CREATE OR REPLACE TABLE YOURLIB.LOGAPI
(
	API_STAMP TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	API_USER VARCHAR(128) DEFAULT NULL,
	API_METHOD CHAR(20) DEFAULT NULL,
	API_CONTENT_TYPE FOR COLUMN API_CONTYP VARCHAR(128) DEFAULT NULL,
	API_AUTHORIZATION_TYPE FOR COLUMN API_AUTTYP VARCHAR(128) DEFAULT NULL,
	API_REMOTE_IP FOR COLUMN API_IP VARCHAR(15) DEFAULT NULL,
	API_REMOTE_HOST FOR COLUMN API_HOST VARCHAR(128) DEFAULT NULL,
	API_USER_AGENT FOR COLUMN API_USRAGT VARCHAR(128) DEFAULT NULL,
	API_QUERY_STRING FOR COLUMN API_QRY VARCHAR(128) DEFAULT NULL,
	API_PATH_INFO FOR COLUMN API_PATH VARCHAR(128) DEFAULT NULL
) CDFMT LOGAPI;

LABEL ON TABLE YOURLIB.LOGAPI IS 'Log for api access';

LABEL ON COLUMN YOURLIB.LOGAPI
(
	API_STAMP IS 'Timestamp',
	API_USER IS 'User',
	API_METHOD IS 'Method',
	API_CONTENT_TYPE IS 'Content             Type',
	API_AUTHORIZATION_TYPE IS 'Authentication      Type',
	API_REMOTE_IP IS 'Remote              IP                  Address',
	API_REMOTE_HOST IS 'Remote              Host',
	API_USER_AGENT IS 'User                Agent',
	API_QUERY_STRING IS 'Query               String',
	API_PATH_INFO IS 'Path                Information'
);

LABEL ON COLUMN YOURLIB.LOGAPI
(
	API_STAMP TEXT IS 'Timestamp',
	API_USER TEXT IS 'User',
	API_METHOD TEXT IS 'Method',
	API_CONTENT_TYPE TEXT IS 'Content type',
	API_AUTHORIZATION_TYPE TEXT IS 'Authentication type',
	API_REMOTE_IP TEXT IS 'Remote ip address',
	API_REMOTE_HOST TEXT IS 'Remote host',
	API_USER_AGENT TEXT IS 'User agent',
	API_QUERY_STRING TEXT IS 'Query string',
	API_PATH_INFO TEXT IS 'Path information'
);
