@page library_build Build

@brief 🟨 Minimal build system where builds are described in C++

Build uses C++ to imperatively describe a sequence of build operations.  

[TOC]

# Features

- Describe builds in a `.cpp` file
- Integrates with `SC-Package` from [Tools](@ref page_tools) to download dependencies
- Generate XCode 14+ Projects
    - Generate app bundle icon and storyboard
    - Link locally defined `LLDB` debug visualizer
- Generate Visual Studio 2022 Projects
    - Link locally defined `.natvis` debug visualizer
- Generate Makefile for Linux and Apple (macOS / iOS) targets
    - Generates `compile_commands.json` for VSCode

# Status
🟨 MVP  
Build is currently used to generate test and example projects of this repository.  
It has a limited set of features but it can be used to describe simple projects that have no dependencies between them.  
Features will be added as needed.

# Description

Build C++ files (named by convention `SC-build.cpp`) are compiled the fly and they generate project files for existing build systems.  
In the future the plan is to allow also the system to run standalone directly invoking compilers to produce libraries and executables.
Projects are generated by invoking `./SC.sh build` or `SC.bat build`.

@note Check the [Tools](@ref page_tools) page for more details on `SC.sh build`.

This is for example the `Tools/SC-build.cpp` file for the `SCTest` test suite and the [SCExample](@ref page_examples):
\include Tools/SC-build.cpp

The abstraction is described by the following (top-down) hierarchy:

| Class                         | Description                           |
|:------------------------------|---------------------------------------|
| SC::Build::Definition         | @copybrief SC::Build::Definition      |
| SC::Build::Workspace          | @copybrief SC::Build::Workspace       |
| SC::Build::Project            | @copybrief SC::Build::Project         |
| SC::Build::Configuration      | @copybrief SC::Build::Configuration   |

Some additional types allow describing detailed properties of the build:

| Class                         | Description                           |
|:------------------------------|---------------------------------------|
| SC::Build::Platform           | @copybrief SC::Build::Platform        |
| SC::Build::Architecture       | @copybrief SC::Build::Architecture    |
| SC::Build::Generator          | @copybrief SC::Build::Generator       |
| SC::Build::Optimization       | @copybrief SC::Build::Optimization    |
| SC::Build::Compile            | @copybrief SC::Build::Compile         |
| SC::Build::CompileFlags       | @copybrief SC::Build::CompileFlags    |
| SC::Build::Link               | @copybrief SC::Build::Link            |
| SC::Build::LinkFlags          | @copybrief SC::Build::LinkFlags       |

# Videos

This is the list of videos that have been recorded showing some of the internal thoughts that have been going into this library:

- [Ep.02 - Creating a Makefile](https://www.youtube.com/watch?v=2ccW8TBAWWE)
- [Ep.03 - Add Makefile backend to SC::Build](https://www.youtube.com/watch?v=wYmT3xAzMxU)
- [Ep.04 - Start Linux Porting](https://www.youtube.com/watch?v=DUZeu6VDGL8)
- [Ep.05 - Build Everything on Linux](https://www.youtube.com/watch?v=gu3x3Y1zZLI)

# Blog

Some relevant blog posts are:

- [March 2024 Update](https://pagghiu.github.io/site/blog/2024-03-27-SaneCppLibrariesUpdate.html)
- [May 2024 Update](https://pagghiu.github.io/site/blog/2024-05-31-SaneCppLibrariesUpdate.html)
- [June 2024 Update](https://pagghiu.github.io/site/blog/2024-06-30-SaneCppLibrariesUpdate.html)
- [July 2024 Update](https://pagghiu.github.io/site/blog/2024-07-31-SaneCppLibrariesUpdate.html)

# Architecture

- User adds a `SC-build.cpp` files to his library
- `SC-build.cpp` describes the SC::Build::Definition using imperative C++ code
    - Define at least one SC::Build::Workspace
    - Define at least one SC::Build::Project 
    - Define at least one SC::Build::Configuration
- `SC-build.cpp` is compiled to an executable with a single `clang` or `cl.exe` invocation
- The unity build file `SC.cpp` is linked together in the same invocation
    - Provides all needed Platform abstraction features to enumerate files and directories, launch processes etc.
- The generated executable is run as specified in SC::Build::Parameters
- SC::Build::Parameters specifies a combination of:
    - SC::Build::Platform @copybrief SC::Build::Platform
    - SC::Build::Configuration @copybrief SC::Build::Configuration
    - SC::Build::Generator @copybrief SC::Build::Generator
- `SC-build.cpp` calls SC::Build::ConfigurePresets::generateAllPlatforms or manually invokes SC::Build::Definition::generate
- Debugging the build script means just debugging a regular C++ executable

@note Check the [Tools](@ref page_tools) page for more details on `SC.sh build`.

So far the entire build configuration is created in C++ but each invocation with a different set of "build parameters" it's building a data structure that is free of conditionals, as they've been evaluated by the imperative code.
Such "post-configure" build settings could be serialized to JSON (or using binary [Serialization](@ref library_serialization_binary)) or to any other declarative format if needed.  

# Roadmap

🟩 Usable Features:
- Remove any left-over hardcoded setting
- Describe more project types (dynamic libraries, static libraries etc.)
- Describe dependencies between targets
- Allow nested builds (where the root script should compile child scripts found down the path)

🟦 Complete Features:
- `ninja` backend
- Self-hosted backend (no need for `make`, `ninja`, `xcodebuild` or `msbuild`)
- Generate ready to debug projects for the build program itself
- Describe very complex builds (like `LLVM`)

💡 Unplanned Features:
- Compile scripts to WASM so that they can't run arbitrary code
