# Word2Vec: 一种词向量的训练方法

前边我们貌似提出了一个对词向量比较好的期望，但是如何去学习这些词向量，达到这种效果呢？这就是本节讨论的话题，本节将通过Word2Vec为大家讲解词向量的训练方法。

简单地讲，Word2Vec是建模了一个单词预测的任务，通过这个任务来学习词向量。假设有这样一句话**Pineapples are spiked and yellow**，现在假设spiked这个单词被删掉了，现在要预测这个位置原本的单词是什么。

Word2Vec本身就是在建模这个单词预测任务，当这个单词预测任务训练完成之后，那每个单词对应的词向量也就训练好了。下边我们来具体看看吧。

## 1. Word2Vec概述

在正式介绍之前，我们先来科普一下Word2Vec，Word2vec是2013年被Mikolov提出来的词向量训练算法，在[论文](https://arxiv.org/pdf/1301.3781.pdf)中作者提到了两种word2vec的具体实现方式：**连续词袋模型CBOW**和**Skip-gram**，如**图4**所示。

![image-20210430163430455](https://raw.githubusercontent.com/1649759610/images_for_blog/master/image-20210430163430455.png)

<center>图4 CBOW和Skip-gram的对比</center>

**图4**中使用了这句话作为例子：Pineapples are spiked and yellow，在这句话中假设中心词是spiked，这个单词的**上下文**是其他单词:Pineapples are and yellow。

 **连续词袋模型CBOW**的建模方式是使用上下文单词来预测spiked这个单词，当然图片上展示的是spikey，相当于是预测错了。**Skip-gram**正好反过来，它是通过中心词来预测上下文。

一般来说，**CBOW**比**Skip-garm**训练快且更加稳定一些，然而，**Skip-garm**不会刻意地回避生僻词（即出现频率比较低的词），比**CBOW**能够更好地处理生僻词。在本节呢，我们将以**Skip-garm**的方式讨论词向量的训练过程。

## 2. Skip-gram训练词向量原理

前边我们说到，**Skip-gram**是通过中心词来预测上下文。我们还是以**Pineapples are spiked and yellow**为例进行讲解，如**图5**所示，中心词是spiked，上下文是Pineapples are and yellow，在**Skip-gram**中，上下文是我们要预测的词，因此这些词也叫目标词。

![image-20210430172831782](https://raw.githubusercontent.com/1649759610/images_for_blog/master/image-20210430172831782.png)

<center>图5 Skip-gram原理图</center>

我们来看看**Skip-garm**具体是怎么工作的， 首先skip-gram是使用中心词来预测上下文，即利用spiked这个单词来预测 pineapples are and yellow这4个单词，但是训练过程中，这个预测结果很有可能并不是这4个单词，但是没关系，我们会使用这4个单词和预测的单词进行计算损失，通过损失的方式将正确的这4个单词的信息，使用梯度信息反向传播中心词spiked，这样在spiked单词在下次预测的时候，就会更准确一点。

**总结一下**，在训练过程中通过梯度的方式，将上下文单词的语义传入到了中心词的表示中，即使用了spiked的上下文来训练了spiked的词向量。但是我们来看spiked，和prickly这两个单词，他们的意思都是有刺，多刺的意思，那么真实的文本语料中，他们的上下文大概率也是差不多的，这样通过差不多的上下文去训练这个中心词，那么自然具有相同语义的词的词向量距离会比较近。

## 3. Skip-gram网络结构

前边我们提到，Word2Vec是建模了一个单词预测的任务，通过这个任务来学习词向量。同时呢，Skip-gram是一种以中心词预测上下文的方式进行的，那我们来看看它的网络结构长什么样子，如**图6**所示。

![image-20210430173826772](https://raw.githubusercontent.com/1649759610/images_for_blog/master/image-20210430173826772.png)

<center>图6 Skip-gram网络结构</center>

**Skip-gram**的网络结构共包含三层：输入层，隐藏层和输出层。它的处理步骤是这样的：

1. 输入层接收shape为$[1,V]$的one-hot向量$x$，其中$V$代表词表中单词的数量，这个one-hot向量就是上边提到的中心词。

2. 隐藏层包含一个shape为$[V,N]$的参数矩阵$W_1$，其中这个$N$代表词向量的维度，$W_1$就是word embedding 矩阵，即我们要学习的词向量。将输入的one-hot向量$x$与$W_1$相乘，便可得到一个shape为$[1, N]$的向量，即该输入单词对应的词向量$e$。
3. 输出层包含一个shape为$[N,V]$的参数矩阵$W_2$，将隐藏层输出的$e$与$W_2$相乘，便可以得到shape为$[1,V]$的向量$r$，内部的数值分别代表每个候选词的打分，使用softmax函数，对这些打分进行归一化，即得到中心词的预测各个单词的概率。

这是一种比较**理想的**实现方式，但是这里有两个问题：

1. 这个输入向量是个one-hot编码的方式，只有一个元素为1，其他全是0，是个极其稀疏的向量，假设它第2个位置为1，它和word embedding相乘，便可获得word embedding矩阵的第二行的数据。那么我们知道这个规律，直接通过访存的方式直接获取就可以了，不需要进行矩阵相乘。

2. 在获取了输入单词对应的词向量$e$后，它是一个$[1,N]$向量。接下来，会使用这个向量和另外一个大的矩阵$W_2$进行相乘，最终会获得一个1*V的向量，然后对这个向量进行softmax，可以看到这个向量具有词表的长度，对这么长的向量进行softmax本身也是一个极其消耗资源的事情。

第1个问题解决起来比较简单，我们主要来看第2个问题，那怎么解决呢？直观的想法是我们不要去生成这么多的类别，所以采用了一个负采样的策略，将海量分类转化成了二分类，来缓解这个问题，下我们来看看它具体是怎么做的。

## 4. 负采样解决大规模分类问题

![image-20210430180824018](https://raw.githubusercontent.com/1649759610/images_for_blog/master/image-20210430180824018.png)

<center>图7 使用负采样策略训练Skip-gram模型</center>

还是以**Pineapples are spiked and yellow**为例进行讲解，如**图7**所示，其中中心词是spiked和上下文词是正样本Pineapples are and yellow，这里这个正样本代表该词是中心词的上下文。

以正样本单词Pineapples为例，**之前的做法**是在使用softmax学习时，需要最大化Pineapples的推理概率，同时最小化其他词表中词的推理概率。之所以计算缓慢，是因为需要对词表中的所有词都计算一遍。**然而**我们还可以使用另一种方法，就是随机从词表中选择几个代表词，通过最小化这几个代表词的概率，去**近似**最小化整体的预测概率。

例如，先指定一个中心词（spiked）和一个目标词正样本（Pineapples），再随机在词表中采样几个目标词负样本（如”dog，house”等）。

有了这些正负样本，我们的skip-gram模型就变成了一个二分类任务。对于目标词正样本，我们需要最大化它的预测概率；对于目标词负样本，我们需要最小化它的预测概率。通过这种方式，我们就可以完成计算加速。这个做法就是**负采样**。

我们再回到**图7**看一看整体的训练流程是怎么样的。图7中相当于有两个词向量矩阵：黄色的和灰色的，他们的shape都是一样的。整体的流程大概是这样的。

1. 获取中心词spiked的正负样本（正负样本是目标词），这里一般会设定个固定的窗口，比如中心词前后3个词算是中心词的上下文(即正样本)；
2. 获取对应词的词向量，其中中心词从黄色的向量矩阵中获取词向量，目标词从灰色的向量矩阵中获取词向量。
3. 将中心词和目标词的词向量进行点积并经过sigmoid函数，我们知道sigmoid是可以用于2分类的函数，通过这种方式来预测中心词和目标词是否具有上下文关系。
4. 将预测的结果和标签使用交叉熵计算损失值，并计算梯度进行反向迭代，优化参数。

经过这个训练的方式，我们就可以训练出我们想要的词向量，但**图7**中包含两个词向量矩阵（黄色的和灰色的），一般是将中心词对应的词向量矩阵(黄色的)作为正式训练出的词向量。

恭喜，看到这里我想你已经明白Skip-gram大致是如何训练词向量了。
