# One-Hot编码: 一种简单的单词编码方式

在NLP领域，如何将单词数值化呢，One-Hot编码就是一种很简单的方式。假设我们现在有单词数量为$N$的词表，那可以生成一个长度为$N$的向量来表示一个单词，在这个向量中该单词对应的位置数值为1，其余单词对应的位置数值全部为0。举例如下：

**词典**: [queen, king, man, woman, boy, girl ]

![image-20210430135930316](https://raw.githubusercontent.com/1649759610/images_for_blog/master/image-20210430135930316.png)

<center>图1 one-hot 编码图 </center>

假设当前词典中有以上6个单词，**图1**展示了其中4个单词的one-hot编码表示。这个表示是不是挺简单的，但是这种表示方式也有一些不太合适的地方。

**首先**，在实际应用中词表中单词的数量往往比较多，高达几十万，甚至百万。这种情况下使用one-hot编码的方式表示一个单词，向量维度过长，同时向量会极其稀疏。

**其次**，从**图1**我们也可以看出向量之间是正交的，向量之间的点积为0，因此无法直接通过向量计算的方式来得出单词之间的关系。直观上我们希望语义相近的单词之间的距离比较近。比如，我们知道，“香蕉”和“橘子”更加相似，而“香蕉”和“句子”就没有那么相似，同时，“香蕉”和“食物”，“水果”的相似程度，可能介于“橘子”和“句子之间”。
