# 推荐系统评估指标

## 场景转化指标

场景转化指标是将用户从一个场景转化到我们希望的场景的效果。这个过程主要是对用户的行为进行分析，这类指标关注推荐系统的漏斗效果，主要有：

### pv点击率

PV(访问量)：PageView,即页面浏览量或点击量，用户每次刷新即被计算一次。

$$pv点击率=\frac{pv点击}{pv}$$

pv点击率是比较经典的指标，计算用户每次进入页面的情况。他能粗略衡量转化的效果，但是它缺点也比较明显：少数用户贡献大量点击会影响这个指标的作用效果。

### uv点击率

UV(独立访客)：Unique Visitor,访问您网站的一台电脑客户端为一个访客。00:00-24:00内相同的客户端只会被计算一次。

$$uv点击率=\frac{点击uv}{整个产品的uv}$$

分母是整个产品的uv,而不是有点击行为的uv。uv点击率相对于pv点击率的优势在于，它不受用户行为路径影响（不受重复浏览某个产品的影响），能记录用户在一个完整session的点击效果。据了解好多互联网公司的分析指标也将pv点击率给为uv点击率了

### 曝光点击率

$$ 曝光点击率=\frac{点击量}{曝光次数}$$

曝光点击率适合支持上拉、下拉翻页的产品。相比pv点击率，曝光点击率随用户刷屏次数增大而变大，能更真实记录每一屏的转化情况。

### uv转化率

转化率：指在一个统计周期内，完成转化行为的次数占推广信息总点击次数的比率。

$$uv转化率=\frac{点击uv}{进入uv}$$

与uv转化率相对的是页面流失率。uv转化率衡量对用户的转化情况，通过我们的产品设计能把多大比例的用户从一个场景转化到我们希望的另一个场景里面去。uv转化率相对于前面两个指标，更靠得住，不容易受到挑战。

uv转化率尤其衡量入口型产品，比如视频app的首页，如果用uv点击率去衡量就不太科学，因为一般用户在首页点击某个视频后，会进入下一层页面深度消费，很少会返回首页继续消费，这个用户已经被转化，但不再贡献点击，所以uv转化率更加合理。

如果某页面的转化率较低，则表示大部分人对该页面不感兴趣，遵循“不行就分”的简单原则，这样的页面去掉可能对产品更好。

### 人均点击次数

$$人均点击次数=\frac{点击量}{点击uv}$$

人均点击次数与uv转化率相辅相成。uv转化率表示页面的消费宽度（吸引用户的比例），而人均点击次数表示页面的消费深度（每个用户的消费的次数）。

## 消费满意度

### 留存率

$$留存率=\frac{x日后仍活跃的用户数}{x日前的用户数}$$

留存率很重要，每家公司都很重视，但它很艰难作为算法的优化指标，因为时间周期长，变量会很多。比如计算视频app首页的留存率就十分艰难，因为当中可能会上线大剧；和热门综艺。虽然难以衡量，但留存率是产品技术团队的重要指标：市场部负责拉新用户，产品技术团队负责服务用户，把客户留下来。

### 停留时间长

内容消费型产品，点击率很难反应推荐的真正效果，把用户骗进了希望的场景消费，但是发现真相的用户转身就走，这反而说明这个推荐是失败的。所以需要引入停留时长来量化用户消费效果。音频类的就对应播放时长。

### 播放完成率

$$播放完成率=\frac{播放时长}{视频时长}$$

由于停留时长受视频时长的锚定效应影响，稍长一点的视频，即使用户不感兴趣，但是平均来说也会比短视频要停留更长一些。因此，播放完成指标就能一定程度上去弥补这个问题，但是短视频天然的完成率要比长视频高，也是需要在看指标时注意。



## 离线评估验证方法

### Holdout检验
Holdout检验是基础的离线评估方法，它将原始的样本集合随机划分为训练集和验证集两部分，比如70%训练集，30%测试集（但现在很多机器学习框架、深度学习框架中都增加了验证集，即将整个数据集分成三份，70%训练集，10%验证集，20%测试集）。

Holdout检验的缺点也很明显，即在验证集上计算出来的评估指标与训练集和测试机的划分有直接关系，如果仅进行少量Holdout检验，则得到的结论存在很大的随机性（在划分数据集的时候尽量保证其随机性）。

### 交叉检验

#### k-fold交叉验证
先将全部样本划分成 k个大小相等的样本子集，依次遍历这k个子集，每次都把当前子集作为验证集，其余所有子集作为训练集，进行模型的训练和评估，最后将所有次的评估指标的平均值作为最终的评估指标，在实际经验中， 经常取值为 10。

#### 留一验证
每次留下1个样本作为验证集，其余所有样本作为测试集，样本总数为n，依次遍历所有n个样本，进行n次验证，再将评估指标求平均得到最终指标。在样本总数较多的情况下，留一验证法的时间开销极大，事实上，留一验证是留p验证的特例，留p验证是指每次留下p个样本作为验证集，而从n个元素中选择 p个元素 有 $C_{n}^p$种可能，因此它的时间开销远远高于留一验证，故很少在实际中使用。

#### 自助法

不管是holdout检验还是交叉检验，都是基于划分训练集和测试集的方法进行模型评估的，当样本规模比较小时，将样本集进行划分，会进一步缩小训练集，有影响模型的训练效果。

自助法（Bootstrap）是基于自助采样法的检验方法：对于总数为n的样本集合，进行n次有放回的随机抽样，得到大小为n的训练集，在n次采样过程中，有的样本会被重复采样，有的样本没有被抽出过，将这些没有被抽出的样本作为验证集进行模型验证，就是自助法的验证过程。

## 离线评估的主要指标

离线评估是针对系统自身的推荐算法模型的评估，通过评估具体指标来选择合适的推荐算法；推荐系统从接收数据到产生推荐结果，再根据结果的硬性从新修改参数，而这个过程是通过机器学习训练得出的模型主要有以下评估指标：

### 准确率

分类准确率是指分类正确的样本占总样本个数的比例：

$$accuracy=\frac{n_{correct}}{n_{total}}$$

$n_{correct}$为被正确分类的样本个数，$n_{total}$为总样本个数，准确率是分类任务中比较直观的评价指标，但其优缺点也明显。

#### 优点

+ 解释性强

#### 缺点

+ 类别分布不均匀时，占比大的类别往往成为影响准确率的主要因素（极端的情况比如正样本 1%，负样本 99%时）

### 精确率和召回率

+ 精确率（Precision）是分类正确的正样本个数占分类器判定为正样本的样本个数的比例

+ 召回率（Recall）是分类正确的正样本个数占真正正样本个数的比例

排序模型中，通常没有一个确定的阈值把预测结果直接判定为正样本还是负样本，而是采用 Top N 排序结果的精确率（Precision@N）和召回率（Recall@N）来衡量排序模型的性能，即认为模型排序的Top N的结果就是模型排定的正样本，然后计算精确率和召回率。

精确率和召回率是矛盾统一的两个指标：为了提高精确率，分类器需要尽量再“更有把握时”才把样本预测为正样本，但往往因为过于保守而漏掉很多“没有把握”的正样本，导致召回率降低。

因此使用F1-score进行调和（也叫F-measure），定义为：

$$F1=\frac{2*Precision*Recall}{Precision+Recall}$$

### 均方根误差

Root Mean Square Error，RMSE 经常被用来衡量回归模型的好坏，使用点击率预估模型构建推荐系统时，推荐系统预测的其实是样本为正样本的概率，RMSE被定义为：

$$RMSE=\sqrt{\frac{1}{n}\sum_{i=1}^n(y_{i}-y_{pred})}$$

$y_{i}$是第i个样本的真实值，$y_{pred}$是第i个样本的预测值，n为样本的个数。

#### 缺点

一般情况下能够很好的反映回归模型预测值与真实值的偏离程度，但在实际应用时，如果存在个别偏离程度非常大的离群点，那么即使离群点的数量非常少，也会让RMSE指标变得很差

为了解决这个问题，引入了鲁棒性更强的平均绝对百分比误差（Mean Absolute Percent Error，MAPE）进行类似的评估，MAPE定义如下：

$$MAPE=\sum_{i=1}^n |\frac{y_{i}-y_{pred}}{y_{i}}|*\frac{100}{n}$$

相比RMSE，MAPE相当于把每个点的误差进行了归一化，降低了个别离群点带来的绝对误差的影响。

### 对数损失函数

LogLoss，在一个二分类问题中，LogLoss定义为：

$$LogLoss=-\frac{1}{N}\sum_{i=1}^N(y_{i}logP_{i}+(1-y_{i})log(1-P_{i}))$$

其中$y_{i}$为输入实例$x_{i}$的真实类别，$p_{i}$为预测输入实例$x_{i}$是正样本的概率，N为样本总数。

LogLoss 是逻辑回归的损失函数，大量深度学习模型的输出层是逻辑回归或softmax，因此采用LogLoss作为评估指标能够非常直观的反映模型损失函数的变化，站在模型的角度来讲，LogLoss非常适于观察模型的收敛情况。


### P-R曲线

P-R曲线的横轴是召回率，纵轴是精确率，对于一个排序模型来说，其P-R曲线上的一个点代表在某一阈值下，模型将大于该阈值的结果判定为正样本，将小于该阈值的结果判定为负样本时，排序结果对应的召回率和精确率

整体P-R曲线是通过从高到低移动正样本阈值生成的，如下所示：

![](https://raw.githubusercontent.com/w5688414/paddleImage/main/recommendation_evaluation_img/precision_recall.png)

P-R曲线下的面积（Area Under Curve， AUC）能够量化P-R曲线的优劣，AUC越大，排序模型的性能越好。

### ROC曲线

ROC曲线的全称时 the Receiver Operating Characteristic曲线，中文译为「受试者工作特征曲线」，ROC曲线最早诞生于军事领域，而后在医学领域应用甚广，「受试者工作特征曲线」也来源于该领域。

ROC曲线的横坐标时 False Posotive Rate（FPR， 假阳性率），纵坐标时True Positive Rate（TPR，真阳性率），FPR和TPR的计算方法如下：

$$FPR=\frac{FP}{N}$$
$$TPR=\frac{TP}{P}$$

上式中P是真实的正样本数量，N是真实的负样本数量，TP指的是P个正样本中被分类器预测为正样本的个数，FP指的是N个负样本中被分类器预测为正样本的个数。

ROC曲线的绘制和P-R曲线一样，通过不断移动模型正样本阈值生成的，ROC曲线下的面积就是AUC

### 平均精度均值
平均精度均值（Mean Average Precision，mAP）是另一个在推荐系统、信息检索领域常用的评估指标，该指标其实是对平均精度（Average Precision，AP）的再次平均。

假设推荐系统对某一用户测试集的排序结果如下所示：

|推荐序列|N=1|N=2|N=3|N=4|N=5|N=6|
|----|----|----|---|---|---|---|
|真实标签|1|0|0|1|1|1|

其中，1代表正样本，0代表负样本

那么对于上述的序列，precision@N分别是多少呢？

|推荐序列|N=1|N=2|N=3|N=4|N=5|N=6|
|----|----|----|---|---|---|---|
|真实标签|1|0|0|1|1|1|
|precision@N|1/1|1/2|1/3|2/4|3/5|4/6|

AP的计算只取正样本处的precision进行平均，即 AP= (1/1 + 2/4 + 3/5 + 4/6) =0.6917

那么mAP是什么呢？

如果推荐系统对测试集中的每个用户都进行样本排序，那么每个用户都会计算出一个AP值，再对所有用户的AP值进行平均，就得到了mAP，也就是mAP是对精确度平均的平均。

需要注意的是，mAP的计算和P-R曲线、ROC曲线的计算方法完全不同，因为mAP需要对每个每个用户的样本进行分用户排序，而P-R曲线和ROC曲线均是对全量测试样本进行排序。

### NDCG

#### CG

CG，cumulative，是DCG的前身，只考虑到了相关性的关联程度，没有考虑到位置的因素，它是一个搜索结果相关性分数的综合，指定位置p上的CG为：

$$CG_{p}=\sum_{i=1}^p rel_{i}$$

$rel_{i}$代表i这个位置的相关度。

比如搜索“推荐系统”图书时，最理想的结果时R1、R2、R3，但出现的结果是 R2、R3、R1，CG值是没有变化的。

#### DCG
DCG， Discounted的CG，就是在每一个CG的结果上除以一个折损值，目的是为了让排名越考前的结果越能影响最后的结果，假设排序越靠后，价值越低，那么到第i个位置时，价值为$\frac{1}{log_{2}(i+1)}$，那么第i个结果产生的效益是$rek_{i}*1/log_{2}(i+1)$，所以DCG表达式为：

$$DCG_{p}=\sum_{i=1}^p \frac{rel_{i}}{log_{2}(i+1)}$$
$$=rel_{i}+\sum_{i=2}^{n} \frac{rel_{i}}{log_{2}(i+1)}$$

另外一种比较常用的公式，增加相关度影响比重的DCG计算方式是：

$$DCG_{p}=\sum_{i=1}^p \frac{2^{rel_{i}}-1}{log_{2}(i+1)}$$

百科中写到后一种更多用于工业。当然相关性值为二进制时，即$rel_{i}$ 在0,1，二者结果是一样的。当然CG相关性不止是两个，可以是实数的形式。

#### NDCG

NDCG，归一化的DCG，由于搜索结果随着检索词的不同，返回的数量是不一样的，而DCG是一个累加的值，没法针对两个不同的检索结果进行归一化出力，这里是除以IDCG。

$$NDCG_{p}=\frac{DCG}{IDCG_{p}}$$

IDCG为理想情况下的最大的DCG的值，为：
$$IDCG_{p}=\sum_{i=1}^{REL} \frac{2^{rel_{i}}-1}{log_{2}(i+1)}$$
其中$|REL|$表示，结果按照相关性从大到小的顺序排序，取前个结果组成的集合，也就是按照最优的方式对结果进行排序。

### 覆盖率

$$ 覆盖率=\frac{推荐的物品数}{总物品数} $$

覆盖率最简单的定义是，推荐系统能够推荐出来的物品占总物品的比例，将更多的物品推荐（曝光）出去，只有曝光出去才有被用户“消费”的可能；覆盖率越高表明模型能够针对更多的item产生推荐，从而促进长尾效应挖掘。

###  挖掘长尾的能力
通过日志分析，我们可以知道哪些推荐的物品是流行的，哪些是长尾。拿视频推荐来举例，我们可以根据二八定律，将电影播放量降序排列，播放量占总播放量80%的前面的电影，算作热门电影，后面的当做长尾。

在度量推荐系统长尾能力时，我们可以从如下三个维度来度量：

1. 所有长尾推荐物品中每天有多少比例被分发出去了
2. 有多少比例的用户，推荐过了长尾物品
3. 长尾内容的转化情况和产生的商业价值

### 多样性

用户的兴趣会改变的，而且有些产品的用户不止一个，同一个用户的兴趣也会受到时间段、心情、节日等多种因素的影响，在推荐列表中插入不同类别的产品来提高多样性。

### 时效性

不同的产品有不同的时效性，比如电商类需要的时效性不是很高，但是新闻资讯、短视频这类产品，就需要很高的时效性、所以针对不同产品甚至产品下不同的类别，设置不同的时效性，这也是提高推荐质量的途径之一。

所以时效性一般分为四个级别：日级、小时级、分钟级、秒级。我们可以根据不同的产品形态，不同的业务场景等因素来进行评估，选出产品所属的时效性。


## Replay

### 动态离线评估方法

**传统离线评估方法和动态离线方法对比**

传统离线方法：模型不会随着评估的进行而更新，假设用一个月得测试数据评估一个推荐系统，如果评估过程是静态的，这就意味着当模型对月末得数据进行预测时，模型已经停止更新近30天了，这不仅不符合工程实践，而且会导致模型效果评估得失真
动态离线评估方法：先根据样本产生时间对测试样本由早到晚进行排序，再用模型根据样本时间依次进行预测，在模型更新的时间点上，模型需要增量学习更新时间点前的测试样本，更新后继续进行后续的评估。

毫无疑问，动态评估的过程更接近真实的线上环境，评测结果也更接近客观情况，如果模型更新的频率持续增加，快到接收到样本就更新，整个动态评估的过程也变成逐一样本回放的精准线上仿真过程，这就是经典的仿真式离线评估方法-Replay。

Replay方法不仅适用于几乎所有推荐模型的离线评估，而且是强化学习类模型唯一的离线评估方法。

Replay的实际实现中有一点需要特别注意的是：样本中不能包含任何「未来信息」，要避免数据穿越的现象发生

### A/B测试与线上评估

上文介绍的离线评估指标无法还原真实的线上环境，几乎所有的互联网公司，线上A/B 测试都是验证新模块、新功能、新产品是否有效的主要方法。

#### 什么是A/B测试

又称「分流测试」或「分桶测试」，是一个随机实验，通常被分为实验组和对照组。利用控制变量法，保持单一变量进行A、B两组的数据对比，并得到结论。

线上A/B测试无法被替代的原因主要有以下三点：

离线评估无法完全消除数据有偏（data bias）现象的影响，因此得到的离线评估结果无法完全替代线上评估结果
离线评估无法完全还原线上的工程环境，比如请求延迟、数据丢失、标签数据缺失等，离线评估比较理想化，结果存在失真现象
线上系统的某些商业指标再离线评估中无法计算

#### A/B测试的分桶原则

需要注意样本等独立性和无偏性，同一用户在测试的全程中只能被分到同一个桶中。

在实际的场景中，同一App或者网站需要进行多组不同类型的A/B测试，统同一业务的不同模块也会进行A/B测试（比如推荐系统中的召回层、排序层、展示层等），这种情况下不同层之间势必会产生干扰，同层之间也可能因为分流策略不当导致指标失真。

谷歌在其实验平台论文：Overlapping Experimen Infrastructure: More, Bette, Faster Experimentation 详细介绍了实验流量分层和分流的机制。A/B测试分流和分层的机制可以概括为：

层与层之间的流量正交，即层与层之间的独立实验的流量是正交的，即实验中每组的流量穿越该层后，都会被再次随机打散，且均匀的分布再下层的每个实验中
同层之间的流量互斥，即
同层之间进行多组A/B测试，不同测试之间的流量是不重叠的
一组A/B测试中实验组和对照组的流量是不重叠的，是互斥的

#### 线上A/B测试的评估指标

不同业务背景关注的指标可能不一样，同一类型不同模块的业务下关注的指标也不一样，电商中经常关注的是：点击率、转化率、下单率、GMV、复购率等，娱乐咨询类平台关注的是：点击率、阅读时长、留存率等。

在进行A/B测试时，进行指标的对比和模型策略等的验证是比较有说服力的。

### Interleaving线上评估方法

2013年微软提出了Interleaving线上评估方法，被当作时线上A/B测试的预选阶段进行候选算法的快速筛选，从大量初始想法中筛选出少量优秀的推荐算法，再对缩小的算法集合进行传统的A/B测试，以侧拉他们对用户行为的长期影响。



使用 Inter leaving 进行快速线上测试。用灯泡代表候选算法。其中，最优的获胜算法用红色表示。Interleaving 能够快速地将最初的候选算法集合进行缩减，相比传统的 AB Test 更快地确定最优算法。

#### A/B测试存在的统计学问题

A/B测试虽然是样本进行随机分配，但是难免会存在分布不均匀得情况，我们都知道二八原则，当对平台用户进行分流时，没有办法保证活跃用户也能被均分，因此一种可行的方法就是不对测试人群进行分组，而是让所有测试者都可以自由的选择要测试的物品，在实验结束时，统计每个人选择不同物品的比例，进行相关的数据统计（有点像做选择题哈哈），这种方案的优点在于：

消除了A/B测试者自身属性分布不均的问题
通过给予每个人相同的权重，降低了活跃用户对结果的影响

![Interleaving](https://raw.githubusercontent.com/w5688414/paddleImage/main/recommendation_evaluation_img/Interleaving.png)

这种不区分A/B组，而是把不同的被测对象同时提供给受试者，最后根据守试者的选择得出评估结果的方法称为——Interleaving方法。

Interleaving 方法的优缺点

优点：

+ 所需样本少
+ 测试速度快
+ 结果与A/B测试无明显差异

缺点：

+ 工程实现的框架较A/B测试复杂，实验逻辑和业务逻辑纠缠在一起，业务逻辑会被干扰
+ Interleaving方法只是对“用户对算法推荐结果偏好程度”的相对测量，不能得出一个算法真实的表现，如果需要知道某个算法的具体指标提升，不适合使用Interleaving


## 用户数据指标

所谓的用户指标就是从用户的角度去衡量所推荐产品的效果，是否满足用户的需求，能不能给用户带来惊喜，或者引发用户搜索更多产品等，可以从以下几个标准来衡量：

### 推荐命中率/准确度

推荐命中率/准确度就是所推荐的产品用户喜不喜欢的最直观的指标，比如推荐的商品，用户有没有加入购物车或者下单，推荐的音乐用户有没有收藏或收听，推荐的课程用户有没有学习等，都可以用来衡量用推荐的命中率。

### 用户的喜欢程度

用户的行为反应出用户对于推荐产品的喜爱程度，比如：推荐的歌曲用户听了之后有没有收藏，收藏之后有没有分享出去；推荐的商品有没有浏览，浏览后有没有加入购物车，加入购物车后有没有购买等；不同的行为体现了不同的喜欢程度，这一指标很好的衡量推荐产品的效果。

### 产品对于用户的新颖性

推荐用户没有接触过的产品，不一定是用户喜欢的，但是可以提升用户的探索欲望，从而获取更完整的用户兴趣。

### 多样性

用户的兴趣是多样的，在做推荐的时候需要给用户提供多样的物品，可以挖掘新用户的兴趣点，拓展用户的兴趣范围，提升用户的体验





