# 预训练模型简要介绍

从字面上看，预训练模型（pre-training model）是先通过一批语料进行训练模型，然后在这个初步训练好的模型基础上，再继续训练或者另作他用。这样的理解基本上是对的，预训练模型的训练和使用分别对应两个阶段：预训练阶段（pre-training）和 微调（fine-tuning）阶段。

预训练阶段一般会在超大规模的语料上，采用无监督（unsupervised）或者弱监督（weak-supervised）的方式训练模型，期望模型能够获得语言相关的知识，比如句法，语法知识等等。经过超大规模语料的"洗礼"，预训练模型往往会是一个Super模型，一方面体现在它具备足够多的语言知识，一方面是因为它的参数规模很大。

微调阶段是利用预训练好的模型，去定制化地训练某些任务，使得预训练模型"更懂"这个任务。例如，利用预训练好的模型继续训练文本分类任务，将会获得比较好的一个分类结果，直观地想，预训练模型已经懂得了语言的知识，在这些知识基础上去学习文本分类任务将会事半功倍。利用预训练模型去微调的一些任务(例如前述文本分类)被称为下游任务（down-stream）。

以BERT为例，BERT是在海量数据中进行训练的，预训练阶段包含两个任务：MLM（Masked Language Model）和NSP (Next Sentence Prediction)。前者类似"完形填空"，在一句中扣出一个单词，然后利用这句话的其他单词去预测被扣出的这个单词；后者是给定两句话，判断这两句话在原文中是否是相邻的关系。

BERT预训练完成之后，后边可以接入多种类型的下游任务，例如文本分类，序列标注，阅读理解等等，通过在这些任务上进行微调，可以获得比较好的实验结果。
