# AMSGrad

AMSGrad在ICLR 2018年被提出来，并获得了最佳论文。AMSGrad是一个随机梯度下降优化方法，它试图解决基于Adam的优化器的收敛问题。AMSGrad使用最大化过去平方梯度$v_{t}$来更新参数，而不是使用指数平均，这样就降低了指数衰减平均，造成重要历史信息快速丢失的影响。

$$m_{t}=\beta_{1}m_{t-1}+(1-\beta_{1})g_{t}$$
$$v_{t}=\beta_{2}v_{t-1}+(1-\beta_{2})g_{t}^2$$

上面的两个公式跟Adam是一样的，求的是一阶矩和二阶矩，$g_{t}$
是当前参数的梯度，$\beta_{1}$为一阶矩估计的指数衰减率，$\beta_{2}$是二阶矩估计的指数衰减率，前者控制一阶矩估计，后者控制二阶矩估计。

$$\hat v_{t}=max(\hat v_{t-1},v_{t})$$

上式求过去最大的平方梯度$\hat v_{t}$，参数的更新公式如下：

$$\theta_{t+1}=\theta_{t}-\frac{\eta}{\sqrt{\hat v_{t}}+\epsilon}m_{t}$$

从上面的公式可以看出，参数更新公式与Adam没有啥区别，但是求$\hat v_{t}$有区别。AMSGRAD不增加步长，避免了ADAM和RMSPROP算法的缺陷。

