# Adamax

AdaMax是Adam的一种变体，此方法对学习率的上限提供了一个更简单的范围。公式上的变化如下：


$$v_{t}=\beta_{1} \cdot m_{t-1}+(1-\beta_{1}) \cdot g_{t}$$

我们可以将此推广到$l_{p}$范数。

$$v_{t}=\beta_{2}^{p}v_{t-1}+(1-\beta_{2}^{p})|g_{t}|^p$$

当p非常大的时候通常会导致数值上的不稳定，这也是实际中通常使用$l_{1}$和$l_{2}$的原因。然而，$l_{\infty}$通常也会比较稳定。因此，作者提出了 AdaMax，显示了结合了$v_{t}$和$l_{\infty}$也能够收敛到下面的更稳定的值。为了避免与 Adam 混淆，我们使用$u_{t}$来表示无限范数约束的$v_{t}$

$$u_{t}=\beta_{2}^{\infty}v_{t-1}+(1-\beta_{2}^{\infty})|g_{t}|^{\infty}
= max(\beta_{2} \cdot v_{t-1},|g_{t}|) $$

现在可以将此加进 Adam 的更新规则里，用$u_{t}$代替$\sqrt{\hat v_{t}}+\epsilon$，得到 AdaMax 的更新规则：

$$\theta_{t+1}=\theta_{t}-\frac{\eta}{u_t} \hat m_{t}$$

其中$u_{t}$依赖于 max 操作，这不像Adam中的$m_{t}$和$v_{t}$那样容易趋于0，这也是我们不需要为$u_{t}$计算偏差纠正的原因。建议的默认值是$\eta=0.002$，$\beta_{1}=0.9$和$\beta_{2}=0.999$


