# Adam

Adam最开始是由 OpenAI 的 Diederik Kingma 和多伦多大学的 Jimmy Ba提出的。Adam使用动量和自适应学习率来加快收敛速度。SGD-M在SGD基础上增加了一阶动量，AdaGrad和AdaDelta在SGD基础上增加了二阶动量（二阶矩估计）。把一阶动量和二阶动量都用起来，就是Adam了——Adaptive + Momentum。

SGD的一阶矩的估计，即mean均值：

$$m_{t}=\beta_{1} \cdot m_{t-1}+(1-\beta_{1}) \cdot g_{t}$$

加上AdaDelta的二阶动量，二阶距的估计，即variance，和方差类似，都是二阶距的一种：

$$v_{t}=\beta_{2} \cdot v_{t-1}+(1-\beta_{2})\cdot g_{t}^2$$

对mean和var进行校正，因为mean和var的初始值为0，所以它们会向0偏置，这样处理后会减少这种偏置影响。

$$\hat m_{t}=\frac{m_{t}}{1-\beta_{1}^t}$$
$$\hat v_{t}=\frac{v_{t}}{1-\beta_{2}^t}$$

Adam参数更新公式如下：

$$\theta_{t+1}=\theta_{t}-\eta \cdot \hat m_{t}/(\sqrt{\hat v_{t}}+\epsilon)$$

其中$\eta$是学习率， $g_{t}$是当前参数的梯度，$\beta_{1}$为一阶矩估计的指数衰减率（如 0.9），$\beta_{2}$二阶矩估计的指数衰减率（如 0.999），前者控制一阶矩估计，后者控制二阶矩估计。该超参数在稀疏梯度（如在 NLP 或计算机视觉任务中）中应该设置为接近 1 的数，$\beta_{1}^t$和$\beta_{2}^t$是$\beta_{1}$和$\beta_{2}$的t次方

**优点**

+ 通过一阶动量和二阶动量，有效控制学习率步长和梯度方向，防止梯度的振荡和在鞍点的静止。
+ 实现简单，计算高效，对内存需求少
+ 参数的更新不受梯度的伸缩变换影响
+ 超参数具有很好的解释性，且通常无需调整或仅需很少的微调
+ 更新的步长能够被限制在大致的范围内（初始学习率）
+ 能自然地实现步长退火过程（自动调整学习率）
+ 很适合应用于大规模的数据及参数的场景
+ 适用于不稳定目标函数
+ 适用于梯度稀疏或梯度存在很大噪声的问题

Adam在很多情况下算作默认工作性能比较优秀的优化器。


**缺点**

+ 可能不收敛：二阶动量是固定时间窗口内的累积，随着时间窗口的变化，遇到的数据可能发生巨变，使得$V_{t}$可能会时大时小，不是单调变化。这就可能在训练后期引起学习率的震荡，导致模型无法收敛。

	修正的方法。由于Adam中的学习率主要是由二阶动量控制的，为了保证算法的收敛，可以对二阶动量的变化进行控制，避免上下波动。
	
	$$v_{t}=max(\beta_{2} \cdot v_{t-1}+ (1-\beta_{2})g_{t}^2,v_{t-1})$$
 
+ 可能错过全局最优解：自适应学习率算法可能会对前期出现的特征过拟合，后期才出现的特征很难纠正前期的拟合效果。后期Adam的学习率太低，影响了有效的收敛。
