# AdaBound

AdaBound算法训练速度比肩Adam，性能媲美SGD。SGD现在后期调优时还是经常使用到，但SGD的问题是前期收敛速度慢。SGD前期收敛慢的原因： SGD在更新参数时对各个维度上梯度的放缩是一致的，并且在训练数据分布极不均很时训练效果很差。而因为收敛慢的问题应运而生的自适应优化算法Adam、AdaGrad、RMSprop 等，但这些自适应的优化算法虽然可以在训练早期展现出快速的收敛速度，但其在测试集上的表现却会很快陷入停滞，并最终被 SGD 超过。

具体做法是对学习率进行动态裁剪，在这一设置下，在训练早期由于上下界对学习率的影响很小，算法更加接近于 Adam；而随着时间增长裁减区间越来越收紧，模型的学习率逐渐趋于稳定，在末期更加贴近于 SGD。

$$m_{t}=\beta_{1}m_{t-1}+(1-\beta_{1})g_{t}$$

$$v_{t}=\beta_{2}v_{t-1}+(1-\beta_{2})g_{t}^2$$

上面的两个公式跟Adam是一样的，求的是一阶矩和二阶矩，$g_{t}$
是当前参数的梯度，$\beta_{1}$为一阶矩估计的指数衰减率，$\beta_{2}$是二阶矩估计的指数衰减率，前者控制一阶矩估计，后者控制二阶矩估计。

$$V_{t}=diag(v_{t})$$
$$\hat \eta_{t}=Clip(\alpha/\sqrt(V_{t}),\eta_{l}(t),\eta_{u}(t))$$
$$\eta_{t}=\hat \eta_{t}/\sqrt{t}$$

上述3个公式是把学习率限定在$[\eta_{l},\eta_{u}]$之间，这个公式是对SGD+momentum和Adam的一般化，其中$\eta_{l}$=$\eta_{u}=\alpha^*$ 时，就变成了SGD+momentum的公式了，因为学习率固定了参数只与一阶动量有关；如果$\eta_{l}=0$和$\eta_{u}=\infty $整个公式就变成了Adam，因为Adam既与一阶矩有关也与二阶矩有关。其中$\eta_{l}^t$是一个非递减函数，从0逐渐的收敛到$\alpha$，而$\eta_{u}^t$ 是一个非递增函数，从$\infty$逐渐收敛到$\alpha$。

$$\theta_{t+1}=\theta_{t}-\eta_{t} \odot m_{t}$$

在这种设置下，AdaBound在最开始表现的像Adam，因为最开始学习率的边界对更新公式影响很小，渐渐的表现的像SGD+momentum，因为学习率逐渐被限制住了。


