# 经典注意力机制

## 1. 用机器翻译任务带你看Attention机制的计算

单独地去讲**Attention机制**会有些抽象，也有些枯燥，所以我们不妨以**机器翻译**任务为例，通过讲解**Attention机制**在机器翻译任务中的应用方式，来了解**Attention机制**的使用。

什么是机器翻译任务？以**中译英**为例，机器翻译是将一串中文语句翻译为对应的英文语句，如**图1**所示。

![image (1)](https://raw.githubusercontent.com/1649759610/images_for_blog/master/image%20(1).png)

<center>图1 机器翻译示例图</center>

**图1**展示了一种经典的机器翻译结构**Seq-to-Seq**，并且向其中添加了**Attention计算**。**Seq-to-Seq**结构包含两个部分：Encoder和Decoder。其中Encoder用于将中文语句进行编码，这些编码后续将提供给Decoder进行使用；Decoder将根据Encoder的数据进行解码。我们还是以图1为例详细解释一下Decoder的解码过程。

更明确的讲，**图1**展示的是生成单词"machine"时的计算方式。首先将前一个时刻的输出状态 $q_2$ 和Encoder的输出 $h=[h_1,h_2,h_3,h_4]$ 进行Attention计算，得到一个当前时刻的 $context$ ，用公式可以这样组织：

$$
\begin{align} 
[a_1,a_2,a_3,a_4] &= softmax([s(q_2, h_1), s(q_2,h_2),s(q_2, h_3),s(q_2, h_4)]) \\ context&=\sum_{i=1}^4 a_i \cdot h_i 
\end{align}
$$

我们来解释一下，这里的 $s(q_i,h_j)$ 表示注意力打分函数，它是个标量，其大小描述了当前时刻在这些Encoder的结果上的关注程度，这个函数在后边会展开讨论。然后用softmax对这个结果进行归一化，最后使用加权评价获得当前时刻的上下文向量 $context$。这个$context$可以解释为：截止到当前已经有了"I love"，在此基础上下一个时刻应该更加关注**源中文语句**的那些内容。这就是关于**Attention机制**的一个完整计算。

最后，将这个$context$和上个时刻的输出"love"进行融合作为当前时刻RNN单元的输入。

> **图1**中采用了继续融合上一步的输出结果，例如上述描述中融合了"love"，在有些实现中，并没有融入这个上一步的输出，默认 $q_2$ 中已经携带了"love"的信息，这也是合理的。‌

## 2. 注意力机制的正式引入

前边我们通过机器翻译任务介绍了**Attention机制**的整体计算。但是还有点**小尾巴**没有展开，就是那个**注意力打分函数**的计算，现在我们将来讨论这个事情。但在讲这个函数之前，我们先来对上边的**Attention机制**的计算做个总结，**图2**详细地描述了Attention机制的计算原理。

![image (2)](https://raw.githubusercontent.com/1649759610/images_for_blog/master/image%20(2).png)

<center>图2 Attention机制图</center>

假设现在我们要对一组输入 $H=[h_1,h_2,h_3,...,h_n]$使用**Attention机制**计算重要的内容，这里往往需要一个**查询向量** $q$(这个向量往往和你做的任务有关，比如机器翻译中用到的那个 $q_2$ ) ，然后通过一个**打分函数**计算查询向量 $q$ 和每个输入 $h_i$ 之间的相关性，得出一个分数。接下来使用softmax对这些分数进行归一化，归一化后的结果便是**查询向量** $q$在各个输入 $h_i$上的**注意力分布** $a=[a_1,a_2,a_3,...,a_n]$，其中每一项数值和原始的输入$H=[h_1,h_2,h_3,...,h_n]$一一对应。以 $a_i$ 为例，相关计算公式如下：

$$
\begin{align}a_i = softmax(s(h_i, q))= \frac {exp(s(h_i,q))} {\sum_{j=1}^n exp(s(h_j, q))} \end{align}
$$

**最后**根据这些注意力分布可以去有选择性的从输入信息 $H$ 中提取信息，这里比较常用的信息提取方式，是一种"软性"的信息提取（**图2**展示的就是一种"软性"注意力），即根据注意力分布对输入信息进行加权求和，最终的这个结果 $context$ 体现了模型当前应该关注的内容：

$$
context = \sum_{i=1}^n a_i \cdot h_i
$$

现在我们来解决之前一直没有展开的**小尾巴**-打分函数，它可以使用以下几种方式来计算：

- 加性模型:          $s(h, q) = v^Ttanh(Wh+Uq)$
- 点积模型:          $s(h, q) = h^Tq$
- 缩放点积模型:  $s(h, q) =\frac{ h^Tq}{\sqrt D}$
- 双线性模型:       $s(h, q) = h^TWq$

以上公式中的参数 $W$、$U$和$v$均是可学习的参数矩阵或向量，$D$为输入向量的维度。下边我们来分析一下这些分数计算方式的差别。

**加性模型**引入了可学习的参数，将查询向量 $q$ 和原始输入向量 $h$ 映射到不同的向量空间后进行计算打分，显然相较于加性模型，**点积模型**具有更好的计算效率。

另外，当输入向量的维度比较高的时候，**点积模型**通常有比较大的方差，从而导致Softmax函数的梯度会比较小。因此**缩放点积模型**通过除以一个**平方根项**来平滑分数数值，也相当于平滑最终的**注意力分布**，缓解这个问题。

最后，**双线性模型**可以重塑为$s(h_i, q) = h^TWq=h^T(U^TV)q=(Uh)^T(Vq)$，即分别对查询向量 $q$ 和原始输入向量 $h$进行线性变换之后，再计算点积。相比点积模型，**双线性模型**在计算相似度时引入了非对称性。

