# 注意力机制的一些变体

## 1. 硬性注意力机制

在**经典注意力机制**章节我们使用了一种软性注意力的方式进行Attention机制，它通过**注意力分布**来加权求和融合各个输入向量。而**硬性注意力（Hard Attention）**机制则不是采用这种方式，它是根据**注意力分布**选择输入向量中的一个作为输出。这里有两种选择方式：

- 选择注意力分布中，分数最大的那一项对应的输入向量作为Attention机制的输出。
- 根据注意力分布进行随机采样，采样结果作为Attention机制的输出。

**硬性注意力**通过以上两种方式选择Attention的输出，这会使得最终的损失函数与注意力分布之间的函数关系不可导，导致无法使用反向传播算法训练模型，硬性注意力通常需要使用强化学习来进行训练。因此，一般深度学习算法会使用**软性注意力**的方式进行计算，

## 2. 键值对注意力机制

假设我们的输入信息不再是前边所提到的$H=[h_1,h_2,h_3,...,h_n]$ ，而是更为一般的**键值对（key-value pair）**形式 $(K,V)=[(k_1,v_1),(k_2,v_2),...,(k_n,v_n)]$ ，相关的**查询向量**仍然为 $q$。这种模式下，一般会使用**查询向量** $q$和相应的**键** $k_i$进行计算注意力权值 $a_i$。

$$
\begin{align} a_i=softmax(s(k_i,q)) = \frac{exp(s(k_i,q))}{\sum_{j=1}^n exp(s(k_j, q))} \end{align}
$$


当计算出在输入数据上的**注意力分布**之后，利用**注意力分布**和键值对中的对应**值**进行加权融合计算：

$$
context=\sum_{i=1}^n a_i \cdot v_i
$$

显然，当键值相同的情况下$k=v$，键值对注意力就退化成了普通的经典注意力机制。

## 3. 多头注意力机制

多头注意力(Multi-Head Attention)是利用多个查询向量 $Q=[q_1,q_2,...,q_m]$，并行地从输入信息$(K,V)=[(k_1,v_1),(k_2,v_2),...,(k_n,v_n)]$中选取多组信息。在查询过程中，每个查询向量 $q_i$ 将会关注输入信息的不同部分，即从不同的角度上去分析当前的输入信息。

假设 $a_{ij}$代表第 $i$ 各查询向量 $q_i$ 与第 $j$ 个输入信息 $k_j$ 的注意力权重， $context_i$ 代表由查询向量$q_i$计算得出的Attention输出向量。其计算方式为：

$$
\begin{align}
a_{ij}=softmax(s(k_j,q_i)) &= \frac{exp(s(k_j,q_i))}{\sum_{t=1}^n exp(s(k_t, q_i))} \\
context_i &=\sum_{j=1}^n a_{ij} \cdot v_j  
\end{align}
$$

最终将所有查询向量的结果进行拼接作为最终的结果：

$$
context=context_1 \oplus context_2 \oplus context_3 \oplus...\oplus context_m
$$

公式里的 $\oplus$表示向量拼接操作。

## 4. 引用
[1] 邱锡鹏. 神经网络与深度学习[M]. 北京：机械工业出版社，2021.
