# 注意力机制是什么

假设有一天热爱绘画的你决定去户外写生，你来到一片山坡上，极目远去，心旷神怡。头顶一片蔚蓝，脚踩一席草绿，远处山川连绵，眼前花草送香，暖阳含羞云后，轻风拂动衣襟，鸟啼虫鸣入耳，美景丹青共卷。

<center><img src="https://raw.githubusercontent.com/1649759610/images_for_blog/master/infoflow%202021-05-19%2015-43-38%20(1).png"/></center>
<center> 图1《起风了》插图 </center>

你集中精神，拿起画笔将蓝天、白云、青草等等这些元素，按照所思所想纷纷绘入画板。在绘画的过程中，你会持续地关注你构思到画板上的元素（比如蓝天，白云），而不会太多关注那些其他的元素，比如风，虫鸣，阳光等等。即你的精神是聚焦在你关心的那些事物上，这其实就是注意力的体现，这种有意识的聚焦被称为**聚焦式注意力（Focus Attention**）。

然而，正当你在画板上忘我倾洒的时侯，突然有人在背后喊你的名字，你立马注意到了，然后放下画笔，转头和来人交谈。这种无意识地，往往由外界刺激引发的注意力被称为**显著性注意力（Saliency-Based Attention）**。

但不论哪一种注意力，其实都是让你在某一时刻将注意力放到某些事物上，而忽略另外的一些事物，这就是**注意力机制（Attention Mechanism）**。

在深度学习领域，模型往往需要接收和处理大量的数据，然而在特定的某个时刻，往往只有少部分的某些数据是重要的，这种情况就非常适合**Attention机制**发光发热。

![image](https://raw.githubusercontent.com/1649759610/images_for_blog/master/image.png)

<center>图2 机器翻译任务</center>

举个例子，**图2**展示了一个机器翻译的结果，在这个例子中，我们想将"who are you"翻译为"你是谁"，传统的模型处理方式是一个seq-to-seq的模型，其包含一个encoder端和一个decoder端，其中encoder端对"who are you"进行编码，然后将整句话的信息传递给decoder端，由decoder解码出"我是谁"。在这个过程中，decoder是逐字解码的，在每次解码的过程中，如果接收信息过多，可能会导致模型的内部混乱，从而导致错误结果的出现。

我们可以使用**Attention机制**来解决这个问题，从**图2**可以看到，在生成"你"的时候和单词"you"关系比较大，和"who are"关系不大，所以我们更希望在这个过程中能够使用**Attention机制**，将更多注意力放到"you"上，而不要太多关注"who are"，从而提高整体模型的表现。

> 备注：在深度学习领域，无意识的**显著性注意力**更加常见。

Attention机制自提出以来，出现了很多不同Attention应用方式，但大道是共同的，均是将模型的注意力聚焦在重要的事情上。本文后续将选择一些经典或常用的Attention机制展开讨论。
