# ROUGE

## 1. ROUGE 评估指标

看过BLEU算法的同学知道，BLEU算法只关心生成序列的字词是否在参考序列中出现，而不关心参考序列中的字词是否在生成序列中出现，这在实际指标评估过程中可能会带来一些影响，从而不能较好评估生成序列的质量。

**ROUGE** (Recall-Oriented Understudy for Gisting Evaluation)算法便是一种解决方案，它能够衡量参考序列中的字词是在生成序列中出现过，即它能够衡量生成序列的召回率。下面还是以机器翻译为例，来探讨一下ROUGE的计算。

假设当前有一句源文$s$，以及相应的译文参考序列$r_1, r_2,...,r_n$。机器翻译模型根据源文$s$生成了一个生成序列$x$，且$W$为根据候选序列$x$生成的$N$元单词组合，则ROUGE算法的计算方式为：

$$
\text{ROUGE-N}(x) = \frac{\sum_{k=1}^n \sum_{w \in W} \text{min}(c_w(x), c_w(r_k))}{\sum_{k=1}^n \sum_{w \in W} c_w(r_k)}
$$

其中，$c_w(x)$为$N$元组合词$w$在生成序列$x$中出现的次数，$c_w(r_k)$为$N$元组合词$w$在参考序列$r_k$中出现的次数。

从公式可以看到，ROUGE算法能比较好地计算参考序列中的字词是否在生成序列出现过，但没有关注生成序列的字词是否在参考序列中出现过，即ROUGE算法只关心生成序列的召回率，而不关心准确率。

## 2. 引用
[1] 邱锡鹏. 神经网络与深度学习[M]. 北京：机械工业出版社，2021.  
[2] 吴飞. 人工智能导论：模型与算法[M]. 北京：高等教育出版社，2020.
