# Perplexity

Perplexity，中文翻译为困惑度，是信息论中的一个概念，其可以用来衡量一个随机变量的不确定性，也可以用来衡量模型训练的好坏程度。通常情况下，一个随机变量的Perplexity数值越高，代表其不确定性也越高；一个模型推理时的Perplexity数值越高，代表模型表现越差，反之亦然。

## 1. 随机变量概率分布的困惑度

对于离散随机变量$X$​，假设概率分布可以表示为$p(x)$​​​，那么对应的困惑度为：

$$
2^{H(p)} = 2^{-\sum_{x\in X} p(x){log}_2p(x)}
$$

其中，$H(p)$为概率分布$p$​​的熵。可以看到，一个随机变量熵越大，其对应的困惑度也就越大，随机变量的不确定性也就越大。

## 2. 模型分布的困惑度

困惑度也可以用来衡量模型训练的好坏程度，即衡量模型分布和样本分布之间的差异。一般来讲，在模型的训练过程中，模型分布越接近样本分布，模型训练得也就越好。

假设现在有一批数据$x_1, x_2,x_3,..., x_n$，其对应的**经验分布**为$p_r(x)$。现在我们根据这些样本成功训练出了一个模型$p_{\theta}(x)$，那么模型分布$p_{\theta}(x)$​​​​的好坏可以由困惑度进行定义：

$$
2^{H(p_r,p_\theta)} = 2^{-\sum_i^n p_r(x_i) \; {log}_2 p_{\theta}(x_i)}
$$

其中，$H({p_r},p_\theta)$​表示样本的经验分布$\hat{p_r}$和模型分布$p_\theta$​之间的交叉熵。假设每个样本$x_i$的生成概率是相等的，即$p_r(x_i)=\frac{1}{n}$，则模型分布的困惑度可简化为：

$$
2^{H(p_r,p_\theta)} = 2^{-\frac{1}{n}\sum_i^n {log}_2p_{\theta}(x_i)}
$$

## 3. NLP领域中的困惑度

在NLP领域，语言模型可以用来计算一个句子的概率，假设现在有这样一句话$s=w_1, w_2, w_3, ..., w_n$​​​​​​, 我们可以这样计算这句话的生成概率：

$$
\begin{align}
p(s) &= p(w_1,w_2,...,w_n) \\ &= \prod_{i=1}^n p(w_i|w_1,w_2,...,w_{i-1})
\end{align}
$$

在语言模型训练完成之后，如何去评判语言模型的好坏？这时，困惑度就可以发挥作用了。一般来讲，用于评判语言模型的测试集均是合理的、高质量的语料，只要语言模型在测试集上的困惑度越高，则代表语言模型训练地越好，反之亦然。

在了解了语句概率的计算后，则对于语句$s=w_1, w_2, w_3, ..., w_n$​​，其困惑度可以这样来定义：

$$
\begin{align}
perplexity &= {p(s)}^{-\frac{1}{n}}\\ &={p(w_1,w_2,...,w_n)}^{-\frac{1}{n}} \\ &= \sqrt[n]{\frac{1}{p(w_1,w_2,...,w_n)}} \\ &= \sqrt[n]{\prod_{i=1}^n \frac{1}{p(w_i|w_1,w_2,...,w_{i-1})}}
\end{align}
$$

显然，测试集中句子的概率越大，困惑度也就越小。

## 4. 引用
[1] 邱锡鹏. 神经网络与深度学习[M]. 北京：机械工业出版社，2021.  
[2] 吴飞. 人工智能导论：模型与算法[M]. 北京：高等教育出版社，2020.
