# BLEU

## 1. BLEU 内容介绍
BLEU (BiLingual Evaluation Understudy) 最早用于机器翻译任务上，用于评估机器翻译的语句的合理性。具体来讲，BLEU通过衡量生成序列和参考序列之间的重合度进行计算的。下面我们将以机器翻译为例，进行讨论这个指标。

假设当前有一句源文$s$​​​​​​，以及相应的译文参考序列$r_1, r_2,...,r_n$​​​​​​。机器翻译模型根据源文$s$​​​​​​生成了一个生成序列$x$​​​​​​​​​，且$W$​​​​​​为根据候选序列$x$​​​​​​生成的$N$​​​​​​​​元单词组合，这些$N$元组合的精度为：

$$
P_{N}(x) = \frac{\sum_{w\in W}min(c_w(x), max_{k=1}^n c_w(r_k))}{\sum_{w \in W} c_w (x)}
$$


其中，$c_w(x)$​为$N$​元组合词$w$​在生成序列$x$​中出现的次数，$c_w(r_k)$​为$N$​元组合词$w$​在参考序列$r_k$​​中出现的次数。$N$元组合的精度$P_N(x)$即为生成序列中的$N$元组合词在参考序列中出现的比例。

从以上公式可以看出，$P_N(x)$​的核心思想是衡量生成序列$x$​中的$N$​元组合词是否在参考序列中出现，其计算结果更偏好短的生成序列，即生成序列$x$​越短，精度$P_N(x)$​​​​会越高。这种情况下，可以引入**长度惩罚因子**，如果生成序列$x$​比参考序列$r_k$短，则会对该生成序列$x$进行惩罚。

$$
b(x)=\left\{\begin{matrix}1 &\text{if} \quad l_x>l_r \\ \text{exp}(1-l_s/l_r) &\text{if} \quad l_s \leq l_r \end{matrix}\right.
$$

其中，$l_x$​表示生成序列$x$​的长度， $l_r$​表示参考序列$l_r$​的**最短长度**。

前边反复提到一个概念--$N$​​​**元组合词**，我们可以根据生成序列$x$​​构造不同长度的N元组合词，这样便可以获得不同长度组合词的精度，比如$P_1(x)$​，$P_2(x)$​，$P_3(x)$​等等。BLEU算法通过计算不同长度的$N$​​​​​​元组合的精度$P_N(x)，N=1,2,3...$​，并对其进行几何加权平均得到，如下所示。

$$
\text{BLEU-N}(x) = b(x)\times \text{exp}(\sum_{N=1}^{N^{'}} {\alpha}_N \; \text{log} \; P_N)
$$

其中，$N'$​为最长$N$​元组合词的长度， $\alpha_N$​为不同$N$​元组合词的权重，一般设置为$\frac{1}{N'}$​，BLEU算法的值域范围是$[0,1]$​，数值越大，表示生成的质量越好。

BLEU算法能够比较好地计算生成序列$x$​​​的字词是否在参考序列中出现过，但是其并没有关注参考序列中的字词是否在生成序列出现过。即BLEU只关心生成的序列精度，而不关心其召回率。

## 2. 引用
[1] 邱锡鹏. 神经网络与深度学习[M]. 北京：机械工业出版社，2021.  
[2] 吴飞. 人工智能导论：模型与算法[M]. 北京：高等教育出版社，2020.
