# **引入**
* 自动驾驶是近些年来非常热门的一个技术
* 恰好这次新开的论文复现比赛中有一个这样的论文
* 所以今天就介绍一下如何用模拟器和简单的神经网络实现一个简单的端到端自动驾驶模型

# **效果演示**
![](https://img-blog.csdnimg.cn/f11007092340466e8a64155ce0283141.gif)

# **相关资料**
* 论文：[End to End Learning for Self-Driving Cars](https://arxiv.org/abs/1604.07316)
* 参考实现：[naokishibuya/car-behavioral-cloning](https://github.com/naokishibuya/car-behavioral-cloning)
* 本项目：[jm12138/car-behavioral-cloning-paddle](https://github.com/jm12138/car-behavioral-cloning-paddle)

# **原理介绍**
* 本项目基于监督学习的方式实现模拟器中的自动驾驶
* 通过模拟器手动跑几圈采集数据（模拟器画面的图像和对应的车辆转弯角度）
* 使用一个简单的卷积神经网络实现一个从画面到角度的回归模型
* 推理时通过实时的画面预测出对应时刻的车辆转弯角度，再通过简单的速度控制代码实现速度控制，既可以实现简易的自动驾驶

![](https://ai-studio-static-online.cdn.bcebos.com/a9f41fffa2d24906aec05bf674de94b6b5906c46c3ee4875be31cec1c8ac57b0)
![](https://ai-studio-static-online.cdn.bcebos.com/c7dd74d0a54344518acafd1947bd5625fa58563437b54f0d96dde29817dcf1a2)
![](https://ai-studio-static-online.cdn.bcebos.com/12e56fefb5f74dab9c8063bab2ca82a26363a098876047d884168b177ac92ffd)


# **采集数据**
* 下载模拟器，使用 Training Mode 采集数据
* 采集的数据需要进行一定的处理才可以在 AIStudio 中进行训练
    * 在数据 csv 文件中增加一个如下的表头

    | center | left | right | steering | lefting | righting | speed |
    | -------- | -------- | -------- | -------- | -------- | -------- | -------- |

    * 在数据 csv 文件中替换删除 IMG\xxx.jpg 前面的路径，并将后面的斜杠统一为 \

# **同步项目代码**


```python
%cd ~

!git clone https://github.com.cnpmjs.org/jm12138/car-behavioral-cloning-paddle
```

    /home/aistudio
    Cloning into 'car-behavioral-cloning-paddle'...
    remote: Enumerating objects: 84, done.[K
    remote: Counting objects: 100% (84/84), done.[K
    remote: Compressing objects: 100% (70/70), done.[K
    remote: Total 84 (delta 43), reused 40 (delta 12), pack-reused 0[K
    Unpacking objects: 100% (84/84), done.
    Checking connectivity... done.


# **解压数据**
* 这里已经准备好了一个在第一个赛道中已经采集好的数据集
* 解压即可使用


```python
%cd ~

!unzip -q data.zip -d car-behavioral-cloning-paddle
```

    /home/aistudio


# **模型结构**
* 这篇论文中使用的模型非常简单，是一个简单的多层卷积神经网络

![](https://ai-studio-static-online.cdn.bcebos.com/227e1a2847af4658a8ae5d9172d30b715cd424fd4a7a490cbbaad525c8adb8d6)

* 也可以使用下面的代码打印出模型结构


```python
%cd ~/car-behavioral-cloning-paddle/

import paddle
from car.model import build_model

# 创建一个模型
model = build_model()

# 打印模型结构
paddle.summary(model, (1, 66, 200, 3))
```

    /home/aistudio/car-behavioral-cloning-paddle
    ---------------------------------------------------------------------------
     Layer (type)       Input Shape          Output Shape         Param #  
    ===========================================================================
       Conv2D-11     [[1, 66, 200, 3]]     [1, 31, 98, 24]         1,824  
        ELU-17       [[1, 31, 98, 24]]     [1, 31, 98, 24]           0  
       Conv2D-12     [[1, 31, 98, 24]]     [1, 14, 47, 36]        21,636  
        ELU-18       [[1, 14, 47, 36]]     [1, 14, 47, 36]           0  
       Conv2D-13     [[1, 14, 47, 36]]      [1, 5, 22, 48]        43,248  
        ELU-19        [[1, 5, 22, 48]]      [1, 5, 22, 48]           0  
       Conv2D-14      [[1, 5, 22, 48]]      [1, 3, 20, 64]        27,712  
        ELU-20        [[1, 3, 20, 64]]      [1, 3, 20, 64]           0  
       Conv2D-15      [[1, 3, 20, 64]]      [1, 1, 18, 64]        36,928  
        ELU-21        [[1, 1, 18, 64]]      [1, 1, 18, 64]           0  
       Dropout-3      [[1, 1, 18, 64]]      [1, 1, 18, 64]           0  
       Flatten-3      [[1, 1, 18, 64]]        [1, 1152]              0  
       Linear-9         [[1, 1152]]            [1, 100]           115,300  
        ELU-22           [[1, 100]]            [1, 100]              0  
       Linear-10         [[1, 100]]            [1, 50]             5,050  
        ELU-23           [[1, 50]]             [1, 50]               0  
       Linear-11         [[1, 50]]             [1, 10]              510  
        ELU-24           [[1, 10]]             [1, 10]               0  
       Linear-12         [[1, 10]]              [1, 1]              11  
    ===========================================================================
    Total params: 252,219
    Trainable params: 252,219
    Non-trainable params: 0
    ---------------------------------------------------------------------------
    Input size (MB): 0.15
    Forward/backward pass size (MB): 1.65
    Params size (MB): 0.96
    Estimated Total Size (MB): 2.76
    ---------------------------------------------------------------------------






    {'total_params': 252219, 'trainable_params': 252219}



# **模型训练**
* 使用如下指令进行模型训练，更多选项请参考源代码


```python
%cd ~/car-behavioral-cloning-paddle/

!python train.py -d data
```

    /home/aistudio/car-behavioral-cloning-paddle
    /opt/conda/envs/python35-paddle120-env/lib/python3.7/site-packages/matplotlib/__init__.py:107: DeprecationWarning: Using or importing the ABCs from 'collections' instead of from 'collections.abc' is deprecated, and in 3.8 it will stop working
      from collections import MutableMapping
    /opt/conda/envs/python35-paddle120-env/lib/python3.7/site-packages/matplotlib/rcsetup.py:20: DeprecationWarning: Using or importing the ABCs from 'collections' instead of from 'collections.abc' is deprecated, and in 3.8 it will stop working
      from collections import Iterable, Mapping
    /opt/conda/envs/python35-paddle120-env/lib/python3.7/site-packages/matplotlib/colors.py:53: DeprecationWarning: Using or importing the ABCs from 'collections' instead of from 'collections.abc' is deprecated, and in 3.8 it will stop working
      from collections import Sized
    ------------------------------
    Parameters
    ------------------------------
    data_dir             := data
    save_dir             := save
    test_size            := 0.2
    keep_prob            := 0.5
    nb_epoch             := 100
    batch_size           := 40
    learning_rate        := 0.0001
    early_stop           := False
    ------------------------------
    W0806 18:32:27.157912  2683 device_context.cc:404] Please NOTE: device: 0, GPU Compute Capability: 7.0, Driver API Version: 10.1, Runtime API Version: 10.1
    W0806 18:32:27.162982  2683 device_context.cc:422] device: 0, cuDNN Version: 7.6.
    The loss value printed in the log is the current step, and the metric is the average value of previous steps.
    Epoch 1/100
    /opt/conda/envs/python35-paddle120-env/lib/python3.7/site-packages/paddle/fluid/layers/utils.py:77: DeprecationWarning: Using or importing the ABCs from 'collections' instead of from 'collections.abc' is deprecated, and in 3.8 it will stop working
      return (isinstance(seq, collections.Sequence) and
    step 55/55 [==============================] - loss: 0.1115 - 80ms/step  
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/0
    Eval begin...
    step 14/14 [==============================] - loss: 0.0450 - 61ms/step  
    Eval samples: 547
    Epoch 2/100
    step 55/55 [==============================] - loss: 0.0768 - 78ms/step  
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/1
    Eval begin...
    step 14/14 [==============================] - loss: 0.0308 - 55ms/step  
    Eval samples: 547
    Epoch 3/100
    step 55/55 [==============================] - loss: 0.0425 - 76ms/step  
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/2
    Eval begin...
    step 14/14 [==============================] - loss: 0.0311 - 54ms/step  
    Eval samples: 547
    Epoch 4/100
    step 55/55 [==============================] - loss: 0.0434 - 80ms/step  
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/3
    Eval begin...
    step 14/14 [==============================] - loss: 0.0294 - 53ms/step  
    Eval samples: 547
    Epoch 5/100
    step 55/55 [==============================] - loss: 0.0473 - 78ms/step  
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/4
    Eval begin...
    step 14/14 [==============================] - loss: 0.0315 - 53ms/step  
    Eval samples: 547
    Epoch 6/100
    step 55/55 [==============================] - loss: 0.0295 - 80ms/step  
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/5
    Eval begin...
    step 14/14 [==============================] - loss: 0.0286 - 65ms/step  
    Eval samples: 547
    Epoch 7/100
    step 55/55 [==============================] - loss: 0.0421 - 76ms/step  
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/6
    Eval begin...
    step 14/14 [==============================] - loss: 0.0245 - 58ms/step  
    Eval samples: 547
    Epoch 8/100
    step 55/55 [==============================] - loss: 0.0527 - 79ms/step  
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/7
    Eval begin...
    step 14/14 [==============================] - loss: 0.0263 - 55ms/step  
    Eval samples: 547
    Epoch 9/100
    step 55/55 [==============================] - loss: 0.0238 - 76ms/step  
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/8
    Eval begin...
    step 14/14 [==============================] - loss: 0.0275 - 53ms/step  
    Eval samples: 547
    Epoch 10/100
    step 55/55 [==============================] - loss: 0.0515 - 77ms/step  
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/9
    Eval begin...
    step 14/14 [==============================] - loss: 0.0241 - 54ms/step  
    Eval samples: 547
    Epoch 11/100
    step 55/55 [==============================] - loss: 0.0332 - 80ms/step  
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/10
    Eval begin...
    step 14/14 [==============================] - loss: 0.0240 - 53ms/step  
    Eval samples: 547
    Epoch 12/100
    step 55/55 [==============================] - loss: 0.0477 - 78ms/step  
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/11
    Eval begin...
    step 14/14 [==============================] - loss: 0.0237 - 54ms/step  
    Eval samples: 547
    Epoch 13/100
    step 55/55 [==============================] - loss: 0.0648 - 76ms/step  
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/12
    Eval begin...
    step 14/14 [==============================] - loss: 0.0231 - 56ms/step  
    Eval samples: 547
    Epoch 14/100
    step 55/55 [==============================] - loss: 0.0384 - 78ms/step  
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/13
    Eval begin...
    step 14/14 [==============================] - loss: 0.0211 - 58ms/step  
    Eval samples: 547
    Epoch 15/100
    step 55/55 [==============================] - loss: 0.0373 - 78ms/step  
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/14
    Eval begin...
    step 14/14 [==============================] - loss: 0.0247 - 58ms/step  
    Eval samples: 547
    Epoch 16/100
    step 55/55 [==============================] - loss: 0.0364 - 77ms/step  
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/15
    Eval begin...
    step 14/14 [==============================] - loss: 0.0208 - 54ms/step  
    Eval samples: 547
    Epoch 17/100
    step 55/55 [==============================] - loss: 0.0227 - 79ms/step  
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/16
    Eval begin...
    step 14/14 [==============================] - loss: 0.0222 - 57ms/step  
    Eval samples: 547
    Epoch 18/100
    step 55/55 [==============================] - loss: 0.0244 - 81ms/step  
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/17
    Eval begin...
    step 14/14 [==============================] - loss: 0.0234 - 55ms/step  
    Eval samples: 547
    Epoch 19/100
    step 55/55 [==============================] - loss: 0.0264 - 79ms/step  
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/18
    Eval begin...
    step 14/14 [==============================] - loss: 0.0226 - 65ms/step  
    Eval samples: 547
    Epoch 20/100
    step 55/55 [==============================] - loss: 0.0398 - 79ms/step  
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/19
    Eval begin...
    step 14/14 [==============================] - loss: 0.0207 - 60ms/step  
    Eval samples: 547
    Epoch 21/100
    step 55/55 [==============================] - loss: 0.0292 - 79ms/step  
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/20
    Eval begin...
    step 14/14 [==============================] - loss: 0.0198 - 54ms/step  
    Eval samples: 547
    Epoch 22/100
    step 55/55 [==============================] - loss: 0.0284 - 77ms/step  
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/21
    Eval begin...
    step 14/14 [==============================] - loss: 0.0213 - 56ms/step  
    Eval samples: 547
    Epoch 23/100
    step 55/55 [==============================] - loss: 0.0732 - 78ms/step  
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/22
    Eval begin...
    step 14/14 [==============================] - loss: 0.0183 - 53ms/step  
    Eval samples: 547
    Epoch 24/100
    step 55/55 [==============================] - loss: 0.0244 - 83ms/step  
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/23
    Eval begin...
    step 14/14 [==============================] - loss: 0.0203 - 54ms/step  
    Eval samples: 547
    Epoch 25/100
    step 55/55 [==============================] - loss: 0.0266 - 82ms/step  
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/24
    Eval begin...
    step 14/14 [==============================] - loss: 0.0175 - 53ms/step  
    Eval samples: 547
    Epoch 26/100
    step 55/55 [==============================] - loss: 0.0284 - 82ms/step  
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/25
    Eval begin...
    step 14/14 [==============================] - loss: 0.0173 - 60ms/step  
    Eval samples: 547
    Epoch 27/100
    step 55/55 [==============================] - loss: 0.0360 - 81ms/step  
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/26
    Eval begin...
    step 14/14 [==============================] - loss: 0.0178 - 55ms/step  
    Eval samples: 547
    Epoch 28/100
    step 55/55 [==============================] - loss: 0.0143 - 85ms/step  
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/27
    Eval begin...
    step 14/14 [==============================] - loss: 0.0179 - 56ms/step  
    Eval samples: 547
    Epoch 29/100
    step 55/55 [==============================] - loss: 0.0352 - 75ms/step  
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/28
    Eval begin...
    step 14/14 [==============================] - loss: 0.0169 - 55ms/step  
    Eval samples: 547
    Epoch 30/100
    step 55/55 [==============================] - loss: 0.0283 - 78ms/step  
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/29
    Eval begin...
    step 14/14 [==============================] - loss: 0.0165 - 56ms/step  
    Eval samples: 547
    Epoch 31/100
    step 55/55 [==============================] - loss: 0.0299 - 78ms/step  
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/30
    Eval begin...
    step 14/14 [==============================] - loss: 0.0173 - 56ms/step  
    Eval samples: 547
    Epoch 32/100
    step 55/55 [==============================] - loss: 0.0355 - 83ms/step  
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/31
    Eval begin...
    step 14/14 [==============================] - loss: 0.0174 - 53ms/step  
    Eval samples: 547
    Epoch 33/100
    step 55/55 [==============================] - loss: 0.0218 - 77ms/step  
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/32
    Eval begin...
    step 14/14 [==============================] - loss: 0.0159 - 53ms/step  
    Eval samples: 547
    Epoch 34/100
    step 55/55 [==============================] - loss: 0.0231 - 76ms/step  
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/33
    Eval begin...
    step 14/14 [==============================] - loss: 0.0173 - 53ms/step  
    Eval samples: 547
    Epoch 35/100
    step 55/55 [==============================] - loss: 0.0239 - 77ms/step  
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/34
    Eval begin...
    step 14/14 [==============================] - loss: 0.0121 - ETA: 0s - 56ms/st - loss: 0.0201 - 55ms/step  
    Eval samples: 547
    Epoch 36/100
    step 55/55 [==============================] - loss: 0.0361 - 80ms/step  
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/35
    Eval begin...
    step 14/14 [==============================] - loss: 0.0169 - 53ms/step  
    Eval samples: 547
    Epoch 37/100
    step 55/55 [==============================] - loss: 0.0250 - 81ms/step  
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/36
    Eval begin...
    step 14/14 [==============================] - loss: 0.0168 - 55ms/step  
    Eval samples: 547
    Epoch 38/100
    step 55/55 [==============================] - loss: 0.0350 - 91ms/step  
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/37
    Eval begin...
    step 14/14 [==============================] - loss: 0.0176 - 54ms/step  
    Eval samples: 547
    Epoch 39/100
    step 55/55 [==============================] - loss: 0.0213 - 80ms/step  
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/38
    Eval begin...
    step 14/14 [==============================] - loss: 0.0160 - 53ms/step  
    Eval samples: 547
    Epoch 40/100
    step 55/55 [==============================] - loss: 0.0118 - 75ms/step  
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/39
    Eval begin...
    step 14/14 [==============================] - loss: 0.0151 - 54ms/step  
    Eval samples: 547
    Epoch 41/100
    step 55/55 [==============================] - loss: 0.0317 - 78ms/step  
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/40
    Eval begin...
    step 14/14 [==============================] - loss: 0.0175 - 52ms/step  
    Eval samples: 547
    Epoch 42/100
    step 55/55 [==============================] - loss: 0.0197 - 77ms/step  
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/41
    Eval begin...
    step 14/14 [==============================] - loss: 0.0174 - 54ms/step  
    Eval samples: 547
    Epoch 43/100
    step 55/55 [==============================] - loss: 0.0264 - 76ms/step  
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/42
    Eval begin...
    step 14/14 [==============================] - loss: 0.0154 - 52ms/step  
    Eval samples: 547
    Epoch 44/100
    step 55/55 [==============================] - loss: 0.0344 - 76ms/step  
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/43
    Eval begin...
    step 14/14 [==============================] - loss: 0.0189 - 53ms/step  
    Eval samples: 547
    Epoch 45/100
    step 55/55 [==============================] - loss: 0.0274 - 78ms/step  
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/44
    Eval begin...
    step 14/14 [==============================] - loss: 0.0154 - 53ms/step  
    Eval samples: 547
    Epoch 46/100
    step 55/55 [==============================] - loss: 0.0164 - 77ms/step  
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/45
    Eval begin...
    step 14/14 [==============================] - loss: 0.0165 - 57ms/step  
    Eval samples: 547
    Epoch 47/100
    step 55/55 [==============================] - loss: 0.0274 - 78ms/step  
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/46
    Eval begin...
    step 14/14 [==============================] - loss: 0.0179 - 54ms/step  
    Eval samples: 547
    Epoch 48/100
    step 55/55 [==============================] - loss: 0.0320 - 79ms/step  
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/47
    Eval begin...
    step 14/14 [==============================] - loss: 0.0166 - 55ms/step  
    Eval samples: 547
    Epoch 49/100
    step 55/55 [==============================] - loss: 0.0199 - 83ms/step  
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/48
    Eval begin...
    step 14/14 [==============================] - loss: 0.0157 - 55ms/step  
    Eval samples: 547
    Epoch 50/100
    step 55/55 [==============================] - loss: 0.0354 - 78ms/step  
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/49
    Eval begin...
    step 14/14 [==============================] - loss: 0.0164 - 54ms/step  
    Eval samples: 547
    Epoch 51/100
    step 55/55 [==============================] - loss: 0.0283 - 81ms/step  
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/50
    Eval begin...
    step 14/14 [==============================] - loss: 0.0170 - 58ms/step  
    Eval samples: 547
    Epoch 52/100
    step 55/55 [==============================] - loss: 0.0358 - 78ms/step  
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/51
    Eval begin...
    step 14/14 [==============================] - loss: 0.0165 - 54ms/step  
    Eval samples: 547
    Epoch 53/100
    step 55/55 [==============================] - loss: 0.0233 - 79ms/step  
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/52
    Eval begin...
    step 14/14 [==============================] - loss: 0.0154 - 54ms/step  
    Eval samples: 547
    Epoch 54/100
    step 55/55 [==============================] - loss: 0.0104 - 76ms/step  
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/53
    Eval begin...
    step 14/14 [==============================] - loss: 0.0158 - 53ms/step  
    Eval samples: 547
    Epoch 55/100
    step 55/55 [==============================] - loss: 0.0457 - 76ms/step  
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/54
    Eval begin...
    step 14/14 [==============================] - loss: 0.0095 - ETA: 0s - 57ms/st - loss: 0.0163 - 54ms/step  
    Eval samples: 547
    Epoch 56/100
    step 55/55 [==============================] - loss: 0.0298 - 82ms/step  
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/55
    Eval begin...
    step 14/14 [==============================] - loss: 0.0163 - 59ms/step  
    Eval samples: 547
    Epoch 57/100
    step 55/55 [==============================] - loss: 0.0471 - 78ms/step  
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/56
    Eval begin...
    step 14/14 [==============================] - loss: 0.0168 - 63ms/step  
    Eval samples: 547
    Epoch 58/100
    step 55/55 [==============================] - loss: 0.0265 - 76ms/step  
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/57
    Eval begin...
    step 14/14 [==============================] - loss: 0.0140 - 57ms/step  
    Eval samples: 547
    Epoch 59/100
    step 55/55 [==============================] - loss: 0.0212 - 78ms/step  
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/58
    Eval begin...
    step 14/14 [==============================] - loss: 0.0146 - 74ms/step  
    Eval samples: 547
    Epoch 60/100
    step 55/55 [==============================] - loss: 0.0177 - 83ms/step  
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/59
    Eval begin...
    step 14/14 [==============================] - loss: 0.0162 - 52ms/step  
    Eval samples: 547
    Epoch 61/100
    step 55/55 [==============================] - loss: 0.0156 - 76ms/step  
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/60
    Eval begin...
    step 14/14 [==============================] - loss: 0.0172 - 52ms/step  
    Eval samples: 547
    Epoch 62/100
    step 55/55 [==============================] - loss: 0.0257 - 79ms/step  
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/61
    Eval begin...
    step 14/14 [==============================] - loss: 0.0088 - ETA: 0s - 54ms/st - loss: 0.0160 - 54ms/step  
    Eval samples: 547
    Epoch 63/100
    step 55/55 [==============================] - loss: 0.0260 - 76ms/step  
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/62
    Eval begin...
    step 14/14 [==============================] - loss: 0.0155 - 58ms/step  
    Eval samples: 547
    Epoch 64/100
    step 55/55 [==============================] - loss: 0.0380 - 84ms/step  
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/63
    Eval begin...
    step 14/14 [==============================] - loss: 0.0158 - 53ms/step  
    Eval samples: 547
    Epoch 65/100
    step 55/55 [==============================] - loss: 0.0411 - 80ms/step  
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/64
    Eval begin...
    step 14/14 [==============================] - loss: 0.0147 - 54ms/step  
    Eval samples: 547
    Epoch 66/100
    step 55/55 [==============================] - loss: 0.0204 - 84ms/step  
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/65
    Eval begin...
    step 14/14 [==============================] - loss: 0.0162 - 55ms/step  
    Eval samples: 547
    Epoch 67/100
    step 55/55 [==============================] - loss: 0.0331 - 77ms/step          oss: 0.0212 - ETA: 1s - 78ms/
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/66
    Eval begin...
    step 14/14 [==============================] - loss: 0.0151 - 54ms/step  
    Eval samples: 547
    Epoch 68/100
    step 55/55 [==============================] - loss: 0.0303 - 80ms/step  
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/67
    Eval begin...
    step 14/14 [==============================] - loss: 0.0162 - 66ms/step  
    Eval samples: 547
    Epoch 69/100
    step 55/55 [==============================] - loss: 0.0255 - 81ms/step  
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/68
    Eval begin...
    step 14/14 [==============================] - loss: 0.0155 - 64ms/step  
    Eval samples: 547
    Epoch 70/100
    step 55/55 [==============================] - loss: 0.0295 - 81ms/step  
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/69
    Eval begin...
    step 14/14 [==============================] - loss: 0.0157 - 63ms/step  
    Eval samples: 547
    Epoch 71/100
    step 55/55 [==============================] - loss: 0.0170 - 87ms/step  
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/70
    Eval begin...
    step 14/14 [==============================] - loss: 0.0147 - 60ms/step  
    Eval samples: 547
    Epoch 72/100
    step 55/55 [==============================] - loss: 0.0114 - 82ms/step  
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/71
    Eval begin...
    step 14/14 [==============================] - loss: 0.0140 - 60ms/step  
    Eval samples: 547
    Epoch 73/100
    step 55/55 [==============================] - loss: 0.0200 - 85ms/step  
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/72
    Eval begin...
    step 14/14 [==============================] - loss: 0.0139 - 55ms/step  
    Eval samples: 547
    Epoch 74/100
    step 55/55 [==============================] - loss: 0.0211 - 77ms/step  
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/73
    Eval begin...
    step 14/14 [==============================] - loss: 0.0159 - 64ms/step  
    Eval samples: 547
    Epoch 75/100
    step 55/55 [==============================] - loss: 0.0373 - 78ms/step  
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/74
    Eval begin...
    step 14/14 [==============================] - loss: 0.0166 - 65ms/step  
    Eval samples: 547
    Epoch 76/100
    step 55/55 [==============================] - loss: 0.0091 - 76ms/step  
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/75
    Eval begin...
    step 14/14 [==============================] - loss: 0.0156 - 59ms/step  
    Eval samples: 547
    Epoch 77/100
    step 55/55 [==============================] - loss: 0.0278 - 78ms/step  
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/76
    Eval begin...
    step 14/14 [==============================] - loss: 0.0169 - 59ms/step  
    Eval samples: 547
    Epoch 78/100
    step 55/55 [==============================] - loss: 0.0211 - 77ms/step  
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/77
    Eval begin...
    step 14/14 [==============================] - loss: 0.0155 - 53ms/step  
    Eval samples: 547
    Epoch 79/100
    step 55/55 [==============================] - loss: 0.0331 - 78ms/step  
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/78
    Eval begin...
    step 14/14 [==============================] - loss: 0.0161 - 53ms/step  
    Eval samples: 547
    Epoch 80/100
    step 55/55 [==============================] - loss: 0.0164 - 82ms/step  
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/79
    Eval begin...
    step 14/14 [==============================] - loss: 0.0157 - 54ms/step  
    Eval samples: 547
    Epoch 81/100
    step 55/55 [==============================] - loss: 0.0190 - 79ms/step  
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/80
    Eval begin...
    step 14/14 [==============================] - loss: 0.0161 - 55ms/step  
    Eval samples: 547
    Epoch 82/100
    step 55/55 [==============================] - loss: 0.0247 - 76ms/step  
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/81
    Eval begin...
    step 14/14 [==============================] - loss: 0.0167 - 55ms/step  
    Eval samples: 547
    Epoch 83/100
    step 55/55 [==============================] - loss: 0.0198 - 78ms/step  
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/82
    Eval begin...
    step 14/14 [==============================] - loss: 0.0160 - 52ms/step  
    Eval samples: 547
    Epoch 84/100
    step 55/55 [==============================] - loss: 0.0205 - 84ms/step  
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/83
    Eval begin...
    step 14/14 [==============================] - loss: 0.0175 - 55ms/step  
    Eval samples: 547
    Epoch 85/100
    step 55/55 [==============================] - loss: 0.0164 - 76ms/step  
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/84
    Eval begin...
    step 14/14 [==============================] - loss: 0.0161 - 55ms/step  
    Eval samples: 547
    Epoch 86/100
    step 55/55 [==============================] - loss: 0.0214 - 76ms/step  
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/85
    Eval begin...
    step 14/14 [==============================] - loss: 0.0159 - 52ms/step  
    Eval samples: 547
    Epoch 87/100
    step 55/55 [==============================] - loss: 0.0098 - 81ms/step  
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/86
    Eval begin...
    step 14/14 [==============================] - loss: 0.0168 - 53ms/step  
    Eval samples: 547
    Epoch 88/100
    step 55/55 [==============================] - loss: 0.0207 - 86ms/step  
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/87
    Eval begin...
    step 14/14 [==============================] - loss: 0.0163 - 57ms/step  
    Eval samples: 547
    Epoch 89/100
    step 55/55 [==============================] - loss: 0.0111 - 77ms/step  
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/88
    Eval begin...
    step 14/14 [==============================] - loss: 0.0171 - 53ms/step  
    Eval samples: 547
    Epoch 90/100
    step 55/55 [==============================] - loss: 0.0175 - 81ms/step  
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/89
    Eval begin...
    step 14/14 [==============================] - loss: 0.0180 - 53ms/step  
    Eval samples: 547
    Epoch 91/100
    step 55/55 [==============================] - loss: 0.0201 - 83ms/step  
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/90
    Eval begin...
    step 14/14 [==============================] - loss: 0.0175 - 57ms/step  
    Eval samples: 547
    Epoch 92/100
    step 55/55 [==============================] - loss: 0.0101 - 78ms/step  
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/91
    Eval begin...
    step 14/14 [==============================] - loss: 0.0164 - 54ms/step  
    Eval samples: 547
    Epoch 93/100
    step 55/55 [==============================] - loss: 0.0335 - 77ms/step  
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/92
    Eval begin...
    step 14/14 [==============================] - loss: 0.0159 - 55ms/step  
    Eval samples: 547
    Epoch 94/100
    step 55/55 [==============================] - loss: 0.0439 - 80ms/step  
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/93
    Eval begin...
    step 14/14 [==============================] - loss: 0.0161 - 61ms/step  
    Eval samples: 547
    Epoch 95/100
    step 55/55 [==============================] - loss: 0.0210 - 80ms/step  
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/94
    Eval begin...
    step 14/14 [==============================] - loss: 0.0159 - 54ms/step  
    Eval samples: 547
    Epoch 96/100
    step 55/55 [==============================] - loss: 0.0297 - 77ms/step  
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/95
    Eval begin...
    step 14/14 [==============================] - loss: 0.0149 - 59ms/step  
    Eval samples: 547
    Epoch 97/100
    step 55/55 [==============================] - loss: 0.0305 - 76ms/step  
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/96
    Eval begin...
    step 14/14 [==============================] - loss: 0.0161 - 54ms/step  
    Eval samples: 547
    Epoch 98/100
    step 55/55 [==============================] - loss: 0.0230 - 76ms/step  
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/97
    Eval begin...
    step 14/14 [==============================] - loss: 0.0167 - 56ms/step  
    Eval samples: 547
    Epoch 99/100
    step 55/55 [==============================] - loss: 0.0353 - 82ms/step  
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/98
    Eval begin...
    step 14/14 [==============================] - loss: 0.0171 - 55ms/step  
    Eval samples: 547
    Epoch 100/100
    step 55/55 [==============================] - loss: 0.0188 - 75ms/step  
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/99
    Eval begin...
    step 14/14 [==============================] - loss: 0.0161 - 54ms/step  
    Eval samples: 547
    save checkpoint at /home/aistudio/car-behavioral-cloning-paddle/save/final


# **模型验证**
* 克隆本项目的 Github 代码到本地
* 模型保存至 ~/car-behavioral-cloning-paddle/save
* 将其中 final.pdparams 模型文件下载到本地
* 启动模拟器并选择第一个赛道启动自动驾驶模式
* 接着使用如下命令运行自动驾驶模型：
~~~shell
$ python drive.py final.pdparams
~~~
* 然后就可以看到车子自己在赛道里面跑了起来

# **总结**
* 这是五年前的一个自动驾驶的论文，针对模拟器环境很简单也很有效。
* 但是针对更加复杂的环境这样的方式就不太行得通了，需要更多的数据来源，更强大的模型和运算能力等等。
