## 1 项目说明

近几年，随着自动驾驶、车路协同等概念的日益火热，地图厂商、传统汽车厂商以及有互联网背景的“造车新势力”纷纷加入了智能升级的探索之路。为了使智能驾驶更安全更可靠，实现高精度、实时感知周围环境的技术至关重要，该技术不仅可以精准快速地识别车道线、行驶区域、行人、车辆等，而且将车辆行驶路线“画”在地面，为驾驶人员提供车距监测、行人预警、车道偏离提醒和红绿灯提醒等一系列安全辅助功能，助力驾驶系统进行高效的决策。
<center><img src='https://s1.ax1x.com/2022/03/14/bXtTSJ.png' width=600></center>

但在真实产业中，要实现高精度的驾驶环境感知不是一件容易的事，在实际的路况中存在着各种各样的问题：
* 摄像头采集到的图像会受到树木、建筑遮挡以及车辆移动的影响；
* 天气多种多样，要适应白天、黑夜、雾天和雨天等；
* 车道线磨损程度不一，且不同区域的车道线新旧对识别也有很大的影响。

针对上述场景，本次飞桨产业实践范例库基于真实场景中的车载影像数据，推出了目标检测和车道线分割多任务处理的智能驾驶感知实践示例，提供从数据准备、技术方案、模型训练优化，到模型部署的全流程可复用方案，有效解决了不同光照、不同天气等室外复杂环境下的目标识别问题，适用于AR地图导航、机器人教育、厂区自动巡检、自动驾驶等多个产业应用。



**方案难点**：

* **多任务运算：** 交通目标检测与车道线分割同时进行，相对于单一任务来说需要更多的算力和后处理方法；
* **精度与速度的均衡：** 原有的解决方案在V100上进行处理，本项目要将方案部署到手机端，需要在尽可能少减低精度的同时保证实时性；
* **跨平台迁移：** 将PaddleDetection和PaddleSeg中的模型转换到PaddleLite中，并部署到Android手机端，涉及到Python向C++与JAVA结合的工程落地；
* **端侧运行：** 成果最终以app的形式在手机中进行展示，并能够调用手机摄像头进行检测与分割，是一个完整的应用软件。

## 2 安装说明

**环境要求**
  ```
  PaddlePaddle == 2.2.1
  Python == 3.7
  PaddleDetection == 2.1
  PaddleSeg == 2.1
  ```

**首先从gitee或者github上下载PaddleDetection和PaddleSeg**
  ```
  git clone https://gitee.com/PaddlePaddle/PaddleDetection.git -b release/2.1
  git clone https://gitee.com/paddlepaddle/PaddleSeg.git -b release/2.1
  ```

**安装相关依赖**
  ```
  pip install paddledet==2.1.0 -i https://mirror.baidu.com/pypi/simple
  pip install paddleseg -i https://mirror.baidu.com/pypi/simple
  ```
## 3 数据准备

本范例使用数据集为[2021大数据竞赛全部训练集](https://aistudio.baidu.com/aistudio/datasetdetail/97737)，是百度地图提供的真实业务场景数据，共有16000张图片，使用json格式进行了标注：其中1~7类采用矩形检测框标注方法，8~10类采用分割连通域标注方法.
  

**具体分类标准如下**

<center><img src='https://ai-studio-static-online.cdn.bcebos.com/701d88eadf8a4d83a22c99f1ba853737026d289d44fa4a59842814e09202afe5' width=300></center>

**数据存储说明**

每个图像文件均对应一个同名的JSON文件，全部数据集格式为：

train，全部数据文件夹

- image，存放全部图片
  ```
  00001.jpg
  00002.jpg
  ......
  16000.jpg
  ```
- label，存放全部JSON文件
  ```
  00001.json
  00002.json
  ......
  16000.json
  ```

**JSON文件格式说明**

JSON文件以字典的形式保存每个检测目标或分割区域的信息，示例如下：

  ```
  [
     {
      "type": 1,       类别
      "x": 766,        bbox左上角点x
      "y": 384,        bbox左上角点y
      "width": 53,      bbox宽度
      "height": 45,     bbox高度
      "segmentation": [] 多边形点信息，检测目标为空
     },
     {
      "type": 8,
      "x": -1,
      "y": -1,
      "width": -1,
      "height": -1,
      "segmentation": [  多边形点信息，每两个数字组成一个点的位置，顺序为x，y
       [
        380.311,
        623.614,
        358.423,
        638.089,
        390.173,
        634.197,
        389.122,
        633.179
       ]
      ]
     }
   ]
  ```



## 4.模型选择

本项目不仅仅是提供一个完整的开发过程，也将对模型选择、优化思路进行说明。

**模型上选择的几个思考点**

  - 场景真：本项目中数据为真实交通场景，所以模型特征提取能力和泛化能力要强

  - 任务多：同时解决检测和分割两个任务，选模型和优化时要权衡精度与速度两方面。

  - 效率高：模型要尽量小、训练与预测速度要尽量快、且能够在平台上稳定运行

**检测模型的选择**

<center><img src='https://ai-studio-static-online.cdn.bcebos.com/eb96fd263fa846ccba76b632e8689155ae999d9437854f688a258b1aae85ec17' width=640></center>

如上图所示，第一阶段先选择[PPYOLOV2-R50vd](https://arxiv.org/abs/2104.10419)来作为检测基准模型。

**分割模型的选择**

<center><img src='https://ai-studio-static-online.cdn.bcebos.com/2a556cf61def4d9bbb0bc4895e6ed80b8b33a1b3e043400e9721a1a498a3fdc5' width=640></center>

如上图所示，第一阶段先选择[HarDNet](https://arxiv.org/abs/2104.10419)来作为检测基准模型。

## 5 检测模型训练、参数优化和消融实验

#### * 调整模型分辨率：
  ```
  608 (w) * 608(h)  ->  480(w) * 480(h)，训练采用多尺度
  ```
#### * 调整训练超参数：
  ```
  8卡V100 32GB BS12 Lr0.01  ->  1卡V100 32GB BS 6  Lr0.002 
  COCO 80类，训练365轮 -> BIGDATA 7类，先验性强，训练40轮
  ```
#### * 数据增强调整：
  ```
  RandomDistort   –  hue、saturation、contrast、brightness范围缩小到[0.8, 1.2]
  RandomExpand    –  ratio从4.0降到1.5
  RandomCrop     –  aspect_ratio调整到[0.8, 1.3]，scaling[0.7, 1.0]
  RandomResize    –  [384, 384] 到 [544, 544]，随机缩放算法
  Mixup         –  训练第36轮后取消Mixup用于提高检出结果的可靠性
  ```
#### * PAN结构优化：

<center><img src='https://ai-studio-static-online.cdn.bcebos.com/e842c402568b4bb38acecd90fbe601cf16e01987ee2a425785014c0d5141e9d3' width=900></center>

#### * 检测头Decoupled Head复现：
  ```
	Note： 在复现过程中，考虑到性能问题，删除了图中红色框部分的卷积层，可以将模型有效的缩小
  ```
<center><img src='https://ai-studio-static-online.cdn.bcebos.com/920b2473be184fe290598fa4daebd323612bdb279e6f4f73aa7c5ce75c313848' width=700></center>

#### * 模型优化消融实验：

  |     模型及方法     |       MAP @0.5      |     服务器预测帧率 FPS      |   模型占用空间大小   |
  | :--------------------: | :--------------------: | :---------------: | :------------: |
  |     PPYOLOV2-R50    |        0.81       |       52      |    240MB    |
  |    + 分辨率480 * 480  |        0.72 （-0.09）     |       78      |    239MB    |
  |    + 先验性数据增强   |       0.73  （+0.01）      |       78      |    239MB    |
  |    + DCN位置调整     |        0.75  （+0.02）      |       75      |    242MB    |
  |    + Reduced PAN     |        0.75  （+0.00）      |       86      |    188MB    |
  |   + Decoupled Head   |        0.77  （+0.02）      |       83      |    195MB    |



## 6 分割模型训练及参数优化

* 调整模型分辨率：
  ```
  1024 (w) * 1024(h)  ->  480(w) * 480(h)，训练采用多尺度（保持跟检测模型一样的分辨率）
  ```
* 调整训练超参数：
  ```
  1卡V100 32GB BS 4  Lr0.002 
  BIGDATA 3类，先验性强，训练10轮
  ```
* 数据增强调整：
  ```
  RandomBlur   –  prob 0.4
  RandomHrizontalFlip  –  prob 0.5
  RandomCrop      –   aspect_ratio调整到[0.8, 1.3]，scaling[0.7, 1.0]
  RandomDistort   –  hue、saturation、contrast、brightness范围缩小到[0.8, 1.2]
  ```

## 7 服务器端GPU模型推理部署及优化

**【基础版】Pipeline部署推理**

为了尽可能简单实现全流程，首先使用串行的流程进行处理：

<center><img src='https://ai-studio-static-online.cdn.bcebos.com/1243fb093d3e420c8e82a033fa2999264f55228f3a5b410bb212420b6e7b84e3' width=900></center>


**【优化版】Pipeline部署推理**

为了让两个任务能够尽可能达到最好的效率，做了如下多进程异步的设计：

<center><img src='https://ai-studio-static-online.cdn.bcebos.com/05b335d43b594f74be5632bd654dcbf2e1c8fffd351d4538a0e3a707cf3c99af' width=640></center>



**【推理结果】结果示例**

示例1：

<center><img src='https://ai-studio-static-online.cdn.bcebos.com/09a47a3a7c46443c91ae8de0b2f53ced2fd3a5eb751548d9a59d693c9f90d814' width=960></center>


示例2：

<center><img src='https://ai-studio-static-online.cdn.bcebos.com/4498f33c47d742a283dfd98f93faa1e3acd39712b33949958dcb6fa4ee8e5e73' width=960></center>





## 8 PaddleLite环境配置及模型转换


```python
# 安装paddle_lite_opt工具
!pip install paddlelite

# 基于前面export model的步骤，对模型再一次进行PaddleLite格式的转化
!cd /home/aistudio/work/model/

# 首先转换检测模型
!paddle_lite_opt --model_file=ppyolov2_r50vd_dcn_optimize/model.pdmodel --param_file=ppyolov2_r50vd_dcn_optimize/model.pdiparams --optimize_out=ppyolov2_r50vd_dcn_optimize

# 然后转换语义分割模型
!paddle_lite_opt --model_file=hardnet/model.pdmodel --param_file=hardnet/model.pdiparams --optimize_out=hardnet
```


## 9 安卓手机联调及推理部署

**【1】准备一台arm8的安卓手机，这里我使用了一台性能中上等的国产安卓手机**

&nbsp;

**【2】电脑上安装ADB工具，用于调试。 ADB安装方式如下：**

    2.1. MAC电脑安装ADB:

    ```shell
    brew cask install android-platform-tools
    ```
    2.2. Linux安装ADB
    ```shell
    sudo apt update
    sudo apt install -y wget adb
    ```
    2.3. Window安装ADB

    win上安装需要去谷歌的安卓平台下载ADB软件包进行安装：[链接](https://developer.android.com/studio)
    
&nbsp;

**【3】手机连接电脑后，开启手机`USB调试`选项，选择`文件传输`模式，在电脑终端中输入：**

```shell
adb devices
```
如果有device输出，则表示安装成功，如下所示：
```
List of devices attached
744be294    device
```

### 9.1 检测模型部署
1. 准备优化后的模型、预测库文件、测试图像和类别映射文件。

```shell
cd /home/aistudio/work/PaddleDetection/
cd deploy/lite/

# 将预测库文件、测试图像和使用的类别字典文件放置在预测库中的demo/cxx/detection文件夹下
inference_lite_path=/home/aistudio/work/PaddleDetection/deploy/lite/inference_lite_lib.android.armv8.clang.c++_static.with_extra/
mkdir -p  $inference_lite_path/demo/cxx/detection/debug/
cp /home/aistudio/work/model/ppyolov2_r50vd_dcn_optimize.nb $inference_lite_path/demo/cxx/detection/debug/
cp  ./yidaiyilu_label_list.txt  $inference_lite_path/demo/cxx/detection/debug/
cp Makefile run_detection.cc  $inference_lite_path/demo/cxx/detection/
cp ./config_ppyolov2_optimize.txt  $inference_lite_path/demo/cxx/detection/debug/
cp ../../demo/000000014439.jpg  $inference_lite_path/demo/cxx/detection/debug/
cp $inference_lite_path/cxx/lib/libpaddle_light_api_shared.so $inference_lite_path/demo/cxx/detection/debug/

```

执行完成后，detection文件夹下将有如下文件格式：

```
demo/cxx/detection/
|-- debug/
|   |--ppyolov2_r50vd_dcn_optimize.nb      优化后的检测器模型文件
|   |--000000014439.jpg                待测试图像
|   |--yidaiyilu_label_list.txt           类别映射文件
|   |--libpaddle_light_api_shared.so       C++预测库文件
|   |--config_ppyolov2_optimize.txt        检测模型预测超参数配置
|-- run_detection.cc                   目标检测代码文件
|-- Makefile                         编译文件
```

5. 启动调试，上述步骤完成后就可以使用ADB将文件夹 `debug/` push到手机上运行，步骤如下：

```shell
# 执行编译，得到可执行文件detect_system
# 如果是编译armv7的执行程序，需要使用 Makefile_armv7 替换 Makefile 文件
make

# 将编译得到的可执行文件移动到debug文件夹中
mv detect_system ./debug/

# 将上述debug文件夹push到手机上
adb push debug /data/local/tmp/

adb shell
cd /data/local/tmp/debug
export LD_LIBRARY_PATH=/data/local/tmp/debug:$LD_LIBRARY_PATH

# detect_system可执行文件的使用方式为:
# ./detect_system 配置文件路径  测试图像路径
./detect_system ./config_ppyolov2_optimize.txt ./000000014439.jpg
```

### 9.2 安卓手机app部署及视频流实时检测

**【目的】**：

	将基于 Paddle Lite 预测库的 Android APP 部署到手机，实现物体检测

&nbsp;

**【需要的环境】**： 

	Android Studio、Android 手机（开启 USB 调试模式）、下载到本地的 Paddle Lite Demo 工程

&nbsp;

**【预先要求】**：

	如果您的 Android Studio 尚未配置 NDK ，请根据 Android Studio 用户指南中的安装及配置 NDK 和 CMake 内容，预先配置好 NDK 。您可以选择最新的 NDK 版本，或者与 Linux x86 环境下编译适用于 Android 的库、macOS 环境下编译适用于 Android 的库 两个章节中的 NDK 版本保持一致。

&nbsp;

**【部署代码结构介绍】**：

![](https://ai-studio-static-online.cdn.bcebos.com/74a6f72f77374b84ab8af4e4f9c8ca0201a718474a13494b9da18deae217d171)

&nbsp;

**【Android Studio使用说明及编译方法】**

   [Android Studio使用说明及编译方法参见官方提供的样例](https://paddle-lite.readthedocs.io/zh/latest/demo_guides/android_app_demo.html)

&nbsp;

**【APK安装】**

	APK已经编译完成，可以下载工程中的lanedetection.apk进行安装。安装方法有：
    
    1. 使用Android Studio安装
    
    2. 使用adb install安装
 
 &nbsp;
   
 **【运行效果】**
 
<left><img src='https://ai-studio-static-online.cdn.bcebos.com/aefc5ed6417444c9b9f1c9ff0b2c6ef3dacc4314e5c0460591011c5f354cf058' width=400></left>
<right><img src='https://ai-studio-static-online.cdn.bcebos.com/6173dd68ad1e43cf9c00705532d43dc607f4ce4af98b4d73b40aea0d7a27a040' width=400></right>
 
 * 相关项目使用，参考aistudio
https://aistudio.baidu.com/aistudio/projectdetail/3619480?contributionType=1