# 基于SKEP预训练模型进行目标级情感分析

众所周知，人类自然语言中包含了丰富的情感色彩：表达人的情绪（如悲伤、快乐）、表达人的心情（如倦怠、忧郁）、表达人的喜好（如喜欢、讨厌）、表达人的个性特征和表达人的立场等等。情感分析在商品喜好、消费决策、舆情分析等场景中均有应用。利用机器自动分析这些情感倾向，不但有助于帮助企业了解消费者对其产品的感受，为产品改进提供依据；同时还有助于企业分析商业伙伴们的态度，以便更好地进行商业决策。

本实践将进行基于目标级的情感分析任务，与语句级别的情感分析不同，目标级的情感分析将对一句话中涉及的某个方面进行分析，如下面这句话所示。

>这个薯片口味有点咸，太辣了，不过口感很脆。

对于这句话来讲，显然关于薯片的口味方面是一个负向评价（咸，太辣），然而对于口感方面却是一个正向评价（很脆）。


为方便目标级别的情感分析任务建模，同样可将情感极性分为正向、负向、中性三个类别，从而将情感分析任务转变为一个分类问题，如图1所示：

- 正向： 表示正面积极的情感，如高兴，幸福，惊喜，期待等；
- 负向： 表示负面消极的情感，如难过，伤心，愤怒，惊恐等；
- 中性： 其他类型的情感；

<center><img src="https://ai-studio-static-online.cdn.bcebos.com/b630901b397e4e7a8e78ab1d306dfa1fc070d91015a64ef0b8d590aaa8cfde14" width="600" ></center>
<br><center>图1 情感分析任务</center></br>

本实践将基于预训练SKEP模型，在[seabsa16-phns](https://aistudio.baidu.com/aistudio/competition/detail/50/0/task-definition)
数据集上进行目标级别的情感分析任务。

## 1. 方案设计

本实践的设计思路如图2所示，SKEP模型的输入有两部分，一部分是要评价的对象(Aspect)，另一个方面是相应的评论文本。将两者拼接之后便可以传入SKEP模型中，SKEP模型对该文本串进行语义编码后，本实践将CLS位置的token输出向量作为最终的语义编码向量。接下来将根据该语义编码向量进行情感分类。需要注意的是：[seabsa16-phns](https://aistudio.baidu.com/aistudio/competition/detail/50/0/task-definition)数据集是个二分类数据集，其情感极性只包含正向和负向两个类别。

<center><img src="https://ai-studio-static-online.cdn.bcebos.com/1a4b76447dae404caa3bf123ea28e375179cb09a02de4bef8a2f172edc6e3c8f" /></center>
<br><center>图2 目标级情感分析建模图</center><br/>


## 2. 数据说明
本实践将在数据集[seabsa16-phns](https://aistudio.baidu.com/aistudio/competition/detail/50/0/task-definition)进行情感分析任务。该数据集是个目标级别的情感分析数据集，其中训练集包含1334条训练样本，529条测试样本。下面展示了该数据集中的一条样本：

```
{

    "label":1
    "text":"display#quality",
    "text_pair":"今天有幸拿到了港版白色iPhone 5真机，试玩了一下，说说感受吧：1. 真机尺寸宽度与4/4s保持一致没有变化，长度多了大概一厘米，也就是之前所说的多了一排的图标。2. 真机重量比上一代轻了很多，个人感觉跟i9100的重量差不多。（用惯上一代的朋友可能需要一段时间适应了）3. 由于目前还没有版的SIM卡，无法插卡使用，有购买的朋友要注意了，并非简单的剪卡就可以用，而是需要去运营商更换新一代的SIM卡。4. 屏幕显示效果确实比上一代有进步，不论是从清晰度还是不同角度的视角，iPhone 5绝对要更上一层，我想这也许是相对上一代最有意义的升级了。5. 新的数据接口更小，比上一代更好用更方便，使用的过程会有这样的体会。6. 从简单的几个操作来讲速度比4s要快，这个不用测试软件也能感受出来，比如程序的调用以及照片的拍摄和浏览。不过，目前水货市场上坑爹的价格，最好大家可以再观望一下，不要急着出手。",

}

```

## 3. 使用说明
### 3.1 模型训练
使用如下命令进行目标级情感分析模型训练。

```shell
sh run_train.sh
```

### 3.2 模型推理
使用如下命令进行目标级情感分析模型推理。

```shell
sh run_predict.sh
```
