# 基于BiLSTM+CRF进行航班意图分析

意图识别是指分析用户的核心需求，输出与查询输入最相关的信息，例如在搜索中要找电影、查快递、市政办公等需求，这些需求在底层的检索策略会有很大的不同，错误的识别几乎可以确定找不到能满足用户需求的内容，导致产生非常差的用户体验；在对话过程中要准确理解对方所想表达的意思，这是具有很大挑战性的任务。

例如用户输入查询“仙剑奇侠传”时，我们知道“仙剑奇侠传”既有游戏又有电视剧还有新闻、图片等等，如果我们通过用户意图识别发现该用户是想看“仙剑奇侠传”电视剧的，那我们直接把电视剧作为结果返回给用户，就会节省用户的搜索点击次数，缩短搜索时间，大大提升使用体验。而在对话中如果对方说“我的苹果从不出现卡顿”，那么我们就能通过意图识别判断出此刻的苹果是一个电子设备，而非水果，这样对话就能顺利进行下去。

**本案例应用深度学习的BiLSTM+CRF技术，针对用户航班预订的请求，通过联合学习的方式同时进行意图识别和槽位抽取，从而实现用户航班请求的意图分析。**

## 1. 方案设计
本实践将基于BiLSTM+CRF的结构来实现意图分析任务，模型的输入是一串航班请求的文本，模型的输出是请求的意图识别和槽位标签。

在建模过程中，对于输入的待分析文本，首先需要进行数据处理生成规整的文本序列数据，包括**语句分词**、**将词转换为id**，**过长文本截断**、**过短文本填充**等等操作；然后，将文本序列传入到双向的LSTM模型中，这样在LSTM每个时间步骤都能获得一个与输入对应的向量，选择最后时间步骤的一个向量进行意图识别得到改文本请求的意图。然后将这些向量传入全连接层，将会得到一个被称为"发射分数"的向量。最后，将这个发射分数传给条件随机场CRF，CRF会根据这个"发射分数"进行解码，得到该输入对应的槽位标签。

## 2. 数据说明
ATIS (Airline Travel Information Systems)是一份预订航班时的语音记录数据集，经常被用在SLU (Spoken Language Understanding，SLU)领域。ATIS数据集有很多变体，本实验使用ATIS的文本语料数据集，使用BiLSTM+CRF模型分析这些客户在预订航班时的意图。ATIS文本语料数据集共包含4978条训练数据和893条测试数据。

其中单条样本的格式如下所示：
```
{
    "text": "what are all the flights from boston to dallas",
    "intent": "flight",
    "entities": [
        {
            "start": 30,
            "end": 36,
            "value": "boston",
            "entity": "fromloc.city_name"
         },
         {
            "start": 40,
            "end": 46,
            "value": "dallas",
            "entity": "toloc.city_name"
          }
    ]
}
```

## 3. 使用说明
### 3.1 模型训练
使用如下命令，进行模型训练。

```shell
 python train.py
```

### 3.2 模型测试
使用如下命令，进行模型测试。

```shell
 python evaluate.py --model_path ./checkpoint/jointModel_e50.pdparams
```

### 3.3 模型推理
使用如下命令，进行模型推理。
```shell
python predict.py --model_path ./checkpoint/jointModel_e50.pdparams
```
