# 5.6. GPU
在 表1.5.1 中，我们讨论了过去20年中计算能力的快速增长。简而言之，自2000年以来，GPU性能每十年增长1000倍。这提供了巨大的机会，但也表明需要提供这样的性能。

在本节中，我们开始讨论如何利用这种计算性能进行研究。首先是使用单个GPU，然后是如何使用多个GPU和多个服务器（具有多个GPU）。

具体来说，我们将讨论如何使用单个NVIDIA GPU进行计算。首先，确保至少安装了一个NVIDIA GPU。然后，下载NVIDIA驱动和CUDA并按照提示设置适当的路径。当这些准备工作完成，就可以使用nvidia-smi命令来查看显卡信息。


```python
!nvidia-smi
```

    Fri Aug  6 23:48:38 2021       
    +-----------------------------------------------------------------------------+
    | NVIDIA-SMI 460.32.03    Driver Version: 460.32.03    CUDA Version: 11.2     |
    |-------------------------------+----------------------+----------------------+
    | GPU  Name        Persistence-M| Bus-Id        Disp.A | Volatile Uncorr. ECC |
    | Fan  Temp  Perf  Pwr:Usage/Cap|         Memory-Usage | GPU-Util  Compute M. |
    |                               |                      |               MIG M. |
    |===============================+======================+======================|
    |   0  GeForce RTX 208...  On   | 00000000:04:00.0 Off |                  N/A |
    | 22%   26C    P8    12W / 250W |      1MiB / 11019MiB |      0%      Default |
    |                               |                      |                  N/A |
    +-------------------------------+----------------------+----------------------+
    |   1  GeForce RTX 208...  On   | 00000000:85:00.0 Off |                  N/A |
    | 22%   35C    P8    22W / 250W |      1MiB / 11019MiB |      0%      Default |
    |                               |                      |                  N/A |
    +-------------------------------+----------------------+----------------------+
                                                                                   
    +-----------------------------------------------------------------------------+
    | Processes:                                                                  |
    |  GPU   GI   CI        PID   Type   Process name                  GPU Memory |
    |        ID   ID                                                   Usage      |
    |=============================================================================|
    |  No running processes found                                                 |
    +-----------------------------------------------------------------------------+


在Paddle中，每个数组都有一个设备（device），我们通常将其称为上下文（context）。到目前为止，默认情况下，所有变量和相关的计算都分配给CPU。有时上下文可能是GPU。当我们跨多个服务器部署作业时，事情会变得更加棘手。通过智能地将数组分配给上下文，我们可以最大限度地减少在设备之间传输数据的时间。例如，当在带有GPU的服务器上训练神经网络时，我们通常希望模型的参数在GPU上。

接下来，我们需要确认安装了GPU版本的Paddle。如果已经安装了Paddle的CPU版本，我们需要先卸载它。例如，使用pip uninstall torch命令，然后根据你的CUDA版本安装相应的PyTorch版本。假设你安装了CUDA10.0，你可以通过
python -m pip install paddlepaddle-gpu==0.0.0.post101 -f https://www.paddlepaddle.org.cn/whl/windows/gpu/develop.html
安装支持CUDA10.0的Paddle版本。

要运行此部分中的程序，至少需要两个GPU。注意，对于大多数桌面计算机来说，这可能是奢侈的，但在云中很容易获得，例如，通过使用AWS EC2的多GPU实例。本书的其他章节大都不需要多个GPU，所以本节只是为了展示数据如何在不同的设备之间传递。

在Paddleh中，CPU和GPU可以用paddle.device.set_device('cpu')和paddle.device.set_device('gpu')表示。应该注意的是，cpu设备意味着所有物理CPU和内存。这意味着Paddle的计算将尝试使用所有CPU核心。然而，gpu设备只代表一个卡和相应的显存。如果有多个GPU，我们使用paddle.device.get_device()来表示第 i 块GPU（ i 从0开始）。


```python
import paddle
```


```python
paddle.device.set_device("cpu"),paddle.CUDAPlace(0),paddle.CUDAPlace(1)
```

    /root/miniconda3/envs/myconda/lib/python3.7/site-packages/ipykernel/ipkernel.py:283: DeprecationWarning: `should_run_async` will not call `transform_cell` automatically in the future. Please pass the result to `transformed_cell` argument and any exception that happen during thetransform in `preprocessing_exc_tuple` in IPython 7.17 and above.
      and should_run_async(code)





    (CPUPlace, CUDAPlace(0), CUDAPlace(1))



我们可以查询可用gpu的数量。


```python
len(paddle.static.cuda_places())
```




    2



现在我们定义了两个方便的函数，这两个函数允许我们在请求的GPU不存在的情况下运行代码。


```python
def try_gpu(i=0):  #@save
    """如果存在，则返回gpu(i)，否则返回cpu()。"""
    if len(paddle.static.cuda_places())>= i + 1:
        return paddle.device.get_device()
    return paddle.device.set_device("cpu")

def try_all_gpus():  #@save
    """返回所有可用的GPU，如果没有GPU，则返回[cpu(),]。"""
    devices = [paddle.device.get_device()
               for i in range(len(paddle.static.cuda_places()))
               ]
    return devices if devices else paddle.device.get_device()

try_gpu(),try_gpu(10),try_all_gpus()
```




    ('cpu', CPUPlace, ['cpu', 'cpu'])



# 5.6.2. 张量与gpu
默认情况下，张量是在CPU上创建的。我们可以查询张量所在的设备

需要注意的是，无论何时我们要对多个项进行操作，它们都必须在同一个设备上。例如，如果我们对两个张量求和，我们需要确保两个张量都位于同一个设备上，否则框架将不知道在哪里存储结果，甚至不知道在哪里执行计算。


```python
x = paddle.to_tensor([1, 2, 3])
x.cuda()
```




    Tensor(shape=[3], dtype=int64, place=CUDAPlace(0), stop_gradient=True,
           [1, 2, 3])



# 5.6.2.1. 存储在GPU上
有几种方法可以在GPU上存储张量。例如，我们可以在创建张量时指定存储设备。接下来，我们在第一个gpu上创建张量变量X。在GPU上创建的张量只消耗这个GPU的显存。我们可以使用nvidia-smi命令查看显存使用情况。一般来说，我们需要确保不创建超过GPU显存限制的数据。


```python
paddle.device.set_device("gpu:0")
X = paddle.ones(shape=[2, 3])
X
```




    Tensor(shape=[2, 3], dtype=float32, place=CUDAPlace(0), stop_gradient=True,
           [[1., 1., 1.],
            [1., 1., 1.]])



假设你至少有两个GPU，下面的代码将在第二个GPU上创建一个随机张量。


```python
paddle.device.set_device("gpu:1")
Y = paddle.rand([2, 3])
Y
```




    Tensor(shape=[2, 3], dtype=float32, place=CUDAPlace(1), stop_gradient=True,
           [[0.25106877, 0.34006062, 0.06665020],
            [0.27161157, 0.96259201, 0.27771869]])



# 5.6.2.2. 复制
如果我们要计算X + Y，我们需要决定在哪里执行这个操作。例如，如 图5.6.1 所示，我们可以将X传输到第二个GPU并在那里执行操作。 不要简单地X加上Y， 因为这会导致异常。运行时引擎不知道该怎么做：它在同一设备上找不到数据会导致失败。由于Y位于第二个GPU上，所以我们需要将X移到那里，然后才能执行相加运算。



![](https://ai-studio-static-online.cdn.bcebos.com/58e48213dd324e9588bca661ca729d91d70691f181914bb49b23c8c1a594d57c)



```python
Z=X.cuda(1)
print(X)
print(Z)
```

    Tensor(shape=[2, 3], dtype=float32, place=CUDAPlace(0), stop_gradient=True,
           [[1., 1., 1.],
            [1., 1., 1.]])
    Tensor(shape=[2, 3], dtype=float32, place=CUDAPlace(1), stop_gradient=True,
           [[1., 1., 1.],
            [1., 1., 1.]])


现在数据在同一个GPU上（Z和Y都在），我们可以将它们相加。


```python
paddle.device.set_device("gpu:1")
print(Y + Z)
```

    Tensor(shape=[2, 3], dtype=float32, place=CUDAPlace(1), stop_gradient=True,
           [[1.25106883, 1.34006059, 1.06665015],
            [1.27161157, 1.96259201, 1.27771866]])


假设变量Z已经存在于第二个GPU上。如果我们还是调用Z.cuda(1)怎么办？它将返回Z，而不会复制并分配新内存。


```python
paddle.device.set_device("gpu:1")
Z is Z
```




    True



# 5.6.2.3. 旁注
人们使用GPU来进行机器学习，因为他们希望运行速度快。但是在设备之间传输变量是缓慢的。所以我们希望你百分之百确定你想做一些缓慢的事情。如果深度学习框架只是自动复制而没有崩溃，那么你可能不会意识到你已经编写了一些缓慢的代码。

此外，在设备（CPU、GPU和其他机器）之间传输数据比计算慢得多。这也使得并行化变得更加困难，因为我们必须等待数据被发送（或者接收），然后才能继续进行更多的操作。这就是为什么拷贝操作要格外小心。根据经验，多个小操作比一个大操作糟糕得多。此外，除非你知道自己在做什么，否则，一次执行几个操作比代码中散布的许多单个操作要好得多。如果一个设备必须等待另一个设备才能执行其他操作，那么这样的操作可能会阻塞。这有点像排队订购咖啡，而不像通过电话预先订购时，当你在的时候发现咖啡已经准备好了。

最后，当我们打印张量或将张量转换为NumPy格式时，如果数据不在内存中，框架会首先将其复制到内存中，这会导致额外的传输开销。更糟糕的是，它现在受制于可怕的全局解释器锁，这使得一切都得等待Python完成。

# 5.6.3. 神经网络与GPU
类似地，神经网络模型可以指定设备。下面的代码将模型参数放在GPU上


```python
import paddle 
import paddle.nn as nn
paddle.device.set_device("gpu:0")
net = nn.Sequential(nn.Linear(3, 1))
```

在接下来的几章中，我们将看到更多关于如何在GPU上运行模型的例子，因为它们将变得更加计算密集。

当输入为GPU上的张量时，模型将在同一GPU上计算结果


```python
net(X)
```




    Tensor(shape=[2, 1], dtype=float32, place=CUDAPlace(0), stop_gradient=False,
           [[-1.15389061],
            [-1.15389061]])



让我们确认模型参数存储在同一个GPU上。


```python
net[0].weight
```




    Parameter containing:
    Tensor(shape=[3, 1], dtype=float32, place=CUDAPlace(0), stop_gradient=False,
           [[ 0.63211048],
            [-0.69075739],
            [-1.09524369]])



总之，只要所有的数据和参数都在同一个设备上，我们就可以有效地学习模型。在下面的章节中，我们将看到几个这样的例子。

# 5.6.4. 小结

* 我们可以指定用于存储和计算的设备，例如CPU或GPU。默认情况下，数据在主内存中创建，然后使用CPU进行计算。
* 深度学习框架要求计算的所有输入数据都在同一设备上，无论是CPU还是GPU。
* 不经意地移动数据可能会显著降低性能。一个典型的错误如下：计算GPU上每个小批量的损失，并在命令行中将其报告给用户（或将其记录在NumPy ndarray中）时，将触发全局解释器锁，从而使所有GPU阻塞。最好是为GPU内部的日志分配内存，并且只移动较大的日志。

# 5.6.5. 练习
尝试一个更大的计算任务，比如大矩阵的乘法，看看CPU和GPU之间的速度差异。一个计算量很小的任务呢？
我们应该如何在GPU上读写模型参数？
测量计算1000个 100×100 矩阵的矩阵乘法所需的时间，并记录输出矩阵的弗罗贝尼乌斯范数，一次记录一个结果，而不是在GPU上保存日志并仅传输最终结果。
测量同时在两个GPU上执行两个矩阵乘法与在一个GPU上按顺序执行两个矩阵乘法所需的时间。提示：你应该看到近乎线性的缩放。
