```python
!pip install -U d2l
!python -m pip install paddlepaddle -i https://mirror.baidu.com/pypi/simple
```

# 3.7. softmax回归的简洁实现

在 3.3节中，我们可以发现通过深度学习框架的高级API能够使实现

线性回归变得更加容易。同样地，通过深度学习框架的高级API也能更方便地实现分类模型。让我们继续使用Fashion-MNIST数据集，并保持批量大小为256，就像在 3.6节中一样。
#### torch版


```python
import torch
from torch import nn
from d2l import torch as d2l


batch_size = 256
train_iter, test_iter = d2l.load_data_fashion_mnist(batch_size)
```

#### paddle版


```python
import paddle
def paddle_load_data_fashion_mnist(batch_size, resize=None):
    """下载Fashion-MNIST数据集，然后将其加载到内存中。"""
    trans = [transforms.ToTensor()]
    if resize:
        trans.insert(0, transforms.Resize(resize))
    trans = transforms.Compose(trans)
    paddle_transform = T.Compose([T.Normalize(mean=[127.5],std=[127.5],data_format='CHW')])
    paddle_train = paddle.vision.datasets.FashionMNIST(mode='train', transform=paddle_transform)
    paddle_test = paddle.vision.datasets.FashionMNIST(mode='test', transform=paddle_transform)
    return (paddle.io.DataLoader(paddle_train, batch_size, shuffle=True,
                            num_workers=paddle_get_dataloader_workers()),
            paddle.io.DataLoader(paddle_test, batch_size, shuffle=False,
                            num_workers=paddle_get_dataloader_workers()))
```


```python
paddle_train_iter, paddle_test_iter = d2l.load_data_fashion_mnist(batch_size)
```

## 3.7.1 初始化模型参数
如我们在 3.4节所述，softmax回归的输出层是一个全连接层。因此，为了实现我们的模型，我们只需在Sequential中添加一个带有10个输出的全连接层。同样，在这里，Sequential并不是必要的，但我们可能会形成这种习惯。因为在实现深度模型时，Sequential将无处不在。我们仍然以均值0和标准差0.01随机初始化权重。

#### torch版


```python
# PyTorch不会隐式地调整输入的形状。因此，
# 我们在线性层前定义了展平层（flatten），来调整网络输入的形状
net = nn.Sequential(nn.Flatten(), nn.Linear(784, 10))

def init_weights(m):
    if type(m) == nn.Linear:
        nn.init.normal_(m.weight, std=0.01)

net.apply(init_weights);
```

#### paddle版


```python
paddle_net = paddle.nn.Sequential(paddle.nn.Flatten(), paddle.nn.Linear(784, 10))

def init_weights(m):
    if type(m) == paddle.nn.Linear:
        paddle.nn.initializer.Normal(m.weight, std=0.01)

paddle_net.apply(init_weights);
```

#### torch版


```python
loss = nn.CrossEntropyLoss()

```

#### paddle版


```python
paddle_loss = paddle.nn.CrossEntropyLoss()
```

## 3.7.3 优化算法

#### torch版


```python
trainer = torch.optim.SGD(net.parameters(), lr=0.1)
```

#### paddle版


```python
paddle_trainer = paddle.optimizer.SGD(learning_rate=0.1,parameters=paddle_net.parameters())
```

## 3.7.4 训练

#### torch版


```python
num_epochs = 10
d2l.train_ch3(net, train_iter, test_iter, loss, num_epochs, trainer)
```

#### paddle版


```python
num_epochs = 10

class Animator:
    """在动画中绘制数据。"""
    def __init__(self, xlabel=None, ylabel=None, legend=None, xlim=None,
                 ylim=None, xscale='linear', yscale='linear',
                 fmts=('-', 'm--', 'g-.', 'r:'), nrows=1, ncols=1,
                 figsize=(3.5, 2.5)):
        # 增量地绘制多条线
        if legend is None:
            legend = []
        d2l.use_svg_display()
        self.fig, self.axes = d2l.plt.subplots(nrows, ncols, figsize=figsize)
        if nrows * ncols == 1:
            self.axes = [self.axes, ]
        # 使用lambda函数捕获参数
        self.config_axes = lambda: d2l.set_axes(
            self.axes[0], xlabel, ylabel, xlim, ylim, xscale, yscale, legend)
        self.X, self.Y, self.fmts = None, None, fmts

    def add(self, x, y):
        # 向图表中添加多个数据点
        if not hasattr(y, "__len__"):
            y = [y]
        n = len(y)
        if not hasattr(x, "__len__"):
            x = [x] * n
        if not self.X:
            self.X = [[] for _ in range(n)]
        if not self.Y:
            self.Y = [[] for _ in range(n)]
        for i, (a, b) in enumerate(zip(x, y)):
            if a is not None and b is not None:
                self.X[i].append(a)
                self.Y[i].append(b)
        self.axes[0].cla()
        for x, y, fmt in zip(self.X, self.Y, self.fmts):
            self.axes[0].plot(x, y, fmt)
        self.config_axes()
        display.display(self.fig)
        display.clear_output(wait=True)
```
