```python
!pip install -U d2l
!python -m pip install paddlepaddle -i https://mirror.baidu.com/pypi/simple
```

# 3.5 图像分类数据集




```python
import torch
import torchvision
from torch.utils import data
from torchvision import transforms
from d2l import torch as d2l
import paddle
import matplotlib.pyplot as plt
import numpy as np
```

## 3.5.1 读取数据集
可以通过框架中的内置函数将Fashion-MNIST数据集下载并读取到内存中。

#### torch版


```python
# 通过ToTensor实例将图像数据从PIL类型变换成32位浮点数格式
# 并除以255使得所有像素的数值均在0到1之间
trans = transforms.ToTensor()
mnist_train = torchvision.datasets.FashionMNIST(
    root="../data", train=True, transform=trans, download=True)
mnist_test = torchvision.datasets.FashionMNIST(
    root="../data", train=False, transform=trans, download=True)
```

Fashion-MNIST由10个类别的图像组成，每个类别由训练数据集中的6000张图像和测试数据集中的1000张图像组成。测试数据集（test dataset）不会用于训练，只用于评估模型性能。训练集和测试集分别包含60000和10000张图像。


```python
len(mnist_train),len(mnist_test)
```

每个输入图像的高度和宽度均为28像素。数据集由灰度图像组成，其通道数为1。为了简洁起见，在这本书中，我们将高度 ℎ 像素，宽度 𝑤 像素图像的形状记为 ℎ×𝑤或（ ℎ, 𝑤）。


```python
mnist_train[0][0].shape
```

Fashion-MNIST中包含的10个类别分别为t-shirt（T恤）、trouser（裤子）、pullover（套衫）、dress（连衣裙）、coat（外套）、sandal（凉鞋）、shirt（衬衫）、sneaker（运动鞋）、bag（包）和ankle boot（短靴）。以下函数用于在数字标签索引及其文本名称之间进行转换。


```python
def get_fashion_mnist_labels(labels):
    """返回Fashion-MNIST数据集的文本标签。"""
    text_labels = ['t-shirt', 'trouser', 'pullover', 'dress', 'coat','sandal', 'shirt', 'sneaker', 'bag', 'ankle boot']
    return [text_labels[int(i)] for i in labels]
```

可以创建函数来可视化这些样本


```python
def show_images(imgs, num_rows, num_cols, titles=None, scale=1.5):
    """Plot a list of images."""
    figsize = (num_cols * scale, num_rows * scale)
    _, axes = d2l.plt.subplots(num_rows, num_cols, figsize=figsize)
    axes = axes.flatten()
    for i, (ax, img) in enumerate(zip(axes, imgs)):
        if torch.is_tensor(img):
            # 图片张量
            ax.imshow(img.numpy())
        else:
            # PIL图片
            ax.imshow(img)
        ax.axes.get_xaxis().set_visible(False)
        ax.axes.get_yaxis().set_visible(False)
        if titles:
            ax.set_title(titles[i])
    return axes
```

以下是训练数据集前几个样本的图像及其对应标签（文本形式）


```python
X, y = next(iter(data.DataLoader(mnist_train, batch_size=18)))
print(X.shape)
show_images(X.reshape(18, 28, 28), 2, 9, titles=get_fashion_mnist_labels(y));
```

#### paddle版


```python

import paddle.vision.transforms as T
paddle_transform = T.Compose([T.Normalize(mean=[127.5],std=[127.5],data_format='CHW')])
paddle_train = paddle.vision.datasets.FashionMNIST(mode='train', transform=paddle_transform)
paddle_test = paddle.vision.datasets.FashionMNIST(mode='test', transform=paddle_transform)
print(len(paddle_train))
print(len(paddle_test))
print(paddle_train[0][0].shape)
```


```python
def paddle_show_images(imgs, num_rows, num_cols, titles=None, scale=1.5):
    """Plot a list of images."""
    figsize = (num_cols * scale, num_rows * scale)
    _, axes = plt.subplots(num_rows, num_cols, figsize=figsize)
    axes = axes.flatten()
    for i, (ax, img) in enumerate(zip(axes, imgs)):
        if paddle.is_tensor(img):
            # 图片张量
            ax.imshow(img.numpy())
        else:
            # PIL图片
            ax.imshow(img)
        ax.axes.get_xaxis().set_visible(False)
        ax.axes.get_yaxis().set_visible(False)
        if titles:
            ax.set_title(titles[i])
    return axes
```


```python
from paddle.io import DataLoader
paddle_X, paddle_y = next(iter(DataLoader(paddle_train,batch_size=18)))
paddle_show_images(paddle_X.reshape((18, 28, 28)), 2, 9, titles=get_fashion_mnist_labels(paddle_y));
```

## 3.5 2 读取小批量
为了使我们在读取训练集和测试集时更容易，我们使用内置的数据迭代器，而不是从零开始创建一个。 回顾一下，在每次迭代中，数据加载器每次都会读取一小批量数据，大小为batch_size。我们在训练数据迭代器中还随机打乱了所有样本。

#### torch版


```python
batch_size = 256

def get_dataloader_workers():
    """使用4个进程来读取数据。"""
    return 4

train_iter = data.DataLoader(mnist_train, batch_size, shuffle=True,num_workers=get_dataloader_workers())
```

看一下读取训练数据所需时间：


```python
timer = d2l.Timer()
for X,y in train_iter:
  continue
f'{timer.stop():.2f} sec'
```

#### paddle版


```python
import time
class Timer:
  """Record multiple running times."""

  def __init__(self):
    self.times = []
    self.start()

  def start(self):
    """Start the timer."""
    self.tik = time.time()

  def stop(self):
    """Stop the timer and record the time in a list."""
    self.times.append(time.time() - self.tik)
    return self.times[-1]

  def avg(self):
    """Return the average time."""
    return sum(self.times) / len(self.times)

  def sum(self):
    """Return the sum of time."""
    return sum(self.times)

  def cumsum(self):
    """Return the accumulated time."""
    return np.array(self.times).cumsum().tolist()
```


```python
batch_size = 256

def paddle_get_dataloader_workers():
    """使用4个进程来读取数据。"""
    return 4

paddle_train_iter = paddle.io.DataLoader(paddle_train, batch_size, shuffle=True,num_workers=paddle_get_dataloader_workers())
paddle_train_iter
```


```python
paddle_timer = Timer()
for iter_id, data in enumerate(paddle_train_iter()):
  X,y = data
  continue
f'{timer.stop():.2f} sec'
```

## 3.5.3 整合所有组件

3.5.3. 整合所有组件
现在我们定义load_data_fashion_mnist函数，用于获取和读取Fashion-MNIST数据集。它返回训练集和验证集的数据迭代器。此外，它还接受一个可选参数，用来将图像大小调整为另一种形状。

### torch版


```python
def load_data_fashion_mnist(batch_size, resize=None):
    """下载Fashion-MNIST数据集，然后将其加载到内存中。"""
    trans = [T.Compose([T.Normalize(mean=[127.5],std=[127.5],data_format='CHW')])]
    if resize:
        trans.insert(0, transforms.Resize(resize))
    trans = transforms.Compose(trans)
    mnist_train = torchvision.datasets.FashionMNIST(
        root="../data", train=True, transform=trans, download=True)
    mnist_test = torchvision.datasets.FashionMNIST(
        root="../data", train=False, transform=trans, download=True)
    return (data.DataLoader(mnist_train, batch_size, shuffle=True,
                            num_workers=get_dataloader_workers()),
            data.DataLoader(mnist_test, batch_size, shuffle=False,
                            num_workers=get_dataloader_workers()))
```

下面，我们通过指定resize参数来测试load_data_fashion_mnist函数的图像大小调整功能。


```python
train_iter, test_iter = load_data_fashion_mnist(32, resize=64)
for X, y in train_iter:
    print(X.shape, X.dtype, y.shape, y.dtype)
    break
```

我们现在已经准备好在下面的章节中使用Fashion-MNIST数据集。

### paddle版


```python
def paddle_load_data_fashion_mnist(batch_size, resize=None):
    """下载Fashion-MNIST数据集，然后将其加载到内存中。"""
    trans = [transforms.ToTensor()]
    if resize:
        trans.insert(0, transforms.Resize(resize))
    trans = transforms.Compose(trans)
    paddle_transform = T.Compose([T.Normalize(mean=[127.5],std=[127.5],data_format='CHW')])
    paddle_train = paddle.vision.datasets.FashionMNIST(mode='train', transform=paddle_transform)
    paddle_test = paddle.vision.datasets.FashionMNIST(mode='test', transform=paddle_transform)
    return (paddle.io.DataLoader(paddle_train, batch_size, shuffle=True,
                            num_workers=paddle_get_dataloader_workers()),
            paddle.io.DataLoader(paddle_test, batch_size, shuffle=False,
                            num_workers=paddle_get_dataloader_workers()))
```


```python

```
