# 2.7. 查阅文档


由于本书篇幅的限制，我们不可能介绍每一个PaddlePaddle函数和类（你可能也不希望我们这样做）。API文档、其他教程和示例提供了本书之外的大量文档。在本节中，我们为你提供了一些查看PaddlePaddle API的指导。


## 2.7.1. 查找模块中的所有函数和类

为了知道模块中可以调用哪些函数和类，我们调用 `dir` 函数。例如，我们可以(**查询随机数生成模块中的所有属性：**)



```python
import paddle

print(dir(paddle.distribution))
```

    ['Categorical', 'Distribution', 'Normal', 'Uniform', '__all__', '__builtins__', '__cached__', '__doc__', '__file__', '__loader__', '__name__', '__package__', '__spec__', 'arange', 'check_dtype', 'check_type', 'check_variable_and_dtype', 'concat', 'control_flow', 'convert_dtype', 'core', 'elementwise_add', 'elementwise_div', 'elementwise_mul', 'elementwise_sub', 'gather_nd', 'in_dygraph_mode', 'math', 'multinomial', 'nn', 'np', 'ops', 'print_function', 'tensor', 'warnings']


通常，我们可以忽略以 `__` 开始和结束的函数（Python 中的特殊对象）或以单个 `_` 开始的函数（通常是内部函数）。根据剩余的函数名或属性名，我们可能会猜测这个模块提供了各种生成随机数的方法，包括从均匀分布（`uniform`）、正态分布 （`normal`）和多项分布（`multinomial`）中采样。

## 2.7.2. 查找特定函数和类的用法

有关如何使用给定函数或类的更具体说明，我们可以调用 `help` 函数。例如，我们来[**查看张量 `ones` 函数的用法。**]



```python
help(paddle.ones)
```

    Help on function ones in module paddle.tensor.creation:
    
    ones(shape, dtype=None, name=None)
        The OP creates a tensor of specified :attr:`shape` and :attr:`dtype`, and fills it with 1.
        
        Args:
            shape(tuple|list|Tensor): Shape of the Tensor to be created, the data type of shape is int32 or int64.
            dtype(np.dtype|str, optional): Data type of output Tensor, it supports
                bool, float16, float32, float64, int32 and int64. Default: if None, the data type is 'float32'.
            name(str, optional): The default value is None. Normally there is no need for user to set this property. For more information, please refer to :ref:`api_guide_Name`
        
        Returns:
            Tensor: A tensor of data type :attr:`dtype` with shape :attr:`shape` and all elements set to 1.
        
        Examples:
            .. code-block:: python
        
              import paddle 
              
              # default dtype for ones OP
              data1 = paddle.ones(shape=[3, 2]) 
              # [[1. 1.]
              #  [1. 1.]
              #  [1. 1.]]
              
              data2 = paddle.ones(shape=[2, 2], dtype='int32') 
              # [[1 1]
              #  [1 1]]
              
              # shape is a Tensor
              shape = paddle.full(shape=[2], dtype='int32', fill_value=2)
              data3 = paddle.ones(shape=shape, dtype='int32') 
              # [[1 1]
              #  [1 1]]
    


从文档中，我们可以看到 `ones` 函数创建一个具有指定形状的新张量，并将所有元素值设置为 1。让我们来[**运行一个快速测试**]来确认这一解释：



```python
paddle.ones([4], dtype='float32')
```




    Tensor(shape=[4], dtype=float32, place=CPUPlace, stop_gradient=True,
           [1., 1., 1., 1.])



在Jupyter记事本中，我们可以使用 `?` 在另一个窗口中显示文档。例如，`list?`将创建与`help(list)` 几乎相同的内容，并在新的浏览器窗口中显示它。此外，如果我们使用两个问号，如 `list??`，将显示实现该函数的 Python 代码。

## 小结

* 官方文档提供了本书之外的大量描述和示例。
* 我们可以通过调用 `dir` 和 `help` 函数或在Jupyter记事本中使用`?` 和 `??`查看API的用法文档。

## 练习

1. 在深度学习框架中查找任何函数或类的文档。你能在这个框架的官方网站上找到文档吗?


[Discussions](https://discuss.d2l.ai/t/1765)

