--------------------------------------------------------------------------------
-- Company: <Name>
--
-- File: Nokia5110_Memory.vhd
-- File history:
--      <Revision number>: <Date>: <Comments>
--      <Revision number>: <Date>: <Comments>
--      <Revision number>: <Date>: <Comments>
--
-- Description: 
--
-- <Description here>
--
-- Targeted device: <Family::SmartFusion2> <Die::M2S010> <Package::144 TQ>
-- Author: <Name>
--
--------------------------------------------------------------------------------

library IEEE;

use IEEE.std_logic_1164.all;
use IEEE.numeric_std.all;

entity Nokia5110_Memory is
port (
    CLK : in std_logic;     -- assumed to be 100Mhz
    RSTn : in std_logic;

    mem_addr_X : in natural range 0 to 83;
    mem_addr_Y : in natural range 0 to 5;
    display_byte : out std_logic_vector(7 downto 0)
);
end Nokia5110_Memory;
architecture architecture_Nokia5110_Memory of Nokia5110_Memory is
    
    -- X address is 0 to 83, Y address is 0 to 5
    -- LCD address is X * Y = max 503 = (84 * 6) - 1
    --type LCD_Byte is std_logic_vector(7 downto 0);
    --type LCD_Col is array(0 to 6) of std_logic_vector(7 downto 0);
    --type LCD_map is array(0 to 83) of LCD_Col;
    type LCD_map is array(0 to 83, 0 to 5) of std_logic_vector(7 downto 0);

    signal LCD_mem_sig : LCD_map := (
        (X"FF", X"00", X"FF", X"00", X"FF", X"00"),		-- X = 0
        (X"00", X"FF", X"00", X"FF", X"00", X"FF"),		-- X = 1
        (X"FF", X"00", X"FF", X"00", X"FF", X"00"),		-- X = 2
        (X"00", X"FF", X"00", X"FF", X"00", X"FF"),		-- X = 3
        (X"FF", X"00", X"FF", X"00", X"FF", X"00"),		-- X = 4
        (X"00", X"FF", X"00", X"FF", X"00", X"FF"),		-- X = 5
        (X"FF", X"00", X"FF", X"00", X"FF", X"00"),		-- X = 6
        (X"00", X"FF", X"00", X"FF", X"00", X"FF"),		-- X = 7
        (X"FF", X"00", X"FF", X"00", X"FF", X"00"),		-- X = 8
        (X"00", X"FF", X"00", X"FF", X"00", X"FF"),		-- X = 9
        (X"FF", X"00", X"FF", X"00", X"FF", X"00"),		-- X = 10
        (X"00", X"FF", X"00", X"FF", X"00", X"FF"),		-- X = 11
        (X"FF", X"00", X"FF", X"00", X"FF", X"00"),		-- X = 12
        (X"00", X"FF", X"00", X"FF", X"00", X"FF"),		-- X = 13
        (X"FF", X"00", X"FF", X"00", X"FF", X"00"),		-- X = 14
        (X"00", X"FF", X"00", X"FF", X"00", X"FF"),		-- X = 15
        (X"FF", X"00", X"FF", X"00", X"FF", X"00"),		-- X = 16
        (X"00", X"FF", X"00", X"FF", X"00", X"FF"),		-- X = 17
        (X"FF", X"00", X"FF", X"00", X"FF", X"00"),		-- X = 18
        (X"00", X"FF", X"00", X"FF", X"00", X"FF"),		-- X = 19
        (X"FF", X"00", X"FF", X"00", X"FF", X"00"),		-- X = 20
        (X"00", X"FF", X"00", X"FF", X"00", X"FF"),		-- X = 21
        (X"FF", X"00", X"FF", X"00", X"FF", X"00"),		-- X = 22
        (X"00", X"FF", X"00", X"FF", X"00", X"FF"),		-- X = 23
        (X"FF", X"00", X"FF", X"00", X"FF", X"00"),		-- X = 24
        (X"00", X"FF", X"00", X"FF", X"00", X"FF"),		-- X = 25
        (X"FF", X"00", X"FF", X"00", X"FF", X"00"),		-- X = 26
        (X"00", X"FF", X"00", X"FF", X"00", X"FF"),		-- X = 27
        (X"FF", X"00", X"FF", X"00", X"FF", X"00"),		-- X = 28
        (X"00", X"FF", X"00", X"FF", X"00", X"FF"),		-- X = 29
        (X"FF", X"00", X"FF", X"00", X"FF", X"00"),		-- X = 30
        (X"00", X"FF", X"00", X"FF", X"00", X"FF"),		-- X = 31
        (X"FF", X"00", X"FF", X"00", X"FF", X"00"),		-- X = 32
        (X"00", X"FF", X"00", X"FF", X"00", X"FF"),		-- X = 33
        (X"FF", X"00", X"FF", X"00", X"FF", X"00"),		-- X = 34
        (X"00", X"FF", X"00", X"FF", X"00", X"FF"),		-- X = 35
        (X"FF", X"00", X"FF", X"00", X"FF", X"00"),		-- X = 36
        (X"00", X"FF", X"00", X"FF", X"00", X"FF"),		-- X = 37
        (X"FF", X"00", X"FF", X"00", X"FF", X"00"),		-- X = 38
        (X"00", X"FF", X"00", X"FF", X"00", X"FF"),		-- X = 39
        (X"FF", X"00", X"FF", X"00", X"FF", X"00"),		-- X = 40
        (X"00", X"FF", X"00", X"FF", X"00", X"FF"),		-- X = 41
        (X"FF", X"00", X"FF", X"00", X"FF", X"00"),		-- X = 42
        (X"00", X"FF", X"00", X"FF", X"00", X"FF"),		-- X = 43
        (X"FF", X"00", X"FF", X"00", X"FF", X"00"),		-- X = 44
        (X"00", X"FF", X"00", X"FF", X"00", X"FF"),		-- X = 45
        (X"FF", X"00", X"FF", X"00", X"FF", X"00"),		-- X = 46
        (X"00", X"FF", X"00", X"FF", X"00", X"FF"),		-- X = 47
        (X"FF", X"00", X"FF", X"00", X"FF", X"00"),		-- X = 48
        (X"00", X"FF", X"00", X"FF", X"00", X"FF"),		-- X = 49
        (X"FF", X"00", X"FF", X"00", X"FF", X"00"),		-- X = 50
        (X"00", X"FF", X"00", X"FF", X"00", X"FF"),		-- X = 51
        (X"FF", X"00", X"FF", X"00", X"FF", X"00"),		-- X = 52
        (X"00", X"FF", X"00", X"FF", X"00", X"FF"),		-- X = 53
        (X"FF", X"00", X"FF", X"00", X"FF", X"00"),		-- X = 54
        (X"00", X"FF", X"00", X"FF", X"00", X"FF"),		-- X = 55
        (X"FF", X"00", X"FF", X"00", X"FF", X"00"),		-- X = 56
        (X"00", X"FF", X"00", X"FF", X"00", X"FF"),		-- X = 57
        (X"FF", X"00", X"FF", X"00", X"FF", X"00"),		-- X = 58
        (X"00", X"FF", X"00", X"FF", X"00", X"FF"),		-- X = 59
        (X"FF", X"00", X"FF", X"00", X"FF", X"00"),		-- X = 60
        (X"00", X"FF", X"00", X"FF", X"00", X"FF"),		-- X = 61
        (X"FF", X"00", X"FF", X"00", X"FF", X"00"),		-- X = 62
        (X"00", X"FF", X"00", X"FF", X"00", X"FF"),		-- X = 63
        (X"FF", X"00", X"FF", X"00", X"FF", X"00"),		-- X = 64
        (X"00", X"FF", X"00", X"FF", X"00", X"FF"),		-- X = 65
        (X"FF", X"00", X"FF", X"00", X"FF", X"00"),		-- X = 66
        (X"00", X"FF", X"00", X"FF", X"00", X"FF"),		-- X = 67
        (X"FF", X"00", X"FF", X"00", X"FF", X"00"),		-- X = 68
        (X"00", X"FF", X"00", X"FF", X"00", X"FF"),		-- X = 69
        (X"FF", X"00", X"FF", X"00", X"FF", X"00"),		-- X = 70
        (X"00", X"FF", X"00", X"FF", X"00", X"FF"),		-- X = 71
        (X"FF", X"00", X"FF", X"00", X"FF", X"00"),		-- X = 72
        (X"00", X"FF", X"00", X"FF", X"00", X"FF"),		-- X = 73
        (X"FF", X"00", X"FF", X"00", X"FF", X"00"),		-- X = 74
        (X"00", X"FF", X"00", X"FF", X"00", X"FF"),		-- X = 75
        (X"FF", X"00", X"FF", X"00", X"FF", X"00"),		-- X = 76
        (X"00", X"FF", X"00", X"FF", X"00", X"FF"),		-- X = 77
        (X"FF", X"00", X"FF", X"00", X"FF", X"00"),		-- X = 78
        (X"00", X"FF", X"00", X"FF", X"00", X"FF"),		-- X = 79
        (X"FF", X"00", X"FF", X"00", X"FF", X"00"),		-- X = 80
        (X"00", X"FF", X"00", X"FF", X"00", X"FF"),		-- X = 81
        (X"FF", X"00", X"FF", X"00", X"FF", X"00"),		-- X = 82
        (X"00", X"FF", X"00", X"FF", X"00", X"FF")		-- X = 83
    );

begin

    process(CLK, RSTn)
    begin
        if(RSTn = '0') then
            LCD_mem_sig <= (
                ("00001111", X"00", X"00", X"00", X"00", "11110000"),		-- X = 0
                ("00000001", X"00", X"00", "10000000", "00111111", "10000000"),		-- X = 1
                ("00000001", X"00", X"00", "10000000", "00111111", "10000000"),		-- X = 2
                ("00000001", X"00", X"00", "11100000", "00111111", "10000000"),		-- X = 3
                (X"00", X"00", X"00", "11100000", X"00", X"00"),		-- X = 4
                (X"00", X"00", X"00", "11100000", X"00", X"00"),		-- X = 5
                (X"00", X"00", X"00", "11111100", X"00", X"00"),		-- X = 6
                (X"00", X"00", X"00", "00011100", X"00", X"00"),		-- X = 7
                (X"00", X"00", X"00", "00011100", X"00", X"00"),		-- X = 8
                (X"00", X"00", X"00", "11111100", X"FF","00000011"),		-- X = 9
                (X"00", X"00", X"00", "11111100", X"FF","00000011"),		-- X = 10
                ("11100000", "00111111", X"00", "11111100", X"FF","00000011"),		-- X = 11
                ("11100000", "00111111", X"00", "11111100", X"FF","00000011"),		-- X = 12
                ("11100000", X"FF", X"FF", X"FF", X"FF", "00000011"),		-- X = 13
                ("11100000", X"FF", X"FF", X"FF", X"FF", "00000011"),		-- X = 14
                ("11100000", X"FF", "11110001", X"FF", X"FF", "00000011"),		-- X = 15
                ("11100000", X"FF", "11110001", X"FF", X"FF", "01100011"),		-- X = 16
                ("11111110", "01111111", "11111100", X"FF", X"FF", "01100011"),		-- X = 17
                ("11111110", "01111111", "11111100", X"FF", X"FF", "01100011"),		-- X = 18
                ("11111110", "00011111", "11111100", X"FF", X"FF", "01100011"),		-- X = 19
                ("11111110", "10011111", "11100011", X"FF", X"FF", "01100011"),		-- X = 20
                ("11111110", "10011111", "11100011", "10000111", X"FF", "01100011"),		-- X = 21
                ("11111110", "11100111", "11100011", "10000111", X"FF", "01100011"),		-- X = 22
                ("11111110", "11100111", "11100011", "10000111", X"FF", "01111111"),		-- X = 23
                ("11111110", "11100111", "11100011", "10000111", X"FF", "01111111"),		-- X = 24
                ("11111110", X"FF", X"FF", "10000111", X"FF", "00000011"),		-- X = 25
                ("11111110", X"FF", X"FF", "10000111", X"FF", "00000011"),		-- X = 26
                ("11100000", X"FF", X"FF", "10000111", X"FF", "00000011"),		-- X = 27
                ("11100000", X"FF", X"FF", "10000111", X"FF", "00000011"),		-- X = 28
                ("11111000", X"FF", X"FF", "10000111", X"FF", "00000011"),		-- X = 29
                ("11111000", X"FF", X"FF", "10000111", X"FF", "00000011"),		-- X = 30
                ("11111000", X"FF", X"FF", "10000111", X"FF", "00000011"),		-- X = 31
                ("11111000", X"FF", "11100011", "10000111", X"FF", "00000011"),		-- X = 32
                ("11111000", X"FF", "11100011", "10000111", X"FF", "01111111"),		-- X = 33
                ("11111000", "11100111", "11100011", "10000111", X"FF", "01111111"),		-- X = 34
                ("11111000", "11100111", "11100011", "10000111", X"FF", "01111111"),		-- X = 35
                ("11111000", "00011111", "11100011", X"FF", X"FF", "01100011"),		-- X = 36
                ("11111110", "00011111", X"FF", X"FF", X"FF", "01100011"),		-- X = 37
                ("11111110", "00011111", "11111100", X"FF", X"FF", "01100011"),		-- X = 38
                ("11111110", "01111111", "11111100", X"FF", X"FF", "01100011"),		-- X = 39
                ("11111110", "01111111", "11111100", X"FF", X"FF", "01100011"),		-- X = 40
                ("11111110", X"FF", "11110001", X"FF", X"FF", "01100011"),		-- X = 41
                ("11111110", X"FF", "11110001", X"FF", X"FF", "01100011"),		-- X = 42
                ("11111110", X"FF", X"FF", X"FF", X"FF", "00000011"),		-- X = 43
                ("11111110", X"FF", X"FF", X"FF", X"FF", "00000011"),		-- X = 44
                (X"00", X"00", "10000000", X"FF", X"FF", "00000011"),		-- X = 45
                (X"00", X"00", "10000000", X"FF", X"FF", "00000011"),		-- X = 46
                (X"00", X"00", "10000000", X"FF", X"FF", "00000011"),		-- X = 47
                (X"00", X"00", X"00", "00000111", X"00", X"00"),		-- X = 48
                (X"00", X"00", X"00", "00000111", X"00", X"00"),		-- X = 49
                (X"00", X"00", X"00", "00000111", X"00", X"00"),		-- X = 50
                (X"00", X"00", X"00", "00011100", X"00", X"00"),		-- X = 51
                (X"00", X"00", X"00", "00011100", X"00", X"00"),		-- X = 52
                (X"00", X"00", X"00", "00011100", X"00", X"00"),		-- X = 53
                (X"00", X"00", X"00", "11100000", "01111111", X"00"),		-- X = 54
                (X"00", X"00", X"00", "11100000", "01111111", X"00"),		-- X = 55
                (X"00", X"00", X"00", X"00", X"00", X"00"),		-- X = 56
                (X"00", X"00", X"00", X"00", X"00", X"00"),		-- X = 57
                (X"00", X"00", X"00", X"00", X"00", X"00"),		-- X = 58
                (X"00", X"00", X"00", X"00", X"00", X"00"),		-- X = 59
                (X"00", X"00", X"00", X"00", X"00", X"00"),		-- X = 60
                (X"00", X"00", X"00", X"00", X"00", X"00"),		-- X = 61
                (X"00", X"00", X"00", X"00", X"00", X"00"),		-- X = 62
                (X"00", X"00", X"00", X"00", X"00", X"00"),		-- X = 63
                (X"00", X"00", X"00", X"00", X"00", X"00"),		-- X = 64
                (X"00", X"00", X"00", X"00", X"00", X"00"),		-- X = 65
                (X"00", X"00", X"00", X"00", X"00", X"00"),		-- X = 66
                (X"00", X"00", X"00", X"00", X"00", X"00"),		-- X = 67
                (X"00", X"00", X"00", X"00", X"00", X"00"),		-- X = 68
                (X"00", X"00", X"00", X"00", X"00", X"00"),		-- X = 69
                (X"00", X"00", X"00", X"00", X"00", X"00"),		-- X = 70
                (X"00", X"00", X"00", X"00", X"00", X"00"),		-- X = 71
                (X"00", X"00", X"00", X"00", X"00", X"00"),		-- X = 72
                (X"00", X"00", X"00", X"00", X"00", X"00"),		-- X = 73
                (X"00", X"00", X"00", X"00", X"00", X"00"),		-- X = 74
                (X"00", X"00", X"00", X"00", X"00", X"00"),		-- X = 75
                (X"00", X"00", X"00", X"00", X"00", X"00"),		-- X = 76
                (X"00", X"00", X"00", X"00", X"00", X"00"),		-- X = 77
                (X"00", X"00", X"00", X"00", X"00", X"00"),		-- X = 78
                (X"00", X"00", X"00", X"00", X"00", X"00"),		-- X = 79
                ("00000001", X"00", X"00", X"00", X"00", "10000000"),		-- X = 80
                ("00000001", X"00", X"00", X"00", X"00", "10000000"),		-- X = 81
                ("00000001", X"00", X"00", X"00", X"00", "10000000"),		-- X = 82
                ("00001111", X"00", X"00", X"00", X"00", "11110000")		-- X = 83
            );
        elsif(rising_edge(CLK)) then
        end if;
    end process;

    
    display_byte <= LCD_mem_sig(mem_addr_X, mem_addr_Y);

   -- architecture body
end architecture_Nokia5110_Memory;
