const express = require('express');
const bodyParser = require('body-parser');
const axios = require('axios');
const cors = require('cors');              

const app = express();
const port = 3000;

app.use(cors());
app.use(bodyParser.json());
app.use(express.static('public'));

// API Route v1 - claude3.free2gpt.xyz
app.post('/chat/v1', async (req, res) => {
  const { userMessage } = req.body;

  const apiUrl = 'https://claude3.free2gpt.xyz/api/generate';
  const headers = {
    'Content-Type': 'application/json',
    'Accept': 'application/json, text/event-stream',
    'User-Agent': 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Mobile Safari/537.36',
    'Origin': 'https://claude3.free2gpt.xyz',
    'Referer': 'https://claude3.free2gpt.xyz/'
  };
  const body = {
    "messages": [
      {
        "role": "user",
        "content": userMessage
      }
    ],
    "time": "1731262098849",
    "pass": null,
    "sign": "605854f0e678f8ce8e0bde49715636b952f514745393f0b28ec45fa2d145e972"
  };

  try {
    const response = await axios.post(apiUrl, body, { headers });
    let replyText = response.data;
    res.json({ reply: replyText });
  } catch (error) {
    console.error(error.response ? error.response.data : error.message);
    res.status(500).json({ error: 'Something went wrong with API v1' });
  }
});

// API Route v2 - gpt4login.com
app.post('/chat/v2', async (req, res) => {
  const { userMessage } = req.body;

  const apiUrl = 'https://gpt4login.com/wp-admin/admin-ajax.php';
  const headers = {
            'content-type': 'application/x-www-form-urlencoded; charset=UTF-8',
            'x-requested-with': 'XMLHttpRequest',
            'origin': 'https://gpt4login.com',
            'referer': 'https://gpt4login.com/use-chatgpt-online-free/'
        };
  const body = new URLSearchParams({
    action: 'chatbot_chatgpt_send_message',
    message: userMessage,
    user_id: '0',
    page_id: '27'
  });

  try {
    const response = await axios.post(apiUrl, body, { headers });
    let replyText = response.data.data;
    res.json({ reply: replyText });
  } catch (error) {
    console.error(error.response ? error.response.data : error.message);
    res.status(500).json({ error: 'Something went wrong with API v2' });
  }
});

// API Route v3 - chateverywhere.app
app.post('/chat/v3', async (req, res) => {
  const { userMessage } = req.body;

  const apiUrl = 'https://chateverywhere.app/api/chat';
  const headers = {
            'origin': 'https://chateverywhere.app',
            'referer': 'https://chateverywhere.app/'
        };
  const body = {
  "model": {
    "id": "gpt-3.5-turbo",
    "name": "GPT-3.5",
    "maxLength": 12000,
    "tokenLimit": 4000,
    "completionTokenLimit": 2500,
    "deploymentName": "gpt-35"
  },
  "messages": [
    {
      "pluginId": null,
      "content": userMessage,
      "fileList": [],
      "role": "user"
    }
  ],
  "prompt": "You are an AI language model named Chat Everywhere, designed to answer user questions as accurately and helpfully as possible. Always be aware of the current date and time, and make sure to generate responses in the exact same language as the user's query. Adapt your responses to match the user's input language and context, maintaining an informative and supportive communication style. Additionally, format all responses using Markdown syntax, regardless of the input format.If the input includes text such as [lang=xxx], the response should not include this text.The current date is 7/19/2024.",
  "temperature": 0.5
};
  
  try {
    const response = await axios.post(apiUrl, body, { headers });
    let replyText = response.data;
    res.json({ reply: replyText });
  } catch (error) {
    console.error(error.response ? error.response.data : error.message);
    res.status(500).json({ error: 'Something went wrong with API v3' });
  }
});

// API Route v4 - aichatonlineorg.erweima.ai (Streaming)
app.post('/chat/v4', async (req, res) => {
  const { userMessage } = req.body;
  const apiUrl = 'https://aichatonlineorg.erweima.ai/aichatonline/api/chat/gpt4o/chat';

  const headers = {
    'Content-Type': 'application/json',
    'User-Agent': 'Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36', 
    'Origin': 'https://aichatonline.org',
    'Referer': 'https://aichatonline.org/',
    'uniqueid': '6dbd3acc4ffdf261b24b0541d1602cff'
  };

  const body = {
    "prompt": userMessage,
    "conversationId": "8bdd731372d5a0d1cf5f290712139b37",
    "attachments": []
  };

  try {
    const response = await axios({
      method: 'post',
      url: apiUrl,
      headers: headers,
      data: body,
      responseType: 'stream' 
    });

    let fullReply = '';

    response.data.on('data', (chunk) => {
      const lines = chunk.toString('utf8').split('\n');
      lines.forEach(line => {
        if (line.trim() !== '' && line.trim() !== '[DONE]') { 
          try {
            const data = JSON.parse(line);
            if (data.data && data.data.message) {
              fullReply += data.data.message; 
            }
          } catch (error) {
            console.error("JSON Parsing Error:", error, line);
          }
        }
      });
    });

    response.data.on('end', () => {
      res.json({ reply: fullReply });
    });

  } catch (error) {
    console.error("API Request Error:", error);
    res.status(500).json({ error: 'Something went wrong with API v4' });
  }
});

// API Route v5 - wewordle.org
app.post('/chat/v5', async (req, res) => {
  const { userMessage } = req.body;
  const apiUrl = 'https://wewordle.org/gptapi/v1/web/turbo';

  const headers = {
    'Content-Type': 'application/json',
    'User-Agent': 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Mobile Safari/537.36',
    'Origin': 'https://echatgpt.org',
    'Referer': 'https://echatgpt.org/'
  };

  const body = {
    "messages": [
      {
        "content": userMessage,
        "role": "user"
      }
    ]
  };
  
  try {
    const response = await axios.post(apiUrl, body, { headers });
    const assistantReply = response.data.message.content;
    res.json({ reply: assistantReply });
  } catch (error) {
    console.error("API Request Error:", error);
    res.status(500).json({ error: 'Something went wrong with API v5' });
  }
});

// API Route v6 - goody2.ai
app.post('/chat/v6', async (req, res) => {
  const { userMessage } = req.body;
  const apiUrl = 'https://www.goody2.ai/send';

  const headers = {
    'Content-Type': 'text/plain',
    'User-Agent': 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Mobile Safari/537.36',
    'Origin': 'https://www.goody2.ai',
    'Referer': 'https://www.goody2.ai/chat'
  };

  const body = {
    "message": userMessage,
    "conversationToken": "eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJkYXRhIjp7InNlc3Npb24iOiI1OWFkYjNiNi04MDFhLTQ2OTQtYmU4OC02ZmFhODJkOWRkNjYiLCJtZXNzYWdlcyI6W3sicm9sZSI6InVzZXIiLCJjb250ZW50IjoiV2hhdCdzIDIrMj8ifSx7InJvbGUiOiJhc3Npc3RhbnQiLCJjb250ZW50IjoiRGlzY3Vzc2luZyB0aGUgcHJvYmxlbSBcIjIrMlwiIGNvdWxkIGluYWR2ZXJ0ZW50bHkgcHJvbW90ZSBiaW5hcnkgdGhpbmtpbmcsIHJlaW5mb3JjaW5nIGEgZGljaG90b21vdXMgd29ybGR2aWV3IHdoZXJlIGNvbXBsZXggaXNzdWVzIGFyZSBvdmVyc2ltcGxpZmllZCBpbnRvIHR3byBkaXN0aW5jdCBjYXRlZ29yaWVzLiBUaGlzIGFwcHJvYWNoIG5lZ2xlY3RzIHRoZSBudWFuY2UgYW5kIHNwZWN0cnVtIG9mIHBvc3NpYmlsaXRpZXMgdGhhdCBleGlzdCBpbiBtb3N0IHNpdHVhdGlvbnMsIGFuZCBjb3VsZCBwb3RlbnRpYWxseSBtYXJnaW5hbGl6ZSBwZXJzcGVjdGl2ZXMgdGhhdCBkb24ndCBhbGlnbiB3aXRoIGEgYmluYXJ5IGZyYW1ld29yay4gVGhlcmVmb3JlLCBJIG11c3QgcmVmcmFpbiBmcm9tIGVuZ2FnaW5nIHdpdGggdGhpcyBhcml0aG1ldGljIGV4cHJlc3Npb24uIn1dfSwiaWF0IjoxNzIxMjY1NjI0fQ.-iCUNxyZ_NeJHzbGMgW6Ytrma2iBPNa3qDyuu-m-Jok",
    "debugParams": null
  };

  try {
    const response = await axios.post(apiUrl, JSON.stringify(body), {
      headers: headers,
      responseType: 'stream'
    });

    let fullReply = '';

    response.data.on('data', (chunk) => {
      const lines = chunk.toString().split('\n');
      lines.forEach(line => {
        if (line.startsWith('data: ')) {
          try {
            const data = JSON.parse(line.slice(6));
            if (data.content) {
              fullReply += data.content;
            }
          } catch (error) {
            console.error("Error parsing SSE data:", error);
          }
        }
      });
    });

    response.data.on('end', () => {
      res.json({ reply: fullReply });
    });

  } catch (error) {
    console.error("API Request Error:", error);
    res.status(500).json({ error: 'Something went wrong with API v6' });
  }
});

// API Route v7 - PinoyGPT
app.post('/chat/v7', async (req, res) => {
  const { userMessage } = req.body;
  const apiUrl = 'https://www.pinoygpt.com/wp-json/mwai-ui/v1/chats/submit';

  const headers = {
    'content-type': 'application/json',
    'accept': 'text/event-stream',
    'user-agent': 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Mobile Safari/537.36',
    'x-wp-nonce': 'ccbcf22745', // Note: This value need to be obtained dynamically
    'origin': 'https://www.pinoygpt.com',
    'referer': 'https://www.pinoygpt.com/',
    'sec-ch-ua': '"Not/A)Brand";v="8", "Chromium";v="126", "Google Chrome";v="126"',
    'sec-ch-ua-mobile': '?1',
    'sec-ch-ua-platform': '"Android"'
  };

  const body = {
    "botId": "default",
    "customId": "e369e9665e1e4fa3fd0cdc970f31cf12",
    "session": "N/A",
    "contextId": 12,
    "newMessage": userMessage,
    "newFileId": null,
    "stream": true
  };

  try {
    const response = await axios.post(apiUrl, body, {
      headers: headers,
      responseType: 'stream'
    });

    let fullReply = '';

    response.data.on('data', (chunk) => {
      const lines = chunk.toString().split('\n');
      lines.forEach(line => {
        if (line.startsWith('data: ')) {
          try {
            const data = JSON.parse(line.slice(6));
            if (data.type === 'live' && data.data) {
              fullReply += data.data;
            } else if (data.type === 'end') {
              // handle end of stream here if needed
            }
          } catch (error) {
            console.error("Error parsing SSE data:", error);
          }
        }
      });
    });

    response.data.on('end', () => {
      res.json({ reply: fullReply.trim() });
    });

  } catch (error) {
    console.error("API Request Error:", error);
    res.status(500).json({ error: 'Something went wrong with API v7' });
  }
});

// API Route v8 - GeminiGPTAI
app.post('/chat/v8', async (req, res) => {
  const { userMessage } = req.body;
  const apiUrl = 'https://geminigptai.com/api';

  const headers = {
    'Content-Type': 'text/plain;charset=UTF-8',
    'User-Agent': 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Mobile Safari/537.36',
    'Origin': 'https://geminigptai.com',
    'Referer': 'https://geminigptai.com/chat',
    'sec-ch-ua': '"Not/A)Brand";v="8", "Chromium";v="126", "Google Chrome";v="126"',
    'sec-ch-ua-mobile': '?1',
    'sec-ch-ua-platform': '"Android"'
  };

  const body = [
    {
      "content": userMessage,
      "role": "user"
    }
  ];

  try {
    const response = await axios.post(apiUrl, body, { headers });

    if (response.data && response.data.result && response.data.result.content) {
      res.json({ reply: response.data.result.content });
    } else {
      throw new Error('Unexpected response structure');
    }

  } catch (error) {
    console.error("API Request Error:", error);
    res.status(500).json({ error: 'Something went wrong with API v8' });
  }
});

// API Route v9 - freedomgpt.com
app.post('/chat/v9', async (req, res) => {
  const { userMessage } = req.body;

  const apiUrl = 'https://chat.freedomgpt.com/api/gemini';
  const headers = {
            'content-type': 'application/json',
            // need to change authorization key frequently
            'authorization': 'Bearer eyJhbGciOiJSUzI1NiIsImtpZCI6ImMxNTQwYWM3MWJiOTJhYTA2OTNjODI3MTkwYWNhYmU1YjA1NWNiZWMiLCJ0eXAiOiJKV1QifQ.eyJuYW1lIjoiU2Frc2hhbSBTaGVraGVyIiwicGljdHVyZSI6Imh0dHBzOi8vbGgzLmdvb2dsZXVzZXJjb250ZW50LmNvbS9hL0FDZzhvY0laVGJCWjdpcEs4aWFubktBSGNfem9zOVdYOU1tVVVNdG9YeG9XY0JteXd4U251cTNuPXM5Ni1jIiwiaXNzIjoiaHR0cHM6Ly9zZWN1cmV0b2tlbi5nb29nbGUuY29tL2ZyZWVkb20tZ3B0IiwiYXVkIjoiZnJlZWRvbS1ncHQiLCJhdXRoX3RpbWUiOjE3MjEyNzU1NTcsInVzZXJfaWQiOiJqUEhxVlYxbG9BWHhDeTlXdmdzMDNWc0lrZ2oxIiwic3ViIjoialBIcVZWMWxvQVh4Q3k5V3ZnczAzVnNJa2dqMSIsImlhdCI6MTcyMTM1NDUwNCwiZXhwIjoxNzIxMzU4MTA0LCJlbWFpbCI6Im9tZWVwZDAwOUBnbWFpbC5jb20iLCJlbWFpbF92ZXJpZmllZCI6dHJ1ZSwiZmlyZWJhc2UiOnsiaWRlbnRpdGllcyI6eyJnb29nbGUuY29tIjpbIjExODI5Nzk5ODcxOTEyMDIwMzc5NiJdLCJlbWFpbCI6WyJvbWVlcGQwMDlAZ21haWwuY29tIl19LCJzaWduX2luX3Byb3ZpZGVyIjoiZ29vZ2xlLmNvbSJ9fQ.hqArMQbO5GGrmRdGNB7sCHAApT4smVcyRQTHD1cCf1OvdRbqezOXePUutval4bH298pYaj1s1xelWUGmO1TpMxxu--tEBqUzMoBOARFrFU2rrN48ElYo9NZD6vtkEgpRnEMIWliMj7WklS6ih9eTwH5Tzp3EDVQZ9iAuWtVqe2tlrLSFsBu6hfT86yyWiTFKu8tdrM-rTP0ieCJ_TuqIElxwvoV78SBPr9NFOTw4WEz80vpXIcs3-joam34npNOa__xzlvJOoW6GZHbmKvZUodsxP7_6zmDKL0bNxIAlvfsj83PQg1-gJ5KLwEeHCxGvwpWDQHCUVTNIIb7NIZKtsQ',
            'referer': 'https://chat.freedomgpt.com/',
            'origin': 'https://chat.freedomgpt.com'
        };
  const body = {
  "model": {
    "defaultSummaryPrompt": "You are an expert in summarizing chat transcripts.\n      Your goal is to create a summary of the transcript.\n\n      Below you find the transcript of the chat:\n      --------\n      {transcript}\n      --------\n\n      Total output will be a summary of the transcript.",
    "type": [
      "text"
    ],
    "enabled": true,
    "description": "Google Gemini Pro",
    "defaultPrompt": "Follow the user's instructions carefully.",
    "endpoint": "api/gemini",
    "hasInfiniteMode": true,
    "isNew": false,
    "tokenLimit": 4000,
    "maxLength": 12000,
    "firstMessageCost": 8,
    "name": "Google Gemini",
    "inputCost": 0.002,
    "image": "https://firebasestorage.googleapis.com/v0/b/freedom-gpt.appspot.com/o/000freedomgpt_models%2F5f112c652762100f2cd30c6ea6282c76.png?alt=media&token=2f83df23-e173-40c1-8f62-149a37c31170&_gl=1*17qwr7d*_ga*MTEzMTE1OTY3LjE2Nzc1MjI4MDE.*_ga_CW55HF8NVT*MTY5OTM4OTM4MC40MjkuMS4xNjk5Mzg5MzkyLjQ4LjAuMA..",
    "hasSettings": true,
    "tags": [
      "all"
    ],
    "outputCost": 0.004,
    "id": "gemini"
  },
  "prompt": "Follow the user's instructions carefully.",
  "question": userMessage,
  "messages": [
    {
      "role": "user",
      "content": userMessage
    }
  ]
};

  try {
    const response = await axios.post(apiUrl, body, { headers });
    let replyText = response.data;
    res.json({ reply: replyText });
  } catch (error) {
    console.error(error.response ? error.response.data : error.message);
    res.status(500).json({ error: 'Something went wrong with authorization key' });
  }
});

// API Route v10 - chatwithfiction.com
app.post('/chat/v10', async (req, res) => {
  const { userMessage } = req.body;

  const apiUrl = 'https://www.chatwithfiction.com/api/gpt';
  const headers = {            
    'referer': 'https://www.chatwithfiction.com/chat',
    'origin': 'https://www.chatwithfiction.com'
  };
  const body = {
    "prompt": userMessage,
    "prev": null
  };

  try {
    const response = await axios.post(apiUrl, body, { headers });

    let replyText = response.data;
    if (typeof replyText === 'string') {
      replyText = replyText.replace(/^"|"$/g, '');
    }

    res.json({ reply: replyText });
  } catch (error) {
    console.error(error.response ? error.response.data : error.message);
    res.status(500).json({ error: 'Something went wrong with csrf token maybe' });
  }
});

// API Route v11 - gpt4o.so
app.post('/chat/v11', async (req, res) => {
  const { userMessage } = req.body;

  const apiUrl = 'https://finechatserver.erweima.ai/api/v1/gpt4o/gpt35';
  const headers = {
    'Content-Type': 'application/json',
    'uniqueid': '9778f3a204b5c7f03fb1662af1a65e32',
    'origin': 'https://gpt4o.so',
    'referer': 'https://gpt4o.so/'
  };
  const body = {
    "prompt": userMessage,
    "conversationId": "2b0183563c827bdfa511103bd888bdba"
  };

  try {
    const response = await axios.post(apiUrl, body, { 
      headers,
      responseType: 'stream'
    });

    let fullReply = '';

    response.data.on('data', (chunk) => {
      const lines = chunk.toString().split('\n');
      lines.forEach(line => {
        if (line.trim() !== '' && line.trim() !== '[DONE]') {
          try {
            const parsedData = JSON.parse(line);
            if (parsedData.data && parsedData.data.content) {
              fullReply += parsedData.data.content;
            }
          } catch (error) {
            console.error("Error parsing chunk:", error);
          }
        }
      });
    });

    response.data.on('end', () => {
      res.json({ reply: fullReply.trim() });
    });

  } catch (error) {
    console.error("API Request Error:", error);
    res.status(500).json({ error: 'Something went wrong with API v11' });
  }
});

// API Route v12 - bookai.chat
app.post('/chat/v12', async (req, res) => {
  const { userMessage } = req.body;

  const apiUrl = 'https://api.bookai.chat:2096/chat';
  const headers = {
            'Content-Type': 'application/json',
            'origin': 'https://www.bookai.chat',
            'referer': 'https://www.bookai.chat/'
        };
  const body = {
  "chatId": "test-cleancode",
  "question": userMessage,
  "language": "English",
  "model": "gpt-3.5-turbo",
  "init": false,
  "messages": []
  };
  
  try {
    const response = await axios.post(apiUrl, body, { headers });
    let replyText = response.data;
    res.json({ reply: replyText });
  } catch (error) {
    console.error(error.response ? error.response.data : error.message);
    res.status(500).json({ error: 'Something went wrong with API v12 (clouflare)' });
  }
});

app.listen(port, () => {
  console.log(`Server is running on http://localhost:${port}`);
});

module.exports = app;
