#pragma once
#include "xrUICore/Static/UIStatic.h"

class CUI3tButton;
class CUIEditBox;

class XRUICORE_API CUIMessageBox final : public CUIStatic
{
private:
    typedef CUIStatic inherited;

public:
    CUIMessageBox();
    virtual ~CUIMessageBox();

    //разновидности MessageBox
    typedef enum {
        MESSAGEBOX_OK,
        MESSAGEBOX_INFO,
        MESSAGEBOX_YES_NO,
        MESSAGEBOX_YES_NO_CANCEL,
        MESSAGEBOX_DIRECT_IP,
        MESSAGEBOX_PASSWORD,
        MESSAGEBOX_RA_LOGIN,
        MESSAGEBOX_QUIT_WINDOWS,
        MESSAGEBOX_QUIT_GAME,
        MESSAGEBOX_YES_NO_COPY
    } E_MESSAGEBOX_STYLE;

    virtual bool InitMessageBox(LPCSTR xml_template);
    void Clear();
    virtual void SetText(LPCSTR str);
    virtual LPCSTR GetText() const;
    LPCSTR GetHost();
    LPCSTR GetPassword();
    LPCSTR GetUserPassword();
    void SetUserPasswordMode(bool);
    void SetPasswordMode(bool);
    E_MESSAGEBOX_STYLE GetBoxStyle() { return m_eMessageBoxStyle; };
    void SetTextEditURL(LPCSTR text);
    LPCSTR GetTextEditURL();

    virtual bool OnMouseAction(float x, float y, EUIMessages mouse_action);
    bool OnKeyboardAction(int dik, EUIMessages keyboard_action) override;
    virtual void SendMessage(CUIWindow* pWnd, s16 msg, void* pData);

    void OnYesOk();

    [[nodiscard]]
    bool IsInputHandlingAllowed() const { return m_allowInputHandling; }
    void AllowInputHandling(bool allow) { m_allowInputHandling = allow; }

    pcstr GetDebugType() override { return "CUIMessageBox"; }

protected:
    xr_string m_ret_val;
    CUI3tButton* m_UIButtonYesOk;
    CUI3tButton* m_UIButtonNo;
    CUI3tButton* m_UIButtonCancel;
    CUI3tButton* m_UIButtonCopy;

    CUIStatic* m_UIStaticPicture;
    CUIStatic* m_UIStaticText;
    CUIStatic* m_UIStaticHost;
    CUIStatic* m_UIStaticPass;
    CUIStatic* m_UIStaticUserPass;
    CUIEditBox* m_UIEditHost;
    CUIEditBox* m_UIEditPass;
    CUIEditBox* m_UIEditUserPass;
    CUIEditBox* m_UIEditURL;

    E_MESSAGEBOX_STYLE m_eMessageBoxStyle;
    bool m_allowInputHandling{};
};
