////////////////////////////////////////////////////////////////////////////
//	Module 		: level_location_selector.h
//	Created 	: 02.10.2001
//  Modified 	: 18.11.2003
//	Author		: Dmitriy Iassenev
//	Description : Level location selector
////////////////////////////////////////////////////////////////////////////

#pragma once

#include "abstract_location_selector.h"
#include "xrAICore/Navigation/level_graph.h"

template <typename _VertexEvaluator, typename _vertex_id_type>
class CBaseLocationSelector<CLevelGraph, _VertexEvaluator, _vertex_id_type>
    : public CAbstractLocationSelector<CLevelGraph, _VertexEvaluator, _vertex_id_type>
{
    typedef CLevelGraph _Graph;
    typedef CAbstractLocationSelector<_Graph, _VertexEvaluator, _vertex_id_type> inherited;

    // Needed for template-derived-classes.
    using inherited::m_evaluator;
    using inherited::m_graph;
    using inherited::m_path;
    using inherited::m_restricted_object;

public:
    IC CBaseLocationSelector(CRestrictedObject* object);

protected:
    IC virtual void before_search(_vertex_id_type& vertex_id);
    IC virtual void after_search();
};

#include "level_location_selector_inline.h"
