#include "StdAfx.h"
#include "monster_event_manager.h"

CMonsterEventManager::CMonsterEventManager() {}
CMonsterEventManager::~CMonsterEventManager() { clear(); }
void CMonsterEventManager::add_delegate(EEventType event, typeEvent delegate)
{
    auto it = m_event_storage.find(event);
    if (it == m_event_storage.end())
    {
        auto res = m_event_storage.insert(std::make_pair(event, EVENT_VECTOR()));
        it = res.first;
    }

    it->second.push_back(event_struc(delegate));
}

void CMonsterEventManager::remove_delegate(EEventType event, typeEvent delegate)
{
    auto it = m_event_storage.find(event);
    if (it == m_event_storage.end())
        return;

    for (auto it_del = it->second.begin(); it_del != it->second.end(); ++it_del)
    {
        if (it_del->delegate == delegate)
            it_del->need_remove = true;
    }
}

void CMonsterEventManager::raise(EEventType event, IEventData* data)
{
    auto it = m_event_storage.find(event);
    if (it == m_event_storage.end())
        return;

    for (auto I = it->second.begin(); I != it->second.end(); ++I)
    {
        if (!I->need_remove)
            (I->delegate)(data);
    }

    auto it_del = std::remove_if(it->second.begin(), it->second.end(), [](const event_struc& event)
    {
        return event.need_remove;
    });
    it->second.erase(it_del, it->second.end());
}

void CMonsterEventManager::clear()
{
    for (auto I_map = m_event_storage.begin(); I_map != m_event_storage.end(); ++I_map)
    {
        I_map->second.clear();
    }

    m_event_storage.clear();
}
