/*************************************************************************
 *                                                                       *
 * Open Dynamics Engine, Copyright (C) 2001,2002 Russell L. Smith.       *
 * All rights reserved.  Email: russ@q12.org   Web: www.q12.org          *
 *                                                                       *
 * This library is free software; you can redistribute it and/or         *
 * modify it under the terms of EITHER:                                  *
 *   (1) The GNU Lesser General Public License as published by the Free  *
 *       Software Foundation; either version 2.1 of the License, or (at  *
 *       your option) any later version. The text of the GNU Lesser      *
 *       General Public License is included with this library in the     *
 *       file LICENSE.TXT.                                               *
 *   (2) The BSD-style license that is included with this library in     *
 *       the file LICENSE-BSD.TXT.                                       *
 *                                                                       *
 * This library is distributed in the hope that it will be useful,       *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the files    *
 * LICENSE.TXT and LICENSE-BSD.TXT for more details.                     *
 *                                                                       *
 *************************************************************************/

#ifndef _ODE_UTIL_H_
#define _ODE_UTIL_H_

#include "objects.h"
#include "float.h"

#ifndef MSVC
#include <cmath> // for fpclassify
#endif

void dInternalHandleAutoDisabling (dxWorld *world, dReal stepsize);
extern "C"
{
	ODE_API void dxStepBody (dxBody *b, dReal h);
}
typedef void (*dstepper_fn_t) (dxWorld *world, dxBody * const *body, int nb,
        dxJoint **joint, int nj, dReal stepsize);


void dxProcessIslands (dxWorld *world, dReal stepsize, dstepper_fn_t stepper);

inline bool dValid(const float x)
{
#ifdef MSVC
    // check for: Signaling NaN, Quiet NaN, Negative infinity (-INF), Positive infinity (+INF), Negative denormalized, Positive denormalized
    int cls = _fpclass(double(x));
    if (cls&(_FPCLASS_SNAN+_FPCLASS_QNAN+_FPCLASS_NINF+_FPCLASS_PINF+_FPCLASS_ND+_FPCLASS_PD))
       return false;
#else
	int cls = std::fpclassify((double)x);
    switch (cls)
    {
    case FP_NAN:
    case FP_INFINITE:
    case FP_SUBNORMAL:
        return false;
    default:
        break;
    }
#endif
    /*	*****other cases are*****
     _FPCLASS_NN Negative normalized non-zero
     _FPCLASS_NZ Negative zero (-0)
     _FPCLASS_PZ Positive 0 (+0)
     _FPCLASS_PN Positive normalized non-zero
     */
    return true;
}
#endif
