///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/**
 *	Contains a handy triangle class.
 *	\file		IceTriangle.h
 *	\author		Pierre Terdiman
 *	\date		January, 17, 2000
 */
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Include Guard
#ifndef __ICETRIANGLE_H__
#define __ICETRIANGLE_H__

// An indexed triangle class.
class MESHMERIZER_API IndexedTriangle
{
public:
    //! Constructor
    inline_ IndexedTriangle() {}
    //! Constructor
    inline_ IndexedTriangle(udword r0, udword r1, udword r2)
    {
        mVRef[0] = r0;
        mVRef[1] = r1;
        mVRef[2] = r2;
    }
    //! Copy constructor
    inline_ IndexedTriangle(const IndexedTriangle& triangle)
    {
        mVRef[0] = triangle.mVRef[0];
        mVRef[1] = triangle.mVRef[1];
        mVRef[2] = triangle.mVRef[2];
    }
    //! Destructor
    inline_ ~IndexedTriangle() {}
    //! Vertex-references
    udword mVRef[3];

    // Methods
    bool IsDegenerate() const;
};

#endif // __ICETRIANGLE_H__
