-- © IBM Corp. 2020
-- Licensed under the Apache License, Version 2.0 (the "License"), as modified by
-- the terms below; you may not use the files in this repository except in
-- compliance with the License as modified.
-- You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
--
-- Modified Terms:
--
--    1) For the purpose of the patent license granted to you in Section 3 of the
--    License, the "Work" hereby includes implementations of the work of authorship
--    in physical form.
--
--    2) Notwithstanding any terms to the contrary in the License, any licenses
--    necessary for implementation of the Work that are available from OpenPOWER
--    via the Power ISA End User License Agreement (EULA) are explicitly excluded
--    hereunder, and may be obtained from OpenPOWER under the terms and conditions
--    of the EULA.  
--
-- Unless required by applicable law or agreed to in writing, the reference design
-- distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
-- WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License
-- for the specific language governing permissions and limitations under the License.
-- 
-- Additional rights, including the ability to physically implement a softcore that
-- is compliant with the required sections of the Power ISA Specification, are
-- available at no cost under the terms of the OpenPOWER Power ISA EULA, which can be
-- obtained (along with the Power ISA) here: https://openpowerfoundation.org. 

--  Description:  XU LSU L1 Data Directory Valid Register Array

library ibm, ieee, work, tri, support;
use ibm.std_ulogic_support.all;
use ibm.std_ulogic_function_support.all;
use ibm.std_ulogic_unsigned.all;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
use tri.tri_latches_pkg.all;
use support.power_logic_pkg.all;
-- ##########################################################################################
-- Directory Valids Component
-- 1) Contains an Array of Valids
-- 2) Updates Valid bits on Reloads
-- 3) Invalidates Valid bits for Flush type commands and Back Invalidates
-- 4) Outputs Valids for Congruence Class
-- XXXXXXXXXXXXXXXXXXXXXXXXXXXXX
-- Flush Way Generation
-- Want to flush a Way on the following conditions
-- 1) Invalidate Type Instruction (dcbf,dcbi,dcbz,lwarx,stwcx)
-- 2) L2 Back Invalidate
-- 3) L2 Reload and overwritting a Valid Way
-- XXXXXXXXXXXXXXXXXXXXXXXXXXXXX
-- ##########################################################################################
entity xuq_lsu_dir_val32  is
generic(expand_type     : integer := 2;         
        dc_size         : natural := 15;
        cl_size         : natural := 6);
port(

     ex1_stg_act                :in  std_ulogic;
     ex2_stg_act                :in  std_ulogic;
     ex3_stg_act                :in  std_ulogic;
     ex4_stg_act                :in  std_ulogic;
     ex5_stg_act                :in  std_ulogic;
     binv1_stg_act              :in  std_ulogic;
     binv2_stg_act              :in  std_ulogic;
     binv3_stg_act              :in  std_ulogic;
     binv4_stg_act              :in  std_ulogic;
     binv5_stg_act              :in  std_ulogic;
     rel1_stg_act               :in  std_ulogic;
     rel2_stg_act               :in  std_ulogic;

     ldq_rel1_early_v           :in  std_ulogic;                        
     rel1_val                   :in  std_ulogic;                        
     rel_addr_early             :in  std_ulogic_vector(64-(dc_size-3) to 63-cl_size);       
     rel_lock_en                :in  std_ulogic;                        
     rel_l1dump_cslc            :in  std_ulogic;
     rel3_l1dump_val            :in  std_ulogic;                        
     rel4_ecc_err               :in  std_ulogic;                        
     rel_watch_en               :in  std_ulogic;                        
     rel_thrd_id                :in  std_ulogic_vector(0 to 3);         
     rel_way_clr_a              :in  std_ulogic;                        
     rel_way_clr_b              :in  std_ulogic;                        
     rel_way_clr_c              :in  std_ulogic;                        
     rel_way_clr_d              :in  std_ulogic;                        
     rel_way_clr_e              :in  std_ulogic;                        
     rel_way_clr_f              :in  std_ulogic;                        
     rel_way_clr_g              :in  std_ulogic;                        
     rel_way_clr_h              :in  std_ulogic;                        

     ldq_rel3_early_v           :in  std_ulogic;                        
     rel3_val                   :in  std_ulogic;                        
     rel_back_inval             :in  std_ulogic;                        
     rel4_set_val               :in  std_ulogic;                        
     rel4_recirc_val            :in  std_ulogic;                        
     rel_way_wen_a              :in  std_ulogic;                        
     rel_way_wen_b              :in  std_ulogic;                        
     rel_way_wen_c              :in  std_ulogic;                        
     rel_way_wen_d              :in  std_ulogic;                        
     rel_way_wen_e              :in  std_ulogic;                        
     rel_way_wen_f              :in  std_ulogic;                        
     rel_way_wen_g              :in  std_ulogic;                        
     rel_way_wen_h              :in  std_ulogic;                        
     rel_up_way_addr_b          :in  std_ulogic_vector(0 to 2);         
     rel_dcarr_addr_en          :in  std_ulogic;                        

     xu_lsu_dci                 :in  std_ulogic;                        
     xu_lsu_spr_xucr0_clfc      :in  std_ulogic;                        
     spr_xucr0_dcdis            :in  std_ulogic;                        
     spr_xucr0_cls              :in  std_ulogic;                        

     ex1_thrd_id                :in  std_ulogic_vector(0 to 3);         
     ex1_p_addr                 :in  std_ulogic_vector(64-(dc_size-3) to 63-cl_size);       
     ex2_is_inval_op            :in  std_ulogic;                        
     ex2_lock_set               :in  std_ulogic;                        
     ex2_lock_clr               :in  std_ulogic;                        
     ex3_cache_acc              :in  std_ulogic;                        
     ex3_cache_en               :in  std_ulogic;                        
     ex3_tag_way_perr           :in  std_ulogic_vector(0 to 7);         
     ex5_load_op_hit            :in  std_ulogic;                        
     ex6_ld_par_err             :in  std_ulogic;                        
     ex2_ldawx_instr            :in  std_ulogic;                        
     ex2_wclr_instr             :in  std_ulogic;                        
     ex2_wchk_val               :in  std_ulogic;                        
     ex2_l_fld                  :in  std_ulogic_vector(0 to 1);         
     ex2_store_instr            :in  std_ulogic;                        
     ex3_load_val               :in  std_ulogic;
     ex3_wimge_i_bit            :in  std_ulogic;
     ex3_l2_request             :in  std_ulogic;
     ex3_ldq_potential_flush    :in  std_ulogic;

     inv1_val                   :in  std_ulogic;                        

     ex3_way_cmp_a              :in  std_ulogic;                        
     ex3_way_cmp_b              :in  std_ulogic;                        
     ex3_way_cmp_c              :in  std_ulogic;                        
     ex3_way_cmp_d              :in  std_ulogic;                        
     ex3_way_cmp_e              :in  std_ulogic;                        
     ex3_way_cmp_f              :in  std_ulogic;                        
     ex3_way_cmp_g              :in  std_ulogic;                        
     ex3_way_cmp_h              :in  std_ulogic;                        

     ex2_stg_flush              :in  std_ulogic;                        
     ex3_stg_flush              :in  std_ulogic;                        
     ex4_stg_flush              :in  std_ulogic;                        
     ex5_stg_flush              :in  std_ulogic;                        

     pc_xu_inj_dcachedir_multihit :in  std_ulogic;                      

     ex4_way_a_dir              :out std_ulogic_vector(0 to 5);
     ex4_way_b_dir              :out std_ulogic_vector(0 to 5);
     ex4_way_c_dir              :out std_ulogic_vector(0 to 5);
     ex4_way_d_dir              :out std_ulogic_vector(0 to 5);
     ex4_way_e_dir              :out std_ulogic_vector(0 to 5);
     ex4_way_f_dir              :out std_ulogic_vector(0 to 5);
     ex4_way_g_dir              :out std_ulogic_vector(0 to 5);
     ex4_way_h_dir              :out std_ulogic_vector(0 to 5);

     ex4_way_a_hit              :out std_ulogic;                        
     ex4_way_b_hit              :out std_ulogic;                        
     ex4_way_c_hit              :out std_ulogic;                        
     ex4_way_d_hit              :out std_ulogic;                        
     ex4_way_e_hit              :out std_ulogic;                        
     ex4_way_f_hit              :out std_ulogic;                        
     ex4_way_g_hit              :out std_ulogic;                        
     ex4_way_h_hit              :out std_ulogic;                        

     ex3_cClass_upd_way_a       :out std_ulogic;
     ex3_cClass_upd_way_b       :out std_ulogic;
     ex3_cClass_upd_way_c       :out std_ulogic;
     ex3_cClass_upd_way_d       :out std_ulogic;
     ex3_cClass_upd_way_e       :out std_ulogic;
     ex3_cClass_upd_way_f       :out std_ulogic; 
     ex3_cClass_upd_way_g       :out std_ulogic;
     ex3_cClass_upd_way_h       :out std_ulogic;

     ex2_lockwatchSet_rel_coll  :out std_ulogic;                        
     ex3_wclr_all_flush         :out std_ulogic;                        

     ex3_hit                    :out std_ulogic;                        
     ex3_dir_perr_det           :out std_ulogic;                        
     ex4_dir_multihit_det       :out std_ulogic;                        
     ex4_n_lsu_ddmh_flush       :out std_ulogic_vector(0 to 3);         
     ex4_ldq_full_flush         :out std_ulogic;                        
     ex4_miss                   :out std_ulogic;                        
     ex4_snd_ld_l2              :out std_ulogic;                        
     dcpar_err_flush            :out std_ulogic;                        
     pe_recov_begin             :out std_ulogic;

     lsu_xu_ex5_cr_rslt         :out std_ulogic;                        

     rel_way_val_a              :out std_ulogic;                        
     rel_way_val_b              :out std_ulogic;                        
     rel_way_val_c              :out std_ulogic;                        
     rel_way_val_d              :out std_ulogic;                        
     rel_way_val_e              :out std_ulogic;                        
     rel_way_val_f              :out std_ulogic;                        
     rel_way_val_g              :out std_ulogic;                        
     rel_way_val_h              :out std_ulogic;                        

     rel_way_lock_a             :out std_ulogic;                        
     rel_way_lock_b             :out std_ulogic;                        
     rel_way_lock_c             :out std_ulogic;                        
     rel_way_lock_d             :out std_ulogic;                        
     rel_way_lock_e             :out std_ulogic;                        
     rel_way_lock_f             :out std_ulogic;                        
     rel_way_lock_g             :out std_ulogic;                        
     rel_way_lock_h             :out std_ulogic;                        

     dcarr_up_way_addr          :out std_ulogic_vector(0 to 2);         

     lsu_xu_perf_events         :out std_ulogic_vector(0 to 16);        

     lsu_xu_spr_xucr0_cslc_xuop :out std_ulogic;                        
     lsu_xu_spr_xucr0_cslc_binv :out std_ulogic;                        

     dc_val_dbg_data            :out std_ulogic_vector(0 to 293);

     vdd                        :inout power_logic;
     gnd                        :inout power_logic;
     nclk                       :in  clk_logic;
     sg_0                       :in  std_ulogic;
     func_sl_thold_0_b          :in  std_ulogic;
     func_sl_force              :in  std_ulogic;
     func_slp_sl_thold_0_b      :in  std_ulogic;
     func_slp_sl_force          :in  std_ulogic;
     func_nsl_thold_0_b         :in  std_ulogic;
     func_nsl_force             :in  std_ulogic;
     func_slp_nsl_thold_0_b     :in  std_ulogic;
     func_slp_nsl_force         :in  std_ulogic;
     d_mode_dc                  :in  std_ulogic;
     delay_lclkr_dc             :in  std_ulogic;
     mpw1_dc_b                  :in  std_ulogic;
     mpw2_dc_b                  :in  std_ulogic;
     scan_in                    :in  std_ulogic_vector(0 to 2);
     scan_out                   :out std_ulogic_vector(0 to 2)     
   );
-- synopsys translate_off
-- synopsys translate_on
end xuq_lsu_dir_val32;
----
ARCHITECTURE XUQ_LSU_DIR_VAL32
          OF XUQ_LSU_DIR_VAL32
          IS
----------------------------
-- components
----------------------------
----------------------------
-- constants
----------------------------
constant congr_cl0_wA_offset            :natural := 0;
constant congr_cl0_wB_offset            :natural := congr_cl0_wA_offset + 6;
constant congr_cl0_wC_offset            :natural := congr_cl0_wB_offset + 6;
constant congr_cl0_wD_offset            :natural := congr_cl0_wC_offset + 6;
constant congr_cl0_wE_offset            :natural := congr_cl0_wD_offset + 6;
constant congr_cl0_wF_offset            :natural := congr_cl0_wE_offset + 6;
constant congr_cl0_wG_offset            :natural := congr_cl0_wF_offset + 6;
constant congr_cl0_wH_offset            :natural := congr_cl0_wG_offset + 6;
constant congr_cl1_wA_offset            :natural := congr_cl0_wH_offset   + 6;
constant congr_cl1_wB_offset            :natural := congr_cl1_wA_offset     + 6;
constant congr_cl1_wC_offset            :natural := congr_cl1_wB_offset     + 6;
constant congr_cl1_wD_offset            :natural := congr_cl1_wC_offset     + 6;
constant congr_cl1_wE_offset            :natural := congr_cl1_wD_offset     + 6;
constant congr_cl1_wF_offset            :natural := congr_cl1_wE_offset     + 6;
constant congr_cl1_wG_offset            :natural := congr_cl1_wF_offset     + 6;
constant congr_cl1_wH_offset            :natural := congr_cl1_wG_offset     + 6;
constant congr_cl2_wA_offset            :natural := congr_cl1_wH_offset   + 6;
constant congr_cl2_wB_offset            :natural := congr_cl2_wA_offset     + 6;
constant congr_cl2_wC_offset            :natural := congr_cl2_wB_offset     + 6;
constant congr_cl2_wD_offset            :natural := congr_cl2_wC_offset     + 6;
constant congr_cl2_wE_offset            :natural := congr_cl2_wD_offset     + 6;
constant congr_cl2_wF_offset            :natural := congr_cl2_wE_offset     + 6;
constant congr_cl2_wG_offset            :natural := congr_cl2_wF_offset     + 6;
constant congr_cl2_wH_offset            :natural := congr_cl2_wG_offset     + 6;
constant congr_cl3_wA_offset            :natural := congr_cl2_wH_offset   + 6;
constant congr_cl3_wB_offset            :natural := congr_cl3_wA_offset     + 6;
constant congr_cl3_wC_offset            :natural := congr_cl3_wB_offset     + 6;
constant congr_cl3_wD_offset            :natural := congr_cl3_wC_offset     + 6;
constant congr_cl3_wE_offset            :natural := congr_cl3_wD_offset     + 6;
constant congr_cl3_wF_offset            :natural := congr_cl3_wE_offset     + 6;
constant congr_cl3_wG_offset            :natural := congr_cl3_wF_offset     + 6;
constant congr_cl3_wH_offset            :natural := congr_cl3_wG_offset     + 6;
constant congr_cl4_wA_offset            :natural := congr_cl3_wH_offset   + 6;
constant congr_cl4_wB_offset            :natural := congr_cl4_wA_offset     + 6;
constant congr_cl4_wC_offset            :natural := congr_cl4_wB_offset     + 6;
constant congr_cl4_wD_offset            :natural := congr_cl4_wC_offset     + 6;
constant congr_cl4_wE_offset            :natural := congr_cl4_wD_offset     + 6;
constant congr_cl4_wF_offset            :natural := congr_cl4_wE_offset     + 6;
constant congr_cl4_wG_offset            :natural := congr_cl4_wF_offset     + 6;
constant congr_cl4_wH_offset            :natural := congr_cl4_wG_offset     + 6;
constant congr_cl5_wA_offset            :natural := congr_cl4_wH_offset   + 6;
constant congr_cl5_wB_offset            :natural := congr_cl5_wA_offset     + 6;
constant congr_cl5_wC_offset            :natural := congr_cl5_wB_offset     + 6;
constant congr_cl5_wD_offset            :natural := congr_cl5_wC_offset     + 6;
constant congr_cl5_wE_offset            :natural := congr_cl5_wD_offset     + 6;
constant congr_cl5_wF_offset            :natural := congr_cl5_wE_offset     + 6;
constant congr_cl5_wG_offset            :natural := congr_cl5_wF_offset     + 6;
constant congr_cl5_wH_offset            :natural := congr_cl5_wG_offset     + 6;
constant congr_cl6_wA_offset            :natural := congr_cl5_wH_offset   + 6;
constant congr_cl6_wB_offset            :natural := congr_cl6_wA_offset     + 6;
constant congr_cl6_wC_offset            :natural := congr_cl6_wB_offset     + 6;
constant congr_cl6_wD_offset            :natural := congr_cl6_wC_offset     + 6;
constant congr_cl6_wE_offset            :natural := congr_cl6_wD_offset     + 6;
constant congr_cl6_wF_offset            :natural := congr_cl6_wE_offset     + 6;
constant congr_cl6_wG_offset            :natural := congr_cl6_wF_offset     + 6;
constant congr_cl6_wH_offset            :natural := congr_cl6_wG_offset     + 6;
constant congr_cl7_wA_offset            :natural := congr_cl6_wH_offset   + 6;
constant congr_cl7_wB_offset            :natural := congr_cl7_wA_offset     + 6;
constant congr_cl7_wC_offset            :natural := congr_cl7_wB_offset     + 6;
constant congr_cl7_wD_offset            :natural := congr_cl7_wC_offset     + 6;
constant congr_cl7_wE_offset            :natural := congr_cl7_wD_offset     + 6;
constant congr_cl7_wF_offset            :natural := congr_cl7_wE_offset     + 6;
constant congr_cl7_wG_offset            :natural := congr_cl7_wF_offset     + 6;
constant congr_cl7_wH_offset            :natural := congr_cl7_wG_offset     + 6;
constant congr_cl8_wA_offset            :natural := congr_cl7_wH_offset   + 6;
constant congr_cl8_wB_offset            :natural := congr_cl8_wA_offset     + 6;
constant congr_cl8_wC_offset            :natural := congr_cl8_wB_offset     + 6;
constant congr_cl8_wD_offset            :natural := congr_cl8_wC_offset     + 6;
constant congr_cl8_wE_offset            :natural := congr_cl8_wD_offset     + 6;
constant congr_cl8_wF_offset            :natural := congr_cl8_wE_offset     + 6;
constant congr_cl8_wG_offset            :natural := congr_cl8_wF_offset     + 6;
constant congr_cl8_wH_offset            :natural := congr_cl8_wG_offset     + 6;
constant congr_cl9_wA_offset            :natural := congr_cl8_wH_offset   + 6;
constant congr_cl9_wB_offset            :natural := congr_cl9_wA_offset     + 6;
constant congr_cl9_wC_offset            :natural := congr_cl9_wB_offset     + 6;
constant congr_cl9_wD_offset            :natural := congr_cl9_wC_offset     + 6;
constant congr_cl9_wE_offset            :natural := congr_cl9_wD_offset     + 6;
constant congr_cl9_wF_offset            :natural := congr_cl9_wE_offset     + 6;
constant congr_cl9_wG_offset            :natural := congr_cl9_wF_offset     + 6;
constant congr_cl9_wH_offset            :natural := congr_cl9_wG_offset     + 6;
constant congr_cl10_wA_offset           :natural := congr_cl9_wH_offset   + 6;
constant congr_cl10_wB_offset           :natural := congr_cl10_wA_offset    + 6;
constant congr_cl10_wC_offset           :natural := congr_cl10_wB_offset    + 6;
constant congr_cl10_wD_offset           :natural := congr_cl10_wC_offset    + 6;
constant congr_cl10_wE_offset           :natural := congr_cl10_wD_offset    + 6;
constant congr_cl10_wF_offset           :natural := congr_cl10_wE_offset    + 6;
constant congr_cl10_wG_offset           :natural := congr_cl10_wF_offset    + 6;
constant congr_cl10_wH_offset           :natural := congr_cl10_wG_offset    + 6;
constant congr_cl11_wA_offset           :natural := congr_cl10_wH_offset  + 6;
constant congr_cl11_wB_offset           :natural := congr_cl11_wA_offset    + 6;
constant congr_cl11_wC_offset           :natural := congr_cl11_wB_offset    + 6;
constant congr_cl11_wD_offset           :natural := congr_cl11_wC_offset    + 6;
constant congr_cl11_wE_offset           :natural := congr_cl11_wD_offset    + 6;
constant congr_cl11_wF_offset           :natural := congr_cl11_wE_offset    + 6;
constant congr_cl11_wG_offset           :natural := congr_cl11_wF_offset    + 6;
constant congr_cl11_wH_offset           :natural := congr_cl11_wG_offset    + 6;
constant congr_cl12_wA_offset           :natural := congr_cl11_wH_offset  + 6;
constant congr_cl12_wB_offset           :natural := congr_cl12_wA_offset    + 6;
constant congr_cl12_wC_offset           :natural := congr_cl12_wB_offset    + 6;
constant congr_cl12_wD_offset           :natural := congr_cl12_wC_offset    + 6;
constant congr_cl12_wE_offset           :natural := congr_cl12_wD_offset    + 6;
constant congr_cl12_wF_offset           :natural := congr_cl12_wE_offset    + 6;
constant congr_cl12_wG_offset           :natural := congr_cl12_wF_offset    + 6;
constant congr_cl12_wH_offset           :natural := congr_cl12_wG_offset    + 6;
constant congr_cl13_wA_offset           :natural := congr_cl12_wH_offset  + 6;
constant congr_cl13_wB_offset           :natural := congr_cl13_wA_offset    + 6;
constant congr_cl13_wC_offset           :natural := congr_cl13_wB_offset    + 6;
constant congr_cl13_wD_offset           :natural := congr_cl13_wC_offset    + 6;
constant congr_cl13_wE_offset           :natural := congr_cl13_wD_offset    + 6;
constant congr_cl13_wF_offset           :natural := congr_cl13_wE_offset    + 6;
constant congr_cl13_wG_offset           :natural := congr_cl13_wF_offset    + 6;
constant congr_cl13_wH_offset           :natural := congr_cl13_wG_offset    + 6;
constant congr_cl14_wA_offset           :natural := congr_cl13_wH_offset  + 6;
constant congr_cl14_wB_offset           :natural := congr_cl14_wA_offset    + 6;
constant congr_cl14_wC_offset           :natural := congr_cl14_wB_offset    + 6;
constant congr_cl14_wD_offset           :natural := congr_cl14_wC_offset    + 6;
constant congr_cl14_wE_offset           :natural := congr_cl14_wD_offset    + 6;
constant congr_cl14_wF_offset           :natural := congr_cl14_wE_offset    + 6;
constant congr_cl14_wG_offset           :natural := congr_cl14_wF_offset    + 6;
constant congr_cl14_wH_offset           :natural := congr_cl14_wG_offset    + 6;
constant congr_cl15_wA_offset           :natural := congr_cl14_wH_offset  + 6;
constant congr_cl15_wB_offset           :natural := congr_cl15_wA_offset    + 6;
constant congr_cl15_wC_offset           :natural := congr_cl15_wB_offset    + 6;
constant congr_cl15_wD_offset           :natural := congr_cl15_wC_offset    + 6;
constant congr_cl15_wE_offset           :natural := congr_cl15_wD_offset    + 6;
constant congr_cl15_wF_offset           :natural := congr_cl15_wE_offset    + 6;
constant congr_cl15_wG_offset           :natural := congr_cl15_wF_offset    + 6;
constant congr_cl15_wH_offset           :natural := congr_cl15_wG_offset    + 6;
constant congr_cl16_wA_offset           :natural := congr_cl15_wH_offset  + 6;
constant congr_cl16_wB_offset           :natural := congr_cl16_wA_offset    + 6;
constant congr_cl16_wC_offset           :natural := congr_cl16_wB_offset    + 6;
constant congr_cl16_wD_offset           :natural := congr_cl16_wC_offset    + 6;
constant congr_cl16_wE_offset           :natural := congr_cl16_wD_offset    + 6;
constant congr_cl16_wF_offset           :natural := congr_cl16_wE_offset    + 6;
constant congr_cl16_wG_offset           :natural := congr_cl16_wF_offset    + 6;
constant congr_cl16_wH_offset           :natural := congr_cl16_wG_offset    + 6;
constant congr_cl17_wA_offset           :natural := congr_cl16_wH_offset  + 6;
constant congr_cl17_wB_offset           :natural := congr_cl17_wA_offset    + 6;
constant congr_cl17_wC_offset           :natural := congr_cl17_wB_offset    + 6;
constant congr_cl17_wD_offset           :natural := congr_cl17_wC_offset    + 6;
constant congr_cl17_wE_offset           :natural := congr_cl17_wD_offset    + 6;
constant congr_cl17_wF_offset           :natural := congr_cl17_wE_offset    + 6;
constant congr_cl17_wG_offset           :natural := congr_cl17_wF_offset    + 6;
constant congr_cl17_wH_offset           :natural := congr_cl17_wG_offset    + 6;
constant congr_cl18_wA_offset           :natural := congr_cl17_wH_offset  + 6;
constant congr_cl18_wB_offset           :natural := congr_cl18_wA_offset    + 6;
constant congr_cl18_wC_offset           :natural := congr_cl18_wB_offset    + 6;
constant congr_cl18_wD_offset           :natural := congr_cl18_wC_offset    + 6;
constant congr_cl18_wE_offset           :natural := congr_cl18_wD_offset    + 6;
constant congr_cl18_wF_offset           :natural := congr_cl18_wE_offset    + 6;
constant congr_cl18_wG_offset           :natural := congr_cl18_wF_offset    + 6;
constant congr_cl18_wH_offset           :natural := congr_cl18_wG_offset    + 6;
constant congr_cl19_wA_offset           :natural := congr_cl18_wH_offset  + 6;
constant congr_cl19_wB_offset           :natural := congr_cl19_wA_offset    + 6;
constant congr_cl19_wC_offset           :natural := congr_cl19_wB_offset    + 6;
constant congr_cl19_wD_offset           :natural := congr_cl19_wC_offset    + 6;
constant congr_cl19_wE_offset           :natural := congr_cl19_wD_offset    + 6;
constant congr_cl19_wF_offset           :natural := congr_cl19_wE_offset    + 6;
constant congr_cl19_wG_offset           :natural := congr_cl19_wF_offset    + 6;
constant congr_cl19_wH_offset           :natural := congr_cl19_wG_offset    + 6;
constant congr_cl20_wA_offset           :natural := congr_cl19_wH_offset  + 6;
constant congr_cl20_wB_offset           :natural := congr_cl20_wA_offset    + 6;
constant congr_cl20_wC_offset           :natural := congr_cl20_wB_offset    + 6;
constant congr_cl20_wD_offset           :natural := congr_cl20_wC_offset    + 6;
constant congr_cl20_wE_offset           :natural := congr_cl20_wD_offset    + 6;
constant congr_cl20_wF_offset           :natural := congr_cl20_wE_offset    + 6;
constant congr_cl20_wG_offset           :natural := congr_cl20_wF_offset    + 6;
constant congr_cl20_wH_offset           :natural := congr_cl20_wG_offset    + 6;
constant congr_cl21_wA_offset           :natural := congr_cl20_wH_offset  + 6;
constant congr_cl21_wB_offset           :natural := congr_cl21_wA_offset    + 6;
constant congr_cl21_wC_offset           :natural := congr_cl21_wB_offset    + 6;
constant congr_cl21_wD_offset           :natural := congr_cl21_wC_offset    + 6;
constant congr_cl21_wE_offset           :natural := congr_cl21_wD_offset    + 6;
constant congr_cl21_wF_offset           :natural := congr_cl21_wE_offset    + 6;
constant congr_cl21_wG_offset           :natural := congr_cl21_wF_offset    + 6;
constant congr_cl21_wH_offset           :natural := congr_cl21_wG_offset    + 6;
constant congr_cl22_wA_offset           :natural := congr_cl21_wH_offset  + 6;
constant congr_cl22_wB_offset           :natural := congr_cl22_wA_offset    + 6;
constant congr_cl22_wC_offset           :natural := congr_cl22_wB_offset    + 6;
constant congr_cl22_wD_offset           :natural := congr_cl22_wC_offset    + 6;
constant congr_cl22_wE_offset           :natural := congr_cl22_wD_offset    + 6;
constant congr_cl22_wF_offset           :natural := congr_cl22_wE_offset    + 6;
constant congr_cl22_wG_offset           :natural := congr_cl22_wF_offset    + 6;
constant congr_cl22_wH_offset           :natural := congr_cl22_wG_offset    + 6;
constant congr_cl23_wA_offset           :natural := congr_cl22_wH_offset  + 6;
constant congr_cl23_wB_offset           :natural := congr_cl23_wA_offset    + 6;
constant congr_cl23_wC_offset           :natural := congr_cl23_wB_offset    + 6;
constant congr_cl23_wD_offset           :natural := congr_cl23_wC_offset    + 6;
constant congr_cl23_wE_offset           :natural := congr_cl23_wD_offset    + 6;
constant congr_cl23_wF_offset           :natural := congr_cl23_wE_offset    + 6;
constant congr_cl23_wG_offset           :natural := congr_cl23_wF_offset    + 6;
constant congr_cl23_wH_offset           :natural := congr_cl23_wG_offset    + 6;
constant congr_cl24_wA_offset           :natural := congr_cl23_wH_offset  + 6;
constant congr_cl24_wB_offset           :natural := congr_cl24_wA_offset    + 6;
constant congr_cl24_wC_offset           :natural := congr_cl24_wB_offset    + 6;
constant congr_cl24_wD_offset           :natural := congr_cl24_wC_offset    + 6;
constant congr_cl24_wE_offset           :natural := congr_cl24_wD_offset    + 6;
constant congr_cl24_wF_offset           :natural := congr_cl24_wE_offset    + 6;
constant congr_cl24_wG_offset           :natural := congr_cl24_wF_offset    + 6;
constant congr_cl24_wH_offset           :natural := congr_cl24_wG_offset    + 6;
constant congr_cl25_wA_offset           :natural := congr_cl24_wH_offset  + 6;
constant congr_cl25_wB_offset           :natural := congr_cl25_wA_offset    + 6;
constant congr_cl25_wC_offset           :natural := congr_cl25_wB_offset    + 6;
constant congr_cl25_wD_offset           :natural := congr_cl25_wC_offset    + 6;
constant congr_cl25_wE_offset           :natural := congr_cl25_wD_offset    + 6;
constant congr_cl25_wF_offset           :natural := congr_cl25_wE_offset    + 6;
constant congr_cl25_wG_offset           :natural := congr_cl25_wF_offset    + 6;
constant congr_cl25_wH_offset           :natural := congr_cl25_wG_offset    + 6;
constant congr_cl26_wA_offset           :natural := congr_cl25_wH_offset  + 6;
constant congr_cl26_wB_offset           :natural := congr_cl26_wA_offset    + 6;
constant congr_cl26_wC_offset           :natural := congr_cl26_wB_offset    + 6;
constant congr_cl26_wD_offset           :natural := congr_cl26_wC_offset    + 6;
constant congr_cl26_wE_offset           :natural := congr_cl26_wD_offset    + 6;
constant congr_cl26_wF_offset           :natural := congr_cl26_wE_offset    + 6;
constant congr_cl26_wG_offset           :natural := congr_cl26_wF_offset    + 6;
constant congr_cl26_wH_offset           :natural := congr_cl26_wG_offset    + 6;
constant congr_cl27_wA_offset           :natural := congr_cl26_wH_offset  + 6;
constant congr_cl27_wB_offset           :natural := congr_cl27_wA_offset    + 6;
constant congr_cl27_wC_offset           :natural := congr_cl27_wB_offset    + 6;
constant congr_cl27_wD_offset           :natural := congr_cl27_wC_offset    + 6;
constant congr_cl27_wE_offset           :natural := congr_cl27_wD_offset    + 6;
constant congr_cl27_wF_offset           :natural := congr_cl27_wE_offset    + 6;
constant congr_cl27_wG_offset           :natural := congr_cl27_wF_offset    + 6;
constant congr_cl27_wH_offset           :natural := congr_cl27_wG_offset    + 6;
constant congr_cl28_wA_offset           :natural := congr_cl27_wH_offset  + 6;
constant congr_cl28_wB_offset           :natural := congr_cl28_wA_offset    + 6;
constant congr_cl28_wC_offset           :natural := congr_cl28_wB_offset    + 6;
constant congr_cl28_wD_offset           :natural := congr_cl28_wC_offset    + 6;
constant congr_cl28_wE_offset           :natural := congr_cl28_wD_offset    + 6;
constant congr_cl28_wF_offset           :natural := congr_cl28_wE_offset    + 6;
constant congr_cl28_wG_offset           :natural := congr_cl28_wF_offset    + 6;
constant congr_cl28_wH_offset           :natural := congr_cl28_wG_offset    + 6;
constant congr_cl29_wA_offset           :natural := congr_cl28_wH_offset  + 6;
constant congr_cl29_wB_offset           :natural := congr_cl29_wA_offset    + 6;
constant congr_cl29_wC_offset           :natural := congr_cl29_wB_offset    + 6;
constant congr_cl29_wD_offset           :natural := congr_cl29_wC_offset    + 6;
constant congr_cl29_wE_offset           :natural := congr_cl29_wD_offset    + 6;
constant congr_cl29_wF_offset           :natural := congr_cl29_wE_offset    + 6;
constant congr_cl29_wG_offset           :natural := congr_cl29_wF_offset    + 6;
constant congr_cl29_wH_offset           :natural := congr_cl29_wG_offset    + 6;
constant congr_cl30_wA_offset           :natural := congr_cl29_wH_offset  + 6;
constant congr_cl30_wB_offset           :natural := congr_cl30_wA_offset    + 6;
constant congr_cl30_wC_offset           :natural := congr_cl30_wB_offset    + 6;
constant congr_cl30_wD_offset           :natural := congr_cl30_wC_offset    + 6;
constant congr_cl30_wE_offset           :natural := congr_cl30_wD_offset    + 6;
constant congr_cl30_wF_offset           :natural := congr_cl30_wE_offset    + 6;
constant congr_cl30_wG_offset           :natural := congr_cl30_wF_offset    + 6;
constant congr_cl30_wH_offset           :natural := congr_cl30_wG_offset    + 6;
constant congr_cl31_wA_offset           :natural := congr_cl30_wH_offset  + 6;
constant congr_cl31_wB_offset           :natural := congr_cl31_wA_offset    + 6;
constant congr_cl31_wC_offset           :natural := congr_cl31_wB_offset    + 6;
constant congr_cl31_wD_offset           :natural := congr_cl31_wC_offset    + 6;
constant congr_cl31_wE_offset           :natural := congr_cl31_wD_offset    + 6;
constant congr_cl31_wF_offset           :natural := congr_cl31_wE_offset    + 6;
constant congr_cl31_wG_offset           :natural := congr_cl31_wF_offset    + 6;
constant congr_cl31_wH_offset           :natural := congr_cl31_wG_offset    + 6;
constant congr_cl32_wA_offset           :natural := congr_cl31_wH_offset  + 6;
constant congr_cl32_wB_offset           :natural := congr_cl32_wA_offset    + 6;
constant congr_cl32_wC_offset           :natural := congr_cl32_wB_offset    + 6;
constant congr_cl32_wD_offset           :natural := congr_cl32_wC_offset    + 6;
constant congr_cl32_wE_offset           :natural := congr_cl32_wD_offset    + 6;
constant congr_cl32_wF_offset           :natural := congr_cl32_wE_offset    + 6;
constant congr_cl32_wG_offset           :natural := congr_cl32_wF_offset    + 6;
constant congr_cl32_wH_offset           :natural := congr_cl32_wG_offset    + 6;
constant congr_cl33_wA_offset           :natural := congr_cl32_wH_offset  + 6;
constant congr_cl33_wB_offset           :natural := congr_cl33_wA_offset    + 6;
constant congr_cl33_wC_offset           :natural := congr_cl33_wB_offset    + 6;
constant congr_cl33_wD_offset           :natural := congr_cl33_wC_offset    + 6;
constant congr_cl33_wE_offset           :natural := congr_cl33_wD_offset    + 6;
constant congr_cl33_wF_offset           :natural := congr_cl33_wE_offset    + 6;
constant congr_cl33_wG_offset           :natural := congr_cl33_wF_offset    + 6;
constant congr_cl33_wH_offset           :natural := congr_cl33_wG_offset    + 6;
constant congr_cl34_wA_offset           :natural := congr_cl33_wH_offset  + 6;
constant congr_cl34_wB_offset           :natural := congr_cl34_wA_offset    + 6;
constant congr_cl34_wC_offset           :natural := congr_cl34_wB_offset    + 6;
constant congr_cl34_wD_offset           :natural := congr_cl34_wC_offset    + 6;
constant congr_cl34_wE_offset           :natural := congr_cl34_wD_offset    + 6;
constant congr_cl34_wF_offset           :natural := congr_cl34_wE_offset    + 6;
constant congr_cl34_wG_offset           :natural := congr_cl34_wF_offset    + 6;
constant congr_cl34_wH_offset           :natural := congr_cl34_wG_offset    + 6;
constant congr_cl35_wA_offset           :natural := congr_cl34_wH_offset  + 6;
constant congr_cl35_wB_offset           :natural := congr_cl35_wA_offset    + 6;
constant congr_cl35_wC_offset           :natural := congr_cl35_wB_offset    + 6;
constant congr_cl35_wD_offset           :natural := congr_cl35_wC_offset    + 6;
constant congr_cl35_wE_offset           :natural := congr_cl35_wD_offset    + 6;
constant congr_cl35_wF_offset           :natural := congr_cl35_wE_offset    + 6;
constant congr_cl35_wG_offset           :natural := congr_cl35_wF_offset    + 6;
constant congr_cl35_wH_offset           :natural := congr_cl35_wG_offset    + 6;
constant congr_cl36_wA_offset           :natural := congr_cl35_wH_offset  + 6;
constant congr_cl36_wB_offset           :natural := congr_cl36_wA_offset    + 6;
constant congr_cl36_wC_offset           :natural := congr_cl36_wB_offset    + 6;
constant congr_cl36_wD_offset           :natural := congr_cl36_wC_offset    + 6;
constant congr_cl36_wE_offset           :natural := congr_cl36_wD_offset    + 6;
constant congr_cl36_wF_offset           :natural := congr_cl36_wE_offset    + 6;
constant congr_cl36_wG_offset           :natural := congr_cl36_wF_offset    + 6;
constant congr_cl36_wH_offset           :natural := congr_cl36_wG_offset    + 6;
constant congr_cl37_wA_offset           :natural := congr_cl36_wH_offset  + 6;
constant congr_cl37_wB_offset           :natural := congr_cl37_wA_offset    + 6;
constant congr_cl37_wC_offset           :natural := congr_cl37_wB_offset    + 6;
constant congr_cl37_wD_offset           :natural := congr_cl37_wC_offset    + 6;
constant congr_cl37_wE_offset           :natural := congr_cl37_wD_offset    + 6;
constant congr_cl37_wF_offset           :natural := congr_cl37_wE_offset    + 6;
constant congr_cl37_wG_offset           :natural := congr_cl37_wF_offset    + 6;
constant congr_cl37_wH_offset           :natural := congr_cl37_wG_offset    + 6;
constant congr_cl38_wA_offset           :natural := congr_cl37_wH_offset  + 6;
constant congr_cl38_wB_offset           :natural := congr_cl38_wA_offset    + 6;
constant congr_cl38_wC_offset           :natural := congr_cl38_wB_offset    + 6;
constant congr_cl38_wD_offset           :natural := congr_cl38_wC_offset    + 6;
constant congr_cl38_wE_offset           :natural := congr_cl38_wD_offset    + 6;
constant congr_cl38_wF_offset           :natural := congr_cl38_wE_offset    + 6;
constant congr_cl38_wG_offset           :natural := congr_cl38_wF_offset    + 6;
constant congr_cl38_wH_offset           :natural := congr_cl38_wG_offset    + 6;
constant congr_cl39_wA_offset           :natural := congr_cl38_wH_offset  + 6;
constant congr_cl39_wB_offset           :natural := congr_cl39_wA_offset    + 6;
constant congr_cl39_wC_offset           :natural := congr_cl39_wB_offset    + 6;
constant congr_cl39_wD_offset           :natural := congr_cl39_wC_offset    + 6;
constant congr_cl39_wE_offset           :natural := congr_cl39_wD_offset    + 6;
constant congr_cl39_wF_offset           :natural := congr_cl39_wE_offset    + 6;
constant congr_cl39_wG_offset           :natural := congr_cl39_wF_offset    + 6;
constant congr_cl39_wH_offset           :natural := congr_cl39_wG_offset    + 6;
constant congr_cl40_wA_offset           :natural := congr_cl39_wH_offset  + 6;
constant congr_cl40_wB_offset           :natural := congr_cl40_wA_offset    + 6;
constant congr_cl40_wC_offset           :natural := congr_cl40_wB_offset    + 6;
constant congr_cl40_wD_offset           :natural := congr_cl40_wC_offset    + 6;
constant congr_cl40_wE_offset           :natural := congr_cl40_wD_offset    + 6;
constant congr_cl40_wF_offset           :natural := congr_cl40_wE_offset    + 6;
constant congr_cl40_wG_offset           :natural := congr_cl40_wF_offset    + 6;
constant congr_cl40_wH_offset           :natural := congr_cl40_wG_offset    + 6;
constant congr_cl41_wA_offset           :natural := congr_cl40_wH_offset  + 6;
constant congr_cl41_wB_offset           :natural := congr_cl41_wA_offset    + 6;
constant congr_cl41_wC_offset           :natural := congr_cl41_wB_offset    + 6;
constant congr_cl41_wD_offset           :natural := congr_cl41_wC_offset    + 6;
constant congr_cl41_wE_offset           :natural := congr_cl41_wD_offset    + 6;
constant congr_cl41_wF_offset           :natural := congr_cl41_wE_offset    + 6;
constant congr_cl41_wG_offset           :natural := congr_cl41_wF_offset    + 6;
constant congr_cl41_wH_offset           :natural := congr_cl41_wG_offset    + 6;
constant congr_cl42_wA_offset           :natural := congr_cl41_wH_offset  + 6;
constant congr_cl42_wB_offset           :natural := congr_cl42_wA_offset    + 6;
constant congr_cl42_wC_offset           :natural := congr_cl42_wB_offset    + 6;
constant congr_cl42_wD_offset           :natural := congr_cl42_wC_offset    + 6;
constant congr_cl42_wE_offset           :natural := congr_cl42_wD_offset    + 6;
constant congr_cl42_wF_offset           :natural := congr_cl42_wE_offset    + 6;
constant congr_cl42_wG_offset           :natural := congr_cl42_wF_offset    + 6;
constant congr_cl42_wH_offset           :natural := congr_cl42_wG_offset    + 6;
constant congr_cl43_wA_offset           :natural := congr_cl42_wH_offset  + 6;
constant congr_cl43_wB_offset           :natural := congr_cl43_wA_offset    + 6;
constant congr_cl43_wC_offset           :natural := congr_cl43_wB_offset    + 6;
constant congr_cl43_wD_offset           :natural := congr_cl43_wC_offset    + 6;
constant congr_cl43_wE_offset           :natural := congr_cl43_wD_offset    + 6;
constant congr_cl43_wF_offset           :natural := congr_cl43_wE_offset    + 6;
constant congr_cl43_wG_offset           :natural := congr_cl43_wF_offset    + 6;
constant congr_cl43_wH_offset           :natural := congr_cl43_wG_offset    + 6;
constant congr_cl44_wA_offset           :natural := congr_cl43_wH_offset  + 6;
constant congr_cl44_wB_offset           :natural := congr_cl44_wA_offset    + 6;
constant congr_cl44_wC_offset           :natural := congr_cl44_wB_offset    + 6;
constant congr_cl44_wD_offset           :natural := congr_cl44_wC_offset    + 6;
constant congr_cl44_wE_offset           :natural := congr_cl44_wD_offset    + 6;
constant congr_cl44_wF_offset           :natural := congr_cl44_wE_offset    + 6;
constant congr_cl44_wG_offset           :natural := congr_cl44_wF_offset    + 6;
constant congr_cl44_wH_offset           :natural := congr_cl44_wG_offset    + 6;
constant congr_cl45_wA_offset           :natural := congr_cl44_wH_offset  + 6;
constant congr_cl45_wB_offset           :natural := congr_cl45_wA_offset    + 6;
constant congr_cl45_wC_offset           :natural := congr_cl45_wB_offset    + 6;
constant congr_cl45_wD_offset           :natural := congr_cl45_wC_offset    + 6;
constant congr_cl45_wE_offset           :natural := congr_cl45_wD_offset    + 6;
constant congr_cl45_wF_offset           :natural := congr_cl45_wE_offset    + 6;
constant congr_cl45_wG_offset           :natural := congr_cl45_wF_offset    + 6;
constant congr_cl45_wH_offset           :natural := congr_cl45_wG_offset    + 6;
constant congr_cl46_wA_offset           :natural := congr_cl45_wH_offset  + 6;
constant congr_cl46_wB_offset           :natural := congr_cl46_wA_offset    + 6;
constant congr_cl46_wC_offset           :natural := congr_cl46_wB_offset    + 6;
constant congr_cl46_wD_offset           :natural := congr_cl46_wC_offset    + 6;
constant congr_cl46_wE_offset           :natural := congr_cl46_wD_offset    + 6;
constant congr_cl46_wF_offset           :natural := congr_cl46_wE_offset    + 6;
constant congr_cl46_wG_offset           :natural := congr_cl46_wF_offset    + 6;
constant congr_cl46_wH_offset           :natural := congr_cl46_wG_offset    + 6;
constant congr_cl47_wA_offset           :natural := congr_cl46_wH_offset  + 6;
constant congr_cl47_wB_offset           :natural := congr_cl47_wA_offset    + 6;
constant congr_cl47_wC_offset           :natural := congr_cl47_wB_offset    + 6;
constant congr_cl47_wD_offset           :natural := congr_cl47_wC_offset    + 6;
constant congr_cl47_wE_offset           :natural := congr_cl47_wD_offset    + 6;
constant congr_cl47_wF_offset           :natural := congr_cl47_wE_offset    + 6;
constant congr_cl47_wG_offset           :natural := congr_cl47_wF_offset    + 6;
constant congr_cl47_wH_offset           :natural := congr_cl47_wG_offset    + 6;
constant congr_cl48_wA_offset           :natural := congr_cl47_wH_offset  + 6;
constant congr_cl48_wB_offset           :natural := congr_cl48_wA_offset    + 6;
constant congr_cl48_wC_offset           :natural := congr_cl48_wB_offset    + 6;
constant congr_cl48_wD_offset           :natural := congr_cl48_wC_offset    + 6;
constant congr_cl48_wE_offset           :natural := congr_cl48_wD_offset    + 6;
constant congr_cl48_wF_offset           :natural := congr_cl48_wE_offset    + 6;
constant congr_cl48_wG_offset           :natural := congr_cl48_wF_offset    + 6;
constant congr_cl48_wH_offset           :natural := congr_cl48_wG_offset    + 6;
constant congr_cl49_wA_offset           :natural := congr_cl48_wH_offset  + 6;
constant congr_cl49_wB_offset           :natural := congr_cl49_wA_offset    + 6;
constant congr_cl49_wC_offset           :natural := congr_cl49_wB_offset    + 6;
constant congr_cl49_wD_offset           :natural := congr_cl49_wC_offset    + 6;
constant congr_cl49_wE_offset           :natural := congr_cl49_wD_offset    + 6;
constant congr_cl49_wF_offset           :natural := congr_cl49_wE_offset    + 6;
constant congr_cl49_wG_offset           :natural := congr_cl49_wF_offset    + 6;
constant congr_cl49_wH_offset           :natural := congr_cl49_wG_offset    + 6;
constant congr_cl50_wA_offset           :natural := congr_cl49_wH_offset  + 6;
constant congr_cl50_wB_offset           :natural := congr_cl50_wA_offset    + 6;
constant congr_cl50_wC_offset           :natural := congr_cl50_wB_offset    + 6;
constant congr_cl50_wD_offset           :natural := congr_cl50_wC_offset    + 6;
constant congr_cl50_wE_offset           :natural := congr_cl50_wD_offset    + 6;
constant congr_cl50_wF_offset           :natural := congr_cl50_wE_offset    + 6;
constant congr_cl50_wG_offset           :natural := congr_cl50_wF_offset    + 6;
constant congr_cl50_wH_offset           :natural := congr_cl50_wG_offset    + 6;
constant congr_cl51_wA_offset           :natural := congr_cl50_wH_offset  + 6;
constant congr_cl51_wB_offset           :natural := congr_cl51_wA_offset    + 6;
constant congr_cl51_wC_offset           :natural := congr_cl51_wB_offset    + 6;
constant congr_cl51_wD_offset           :natural := congr_cl51_wC_offset    + 6;
constant congr_cl51_wE_offset           :natural := congr_cl51_wD_offset    + 6;
constant congr_cl51_wF_offset           :natural := congr_cl51_wE_offset    + 6;
constant congr_cl51_wG_offset           :natural := congr_cl51_wF_offset    + 6;
constant congr_cl51_wH_offset           :natural := congr_cl51_wG_offset    + 6;
constant congr_cl52_wA_offset           :natural := congr_cl51_wH_offset  + 6;
constant congr_cl52_wB_offset           :natural := congr_cl52_wA_offset    + 6;
constant congr_cl52_wC_offset           :natural := congr_cl52_wB_offset    + 6;
constant congr_cl52_wD_offset           :natural := congr_cl52_wC_offset    + 6;
constant congr_cl52_wE_offset           :natural := congr_cl52_wD_offset    + 6;
constant congr_cl52_wF_offset           :natural := congr_cl52_wE_offset    + 6;
constant congr_cl52_wG_offset           :natural := congr_cl52_wF_offset    + 6;
constant congr_cl52_wH_offset           :natural := congr_cl52_wG_offset    + 6;
constant congr_cl53_wA_offset           :natural := congr_cl52_wH_offset  + 6;
constant congr_cl53_wB_offset           :natural := congr_cl53_wA_offset    + 6;
constant congr_cl53_wC_offset           :natural := congr_cl53_wB_offset    + 6;
constant congr_cl53_wD_offset           :natural := congr_cl53_wC_offset    + 6;
constant congr_cl53_wE_offset           :natural := congr_cl53_wD_offset    + 6;
constant congr_cl53_wF_offset           :natural := congr_cl53_wE_offset    + 6;
constant congr_cl53_wG_offset           :natural := congr_cl53_wF_offset    + 6;
constant congr_cl53_wH_offset           :natural := congr_cl53_wG_offset    + 6;
constant congr_cl54_wA_offset           :natural := congr_cl53_wH_offset  + 6;
constant congr_cl54_wB_offset           :natural := congr_cl54_wA_offset    + 6;
constant congr_cl54_wC_offset           :natural := congr_cl54_wB_offset    + 6;
constant congr_cl54_wD_offset           :natural := congr_cl54_wC_offset    + 6;
constant congr_cl54_wE_offset           :natural := congr_cl54_wD_offset    + 6;
constant congr_cl54_wF_offset           :natural := congr_cl54_wE_offset    + 6;
constant congr_cl54_wG_offset           :natural := congr_cl54_wF_offset    + 6;
constant congr_cl54_wH_offset           :natural := congr_cl54_wG_offset    + 6;
constant congr_cl55_wA_offset           :natural := congr_cl54_wH_offset  + 6;
constant congr_cl55_wB_offset           :natural := congr_cl55_wA_offset    + 6;
constant congr_cl55_wC_offset           :natural := congr_cl55_wB_offset    + 6;
constant congr_cl55_wD_offset           :natural := congr_cl55_wC_offset    + 6;
constant congr_cl55_wE_offset           :natural := congr_cl55_wD_offset    + 6;
constant congr_cl55_wF_offset           :natural := congr_cl55_wE_offset    + 6;
constant congr_cl55_wG_offset           :natural := congr_cl55_wF_offset    + 6;
constant congr_cl55_wH_offset           :natural := congr_cl55_wG_offset    + 6;
constant congr_cl56_wA_offset           :natural := congr_cl55_wH_offset  + 6;
constant congr_cl56_wB_offset           :natural := congr_cl56_wA_offset    + 6;
constant congr_cl56_wC_offset           :natural := congr_cl56_wB_offset    + 6;
constant congr_cl56_wD_offset           :natural := congr_cl56_wC_offset    + 6;
constant congr_cl56_wE_offset           :natural := congr_cl56_wD_offset    + 6;
constant congr_cl56_wF_offset           :natural := congr_cl56_wE_offset    + 6;
constant congr_cl56_wG_offset           :natural := congr_cl56_wF_offset    + 6;
constant congr_cl56_wH_offset           :natural := congr_cl56_wG_offset    + 6;
constant congr_cl57_wA_offset           :natural := congr_cl56_wH_offset  + 6;
constant congr_cl57_wB_offset           :natural := congr_cl57_wA_offset    + 6;
constant congr_cl57_wC_offset           :natural := congr_cl57_wB_offset    + 6;
constant congr_cl57_wD_offset           :natural := congr_cl57_wC_offset    + 6;
constant congr_cl57_wE_offset           :natural := congr_cl57_wD_offset    + 6;
constant congr_cl57_wF_offset           :natural := congr_cl57_wE_offset    + 6;
constant congr_cl57_wG_offset           :natural := congr_cl57_wF_offset    + 6;
constant congr_cl57_wH_offset           :natural := congr_cl57_wG_offset    + 6;
constant congr_cl58_wA_offset           :natural := congr_cl57_wH_offset  + 6;
constant congr_cl58_wB_offset           :natural := congr_cl58_wA_offset    + 6;
constant congr_cl58_wC_offset           :natural := congr_cl58_wB_offset    + 6;
constant congr_cl58_wD_offset           :natural := congr_cl58_wC_offset    + 6;
constant congr_cl58_wE_offset           :natural := congr_cl58_wD_offset    + 6;
constant congr_cl58_wF_offset           :natural := congr_cl58_wE_offset    + 6;
constant congr_cl58_wG_offset           :natural := congr_cl58_wF_offset    + 6;
constant congr_cl58_wH_offset           :natural := congr_cl58_wG_offset    + 6;
constant congr_cl59_wA_offset           :natural := congr_cl58_wH_offset  + 6;
constant congr_cl59_wB_offset           :natural := congr_cl59_wA_offset    + 6;
constant congr_cl59_wC_offset           :natural := congr_cl59_wB_offset    + 6;
constant congr_cl59_wD_offset           :natural := congr_cl59_wC_offset    + 6;
constant congr_cl59_wE_offset           :natural := congr_cl59_wD_offset    + 6;
constant congr_cl59_wF_offset           :natural := congr_cl59_wE_offset    + 6;
constant congr_cl59_wG_offset           :natural := congr_cl59_wF_offset    + 6;
constant congr_cl59_wH_offset           :natural := congr_cl59_wG_offset    + 6;
constant congr_cl60_wA_offset           :natural := congr_cl59_wH_offset  + 6;
constant congr_cl60_wB_offset           :natural := congr_cl60_wA_offset    + 6;
constant congr_cl60_wC_offset           :natural := congr_cl60_wB_offset    + 6;
constant congr_cl60_wD_offset           :natural := congr_cl60_wC_offset    + 6;
constant congr_cl60_wE_offset           :natural := congr_cl60_wD_offset    + 6;
constant congr_cl60_wF_offset           :natural := congr_cl60_wE_offset    + 6;
constant congr_cl60_wG_offset           :natural := congr_cl60_wF_offset    + 6;
constant congr_cl60_wH_offset           :natural := congr_cl60_wG_offset    + 6;
constant congr_cl61_wA_offset           :natural := congr_cl60_wH_offset  + 6;
constant congr_cl61_wB_offset           :natural := congr_cl61_wA_offset    + 6;
constant congr_cl61_wC_offset           :natural := congr_cl61_wB_offset    + 6;
constant congr_cl61_wD_offset           :natural := congr_cl61_wC_offset    + 6;
constant congr_cl61_wE_offset           :natural := congr_cl61_wD_offset    + 6;
constant congr_cl61_wF_offset           :natural := congr_cl61_wE_offset    + 6;
constant congr_cl61_wG_offset           :natural := congr_cl61_wF_offset    + 6;
constant congr_cl61_wH_offset           :natural := congr_cl61_wG_offset    + 6;
constant congr_cl62_wA_offset           :natural := congr_cl61_wH_offset  + 6;
constant congr_cl62_wB_offset           :natural := congr_cl62_wA_offset    + 6;
constant congr_cl62_wC_offset           :natural := congr_cl62_wB_offset    + 6;
constant congr_cl62_wD_offset           :natural := congr_cl62_wC_offset    + 6;
constant congr_cl62_wE_offset           :natural := congr_cl62_wD_offset    + 6;
constant congr_cl62_wF_offset           :natural := congr_cl62_wE_offset    + 6;
constant congr_cl62_wG_offset           :natural := congr_cl62_wF_offset    + 6;
constant congr_cl62_wH_offset           :natural := congr_cl62_wG_offset    + 6;
constant congr_cl63_wA_offset           :natural := congr_cl62_wH_offset  + 6;
constant congr_cl63_wB_offset           :natural := congr_cl63_wA_offset    + 6;
constant congr_cl63_wC_offset           :natural := congr_cl63_wB_offset    + 6;
constant congr_cl63_wD_offset           :natural := congr_cl63_wC_offset    + 6;
constant congr_cl63_wE_offset           :natural := congr_cl63_wD_offset    + 6;
constant congr_cl63_wF_offset           :natural := congr_cl63_wE_offset    + 6;
constant congr_cl63_wG_offset           :natural := congr_cl63_wF_offset    + 6;
constant congr_cl63_wH_offset           :natural := congr_cl63_wG_offset    + 6;
constant flush_wayA_data_offset         :natural := congr_cl63_wH_offset + 6;
constant flush_wayB_data_offset         :natural := flush_wayA_data_offset + 6;
constant flush_wayC_data_offset         :natural := flush_wayB_data_offset + 6;
constant flush_wayD_data_offset         :natural := flush_wayC_data_offset + 6;
constant flush_wayE_data_offset         :natural := flush_wayD_data_offset + 6;
constant flush_wayF_data_offset         :natural := flush_wayE_data_offset + 6;
constant flush_wayG_data_offset         :natural := flush_wayF_data_offset + 6;
constant flush_wayH_data_offset         :natural := flush_wayG_data_offset + 6;
constant ex3_flush_cline_offset         :natural := flush_wayH_data_offset + 6;
constant ex5_congr_cl_offset            :natural := ex3_flush_cline_offset + 1;
constant ex7_congr_cl_offset            :natural := ex5_congr_cl_offset + 6;
constant ex8_congr_cl_offset            :natural := ex7_congr_cl_offset + 6;
constant ex9_congr_cl_offset            :natural := ex8_congr_cl_offset + 6;
constant wayA_val_b_offset              :natural := ex9_congr_cl_offset + 6;
constant wayB_val_b_offset              :natural := wayA_val_b_offset + 6;
constant wayC_val_b_offset              :natural := wayB_val_b_offset + 6;
constant wayD_val_b_offset              :natural := wayC_val_b_offset + 6;
constant wayE_val_b_offset              :natural := wayD_val_b_offset + 6;
constant wayF_val_b_offset              :natural := wayE_val_b_offset + 6;
constant wayG_val_b_offset              :natural := wayF_val_b_offset + 6;
constant wayH_val_b_offset              :natural := wayG_val_b_offset + 6;
constant ex3_wayA_fxubyp_val_offset     :natural := wayH_val_b_offset + 6;
constant ex3_wayB_fxubyp_val_offset     :natural := ex3_wayA_fxubyp_val_offset + 1;
constant ex3_wayC_fxubyp_val_offset     :natural := ex3_wayB_fxubyp_val_offset + 1;
constant ex3_wayD_fxubyp_val_offset     :natural := ex3_wayC_fxubyp_val_offset + 1;
constant ex3_wayE_fxubyp_val_offset     :natural := ex3_wayD_fxubyp_val_offset + 1;
constant ex3_wayF_fxubyp_val_offset     :natural := ex3_wayE_fxubyp_val_offset + 1;
constant ex3_wayG_fxubyp_val_offset     :natural := ex3_wayF_fxubyp_val_offset + 1;
constant ex3_wayH_fxubyp_val_offset     :natural := ex3_wayG_fxubyp_val_offset + 1;
constant ex3_wayA_relbyp_val_offset     :natural := ex3_wayH_fxubyp_val_offset + 1;
constant ex3_wayB_relbyp_val_offset     :natural := ex3_wayA_relbyp_val_offset + 1;
constant ex3_wayC_relbyp_val_offset     :natural := ex3_wayB_relbyp_val_offset + 1;
constant ex3_wayD_relbyp_val_offset     :natural := ex3_wayC_relbyp_val_offset + 1;
constant ex3_wayE_relbyp_val_offset     :natural := ex3_wayD_relbyp_val_offset + 1;
constant ex3_wayF_relbyp_val_offset     :natural := ex3_wayE_relbyp_val_offset + 1;
constant ex3_wayG_relbyp_val_offset     :natural := ex3_wayF_relbyp_val_offset + 1;
constant ex3_wayH_relbyp_val_offset     :natural := ex3_wayG_relbyp_val_offset + 1;
constant ex4_xuop_wayA_upd_offset       :natural := ex3_wayH_relbyp_val_offset + 1;
constant ex4_xuop_wayB_upd_offset       :natural := ex4_xuop_wayA_upd_offset + 1;
constant ex4_xuop_wayC_upd_offset       :natural := ex4_xuop_wayB_upd_offset + 1;
constant ex4_xuop_wayD_upd_offset       :natural := ex4_xuop_wayC_upd_offset + 1;
constant ex4_xuop_wayE_upd_offset       :natural := ex4_xuop_wayD_upd_offset + 1;
constant ex4_xuop_wayF_upd_offset       :natural := ex4_xuop_wayE_upd_offset + 1;
constant ex4_xuop_wayG_upd_offset       :natural := ex4_xuop_wayF_upd_offset + 1;
constant ex4_xuop_wayH_upd_offset       :natural := ex4_xuop_wayG_upd_offset + 1;
constant ex5_xuop_wayA_upd_offset       :natural := ex4_xuop_wayH_upd_offset + 1;
constant ex5_xuop_wayB_upd_offset       :natural := ex5_xuop_wayA_upd_offset + 1;
constant ex5_xuop_wayC_upd_offset       :natural := ex5_xuop_wayB_upd_offset + 1;
constant ex5_xuop_wayD_upd_offset       :natural := ex5_xuop_wayC_upd_offset + 1;
constant ex5_xuop_wayE_upd_offset       :natural := ex5_xuop_wayD_upd_offset + 1;
constant ex5_xuop_wayF_upd_offset       :natural := ex5_xuop_wayE_upd_offset + 1;
constant ex5_xuop_wayG_upd_offset       :natural := ex5_xuop_wayF_upd_offset + 1;
constant ex5_xuop_wayH_upd_offset       :natural := ex5_xuop_wayG_upd_offset + 1;
constant inval_clr_lck_wA_offset        :natural := ex5_xuop_wayH_upd_offset + 1;
constant inval_clr_lck_wB_offset        :natural := inval_clr_lck_wA_offset + 1;
constant inval_clr_lck_wC_offset        :natural := inval_clr_lck_wB_offset + 1;
constant inval_clr_lck_wD_offset        :natural := inval_clr_lck_wC_offset + 1;
constant inval_clr_lck_wE_offset        :natural := inval_clr_lck_wD_offset + 1;
constant inval_clr_lck_wF_offset        :natural := inval_clr_lck_wE_offset + 1;
constant inval_clr_lck_wG_offset        :natural := inval_clr_lck_wF_offset + 1;
constant inval_clr_lck_wH_offset        :natural := inval_clr_lck_wG_offset + 1;
constant congr_cl_m_upd_wayA_offset     :natural := inval_clr_lck_wH_offset + 1;
constant congr_cl_m_upd_wayB_offset     :natural := congr_cl_m_upd_wayA_offset + 1;
constant congr_cl_m_upd_wayC_offset     :natural := congr_cl_m_upd_wayB_offset + 1;
constant congr_cl_m_upd_wayD_offset     :natural := congr_cl_m_upd_wayC_offset + 1;
constant congr_cl_m_upd_wayE_offset     :natural := congr_cl_m_upd_wayD_offset + 1;
constant congr_cl_m_upd_wayF_offset     :natural := congr_cl_m_upd_wayE_offset + 1;
constant congr_cl_m_upd_wayG_offset     :natural := congr_cl_m_upd_wayF_offset + 1;
constant congr_cl_m_upd_wayH_offset     :natural := congr_cl_m_upd_wayG_offset + 1;
constant ex3_congr_cl_offset            :natural := congr_cl_m_upd_wayH_offset + 1;
constant rel24_congr_cl_offset          :natural := ex3_congr_cl_offset + 6;
constant relu_s_congr_cl_offset         :natural := rel24_congr_cl_offset + 6;
constant reload_way_clr_offset          :natural := relu_s_congr_cl_offset + 6;
constant ex4_watchSet_coll_offset       :natural := reload_way_clr_offset + 8;
constant rel_wayA_val_b_offset          :natural := ex4_watchSet_coll_offset + 1;
constant rel_wayB_val_b_offset          :natural := rel_wayA_val_b_offset + 6;
constant rel_wayC_val_b_offset          :natural := rel_wayB_val_b_offset + 6;
constant rel_wayD_val_b_offset          :natural := rel_wayC_val_b_offset + 6;
constant rel_wayE_val_b_offset          :natural := rel_wayD_val_b_offset + 6;
constant rel_wayF_val_b_offset          :natural := rel_wayE_val_b_offset + 6;
constant rel_wayG_val_b_offset          :natural := rel_wayF_val_b_offset + 6;
constant rel_wayH_val_b_offset          :natural := rel_wayG_val_b_offset + 6;
constant rel_val_stg2_offset            :natural := rel_wayH_val_b_offset + 6;
constant rel_val_clr_offset             :natural := rel_val_stg2_offset + 1;
constant rel_port_upd_offset            :natural := rel_val_clr_offset + 1;
constant rel_val_stg4_offset            :natural := rel_port_upd_offset + 1;
constant rel_binv_stg4_offset           :natural := rel_val_stg4_offset + 1;
constant back_inval_stg3_offset         :natural := rel_binv_stg4_offset + 1;
constant back_inval_stg4_offset         :natural := back_inval_stg3_offset + 1;
constant back_inval_stg5_offset         :natural := back_inval_stg4_offset + 1;
constant binv4_ex4_xuop_upd_offset      :natural := back_inval_stg5_offset + 1;
constant binv4_ex4_dir_val_offset       :natural := binv4_ex4_xuop_upd_offset + 1;
constant ex4_dir_err_val_offset         :natural := binv4_ex4_dir_val_offset + 1;
constant ex5_dir_err_val_offset         :natural := ex4_dir_err_val_offset + 1;
constant ex6_dir_err_val_offset         :natural := ex5_dir_err_val_offset + 1;
constant derr2_stg_act_offset           :natural := ex6_dir_err_val_offset + 1;
constant derr3_stg_act_offset           :natural := derr2_stg_act_offset + 1;
constant derr4_stg_act_offset           :natural := derr3_stg_act_offset + 1;
constant derr5_stg_act_offset           :natural := derr4_stg_act_offset + 1;
constant ex4_dir_multihit_val_b_offset  :natural := derr5_stg_act_offset + 1;
constant ex4_n_lsu_ddmh_flush_b_offset  :natural := ex4_dir_multihit_val_b_offset + 1;
constant dcarr_up_way_addr_offset       :natural := ex4_n_lsu_ddmh_flush_b_offset + 4;
constant reload_wayA_data_offset        :natural := dcarr_up_way_addr_offset + 3;
constant reload_wayB_data_offset        :natural := reload_wayA_data_offset + 6;
constant reload_wayC_data_offset        :natural := reload_wayB_data_offset + 6;
constant reload_wayD_data_offset        :natural := reload_wayC_data_offset + 6;
constant reload_wayE_data_offset        :natural := reload_wayD_data_offset + 6;
constant reload_wayF_data_offset        :natural := reload_wayE_data_offset + 6;
constant reload_wayG_data_offset        :natural := reload_wayF_data_offset + 6;
constant reload_wayH_data_offset        :natural := reload_wayG_data_offset + 6;
constant binv_wayA_upd_offset           :natural := reload_wayH_data_offset + 6;
constant binv_wayB_upd_offset           :natural := binv_wayA_upd_offset + 1;
constant binv_wayC_upd_offset           :natural := binv_wayB_upd_offset + 1;
constant binv_wayD_upd_offset           :natural := binv_wayC_upd_offset + 1;
constant binv_wayE_upd_offset           :natural := binv_wayD_upd_offset + 1;
constant binv_wayF_upd_offset           :natural := binv_wayE_upd_offset + 1;
constant binv_wayG_upd_offset           :natural := binv_wayF_upd_offset + 1;
constant binv_wayH_upd_offset           :natural := binv_wayG_upd_offset + 1;
constant binv_wayA_upd2_offset          :natural := binv_wayH_upd_offset + 1;
constant binv_wayB_upd2_offset          :natural := binv_wayA_upd2_offset + 1;
constant binv_wayC_upd2_offset          :natural := binv_wayB_upd2_offset + 1;
constant binv_wayD_upd2_offset          :natural := binv_wayC_upd2_offset + 1;
constant binv_wayE_upd2_offset          :natural := binv_wayD_upd2_offset + 1;
constant binv_wayF_upd2_offset          :natural := binv_wayE_upd2_offset + 1;
constant binv_wayG_upd2_offset          :natural := binv_wayF_upd2_offset + 1;
constant binv_wayH_upd2_offset          :natural := binv_wayG_upd2_offset + 1;
constant binv_wayA_upd3_offset          :natural := binv_wayH_upd2_offset + 1;
constant binv_wayB_upd3_offset          :natural := binv_wayA_upd3_offset + 1;
constant binv_wayC_upd3_offset          :natural := binv_wayB_upd3_offset + 1;
constant binv_wayD_upd3_offset          :natural := binv_wayC_upd3_offset + 1;
constant binv_wayE_upd3_offset          :natural := binv_wayD_upd3_offset + 1;
constant binv_wayF_upd3_offset          :natural := binv_wayE_upd3_offset + 1;
constant binv_wayG_upd3_offset          :natural := binv_wayF_upd3_offset + 1;
constant binv_wayH_upd3_offset          :natural := binv_wayG_upd3_offset + 1;
constant reload_wayA_upd_offset         :natural := binv_wayH_upd3_offset + 1;
constant reload_wayB_upd_offset         :natural := reload_wayA_upd_offset + 1;
constant reload_wayC_upd_offset         :natural := reload_wayB_upd_offset + 1;
constant reload_wayD_upd_offset         :natural := reload_wayC_upd_offset + 1;
constant reload_wayE_upd_offset         :natural := reload_wayD_upd_offset + 1;
constant reload_wayF_upd_offset         :natural := reload_wayE_upd_offset + 1;
constant reload_wayG_upd_offset         :natural := reload_wayF_upd_offset + 1;
constant reload_wayH_upd_offset         :natural := reload_wayG_upd_offset + 1;
constant reload_wayA_upd2_offset        :natural := reload_wayH_upd_offset + 1;
constant reload_wayB_upd2_offset        :natural := reload_wayA_upd2_offset + 1;
constant reload_wayC_upd2_offset        :natural := reload_wayB_upd2_offset + 1;
constant reload_wayD_upd2_offset        :natural := reload_wayC_upd2_offset + 1;
constant reload_wayE_upd2_offset        :natural := reload_wayD_upd2_offset + 1;
constant reload_wayF_upd2_offset        :natural := reload_wayE_upd2_offset + 1;
constant reload_wayG_upd2_offset        :natural := reload_wayF_upd2_offset + 1;
constant reload_wayH_upd2_offset        :natural := reload_wayG_upd2_offset + 1;
constant reload_wayA_upd3_offset        :natural := reload_wayH_upd2_offset + 1;
constant reload_wayB_upd3_offset        :natural := reload_wayA_upd3_offset + 1;
constant reload_wayC_upd3_offset        :natural := reload_wayB_upd3_offset + 1;
constant reload_wayD_upd3_offset        :natural := reload_wayC_upd3_offset + 1;
constant reload_wayE_upd3_offset        :natural := reload_wayD_upd3_offset + 1;
constant reload_wayF_upd3_offset        :natural := reload_wayE_upd3_offset + 1;
constant reload_wayG_upd3_offset        :natural := reload_wayF_upd3_offset + 1;
constant reload_wayH_upd3_offset        :natural := reload_wayG_upd3_offset + 1;
constant ex3_store_instr_offset         :natural := reload_wayH_upd3_offset + 1;
constant ex3_lock_set_offset            :natural := ex3_store_instr_offset + 1;
constant ex4_lock_set_offset            :natural := ex3_lock_set_offset + 1;
constant ex5_lock_set_offset            :natural := ex4_lock_set_offset + 1;
constant ex3_lock_clr_offset            :natural := ex5_lock_set_offset + 1;
constant ex3_xuop_val_offset            :natural := ex3_lock_clr_offset + 1;
constant ex4_xuop_val_offset            :natural := ex3_xuop_val_offset + 1;
constant ex5_xuop_val_offset            :natural := ex4_xuop_val_offset + 1;
constant rel_lock_set_offset            :natural := ex5_xuop_val_offset + 1;
constant dcpar_err_stg1_offset          :natural := rel_lock_set_offset + 1;
constant dcpar_err_stg2_offset          :natural := dcpar_err_stg1_offset + 1;
constant dcpar_err_way_offset           :natural := dcpar_err_stg2_offset + 1;
constant dcpar_err_way_inval_offset     :natural := dcpar_err_way_offset + 8;
constant dcpar_err_cntr_offset          :natural := dcpar_err_way_inval_offset + 8;
constant dcpar_err_ind_sel_offset       :natural := dcpar_err_cntr_offset + 2;
constant dcpar_err_push_queue_offset    :natural := dcpar_err_ind_sel_offset + 2;
constant ex5_way_hit_offset             :natural := dcpar_err_push_queue_offset + 1;
constant ex7_way_hit_offset             :natural := ex5_way_hit_offset + 8;
constant ex8_way_hit_offset             :natural := ex7_way_hit_offset + 8;
constant ex9_way_hit_offset             :natural := ex8_way_hit_offset + 8;
constant ex4_lose_watch_offset          :natural := ex9_way_hit_offset + 8;
constant xucr0_cslc_xuop_offset         :natural := ex4_lose_watch_offset + 4;
constant xucr0_cslc_binv_offset         :natural := xucr0_cslc_xuop_offset + 1;
constant dci_compl_offset               :natural := xucr0_cslc_binv_offset + 1;
constant dci_inval_all_offset           :natural := dci_compl_offset + 1;
constant inv2_val_offset                :natural := dci_inval_all_offset + 1;
constant perf_lsu_evnts_offset          :natural := inv2_val_offset + 1;
constant lock_flash_clear_offset        :natural := perf_lsu_evnts_offset + 5;
constant lock_flash_clear_val_offset    :natural := lock_flash_clear_offset + 1;
constant rel_port_wren_offset           :natural := lock_flash_clear_val_offset + 1;
constant ex3_thrd_id_offset             :natural := rel_port_wren_offset + 1;
constant ex5_thrd_id_offset             :natural := ex3_thrd_id_offset + 4;
constant ex3_l_fld_b1_offset            :natural := ex5_thrd_id_offset + 4;
constant ex3_watch_set_offset           :natural := ex3_l_fld_b1_offset + 1;
constant ex4_watch_set_offset           :natural := ex3_watch_set_offset + 1;
constant ex5_watch_set_offset           :natural := ex4_watch_set_offset + 1;
constant ex3_watch_clr_offset           :natural := ex5_watch_set_offset + 1;
constant ex3_watch_clr_all_offset       :natural := ex3_watch_clr_offset + 1;
constant ex3_watch_chk_offset           :natural := ex3_watch_clr_all_offset + 1;
constant ex4_watch_chk_offset           :natural := ex3_watch_chk_offset + 1;
constant ex5_watch_chk_offset           :natural := ex4_watch_chk_offset + 1;
constant ex3_wclr_all_upd_offset        :natural := ex5_watch_chk_offset + 1;
constant ex4_wclr_all_val_offset        :natural := ex3_wclr_all_upd_offset + 1;
constant ex5_wclr_all_val_offset        :natural := ex4_wclr_all_val_offset + 1;
constant ex6_wclr_all_val_offset        :natural := ex5_wclr_all_val_offset + 1;
constant rel_thrd_id_offset             :natural := ex6_wclr_all_val_offset + 1;
constant rel_watch_set_offset           :natural := rel_thrd_id_offset + 4;
constant ex5_cr_watch_offset            :natural := rel_watch_set_offset + 1;
constant ex4_watch_clr_all_offset       :natural := ex5_cr_watch_offset + 1;
constant ex5_watch_clr_all_offset       :natural := ex4_watch_clr_all_offset + 4;
constant ex6_watch_clr_all_offset       :natural := ex5_watch_clr_all_offset + 4;
constant ex5_watch_clr_all_val_offset   :natural := ex6_watch_clr_all_offset + 4;
constant ex5_lost_watch_upd_offset      :natural := ex5_watch_clr_all_val_offset + 1;
constant ex4_watchlost_set_offset       :natural := ex5_lost_watch_upd_offset + 4;
constant ex5_watchlost_set_offset       :natural := ex4_watchlost_set_offset + 4;
constant rel_lost_watch_binv_offset     :natural := ex5_watchlost_set_offset + 4;
constant lost_watch_evict_ovl_offset    :natural := rel_lost_watch_binv_offset + 4;
constant rel_lost_watch_upd_offset      :natural := lost_watch_evict_ovl_offset + 4;
constant lost_watch_evict_val_offset    :natural := rel_lost_watch_upd_offset + 4;
constant lost_watch_inter_thrd_offset   :natural := lost_watch_evict_val_offset + 4;
constant stm_watchlost_state_offset     :natural := lost_watch_inter_thrd_offset + 4;
constant ex5_xuop_p0_upd_offset         :natural := stm_watchlost_state_offset + 4;
constant rel_val_stgu_offset            :natural := ex5_xuop_p0_upd_offset + 1;
constant p0_wren_offset                 :natural := rel_val_stgu_offset + 1;
constant p0_wren_cpy_offset             :natural := p0_wren_offset + 1;
constant p0_wren_stg_offset             :natural := p0_wren_cpy_offset + 1;
constant p1_wren_offset                 :natural := p0_wren_stg_offset + 1;
constant p1_wren_cpy_offset             :natural := p1_wren_offset + 1;
constant ex3_thrd_m_offset              :natural := p1_wren_cpy_offset + 1;
constant ex4_thrd_m_offset              :natural := ex3_thrd_m_offset + 1;
constant ex5_thrd_m_offset              :natural := ex4_thrd_m_offset + 1;
constant ex6_thrd_m_offset              :natural := ex5_thrd_m_offset + 1;
constant ex7_ld_par_err_offset          :natural := ex6_thrd_m_offset + 1;
constant ex8_ld_par_err_offset          :natural := ex7_ld_par_err_offset + 1;
constant ex9_ld_par_err_offset          :natural := ex8_ld_par_err_offset + 1;
constant ex6_ld_valid_offset            :natural := ex9_ld_par_err_offset + 1;
constant ex7_ld_valid_offset            :natural := ex6_ld_valid_offset + 1;
constant ex8_ld_valid_offset            :natural := ex7_ld_valid_offset + 1;
constant ex9_ld_valid_offset            :natural := ex8_ld_valid_offset + 1;
constant rel_in_progress_offset         :natural := ex9_ld_valid_offset + 1;
constant inj_dir_multihit_offset        :natural := rel_in_progress_offset + 1;
constant congr_cl_ex2_ex3_cmp_offset    :natural := inj_dir_multihit_offset + 1;
constant congr_cl_ex2_ex4_cmp_offset    :natural := congr_cl_ex2_ex3_cmp_offset + 1;
constant congr_cl_ex2_ex5_cmp_offset    :natural := congr_cl_ex2_ex4_cmp_offset + 1;
constant congr_cl_ex2_ex6_cmp_offset    :natural := congr_cl_ex2_ex5_cmp_offset + 1;
constant congr_cl_ex3_ex4_cmp_offset    :natural := congr_cl_ex2_ex6_cmp_offset + 1;
constant congr_cl_ex3_ex5_cmp_offset    :natural := congr_cl_ex3_ex4_cmp_offset + 1;
constant congr_cl_ex3_ex6_cmp_offset    :natural := congr_cl_ex3_ex5_cmp_offset + 1;
constant congr_cl_ex4_ex5_cmp_offset    :natural := congr_cl_ex3_ex6_cmp_offset + 1;
constant congr_cl_ex4_ex6_cmp_offset    :natural := congr_cl_ex4_ex5_cmp_offset + 1;
constant congr_cl_ex4_ex7_cmp_offset    :natural := congr_cl_ex4_ex6_cmp_offset + 1;
constant congr_cl_ex2_relu_cmp_offset   :natural := congr_cl_ex4_ex7_cmp_offset + 1;
constant congr_cl_ex2_relu_s_cmp_offset :natural := congr_cl_ex2_relu_cmp_offset + 1;
constant congr_cl_ex2_rel_upd_cmp_offset :natural := congr_cl_ex2_relu_s_cmp_offset + 1;
constant congr_cl_rel13_ex3_cmp_offset  :natural := congr_cl_ex2_rel_upd_cmp_offset + 1;
constant congr_cl_rel13_ex4_cmp_offset  :natural := congr_cl_rel13_ex3_cmp_offset + 1;
constant congr_cl_rel13_ex5_cmp_offset  :natural := congr_cl_rel13_ex4_cmp_offset + 1;
constant congr_cl_rel13_ex6_cmp_offset  :natural := congr_cl_rel13_ex5_cmp_offset + 1;
constant congr_cl_rel13_relu_cmp_offset :natural := congr_cl_rel13_ex6_cmp_offset + 1;
constant congr_cl_rel13_relu_s_cmp_offset :natural := congr_cl_rel13_relu_cmp_offset + 1;
constant congr_cl_rel13_rel_upd_cmp_offset :natural := congr_cl_rel13_relu_s_cmp_offset + 1;
constant rel24_congr_cl_ex4_cmp_offset  :natural := congr_cl_rel13_rel_upd_cmp_offset + 1;
constant rel24_congr_cl_ex5_cmp_offset  :natural := rel24_congr_cl_ex4_cmp_offset + 1;
constant rel24_congr_cl_ex6_cmp_offset  :natural := rel24_congr_cl_ex5_cmp_offset + 1;
constant relu_congr_cl_ex5_cmp_offset   :natural := rel24_congr_cl_ex6_cmp_offset + 1;
constant relu_congr_cl_ex6_cmp_offset   :natural := relu_congr_cl_ex5_cmp_offset + 1;
constant relu_congr_cl_ex7_cmp_offset   :natural := relu_congr_cl_ex6_cmp_offset + 1;
constant ex4_err_det_way_offset         :natural := relu_congr_cl_ex7_cmp_offset + 1;
constant ex4_perr_lck_lost_offset       :natural := ex4_err_det_way_offset + 8;
constant ex4_perr_watch_lost_offset     :natural := ex4_perr_lck_lost_offset + 1;
constant dcperr_lock_lost_offset        :natural := ex4_perr_watch_lost_offset + 4;
constant binv7_ex7_way_upd_offset       :natural := dcperr_lock_lost_offset + 1;
constant binv5_ex5_dir_data_offset      :natural := binv7_ex7_way_upd_offset + 8;
constant binv7_ex7_dir_data_offset      :natural := binv5_ex5_dir_data_offset + 5;
constant binv5_inval_watch_val_offset   :natural := binv7_ex7_dir_data_offset + 5;
constant binv5_inval_lock_val_offset    :natural := binv5_inval_watch_val_offset + 4;
constant ex4_snd_ld_l2_offset           :natural := binv5_inval_lock_val_offset + 1;
constant ex4_ldq_full_flush_b_offset    :natural := ex4_snd_ld_l2_offset + 1;
constant ex4_miss_offset                :natural := ex4_ldq_full_flush_b_offset + 1;
constant my_spare0_latches_offset       :natural := ex4_miss_offset + 1;
constant my_spare1_latches_offset       :natural := my_spare0_latches_offset + 17;
constant rel_l1dump_cslc_offset         :natural := my_spare1_latches_offset + 16;
constant rel_in_prog_stg1_offset        :natural := rel_l1dump_cslc_offset + 1;
constant rel_in_prog_stg2_offset        :natural := rel_in_prog_stg1_offset + 1;
constant rel_in_prog_stg3_offset        :natural := rel_in_prog_stg2_offset + 1;
constant rel_in_prog_stg4_offset        :natural := rel_in_prog_stg3_offset + 1;
constant rel_in_prog_stg5_offset        :natural := rel_in_prog_stg4_offset + 1;
constant dcpar_err_stg1_act_offset      :natural := rel_in_prog_stg5_offset + 1;
constant dcpar_err_stg2_act_offset      :natural := dcpar_err_stg1_act_offset + 1;
constant rel3_perr_stg_act_offset       :natural := dcpar_err_stg2_act_offset + 1;
constant rel4_perr_stg_act_offset       :natural := rel3_perr_stg_act_offset + 1;
constant scan_right                     :natural := rel4_perr_stg_act_offset + 1 - 1;
----------------------------
-- signals
----------------------------
signal p0_congr_cl0_m             :std_ulogic;
signal p1_congr_cl0_m             :std_ulogic;
signal p0_congr_cl0_act_d         :std_ulogic;
signal p0_congr_cl0_act_q         :std_ulogic;
signal p1_congr_cl0_act_d         :std_ulogic;
signal p1_congr_cl0_act_q         :std_ulogic;
signal congr_cl0_act              :std_ulogic;
signal congr_cl0_wA_d           :std_ulogic_vector(0 to 5);
signal congr_cl0_wA_q           :std_ulogic_vector(0 to 5);
signal rel_bixu0_wayA_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd0_wayA    :std_ulogic;
signal p1_way_data_upd0_wayA    :std_ulogic;
signal congr_cl0_wB_d           :std_ulogic_vector(0 to 5);
signal congr_cl0_wB_q           :std_ulogic_vector(0 to 5);
signal rel_bixu0_wayB_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd0_wayB    :std_ulogic;
signal p1_way_data_upd0_wayB    :std_ulogic;
signal congr_cl0_wC_d           :std_ulogic_vector(0 to 5);
signal congr_cl0_wC_q           :std_ulogic_vector(0 to 5);
signal rel_bixu0_wayC_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd0_wayC    :std_ulogic;
signal p1_way_data_upd0_wayC    :std_ulogic;
signal congr_cl0_wD_d           :std_ulogic_vector(0 to 5);
signal congr_cl0_wD_q           :std_ulogic_vector(0 to 5);
signal rel_bixu0_wayD_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd0_wayD    :std_ulogic;
signal p1_way_data_upd0_wayD    :std_ulogic;
signal congr_cl0_wE_d           :std_ulogic_vector(0 to 5);
signal congr_cl0_wE_q           :std_ulogic_vector(0 to 5);
signal rel_bixu0_wayE_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd0_wayE    :std_ulogic;
signal p1_way_data_upd0_wayE    :std_ulogic;
signal congr_cl0_wF_d           :std_ulogic_vector(0 to 5);
signal congr_cl0_wF_q           :std_ulogic_vector(0 to 5);
signal rel_bixu0_wayF_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd0_wayF    :std_ulogic;
signal p1_way_data_upd0_wayF    :std_ulogic;
signal congr_cl0_wG_d           :std_ulogic_vector(0 to 5);
signal congr_cl0_wG_q           :std_ulogic_vector(0 to 5);
signal rel_bixu0_wayG_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd0_wayG    :std_ulogic;
signal p1_way_data_upd0_wayG    :std_ulogic;
signal congr_cl0_wH_d           :std_ulogic_vector(0 to 5);
signal congr_cl0_wH_q           :std_ulogic_vector(0 to 5);
signal rel_bixu0_wayH_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd0_wayH    :std_ulogic;
signal p1_way_data_upd0_wayH    :std_ulogic;
signal p0_congr_cl1_m             :std_ulogic;
signal p1_congr_cl1_m             :std_ulogic;
signal p0_congr_cl1_act_d         :std_ulogic;
signal p0_congr_cl1_act_q         :std_ulogic;
signal p1_congr_cl1_act_d         :std_ulogic;
signal p1_congr_cl1_act_q         :std_ulogic;
signal congr_cl1_act              :std_ulogic;
signal congr_cl1_wA_d           :std_ulogic_vector(0 to 5);
signal congr_cl1_wA_q           :std_ulogic_vector(0 to 5);
signal rel_bixu1_wayA_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd1_wayA    :std_ulogic;
signal p1_way_data_upd1_wayA    :std_ulogic;
signal congr_cl1_wB_d           :std_ulogic_vector(0 to 5);
signal congr_cl1_wB_q           :std_ulogic_vector(0 to 5);
signal rel_bixu1_wayB_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd1_wayB    :std_ulogic;
signal p1_way_data_upd1_wayB    :std_ulogic;
signal congr_cl1_wC_d           :std_ulogic_vector(0 to 5);
signal congr_cl1_wC_q           :std_ulogic_vector(0 to 5);
signal rel_bixu1_wayC_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd1_wayC    :std_ulogic;
signal p1_way_data_upd1_wayC    :std_ulogic;
signal congr_cl1_wD_d           :std_ulogic_vector(0 to 5);
signal congr_cl1_wD_q           :std_ulogic_vector(0 to 5);
signal rel_bixu1_wayD_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd1_wayD    :std_ulogic;
signal p1_way_data_upd1_wayD    :std_ulogic;
signal congr_cl1_wE_d           :std_ulogic_vector(0 to 5);
signal congr_cl1_wE_q           :std_ulogic_vector(0 to 5);
signal rel_bixu1_wayE_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd1_wayE    :std_ulogic;
signal p1_way_data_upd1_wayE    :std_ulogic;
signal congr_cl1_wF_d           :std_ulogic_vector(0 to 5);
signal congr_cl1_wF_q           :std_ulogic_vector(0 to 5);
signal rel_bixu1_wayF_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd1_wayF    :std_ulogic;
signal p1_way_data_upd1_wayF    :std_ulogic;
signal congr_cl1_wG_d           :std_ulogic_vector(0 to 5);
signal congr_cl1_wG_q           :std_ulogic_vector(0 to 5);
signal rel_bixu1_wayG_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd1_wayG    :std_ulogic;
signal p1_way_data_upd1_wayG    :std_ulogic;
signal congr_cl1_wH_d           :std_ulogic_vector(0 to 5);
signal congr_cl1_wH_q           :std_ulogic_vector(0 to 5);
signal rel_bixu1_wayH_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd1_wayH    :std_ulogic;
signal p1_way_data_upd1_wayH    :std_ulogic;
signal p0_congr_cl2_m             :std_ulogic;
signal p1_congr_cl2_m             :std_ulogic;
signal p0_congr_cl2_act_d         :std_ulogic;
signal p0_congr_cl2_act_q         :std_ulogic;
signal p1_congr_cl2_act_d         :std_ulogic;
signal p1_congr_cl2_act_q         :std_ulogic;
signal congr_cl2_act              :std_ulogic;
signal congr_cl2_wA_d           :std_ulogic_vector(0 to 5);
signal congr_cl2_wA_q           :std_ulogic_vector(0 to 5);
signal rel_bixu2_wayA_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd2_wayA    :std_ulogic;
signal p1_way_data_upd2_wayA    :std_ulogic;
signal congr_cl2_wB_d           :std_ulogic_vector(0 to 5);
signal congr_cl2_wB_q           :std_ulogic_vector(0 to 5);
signal rel_bixu2_wayB_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd2_wayB    :std_ulogic;
signal p1_way_data_upd2_wayB    :std_ulogic;
signal congr_cl2_wC_d           :std_ulogic_vector(0 to 5);
signal congr_cl2_wC_q           :std_ulogic_vector(0 to 5);
signal rel_bixu2_wayC_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd2_wayC    :std_ulogic;
signal p1_way_data_upd2_wayC    :std_ulogic;
signal congr_cl2_wD_d           :std_ulogic_vector(0 to 5);
signal congr_cl2_wD_q           :std_ulogic_vector(0 to 5);
signal rel_bixu2_wayD_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd2_wayD    :std_ulogic;
signal p1_way_data_upd2_wayD    :std_ulogic;
signal congr_cl2_wE_d           :std_ulogic_vector(0 to 5);
signal congr_cl2_wE_q           :std_ulogic_vector(0 to 5);
signal rel_bixu2_wayE_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd2_wayE    :std_ulogic;
signal p1_way_data_upd2_wayE    :std_ulogic;
signal congr_cl2_wF_d           :std_ulogic_vector(0 to 5);
signal congr_cl2_wF_q           :std_ulogic_vector(0 to 5);
signal rel_bixu2_wayF_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd2_wayF    :std_ulogic;
signal p1_way_data_upd2_wayF    :std_ulogic;
signal congr_cl2_wG_d           :std_ulogic_vector(0 to 5);
signal congr_cl2_wG_q           :std_ulogic_vector(0 to 5);
signal rel_bixu2_wayG_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd2_wayG    :std_ulogic;
signal p1_way_data_upd2_wayG    :std_ulogic;
signal congr_cl2_wH_d           :std_ulogic_vector(0 to 5);
signal congr_cl2_wH_q           :std_ulogic_vector(0 to 5);
signal rel_bixu2_wayH_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd2_wayH    :std_ulogic;
signal p1_way_data_upd2_wayH    :std_ulogic;
signal p0_congr_cl3_m             :std_ulogic;
signal p1_congr_cl3_m             :std_ulogic;
signal p0_congr_cl3_act_d         :std_ulogic;
signal p0_congr_cl3_act_q         :std_ulogic;
signal p1_congr_cl3_act_d         :std_ulogic;
signal p1_congr_cl3_act_q         :std_ulogic;
signal congr_cl3_act              :std_ulogic;
signal congr_cl3_wA_d           :std_ulogic_vector(0 to 5);
signal congr_cl3_wA_q           :std_ulogic_vector(0 to 5);
signal rel_bixu3_wayA_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd3_wayA    :std_ulogic;
signal p1_way_data_upd3_wayA    :std_ulogic;
signal congr_cl3_wB_d           :std_ulogic_vector(0 to 5);
signal congr_cl3_wB_q           :std_ulogic_vector(0 to 5);
signal rel_bixu3_wayB_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd3_wayB    :std_ulogic;
signal p1_way_data_upd3_wayB    :std_ulogic;
signal congr_cl3_wC_d           :std_ulogic_vector(0 to 5);
signal congr_cl3_wC_q           :std_ulogic_vector(0 to 5);
signal rel_bixu3_wayC_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd3_wayC    :std_ulogic;
signal p1_way_data_upd3_wayC    :std_ulogic;
signal congr_cl3_wD_d           :std_ulogic_vector(0 to 5);
signal congr_cl3_wD_q           :std_ulogic_vector(0 to 5);
signal rel_bixu3_wayD_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd3_wayD    :std_ulogic;
signal p1_way_data_upd3_wayD    :std_ulogic;
signal congr_cl3_wE_d           :std_ulogic_vector(0 to 5);
signal congr_cl3_wE_q           :std_ulogic_vector(0 to 5);
signal rel_bixu3_wayE_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd3_wayE    :std_ulogic;
signal p1_way_data_upd3_wayE    :std_ulogic;
signal congr_cl3_wF_d           :std_ulogic_vector(0 to 5);
signal congr_cl3_wF_q           :std_ulogic_vector(0 to 5);
signal rel_bixu3_wayF_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd3_wayF    :std_ulogic;
signal p1_way_data_upd3_wayF    :std_ulogic;
signal congr_cl3_wG_d           :std_ulogic_vector(0 to 5);
signal congr_cl3_wG_q           :std_ulogic_vector(0 to 5);
signal rel_bixu3_wayG_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd3_wayG    :std_ulogic;
signal p1_way_data_upd3_wayG    :std_ulogic;
signal congr_cl3_wH_d           :std_ulogic_vector(0 to 5);
signal congr_cl3_wH_q           :std_ulogic_vector(0 to 5);
signal rel_bixu3_wayH_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd3_wayH    :std_ulogic;
signal p1_way_data_upd3_wayH    :std_ulogic;
signal p0_congr_cl4_m             :std_ulogic;
signal p1_congr_cl4_m             :std_ulogic;
signal p0_congr_cl4_act_d         :std_ulogic;
signal p0_congr_cl4_act_q         :std_ulogic;
signal p1_congr_cl4_act_d         :std_ulogic;
signal p1_congr_cl4_act_q         :std_ulogic;
signal congr_cl4_act              :std_ulogic;
signal congr_cl4_wA_d           :std_ulogic_vector(0 to 5);
signal congr_cl4_wA_q           :std_ulogic_vector(0 to 5);
signal rel_bixu4_wayA_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd4_wayA    :std_ulogic;
signal p1_way_data_upd4_wayA    :std_ulogic;
signal congr_cl4_wB_d           :std_ulogic_vector(0 to 5);
signal congr_cl4_wB_q           :std_ulogic_vector(0 to 5);
signal rel_bixu4_wayB_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd4_wayB    :std_ulogic;
signal p1_way_data_upd4_wayB    :std_ulogic;
signal congr_cl4_wC_d           :std_ulogic_vector(0 to 5);
signal congr_cl4_wC_q           :std_ulogic_vector(0 to 5);
signal rel_bixu4_wayC_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd4_wayC    :std_ulogic;
signal p1_way_data_upd4_wayC    :std_ulogic;
signal congr_cl4_wD_d           :std_ulogic_vector(0 to 5);
signal congr_cl4_wD_q           :std_ulogic_vector(0 to 5);
signal rel_bixu4_wayD_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd4_wayD    :std_ulogic;
signal p1_way_data_upd4_wayD    :std_ulogic;
signal congr_cl4_wE_d           :std_ulogic_vector(0 to 5);
signal congr_cl4_wE_q           :std_ulogic_vector(0 to 5);
signal rel_bixu4_wayE_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd4_wayE    :std_ulogic;
signal p1_way_data_upd4_wayE    :std_ulogic;
signal congr_cl4_wF_d           :std_ulogic_vector(0 to 5);
signal congr_cl4_wF_q           :std_ulogic_vector(0 to 5);
signal rel_bixu4_wayF_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd4_wayF    :std_ulogic;
signal p1_way_data_upd4_wayF    :std_ulogic;
signal congr_cl4_wG_d           :std_ulogic_vector(0 to 5);
signal congr_cl4_wG_q           :std_ulogic_vector(0 to 5);
signal rel_bixu4_wayG_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd4_wayG    :std_ulogic;
signal p1_way_data_upd4_wayG    :std_ulogic;
signal congr_cl4_wH_d           :std_ulogic_vector(0 to 5);
signal congr_cl4_wH_q           :std_ulogic_vector(0 to 5);
signal rel_bixu4_wayH_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd4_wayH    :std_ulogic;
signal p1_way_data_upd4_wayH    :std_ulogic;
signal p0_congr_cl5_m             :std_ulogic;
signal p1_congr_cl5_m             :std_ulogic;
signal p0_congr_cl5_act_d         :std_ulogic;
signal p0_congr_cl5_act_q         :std_ulogic;
signal p1_congr_cl5_act_d         :std_ulogic;
signal p1_congr_cl5_act_q         :std_ulogic;
signal congr_cl5_act              :std_ulogic;
signal congr_cl5_wA_d           :std_ulogic_vector(0 to 5);
signal congr_cl5_wA_q           :std_ulogic_vector(0 to 5);
signal rel_bixu5_wayA_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd5_wayA    :std_ulogic;
signal p1_way_data_upd5_wayA    :std_ulogic;
signal congr_cl5_wB_d           :std_ulogic_vector(0 to 5);
signal congr_cl5_wB_q           :std_ulogic_vector(0 to 5);
signal rel_bixu5_wayB_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd5_wayB    :std_ulogic;
signal p1_way_data_upd5_wayB    :std_ulogic;
signal congr_cl5_wC_d           :std_ulogic_vector(0 to 5);
signal congr_cl5_wC_q           :std_ulogic_vector(0 to 5);
signal rel_bixu5_wayC_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd5_wayC    :std_ulogic;
signal p1_way_data_upd5_wayC    :std_ulogic;
signal congr_cl5_wD_d           :std_ulogic_vector(0 to 5);
signal congr_cl5_wD_q           :std_ulogic_vector(0 to 5);
signal rel_bixu5_wayD_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd5_wayD    :std_ulogic;
signal p1_way_data_upd5_wayD    :std_ulogic;
signal congr_cl5_wE_d           :std_ulogic_vector(0 to 5);
signal congr_cl5_wE_q           :std_ulogic_vector(0 to 5);
signal rel_bixu5_wayE_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd5_wayE    :std_ulogic;
signal p1_way_data_upd5_wayE    :std_ulogic;
signal congr_cl5_wF_d           :std_ulogic_vector(0 to 5);
signal congr_cl5_wF_q           :std_ulogic_vector(0 to 5);
signal rel_bixu5_wayF_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd5_wayF    :std_ulogic;
signal p1_way_data_upd5_wayF    :std_ulogic;
signal congr_cl5_wG_d           :std_ulogic_vector(0 to 5);
signal congr_cl5_wG_q           :std_ulogic_vector(0 to 5);
signal rel_bixu5_wayG_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd5_wayG    :std_ulogic;
signal p1_way_data_upd5_wayG    :std_ulogic;
signal congr_cl5_wH_d           :std_ulogic_vector(0 to 5);
signal congr_cl5_wH_q           :std_ulogic_vector(0 to 5);
signal rel_bixu5_wayH_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd5_wayH    :std_ulogic;
signal p1_way_data_upd5_wayH    :std_ulogic;
signal p0_congr_cl6_m             :std_ulogic;
signal p1_congr_cl6_m             :std_ulogic;
signal p0_congr_cl6_act_d         :std_ulogic;
signal p0_congr_cl6_act_q         :std_ulogic;
signal p1_congr_cl6_act_d         :std_ulogic;
signal p1_congr_cl6_act_q         :std_ulogic;
signal congr_cl6_act              :std_ulogic;
signal congr_cl6_wA_d           :std_ulogic_vector(0 to 5);
signal congr_cl6_wA_q           :std_ulogic_vector(0 to 5);
signal rel_bixu6_wayA_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd6_wayA    :std_ulogic;
signal p1_way_data_upd6_wayA    :std_ulogic;
signal congr_cl6_wB_d           :std_ulogic_vector(0 to 5);
signal congr_cl6_wB_q           :std_ulogic_vector(0 to 5);
signal rel_bixu6_wayB_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd6_wayB    :std_ulogic;
signal p1_way_data_upd6_wayB    :std_ulogic;
signal congr_cl6_wC_d           :std_ulogic_vector(0 to 5);
signal congr_cl6_wC_q           :std_ulogic_vector(0 to 5);
signal rel_bixu6_wayC_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd6_wayC    :std_ulogic;
signal p1_way_data_upd6_wayC    :std_ulogic;
signal congr_cl6_wD_d           :std_ulogic_vector(0 to 5);
signal congr_cl6_wD_q           :std_ulogic_vector(0 to 5);
signal rel_bixu6_wayD_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd6_wayD    :std_ulogic;
signal p1_way_data_upd6_wayD    :std_ulogic;
signal congr_cl6_wE_d           :std_ulogic_vector(0 to 5);
signal congr_cl6_wE_q           :std_ulogic_vector(0 to 5);
signal rel_bixu6_wayE_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd6_wayE    :std_ulogic;
signal p1_way_data_upd6_wayE    :std_ulogic;
signal congr_cl6_wF_d           :std_ulogic_vector(0 to 5);
signal congr_cl6_wF_q           :std_ulogic_vector(0 to 5);
signal rel_bixu6_wayF_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd6_wayF    :std_ulogic;
signal p1_way_data_upd6_wayF    :std_ulogic;
signal congr_cl6_wG_d           :std_ulogic_vector(0 to 5);
signal congr_cl6_wG_q           :std_ulogic_vector(0 to 5);
signal rel_bixu6_wayG_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd6_wayG    :std_ulogic;
signal p1_way_data_upd6_wayG    :std_ulogic;
signal congr_cl6_wH_d           :std_ulogic_vector(0 to 5);
signal congr_cl6_wH_q           :std_ulogic_vector(0 to 5);
signal rel_bixu6_wayH_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd6_wayH    :std_ulogic;
signal p1_way_data_upd6_wayH    :std_ulogic;
signal p0_congr_cl7_m             :std_ulogic;
signal p1_congr_cl7_m             :std_ulogic;
signal p0_congr_cl7_act_d         :std_ulogic;
signal p0_congr_cl7_act_q         :std_ulogic;
signal p1_congr_cl7_act_d         :std_ulogic;
signal p1_congr_cl7_act_q         :std_ulogic;
signal congr_cl7_act              :std_ulogic;
signal congr_cl7_wA_d           :std_ulogic_vector(0 to 5);
signal congr_cl7_wA_q           :std_ulogic_vector(0 to 5);
signal rel_bixu7_wayA_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd7_wayA    :std_ulogic;
signal p1_way_data_upd7_wayA    :std_ulogic;
signal congr_cl7_wB_d           :std_ulogic_vector(0 to 5);
signal congr_cl7_wB_q           :std_ulogic_vector(0 to 5);
signal rel_bixu7_wayB_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd7_wayB    :std_ulogic;
signal p1_way_data_upd7_wayB    :std_ulogic;
signal congr_cl7_wC_d           :std_ulogic_vector(0 to 5);
signal congr_cl7_wC_q           :std_ulogic_vector(0 to 5);
signal rel_bixu7_wayC_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd7_wayC    :std_ulogic;
signal p1_way_data_upd7_wayC    :std_ulogic;
signal congr_cl7_wD_d           :std_ulogic_vector(0 to 5);
signal congr_cl7_wD_q           :std_ulogic_vector(0 to 5);
signal rel_bixu7_wayD_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd7_wayD    :std_ulogic;
signal p1_way_data_upd7_wayD    :std_ulogic;
signal congr_cl7_wE_d           :std_ulogic_vector(0 to 5);
signal congr_cl7_wE_q           :std_ulogic_vector(0 to 5);
signal rel_bixu7_wayE_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd7_wayE    :std_ulogic;
signal p1_way_data_upd7_wayE    :std_ulogic;
signal congr_cl7_wF_d           :std_ulogic_vector(0 to 5);
signal congr_cl7_wF_q           :std_ulogic_vector(0 to 5);
signal rel_bixu7_wayF_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd7_wayF    :std_ulogic;
signal p1_way_data_upd7_wayF    :std_ulogic;
signal congr_cl7_wG_d           :std_ulogic_vector(0 to 5);
signal congr_cl7_wG_q           :std_ulogic_vector(0 to 5);
signal rel_bixu7_wayG_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd7_wayG    :std_ulogic;
signal p1_way_data_upd7_wayG    :std_ulogic;
signal congr_cl7_wH_d           :std_ulogic_vector(0 to 5);
signal congr_cl7_wH_q           :std_ulogic_vector(0 to 5);
signal rel_bixu7_wayH_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd7_wayH    :std_ulogic;
signal p1_way_data_upd7_wayH    :std_ulogic;
signal p0_congr_cl8_m             :std_ulogic;
signal p1_congr_cl8_m             :std_ulogic;
signal p0_congr_cl8_act_d         :std_ulogic;
signal p0_congr_cl8_act_q         :std_ulogic;
signal p1_congr_cl8_act_d         :std_ulogic;
signal p1_congr_cl8_act_q         :std_ulogic;
signal congr_cl8_act              :std_ulogic;
signal congr_cl8_wA_d           :std_ulogic_vector(0 to 5);
signal congr_cl8_wA_q           :std_ulogic_vector(0 to 5);
signal rel_bixu8_wayA_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd8_wayA    :std_ulogic;
signal p1_way_data_upd8_wayA    :std_ulogic;
signal congr_cl8_wB_d           :std_ulogic_vector(0 to 5);
signal congr_cl8_wB_q           :std_ulogic_vector(0 to 5);
signal rel_bixu8_wayB_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd8_wayB    :std_ulogic;
signal p1_way_data_upd8_wayB    :std_ulogic;
signal congr_cl8_wC_d           :std_ulogic_vector(0 to 5);
signal congr_cl8_wC_q           :std_ulogic_vector(0 to 5);
signal rel_bixu8_wayC_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd8_wayC    :std_ulogic;
signal p1_way_data_upd8_wayC    :std_ulogic;
signal congr_cl8_wD_d           :std_ulogic_vector(0 to 5);
signal congr_cl8_wD_q           :std_ulogic_vector(0 to 5);
signal rel_bixu8_wayD_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd8_wayD    :std_ulogic;
signal p1_way_data_upd8_wayD    :std_ulogic;
signal congr_cl8_wE_d           :std_ulogic_vector(0 to 5);
signal congr_cl8_wE_q           :std_ulogic_vector(0 to 5);
signal rel_bixu8_wayE_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd8_wayE    :std_ulogic;
signal p1_way_data_upd8_wayE    :std_ulogic;
signal congr_cl8_wF_d           :std_ulogic_vector(0 to 5);
signal congr_cl8_wF_q           :std_ulogic_vector(0 to 5);
signal rel_bixu8_wayF_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd8_wayF    :std_ulogic;
signal p1_way_data_upd8_wayF    :std_ulogic;
signal congr_cl8_wG_d           :std_ulogic_vector(0 to 5);
signal congr_cl8_wG_q           :std_ulogic_vector(0 to 5);
signal rel_bixu8_wayG_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd8_wayG    :std_ulogic;
signal p1_way_data_upd8_wayG    :std_ulogic;
signal congr_cl8_wH_d           :std_ulogic_vector(0 to 5);
signal congr_cl8_wH_q           :std_ulogic_vector(0 to 5);
signal rel_bixu8_wayH_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd8_wayH    :std_ulogic;
signal p1_way_data_upd8_wayH    :std_ulogic;
signal p0_congr_cl9_m             :std_ulogic;
signal p1_congr_cl9_m             :std_ulogic;
signal p0_congr_cl9_act_d         :std_ulogic;
signal p0_congr_cl9_act_q         :std_ulogic;
signal p1_congr_cl9_act_d         :std_ulogic;
signal p1_congr_cl9_act_q         :std_ulogic;
signal congr_cl9_act              :std_ulogic;
signal congr_cl9_wA_d           :std_ulogic_vector(0 to 5);
signal congr_cl9_wA_q           :std_ulogic_vector(0 to 5);
signal rel_bixu9_wayA_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd9_wayA    :std_ulogic;
signal p1_way_data_upd9_wayA    :std_ulogic;
signal congr_cl9_wB_d           :std_ulogic_vector(0 to 5);
signal congr_cl9_wB_q           :std_ulogic_vector(0 to 5);
signal rel_bixu9_wayB_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd9_wayB    :std_ulogic;
signal p1_way_data_upd9_wayB    :std_ulogic;
signal congr_cl9_wC_d           :std_ulogic_vector(0 to 5);
signal congr_cl9_wC_q           :std_ulogic_vector(0 to 5);
signal rel_bixu9_wayC_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd9_wayC    :std_ulogic;
signal p1_way_data_upd9_wayC    :std_ulogic;
signal congr_cl9_wD_d           :std_ulogic_vector(0 to 5);
signal congr_cl9_wD_q           :std_ulogic_vector(0 to 5);
signal rel_bixu9_wayD_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd9_wayD    :std_ulogic;
signal p1_way_data_upd9_wayD    :std_ulogic;
signal congr_cl9_wE_d           :std_ulogic_vector(0 to 5);
signal congr_cl9_wE_q           :std_ulogic_vector(0 to 5);
signal rel_bixu9_wayE_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd9_wayE    :std_ulogic;
signal p1_way_data_upd9_wayE    :std_ulogic;
signal congr_cl9_wF_d           :std_ulogic_vector(0 to 5);
signal congr_cl9_wF_q           :std_ulogic_vector(0 to 5);
signal rel_bixu9_wayF_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd9_wayF    :std_ulogic;
signal p1_way_data_upd9_wayF    :std_ulogic;
signal congr_cl9_wG_d           :std_ulogic_vector(0 to 5);
signal congr_cl9_wG_q           :std_ulogic_vector(0 to 5);
signal rel_bixu9_wayG_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd9_wayG    :std_ulogic;
signal p1_way_data_upd9_wayG    :std_ulogic;
signal congr_cl9_wH_d           :std_ulogic_vector(0 to 5);
signal congr_cl9_wH_q           :std_ulogic_vector(0 to 5);
signal rel_bixu9_wayH_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd9_wayH    :std_ulogic;
signal p1_way_data_upd9_wayH    :std_ulogic;
signal p0_congr_cl10_m            :std_ulogic;
signal p1_congr_cl10_m            :std_ulogic;
signal p0_congr_cl10_act_d        :std_ulogic;
signal p0_congr_cl10_act_q        :std_ulogic;
signal p1_congr_cl10_act_d        :std_ulogic;
signal p1_congr_cl10_act_q        :std_ulogic;
signal congr_cl10_act             :std_ulogic;
signal congr_cl10_wA_d           :std_ulogic_vector(0 to 5);
signal congr_cl10_wA_q           :std_ulogic_vector(0 to 5);
signal rel_bixu10_wayA_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd10_wayA    :std_ulogic;
signal p1_way_data_upd10_wayA    :std_ulogic;
signal congr_cl10_wB_d           :std_ulogic_vector(0 to 5);
signal congr_cl10_wB_q           :std_ulogic_vector(0 to 5);
signal rel_bixu10_wayB_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd10_wayB    :std_ulogic;
signal p1_way_data_upd10_wayB    :std_ulogic;
signal congr_cl10_wC_d           :std_ulogic_vector(0 to 5);
signal congr_cl10_wC_q           :std_ulogic_vector(0 to 5);
signal rel_bixu10_wayC_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd10_wayC    :std_ulogic;
signal p1_way_data_upd10_wayC    :std_ulogic;
signal congr_cl10_wD_d           :std_ulogic_vector(0 to 5);
signal congr_cl10_wD_q           :std_ulogic_vector(0 to 5);
signal rel_bixu10_wayD_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd10_wayD    :std_ulogic;
signal p1_way_data_upd10_wayD    :std_ulogic;
signal congr_cl10_wE_d           :std_ulogic_vector(0 to 5);
signal congr_cl10_wE_q           :std_ulogic_vector(0 to 5);
signal rel_bixu10_wayE_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd10_wayE    :std_ulogic;
signal p1_way_data_upd10_wayE    :std_ulogic;
signal congr_cl10_wF_d           :std_ulogic_vector(0 to 5);
signal congr_cl10_wF_q           :std_ulogic_vector(0 to 5);
signal rel_bixu10_wayF_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd10_wayF    :std_ulogic;
signal p1_way_data_upd10_wayF    :std_ulogic;
signal congr_cl10_wG_d           :std_ulogic_vector(0 to 5);
signal congr_cl10_wG_q           :std_ulogic_vector(0 to 5);
signal rel_bixu10_wayG_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd10_wayG    :std_ulogic;
signal p1_way_data_upd10_wayG    :std_ulogic;
signal congr_cl10_wH_d           :std_ulogic_vector(0 to 5);
signal congr_cl10_wH_q           :std_ulogic_vector(0 to 5);
signal rel_bixu10_wayH_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd10_wayH    :std_ulogic;
signal p1_way_data_upd10_wayH    :std_ulogic;
signal p0_congr_cl11_m            :std_ulogic;
signal p1_congr_cl11_m            :std_ulogic;
signal p0_congr_cl11_act_d        :std_ulogic;
signal p0_congr_cl11_act_q        :std_ulogic;
signal p1_congr_cl11_act_d        :std_ulogic;
signal p1_congr_cl11_act_q        :std_ulogic;
signal congr_cl11_act             :std_ulogic;
signal congr_cl11_wA_d           :std_ulogic_vector(0 to 5);
signal congr_cl11_wA_q           :std_ulogic_vector(0 to 5);
signal rel_bixu11_wayA_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd11_wayA    :std_ulogic;
signal p1_way_data_upd11_wayA    :std_ulogic;
signal congr_cl11_wB_d           :std_ulogic_vector(0 to 5);
signal congr_cl11_wB_q           :std_ulogic_vector(0 to 5);
signal rel_bixu11_wayB_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd11_wayB    :std_ulogic;
signal p1_way_data_upd11_wayB    :std_ulogic;
signal congr_cl11_wC_d           :std_ulogic_vector(0 to 5);
signal congr_cl11_wC_q           :std_ulogic_vector(0 to 5);
signal rel_bixu11_wayC_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd11_wayC    :std_ulogic;
signal p1_way_data_upd11_wayC    :std_ulogic;
signal congr_cl11_wD_d           :std_ulogic_vector(0 to 5);
signal congr_cl11_wD_q           :std_ulogic_vector(0 to 5);
signal rel_bixu11_wayD_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd11_wayD    :std_ulogic;
signal p1_way_data_upd11_wayD    :std_ulogic;
signal congr_cl11_wE_d           :std_ulogic_vector(0 to 5);
signal congr_cl11_wE_q           :std_ulogic_vector(0 to 5);
signal rel_bixu11_wayE_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd11_wayE    :std_ulogic;
signal p1_way_data_upd11_wayE    :std_ulogic;
signal congr_cl11_wF_d           :std_ulogic_vector(0 to 5);
signal congr_cl11_wF_q           :std_ulogic_vector(0 to 5);
signal rel_bixu11_wayF_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd11_wayF    :std_ulogic;
signal p1_way_data_upd11_wayF    :std_ulogic;
signal congr_cl11_wG_d           :std_ulogic_vector(0 to 5);
signal congr_cl11_wG_q           :std_ulogic_vector(0 to 5);
signal rel_bixu11_wayG_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd11_wayG    :std_ulogic;
signal p1_way_data_upd11_wayG    :std_ulogic;
signal congr_cl11_wH_d           :std_ulogic_vector(0 to 5);
signal congr_cl11_wH_q           :std_ulogic_vector(0 to 5);
signal rel_bixu11_wayH_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd11_wayH    :std_ulogic;
signal p1_way_data_upd11_wayH    :std_ulogic;
signal p0_congr_cl12_m            :std_ulogic;
signal p1_congr_cl12_m            :std_ulogic;
signal p0_congr_cl12_act_d        :std_ulogic;
signal p0_congr_cl12_act_q        :std_ulogic;
signal p1_congr_cl12_act_d        :std_ulogic;
signal p1_congr_cl12_act_q        :std_ulogic;
signal congr_cl12_act             :std_ulogic;
signal congr_cl12_wA_d           :std_ulogic_vector(0 to 5);
signal congr_cl12_wA_q           :std_ulogic_vector(0 to 5);
signal rel_bixu12_wayA_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd12_wayA    :std_ulogic;
signal p1_way_data_upd12_wayA    :std_ulogic;
signal congr_cl12_wB_d           :std_ulogic_vector(0 to 5);
signal congr_cl12_wB_q           :std_ulogic_vector(0 to 5);
signal rel_bixu12_wayB_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd12_wayB    :std_ulogic;
signal p1_way_data_upd12_wayB    :std_ulogic;
signal congr_cl12_wC_d           :std_ulogic_vector(0 to 5);
signal congr_cl12_wC_q           :std_ulogic_vector(0 to 5);
signal rel_bixu12_wayC_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd12_wayC    :std_ulogic;
signal p1_way_data_upd12_wayC    :std_ulogic;
signal congr_cl12_wD_d           :std_ulogic_vector(0 to 5);
signal congr_cl12_wD_q           :std_ulogic_vector(0 to 5);
signal rel_bixu12_wayD_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd12_wayD    :std_ulogic;
signal p1_way_data_upd12_wayD    :std_ulogic;
signal congr_cl12_wE_d           :std_ulogic_vector(0 to 5);
signal congr_cl12_wE_q           :std_ulogic_vector(0 to 5);
signal rel_bixu12_wayE_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd12_wayE    :std_ulogic;
signal p1_way_data_upd12_wayE    :std_ulogic;
signal congr_cl12_wF_d           :std_ulogic_vector(0 to 5);
signal congr_cl12_wF_q           :std_ulogic_vector(0 to 5);
signal rel_bixu12_wayF_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd12_wayF    :std_ulogic;
signal p1_way_data_upd12_wayF    :std_ulogic;
signal congr_cl12_wG_d           :std_ulogic_vector(0 to 5);
signal congr_cl12_wG_q           :std_ulogic_vector(0 to 5);
signal rel_bixu12_wayG_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd12_wayG    :std_ulogic;
signal p1_way_data_upd12_wayG    :std_ulogic;
signal congr_cl12_wH_d           :std_ulogic_vector(0 to 5);
signal congr_cl12_wH_q           :std_ulogic_vector(0 to 5);
signal rel_bixu12_wayH_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd12_wayH    :std_ulogic;
signal p1_way_data_upd12_wayH    :std_ulogic;
signal p0_congr_cl13_m            :std_ulogic;
signal p1_congr_cl13_m            :std_ulogic;
signal p0_congr_cl13_act_d        :std_ulogic;
signal p0_congr_cl13_act_q        :std_ulogic;
signal p1_congr_cl13_act_d        :std_ulogic;
signal p1_congr_cl13_act_q        :std_ulogic;
signal congr_cl13_act             :std_ulogic;
signal congr_cl13_wA_d           :std_ulogic_vector(0 to 5);
signal congr_cl13_wA_q           :std_ulogic_vector(0 to 5);
signal rel_bixu13_wayA_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd13_wayA    :std_ulogic;
signal p1_way_data_upd13_wayA    :std_ulogic;
signal congr_cl13_wB_d           :std_ulogic_vector(0 to 5);
signal congr_cl13_wB_q           :std_ulogic_vector(0 to 5);
signal rel_bixu13_wayB_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd13_wayB    :std_ulogic;
signal p1_way_data_upd13_wayB    :std_ulogic;
signal congr_cl13_wC_d           :std_ulogic_vector(0 to 5);
signal congr_cl13_wC_q           :std_ulogic_vector(0 to 5);
signal rel_bixu13_wayC_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd13_wayC    :std_ulogic;
signal p1_way_data_upd13_wayC    :std_ulogic;
signal congr_cl13_wD_d           :std_ulogic_vector(0 to 5);
signal congr_cl13_wD_q           :std_ulogic_vector(0 to 5);
signal rel_bixu13_wayD_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd13_wayD    :std_ulogic;
signal p1_way_data_upd13_wayD    :std_ulogic;
signal congr_cl13_wE_d           :std_ulogic_vector(0 to 5);
signal congr_cl13_wE_q           :std_ulogic_vector(0 to 5);
signal rel_bixu13_wayE_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd13_wayE    :std_ulogic;
signal p1_way_data_upd13_wayE    :std_ulogic;
signal congr_cl13_wF_d           :std_ulogic_vector(0 to 5);
signal congr_cl13_wF_q           :std_ulogic_vector(0 to 5);
signal rel_bixu13_wayF_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd13_wayF    :std_ulogic;
signal p1_way_data_upd13_wayF    :std_ulogic;
signal congr_cl13_wG_d           :std_ulogic_vector(0 to 5);
signal congr_cl13_wG_q           :std_ulogic_vector(0 to 5);
signal rel_bixu13_wayG_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd13_wayG    :std_ulogic;
signal p1_way_data_upd13_wayG    :std_ulogic;
signal congr_cl13_wH_d           :std_ulogic_vector(0 to 5);
signal congr_cl13_wH_q           :std_ulogic_vector(0 to 5);
signal rel_bixu13_wayH_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd13_wayH    :std_ulogic;
signal p1_way_data_upd13_wayH    :std_ulogic;
signal p0_congr_cl14_m            :std_ulogic;
signal p1_congr_cl14_m            :std_ulogic;
signal p0_congr_cl14_act_d        :std_ulogic;
signal p0_congr_cl14_act_q        :std_ulogic;
signal p1_congr_cl14_act_d        :std_ulogic;
signal p1_congr_cl14_act_q        :std_ulogic;
signal congr_cl14_act             :std_ulogic;
signal congr_cl14_wA_d           :std_ulogic_vector(0 to 5);
signal congr_cl14_wA_q           :std_ulogic_vector(0 to 5);
signal rel_bixu14_wayA_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd14_wayA    :std_ulogic;
signal p1_way_data_upd14_wayA    :std_ulogic;
signal congr_cl14_wB_d           :std_ulogic_vector(0 to 5);
signal congr_cl14_wB_q           :std_ulogic_vector(0 to 5);
signal rel_bixu14_wayB_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd14_wayB    :std_ulogic;
signal p1_way_data_upd14_wayB    :std_ulogic;
signal congr_cl14_wC_d           :std_ulogic_vector(0 to 5);
signal congr_cl14_wC_q           :std_ulogic_vector(0 to 5);
signal rel_bixu14_wayC_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd14_wayC    :std_ulogic;
signal p1_way_data_upd14_wayC    :std_ulogic;
signal congr_cl14_wD_d           :std_ulogic_vector(0 to 5);
signal congr_cl14_wD_q           :std_ulogic_vector(0 to 5);
signal rel_bixu14_wayD_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd14_wayD    :std_ulogic;
signal p1_way_data_upd14_wayD    :std_ulogic;
signal congr_cl14_wE_d           :std_ulogic_vector(0 to 5);
signal congr_cl14_wE_q           :std_ulogic_vector(0 to 5);
signal rel_bixu14_wayE_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd14_wayE    :std_ulogic;
signal p1_way_data_upd14_wayE    :std_ulogic;
signal congr_cl14_wF_d           :std_ulogic_vector(0 to 5);
signal congr_cl14_wF_q           :std_ulogic_vector(0 to 5);
signal rel_bixu14_wayF_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd14_wayF    :std_ulogic;
signal p1_way_data_upd14_wayF    :std_ulogic;
signal congr_cl14_wG_d           :std_ulogic_vector(0 to 5);
signal congr_cl14_wG_q           :std_ulogic_vector(0 to 5);
signal rel_bixu14_wayG_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd14_wayG    :std_ulogic;
signal p1_way_data_upd14_wayG    :std_ulogic;
signal congr_cl14_wH_d           :std_ulogic_vector(0 to 5);
signal congr_cl14_wH_q           :std_ulogic_vector(0 to 5);
signal rel_bixu14_wayH_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd14_wayH    :std_ulogic;
signal p1_way_data_upd14_wayH    :std_ulogic;
signal p0_congr_cl15_m            :std_ulogic;
signal p1_congr_cl15_m            :std_ulogic;
signal p0_congr_cl15_act_d        :std_ulogic;
signal p0_congr_cl15_act_q        :std_ulogic;
signal p1_congr_cl15_act_d        :std_ulogic;
signal p1_congr_cl15_act_q        :std_ulogic;
signal congr_cl15_act             :std_ulogic;
signal congr_cl15_wA_d           :std_ulogic_vector(0 to 5);
signal congr_cl15_wA_q           :std_ulogic_vector(0 to 5);
signal rel_bixu15_wayA_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd15_wayA    :std_ulogic;
signal p1_way_data_upd15_wayA    :std_ulogic;
signal congr_cl15_wB_d           :std_ulogic_vector(0 to 5);
signal congr_cl15_wB_q           :std_ulogic_vector(0 to 5);
signal rel_bixu15_wayB_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd15_wayB    :std_ulogic;
signal p1_way_data_upd15_wayB    :std_ulogic;
signal congr_cl15_wC_d           :std_ulogic_vector(0 to 5);
signal congr_cl15_wC_q           :std_ulogic_vector(0 to 5);
signal rel_bixu15_wayC_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd15_wayC    :std_ulogic;
signal p1_way_data_upd15_wayC    :std_ulogic;
signal congr_cl15_wD_d           :std_ulogic_vector(0 to 5);
signal congr_cl15_wD_q           :std_ulogic_vector(0 to 5);
signal rel_bixu15_wayD_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd15_wayD    :std_ulogic;
signal p1_way_data_upd15_wayD    :std_ulogic;
signal congr_cl15_wE_d           :std_ulogic_vector(0 to 5);
signal congr_cl15_wE_q           :std_ulogic_vector(0 to 5);
signal rel_bixu15_wayE_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd15_wayE    :std_ulogic;
signal p1_way_data_upd15_wayE    :std_ulogic;
signal congr_cl15_wF_d           :std_ulogic_vector(0 to 5);
signal congr_cl15_wF_q           :std_ulogic_vector(0 to 5);
signal rel_bixu15_wayF_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd15_wayF    :std_ulogic;
signal p1_way_data_upd15_wayF    :std_ulogic;
signal congr_cl15_wG_d           :std_ulogic_vector(0 to 5);
signal congr_cl15_wG_q           :std_ulogic_vector(0 to 5);
signal rel_bixu15_wayG_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd15_wayG    :std_ulogic;
signal p1_way_data_upd15_wayG    :std_ulogic;
signal congr_cl15_wH_d           :std_ulogic_vector(0 to 5);
signal congr_cl15_wH_q           :std_ulogic_vector(0 to 5);
signal rel_bixu15_wayH_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd15_wayH    :std_ulogic;
signal p1_way_data_upd15_wayH    :std_ulogic;
signal p0_congr_cl16_m            :std_ulogic;
signal p1_congr_cl16_m            :std_ulogic;
signal p0_congr_cl16_act_d        :std_ulogic;
signal p0_congr_cl16_act_q        :std_ulogic;
signal p1_congr_cl16_act_d        :std_ulogic;
signal p1_congr_cl16_act_q        :std_ulogic;
signal congr_cl16_act             :std_ulogic;
signal congr_cl16_wA_d           :std_ulogic_vector(0 to 5);
signal congr_cl16_wA_q           :std_ulogic_vector(0 to 5);
signal rel_bixu16_wayA_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd16_wayA    :std_ulogic;
signal p1_way_data_upd16_wayA    :std_ulogic;
signal congr_cl16_wB_d           :std_ulogic_vector(0 to 5);
signal congr_cl16_wB_q           :std_ulogic_vector(0 to 5);
signal rel_bixu16_wayB_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd16_wayB    :std_ulogic;
signal p1_way_data_upd16_wayB    :std_ulogic;
signal congr_cl16_wC_d           :std_ulogic_vector(0 to 5);
signal congr_cl16_wC_q           :std_ulogic_vector(0 to 5);
signal rel_bixu16_wayC_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd16_wayC    :std_ulogic;
signal p1_way_data_upd16_wayC    :std_ulogic;
signal congr_cl16_wD_d           :std_ulogic_vector(0 to 5);
signal congr_cl16_wD_q           :std_ulogic_vector(0 to 5);
signal rel_bixu16_wayD_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd16_wayD    :std_ulogic;
signal p1_way_data_upd16_wayD    :std_ulogic;
signal congr_cl16_wE_d           :std_ulogic_vector(0 to 5);
signal congr_cl16_wE_q           :std_ulogic_vector(0 to 5);
signal rel_bixu16_wayE_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd16_wayE    :std_ulogic;
signal p1_way_data_upd16_wayE    :std_ulogic;
signal congr_cl16_wF_d           :std_ulogic_vector(0 to 5);
signal congr_cl16_wF_q           :std_ulogic_vector(0 to 5);
signal rel_bixu16_wayF_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd16_wayF    :std_ulogic;
signal p1_way_data_upd16_wayF    :std_ulogic;
signal congr_cl16_wG_d           :std_ulogic_vector(0 to 5);
signal congr_cl16_wG_q           :std_ulogic_vector(0 to 5);
signal rel_bixu16_wayG_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd16_wayG    :std_ulogic;
signal p1_way_data_upd16_wayG    :std_ulogic;
signal congr_cl16_wH_d           :std_ulogic_vector(0 to 5);
signal congr_cl16_wH_q           :std_ulogic_vector(0 to 5);
signal rel_bixu16_wayH_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd16_wayH    :std_ulogic;
signal p1_way_data_upd16_wayH    :std_ulogic;
signal p0_congr_cl17_m            :std_ulogic;
signal p1_congr_cl17_m            :std_ulogic;
signal p0_congr_cl17_act_d        :std_ulogic;
signal p0_congr_cl17_act_q        :std_ulogic;
signal p1_congr_cl17_act_d        :std_ulogic;
signal p1_congr_cl17_act_q        :std_ulogic;
signal congr_cl17_act             :std_ulogic;
signal congr_cl17_wA_d           :std_ulogic_vector(0 to 5);
signal congr_cl17_wA_q           :std_ulogic_vector(0 to 5);
signal rel_bixu17_wayA_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd17_wayA    :std_ulogic;
signal p1_way_data_upd17_wayA    :std_ulogic;
signal congr_cl17_wB_d           :std_ulogic_vector(0 to 5);
signal congr_cl17_wB_q           :std_ulogic_vector(0 to 5);
signal rel_bixu17_wayB_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd17_wayB    :std_ulogic;
signal p1_way_data_upd17_wayB    :std_ulogic;
signal congr_cl17_wC_d           :std_ulogic_vector(0 to 5);
signal congr_cl17_wC_q           :std_ulogic_vector(0 to 5);
signal rel_bixu17_wayC_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd17_wayC    :std_ulogic;
signal p1_way_data_upd17_wayC    :std_ulogic;
signal congr_cl17_wD_d           :std_ulogic_vector(0 to 5);
signal congr_cl17_wD_q           :std_ulogic_vector(0 to 5);
signal rel_bixu17_wayD_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd17_wayD    :std_ulogic;
signal p1_way_data_upd17_wayD    :std_ulogic;
signal congr_cl17_wE_d           :std_ulogic_vector(0 to 5);
signal congr_cl17_wE_q           :std_ulogic_vector(0 to 5);
signal rel_bixu17_wayE_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd17_wayE    :std_ulogic;
signal p1_way_data_upd17_wayE    :std_ulogic;
signal congr_cl17_wF_d           :std_ulogic_vector(0 to 5);
signal congr_cl17_wF_q           :std_ulogic_vector(0 to 5);
signal rel_bixu17_wayF_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd17_wayF    :std_ulogic;
signal p1_way_data_upd17_wayF    :std_ulogic;
signal congr_cl17_wG_d           :std_ulogic_vector(0 to 5);
signal congr_cl17_wG_q           :std_ulogic_vector(0 to 5);
signal rel_bixu17_wayG_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd17_wayG    :std_ulogic;
signal p1_way_data_upd17_wayG    :std_ulogic;
signal congr_cl17_wH_d           :std_ulogic_vector(0 to 5);
signal congr_cl17_wH_q           :std_ulogic_vector(0 to 5);
signal rel_bixu17_wayH_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd17_wayH    :std_ulogic;
signal p1_way_data_upd17_wayH    :std_ulogic;
signal p0_congr_cl18_m            :std_ulogic;
signal p1_congr_cl18_m            :std_ulogic;
signal p0_congr_cl18_act_d        :std_ulogic;
signal p0_congr_cl18_act_q        :std_ulogic;
signal p1_congr_cl18_act_d        :std_ulogic;
signal p1_congr_cl18_act_q        :std_ulogic;
signal congr_cl18_act             :std_ulogic;
signal congr_cl18_wA_d           :std_ulogic_vector(0 to 5);
signal congr_cl18_wA_q           :std_ulogic_vector(0 to 5);
signal rel_bixu18_wayA_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd18_wayA    :std_ulogic;
signal p1_way_data_upd18_wayA    :std_ulogic;
signal congr_cl18_wB_d           :std_ulogic_vector(0 to 5);
signal congr_cl18_wB_q           :std_ulogic_vector(0 to 5);
signal rel_bixu18_wayB_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd18_wayB    :std_ulogic;
signal p1_way_data_upd18_wayB    :std_ulogic;
signal congr_cl18_wC_d           :std_ulogic_vector(0 to 5);
signal congr_cl18_wC_q           :std_ulogic_vector(0 to 5);
signal rel_bixu18_wayC_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd18_wayC    :std_ulogic;
signal p1_way_data_upd18_wayC    :std_ulogic;
signal congr_cl18_wD_d           :std_ulogic_vector(0 to 5);
signal congr_cl18_wD_q           :std_ulogic_vector(0 to 5);
signal rel_bixu18_wayD_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd18_wayD    :std_ulogic;
signal p1_way_data_upd18_wayD    :std_ulogic;
signal congr_cl18_wE_d           :std_ulogic_vector(0 to 5);
signal congr_cl18_wE_q           :std_ulogic_vector(0 to 5);
signal rel_bixu18_wayE_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd18_wayE    :std_ulogic;
signal p1_way_data_upd18_wayE    :std_ulogic;
signal congr_cl18_wF_d           :std_ulogic_vector(0 to 5);
signal congr_cl18_wF_q           :std_ulogic_vector(0 to 5);
signal rel_bixu18_wayF_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd18_wayF    :std_ulogic;
signal p1_way_data_upd18_wayF    :std_ulogic;
signal congr_cl18_wG_d           :std_ulogic_vector(0 to 5);
signal congr_cl18_wG_q           :std_ulogic_vector(0 to 5);
signal rel_bixu18_wayG_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd18_wayG    :std_ulogic;
signal p1_way_data_upd18_wayG    :std_ulogic;
signal congr_cl18_wH_d           :std_ulogic_vector(0 to 5);
signal congr_cl18_wH_q           :std_ulogic_vector(0 to 5);
signal rel_bixu18_wayH_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd18_wayH    :std_ulogic;
signal p1_way_data_upd18_wayH    :std_ulogic;
signal p0_congr_cl19_m            :std_ulogic;
signal p1_congr_cl19_m            :std_ulogic;
signal p0_congr_cl19_act_d        :std_ulogic;
signal p0_congr_cl19_act_q        :std_ulogic;
signal p1_congr_cl19_act_d        :std_ulogic;
signal p1_congr_cl19_act_q        :std_ulogic;
signal congr_cl19_act             :std_ulogic;
signal congr_cl19_wA_d           :std_ulogic_vector(0 to 5);
signal congr_cl19_wA_q           :std_ulogic_vector(0 to 5);
signal rel_bixu19_wayA_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd19_wayA    :std_ulogic;
signal p1_way_data_upd19_wayA    :std_ulogic;
signal congr_cl19_wB_d           :std_ulogic_vector(0 to 5);
signal congr_cl19_wB_q           :std_ulogic_vector(0 to 5);
signal rel_bixu19_wayB_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd19_wayB    :std_ulogic;
signal p1_way_data_upd19_wayB    :std_ulogic;
signal congr_cl19_wC_d           :std_ulogic_vector(0 to 5);
signal congr_cl19_wC_q           :std_ulogic_vector(0 to 5);
signal rel_bixu19_wayC_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd19_wayC    :std_ulogic;
signal p1_way_data_upd19_wayC    :std_ulogic;
signal congr_cl19_wD_d           :std_ulogic_vector(0 to 5);
signal congr_cl19_wD_q           :std_ulogic_vector(0 to 5);
signal rel_bixu19_wayD_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd19_wayD    :std_ulogic;
signal p1_way_data_upd19_wayD    :std_ulogic;
signal congr_cl19_wE_d           :std_ulogic_vector(0 to 5);
signal congr_cl19_wE_q           :std_ulogic_vector(0 to 5);
signal rel_bixu19_wayE_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd19_wayE    :std_ulogic;
signal p1_way_data_upd19_wayE    :std_ulogic;
signal congr_cl19_wF_d           :std_ulogic_vector(0 to 5);
signal congr_cl19_wF_q           :std_ulogic_vector(0 to 5);
signal rel_bixu19_wayF_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd19_wayF    :std_ulogic;
signal p1_way_data_upd19_wayF    :std_ulogic;
signal congr_cl19_wG_d           :std_ulogic_vector(0 to 5);
signal congr_cl19_wG_q           :std_ulogic_vector(0 to 5);
signal rel_bixu19_wayG_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd19_wayG    :std_ulogic;
signal p1_way_data_upd19_wayG    :std_ulogic;
signal congr_cl19_wH_d           :std_ulogic_vector(0 to 5);
signal congr_cl19_wH_q           :std_ulogic_vector(0 to 5);
signal rel_bixu19_wayH_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd19_wayH    :std_ulogic;
signal p1_way_data_upd19_wayH    :std_ulogic;
signal p0_congr_cl20_m            :std_ulogic;
signal p1_congr_cl20_m            :std_ulogic;
signal p0_congr_cl20_act_d        :std_ulogic;
signal p0_congr_cl20_act_q        :std_ulogic;
signal p1_congr_cl20_act_d        :std_ulogic;
signal p1_congr_cl20_act_q        :std_ulogic;
signal congr_cl20_act             :std_ulogic;
signal congr_cl20_wA_d           :std_ulogic_vector(0 to 5);
signal congr_cl20_wA_q           :std_ulogic_vector(0 to 5);
signal rel_bixu20_wayA_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd20_wayA    :std_ulogic;
signal p1_way_data_upd20_wayA    :std_ulogic;
signal congr_cl20_wB_d           :std_ulogic_vector(0 to 5);
signal congr_cl20_wB_q           :std_ulogic_vector(0 to 5);
signal rel_bixu20_wayB_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd20_wayB    :std_ulogic;
signal p1_way_data_upd20_wayB    :std_ulogic;
signal congr_cl20_wC_d           :std_ulogic_vector(0 to 5);
signal congr_cl20_wC_q           :std_ulogic_vector(0 to 5);
signal rel_bixu20_wayC_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd20_wayC    :std_ulogic;
signal p1_way_data_upd20_wayC    :std_ulogic;
signal congr_cl20_wD_d           :std_ulogic_vector(0 to 5);
signal congr_cl20_wD_q           :std_ulogic_vector(0 to 5);
signal rel_bixu20_wayD_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd20_wayD    :std_ulogic;
signal p1_way_data_upd20_wayD    :std_ulogic;
signal congr_cl20_wE_d           :std_ulogic_vector(0 to 5);
signal congr_cl20_wE_q           :std_ulogic_vector(0 to 5);
signal rel_bixu20_wayE_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd20_wayE    :std_ulogic;
signal p1_way_data_upd20_wayE    :std_ulogic;
signal congr_cl20_wF_d           :std_ulogic_vector(0 to 5);
signal congr_cl20_wF_q           :std_ulogic_vector(0 to 5);
signal rel_bixu20_wayF_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd20_wayF    :std_ulogic;
signal p1_way_data_upd20_wayF    :std_ulogic;
signal congr_cl20_wG_d           :std_ulogic_vector(0 to 5);
signal congr_cl20_wG_q           :std_ulogic_vector(0 to 5);
signal rel_bixu20_wayG_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd20_wayG    :std_ulogic;
signal p1_way_data_upd20_wayG    :std_ulogic;
signal congr_cl20_wH_d           :std_ulogic_vector(0 to 5);
signal congr_cl20_wH_q           :std_ulogic_vector(0 to 5);
signal rel_bixu20_wayH_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd20_wayH    :std_ulogic;
signal p1_way_data_upd20_wayH    :std_ulogic;
signal p0_congr_cl21_m            :std_ulogic;
signal p1_congr_cl21_m            :std_ulogic;
signal p0_congr_cl21_act_d        :std_ulogic;
signal p0_congr_cl21_act_q        :std_ulogic;
signal p1_congr_cl21_act_d        :std_ulogic;
signal p1_congr_cl21_act_q        :std_ulogic;
signal congr_cl21_act             :std_ulogic;
signal congr_cl21_wA_d           :std_ulogic_vector(0 to 5);
signal congr_cl21_wA_q           :std_ulogic_vector(0 to 5);
signal rel_bixu21_wayA_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd21_wayA    :std_ulogic;
signal p1_way_data_upd21_wayA    :std_ulogic;
signal congr_cl21_wB_d           :std_ulogic_vector(0 to 5);
signal congr_cl21_wB_q           :std_ulogic_vector(0 to 5);
signal rel_bixu21_wayB_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd21_wayB    :std_ulogic;
signal p1_way_data_upd21_wayB    :std_ulogic;
signal congr_cl21_wC_d           :std_ulogic_vector(0 to 5);
signal congr_cl21_wC_q           :std_ulogic_vector(0 to 5);
signal rel_bixu21_wayC_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd21_wayC    :std_ulogic;
signal p1_way_data_upd21_wayC    :std_ulogic;
signal congr_cl21_wD_d           :std_ulogic_vector(0 to 5);
signal congr_cl21_wD_q           :std_ulogic_vector(0 to 5);
signal rel_bixu21_wayD_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd21_wayD    :std_ulogic;
signal p1_way_data_upd21_wayD    :std_ulogic;
signal congr_cl21_wE_d           :std_ulogic_vector(0 to 5);
signal congr_cl21_wE_q           :std_ulogic_vector(0 to 5);
signal rel_bixu21_wayE_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd21_wayE    :std_ulogic;
signal p1_way_data_upd21_wayE    :std_ulogic;
signal congr_cl21_wF_d           :std_ulogic_vector(0 to 5);
signal congr_cl21_wF_q           :std_ulogic_vector(0 to 5);
signal rel_bixu21_wayF_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd21_wayF    :std_ulogic;
signal p1_way_data_upd21_wayF    :std_ulogic;
signal congr_cl21_wG_d           :std_ulogic_vector(0 to 5);
signal congr_cl21_wG_q           :std_ulogic_vector(0 to 5);
signal rel_bixu21_wayG_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd21_wayG    :std_ulogic;
signal p1_way_data_upd21_wayG    :std_ulogic;
signal congr_cl21_wH_d           :std_ulogic_vector(0 to 5);
signal congr_cl21_wH_q           :std_ulogic_vector(0 to 5);
signal rel_bixu21_wayH_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd21_wayH    :std_ulogic;
signal p1_way_data_upd21_wayH    :std_ulogic;
signal p0_congr_cl22_m            :std_ulogic;
signal p1_congr_cl22_m            :std_ulogic;
signal p0_congr_cl22_act_d        :std_ulogic;
signal p0_congr_cl22_act_q        :std_ulogic;
signal p1_congr_cl22_act_d        :std_ulogic;
signal p1_congr_cl22_act_q        :std_ulogic;
signal congr_cl22_act             :std_ulogic;
signal congr_cl22_wA_d           :std_ulogic_vector(0 to 5);
signal congr_cl22_wA_q           :std_ulogic_vector(0 to 5);
signal rel_bixu22_wayA_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd22_wayA    :std_ulogic;
signal p1_way_data_upd22_wayA    :std_ulogic;
signal congr_cl22_wB_d           :std_ulogic_vector(0 to 5);
signal congr_cl22_wB_q           :std_ulogic_vector(0 to 5);
signal rel_bixu22_wayB_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd22_wayB    :std_ulogic;
signal p1_way_data_upd22_wayB    :std_ulogic;
signal congr_cl22_wC_d           :std_ulogic_vector(0 to 5);
signal congr_cl22_wC_q           :std_ulogic_vector(0 to 5);
signal rel_bixu22_wayC_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd22_wayC    :std_ulogic;
signal p1_way_data_upd22_wayC    :std_ulogic;
signal congr_cl22_wD_d           :std_ulogic_vector(0 to 5);
signal congr_cl22_wD_q           :std_ulogic_vector(0 to 5);
signal rel_bixu22_wayD_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd22_wayD    :std_ulogic;
signal p1_way_data_upd22_wayD    :std_ulogic;
signal congr_cl22_wE_d           :std_ulogic_vector(0 to 5);
signal congr_cl22_wE_q           :std_ulogic_vector(0 to 5);
signal rel_bixu22_wayE_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd22_wayE    :std_ulogic;
signal p1_way_data_upd22_wayE    :std_ulogic;
signal congr_cl22_wF_d           :std_ulogic_vector(0 to 5);
signal congr_cl22_wF_q           :std_ulogic_vector(0 to 5);
signal rel_bixu22_wayF_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd22_wayF    :std_ulogic;
signal p1_way_data_upd22_wayF    :std_ulogic;
signal congr_cl22_wG_d           :std_ulogic_vector(0 to 5);
signal congr_cl22_wG_q           :std_ulogic_vector(0 to 5);
signal rel_bixu22_wayG_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd22_wayG    :std_ulogic;
signal p1_way_data_upd22_wayG    :std_ulogic;
signal congr_cl22_wH_d           :std_ulogic_vector(0 to 5);
signal congr_cl22_wH_q           :std_ulogic_vector(0 to 5);
signal rel_bixu22_wayH_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd22_wayH    :std_ulogic;
signal p1_way_data_upd22_wayH    :std_ulogic;
signal p0_congr_cl23_m            :std_ulogic;
signal p1_congr_cl23_m            :std_ulogic;
signal p0_congr_cl23_act_d        :std_ulogic;
signal p0_congr_cl23_act_q        :std_ulogic;
signal p1_congr_cl23_act_d        :std_ulogic;
signal p1_congr_cl23_act_q        :std_ulogic;
signal congr_cl23_act             :std_ulogic;
signal congr_cl23_wA_d           :std_ulogic_vector(0 to 5);
signal congr_cl23_wA_q           :std_ulogic_vector(0 to 5);
signal rel_bixu23_wayA_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd23_wayA    :std_ulogic;
signal p1_way_data_upd23_wayA    :std_ulogic;
signal congr_cl23_wB_d           :std_ulogic_vector(0 to 5);
signal congr_cl23_wB_q           :std_ulogic_vector(0 to 5);
signal rel_bixu23_wayB_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd23_wayB    :std_ulogic;
signal p1_way_data_upd23_wayB    :std_ulogic;
signal congr_cl23_wC_d           :std_ulogic_vector(0 to 5);
signal congr_cl23_wC_q           :std_ulogic_vector(0 to 5);
signal rel_bixu23_wayC_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd23_wayC    :std_ulogic;
signal p1_way_data_upd23_wayC    :std_ulogic;
signal congr_cl23_wD_d           :std_ulogic_vector(0 to 5);
signal congr_cl23_wD_q           :std_ulogic_vector(0 to 5);
signal rel_bixu23_wayD_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd23_wayD    :std_ulogic;
signal p1_way_data_upd23_wayD    :std_ulogic;
signal congr_cl23_wE_d           :std_ulogic_vector(0 to 5);
signal congr_cl23_wE_q           :std_ulogic_vector(0 to 5);
signal rel_bixu23_wayE_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd23_wayE    :std_ulogic;
signal p1_way_data_upd23_wayE    :std_ulogic;
signal congr_cl23_wF_d           :std_ulogic_vector(0 to 5);
signal congr_cl23_wF_q           :std_ulogic_vector(0 to 5);
signal rel_bixu23_wayF_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd23_wayF    :std_ulogic;
signal p1_way_data_upd23_wayF    :std_ulogic;
signal congr_cl23_wG_d           :std_ulogic_vector(0 to 5);
signal congr_cl23_wG_q           :std_ulogic_vector(0 to 5);
signal rel_bixu23_wayG_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd23_wayG    :std_ulogic;
signal p1_way_data_upd23_wayG    :std_ulogic;
signal congr_cl23_wH_d           :std_ulogic_vector(0 to 5);
signal congr_cl23_wH_q           :std_ulogic_vector(0 to 5);
signal rel_bixu23_wayH_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd23_wayH    :std_ulogic;
signal p1_way_data_upd23_wayH    :std_ulogic;
signal p0_congr_cl24_m            :std_ulogic;
signal p1_congr_cl24_m            :std_ulogic;
signal p0_congr_cl24_act_d        :std_ulogic;
signal p0_congr_cl24_act_q        :std_ulogic;
signal p1_congr_cl24_act_d        :std_ulogic;
signal p1_congr_cl24_act_q        :std_ulogic;
signal congr_cl24_act             :std_ulogic;
signal congr_cl24_wA_d           :std_ulogic_vector(0 to 5);
signal congr_cl24_wA_q           :std_ulogic_vector(0 to 5);
signal rel_bixu24_wayA_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd24_wayA    :std_ulogic;
signal p1_way_data_upd24_wayA    :std_ulogic;
signal congr_cl24_wB_d           :std_ulogic_vector(0 to 5);
signal congr_cl24_wB_q           :std_ulogic_vector(0 to 5);
signal rel_bixu24_wayB_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd24_wayB    :std_ulogic;
signal p1_way_data_upd24_wayB    :std_ulogic;
signal congr_cl24_wC_d           :std_ulogic_vector(0 to 5);
signal congr_cl24_wC_q           :std_ulogic_vector(0 to 5);
signal rel_bixu24_wayC_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd24_wayC    :std_ulogic;
signal p1_way_data_upd24_wayC    :std_ulogic;
signal congr_cl24_wD_d           :std_ulogic_vector(0 to 5);
signal congr_cl24_wD_q           :std_ulogic_vector(0 to 5);
signal rel_bixu24_wayD_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd24_wayD    :std_ulogic;
signal p1_way_data_upd24_wayD    :std_ulogic;
signal congr_cl24_wE_d           :std_ulogic_vector(0 to 5);
signal congr_cl24_wE_q           :std_ulogic_vector(0 to 5);
signal rel_bixu24_wayE_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd24_wayE    :std_ulogic;
signal p1_way_data_upd24_wayE    :std_ulogic;
signal congr_cl24_wF_d           :std_ulogic_vector(0 to 5);
signal congr_cl24_wF_q           :std_ulogic_vector(0 to 5);
signal rel_bixu24_wayF_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd24_wayF    :std_ulogic;
signal p1_way_data_upd24_wayF    :std_ulogic;
signal congr_cl24_wG_d           :std_ulogic_vector(0 to 5);
signal congr_cl24_wG_q           :std_ulogic_vector(0 to 5);
signal rel_bixu24_wayG_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd24_wayG    :std_ulogic;
signal p1_way_data_upd24_wayG    :std_ulogic;
signal congr_cl24_wH_d           :std_ulogic_vector(0 to 5);
signal congr_cl24_wH_q           :std_ulogic_vector(0 to 5);
signal rel_bixu24_wayH_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd24_wayH    :std_ulogic;
signal p1_way_data_upd24_wayH    :std_ulogic;
signal p0_congr_cl25_m            :std_ulogic;
signal p1_congr_cl25_m            :std_ulogic;
signal p0_congr_cl25_act_d        :std_ulogic;
signal p0_congr_cl25_act_q        :std_ulogic;
signal p1_congr_cl25_act_d        :std_ulogic;
signal p1_congr_cl25_act_q        :std_ulogic;
signal congr_cl25_act             :std_ulogic;
signal congr_cl25_wA_d           :std_ulogic_vector(0 to 5);
signal congr_cl25_wA_q           :std_ulogic_vector(0 to 5);
signal rel_bixu25_wayA_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd25_wayA    :std_ulogic;
signal p1_way_data_upd25_wayA    :std_ulogic;
signal congr_cl25_wB_d           :std_ulogic_vector(0 to 5);
signal congr_cl25_wB_q           :std_ulogic_vector(0 to 5);
signal rel_bixu25_wayB_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd25_wayB    :std_ulogic;
signal p1_way_data_upd25_wayB    :std_ulogic;
signal congr_cl25_wC_d           :std_ulogic_vector(0 to 5);
signal congr_cl25_wC_q           :std_ulogic_vector(0 to 5);
signal rel_bixu25_wayC_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd25_wayC    :std_ulogic;
signal p1_way_data_upd25_wayC    :std_ulogic;
signal congr_cl25_wD_d           :std_ulogic_vector(0 to 5);
signal congr_cl25_wD_q           :std_ulogic_vector(0 to 5);
signal rel_bixu25_wayD_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd25_wayD    :std_ulogic;
signal p1_way_data_upd25_wayD    :std_ulogic;
signal congr_cl25_wE_d           :std_ulogic_vector(0 to 5);
signal congr_cl25_wE_q           :std_ulogic_vector(0 to 5);
signal rel_bixu25_wayE_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd25_wayE    :std_ulogic;
signal p1_way_data_upd25_wayE    :std_ulogic;
signal congr_cl25_wF_d           :std_ulogic_vector(0 to 5);
signal congr_cl25_wF_q           :std_ulogic_vector(0 to 5);
signal rel_bixu25_wayF_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd25_wayF    :std_ulogic;
signal p1_way_data_upd25_wayF    :std_ulogic;
signal congr_cl25_wG_d           :std_ulogic_vector(0 to 5);
signal congr_cl25_wG_q           :std_ulogic_vector(0 to 5);
signal rel_bixu25_wayG_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd25_wayG    :std_ulogic;
signal p1_way_data_upd25_wayG    :std_ulogic;
signal congr_cl25_wH_d           :std_ulogic_vector(0 to 5);
signal congr_cl25_wH_q           :std_ulogic_vector(0 to 5);
signal rel_bixu25_wayH_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd25_wayH    :std_ulogic;
signal p1_way_data_upd25_wayH    :std_ulogic;
signal p0_congr_cl26_m            :std_ulogic;
signal p1_congr_cl26_m            :std_ulogic;
signal p0_congr_cl26_act_d        :std_ulogic;
signal p0_congr_cl26_act_q        :std_ulogic;
signal p1_congr_cl26_act_d        :std_ulogic;
signal p1_congr_cl26_act_q        :std_ulogic;
signal congr_cl26_act             :std_ulogic;
signal congr_cl26_wA_d           :std_ulogic_vector(0 to 5);
signal congr_cl26_wA_q           :std_ulogic_vector(0 to 5);
signal rel_bixu26_wayA_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd26_wayA    :std_ulogic;
signal p1_way_data_upd26_wayA    :std_ulogic;
signal congr_cl26_wB_d           :std_ulogic_vector(0 to 5);
signal congr_cl26_wB_q           :std_ulogic_vector(0 to 5);
signal rel_bixu26_wayB_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd26_wayB    :std_ulogic;
signal p1_way_data_upd26_wayB    :std_ulogic;
signal congr_cl26_wC_d           :std_ulogic_vector(0 to 5);
signal congr_cl26_wC_q           :std_ulogic_vector(0 to 5);
signal rel_bixu26_wayC_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd26_wayC    :std_ulogic;
signal p1_way_data_upd26_wayC    :std_ulogic;
signal congr_cl26_wD_d           :std_ulogic_vector(0 to 5);
signal congr_cl26_wD_q           :std_ulogic_vector(0 to 5);
signal rel_bixu26_wayD_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd26_wayD    :std_ulogic;
signal p1_way_data_upd26_wayD    :std_ulogic;
signal congr_cl26_wE_d           :std_ulogic_vector(0 to 5);
signal congr_cl26_wE_q           :std_ulogic_vector(0 to 5);
signal rel_bixu26_wayE_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd26_wayE    :std_ulogic;
signal p1_way_data_upd26_wayE    :std_ulogic;
signal congr_cl26_wF_d           :std_ulogic_vector(0 to 5);
signal congr_cl26_wF_q           :std_ulogic_vector(0 to 5);
signal rel_bixu26_wayF_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd26_wayF    :std_ulogic;
signal p1_way_data_upd26_wayF    :std_ulogic;
signal congr_cl26_wG_d           :std_ulogic_vector(0 to 5);
signal congr_cl26_wG_q           :std_ulogic_vector(0 to 5);
signal rel_bixu26_wayG_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd26_wayG    :std_ulogic;
signal p1_way_data_upd26_wayG    :std_ulogic;
signal congr_cl26_wH_d           :std_ulogic_vector(0 to 5);
signal congr_cl26_wH_q           :std_ulogic_vector(0 to 5);
signal rel_bixu26_wayH_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd26_wayH    :std_ulogic;
signal p1_way_data_upd26_wayH    :std_ulogic;
signal p0_congr_cl27_m            :std_ulogic;
signal p1_congr_cl27_m            :std_ulogic;
signal p0_congr_cl27_act_d        :std_ulogic;
signal p0_congr_cl27_act_q        :std_ulogic;
signal p1_congr_cl27_act_d        :std_ulogic;
signal p1_congr_cl27_act_q        :std_ulogic;
signal congr_cl27_act             :std_ulogic;
signal congr_cl27_wA_d           :std_ulogic_vector(0 to 5);
signal congr_cl27_wA_q           :std_ulogic_vector(0 to 5);
signal rel_bixu27_wayA_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd27_wayA    :std_ulogic;
signal p1_way_data_upd27_wayA    :std_ulogic;
signal congr_cl27_wB_d           :std_ulogic_vector(0 to 5);
signal congr_cl27_wB_q           :std_ulogic_vector(0 to 5);
signal rel_bixu27_wayB_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd27_wayB    :std_ulogic;
signal p1_way_data_upd27_wayB    :std_ulogic;
signal congr_cl27_wC_d           :std_ulogic_vector(0 to 5);
signal congr_cl27_wC_q           :std_ulogic_vector(0 to 5);
signal rel_bixu27_wayC_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd27_wayC    :std_ulogic;
signal p1_way_data_upd27_wayC    :std_ulogic;
signal congr_cl27_wD_d           :std_ulogic_vector(0 to 5);
signal congr_cl27_wD_q           :std_ulogic_vector(0 to 5);
signal rel_bixu27_wayD_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd27_wayD    :std_ulogic;
signal p1_way_data_upd27_wayD    :std_ulogic;
signal congr_cl27_wE_d           :std_ulogic_vector(0 to 5);
signal congr_cl27_wE_q           :std_ulogic_vector(0 to 5);
signal rel_bixu27_wayE_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd27_wayE    :std_ulogic;
signal p1_way_data_upd27_wayE    :std_ulogic;
signal congr_cl27_wF_d           :std_ulogic_vector(0 to 5);
signal congr_cl27_wF_q           :std_ulogic_vector(0 to 5);
signal rel_bixu27_wayF_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd27_wayF    :std_ulogic;
signal p1_way_data_upd27_wayF    :std_ulogic;
signal congr_cl27_wG_d           :std_ulogic_vector(0 to 5);
signal congr_cl27_wG_q           :std_ulogic_vector(0 to 5);
signal rel_bixu27_wayG_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd27_wayG    :std_ulogic;
signal p1_way_data_upd27_wayG    :std_ulogic;
signal congr_cl27_wH_d           :std_ulogic_vector(0 to 5);
signal congr_cl27_wH_q           :std_ulogic_vector(0 to 5);
signal rel_bixu27_wayH_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd27_wayH    :std_ulogic;
signal p1_way_data_upd27_wayH    :std_ulogic;
signal p0_congr_cl28_m            :std_ulogic;
signal p1_congr_cl28_m            :std_ulogic;
signal p0_congr_cl28_act_d        :std_ulogic;
signal p0_congr_cl28_act_q        :std_ulogic;
signal p1_congr_cl28_act_d        :std_ulogic;
signal p1_congr_cl28_act_q        :std_ulogic;
signal congr_cl28_act             :std_ulogic;
signal congr_cl28_wA_d           :std_ulogic_vector(0 to 5);
signal congr_cl28_wA_q           :std_ulogic_vector(0 to 5);
signal rel_bixu28_wayA_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd28_wayA    :std_ulogic;
signal p1_way_data_upd28_wayA    :std_ulogic;
signal congr_cl28_wB_d           :std_ulogic_vector(0 to 5);
signal congr_cl28_wB_q           :std_ulogic_vector(0 to 5);
signal rel_bixu28_wayB_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd28_wayB    :std_ulogic;
signal p1_way_data_upd28_wayB    :std_ulogic;
signal congr_cl28_wC_d           :std_ulogic_vector(0 to 5);
signal congr_cl28_wC_q           :std_ulogic_vector(0 to 5);
signal rel_bixu28_wayC_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd28_wayC    :std_ulogic;
signal p1_way_data_upd28_wayC    :std_ulogic;
signal congr_cl28_wD_d           :std_ulogic_vector(0 to 5);
signal congr_cl28_wD_q           :std_ulogic_vector(0 to 5);
signal rel_bixu28_wayD_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd28_wayD    :std_ulogic;
signal p1_way_data_upd28_wayD    :std_ulogic;
signal congr_cl28_wE_d           :std_ulogic_vector(0 to 5);
signal congr_cl28_wE_q           :std_ulogic_vector(0 to 5);
signal rel_bixu28_wayE_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd28_wayE    :std_ulogic;
signal p1_way_data_upd28_wayE    :std_ulogic;
signal congr_cl28_wF_d           :std_ulogic_vector(0 to 5);
signal congr_cl28_wF_q           :std_ulogic_vector(0 to 5);
signal rel_bixu28_wayF_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd28_wayF    :std_ulogic;
signal p1_way_data_upd28_wayF    :std_ulogic;
signal congr_cl28_wG_d           :std_ulogic_vector(0 to 5);
signal congr_cl28_wG_q           :std_ulogic_vector(0 to 5);
signal rel_bixu28_wayG_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd28_wayG    :std_ulogic;
signal p1_way_data_upd28_wayG    :std_ulogic;
signal congr_cl28_wH_d           :std_ulogic_vector(0 to 5);
signal congr_cl28_wH_q           :std_ulogic_vector(0 to 5);
signal rel_bixu28_wayH_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd28_wayH    :std_ulogic;
signal p1_way_data_upd28_wayH    :std_ulogic;
signal p0_congr_cl29_m            :std_ulogic;
signal p1_congr_cl29_m            :std_ulogic;
signal p0_congr_cl29_act_d        :std_ulogic;
signal p0_congr_cl29_act_q        :std_ulogic;
signal p1_congr_cl29_act_d        :std_ulogic;
signal p1_congr_cl29_act_q        :std_ulogic;
signal congr_cl29_act             :std_ulogic;
signal congr_cl29_wA_d           :std_ulogic_vector(0 to 5);
signal congr_cl29_wA_q           :std_ulogic_vector(0 to 5);
signal rel_bixu29_wayA_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd29_wayA    :std_ulogic;
signal p1_way_data_upd29_wayA    :std_ulogic;
signal congr_cl29_wB_d           :std_ulogic_vector(0 to 5);
signal congr_cl29_wB_q           :std_ulogic_vector(0 to 5);
signal rel_bixu29_wayB_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd29_wayB    :std_ulogic;
signal p1_way_data_upd29_wayB    :std_ulogic;
signal congr_cl29_wC_d           :std_ulogic_vector(0 to 5);
signal congr_cl29_wC_q           :std_ulogic_vector(0 to 5);
signal rel_bixu29_wayC_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd29_wayC    :std_ulogic;
signal p1_way_data_upd29_wayC    :std_ulogic;
signal congr_cl29_wD_d           :std_ulogic_vector(0 to 5);
signal congr_cl29_wD_q           :std_ulogic_vector(0 to 5);
signal rel_bixu29_wayD_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd29_wayD    :std_ulogic;
signal p1_way_data_upd29_wayD    :std_ulogic;
signal congr_cl29_wE_d           :std_ulogic_vector(0 to 5);
signal congr_cl29_wE_q           :std_ulogic_vector(0 to 5);
signal rel_bixu29_wayE_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd29_wayE    :std_ulogic;
signal p1_way_data_upd29_wayE    :std_ulogic;
signal congr_cl29_wF_d           :std_ulogic_vector(0 to 5);
signal congr_cl29_wF_q           :std_ulogic_vector(0 to 5);
signal rel_bixu29_wayF_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd29_wayF    :std_ulogic;
signal p1_way_data_upd29_wayF    :std_ulogic;
signal congr_cl29_wG_d           :std_ulogic_vector(0 to 5);
signal congr_cl29_wG_q           :std_ulogic_vector(0 to 5);
signal rel_bixu29_wayG_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd29_wayG    :std_ulogic;
signal p1_way_data_upd29_wayG    :std_ulogic;
signal congr_cl29_wH_d           :std_ulogic_vector(0 to 5);
signal congr_cl29_wH_q           :std_ulogic_vector(0 to 5);
signal rel_bixu29_wayH_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd29_wayH    :std_ulogic;
signal p1_way_data_upd29_wayH    :std_ulogic;
signal p0_congr_cl30_m            :std_ulogic;
signal p1_congr_cl30_m            :std_ulogic;
signal p0_congr_cl30_act_d        :std_ulogic;
signal p0_congr_cl30_act_q        :std_ulogic;
signal p1_congr_cl30_act_d        :std_ulogic;
signal p1_congr_cl30_act_q        :std_ulogic;
signal congr_cl30_act             :std_ulogic;
signal congr_cl30_wA_d           :std_ulogic_vector(0 to 5);
signal congr_cl30_wA_q           :std_ulogic_vector(0 to 5);
signal rel_bixu30_wayA_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd30_wayA    :std_ulogic;
signal p1_way_data_upd30_wayA    :std_ulogic;
signal congr_cl30_wB_d           :std_ulogic_vector(0 to 5);
signal congr_cl30_wB_q           :std_ulogic_vector(0 to 5);
signal rel_bixu30_wayB_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd30_wayB    :std_ulogic;
signal p1_way_data_upd30_wayB    :std_ulogic;
signal congr_cl30_wC_d           :std_ulogic_vector(0 to 5);
signal congr_cl30_wC_q           :std_ulogic_vector(0 to 5);
signal rel_bixu30_wayC_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd30_wayC    :std_ulogic;
signal p1_way_data_upd30_wayC    :std_ulogic;
signal congr_cl30_wD_d           :std_ulogic_vector(0 to 5);
signal congr_cl30_wD_q           :std_ulogic_vector(0 to 5);
signal rel_bixu30_wayD_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd30_wayD    :std_ulogic;
signal p1_way_data_upd30_wayD    :std_ulogic;
signal congr_cl30_wE_d           :std_ulogic_vector(0 to 5);
signal congr_cl30_wE_q           :std_ulogic_vector(0 to 5);
signal rel_bixu30_wayE_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd30_wayE    :std_ulogic;
signal p1_way_data_upd30_wayE    :std_ulogic;
signal congr_cl30_wF_d           :std_ulogic_vector(0 to 5);
signal congr_cl30_wF_q           :std_ulogic_vector(0 to 5);
signal rel_bixu30_wayF_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd30_wayF    :std_ulogic;
signal p1_way_data_upd30_wayF    :std_ulogic;
signal congr_cl30_wG_d           :std_ulogic_vector(0 to 5);
signal congr_cl30_wG_q           :std_ulogic_vector(0 to 5);
signal rel_bixu30_wayG_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd30_wayG    :std_ulogic;
signal p1_way_data_upd30_wayG    :std_ulogic;
signal congr_cl30_wH_d           :std_ulogic_vector(0 to 5);
signal congr_cl30_wH_q           :std_ulogic_vector(0 to 5);
signal rel_bixu30_wayH_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd30_wayH    :std_ulogic;
signal p1_way_data_upd30_wayH    :std_ulogic;
signal p0_congr_cl31_m            :std_ulogic;
signal p1_congr_cl31_m            :std_ulogic;
signal p0_congr_cl31_act_d        :std_ulogic;
signal p0_congr_cl31_act_q        :std_ulogic;
signal p1_congr_cl31_act_d        :std_ulogic;
signal p1_congr_cl31_act_q        :std_ulogic;
signal congr_cl31_act             :std_ulogic;
signal congr_cl31_wA_d           :std_ulogic_vector(0 to 5);
signal congr_cl31_wA_q           :std_ulogic_vector(0 to 5);
signal rel_bixu31_wayA_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd31_wayA    :std_ulogic;
signal p1_way_data_upd31_wayA    :std_ulogic;
signal congr_cl31_wB_d           :std_ulogic_vector(0 to 5);
signal congr_cl31_wB_q           :std_ulogic_vector(0 to 5);
signal rel_bixu31_wayB_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd31_wayB    :std_ulogic;
signal p1_way_data_upd31_wayB    :std_ulogic;
signal congr_cl31_wC_d           :std_ulogic_vector(0 to 5);
signal congr_cl31_wC_q           :std_ulogic_vector(0 to 5);
signal rel_bixu31_wayC_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd31_wayC    :std_ulogic;
signal p1_way_data_upd31_wayC    :std_ulogic;
signal congr_cl31_wD_d           :std_ulogic_vector(0 to 5);
signal congr_cl31_wD_q           :std_ulogic_vector(0 to 5);
signal rel_bixu31_wayD_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd31_wayD    :std_ulogic;
signal p1_way_data_upd31_wayD    :std_ulogic;
signal congr_cl31_wE_d           :std_ulogic_vector(0 to 5);
signal congr_cl31_wE_q           :std_ulogic_vector(0 to 5);
signal rel_bixu31_wayE_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd31_wayE    :std_ulogic;
signal p1_way_data_upd31_wayE    :std_ulogic;
signal congr_cl31_wF_d           :std_ulogic_vector(0 to 5);
signal congr_cl31_wF_q           :std_ulogic_vector(0 to 5);
signal rel_bixu31_wayF_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd31_wayF    :std_ulogic;
signal p1_way_data_upd31_wayF    :std_ulogic;
signal congr_cl31_wG_d           :std_ulogic_vector(0 to 5);
signal congr_cl31_wG_q           :std_ulogic_vector(0 to 5);
signal rel_bixu31_wayG_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd31_wayG    :std_ulogic;
signal p1_way_data_upd31_wayG    :std_ulogic;
signal congr_cl31_wH_d           :std_ulogic_vector(0 to 5);
signal congr_cl31_wH_q           :std_ulogic_vector(0 to 5);
signal rel_bixu31_wayH_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd31_wayH    :std_ulogic;
signal p1_way_data_upd31_wayH    :std_ulogic;
signal p0_congr_cl32_m            :std_ulogic;
signal p1_congr_cl32_m            :std_ulogic;
signal p0_congr_cl32_act_d        :std_ulogic;
signal p0_congr_cl32_act_q        :std_ulogic;
signal p1_congr_cl32_act_d        :std_ulogic;
signal p1_congr_cl32_act_q        :std_ulogic;
signal congr_cl32_act             :std_ulogic;
signal congr_cl32_wA_d           :std_ulogic_vector(0 to 5);
signal congr_cl32_wA_q           :std_ulogic_vector(0 to 5);
signal rel_bixu32_wayA_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd32_wayA    :std_ulogic;
signal p1_way_data_upd32_wayA    :std_ulogic;
signal congr_cl32_wB_d           :std_ulogic_vector(0 to 5);
signal congr_cl32_wB_q           :std_ulogic_vector(0 to 5);
signal rel_bixu32_wayB_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd32_wayB    :std_ulogic;
signal p1_way_data_upd32_wayB    :std_ulogic;
signal congr_cl32_wC_d           :std_ulogic_vector(0 to 5);
signal congr_cl32_wC_q           :std_ulogic_vector(0 to 5);
signal rel_bixu32_wayC_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd32_wayC    :std_ulogic;
signal p1_way_data_upd32_wayC    :std_ulogic;
signal congr_cl32_wD_d           :std_ulogic_vector(0 to 5);
signal congr_cl32_wD_q           :std_ulogic_vector(0 to 5);
signal rel_bixu32_wayD_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd32_wayD    :std_ulogic;
signal p1_way_data_upd32_wayD    :std_ulogic;
signal congr_cl32_wE_d           :std_ulogic_vector(0 to 5);
signal congr_cl32_wE_q           :std_ulogic_vector(0 to 5);
signal rel_bixu32_wayE_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd32_wayE    :std_ulogic;
signal p1_way_data_upd32_wayE    :std_ulogic;
signal congr_cl32_wF_d           :std_ulogic_vector(0 to 5);
signal congr_cl32_wF_q           :std_ulogic_vector(0 to 5);
signal rel_bixu32_wayF_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd32_wayF    :std_ulogic;
signal p1_way_data_upd32_wayF    :std_ulogic;
signal congr_cl32_wG_d           :std_ulogic_vector(0 to 5);
signal congr_cl32_wG_q           :std_ulogic_vector(0 to 5);
signal rel_bixu32_wayG_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd32_wayG    :std_ulogic;
signal p1_way_data_upd32_wayG    :std_ulogic;
signal congr_cl32_wH_d           :std_ulogic_vector(0 to 5);
signal congr_cl32_wH_q           :std_ulogic_vector(0 to 5);
signal rel_bixu32_wayH_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd32_wayH    :std_ulogic;
signal p1_way_data_upd32_wayH    :std_ulogic;
signal p0_congr_cl33_m            :std_ulogic;
signal p1_congr_cl33_m            :std_ulogic;
signal p0_congr_cl33_act_d        :std_ulogic;
signal p0_congr_cl33_act_q        :std_ulogic;
signal p1_congr_cl33_act_d        :std_ulogic;
signal p1_congr_cl33_act_q        :std_ulogic;
signal congr_cl33_act             :std_ulogic;
signal congr_cl33_wA_d           :std_ulogic_vector(0 to 5);
signal congr_cl33_wA_q           :std_ulogic_vector(0 to 5);
signal rel_bixu33_wayA_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd33_wayA    :std_ulogic;
signal p1_way_data_upd33_wayA    :std_ulogic;
signal congr_cl33_wB_d           :std_ulogic_vector(0 to 5);
signal congr_cl33_wB_q           :std_ulogic_vector(0 to 5);
signal rel_bixu33_wayB_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd33_wayB    :std_ulogic;
signal p1_way_data_upd33_wayB    :std_ulogic;
signal congr_cl33_wC_d           :std_ulogic_vector(0 to 5);
signal congr_cl33_wC_q           :std_ulogic_vector(0 to 5);
signal rel_bixu33_wayC_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd33_wayC    :std_ulogic;
signal p1_way_data_upd33_wayC    :std_ulogic;
signal congr_cl33_wD_d           :std_ulogic_vector(0 to 5);
signal congr_cl33_wD_q           :std_ulogic_vector(0 to 5);
signal rel_bixu33_wayD_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd33_wayD    :std_ulogic;
signal p1_way_data_upd33_wayD    :std_ulogic;
signal congr_cl33_wE_d           :std_ulogic_vector(0 to 5);
signal congr_cl33_wE_q           :std_ulogic_vector(0 to 5);
signal rel_bixu33_wayE_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd33_wayE    :std_ulogic;
signal p1_way_data_upd33_wayE    :std_ulogic;
signal congr_cl33_wF_d           :std_ulogic_vector(0 to 5);
signal congr_cl33_wF_q           :std_ulogic_vector(0 to 5);
signal rel_bixu33_wayF_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd33_wayF    :std_ulogic;
signal p1_way_data_upd33_wayF    :std_ulogic;
signal congr_cl33_wG_d           :std_ulogic_vector(0 to 5);
signal congr_cl33_wG_q           :std_ulogic_vector(0 to 5);
signal rel_bixu33_wayG_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd33_wayG    :std_ulogic;
signal p1_way_data_upd33_wayG    :std_ulogic;
signal congr_cl33_wH_d           :std_ulogic_vector(0 to 5);
signal congr_cl33_wH_q           :std_ulogic_vector(0 to 5);
signal rel_bixu33_wayH_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd33_wayH    :std_ulogic;
signal p1_way_data_upd33_wayH    :std_ulogic;
signal p0_congr_cl34_m            :std_ulogic;
signal p1_congr_cl34_m            :std_ulogic;
signal p0_congr_cl34_act_d        :std_ulogic;
signal p0_congr_cl34_act_q        :std_ulogic;
signal p1_congr_cl34_act_d        :std_ulogic;
signal p1_congr_cl34_act_q        :std_ulogic;
signal congr_cl34_act             :std_ulogic;
signal congr_cl34_wA_d           :std_ulogic_vector(0 to 5);
signal congr_cl34_wA_q           :std_ulogic_vector(0 to 5);
signal rel_bixu34_wayA_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd34_wayA    :std_ulogic;
signal p1_way_data_upd34_wayA    :std_ulogic;
signal congr_cl34_wB_d           :std_ulogic_vector(0 to 5);
signal congr_cl34_wB_q           :std_ulogic_vector(0 to 5);
signal rel_bixu34_wayB_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd34_wayB    :std_ulogic;
signal p1_way_data_upd34_wayB    :std_ulogic;
signal congr_cl34_wC_d           :std_ulogic_vector(0 to 5);
signal congr_cl34_wC_q           :std_ulogic_vector(0 to 5);
signal rel_bixu34_wayC_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd34_wayC    :std_ulogic;
signal p1_way_data_upd34_wayC    :std_ulogic;
signal congr_cl34_wD_d           :std_ulogic_vector(0 to 5);
signal congr_cl34_wD_q           :std_ulogic_vector(0 to 5);
signal rel_bixu34_wayD_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd34_wayD    :std_ulogic;
signal p1_way_data_upd34_wayD    :std_ulogic;
signal congr_cl34_wE_d           :std_ulogic_vector(0 to 5);
signal congr_cl34_wE_q           :std_ulogic_vector(0 to 5);
signal rel_bixu34_wayE_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd34_wayE    :std_ulogic;
signal p1_way_data_upd34_wayE    :std_ulogic;
signal congr_cl34_wF_d           :std_ulogic_vector(0 to 5);
signal congr_cl34_wF_q           :std_ulogic_vector(0 to 5);
signal rel_bixu34_wayF_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd34_wayF    :std_ulogic;
signal p1_way_data_upd34_wayF    :std_ulogic;
signal congr_cl34_wG_d           :std_ulogic_vector(0 to 5);
signal congr_cl34_wG_q           :std_ulogic_vector(0 to 5);
signal rel_bixu34_wayG_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd34_wayG    :std_ulogic;
signal p1_way_data_upd34_wayG    :std_ulogic;
signal congr_cl34_wH_d           :std_ulogic_vector(0 to 5);
signal congr_cl34_wH_q           :std_ulogic_vector(0 to 5);
signal rel_bixu34_wayH_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd34_wayH    :std_ulogic;
signal p1_way_data_upd34_wayH    :std_ulogic;
signal p0_congr_cl35_m            :std_ulogic;
signal p1_congr_cl35_m            :std_ulogic;
signal p0_congr_cl35_act_d        :std_ulogic;
signal p0_congr_cl35_act_q        :std_ulogic;
signal p1_congr_cl35_act_d        :std_ulogic;
signal p1_congr_cl35_act_q        :std_ulogic;
signal congr_cl35_act             :std_ulogic;
signal congr_cl35_wA_d           :std_ulogic_vector(0 to 5);
signal congr_cl35_wA_q           :std_ulogic_vector(0 to 5);
signal rel_bixu35_wayA_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd35_wayA    :std_ulogic;
signal p1_way_data_upd35_wayA    :std_ulogic;
signal congr_cl35_wB_d           :std_ulogic_vector(0 to 5);
signal congr_cl35_wB_q           :std_ulogic_vector(0 to 5);
signal rel_bixu35_wayB_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd35_wayB    :std_ulogic;
signal p1_way_data_upd35_wayB    :std_ulogic;
signal congr_cl35_wC_d           :std_ulogic_vector(0 to 5);
signal congr_cl35_wC_q           :std_ulogic_vector(0 to 5);
signal rel_bixu35_wayC_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd35_wayC    :std_ulogic;
signal p1_way_data_upd35_wayC    :std_ulogic;
signal congr_cl35_wD_d           :std_ulogic_vector(0 to 5);
signal congr_cl35_wD_q           :std_ulogic_vector(0 to 5);
signal rel_bixu35_wayD_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd35_wayD    :std_ulogic;
signal p1_way_data_upd35_wayD    :std_ulogic;
signal congr_cl35_wE_d           :std_ulogic_vector(0 to 5);
signal congr_cl35_wE_q           :std_ulogic_vector(0 to 5);
signal rel_bixu35_wayE_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd35_wayE    :std_ulogic;
signal p1_way_data_upd35_wayE    :std_ulogic;
signal congr_cl35_wF_d           :std_ulogic_vector(0 to 5);
signal congr_cl35_wF_q           :std_ulogic_vector(0 to 5);
signal rel_bixu35_wayF_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd35_wayF    :std_ulogic;
signal p1_way_data_upd35_wayF    :std_ulogic;
signal congr_cl35_wG_d           :std_ulogic_vector(0 to 5);
signal congr_cl35_wG_q           :std_ulogic_vector(0 to 5);
signal rel_bixu35_wayG_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd35_wayG    :std_ulogic;
signal p1_way_data_upd35_wayG    :std_ulogic;
signal congr_cl35_wH_d           :std_ulogic_vector(0 to 5);
signal congr_cl35_wH_q           :std_ulogic_vector(0 to 5);
signal rel_bixu35_wayH_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd35_wayH    :std_ulogic;
signal p1_way_data_upd35_wayH    :std_ulogic;
signal p0_congr_cl36_m            :std_ulogic;
signal p1_congr_cl36_m            :std_ulogic;
signal p0_congr_cl36_act_d        :std_ulogic;
signal p0_congr_cl36_act_q        :std_ulogic;
signal p1_congr_cl36_act_d        :std_ulogic;
signal p1_congr_cl36_act_q        :std_ulogic;
signal congr_cl36_act             :std_ulogic;
signal congr_cl36_wA_d           :std_ulogic_vector(0 to 5);
signal congr_cl36_wA_q           :std_ulogic_vector(0 to 5);
signal rel_bixu36_wayA_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd36_wayA    :std_ulogic;
signal p1_way_data_upd36_wayA    :std_ulogic;
signal congr_cl36_wB_d           :std_ulogic_vector(0 to 5);
signal congr_cl36_wB_q           :std_ulogic_vector(0 to 5);
signal rel_bixu36_wayB_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd36_wayB    :std_ulogic;
signal p1_way_data_upd36_wayB    :std_ulogic;
signal congr_cl36_wC_d           :std_ulogic_vector(0 to 5);
signal congr_cl36_wC_q           :std_ulogic_vector(0 to 5);
signal rel_bixu36_wayC_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd36_wayC    :std_ulogic;
signal p1_way_data_upd36_wayC    :std_ulogic;
signal congr_cl36_wD_d           :std_ulogic_vector(0 to 5);
signal congr_cl36_wD_q           :std_ulogic_vector(0 to 5);
signal rel_bixu36_wayD_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd36_wayD    :std_ulogic;
signal p1_way_data_upd36_wayD    :std_ulogic;
signal congr_cl36_wE_d           :std_ulogic_vector(0 to 5);
signal congr_cl36_wE_q           :std_ulogic_vector(0 to 5);
signal rel_bixu36_wayE_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd36_wayE    :std_ulogic;
signal p1_way_data_upd36_wayE    :std_ulogic;
signal congr_cl36_wF_d           :std_ulogic_vector(0 to 5);
signal congr_cl36_wF_q           :std_ulogic_vector(0 to 5);
signal rel_bixu36_wayF_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd36_wayF    :std_ulogic;
signal p1_way_data_upd36_wayF    :std_ulogic;
signal congr_cl36_wG_d           :std_ulogic_vector(0 to 5);
signal congr_cl36_wG_q           :std_ulogic_vector(0 to 5);
signal rel_bixu36_wayG_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd36_wayG    :std_ulogic;
signal p1_way_data_upd36_wayG    :std_ulogic;
signal congr_cl36_wH_d           :std_ulogic_vector(0 to 5);
signal congr_cl36_wH_q           :std_ulogic_vector(0 to 5);
signal rel_bixu36_wayH_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd36_wayH    :std_ulogic;
signal p1_way_data_upd36_wayH    :std_ulogic;
signal p0_congr_cl37_m            :std_ulogic;
signal p1_congr_cl37_m            :std_ulogic;
signal p0_congr_cl37_act_d        :std_ulogic;
signal p0_congr_cl37_act_q        :std_ulogic;
signal p1_congr_cl37_act_d        :std_ulogic;
signal p1_congr_cl37_act_q        :std_ulogic;
signal congr_cl37_act             :std_ulogic;
signal congr_cl37_wA_d           :std_ulogic_vector(0 to 5);
signal congr_cl37_wA_q           :std_ulogic_vector(0 to 5);
signal rel_bixu37_wayA_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd37_wayA    :std_ulogic;
signal p1_way_data_upd37_wayA    :std_ulogic;
signal congr_cl37_wB_d           :std_ulogic_vector(0 to 5);
signal congr_cl37_wB_q           :std_ulogic_vector(0 to 5);
signal rel_bixu37_wayB_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd37_wayB    :std_ulogic;
signal p1_way_data_upd37_wayB    :std_ulogic;
signal congr_cl37_wC_d           :std_ulogic_vector(0 to 5);
signal congr_cl37_wC_q           :std_ulogic_vector(0 to 5);
signal rel_bixu37_wayC_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd37_wayC    :std_ulogic;
signal p1_way_data_upd37_wayC    :std_ulogic;
signal congr_cl37_wD_d           :std_ulogic_vector(0 to 5);
signal congr_cl37_wD_q           :std_ulogic_vector(0 to 5);
signal rel_bixu37_wayD_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd37_wayD    :std_ulogic;
signal p1_way_data_upd37_wayD    :std_ulogic;
signal congr_cl37_wE_d           :std_ulogic_vector(0 to 5);
signal congr_cl37_wE_q           :std_ulogic_vector(0 to 5);
signal rel_bixu37_wayE_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd37_wayE    :std_ulogic;
signal p1_way_data_upd37_wayE    :std_ulogic;
signal congr_cl37_wF_d           :std_ulogic_vector(0 to 5);
signal congr_cl37_wF_q           :std_ulogic_vector(0 to 5);
signal rel_bixu37_wayF_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd37_wayF    :std_ulogic;
signal p1_way_data_upd37_wayF    :std_ulogic;
signal congr_cl37_wG_d           :std_ulogic_vector(0 to 5);
signal congr_cl37_wG_q           :std_ulogic_vector(0 to 5);
signal rel_bixu37_wayG_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd37_wayG    :std_ulogic;
signal p1_way_data_upd37_wayG    :std_ulogic;
signal congr_cl37_wH_d           :std_ulogic_vector(0 to 5);
signal congr_cl37_wH_q           :std_ulogic_vector(0 to 5);
signal rel_bixu37_wayH_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd37_wayH    :std_ulogic;
signal p1_way_data_upd37_wayH    :std_ulogic;
signal p0_congr_cl38_m            :std_ulogic;
signal p1_congr_cl38_m            :std_ulogic;
signal p0_congr_cl38_act_d        :std_ulogic;
signal p0_congr_cl38_act_q        :std_ulogic;
signal p1_congr_cl38_act_d        :std_ulogic;
signal p1_congr_cl38_act_q        :std_ulogic;
signal congr_cl38_act             :std_ulogic;
signal congr_cl38_wA_d           :std_ulogic_vector(0 to 5);
signal congr_cl38_wA_q           :std_ulogic_vector(0 to 5);
signal rel_bixu38_wayA_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd38_wayA    :std_ulogic;
signal p1_way_data_upd38_wayA    :std_ulogic;
signal congr_cl38_wB_d           :std_ulogic_vector(0 to 5);
signal congr_cl38_wB_q           :std_ulogic_vector(0 to 5);
signal rel_bixu38_wayB_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd38_wayB    :std_ulogic;
signal p1_way_data_upd38_wayB    :std_ulogic;
signal congr_cl38_wC_d           :std_ulogic_vector(0 to 5);
signal congr_cl38_wC_q           :std_ulogic_vector(0 to 5);
signal rel_bixu38_wayC_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd38_wayC    :std_ulogic;
signal p1_way_data_upd38_wayC    :std_ulogic;
signal congr_cl38_wD_d           :std_ulogic_vector(0 to 5);
signal congr_cl38_wD_q           :std_ulogic_vector(0 to 5);
signal rel_bixu38_wayD_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd38_wayD    :std_ulogic;
signal p1_way_data_upd38_wayD    :std_ulogic;
signal congr_cl38_wE_d           :std_ulogic_vector(0 to 5);
signal congr_cl38_wE_q           :std_ulogic_vector(0 to 5);
signal rel_bixu38_wayE_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd38_wayE    :std_ulogic;
signal p1_way_data_upd38_wayE    :std_ulogic;
signal congr_cl38_wF_d           :std_ulogic_vector(0 to 5);
signal congr_cl38_wF_q           :std_ulogic_vector(0 to 5);
signal rel_bixu38_wayF_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd38_wayF    :std_ulogic;
signal p1_way_data_upd38_wayF    :std_ulogic;
signal congr_cl38_wG_d           :std_ulogic_vector(0 to 5);
signal congr_cl38_wG_q           :std_ulogic_vector(0 to 5);
signal rel_bixu38_wayG_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd38_wayG    :std_ulogic;
signal p1_way_data_upd38_wayG    :std_ulogic;
signal congr_cl38_wH_d           :std_ulogic_vector(0 to 5);
signal congr_cl38_wH_q           :std_ulogic_vector(0 to 5);
signal rel_bixu38_wayH_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd38_wayH    :std_ulogic;
signal p1_way_data_upd38_wayH    :std_ulogic;
signal p0_congr_cl39_m            :std_ulogic;
signal p1_congr_cl39_m            :std_ulogic;
signal p0_congr_cl39_act_d        :std_ulogic;
signal p0_congr_cl39_act_q        :std_ulogic;
signal p1_congr_cl39_act_d        :std_ulogic;
signal p1_congr_cl39_act_q        :std_ulogic;
signal congr_cl39_act             :std_ulogic;
signal congr_cl39_wA_d           :std_ulogic_vector(0 to 5);
signal congr_cl39_wA_q           :std_ulogic_vector(0 to 5);
signal rel_bixu39_wayA_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd39_wayA    :std_ulogic;
signal p1_way_data_upd39_wayA    :std_ulogic;
signal congr_cl39_wB_d           :std_ulogic_vector(0 to 5);
signal congr_cl39_wB_q           :std_ulogic_vector(0 to 5);
signal rel_bixu39_wayB_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd39_wayB    :std_ulogic;
signal p1_way_data_upd39_wayB    :std_ulogic;
signal congr_cl39_wC_d           :std_ulogic_vector(0 to 5);
signal congr_cl39_wC_q           :std_ulogic_vector(0 to 5);
signal rel_bixu39_wayC_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd39_wayC    :std_ulogic;
signal p1_way_data_upd39_wayC    :std_ulogic;
signal congr_cl39_wD_d           :std_ulogic_vector(0 to 5);
signal congr_cl39_wD_q           :std_ulogic_vector(0 to 5);
signal rel_bixu39_wayD_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd39_wayD    :std_ulogic;
signal p1_way_data_upd39_wayD    :std_ulogic;
signal congr_cl39_wE_d           :std_ulogic_vector(0 to 5);
signal congr_cl39_wE_q           :std_ulogic_vector(0 to 5);
signal rel_bixu39_wayE_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd39_wayE    :std_ulogic;
signal p1_way_data_upd39_wayE    :std_ulogic;
signal congr_cl39_wF_d           :std_ulogic_vector(0 to 5);
signal congr_cl39_wF_q           :std_ulogic_vector(0 to 5);
signal rel_bixu39_wayF_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd39_wayF    :std_ulogic;
signal p1_way_data_upd39_wayF    :std_ulogic;
signal congr_cl39_wG_d           :std_ulogic_vector(0 to 5);
signal congr_cl39_wG_q           :std_ulogic_vector(0 to 5);
signal rel_bixu39_wayG_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd39_wayG    :std_ulogic;
signal p1_way_data_upd39_wayG    :std_ulogic;
signal congr_cl39_wH_d           :std_ulogic_vector(0 to 5);
signal congr_cl39_wH_q           :std_ulogic_vector(0 to 5);
signal rel_bixu39_wayH_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd39_wayH    :std_ulogic;
signal p1_way_data_upd39_wayH    :std_ulogic;
signal p0_congr_cl40_m            :std_ulogic;
signal p1_congr_cl40_m            :std_ulogic;
signal p0_congr_cl40_act_d        :std_ulogic;
signal p0_congr_cl40_act_q        :std_ulogic;
signal p1_congr_cl40_act_d        :std_ulogic;
signal p1_congr_cl40_act_q        :std_ulogic;
signal congr_cl40_act             :std_ulogic;
signal congr_cl40_wA_d           :std_ulogic_vector(0 to 5);
signal congr_cl40_wA_q           :std_ulogic_vector(0 to 5);
signal rel_bixu40_wayA_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd40_wayA    :std_ulogic;
signal p1_way_data_upd40_wayA    :std_ulogic;
signal congr_cl40_wB_d           :std_ulogic_vector(0 to 5);
signal congr_cl40_wB_q           :std_ulogic_vector(0 to 5);
signal rel_bixu40_wayB_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd40_wayB    :std_ulogic;
signal p1_way_data_upd40_wayB    :std_ulogic;
signal congr_cl40_wC_d           :std_ulogic_vector(0 to 5);
signal congr_cl40_wC_q           :std_ulogic_vector(0 to 5);
signal rel_bixu40_wayC_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd40_wayC    :std_ulogic;
signal p1_way_data_upd40_wayC    :std_ulogic;
signal congr_cl40_wD_d           :std_ulogic_vector(0 to 5);
signal congr_cl40_wD_q           :std_ulogic_vector(0 to 5);
signal rel_bixu40_wayD_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd40_wayD    :std_ulogic;
signal p1_way_data_upd40_wayD    :std_ulogic;
signal congr_cl40_wE_d           :std_ulogic_vector(0 to 5);
signal congr_cl40_wE_q           :std_ulogic_vector(0 to 5);
signal rel_bixu40_wayE_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd40_wayE    :std_ulogic;
signal p1_way_data_upd40_wayE    :std_ulogic;
signal congr_cl40_wF_d           :std_ulogic_vector(0 to 5);
signal congr_cl40_wF_q           :std_ulogic_vector(0 to 5);
signal rel_bixu40_wayF_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd40_wayF    :std_ulogic;
signal p1_way_data_upd40_wayF    :std_ulogic;
signal congr_cl40_wG_d           :std_ulogic_vector(0 to 5);
signal congr_cl40_wG_q           :std_ulogic_vector(0 to 5);
signal rel_bixu40_wayG_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd40_wayG    :std_ulogic;
signal p1_way_data_upd40_wayG    :std_ulogic;
signal congr_cl40_wH_d           :std_ulogic_vector(0 to 5);
signal congr_cl40_wH_q           :std_ulogic_vector(0 to 5);
signal rel_bixu40_wayH_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd40_wayH    :std_ulogic;
signal p1_way_data_upd40_wayH    :std_ulogic;
signal p0_congr_cl41_m            :std_ulogic;
signal p1_congr_cl41_m            :std_ulogic;
signal p0_congr_cl41_act_d        :std_ulogic;
signal p0_congr_cl41_act_q        :std_ulogic;
signal p1_congr_cl41_act_d        :std_ulogic;
signal p1_congr_cl41_act_q        :std_ulogic;
signal congr_cl41_act             :std_ulogic;
signal congr_cl41_wA_d           :std_ulogic_vector(0 to 5);
signal congr_cl41_wA_q           :std_ulogic_vector(0 to 5);
signal rel_bixu41_wayA_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd41_wayA    :std_ulogic;
signal p1_way_data_upd41_wayA    :std_ulogic;
signal congr_cl41_wB_d           :std_ulogic_vector(0 to 5);
signal congr_cl41_wB_q           :std_ulogic_vector(0 to 5);
signal rel_bixu41_wayB_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd41_wayB    :std_ulogic;
signal p1_way_data_upd41_wayB    :std_ulogic;
signal congr_cl41_wC_d           :std_ulogic_vector(0 to 5);
signal congr_cl41_wC_q           :std_ulogic_vector(0 to 5);
signal rel_bixu41_wayC_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd41_wayC    :std_ulogic;
signal p1_way_data_upd41_wayC    :std_ulogic;
signal congr_cl41_wD_d           :std_ulogic_vector(0 to 5);
signal congr_cl41_wD_q           :std_ulogic_vector(0 to 5);
signal rel_bixu41_wayD_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd41_wayD    :std_ulogic;
signal p1_way_data_upd41_wayD    :std_ulogic;
signal congr_cl41_wE_d           :std_ulogic_vector(0 to 5);
signal congr_cl41_wE_q           :std_ulogic_vector(0 to 5);
signal rel_bixu41_wayE_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd41_wayE    :std_ulogic;
signal p1_way_data_upd41_wayE    :std_ulogic;
signal congr_cl41_wF_d           :std_ulogic_vector(0 to 5);
signal congr_cl41_wF_q           :std_ulogic_vector(0 to 5);
signal rel_bixu41_wayF_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd41_wayF    :std_ulogic;
signal p1_way_data_upd41_wayF    :std_ulogic;
signal congr_cl41_wG_d           :std_ulogic_vector(0 to 5);
signal congr_cl41_wG_q           :std_ulogic_vector(0 to 5);
signal rel_bixu41_wayG_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd41_wayG    :std_ulogic;
signal p1_way_data_upd41_wayG    :std_ulogic;
signal congr_cl41_wH_d           :std_ulogic_vector(0 to 5);
signal congr_cl41_wH_q           :std_ulogic_vector(0 to 5);
signal rel_bixu41_wayH_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd41_wayH    :std_ulogic;
signal p1_way_data_upd41_wayH    :std_ulogic;
signal p0_congr_cl42_m            :std_ulogic;
signal p1_congr_cl42_m            :std_ulogic;
signal p0_congr_cl42_act_d        :std_ulogic;
signal p0_congr_cl42_act_q        :std_ulogic;
signal p1_congr_cl42_act_d        :std_ulogic;
signal p1_congr_cl42_act_q        :std_ulogic;
signal congr_cl42_act             :std_ulogic;
signal congr_cl42_wA_d           :std_ulogic_vector(0 to 5);
signal congr_cl42_wA_q           :std_ulogic_vector(0 to 5);
signal rel_bixu42_wayA_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd42_wayA    :std_ulogic;
signal p1_way_data_upd42_wayA    :std_ulogic;
signal congr_cl42_wB_d           :std_ulogic_vector(0 to 5);
signal congr_cl42_wB_q           :std_ulogic_vector(0 to 5);
signal rel_bixu42_wayB_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd42_wayB    :std_ulogic;
signal p1_way_data_upd42_wayB    :std_ulogic;
signal congr_cl42_wC_d           :std_ulogic_vector(0 to 5);
signal congr_cl42_wC_q           :std_ulogic_vector(0 to 5);
signal rel_bixu42_wayC_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd42_wayC    :std_ulogic;
signal p1_way_data_upd42_wayC    :std_ulogic;
signal congr_cl42_wD_d           :std_ulogic_vector(0 to 5);
signal congr_cl42_wD_q           :std_ulogic_vector(0 to 5);
signal rel_bixu42_wayD_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd42_wayD    :std_ulogic;
signal p1_way_data_upd42_wayD    :std_ulogic;
signal congr_cl42_wE_d           :std_ulogic_vector(0 to 5);
signal congr_cl42_wE_q           :std_ulogic_vector(0 to 5);
signal rel_bixu42_wayE_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd42_wayE    :std_ulogic;
signal p1_way_data_upd42_wayE    :std_ulogic;
signal congr_cl42_wF_d           :std_ulogic_vector(0 to 5);
signal congr_cl42_wF_q           :std_ulogic_vector(0 to 5);
signal rel_bixu42_wayF_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd42_wayF    :std_ulogic;
signal p1_way_data_upd42_wayF    :std_ulogic;
signal congr_cl42_wG_d           :std_ulogic_vector(0 to 5);
signal congr_cl42_wG_q           :std_ulogic_vector(0 to 5);
signal rel_bixu42_wayG_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd42_wayG    :std_ulogic;
signal p1_way_data_upd42_wayG    :std_ulogic;
signal congr_cl42_wH_d           :std_ulogic_vector(0 to 5);
signal congr_cl42_wH_q           :std_ulogic_vector(0 to 5);
signal rel_bixu42_wayH_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd42_wayH    :std_ulogic;
signal p1_way_data_upd42_wayH    :std_ulogic;
signal p0_congr_cl43_m            :std_ulogic;
signal p1_congr_cl43_m            :std_ulogic;
signal p0_congr_cl43_act_d        :std_ulogic;
signal p0_congr_cl43_act_q        :std_ulogic;
signal p1_congr_cl43_act_d        :std_ulogic;
signal p1_congr_cl43_act_q        :std_ulogic;
signal congr_cl43_act             :std_ulogic;
signal congr_cl43_wA_d           :std_ulogic_vector(0 to 5);
signal congr_cl43_wA_q           :std_ulogic_vector(0 to 5);
signal rel_bixu43_wayA_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd43_wayA    :std_ulogic;
signal p1_way_data_upd43_wayA    :std_ulogic;
signal congr_cl43_wB_d           :std_ulogic_vector(0 to 5);
signal congr_cl43_wB_q           :std_ulogic_vector(0 to 5);
signal rel_bixu43_wayB_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd43_wayB    :std_ulogic;
signal p1_way_data_upd43_wayB    :std_ulogic;
signal congr_cl43_wC_d           :std_ulogic_vector(0 to 5);
signal congr_cl43_wC_q           :std_ulogic_vector(0 to 5);
signal rel_bixu43_wayC_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd43_wayC    :std_ulogic;
signal p1_way_data_upd43_wayC    :std_ulogic;
signal congr_cl43_wD_d           :std_ulogic_vector(0 to 5);
signal congr_cl43_wD_q           :std_ulogic_vector(0 to 5);
signal rel_bixu43_wayD_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd43_wayD    :std_ulogic;
signal p1_way_data_upd43_wayD    :std_ulogic;
signal congr_cl43_wE_d           :std_ulogic_vector(0 to 5);
signal congr_cl43_wE_q           :std_ulogic_vector(0 to 5);
signal rel_bixu43_wayE_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd43_wayE    :std_ulogic;
signal p1_way_data_upd43_wayE    :std_ulogic;
signal congr_cl43_wF_d           :std_ulogic_vector(0 to 5);
signal congr_cl43_wF_q           :std_ulogic_vector(0 to 5);
signal rel_bixu43_wayF_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd43_wayF    :std_ulogic;
signal p1_way_data_upd43_wayF    :std_ulogic;
signal congr_cl43_wG_d           :std_ulogic_vector(0 to 5);
signal congr_cl43_wG_q           :std_ulogic_vector(0 to 5);
signal rel_bixu43_wayG_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd43_wayG    :std_ulogic;
signal p1_way_data_upd43_wayG    :std_ulogic;
signal congr_cl43_wH_d           :std_ulogic_vector(0 to 5);
signal congr_cl43_wH_q           :std_ulogic_vector(0 to 5);
signal rel_bixu43_wayH_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd43_wayH    :std_ulogic;
signal p1_way_data_upd43_wayH    :std_ulogic;
signal p0_congr_cl44_m            :std_ulogic;
signal p1_congr_cl44_m            :std_ulogic;
signal p0_congr_cl44_act_d        :std_ulogic;
signal p0_congr_cl44_act_q        :std_ulogic;
signal p1_congr_cl44_act_d        :std_ulogic;
signal p1_congr_cl44_act_q        :std_ulogic;
signal congr_cl44_act             :std_ulogic;
signal congr_cl44_wA_d           :std_ulogic_vector(0 to 5);
signal congr_cl44_wA_q           :std_ulogic_vector(0 to 5);
signal rel_bixu44_wayA_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd44_wayA    :std_ulogic;
signal p1_way_data_upd44_wayA    :std_ulogic;
signal congr_cl44_wB_d           :std_ulogic_vector(0 to 5);
signal congr_cl44_wB_q           :std_ulogic_vector(0 to 5);
signal rel_bixu44_wayB_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd44_wayB    :std_ulogic;
signal p1_way_data_upd44_wayB    :std_ulogic;
signal congr_cl44_wC_d           :std_ulogic_vector(0 to 5);
signal congr_cl44_wC_q           :std_ulogic_vector(0 to 5);
signal rel_bixu44_wayC_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd44_wayC    :std_ulogic;
signal p1_way_data_upd44_wayC    :std_ulogic;
signal congr_cl44_wD_d           :std_ulogic_vector(0 to 5);
signal congr_cl44_wD_q           :std_ulogic_vector(0 to 5);
signal rel_bixu44_wayD_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd44_wayD    :std_ulogic;
signal p1_way_data_upd44_wayD    :std_ulogic;
signal congr_cl44_wE_d           :std_ulogic_vector(0 to 5);
signal congr_cl44_wE_q           :std_ulogic_vector(0 to 5);
signal rel_bixu44_wayE_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd44_wayE    :std_ulogic;
signal p1_way_data_upd44_wayE    :std_ulogic;
signal congr_cl44_wF_d           :std_ulogic_vector(0 to 5);
signal congr_cl44_wF_q           :std_ulogic_vector(0 to 5);
signal rel_bixu44_wayF_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd44_wayF    :std_ulogic;
signal p1_way_data_upd44_wayF    :std_ulogic;
signal congr_cl44_wG_d           :std_ulogic_vector(0 to 5);
signal congr_cl44_wG_q           :std_ulogic_vector(0 to 5);
signal rel_bixu44_wayG_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd44_wayG    :std_ulogic;
signal p1_way_data_upd44_wayG    :std_ulogic;
signal congr_cl44_wH_d           :std_ulogic_vector(0 to 5);
signal congr_cl44_wH_q           :std_ulogic_vector(0 to 5);
signal rel_bixu44_wayH_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd44_wayH    :std_ulogic;
signal p1_way_data_upd44_wayH    :std_ulogic;
signal p0_congr_cl45_m            :std_ulogic;
signal p1_congr_cl45_m            :std_ulogic;
signal p0_congr_cl45_act_d        :std_ulogic;
signal p0_congr_cl45_act_q        :std_ulogic;
signal p1_congr_cl45_act_d        :std_ulogic;
signal p1_congr_cl45_act_q        :std_ulogic;
signal congr_cl45_act             :std_ulogic;
signal congr_cl45_wA_d           :std_ulogic_vector(0 to 5);
signal congr_cl45_wA_q           :std_ulogic_vector(0 to 5);
signal rel_bixu45_wayA_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd45_wayA    :std_ulogic;
signal p1_way_data_upd45_wayA    :std_ulogic;
signal congr_cl45_wB_d           :std_ulogic_vector(0 to 5);
signal congr_cl45_wB_q           :std_ulogic_vector(0 to 5);
signal rel_bixu45_wayB_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd45_wayB    :std_ulogic;
signal p1_way_data_upd45_wayB    :std_ulogic;
signal congr_cl45_wC_d           :std_ulogic_vector(0 to 5);
signal congr_cl45_wC_q           :std_ulogic_vector(0 to 5);
signal rel_bixu45_wayC_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd45_wayC    :std_ulogic;
signal p1_way_data_upd45_wayC    :std_ulogic;
signal congr_cl45_wD_d           :std_ulogic_vector(0 to 5);
signal congr_cl45_wD_q           :std_ulogic_vector(0 to 5);
signal rel_bixu45_wayD_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd45_wayD    :std_ulogic;
signal p1_way_data_upd45_wayD    :std_ulogic;
signal congr_cl45_wE_d           :std_ulogic_vector(0 to 5);
signal congr_cl45_wE_q           :std_ulogic_vector(0 to 5);
signal rel_bixu45_wayE_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd45_wayE    :std_ulogic;
signal p1_way_data_upd45_wayE    :std_ulogic;
signal congr_cl45_wF_d           :std_ulogic_vector(0 to 5);
signal congr_cl45_wF_q           :std_ulogic_vector(0 to 5);
signal rel_bixu45_wayF_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd45_wayF    :std_ulogic;
signal p1_way_data_upd45_wayF    :std_ulogic;
signal congr_cl45_wG_d           :std_ulogic_vector(0 to 5);
signal congr_cl45_wG_q           :std_ulogic_vector(0 to 5);
signal rel_bixu45_wayG_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd45_wayG    :std_ulogic;
signal p1_way_data_upd45_wayG    :std_ulogic;
signal congr_cl45_wH_d           :std_ulogic_vector(0 to 5);
signal congr_cl45_wH_q           :std_ulogic_vector(0 to 5);
signal rel_bixu45_wayH_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd45_wayH    :std_ulogic;
signal p1_way_data_upd45_wayH    :std_ulogic;
signal p0_congr_cl46_m            :std_ulogic;
signal p1_congr_cl46_m            :std_ulogic;
signal p0_congr_cl46_act_d        :std_ulogic;
signal p0_congr_cl46_act_q        :std_ulogic;
signal p1_congr_cl46_act_d        :std_ulogic;
signal p1_congr_cl46_act_q        :std_ulogic;
signal congr_cl46_act             :std_ulogic;
signal congr_cl46_wA_d           :std_ulogic_vector(0 to 5);
signal congr_cl46_wA_q           :std_ulogic_vector(0 to 5);
signal rel_bixu46_wayA_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd46_wayA    :std_ulogic;
signal p1_way_data_upd46_wayA    :std_ulogic;
signal congr_cl46_wB_d           :std_ulogic_vector(0 to 5);
signal congr_cl46_wB_q           :std_ulogic_vector(0 to 5);
signal rel_bixu46_wayB_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd46_wayB    :std_ulogic;
signal p1_way_data_upd46_wayB    :std_ulogic;
signal congr_cl46_wC_d           :std_ulogic_vector(0 to 5);
signal congr_cl46_wC_q           :std_ulogic_vector(0 to 5);
signal rel_bixu46_wayC_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd46_wayC    :std_ulogic;
signal p1_way_data_upd46_wayC    :std_ulogic;
signal congr_cl46_wD_d           :std_ulogic_vector(0 to 5);
signal congr_cl46_wD_q           :std_ulogic_vector(0 to 5);
signal rel_bixu46_wayD_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd46_wayD    :std_ulogic;
signal p1_way_data_upd46_wayD    :std_ulogic;
signal congr_cl46_wE_d           :std_ulogic_vector(0 to 5);
signal congr_cl46_wE_q           :std_ulogic_vector(0 to 5);
signal rel_bixu46_wayE_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd46_wayE    :std_ulogic;
signal p1_way_data_upd46_wayE    :std_ulogic;
signal congr_cl46_wF_d           :std_ulogic_vector(0 to 5);
signal congr_cl46_wF_q           :std_ulogic_vector(0 to 5);
signal rel_bixu46_wayF_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd46_wayF    :std_ulogic;
signal p1_way_data_upd46_wayF    :std_ulogic;
signal congr_cl46_wG_d           :std_ulogic_vector(0 to 5);
signal congr_cl46_wG_q           :std_ulogic_vector(0 to 5);
signal rel_bixu46_wayG_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd46_wayG    :std_ulogic;
signal p1_way_data_upd46_wayG    :std_ulogic;
signal congr_cl46_wH_d           :std_ulogic_vector(0 to 5);
signal congr_cl46_wH_q           :std_ulogic_vector(0 to 5);
signal rel_bixu46_wayH_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd46_wayH    :std_ulogic;
signal p1_way_data_upd46_wayH    :std_ulogic;
signal p0_congr_cl47_m            :std_ulogic;
signal p1_congr_cl47_m            :std_ulogic;
signal p0_congr_cl47_act_d        :std_ulogic;
signal p0_congr_cl47_act_q        :std_ulogic;
signal p1_congr_cl47_act_d        :std_ulogic;
signal p1_congr_cl47_act_q        :std_ulogic;
signal congr_cl47_act             :std_ulogic;
signal congr_cl47_wA_d           :std_ulogic_vector(0 to 5);
signal congr_cl47_wA_q           :std_ulogic_vector(0 to 5);
signal rel_bixu47_wayA_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd47_wayA    :std_ulogic;
signal p1_way_data_upd47_wayA    :std_ulogic;
signal congr_cl47_wB_d           :std_ulogic_vector(0 to 5);
signal congr_cl47_wB_q           :std_ulogic_vector(0 to 5);
signal rel_bixu47_wayB_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd47_wayB    :std_ulogic;
signal p1_way_data_upd47_wayB    :std_ulogic;
signal congr_cl47_wC_d           :std_ulogic_vector(0 to 5);
signal congr_cl47_wC_q           :std_ulogic_vector(0 to 5);
signal rel_bixu47_wayC_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd47_wayC    :std_ulogic;
signal p1_way_data_upd47_wayC    :std_ulogic;
signal congr_cl47_wD_d           :std_ulogic_vector(0 to 5);
signal congr_cl47_wD_q           :std_ulogic_vector(0 to 5);
signal rel_bixu47_wayD_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd47_wayD    :std_ulogic;
signal p1_way_data_upd47_wayD    :std_ulogic;
signal congr_cl47_wE_d           :std_ulogic_vector(0 to 5);
signal congr_cl47_wE_q           :std_ulogic_vector(0 to 5);
signal rel_bixu47_wayE_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd47_wayE    :std_ulogic;
signal p1_way_data_upd47_wayE    :std_ulogic;
signal congr_cl47_wF_d           :std_ulogic_vector(0 to 5);
signal congr_cl47_wF_q           :std_ulogic_vector(0 to 5);
signal rel_bixu47_wayF_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd47_wayF    :std_ulogic;
signal p1_way_data_upd47_wayF    :std_ulogic;
signal congr_cl47_wG_d           :std_ulogic_vector(0 to 5);
signal congr_cl47_wG_q           :std_ulogic_vector(0 to 5);
signal rel_bixu47_wayG_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd47_wayG    :std_ulogic;
signal p1_way_data_upd47_wayG    :std_ulogic;
signal congr_cl47_wH_d           :std_ulogic_vector(0 to 5);
signal congr_cl47_wH_q           :std_ulogic_vector(0 to 5);
signal rel_bixu47_wayH_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd47_wayH    :std_ulogic;
signal p1_way_data_upd47_wayH    :std_ulogic;
signal p0_congr_cl48_m            :std_ulogic;
signal p1_congr_cl48_m            :std_ulogic;
signal p0_congr_cl48_act_d        :std_ulogic;
signal p0_congr_cl48_act_q        :std_ulogic;
signal p1_congr_cl48_act_d        :std_ulogic;
signal p1_congr_cl48_act_q        :std_ulogic;
signal congr_cl48_act             :std_ulogic;
signal congr_cl48_wA_d           :std_ulogic_vector(0 to 5);
signal congr_cl48_wA_q           :std_ulogic_vector(0 to 5);
signal rel_bixu48_wayA_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd48_wayA    :std_ulogic;
signal p1_way_data_upd48_wayA    :std_ulogic;
signal congr_cl48_wB_d           :std_ulogic_vector(0 to 5);
signal congr_cl48_wB_q           :std_ulogic_vector(0 to 5);
signal rel_bixu48_wayB_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd48_wayB    :std_ulogic;
signal p1_way_data_upd48_wayB    :std_ulogic;
signal congr_cl48_wC_d           :std_ulogic_vector(0 to 5);
signal congr_cl48_wC_q           :std_ulogic_vector(0 to 5);
signal rel_bixu48_wayC_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd48_wayC    :std_ulogic;
signal p1_way_data_upd48_wayC    :std_ulogic;
signal congr_cl48_wD_d           :std_ulogic_vector(0 to 5);
signal congr_cl48_wD_q           :std_ulogic_vector(0 to 5);
signal rel_bixu48_wayD_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd48_wayD    :std_ulogic;
signal p1_way_data_upd48_wayD    :std_ulogic;
signal congr_cl48_wE_d           :std_ulogic_vector(0 to 5);
signal congr_cl48_wE_q           :std_ulogic_vector(0 to 5);
signal rel_bixu48_wayE_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd48_wayE    :std_ulogic;
signal p1_way_data_upd48_wayE    :std_ulogic;
signal congr_cl48_wF_d           :std_ulogic_vector(0 to 5);
signal congr_cl48_wF_q           :std_ulogic_vector(0 to 5);
signal rel_bixu48_wayF_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd48_wayF    :std_ulogic;
signal p1_way_data_upd48_wayF    :std_ulogic;
signal congr_cl48_wG_d           :std_ulogic_vector(0 to 5);
signal congr_cl48_wG_q           :std_ulogic_vector(0 to 5);
signal rel_bixu48_wayG_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd48_wayG    :std_ulogic;
signal p1_way_data_upd48_wayG    :std_ulogic;
signal congr_cl48_wH_d           :std_ulogic_vector(0 to 5);
signal congr_cl48_wH_q           :std_ulogic_vector(0 to 5);
signal rel_bixu48_wayH_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd48_wayH    :std_ulogic;
signal p1_way_data_upd48_wayH    :std_ulogic;
signal p0_congr_cl49_m            :std_ulogic;
signal p1_congr_cl49_m            :std_ulogic;
signal p0_congr_cl49_act_d        :std_ulogic;
signal p0_congr_cl49_act_q        :std_ulogic;
signal p1_congr_cl49_act_d        :std_ulogic;
signal p1_congr_cl49_act_q        :std_ulogic;
signal congr_cl49_act             :std_ulogic;
signal congr_cl49_wA_d           :std_ulogic_vector(0 to 5);
signal congr_cl49_wA_q           :std_ulogic_vector(0 to 5);
signal rel_bixu49_wayA_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd49_wayA    :std_ulogic;
signal p1_way_data_upd49_wayA    :std_ulogic;
signal congr_cl49_wB_d           :std_ulogic_vector(0 to 5);
signal congr_cl49_wB_q           :std_ulogic_vector(0 to 5);
signal rel_bixu49_wayB_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd49_wayB    :std_ulogic;
signal p1_way_data_upd49_wayB    :std_ulogic;
signal congr_cl49_wC_d           :std_ulogic_vector(0 to 5);
signal congr_cl49_wC_q           :std_ulogic_vector(0 to 5);
signal rel_bixu49_wayC_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd49_wayC    :std_ulogic;
signal p1_way_data_upd49_wayC    :std_ulogic;
signal congr_cl49_wD_d           :std_ulogic_vector(0 to 5);
signal congr_cl49_wD_q           :std_ulogic_vector(0 to 5);
signal rel_bixu49_wayD_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd49_wayD    :std_ulogic;
signal p1_way_data_upd49_wayD    :std_ulogic;
signal congr_cl49_wE_d           :std_ulogic_vector(0 to 5);
signal congr_cl49_wE_q           :std_ulogic_vector(0 to 5);
signal rel_bixu49_wayE_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd49_wayE    :std_ulogic;
signal p1_way_data_upd49_wayE    :std_ulogic;
signal congr_cl49_wF_d           :std_ulogic_vector(0 to 5);
signal congr_cl49_wF_q           :std_ulogic_vector(0 to 5);
signal rel_bixu49_wayF_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd49_wayF    :std_ulogic;
signal p1_way_data_upd49_wayF    :std_ulogic;
signal congr_cl49_wG_d           :std_ulogic_vector(0 to 5);
signal congr_cl49_wG_q           :std_ulogic_vector(0 to 5);
signal rel_bixu49_wayG_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd49_wayG    :std_ulogic;
signal p1_way_data_upd49_wayG    :std_ulogic;
signal congr_cl49_wH_d           :std_ulogic_vector(0 to 5);
signal congr_cl49_wH_q           :std_ulogic_vector(0 to 5);
signal rel_bixu49_wayH_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd49_wayH    :std_ulogic;
signal p1_way_data_upd49_wayH    :std_ulogic;
signal p0_congr_cl50_m            :std_ulogic;
signal p1_congr_cl50_m            :std_ulogic;
signal p0_congr_cl50_act_d        :std_ulogic;
signal p0_congr_cl50_act_q        :std_ulogic;
signal p1_congr_cl50_act_d        :std_ulogic;
signal p1_congr_cl50_act_q        :std_ulogic;
signal congr_cl50_act             :std_ulogic;
signal congr_cl50_wA_d           :std_ulogic_vector(0 to 5);
signal congr_cl50_wA_q           :std_ulogic_vector(0 to 5);
signal rel_bixu50_wayA_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd50_wayA    :std_ulogic;
signal p1_way_data_upd50_wayA    :std_ulogic;
signal congr_cl50_wB_d           :std_ulogic_vector(0 to 5);
signal congr_cl50_wB_q           :std_ulogic_vector(0 to 5);
signal rel_bixu50_wayB_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd50_wayB    :std_ulogic;
signal p1_way_data_upd50_wayB    :std_ulogic;
signal congr_cl50_wC_d           :std_ulogic_vector(0 to 5);
signal congr_cl50_wC_q           :std_ulogic_vector(0 to 5);
signal rel_bixu50_wayC_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd50_wayC    :std_ulogic;
signal p1_way_data_upd50_wayC    :std_ulogic;
signal congr_cl50_wD_d           :std_ulogic_vector(0 to 5);
signal congr_cl50_wD_q           :std_ulogic_vector(0 to 5);
signal rel_bixu50_wayD_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd50_wayD    :std_ulogic;
signal p1_way_data_upd50_wayD    :std_ulogic;
signal congr_cl50_wE_d           :std_ulogic_vector(0 to 5);
signal congr_cl50_wE_q           :std_ulogic_vector(0 to 5);
signal rel_bixu50_wayE_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd50_wayE    :std_ulogic;
signal p1_way_data_upd50_wayE    :std_ulogic;
signal congr_cl50_wF_d           :std_ulogic_vector(0 to 5);
signal congr_cl50_wF_q           :std_ulogic_vector(0 to 5);
signal rel_bixu50_wayF_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd50_wayF    :std_ulogic;
signal p1_way_data_upd50_wayF    :std_ulogic;
signal congr_cl50_wG_d           :std_ulogic_vector(0 to 5);
signal congr_cl50_wG_q           :std_ulogic_vector(0 to 5);
signal rel_bixu50_wayG_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd50_wayG    :std_ulogic;
signal p1_way_data_upd50_wayG    :std_ulogic;
signal congr_cl50_wH_d           :std_ulogic_vector(0 to 5);
signal congr_cl50_wH_q           :std_ulogic_vector(0 to 5);
signal rel_bixu50_wayH_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd50_wayH    :std_ulogic;
signal p1_way_data_upd50_wayH    :std_ulogic;
signal p0_congr_cl51_m            :std_ulogic;
signal p1_congr_cl51_m            :std_ulogic;
signal p0_congr_cl51_act_d        :std_ulogic;
signal p0_congr_cl51_act_q        :std_ulogic;
signal p1_congr_cl51_act_d        :std_ulogic;
signal p1_congr_cl51_act_q        :std_ulogic;
signal congr_cl51_act             :std_ulogic;
signal congr_cl51_wA_d           :std_ulogic_vector(0 to 5);
signal congr_cl51_wA_q           :std_ulogic_vector(0 to 5);
signal rel_bixu51_wayA_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd51_wayA    :std_ulogic;
signal p1_way_data_upd51_wayA    :std_ulogic;
signal congr_cl51_wB_d           :std_ulogic_vector(0 to 5);
signal congr_cl51_wB_q           :std_ulogic_vector(0 to 5);
signal rel_bixu51_wayB_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd51_wayB    :std_ulogic;
signal p1_way_data_upd51_wayB    :std_ulogic;
signal congr_cl51_wC_d           :std_ulogic_vector(0 to 5);
signal congr_cl51_wC_q           :std_ulogic_vector(0 to 5);
signal rel_bixu51_wayC_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd51_wayC    :std_ulogic;
signal p1_way_data_upd51_wayC    :std_ulogic;
signal congr_cl51_wD_d           :std_ulogic_vector(0 to 5);
signal congr_cl51_wD_q           :std_ulogic_vector(0 to 5);
signal rel_bixu51_wayD_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd51_wayD    :std_ulogic;
signal p1_way_data_upd51_wayD    :std_ulogic;
signal congr_cl51_wE_d           :std_ulogic_vector(0 to 5);
signal congr_cl51_wE_q           :std_ulogic_vector(0 to 5);
signal rel_bixu51_wayE_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd51_wayE    :std_ulogic;
signal p1_way_data_upd51_wayE    :std_ulogic;
signal congr_cl51_wF_d           :std_ulogic_vector(0 to 5);
signal congr_cl51_wF_q           :std_ulogic_vector(0 to 5);
signal rel_bixu51_wayF_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd51_wayF    :std_ulogic;
signal p1_way_data_upd51_wayF    :std_ulogic;
signal congr_cl51_wG_d           :std_ulogic_vector(0 to 5);
signal congr_cl51_wG_q           :std_ulogic_vector(0 to 5);
signal rel_bixu51_wayG_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd51_wayG    :std_ulogic;
signal p1_way_data_upd51_wayG    :std_ulogic;
signal congr_cl51_wH_d           :std_ulogic_vector(0 to 5);
signal congr_cl51_wH_q           :std_ulogic_vector(0 to 5);
signal rel_bixu51_wayH_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd51_wayH    :std_ulogic;
signal p1_way_data_upd51_wayH    :std_ulogic;
signal p0_congr_cl52_m            :std_ulogic;
signal p1_congr_cl52_m            :std_ulogic;
signal p0_congr_cl52_act_d        :std_ulogic;
signal p0_congr_cl52_act_q        :std_ulogic;
signal p1_congr_cl52_act_d        :std_ulogic;
signal p1_congr_cl52_act_q        :std_ulogic;
signal congr_cl52_act             :std_ulogic;
signal congr_cl52_wA_d           :std_ulogic_vector(0 to 5);
signal congr_cl52_wA_q           :std_ulogic_vector(0 to 5);
signal rel_bixu52_wayA_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd52_wayA    :std_ulogic;
signal p1_way_data_upd52_wayA    :std_ulogic;
signal congr_cl52_wB_d           :std_ulogic_vector(0 to 5);
signal congr_cl52_wB_q           :std_ulogic_vector(0 to 5);
signal rel_bixu52_wayB_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd52_wayB    :std_ulogic;
signal p1_way_data_upd52_wayB    :std_ulogic;
signal congr_cl52_wC_d           :std_ulogic_vector(0 to 5);
signal congr_cl52_wC_q           :std_ulogic_vector(0 to 5);
signal rel_bixu52_wayC_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd52_wayC    :std_ulogic;
signal p1_way_data_upd52_wayC    :std_ulogic;
signal congr_cl52_wD_d           :std_ulogic_vector(0 to 5);
signal congr_cl52_wD_q           :std_ulogic_vector(0 to 5);
signal rel_bixu52_wayD_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd52_wayD    :std_ulogic;
signal p1_way_data_upd52_wayD    :std_ulogic;
signal congr_cl52_wE_d           :std_ulogic_vector(0 to 5);
signal congr_cl52_wE_q           :std_ulogic_vector(0 to 5);
signal rel_bixu52_wayE_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd52_wayE    :std_ulogic;
signal p1_way_data_upd52_wayE    :std_ulogic;
signal congr_cl52_wF_d           :std_ulogic_vector(0 to 5);
signal congr_cl52_wF_q           :std_ulogic_vector(0 to 5);
signal rel_bixu52_wayF_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd52_wayF    :std_ulogic;
signal p1_way_data_upd52_wayF    :std_ulogic;
signal congr_cl52_wG_d           :std_ulogic_vector(0 to 5);
signal congr_cl52_wG_q           :std_ulogic_vector(0 to 5);
signal rel_bixu52_wayG_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd52_wayG    :std_ulogic;
signal p1_way_data_upd52_wayG    :std_ulogic;
signal congr_cl52_wH_d           :std_ulogic_vector(0 to 5);
signal congr_cl52_wH_q           :std_ulogic_vector(0 to 5);
signal rel_bixu52_wayH_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd52_wayH    :std_ulogic;
signal p1_way_data_upd52_wayH    :std_ulogic;
signal p0_congr_cl53_m            :std_ulogic;
signal p1_congr_cl53_m            :std_ulogic;
signal p0_congr_cl53_act_d        :std_ulogic;
signal p0_congr_cl53_act_q        :std_ulogic;
signal p1_congr_cl53_act_d        :std_ulogic;
signal p1_congr_cl53_act_q        :std_ulogic;
signal congr_cl53_act             :std_ulogic;
signal congr_cl53_wA_d           :std_ulogic_vector(0 to 5);
signal congr_cl53_wA_q           :std_ulogic_vector(0 to 5);
signal rel_bixu53_wayA_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd53_wayA    :std_ulogic;
signal p1_way_data_upd53_wayA    :std_ulogic;
signal congr_cl53_wB_d           :std_ulogic_vector(0 to 5);
signal congr_cl53_wB_q           :std_ulogic_vector(0 to 5);
signal rel_bixu53_wayB_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd53_wayB    :std_ulogic;
signal p1_way_data_upd53_wayB    :std_ulogic;
signal congr_cl53_wC_d           :std_ulogic_vector(0 to 5);
signal congr_cl53_wC_q           :std_ulogic_vector(0 to 5);
signal rel_bixu53_wayC_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd53_wayC    :std_ulogic;
signal p1_way_data_upd53_wayC    :std_ulogic;
signal congr_cl53_wD_d           :std_ulogic_vector(0 to 5);
signal congr_cl53_wD_q           :std_ulogic_vector(0 to 5);
signal rel_bixu53_wayD_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd53_wayD    :std_ulogic;
signal p1_way_data_upd53_wayD    :std_ulogic;
signal congr_cl53_wE_d           :std_ulogic_vector(0 to 5);
signal congr_cl53_wE_q           :std_ulogic_vector(0 to 5);
signal rel_bixu53_wayE_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd53_wayE    :std_ulogic;
signal p1_way_data_upd53_wayE    :std_ulogic;
signal congr_cl53_wF_d           :std_ulogic_vector(0 to 5);
signal congr_cl53_wF_q           :std_ulogic_vector(0 to 5);
signal rel_bixu53_wayF_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd53_wayF    :std_ulogic;
signal p1_way_data_upd53_wayF    :std_ulogic;
signal congr_cl53_wG_d           :std_ulogic_vector(0 to 5);
signal congr_cl53_wG_q           :std_ulogic_vector(0 to 5);
signal rel_bixu53_wayG_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd53_wayG    :std_ulogic;
signal p1_way_data_upd53_wayG    :std_ulogic;
signal congr_cl53_wH_d           :std_ulogic_vector(0 to 5);
signal congr_cl53_wH_q           :std_ulogic_vector(0 to 5);
signal rel_bixu53_wayH_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd53_wayH    :std_ulogic;
signal p1_way_data_upd53_wayH    :std_ulogic;
signal p0_congr_cl54_m            :std_ulogic;
signal p1_congr_cl54_m            :std_ulogic;
signal p0_congr_cl54_act_d        :std_ulogic;
signal p0_congr_cl54_act_q        :std_ulogic;
signal p1_congr_cl54_act_d        :std_ulogic;
signal p1_congr_cl54_act_q        :std_ulogic;
signal congr_cl54_act             :std_ulogic;
signal congr_cl54_wA_d           :std_ulogic_vector(0 to 5);
signal congr_cl54_wA_q           :std_ulogic_vector(0 to 5);
signal rel_bixu54_wayA_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd54_wayA    :std_ulogic;
signal p1_way_data_upd54_wayA    :std_ulogic;
signal congr_cl54_wB_d           :std_ulogic_vector(0 to 5);
signal congr_cl54_wB_q           :std_ulogic_vector(0 to 5);
signal rel_bixu54_wayB_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd54_wayB    :std_ulogic;
signal p1_way_data_upd54_wayB    :std_ulogic;
signal congr_cl54_wC_d           :std_ulogic_vector(0 to 5);
signal congr_cl54_wC_q           :std_ulogic_vector(0 to 5);
signal rel_bixu54_wayC_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd54_wayC    :std_ulogic;
signal p1_way_data_upd54_wayC    :std_ulogic;
signal congr_cl54_wD_d           :std_ulogic_vector(0 to 5);
signal congr_cl54_wD_q           :std_ulogic_vector(0 to 5);
signal rel_bixu54_wayD_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd54_wayD    :std_ulogic;
signal p1_way_data_upd54_wayD    :std_ulogic;
signal congr_cl54_wE_d           :std_ulogic_vector(0 to 5);
signal congr_cl54_wE_q           :std_ulogic_vector(0 to 5);
signal rel_bixu54_wayE_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd54_wayE    :std_ulogic;
signal p1_way_data_upd54_wayE    :std_ulogic;
signal congr_cl54_wF_d           :std_ulogic_vector(0 to 5);
signal congr_cl54_wF_q           :std_ulogic_vector(0 to 5);
signal rel_bixu54_wayF_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd54_wayF    :std_ulogic;
signal p1_way_data_upd54_wayF    :std_ulogic;
signal congr_cl54_wG_d           :std_ulogic_vector(0 to 5);
signal congr_cl54_wG_q           :std_ulogic_vector(0 to 5);
signal rel_bixu54_wayG_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd54_wayG    :std_ulogic;
signal p1_way_data_upd54_wayG    :std_ulogic;
signal congr_cl54_wH_d           :std_ulogic_vector(0 to 5);
signal congr_cl54_wH_q           :std_ulogic_vector(0 to 5);
signal rel_bixu54_wayH_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd54_wayH    :std_ulogic;
signal p1_way_data_upd54_wayH    :std_ulogic;
signal p0_congr_cl55_m            :std_ulogic;
signal p1_congr_cl55_m            :std_ulogic;
signal p0_congr_cl55_act_d        :std_ulogic;
signal p0_congr_cl55_act_q        :std_ulogic;
signal p1_congr_cl55_act_d        :std_ulogic;
signal p1_congr_cl55_act_q        :std_ulogic;
signal congr_cl55_act             :std_ulogic;
signal congr_cl55_wA_d           :std_ulogic_vector(0 to 5);
signal congr_cl55_wA_q           :std_ulogic_vector(0 to 5);
signal rel_bixu55_wayA_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd55_wayA    :std_ulogic;
signal p1_way_data_upd55_wayA    :std_ulogic;
signal congr_cl55_wB_d           :std_ulogic_vector(0 to 5);
signal congr_cl55_wB_q           :std_ulogic_vector(0 to 5);
signal rel_bixu55_wayB_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd55_wayB    :std_ulogic;
signal p1_way_data_upd55_wayB    :std_ulogic;
signal congr_cl55_wC_d           :std_ulogic_vector(0 to 5);
signal congr_cl55_wC_q           :std_ulogic_vector(0 to 5);
signal rel_bixu55_wayC_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd55_wayC    :std_ulogic;
signal p1_way_data_upd55_wayC    :std_ulogic;
signal congr_cl55_wD_d           :std_ulogic_vector(0 to 5);
signal congr_cl55_wD_q           :std_ulogic_vector(0 to 5);
signal rel_bixu55_wayD_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd55_wayD    :std_ulogic;
signal p1_way_data_upd55_wayD    :std_ulogic;
signal congr_cl55_wE_d           :std_ulogic_vector(0 to 5);
signal congr_cl55_wE_q           :std_ulogic_vector(0 to 5);
signal rel_bixu55_wayE_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd55_wayE    :std_ulogic;
signal p1_way_data_upd55_wayE    :std_ulogic;
signal congr_cl55_wF_d           :std_ulogic_vector(0 to 5);
signal congr_cl55_wF_q           :std_ulogic_vector(0 to 5);
signal rel_bixu55_wayF_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd55_wayF    :std_ulogic;
signal p1_way_data_upd55_wayF    :std_ulogic;
signal congr_cl55_wG_d           :std_ulogic_vector(0 to 5);
signal congr_cl55_wG_q           :std_ulogic_vector(0 to 5);
signal rel_bixu55_wayG_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd55_wayG    :std_ulogic;
signal p1_way_data_upd55_wayG    :std_ulogic;
signal congr_cl55_wH_d           :std_ulogic_vector(0 to 5);
signal congr_cl55_wH_q           :std_ulogic_vector(0 to 5);
signal rel_bixu55_wayH_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd55_wayH    :std_ulogic;
signal p1_way_data_upd55_wayH    :std_ulogic;
signal p0_congr_cl56_m            :std_ulogic;
signal p1_congr_cl56_m            :std_ulogic;
signal p0_congr_cl56_act_d        :std_ulogic;
signal p0_congr_cl56_act_q        :std_ulogic;
signal p1_congr_cl56_act_d        :std_ulogic;
signal p1_congr_cl56_act_q        :std_ulogic;
signal congr_cl56_act             :std_ulogic;
signal congr_cl56_wA_d           :std_ulogic_vector(0 to 5);
signal congr_cl56_wA_q           :std_ulogic_vector(0 to 5);
signal rel_bixu56_wayA_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd56_wayA    :std_ulogic;
signal p1_way_data_upd56_wayA    :std_ulogic;
signal congr_cl56_wB_d           :std_ulogic_vector(0 to 5);
signal congr_cl56_wB_q           :std_ulogic_vector(0 to 5);
signal rel_bixu56_wayB_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd56_wayB    :std_ulogic;
signal p1_way_data_upd56_wayB    :std_ulogic;
signal congr_cl56_wC_d           :std_ulogic_vector(0 to 5);
signal congr_cl56_wC_q           :std_ulogic_vector(0 to 5);
signal rel_bixu56_wayC_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd56_wayC    :std_ulogic;
signal p1_way_data_upd56_wayC    :std_ulogic;
signal congr_cl56_wD_d           :std_ulogic_vector(0 to 5);
signal congr_cl56_wD_q           :std_ulogic_vector(0 to 5);
signal rel_bixu56_wayD_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd56_wayD    :std_ulogic;
signal p1_way_data_upd56_wayD    :std_ulogic;
signal congr_cl56_wE_d           :std_ulogic_vector(0 to 5);
signal congr_cl56_wE_q           :std_ulogic_vector(0 to 5);
signal rel_bixu56_wayE_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd56_wayE    :std_ulogic;
signal p1_way_data_upd56_wayE    :std_ulogic;
signal congr_cl56_wF_d           :std_ulogic_vector(0 to 5);
signal congr_cl56_wF_q           :std_ulogic_vector(0 to 5);
signal rel_bixu56_wayF_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd56_wayF    :std_ulogic;
signal p1_way_data_upd56_wayF    :std_ulogic;
signal congr_cl56_wG_d           :std_ulogic_vector(0 to 5);
signal congr_cl56_wG_q           :std_ulogic_vector(0 to 5);
signal rel_bixu56_wayG_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd56_wayG    :std_ulogic;
signal p1_way_data_upd56_wayG    :std_ulogic;
signal congr_cl56_wH_d           :std_ulogic_vector(0 to 5);
signal congr_cl56_wH_q           :std_ulogic_vector(0 to 5);
signal rel_bixu56_wayH_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd56_wayH    :std_ulogic;
signal p1_way_data_upd56_wayH    :std_ulogic;
signal p0_congr_cl57_m            :std_ulogic;
signal p1_congr_cl57_m            :std_ulogic;
signal p0_congr_cl57_act_d        :std_ulogic;
signal p0_congr_cl57_act_q        :std_ulogic;
signal p1_congr_cl57_act_d        :std_ulogic;
signal p1_congr_cl57_act_q        :std_ulogic;
signal congr_cl57_act             :std_ulogic;
signal congr_cl57_wA_d           :std_ulogic_vector(0 to 5);
signal congr_cl57_wA_q           :std_ulogic_vector(0 to 5);
signal rel_bixu57_wayA_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd57_wayA    :std_ulogic;
signal p1_way_data_upd57_wayA    :std_ulogic;
signal congr_cl57_wB_d           :std_ulogic_vector(0 to 5);
signal congr_cl57_wB_q           :std_ulogic_vector(0 to 5);
signal rel_bixu57_wayB_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd57_wayB    :std_ulogic;
signal p1_way_data_upd57_wayB    :std_ulogic;
signal congr_cl57_wC_d           :std_ulogic_vector(0 to 5);
signal congr_cl57_wC_q           :std_ulogic_vector(0 to 5);
signal rel_bixu57_wayC_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd57_wayC    :std_ulogic;
signal p1_way_data_upd57_wayC    :std_ulogic;
signal congr_cl57_wD_d           :std_ulogic_vector(0 to 5);
signal congr_cl57_wD_q           :std_ulogic_vector(0 to 5);
signal rel_bixu57_wayD_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd57_wayD    :std_ulogic;
signal p1_way_data_upd57_wayD    :std_ulogic;
signal congr_cl57_wE_d           :std_ulogic_vector(0 to 5);
signal congr_cl57_wE_q           :std_ulogic_vector(0 to 5);
signal rel_bixu57_wayE_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd57_wayE    :std_ulogic;
signal p1_way_data_upd57_wayE    :std_ulogic;
signal congr_cl57_wF_d           :std_ulogic_vector(0 to 5);
signal congr_cl57_wF_q           :std_ulogic_vector(0 to 5);
signal rel_bixu57_wayF_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd57_wayF    :std_ulogic;
signal p1_way_data_upd57_wayF    :std_ulogic;
signal congr_cl57_wG_d           :std_ulogic_vector(0 to 5);
signal congr_cl57_wG_q           :std_ulogic_vector(0 to 5);
signal rel_bixu57_wayG_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd57_wayG    :std_ulogic;
signal p1_way_data_upd57_wayG    :std_ulogic;
signal congr_cl57_wH_d           :std_ulogic_vector(0 to 5);
signal congr_cl57_wH_q           :std_ulogic_vector(0 to 5);
signal rel_bixu57_wayH_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd57_wayH    :std_ulogic;
signal p1_way_data_upd57_wayH    :std_ulogic;
signal p0_congr_cl58_m            :std_ulogic;
signal p1_congr_cl58_m            :std_ulogic;
signal p0_congr_cl58_act_d        :std_ulogic;
signal p0_congr_cl58_act_q        :std_ulogic;
signal p1_congr_cl58_act_d        :std_ulogic;
signal p1_congr_cl58_act_q        :std_ulogic;
signal congr_cl58_act             :std_ulogic;
signal congr_cl58_wA_d           :std_ulogic_vector(0 to 5);
signal congr_cl58_wA_q           :std_ulogic_vector(0 to 5);
signal rel_bixu58_wayA_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd58_wayA    :std_ulogic;
signal p1_way_data_upd58_wayA    :std_ulogic;
signal congr_cl58_wB_d           :std_ulogic_vector(0 to 5);
signal congr_cl58_wB_q           :std_ulogic_vector(0 to 5);
signal rel_bixu58_wayB_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd58_wayB    :std_ulogic;
signal p1_way_data_upd58_wayB    :std_ulogic;
signal congr_cl58_wC_d           :std_ulogic_vector(0 to 5);
signal congr_cl58_wC_q           :std_ulogic_vector(0 to 5);
signal rel_bixu58_wayC_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd58_wayC    :std_ulogic;
signal p1_way_data_upd58_wayC    :std_ulogic;
signal congr_cl58_wD_d           :std_ulogic_vector(0 to 5);
signal congr_cl58_wD_q           :std_ulogic_vector(0 to 5);
signal rel_bixu58_wayD_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd58_wayD    :std_ulogic;
signal p1_way_data_upd58_wayD    :std_ulogic;
signal congr_cl58_wE_d           :std_ulogic_vector(0 to 5);
signal congr_cl58_wE_q           :std_ulogic_vector(0 to 5);
signal rel_bixu58_wayE_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd58_wayE    :std_ulogic;
signal p1_way_data_upd58_wayE    :std_ulogic;
signal congr_cl58_wF_d           :std_ulogic_vector(0 to 5);
signal congr_cl58_wF_q           :std_ulogic_vector(0 to 5);
signal rel_bixu58_wayF_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd58_wayF    :std_ulogic;
signal p1_way_data_upd58_wayF    :std_ulogic;
signal congr_cl58_wG_d           :std_ulogic_vector(0 to 5);
signal congr_cl58_wG_q           :std_ulogic_vector(0 to 5);
signal rel_bixu58_wayG_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd58_wayG    :std_ulogic;
signal p1_way_data_upd58_wayG    :std_ulogic;
signal congr_cl58_wH_d           :std_ulogic_vector(0 to 5);
signal congr_cl58_wH_q           :std_ulogic_vector(0 to 5);
signal rel_bixu58_wayH_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd58_wayH    :std_ulogic;
signal p1_way_data_upd58_wayH    :std_ulogic;
signal p0_congr_cl59_m            :std_ulogic;
signal p1_congr_cl59_m            :std_ulogic;
signal p0_congr_cl59_act_d        :std_ulogic;
signal p0_congr_cl59_act_q        :std_ulogic;
signal p1_congr_cl59_act_d        :std_ulogic;
signal p1_congr_cl59_act_q        :std_ulogic;
signal congr_cl59_act             :std_ulogic;
signal congr_cl59_wA_d           :std_ulogic_vector(0 to 5);
signal congr_cl59_wA_q           :std_ulogic_vector(0 to 5);
signal rel_bixu59_wayA_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd59_wayA    :std_ulogic;
signal p1_way_data_upd59_wayA    :std_ulogic;
signal congr_cl59_wB_d           :std_ulogic_vector(0 to 5);
signal congr_cl59_wB_q           :std_ulogic_vector(0 to 5);
signal rel_bixu59_wayB_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd59_wayB    :std_ulogic;
signal p1_way_data_upd59_wayB    :std_ulogic;
signal congr_cl59_wC_d           :std_ulogic_vector(0 to 5);
signal congr_cl59_wC_q           :std_ulogic_vector(0 to 5);
signal rel_bixu59_wayC_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd59_wayC    :std_ulogic;
signal p1_way_data_upd59_wayC    :std_ulogic;
signal congr_cl59_wD_d           :std_ulogic_vector(0 to 5);
signal congr_cl59_wD_q           :std_ulogic_vector(0 to 5);
signal rel_bixu59_wayD_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd59_wayD    :std_ulogic;
signal p1_way_data_upd59_wayD    :std_ulogic;
signal congr_cl59_wE_d           :std_ulogic_vector(0 to 5);
signal congr_cl59_wE_q           :std_ulogic_vector(0 to 5);
signal rel_bixu59_wayE_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd59_wayE    :std_ulogic;
signal p1_way_data_upd59_wayE    :std_ulogic;
signal congr_cl59_wF_d           :std_ulogic_vector(0 to 5);
signal congr_cl59_wF_q           :std_ulogic_vector(0 to 5);
signal rel_bixu59_wayF_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd59_wayF    :std_ulogic;
signal p1_way_data_upd59_wayF    :std_ulogic;
signal congr_cl59_wG_d           :std_ulogic_vector(0 to 5);
signal congr_cl59_wG_q           :std_ulogic_vector(0 to 5);
signal rel_bixu59_wayG_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd59_wayG    :std_ulogic;
signal p1_way_data_upd59_wayG    :std_ulogic;
signal congr_cl59_wH_d           :std_ulogic_vector(0 to 5);
signal congr_cl59_wH_q           :std_ulogic_vector(0 to 5);
signal rel_bixu59_wayH_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd59_wayH    :std_ulogic;
signal p1_way_data_upd59_wayH    :std_ulogic;
signal p0_congr_cl60_m            :std_ulogic;
signal p1_congr_cl60_m            :std_ulogic;
signal p0_congr_cl60_act_d        :std_ulogic;
signal p0_congr_cl60_act_q        :std_ulogic;
signal p1_congr_cl60_act_d        :std_ulogic;
signal p1_congr_cl60_act_q        :std_ulogic;
signal congr_cl60_act             :std_ulogic;
signal congr_cl60_wA_d           :std_ulogic_vector(0 to 5);
signal congr_cl60_wA_q           :std_ulogic_vector(0 to 5);
signal rel_bixu60_wayA_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd60_wayA    :std_ulogic;
signal p1_way_data_upd60_wayA    :std_ulogic;
signal congr_cl60_wB_d           :std_ulogic_vector(0 to 5);
signal congr_cl60_wB_q           :std_ulogic_vector(0 to 5);
signal rel_bixu60_wayB_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd60_wayB    :std_ulogic;
signal p1_way_data_upd60_wayB    :std_ulogic;
signal congr_cl60_wC_d           :std_ulogic_vector(0 to 5);
signal congr_cl60_wC_q           :std_ulogic_vector(0 to 5);
signal rel_bixu60_wayC_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd60_wayC    :std_ulogic;
signal p1_way_data_upd60_wayC    :std_ulogic;
signal congr_cl60_wD_d           :std_ulogic_vector(0 to 5);
signal congr_cl60_wD_q           :std_ulogic_vector(0 to 5);
signal rel_bixu60_wayD_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd60_wayD    :std_ulogic;
signal p1_way_data_upd60_wayD    :std_ulogic;
signal congr_cl60_wE_d           :std_ulogic_vector(0 to 5);
signal congr_cl60_wE_q           :std_ulogic_vector(0 to 5);
signal rel_bixu60_wayE_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd60_wayE    :std_ulogic;
signal p1_way_data_upd60_wayE    :std_ulogic;
signal congr_cl60_wF_d           :std_ulogic_vector(0 to 5);
signal congr_cl60_wF_q           :std_ulogic_vector(0 to 5);
signal rel_bixu60_wayF_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd60_wayF    :std_ulogic;
signal p1_way_data_upd60_wayF    :std_ulogic;
signal congr_cl60_wG_d           :std_ulogic_vector(0 to 5);
signal congr_cl60_wG_q           :std_ulogic_vector(0 to 5);
signal rel_bixu60_wayG_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd60_wayG    :std_ulogic;
signal p1_way_data_upd60_wayG    :std_ulogic;
signal congr_cl60_wH_d           :std_ulogic_vector(0 to 5);
signal congr_cl60_wH_q           :std_ulogic_vector(0 to 5);
signal rel_bixu60_wayH_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd60_wayH    :std_ulogic;
signal p1_way_data_upd60_wayH    :std_ulogic;
signal p0_congr_cl61_m            :std_ulogic;
signal p1_congr_cl61_m            :std_ulogic;
signal p0_congr_cl61_act_d        :std_ulogic;
signal p0_congr_cl61_act_q        :std_ulogic;
signal p1_congr_cl61_act_d        :std_ulogic;
signal p1_congr_cl61_act_q        :std_ulogic;
signal congr_cl61_act             :std_ulogic;
signal congr_cl61_wA_d           :std_ulogic_vector(0 to 5);
signal congr_cl61_wA_q           :std_ulogic_vector(0 to 5);
signal rel_bixu61_wayA_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd61_wayA    :std_ulogic;
signal p1_way_data_upd61_wayA    :std_ulogic;
signal congr_cl61_wB_d           :std_ulogic_vector(0 to 5);
signal congr_cl61_wB_q           :std_ulogic_vector(0 to 5);
signal rel_bixu61_wayB_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd61_wayB    :std_ulogic;
signal p1_way_data_upd61_wayB    :std_ulogic;
signal congr_cl61_wC_d           :std_ulogic_vector(0 to 5);
signal congr_cl61_wC_q           :std_ulogic_vector(0 to 5);
signal rel_bixu61_wayC_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd61_wayC    :std_ulogic;
signal p1_way_data_upd61_wayC    :std_ulogic;
signal congr_cl61_wD_d           :std_ulogic_vector(0 to 5);
signal congr_cl61_wD_q           :std_ulogic_vector(0 to 5);
signal rel_bixu61_wayD_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd61_wayD    :std_ulogic;
signal p1_way_data_upd61_wayD    :std_ulogic;
signal congr_cl61_wE_d           :std_ulogic_vector(0 to 5);
signal congr_cl61_wE_q           :std_ulogic_vector(0 to 5);
signal rel_bixu61_wayE_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd61_wayE    :std_ulogic;
signal p1_way_data_upd61_wayE    :std_ulogic;
signal congr_cl61_wF_d           :std_ulogic_vector(0 to 5);
signal congr_cl61_wF_q           :std_ulogic_vector(0 to 5);
signal rel_bixu61_wayF_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd61_wayF    :std_ulogic;
signal p1_way_data_upd61_wayF    :std_ulogic;
signal congr_cl61_wG_d           :std_ulogic_vector(0 to 5);
signal congr_cl61_wG_q           :std_ulogic_vector(0 to 5);
signal rel_bixu61_wayG_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd61_wayG    :std_ulogic;
signal p1_way_data_upd61_wayG    :std_ulogic;
signal congr_cl61_wH_d           :std_ulogic_vector(0 to 5);
signal congr_cl61_wH_q           :std_ulogic_vector(0 to 5);
signal rel_bixu61_wayH_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd61_wayH    :std_ulogic;
signal p1_way_data_upd61_wayH    :std_ulogic;
signal p0_congr_cl62_m            :std_ulogic;
signal p1_congr_cl62_m            :std_ulogic;
signal p0_congr_cl62_act_d        :std_ulogic;
signal p0_congr_cl62_act_q        :std_ulogic;
signal p1_congr_cl62_act_d        :std_ulogic;
signal p1_congr_cl62_act_q        :std_ulogic;
signal congr_cl62_act             :std_ulogic;
signal congr_cl62_wA_d           :std_ulogic_vector(0 to 5);
signal congr_cl62_wA_q           :std_ulogic_vector(0 to 5);
signal rel_bixu62_wayA_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd62_wayA    :std_ulogic;
signal p1_way_data_upd62_wayA    :std_ulogic;
signal congr_cl62_wB_d           :std_ulogic_vector(0 to 5);
signal congr_cl62_wB_q           :std_ulogic_vector(0 to 5);
signal rel_bixu62_wayB_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd62_wayB    :std_ulogic;
signal p1_way_data_upd62_wayB    :std_ulogic;
signal congr_cl62_wC_d           :std_ulogic_vector(0 to 5);
signal congr_cl62_wC_q           :std_ulogic_vector(0 to 5);
signal rel_bixu62_wayC_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd62_wayC    :std_ulogic;
signal p1_way_data_upd62_wayC    :std_ulogic;
signal congr_cl62_wD_d           :std_ulogic_vector(0 to 5);
signal congr_cl62_wD_q           :std_ulogic_vector(0 to 5);
signal rel_bixu62_wayD_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd62_wayD    :std_ulogic;
signal p1_way_data_upd62_wayD    :std_ulogic;
signal congr_cl62_wE_d           :std_ulogic_vector(0 to 5);
signal congr_cl62_wE_q           :std_ulogic_vector(0 to 5);
signal rel_bixu62_wayE_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd62_wayE    :std_ulogic;
signal p1_way_data_upd62_wayE    :std_ulogic;
signal congr_cl62_wF_d           :std_ulogic_vector(0 to 5);
signal congr_cl62_wF_q           :std_ulogic_vector(0 to 5);
signal rel_bixu62_wayF_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd62_wayF    :std_ulogic;
signal p1_way_data_upd62_wayF    :std_ulogic;
signal congr_cl62_wG_d           :std_ulogic_vector(0 to 5);
signal congr_cl62_wG_q           :std_ulogic_vector(0 to 5);
signal rel_bixu62_wayG_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd62_wayG    :std_ulogic;
signal p1_way_data_upd62_wayG    :std_ulogic;
signal congr_cl62_wH_d           :std_ulogic_vector(0 to 5);
signal congr_cl62_wH_q           :std_ulogic_vector(0 to 5);
signal rel_bixu62_wayH_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd62_wayH    :std_ulogic;
signal p1_way_data_upd62_wayH    :std_ulogic;
signal p0_congr_cl63_m            :std_ulogic;
signal p1_congr_cl63_m            :std_ulogic;
signal p0_congr_cl63_act_d        :std_ulogic;
signal p0_congr_cl63_act_q        :std_ulogic;
signal p1_congr_cl63_act_d        :std_ulogic;
signal p1_congr_cl63_act_q        :std_ulogic;
signal congr_cl63_act             :std_ulogic;
signal congr_cl63_wA_d           :std_ulogic_vector(0 to 5);
signal congr_cl63_wA_q           :std_ulogic_vector(0 to 5);
signal rel_bixu63_wayA_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd63_wayA    :std_ulogic;
signal p1_way_data_upd63_wayA    :std_ulogic;
signal congr_cl63_wB_d           :std_ulogic_vector(0 to 5);
signal congr_cl63_wB_q           :std_ulogic_vector(0 to 5);
signal rel_bixu63_wayB_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd63_wayB    :std_ulogic;
signal p1_way_data_upd63_wayB    :std_ulogic;
signal congr_cl63_wC_d           :std_ulogic_vector(0 to 5);
signal congr_cl63_wC_q           :std_ulogic_vector(0 to 5);
signal rel_bixu63_wayC_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd63_wayC    :std_ulogic;
signal p1_way_data_upd63_wayC    :std_ulogic;
signal congr_cl63_wD_d           :std_ulogic_vector(0 to 5);
signal congr_cl63_wD_q           :std_ulogic_vector(0 to 5);
signal rel_bixu63_wayD_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd63_wayD    :std_ulogic;
signal p1_way_data_upd63_wayD    :std_ulogic;
signal congr_cl63_wE_d           :std_ulogic_vector(0 to 5);
signal congr_cl63_wE_q           :std_ulogic_vector(0 to 5);
signal rel_bixu63_wayE_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd63_wayE    :std_ulogic;
signal p1_way_data_upd63_wayE    :std_ulogic;
signal congr_cl63_wF_d           :std_ulogic_vector(0 to 5);
signal congr_cl63_wF_q           :std_ulogic_vector(0 to 5);
signal rel_bixu63_wayF_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd63_wayF    :std_ulogic;
signal p1_way_data_upd63_wayF    :std_ulogic;
signal congr_cl63_wG_d           :std_ulogic_vector(0 to 5);
signal congr_cl63_wG_q           :std_ulogic_vector(0 to 5);
signal rel_bixu63_wayG_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd63_wayG    :std_ulogic;
signal p1_way_data_upd63_wayG    :std_ulogic;
signal congr_cl63_wH_d           :std_ulogic_vector(0 to 5);
signal congr_cl63_wH_q           :std_ulogic_vector(0 to 5);
signal rel_bixu63_wayH_upd       :std_ulogic_vector(0 to 1);
signal p0_way_data_upd63_wayH    :std_ulogic;
signal p1_way_data_upd63_wayH    :std_ulogic;
signal tagA_hit                   :std_ulogic;
signal tagA_hit_b                 :std_ulogic;
signal arr_wayA_val               :std_ulogic_vector(0 to 5);
signal p0_arr_wayA_rd             :std_ulogic_vector(0 to 5);
signal flush_wayA_d               :std_ulogic_vector(0 to 5);
signal flush_wayA_q               :std_ulogic_vector(0 to 5);
signal rel_wayA_clr               :std_ulogic;
signal rel_wayA_set               :std_ulogic;
signal rel_par_wA_clr             :std_ulogic;
signal wayA_val                   :std_ulogic_vector(0 to 5);
signal wayA_val_b_q               :std_ulogic_vector(0 to 5);
signal wayA_val_b1                :std_ulogic;
signal congr_cl_ex2_wayA_byp      :std_ulogic_vector(1 to 7);
signal congr_cl_ex2_wayA_sel      :std_ulogic_vector(2 to 7);
signal rel_arr_wayA_val           :std_ulogic_vector(0 to 5);
signal p1_arr_wayA_rd             :std_ulogic_vector(0 to 5);
signal rel_wayA_val_b_q           :std_ulogic_vector(0 to 5);
signal rel_wayA_val               :std_ulogic_vector(0 to 5);
signal congr_cl_rel13_wayA_byp    :std_ulogic_vector(1 to 7);
signal congr_cl_rel13_wayA_sel    :std_ulogic_vector(2 to 7);
signal reload_wayA_d              :std_ulogic_vector(0 to 5);
signal reload_wayA_q              :std_ulogic_vector(0 to 5);
signal reload_wayA_data_d         :std_ulogic_vector(0 to 5);
signal reload_wayA_data_q         :std_ulogic_vector(0 to 5);
signal reload_wayA_data2_d        :std_ulogic_vector(0 to 5);
signal reload_wayA_data2_q        :std_ulogic_vector(0 to 5);
signal reload_wayA_upd_d          :std_ulogic;
signal reload_wayA_upd_q          :std_ulogic;
signal reload_wayA_clr            :std_ulogic;
signal reload_wayA_upd2_d         :std_ulogic;
signal reload_wayA_upd2_q         :std_ulogic;
signal reload_wayA_upd3_d         :std_ulogic;
signal reload_wayA_upd3_q         :std_ulogic;
signal reload_wayA                :std_ulogic_vector(0 to 5);
signal binv_wayA_upd_d            :std_ulogic;
signal binv_wayA_upd_q            :std_ulogic;
signal binv_wayA_upd1             :std_ulogic;
signal binv_wayA_upd2_d           :std_ulogic;
signal binv_wayA_upd2_q           :std_ulogic;
signal binv_wayA_upd3_d           :std_ulogic;
signal binv_wayA_upd3_q           :std_ulogic;
signal flush_wayA_data1           :std_ulogic_vector(0 to 5);
signal flush_wayA_data_d          :std_ulogic_vector(0 to 5);
signal flush_wayA_data_q          :std_ulogic_vector(0 to 5);
signal flush_wayA_data2_d         :std_ulogic_vector(0 to 5);
signal flush_wayA_data2_q         :std_ulogic_vector(0 to 5);
signal xu_op_hit_wayA_b           :std_ulogic;
signal xu_op_hit_wayA             :std_ulogic;
signal xu_op_hit_wayA_dly_b       :std_ulogic;
signal clr_val_wayA               :std_ulogic;
signal upd_lck_wayA               :std_ulogic_vector(0 to 1);
signal inval_clr_lck_wA_d         :std_ulogic;
signal inval_clr_lck_wA_q         :std_ulogic;
signal perr_way_det_wayA          :std_ulogic;
signal perr_wayA_watch_lost       :std_ulogic_vector(0 to 3);
signal wayA_watch_value           :std_ulogic;
signal ex4_lost_wayA              :std_ulogic_vector(0 to 3);
signal ex3_xuop_lost_watch_wayA   :std_ulogic;
signal ex3_xuop_wayA_upd          :std_ulogic;
signal ex4_xuop_wayA_upd_d        :std_ulogic;
signal ex4_xuop_wayA_upd_q        :std_ulogic;
signal ex4_wayA_val_d             :std_ulogic_vector(0 to 5);
signal ex4_wayA_val_q             :std_ulogic_vector(0 to 5);
signal rel_wayA_val_stg_d         :std_ulogic_vector(0 to 5);
signal rel_wayA_val_stg_q         :std_ulogic_vector(0 to 5);
signal ex5_xuop_wayA_upd_d        :std_ulogic;
signal ex5_xuop_wayA_upd_q        :std_ulogic;
signal congr_cl_ex3_upd_wayA      :std_ulogic;
signal congr_cl_ex4_upd_wayA      :std_ulogic;
signal congr_cl_ex5_upd_wayA      :std_ulogic;
signal congr_cl_m_upd_wayA_d      :std_ulogic;
signal congr_cl_m_upd_wayA_q      :std_ulogic;
signal ex3_cClass_wayA_hit        :std_ulogic;
signal wayA_later_stg_pri         :std_ulogic_vector(0 to 5);
signal wayA_early_stg_pri         :std_ulogic_vector(0 to 5);
signal wayA_stg_val               :std_ulogic_vector(0 to 5);
signal wayA_stg_val_b             :std_ulogic_vector(0 to 5);
signal rel_wayA_later_stg_pri     :std_ulogic_vector(0 to 5);
signal rel_wayA_early_stg_pri     :std_ulogic_vector(0 to 5);
signal rel_wayA_stg_val           :std_ulogic_vector(0 to 5);
signal rel_wayA_stg_val_b         :std_ulogic_vector(0 to 5);
signal wayA_early_sel             :std_ulogic;
signal wayA_late_sel              :std_ulogic;
signal rel_wayA_early_sel         :std_ulogic;
signal rel_wayA_late_sel          :std_ulogic;
signal ex3_wayA_hit               :std_ulogic;
signal rel_lost_watch_wayA_evict   :std_ulogic_vector(0 to 3);
signal ex3_wayA_fxubyp_val_d      :std_ulogic;
signal ex3_wayA_fxubyp_val_q      :std_ulogic;
signal ex4_wayA_fxubyp_val_d      :std_ulogic;
signal ex4_wayA_fxubyp_val_q      :std_ulogic;
signal ex3_wayA_relbyp_val_d      :std_ulogic;
signal ex3_wayA_relbyp_val_q      :std_ulogic;
signal ex4_wayA_relbyp_val_d      :std_ulogic;
signal ex4_wayA_relbyp_val_q      :std_ulogic;
signal ex4_wayA_byp_sel           :std_ulogic_vector(0 to 1);
signal rel24_wayA_fxubyp_val_d    :std_ulogic;
signal rel24_wayA_fxubyp_val_q    :std_ulogic;
signal rel24_wayA_relbyp_val_d    :std_ulogic;
signal rel24_wayA_relbyp_val_q    :std_ulogic;
signal rel24_wayA_byp_sel         :std_ulogic_vector(0 to 1);
signal tagB_hit                   :std_ulogic;
signal tagB_hit_b                 :std_ulogic;
signal arr_wayB_val               :std_ulogic_vector(0 to 5);
signal p0_arr_wayB_rd             :std_ulogic_vector(0 to 5);
signal flush_wayB_d               :std_ulogic_vector(0 to 5);
signal flush_wayB_q               :std_ulogic_vector(0 to 5);
signal rel_wayB_clr               :std_ulogic;
signal rel_wayB_set               :std_ulogic;
signal rel_par_wB_clr             :std_ulogic;
signal wayB_val                   :std_ulogic_vector(0 to 5);
signal wayB_val_b_q               :std_ulogic_vector(0 to 5);
signal wayB_val_b1                :std_ulogic;
signal congr_cl_ex2_wayB_byp      :std_ulogic_vector(1 to 7);
signal congr_cl_ex2_wayB_sel      :std_ulogic_vector(2 to 7);
signal rel_arr_wayB_val           :std_ulogic_vector(0 to 5);
signal p1_arr_wayB_rd             :std_ulogic_vector(0 to 5);
signal rel_wayB_val_b_q           :std_ulogic_vector(0 to 5);
signal rel_wayB_val               :std_ulogic_vector(0 to 5);
signal congr_cl_rel13_wayB_byp    :std_ulogic_vector(1 to 7);
signal congr_cl_rel13_wayB_sel    :std_ulogic_vector(2 to 7);
signal reload_wayB_d              :std_ulogic_vector(0 to 5);
signal reload_wayB_q              :std_ulogic_vector(0 to 5);
signal reload_wayB_data_d         :std_ulogic_vector(0 to 5);
signal reload_wayB_data_q         :std_ulogic_vector(0 to 5);
signal reload_wayB_data2_d        :std_ulogic_vector(0 to 5);
signal reload_wayB_data2_q        :std_ulogic_vector(0 to 5);
signal reload_wayB_upd_d          :std_ulogic;
signal reload_wayB_upd_q          :std_ulogic;
signal reload_wayB_clr            :std_ulogic;
signal reload_wayB_upd2_d         :std_ulogic;
signal reload_wayB_upd2_q         :std_ulogic;
signal reload_wayB_upd3_d         :std_ulogic;
signal reload_wayB_upd3_q         :std_ulogic;
signal reload_wayB                :std_ulogic_vector(0 to 5);
signal binv_wayB_upd_d            :std_ulogic;
signal binv_wayB_upd_q            :std_ulogic;
signal binv_wayB_upd1             :std_ulogic;
signal binv_wayB_upd2_d           :std_ulogic;
signal binv_wayB_upd2_q           :std_ulogic;
signal binv_wayB_upd3_d           :std_ulogic;
signal binv_wayB_upd3_q           :std_ulogic;
signal flush_wayB_data1           :std_ulogic_vector(0 to 5);
signal flush_wayB_data_d          :std_ulogic_vector(0 to 5);
signal flush_wayB_data_q          :std_ulogic_vector(0 to 5);
signal flush_wayB_data2_d         :std_ulogic_vector(0 to 5);
signal flush_wayB_data2_q         :std_ulogic_vector(0 to 5);
signal xu_op_hit_wayB_b           :std_ulogic;
signal xu_op_hit_wayB             :std_ulogic;
signal xu_op_hit_wayB_dly_b       :std_ulogic;
signal clr_val_wayB               :std_ulogic;
signal upd_lck_wayB               :std_ulogic_vector(0 to 1);
signal inval_clr_lck_wB_d         :std_ulogic;
signal inval_clr_lck_wB_q         :std_ulogic;
signal perr_way_det_wayB          :std_ulogic;
signal perr_wayB_watch_lost       :std_ulogic_vector(0 to 3);
signal wayB_watch_value           :std_ulogic;
signal ex4_lost_wayB              :std_ulogic_vector(0 to 3);
signal ex3_xuop_lost_watch_wayB   :std_ulogic;
signal ex3_xuop_wayB_upd          :std_ulogic;
signal ex4_xuop_wayB_upd_d        :std_ulogic;
signal ex4_xuop_wayB_upd_q        :std_ulogic;
signal ex4_wayB_val_d             :std_ulogic_vector(0 to 5);
signal ex4_wayB_val_q             :std_ulogic_vector(0 to 5);
signal rel_wayB_val_stg_d         :std_ulogic_vector(0 to 5);
signal rel_wayB_val_stg_q         :std_ulogic_vector(0 to 5);
signal ex5_xuop_wayB_upd_d        :std_ulogic;
signal ex5_xuop_wayB_upd_q        :std_ulogic;
signal congr_cl_ex3_upd_wayB      :std_ulogic;
signal congr_cl_ex4_upd_wayB      :std_ulogic;
signal congr_cl_ex5_upd_wayB      :std_ulogic;
signal congr_cl_m_upd_wayB_d      :std_ulogic;
signal congr_cl_m_upd_wayB_q      :std_ulogic;
signal ex3_cClass_wayB_hit        :std_ulogic;
signal wayB_later_stg_pri         :std_ulogic_vector(0 to 5);
signal wayB_early_stg_pri         :std_ulogic_vector(0 to 5);
signal wayB_stg_val               :std_ulogic_vector(0 to 5);
signal wayB_stg_val_b             :std_ulogic_vector(0 to 5);
signal rel_wayB_later_stg_pri     :std_ulogic_vector(0 to 5);
signal rel_wayB_early_stg_pri     :std_ulogic_vector(0 to 5);
signal rel_wayB_stg_val           :std_ulogic_vector(0 to 5);
signal rel_wayB_stg_val_b         :std_ulogic_vector(0 to 5);
signal wayB_early_sel             :std_ulogic;
signal wayB_late_sel              :std_ulogic;
signal rel_wayB_early_sel         :std_ulogic;
signal rel_wayB_late_sel          :std_ulogic;
signal ex3_wayB_hit               :std_ulogic;
signal rel_lost_watch_wayB_evict   :std_ulogic_vector(0 to 3);
signal ex3_wayB_fxubyp_val_d      :std_ulogic;
signal ex3_wayB_fxubyp_val_q      :std_ulogic;
signal ex4_wayB_fxubyp_val_d      :std_ulogic;
signal ex4_wayB_fxubyp_val_q      :std_ulogic;
signal ex3_wayB_relbyp_val_d      :std_ulogic;
signal ex3_wayB_relbyp_val_q      :std_ulogic;
signal ex4_wayB_relbyp_val_d      :std_ulogic;
signal ex4_wayB_relbyp_val_q      :std_ulogic;
signal ex4_wayB_byp_sel           :std_ulogic_vector(0 to 1);
signal rel24_wayB_fxubyp_val_d    :std_ulogic;
signal rel24_wayB_fxubyp_val_q    :std_ulogic;
signal rel24_wayB_relbyp_val_d    :std_ulogic;
signal rel24_wayB_relbyp_val_q    :std_ulogic;
signal rel24_wayB_byp_sel         :std_ulogic_vector(0 to 1);
signal tagC_hit                   :std_ulogic;
signal tagC_hit_b                 :std_ulogic;
signal arr_wayC_val               :std_ulogic_vector(0 to 5);
signal p0_arr_wayC_rd             :std_ulogic_vector(0 to 5);
signal flush_wayC_d               :std_ulogic_vector(0 to 5);
signal flush_wayC_q               :std_ulogic_vector(0 to 5);
signal rel_wayC_clr               :std_ulogic;
signal rel_wayC_set               :std_ulogic;
signal rel_par_wC_clr             :std_ulogic;
signal wayC_val                   :std_ulogic_vector(0 to 5);
signal wayC_val_b_q               :std_ulogic_vector(0 to 5);
signal wayC_val_b1                :std_ulogic;
signal congr_cl_ex2_wayC_byp      :std_ulogic_vector(1 to 7);
signal congr_cl_ex2_wayC_sel      :std_ulogic_vector(2 to 7);
signal rel_arr_wayC_val           :std_ulogic_vector(0 to 5);
signal p1_arr_wayC_rd             :std_ulogic_vector(0 to 5);
signal rel_wayC_val_b_q           :std_ulogic_vector(0 to 5);
signal rel_wayC_val               :std_ulogic_vector(0 to 5);
signal congr_cl_rel13_wayC_byp    :std_ulogic_vector(1 to 7);
signal congr_cl_rel13_wayC_sel    :std_ulogic_vector(2 to 7);
signal reload_wayC_d              :std_ulogic_vector(0 to 5);
signal reload_wayC_q              :std_ulogic_vector(0 to 5);
signal reload_wayC_data_d         :std_ulogic_vector(0 to 5);
signal reload_wayC_data_q         :std_ulogic_vector(0 to 5);
signal reload_wayC_data2_d        :std_ulogic_vector(0 to 5);
signal reload_wayC_data2_q        :std_ulogic_vector(0 to 5);
signal reload_wayC_upd_d          :std_ulogic;
signal reload_wayC_upd_q          :std_ulogic;
signal reload_wayC_clr            :std_ulogic;
signal reload_wayC_upd2_d         :std_ulogic;
signal reload_wayC_upd2_q         :std_ulogic;
signal reload_wayC_upd3_d         :std_ulogic;
signal reload_wayC_upd3_q         :std_ulogic;
signal reload_wayC                :std_ulogic_vector(0 to 5);
signal binv_wayC_upd_d            :std_ulogic;
signal binv_wayC_upd_q            :std_ulogic;
signal binv_wayC_upd1             :std_ulogic;
signal binv_wayC_upd2_d           :std_ulogic;
signal binv_wayC_upd2_q           :std_ulogic;
signal binv_wayC_upd3_d           :std_ulogic;
signal binv_wayC_upd3_q           :std_ulogic;
signal flush_wayC_data1           :std_ulogic_vector(0 to 5);
signal flush_wayC_data_d          :std_ulogic_vector(0 to 5);
signal flush_wayC_data_q          :std_ulogic_vector(0 to 5);
signal flush_wayC_data2_d         :std_ulogic_vector(0 to 5);
signal flush_wayC_data2_q         :std_ulogic_vector(0 to 5);
signal xu_op_hit_wayC_b           :std_ulogic;
signal xu_op_hit_wayC             :std_ulogic;
signal xu_op_hit_wayC_dly_b       :std_ulogic;
signal clr_val_wayC               :std_ulogic;
signal upd_lck_wayC               :std_ulogic_vector(0 to 1);
signal inval_clr_lck_wC_d         :std_ulogic;
signal inval_clr_lck_wC_q         :std_ulogic;
signal perr_way_det_wayC          :std_ulogic;
signal perr_wayC_watch_lost       :std_ulogic_vector(0 to 3);
signal wayC_watch_value           :std_ulogic;
signal ex4_lost_wayC              :std_ulogic_vector(0 to 3);
signal ex3_xuop_lost_watch_wayC   :std_ulogic;
signal ex3_xuop_wayC_upd          :std_ulogic;
signal ex4_xuop_wayC_upd_d        :std_ulogic;
signal ex4_xuop_wayC_upd_q        :std_ulogic;
signal ex4_wayC_val_d             :std_ulogic_vector(0 to 5);
signal ex4_wayC_val_q             :std_ulogic_vector(0 to 5);
signal rel_wayC_val_stg_d         :std_ulogic_vector(0 to 5);
signal rel_wayC_val_stg_q         :std_ulogic_vector(0 to 5);
signal ex5_xuop_wayC_upd_d        :std_ulogic;
signal ex5_xuop_wayC_upd_q        :std_ulogic;
signal congr_cl_ex3_upd_wayC      :std_ulogic;
signal congr_cl_ex4_upd_wayC      :std_ulogic;
signal congr_cl_ex5_upd_wayC      :std_ulogic;
signal congr_cl_m_upd_wayC_d      :std_ulogic;
signal congr_cl_m_upd_wayC_q      :std_ulogic;
signal ex3_cClass_wayC_hit        :std_ulogic;
signal wayC_later_stg_pri         :std_ulogic_vector(0 to 5);
signal wayC_early_stg_pri         :std_ulogic_vector(0 to 5);
signal wayC_stg_val               :std_ulogic_vector(0 to 5);
signal wayC_stg_val_b             :std_ulogic_vector(0 to 5);
signal rel_wayC_later_stg_pri     :std_ulogic_vector(0 to 5);
signal rel_wayC_early_stg_pri     :std_ulogic_vector(0 to 5);
signal rel_wayC_stg_val           :std_ulogic_vector(0 to 5);
signal rel_wayC_stg_val_b         :std_ulogic_vector(0 to 5);
signal wayC_early_sel             :std_ulogic;
signal wayC_late_sel              :std_ulogic;
signal rel_wayC_early_sel         :std_ulogic;
signal rel_wayC_late_sel          :std_ulogic;
signal ex3_wayC_hit               :std_ulogic;
signal rel_lost_watch_wayC_evict   :std_ulogic_vector(0 to 3);
signal ex3_wayC_fxubyp_val_d      :std_ulogic;
signal ex3_wayC_fxubyp_val_q      :std_ulogic;
signal ex4_wayC_fxubyp_val_d      :std_ulogic;
signal ex4_wayC_fxubyp_val_q      :std_ulogic;
signal ex3_wayC_relbyp_val_d      :std_ulogic;
signal ex3_wayC_relbyp_val_q      :std_ulogic;
signal ex4_wayC_relbyp_val_d      :std_ulogic;
signal ex4_wayC_relbyp_val_q      :std_ulogic;
signal ex4_wayC_byp_sel           :std_ulogic_vector(0 to 1);
signal rel24_wayC_fxubyp_val_d    :std_ulogic;
signal rel24_wayC_fxubyp_val_q    :std_ulogic;
signal rel24_wayC_relbyp_val_d    :std_ulogic;
signal rel24_wayC_relbyp_val_q    :std_ulogic;
signal rel24_wayC_byp_sel         :std_ulogic_vector(0 to 1);
signal tagD_hit                   :std_ulogic;
signal tagD_hit_b                 :std_ulogic;
signal arr_wayD_val               :std_ulogic_vector(0 to 5);
signal p0_arr_wayD_rd             :std_ulogic_vector(0 to 5);
signal flush_wayD_d               :std_ulogic_vector(0 to 5);
signal flush_wayD_q               :std_ulogic_vector(0 to 5);
signal rel_wayD_clr               :std_ulogic;
signal rel_wayD_set               :std_ulogic;
signal rel_par_wD_clr             :std_ulogic;
signal wayD_val                   :std_ulogic_vector(0 to 5);
signal wayD_val_b_q               :std_ulogic_vector(0 to 5);
signal wayD_val_b1                :std_ulogic;
signal congr_cl_ex2_wayD_byp      :std_ulogic_vector(1 to 7);
signal congr_cl_ex2_wayD_sel      :std_ulogic_vector(2 to 7);
signal rel_arr_wayD_val           :std_ulogic_vector(0 to 5);
signal p1_arr_wayD_rd             :std_ulogic_vector(0 to 5);
signal rel_wayD_val_b_q           :std_ulogic_vector(0 to 5);
signal rel_wayD_val               :std_ulogic_vector(0 to 5);
signal congr_cl_rel13_wayD_byp    :std_ulogic_vector(1 to 7);
signal congr_cl_rel13_wayD_sel    :std_ulogic_vector(2 to 7);
signal reload_wayD_d              :std_ulogic_vector(0 to 5);
signal reload_wayD_q              :std_ulogic_vector(0 to 5);
signal reload_wayD_data_d         :std_ulogic_vector(0 to 5);
signal reload_wayD_data_q         :std_ulogic_vector(0 to 5);
signal reload_wayD_data2_d        :std_ulogic_vector(0 to 5);
signal reload_wayD_data2_q        :std_ulogic_vector(0 to 5);
signal reload_wayD_upd_d          :std_ulogic;
signal reload_wayD_upd_q          :std_ulogic;
signal reload_wayD_clr            :std_ulogic;
signal reload_wayD_upd2_d         :std_ulogic;
signal reload_wayD_upd2_q         :std_ulogic;
signal reload_wayD_upd3_d         :std_ulogic;
signal reload_wayD_upd3_q         :std_ulogic;
signal reload_wayD                :std_ulogic_vector(0 to 5);
signal binv_wayD_upd_d            :std_ulogic;
signal binv_wayD_upd_q            :std_ulogic;
signal binv_wayD_upd1             :std_ulogic;
signal binv_wayD_upd2_d           :std_ulogic;
signal binv_wayD_upd2_q           :std_ulogic;
signal binv_wayD_upd3_d           :std_ulogic;
signal binv_wayD_upd3_q           :std_ulogic;
signal flush_wayD_data1           :std_ulogic_vector(0 to 5);
signal flush_wayD_data_d          :std_ulogic_vector(0 to 5);
signal flush_wayD_data_q          :std_ulogic_vector(0 to 5);
signal flush_wayD_data2_d         :std_ulogic_vector(0 to 5);
signal flush_wayD_data2_q         :std_ulogic_vector(0 to 5);
signal xu_op_hit_wayD_b           :std_ulogic;
signal xu_op_hit_wayD             :std_ulogic;
signal xu_op_hit_wayD_dly_b       :std_ulogic;
signal clr_val_wayD               :std_ulogic;
signal upd_lck_wayD               :std_ulogic_vector(0 to 1);
signal inval_clr_lck_wD_d         :std_ulogic;
signal inval_clr_lck_wD_q         :std_ulogic;
signal perr_way_det_wayD          :std_ulogic;
signal perr_wayD_watch_lost       :std_ulogic_vector(0 to 3);
signal wayD_watch_value           :std_ulogic;
signal ex4_lost_wayD              :std_ulogic_vector(0 to 3);
signal ex3_xuop_lost_watch_wayD   :std_ulogic;
signal ex3_xuop_wayD_upd          :std_ulogic;
signal ex4_xuop_wayD_upd_d        :std_ulogic;
signal ex4_xuop_wayD_upd_q        :std_ulogic;
signal ex4_wayD_val_d             :std_ulogic_vector(0 to 5);
signal ex4_wayD_val_q             :std_ulogic_vector(0 to 5);
signal rel_wayD_val_stg_d         :std_ulogic_vector(0 to 5);
signal rel_wayD_val_stg_q         :std_ulogic_vector(0 to 5);
signal ex5_xuop_wayD_upd_d        :std_ulogic;
signal ex5_xuop_wayD_upd_q        :std_ulogic;
signal congr_cl_ex3_upd_wayD      :std_ulogic;
signal congr_cl_ex4_upd_wayD      :std_ulogic;
signal congr_cl_ex5_upd_wayD      :std_ulogic;
signal congr_cl_m_upd_wayD_d      :std_ulogic;
signal congr_cl_m_upd_wayD_q      :std_ulogic;
signal ex3_cClass_wayD_hit        :std_ulogic;
signal wayD_later_stg_pri         :std_ulogic_vector(0 to 5);
signal wayD_early_stg_pri         :std_ulogic_vector(0 to 5);
signal wayD_stg_val               :std_ulogic_vector(0 to 5);
signal wayD_stg_val_b             :std_ulogic_vector(0 to 5);
signal rel_wayD_later_stg_pri     :std_ulogic_vector(0 to 5);
signal rel_wayD_early_stg_pri     :std_ulogic_vector(0 to 5);
signal rel_wayD_stg_val           :std_ulogic_vector(0 to 5);
signal rel_wayD_stg_val_b         :std_ulogic_vector(0 to 5);
signal wayD_early_sel             :std_ulogic;
signal wayD_late_sel              :std_ulogic;
signal rel_wayD_early_sel         :std_ulogic;
signal rel_wayD_late_sel          :std_ulogic;
signal ex3_wayD_hit               :std_ulogic;
signal rel_lost_watch_wayD_evict   :std_ulogic_vector(0 to 3);
signal ex3_wayD_fxubyp_val_d      :std_ulogic;
signal ex3_wayD_fxubyp_val_q      :std_ulogic;
signal ex4_wayD_fxubyp_val_d      :std_ulogic;
signal ex4_wayD_fxubyp_val_q      :std_ulogic;
signal ex3_wayD_relbyp_val_d      :std_ulogic;
signal ex3_wayD_relbyp_val_q      :std_ulogic;
signal ex4_wayD_relbyp_val_d      :std_ulogic;
signal ex4_wayD_relbyp_val_q      :std_ulogic;
signal ex4_wayD_byp_sel           :std_ulogic_vector(0 to 1);
signal rel24_wayD_fxubyp_val_d    :std_ulogic;
signal rel24_wayD_fxubyp_val_q    :std_ulogic;
signal rel24_wayD_relbyp_val_d    :std_ulogic;
signal rel24_wayD_relbyp_val_q    :std_ulogic;
signal rel24_wayD_byp_sel         :std_ulogic_vector(0 to 1);
signal tagE_hit                   :std_ulogic;
signal tagE_hit_b                 :std_ulogic;
signal arr_wayE_val               :std_ulogic_vector(0 to 5);
signal p0_arr_wayE_rd             :std_ulogic_vector(0 to 5);
signal flush_wayE_d               :std_ulogic_vector(0 to 5);
signal flush_wayE_q               :std_ulogic_vector(0 to 5);
signal rel_wayE_clr               :std_ulogic;
signal rel_wayE_set               :std_ulogic;
signal rel_par_wE_clr             :std_ulogic;
signal wayE_val                   :std_ulogic_vector(0 to 5);
signal wayE_val_b_q               :std_ulogic_vector(0 to 5);
signal wayE_val_b1                :std_ulogic;
signal congr_cl_ex2_wayE_byp      :std_ulogic_vector(1 to 7);
signal congr_cl_ex2_wayE_sel      :std_ulogic_vector(2 to 7);
signal rel_arr_wayE_val           :std_ulogic_vector(0 to 5);
signal p1_arr_wayE_rd             :std_ulogic_vector(0 to 5);
signal rel_wayE_val_b_q           :std_ulogic_vector(0 to 5);
signal rel_wayE_val               :std_ulogic_vector(0 to 5);
signal congr_cl_rel13_wayE_byp    :std_ulogic_vector(1 to 7);
signal congr_cl_rel13_wayE_sel    :std_ulogic_vector(2 to 7);
signal reload_wayE_d              :std_ulogic_vector(0 to 5);
signal reload_wayE_q              :std_ulogic_vector(0 to 5);
signal reload_wayE_data_d         :std_ulogic_vector(0 to 5);
signal reload_wayE_data_q         :std_ulogic_vector(0 to 5);
signal reload_wayE_data2_d        :std_ulogic_vector(0 to 5);
signal reload_wayE_data2_q        :std_ulogic_vector(0 to 5);
signal reload_wayE_upd_d          :std_ulogic;
signal reload_wayE_upd_q          :std_ulogic;
signal reload_wayE_clr            :std_ulogic;
signal reload_wayE_upd2_d         :std_ulogic;
signal reload_wayE_upd2_q         :std_ulogic;
signal reload_wayE_upd3_d         :std_ulogic;
signal reload_wayE_upd3_q         :std_ulogic;
signal reload_wayE                :std_ulogic_vector(0 to 5);
signal binv_wayE_upd_d            :std_ulogic;
signal binv_wayE_upd_q            :std_ulogic;
signal binv_wayE_upd1             :std_ulogic;
signal binv_wayE_upd2_d           :std_ulogic;
signal binv_wayE_upd2_q           :std_ulogic;
signal binv_wayE_upd3_d           :std_ulogic;
signal binv_wayE_upd3_q           :std_ulogic;
signal flush_wayE_data1           :std_ulogic_vector(0 to 5);
signal flush_wayE_data_d          :std_ulogic_vector(0 to 5);
signal flush_wayE_data_q          :std_ulogic_vector(0 to 5);
signal flush_wayE_data2_d         :std_ulogic_vector(0 to 5);
signal flush_wayE_data2_q         :std_ulogic_vector(0 to 5);
signal xu_op_hit_wayE_b           :std_ulogic;
signal xu_op_hit_wayE             :std_ulogic;
signal xu_op_hit_wayE_dly_b       :std_ulogic;
signal clr_val_wayE               :std_ulogic;
signal upd_lck_wayE               :std_ulogic_vector(0 to 1);
signal inval_clr_lck_wE_d         :std_ulogic;
signal inval_clr_lck_wE_q         :std_ulogic;
signal perr_way_det_wayE          :std_ulogic;
signal perr_wayE_watch_lost       :std_ulogic_vector(0 to 3);
signal wayE_watch_value           :std_ulogic;
signal ex4_lost_wayE              :std_ulogic_vector(0 to 3);
signal ex3_xuop_lost_watch_wayE   :std_ulogic;
signal ex3_xuop_wayE_upd          :std_ulogic;
signal ex4_xuop_wayE_upd_d        :std_ulogic;
signal ex4_xuop_wayE_upd_q        :std_ulogic;
signal ex4_wayE_val_d             :std_ulogic_vector(0 to 5);
signal ex4_wayE_val_q             :std_ulogic_vector(0 to 5);
signal rel_wayE_val_stg_d         :std_ulogic_vector(0 to 5);
signal rel_wayE_val_stg_q         :std_ulogic_vector(0 to 5);
signal ex5_xuop_wayE_upd_d        :std_ulogic;
signal ex5_xuop_wayE_upd_q        :std_ulogic;
signal congr_cl_ex3_upd_wayE      :std_ulogic;
signal congr_cl_ex4_upd_wayE      :std_ulogic;
signal congr_cl_ex5_upd_wayE      :std_ulogic;
signal congr_cl_m_upd_wayE_d      :std_ulogic;
signal congr_cl_m_upd_wayE_q      :std_ulogic;
signal ex3_cClass_wayE_hit        :std_ulogic;
signal wayE_later_stg_pri         :std_ulogic_vector(0 to 5);
signal wayE_early_stg_pri         :std_ulogic_vector(0 to 5);
signal wayE_stg_val               :std_ulogic_vector(0 to 5);
signal wayE_stg_val_b             :std_ulogic_vector(0 to 5);
signal rel_wayE_later_stg_pri     :std_ulogic_vector(0 to 5);
signal rel_wayE_early_stg_pri     :std_ulogic_vector(0 to 5);
signal rel_wayE_stg_val           :std_ulogic_vector(0 to 5);
signal rel_wayE_stg_val_b         :std_ulogic_vector(0 to 5);
signal wayE_early_sel             :std_ulogic;
signal wayE_late_sel              :std_ulogic;
signal rel_wayE_early_sel         :std_ulogic;
signal rel_wayE_late_sel          :std_ulogic;
signal ex3_wayE_hit               :std_ulogic;
signal rel_lost_watch_wayE_evict   :std_ulogic_vector(0 to 3);
signal ex3_wayE_fxubyp_val_d      :std_ulogic;
signal ex3_wayE_fxubyp_val_q      :std_ulogic;
signal ex4_wayE_fxubyp_val_d      :std_ulogic;
signal ex4_wayE_fxubyp_val_q      :std_ulogic;
signal ex3_wayE_relbyp_val_d      :std_ulogic;
signal ex3_wayE_relbyp_val_q      :std_ulogic;
signal ex4_wayE_relbyp_val_d      :std_ulogic;
signal ex4_wayE_relbyp_val_q      :std_ulogic;
signal ex4_wayE_byp_sel           :std_ulogic_vector(0 to 1);
signal rel24_wayE_fxubyp_val_d    :std_ulogic;
signal rel24_wayE_fxubyp_val_q    :std_ulogic;
signal rel24_wayE_relbyp_val_d    :std_ulogic;
signal rel24_wayE_relbyp_val_q    :std_ulogic;
signal rel24_wayE_byp_sel         :std_ulogic_vector(0 to 1);
signal tagF_hit                   :std_ulogic;
signal tagF_hit_b                 :std_ulogic;
signal arr_wayF_val               :std_ulogic_vector(0 to 5);
signal p0_arr_wayF_rd             :std_ulogic_vector(0 to 5);
signal flush_wayF_d               :std_ulogic_vector(0 to 5);
signal flush_wayF_q               :std_ulogic_vector(0 to 5);
signal rel_wayF_clr               :std_ulogic;
signal rel_wayF_set               :std_ulogic;
signal rel_par_wF_clr             :std_ulogic;
signal wayF_val                   :std_ulogic_vector(0 to 5);
signal wayF_val_b_q               :std_ulogic_vector(0 to 5);
signal wayF_val_b1                :std_ulogic;
signal congr_cl_ex2_wayF_byp      :std_ulogic_vector(1 to 7);
signal congr_cl_ex2_wayF_sel      :std_ulogic_vector(2 to 7);
signal rel_arr_wayF_val           :std_ulogic_vector(0 to 5);
signal p1_arr_wayF_rd             :std_ulogic_vector(0 to 5);
signal rel_wayF_val_b_q           :std_ulogic_vector(0 to 5);
signal rel_wayF_val               :std_ulogic_vector(0 to 5);
signal congr_cl_rel13_wayF_byp    :std_ulogic_vector(1 to 7);
signal congr_cl_rel13_wayF_sel    :std_ulogic_vector(2 to 7);
signal reload_wayF_d              :std_ulogic_vector(0 to 5);
signal reload_wayF_q              :std_ulogic_vector(0 to 5);
signal reload_wayF_data_d         :std_ulogic_vector(0 to 5);
signal reload_wayF_data_q         :std_ulogic_vector(0 to 5);
signal reload_wayF_data2_d        :std_ulogic_vector(0 to 5);
signal reload_wayF_data2_q        :std_ulogic_vector(0 to 5);
signal reload_wayF_upd_d          :std_ulogic;
signal reload_wayF_upd_q          :std_ulogic;
signal reload_wayF_clr            :std_ulogic;
signal reload_wayF_upd2_d         :std_ulogic;
signal reload_wayF_upd2_q         :std_ulogic;
signal reload_wayF_upd3_d         :std_ulogic;
signal reload_wayF_upd3_q         :std_ulogic;
signal reload_wayF                :std_ulogic_vector(0 to 5);
signal binv_wayF_upd_d            :std_ulogic;
signal binv_wayF_upd_q            :std_ulogic;
signal binv_wayF_upd1             :std_ulogic;
signal binv_wayF_upd2_d           :std_ulogic;
signal binv_wayF_upd2_q           :std_ulogic;
signal binv_wayF_upd3_d           :std_ulogic;
signal binv_wayF_upd3_q           :std_ulogic;
signal flush_wayF_data1           :std_ulogic_vector(0 to 5);
signal flush_wayF_data_d          :std_ulogic_vector(0 to 5);
signal flush_wayF_data_q          :std_ulogic_vector(0 to 5);
signal flush_wayF_data2_d         :std_ulogic_vector(0 to 5);
signal flush_wayF_data2_q         :std_ulogic_vector(0 to 5);
signal xu_op_hit_wayF_b           :std_ulogic;
signal xu_op_hit_wayF             :std_ulogic;
signal xu_op_hit_wayF_dly_b       :std_ulogic;
signal clr_val_wayF               :std_ulogic;
signal upd_lck_wayF               :std_ulogic_vector(0 to 1);
signal inval_clr_lck_wF_d         :std_ulogic;
signal inval_clr_lck_wF_q         :std_ulogic;
signal perr_way_det_wayF          :std_ulogic;
signal perr_wayF_watch_lost       :std_ulogic_vector(0 to 3);
signal wayF_watch_value           :std_ulogic;
signal ex4_lost_wayF              :std_ulogic_vector(0 to 3);
signal ex3_xuop_lost_watch_wayF   :std_ulogic;
signal ex3_xuop_wayF_upd          :std_ulogic;
signal ex4_xuop_wayF_upd_d        :std_ulogic;
signal ex4_xuop_wayF_upd_q        :std_ulogic;
signal ex4_wayF_val_d             :std_ulogic_vector(0 to 5);
signal ex4_wayF_val_q             :std_ulogic_vector(0 to 5);
signal rel_wayF_val_stg_d         :std_ulogic_vector(0 to 5);
signal rel_wayF_val_stg_q         :std_ulogic_vector(0 to 5);
signal ex5_xuop_wayF_upd_d        :std_ulogic;
signal ex5_xuop_wayF_upd_q        :std_ulogic;
signal congr_cl_ex3_upd_wayF      :std_ulogic;
signal congr_cl_ex4_upd_wayF      :std_ulogic;
signal congr_cl_ex5_upd_wayF      :std_ulogic;
signal congr_cl_m_upd_wayF_d      :std_ulogic;
signal congr_cl_m_upd_wayF_q      :std_ulogic;
signal ex3_cClass_wayF_hit        :std_ulogic;
signal wayF_later_stg_pri         :std_ulogic_vector(0 to 5);
signal wayF_early_stg_pri         :std_ulogic_vector(0 to 5);
signal wayF_stg_val               :std_ulogic_vector(0 to 5);
signal wayF_stg_val_b             :std_ulogic_vector(0 to 5);
signal rel_wayF_later_stg_pri     :std_ulogic_vector(0 to 5);
signal rel_wayF_early_stg_pri     :std_ulogic_vector(0 to 5);
signal rel_wayF_stg_val           :std_ulogic_vector(0 to 5);
signal rel_wayF_stg_val_b         :std_ulogic_vector(0 to 5);
signal wayF_early_sel             :std_ulogic;
signal wayF_late_sel              :std_ulogic;
signal rel_wayF_early_sel         :std_ulogic;
signal rel_wayF_late_sel          :std_ulogic;
signal ex3_wayF_hit               :std_ulogic;
signal rel_lost_watch_wayF_evict   :std_ulogic_vector(0 to 3);
signal ex3_wayF_fxubyp_val_d      :std_ulogic;
signal ex3_wayF_fxubyp_val_q      :std_ulogic;
signal ex4_wayF_fxubyp_val_d      :std_ulogic;
signal ex4_wayF_fxubyp_val_q      :std_ulogic;
signal ex3_wayF_relbyp_val_d      :std_ulogic;
signal ex3_wayF_relbyp_val_q      :std_ulogic;
signal ex4_wayF_relbyp_val_d      :std_ulogic;
signal ex4_wayF_relbyp_val_q      :std_ulogic;
signal ex4_wayF_byp_sel           :std_ulogic_vector(0 to 1);
signal rel24_wayF_fxubyp_val_d    :std_ulogic;
signal rel24_wayF_fxubyp_val_q    :std_ulogic;
signal rel24_wayF_relbyp_val_d    :std_ulogic;
signal rel24_wayF_relbyp_val_q    :std_ulogic;
signal rel24_wayF_byp_sel         :std_ulogic_vector(0 to 1);
signal tagG_hit                   :std_ulogic;
signal tagG_hit_b                 :std_ulogic;
signal arr_wayG_val               :std_ulogic_vector(0 to 5);
signal p0_arr_wayG_rd             :std_ulogic_vector(0 to 5);
signal flush_wayG_d               :std_ulogic_vector(0 to 5);
signal flush_wayG_q               :std_ulogic_vector(0 to 5);
signal rel_wayG_clr               :std_ulogic;
signal rel_wayG_set               :std_ulogic;
signal rel_par_wG_clr             :std_ulogic;
signal wayG_val                   :std_ulogic_vector(0 to 5);
signal wayG_val_b_q               :std_ulogic_vector(0 to 5);
signal wayG_val_b1                :std_ulogic;
signal congr_cl_ex2_wayG_byp      :std_ulogic_vector(1 to 7);
signal congr_cl_ex2_wayG_sel      :std_ulogic_vector(2 to 7);
signal rel_arr_wayG_val           :std_ulogic_vector(0 to 5);
signal p1_arr_wayG_rd             :std_ulogic_vector(0 to 5);
signal rel_wayG_val_b_q           :std_ulogic_vector(0 to 5);
signal rel_wayG_val               :std_ulogic_vector(0 to 5);
signal congr_cl_rel13_wayG_byp    :std_ulogic_vector(1 to 7);
signal congr_cl_rel13_wayG_sel    :std_ulogic_vector(2 to 7);
signal reload_wayG_d              :std_ulogic_vector(0 to 5);
signal reload_wayG_q              :std_ulogic_vector(0 to 5);
signal reload_wayG_data_d         :std_ulogic_vector(0 to 5);
signal reload_wayG_data_q         :std_ulogic_vector(0 to 5);
signal reload_wayG_data2_d        :std_ulogic_vector(0 to 5);
signal reload_wayG_data2_q        :std_ulogic_vector(0 to 5);
signal reload_wayG_upd_d          :std_ulogic;
signal reload_wayG_upd_q          :std_ulogic;
signal reload_wayG_clr            :std_ulogic;
signal reload_wayG_upd2_d         :std_ulogic;
signal reload_wayG_upd2_q         :std_ulogic;
signal reload_wayG_upd3_d         :std_ulogic;
signal reload_wayG_upd3_q         :std_ulogic;
signal reload_wayG                :std_ulogic_vector(0 to 5);
signal binv_wayG_upd_d            :std_ulogic;
signal binv_wayG_upd_q            :std_ulogic;
signal binv_wayG_upd1             :std_ulogic;
signal binv_wayG_upd2_d           :std_ulogic;
signal binv_wayG_upd2_q           :std_ulogic;
signal binv_wayG_upd3_d           :std_ulogic;
signal binv_wayG_upd3_q           :std_ulogic;
signal flush_wayG_data1           :std_ulogic_vector(0 to 5);
signal flush_wayG_data_d          :std_ulogic_vector(0 to 5);
signal flush_wayG_data_q          :std_ulogic_vector(0 to 5);
signal flush_wayG_data2_d         :std_ulogic_vector(0 to 5);
signal flush_wayG_data2_q         :std_ulogic_vector(0 to 5);
signal xu_op_hit_wayG_b           :std_ulogic;
signal xu_op_hit_wayG             :std_ulogic;
signal xu_op_hit_wayG_dly_b       :std_ulogic;
signal clr_val_wayG               :std_ulogic;
signal upd_lck_wayG               :std_ulogic_vector(0 to 1);
signal inval_clr_lck_wG_d         :std_ulogic;
signal inval_clr_lck_wG_q         :std_ulogic;
signal perr_way_det_wayG          :std_ulogic;
signal perr_wayG_watch_lost       :std_ulogic_vector(0 to 3);
signal wayG_watch_value           :std_ulogic;
signal ex4_lost_wayG              :std_ulogic_vector(0 to 3);
signal ex3_xuop_lost_watch_wayG   :std_ulogic;
signal ex3_xuop_wayG_upd          :std_ulogic;
signal ex4_xuop_wayG_upd_d        :std_ulogic;
signal ex4_xuop_wayG_upd_q        :std_ulogic;
signal ex4_wayG_val_d             :std_ulogic_vector(0 to 5);
signal ex4_wayG_val_q             :std_ulogic_vector(0 to 5);
signal rel_wayG_val_stg_d         :std_ulogic_vector(0 to 5);
signal rel_wayG_val_stg_q         :std_ulogic_vector(0 to 5);
signal ex5_xuop_wayG_upd_d        :std_ulogic;
signal ex5_xuop_wayG_upd_q        :std_ulogic;
signal congr_cl_ex3_upd_wayG      :std_ulogic;
signal congr_cl_ex4_upd_wayG      :std_ulogic;
signal congr_cl_ex5_upd_wayG      :std_ulogic;
signal congr_cl_m_upd_wayG_d      :std_ulogic;
signal congr_cl_m_upd_wayG_q      :std_ulogic;
signal ex3_cClass_wayG_hit        :std_ulogic;
signal wayG_later_stg_pri         :std_ulogic_vector(0 to 5);
signal wayG_early_stg_pri         :std_ulogic_vector(0 to 5);
signal wayG_stg_val               :std_ulogic_vector(0 to 5);
signal wayG_stg_val_b             :std_ulogic_vector(0 to 5);
signal rel_wayG_later_stg_pri     :std_ulogic_vector(0 to 5);
signal rel_wayG_early_stg_pri     :std_ulogic_vector(0 to 5);
signal rel_wayG_stg_val           :std_ulogic_vector(0 to 5);
signal rel_wayG_stg_val_b         :std_ulogic_vector(0 to 5);
signal wayG_early_sel             :std_ulogic;
signal wayG_late_sel              :std_ulogic;
signal rel_wayG_early_sel         :std_ulogic;
signal rel_wayG_late_sel          :std_ulogic;
signal ex3_wayG_hit               :std_ulogic;
signal rel_lost_watch_wayG_evict   :std_ulogic_vector(0 to 3);
signal ex3_wayG_fxubyp_val_d      :std_ulogic;
signal ex3_wayG_fxubyp_val_q      :std_ulogic;
signal ex4_wayG_fxubyp_val_d      :std_ulogic;
signal ex4_wayG_fxubyp_val_q      :std_ulogic;
signal ex3_wayG_relbyp_val_d      :std_ulogic;
signal ex3_wayG_relbyp_val_q      :std_ulogic;
signal ex4_wayG_relbyp_val_d      :std_ulogic;
signal ex4_wayG_relbyp_val_q      :std_ulogic;
signal ex4_wayG_byp_sel           :std_ulogic_vector(0 to 1);
signal rel24_wayG_fxubyp_val_d    :std_ulogic;
signal rel24_wayG_fxubyp_val_q    :std_ulogic;
signal rel24_wayG_relbyp_val_d    :std_ulogic;
signal rel24_wayG_relbyp_val_q    :std_ulogic;
signal rel24_wayG_byp_sel         :std_ulogic_vector(0 to 1);
signal tagH_hit                   :std_ulogic;
signal tagH_hit_b                 :std_ulogic;
signal arr_wayH_val               :std_ulogic_vector(0 to 5);
signal p0_arr_wayH_rd             :std_ulogic_vector(0 to 5);
signal flush_wayH_d               :std_ulogic_vector(0 to 5);
signal flush_wayH_q               :std_ulogic_vector(0 to 5);
signal rel_wayH_clr               :std_ulogic;
signal rel_wayH_set               :std_ulogic;
signal rel_par_wH_clr             :std_ulogic;
signal wayH_val                   :std_ulogic_vector(0 to 5);
signal wayH_val_b_q               :std_ulogic_vector(0 to 5);
signal wayH_val_b1                :std_ulogic;
signal congr_cl_ex2_wayH_byp      :std_ulogic_vector(1 to 7);
signal congr_cl_ex2_wayH_sel      :std_ulogic_vector(2 to 7);
signal rel_arr_wayH_val           :std_ulogic_vector(0 to 5);
signal p1_arr_wayH_rd             :std_ulogic_vector(0 to 5);
signal rel_wayH_val_b_q           :std_ulogic_vector(0 to 5);
signal rel_wayH_val               :std_ulogic_vector(0 to 5);
signal congr_cl_rel13_wayH_byp    :std_ulogic_vector(1 to 7);
signal congr_cl_rel13_wayH_sel    :std_ulogic_vector(2 to 7);
signal reload_wayH_d              :std_ulogic_vector(0 to 5);
signal reload_wayH_q              :std_ulogic_vector(0 to 5);
signal reload_wayH_data_d         :std_ulogic_vector(0 to 5);
signal reload_wayH_data_q         :std_ulogic_vector(0 to 5);
signal reload_wayH_data2_d        :std_ulogic_vector(0 to 5);
signal reload_wayH_data2_q        :std_ulogic_vector(0 to 5);
signal reload_wayH_upd_d          :std_ulogic;
signal reload_wayH_upd_q          :std_ulogic;
signal reload_wayH_clr            :std_ulogic;
signal reload_wayH_upd2_d         :std_ulogic;
signal reload_wayH_upd2_q         :std_ulogic;
signal reload_wayH_upd3_d         :std_ulogic;
signal reload_wayH_upd3_q         :std_ulogic;
signal reload_wayH                :std_ulogic_vector(0 to 5);
signal binv_wayH_upd_d            :std_ulogic;
signal binv_wayH_upd_q            :std_ulogic;
signal binv_wayH_upd1             :std_ulogic;
signal binv_wayH_upd2_d           :std_ulogic;
signal binv_wayH_upd2_q           :std_ulogic;
signal binv_wayH_upd3_d           :std_ulogic;
signal binv_wayH_upd3_q           :std_ulogic;
signal flush_wayH_data1           :std_ulogic_vector(0 to 5);
signal flush_wayH_data_d          :std_ulogic_vector(0 to 5);
signal flush_wayH_data_q          :std_ulogic_vector(0 to 5);
signal flush_wayH_data2_d         :std_ulogic_vector(0 to 5);
signal flush_wayH_data2_q         :std_ulogic_vector(0 to 5);
signal xu_op_hit_wayH_b           :std_ulogic;
signal xu_op_hit_wayH             :std_ulogic;
signal xu_op_hit_wayH_dly_b       :std_ulogic;
signal clr_val_wayH               :std_ulogic;
signal upd_lck_wayH               :std_ulogic_vector(0 to 1);
signal inval_clr_lck_wH_d         :std_ulogic;
signal inval_clr_lck_wH_q         :std_ulogic;
signal perr_way_det_wayH          :std_ulogic;
signal perr_wayH_watch_lost       :std_ulogic_vector(0 to 3);
signal wayH_watch_value           :std_ulogic;
signal ex4_lost_wayH              :std_ulogic_vector(0 to 3);
signal ex3_xuop_lost_watch_wayH   :std_ulogic;
signal ex3_xuop_wayH_upd          :std_ulogic;
signal ex4_xuop_wayH_upd_d        :std_ulogic;
signal ex4_xuop_wayH_upd_q        :std_ulogic;
signal ex4_wayH_val_d             :std_ulogic_vector(0 to 5);
signal ex4_wayH_val_q             :std_ulogic_vector(0 to 5);
signal rel_wayH_val_stg_d         :std_ulogic_vector(0 to 5);
signal rel_wayH_val_stg_q         :std_ulogic_vector(0 to 5);
signal ex5_xuop_wayH_upd_d        :std_ulogic;
signal ex5_xuop_wayH_upd_q        :std_ulogic;
signal congr_cl_ex3_upd_wayH      :std_ulogic;
signal congr_cl_ex4_upd_wayH      :std_ulogic;
signal congr_cl_ex5_upd_wayH      :std_ulogic;
signal congr_cl_m_upd_wayH_d      :std_ulogic;
signal congr_cl_m_upd_wayH_q      :std_ulogic;
signal ex3_cClass_wayH_hit        :std_ulogic;
signal wayH_later_stg_pri         :std_ulogic_vector(0 to 5);
signal wayH_early_stg_pri         :std_ulogic_vector(0 to 5);
signal wayH_stg_val               :std_ulogic_vector(0 to 5);
signal wayH_stg_val_b             :std_ulogic_vector(0 to 5);
signal rel_wayH_later_stg_pri     :std_ulogic_vector(0 to 5);
signal rel_wayH_early_stg_pri     :std_ulogic_vector(0 to 5);
signal rel_wayH_stg_val           :std_ulogic_vector(0 to 5);
signal rel_wayH_stg_val_b         :std_ulogic_vector(0 to 5);
signal wayH_early_sel             :std_ulogic;
signal wayH_late_sel              :std_ulogic;
signal rel_wayH_early_sel         :std_ulogic;
signal rel_wayH_late_sel          :std_ulogic;
signal ex3_wayH_hit               :std_ulogic;
signal rel_lost_watch_wayH_evict   :std_ulogic_vector(0 to 3);
signal ex3_wayH_fxubyp_val_d      :std_ulogic;
signal ex3_wayH_fxubyp_val_q      :std_ulogic;
signal ex4_wayH_fxubyp_val_d      :std_ulogic;
signal ex4_wayH_fxubyp_val_q      :std_ulogic;
signal ex3_wayH_relbyp_val_d      :std_ulogic;
signal ex3_wayH_relbyp_val_q      :std_ulogic;
signal ex4_wayH_relbyp_val_d      :std_ulogic;
signal ex4_wayH_relbyp_val_q      :std_ulogic;
signal ex4_wayH_byp_sel           :std_ulogic_vector(0 to 1);
signal rel24_wayH_fxubyp_val_d    :std_ulogic;
signal rel24_wayH_fxubyp_val_q    :std_ulogic;
signal rel24_wayH_relbyp_val_d    :std_ulogic;
signal rel24_wayH_relbyp_val_q    :std_ulogic;
signal rel24_wayH_byp_sel         :std_ulogic_vector(0 to 1);
signal stm_upd_watchlost_tid0     :std_ulogic_vector(0 to 1);
signal upd_watch_tid0_wayA    :std_ulogic_vector(0 to 1);
signal upd_watch_tid0_wayB    :std_ulogic_vector(0 to 1);
signal upd_watch_tid0_wayC    :std_ulogic_vector(0 to 1);
signal upd_watch_tid0_wayD    :std_ulogic_vector(0 to 1);
signal upd_watch_tid0_wayE    :std_ulogic_vector(0 to 1);
signal upd_watch_tid0_wayF    :std_ulogic_vector(0 to 1);
signal upd_watch_tid0_wayG    :std_ulogic_vector(0 to 1);
signal upd_watch_tid0_wayH    :std_ulogic_vector(0 to 1);
signal stm_upd_watchlost_tid1     :std_ulogic_vector(0 to 1);
signal upd_watch_tid1_wayA    :std_ulogic_vector(0 to 1);
signal upd_watch_tid1_wayB    :std_ulogic_vector(0 to 1);
signal upd_watch_tid1_wayC    :std_ulogic_vector(0 to 1);
signal upd_watch_tid1_wayD    :std_ulogic_vector(0 to 1);
signal upd_watch_tid1_wayE    :std_ulogic_vector(0 to 1);
signal upd_watch_tid1_wayF    :std_ulogic_vector(0 to 1);
signal upd_watch_tid1_wayG    :std_ulogic_vector(0 to 1);
signal upd_watch_tid1_wayH    :std_ulogic_vector(0 to 1);
signal stm_upd_watchlost_tid2     :std_ulogic_vector(0 to 1);
signal upd_watch_tid2_wayA    :std_ulogic_vector(0 to 1);
signal upd_watch_tid2_wayB    :std_ulogic_vector(0 to 1);
signal upd_watch_tid2_wayC    :std_ulogic_vector(0 to 1);
signal upd_watch_tid2_wayD    :std_ulogic_vector(0 to 1);
signal upd_watch_tid2_wayE    :std_ulogic_vector(0 to 1);
signal upd_watch_tid2_wayF    :std_ulogic_vector(0 to 1);
signal upd_watch_tid2_wayG    :std_ulogic_vector(0 to 1);
signal upd_watch_tid2_wayH    :std_ulogic_vector(0 to 1);
signal stm_upd_watchlost_tid3     :std_ulogic_vector(0 to 1);
signal upd_watch_tid3_wayA    :std_ulogic_vector(0 to 1);
signal upd_watch_tid3_wayB    :std_ulogic_vector(0 to 1);
signal upd_watch_tid3_wayC    :std_ulogic_vector(0 to 1);
signal upd_watch_tid3_wayD    :std_ulogic_vector(0 to 1);
signal upd_watch_tid3_wayE    :std_ulogic_vector(0 to 1);
signal upd_watch_tid3_wayF    :std_ulogic_vector(0 to 1);
signal upd_watch_tid3_wayG    :std_ulogic_vector(0 to 1);
signal upd_watch_tid3_wayH    :std_ulogic_vector(0 to 1);
signal congr_cl_all_act_d       :std_ulogic;
signal congr_cl_all_act_q       :std_ulogic;
signal ex3_flush_cline_d        :std_ulogic;
signal ex3_flush_cline_q        :std_ulogic;
signal congr_cl_ex2_ex3_m       :std_ulogic;
signal congr_cl_ex2_ex4_m       :std_ulogic;
signal congr_cl_ex2_ex5_m       :std_ulogic;
signal congr_cl_ex2_relu_m      :std_ulogic;
signal congr_cl_ex2_relu_s_m    :std_ulogic;
signal congr_cl_ex2_ex3_cmp_d   :std_ulogic;
signal congr_cl_ex2_ex3_cmp_q   :std_ulogic;
signal congr_cl_ex2_ex4_cmp_d   :std_ulogic;
signal congr_cl_ex2_ex4_cmp_q   :std_ulogic;
signal congr_cl_ex2_ex5_cmp_d   :std_ulogic;
signal congr_cl_ex2_ex5_cmp_q   :std_ulogic;
signal congr_cl_ex2_ex6_cmp_d   :std_ulogic;
signal congr_cl_ex2_ex6_cmp_q   :std_ulogic;
signal congr_cl_ex3_ex4_cmp_d   :std_ulogic;
signal congr_cl_ex3_ex4_cmp_q   :std_ulogic;
signal congr_cl_ex3_ex5_cmp_d   :std_ulogic;
signal congr_cl_ex3_ex5_cmp_q   :std_ulogic;
signal congr_cl_ex3_ex6_cmp_d   :std_ulogic;
signal congr_cl_ex3_ex6_cmp_q   :std_ulogic;
signal congr_cl_ex4_ex5_cmp_d   :std_ulogic;
signal congr_cl_ex4_ex5_cmp_q   :std_ulogic;
signal congr_cl_ex4_ex6_cmp_d   :std_ulogic;
signal congr_cl_ex4_ex6_cmp_q   :std_ulogic;
signal congr_cl_ex4_ex7_cmp_d   :std_ulogic;
signal congr_cl_ex4_ex7_cmp_q   :std_ulogic;
signal congr_cl_ex2_p0_cmp      :std_ulogic;
signal congr_cl_ex2_relu_cmp_d  :std_ulogic;
signal congr_cl_ex2_relu_cmp_q  :std_ulogic;
signal congr_cl_ex2_relu_s_cmp_d :std_ulogic;
signal congr_cl_ex2_relu_s_cmp_q :std_ulogic;
signal congr_cl_ex2_rel_upd_cmp_d :std_ulogic;
signal congr_cl_ex2_rel_upd_cmp_q :std_ulogic;
signal congr_cl_ex2_p1_cmp      :std_ulogic;
signal ex4_congr_cl_d           :std_ulogic_vector(2 to 7);
signal ex4_congr_cl_q           :std_ulogic_vector(2 to 7);
signal ex5_congr_cl_d           :std_ulogic_vector(2 to 7);
signal ex5_congr_cl_q           :std_ulogic_vector(2 to 7);
signal ex6_congr_cl_d           :std_ulogic_vector(2 to 7);
signal ex6_congr_cl_q           :std_ulogic_vector(2 to 7);
signal ex7_congr_cl_d           :std_ulogic_vector(2 to 7);
signal ex7_congr_cl_q           :std_ulogic_vector(2 to 7);
signal ex8_congr_cl_d           :std_ulogic_vector(2 to 7);
signal ex8_congr_cl_q           :std_ulogic_vector(2 to 7);
signal ex9_congr_cl_d           :std_ulogic_vector(2 to 7);
signal ex9_congr_cl_q           :std_ulogic_vector(2 to 7);
signal rel_early_congr_cl       :std_ulogic_vector(2 to 7);
signal rel_congr_cl_d           :std_ulogic_vector(2 to 7);
signal rel_congr_cl_q           :std_ulogic_vector(2 to 7);
signal rel_val_stg1             :std_ulogic;
signal rel_val_stg2_d           :std_ulogic;
signal rel_val_stg2_q           :std_ulogic;
signal rel_val_clr_d            :std_ulogic;
signal rel_val_clr_q            :std_ulogic;
signal rel_val_stg3             :std_ulogic;
signal rel_val_stg4             :std_ulogic;
signal rel_val_stg4_d           :std_ulogic;
signal rel_val_stg4_q           :std_ulogic;
signal rel_binv_stg4_d          :std_ulogic;
signal rel_binv_stg4_q          :std_ulogic;
signal back_inval_stg2          :std_ulogic;
signal back_inval_stg3_d        :std_ulogic;
signal back_inval_stg3_q        :std_ulogic;
signal back_inval_stg4_d        :std_ulogic;
signal back_inval_stg4_q        :std_ulogic;
signal back_inval_stg5_d        :std_ulogic;
signal back_inval_stg5_q        :std_ulogic;
signal ex1_congr_cl             :std_ulogic_vector(2 to 7);
signal ex2_congr_cl_d           :std_ulogic_vector(2 to 7);
signal ex2_congr_cl_q           :std_ulogic_vector(2 to 7);
signal ex3_congr_cl_d           :std_ulogic_vector(2 to 7);
signal ex3_congr_cl_q           :std_ulogic_vector(2 to 7);
signal rel24_congr_cl_d         :std_ulogic_vector(2 to 7);
signal rel24_congr_cl_q         :std_ulogic_vector(2 to 7);
signal p0_wren_d                :std_ulogic;
signal p0_wren_q                :std_ulogic;
signal p0_wren_cpy_d            :std_ulogic;
signal p0_wren_cpy_q            :std_ulogic;
signal p0_wren_stg_d            :std_ulogic;
signal p0_wren_stg_q            :std_ulogic;
signal p1_wren_d                :std_ulogic;
signal p1_wren_q                :std_ulogic;
signal p1_wren_cpy_d            :std_ulogic;
signal p1_wren_cpy_q            :std_ulogic;
signal congr_cl_rel13_ex3_m     :std_ulogic;
signal congr_cl_rel13_ex4_m     :std_ulogic;
signal congr_cl_rel13_ex5_m     :std_ulogic;
signal congr_cl_rel13_relu_m    :std_ulogic;
signal congr_cl_rel13_relu_s_m  :std_ulogic;
signal congr_cl_rel13_ex3_cmp_d :std_ulogic;
signal congr_cl_rel13_ex3_cmp_q :std_ulogic;
signal congr_cl_rel13_ex4_cmp_d :std_ulogic;
signal congr_cl_rel13_ex4_cmp_q :std_ulogic;
signal congr_cl_rel13_ex5_cmp_d :std_ulogic;
signal congr_cl_rel13_ex5_cmp_q :std_ulogic;
signal congr_cl_rel13_ex6_cmp_d :std_ulogic;
signal congr_cl_rel13_ex6_cmp_q :std_ulogic;
signal congr_cl_rel13_p0_cmp    :std_ulogic;
signal congr_cl_rel13_relu_cmp_d    :std_ulogic;
signal congr_cl_rel13_relu_cmp_q    :std_ulogic;
signal congr_cl_rel13_relu_s_cmp_d  :std_ulogic;
signal congr_cl_rel13_relu_s_cmp_q  :std_ulogic;
signal congr_cl_rel13_rel_upd_cmp_d :std_ulogic;
signal congr_cl_rel13_rel_upd_cmp_q :std_ulogic;
signal congr_cl_rel13_p1_cmp    :std_ulogic;
signal ex3_c_acc                :std_ulogic;
signal fxu_pipe_val             :std_ulogic;
signal rel_set_val              :std_ulogic;
signal ex3_store_instr_d        :std_ulogic;
signal ex3_store_instr_q        :std_ulogic;
signal ex3_lock_set_d           :std_ulogic;
signal ex3_lock_set_q           :std_ulogic;
signal ex4_lock_set_d           :std_ulogic;
signal ex4_lock_set_q           :std_ulogic;
signal ex5_lock_set_d           :std_ulogic;
signal ex5_lock_set_q           :std_ulogic;
signal ex3_lock_clr_d           :std_ulogic;
signal ex3_lock_clr_q           :std_ulogic;
signal clr_val                  :std_ulogic;
signal clr_lock                 :std_ulogic;
signal rel_val_set              :std_ulogic;
signal rel_lock_set_d           :std_ulogic;
signal rel_lock_set_q           :std_ulogic;
signal rel_l1dump_cslc_d        :std_ulogic;
signal rel_l1dump_cslc_q        :std_ulogic;
signal rel_no_ovr_lock          :std_ulogic;
signal rel_lock_lost            :std_ulogic;
signal ex3_xuop_val             :std_ulogic;
signal ex3_xuop_val_d           :std_ulogic;
signal ex3_xuop_val_q           :std_ulogic;
signal ex4_xuop_val             :std_ulogic;
signal ex4_xuop_val_d           :std_ulogic;
signal ex4_xuop_val_q           :std_ulogic;
signal ex5_xuop_val             :std_ulogic;
signal ex5_xuop_val_d           :std_ulogic;
signal ex5_xuop_val_q           :std_ulogic;
signal ex4_l_fld_b1_d           :std_ulogic;
signal ex4_l_fld_b1_q           :std_ulogic;
signal rel_in_progress          :std_ulogic;
signal rel_in_progress_d        :std_ulogic;
signal rel_in_progress_q        :std_ulogic;
signal ex4_miss_q               :std_ulogic;
signal ex4_way_hit_d            :std_ulogic_vector(0 to 7);
signal ex4_way_hit_q            :std_ulogic_vector(0 to 7);
signal ex5_way_hit_d            :std_ulogic_vector(0 to 7);
signal ex5_way_hit_q            :std_ulogic_vector(0 to 7);
signal ex6_way_hit_d            :std_ulogic_vector(0 to 7);
signal ex6_way_hit_q            :std_ulogic_vector(0 to 7);
signal ex7_way_hit_d            :std_ulogic_vector(0 to 7);
signal ex7_way_hit_q            :std_ulogic_vector(0 to 7);
signal ex8_way_hit_d            :std_ulogic_vector(0 to 7);
signal ex8_way_hit_q            :std_ulogic_vector(0 to 7);
signal ex9_way_hit_d            :std_ulogic_vector(0 to 7);
signal ex9_way_hit_q            :std_ulogic_vector(0 to 7);
signal dcpar_err_congr_cl       :std_ulogic_vector(2 to 7);
signal dcpar_err_stg1_d         :std_ulogic;
signal dcpar_err_stg1_q         :std_ulogic;
signal dcpar_err_stg2_d         :std_ulogic;
signal dcpar_err_stg2_q         :std_ulogic;
signal dcpar_err_way_d          :std_ulogic_vector(0 to 7);
signal dcpar_err_way_q          :std_ulogic_vector(0 to 7);
signal dcpar_err_way_inval_d    :std_ulogic_vector(0 to 7);
signal dcpar_err_way_inval_q    :std_ulogic_vector(0 to 7);
signal dcpar_err_cntr_d         :std_ulogic_vector(0 to 1);
signal dcpar_err_cntr_q         :std_ulogic_vector(0 to 1);
signal dcpar_err_push           :std_ulogic;
signal dcpar_err_rec_cmpl       :std_ulogic;
signal dcpar_err_nxt_rec        :std_ulogic;
signal dcpar_err_push_queue     :std_ulogic;
signal dcpar_err_ind_sel        :std_ulogic_vector(0 to 1);
signal dcpar_err_incr_val       :std_ulogic;
signal dcpar_err_cntr_sel       :std_ulogic_vector(0 to 1);
signal dcpar_err_nxt_cntr       :std_ulogic_vector(0 to 1);
signal dcpar_err_rec_inprog     :std_ulogic;
signal dcpar_err_ind_sel_d      :std_ulogic_vector(0 to 1);
signal dcpar_err_ind_sel_q      :std_ulogic_vector(0 to 1);
signal dcpar_err_push_queue_d   :std_ulogic;
signal dcpar_err_push_queue_q   :std_ulogic;
signal lock_finval              :std_ulogic;
signal inval_clr_lck            :std_ulogic;
signal xucr0_cslc_xuop_d        :std_ulogic;
signal xucr0_cslc_xuop_q        :std_ulogic;
signal xucr0_cslc_binv_d        :std_ulogic;
signal xucr0_cslc_binv_q        :std_ulogic;
signal dci_compl_d              :std_ulogic;
signal dci_compl_q              :std_ulogic;
signal dci_inval_all_d          :std_ulogic;
signal dci_inval_all_q          :std_ulogic;
signal inv2_val_d               :std_ulogic;
signal inv2_val_q               :std_ulogic;
signal perf_binv_hit            :std_ulogic;
signal perf_lsu_evnts_d         :std_ulogic_vector(0 to 4);
signal perf_lsu_evnts_q         :std_ulogic_vector(0 to 4);
signal lock_flash_clear_d       :std_ulogic;
signal lock_flash_clear_q       :std_ulogic;
signal lock_flash_clear_val_d   :std_ulogic;
signal lock_flash_clear_val_q   :std_ulogic;
signal rel_port_upd_d           :std_ulogic;
signal rel_port_upd_q           :std_ulogic;
signal p1_upd_val               :std_ulogic;
signal rel_port_wren_d          :std_ulogic;
signal rel_port_wren_q          :std_ulogic;
signal ex2_thrd_id_d            :std_ulogic_vector(0 to 3);
signal ex2_thrd_id_q            :std_ulogic_vector(0 to 3);
signal ex3_thrd_id_d            :std_ulogic_vector(0 to 3);
signal ex3_thrd_id_q            :std_ulogic_vector(0 to 3);
signal ex4_thrd_id_d            :std_ulogic_vector(0 to 3);
signal ex4_thrd_id_q            :std_ulogic_vector(0 to 3);
signal ex5_thrd_id_d            :std_ulogic_vector(0 to 3);
signal ex5_thrd_id_q            :std_ulogic_vector(0 to 3);
signal ex3_watch_set_d          :std_ulogic;
signal ex3_watch_set_q          :std_ulogic;
signal ex4_watch_set_d          :std_ulogic;
signal ex4_watch_set_q          :std_ulogic;
signal ex5_watch_set_d          :std_ulogic;
signal ex5_watch_set_q          :std_ulogic;
signal ex3_watch_clr_d          :std_ulogic;
signal ex3_watch_clr_q          :std_ulogic;
signal ex2_watch_clr_all        :std_ulogic;
signal ex2_watch_clr_one        :std_ulogic;
signal ex3_watch_clr_all_d      :std_ulogic;
signal ex3_watch_clr_all_q      :std_ulogic;
signal ex3_watch_clr_all        :std_ulogic_vector(0 to 3);
signal ex4_watch_clr_all_d      :std_ulogic_vector(0 to 3);
signal ex4_watch_clr_all_q      :std_ulogic_vector(0 to 3);
signal ex5_watch_clr_all_d      :std_ulogic_vector(0 to 3);
signal ex5_watch_clr_all_q      :std_ulogic_vector(0 to 3);
signal ex6_watch_clr_all_d      :std_ulogic_vector(0 to 3);
signal ex6_watch_clr_all_q      :std_ulogic_vector(0 to 3);
signal ex5_watch_clr_all_val_d  :std_ulogic;
signal ex5_watch_clr_all_val_q  :std_ulogic;
signal rel_watch_set_d          :std_ulogic;
signal rel_watch_set_q          :std_ulogic;
signal rel_thrd_id_d            :std_ulogic_vector(0 to 3);
signal rel_thrd_id_q            :std_ulogic_vector(0 to 3);
signal rel_watch_lost           :std_ulogic_vector(0 to 3);
signal lose_watch               :std_ulogic_vector(0 to 3);
signal ex4_lose_watch_d         :std_ulogic_vector(0 to 3);
signal ex4_lose_watch_q         :std_ulogic_vector(0 to 3);
signal clr_watch                :std_ulogic_vector(0 to 3);
signal set_watch                :std_ulogic_vector(0 to 3);
signal ex4_curr_watch           :std_ulogic;
signal stm_watchlost_sel        :std_ulogic;
signal ex5_cr_watch_d           :std_ulogic;
signal ex5_cr_watch_q           :std_ulogic;
signal ex4_lost_watch           :std_ulogic_vector(0 to 3);
signal ex4_lost_watch_upd       :std_ulogic_vector(0 to 3);
signal ex5_lost_watch_upd_d     :std_ulogic_vector(0 to 3);
signal ex5_lost_watch_upd_q     :std_ulogic_vector(0 to 3);
signal ex4_watchlost_set_d      :std_ulogic_vector(0 to 3);
signal ex4_watchlost_set_q      :std_ulogic_vector(0 to 3);
signal ex5_watchlost_set_d      :std_ulogic_vector(0 to 3);
signal ex5_watchlost_set_q      :std_ulogic_vector(0 to 3);
signal rel_lost_watch_binv_d    :std_ulogic_vector(0 to 3);
signal rel_lost_watch_binv_q    :std_ulogic_vector(0 to 3);
signal rel_lost_watch_upd_d     :std_ulogic_vector(0 to 3);
signal rel_lost_watch_upd_q     :std_ulogic_vector(0 to 3);
signal rel_lost_watch_evict     :std_ulogic_vector(0 to 3);
signal rel_lost_watch_evict_np  :std_ulogic_vector(0 to 3);
signal lost_watch_evict_ovl_d   :std_ulogic_vector(0 to 3);
signal lost_watch_evict_ovl_q   :std_ulogic_vector(0 to 3);
signal lost_watch_binv          :std_ulogic_vector(0 to 3);
signal lost_watch_inter_thrd_d  :std_ulogic_vector(0 to 3);
signal lost_watch_inter_thrd_q  :std_ulogic_vector(0 to 3);
signal stm_watchlost            :std_ulogic_vector(0 to 3);
signal rel_watchlost_upd        :std_ulogic_vector(0 to 3);
signal ex5_watchlost_upd        :std_ulogic_vector(0 to 3);
signal stm_watchlost_state_d    :std_ulogic_vector(0 to 3);
signal stm_watchlost_state_q    :std_ulogic_vector(0 to 3);
signal ex5_xuop_p0_upd_d        :std_ulogic;
signal ex5_xuop_p0_upd_q        :std_ulogic;
signal rel_val_stg24            :std_ulogic;
signal rel_val_stgu_d           :std_ulogic;
signal rel_val_stgu_q           :std_ulogic;
signal relu_congr_cl_d          :std_ulogic_vector(2 to 7);
signal relu_congr_cl_q          :std_ulogic_vector(2 to 7);
signal relu_s_congr_cl_d        :std_ulogic_vector(2 to 7);
signal relu_s_congr_cl_q        :std_ulogic_vector(2 to 7);
signal ex3_thrd_m_d             :std_ulogic;
signal ex3_thrd_m_q             :std_ulogic;
signal ex4_thrd_m_d             :std_ulogic;
signal ex4_thrd_m_q             :std_ulogic;
signal ex5_thrd_m_d             :std_ulogic;
signal ex5_thrd_m_q             :std_ulogic;
signal ex6_thrd_m_d             :std_ulogic;
signal ex6_thrd_m_q             :std_ulogic;
signal ex7_ld_par_err_d         :std_ulogic;
signal ex7_ld_par_err_q         :std_ulogic;
signal ex8_ld_par_err_d         :std_ulogic;
signal ex8_ld_par_err_q         :std_ulogic;
signal ex9_ld_par_err_d         :std_ulogic;
signal ex9_ld_par_err_q         :std_ulogic;
signal ex6_ld_valid_d           :std_ulogic;
signal ex6_ld_valid_q           :std_ulogic;
signal ex7_ld_valid_d           :std_ulogic;
signal ex7_ld_valid_q           :std_ulogic;
signal ex8_ld_valid_d           :std_ulogic;
signal ex8_ld_valid_q           :std_ulogic;
signal ex9_ld_valid_d           :std_ulogic;
signal ex9_ld_valid_q           :std_ulogic;
signal inj_dir_multihit_b       :std_ulogic;
signal inj_dir_multihit_d       :std_ulogic;
signal inj_dir_multihit_q       :std_ulogic;
signal binv1_ex1_stg_act        :std_ulogic;
signal binv2_ex2_stg_act        :std_ulogic;
signal binv3_ex3_stg_act        :std_ulogic;
signal binv4_ex4_stg_act        :std_ulogic;
signal binv5_ex5_stg_act        :std_ulogic;
signal binv2_ex2_val_stg_act    :std_ulogic;
signal binv3_ex3_val_stg_act    :std_ulogic;
signal binv4_ex4_val_stg_act    :std_ulogic;
signal binv5_ex5_val_stg_act    :std_ulogic;
signal dcpar_err_stg1_act_d     :std_ulogic;
signal dcpar_err_stg1_act_q     :std_ulogic;
signal dcpar_err_stg2_act_d     :std_ulogic;
signal dcpar_err_stg2_act_q     :std_ulogic;
signal rel1_perr_stg_act        :std_ulogic;
signal rel2_perr_stg_act        :std_ulogic;
signal rel3_perr_stg_act_d      :std_ulogic;
signal rel3_perr_stg_act_q      :std_ulogic;
signal rel4_perr_stg_act_d      :std_ulogic;
signal rel4_perr_stg_act_q      :std_ulogic;
signal reload_way_clr_d         :std_ulogic_vector(0 to 7);
signal reload_way_clr_q         :std_ulogic_vector(0 to 7);
signal ex4_watchSet_coll_d      :std_ulogic;
signal ex4_watchSet_coll_q      :std_ulogic;
signal watchSet_rel_way_coll    :std_ulogic_vector(0 to 7);
signal watchSet_rel_coll_val    :std_ulogic_vector(0 to 3);
signal rel24_congr_cl_ex4_cmp_d :std_ulogic;
signal rel24_congr_cl_ex4_cmp_q :std_ulogic;
signal rel24_congr_cl_ex5_cmp_d :std_ulogic;
signal rel24_congr_cl_ex5_cmp_q :std_ulogic;
signal rel24_congr_cl_ex6_cmp_d :std_ulogic;
signal rel24_congr_cl_ex6_cmp_q :std_ulogic;
signal relu_congr_cl_ex5_cmp_d  :std_ulogic;
signal relu_congr_cl_ex5_cmp_q  :std_ulogic;
signal relu_congr_cl_ex6_cmp_d  :std_ulogic;
signal relu_congr_cl_ex6_cmp_q  :std_ulogic;
signal relu_congr_cl_ex7_cmp_d  :std_ulogic;
signal relu_congr_cl_ex7_cmp_q  :std_ulogic;
signal rel_ex5_watchSet_coll    :std_ulogic;
signal rel_ex6_watchSet_coll    :std_ulogic;
signal rel_ex7_watchSet_coll    :std_ulogic;
signal rel_coll_val             :std_ulogic;
signal relu_dir_data            :std_ulogic_vector(2 to 5);
signal rel_pri_byp_sel          :std_ulogic_vector(0 to 2);
signal rel_byp_dir_data         :std_ulogic_vector(2 to 5);
signal rel_watchSet_coll_tid    :std_ulogic_vector(0 to 3);
signal lost_watch_evict_val_d   :std_ulogic_vector(0 to 3);
signal lost_watch_evict_val_q   :std_ulogic_vector(0 to 3);
signal dcpar_err_lock_lost      :std_ulogic_vector(0 to 7);
signal dirpar_err_lock_lost     :std_ulogic_vector(0 to 7);
signal ex3_dir_perr_val         :std_ulogic;
signal ex3_dir_multihit_val     :std_ulogic;
signal ex4_dir_err_val_d        :std_ulogic;
signal ex4_dir_err_val_q        :std_ulogic;
signal ex5_dir_err_val_d        :std_ulogic;
signal ex5_dir_err_val_q        :std_ulogic;
signal ex6_dir_err_val_d        :std_ulogic;
signal ex6_dir_err_val_q        :std_ulogic;
signal derr2_stg_act_d          :std_ulogic;
signal derr2_stg_act_q          :std_ulogic;
signal derr3_stg_act_d          :std_ulogic;
signal derr3_stg_act_q          :std_ulogic;
signal derr4_stg_act_d          :std_ulogic;
signal derr4_stg_act_q          :std_ulogic;
signal derr5_stg_act_d          :std_ulogic;
signal derr5_stg_act_q          :std_ulogic;
signal ex4_err_det_way_d        :std_ulogic_vector(0 to 7);
signal ex4_err_det_way_q        :std_ulogic_vector(0 to 7);
signal ex4_perr_lck_lost_d      :std_ulogic;
signal ex4_perr_lck_lost_q      :std_ulogic;
signal ex4_perr_watch_lost_d    :std_ulogic_vector(0 to 3);
signal ex4_perr_watch_lost_q    :std_ulogic_vector(0 to 3);
signal dcperr_lock_lost_d       :std_ulogic;
signal dcperr_lock_lost_q       :std_ulogic;
signal ex4_dir_multihit_val_b_q :std_ulogic;
signal ex4_dir_multihit_val     :std_ulogic;
signal binv4_ex4_lock_set       :std_ulogic;
signal binv4_ex4_thrd_watch     :std_ulogic_vector(0 to 3);
signal ex4_multihit_watch_lost  :std_ulogic_vector(0 to 3);
signal ex4_multihit_lock_lost   :std_ulogic;
signal ex3_watch_chk_d          :std_ulogic;
signal ex3_watch_chk_q          :std_ulogic;
signal ex4_watch_chk_d          :std_ulogic;
signal ex4_watch_chk_q          :std_ulogic;
signal ex5_watch_chk_d          :std_ulogic;
signal ex5_watch_chk_q          :std_ulogic;
signal ex5_watch_chk_cplt       :std_ulogic;
signal ex5_watch_chk_succ       :std_ulogic;
signal ex5_watch_dup_set        :std_ulogic;
signal hit_and_01_b             :std_ulogic;
signal hit_and_23_b             :std_ulogic;
signal hit_and_45_b             :std_ulogic;
signal hit_and_67_b             :std_ulogic;
signal hit_or_01_b              :std_ulogic;
signal hit_or_23_b              :std_ulogic;
signal hit_or_45_b              :std_ulogic;
signal hit_or_67_b              :std_ulogic;
signal hit_or_13_b              :std_ulogic;
signal hit_or_57_b              :std_ulogic;
signal hit_or_0123              :std_ulogic;
signal hit_or_4567              :std_ulogic;
signal hit_or_1357              :std_ulogic;
signal hit_or_2367              :std_ulogic;
signal hit_and_0123             :std_ulogic;
signal hit_and_4567             :std_ulogic;
signal multi_hit_err2_0         :std_ulogic;
signal multi_hit_err2_1         :std_ulogic;
signal hit_or_01234567_b        :std_ulogic;
signal ex3_dir_multihit_val_0   :std_ulogic;
signal ex3_dir_multihit_val_1   :std_ulogic;
signal ex3_dir_multihit_val_b   :std_ulogic;
signal multi_hit_err3_b         :std_ulogic_vector(0 to 2);
signal hit_enc_b                :std_ulogic_vector(0 to 2);
signal ex3_l_fld_b1_d           :std_ulogic;
signal ex3_l_fld_b1_q           :std_ulogic;
signal binv4_ex4_way_upd        :std_ulogic_vector(0 to 7);
signal binv5_ex5_way_upd        :std_ulogic_vector(0 to 7);
signal binv6_ex6_way_upd        :std_ulogic_vector(0 to 7);
signal binv7_ex7_way_upd_d      :std_ulogic_vector(0 to 7);
signal binv7_ex7_way_upd_q      :std_ulogic_vector(0 to 7);
signal binv4_ex4_dir_data       :std_ulogic_vector(1 to 5);
signal binv5_ex5_dir_data_d     :std_ulogic_vector(1 to 5);
signal binv5_ex5_dir_data_q     :std_ulogic_vector(1 to 5);
signal binv6_ex6_dir_data_d     :std_ulogic_vector(1 to 5);
signal binv6_ex6_dir_data_q     :std_ulogic_vector(1 to 5);
signal binv7_ex7_dir_data_d     :std_ulogic_vector(1 to 5);
signal binv7_ex7_dir_data_q     :std_ulogic_vector(1 to 5);
signal binv4_inval_lck          :std_ulogic;
signal binv4_inval_watch        :std_ulogic_vector(0 to 3);
signal binv4_coll_val           :std_ulogic;
signal binv4_ex5_coll           :std_ulogic;
signal binv4_ex6_coll           :std_ulogic;
signal binv4_ex7_coll           :std_ulogic;
signal binv4_pri_byp_sel        :std_ulogic_vector(0 to 2);
signal binv4_byp_dir_data       :std_ulogic_vector(1 to 5);
signal binv5_inval_lock_val_d   :std_ulogic;
signal binv5_inval_lock_val_q   :std_ulogic;
signal binv5_inval_watch_val_d  :std_ulogic_vector(0 to 3);
signal binv5_inval_watch_val_q  :std_ulogic_vector(0 to 3);
signal binv5_ex5_lost_watch_upd :std_ulogic_vector(0 to 3);
signal dci_watch_lost           :std_ulogic_vector(0 to 3);
signal ex3_xuop_upd_dir         :std_ulogic;
signal binv3_ex3_xuop_upd       :std_ulogic;
signal binv4_ex4_xuop_upd_d     :std_ulogic;
signal binv4_ex4_xuop_upd_q     :std_ulogic;
signal ex3_dir_acc_val          :std_ulogic;
signal binv3_ex3_dir_val        :std_ulogic;
signal binv4_ex4_dir_val_d      :std_ulogic;
signal binv4_ex4_dir_val_q      :std_ulogic;
signal ex3_l1hit                :std_ulogic;
signal ex3_l1miss               :std_ulogic;
signal ex4_snd_ld_l2_q          :std_ulogic;
signal ex4_ldq_full_flush_b_q   :std_ulogic;
signal rel_in_prog_stg1_d       :std_ulogic;
signal rel_in_prog_stg1_q       :std_ulogic;
signal rel_in_prog_stg2_d       :std_ulogic;
signal rel_in_prog_stg2_q       :std_ulogic;
signal rel_in_prog_stg3_d       :std_ulogic;
signal rel_in_prog_stg3_q       :std_ulogic;
signal rel_in_prog_stg4_d       :std_ulogic;
signal rel_in_prog_stg4_q       :std_ulogic;
signal rel_in_prog_stg5_d       :std_ulogic;
signal rel_in_prog_stg5_q       :std_ulogic;
signal ex4_instr_enc_d          :std_ulogic_vector(0 to 3);
signal ex4_instr_enc_q          :std_ulogic_vector(0 to 3);
signal ex4_wclr_all_val_d       :std_ulogic;
signal ex4_wclr_all_val_q       :std_ulogic;
signal ex5_wclr_all_val_d       :std_ulogic;
signal ex5_wclr_all_val_q       :std_ulogic;
signal ex6_wclr_all_val_d       :std_ulogic;
signal ex6_wclr_all_val_q       :std_ulogic;
signal ex3_wclr_all_upd_val     :std_ulogic;
signal ex4_wclr_all_upd_val     :std_ulogic;
signal ex5_wclr_all_upd_val     :std_ulogic;
signal ex6_wclr_all_upd_val     :std_ulogic;
signal ex3_wclr_all_upd_d       :std_ulogic;
signal ex3_wclr_all_upd_q       :std_ulogic;
signal ex4_n_lsu_ddmh_flush_b_d :std_ulogic_vector(0 to 3);
signal ex4_n_lsu_ddmh_flush_b_q :std_ulogic_vector(0 to 3);
signal ex3_xuop_up_addr_b       :std_ulogic_vector(0 to 2);
signal rel_dcarr_addr_sel       :std_ulogic_vector(0 to 2);
signal rel_dcarr_addr_sel_b     :std_ulogic_vector(0 to 2);
signal dcarr_up_way_addr_q      :std_ulogic_vector(0 to 2);
signal rel4_l1dump_val_q        :std_ulogic;
signal rel4_l1dump_watch        :std_ulogic;
signal lost_watch_l1dump        :std_ulogic_vector(0 to 3);
signal my_lclk                  :clk_logic;
signal my_d1clk                 :std_ulogic;
signal my_d2clk                 :std_ulogic;
signal my_multihit_lclk         :clk_logic;
signal my_multihit_d1clk        :std_ulogic;
signal my_multihit_d2clk        :std_ulogic;
signal my_ddmh_lclk             :clk_logic;
signal my_ddmh_d1clk            :std_ulogic;
signal my_ddmh_d2clk            :std_ulogic;
signal ex4_miss_siv             :std_ulogic;
signal ex4_miss_sov             :std_ulogic;
signal my_spare0_lclk           :clk_logic;
signal my_spare0_d1clk          :std_ulogic;
signal my_spare0_d2clk          :std_ulogic;
signal my_spare0_latches_d      :std_ulogic_vector(0 to 16);
signal my_spare0_latches_q      :std_ulogic_vector(0 to 16);
signal my_spare1_lclk           :clk_logic;
signal my_spare1_d1clk          :std_ulogic;
signal my_spare1_d2clk          :std_ulogic;
signal my_spare1_latches_d      :std_ulogic_vector(0 to 15);
signal my_spare1_latches_q      :std_ulogic_vector(0 to 15);
signal tiup                     :std_ulogic;
signal siv                      :std_ulogic_vector(0 to scan_right);
signal sov                      :std_ulogic_vector(0 to scan_right);
  BEGIN --@@ START OF EXECUTABLE CODE FOR XUQ_LSU_DIR_VAL32

tiup  <=  '1';
inv2_val_d       <=  inv1_val and not spr_xucr0_dcdis;
back_inval_stg2  <=  inv2_val_q;
rel_val_stg1     <=  rel1_val;
rel_val_stg3     <=  rel3_val;
rel_set_val      <=  rel4_set_val;
lock_flash_clear_d      <=  xu_lsu_spr_xucr0_clfc;
lock_flash_clear_val_d  <=  lock_flash_clear_q;
dci_compl_d             <=  xu_lsu_dci;
dci_inval_all_d         <=  dci_compl_q;
lock_finval             <=  dci_inval_all_q or lock_flash_clear_val_q;
inj_dir_multihit_d      <=  pc_xu_inj_dcachedir_multihit;
ex3_l_fld_b1_d          <=  ex2_l_fld(1);
tagA_hit        <=  ex3_way_cmp_a;
rel_wayA_clr    <=  rel_way_clr_a;
rel_wayA_set    <=  rel_way_wen_a;
tagB_hit        <=  ex3_way_cmp_b;
rel_wayB_clr    <=  rel_way_clr_b;
rel_wayB_set    <=  rel_way_wen_b;
tagC_hit        <=  ex3_way_cmp_c;
rel_wayC_clr    <=  rel_way_clr_c;
rel_wayC_set    <=  rel_way_wen_c;
tagD_hit        <=  ex3_way_cmp_d;
rel_wayD_clr    <=  rel_way_clr_d;
rel_wayD_set    <=  rel_way_wen_d;
tagE_hit        <=  ex3_way_cmp_e;
rel_wayE_clr    <=  rel_way_clr_e;
rel_wayE_set    <=  rel_way_wen_e;
tagF_hit        <=  ex3_way_cmp_f;
rel_wayF_clr    <=  rel_way_clr_f;
rel_wayF_set    <=  rel_way_wen_f;
tagG_hit        <=  ex3_way_cmp_g;
rel_wayG_clr    <=  rel_way_clr_g;
rel_wayG_set    <=  rel_way_wen_g;
tagH_hit        <=  ex3_way_cmp_h;
rel_wayH_clr    <=  rel_way_clr_h;
rel_wayH_set    <=  rel_way_wen_h;
ex3_c_acc  <=  ex3_cache_en;
-- ####################################################
-- Stage ACT Pipes
-- ####################################################
binv1_ex1_stg_act      <=  binv1_stg_act or ex1_stg_act;
binv2_ex2_stg_act      <=  binv2_stg_act or ex2_stg_act;
binv3_ex3_stg_act      <=  binv3_stg_act or ex3_stg_act;
binv4_ex4_stg_act      <=  binv4_stg_act or ex4_stg_act;
binv5_ex5_stg_act      <=  binv5_stg_act or ex5_stg_act;
binv2_ex2_val_stg_act  <=  derr2_stg_act_q or binv2_stg_act or ex2_stg_act;
binv3_ex3_val_stg_act  <=  derr3_stg_act_q or binv3_stg_act or ex3_stg_act;
binv4_ex4_val_stg_act  <=  derr4_stg_act_q or binv4_stg_act or ex4_stg_act;
binv5_ex5_val_stg_act  <=  derr5_stg_act_q or binv5_stg_act or ex5_stg_act;
rel1_perr_stg_act      <=  rel1_stg_act  or dcpar_err_stg1_act_q;
rel2_perr_stg_act      <=  rel2_stg_act  or dcpar_err_stg2_act_q;
rel3_perr_stg_act_d    <=  rel2_perr_stg_act;
rel4_perr_stg_act_d    <=  rel3_perr_stg_act_q;
-- ####################################################
-- Dcache Number of Cachelines Configurations
-- ####################################################
-- EX2 Stage
ex1_congr_cl        <=  ex1_p_addr;
cl64size : if (cl_size=6) generate
begin
      rel_early_congr_cl(2 TO 6) <=  rel_addr_early(64-(dc_size-3) to 63-cl_size-1);
rel_early_congr_cl(7) <=  rel_addr_early(63-cl_size) or spr_xucr0_cls;
end generate cl64size;
cl32size : if (cl_size=5) generate
begin
      rel_early_congr_cl(2 TO 5) <=  rel_addr_early(64-(dc_size-3) to 63-cl_size-2);
rel_early_congr_cl(6) <=  rel_addr_early(63-cl_size-1) or spr_xucr0_cls;
rel_early_congr_cl(7) <=  rel_addr_early(63-cl_size);
end generate cl32size;
-- ####################################################
-- Congruence Class Address Select
-- Port0 => Execution Pipe or Back-Invalidate
-- Port1 => Reload or DC Parity Error Recovery
-- ####################################################
-- Port0
-- = '1' => Select Back-Invalidate
-- = '0' => Select Execution Op
ex2_congr_cl_d  <=  ex1_congr_cl;
ex3_congr_cl_d  <=  ex2_congr_cl_q;
ex4_congr_cl_d  <=  ex3_congr_cl_q;
ex5_congr_cl_d  <=  ex4_congr_cl_q;
ex6_congr_cl_d  <=  ex5_congr_cl_q;
-- Port1
-- = '1' => Select DC Parity Error Recovery
-- = '0' => Select Reload
with rel_in_progress select
    rel_congr_cl_d  <=  rel_early_congr_cl when '1',
                      dcpar_err_congr_cl when others;
-- Reload Invalidate Stages
rel_val_stg2_d  <=  rel_val_stg1;
rel_val_clr_d   <=  rel_val_stg2_q or dcpar_err_stg2_q;
-- Reload Validate Stages
rel_val_stg4_d  <=  rel_val_stg3;
rel_val_stg4    <=  rel_val_stg4_q and not rel4_recirc_val;
rel_val_set     <=  rel_val_stg4 and rel_set_val;
-- Reload Back-Invalidated
rel_binv_stg4_d  <=  rel_back_inval;
-- Reload Lock Cache-Line
rel_lock_set_d  <=  rel_lock_en;
rel_l1dump_cslc_d  <=  rel_l1dump_cslc;
-- Reload Lost Lock due to Back-Invalidate of loadmissQ entry
rel_no_ovr_lock  <=  rel_wayA_set or rel_wayB_set or rel_wayC_set or rel_wayD_set or
                   rel_wayE_set or rel_wayF_set or rel_wayG_set or rel_wayH_set;
rel_lock_lost    <=  rel_lock_set_q and rel_val_stg4 and rel_no_ovr_lock and rel_binv_stg4_q and not rel_set_val;
-- Reload Watch Cache-Line
rel_watch_set_d  <=  rel_watch_en;
rel_thrd_id_d    <=  rel_thrd_id;
-- Reload Lost Watch due to Back-Invalidate of loadmissQ entry
rel_watch_lost  <=  gate(rel_thrd_id_q, (rel_watch_set_q and rel_val_stg4 and rel_binv_stg4_q and not rel_set_val));
-- Reload Port is updated when a Reload is invalidating a line, a Reload is setting a line, or Parity Error Recovery
rel_val_stg24    <=  rel_val_stg2_q or rel_val_set or dcpar_err_stg2_q;
rel_val_stgu_d   <=  rel_val_stg24;
rel_port_wren_d  <=  rel_val_stgu_q;
rel_port_upd_d   <=  rel_val_stgu_q;
rel_in_prog_stg1_d  <=  ldq_rel1_early_v or ldq_rel3_early_v;
rel_in_prog_stg2_d  <=  rel_in_prog_stg1_q;
rel_in_prog_stg3_d  <=  rel_in_prog_stg2_q;
rel_in_prog_stg4_d  <=  rel_in_prog_stg3_q;
rel_in_prog_stg5_d  <=  rel_in_prog_stg4_q;
-- Used to block Parity Recovery
rel_in_progress  <=  ldq_rel1_early_v   or ldq_rel3_early_v   or rel_in_prog_stg1_q or rel_in_prog_stg2_q or
                   rel_in_prog_stg3_q or rel_in_prog_stg4_q or rel_in_prog_stg5_q;
rel_in_progress_d  <=  rel_in_progress;
-- Back-Invalidate Stages
back_inval_stg3_d  <=  back_inval_stg2;
back_inval_stg4_d  <=  back_inval_stg3_q;
back_inval_stg5_d  <=  back_inval_stg4_q;
-- EX1 STAGE
ex2_thrd_id_d  <=  ex1_thrd_id;
-- EX2 STAGE
ex3_store_instr_d    <=  ex2_store_instr and not ex2_stg_flush;
ex3_flush_cline_d    <=  ex2_is_inval_op and not ex2_stg_flush;
ex3_lock_set_d       <=  ex2_lock_set and not ex2_stg_flush;
ex4_lock_set_d       <=  ex3_lock_set_q and not ex3_stg_flush;
ex5_lock_set_d       <=  ex4_lock_set_q and not ex4_stg_flush;
ex3_lock_clr_d       <=  ex2_lock_clr and not ex2_stg_flush;
ex3_thrd_id_d        <=  ex2_thrd_id_q;
ex3_watch_set_d      <=  ex2_ldawx_instr and not ex2_stg_flush;
ex3_watch_clr_d      <=  ex2_wclr_instr and not ex2_stg_flush;
ex2_watch_clr_all    <=  ex2_wclr_instr and not ex2_l_fld(0);
ex2_watch_clr_one    <=  ex2_wclr_instr and ex2_l_fld(0);
ex3_watch_clr_all_d  <=  ex2_watch_clr_all and not ex2_stg_flush;
ex3_watch_chk_d      <=  ex2_wchk_val and not ex2_stg_flush;
ex3_xuop_val_d       <=  (ex2_lock_clr or ex2_lock_set or ex2_ldawx_instr or ex2_watch_clr_one or ex2_store_instr) and not ex2_stg_flush;
-- EX3 STAGE
ex4_l_fld_b1_d       <=  ex3_l_fld_b1_q;
ex3_watch_clr_all    <=  gate(ex3_thrd_id_q, ex3_watch_clr_all_q);
ex4_wclr_all_val_d   <=  ex3_watch_clr_all_q and not ex3_stg_flush;
ex5_wclr_all_val_d   <=  ex4_wclr_all_val_q  and not ex4_stg_flush;
ex6_wclr_all_val_d   <=  ex5_wclr_all_val_q  and not ex5_stg_flush;
ex3_xuop_val         <=  ((ex3_xuop_val_q and ex3_c_acc) or ex3_flush_cline_q) and not spr_xucr0_dcdis;
ex4_xuop_val_d       <=  (ex3_xuop_val or ex3_watch_clr_all_q) and not ex3_stg_flush;
ex4_watch_clr_all_d  <=  gate(ex3_watch_clr_all, (not (ex3_stg_flush or spr_xucr0_dcdis)));
ex4_watch_chk_d      <=  ex3_watch_chk_q and not ex3_stg_flush;
ex4_watch_set_d      <=  ex3_watch_set_q and not ex3_stg_flush;
ex5_watch_set_d      <=  ex4_watch_set_q and not ex4_stg_flush;
ex3_xuop_upd_dir     <=  ex3_flush_cline_q or ex3_lock_clr_q or ex3_lock_set_q or ex3_watch_set_q or ex3_watch_clr_q;
binv3_ex3_xuop_upd   <=  back_inval_stg3_q or ex3_xuop_val;
binv4_ex4_xuop_upd_d  <=  binv3_ex3_xuop_upd or ((ex3_xuop_val or ex3_watch_clr_all_q) and not ex3_stg_flush);
ex3_dir_acc_val      <=  ex3_cache_acc and not ex3_watch_clr_all_q;
binv3_ex3_dir_val    <=  back_inval_stg3_q or  ex3_dir_acc_val;
binv4_ex4_dir_val_d  <=  back_inval_stg3_q or (ex3_dir_acc_val and not ex3_stg_flush);
ex4_instr_enc_d(0) <=  ex3_watch_clr_q;
ex4_instr_enc_d(1) <=  back_inval_stg3_q or ex3_lock_set_q    or ex3_lock_clr_q    or ex3_watch_set_q;
ex4_instr_enc_d(2) <=  back_inval_stg3_q or ex3_store_instr_q or ex3_watch_set_q;
ex4_instr_enc_d(3) <=  back_inval_stg3_q or ex3_lock_clr_q    or ex3_flush_cline_q or ex3_watch_clr_all_q;
-- EX4 STAGE
ex4_xuop_val        <=  ex4_xuop_val_q and not ex4_stg_flush;
ex4_thrd_id_d       <=  ex3_thrd_id_q;
-- EX5 STAGE
ex5_xuop_val_d        <=  ex4_xuop_val;
ex5_xuop_val          <=  ex5_xuop_val_q and not ex5_stg_flush;
ex5_xuop_p0_upd_d     <=  ex4_xuop_val;
ex5_watch_chk_d       <=  ex4_watch_chk_q and not ex4_stg_flush;
ex5_thrd_id_d         <=  ex4_thrd_id_q;
-- Reload Congruence Class
rel24_congr_cl_d    <=  rel_congr_cl_q;
relu_congr_cl_d     <=  rel24_congr_cl_q;
relu_s_congr_cl_d   <=  relu_congr_cl_q;
-- Load Hit Valid
ex6_ld_valid_d  <=  ex5_load_op_hit and not ex5_stg_flush;
-- ####################################################
-- Execution Directory Read
-- ####################################################
-- Execution Path Directory Valid and Line Lock Bits Muxing
-- Select Congruence Class Way A
with ex2_congr_cl_q select
    arr_wayA_val    <= 
                    congr_cl0_wA_q     when "000000",
                    congr_cl1_wA_q     when "000001",
                    congr_cl2_wA_q     when "000010",
                    congr_cl3_wA_q     when "000011",
                    congr_cl4_wA_q     when "000100",
                    congr_cl5_wA_q     when "000101",
                    congr_cl6_wA_q     when "000110",
                    congr_cl7_wA_q     when "000111",
                    congr_cl8_wA_q     when "001000",
                    congr_cl9_wA_q     when "001001",
                    congr_cl10_wA_q    when "001010",
                    congr_cl11_wA_q    when "001011",
                    congr_cl12_wA_q    when "001100",
                    congr_cl13_wA_q    when "001101",
                    congr_cl14_wA_q    when "001110",
                    congr_cl15_wA_q    when "001111",
                    congr_cl16_wA_q    when "010000",
                    congr_cl17_wA_q    when "010001",
                    congr_cl18_wA_q    when "010010",
                    congr_cl19_wA_q    when "010011",
                    congr_cl20_wA_q    when "010100",
                    congr_cl21_wA_q    when "010101",
                    congr_cl22_wA_q    when "010110",
                    congr_cl23_wA_q    when "010111",
                    congr_cl24_wA_q    when "011000",
                    congr_cl25_wA_q    when "011001",
                    congr_cl26_wA_q    when "011010",
                    congr_cl27_wA_q    when "011011",
                    congr_cl28_wA_q    when "011100",
                    congr_cl29_wA_q    when "011101",
                    congr_cl30_wA_q    when "011110",
                    congr_cl31_wA_q    when "011111",
                    congr_cl32_wA_q    when "100000",
                    congr_cl33_wA_q    when "100001",
                    congr_cl34_wA_q    when "100010",
                    congr_cl35_wA_q    when "100011",
                    congr_cl36_wA_q    when "100100",
                    congr_cl37_wA_q    when "100101",
                    congr_cl38_wA_q    when "100110",
                    congr_cl39_wA_q    when "100111",
                    congr_cl40_wA_q    when "101000",
                    congr_cl41_wA_q    when "101001",
                    congr_cl42_wA_q    when "101010",
                    congr_cl43_wA_q    when "101011",
                    congr_cl44_wA_q    when "101100",
                    congr_cl45_wA_q    when "101101",
                    congr_cl46_wA_q    when "101110",
                    congr_cl47_wA_q    when "101111",
                    congr_cl48_wA_q    when "110000",
                    congr_cl49_wA_q    when "110001",
                    congr_cl50_wA_q    when "110010",
                    congr_cl51_wA_q    when "110011",
                    congr_cl52_wA_q    when "110100",
                    congr_cl53_wA_q    when "110101",
                    congr_cl54_wA_q    when "110110",
                    congr_cl55_wA_q    when "110111",
                    congr_cl56_wA_q    when "111000",
                    congr_cl57_wA_q    when "111001",
                    congr_cl58_wA_q    when "111010",
                    congr_cl59_wA_q    when "111011",
                    congr_cl60_wA_q    when "111100",
                    congr_cl61_wA_q    when "111101",
                    congr_cl62_wA_q    when "111110",
                    congr_cl63_wA_q   when others;
p0_arr_wayA_rd     <=  arr_wayA_val;
-- Select Congruence Class Way B
with ex2_congr_cl_q select
    arr_wayB_val    <= 
                    congr_cl0_wB_q     when "000000",
                    congr_cl1_wB_q     when "000001",
                    congr_cl2_wB_q     when "000010",
                    congr_cl3_wB_q     when "000011",
                    congr_cl4_wB_q     when "000100",
                    congr_cl5_wB_q     when "000101",
                    congr_cl6_wB_q     when "000110",
                    congr_cl7_wB_q     when "000111",
                    congr_cl8_wB_q     when "001000",
                    congr_cl9_wB_q     when "001001",
                    congr_cl10_wB_q    when "001010",
                    congr_cl11_wB_q    when "001011",
                    congr_cl12_wB_q    when "001100",
                    congr_cl13_wB_q    when "001101",
                    congr_cl14_wB_q    when "001110",
                    congr_cl15_wB_q    when "001111",
                    congr_cl16_wB_q    when "010000",
                    congr_cl17_wB_q    when "010001",
                    congr_cl18_wB_q    when "010010",
                    congr_cl19_wB_q    when "010011",
                    congr_cl20_wB_q    when "010100",
                    congr_cl21_wB_q    when "010101",
                    congr_cl22_wB_q    when "010110",
                    congr_cl23_wB_q    when "010111",
                    congr_cl24_wB_q    when "011000",
                    congr_cl25_wB_q    when "011001",
                    congr_cl26_wB_q    when "011010",
                    congr_cl27_wB_q    when "011011",
                    congr_cl28_wB_q    when "011100",
                    congr_cl29_wB_q    when "011101",
                    congr_cl30_wB_q    when "011110",
                    congr_cl31_wB_q    when "011111",
                    congr_cl32_wB_q    when "100000",
                    congr_cl33_wB_q    when "100001",
                    congr_cl34_wB_q    when "100010",
                    congr_cl35_wB_q    when "100011",
                    congr_cl36_wB_q    when "100100",
                    congr_cl37_wB_q    when "100101",
                    congr_cl38_wB_q    when "100110",
                    congr_cl39_wB_q    when "100111",
                    congr_cl40_wB_q    when "101000",
                    congr_cl41_wB_q    when "101001",
                    congr_cl42_wB_q    when "101010",
                    congr_cl43_wB_q    when "101011",
                    congr_cl44_wB_q    when "101100",
                    congr_cl45_wB_q    when "101101",
                    congr_cl46_wB_q    when "101110",
                    congr_cl47_wB_q    when "101111",
                    congr_cl48_wB_q    when "110000",
                    congr_cl49_wB_q    when "110001",
                    congr_cl50_wB_q    when "110010",
                    congr_cl51_wB_q    when "110011",
                    congr_cl52_wB_q    when "110100",
                    congr_cl53_wB_q    when "110101",
                    congr_cl54_wB_q    when "110110",
                    congr_cl55_wB_q    when "110111",
                    congr_cl56_wB_q    when "111000",
                    congr_cl57_wB_q    when "111001",
                    congr_cl58_wB_q    when "111010",
                    congr_cl59_wB_q    when "111011",
                    congr_cl60_wB_q    when "111100",
                    congr_cl61_wB_q    when "111101",
                    congr_cl62_wB_q    when "111110",
                    congr_cl63_wB_q   when others;
p0_arr_wayB_rd     <=  arr_wayB_val;
-- Select Congruence Class Way C
with ex2_congr_cl_q select
    arr_wayC_val    <= 
                    congr_cl0_wC_q     when "000000",
                    congr_cl1_wC_q     when "000001",
                    congr_cl2_wC_q     when "000010",
                    congr_cl3_wC_q     when "000011",
                    congr_cl4_wC_q     when "000100",
                    congr_cl5_wC_q     when "000101",
                    congr_cl6_wC_q     when "000110",
                    congr_cl7_wC_q     when "000111",
                    congr_cl8_wC_q     when "001000",
                    congr_cl9_wC_q     when "001001",
                    congr_cl10_wC_q    when "001010",
                    congr_cl11_wC_q    when "001011",
                    congr_cl12_wC_q    when "001100",
                    congr_cl13_wC_q    when "001101",
                    congr_cl14_wC_q    when "001110",
                    congr_cl15_wC_q    when "001111",
                    congr_cl16_wC_q    when "010000",
                    congr_cl17_wC_q    when "010001",
                    congr_cl18_wC_q    when "010010",
                    congr_cl19_wC_q    when "010011",
                    congr_cl20_wC_q    when "010100",
                    congr_cl21_wC_q    when "010101",
                    congr_cl22_wC_q    when "010110",
                    congr_cl23_wC_q    when "010111",
                    congr_cl24_wC_q    when "011000",
                    congr_cl25_wC_q    when "011001",
                    congr_cl26_wC_q    when "011010",
                    congr_cl27_wC_q    when "011011",
                    congr_cl28_wC_q    when "011100",
                    congr_cl29_wC_q    when "011101",
                    congr_cl30_wC_q    when "011110",
                    congr_cl31_wC_q    when "011111",
                    congr_cl32_wC_q    when "100000",
                    congr_cl33_wC_q    when "100001",
                    congr_cl34_wC_q    when "100010",
                    congr_cl35_wC_q    when "100011",
                    congr_cl36_wC_q    when "100100",
                    congr_cl37_wC_q    when "100101",
                    congr_cl38_wC_q    when "100110",
                    congr_cl39_wC_q    when "100111",
                    congr_cl40_wC_q    when "101000",
                    congr_cl41_wC_q    when "101001",
                    congr_cl42_wC_q    when "101010",
                    congr_cl43_wC_q    when "101011",
                    congr_cl44_wC_q    when "101100",
                    congr_cl45_wC_q    when "101101",
                    congr_cl46_wC_q    when "101110",
                    congr_cl47_wC_q    when "101111",
                    congr_cl48_wC_q    when "110000",
                    congr_cl49_wC_q    when "110001",
                    congr_cl50_wC_q    when "110010",
                    congr_cl51_wC_q    when "110011",
                    congr_cl52_wC_q    when "110100",
                    congr_cl53_wC_q    when "110101",
                    congr_cl54_wC_q    when "110110",
                    congr_cl55_wC_q    when "110111",
                    congr_cl56_wC_q    when "111000",
                    congr_cl57_wC_q    when "111001",
                    congr_cl58_wC_q    when "111010",
                    congr_cl59_wC_q    when "111011",
                    congr_cl60_wC_q    when "111100",
                    congr_cl61_wC_q    when "111101",
                    congr_cl62_wC_q    when "111110",
                    congr_cl63_wC_q   when others;
p0_arr_wayC_rd     <=  arr_wayC_val;
-- Select Congruence Class Way D
with ex2_congr_cl_q select
    arr_wayD_val    <= 
                    congr_cl0_wD_q     when "000000",
                    congr_cl1_wD_q     when "000001",
                    congr_cl2_wD_q     when "000010",
                    congr_cl3_wD_q     when "000011",
                    congr_cl4_wD_q     when "000100",
                    congr_cl5_wD_q     when "000101",
                    congr_cl6_wD_q     when "000110",
                    congr_cl7_wD_q     when "000111",
                    congr_cl8_wD_q     when "001000",
                    congr_cl9_wD_q     when "001001",
                    congr_cl10_wD_q    when "001010",
                    congr_cl11_wD_q    when "001011",
                    congr_cl12_wD_q    when "001100",
                    congr_cl13_wD_q    when "001101",
                    congr_cl14_wD_q    when "001110",
                    congr_cl15_wD_q    when "001111",
                    congr_cl16_wD_q    when "010000",
                    congr_cl17_wD_q    when "010001",
                    congr_cl18_wD_q    when "010010",
                    congr_cl19_wD_q    when "010011",
                    congr_cl20_wD_q    when "010100",
                    congr_cl21_wD_q    when "010101",
                    congr_cl22_wD_q    when "010110",
                    congr_cl23_wD_q    when "010111",
                    congr_cl24_wD_q    when "011000",
                    congr_cl25_wD_q    when "011001",
                    congr_cl26_wD_q    when "011010",
                    congr_cl27_wD_q    when "011011",
                    congr_cl28_wD_q    when "011100",
                    congr_cl29_wD_q    when "011101",
                    congr_cl30_wD_q    when "011110",
                    congr_cl31_wD_q    when "011111",
                    congr_cl32_wD_q    when "100000",
                    congr_cl33_wD_q    when "100001",
                    congr_cl34_wD_q    when "100010",
                    congr_cl35_wD_q    when "100011",
                    congr_cl36_wD_q    when "100100",
                    congr_cl37_wD_q    when "100101",
                    congr_cl38_wD_q    when "100110",
                    congr_cl39_wD_q    when "100111",
                    congr_cl40_wD_q    when "101000",
                    congr_cl41_wD_q    when "101001",
                    congr_cl42_wD_q    when "101010",
                    congr_cl43_wD_q    when "101011",
                    congr_cl44_wD_q    when "101100",
                    congr_cl45_wD_q    when "101101",
                    congr_cl46_wD_q    when "101110",
                    congr_cl47_wD_q    when "101111",
                    congr_cl48_wD_q    when "110000",
                    congr_cl49_wD_q    when "110001",
                    congr_cl50_wD_q    when "110010",
                    congr_cl51_wD_q    when "110011",
                    congr_cl52_wD_q    when "110100",
                    congr_cl53_wD_q    when "110101",
                    congr_cl54_wD_q    when "110110",
                    congr_cl55_wD_q    when "110111",
                    congr_cl56_wD_q    when "111000",
                    congr_cl57_wD_q    when "111001",
                    congr_cl58_wD_q    when "111010",
                    congr_cl59_wD_q    when "111011",
                    congr_cl60_wD_q    when "111100",
                    congr_cl61_wD_q    when "111101",
                    congr_cl62_wD_q    when "111110",
                    congr_cl63_wD_q   when others;
p0_arr_wayD_rd     <=  arr_wayD_val;
-- Select Congruence Class Way E
with ex2_congr_cl_q select
    arr_wayE_val    <= 
                    congr_cl0_wE_q     when "000000",
                    congr_cl1_wE_q     when "000001",
                    congr_cl2_wE_q     when "000010",
                    congr_cl3_wE_q     when "000011",
                    congr_cl4_wE_q     when "000100",
                    congr_cl5_wE_q     when "000101",
                    congr_cl6_wE_q     when "000110",
                    congr_cl7_wE_q     when "000111",
                    congr_cl8_wE_q     when "001000",
                    congr_cl9_wE_q     when "001001",
                    congr_cl10_wE_q    when "001010",
                    congr_cl11_wE_q    when "001011",
                    congr_cl12_wE_q    when "001100",
                    congr_cl13_wE_q    when "001101",
                    congr_cl14_wE_q    when "001110",
                    congr_cl15_wE_q    when "001111",
                    congr_cl16_wE_q    when "010000",
                    congr_cl17_wE_q    when "010001",
                    congr_cl18_wE_q    when "010010",
                    congr_cl19_wE_q    when "010011",
                    congr_cl20_wE_q    when "010100",
                    congr_cl21_wE_q    when "010101",
                    congr_cl22_wE_q    when "010110",
                    congr_cl23_wE_q    when "010111",
                    congr_cl24_wE_q    when "011000",
                    congr_cl25_wE_q    when "011001",
                    congr_cl26_wE_q    when "011010",
                    congr_cl27_wE_q    when "011011",
                    congr_cl28_wE_q    when "011100",
                    congr_cl29_wE_q    when "011101",
                    congr_cl30_wE_q    when "011110",
                    congr_cl31_wE_q    when "011111",
                    congr_cl32_wE_q    when "100000",
                    congr_cl33_wE_q    when "100001",
                    congr_cl34_wE_q    when "100010",
                    congr_cl35_wE_q    when "100011",
                    congr_cl36_wE_q    when "100100",
                    congr_cl37_wE_q    when "100101",
                    congr_cl38_wE_q    when "100110",
                    congr_cl39_wE_q    when "100111",
                    congr_cl40_wE_q    when "101000",
                    congr_cl41_wE_q    when "101001",
                    congr_cl42_wE_q    when "101010",
                    congr_cl43_wE_q    when "101011",
                    congr_cl44_wE_q    when "101100",
                    congr_cl45_wE_q    when "101101",
                    congr_cl46_wE_q    when "101110",
                    congr_cl47_wE_q    when "101111",
                    congr_cl48_wE_q    when "110000",
                    congr_cl49_wE_q    when "110001",
                    congr_cl50_wE_q    when "110010",
                    congr_cl51_wE_q    when "110011",
                    congr_cl52_wE_q    when "110100",
                    congr_cl53_wE_q    when "110101",
                    congr_cl54_wE_q    when "110110",
                    congr_cl55_wE_q    when "110111",
                    congr_cl56_wE_q    when "111000",
                    congr_cl57_wE_q    when "111001",
                    congr_cl58_wE_q    when "111010",
                    congr_cl59_wE_q    when "111011",
                    congr_cl60_wE_q    when "111100",
                    congr_cl61_wE_q    when "111101",
                    congr_cl62_wE_q    when "111110",
                    congr_cl63_wE_q   when others;
p0_arr_wayE_rd     <=  arr_wayE_val;
-- Select Congruence Class Way F
with ex2_congr_cl_q select
    arr_wayF_val    <= 
                    congr_cl0_wF_q     when "000000",
                    congr_cl1_wF_q     when "000001",
                    congr_cl2_wF_q     when "000010",
                    congr_cl3_wF_q     when "000011",
                    congr_cl4_wF_q     when "000100",
                    congr_cl5_wF_q     when "000101",
                    congr_cl6_wF_q     when "000110",
                    congr_cl7_wF_q     when "000111",
                    congr_cl8_wF_q     when "001000",
                    congr_cl9_wF_q     when "001001",
                    congr_cl10_wF_q    when "001010",
                    congr_cl11_wF_q    when "001011",
                    congr_cl12_wF_q    when "001100",
                    congr_cl13_wF_q    when "001101",
                    congr_cl14_wF_q    when "001110",
                    congr_cl15_wF_q    when "001111",
                    congr_cl16_wF_q    when "010000",
                    congr_cl17_wF_q    when "010001",
                    congr_cl18_wF_q    when "010010",
                    congr_cl19_wF_q    when "010011",
                    congr_cl20_wF_q    when "010100",
                    congr_cl21_wF_q    when "010101",
                    congr_cl22_wF_q    when "010110",
                    congr_cl23_wF_q    when "010111",
                    congr_cl24_wF_q    when "011000",
                    congr_cl25_wF_q    when "011001",
                    congr_cl26_wF_q    when "011010",
                    congr_cl27_wF_q    when "011011",
                    congr_cl28_wF_q    when "011100",
                    congr_cl29_wF_q    when "011101",
                    congr_cl30_wF_q    when "011110",
                    congr_cl31_wF_q    when "011111",
                    congr_cl32_wF_q    when "100000",
                    congr_cl33_wF_q    when "100001",
                    congr_cl34_wF_q    when "100010",
                    congr_cl35_wF_q    when "100011",
                    congr_cl36_wF_q    when "100100",
                    congr_cl37_wF_q    when "100101",
                    congr_cl38_wF_q    when "100110",
                    congr_cl39_wF_q    when "100111",
                    congr_cl40_wF_q    when "101000",
                    congr_cl41_wF_q    when "101001",
                    congr_cl42_wF_q    when "101010",
                    congr_cl43_wF_q    when "101011",
                    congr_cl44_wF_q    when "101100",
                    congr_cl45_wF_q    when "101101",
                    congr_cl46_wF_q    when "101110",
                    congr_cl47_wF_q    when "101111",
                    congr_cl48_wF_q    when "110000",
                    congr_cl49_wF_q    when "110001",
                    congr_cl50_wF_q    when "110010",
                    congr_cl51_wF_q    when "110011",
                    congr_cl52_wF_q    when "110100",
                    congr_cl53_wF_q    when "110101",
                    congr_cl54_wF_q    when "110110",
                    congr_cl55_wF_q    when "110111",
                    congr_cl56_wF_q    when "111000",
                    congr_cl57_wF_q    when "111001",
                    congr_cl58_wF_q    when "111010",
                    congr_cl59_wF_q    when "111011",
                    congr_cl60_wF_q    when "111100",
                    congr_cl61_wF_q    when "111101",
                    congr_cl62_wF_q    when "111110",
                    congr_cl63_wF_q   when others;
p0_arr_wayF_rd     <=  arr_wayF_val;
-- Select Congruence Class Way G
with ex2_congr_cl_q select
    arr_wayG_val    <= 
                    congr_cl0_wG_q     when "000000",
                    congr_cl1_wG_q     when "000001",
                    congr_cl2_wG_q     when "000010",
                    congr_cl3_wG_q     when "000011",
                    congr_cl4_wG_q     when "000100",
                    congr_cl5_wG_q     when "000101",
                    congr_cl6_wG_q     when "000110",
                    congr_cl7_wG_q     when "000111",
                    congr_cl8_wG_q     when "001000",
                    congr_cl9_wG_q     when "001001",
                    congr_cl10_wG_q    when "001010",
                    congr_cl11_wG_q    when "001011",
                    congr_cl12_wG_q    when "001100",
                    congr_cl13_wG_q    when "001101",
                    congr_cl14_wG_q    when "001110",
                    congr_cl15_wG_q    when "001111",
                    congr_cl16_wG_q    when "010000",
                    congr_cl17_wG_q    when "010001",
                    congr_cl18_wG_q    when "010010",
                    congr_cl19_wG_q    when "010011",
                    congr_cl20_wG_q    when "010100",
                    congr_cl21_wG_q    when "010101",
                    congr_cl22_wG_q    when "010110",
                    congr_cl23_wG_q    when "010111",
                    congr_cl24_wG_q    when "011000",
                    congr_cl25_wG_q    when "011001",
                    congr_cl26_wG_q    when "011010",
                    congr_cl27_wG_q    when "011011",
                    congr_cl28_wG_q    when "011100",
                    congr_cl29_wG_q    when "011101",
                    congr_cl30_wG_q    when "011110",
                    congr_cl31_wG_q    when "011111",
                    congr_cl32_wG_q    when "100000",
                    congr_cl33_wG_q    when "100001",
                    congr_cl34_wG_q    when "100010",
                    congr_cl35_wG_q    when "100011",
                    congr_cl36_wG_q    when "100100",
                    congr_cl37_wG_q    when "100101",
                    congr_cl38_wG_q    when "100110",
                    congr_cl39_wG_q    when "100111",
                    congr_cl40_wG_q    when "101000",
                    congr_cl41_wG_q    when "101001",
                    congr_cl42_wG_q    when "101010",
                    congr_cl43_wG_q    when "101011",
                    congr_cl44_wG_q    when "101100",
                    congr_cl45_wG_q    when "101101",
                    congr_cl46_wG_q    when "101110",
                    congr_cl47_wG_q    when "101111",
                    congr_cl48_wG_q    when "110000",
                    congr_cl49_wG_q    when "110001",
                    congr_cl50_wG_q    when "110010",
                    congr_cl51_wG_q    when "110011",
                    congr_cl52_wG_q    when "110100",
                    congr_cl53_wG_q    when "110101",
                    congr_cl54_wG_q    when "110110",
                    congr_cl55_wG_q    when "110111",
                    congr_cl56_wG_q    when "111000",
                    congr_cl57_wG_q    when "111001",
                    congr_cl58_wG_q    when "111010",
                    congr_cl59_wG_q    when "111011",
                    congr_cl60_wG_q    when "111100",
                    congr_cl61_wG_q    when "111101",
                    congr_cl62_wG_q    when "111110",
                    congr_cl63_wG_q   when others;
p0_arr_wayG_rd     <=  arr_wayG_val;
-- Select Congruence Class Way H
with ex2_congr_cl_q select
    arr_wayH_val    <= 
                    congr_cl0_wH_q     when "000000",
                    congr_cl1_wH_q     when "000001",
                    congr_cl2_wH_q     when "000010",
                    congr_cl3_wH_q     when "000011",
                    congr_cl4_wH_q     when "000100",
                    congr_cl5_wH_q     when "000101",
                    congr_cl6_wH_q     when "000110",
                    congr_cl7_wH_q     when "000111",
                    congr_cl8_wH_q     when "001000",
                    congr_cl9_wH_q     when "001001",
                    congr_cl10_wH_q    when "001010",
                    congr_cl11_wH_q    when "001011",
                    congr_cl12_wH_q    when "001100",
                    congr_cl13_wH_q    when "001101",
                    congr_cl14_wH_q    when "001110",
                    congr_cl15_wH_q    when "001111",
                    congr_cl16_wH_q    when "010000",
                    congr_cl17_wH_q    when "010001",
                    congr_cl18_wH_q    when "010010",
                    congr_cl19_wH_q    when "010011",
                    congr_cl20_wH_q    when "010100",
                    congr_cl21_wH_q    when "010101",
                    congr_cl22_wH_q    when "010110",
                    congr_cl23_wH_q    when "010111",
                    congr_cl24_wH_q    when "011000",
                    congr_cl25_wH_q    when "011001",
                    congr_cl26_wH_q    when "011010",
                    congr_cl27_wH_q    when "011011",
                    congr_cl28_wH_q    when "011100",
                    congr_cl29_wH_q    when "011101",
                    congr_cl30_wH_q    when "011110",
                    congr_cl31_wH_q    when "011111",
                    congr_cl32_wH_q    when "100000",
                    congr_cl33_wH_q    when "100001",
                    congr_cl34_wH_q    when "100010",
                    congr_cl35_wH_q    when "100011",
                    congr_cl36_wH_q    when "100100",
                    congr_cl37_wH_q    when "100101",
                    congr_cl38_wH_q    when "100110",
                    congr_cl39_wH_q    when "100111",
                    congr_cl40_wH_q    when "101000",
                    congr_cl41_wH_q    when "101001",
                    congr_cl42_wH_q    when "101010",
                    congr_cl43_wH_q    when "101011",
                    congr_cl44_wH_q    when "101100",
                    congr_cl45_wH_q    when "101101",
                    congr_cl46_wH_q    when "101110",
                    congr_cl47_wH_q    when "101111",
                    congr_cl48_wH_q    when "110000",
                    congr_cl49_wH_q    when "110001",
                    congr_cl50_wH_q    when "110010",
                    congr_cl51_wH_q    when "110011",
                    congr_cl52_wH_q    when "110100",
                    congr_cl53_wH_q    when "110101",
                    congr_cl54_wH_q    when "110110",
                    congr_cl55_wH_q    when "110111",
                    congr_cl56_wH_q    when "111000",
                    congr_cl57_wH_q    when "111001",
                    congr_cl58_wH_q    when "111010",
                    congr_cl59_wH_q    when "111011",
                    congr_cl60_wH_q    when "111100",
                    congr_cl61_wH_q    when "111101",
                    congr_cl62_wH_q    when "111110",
                    congr_cl63_wH_q   when others;
p0_arr_wayH_rd     <=  arr_wayH_val;
-- ####################################################
-- Execution/Back-Invalidate Pipe Bypass
-- ####################################################
-- Determine if there is any updates in later stages to the same congruence class
congr_cl_ex2_ex3_cmp_d      <=  (ex1_congr_cl = ex2_congr_cl_q);
congr_cl_ex2_ex4_cmp_d      <=  (ex1_congr_cl = ex3_congr_cl_q);
congr_cl_ex2_ex5_cmp_d      <=  (ex1_congr_cl = ex4_congr_cl_q);
congr_cl_ex2_ex6_cmp_d      <=  (ex1_congr_cl = ex5_congr_cl_q);
congr_cl_ex2_relu_cmp_d     <=  (ex1_congr_cl = rel24_congr_cl_q);
congr_cl_ex2_relu_s_cmp_d   <=  (ex1_congr_cl = relu_congr_cl_q);
congr_cl_ex2_rel_upd_cmp_d  <=  (ex1_congr_cl = relu_s_congr_cl_q);
congr_cl_ex2_p0_cmp         <=  congr_cl_ex2_ex6_cmp_q and p0_wren_cpy_q;
congr_cl_ex2_p1_cmp         <=  congr_cl_ex2_rel_upd_cmp_q and p1_wren_cpy_q;
-- Determine Bypass from later stages
ex3_thrd_m_d  <=  (ex1_thrd_id = ex2_thrd_id_q);
ex4_thrd_m_d  <=  (ex1_thrd_id = ex3_thrd_id_q);
ex5_thrd_m_d  <=  (ex1_thrd_id = ex4_thrd_id_q);
ex6_thrd_m_d  <=  (ex1_thrd_id = ex5_thrd_id_q);
congr_cl_ex2_ex3_m     <=  congr_cl_ex2_ex3_cmp_q    and ((ex3_xuop_val      and ex3_thrd_m_q) or back_inval_stg3_q) and not inv2_val_q;
congr_cl_ex2_ex4_m     <=  congr_cl_ex2_ex4_cmp_q    and ((ex4_xuop_val_q    and ex4_thrd_m_q) or back_inval_stg4_q) and not inv2_val_q;
congr_cl_ex2_ex5_m     <=  congr_cl_ex2_ex5_cmp_q    and ((ex5_xuop_p0_upd_q and ex5_thrd_m_q) or back_inval_stg5_q) and not inv2_val_q;
congr_cl_ex2_relu_m    <=  congr_cl_ex2_relu_cmp_q   and rel_val_stgu_q;
congr_cl_ex2_relu_s_m  <=  congr_cl_ex2_relu_s_cmp_q and p1_upd_val;
-- WayA   Bypass Calculation
congr_cl_ex2_wayA_byp(1) <=  congr_cl_ex2_ex3_m    and ex3_wayA_hit;
congr_cl_ex2_wayA_byp(2) <=  congr_cl_ex2_relu_m   and reload_wayA_upd_q;
congr_cl_ex2_wayA_byp(3) <=  congr_cl_ex2_ex4_m    and binv_wayA_upd_q;
congr_cl_ex2_wayA_byp(4) <=  congr_cl_ex2_relu_s_m and reload_wayA_upd2_q;
congr_cl_ex2_wayA_byp(5) <=  congr_cl_ex2_ex5_m    and binv_wayA_upd2_q;
congr_cl_ex2_wayA_byp(6) <=  congr_cl_ex2_p1_cmp   and reload_wayA_upd3_q;
congr_cl_ex2_wayA_byp(7) <=  congr_cl_ex2_p0_cmp   and binv_wayA_upd3_q;
-- WayA   Bypass Valid
ex3_wayA_fxubyp_val_d    <=  congr_cl_ex2_wayA_byp(1)   or congr_cl_ex2_wayA_byp(3)   or
                           congr_cl_ex2_wayA_byp(5)   or congr_cl_ex2_wayA_byp(7);
ex3_wayA_relbyp_val_d    <=  congr_cl_ex2_wayA_byp(2)   or congr_cl_ex2_wayA_byp(4)   or
                           congr_cl_ex2_wayA_byp(6);
ex4_wayA_fxubyp_val_d    <=  ex3_wayA_fxubyp_val_q;
ex4_wayA_relbyp_val_d    <=  ex3_wayA_relbyp_val_q;
ex4_wayA_byp_sel         <=  ex4_wayA_fxubyp_val_q   & ex4_wayA_relbyp_val_q;
-- Late Stages Priority Selection
congr_cl_ex2_wayA_sel(2) <=  congr_cl_ex2_wayA_byp(2);
congr_cl_ex2_wayA_sel(3) <=  congr_cl_ex2_wayA_byp(3)   and not congr_cl_ex2_wayA_byp(2);
congr_cl_ex2_wayA_sel(4) <=  congr_cl_ex2_wayA_byp(4)   and not or_reduce(congr_cl_ex2_wayA_byp(2   to 3));
congr_cl_ex2_wayA_sel(5) <=  congr_cl_ex2_wayA_byp(5)   and not or_reduce(congr_cl_ex2_wayA_byp(2   to 4));
congr_cl_ex2_wayA_sel(6) <=  congr_cl_ex2_wayA_byp(6)   and not or_reduce(congr_cl_ex2_wayA_byp(2   to 5));
congr_cl_ex2_wayA_sel(7) <=  congr_cl_ex2_wayA_byp(7)   and not or_reduce(congr_cl_ex2_wayA_byp(2   to 6));
-- ArrayRead/LATE Stage Priority Selection
wayA_late_sel         <=  or_reduce(congr_cl_ex2_wayA_byp(2   to 7));
wayA_later_stg_pri    <=  gate(p0_arr_wayA_rd,        not wayA_late_sel)          or
                        gate(reload_wayA_q,         congr_cl_ex2_wayA_sel(2))   or
                        gate(flush_wayA_q,          congr_cl_ex2_wayA_sel(3))   or
                        gate(reload_wayA_data_q,    congr_cl_ex2_wayA_sel(4))   or
                        gate(flush_wayA_data_q,     congr_cl_ex2_wayA_sel(5))   or
                        gate(reload_wayA_data2_q,   congr_cl_ex2_wayA_sel(6))   or
                        gate(flush_wayA_data2_q,    congr_cl_ex2_wayA_sel(7));
-- EX3/RELU Stage Priority Selection
wayA_early_sel        <=  congr_cl_ex2_wayA_byp(1);
wayA_early_stg_pri    <=  flush_wayA_d;
-- Stage/ARRAY Priority Selection
wayA_stg_val        <=  (others=>(wayA_early_sel));
wayA_stg_val_b      <=  (others=>(not(wayA_early_sel)));
wayA_val(0 TO 1) <=  not wayA_val_b_q(0   to 1);
wayA_val(2 TO 5) <=  not wayA_val_b_q(2   to 5);
wayA_val_b1         <=  not wayA_val(0);
-- WayB   Bypass Calculation
congr_cl_ex2_wayB_byp(1) <=  congr_cl_ex2_ex3_m    and ex3_wayB_hit;
congr_cl_ex2_wayB_byp(2) <=  congr_cl_ex2_relu_m   and reload_wayB_upd_q;
congr_cl_ex2_wayB_byp(3) <=  congr_cl_ex2_ex4_m    and binv_wayB_upd_q;
congr_cl_ex2_wayB_byp(4) <=  congr_cl_ex2_relu_s_m and reload_wayB_upd2_q;
congr_cl_ex2_wayB_byp(5) <=  congr_cl_ex2_ex5_m    and binv_wayB_upd2_q;
congr_cl_ex2_wayB_byp(6) <=  congr_cl_ex2_p1_cmp   and reload_wayB_upd3_q;
congr_cl_ex2_wayB_byp(7) <=  congr_cl_ex2_p0_cmp   and binv_wayB_upd3_q;
-- WayB   Bypass Valid
ex3_wayB_fxubyp_val_d    <=  congr_cl_ex2_wayB_byp(1)   or congr_cl_ex2_wayB_byp(3)   or
                           congr_cl_ex2_wayB_byp(5)   or congr_cl_ex2_wayB_byp(7);
ex3_wayB_relbyp_val_d    <=  congr_cl_ex2_wayB_byp(2)   or congr_cl_ex2_wayB_byp(4)   or
                           congr_cl_ex2_wayB_byp(6);
ex4_wayB_fxubyp_val_d    <=  ex3_wayB_fxubyp_val_q;
ex4_wayB_relbyp_val_d    <=  ex3_wayB_relbyp_val_q;
ex4_wayB_byp_sel         <=  ex4_wayB_fxubyp_val_q   & ex4_wayB_relbyp_val_q;
-- Late Stages Priority Selection
congr_cl_ex2_wayB_sel(2) <=  congr_cl_ex2_wayB_byp(2);
congr_cl_ex2_wayB_sel(3) <=  congr_cl_ex2_wayB_byp(3)   and not congr_cl_ex2_wayB_byp(2);
congr_cl_ex2_wayB_sel(4) <=  congr_cl_ex2_wayB_byp(4)   and not or_reduce(congr_cl_ex2_wayB_byp(2   to 3));
congr_cl_ex2_wayB_sel(5) <=  congr_cl_ex2_wayB_byp(5)   and not or_reduce(congr_cl_ex2_wayB_byp(2   to 4));
congr_cl_ex2_wayB_sel(6) <=  congr_cl_ex2_wayB_byp(6)   and not or_reduce(congr_cl_ex2_wayB_byp(2   to 5));
congr_cl_ex2_wayB_sel(7) <=  congr_cl_ex2_wayB_byp(7)   and not or_reduce(congr_cl_ex2_wayB_byp(2   to 6));
-- ArrayRead/LATE Stage Priority Selection
wayB_late_sel         <=  or_reduce(congr_cl_ex2_wayB_byp(2   to 7));
wayB_later_stg_pri    <=  gate(p0_arr_wayB_rd,        not wayB_late_sel)          or
                        gate(reload_wayB_q,         congr_cl_ex2_wayB_sel(2))   or
                        gate(flush_wayB_q,          congr_cl_ex2_wayB_sel(3))   or
                        gate(reload_wayB_data_q,    congr_cl_ex2_wayB_sel(4))   or
                        gate(flush_wayB_data_q,     congr_cl_ex2_wayB_sel(5))   or
                        gate(reload_wayB_data2_q,   congr_cl_ex2_wayB_sel(6))   or
                        gate(flush_wayB_data2_q,    congr_cl_ex2_wayB_sel(7));
-- EX3/RELU Stage Priority Selection
wayB_early_sel        <=  congr_cl_ex2_wayB_byp(1);
wayB_early_stg_pri    <=  flush_wayB_d;
-- Stage/ARRAY Priority Selection
wayB_stg_val        <=  (others=>(wayB_early_sel));
wayB_stg_val_b      <=  (others=>(not(wayB_early_sel)));
wayB_val(0 TO 1) <=  not wayB_val_b_q(0   to 1);
wayB_val(2 TO 5) <=  not wayB_val_b_q(2   to 5);
wayB_val_b1         <=  not wayB_val(0);
-- WayC   Bypass Calculation
congr_cl_ex2_wayC_byp(1) <=  congr_cl_ex2_ex3_m    and ex3_wayC_hit;
congr_cl_ex2_wayC_byp(2) <=  congr_cl_ex2_relu_m   and reload_wayC_upd_q;
congr_cl_ex2_wayC_byp(3) <=  congr_cl_ex2_ex4_m    and binv_wayC_upd_q;
congr_cl_ex2_wayC_byp(4) <=  congr_cl_ex2_relu_s_m and reload_wayC_upd2_q;
congr_cl_ex2_wayC_byp(5) <=  congr_cl_ex2_ex5_m    and binv_wayC_upd2_q;
congr_cl_ex2_wayC_byp(6) <=  congr_cl_ex2_p1_cmp   and reload_wayC_upd3_q;
congr_cl_ex2_wayC_byp(7) <=  congr_cl_ex2_p0_cmp   and binv_wayC_upd3_q;
-- WayC   Bypass Valid
ex3_wayC_fxubyp_val_d    <=  congr_cl_ex2_wayC_byp(1)   or congr_cl_ex2_wayC_byp(3)   or
                           congr_cl_ex2_wayC_byp(5)   or congr_cl_ex2_wayC_byp(7);
ex3_wayC_relbyp_val_d    <=  congr_cl_ex2_wayC_byp(2)   or congr_cl_ex2_wayC_byp(4)   or
                           congr_cl_ex2_wayC_byp(6);
ex4_wayC_fxubyp_val_d    <=  ex3_wayC_fxubyp_val_q;
ex4_wayC_relbyp_val_d    <=  ex3_wayC_relbyp_val_q;
ex4_wayC_byp_sel         <=  ex4_wayC_fxubyp_val_q   & ex4_wayC_relbyp_val_q;
-- Late Stages Priority Selection
congr_cl_ex2_wayC_sel(2) <=  congr_cl_ex2_wayC_byp(2);
congr_cl_ex2_wayC_sel(3) <=  congr_cl_ex2_wayC_byp(3)   and not congr_cl_ex2_wayC_byp(2);
congr_cl_ex2_wayC_sel(4) <=  congr_cl_ex2_wayC_byp(4)   and not or_reduce(congr_cl_ex2_wayC_byp(2   to 3));
congr_cl_ex2_wayC_sel(5) <=  congr_cl_ex2_wayC_byp(5)   and not or_reduce(congr_cl_ex2_wayC_byp(2   to 4));
congr_cl_ex2_wayC_sel(6) <=  congr_cl_ex2_wayC_byp(6)   and not or_reduce(congr_cl_ex2_wayC_byp(2   to 5));
congr_cl_ex2_wayC_sel(7) <=  congr_cl_ex2_wayC_byp(7)   and not or_reduce(congr_cl_ex2_wayC_byp(2   to 6));
-- ArrayRead/LATE Stage Priority Selection
wayC_late_sel         <=  or_reduce(congr_cl_ex2_wayC_byp(2   to 7));
wayC_later_stg_pri    <=  gate(p0_arr_wayC_rd,        not wayC_late_sel)          or
                        gate(reload_wayC_q,         congr_cl_ex2_wayC_sel(2))   or
                        gate(flush_wayC_q,          congr_cl_ex2_wayC_sel(3))   or
                        gate(reload_wayC_data_q,    congr_cl_ex2_wayC_sel(4))   or
                        gate(flush_wayC_data_q,     congr_cl_ex2_wayC_sel(5))   or
                        gate(reload_wayC_data2_q,   congr_cl_ex2_wayC_sel(6))   or
                        gate(flush_wayC_data2_q,    congr_cl_ex2_wayC_sel(7));
-- EX3/RELU Stage Priority Selection
wayC_early_sel        <=  congr_cl_ex2_wayC_byp(1);
wayC_early_stg_pri    <=  flush_wayC_d;
-- Stage/ARRAY Priority Selection
wayC_stg_val        <=  (others=>(wayC_early_sel));
wayC_stg_val_b      <=  (others=>(not(wayC_early_sel)));
wayC_val(0 TO 1) <=  not wayC_val_b_q(0   to 1);
wayC_val(2 TO 5) <=  not wayC_val_b_q(2   to 5);
wayC_val_b1         <=  not wayC_val(0);
-- WayD   Bypass Calculation
congr_cl_ex2_wayD_byp(1) <=  congr_cl_ex2_ex3_m    and ex3_wayD_hit;
congr_cl_ex2_wayD_byp(2) <=  congr_cl_ex2_relu_m   and reload_wayD_upd_q;
congr_cl_ex2_wayD_byp(3) <=  congr_cl_ex2_ex4_m    and binv_wayD_upd_q;
congr_cl_ex2_wayD_byp(4) <=  congr_cl_ex2_relu_s_m and reload_wayD_upd2_q;
congr_cl_ex2_wayD_byp(5) <=  congr_cl_ex2_ex5_m    and binv_wayD_upd2_q;
congr_cl_ex2_wayD_byp(6) <=  congr_cl_ex2_p1_cmp   and reload_wayD_upd3_q;
congr_cl_ex2_wayD_byp(7) <=  congr_cl_ex2_p0_cmp   and binv_wayD_upd3_q;
-- WayD   Bypass Valid
ex3_wayD_fxubyp_val_d    <=  congr_cl_ex2_wayD_byp(1)   or congr_cl_ex2_wayD_byp(3)   or
                           congr_cl_ex2_wayD_byp(5)   or congr_cl_ex2_wayD_byp(7);
ex3_wayD_relbyp_val_d    <=  congr_cl_ex2_wayD_byp(2)   or congr_cl_ex2_wayD_byp(4)   or
                           congr_cl_ex2_wayD_byp(6);
ex4_wayD_fxubyp_val_d    <=  ex3_wayD_fxubyp_val_q;
ex4_wayD_relbyp_val_d    <=  ex3_wayD_relbyp_val_q;
ex4_wayD_byp_sel         <=  ex4_wayD_fxubyp_val_q   & ex4_wayD_relbyp_val_q;
-- Late Stages Priority Selection
congr_cl_ex2_wayD_sel(2) <=  congr_cl_ex2_wayD_byp(2);
congr_cl_ex2_wayD_sel(3) <=  congr_cl_ex2_wayD_byp(3)   and not congr_cl_ex2_wayD_byp(2);
congr_cl_ex2_wayD_sel(4) <=  congr_cl_ex2_wayD_byp(4)   and not or_reduce(congr_cl_ex2_wayD_byp(2   to 3));
congr_cl_ex2_wayD_sel(5) <=  congr_cl_ex2_wayD_byp(5)   and not or_reduce(congr_cl_ex2_wayD_byp(2   to 4));
congr_cl_ex2_wayD_sel(6) <=  congr_cl_ex2_wayD_byp(6)   and not or_reduce(congr_cl_ex2_wayD_byp(2   to 5));
congr_cl_ex2_wayD_sel(7) <=  congr_cl_ex2_wayD_byp(7)   and not or_reduce(congr_cl_ex2_wayD_byp(2   to 6));
-- ArrayRead/LATE Stage Priority Selection
wayD_late_sel         <=  or_reduce(congr_cl_ex2_wayD_byp(2   to 7));
wayD_later_stg_pri    <=  gate(p0_arr_wayD_rd,        not wayD_late_sel)          or
                        gate(reload_wayD_q,         congr_cl_ex2_wayD_sel(2))   or
                        gate(flush_wayD_q,          congr_cl_ex2_wayD_sel(3))   or
                        gate(reload_wayD_data_q,    congr_cl_ex2_wayD_sel(4))   or
                        gate(flush_wayD_data_q,     congr_cl_ex2_wayD_sel(5))   or
                        gate(reload_wayD_data2_q,   congr_cl_ex2_wayD_sel(6))   or
                        gate(flush_wayD_data2_q,    congr_cl_ex2_wayD_sel(7));
-- EX3/RELU Stage Priority Selection
wayD_early_sel        <=  congr_cl_ex2_wayD_byp(1);
wayD_early_stg_pri    <=  flush_wayD_d;
-- Stage/ARRAY Priority Selection
wayD_stg_val        <=  (others=>(wayD_early_sel));
wayD_stg_val_b      <=  (others=>(not(wayD_early_sel)));
wayD_val(0 TO 1) <=  not wayD_val_b_q(0   to 1);
wayD_val(2 TO 5) <=  not wayD_val_b_q(2   to 5);
wayD_val_b1         <=  not wayD_val(0);
-- WayE   Bypass Calculation
congr_cl_ex2_wayE_byp(1) <=  congr_cl_ex2_ex3_m    and ex3_wayE_hit;
congr_cl_ex2_wayE_byp(2) <=  congr_cl_ex2_relu_m   and reload_wayE_upd_q;
congr_cl_ex2_wayE_byp(3) <=  congr_cl_ex2_ex4_m    and binv_wayE_upd_q;
congr_cl_ex2_wayE_byp(4) <=  congr_cl_ex2_relu_s_m and reload_wayE_upd2_q;
congr_cl_ex2_wayE_byp(5) <=  congr_cl_ex2_ex5_m    and binv_wayE_upd2_q;
congr_cl_ex2_wayE_byp(6) <=  congr_cl_ex2_p1_cmp   and reload_wayE_upd3_q;
congr_cl_ex2_wayE_byp(7) <=  congr_cl_ex2_p0_cmp   and binv_wayE_upd3_q;
-- WayE   Bypass Valid
ex3_wayE_fxubyp_val_d    <=  congr_cl_ex2_wayE_byp(1)   or congr_cl_ex2_wayE_byp(3)   or
                           congr_cl_ex2_wayE_byp(5)   or congr_cl_ex2_wayE_byp(7);
ex3_wayE_relbyp_val_d    <=  congr_cl_ex2_wayE_byp(2)   or congr_cl_ex2_wayE_byp(4)   or
                           congr_cl_ex2_wayE_byp(6);
ex4_wayE_fxubyp_val_d    <=  ex3_wayE_fxubyp_val_q;
ex4_wayE_relbyp_val_d    <=  ex3_wayE_relbyp_val_q;
ex4_wayE_byp_sel         <=  ex4_wayE_fxubyp_val_q   & ex4_wayE_relbyp_val_q;
-- Late Stages Priority Selection
congr_cl_ex2_wayE_sel(2) <=  congr_cl_ex2_wayE_byp(2);
congr_cl_ex2_wayE_sel(3) <=  congr_cl_ex2_wayE_byp(3)   and not congr_cl_ex2_wayE_byp(2);
congr_cl_ex2_wayE_sel(4) <=  congr_cl_ex2_wayE_byp(4)   and not or_reduce(congr_cl_ex2_wayE_byp(2   to 3));
congr_cl_ex2_wayE_sel(5) <=  congr_cl_ex2_wayE_byp(5)   and not or_reduce(congr_cl_ex2_wayE_byp(2   to 4));
congr_cl_ex2_wayE_sel(6) <=  congr_cl_ex2_wayE_byp(6)   and not or_reduce(congr_cl_ex2_wayE_byp(2   to 5));
congr_cl_ex2_wayE_sel(7) <=  congr_cl_ex2_wayE_byp(7)   and not or_reduce(congr_cl_ex2_wayE_byp(2   to 6));
-- ArrayRead/LATE Stage Priority Selection
wayE_late_sel         <=  or_reduce(congr_cl_ex2_wayE_byp(2   to 7));
wayE_later_stg_pri    <=  gate(p0_arr_wayE_rd,        not wayE_late_sel)          or
                        gate(reload_wayE_q,         congr_cl_ex2_wayE_sel(2))   or
                        gate(flush_wayE_q,          congr_cl_ex2_wayE_sel(3))   or
                        gate(reload_wayE_data_q,    congr_cl_ex2_wayE_sel(4))   or
                        gate(flush_wayE_data_q,     congr_cl_ex2_wayE_sel(5))   or
                        gate(reload_wayE_data2_q,   congr_cl_ex2_wayE_sel(6))   or
                        gate(flush_wayE_data2_q,    congr_cl_ex2_wayE_sel(7));
-- EX3/RELU Stage Priority Selection
wayE_early_sel        <=  congr_cl_ex2_wayE_byp(1);
wayE_early_stg_pri    <=  flush_wayE_d;
-- Stage/ARRAY Priority Selection
wayE_stg_val        <=  (others=>(wayE_early_sel));
wayE_stg_val_b      <=  (others=>(not(wayE_early_sel)));
wayE_val(0 TO 1) <=  not wayE_val_b_q(0   to 1);
wayE_val(2 TO 5) <=  not wayE_val_b_q(2   to 5);
wayE_val_b1         <=  not wayE_val(0);
-- WayF   Bypass Calculation
congr_cl_ex2_wayF_byp(1) <=  congr_cl_ex2_ex3_m    and ex3_wayF_hit;
congr_cl_ex2_wayF_byp(2) <=  congr_cl_ex2_relu_m   and reload_wayF_upd_q;
congr_cl_ex2_wayF_byp(3) <=  congr_cl_ex2_ex4_m    and binv_wayF_upd_q;
congr_cl_ex2_wayF_byp(4) <=  congr_cl_ex2_relu_s_m and reload_wayF_upd2_q;
congr_cl_ex2_wayF_byp(5) <=  congr_cl_ex2_ex5_m    and binv_wayF_upd2_q;
congr_cl_ex2_wayF_byp(6) <=  congr_cl_ex2_p1_cmp   and reload_wayF_upd3_q;
congr_cl_ex2_wayF_byp(7) <=  congr_cl_ex2_p0_cmp   and binv_wayF_upd3_q;
-- WayF   Bypass Valid
ex3_wayF_fxubyp_val_d    <=  congr_cl_ex2_wayF_byp(1)   or congr_cl_ex2_wayF_byp(3)   or
                           congr_cl_ex2_wayF_byp(5)   or congr_cl_ex2_wayF_byp(7);
ex3_wayF_relbyp_val_d    <=  congr_cl_ex2_wayF_byp(2)   or congr_cl_ex2_wayF_byp(4)   or
                           congr_cl_ex2_wayF_byp(6);
ex4_wayF_fxubyp_val_d    <=  ex3_wayF_fxubyp_val_q;
ex4_wayF_relbyp_val_d    <=  ex3_wayF_relbyp_val_q;
ex4_wayF_byp_sel         <=  ex4_wayF_fxubyp_val_q   & ex4_wayF_relbyp_val_q;
-- Late Stages Priority Selection
congr_cl_ex2_wayF_sel(2) <=  congr_cl_ex2_wayF_byp(2);
congr_cl_ex2_wayF_sel(3) <=  congr_cl_ex2_wayF_byp(3)   and not congr_cl_ex2_wayF_byp(2);
congr_cl_ex2_wayF_sel(4) <=  congr_cl_ex2_wayF_byp(4)   and not or_reduce(congr_cl_ex2_wayF_byp(2   to 3));
congr_cl_ex2_wayF_sel(5) <=  congr_cl_ex2_wayF_byp(5)   and not or_reduce(congr_cl_ex2_wayF_byp(2   to 4));
congr_cl_ex2_wayF_sel(6) <=  congr_cl_ex2_wayF_byp(6)   and not or_reduce(congr_cl_ex2_wayF_byp(2   to 5));
congr_cl_ex2_wayF_sel(7) <=  congr_cl_ex2_wayF_byp(7)   and not or_reduce(congr_cl_ex2_wayF_byp(2   to 6));
-- ArrayRead/LATE Stage Priority Selection
wayF_late_sel         <=  or_reduce(congr_cl_ex2_wayF_byp(2   to 7));
wayF_later_stg_pri    <=  gate(p0_arr_wayF_rd,        not wayF_late_sel)          or
                        gate(reload_wayF_q,         congr_cl_ex2_wayF_sel(2))   or
                        gate(flush_wayF_q,          congr_cl_ex2_wayF_sel(3))   or
                        gate(reload_wayF_data_q,    congr_cl_ex2_wayF_sel(4))   or
                        gate(flush_wayF_data_q,     congr_cl_ex2_wayF_sel(5))   or
                        gate(reload_wayF_data2_q,   congr_cl_ex2_wayF_sel(6))   or
                        gate(flush_wayF_data2_q,    congr_cl_ex2_wayF_sel(7));
-- EX3/RELU Stage Priority Selection
wayF_early_sel        <=  congr_cl_ex2_wayF_byp(1);
wayF_early_stg_pri    <=  flush_wayF_d;
-- Stage/ARRAY Priority Selection
wayF_stg_val        <=  (others=>(wayF_early_sel));
wayF_stg_val_b      <=  (others=>(not(wayF_early_sel)));
wayF_val(0 TO 1) <=  not wayF_val_b_q(0   to 1);
wayF_val(2 TO 5) <=  not wayF_val_b_q(2   to 5);
wayF_val_b1         <=  not wayF_val(0);
-- WayG   Bypass Calculation
congr_cl_ex2_wayG_byp(1) <=  congr_cl_ex2_ex3_m    and ex3_wayG_hit;
congr_cl_ex2_wayG_byp(2) <=  congr_cl_ex2_relu_m   and reload_wayG_upd_q;
congr_cl_ex2_wayG_byp(3) <=  congr_cl_ex2_ex4_m    and binv_wayG_upd_q;
congr_cl_ex2_wayG_byp(4) <=  congr_cl_ex2_relu_s_m and reload_wayG_upd2_q;
congr_cl_ex2_wayG_byp(5) <=  congr_cl_ex2_ex5_m    and binv_wayG_upd2_q;
congr_cl_ex2_wayG_byp(6) <=  congr_cl_ex2_p1_cmp   and reload_wayG_upd3_q;
congr_cl_ex2_wayG_byp(7) <=  congr_cl_ex2_p0_cmp   and binv_wayG_upd3_q;
-- WayG   Bypass Valid
ex3_wayG_fxubyp_val_d    <=  congr_cl_ex2_wayG_byp(1)   or congr_cl_ex2_wayG_byp(3)   or
                           congr_cl_ex2_wayG_byp(5)   or congr_cl_ex2_wayG_byp(7);
ex3_wayG_relbyp_val_d    <=  congr_cl_ex2_wayG_byp(2)   or congr_cl_ex2_wayG_byp(4)   or
                           congr_cl_ex2_wayG_byp(6);
ex4_wayG_fxubyp_val_d    <=  ex3_wayG_fxubyp_val_q;
ex4_wayG_relbyp_val_d    <=  ex3_wayG_relbyp_val_q;
ex4_wayG_byp_sel         <=  ex4_wayG_fxubyp_val_q   & ex4_wayG_relbyp_val_q;
-- Late Stages Priority Selection
congr_cl_ex2_wayG_sel(2) <=  congr_cl_ex2_wayG_byp(2);
congr_cl_ex2_wayG_sel(3) <=  congr_cl_ex2_wayG_byp(3)   and not congr_cl_ex2_wayG_byp(2);
congr_cl_ex2_wayG_sel(4) <=  congr_cl_ex2_wayG_byp(4)   and not or_reduce(congr_cl_ex2_wayG_byp(2   to 3));
congr_cl_ex2_wayG_sel(5) <=  congr_cl_ex2_wayG_byp(5)   and not or_reduce(congr_cl_ex2_wayG_byp(2   to 4));
congr_cl_ex2_wayG_sel(6) <=  congr_cl_ex2_wayG_byp(6)   and not or_reduce(congr_cl_ex2_wayG_byp(2   to 5));
congr_cl_ex2_wayG_sel(7) <=  congr_cl_ex2_wayG_byp(7)   and not or_reduce(congr_cl_ex2_wayG_byp(2   to 6));
-- ArrayRead/LATE Stage Priority Selection
wayG_late_sel         <=  or_reduce(congr_cl_ex2_wayG_byp(2   to 7));
wayG_later_stg_pri    <=  gate(p0_arr_wayG_rd,        not wayG_late_sel)          or
                        gate(reload_wayG_q,         congr_cl_ex2_wayG_sel(2))   or
                        gate(flush_wayG_q,          congr_cl_ex2_wayG_sel(3))   or
                        gate(reload_wayG_data_q,    congr_cl_ex2_wayG_sel(4))   or
                        gate(flush_wayG_data_q,     congr_cl_ex2_wayG_sel(5))   or
                        gate(reload_wayG_data2_q,   congr_cl_ex2_wayG_sel(6))   or
                        gate(flush_wayG_data2_q,    congr_cl_ex2_wayG_sel(7));
-- EX3/RELU Stage Priority Selection
wayG_early_sel        <=  congr_cl_ex2_wayG_byp(1);
wayG_early_stg_pri    <=  flush_wayG_d;
-- Stage/ARRAY Priority Selection
wayG_stg_val        <=  (others=>(wayG_early_sel));
wayG_stg_val_b      <=  (others=>(not(wayG_early_sel)));
wayG_val(0 TO 1) <=  not wayG_val_b_q(0   to 1);
wayG_val(2 TO 5) <=  not wayG_val_b_q(2   to 5);
wayG_val_b1         <=  not wayG_val(0);
-- WayH   Bypass Calculation
congr_cl_ex2_wayH_byp(1) <=  congr_cl_ex2_ex3_m    and ex3_wayH_hit;
congr_cl_ex2_wayH_byp(2) <=  congr_cl_ex2_relu_m   and reload_wayH_upd_q;
congr_cl_ex2_wayH_byp(3) <=  congr_cl_ex2_ex4_m    and binv_wayH_upd_q;
congr_cl_ex2_wayH_byp(4) <=  congr_cl_ex2_relu_s_m and reload_wayH_upd2_q;
congr_cl_ex2_wayH_byp(5) <=  congr_cl_ex2_ex5_m    and binv_wayH_upd2_q;
congr_cl_ex2_wayH_byp(6) <=  congr_cl_ex2_p1_cmp   and reload_wayH_upd3_q;
congr_cl_ex2_wayH_byp(7) <=  congr_cl_ex2_p0_cmp   and binv_wayH_upd3_q;
-- WayH   Bypass Valid
ex3_wayH_fxubyp_val_d    <=  congr_cl_ex2_wayH_byp(1)   or congr_cl_ex2_wayH_byp(3)   or
                           congr_cl_ex2_wayH_byp(5)   or congr_cl_ex2_wayH_byp(7);
ex3_wayH_relbyp_val_d    <=  congr_cl_ex2_wayH_byp(2)   or congr_cl_ex2_wayH_byp(4)   or
                           congr_cl_ex2_wayH_byp(6);
ex4_wayH_fxubyp_val_d    <=  ex3_wayH_fxubyp_val_q;
ex4_wayH_relbyp_val_d    <=  ex3_wayH_relbyp_val_q;
ex4_wayH_byp_sel         <=  ex4_wayH_fxubyp_val_q   & ex4_wayH_relbyp_val_q;
-- Late Stages Priority Selection
congr_cl_ex2_wayH_sel(2) <=  congr_cl_ex2_wayH_byp(2);
congr_cl_ex2_wayH_sel(3) <=  congr_cl_ex2_wayH_byp(3)   and not congr_cl_ex2_wayH_byp(2);
congr_cl_ex2_wayH_sel(4) <=  congr_cl_ex2_wayH_byp(4)   and not or_reduce(congr_cl_ex2_wayH_byp(2   to 3));
congr_cl_ex2_wayH_sel(5) <=  congr_cl_ex2_wayH_byp(5)   and not or_reduce(congr_cl_ex2_wayH_byp(2   to 4));
congr_cl_ex2_wayH_sel(6) <=  congr_cl_ex2_wayH_byp(6)   and not or_reduce(congr_cl_ex2_wayH_byp(2   to 5));
congr_cl_ex2_wayH_sel(7) <=  congr_cl_ex2_wayH_byp(7)   and not or_reduce(congr_cl_ex2_wayH_byp(2   to 6));
-- ArrayRead/LATE Stage Priority Selection
wayH_late_sel         <=  or_reduce(congr_cl_ex2_wayH_byp(2   to 7));
wayH_later_stg_pri    <=  gate(p0_arr_wayH_rd,        not wayH_late_sel)          or
                        gate(reload_wayH_q,         congr_cl_ex2_wayH_sel(2))   or
                        gate(flush_wayH_q,          congr_cl_ex2_wayH_sel(3))   or
                        gate(reload_wayH_data_q,    congr_cl_ex2_wayH_sel(4))   or
                        gate(flush_wayH_data_q,     congr_cl_ex2_wayH_sel(5))   or
                        gate(reload_wayH_data2_q,   congr_cl_ex2_wayH_sel(6))   or
                        gate(flush_wayH_data2_q,    congr_cl_ex2_wayH_sel(7));
-- EX3/RELU Stage Priority Selection
wayH_early_sel        <=  congr_cl_ex2_wayH_byp(1);
wayH_early_stg_pri    <=  flush_wayH_d;
-- Stage/ARRAY Priority Selection
wayH_stg_val        <=  (others=>(wayH_early_sel));
wayH_stg_val_b      <=  (others=>(not(wayH_early_sel)));
wayH_val(0 TO 1) <=  not wayH_val_b_q(0   to 1);
wayH_val(2 TO 5) <=  not wayH_val_b_q(2   to 5);
wayH_val_b1         <=  not wayH_val(0);
-- ####################################################
-- Invalidate Pipe and Execution Pipe Hit/Miss Logic
-- ####################################################
-- EX3 stage
fxu_pipe_val  <=  ex3_c_acc or ex3_flush_cline_q;
-- EX4Invalidate/BINV/RELOAD Bypass Invalidate Pipe
-- ####################################################
-- WayA
ex3WayHitA:   ex3_wayA_hit    <=  not (tagA_hit_b   or wayA_val_b1);
-- WayB
ex3WayHitB:   ex3_wayB_hit    <=  not (tagB_hit_b   or wayB_val_b1);
-- WayC
ex3WayHitC:   ex3_wayC_hit    <=  not (tagC_hit_b   or wayC_val_b1);
-- WayD
ex3WayHitD:   ex3_wayD_hit    <=  not (tagD_hit_b   or wayD_val_b1);
-- WayE
ex3WayHitE:   ex3_wayE_hit    <=  not (tagE_hit_b   or wayE_val_b1);
-- WayF
ex3WayHitF:   ex3_wayF_hit    <=  not (tagF_hit_b   or wayF_val_b1);
-- WayG
ex3WayHitG:   ex3_wayG_hit    <=  not (tagG_hit_b   or wayG_val_b1);
-- WayH
ex3WayHitH:   ex3_wayH_hit    <=  not (tagH_hit_b   or wayH_val_b1);
-- Invalidate Valid Bit Logic on Port0
clr_val  <=  ex3_flush_cline_q or back_inval_stg3_q;
clr_val_wayA    <=  clr_val;
-- Need to detect if Back-Invalidate or invalidate type instruction invalidated the lock bit
inval_clr_lck_wA_d    <=      clr_val_wayA   and wayA_val(1);
flush_wayA_d(0) <=  not clr_val_wayA   and wayA_val(0);
clr_val_wayB    <=  clr_val;
-- Need to detect if Back-Invalidate or invalidate type instruction invalidated the lock bit
inval_clr_lck_wB_d    <=      clr_val_wayB   and wayB_val(1);
flush_wayB_d(0) <=  not clr_val_wayB   and wayB_val(0);
clr_val_wayC    <=  clr_val;
-- Need to detect if Back-Invalidate or invalidate type instruction invalidated the lock bit
inval_clr_lck_wC_d    <=      clr_val_wayC   and wayC_val(1);
flush_wayC_d(0) <=  not clr_val_wayC   and wayC_val(0);
clr_val_wayD    <=  clr_val;
-- Need to detect if Back-Invalidate or invalidate type instruction invalidated the lock bit
inval_clr_lck_wD_d    <=      clr_val_wayD   and wayD_val(1);
flush_wayD_d(0) <=  not clr_val_wayD   and wayD_val(0);
clr_val_wayE    <=  clr_val;
-- Need to detect if Back-Invalidate or invalidate type instruction invalidated the lock bit
inval_clr_lck_wE_d    <=      clr_val_wayE   and wayE_val(1);
flush_wayE_d(0) <=  not clr_val_wayE   and wayE_val(0);
clr_val_wayF    <=  clr_val;
-- Need to detect if Back-Invalidate or invalidate type instruction invalidated the lock bit
inval_clr_lck_wF_d    <=      clr_val_wayF   and wayF_val(1);
flush_wayF_d(0) <=  not clr_val_wayF   and wayF_val(0);
clr_val_wayG    <=  clr_val;
-- Need to detect if Back-Invalidate or invalidate type instruction invalidated the lock bit
inval_clr_lck_wG_d    <=      clr_val_wayG   and wayG_val(1);
flush_wayG_d(0) <=  not clr_val_wayG   and wayG_val(0);
clr_val_wayH    <=  clr_val;
-- Need to detect if Back-Invalidate or invalidate type instruction invalidated the lock bit
inval_clr_lck_wH_d    <=      clr_val_wayH   and wayH_val(1);
flush_wayH_d(0) <=  not clr_val_wayH   and wayH_val(0);
-- Clear Lock Bit Logic on Port0
-- Clear Lock Bit on an invalidate type op or a DCBLC
clr_lock  <=  clr_val or ex3_lock_clr_q;
--                  CLEAR LOCK      SET LOCK
upd_lck_wayA       <=  clr_lock & ex3_lock_set_q;
flush_wayA_d(1) <=  (wayA_val(1)   and not upd_lck_wayA(0))   or
                     (wayA_val(0)   and     upd_lck_wayA(1));
-- Staging out current watch bits
ex4_wayA_val_d    <=  wayA_val;
--                  CLEAR LOCK      SET LOCK
upd_lck_wayB       <=  clr_lock & ex3_lock_set_q;
flush_wayB_d(1) <=  (wayB_val(1)   and not upd_lck_wayB(0))   or
                     (wayB_val(0)   and     upd_lck_wayB(1));
-- Staging out current watch bits
ex4_wayB_val_d    <=  wayB_val;
--                  CLEAR LOCK      SET LOCK
upd_lck_wayC       <=  clr_lock & ex3_lock_set_q;
flush_wayC_d(1) <=  (wayC_val(1)   and not upd_lck_wayC(0))   or
                     (wayC_val(0)   and     upd_lck_wayC(1));
-- Staging out current watch bits
ex4_wayC_val_d    <=  wayC_val;
--                  CLEAR LOCK      SET LOCK
upd_lck_wayD       <=  clr_lock & ex3_lock_set_q;
flush_wayD_d(1) <=  (wayD_val(1)   and not upd_lck_wayD(0))   or
                     (wayD_val(0)   and     upd_lck_wayD(1));
-- Staging out current watch bits
ex4_wayD_val_d    <=  wayD_val;
--                  CLEAR LOCK      SET LOCK
upd_lck_wayE       <=  clr_lock & ex3_lock_set_q;
flush_wayE_d(1) <=  (wayE_val(1)   and not upd_lck_wayE(0))   or
                     (wayE_val(0)   and     upd_lck_wayE(1));
-- Staging out current watch bits
ex4_wayE_val_d    <=  wayE_val;
--                  CLEAR LOCK      SET LOCK
upd_lck_wayF       <=  clr_lock & ex3_lock_set_q;
flush_wayF_d(1) <=  (wayF_val(1)   and not upd_lck_wayF(0))   or
                     (wayF_val(0)   and     upd_lck_wayF(1));
-- Staging out current watch bits
ex4_wayF_val_d    <=  wayF_val;
--                  CLEAR LOCK      SET LOCK
upd_lck_wayG       <=  clr_lock & ex3_lock_set_q;
flush_wayG_d(1) <=  (wayG_val(1)   and not upd_lck_wayG(0))   or
                     (wayG_val(0)   and     upd_lck_wayG(1));
-- Staging out current watch bits
ex4_wayG_val_d    <=  wayG_val;
--                  CLEAR LOCK      SET LOCK
upd_lck_wayH       <=  clr_lock & ex3_lock_set_q;
flush_wayH_d(1) <=  (wayH_val(1)   and not upd_lck_wayH(0))   or
                     (wayH_val(0)   and     upd_lck_wayH(1));
-- Staging out current watch bits
ex4_wayH_val_d    <=  wayH_val;
-- Set/Clr Watch Bit for Thread on Port0
-- Clear Watch Bit on an invalidate type op or WCLR
-- Thread 0   Logic
lose_watch(0) <=  clr_val or (ex3_store_instr_q and ex3_c_acc and not ex3_thrd_id_q(0));
ex4_lose_watch_d(0) <=  lose_watch(0);
clr_watch(0) <=  (ex3_watch_clr_q and ex3_thrd_id_q(0))   or lose_watch(0);
set_watch(0) <=   ex3_watch_set_q and ex3_thrd_id_q(0);
-- Determine if a Watch Bit was lost
ex4_lost_wayA(0) <=  ex4_lose_watch_q(0)   and ex4_way_hit_q(0)   and ex4_wayA_val_q(2);
--                              CLEAR Watch                              SET Watch
upd_watch_tid0_wayA    <=  (clr_watch(0)   or ex3_watch_clr_all(0))   & set_watch(0);
flush_wayA_d(2) <=  (wayA_val(2)       and not upd_watch_tid0_wayA(0))   or
                         (wayA_val(0)       and     upd_watch_tid0_wayA(1));
-- Determine if a Watch Bit was lost
ex4_lost_wayB(0) <=  ex4_lose_watch_q(0)   and ex4_way_hit_q(1)   and ex4_wayB_val_q(2);
--                              CLEAR Watch                              SET Watch
upd_watch_tid0_wayB    <=  (clr_watch(0)   or ex3_watch_clr_all(0))   & set_watch(0);
flush_wayB_d(2) <=  (wayB_val(2)       and not upd_watch_tid0_wayB(0))   or
                         (wayB_val(0)       and     upd_watch_tid0_wayB(1));
-- Determine if a Watch Bit was lost
ex4_lost_wayC(0) <=  ex4_lose_watch_q(0)   and ex4_way_hit_q(2)   and ex4_wayC_val_q(2);
--                              CLEAR Watch                              SET Watch
upd_watch_tid0_wayC    <=  (clr_watch(0)   or ex3_watch_clr_all(0))   & set_watch(0);
flush_wayC_d(2) <=  (wayC_val(2)       and not upd_watch_tid0_wayC(0))   or
                         (wayC_val(0)       and     upd_watch_tid0_wayC(1));
-- Determine if a Watch Bit was lost
ex4_lost_wayD(0) <=  ex4_lose_watch_q(0)   and ex4_way_hit_q(3)   and ex4_wayD_val_q(2);
--                              CLEAR Watch                              SET Watch
upd_watch_tid0_wayD    <=  (clr_watch(0)   or ex3_watch_clr_all(0))   & set_watch(0);
flush_wayD_d(2) <=  (wayD_val(2)       and not upd_watch_tid0_wayD(0))   or
                         (wayD_val(0)       and     upd_watch_tid0_wayD(1));
-- Determine if a Watch Bit was lost
ex4_lost_wayE(0) <=  ex4_lose_watch_q(0)   and ex4_way_hit_q(4)   and ex4_wayE_val_q(2);
--                              CLEAR Watch                              SET Watch
upd_watch_tid0_wayE    <=  (clr_watch(0)   or ex3_watch_clr_all(0))   & set_watch(0);
flush_wayE_d(2) <=  (wayE_val(2)       and not upd_watch_tid0_wayE(0))   or
                         (wayE_val(0)       and     upd_watch_tid0_wayE(1));
-- Determine if a Watch Bit was lost
ex4_lost_wayF(0) <=  ex4_lose_watch_q(0)   and ex4_way_hit_q(5)   and ex4_wayF_val_q(2);
--                              CLEAR Watch                              SET Watch
upd_watch_tid0_wayF    <=  (clr_watch(0)   or ex3_watch_clr_all(0))   & set_watch(0);
flush_wayF_d(2) <=  (wayF_val(2)       and not upd_watch_tid0_wayF(0))   or
                         (wayF_val(0)       and     upd_watch_tid0_wayF(1));
-- Determine if a Watch Bit was lost
ex4_lost_wayG(0) <=  ex4_lose_watch_q(0)   and ex4_way_hit_q(6)   and ex4_wayG_val_q(2);
--                              CLEAR Watch                              SET Watch
upd_watch_tid0_wayG    <=  (clr_watch(0)   or ex3_watch_clr_all(0))   & set_watch(0);
flush_wayG_d(2) <=  (wayG_val(2)       and not upd_watch_tid0_wayG(0))   or
                         (wayG_val(0)       and     upd_watch_tid0_wayG(1));
-- Determine if a Watch Bit was lost
ex4_lost_wayH(0) <=  ex4_lose_watch_q(0)   and ex4_way_hit_q(7)   and ex4_wayH_val_q(2);
--                              CLEAR Watch                              SET Watch
upd_watch_tid0_wayH    <=  (clr_watch(0)   or ex3_watch_clr_all(0))   & set_watch(0);
flush_wayH_d(2) <=  (wayH_val(2)       and not upd_watch_tid0_wayH(0))   or
                         (wayH_val(0)       and     upd_watch_tid0_wayH(1));
-- Thread 1   Logic
lose_watch(1) <=  clr_val or (ex3_store_instr_q and ex3_c_acc and not ex3_thrd_id_q(1));
ex4_lose_watch_d(1) <=  lose_watch(1);
clr_watch(1) <=  (ex3_watch_clr_q and ex3_thrd_id_q(1))   or lose_watch(1);
set_watch(1) <=   ex3_watch_set_q and ex3_thrd_id_q(1);
-- Determine if a Watch Bit was lost
ex4_lost_wayA(1) <=  ex4_lose_watch_q(1)   and ex4_way_hit_q(0)   and ex4_wayA_val_q(3);
--                              CLEAR Watch                              SET Watch
upd_watch_tid1_wayA    <=  (clr_watch(1)   or ex3_watch_clr_all(1))   & set_watch(1);
flush_wayA_d(3) <=  (wayA_val(3)       and not upd_watch_tid1_wayA(0))   or
                         (wayA_val(0)       and     upd_watch_tid1_wayA(1));
-- Determine if a Watch Bit was lost
ex4_lost_wayB(1) <=  ex4_lose_watch_q(1)   and ex4_way_hit_q(1)   and ex4_wayB_val_q(3);
--                              CLEAR Watch                              SET Watch
upd_watch_tid1_wayB    <=  (clr_watch(1)   or ex3_watch_clr_all(1))   & set_watch(1);
flush_wayB_d(3) <=  (wayB_val(3)       and not upd_watch_tid1_wayB(0))   or
                         (wayB_val(0)       and     upd_watch_tid1_wayB(1));
-- Determine if a Watch Bit was lost
ex4_lost_wayC(1) <=  ex4_lose_watch_q(1)   and ex4_way_hit_q(2)   and ex4_wayC_val_q(3);
--                              CLEAR Watch                              SET Watch
upd_watch_tid1_wayC    <=  (clr_watch(1)   or ex3_watch_clr_all(1))   & set_watch(1);
flush_wayC_d(3) <=  (wayC_val(3)       and not upd_watch_tid1_wayC(0))   or
                         (wayC_val(0)       and     upd_watch_tid1_wayC(1));
-- Determine if a Watch Bit was lost
ex4_lost_wayD(1) <=  ex4_lose_watch_q(1)   and ex4_way_hit_q(3)   and ex4_wayD_val_q(3);
--                              CLEAR Watch                              SET Watch
upd_watch_tid1_wayD    <=  (clr_watch(1)   or ex3_watch_clr_all(1))   & set_watch(1);
flush_wayD_d(3) <=  (wayD_val(3)       and not upd_watch_tid1_wayD(0))   or
                         (wayD_val(0)       and     upd_watch_tid1_wayD(1));
-- Determine if a Watch Bit was lost
ex4_lost_wayE(1) <=  ex4_lose_watch_q(1)   and ex4_way_hit_q(4)   and ex4_wayE_val_q(3);
--                              CLEAR Watch                              SET Watch
upd_watch_tid1_wayE    <=  (clr_watch(1)   or ex3_watch_clr_all(1))   & set_watch(1);
flush_wayE_d(3) <=  (wayE_val(3)       and not upd_watch_tid1_wayE(0))   or
                         (wayE_val(0)       and     upd_watch_tid1_wayE(1));
-- Determine if a Watch Bit was lost
ex4_lost_wayF(1) <=  ex4_lose_watch_q(1)   and ex4_way_hit_q(5)   and ex4_wayF_val_q(3);
--                              CLEAR Watch                              SET Watch
upd_watch_tid1_wayF    <=  (clr_watch(1)   or ex3_watch_clr_all(1))   & set_watch(1);
flush_wayF_d(3) <=  (wayF_val(3)       and not upd_watch_tid1_wayF(0))   or
                         (wayF_val(0)       and     upd_watch_tid1_wayF(1));
-- Determine if a Watch Bit was lost
ex4_lost_wayG(1) <=  ex4_lose_watch_q(1)   and ex4_way_hit_q(6)   and ex4_wayG_val_q(3);
--                              CLEAR Watch                              SET Watch
upd_watch_tid1_wayG    <=  (clr_watch(1)   or ex3_watch_clr_all(1))   & set_watch(1);
flush_wayG_d(3) <=  (wayG_val(3)       and not upd_watch_tid1_wayG(0))   or
                         (wayG_val(0)       and     upd_watch_tid1_wayG(1));
-- Determine if a Watch Bit was lost
ex4_lost_wayH(1) <=  ex4_lose_watch_q(1)   and ex4_way_hit_q(7)   and ex4_wayH_val_q(3);
--                              CLEAR Watch                              SET Watch
upd_watch_tid1_wayH    <=  (clr_watch(1)   or ex3_watch_clr_all(1))   & set_watch(1);
flush_wayH_d(3) <=  (wayH_val(3)       and not upd_watch_tid1_wayH(0))   or
                         (wayH_val(0)       and     upd_watch_tid1_wayH(1));
-- Thread 2   Logic
lose_watch(2) <=  clr_val or (ex3_store_instr_q and ex3_c_acc and not ex3_thrd_id_q(2));
ex4_lose_watch_d(2) <=  lose_watch(2);
clr_watch(2) <=  (ex3_watch_clr_q and ex3_thrd_id_q(2))   or lose_watch(2);
set_watch(2) <=   ex3_watch_set_q and ex3_thrd_id_q(2);
-- Determine if a Watch Bit was lost
ex4_lost_wayA(2) <=  ex4_lose_watch_q(2)   and ex4_way_hit_q(0)   and ex4_wayA_val_q(4);
--                              CLEAR Watch                              SET Watch
upd_watch_tid2_wayA    <=  (clr_watch(2)   or ex3_watch_clr_all(2))   & set_watch(2);
flush_wayA_d(4) <=  (wayA_val(4)       and not upd_watch_tid2_wayA(0))   or
                         (wayA_val(0)       and     upd_watch_tid2_wayA(1));
-- Determine if a Watch Bit was lost
ex4_lost_wayB(2) <=  ex4_lose_watch_q(2)   and ex4_way_hit_q(1)   and ex4_wayB_val_q(4);
--                              CLEAR Watch                              SET Watch
upd_watch_tid2_wayB    <=  (clr_watch(2)   or ex3_watch_clr_all(2))   & set_watch(2);
flush_wayB_d(4) <=  (wayB_val(4)       and not upd_watch_tid2_wayB(0))   or
                         (wayB_val(0)       and     upd_watch_tid2_wayB(1));
-- Determine if a Watch Bit was lost
ex4_lost_wayC(2) <=  ex4_lose_watch_q(2)   and ex4_way_hit_q(2)   and ex4_wayC_val_q(4);
--                              CLEAR Watch                              SET Watch
upd_watch_tid2_wayC    <=  (clr_watch(2)   or ex3_watch_clr_all(2))   & set_watch(2);
flush_wayC_d(4) <=  (wayC_val(4)       and not upd_watch_tid2_wayC(0))   or
                         (wayC_val(0)       and     upd_watch_tid2_wayC(1));
-- Determine if a Watch Bit was lost
ex4_lost_wayD(2) <=  ex4_lose_watch_q(2)   and ex4_way_hit_q(3)   and ex4_wayD_val_q(4);
--                              CLEAR Watch                              SET Watch
upd_watch_tid2_wayD    <=  (clr_watch(2)   or ex3_watch_clr_all(2))   & set_watch(2);
flush_wayD_d(4) <=  (wayD_val(4)       and not upd_watch_tid2_wayD(0))   or
                         (wayD_val(0)       and     upd_watch_tid2_wayD(1));
-- Determine if a Watch Bit was lost
ex4_lost_wayE(2) <=  ex4_lose_watch_q(2)   and ex4_way_hit_q(4)   and ex4_wayE_val_q(4);
--                              CLEAR Watch                              SET Watch
upd_watch_tid2_wayE    <=  (clr_watch(2)   or ex3_watch_clr_all(2))   & set_watch(2);
flush_wayE_d(4) <=  (wayE_val(4)       and not upd_watch_tid2_wayE(0))   or
                         (wayE_val(0)       and     upd_watch_tid2_wayE(1));
-- Determine if a Watch Bit was lost
ex4_lost_wayF(2) <=  ex4_lose_watch_q(2)   and ex4_way_hit_q(5)   and ex4_wayF_val_q(4);
--                              CLEAR Watch                              SET Watch
upd_watch_tid2_wayF    <=  (clr_watch(2)   or ex3_watch_clr_all(2))   & set_watch(2);
flush_wayF_d(4) <=  (wayF_val(4)       and not upd_watch_tid2_wayF(0))   or
                         (wayF_val(0)       and     upd_watch_tid2_wayF(1));
-- Determine if a Watch Bit was lost
ex4_lost_wayG(2) <=  ex4_lose_watch_q(2)   and ex4_way_hit_q(6)   and ex4_wayG_val_q(4);
--                              CLEAR Watch                              SET Watch
upd_watch_tid2_wayG    <=  (clr_watch(2)   or ex3_watch_clr_all(2))   & set_watch(2);
flush_wayG_d(4) <=  (wayG_val(4)       and not upd_watch_tid2_wayG(0))   or
                         (wayG_val(0)       and     upd_watch_tid2_wayG(1));
-- Determine if a Watch Bit was lost
ex4_lost_wayH(2) <=  ex4_lose_watch_q(2)   and ex4_way_hit_q(7)   and ex4_wayH_val_q(4);
--                              CLEAR Watch                              SET Watch
upd_watch_tid2_wayH    <=  (clr_watch(2)   or ex3_watch_clr_all(2))   & set_watch(2);
flush_wayH_d(4) <=  (wayH_val(4)       and not upd_watch_tid2_wayH(0))   or
                         (wayH_val(0)       and     upd_watch_tid2_wayH(1));
-- Thread 3   Logic
lose_watch(3) <=  clr_val or (ex3_store_instr_q and ex3_c_acc and not ex3_thrd_id_q(3));
ex4_lose_watch_d(3) <=  lose_watch(3);
clr_watch(3) <=  (ex3_watch_clr_q and ex3_thrd_id_q(3))   or lose_watch(3);
set_watch(3) <=   ex3_watch_set_q and ex3_thrd_id_q(3);
-- Determine if a Watch Bit was lost
ex4_lost_wayA(3) <=  ex4_lose_watch_q(3)   and ex4_way_hit_q(0)   and ex4_wayA_val_q(5);
--                              CLEAR Watch                              SET Watch
upd_watch_tid3_wayA    <=  (clr_watch(3)   or ex3_watch_clr_all(3))   & set_watch(3);
flush_wayA_d(5) <=  (wayA_val(5)       and not upd_watch_tid3_wayA(0))   or
                         (wayA_val(0)       and     upd_watch_tid3_wayA(1));
-- Determine if a Watch Bit was lost
ex4_lost_wayB(3) <=  ex4_lose_watch_q(3)   and ex4_way_hit_q(1)   and ex4_wayB_val_q(5);
--                              CLEAR Watch                              SET Watch
upd_watch_tid3_wayB    <=  (clr_watch(3)   or ex3_watch_clr_all(3))   & set_watch(3);
flush_wayB_d(5) <=  (wayB_val(5)       and not upd_watch_tid3_wayB(0))   or
                         (wayB_val(0)       and     upd_watch_tid3_wayB(1));
-- Determine if a Watch Bit was lost
ex4_lost_wayC(3) <=  ex4_lose_watch_q(3)   and ex4_way_hit_q(2)   and ex4_wayC_val_q(5);
--                              CLEAR Watch                              SET Watch
upd_watch_tid3_wayC    <=  (clr_watch(3)   or ex3_watch_clr_all(3))   & set_watch(3);
flush_wayC_d(5) <=  (wayC_val(5)       and not upd_watch_tid3_wayC(0))   or
                         (wayC_val(0)       and     upd_watch_tid3_wayC(1));
-- Determine if a Watch Bit was lost
ex4_lost_wayD(3) <=  ex4_lose_watch_q(3)   and ex4_way_hit_q(3)   and ex4_wayD_val_q(5);
--                              CLEAR Watch                              SET Watch
upd_watch_tid3_wayD    <=  (clr_watch(3)   or ex3_watch_clr_all(3))   & set_watch(3);
flush_wayD_d(5) <=  (wayD_val(5)       and not upd_watch_tid3_wayD(0))   or
                         (wayD_val(0)       and     upd_watch_tid3_wayD(1));
-- Determine if a Watch Bit was lost
ex4_lost_wayE(3) <=  ex4_lose_watch_q(3)   and ex4_way_hit_q(4)   and ex4_wayE_val_q(5);
--                              CLEAR Watch                              SET Watch
upd_watch_tid3_wayE    <=  (clr_watch(3)   or ex3_watch_clr_all(3))   & set_watch(3);
flush_wayE_d(5) <=  (wayE_val(5)       and not upd_watch_tid3_wayE(0))   or
                         (wayE_val(0)       and     upd_watch_tid3_wayE(1));
-- Determine if a Watch Bit was lost
ex4_lost_wayF(3) <=  ex4_lose_watch_q(3)   and ex4_way_hit_q(5)   and ex4_wayF_val_q(5);
--                              CLEAR Watch                              SET Watch
upd_watch_tid3_wayF    <=  (clr_watch(3)   or ex3_watch_clr_all(3))   & set_watch(3);
flush_wayF_d(5) <=  (wayF_val(5)       and not upd_watch_tid3_wayF(0))   or
                         (wayF_val(0)       and     upd_watch_tid3_wayF(1));
-- Determine if a Watch Bit was lost
ex4_lost_wayG(3) <=  ex4_lose_watch_q(3)   and ex4_way_hit_q(6)   and ex4_wayG_val_q(5);
--                              CLEAR Watch                              SET Watch
upd_watch_tid3_wayG    <=  (clr_watch(3)   or ex3_watch_clr_all(3))   & set_watch(3);
flush_wayG_d(5) <=  (wayG_val(5)       and not upd_watch_tid3_wayG(0))   or
                         (wayG_val(0)       and     upd_watch_tid3_wayG(1));
-- Determine if a Watch Bit was lost
ex4_lost_wayH(3) <=  ex4_lose_watch_q(3)   and ex4_way_hit_q(7)   and ex4_wayH_val_q(5);
--                              CLEAR Watch                              SET Watch
upd_watch_tid3_wayH    <=  (clr_watch(3)   or ex3_watch_clr_all(3))   & set_watch(3);
flush_wayH_d(5) <=  (wayH_val(5)       and not upd_watch_tid3_wayH(0))   or
                         (wayH_val(0)       and     upd_watch_tid3_wayH(1));
-- Determine if Updating Directory
binv_wayA_upd_d             <=  (ex3_wayA_hit   and binv3_ex3_xuop_upd);
ex3_xuop_lost_watch_wayA    <=  or_reduce((wayA_val(2   to 5) and not ex3_thrd_id_q)) and ex3_store_instr_q and ex3_c_acc;
ex3_xuop_wayA_upd           <=  (ex3_wayA_hit   and (ex3_xuop_upd_dir or ex3_xuop_lost_watch_wayA));
ex4_xuop_wayA_upd_d         <=  ex3_xuop_wayA_upd;
ex5_xuop_wayA_upd_d         <=  ex4_xuop_wayA_upd_q;
binv_wayB_upd_d             <=  (ex3_wayB_hit   and binv3_ex3_xuop_upd);
ex3_xuop_lost_watch_wayB    <=  or_reduce((wayB_val(2   to 5) and not ex3_thrd_id_q)) and ex3_store_instr_q and ex3_c_acc;
ex3_xuop_wayB_upd           <=  (ex3_wayB_hit   and (ex3_xuop_upd_dir or ex3_xuop_lost_watch_wayB));
ex4_xuop_wayB_upd_d         <=  ex3_xuop_wayB_upd;
ex5_xuop_wayB_upd_d         <=  ex4_xuop_wayB_upd_q;
binv_wayC_upd_d             <=  (ex3_wayC_hit   and binv3_ex3_xuop_upd);
ex3_xuop_lost_watch_wayC    <=  or_reduce((wayC_val(2   to 5) and not ex3_thrd_id_q)) and ex3_store_instr_q and ex3_c_acc;
ex3_xuop_wayC_upd           <=  (ex3_wayC_hit   and (ex3_xuop_upd_dir or ex3_xuop_lost_watch_wayC));
ex4_xuop_wayC_upd_d         <=  ex3_xuop_wayC_upd;
ex5_xuop_wayC_upd_d         <=  ex4_xuop_wayC_upd_q;
binv_wayD_upd_d             <=  (ex3_wayD_hit   and binv3_ex3_xuop_upd);
ex3_xuop_lost_watch_wayD    <=  or_reduce((wayD_val(2   to 5) and not ex3_thrd_id_q)) and ex3_store_instr_q and ex3_c_acc;
ex3_xuop_wayD_upd           <=  (ex3_wayD_hit   and (ex3_xuop_upd_dir or ex3_xuop_lost_watch_wayD));
ex4_xuop_wayD_upd_d         <=  ex3_xuop_wayD_upd;
ex5_xuop_wayD_upd_d         <=  ex4_xuop_wayD_upd_q;
binv_wayE_upd_d             <=  (ex3_wayE_hit   and binv3_ex3_xuop_upd);
ex3_xuop_lost_watch_wayE    <=  or_reduce((wayE_val(2   to 5) and not ex3_thrd_id_q)) and ex3_store_instr_q and ex3_c_acc;
ex3_xuop_wayE_upd           <=  (ex3_wayE_hit   and (ex3_xuop_upd_dir or ex3_xuop_lost_watch_wayE));
ex4_xuop_wayE_upd_d         <=  ex3_xuop_wayE_upd;
ex5_xuop_wayE_upd_d         <=  ex4_xuop_wayE_upd_q;
binv_wayF_upd_d             <=  (ex3_wayF_hit   and binv3_ex3_xuop_upd);
ex3_xuop_lost_watch_wayF    <=  or_reduce((wayF_val(2   to 5) and not ex3_thrd_id_q)) and ex3_store_instr_q and ex3_c_acc;
ex3_xuop_wayF_upd           <=  (ex3_wayF_hit   and (ex3_xuop_upd_dir or ex3_xuop_lost_watch_wayF));
ex4_xuop_wayF_upd_d         <=  ex3_xuop_wayF_upd;
ex5_xuop_wayF_upd_d         <=  ex4_xuop_wayF_upd_q;
binv_wayG_upd_d             <=  (ex3_wayG_hit   and binv3_ex3_xuop_upd);
ex3_xuop_lost_watch_wayG    <=  or_reduce((wayG_val(2   to 5) and not ex3_thrd_id_q)) and ex3_store_instr_q and ex3_c_acc;
ex3_xuop_wayG_upd           <=  (ex3_wayG_hit   and (ex3_xuop_upd_dir or ex3_xuop_lost_watch_wayG));
ex4_xuop_wayG_upd_d         <=  ex3_xuop_wayG_upd;
ex5_xuop_wayG_upd_d         <=  ex4_xuop_wayG_upd_q;
binv_wayH_upd_d             <=  (ex3_wayH_hit   and binv3_ex3_xuop_upd);
ex3_xuop_lost_watch_wayH    <=  or_reduce((wayH_val(2   to 5) and not ex3_thrd_id_q)) and ex3_store_instr_q and ex3_c_acc;
ex3_xuop_wayH_upd           <=  (ex3_wayH_hit   and (ex3_xuop_upd_dir or ex3_xuop_lost_watch_wayH));
ex4_xuop_wayH_upd_d         <=  ex3_xuop_wayH_upd;
ex5_xuop_wayH_upd_d         <=  ex4_xuop_wayH_upd_q;
-- One of the Ways has a Lock Bit set
binv4_ex4_lock_set  <=  ex4_wayA_val_q(1) or ex4_wayB_val_q(1) or ex4_wayC_val_q(1) or ex4_wayD_val_q(1) or
                      ex4_wayE_val_q(1) or ex4_wayF_val_q(1) or ex4_wayG_val_q(1) or ex4_wayH_val_q(1);
-- Threads Watching one of the ways in EX4/BINV4
binv4_ex4_thrd_watch  <=  ex4_wayA_val_q(2 to 5) or ex4_wayB_val_q(2 to 5) or ex4_wayC_val_q(2 to 5) or ex4_wayD_val_q(2 to 5) or
                        ex4_wayE_val_q(2 to 5) or ex4_wayF_val_q(2 to 5) or ex4_wayG_val_q(2 to 5) or ex4_wayH_val_q(2 to 5);
-- Return Prior Watch Bit Value
wayA_watch_value    <=  (ex4_thrd_id_q(0) and ex4_wayA_val_q(2))   or (ex4_thrd_id_q(1) and ex4_wayA_val_q(3))   or 
                      (ex4_thrd_id_q(2) and ex4_wayA_val_q(4))   or (ex4_thrd_id_q(3) and ex4_wayA_val_q(5));
wayB_watch_value    <=  (ex4_thrd_id_q(0) and ex4_wayB_val_q(2))   or (ex4_thrd_id_q(1) and ex4_wayB_val_q(3))   or 
                      (ex4_thrd_id_q(2) and ex4_wayB_val_q(4))   or (ex4_thrd_id_q(3) and ex4_wayB_val_q(5));
wayC_watch_value    <=  (ex4_thrd_id_q(0) and ex4_wayC_val_q(2))   or (ex4_thrd_id_q(1) and ex4_wayC_val_q(3))   or 
                      (ex4_thrd_id_q(2) and ex4_wayC_val_q(4))   or (ex4_thrd_id_q(3) and ex4_wayC_val_q(5));
wayD_watch_value    <=  (ex4_thrd_id_q(0) and ex4_wayD_val_q(2))   or (ex4_thrd_id_q(1) and ex4_wayD_val_q(3))   or 
                      (ex4_thrd_id_q(2) and ex4_wayD_val_q(4))   or (ex4_thrd_id_q(3) and ex4_wayD_val_q(5));
wayE_watch_value    <=  (ex4_thrd_id_q(0) and ex4_wayE_val_q(2))   or (ex4_thrd_id_q(1) and ex4_wayE_val_q(3))   or 
                      (ex4_thrd_id_q(2) and ex4_wayE_val_q(4))   or (ex4_thrd_id_q(3) and ex4_wayE_val_q(5));
wayF_watch_value    <=  (ex4_thrd_id_q(0) and ex4_wayF_val_q(2))   or (ex4_thrd_id_q(1) and ex4_wayF_val_q(3))   or 
                      (ex4_thrd_id_q(2) and ex4_wayF_val_q(4))   or (ex4_thrd_id_q(3) and ex4_wayF_val_q(5));
wayG_watch_value    <=  (ex4_thrd_id_q(0) and ex4_wayG_val_q(2))   or (ex4_thrd_id_q(1) and ex4_wayG_val_q(3))   or 
                      (ex4_thrd_id_q(2) and ex4_wayG_val_q(4))   or (ex4_thrd_id_q(3) and ex4_wayG_val_q(5));
wayH_watch_value    <=  (ex4_thrd_id_q(0) and ex4_wayH_val_q(2))   or (ex4_thrd_id_q(1) and ex4_wayH_val_q(3))   or 
                      (ex4_thrd_id_q(2) and ex4_wayH_val_q(4))   or (ex4_thrd_id_q(3) and ex4_wayH_val_q(5));
ex4_curr_watch  <=  (ex4_way_hit_q(0) and wayA_watch_value) or (ex4_way_hit_q(1) and wayB_watch_value) or
                  (ex4_way_hit_q(2) and wayC_watch_value) or (ex4_way_hit_q(3) and wayD_watch_value) or
                  (ex4_way_hit_q(4) and wayE_watch_value) or (ex4_way_hit_q(5) and wayF_watch_value) or
                  (ex4_way_hit_q(6) and wayG_watch_value) or (ex4_way_hit_q(7) and wayH_watch_value);
stm_watchlost_sel  <=  (ex4_thrd_id_q(0) and stm_watchlost(0)) or (ex4_thrd_id_q(1) and stm_watchlost(1)) or
                     (ex4_thrd_id_q(2) and stm_watchlost(2)) or (ex4_thrd_id_q(3) and stm_watchlost(3));
with ex4_watch_set_q select
    ex5_cr_watch_d  <=  stm_watchlost_sel when '0',
                         ex4_curr_watch when others;
-- Execution Pipe Watch Lost Indicator Logic
-- ####################################################
ex4_lost_watch(0) <=  ex4_lost_wayA(0)   or ex4_lost_wayB(0)   or ex4_lost_wayC(0)   or ex4_lost_wayD(0)   or
                       ex4_lost_wayE(0)   or ex4_lost_wayF(0)   or ex4_lost_wayG(0)   or ex4_lost_wayH(0)   or
                       ex4_perr_watch_lost_q(0);
-- Want to still update the STM_WATCHLOST indicator if the DC_DIS=1
 WITH ex4_watchlost_set_q(0)    SELECT     ex4_lost_watch_upd(0) <=  ex4_lost_watch(0)   when '0',
                                    ex4_l_fld_b1_q when others;
ex4_lost_watch(1) <=  ex4_lost_wayA(1)   or ex4_lost_wayB(1)   or ex4_lost_wayC(1)   or ex4_lost_wayD(1)   or
                       ex4_lost_wayE(1)   or ex4_lost_wayF(1)   or ex4_lost_wayG(1)   or ex4_lost_wayH(1)   or
                       ex4_perr_watch_lost_q(1);
-- Want to still update the STM_WATCHLOST indicator if the DC_DIS=1
 WITH ex4_watchlost_set_q(1)    SELECT     ex4_lost_watch_upd(1) <=  ex4_lost_watch(1)   when '0',
                                    ex4_l_fld_b1_q when others;
ex4_lost_watch(2) <=  ex4_lost_wayA(2)   or ex4_lost_wayB(2)   or ex4_lost_wayC(2)   or ex4_lost_wayD(2)   or
                       ex4_lost_wayE(2)   or ex4_lost_wayF(2)   or ex4_lost_wayG(2)   or ex4_lost_wayH(2)   or
                       ex4_perr_watch_lost_q(2);
-- Want to still update the STM_WATCHLOST indicator if the DC_DIS=1
 WITH ex4_watchlost_set_q(2)    SELECT     ex4_lost_watch_upd(2) <=  ex4_lost_watch(2)   when '0',
                                    ex4_l_fld_b1_q when others;
ex4_lost_watch(3) <=  ex4_lost_wayA(3)   or ex4_lost_wayB(3)   or ex4_lost_wayC(3)   or ex4_lost_wayD(3)   or
                       ex4_lost_wayE(3)   or ex4_lost_wayF(3)   or ex4_lost_wayG(3)   or ex4_lost_wayH(3)   or
                       ex4_perr_watch_lost_q(3);
-- Want to still update the STM_WATCHLOST indicator if the DC_DIS=1
 WITH ex4_watchlost_set_q(3)    SELECT     ex4_lost_watch_upd(3) <=  ex4_lost_watch(3)   when '0',
                                    ex4_l_fld_b1_q when others;
-- LDAWX Hit Way collided with Reload Clear of Same Way
ex4_watchSet_coll_d    <=  rel_val_stg2_q and ex3_watch_set_q and (rel24_congr_cl_q = ex3_congr_cl_q);
watchSet_rel_way_coll  <=  gate((reload_way_clr_q and ex4_way_hit_q), ex4_watchSet_coll_q);
watchSet_rel_coll_val  <=  gate(ex4_thrd_id_q, or_reduce(watchSet_rel_way_coll));
ex5_lost_watch_upd_d  <=  ex4_lost_watch_upd or watchSet_rel_coll_val or ex4_multihit_watch_lost;
ex4_watchlost_set_d   <=  ex3_watch_clr_all;
ex5_watchlost_set_d   <=  ex4_lost_watch or ex4_watchlost_set_q or watchSet_rel_coll_val or ex4_multihit_watch_lost;
ex5_watch_clr_all_d   <=  gate(ex4_watch_clr_all_q, not ex4_stg_flush);
ex6_watch_clr_all_d   <=  gate(ex5_watch_clr_all_q, not ex5_stg_flush);
ex5_watch_clr_all_val_d  <=  or_reduce(ex4_watch_clr_all_q);
-- EX4Invalidate/BINV/RELOAD Bypass Execution Op hit/miss Logic
-- ####################################################
-- Hit Detect
u_th0i:   tagA_hit_b              <=   not tagA_hit;
u_hw0i:   xu_op_hit_wayA_b        <=   not (wayA_val(0)   and tagA_hit);
u_hw0:    xu_op_hit_wayA          <=   not xu_op_hit_wayA_b;
u_hw0b:   xu_op_hit_wayA_dly_b    <=   not xu_op_hit_wayA;
-- Hit Detect
u_th1i:   tagB_hit_b              <=   not tagB_hit;
u_hw1i:   xu_op_hit_wayB_b        <=   not (wayB_val(0)   and tagB_hit);
u_hw1:    xu_op_hit_wayB          <=   not xu_op_hit_wayB_b;
u_hw1b:   xu_op_hit_wayB_dly_b    <=   not xu_op_hit_wayB;
-- Hit Detect
u_th2i:   tagC_hit_b              <=   not tagC_hit;
u_hw2i:   xu_op_hit_wayC_b        <=   not (wayC_val(0)   and tagC_hit);
u_hw2:    xu_op_hit_wayC          <=   not xu_op_hit_wayC_b;
u_hw2b:   xu_op_hit_wayC_dly_b    <=   not xu_op_hit_wayC;
-- Hit Detect
u_th3i:   tagD_hit_b              <=   not tagD_hit;
u_hw3i:   xu_op_hit_wayD_b        <=   not (wayD_val(0)   and tagD_hit);
u_hw3:    xu_op_hit_wayD          <=   not xu_op_hit_wayD_b;
u_hw3b:   xu_op_hit_wayD_dly_b    <=   not xu_op_hit_wayD;
-- Hit Detect
u_th4i:   tagE_hit_b              <=   not tagE_hit;
u_hw4i:   xu_op_hit_wayE_b        <=   not (wayE_val(0)   and tagE_hit);
u_hw4:    xu_op_hit_wayE          <=   not xu_op_hit_wayE_b;
u_hw4b:   xu_op_hit_wayE_dly_b    <=   not xu_op_hit_wayE;
-- Hit Detect
u_th5i:   tagF_hit_b              <=   not tagF_hit;
u_hw5i:   xu_op_hit_wayF_b        <=   not (wayF_val(0)   and tagF_hit);
u_hw5:    xu_op_hit_wayF          <=   not xu_op_hit_wayF_b;
u_hw5b:   xu_op_hit_wayF_dly_b    <=   not xu_op_hit_wayF;
-- Hit Detect
u_th6i:   tagG_hit_b              <=   not tagG_hit;
u_hw6i:   xu_op_hit_wayG_b        <=   not (wayG_val(0)   and tagG_hit);
u_hw6:    xu_op_hit_wayG          <=   not xu_op_hit_wayG_b;
u_hw6b:   xu_op_hit_wayG_dly_b    <=   not xu_op_hit_wayG;
-- Hit Detect
u_th7i:   tagH_hit_b              <=   not tagH_hit;
u_hw7i:   xu_op_hit_wayH_b        <=   not (wayH_val(0)   and tagH_hit);
u_hw7:    xu_op_hit_wayH          <=   not xu_op_hit_wayH_b;
u_hw7b:   xu_op_hit_wayH_dly_b    <=   not xu_op_hit_wayH;
-- Invalidate Lock Bit Detect
inval_clr_lck  <=  (inval_clr_lck_wA_q and binv_wayA_upd_q) or (inval_clr_lck_wB_q and binv_wayB_upd_q) or
                 (inval_clr_lck_wC_q and binv_wayC_upd_q) or (inval_clr_lck_wD_q and binv_wayD_upd_q) or
                 (inval_clr_lck_wE_q and binv_wayE_upd_q) or (inval_clr_lck_wF_q and binv_wayF_upd_q) or
                 (inval_clr_lck_wG_q and binv_wayG_upd_q) or (inval_clr_lck_wH_q and binv_wayH_upd_q);
xucr0_cslc_xuop_d  <=  inval_clr_lck and ex4_xuop_val;
xucr0_cslc_binv_d  <=  rel_lock_lost or dcperr_lock_lost_q or ex4_perr_lck_lost_q or
                     ex4_multihit_lock_lost or binv5_inval_lock_val_q or (rel_l1dump_cslc_q and not rel4_ecc_err);
ex3_cClass_upd_way_a  <=  ex3_cClass_wayA_hit;
ex3_cClass_upd_way_b  <=  ex3_cClass_wayB_hit;
ex3_cClass_upd_way_c  <=  ex3_cClass_wayC_hit;
ex3_cClass_upd_way_d  <=  ex3_cClass_wayD_hit;
ex3_cClass_upd_way_e  <=  ex3_cClass_wayE_hit;
ex3_cClass_upd_way_f  <=  ex3_cClass_wayF_hit;
ex3_cClass_upd_way_g  <=  ex3_cClass_wayG_hit;
ex3_cClass_upd_way_h  <=  ex3_cClass_wayH_hit;
-- Multihit Error Detected
-- ####################################################
-- Level 1
u_mh1_a01: hit_and_01_b          <=   not( xu_op_hit_wayA and xu_op_hit_wayB );
u_mh1_a23: hit_and_23_b          <=   not( xu_op_hit_wayC and xu_op_hit_wayD );
u_mh1_a45: hit_and_45_b          <=   not( xu_op_hit_wayE and xu_op_hit_wayF );
u_mh1_a67: hit_and_67_b          <=   not( xu_op_hit_wayG and xu_op_hit_wayH );
u_mh1_o01: hit_or_01_b           <=   not( xu_op_hit_wayA or  xu_op_hit_wayB );
u_mh1_o23: hit_or_23_b           <=   not( xu_op_hit_wayC or  xu_op_hit_wayD );
u_mh1_o45: hit_or_45_b           <=   not( xu_op_hit_wayE or  xu_op_hit_wayF );
u_mh1_o67: hit_or_67_b           <=   not( xu_op_hit_wayG or  xu_op_hit_wayH );
u_mh1_o13: hit_or_13_b           <=   not( xu_op_hit_wayB or  xu_op_hit_wayD );
u_mh1_o57: hit_or_57_b           <=   not( xu_op_hit_wayF or  xu_op_hit_wayH );
-- Level 2
u_mh2_o0123: hit_or_0123         <=   not( hit_or_01_b         and hit_or_23_b );
u_mh2_o4567: hit_or_4567         <=   not( hit_or_45_b         and hit_or_67_b );
u_mh2_o1357: hit_or_1357         <=   not( hit_or_13_b         and hit_or_57_b );
u_mh2_o2367: hit_or_2367         <=   not( hit_or_23_b         and hit_or_67_b );
u_mh2_a0123: hit_and_0123        <=   not( hit_or_01_b         or  hit_or_23_b );
u_mh2_a4567: hit_and_4567        <=   not( hit_or_45_b         or  hit_or_67_b );
u_mh2_err0:  multi_hit_err2_0    <=   not( hit_and_01_b and hit_and_23_b );
u_mh2_err1:  multi_hit_err2_1    <=   not( hit_and_45_b and hit_and_67_b );
-- Level 3
u_mh3_o:    hit_or_01234567_b    <=   not( hit_or_0123        or   hit_or_4567      );
u_mh3_err0: multi_hit_err3_b(0) <=   not( hit_or_0123       and   hit_or_4567      );
u_mh3_err1: multi_hit_err3_b(1) <=   not( hit_and_0123       or   hit_and_4567     );
u_mh3_err2: multi_hit_err3_b(2) <=   not( multi_hit_err2_0   or   multi_hit_err2_1 );
u_henc_0:   hit_enc_b(0) <=   not( hit_or_4567 );
u_henc_1:   hit_enc_b(1) <=   not( hit_or_2367 );
u_henc_2:   hit_enc_b(2) <=   not( hit_or_1357 );
-- Level 4
-- Multihit Error Detected
u_mh4_0: ex3_dir_multihit_val_0   <=   not( multi_hit_err3_b(0) and multi_hit_err3_b(1) );
u_mh4_1: ex3_dir_multihit_val_1   <=   not( multi_hit_err3_b(2) and inj_dir_multihit_b  );
-- Level 5
u_mh5:  ex3_dir_multihit_val_b  <=  not( ex3_dir_multihit_val_0 or ex3_dir_multihit_val_1 );
-- Level 6
u_mh6:  ex3_dir_multihit_val  <=  not ex3_dir_multihit_val_b ;
ex4_n_lsu_ddmh_flush_b_d  <=  (others=>ex3_dir_multihit_val);
ex4_dir_multihit_val      <=  binv4_ex4_dir_val_q and not ex4_dir_multihit_val_b_q;
inj_dir_multihit_b        <=  not (inj_dir_multihit_q and binv3_ex3_dir_val);
ex4_multihit_watch_lost   <=  gate(binv4_ex4_thrd_watch, ex4_dir_multihit_val);
ex4_multihit_lock_lost    <=  binv4_ex4_lock_set and ex4_dir_multihit_val;
-- ####################################################
-- Parity Error Detect
-- ####################################################
ex4_err_det_way_d(0) <=  perr_way_det_wayA;
perr_way_det_wayA            <=  wayA_val(0)   and ex3_tag_way_perr(0);
dirpar_err_lock_lost(0) <=  wayA_val(1)   and ex3_tag_way_perr(0);
perr_wayA_watch_lost         <=  gate(wayA_val(2   to 5),ex3_tag_way_perr(0));
ex4_err_det_way_d(1) <=  perr_way_det_wayB;
perr_way_det_wayB            <=  wayB_val(0)   and ex3_tag_way_perr(1);
dirpar_err_lock_lost(1) <=  wayB_val(1)   and ex3_tag_way_perr(1);
perr_wayB_watch_lost         <=  gate(wayB_val(2   to 5),ex3_tag_way_perr(1));
ex4_err_det_way_d(2) <=  perr_way_det_wayC;
perr_way_det_wayC            <=  wayC_val(0)   and ex3_tag_way_perr(2);
dirpar_err_lock_lost(2) <=  wayC_val(1)   and ex3_tag_way_perr(2);
perr_wayC_watch_lost         <=  gate(wayC_val(2   to 5),ex3_tag_way_perr(2));
ex4_err_det_way_d(3) <=  perr_way_det_wayD;
perr_way_det_wayD            <=  wayD_val(0)   and ex3_tag_way_perr(3);
dirpar_err_lock_lost(3) <=  wayD_val(1)   and ex3_tag_way_perr(3);
perr_wayD_watch_lost         <=  gate(wayD_val(2   to 5),ex3_tag_way_perr(3));
ex4_err_det_way_d(4) <=  perr_way_det_wayE;
perr_way_det_wayE            <=  wayE_val(0)   and ex3_tag_way_perr(4);
dirpar_err_lock_lost(4) <=  wayE_val(1)   and ex3_tag_way_perr(4);
perr_wayE_watch_lost         <=  gate(wayE_val(2   to 5),ex3_tag_way_perr(4));
ex4_err_det_way_d(5) <=  perr_way_det_wayF;
perr_way_det_wayF            <=  wayF_val(0)   and ex3_tag_way_perr(5);
dirpar_err_lock_lost(5) <=  wayF_val(1)   and ex3_tag_way_perr(5);
perr_wayF_watch_lost         <=  gate(wayF_val(2   to 5),ex3_tag_way_perr(5));
ex4_err_det_way_d(6) <=  perr_way_det_wayG;
perr_way_det_wayG            <=  wayG_val(0)   and ex3_tag_way_perr(6);
dirpar_err_lock_lost(6) <=  wayG_val(1)   and ex3_tag_way_perr(6);
perr_wayG_watch_lost         <=  gate(wayG_val(2   to 5),ex3_tag_way_perr(6));
ex4_err_det_way_d(7) <=  perr_way_det_wayH;
perr_way_det_wayH            <=  wayH_val(0)   and ex3_tag_way_perr(7);
dirpar_err_lock_lost(7) <=  wayH_val(1)   and ex3_tag_way_perr(7);
perr_wayH_watch_lost         <=  gate(wayH_val(2   to 5),ex3_tag_way_perr(7));
-- Lock Bit Lost due to Parity Error
ex4_perr_lck_lost_d  <=  or_reduce(dirpar_err_lock_lost);
-- Watch Lost due to Parity Error
ex4_perr_watch_lost_d  <=  perr_wayA_watch_lost or perr_wayB_watch_lost or perr_wayC_watch_lost or perr_wayD_watch_lost or
                         perr_wayE_watch_lost or perr_wayF_watch_lost or perr_wayG_watch_lost or perr_wayH_watch_lost;
-- Parity Error Detected
ex3_dir_perr_val  <=  perr_way_det_wayA or perr_way_det_wayB or perr_way_det_wayC or perr_way_det_wayD or
                    perr_way_det_wayE or perr_way_det_wayF or perr_way_det_wayG or perr_way_det_wayH;
-- Staging out Directory Error
ex4_dir_err_val_d  <=  ex3_dir_perr_val;
ex5_dir_err_val_d  <=  ex4_dir_err_val_q or ex4_dir_multihit_val;
ex6_dir_err_val_d  <=  ex5_dir_err_val_q;
derr2_stg_act_d    <=  ex6_dir_err_val_q;
derr3_stg_act_d    <=  derr2_stg_act_q;
derr4_stg_act_d    <=  derr3_stg_act_q;
derr5_stg_act_d    <=  derr4_stg_act_q;
-- ####################################################
-- Hit/Miss Detect
-- ####################################################
-- Execution Pipe Hit/Miss
ex3L1Hit:  ex3_l1hit   <=  not hit_or_01234567_b;
ex3L1Miss: ex3_l1miss  <=  not ex3_l1hit;
ex3_hit     <=  not ex3_l1miss;
ex4_miss    <=  not ex4_miss_q;
ex4_way_hit_d  <=  not (xu_op_hit_wayA_dly_b & xu_op_hit_wayB_dly_b & xu_op_hit_wayC_dly_b & xu_op_hit_wayD_dly_b &
                      xu_op_hit_wayE_dly_b & xu_op_hit_wayF_dly_b & xu_op_hit_wayG_dly_b & xu_op_hit_wayH_dly_b);
ex5_way_hit_d  <=  ex4_way_hit_q;
ex6_way_hit_d  <=  ex5_way_hit_q;
-- EX3 Way Hit Encode for upper address into Data Cache Array
ex3_xuop_up_addr_b    <=  hit_enc_b(0 to 2);
rel_dcarr_addr_sel    <=  (others=>rel_dcarr_addr_en);
rel_dcarr_addr_sel_b  <=  (others=>(not rel_dcarr_addr_en));
-- XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
-- Back-Invalidated Watched/Locked Line detection,
-- I need to do it late since instructions in the ahead of
-- back-invalidate could have set the watch/lost bit
-- Back-Invalidate does not look at instructions ahead of pipe,
-- since they might get flushed and will get bad results
-- Also includes Multihit Error Detect case
-- Staging out congruence class compares
congr_cl_ex3_ex4_cmp_d  <=  congr_cl_ex2_ex3_cmp_q;
congr_cl_ex3_ex5_cmp_d  <=  congr_cl_ex2_ex4_cmp_q;
congr_cl_ex3_ex6_cmp_d  <=  congr_cl_ex2_ex5_cmp_q;
congr_cl_ex4_ex5_cmp_d  <=  congr_cl_ex3_ex4_cmp_q;
congr_cl_ex4_ex6_cmp_d  <=  congr_cl_ex3_ex5_cmp_q;
congr_cl_ex4_ex7_cmp_d  <=  congr_cl_ex3_ex6_cmp_q;
-- Ways updated in other stages
binv4_ex4_way_upd  <=  binv_wayA_upd1 & binv_wayB_upd1 & binv_wayC_upd1 & binv_wayD_upd1 &
                     binv_wayE_upd1 & binv_wayF_upd1 & binv_wayG_upd1 & binv_wayH_upd1;
binv5_ex5_way_upd  <=  binv_wayA_upd2_q & binv_wayB_upd2_q & binv_wayC_upd2_q & binv_wayD_upd2_q &
                     binv_wayE_upd2_q & binv_wayF_upd2_q & binv_wayG_upd2_q & binv_wayH_upd2_q;
binv6_ex6_way_upd  <=  binv_wayA_upd3_q & binv_wayB_upd3_q & binv_wayC_upd3_q & binv_wayD_upd3_q &
                     binv_wayE_upd3_q & binv_wayF_upd3_q & binv_wayG_upd3_q & binv_wayH_upd3_q;
binv7_ex7_way_upd_d  <=  binv6_ex6_way_upd;
-- Data of ways updated in other stages
binv4_ex4_dir_data  <=  gate(flush_wayA_data1(1 to 5), binv4_ex4_way_upd(0)) or gate(flush_wayB_data1(1 to 5), binv4_ex4_way_upd(1)) or
                      gate(flush_wayC_data1(1 to 5), binv4_ex4_way_upd(2)) or gate(flush_wayD_data1(1 to 5), binv4_ex4_way_upd(3)) or
                      gate(flush_wayE_data1(1 to 5), binv4_ex4_way_upd(4)) or gate(flush_wayF_data1(1 to 5), binv4_ex4_way_upd(5)) or
                      gate(flush_wayG_data1(1 to 5), binv4_ex4_way_upd(6)) or gate(flush_wayH_data1(1 to 5), binv4_ex4_way_upd(7));
binv5_ex5_dir_data_d  <=  binv4_ex4_dir_data;
binv6_ex6_dir_data_d  <=  binv5_ex5_dir_data_q;
binv7_ex7_dir_data_d  <=  binv6_ex6_dir_data_q;
-- None Bypass Locked Line lost indicator
binv4_inval_lck    <=  inval_clr_lck and back_inval_stg4_q and not binv4_coll_val;
-- None Bypass Watch Lost indicator
binv4_inval_watch  <=  gate(ex4_lost_watch, (back_inval_stg4_q and not binv4_coll_val));
-- Stage Bypass Select
binv4_ex5_coll   <=  (back_inval_stg4_q or ex4_dir_multihit_val) and congr_cl_ex4_ex5_cmp_q and or_reduce(ex4_way_hit_q and binv5_ex5_way_upd)   and p0_wren_d;
binv4_ex6_coll   <=  (back_inval_stg4_q or ex4_dir_multihit_val) and congr_cl_ex4_ex6_cmp_q and or_reduce(ex4_way_hit_q and binv6_ex6_way_upd)   and p0_wren_q;
binv4_ex7_coll   <=  (back_inval_stg4_q or ex4_dir_multihit_val) and congr_cl_ex4_ex7_cmp_q and or_reduce(ex4_way_hit_q and binv7_ex7_way_upd_q) and p0_wren_stg_q;
binv4_coll_val   <=  binv4_ex5_coll or binv4_ex6_coll or binv4_ex7_coll;
-- Priority Calculation
binv4_pri_byp_sel(0) <=  binv4_ex5_coll;
binv4_pri_byp_sel(1) <=  binv4_ex6_coll and not binv4_ex5_coll;
binv4_pri_byp_sel(2) <=  binv4_ex7_coll and not (binv4_ex6_coll or binv4_ex5_coll);
-- Data Bypass
binv4_byp_dir_data  <=  gate(binv5_ex5_dir_data_q, binv4_pri_byp_sel(0)) or
                      gate(binv6_ex6_dir_data_q, binv4_pri_byp_sel(1)) or
                      gate(binv7_ex7_dir_data_q, binv4_pri_byp_sel(2));
-- Back-Invalidate invalidated a watched line
binv5_inval_watch_val_d  <=  (binv4_byp_dir_data(2 to 5) and not binv4_ex4_dir_data(2 to 5)) or binv4_inval_watch;
-- Back-Invalidate invalidated a locked line
binv5_inval_lock_val_d  <=  (binv4_byp_dir_data(1) and not binv4_ex4_dir_data(1)) or binv4_inval_lck;
-- XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
-- XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
-- Watch Lost due to DCI
dci_watch_lost  <=  (others=>dci_compl_q);
-- XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
-- ####################################################
-- Resource Conflict Flushes
-- ####################################################
-- Determine if another thread is modifying any of the Directory bits, Need to flush if this thread targets same congruence class and way
congr_cl_ex3_upd_wayA    <=  congr_cl_ex2_ex3_cmp_q and not ex3_thrd_m_q and ex3_xuop_wayA_upd     and not ex3_stg_flush;
congr_cl_ex4_upd_wayA    <=  congr_cl_ex2_ex4_cmp_q and not ex4_thrd_m_q and ex4_xuop_wayA_upd_q   and not ex4_stg_flush;
congr_cl_ex5_upd_wayA    <=  congr_cl_ex2_ex5_cmp_q and not ex5_thrd_m_q and ex5_xuop_wayA_upd_q   and not ex5_stg_flush;
congr_cl_m_upd_wayA_d    <=  congr_cl_ex3_upd_wayA   or congr_cl_ex4_upd_wayA   or congr_cl_ex5_upd_wayA;
-- causing a flush for the thread that matches congruence class and directory way being updated by a different thread
ex3_cClass_wayA_hit    <=  fxu_pipe_val and congr_cl_m_upd_wayA_q   and wayA_val(0);
-- Determine if another thread is modifying any of the Directory bits, Need to flush if this thread targets same congruence class and way
congr_cl_ex3_upd_wayB    <=  congr_cl_ex2_ex3_cmp_q and not ex3_thrd_m_q and ex3_xuop_wayB_upd     and not ex3_stg_flush;
congr_cl_ex4_upd_wayB    <=  congr_cl_ex2_ex4_cmp_q and not ex4_thrd_m_q and ex4_xuop_wayB_upd_q   and not ex4_stg_flush;
congr_cl_ex5_upd_wayB    <=  congr_cl_ex2_ex5_cmp_q and not ex5_thrd_m_q and ex5_xuop_wayB_upd_q   and not ex5_stg_flush;
congr_cl_m_upd_wayB_d    <=  congr_cl_ex3_upd_wayB   or congr_cl_ex4_upd_wayB   or congr_cl_ex5_upd_wayB;
-- causing a flush for the thread that matches congruence class and directory way being updated by a different thread
ex3_cClass_wayB_hit    <=  fxu_pipe_val and congr_cl_m_upd_wayB_q   and wayB_val(0);
-- Determine if another thread is modifying any of the Directory bits, Need to flush if this thread targets same congruence class and way
congr_cl_ex3_upd_wayC    <=  congr_cl_ex2_ex3_cmp_q and not ex3_thrd_m_q and ex3_xuop_wayC_upd     and not ex3_stg_flush;
congr_cl_ex4_upd_wayC    <=  congr_cl_ex2_ex4_cmp_q and not ex4_thrd_m_q and ex4_xuop_wayC_upd_q   and not ex4_stg_flush;
congr_cl_ex5_upd_wayC    <=  congr_cl_ex2_ex5_cmp_q and not ex5_thrd_m_q and ex5_xuop_wayC_upd_q   and not ex5_stg_flush;
congr_cl_m_upd_wayC_d    <=  congr_cl_ex3_upd_wayC   or congr_cl_ex4_upd_wayC   or congr_cl_ex5_upd_wayC;
-- causing a flush for the thread that matches congruence class and directory way being updated by a different thread
ex3_cClass_wayC_hit    <=  fxu_pipe_val and congr_cl_m_upd_wayC_q   and wayC_val(0);
-- Determine if another thread is modifying any of the Directory bits, Need to flush if this thread targets same congruence class and way
congr_cl_ex3_upd_wayD    <=  congr_cl_ex2_ex3_cmp_q and not ex3_thrd_m_q and ex3_xuop_wayD_upd     and not ex3_stg_flush;
congr_cl_ex4_upd_wayD    <=  congr_cl_ex2_ex4_cmp_q and not ex4_thrd_m_q and ex4_xuop_wayD_upd_q   and not ex4_stg_flush;
congr_cl_ex5_upd_wayD    <=  congr_cl_ex2_ex5_cmp_q and not ex5_thrd_m_q and ex5_xuop_wayD_upd_q   and not ex5_stg_flush;
congr_cl_m_upd_wayD_d    <=  congr_cl_ex3_upd_wayD   or congr_cl_ex4_upd_wayD   or congr_cl_ex5_upd_wayD;
-- causing a flush for the thread that matches congruence class and directory way being updated by a different thread
ex3_cClass_wayD_hit    <=  fxu_pipe_val and congr_cl_m_upd_wayD_q   and wayD_val(0);
-- Determine if another thread is modifying any of the Directory bits, Need to flush if this thread targets same congruence class and way
congr_cl_ex3_upd_wayE    <=  congr_cl_ex2_ex3_cmp_q and not ex3_thrd_m_q and ex3_xuop_wayE_upd     and not ex3_stg_flush;
congr_cl_ex4_upd_wayE    <=  congr_cl_ex2_ex4_cmp_q and not ex4_thrd_m_q and ex4_xuop_wayE_upd_q   and not ex4_stg_flush;
congr_cl_ex5_upd_wayE    <=  congr_cl_ex2_ex5_cmp_q and not ex5_thrd_m_q and ex5_xuop_wayE_upd_q   and not ex5_stg_flush;
congr_cl_m_upd_wayE_d    <=  congr_cl_ex3_upd_wayE   or congr_cl_ex4_upd_wayE   or congr_cl_ex5_upd_wayE;
-- causing a flush for the thread that matches congruence class and directory way being updated by a different thread
ex3_cClass_wayE_hit    <=  fxu_pipe_val and congr_cl_m_upd_wayE_q   and wayE_val(0);
-- Determine if another thread is modifying any of the Directory bits, Need to flush if this thread targets same congruence class and way
congr_cl_ex3_upd_wayF    <=  congr_cl_ex2_ex3_cmp_q and not ex3_thrd_m_q and ex3_xuop_wayF_upd     and not ex3_stg_flush;
congr_cl_ex4_upd_wayF    <=  congr_cl_ex2_ex4_cmp_q and not ex4_thrd_m_q and ex4_xuop_wayF_upd_q   and not ex4_stg_flush;
congr_cl_ex5_upd_wayF    <=  congr_cl_ex2_ex5_cmp_q and not ex5_thrd_m_q and ex5_xuop_wayF_upd_q   and not ex5_stg_flush;
congr_cl_m_upd_wayF_d    <=  congr_cl_ex3_upd_wayF   or congr_cl_ex4_upd_wayF   or congr_cl_ex5_upd_wayF;
-- causing a flush for the thread that matches congruence class and directory way being updated by a different thread
ex3_cClass_wayF_hit    <=  fxu_pipe_val and congr_cl_m_upd_wayF_q   and wayF_val(0);
-- Determine if another thread is modifying any of the Directory bits, Need to flush if this thread targets same congruence class and way
congr_cl_ex3_upd_wayG    <=  congr_cl_ex2_ex3_cmp_q and not ex3_thrd_m_q and ex3_xuop_wayG_upd     and not ex3_stg_flush;
congr_cl_ex4_upd_wayG    <=  congr_cl_ex2_ex4_cmp_q and not ex4_thrd_m_q and ex4_xuop_wayG_upd_q   and not ex4_stg_flush;
congr_cl_ex5_upd_wayG    <=  congr_cl_ex2_ex5_cmp_q and not ex5_thrd_m_q and ex5_xuop_wayG_upd_q   and not ex5_stg_flush;
congr_cl_m_upd_wayG_d    <=  congr_cl_ex3_upd_wayG   or congr_cl_ex4_upd_wayG   or congr_cl_ex5_upd_wayG;
-- causing a flush for the thread that matches congruence class and directory way being updated by a different thread
ex3_cClass_wayG_hit    <=  fxu_pipe_val and congr_cl_m_upd_wayG_q   and wayG_val(0);
-- Determine if another thread is modifying any of the Directory bits, Need to flush if this thread targets same congruence class and way
congr_cl_ex3_upd_wayH    <=  congr_cl_ex2_ex3_cmp_q and not ex3_thrd_m_q and ex3_xuop_wayH_upd     and not ex3_stg_flush;
congr_cl_ex4_upd_wayH    <=  congr_cl_ex2_ex4_cmp_q and not ex4_thrd_m_q and ex4_xuop_wayH_upd_q   and not ex4_stg_flush;
congr_cl_ex5_upd_wayH    <=  congr_cl_ex2_ex5_cmp_q and not ex5_thrd_m_q and ex5_xuop_wayH_upd_q   and not ex5_stg_flush;
congr_cl_m_upd_wayH_d    <=  congr_cl_ex3_upd_wayH   or congr_cl_ex4_upd_wayH   or congr_cl_ex5_upd_wayH;
-- causing a flush for the thread that matches congruence class and directory way being updated by a different thread
ex3_cClass_wayH_hit    <=  fxu_pipe_val and congr_cl_m_upd_wayH_q   and wayH_val(0);
-- Watch Clear udate in the pipe for a different thread
ex3_wclr_all_upd_val  <=  ex3_watch_clr_all_q and not ex3_thrd_m_q and not ex3_stg_flush;
ex4_wclr_all_upd_val  <=  ex4_wclr_all_val_q  and not ex4_thrd_m_q and not ex4_stg_flush;
ex5_wclr_all_upd_val  <=  ex5_wclr_all_val_q  and not ex5_thrd_m_q and not ex5_stg_flush;
ex6_wclr_all_upd_val  <=  ex6_wclr_all_val_q  and not ex6_thrd_m_q;
-- causing a flush for the thread that is trying to access the directory when a different thread is doing a watch clear all
ex3_wclr_all_upd_d  <=  ex3_wclr_all_upd_val or ex4_wclr_all_upd_val or ex5_wclr_all_upd_val or ex6_wclr_all_upd_val;
-- ####################################################
-- Reload Pipe
-- ####################################################
-- Reload Path Directory Valid Bits Muxing
-- Reload Stage 1
-- Select Congruence Class Way A
with rel_congr_cl_q select
    rel_arr_wayA_val    <= 
                        congr_cl0_wA_q     when "000000",
                        congr_cl1_wA_q     when "000001",
                        congr_cl2_wA_q     when "000010",
                        congr_cl3_wA_q     when "000011",
                        congr_cl4_wA_q     when "000100",
                        congr_cl5_wA_q     when "000101",
                        congr_cl6_wA_q     when "000110",
                        congr_cl7_wA_q     when "000111",
                        congr_cl8_wA_q     when "001000",
                        congr_cl9_wA_q     when "001001",
                        congr_cl10_wA_q    when "001010",
                        congr_cl11_wA_q    when "001011",
                        congr_cl12_wA_q    when "001100",
                        congr_cl13_wA_q    when "001101",
                        congr_cl14_wA_q    when "001110",
                        congr_cl15_wA_q    when "001111",
                        congr_cl16_wA_q    when "010000",
                        congr_cl17_wA_q    when "010001",
                        congr_cl18_wA_q    when "010010",
                        congr_cl19_wA_q    when "010011",
                        congr_cl20_wA_q    when "010100",
                        congr_cl21_wA_q    when "010101",
                        congr_cl22_wA_q    when "010110",
                        congr_cl23_wA_q    when "010111",
                        congr_cl24_wA_q    when "011000",
                        congr_cl25_wA_q    when "011001",
                        congr_cl26_wA_q    when "011010",
                        congr_cl27_wA_q    when "011011",
                        congr_cl28_wA_q    when "011100",
                        congr_cl29_wA_q    when "011101",
                        congr_cl30_wA_q    when "011110",
                        congr_cl31_wA_q    when "011111",
                        congr_cl32_wA_q    when "100000",
                        congr_cl33_wA_q    when "100001",
                        congr_cl34_wA_q    when "100010",
                        congr_cl35_wA_q    when "100011",
                        congr_cl36_wA_q    when "100100",
                        congr_cl37_wA_q    when "100101",
                        congr_cl38_wA_q    when "100110",
                        congr_cl39_wA_q    when "100111",
                        congr_cl40_wA_q    when "101000",
                        congr_cl41_wA_q    when "101001",
                        congr_cl42_wA_q    when "101010",
                        congr_cl43_wA_q    when "101011",
                        congr_cl44_wA_q    when "101100",
                        congr_cl45_wA_q    when "101101",
                        congr_cl46_wA_q    when "101110",
                        congr_cl47_wA_q    when "101111",
                        congr_cl48_wA_q    when "110000",
                        congr_cl49_wA_q    when "110001",
                        congr_cl50_wA_q    when "110010",
                        congr_cl51_wA_q    when "110011",
                        congr_cl52_wA_q    when "110100",
                        congr_cl53_wA_q    when "110101",
                        congr_cl54_wA_q    when "110110",
                        congr_cl55_wA_q    when "110111",
                        congr_cl56_wA_q    when "111000",
                        congr_cl57_wA_q    when "111001",
                        congr_cl58_wA_q    when "111010",
                        congr_cl59_wA_q    when "111011",
                        congr_cl60_wA_q    when "111100",
                        congr_cl61_wA_q    when "111101",
                        congr_cl62_wA_q    when "111110",
                        congr_cl63_wA_q   when others;
p1_arr_wayA_rd    <=  rel_arr_wayA_val;
-- Select Congruence Class Way B
with rel_congr_cl_q select
    rel_arr_wayB_val    <= 
                        congr_cl0_wB_q     when "000000",
                        congr_cl1_wB_q     when "000001",
                        congr_cl2_wB_q     when "000010",
                        congr_cl3_wB_q     when "000011",
                        congr_cl4_wB_q     when "000100",
                        congr_cl5_wB_q     when "000101",
                        congr_cl6_wB_q     when "000110",
                        congr_cl7_wB_q     when "000111",
                        congr_cl8_wB_q     when "001000",
                        congr_cl9_wB_q     when "001001",
                        congr_cl10_wB_q    when "001010",
                        congr_cl11_wB_q    when "001011",
                        congr_cl12_wB_q    when "001100",
                        congr_cl13_wB_q    when "001101",
                        congr_cl14_wB_q    when "001110",
                        congr_cl15_wB_q    when "001111",
                        congr_cl16_wB_q    when "010000",
                        congr_cl17_wB_q    when "010001",
                        congr_cl18_wB_q    when "010010",
                        congr_cl19_wB_q    when "010011",
                        congr_cl20_wB_q    when "010100",
                        congr_cl21_wB_q    when "010101",
                        congr_cl22_wB_q    when "010110",
                        congr_cl23_wB_q    when "010111",
                        congr_cl24_wB_q    when "011000",
                        congr_cl25_wB_q    when "011001",
                        congr_cl26_wB_q    when "011010",
                        congr_cl27_wB_q    when "011011",
                        congr_cl28_wB_q    when "011100",
                        congr_cl29_wB_q    when "011101",
                        congr_cl30_wB_q    when "011110",
                        congr_cl31_wB_q    when "011111",
                        congr_cl32_wB_q    when "100000",
                        congr_cl33_wB_q    when "100001",
                        congr_cl34_wB_q    when "100010",
                        congr_cl35_wB_q    when "100011",
                        congr_cl36_wB_q    when "100100",
                        congr_cl37_wB_q    when "100101",
                        congr_cl38_wB_q    when "100110",
                        congr_cl39_wB_q    when "100111",
                        congr_cl40_wB_q    when "101000",
                        congr_cl41_wB_q    when "101001",
                        congr_cl42_wB_q    when "101010",
                        congr_cl43_wB_q    when "101011",
                        congr_cl44_wB_q    when "101100",
                        congr_cl45_wB_q    when "101101",
                        congr_cl46_wB_q    when "101110",
                        congr_cl47_wB_q    when "101111",
                        congr_cl48_wB_q    when "110000",
                        congr_cl49_wB_q    when "110001",
                        congr_cl50_wB_q    when "110010",
                        congr_cl51_wB_q    when "110011",
                        congr_cl52_wB_q    when "110100",
                        congr_cl53_wB_q    when "110101",
                        congr_cl54_wB_q    when "110110",
                        congr_cl55_wB_q    when "110111",
                        congr_cl56_wB_q    when "111000",
                        congr_cl57_wB_q    when "111001",
                        congr_cl58_wB_q    when "111010",
                        congr_cl59_wB_q    when "111011",
                        congr_cl60_wB_q    when "111100",
                        congr_cl61_wB_q    when "111101",
                        congr_cl62_wB_q    when "111110",
                        congr_cl63_wB_q   when others;
p1_arr_wayB_rd    <=  rel_arr_wayB_val;
-- Select Congruence Class Way C
with rel_congr_cl_q select
    rel_arr_wayC_val    <= 
                        congr_cl0_wC_q     when "000000",
                        congr_cl1_wC_q     when "000001",
                        congr_cl2_wC_q     when "000010",
                        congr_cl3_wC_q     when "000011",
                        congr_cl4_wC_q     when "000100",
                        congr_cl5_wC_q     when "000101",
                        congr_cl6_wC_q     when "000110",
                        congr_cl7_wC_q     when "000111",
                        congr_cl8_wC_q     when "001000",
                        congr_cl9_wC_q     when "001001",
                        congr_cl10_wC_q    when "001010",
                        congr_cl11_wC_q    when "001011",
                        congr_cl12_wC_q    when "001100",
                        congr_cl13_wC_q    when "001101",
                        congr_cl14_wC_q    when "001110",
                        congr_cl15_wC_q    when "001111",
                        congr_cl16_wC_q    when "010000",
                        congr_cl17_wC_q    when "010001",
                        congr_cl18_wC_q    when "010010",
                        congr_cl19_wC_q    when "010011",
                        congr_cl20_wC_q    when "010100",
                        congr_cl21_wC_q    when "010101",
                        congr_cl22_wC_q    when "010110",
                        congr_cl23_wC_q    when "010111",
                        congr_cl24_wC_q    when "011000",
                        congr_cl25_wC_q    when "011001",
                        congr_cl26_wC_q    when "011010",
                        congr_cl27_wC_q    when "011011",
                        congr_cl28_wC_q    when "011100",
                        congr_cl29_wC_q    when "011101",
                        congr_cl30_wC_q    when "011110",
                        congr_cl31_wC_q    when "011111",
                        congr_cl32_wC_q    when "100000",
                        congr_cl33_wC_q    when "100001",
                        congr_cl34_wC_q    when "100010",
                        congr_cl35_wC_q    when "100011",
                        congr_cl36_wC_q    when "100100",
                        congr_cl37_wC_q    when "100101",
                        congr_cl38_wC_q    when "100110",
                        congr_cl39_wC_q    when "100111",
                        congr_cl40_wC_q    when "101000",
                        congr_cl41_wC_q    when "101001",
                        congr_cl42_wC_q    when "101010",
                        congr_cl43_wC_q    when "101011",
                        congr_cl44_wC_q    when "101100",
                        congr_cl45_wC_q    when "101101",
                        congr_cl46_wC_q    when "101110",
                        congr_cl47_wC_q    when "101111",
                        congr_cl48_wC_q    when "110000",
                        congr_cl49_wC_q    when "110001",
                        congr_cl50_wC_q    when "110010",
                        congr_cl51_wC_q    when "110011",
                        congr_cl52_wC_q    when "110100",
                        congr_cl53_wC_q    when "110101",
                        congr_cl54_wC_q    when "110110",
                        congr_cl55_wC_q    when "110111",
                        congr_cl56_wC_q    when "111000",
                        congr_cl57_wC_q    when "111001",
                        congr_cl58_wC_q    when "111010",
                        congr_cl59_wC_q    when "111011",
                        congr_cl60_wC_q    when "111100",
                        congr_cl61_wC_q    when "111101",
                        congr_cl62_wC_q    when "111110",
                        congr_cl63_wC_q   when others;
p1_arr_wayC_rd    <=  rel_arr_wayC_val;
-- Select Congruence Class Way D
with rel_congr_cl_q select
    rel_arr_wayD_val    <= 
                        congr_cl0_wD_q     when "000000",
                        congr_cl1_wD_q     when "000001",
                        congr_cl2_wD_q     when "000010",
                        congr_cl3_wD_q     when "000011",
                        congr_cl4_wD_q     when "000100",
                        congr_cl5_wD_q     when "000101",
                        congr_cl6_wD_q     when "000110",
                        congr_cl7_wD_q     when "000111",
                        congr_cl8_wD_q     when "001000",
                        congr_cl9_wD_q     when "001001",
                        congr_cl10_wD_q    when "001010",
                        congr_cl11_wD_q    when "001011",
                        congr_cl12_wD_q    when "001100",
                        congr_cl13_wD_q    when "001101",
                        congr_cl14_wD_q    when "001110",
                        congr_cl15_wD_q    when "001111",
                        congr_cl16_wD_q    when "010000",
                        congr_cl17_wD_q    when "010001",
                        congr_cl18_wD_q    when "010010",
                        congr_cl19_wD_q    when "010011",
                        congr_cl20_wD_q    when "010100",
                        congr_cl21_wD_q    when "010101",
                        congr_cl22_wD_q    when "010110",
                        congr_cl23_wD_q    when "010111",
                        congr_cl24_wD_q    when "011000",
                        congr_cl25_wD_q    when "011001",
                        congr_cl26_wD_q    when "011010",
                        congr_cl27_wD_q    when "011011",
                        congr_cl28_wD_q    when "011100",
                        congr_cl29_wD_q    when "011101",
                        congr_cl30_wD_q    when "011110",
                        congr_cl31_wD_q    when "011111",
                        congr_cl32_wD_q    when "100000",
                        congr_cl33_wD_q    when "100001",
                        congr_cl34_wD_q    when "100010",
                        congr_cl35_wD_q    when "100011",
                        congr_cl36_wD_q    when "100100",
                        congr_cl37_wD_q    when "100101",
                        congr_cl38_wD_q    when "100110",
                        congr_cl39_wD_q    when "100111",
                        congr_cl40_wD_q    when "101000",
                        congr_cl41_wD_q    when "101001",
                        congr_cl42_wD_q    when "101010",
                        congr_cl43_wD_q    when "101011",
                        congr_cl44_wD_q    when "101100",
                        congr_cl45_wD_q    when "101101",
                        congr_cl46_wD_q    when "101110",
                        congr_cl47_wD_q    when "101111",
                        congr_cl48_wD_q    when "110000",
                        congr_cl49_wD_q    when "110001",
                        congr_cl50_wD_q    when "110010",
                        congr_cl51_wD_q    when "110011",
                        congr_cl52_wD_q    when "110100",
                        congr_cl53_wD_q    when "110101",
                        congr_cl54_wD_q    when "110110",
                        congr_cl55_wD_q    when "110111",
                        congr_cl56_wD_q    when "111000",
                        congr_cl57_wD_q    when "111001",
                        congr_cl58_wD_q    when "111010",
                        congr_cl59_wD_q    when "111011",
                        congr_cl60_wD_q    when "111100",
                        congr_cl61_wD_q    when "111101",
                        congr_cl62_wD_q    when "111110",
                        congr_cl63_wD_q   when others;
p1_arr_wayD_rd    <=  rel_arr_wayD_val;
-- Select Congruence Class Way E
with rel_congr_cl_q select
    rel_arr_wayE_val    <= 
                        congr_cl0_wE_q     when "000000",
                        congr_cl1_wE_q     when "000001",
                        congr_cl2_wE_q     when "000010",
                        congr_cl3_wE_q     when "000011",
                        congr_cl4_wE_q     when "000100",
                        congr_cl5_wE_q     when "000101",
                        congr_cl6_wE_q     when "000110",
                        congr_cl7_wE_q     when "000111",
                        congr_cl8_wE_q     when "001000",
                        congr_cl9_wE_q     when "001001",
                        congr_cl10_wE_q    when "001010",
                        congr_cl11_wE_q    when "001011",
                        congr_cl12_wE_q    when "001100",
                        congr_cl13_wE_q    when "001101",
                        congr_cl14_wE_q    when "001110",
                        congr_cl15_wE_q    when "001111",
                        congr_cl16_wE_q    when "010000",
                        congr_cl17_wE_q    when "010001",
                        congr_cl18_wE_q    when "010010",
                        congr_cl19_wE_q    when "010011",
                        congr_cl20_wE_q    when "010100",
                        congr_cl21_wE_q    when "010101",
                        congr_cl22_wE_q    when "010110",
                        congr_cl23_wE_q    when "010111",
                        congr_cl24_wE_q    when "011000",
                        congr_cl25_wE_q    when "011001",
                        congr_cl26_wE_q    when "011010",
                        congr_cl27_wE_q    when "011011",
                        congr_cl28_wE_q    when "011100",
                        congr_cl29_wE_q    when "011101",
                        congr_cl30_wE_q    when "011110",
                        congr_cl31_wE_q    when "011111",
                        congr_cl32_wE_q    when "100000",
                        congr_cl33_wE_q    when "100001",
                        congr_cl34_wE_q    when "100010",
                        congr_cl35_wE_q    when "100011",
                        congr_cl36_wE_q    when "100100",
                        congr_cl37_wE_q    when "100101",
                        congr_cl38_wE_q    when "100110",
                        congr_cl39_wE_q    when "100111",
                        congr_cl40_wE_q    when "101000",
                        congr_cl41_wE_q    when "101001",
                        congr_cl42_wE_q    when "101010",
                        congr_cl43_wE_q    when "101011",
                        congr_cl44_wE_q    when "101100",
                        congr_cl45_wE_q    when "101101",
                        congr_cl46_wE_q    when "101110",
                        congr_cl47_wE_q    when "101111",
                        congr_cl48_wE_q    when "110000",
                        congr_cl49_wE_q    when "110001",
                        congr_cl50_wE_q    when "110010",
                        congr_cl51_wE_q    when "110011",
                        congr_cl52_wE_q    when "110100",
                        congr_cl53_wE_q    when "110101",
                        congr_cl54_wE_q    when "110110",
                        congr_cl55_wE_q    when "110111",
                        congr_cl56_wE_q    when "111000",
                        congr_cl57_wE_q    when "111001",
                        congr_cl58_wE_q    when "111010",
                        congr_cl59_wE_q    when "111011",
                        congr_cl60_wE_q    when "111100",
                        congr_cl61_wE_q    when "111101",
                        congr_cl62_wE_q    when "111110",
                        congr_cl63_wE_q   when others;
p1_arr_wayE_rd    <=  rel_arr_wayE_val;
-- Select Congruence Class Way F
with rel_congr_cl_q select
    rel_arr_wayF_val    <= 
                        congr_cl0_wF_q     when "000000",
                        congr_cl1_wF_q     when "000001",
                        congr_cl2_wF_q     when "000010",
                        congr_cl3_wF_q     when "000011",
                        congr_cl4_wF_q     when "000100",
                        congr_cl5_wF_q     when "000101",
                        congr_cl6_wF_q     when "000110",
                        congr_cl7_wF_q     when "000111",
                        congr_cl8_wF_q     when "001000",
                        congr_cl9_wF_q     when "001001",
                        congr_cl10_wF_q    when "001010",
                        congr_cl11_wF_q    when "001011",
                        congr_cl12_wF_q    when "001100",
                        congr_cl13_wF_q    when "001101",
                        congr_cl14_wF_q    when "001110",
                        congr_cl15_wF_q    when "001111",
                        congr_cl16_wF_q    when "010000",
                        congr_cl17_wF_q    when "010001",
                        congr_cl18_wF_q    when "010010",
                        congr_cl19_wF_q    when "010011",
                        congr_cl20_wF_q    when "010100",
                        congr_cl21_wF_q    when "010101",
                        congr_cl22_wF_q    when "010110",
                        congr_cl23_wF_q    when "010111",
                        congr_cl24_wF_q    when "011000",
                        congr_cl25_wF_q    when "011001",
                        congr_cl26_wF_q    when "011010",
                        congr_cl27_wF_q    when "011011",
                        congr_cl28_wF_q    when "011100",
                        congr_cl29_wF_q    when "011101",
                        congr_cl30_wF_q    when "011110",
                        congr_cl31_wF_q    when "011111",
                        congr_cl32_wF_q    when "100000",
                        congr_cl33_wF_q    when "100001",
                        congr_cl34_wF_q    when "100010",
                        congr_cl35_wF_q    when "100011",
                        congr_cl36_wF_q    when "100100",
                        congr_cl37_wF_q    when "100101",
                        congr_cl38_wF_q    when "100110",
                        congr_cl39_wF_q    when "100111",
                        congr_cl40_wF_q    when "101000",
                        congr_cl41_wF_q    when "101001",
                        congr_cl42_wF_q    when "101010",
                        congr_cl43_wF_q    when "101011",
                        congr_cl44_wF_q    when "101100",
                        congr_cl45_wF_q    when "101101",
                        congr_cl46_wF_q    when "101110",
                        congr_cl47_wF_q    when "101111",
                        congr_cl48_wF_q    when "110000",
                        congr_cl49_wF_q    when "110001",
                        congr_cl50_wF_q    when "110010",
                        congr_cl51_wF_q    when "110011",
                        congr_cl52_wF_q    when "110100",
                        congr_cl53_wF_q    when "110101",
                        congr_cl54_wF_q    when "110110",
                        congr_cl55_wF_q    when "110111",
                        congr_cl56_wF_q    when "111000",
                        congr_cl57_wF_q    when "111001",
                        congr_cl58_wF_q    when "111010",
                        congr_cl59_wF_q    when "111011",
                        congr_cl60_wF_q    when "111100",
                        congr_cl61_wF_q    when "111101",
                        congr_cl62_wF_q    when "111110",
                        congr_cl63_wF_q   when others;
p1_arr_wayF_rd    <=  rel_arr_wayF_val;
-- Select Congruence Class Way G
with rel_congr_cl_q select
    rel_arr_wayG_val    <= 
                        congr_cl0_wG_q     when "000000",
                        congr_cl1_wG_q     when "000001",
                        congr_cl2_wG_q     when "000010",
                        congr_cl3_wG_q     when "000011",
                        congr_cl4_wG_q     when "000100",
                        congr_cl5_wG_q     when "000101",
                        congr_cl6_wG_q     when "000110",
                        congr_cl7_wG_q     when "000111",
                        congr_cl8_wG_q     when "001000",
                        congr_cl9_wG_q     when "001001",
                        congr_cl10_wG_q    when "001010",
                        congr_cl11_wG_q    when "001011",
                        congr_cl12_wG_q    when "001100",
                        congr_cl13_wG_q    when "001101",
                        congr_cl14_wG_q    when "001110",
                        congr_cl15_wG_q    when "001111",
                        congr_cl16_wG_q    when "010000",
                        congr_cl17_wG_q    when "010001",
                        congr_cl18_wG_q    when "010010",
                        congr_cl19_wG_q    when "010011",
                        congr_cl20_wG_q    when "010100",
                        congr_cl21_wG_q    when "010101",
                        congr_cl22_wG_q    when "010110",
                        congr_cl23_wG_q    when "010111",
                        congr_cl24_wG_q    when "011000",
                        congr_cl25_wG_q    when "011001",
                        congr_cl26_wG_q    when "011010",
                        congr_cl27_wG_q    when "011011",
                        congr_cl28_wG_q    when "011100",
                        congr_cl29_wG_q    when "011101",
                        congr_cl30_wG_q    when "011110",
                        congr_cl31_wG_q    when "011111",
                        congr_cl32_wG_q    when "100000",
                        congr_cl33_wG_q    when "100001",
                        congr_cl34_wG_q    when "100010",
                        congr_cl35_wG_q    when "100011",
                        congr_cl36_wG_q    when "100100",
                        congr_cl37_wG_q    when "100101",
                        congr_cl38_wG_q    when "100110",
                        congr_cl39_wG_q    when "100111",
                        congr_cl40_wG_q    when "101000",
                        congr_cl41_wG_q    when "101001",
                        congr_cl42_wG_q    when "101010",
                        congr_cl43_wG_q    when "101011",
                        congr_cl44_wG_q    when "101100",
                        congr_cl45_wG_q    when "101101",
                        congr_cl46_wG_q    when "101110",
                        congr_cl47_wG_q    when "101111",
                        congr_cl48_wG_q    when "110000",
                        congr_cl49_wG_q    when "110001",
                        congr_cl50_wG_q    when "110010",
                        congr_cl51_wG_q    when "110011",
                        congr_cl52_wG_q    when "110100",
                        congr_cl53_wG_q    when "110101",
                        congr_cl54_wG_q    when "110110",
                        congr_cl55_wG_q    when "110111",
                        congr_cl56_wG_q    when "111000",
                        congr_cl57_wG_q    when "111001",
                        congr_cl58_wG_q    when "111010",
                        congr_cl59_wG_q    when "111011",
                        congr_cl60_wG_q    when "111100",
                        congr_cl61_wG_q    when "111101",
                        congr_cl62_wG_q    when "111110",
                        congr_cl63_wG_q   when others;
p1_arr_wayG_rd    <=  rel_arr_wayG_val;
-- Select Congruence Class Way H
with rel_congr_cl_q select
    rel_arr_wayH_val    <= 
                        congr_cl0_wH_q     when "000000",
                        congr_cl1_wH_q     when "000001",
                        congr_cl2_wH_q     when "000010",
                        congr_cl3_wH_q     when "000011",
                        congr_cl4_wH_q     when "000100",
                        congr_cl5_wH_q     when "000101",
                        congr_cl6_wH_q     when "000110",
                        congr_cl7_wH_q     when "000111",
                        congr_cl8_wH_q     when "001000",
                        congr_cl9_wH_q     when "001001",
                        congr_cl10_wH_q    when "001010",
                        congr_cl11_wH_q    when "001011",
                        congr_cl12_wH_q    when "001100",
                        congr_cl13_wH_q    when "001101",
                        congr_cl14_wH_q    when "001110",
                        congr_cl15_wH_q    when "001111",
                        congr_cl16_wH_q    when "010000",
                        congr_cl17_wH_q    when "010001",
                        congr_cl18_wH_q    when "010010",
                        congr_cl19_wH_q    when "010011",
                        congr_cl20_wH_q    when "010100",
                        congr_cl21_wH_q    when "010101",
                        congr_cl22_wH_q    when "010110",
                        congr_cl23_wH_q    when "010111",
                        congr_cl24_wH_q    when "011000",
                        congr_cl25_wH_q    when "011001",
                        congr_cl26_wH_q    when "011010",
                        congr_cl27_wH_q    when "011011",
                        congr_cl28_wH_q    when "011100",
                        congr_cl29_wH_q    when "011101",
                        congr_cl30_wH_q    when "011110",
                        congr_cl31_wH_q    when "011111",
                        congr_cl32_wH_q    when "100000",
                        congr_cl33_wH_q    when "100001",
                        congr_cl34_wH_q    when "100010",
                        congr_cl35_wH_q    when "100011",
                        congr_cl36_wH_q    when "100100",
                        congr_cl37_wH_q    when "100101",
                        congr_cl38_wH_q    when "100110",
                        congr_cl39_wH_q    when "100111",
                        congr_cl40_wH_q    when "101000",
                        congr_cl41_wH_q    when "101001",
                        congr_cl42_wH_q    when "101010",
                        congr_cl43_wH_q    when "101011",
                        congr_cl44_wH_q    when "101100",
                        congr_cl45_wH_q    when "101101",
                        congr_cl46_wH_q    when "101110",
                        congr_cl47_wH_q    when "101111",
                        congr_cl48_wH_q    when "110000",
                        congr_cl49_wH_q    when "110001",
                        congr_cl50_wH_q    when "110010",
                        congr_cl51_wH_q    when "110011",
                        congr_cl52_wH_q    when "110100",
                        congr_cl53_wH_q    when "110101",
                        congr_cl54_wH_q    when "110110",
                        congr_cl55_wH_q    when "110111",
                        congr_cl56_wH_q    when "111000",
                        congr_cl57_wH_q    when "111001",
                        congr_cl58_wH_q    when "111010",
                        congr_cl59_wH_q    when "111011",
                        congr_cl60_wH_q    when "111100",
                        congr_cl61_wH_q    when "111101",
                        congr_cl62_wH_q    when "111110",
                        congr_cl63_wH_q   when others;
p1_arr_wayH_rd    <=  rel_arr_wayH_val;
-- ####################################################
-- Reload Pipe Bypass
-- ####################################################
-- Reload13 Bypass Stages
-- Determine if there is any updates in later stages to the same congruence class
congr_cl_rel13_ex3_cmp_d      <=  (rel_early_congr_cl = ex2_congr_cl_q);
congr_cl_rel13_ex4_cmp_d      <=  (rel_early_congr_cl = ex3_congr_cl_q);
congr_cl_rel13_ex5_cmp_d      <=  (rel_early_congr_cl = ex4_congr_cl_q);
congr_cl_rel13_ex6_cmp_d      <=  (rel_early_congr_cl = ex5_congr_cl_q);
congr_cl_rel13_relu_cmp_d     <=  (rel_early_congr_cl = rel24_congr_cl_q);
congr_cl_rel13_relu_s_cmp_d   <=  (rel_early_congr_cl = relu_congr_cl_q);
congr_cl_rel13_rel_upd_cmp_d  <=  (rel_early_congr_cl = relu_s_congr_cl_q);
congr_cl_rel13_p0_cmp         <=  congr_cl_rel13_ex6_cmp_q and p0_wren_cpy_q;
congr_cl_rel13_p1_cmp         <=  congr_cl_rel13_rel_upd_cmp_q and p1_wren_cpy_q;
-- Determine if there is any updates in later stages to the same congruence class
congr_cl_rel13_ex3_m     <=  congr_cl_rel13_ex3_cmp_q    and (ex3_lock_set_q or back_inval_stg3_q);
congr_cl_rel13_ex4_m     <=  congr_cl_rel13_ex4_cmp_q    and (ex4_lock_set_q or back_inval_stg4_q);
congr_cl_rel13_ex5_m     <=  congr_cl_rel13_ex5_cmp_q    and (ex5_lock_set_q or back_inval_stg5_q);
congr_cl_rel13_relu_m    <=  congr_cl_rel13_relu_cmp_q   and rel_val_stgu_q;
congr_cl_rel13_relu_s_m  <=  congr_cl_rel13_relu_s_cmp_q and p1_upd_val;
-- WayA   Bypass Calculation
congr_cl_rel13_wayA_byp(1) <=  congr_cl_rel13_ex3_m    and ex3_wayA_hit;
congr_cl_rel13_wayA_byp(2) <=  congr_cl_rel13_relu_m   and reload_wayA_upd_q;
congr_cl_rel13_wayA_byp(3) <=  congr_cl_rel13_ex4_m    and binv_wayA_upd_q;
congr_cl_rel13_wayA_byp(4) <=  congr_cl_rel13_relu_s_m and reload_wayA_upd2_q;
congr_cl_rel13_wayA_byp(5) <=  congr_cl_rel13_ex5_m    and binv_wayA_upd2_q;
congr_cl_rel13_wayA_byp(6) <=  congr_cl_rel13_p1_cmp   and reload_wayA_upd3_q;
congr_cl_rel13_wayA_byp(7) <=  congr_cl_rel13_p0_cmp   and binv_wayA_upd3_q;
-- WayA   Bypass Valid
rel24_wayA_fxubyp_val_d    <=  congr_cl_rel13_wayA_byp(1)   or congr_cl_rel13_wayA_byp(3)   or
                             congr_cl_rel13_wayA_byp(5)   or congr_cl_rel13_wayA_byp(7);
rel24_wayA_relbyp_val_d    <=  congr_cl_rel13_wayA_byp(2)   or congr_cl_rel13_wayA_byp(4)   or
                             congr_cl_rel13_wayA_byp(6);
rel24_wayA_byp_sel         <=  rel24_wayA_fxubyp_val_q   & rel24_wayA_relbyp_val_q;
-- Late Stages Priority Selection
congr_cl_rel13_wayA_sel(2) <=  congr_cl_rel13_wayA_byp(2);
congr_cl_rel13_wayA_sel(3) <=  congr_cl_rel13_wayA_byp(3)   and not congr_cl_rel13_wayA_byp(2);
congr_cl_rel13_wayA_sel(4) <=  congr_cl_rel13_wayA_byp(4)   and not or_reduce(congr_cl_rel13_wayA_byp(2   to 3));
congr_cl_rel13_wayA_sel(5) <=  congr_cl_rel13_wayA_byp(5)   and not or_reduce(congr_cl_rel13_wayA_byp(2   to 4));
congr_cl_rel13_wayA_sel(6) <=  congr_cl_rel13_wayA_byp(6)   and not or_reduce(congr_cl_rel13_wayA_byp(2   to 5));
congr_cl_rel13_wayA_sel(7) <=  congr_cl_rel13_wayA_byp(7)   and not or_reduce(congr_cl_rel13_wayA_byp(2   to 6));
-- ArrayRead/LATE Stage Priority Selection
rel_wayA_late_sel         <=  or_reduce(congr_cl_rel13_wayA_byp(2   to 7));
rel_wayA_later_stg_pri    <=  gate(p1_arr_wayA_rd,        not rel_wayA_late_sel)        or
                            gate(reload_wayA,           congr_cl_rel13_wayA_sel(2))   or
                            gate(flush_wayA_q,          congr_cl_rel13_wayA_sel(3))   or
                            gate(reload_wayA_data_q,    congr_cl_rel13_wayA_sel(4))   or
                            gate(flush_wayA_data_q,     congr_cl_rel13_wayA_sel(5))   or
                            gate(reload_wayA_data2_q,   congr_cl_rel13_wayA_sel(6))   or
                            gate(flush_wayA_data2_q,    congr_cl_rel13_wayA_sel(7));
-- EX3/RELU Stage Priority Selection
rel_wayA_early_sel        <=  congr_cl_rel13_wayA_byp(1);
rel_wayA_early_stg_pri    <=  flush_wayA_d;
-- Stage/ARRAY Priority Selection
rel_wayA_stg_val      <=  (others=>(rel_wayA_early_sel));
rel_wayA_stg_val_b    <=  (others=>(not(rel_wayA_early_sel)));
rel_wayA_val          <=  not rel_wayA_val_b_q;
rel_wayA_val_stg_d    <=  rel_wayA_val;
-- WayB   Bypass Calculation
congr_cl_rel13_wayB_byp(1) <=  congr_cl_rel13_ex3_m    and ex3_wayB_hit;
congr_cl_rel13_wayB_byp(2) <=  congr_cl_rel13_relu_m   and reload_wayB_upd_q;
congr_cl_rel13_wayB_byp(3) <=  congr_cl_rel13_ex4_m    and binv_wayB_upd_q;
congr_cl_rel13_wayB_byp(4) <=  congr_cl_rel13_relu_s_m and reload_wayB_upd2_q;
congr_cl_rel13_wayB_byp(5) <=  congr_cl_rel13_ex5_m    and binv_wayB_upd2_q;
congr_cl_rel13_wayB_byp(6) <=  congr_cl_rel13_p1_cmp   and reload_wayB_upd3_q;
congr_cl_rel13_wayB_byp(7) <=  congr_cl_rel13_p0_cmp   and binv_wayB_upd3_q;
-- WayB   Bypass Valid
rel24_wayB_fxubyp_val_d    <=  congr_cl_rel13_wayB_byp(1)   or congr_cl_rel13_wayB_byp(3)   or
                             congr_cl_rel13_wayB_byp(5)   or congr_cl_rel13_wayB_byp(7);
rel24_wayB_relbyp_val_d    <=  congr_cl_rel13_wayB_byp(2)   or congr_cl_rel13_wayB_byp(4)   or
                             congr_cl_rel13_wayB_byp(6);
rel24_wayB_byp_sel         <=  rel24_wayB_fxubyp_val_q   & rel24_wayB_relbyp_val_q;
-- Late Stages Priority Selection
congr_cl_rel13_wayB_sel(2) <=  congr_cl_rel13_wayB_byp(2);
congr_cl_rel13_wayB_sel(3) <=  congr_cl_rel13_wayB_byp(3)   and not congr_cl_rel13_wayB_byp(2);
congr_cl_rel13_wayB_sel(4) <=  congr_cl_rel13_wayB_byp(4)   and not or_reduce(congr_cl_rel13_wayB_byp(2   to 3));
congr_cl_rel13_wayB_sel(5) <=  congr_cl_rel13_wayB_byp(5)   and not or_reduce(congr_cl_rel13_wayB_byp(2   to 4));
congr_cl_rel13_wayB_sel(6) <=  congr_cl_rel13_wayB_byp(6)   and not or_reduce(congr_cl_rel13_wayB_byp(2   to 5));
congr_cl_rel13_wayB_sel(7) <=  congr_cl_rel13_wayB_byp(7)   and not or_reduce(congr_cl_rel13_wayB_byp(2   to 6));
-- ArrayRead/LATE Stage Priority Selection
rel_wayB_late_sel         <=  or_reduce(congr_cl_rel13_wayB_byp(2   to 7));
rel_wayB_later_stg_pri    <=  gate(p1_arr_wayB_rd,        not rel_wayB_late_sel)        or
                            gate(reload_wayB,           congr_cl_rel13_wayB_sel(2))   or
                            gate(flush_wayB_q,          congr_cl_rel13_wayB_sel(3))   or
                            gate(reload_wayB_data_q,    congr_cl_rel13_wayB_sel(4))   or
                            gate(flush_wayB_data_q,     congr_cl_rel13_wayB_sel(5))   or
                            gate(reload_wayB_data2_q,   congr_cl_rel13_wayB_sel(6))   or
                            gate(flush_wayB_data2_q,    congr_cl_rel13_wayB_sel(7));
-- EX3/RELU Stage Priority Selection
rel_wayB_early_sel        <=  congr_cl_rel13_wayB_byp(1);
rel_wayB_early_stg_pri    <=  flush_wayB_d;
-- Stage/ARRAY Priority Selection
rel_wayB_stg_val      <=  (others=>(rel_wayB_early_sel));
rel_wayB_stg_val_b    <=  (others=>(not(rel_wayB_early_sel)));
rel_wayB_val          <=  not rel_wayB_val_b_q;
rel_wayB_val_stg_d    <=  rel_wayB_val;
-- WayC   Bypass Calculation
congr_cl_rel13_wayC_byp(1) <=  congr_cl_rel13_ex3_m    and ex3_wayC_hit;
congr_cl_rel13_wayC_byp(2) <=  congr_cl_rel13_relu_m   and reload_wayC_upd_q;
congr_cl_rel13_wayC_byp(3) <=  congr_cl_rel13_ex4_m    and binv_wayC_upd_q;
congr_cl_rel13_wayC_byp(4) <=  congr_cl_rel13_relu_s_m and reload_wayC_upd2_q;
congr_cl_rel13_wayC_byp(5) <=  congr_cl_rel13_ex5_m    and binv_wayC_upd2_q;
congr_cl_rel13_wayC_byp(6) <=  congr_cl_rel13_p1_cmp   and reload_wayC_upd3_q;
congr_cl_rel13_wayC_byp(7) <=  congr_cl_rel13_p0_cmp   and binv_wayC_upd3_q;
-- WayC   Bypass Valid
rel24_wayC_fxubyp_val_d    <=  congr_cl_rel13_wayC_byp(1)   or congr_cl_rel13_wayC_byp(3)   or
                             congr_cl_rel13_wayC_byp(5)   or congr_cl_rel13_wayC_byp(7);
rel24_wayC_relbyp_val_d    <=  congr_cl_rel13_wayC_byp(2)   or congr_cl_rel13_wayC_byp(4)   or
                             congr_cl_rel13_wayC_byp(6);
rel24_wayC_byp_sel         <=  rel24_wayC_fxubyp_val_q   & rel24_wayC_relbyp_val_q;
-- Late Stages Priority Selection
congr_cl_rel13_wayC_sel(2) <=  congr_cl_rel13_wayC_byp(2);
congr_cl_rel13_wayC_sel(3) <=  congr_cl_rel13_wayC_byp(3)   and not congr_cl_rel13_wayC_byp(2);
congr_cl_rel13_wayC_sel(4) <=  congr_cl_rel13_wayC_byp(4)   and not or_reduce(congr_cl_rel13_wayC_byp(2   to 3));
congr_cl_rel13_wayC_sel(5) <=  congr_cl_rel13_wayC_byp(5)   and not or_reduce(congr_cl_rel13_wayC_byp(2   to 4));
congr_cl_rel13_wayC_sel(6) <=  congr_cl_rel13_wayC_byp(6)   and not or_reduce(congr_cl_rel13_wayC_byp(2   to 5));
congr_cl_rel13_wayC_sel(7) <=  congr_cl_rel13_wayC_byp(7)   and not or_reduce(congr_cl_rel13_wayC_byp(2   to 6));
-- ArrayRead/LATE Stage Priority Selection
rel_wayC_late_sel         <=  or_reduce(congr_cl_rel13_wayC_byp(2   to 7));
rel_wayC_later_stg_pri    <=  gate(p1_arr_wayC_rd,        not rel_wayC_late_sel)        or
                            gate(reload_wayC,           congr_cl_rel13_wayC_sel(2))   or
                            gate(flush_wayC_q,          congr_cl_rel13_wayC_sel(3))   or
                            gate(reload_wayC_data_q,    congr_cl_rel13_wayC_sel(4))   or
                            gate(flush_wayC_data_q,     congr_cl_rel13_wayC_sel(5))   or
                            gate(reload_wayC_data2_q,   congr_cl_rel13_wayC_sel(6))   or
                            gate(flush_wayC_data2_q,    congr_cl_rel13_wayC_sel(7));
-- EX3/RELU Stage Priority Selection
rel_wayC_early_sel        <=  congr_cl_rel13_wayC_byp(1);
rel_wayC_early_stg_pri    <=  flush_wayC_d;
-- Stage/ARRAY Priority Selection
rel_wayC_stg_val      <=  (others=>(rel_wayC_early_sel));
rel_wayC_stg_val_b    <=  (others=>(not(rel_wayC_early_sel)));
rel_wayC_val          <=  not rel_wayC_val_b_q;
rel_wayC_val_stg_d    <=  rel_wayC_val;
-- WayD   Bypass Calculation
congr_cl_rel13_wayD_byp(1) <=  congr_cl_rel13_ex3_m    and ex3_wayD_hit;
congr_cl_rel13_wayD_byp(2) <=  congr_cl_rel13_relu_m   and reload_wayD_upd_q;
congr_cl_rel13_wayD_byp(3) <=  congr_cl_rel13_ex4_m    and binv_wayD_upd_q;
congr_cl_rel13_wayD_byp(4) <=  congr_cl_rel13_relu_s_m and reload_wayD_upd2_q;
congr_cl_rel13_wayD_byp(5) <=  congr_cl_rel13_ex5_m    and binv_wayD_upd2_q;
congr_cl_rel13_wayD_byp(6) <=  congr_cl_rel13_p1_cmp   and reload_wayD_upd3_q;
congr_cl_rel13_wayD_byp(7) <=  congr_cl_rel13_p0_cmp   and binv_wayD_upd3_q;
-- WayD   Bypass Valid
rel24_wayD_fxubyp_val_d    <=  congr_cl_rel13_wayD_byp(1)   or congr_cl_rel13_wayD_byp(3)   or
                             congr_cl_rel13_wayD_byp(5)   or congr_cl_rel13_wayD_byp(7);
rel24_wayD_relbyp_val_d    <=  congr_cl_rel13_wayD_byp(2)   or congr_cl_rel13_wayD_byp(4)   or
                             congr_cl_rel13_wayD_byp(6);
rel24_wayD_byp_sel         <=  rel24_wayD_fxubyp_val_q   & rel24_wayD_relbyp_val_q;
-- Late Stages Priority Selection
congr_cl_rel13_wayD_sel(2) <=  congr_cl_rel13_wayD_byp(2);
congr_cl_rel13_wayD_sel(3) <=  congr_cl_rel13_wayD_byp(3)   and not congr_cl_rel13_wayD_byp(2);
congr_cl_rel13_wayD_sel(4) <=  congr_cl_rel13_wayD_byp(4)   and not or_reduce(congr_cl_rel13_wayD_byp(2   to 3));
congr_cl_rel13_wayD_sel(5) <=  congr_cl_rel13_wayD_byp(5)   and not or_reduce(congr_cl_rel13_wayD_byp(2   to 4));
congr_cl_rel13_wayD_sel(6) <=  congr_cl_rel13_wayD_byp(6)   and not or_reduce(congr_cl_rel13_wayD_byp(2   to 5));
congr_cl_rel13_wayD_sel(7) <=  congr_cl_rel13_wayD_byp(7)   and not or_reduce(congr_cl_rel13_wayD_byp(2   to 6));
-- ArrayRead/LATE Stage Priority Selection
rel_wayD_late_sel         <=  or_reduce(congr_cl_rel13_wayD_byp(2   to 7));
rel_wayD_later_stg_pri    <=  gate(p1_arr_wayD_rd,        not rel_wayD_late_sel)        or
                            gate(reload_wayD,           congr_cl_rel13_wayD_sel(2))   or
                            gate(flush_wayD_q,          congr_cl_rel13_wayD_sel(3))   or
                            gate(reload_wayD_data_q,    congr_cl_rel13_wayD_sel(4))   or
                            gate(flush_wayD_data_q,     congr_cl_rel13_wayD_sel(5))   or
                            gate(reload_wayD_data2_q,   congr_cl_rel13_wayD_sel(6))   or
                            gate(flush_wayD_data2_q,    congr_cl_rel13_wayD_sel(7));
-- EX3/RELU Stage Priority Selection
rel_wayD_early_sel        <=  congr_cl_rel13_wayD_byp(1);
rel_wayD_early_stg_pri    <=  flush_wayD_d;
-- Stage/ARRAY Priority Selection
rel_wayD_stg_val      <=  (others=>(rel_wayD_early_sel));
rel_wayD_stg_val_b    <=  (others=>(not(rel_wayD_early_sel)));
rel_wayD_val          <=  not rel_wayD_val_b_q;
rel_wayD_val_stg_d    <=  rel_wayD_val;
-- WayE   Bypass Calculation
congr_cl_rel13_wayE_byp(1) <=  congr_cl_rel13_ex3_m    and ex3_wayE_hit;
congr_cl_rel13_wayE_byp(2) <=  congr_cl_rel13_relu_m   and reload_wayE_upd_q;
congr_cl_rel13_wayE_byp(3) <=  congr_cl_rel13_ex4_m    and binv_wayE_upd_q;
congr_cl_rel13_wayE_byp(4) <=  congr_cl_rel13_relu_s_m and reload_wayE_upd2_q;
congr_cl_rel13_wayE_byp(5) <=  congr_cl_rel13_ex5_m    and binv_wayE_upd2_q;
congr_cl_rel13_wayE_byp(6) <=  congr_cl_rel13_p1_cmp   and reload_wayE_upd3_q;
congr_cl_rel13_wayE_byp(7) <=  congr_cl_rel13_p0_cmp   and binv_wayE_upd3_q;
-- WayE   Bypass Valid
rel24_wayE_fxubyp_val_d    <=  congr_cl_rel13_wayE_byp(1)   or congr_cl_rel13_wayE_byp(3)   or
                             congr_cl_rel13_wayE_byp(5)   or congr_cl_rel13_wayE_byp(7);
rel24_wayE_relbyp_val_d    <=  congr_cl_rel13_wayE_byp(2)   or congr_cl_rel13_wayE_byp(4)   or
                             congr_cl_rel13_wayE_byp(6);
rel24_wayE_byp_sel         <=  rel24_wayE_fxubyp_val_q   & rel24_wayE_relbyp_val_q;
-- Late Stages Priority Selection
congr_cl_rel13_wayE_sel(2) <=  congr_cl_rel13_wayE_byp(2);
congr_cl_rel13_wayE_sel(3) <=  congr_cl_rel13_wayE_byp(3)   and not congr_cl_rel13_wayE_byp(2);
congr_cl_rel13_wayE_sel(4) <=  congr_cl_rel13_wayE_byp(4)   and not or_reduce(congr_cl_rel13_wayE_byp(2   to 3));
congr_cl_rel13_wayE_sel(5) <=  congr_cl_rel13_wayE_byp(5)   and not or_reduce(congr_cl_rel13_wayE_byp(2   to 4));
congr_cl_rel13_wayE_sel(6) <=  congr_cl_rel13_wayE_byp(6)   and not or_reduce(congr_cl_rel13_wayE_byp(2   to 5));
congr_cl_rel13_wayE_sel(7) <=  congr_cl_rel13_wayE_byp(7)   and not or_reduce(congr_cl_rel13_wayE_byp(2   to 6));
-- ArrayRead/LATE Stage Priority Selection
rel_wayE_late_sel         <=  or_reduce(congr_cl_rel13_wayE_byp(2   to 7));
rel_wayE_later_stg_pri    <=  gate(p1_arr_wayE_rd,        not rel_wayE_late_sel)        or
                            gate(reload_wayE,           congr_cl_rel13_wayE_sel(2))   or
                            gate(flush_wayE_q,          congr_cl_rel13_wayE_sel(3))   or
                            gate(reload_wayE_data_q,    congr_cl_rel13_wayE_sel(4))   or
                            gate(flush_wayE_data_q,     congr_cl_rel13_wayE_sel(5))   or
                            gate(reload_wayE_data2_q,   congr_cl_rel13_wayE_sel(6))   or
                            gate(flush_wayE_data2_q,    congr_cl_rel13_wayE_sel(7));
-- EX3/RELU Stage Priority Selection
rel_wayE_early_sel        <=  congr_cl_rel13_wayE_byp(1);
rel_wayE_early_stg_pri    <=  flush_wayE_d;
-- Stage/ARRAY Priority Selection
rel_wayE_stg_val      <=  (others=>(rel_wayE_early_sel));
rel_wayE_stg_val_b    <=  (others=>(not(rel_wayE_early_sel)));
rel_wayE_val          <=  not rel_wayE_val_b_q;
rel_wayE_val_stg_d    <=  rel_wayE_val;
-- WayF   Bypass Calculation
congr_cl_rel13_wayF_byp(1) <=  congr_cl_rel13_ex3_m    and ex3_wayF_hit;
congr_cl_rel13_wayF_byp(2) <=  congr_cl_rel13_relu_m   and reload_wayF_upd_q;
congr_cl_rel13_wayF_byp(3) <=  congr_cl_rel13_ex4_m    and binv_wayF_upd_q;
congr_cl_rel13_wayF_byp(4) <=  congr_cl_rel13_relu_s_m and reload_wayF_upd2_q;
congr_cl_rel13_wayF_byp(5) <=  congr_cl_rel13_ex5_m    and binv_wayF_upd2_q;
congr_cl_rel13_wayF_byp(6) <=  congr_cl_rel13_p1_cmp   and reload_wayF_upd3_q;
congr_cl_rel13_wayF_byp(7) <=  congr_cl_rel13_p0_cmp   and binv_wayF_upd3_q;
-- WayF   Bypass Valid
rel24_wayF_fxubyp_val_d    <=  congr_cl_rel13_wayF_byp(1)   or congr_cl_rel13_wayF_byp(3)   or
                             congr_cl_rel13_wayF_byp(5)   or congr_cl_rel13_wayF_byp(7);
rel24_wayF_relbyp_val_d    <=  congr_cl_rel13_wayF_byp(2)   or congr_cl_rel13_wayF_byp(4)   or
                             congr_cl_rel13_wayF_byp(6);
rel24_wayF_byp_sel         <=  rel24_wayF_fxubyp_val_q   & rel24_wayF_relbyp_val_q;
-- Late Stages Priority Selection
congr_cl_rel13_wayF_sel(2) <=  congr_cl_rel13_wayF_byp(2);
congr_cl_rel13_wayF_sel(3) <=  congr_cl_rel13_wayF_byp(3)   and not congr_cl_rel13_wayF_byp(2);
congr_cl_rel13_wayF_sel(4) <=  congr_cl_rel13_wayF_byp(4)   and not or_reduce(congr_cl_rel13_wayF_byp(2   to 3));
congr_cl_rel13_wayF_sel(5) <=  congr_cl_rel13_wayF_byp(5)   and not or_reduce(congr_cl_rel13_wayF_byp(2   to 4));
congr_cl_rel13_wayF_sel(6) <=  congr_cl_rel13_wayF_byp(6)   and not or_reduce(congr_cl_rel13_wayF_byp(2   to 5));
congr_cl_rel13_wayF_sel(7) <=  congr_cl_rel13_wayF_byp(7)   and not or_reduce(congr_cl_rel13_wayF_byp(2   to 6));
-- ArrayRead/LATE Stage Priority Selection
rel_wayF_late_sel         <=  or_reduce(congr_cl_rel13_wayF_byp(2   to 7));
rel_wayF_later_stg_pri    <=  gate(p1_arr_wayF_rd,        not rel_wayF_late_sel)        or
                            gate(reload_wayF,           congr_cl_rel13_wayF_sel(2))   or
                            gate(flush_wayF_q,          congr_cl_rel13_wayF_sel(3))   or
                            gate(reload_wayF_data_q,    congr_cl_rel13_wayF_sel(4))   or
                            gate(flush_wayF_data_q,     congr_cl_rel13_wayF_sel(5))   or
                            gate(reload_wayF_data2_q,   congr_cl_rel13_wayF_sel(6))   or
                            gate(flush_wayF_data2_q,    congr_cl_rel13_wayF_sel(7));
-- EX3/RELU Stage Priority Selection
rel_wayF_early_sel        <=  congr_cl_rel13_wayF_byp(1);
rel_wayF_early_stg_pri    <=  flush_wayF_d;
-- Stage/ARRAY Priority Selection
rel_wayF_stg_val      <=  (others=>(rel_wayF_early_sel));
rel_wayF_stg_val_b    <=  (others=>(not(rel_wayF_early_sel)));
rel_wayF_val          <=  not rel_wayF_val_b_q;
rel_wayF_val_stg_d    <=  rel_wayF_val;
-- WayG   Bypass Calculation
congr_cl_rel13_wayG_byp(1) <=  congr_cl_rel13_ex3_m    and ex3_wayG_hit;
congr_cl_rel13_wayG_byp(2) <=  congr_cl_rel13_relu_m   and reload_wayG_upd_q;
congr_cl_rel13_wayG_byp(3) <=  congr_cl_rel13_ex4_m    and binv_wayG_upd_q;
congr_cl_rel13_wayG_byp(4) <=  congr_cl_rel13_relu_s_m and reload_wayG_upd2_q;
congr_cl_rel13_wayG_byp(5) <=  congr_cl_rel13_ex5_m    and binv_wayG_upd2_q;
congr_cl_rel13_wayG_byp(6) <=  congr_cl_rel13_p1_cmp   and reload_wayG_upd3_q;
congr_cl_rel13_wayG_byp(7) <=  congr_cl_rel13_p0_cmp   and binv_wayG_upd3_q;
-- WayG   Bypass Valid
rel24_wayG_fxubyp_val_d    <=  congr_cl_rel13_wayG_byp(1)   or congr_cl_rel13_wayG_byp(3)   or
                             congr_cl_rel13_wayG_byp(5)   or congr_cl_rel13_wayG_byp(7);
rel24_wayG_relbyp_val_d    <=  congr_cl_rel13_wayG_byp(2)   or congr_cl_rel13_wayG_byp(4)   or
                             congr_cl_rel13_wayG_byp(6);
rel24_wayG_byp_sel         <=  rel24_wayG_fxubyp_val_q   & rel24_wayG_relbyp_val_q;
-- Late Stages Priority Selection
congr_cl_rel13_wayG_sel(2) <=  congr_cl_rel13_wayG_byp(2);
congr_cl_rel13_wayG_sel(3) <=  congr_cl_rel13_wayG_byp(3)   and not congr_cl_rel13_wayG_byp(2);
congr_cl_rel13_wayG_sel(4) <=  congr_cl_rel13_wayG_byp(4)   and not or_reduce(congr_cl_rel13_wayG_byp(2   to 3));
congr_cl_rel13_wayG_sel(5) <=  congr_cl_rel13_wayG_byp(5)   and not or_reduce(congr_cl_rel13_wayG_byp(2   to 4));
congr_cl_rel13_wayG_sel(6) <=  congr_cl_rel13_wayG_byp(6)   and not or_reduce(congr_cl_rel13_wayG_byp(2   to 5));
congr_cl_rel13_wayG_sel(7) <=  congr_cl_rel13_wayG_byp(7)   and not or_reduce(congr_cl_rel13_wayG_byp(2   to 6));
-- ArrayRead/LATE Stage Priority Selection
rel_wayG_late_sel         <=  or_reduce(congr_cl_rel13_wayG_byp(2   to 7));
rel_wayG_later_stg_pri    <=  gate(p1_arr_wayG_rd,        not rel_wayG_late_sel)        or
                            gate(reload_wayG,           congr_cl_rel13_wayG_sel(2))   or
                            gate(flush_wayG_q,          congr_cl_rel13_wayG_sel(3))   or
                            gate(reload_wayG_data_q,    congr_cl_rel13_wayG_sel(4))   or
                            gate(flush_wayG_data_q,     congr_cl_rel13_wayG_sel(5))   or
                            gate(reload_wayG_data2_q,   congr_cl_rel13_wayG_sel(6))   or
                            gate(flush_wayG_data2_q,    congr_cl_rel13_wayG_sel(7));
-- EX3/RELU Stage Priority Selection
rel_wayG_early_sel        <=  congr_cl_rel13_wayG_byp(1);
rel_wayG_early_stg_pri    <=  flush_wayG_d;
-- Stage/ARRAY Priority Selection
rel_wayG_stg_val      <=  (others=>(rel_wayG_early_sel));
rel_wayG_stg_val_b    <=  (others=>(not(rel_wayG_early_sel)));
rel_wayG_val          <=  not rel_wayG_val_b_q;
rel_wayG_val_stg_d    <=  rel_wayG_val;
-- WayH   Bypass Calculation
congr_cl_rel13_wayH_byp(1) <=  congr_cl_rel13_ex3_m    and ex3_wayH_hit;
congr_cl_rel13_wayH_byp(2) <=  congr_cl_rel13_relu_m   and reload_wayH_upd_q;
congr_cl_rel13_wayH_byp(3) <=  congr_cl_rel13_ex4_m    and binv_wayH_upd_q;
congr_cl_rel13_wayH_byp(4) <=  congr_cl_rel13_relu_s_m and reload_wayH_upd2_q;
congr_cl_rel13_wayH_byp(5) <=  congr_cl_rel13_ex5_m    and binv_wayH_upd2_q;
congr_cl_rel13_wayH_byp(6) <=  congr_cl_rel13_p1_cmp   and reload_wayH_upd3_q;
congr_cl_rel13_wayH_byp(7) <=  congr_cl_rel13_p0_cmp   and binv_wayH_upd3_q;
-- WayH   Bypass Valid
rel24_wayH_fxubyp_val_d    <=  congr_cl_rel13_wayH_byp(1)   or congr_cl_rel13_wayH_byp(3)   or
                             congr_cl_rel13_wayH_byp(5)   or congr_cl_rel13_wayH_byp(7);
rel24_wayH_relbyp_val_d    <=  congr_cl_rel13_wayH_byp(2)   or congr_cl_rel13_wayH_byp(4)   or
                             congr_cl_rel13_wayH_byp(6);
rel24_wayH_byp_sel         <=  rel24_wayH_fxubyp_val_q   & rel24_wayH_relbyp_val_q;
-- Late Stages Priority Selection
congr_cl_rel13_wayH_sel(2) <=  congr_cl_rel13_wayH_byp(2);
congr_cl_rel13_wayH_sel(3) <=  congr_cl_rel13_wayH_byp(3)   and not congr_cl_rel13_wayH_byp(2);
congr_cl_rel13_wayH_sel(4) <=  congr_cl_rel13_wayH_byp(4)   and not or_reduce(congr_cl_rel13_wayH_byp(2   to 3));
congr_cl_rel13_wayH_sel(5) <=  congr_cl_rel13_wayH_byp(5)   and not or_reduce(congr_cl_rel13_wayH_byp(2   to 4));
congr_cl_rel13_wayH_sel(6) <=  congr_cl_rel13_wayH_byp(6)   and not or_reduce(congr_cl_rel13_wayH_byp(2   to 5));
congr_cl_rel13_wayH_sel(7) <=  congr_cl_rel13_wayH_byp(7)   and not or_reduce(congr_cl_rel13_wayH_byp(2   to 6));
-- ArrayRead/LATE Stage Priority Selection
rel_wayH_late_sel         <=  or_reduce(congr_cl_rel13_wayH_byp(2   to 7));
rel_wayH_later_stg_pri    <=  gate(p1_arr_wayH_rd,        not rel_wayH_late_sel)        or
                            gate(reload_wayH,           congr_cl_rel13_wayH_sel(2))   or
                            gate(flush_wayH_q,          congr_cl_rel13_wayH_sel(3))   or
                            gate(reload_wayH_data_q,    congr_cl_rel13_wayH_sel(4))   or
                            gate(flush_wayH_data_q,     congr_cl_rel13_wayH_sel(5))   or
                            gate(reload_wayH_data2_q,   congr_cl_rel13_wayH_sel(6))   or
                            gate(flush_wayH_data2_q,    congr_cl_rel13_wayH_sel(7));
-- EX3/RELU Stage Priority Selection
rel_wayH_early_sel        <=  congr_cl_rel13_wayH_byp(1);
rel_wayH_early_stg_pri    <=  flush_wayH_d;
-- Stage/ARRAY Priority Selection
rel_wayH_stg_val      <=  (others=>(rel_wayH_early_sel));
rel_wayH_stg_val_b    <=  (others=>(not(rel_wayH_early_sel)));
rel_wayH_val          <=  not rel_wayH_val_b_q;
rel_wayH_val_stg_d    <=  rel_wayH_val;
-- ####################################################
-- Reload Invalidate/Reload Validate Pipes
-- ####################################################
-- Invalidate Way
rel_par_wA_clr     <=  rel_wayA_clr   or dcpar_err_way_inval_q(0);
-- Invalidate/Reload Logic on Port1
reload_wayA_d(0) <=  (not rel_par_wA_clr   and rel_wayA_val(0))   or rel_wayA_set;
-- Lock Clear/Set Logic on Port1
reload_wayA_d(1) <=  (not rel_par_wA_clr   and rel_wayA_val(1))   or (rel_lock_set_q and rel_wayA_set);
-- Lost Lock due to Parity Error
dcpar_err_lock_lost(0) <=  rel_wayA_val(1)   and dcpar_err_way_inval_q(0);
-- Watch Clear/Set Logic on Port1
reload_wayA_d(2) <=  ((not rel_par_wA_clr   and rel_wayA_val(2)))     or (rel_watch_set_q and rel_wayA_set   and rel_thrd_id_q(0));
reload_wayA_d(3) <=  ((not rel_par_wA_clr   and rel_wayA_val(3)))     or (rel_watch_set_q and rel_wayA_set   and rel_thrd_id_q(1));
reload_wayA_d(4) <=  ((not rel_par_wA_clr   and rel_wayA_val(4)))     or (rel_watch_set_q and rel_wayA_set   and rel_thrd_id_q(2));
reload_wayA_d(5) <=  ((not rel_par_wA_clr   and rel_wayA_val(5)))     or (rel_watch_set_q and rel_wayA_set   and rel_thrd_id_q(3));
-- Updating due to Reload or Data cache Parity error
reload_wayA_upd_d    <=  rel_par_wA_clr   or rel_wayA_set;
-- Updating due to Reload Clear only
reload_wayA_clr    <=  rel_par_wA_clr;
-- Invalidate Way
rel_par_wB_clr     <=  rel_wayB_clr   or dcpar_err_way_inval_q(1);
-- Invalidate/Reload Logic on Port1
reload_wayB_d(0) <=  (not rel_par_wB_clr   and rel_wayB_val(0))   or rel_wayB_set;
-- Lock Clear/Set Logic on Port1
reload_wayB_d(1) <=  (not rel_par_wB_clr   and rel_wayB_val(1))   or (rel_lock_set_q and rel_wayB_set);
-- Lost Lock due to Parity Error
dcpar_err_lock_lost(1) <=  rel_wayB_val(1)   and dcpar_err_way_inval_q(1);
-- Watch Clear/Set Logic on Port1
reload_wayB_d(2) <=  ((not rel_par_wB_clr   and rel_wayB_val(2)))     or (rel_watch_set_q and rel_wayB_set   and rel_thrd_id_q(0));
reload_wayB_d(3) <=  ((not rel_par_wB_clr   and rel_wayB_val(3)))     or (rel_watch_set_q and rel_wayB_set   and rel_thrd_id_q(1));
reload_wayB_d(4) <=  ((not rel_par_wB_clr   and rel_wayB_val(4)))     or (rel_watch_set_q and rel_wayB_set   and rel_thrd_id_q(2));
reload_wayB_d(5) <=  ((not rel_par_wB_clr   and rel_wayB_val(5)))     or (rel_watch_set_q and rel_wayB_set   and rel_thrd_id_q(3));
-- Updating due to Reload or Data cache Parity error
reload_wayB_upd_d    <=  rel_par_wB_clr   or rel_wayB_set;
-- Updating due to Reload Clear only
reload_wayB_clr    <=  rel_par_wB_clr;
-- Invalidate Way
rel_par_wC_clr     <=  rel_wayC_clr   or dcpar_err_way_inval_q(2);
-- Invalidate/Reload Logic on Port1
reload_wayC_d(0) <=  (not rel_par_wC_clr   and rel_wayC_val(0))   or rel_wayC_set;
-- Lock Clear/Set Logic on Port1
reload_wayC_d(1) <=  (not rel_par_wC_clr   and rel_wayC_val(1))   or (rel_lock_set_q and rel_wayC_set);
-- Lost Lock due to Parity Error
dcpar_err_lock_lost(2) <=  rel_wayC_val(1)   and dcpar_err_way_inval_q(2);
-- Watch Clear/Set Logic on Port1
reload_wayC_d(2) <=  ((not rel_par_wC_clr   and rel_wayC_val(2)))     or (rel_watch_set_q and rel_wayC_set   and rel_thrd_id_q(0));
reload_wayC_d(3) <=  ((not rel_par_wC_clr   and rel_wayC_val(3)))     or (rel_watch_set_q and rel_wayC_set   and rel_thrd_id_q(1));
reload_wayC_d(4) <=  ((not rel_par_wC_clr   and rel_wayC_val(4)))     or (rel_watch_set_q and rel_wayC_set   and rel_thrd_id_q(2));
reload_wayC_d(5) <=  ((not rel_par_wC_clr   and rel_wayC_val(5)))     or (rel_watch_set_q and rel_wayC_set   and rel_thrd_id_q(3));
-- Updating due to Reload or Data cache Parity error
reload_wayC_upd_d    <=  rel_par_wC_clr   or rel_wayC_set;
-- Updating due to Reload Clear only
reload_wayC_clr    <=  rel_par_wC_clr;
-- Invalidate Way
rel_par_wD_clr     <=  rel_wayD_clr   or dcpar_err_way_inval_q(3);
-- Invalidate/Reload Logic on Port1
reload_wayD_d(0) <=  (not rel_par_wD_clr   and rel_wayD_val(0))   or rel_wayD_set;
-- Lock Clear/Set Logic on Port1
reload_wayD_d(1) <=  (not rel_par_wD_clr   and rel_wayD_val(1))   or (rel_lock_set_q and rel_wayD_set);
-- Lost Lock due to Parity Error
dcpar_err_lock_lost(3) <=  rel_wayD_val(1)   and dcpar_err_way_inval_q(3);
-- Watch Clear/Set Logic on Port1
reload_wayD_d(2) <=  ((not rel_par_wD_clr   and rel_wayD_val(2)))     or (rel_watch_set_q and rel_wayD_set   and rel_thrd_id_q(0));
reload_wayD_d(3) <=  ((not rel_par_wD_clr   and rel_wayD_val(3)))     or (rel_watch_set_q and rel_wayD_set   and rel_thrd_id_q(1));
reload_wayD_d(4) <=  ((not rel_par_wD_clr   and rel_wayD_val(4)))     or (rel_watch_set_q and rel_wayD_set   and rel_thrd_id_q(2));
reload_wayD_d(5) <=  ((not rel_par_wD_clr   and rel_wayD_val(5)))     or (rel_watch_set_q and rel_wayD_set   and rel_thrd_id_q(3));
-- Updating due to Reload or Data cache Parity error
reload_wayD_upd_d    <=  rel_par_wD_clr   or rel_wayD_set;
-- Updating due to Reload Clear only
reload_wayD_clr    <=  rel_par_wD_clr;
-- Invalidate Way
rel_par_wE_clr     <=  rel_wayE_clr   or dcpar_err_way_inval_q(4);
-- Invalidate/Reload Logic on Port1
reload_wayE_d(0) <=  (not rel_par_wE_clr   and rel_wayE_val(0))   or rel_wayE_set;
-- Lock Clear/Set Logic on Port1
reload_wayE_d(1) <=  (not rel_par_wE_clr   and rel_wayE_val(1))   or (rel_lock_set_q and rel_wayE_set);
-- Lost Lock due to Parity Error
dcpar_err_lock_lost(4) <=  rel_wayE_val(1)   and dcpar_err_way_inval_q(4);
-- Watch Clear/Set Logic on Port1
reload_wayE_d(2) <=  ((not rel_par_wE_clr   and rel_wayE_val(2)))     or (rel_watch_set_q and rel_wayE_set   and rel_thrd_id_q(0));
reload_wayE_d(3) <=  ((not rel_par_wE_clr   and rel_wayE_val(3)))     or (rel_watch_set_q and rel_wayE_set   and rel_thrd_id_q(1));
reload_wayE_d(4) <=  ((not rel_par_wE_clr   and rel_wayE_val(4)))     or (rel_watch_set_q and rel_wayE_set   and rel_thrd_id_q(2));
reload_wayE_d(5) <=  ((not rel_par_wE_clr   and rel_wayE_val(5)))     or (rel_watch_set_q and rel_wayE_set   and rel_thrd_id_q(3));
-- Updating due to Reload or Data cache Parity error
reload_wayE_upd_d    <=  rel_par_wE_clr   or rel_wayE_set;
-- Updating due to Reload Clear only
reload_wayE_clr    <=  rel_par_wE_clr;
-- Invalidate Way
rel_par_wF_clr     <=  rel_wayF_clr   or dcpar_err_way_inval_q(5);
-- Invalidate/Reload Logic on Port1
reload_wayF_d(0) <=  (not rel_par_wF_clr   and rel_wayF_val(0))   or rel_wayF_set;
-- Lock Clear/Set Logic on Port1
reload_wayF_d(1) <=  (not rel_par_wF_clr   and rel_wayF_val(1))   or (rel_lock_set_q and rel_wayF_set);
-- Lost Lock due to Parity Error
dcpar_err_lock_lost(5) <=  rel_wayF_val(1)   and dcpar_err_way_inval_q(5);
-- Watch Clear/Set Logic on Port1
reload_wayF_d(2) <=  ((not rel_par_wF_clr   and rel_wayF_val(2)))     or (rel_watch_set_q and rel_wayF_set   and rel_thrd_id_q(0));
reload_wayF_d(3) <=  ((not rel_par_wF_clr   and rel_wayF_val(3)))     or (rel_watch_set_q and rel_wayF_set   and rel_thrd_id_q(1));
reload_wayF_d(4) <=  ((not rel_par_wF_clr   and rel_wayF_val(4)))     or (rel_watch_set_q and rel_wayF_set   and rel_thrd_id_q(2));
reload_wayF_d(5) <=  ((not rel_par_wF_clr   and rel_wayF_val(5)))     or (rel_watch_set_q and rel_wayF_set   and rel_thrd_id_q(3));
-- Updating due to Reload or Data cache Parity error
reload_wayF_upd_d    <=  rel_par_wF_clr   or rel_wayF_set;
-- Updating due to Reload Clear only
reload_wayF_clr    <=  rel_par_wF_clr;
-- Invalidate Way
rel_par_wG_clr     <=  rel_wayG_clr   or dcpar_err_way_inval_q(6);
-- Invalidate/Reload Logic on Port1
reload_wayG_d(0) <=  (not rel_par_wG_clr   and rel_wayG_val(0))   or rel_wayG_set;
-- Lock Clear/Set Logic on Port1
reload_wayG_d(1) <=  (not rel_par_wG_clr   and rel_wayG_val(1))   or (rel_lock_set_q and rel_wayG_set);
-- Lost Lock due to Parity Error
dcpar_err_lock_lost(6) <=  rel_wayG_val(1)   and dcpar_err_way_inval_q(6);
-- Watch Clear/Set Logic on Port1
reload_wayG_d(2) <=  ((not rel_par_wG_clr   and rel_wayG_val(2)))     or (rel_watch_set_q and rel_wayG_set   and rel_thrd_id_q(0));
reload_wayG_d(3) <=  ((not rel_par_wG_clr   and rel_wayG_val(3)))     or (rel_watch_set_q and rel_wayG_set   and rel_thrd_id_q(1));
reload_wayG_d(4) <=  ((not rel_par_wG_clr   and rel_wayG_val(4)))     or (rel_watch_set_q and rel_wayG_set   and rel_thrd_id_q(2));
reload_wayG_d(5) <=  ((not rel_par_wG_clr   and rel_wayG_val(5)))     or (rel_watch_set_q and rel_wayG_set   and rel_thrd_id_q(3));
-- Updating due to Reload or Data cache Parity error
reload_wayG_upd_d    <=  rel_par_wG_clr   or rel_wayG_set;
-- Updating due to Reload Clear only
reload_wayG_clr    <=  rel_par_wG_clr;
-- Invalidate Way
rel_par_wH_clr     <=  rel_wayH_clr   or dcpar_err_way_inval_q(7);
-- Invalidate/Reload Logic on Port1
reload_wayH_d(0) <=  (not rel_par_wH_clr   and rel_wayH_val(0))   or rel_wayH_set;
-- Lock Clear/Set Logic on Port1
reload_wayH_d(1) <=  (not rel_par_wH_clr   and rel_wayH_val(1))   or (rel_lock_set_q and rel_wayH_set);
-- Lost Lock due to Parity Error
dcpar_err_lock_lost(7) <=  rel_wayH_val(1)   and dcpar_err_way_inval_q(7);
-- Watch Clear/Set Logic on Port1
reload_wayH_d(2) <=  ((not rel_par_wH_clr   and rel_wayH_val(2)))     or (rel_watch_set_q and rel_wayH_set   and rel_thrd_id_q(0));
reload_wayH_d(3) <=  ((not rel_par_wH_clr   and rel_wayH_val(3)))     or (rel_watch_set_q and rel_wayH_set   and rel_thrd_id_q(1));
reload_wayH_d(4) <=  ((not rel_par_wH_clr   and rel_wayH_val(4)))     or (rel_watch_set_q and rel_wayH_set   and rel_thrd_id_q(2));
reload_wayH_d(5) <=  ((not rel_par_wH_clr   and rel_wayH_val(5)))     or (rel_watch_set_q and rel_wayH_set   and rel_thrd_id_q(3));
-- Updating due to Reload or Data cache Parity error
reload_wayH_upd_d    <=  rel_par_wH_clr   or rel_wayH_set;
-- Updating due to Reload Clear only
reload_wayH_clr    <=  rel_par_wH_clr;
reload_way_clr_d  <=  reload_wayA_clr & reload_wayB_clr & reload_wayC_clr & reload_wayD_clr &
                    reload_wayE_clr & reload_wayF_clr & reload_wayG_clr & reload_wayH_clr;
-- ####################################################
-- Determine if Watch was lost due to a reload or
-- due to a Back-Invalidate of loadmissQ entry
-- ####################################################
-- Watch Lost due to L1DUMP of reload
rel4_l1dump_watch  <=  rel4_l1dump_val_q and rel_watch_set_q and not rel4_ecc_err;
lost_watch_l1dump  <=  gate(rel_thrd_id_q, rel4_l1dump_watch);
-- Watch Lost due to Overlock
lost_watch_evict_ovl_d  <=  (gate(rel_thrd_id_q, (rel_watch_set_q and rel_val_stg4 and not
                                               (rel_wayA_set or rel_wayB_set or rel_wayC_set or rel_wayD_set or
                                                rel_wayE_set or rel_wayF_set or rel_wayG_set or rel_wayH_set)))) or
                           lost_watch_l1dump;
-- Watch Lost due to Eviction
rel_lost_watch_wayA_evict    <=  gate(rel_wayA_val_stg_q(2   to 5), reload_way_clr_q(0));
rel_lost_watch_wayB_evict    <=  gate(rel_wayB_val_stg_q(2   to 5), reload_way_clr_q(1));
rel_lost_watch_wayC_evict    <=  gate(rel_wayC_val_stg_q(2   to 5), reload_way_clr_q(2));
rel_lost_watch_wayD_evict    <=  gate(rel_wayD_val_stg_q(2   to 5), reload_way_clr_q(3));
rel_lost_watch_wayE_evict    <=  gate(rel_wayE_val_stg_q(2   to 5), reload_way_clr_q(4));
rel_lost_watch_wayF_evict    <=  gate(rel_wayF_val_stg_q(2   to 5), reload_way_clr_q(5));
rel_lost_watch_wayG_evict    <=  gate(rel_wayG_val_stg_q(2   to 5), reload_way_clr_q(6));
rel_lost_watch_wayH_evict    <=  gate(rel_wayH_val_stg_q(2   to 5), reload_way_clr_q(7));
-- Watch Lost due to back-invalidate
rel_lost_watch_binv_d  <=  rel_watch_lost;
-- None Bypass Watch Lost indicator
rel_lost_watch_evict_np  <=  rel_lost_watch_wayA_evict or rel_lost_watch_wayB_evict or rel_lost_watch_wayC_evict or rel_lost_watch_wayD_evict or
                           rel_lost_watch_wayE_evict or rel_lost_watch_wayF_evict or rel_lost_watch_wayG_evict or rel_lost_watch_wayH_evict;
-- Data Cache Parity error lost Lock Bit
dcperr_lock_lost_d  <=  or_reduce(dcpar_err_lock_lost);
-- Staging out congruence class compares
rel24_congr_cl_ex4_cmp_d  <=  congr_cl_rel13_ex3_cmp_q;
rel24_congr_cl_ex5_cmp_d  <=  congr_cl_rel13_ex4_cmp_q;
rel24_congr_cl_ex6_cmp_d  <=  congr_cl_rel13_ex5_cmp_q;
relu_congr_cl_ex5_cmp_d   <=  rel24_congr_cl_ex4_cmp_q;
relu_congr_cl_ex6_cmp_d   <=  rel24_congr_cl_ex5_cmp_q;
relu_congr_cl_ex7_cmp_d   <=  rel24_congr_cl_ex6_cmp_q;
-- Data of ways updated in other stages
relu_dir_data  <=  gate(reload_wayA_q(2 to 5), reload_way_clr_q(0)) or gate(reload_wayB_q(2 to 5), reload_way_clr_q(1)) or
                 gate(reload_wayC_q(2 to 5), reload_way_clr_q(2)) or gate(reload_wayD_q(2 to 5), reload_way_clr_q(3)) or
                 gate(reload_wayE_q(2 to 5), reload_way_clr_q(4)) or gate(reload_wayF_q(2 to 5), reload_way_clr_q(5)) or
                 gate(reload_wayG_q(2 to 5), reload_way_clr_q(6)) or gate(reload_wayH_q(2 to 5), reload_way_clr_q(7));
-- LDAWX hit way in pipe collided with reload clear of same way in rel1_val stage
rel_ex5_watchSet_coll  <=  rel_val_clr_q and relu_congr_cl_ex5_cmp_q and or_reduce(reload_way_clr_q and binv5_ex5_way_upd)   and p0_wren_d;
rel_ex6_watchSet_coll  <=  rel_val_clr_q and relu_congr_cl_ex6_cmp_q and or_reduce(reload_way_clr_q and binv6_ex6_way_upd)   and p0_wren_q;
rel_ex7_watchSet_coll  <=  rel_val_clr_q and relu_congr_cl_ex7_cmp_q and or_reduce(reload_way_clr_q and binv7_ex7_way_upd_q) and p0_wren_stg_q;
rel_coll_val           <=  rel_ex5_watchSet_coll or rel_ex6_watchSet_coll or rel_ex7_watchSet_coll;
-- Priority Calculation
rel_pri_byp_sel(0) <=  rel_ex5_watchSet_coll;
rel_pri_byp_sel(1) <=  rel_ex6_watchSet_coll and not rel_ex5_watchSet_coll;
rel_pri_byp_sel(2) <=  rel_ex7_watchSet_coll and not (rel_ex6_watchSet_coll or rel_ex5_watchSet_coll);
rel_byp_dir_data  <=  gate(binv5_ex5_dir_data_q(2 to 5), rel_pri_byp_sel(0)) or
                    gate(binv6_ex6_dir_data_q(2 to 5), rel_pri_byp_sel(1)) or
                    gate(binv7_ex7_dir_data_q(2 to 5), rel_pri_byp_sel(2));
-- Reload invalidated a watched line
rel_watchSet_coll_tid  <=  (rel_byp_dir_data and not relu_dir_data) or gate(rel_lost_watch_evict_np, (rel_val_clr_q and not rel_coll_val));
-- Watch Lost due to eviction or overlock or pipe collision with ldawx
rel_lost_watch_evict   <=  lost_watch_evict_ovl_q or rel_watchSet_coll_tid;
-- Watch Lost due to back-invalidate or overlock or eviction or pipe collision with ldawx
rel_lost_watch_upd_d  <=  rel_lost_watch_binv_q or rel_lost_watch_evict;
-- ####################################################
-- Performance Events
-- ####################################################
-- Performance Event, Back-Invalidate Hit
perf_binv_hit     <=  back_inval_stg4_q and or_reduce(ex4_way_hit_q);
-- Performance Event, Watch Checks Completed
ex5_watch_chk_cplt    <=  ex5_watch_chk_q and not ex5_stg_flush;
-- Performance Event, Watch Checked Successfull
ex5_watch_chk_succ    <=  ex5_watch_chk_q and not (ex5_cr_watch_q or ex5_stg_flush);
-- Performance Event, LDAWX. instruction executed and CR=1 (indicates a duplicate watch set)
ex5_watch_dup_set    <=  ex5_watch_set_q and ex5_cr_watch_q and not ex5_stg_flush;
-- Performance Event, Watches lost due to other thread
lost_watch_inter_thrd_d  <=  gate((ex5_watchlost_set_q and not (ex5_thrd_id_q or ex5_watch_clr_all_q)), ex5_xuop_val);
-- Performance Event, Watches lost due to Eviction or Overlock
lost_watch_evict_val_d  <=  lost_watch_evict_ovl_q or rel_watchSet_coll_tid;
-- Performance Event, Watch Lost due to back-invalidate
lost_watch_binv  <=  binv5_inval_watch_val_q or rel_lost_watch_binv_q;
-- Performance Event, Latching up Events
perf_lsu_evnts_d  <=  back_inval_stg4_q & perf_binv_hit & ex5_watch_chk_cplt & ex5_watch_chk_succ & ex5_watch_dup_set;
-- ####################################################
-- Parity Error Recovery Logic
-- ####################################################
-- Parity Error detected in EX6, need to invalidate any
-- Load Hits in EX6, EX5, and EX4 since these requests
-- Will be satisfied by the L2. Parity Error Recovery
-- Sequencer waits for the first parity error to reach EX9
-- in the Parity Error Recovery Queue  before it starts
-- The sequencer will look for a hole in the reload pipe
-- and use it to invalidate the way with the parity error
-- of the load hit including valids,lock,and watch bits.
-- The Queue consists of a Parity Error Indicator,
-- Load Valid Indicator, Congruence Class, and Way Hit
dcpar_err_push        <=  not ex9_ld_par_err_q;
dcpar_err_rec_cmpl    <=  (dcpar_err_cntr_q = "10") and dcpar_err_nxt_rec;
dcpar_err_nxt_rec     <=  ex9_ld_par_err_q and not rel_in_progress;
dcpar_err_push_queue  <=  dcpar_err_push or dcpar_err_nxt_rec;
dcpar_err_ind_sel     <=  dcpar_err_push & dcpar_err_rec_cmpl;
dcpar_err_ind_sel_d     <=  dcpar_err_ind_sel;
dcpar_err_push_queue_d  <=  dcpar_err_push_queue;
-- Parity Error Recovery Queue
-- ####################################################
-- Parity Error Indicator
with dcpar_err_ind_sel select
    ex7_ld_par_err_d  <=    ex6_ld_par_err when "10",
                        ex7_ld_par_err_q when "00",
                                     '0' when others;
with dcpar_err_ind_sel select
    ex8_ld_par_err_d  <=  ex7_ld_par_err_q when "10",
                        ex8_ld_par_err_q when "00",
                                     '0' when others;
with dcpar_err_ind_sel select
    ex9_ld_par_err_d  <=  ex8_ld_par_err_q when "10",
                        ex9_ld_par_err_q when "00",
                                     '0' when others;
-- Load Hit Valid Indicator
with dcpar_err_push_queue select
    ex7_ld_valid_d  <=  ex6_ld_valid_q when '1',
                      ex7_ld_valid_q when others;
with dcpar_err_push_queue select
    ex8_ld_valid_d  <=  ex7_ld_valid_q when '1',
                      ex8_ld_valid_q when others;
with dcpar_err_push_queue select
    ex9_ld_valid_d  <=  ex8_ld_valid_q when '1',
                      ex9_ld_valid_q when others;
-- Congruence Class
with dcpar_err_push_queue select
    ex7_congr_cl_d  <=  ex6_congr_cl_q when '1',
                      ex7_congr_cl_q when others;
with dcpar_err_push_queue select
    ex8_congr_cl_d  <=  ex7_congr_cl_q when '1',
                      ex8_congr_cl_q when others;
with dcpar_err_push_queue select
    ex9_congr_cl_d  <=  ex8_congr_cl_q when '1',
                      ex9_congr_cl_q when others;
-- Way Hit
with dcpar_err_push_queue select
    ex7_way_hit_d  <=  ex6_way_hit_q when '1',
                     ex7_way_hit_q when others;
with dcpar_err_push_queue select
    ex8_way_hit_d  <=  ex7_way_hit_q when '1',
                     ex8_way_hit_q when others;
with dcpar_err_push_queue select
    ex9_way_hit_d  <=  ex8_way_hit_q when '1',
                     ex9_way_hit_q when others;
-- Parity Error Recovery Counter
dcpar_err_incr_val  <=  dcpar_err_nxt_rec and not (dcpar_err_cntr_q = "10");
dcpar_err_cntr_sel  <=  dcpar_err_push & dcpar_err_incr_val;
dcpar_err_nxt_cntr  <=  std_ulogic_vector(unsigned(dcpar_err_cntr_q) + "01");
with dcpar_err_cntr_sel select
    dcpar_err_cntr_d  <=  dcpar_err_nxt_cntr when "01",
                          dcpar_err_cntr_q when "00",
                                      "00" when others;
-- Generate a Pulse for Parity Error Completion
dcpar_err_stg1_d       <=  dcpar_err_nxt_rec;
dcpar_err_stg2_d       <=  dcpar_err_stg1_q;
dcpar_err_congr_cl     <=  ex9_congr_cl_q;
dcpar_err_way_d        <=  gate(ex9_way_hit_q, (ex9_ld_valid_q and dcpar_err_nxt_rec));
dcpar_err_way_inval_d  <=  dcpar_err_way_q;
dcpar_err_flush        <=  ex9_ld_par_err_q;
dcpar_err_stg1_act_d   <=  ex9_ld_par_err_q;
dcpar_err_stg2_act_d   <=  dcpar_err_stg1_act_q;
dcpar_err_rec_inprog   <=  ex7_ld_par_err_q or ex8_ld_par_err_q or ex9_ld_par_err_q;
-- ####################################################
-- Directory Valid Bits Write Enable Generation
-- ####################################################
-- Valids are updated for the following operations
-- 1) Reload -> updated the following cycle of the first beat,
--              need to invalidate the way that will be overwritten
-- 2) Reload -> updated on the last data beat when no ECC error was detected,
--              the Way will be validated that was replaced
-- 3) Back-Invalidate -> updated the following cycle
-- 4) DCBF -> Updated in EX4
-- 5) DCBI -> Updated in EX4
-- 6) DCBZ -> Updated in EX4
-- 7) LWARX Hit Invalidate -> Updated in EX4
-- 8) STWCX Hit Invalidate -> Updated in EX4
-- Lock Bits are updated for the following operations
-- 1) Reload -> updated the following cycle of the first beat,
--              need to clear the lock bit for the way that will be overwritten
-- 2) Reload -> updated on the last data beat when no ECC error was detected,
--              the Lock bit will be set that was replaced if originally a lock type op
-- 3) Back-Invalidate -> will clear lock bit the following cycle
-- 4) DCBF -> will clear lock bit in EX4
-- 5) DCBI -> will clear lock bit in EX4
-- 6) DCBZ -> will clear lock bit in EX4
-- 7) LWARX Hit Invalidate -> will clear lock bit in EX4
-- 8) STWCX Hit Invalidate -> will clear lock bit in EX4
-- 9) DCBLC -> will clear lock bit in EX4
--10) DCBTLS/DCBTSTLS -> will set lock bit in EX4 if hit
-- Port0 Updates
-- 1) XU Invalidate Op
-- 2) BACK-INV Update
-- 3) XU clear Lock Op
-- 4) XU set Lock Op
p0_wren_d      <=  back_inval_stg5_q or ex5_xuop_val or ex5_dir_err_val_q;
p0_wren_cpy_d  <=  back_inval_stg5_q or ex5_xuop_val or ex5_dir_err_val_q;
p0_wren_stg_d  <=  p0_wren_q;
-- Port1 Updates
-- 1) RELOAD_CLR
-- 2) RELOAD_SEt
-- 3) DC Array Parity Error with Loadhit followed by storehit update - need to invalidate storehit cline
p1_wren_d      <=  rel_port_wren_q;
p1_wren_cpy_d  <=  rel_port_wren_q;
p1_upd_val     <=  rel_port_upd_q;
-- Need to set reload way valid bit when clearing the valid bit of older load
-- in case second reload of interleaved reloads to same congruence class
-- Dont want second reload to overwrite first reload that cleared the valid bit
-- Second reload will choose the same way if not set by first
reload_wayA(0) <=  (reload_wayA_upd_q);
reload_wayA(1) <=  reload_wayA_q(1);
reload_wayA(2 TO 5) <=  reload_wayA_q(2   to 5);
-- Staging out Reload Pipe Updates
reload_wayA_upd2_d     <=  reload_wayA_upd_q;
reload_wayA_data_d     <=  reload_wayA_q;
reload_wayA_upd3_d     <=  reload_wayA_upd2_q;
reload_wayA_data2_d    <=  reload_wayA_data_q;
-- Staging out Back-Invalidate Pipe Updates
binv_wayA_upd1        <=  (binv_wayA_upd_q   and ((not ex4_dir_err_val_q) or back_inval_stg4_q)) or ex4_err_det_way_q(0)     or ex4_dir_multihit_val;
binv_wayA_upd2_d      <=  binv_wayA_upd1;
flush_wayA_data1      <=  gate(flush_wayA_q,   not (ex4_err_det_way_q(0)     or ex4_dir_multihit_val));
flush_wayA_data_d     <=  flush_wayA_data1;
binv_wayA_upd3_d      <=  binv_wayA_upd2_q;
flush_wayA_data2_d    <=  flush_wayA_data_q;
reload_wayB(0) <=  (reload_wayB_upd_q);
reload_wayB(1) <=  reload_wayB_q(1);
reload_wayB(2 TO 5) <=  reload_wayB_q(2   to 5);
-- Staging out Reload Pipe Updates
reload_wayB_upd2_d     <=  reload_wayB_upd_q;
reload_wayB_data_d     <=  reload_wayB_q;
reload_wayB_upd3_d     <=  reload_wayB_upd2_q;
reload_wayB_data2_d    <=  reload_wayB_data_q;
-- Staging out Back-Invalidate Pipe Updates
binv_wayB_upd1        <=  (binv_wayB_upd_q   and ((not ex4_dir_err_val_q) or back_inval_stg4_q)) or ex4_err_det_way_q(1)     or ex4_dir_multihit_val;
binv_wayB_upd2_d      <=  binv_wayB_upd1;
flush_wayB_data1      <=  gate(flush_wayB_q,   not (ex4_err_det_way_q(1)     or ex4_dir_multihit_val));
flush_wayB_data_d     <=  flush_wayB_data1;
binv_wayB_upd3_d      <=  binv_wayB_upd2_q;
flush_wayB_data2_d    <=  flush_wayB_data_q;
reload_wayC(0) <=  (reload_wayC_upd_q);
reload_wayC(1) <=  reload_wayC_q(1);
reload_wayC(2 TO 5) <=  reload_wayC_q(2   to 5);
-- Staging out Reload Pipe Updates
reload_wayC_upd2_d     <=  reload_wayC_upd_q;
reload_wayC_data_d     <=  reload_wayC_q;
reload_wayC_upd3_d     <=  reload_wayC_upd2_q;
reload_wayC_data2_d    <=  reload_wayC_data_q;
-- Staging out Back-Invalidate Pipe Updates
binv_wayC_upd1        <=  (binv_wayC_upd_q   and ((not ex4_dir_err_val_q) or back_inval_stg4_q)) or ex4_err_det_way_q(2)     or ex4_dir_multihit_val;
binv_wayC_upd2_d      <=  binv_wayC_upd1;
flush_wayC_data1      <=  gate(flush_wayC_q,   not (ex4_err_det_way_q(2)     or ex4_dir_multihit_val));
flush_wayC_data_d     <=  flush_wayC_data1;
binv_wayC_upd3_d      <=  binv_wayC_upd2_q;
flush_wayC_data2_d    <=  flush_wayC_data_q;
reload_wayD(0) <=  (reload_wayD_upd_q);
reload_wayD(1) <=  reload_wayD_q(1);
reload_wayD(2 TO 5) <=  reload_wayD_q(2   to 5);
-- Staging out Reload Pipe Updates
reload_wayD_upd2_d     <=  reload_wayD_upd_q;
reload_wayD_data_d     <=  reload_wayD_q;
reload_wayD_upd3_d     <=  reload_wayD_upd2_q;
reload_wayD_data2_d    <=  reload_wayD_data_q;
-- Staging out Back-Invalidate Pipe Updates
binv_wayD_upd1        <=  (binv_wayD_upd_q   and ((not ex4_dir_err_val_q) or back_inval_stg4_q)) or ex4_err_det_way_q(3)     or ex4_dir_multihit_val;
binv_wayD_upd2_d      <=  binv_wayD_upd1;
flush_wayD_data1      <=  gate(flush_wayD_q,   not (ex4_err_det_way_q(3)     or ex4_dir_multihit_val));
flush_wayD_data_d     <=  flush_wayD_data1;
binv_wayD_upd3_d      <=  binv_wayD_upd2_q;
flush_wayD_data2_d    <=  flush_wayD_data_q;
reload_wayE(0) <=  (reload_wayE_upd_q);
reload_wayE(1) <=  reload_wayE_q(1);
reload_wayE(2 TO 5) <=  reload_wayE_q(2   to 5);
-- Staging out Reload Pipe Updates
reload_wayE_upd2_d     <=  reload_wayE_upd_q;
reload_wayE_data_d     <=  reload_wayE_q;
reload_wayE_upd3_d     <=  reload_wayE_upd2_q;
reload_wayE_data2_d    <=  reload_wayE_data_q;
-- Staging out Back-Invalidate Pipe Updates
binv_wayE_upd1        <=  (binv_wayE_upd_q   and ((not ex4_dir_err_val_q) or back_inval_stg4_q)) or ex4_err_det_way_q(4)     or ex4_dir_multihit_val;
binv_wayE_upd2_d      <=  binv_wayE_upd1;
flush_wayE_data1      <=  gate(flush_wayE_q,   not (ex4_err_det_way_q(4)     or ex4_dir_multihit_val));
flush_wayE_data_d     <=  flush_wayE_data1;
binv_wayE_upd3_d      <=  binv_wayE_upd2_q;
flush_wayE_data2_d    <=  flush_wayE_data_q;
reload_wayF(0) <=  (reload_wayF_upd_q);
reload_wayF(1) <=  reload_wayF_q(1);
reload_wayF(2 TO 5) <=  reload_wayF_q(2   to 5);
-- Staging out Reload Pipe Updates
reload_wayF_upd2_d     <=  reload_wayF_upd_q;
reload_wayF_data_d     <=  reload_wayF_q;
reload_wayF_upd3_d     <=  reload_wayF_upd2_q;
reload_wayF_data2_d    <=  reload_wayF_data_q;
-- Staging out Back-Invalidate Pipe Updates
binv_wayF_upd1        <=  (binv_wayF_upd_q   and ((not ex4_dir_err_val_q) or back_inval_stg4_q)) or ex4_err_det_way_q(5)     or ex4_dir_multihit_val;
binv_wayF_upd2_d      <=  binv_wayF_upd1;
flush_wayF_data1      <=  gate(flush_wayF_q,   not (ex4_err_det_way_q(5)     or ex4_dir_multihit_val));
flush_wayF_data_d     <=  flush_wayF_data1;
binv_wayF_upd3_d      <=  binv_wayF_upd2_q;
flush_wayF_data2_d    <=  flush_wayF_data_q;
reload_wayG(0) <=  (reload_wayG_upd_q);
reload_wayG(1) <=  reload_wayG_q(1);
reload_wayG(2 TO 5) <=  reload_wayG_q(2   to 5);
-- Staging out Reload Pipe Updates
reload_wayG_upd2_d     <=  reload_wayG_upd_q;
reload_wayG_data_d     <=  reload_wayG_q;
reload_wayG_upd3_d     <=  reload_wayG_upd2_q;
reload_wayG_data2_d    <=  reload_wayG_data_q;
-- Staging out Back-Invalidate Pipe Updates
binv_wayG_upd1        <=  (binv_wayG_upd_q   and ((not ex4_dir_err_val_q) or back_inval_stg4_q)) or ex4_err_det_way_q(6)     or ex4_dir_multihit_val;
binv_wayG_upd2_d      <=  binv_wayG_upd1;
flush_wayG_data1      <=  gate(flush_wayG_q,   not (ex4_err_det_way_q(6)     or ex4_dir_multihit_val));
flush_wayG_data_d     <=  flush_wayG_data1;
binv_wayG_upd3_d      <=  binv_wayG_upd2_q;
flush_wayG_data2_d    <=  flush_wayG_data_q;
reload_wayH(0) <=  (reload_wayH_upd_q);
reload_wayH(1) <=  reload_wayH_q(1);
reload_wayH(2 TO 5) <=  reload_wayH_q(2   to 5);
-- Staging out Reload Pipe Updates
reload_wayH_upd2_d     <=  reload_wayH_upd_q;
reload_wayH_data_d     <=  reload_wayH_q;
reload_wayH_upd3_d     <=  reload_wayH_upd2_q;
reload_wayH_data2_d    <=  reload_wayH_data_q;
-- Staging out Back-Invalidate Pipe Updates
binv_wayH_upd1        <=  (binv_wayH_upd_q   and ((not ex4_dir_err_val_q) or back_inval_stg4_q)) or ex4_err_det_way_q(7)     or ex4_dir_multihit_val;
binv_wayH_upd2_d      <=  binv_wayH_upd1;
flush_wayH_data1      <=  gate(flush_wayH_q,   not (ex4_err_det_way_q(7)     or ex4_dir_multihit_val));
flush_wayH_data_d     <=  flush_wayH_data1;
binv_wayH_upd3_d      <=  binv_wayH_upd2_q;
flush_wayH_data2_d    <=  flush_wayH_data_q;
-- XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
-- Table for selecting Ports data for
-- updating to the same way and
-- same congruence class
-- XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
-- P0           P1      |       PortSel
--------------------------------------------
-- binv2        relclr  |       P1
-- binv2        relset  |       P1
-- binv2        binv2   |       P1      <- Impossible
-- flush        relclr  |       P1
-- flush        relset  |       P1
-- flush        binv2   |       P1      <- FlushOp is flushed
-- lckset       relclr  |       P1
-- lckset       relset  |       P1
-- lckset       binv2   |       P1      <- LockSetOp is flushed
-- lckclr       relclr  |       P1
-- lckclr       relset  |       P1
-- lckclr       binv2   |       P1      <- LockClrOp is flushed
-- Act Pin to all Directory Latches
congr_cl_all_act_d    <=  ex5_watch_clr_all_val_q or dci_compl_q or lock_flash_clear_q;
-- Congruence Class Match
p0_congr_cl0_m        <=  (ex5_congr_cl_q    = tconv(0,6));
p1_congr_cl0_m        <=  (relu_s_congr_cl_q = tconv(0,6));
-- Act Pin to Directory Latches for specific congruence class
p0_congr_cl0_act_d    <=  p0_congr_cl0_m   and (back_inval_stg5_q or ex5_xuop_val_q or ex5_dir_err_val_q);
p1_congr_cl0_act_d    <=  p1_congr_cl0_m   and rel_port_wren_q;
congr_cl0_act         <=  p0_congr_cl0_act_q   or p1_congr_cl0_act_q   or congr_cl_all_act_q;
p0_way_data_upd0_wayA    <=  p0_congr_cl0_act_q   and binv_wayA_upd3_q;
p1_way_data_upd0_wayA    <=  p1_congr_cl0_act_q   and reload_wayA_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu0_wayA_upd(0) <=  p1_way_data_upd0_wayA   and p1_wren_q;
rel_bixu0_wayA_upd(1) <=  p0_way_data_upd0_wayA   and p0_wren_q;
p0_way_data_upd0_wayB    <=  p0_congr_cl0_act_q   and binv_wayB_upd3_q;
p1_way_data_upd0_wayB    <=  p1_congr_cl0_act_q   and reload_wayB_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu0_wayB_upd(0) <=  p1_way_data_upd0_wayB   and p1_wren_q;
rel_bixu0_wayB_upd(1) <=  p0_way_data_upd0_wayB   and p0_wren_q;
p0_way_data_upd0_wayC    <=  p0_congr_cl0_act_q   and binv_wayC_upd3_q;
p1_way_data_upd0_wayC    <=  p1_congr_cl0_act_q   and reload_wayC_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu0_wayC_upd(0) <=  p1_way_data_upd0_wayC   and p1_wren_q;
rel_bixu0_wayC_upd(1) <=  p0_way_data_upd0_wayC   and p0_wren_q;
p0_way_data_upd0_wayD    <=  p0_congr_cl0_act_q   and binv_wayD_upd3_q;
p1_way_data_upd0_wayD    <=  p1_congr_cl0_act_q   and reload_wayD_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu0_wayD_upd(0) <=  p1_way_data_upd0_wayD   and p1_wren_q;
rel_bixu0_wayD_upd(1) <=  p0_way_data_upd0_wayD   and p0_wren_q;
p0_way_data_upd0_wayE    <=  p0_congr_cl0_act_q   and binv_wayE_upd3_q;
p1_way_data_upd0_wayE    <=  p1_congr_cl0_act_q   and reload_wayE_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu0_wayE_upd(0) <=  p1_way_data_upd0_wayE   and p1_wren_q;
rel_bixu0_wayE_upd(1) <=  p0_way_data_upd0_wayE   and p0_wren_q;
p0_way_data_upd0_wayF    <=  p0_congr_cl0_act_q   and binv_wayF_upd3_q;
p1_way_data_upd0_wayF    <=  p1_congr_cl0_act_q   and reload_wayF_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu0_wayF_upd(0) <=  p1_way_data_upd0_wayF   and p1_wren_q;
rel_bixu0_wayF_upd(1) <=  p0_way_data_upd0_wayF   and p0_wren_q;
p0_way_data_upd0_wayG    <=  p0_congr_cl0_act_q   and binv_wayG_upd3_q;
p1_way_data_upd0_wayG    <=  p1_congr_cl0_act_q   and reload_wayG_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu0_wayG_upd(0) <=  p1_way_data_upd0_wayG   and p1_wren_q;
rel_bixu0_wayG_upd(1) <=  p0_way_data_upd0_wayG   and p0_wren_q;
p0_way_data_upd0_wayH    <=  p0_congr_cl0_act_q   and binv_wayH_upd3_q;
p1_way_data_upd0_wayH    <=  p1_congr_cl0_act_q   and reload_wayH_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu0_wayH_upd(0) <=  p1_way_data_upd0_wayH   and p1_wren_q;
rel_bixu0_wayH_upd(1) <=  p0_way_data_upd0_wayH   and p0_wren_q;
-- Congruence Class Match
p0_congr_cl1_m        <=  (ex5_congr_cl_q    = tconv(1,6));
p1_congr_cl1_m        <=  (relu_s_congr_cl_q = tconv(1,6));
-- Act Pin to Directory Latches for specific congruence class
p0_congr_cl1_act_d    <=  p0_congr_cl1_m   and (back_inval_stg5_q or ex5_xuop_val_q or ex5_dir_err_val_q);
p1_congr_cl1_act_d    <=  p1_congr_cl1_m   and rel_port_wren_q;
congr_cl1_act         <=  p0_congr_cl1_act_q   or p1_congr_cl1_act_q   or congr_cl_all_act_q;
p0_way_data_upd1_wayA    <=  p0_congr_cl1_act_q   and binv_wayA_upd3_q;
p1_way_data_upd1_wayA    <=  p1_congr_cl1_act_q   and reload_wayA_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu1_wayA_upd(0) <=  p1_way_data_upd1_wayA   and p1_wren_q;
rel_bixu1_wayA_upd(1) <=  p0_way_data_upd1_wayA   and p0_wren_q;
p0_way_data_upd1_wayB    <=  p0_congr_cl1_act_q   and binv_wayB_upd3_q;
p1_way_data_upd1_wayB    <=  p1_congr_cl1_act_q   and reload_wayB_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu1_wayB_upd(0) <=  p1_way_data_upd1_wayB   and p1_wren_q;
rel_bixu1_wayB_upd(1) <=  p0_way_data_upd1_wayB   and p0_wren_q;
p0_way_data_upd1_wayC    <=  p0_congr_cl1_act_q   and binv_wayC_upd3_q;
p1_way_data_upd1_wayC    <=  p1_congr_cl1_act_q   and reload_wayC_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu1_wayC_upd(0) <=  p1_way_data_upd1_wayC   and p1_wren_q;
rel_bixu1_wayC_upd(1) <=  p0_way_data_upd1_wayC   and p0_wren_q;
p0_way_data_upd1_wayD    <=  p0_congr_cl1_act_q   and binv_wayD_upd3_q;
p1_way_data_upd1_wayD    <=  p1_congr_cl1_act_q   and reload_wayD_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu1_wayD_upd(0) <=  p1_way_data_upd1_wayD   and p1_wren_q;
rel_bixu1_wayD_upd(1) <=  p0_way_data_upd1_wayD   and p0_wren_q;
p0_way_data_upd1_wayE    <=  p0_congr_cl1_act_q   and binv_wayE_upd3_q;
p1_way_data_upd1_wayE    <=  p1_congr_cl1_act_q   and reload_wayE_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu1_wayE_upd(0) <=  p1_way_data_upd1_wayE   and p1_wren_q;
rel_bixu1_wayE_upd(1) <=  p0_way_data_upd1_wayE   and p0_wren_q;
p0_way_data_upd1_wayF    <=  p0_congr_cl1_act_q   and binv_wayF_upd3_q;
p1_way_data_upd1_wayF    <=  p1_congr_cl1_act_q   and reload_wayF_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu1_wayF_upd(0) <=  p1_way_data_upd1_wayF   and p1_wren_q;
rel_bixu1_wayF_upd(1) <=  p0_way_data_upd1_wayF   and p0_wren_q;
p0_way_data_upd1_wayG    <=  p0_congr_cl1_act_q   and binv_wayG_upd3_q;
p1_way_data_upd1_wayG    <=  p1_congr_cl1_act_q   and reload_wayG_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu1_wayG_upd(0) <=  p1_way_data_upd1_wayG   and p1_wren_q;
rel_bixu1_wayG_upd(1) <=  p0_way_data_upd1_wayG   and p0_wren_q;
p0_way_data_upd1_wayH    <=  p0_congr_cl1_act_q   and binv_wayH_upd3_q;
p1_way_data_upd1_wayH    <=  p1_congr_cl1_act_q   and reload_wayH_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu1_wayH_upd(0) <=  p1_way_data_upd1_wayH   and p1_wren_q;
rel_bixu1_wayH_upd(1) <=  p0_way_data_upd1_wayH   and p0_wren_q;
-- Congruence Class Match
p0_congr_cl2_m        <=  (ex5_congr_cl_q    = tconv(2,6));
p1_congr_cl2_m        <=  (relu_s_congr_cl_q = tconv(2,6));
-- Act Pin to Directory Latches for specific congruence class
p0_congr_cl2_act_d    <=  p0_congr_cl2_m   and (back_inval_stg5_q or ex5_xuop_val_q or ex5_dir_err_val_q);
p1_congr_cl2_act_d    <=  p1_congr_cl2_m   and rel_port_wren_q;
congr_cl2_act         <=  p0_congr_cl2_act_q   or p1_congr_cl2_act_q   or congr_cl_all_act_q;
p0_way_data_upd2_wayA    <=  p0_congr_cl2_act_q   and binv_wayA_upd3_q;
p1_way_data_upd2_wayA    <=  p1_congr_cl2_act_q   and reload_wayA_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu2_wayA_upd(0) <=  p1_way_data_upd2_wayA   and p1_wren_q;
rel_bixu2_wayA_upd(1) <=  p0_way_data_upd2_wayA   and p0_wren_q;
p0_way_data_upd2_wayB    <=  p0_congr_cl2_act_q   and binv_wayB_upd3_q;
p1_way_data_upd2_wayB    <=  p1_congr_cl2_act_q   and reload_wayB_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu2_wayB_upd(0) <=  p1_way_data_upd2_wayB   and p1_wren_q;
rel_bixu2_wayB_upd(1) <=  p0_way_data_upd2_wayB   and p0_wren_q;
p0_way_data_upd2_wayC    <=  p0_congr_cl2_act_q   and binv_wayC_upd3_q;
p1_way_data_upd2_wayC    <=  p1_congr_cl2_act_q   and reload_wayC_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu2_wayC_upd(0) <=  p1_way_data_upd2_wayC   and p1_wren_q;
rel_bixu2_wayC_upd(1) <=  p0_way_data_upd2_wayC   and p0_wren_q;
p0_way_data_upd2_wayD    <=  p0_congr_cl2_act_q   and binv_wayD_upd3_q;
p1_way_data_upd2_wayD    <=  p1_congr_cl2_act_q   and reload_wayD_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu2_wayD_upd(0) <=  p1_way_data_upd2_wayD   and p1_wren_q;
rel_bixu2_wayD_upd(1) <=  p0_way_data_upd2_wayD   and p0_wren_q;
p0_way_data_upd2_wayE    <=  p0_congr_cl2_act_q   and binv_wayE_upd3_q;
p1_way_data_upd2_wayE    <=  p1_congr_cl2_act_q   and reload_wayE_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu2_wayE_upd(0) <=  p1_way_data_upd2_wayE   and p1_wren_q;
rel_bixu2_wayE_upd(1) <=  p0_way_data_upd2_wayE   and p0_wren_q;
p0_way_data_upd2_wayF    <=  p0_congr_cl2_act_q   and binv_wayF_upd3_q;
p1_way_data_upd2_wayF    <=  p1_congr_cl2_act_q   and reload_wayF_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu2_wayF_upd(0) <=  p1_way_data_upd2_wayF   and p1_wren_q;
rel_bixu2_wayF_upd(1) <=  p0_way_data_upd2_wayF   and p0_wren_q;
p0_way_data_upd2_wayG    <=  p0_congr_cl2_act_q   and binv_wayG_upd3_q;
p1_way_data_upd2_wayG    <=  p1_congr_cl2_act_q   and reload_wayG_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu2_wayG_upd(0) <=  p1_way_data_upd2_wayG   and p1_wren_q;
rel_bixu2_wayG_upd(1) <=  p0_way_data_upd2_wayG   and p0_wren_q;
p0_way_data_upd2_wayH    <=  p0_congr_cl2_act_q   and binv_wayH_upd3_q;
p1_way_data_upd2_wayH    <=  p1_congr_cl2_act_q   and reload_wayH_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu2_wayH_upd(0) <=  p1_way_data_upd2_wayH   and p1_wren_q;
rel_bixu2_wayH_upd(1) <=  p0_way_data_upd2_wayH   and p0_wren_q;
-- Congruence Class Match
p0_congr_cl3_m        <=  (ex5_congr_cl_q    = tconv(3,6));
p1_congr_cl3_m        <=  (relu_s_congr_cl_q = tconv(3,6));
-- Act Pin to Directory Latches for specific congruence class
p0_congr_cl3_act_d    <=  p0_congr_cl3_m   and (back_inval_stg5_q or ex5_xuop_val_q or ex5_dir_err_val_q);
p1_congr_cl3_act_d    <=  p1_congr_cl3_m   and rel_port_wren_q;
congr_cl3_act         <=  p0_congr_cl3_act_q   or p1_congr_cl3_act_q   or congr_cl_all_act_q;
p0_way_data_upd3_wayA    <=  p0_congr_cl3_act_q   and binv_wayA_upd3_q;
p1_way_data_upd3_wayA    <=  p1_congr_cl3_act_q   and reload_wayA_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu3_wayA_upd(0) <=  p1_way_data_upd3_wayA   and p1_wren_q;
rel_bixu3_wayA_upd(1) <=  p0_way_data_upd3_wayA   and p0_wren_q;
p0_way_data_upd3_wayB    <=  p0_congr_cl3_act_q   and binv_wayB_upd3_q;
p1_way_data_upd3_wayB    <=  p1_congr_cl3_act_q   and reload_wayB_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu3_wayB_upd(0) <=  p1_way_data_upd3_wayB   and p1_wren_q;
rel_bixu3_wayB_upd(1) <=  p0_way_data_upd3_wayB   and p0_wren_q;
p0_way_data_upd3_wayC    <=  p0_congr_cl3_act_q   and binv_wayC_upd3_q;
p1_way_data_upd3_wayC    <=  p1_congr_cl3_act_q   and reload_wayC_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu3_wayC_upd(0) <=  p1_way_data_upd3_wayC   and p1_wren_q;
rel_bixu3_wayC_upd(1) <=  p0_way_data_upd3_wayC   and p0_wren_q;
p0_way_data_upd3_wayD    <=  p0_congr_cl3_act_q   and binv_wayD_upd3_q;
p1_way_data_upd3_wayD    <=  p1_congr_cl3_act_q   and reload_wayD_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu3_wayD_upd(0) <=  p1_way_data_upd3_wayD   and p1_wren_q;
rel_bixu3_wayD_upd(1) <=  p0_way_data_upd3_wayD   and p0_wren_q;
p0_way_data_upd3_wayE    <=  p0_congr_cl3_act_q   and binv_wayE_upd3_q;
p1_way_data_upd3_wayE    <=  p1_congr_cl3_act_q   and reload_wayE_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu3_wayE_upd(0) <=  p1_way_data_upd3_wayE   and p1_wren_q;
rel_bixu3_wayE_upd(1) <=  p0_way_data_upd3_wayE   and p0_wren_q;
p0_way_data_upd3_wayF    <=  p0_congr_cl3_act_q   and binv_wayF_upd3_q;
p1_way_data_upd3_wayF    <=  p1_congr_cl3_act_q   and reload_wayF_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu3_wayF_upd(0) <=  p1_way_data_upd3_wayF   and p1_wren_q;
rel_bixu3_wayF_upd(1) <=  p0_way_data_upd3_wayF   and p0_wren_q;
p0_way_data_upd3_wayG    <=  p0_congr_cl3_act_q   and binv_wayG_upd3_q;
p1_way_data_upd3_wayG    <=  p1_congr_cl3_act_q   and reload_wayG_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu3_wayG_upd(0) <=  p1_way_data_upd3_wayG   and p1_wren_q;
rel_bixu3_wayG_upd(1) <=  p0_way_data_upd3_wayG   and p0_wren_q;
p0_way_data_upd3_wayH    <=  p0_congr_cl3_act_q   and binv_wayH_upd3_q;
p1_way_data_upd3_wayH    <=  p1_congr_cl3_act_q   and reload_wayH_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu3_wayH_upd(0) <=  p1_way_data_upd3_wayH   and p1_wren_q;
rel_bixu3_wayH_upd(1) <=  p0_way_data_upd3_wayH   and p0_wren_q;
-- Congruence Class Match
p0_congr_cl4_m        <=  (ex5_congr_cl_q    = tconv(4,6));
p1_congr_cl4_m        <=  (relu_s_congr_cl_q = tconv(4,6));
-- Act Pin to Directory Latches for specific congruence class
p0_congr_cl4_act_d    <=  p0_congr_cl4_m   and (back_inval_stg5_q or ex5_xuop_val_q or ex5_dir_err_val_q);
p1_congr_cl4_act_d    <=  p1_congr_cl4_m   and rel_port_wren_q;
congr_cl4_act         <=  p0_congr_cl4_act_q   or p1_congr_cl4_act_q   or congr_cl_all_act_q;
p0_way_data_upd4_wayA    <=  p0_congr_cl4_act_q   and binv_wayA_upd3_q;
p1_way_data_upd4_wayA    <=  p1_congr_cl4_act_q   and reload_wayA_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu4_wayA_upd(0) <=  p1_way_data_upd4_wayA   and p1_wren_q;
rel_bixu4_wayA_upd(1) <=  p0_way_data_upd4_wayA   and p0_wren_q;
p0_way_data_upd4_wayB    <=  p0_congr_cl4_act_q   and binv_wayB_upd3_q;
p1_way_data_upd4_wayB    <=  p1_congr_cl4_act_q   and reload_wayB_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu4_wayB_upd(0) <=  p1_way_data_upd4_wayB   and p1_wren_q;
rel_bixu4_wayB_upd(1) <=  p0_way_data_upd4_wayB   and p0_wren_q;
p0_way_data_upd4_wayC    <=  p0_congr_cl4_act_q   and binv_wayC_upd3_q;
p1_way_data_upd4_wayC    <=  p1_congr_cl4_act_q   and reload_wayC_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu4_wayC_upd(0) <=  p1_way_data_upd4_wayC   and p1_wren_q;
rel_bixu4_wayC_upd(1) <=  p0_way_data_upd4_wayC   and p0_wren_q;
p0_way_data_upd4_wayD    <=  p0_congr_cl4_act_q   and binv_wayD_upd3_q;
p1_way_data_upd4_wayD    <=  p1_congr_cl4_act_q   and reload_wayD_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu4_wayD_upd(0) <=  p1_way_data_upd4_wayD   and p1_wren_q;
rel_bixu4_wayD_upd(1) <=  p0_way_data_upd4_wayD   and p0_wren_q;
p0_way_data_upd4_wayE    <=  p0_congr_cl4_act_q   and binv_wayE_upd3_q;
p1_way_data_upd4_wayE    <=  p1_congr_cl4_act_q   and reload_wayE_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu4_wayE_upd(0) <=  p1_way_data_upd4_wayE   and p1_wren_q;
rel_bixu4_wayE_upd(1) <=  p0_way_data_upd4_wayE   and p0_wren_q;
p0_way_data_upd4_wayF    <=  p0_congr_cl4_act_q   and binv_wayF_upd3_q;
p1_way_data_upd4_wayF    <=  p1_congr_cl4_act_q   and reload_wayF_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu4_wayF_upd(0) <=  p1_way_data_upd4_wayF   and p1_wren_q;
rel_bixu4_wayF_upd(1) <=  p0_way_data_upd4_wayF   and p0_wren_q;
p0_way_data_upd4_wayG    <=  p0_congr_cl4_act_q   and binv_wayG_upd3_q;
p1_way_data_upd4_wayG    <=  p1_congr_cl4_act_q   and reload_wayG_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu4_wayG_upd(0) <=  p1_way_data_upd4_wayG   and p1_wren_q;
rel_bixu4_wayG_upd(1) <=  p0_way_data_upd4_wayG   and p0_wren_q;
p0_way_data_upd4_wayH    <=  p0_congr_cl4_act_q   and binv_wayH_upd3_q;
p1_way_data_upd4_wayH    <=  p1_congr_cl4_act_q   and reload_wayH_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu4_wayH_upd(0) <=  p1_way_data_upd4_wayH   and p1_wren_q;
rel_bixu4_wayH_upd(1) <=  p0_way_data_upd4_wayH   and p0_wren_q;
-- Congruence Class Match
p0_congr_cl5_m        <=  (ex5_congr_cl_q    = tconv(5,6));
p1_congr_cl5_m        <=  (relu_s_congr_cl_q = tconv(5,6));
-- Act Pin to Directory Latches for specific congruence class
p0_congr_cl5_act_d    <=  p0_congr_cl5_m   and (back_inval_stg5_q or ex5_xuop_val_q or ex5_dir_err_val_q);
p1_congr_cl5_act_d    <=  p1_congr_cl5_m   and rel_port_wren_q;
congr_cl5_act         <=  p0_congr_cl5_act_q   or p1_congr_cl5_act_q   or congr_cl_all_act_q;
p0_way_data_upd5_wayA    <=  p0_congr_cl5_act_q   and binv_wayA_upd3_q;
p1_way_data_upd5_wayA    <=  p1_congr_cl5_act_q   and reload_wayA_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu5_wayA_upd(0) <=  p1_way_data_upd5_wayA   and p1_wren_q;
rel_bixu5_wayA_upd(1) <=  p0_way_data_upd5_wayA   and p0_wren_q;
p0_way_data_upd5_wayB    <=  p0_congr_cl5_act_q   and binv_wayB_upd3_q;
p1_way_data_upd5_wayB    <=  p1_congr_cl5_act_q   and reload_wayB_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu5_wayB_upd(0) <=  p1_way_data_upd5_wayB   and p1_wren_q;
rel_bixu5_wayB_upd(1) <=  p0_way_data_upd5_wayB   and p0_wren_q;
p0_way_data_upd5_wayC    <=  p0_congr_cl5_act_q   and binv_wayC_upd3_q;
p1_way_data_upd5_wayC    <=  p1_congr_cl5_act_q   and reload_wayC_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu5_wayC_upd(0) <=  p1_way_data_upd5_wayC   and p1_wren_q;
rel_bixu5_wayC_upd(1) <=  p0_way_data_upd5_wayC   and p0_wren_q;
p0_way_data_upd5_wayD    <=  p0_congr_cl5_act_q   and binv_wayD_upd3_q;
p1_way_data_upd5_wayD    <=  p1_congr_cl5_act_q   and reload_wayD_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu5_wayD_upd(0) <=  p1_way_data_upd5_wayD   and p1_wren_q;
rel_bixu5_wayD_upd(1) <=  p0_way_data_upd5_wayD   and p0_wren_q;
p0_way_data_upd5_wayE    <=  p0_congr_cl5_act_q   and binv_wayE_upd3_q;
p1_way_data_upd5_wayE    <=  p1_congr_cl5_act_q   and reload_wayE_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu5_wayE_upd(0) <=  p1_way_data_upd5_wayE   and p1_wren_q;
rel_bixu5_wayE_upd(1) <=  p0_way_data_upd5_wayE   and p0_wren_q;
p0_way_data_upd5_wayF    <=  p0_congr_cl5_act_q   and binv_wayF_upd3_q;
p1_way_data_upd5_wayF    <=  p1_congr_cl5_act_q   and reload_wayF_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu5_wayF_upd(0) <=  p1_way_data_upd5_wayF   and p1_wren_q;
rel_bixu5_wayF_upd(1) <=  p0_way_data_upd5_wayF   and p0_wren_q;
p0_way_data_upd5_wayG    <=  p0_congr_cl5_act_q   and binv_wayG_upd3_q;
p1_way_data_upd5_wayG    <=  p1_congr_cl5_act_q   and reload_wayG_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu5_wayG_upd(0) <=  p1_way_data_upd5_wayG   and p1_wren_q;
rel_bixu5_wayG_upd(1) <=  p0_way_data_upd5_wayG   and p0_wren_q;
p0_way_data_upd5_wayH    <=  p0_congr_cl5_act_q   and binv_wayH_upd3_q;
p1_way_data_upd5_wayH    <=  p1_congr_cl5_act_q   and reload_wayH_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu5_wayH_upd(0) <=  p1_way_data_upd5_wayH   and p1_wren_q;
rel_bixu5_wayH_upd(1) <=  p0_way_data_upd5_wayH   and p0_wren_q;
-- Congruence Class Match
p0_congr_cl6_m        <=  (ex5_congr_cl_q    = tconv(6,6));
p1_congr_cl6_m        <=  (relu_s_congr_cl_q = tconv(6,6));
-- Act Pin to Directory Latches for specific congruence class
p0_congr_cl6_act_d    <=  p0_congr_cl6_m   and (back_inval_stg5_q or ex5_xuop_val_q or ex5_dir_err_val_q);
p1_congr_cl6_act_d    <=  p1_congr_cl6_m   and rel_port_wren_q;
congr_cl6_act         <=  p0_congr_cl6_act_q   or p1_congr_cl6_act_q   or congr_cl_all_act_q;
p0_way_data_upd6_wayA    <=  p0_congr_cl6_act_q   and binv_wayA_upd3_q;
p1_way_data_upd6_wayA    <=  p1_congr_cl6_act_q   and reload_wayA_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu6_wayA_upd(0) <=  p1_way_data_upd6_wayA   and p1_wren_q;
rel_bixu6_wayA_upd(1) <=  p0_way_data_upd6_wayA   and p0_wren_q;
p0_way_data_upd6_wayB    <=  p0_congr_cl6_act_q   and binv_wayB_upd3_q;
p1_way_data_upd6_wayB    <=  p1_congr_cl6_act_q   and reload_wayB_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu6_wayB_upd(0) <=  p1_way_data_upd6_wayB   and p1_wren_q;
rel_bixu6_wayB_upd(1) <=  p0_way_data_upd6_wayB   and p0_wren_q;
p0_way_data_upd6_wayC    <=  p0_congr_cl6_act_q   and binv_wayC_upd3_q;
p1_way_data_upd6_wayC    <=  p1_congr_cl6_act_q   and reload_wayC_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu6_wayC_upd(0) <=  p1_way_data_upd6_wayC   and p1_wren_q;
rel_bixu6_wayC_upd(1) <=  p0_way_data_upd6_wayC   and p0_wren_q;
p0_way_data_upd6_wayD    <=  p0_congr_cl6_act_q   and binv_wayD_upd3_q;
p1_way_data_upd6_wayD    <=  p1_congr_cl6_act_q   and reload_wayD_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu6_wayD_upd(0) <=  p1_way_data_upd6_wayD   and p1_wren_q;
rel_bixu6_wayD_upd(1) <=  p0_way_data_upd6_wayD   and p0_wren_q;
p0_way_data_upd6_wayE    <=  p0_congr_cl6_act_q   and binv_wayE_upd3_q;
p1_way_data_upd6_wayE    <=  p1_congr_cl6_act_q   and reload_wayE_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu6_wayE_upd(0) <=  p1_way_data_upd6_wayE   and p1_wren_q;
rel_bixu6_wayE_upd(1) <=  p0_way_data_upd6_wayE   and p0_wren_q;
p0_way_data_upd6_wayF    <=  p0_congr_cl6_act_q   and binv_wayF_upd3_q;
p1_way_data_upd6_wayF    <=  p1_congr_cl6_act_q   and reload_wayF_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu6_wayF_upd(0) <=  p1_way_data_upd6_wayF   and p1_wren_q;
rel_bixu6_wayF_upd(1) <=  p0_way_data_upd6_wayF   and p0_wren_q;
p0_way_data_upd6_wayG    <=  p0_congr_cl6_act_q   and binv_wayG_upd3_q;
p1_way_data_upd6_wayG    <=  p1_congr_cl6_act_q   and reload_wayG_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu6_wayG_upd(0) <=  p1_way_data_upd6_wayG   and p1_wren_q;
rel_bixu6_wayG_upd(1) <=  p0_way_data_upd6_wayG   and p0_wren_q;
p0_way_data_upd6_wayH    <=  p0_congr_cl6_act_q   and binv_wayH_upd3_q;
p1_way_data_upd6_wayH    <=  p1_congr_cl6_act_q   and reload_wayH_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu6_wayH_upd(0) <=  p1_way_data_upd6_wayH   and p1_wren_q;
rel_bixu6_wayH_upd(1) <=  p0_way_data_upd6_wayH   and p0_wren_q;
-- Congruence Class Match
p0_congr_cl7_m        <=  (ex5_congr_cl_q    = tconv(7,6));
p1_congr_cl7_m        <=  (relu_s_congr_cl_q = tconv(7,6));
-- Act Pin to Directory Latches for specific congruence class
p0_congr_cl7_act_d    <=  p0_congr_cl7_m   and (back_inval_stg5_q or ex5_xuop_val_q or ex5_dir_err_val_q);
p1_congr_cl7_act_d    <=  p1_congr_cl7_m   and rel_port_wren_q;
congr_cl7_act         <=  p0_congr_cl7_act_q   or p1_congr_cl7_act_q   or congr_cl_all_act_q;
p0_way_data_upd7_wayA    <=  p0_congr_cl7_act_q   and binv_wayA_upd3_q;
p1_way_data_upd7_wayA    <=  p1_congr_cl7_act_q   and reload_wayA_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu7_wayA_upd(0) <=  p1_way_data_upd7_wayA   and p1_wren_q;
rel_bixu7_wayA_upd(1) <=  p0_way_data_upd7_wayA   and p0_wren_q;
p0_way_data_upd7_wayB    <=  p0_congr_cl7_act_q   and binv_wayB_upd3_q;
p1_way_data_upd7_wayB    <=  p1_congr_cl7_act_q   and reload_wayB_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu7_wayB_upd(0) <=  p1_way_data_upd7_wayB   and p1_wren_q;
rel_bixu7_wayB_upd(1) <=  p0_way_data_upd7_wayB   and p0_wren_q;
p0_way_data_upd7_wayC    <=  p0_congr_cl7_act_q   and binv_wayC_upd3_q;
p1_way_data_upd7_wayC    <=  p1_congr_cl7_act_q   and reload_wayC_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu7_wayC_upd(0) <=  p1_way_data_upd7_wayC   and p1_wren_q;
rel_bixu7_wayC_upd(1) <=  p0_way_data_upd7_wayC   and p0_wren_q;
p0_way_data_upd7_wayD    <=  p0_congr_cl7_act_q   and binv_wayD_upd3_q;
p1_way_data_upd7_wayD    <=  p1_congr_cl7_act_q   and reload_wayD_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu7_wayD_upd(0) <=  p1_way_data_upd7_wayD   and p1_wren_q;
rel_bixu7_wayD_upd(1) <=  p0_way_data_upd7_wayD   and p0_wren_q;
p0_way_data_upd7_wayE    <=  p0_congr_cl7_act_q   and binv_wayE_upd3_q;
p1_way_data_upd7_wayE    <=  p1_congr_cl7_act_q   and reload_wayE_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu7_wayE_upd(0) <=  p1_way_data_upd7_wayE   and p1_wren_q;
rel_bixu7_wayE_upd(1) <=  p0_way_data_upd7_wayE   and p0_wren_q;
p0_way_data_upd7_wayF    <=  p0_congr_cl7_act_q   and binv_wayF_upd3_q;
p1_way_data_upd7_wayF    <=  p1_congr_cl7_act_q   and reload_wayF_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu7_wayF_upd(0) <=  p1_way_data_upd7_wayF   and p1_wren_q;
rel_bixu7_wayF_upd(1) <=  p0_way_data_upd7_wayF   and p0_wren_q;
p0_way_data_upd7_wayG    <=  p0_congr_cl7_act_q   and binv_wayG_upd3_q;
p1_way_data_upd7_wayG    <=  p1_congr_cl7_act_q   and reload_wayG_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu7_wayG_upd(0) <=  p1_way_data_upd7_wayG   and p1_wren_q;
rel_bixu7_wayG_upd(1) <=  p0_way_data_upd7_wayG   and p0_wren_q;
p0_way_data_upd7_wayH    <=  p0_congr_cl7_act_q   and binv_wayH_upd3_q;
p1_way_data_upd7_wayH    <=  p1_congr_cl7_act_q   and reload_wayH_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu7_wayH_upd(0) <=  p1_way_data_upd7_wayH   and p1_wren_q;
rel_bixu7_wayH_upd(1) <=  p0_way_data_upd7_wayH   and p0_wren_q;
-- Congruence Class Match
p0_congr_cl8_m        <=  (ex5_congr_cl_q    = tconv(8,6));
p1_congr_cl8_m        <=  (relu_s_congr_cl_q = tconv(8,6));
-- Act Pin to Directory Latches for specific congruence class
p0_congr_cl8_act_d    <=  p0_congr_cl8_m   and (back_inval_stg5_q or ex5_xuop_val_q or ex5_dir_err_val_q);
p1_congr_cl8_act_d    <=  p1_congr_cl8_m   and rel_port_wren_q;
congr_cl8_act         <=  p0_congr_cl8_act_q   or p1_congr_cl8_act_q   or congr_cl_all_act_q;
p0_way_data_upd8_wayA    <=  p0_congr_cl8_act_q   and binv_wayA_upd3_q;
p1_way_data_upd8_wayA    <=  p1_congr_cl8_act_q   and reload_wayA_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu8_wayA_upd(0) <=  p1_way_data_upd8_wayA   and p1_wren_q;
rel_bixu8_wayA_upd(1) <=  p0_way_data_upd8_wayA   and p0_wren_q;
p0_way_data_upd8_wayB    <=  p0_congr_cl8_act_q   and binv_wayB_upd3_q;
p1_way_data_upd8_wayB    <=  p1_congr_cl8_act_q   and reload_wayB_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu8_wayB_upd(0) <=  p1_way_data_upd8_wayB   and p1_wren_q;
rel_bixu8_wayB_upd(1) <=  p0_way_data_upd8_wayB   and p0_wren_q;
p0_way_data_upd8_wayC    <=  p0_congr_cl8_act_q   and binv_wayC_upd3_q;
p1_way_data_upd8_wayC    <=  p1_congr_cl8_act_q   and reload_wayC_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu8_wayC_upd(0) <=  p1_way_data_upd8_wayC   and p1_wren_q;
rel_bixu8_wayC_upd(1) <=  p0_way_data_upd8_wayC   and p0_wren_q;
p0_way_data_upd8_wayD    <=  p0_congr_cl8_act_q   and binv_wayD_upd3_q;
p1_way_data_upd8_wayD    <=  p1_congr_cl8_act_q   and reload_wayD_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu8_wayD_upd(0) <=  p1_way_data_upd8_wayD   and p1_wren_q;
rel_bixu8_wayD_upd(1) <=  p0_way_data_upd8_wayD   and p0_wren_q;
p0_way_data_upd8_wayE    <=  p0_congr_cl8_act_q   and binv_wayE_upd3_q;
p1_way_data_upd8_wayE    <=  p1_congr_cl8_act_q   and reload_wayE_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu8_wayE_upd(0) <=  p1_way_data_upd8_wayE   and p1_wren_q;
rel_bixu8_wayE_upd(1) <=  p0_way_data_upd8_wayE   and p0_wren_q;
p0_way_data_upd8_wayF    <=  p0_congr_cl8_act_q   and binv_wayF_upd3_q;
p1_way_data_upd8_wayF    <=  p1_congr_cl8_act_q   and reload_wayF_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu8_wayF_upd(0) <=  p1_way_data_upd8_wayF   and p1_wren_q;
rel_bixu8_wayF_upd(1) <=  p0_way_data_upd8_wayF   and p0_wren_q;
p0_way_data_upd8_wayG    <=  p0_congr_cl8_act_q   and binv_wayG_upd3_q;
p1_way_data_upd8_wayG    <=  p1_congr_cl8_act_q   and reload_wayG_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu8_wayG_upd(0) <=  p1_way_data_upd8_wayG   and p1_wren_q;
rel_bixu8_wayG_upd(1) <=  p0_way_data_upd8_wayG   and p0_wren_q;
p0_way_data_upd8_wayH    <=  p0_congr_cl8_act_q   and binv_wayH_upd3_q;
p1_way_data_upd8_wayH    <=  p1_congr_cl8_act_q   and reload_wayH_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu8_wayH_upd(0) <=  p1_way_data_upd8_wayH   and p1_wren_q;
rel_bixu8_wayH_upd(1) <=  p0_way_data_upd8_wayH   and p0_wren_q;
-- Congruence Class Match
p0_congr_cl9_m        <=  (ex5_congr_cl_q    = tconv(9,6));
p1_congr_cl9_m        <=  (relu_s_congr_cl_q = tconv(9,6));
-- Act Pin to Directory Latches for specific congruence class
p0_congr_cl9_act_d    <=  p0_congr_cl9_m   and (back_inval_stg5_q or ex5_xuop_val_q or ex5_dir_err_val_q);
p1_congr_cl9_act_d    <=  p1_congr_cl9_m   and rel_port_wren_q;
congr_cl9_act         <=  p0_congr_cl9_act_q   or p1_congr_cl9_act_q   or congr_cl_all_act_q;
p0_way_data_upd9_wayA    <=  p0_congr_cl9_act_q   and binv_wayA_upd3_q;
p1_way_data_upd9_wayA    <=  p1_congr_cl9_act_q   and reload_wayA_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu9_wayA_upd(0) <=  p1_way_data_upd9_wayA   and p1_wren_q;
rel_bixu9_wayA_upd(1) <=  p0_way_data_upd9_wayA   and p0_wren_q;
p0_way_data_upd9_wayB    <=  p0_congr_cl9_act_q   and binv_wayB_upd3_q;
p1_way_data_upd9_wayB    <=  p1_congr_cl9_act_q   and reload_wayB_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu9_wayB_upd(0) <=  p1_way_data_upd9_wayB   and p1_wren_q;
rel_bixu9_wayB_upd(1) <=  p0_way_data_upd9_wayB   and p0_wren_q;
p0_way_data_upd9_wayC    <=  p0_congr_cl9_act_q   and binv_wayC_upd3_q;
p1_way_data_upd9_wayC    <=  p1_congr_cl9_act_q   and reload_wayC_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu9_wayC_upd(0) <=  p1_way_data_upd9_wayC   and p1_wren_q;
rel_bixu9_wayC_upd(1) <=  p0_way_data_upd9_wayC   and p0_wren_q;
p0_way_data_upd9_wayD    <=  p0_congr_cl9_act_q   and binv_wayD_upd3_q;
p1_way_data_upd9_wayD    <=  p1_congr_cl9_act_q   and reload_wayD_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu9_wayD_upd(0) <=  p1_way_data_upd9_wayD   and p1_wren_q;
rel_bixu9_wayD_upd(1) <=  p0_way_data_upd9_wayD   and p0_wren_q;
p0_way_data_upd9_wayE    <=  p0_congr_cl9_act_q   and binv_wayE_upd3_q;
p1_way_data_upd9_wayE    <=  p1_congr_cl9_act_q   and reload_wayE_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu9_wayE_upd(0) <=  p1_way_data_upd9_wayE   and p1_wren_q;
rel_bixu9_wayE_upd(1) <=  p0_way_data_upd9_wayE   and p0_wren_q;
p0_way_data_upd9_wayF    <=  p0_congr_cl9_act_q   and binv_wayF_upd3_q;
p1_way_data_upd9_wayF    <=  p1_congr_cl9_act_q   and reload_wayF_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu9_wayF_upd(0) <=  p1_way_data_upd9_wayF   and p1_wren_q;
rel_bixu9_wayF_upd(1) <=  p0_way_data_upd9_wayF   and p0_wren_q;
p0_way_data_upd9_wayG    <=  p0_congr_cl9_act_q   and binv_wayG_upd3_q;
p1_way_data_upd9_wayG    <=  p1_congr_cl9_act_q   and reload_wayG_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu9_wayG_upd(0) <=  p1_way_data_upd9_wayG   and p1_wren_q;
rel_bixu9_wayG_upd(1) <=  p0_way_data_upd9_wayG   and p0_wren_q;
p0_way_data_upd9_wayH    <=  p0_congr_cl9_act_q   and binv_wayH_upd3_q;
p1_way_data_upd9_wayH    <=  p1_congr_cl9_act_q   and reload_wayH_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu9_wayH_upd(0) <=  p1_way_data_upd9_wayH   and p1_wren_q;
rel_bixu9_wayH_upd(1) <=  p0_way_data_upd9_wayH   and p0_wren_q;
-- Congruence Class Match
p0_congr_cl10_m       <=  (ex5_congr_cl_q    = tconv(10,6));
p1_congr_cl10_m       <=  (relu_s_congr_cl_q = tconv(10,6));
-- Act Pin to Directory Latches for specific congruence class
p0_congr_cl10_act_d   <=  p0_congr_cl10_m  and (back_inval_stg5_q or ex5_xuop_val_q or ex5_dir_err_val_q);
p1_congr_cl10_act_d   <=  p1_congr_cl10_m  and rel_port_wren_q;
congr_cl10_act        <=  p0_congr_cl10_act_q  or p1_congr_cl10_act_q  or congr_cl_all_act_q;
p0_way_data_upd10_wayA    <=  p0_congr_cl10_act_q  and binv_wayA_upd3_q;
p1_way_data_upd10_wayA    <=  p1_congr_cl10_act_q  and reload_wayA_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu10_wayA_upd(0) <=  p1_way_data_upd10_wayA   and p1_wren_q;
rel_bixu10_wayA_upd(1) <=  p0_way_data_upd10_wayA   and p0_wren_q;
p0_way_data_upd10_wayB    <=  p0_congr_cl10_act_q  and binv_wayB_upd3_q;
p1_way_data_upd10_wayB    <=  p1_congr_cl10_act_q  and reload_wayB_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu10_wayB_upd(0) <=  p1_way_data_upd10_wayB   and p1_wren_q;
rel_bixu10_wayB_upd(1) <=  p0_way_data_upd10_wayB   and p0_wren_q;
p0_way_data_upd10_wayC    <=  p0_congr_cl10_act_q  and binv_wayC_upd3_q;
p1_way_data_upd10_wayC    <=  p1_congr_cl10_act_q  and reload_wayC_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu10_wayC_upd(0) <=  p1_way_data_upd10_wayC   and p1_wren_q;
rel_bixu10_wayC_upd(1) <=  p0_way_data_upd10_wayC   and p0_wren_q;
p0_way_data_upd10_wayD    <=  p0_congr_cl10_act_q  and binv_wayD_upd3_q;
p1_way_data_upd10_wayD    <=  p1_congr_cl10_act_q  and reload_wayD_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu10_wayD_upd(0) <=  p1_way_data_upd10_wayD   and p1_wren_q;
rel_bixu10_wayD_upd(1) <=  p0_way_data_upd10_wayD   and p0_wren_q;
p0_way_data_upd10_wayE    <=  p0_congr_cl10_act_q  and binv_wayE_upd3_q;
p1_way_data_upd10_wayE    <=  p1_congr_cl10_act_q  and reload_wayE_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu10_wayE_upd(0) <=  p1_way_data_upd10_wayE   and p1_wren_q;
rel_bixu10_wayE_upd(1) <=  p0_way_data_upd10_wayE   and p0_wren_q;
p0_way_data_upd10_wayF    <=  p0_congr_cl10_act_q  and binv_wayF_upd3_q;
p1_way_data_upd10_wayF    <=  p1_congr_cl10_act_q  and reload_wayF_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu10_wayF_upd(0) <=  p1_way_data_upd10_wayF   and p1_wren_q;
rel_bixu10_wayF_upd(1) <=  p0_way_data_upd10_wayF   and p0_wren_q;
p0_way_data_upd10_wayG    <=  p0_congr_cl10_act_q  and binv_wayG_upd3_q;
p1_way_data_upd10_wayG    <=  p1_congr_cl10_act_q  and reload_wayG_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu10_wayG_upd(0) <=  p1_way_data_upd10_wayG   and p1_wren_q;
rel_bixu10_wayG_upd(1) <=  p0_way_data_upd10_wayG   and p0_wren_q;
p0_way_data_upd10_wayH    <=  p0_congr_cl10_act_q  and binv_wayH_upd3_q;
p1_way_data_upd10_wayH    <=  p1_congr_cl10_act_q  and reload_wayH_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu10_wayH_upd(0) <=  p1_way_data_upd10_wayH   and p1_wren_q;
rel_bixu10_wayH_upd(1) <=  p0_way_data_upd10_wayH   and p0_wren_q;
-- Congruence Class Match
p0_congr_cl11_m       <=  (ex5_congr_cl_q    = tconv(11,6));
p1_congr_cl11_m       <=  (relu_s_congr_cl_q = tconv(11,6));
-- Act Pin to Directory Latches for specific congruence class
p0_congr_cl11_act_d   <=  p0_congr_cl11_m  and (back_inval_stg5_q or ex5_xuop_val_q or ex5_dir_err_val_q);
p1_congr_cl11_act_d   <=  p1_congr_cl11_m  and rel_port_wren_q;
congr_cl11_act        <=  p0_congr_cl11_act_q  or p1_congr_cl11_act_q  or congr_cl_all_act_q;
p0_way_data_upd11_wayA    <=  p0_congr_cl11_act_q  and binv_wayA_upd3_q;
p1_way_data_upd11_wayA    <=  p1_congr_cl11_act_q  and reload_wayA_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu11_wayA_upd(0) <=  p1_way_data_upd11_wayA   and p1_wren_q;
rel_bixu11_wayA_upd(1) <=  p0_way_data_upd11_wayA   and p0_wren_q;
p0_way_data_upd11_wayB    <=  p0_congr_cl11_act_q  and binv_wayB_upd3_q;
p1_way_data_upd11_wayB    <=  p1_congr_cl11_act_q  and reload_wayB_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu11_wayB_upd(0) <=  p1_way_data_upd11_wayB   and p1_wren_q;
rel_bixu11_wayB_upd(1) <=  p0_way_data_upd11_wayB   and p0_wren_q;
p0_way_data_upd11_wayC    <=  p0_congr_cl11_act_q  and binv_wayC_upd3_q;
p1_way_data_upd11_wayC    <=  p1_congr_cl11_act_q  and reload_wayC_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu11_wayC_upd(0) <=  p1_way_data_upd11_wayC   and p1_wren_q;
rel_bixu11_wayC_upd(1) <=  p0_way_data_upd11_wayC   and p0_wren_q;
p0_way_data_upd11_wayD    <=  p0_congr_cl11_act_q  and binv_wayD_upd3_q;
p1_way_data_upd11_wayD    <=  p1_congr_cl11_act_q  and reload_wayD_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu11_wayD_upd(0) <=  p1_way_data_upd11_wayD   and p1_wren_q;
rel_bixu11_wayD_upd(1) <=  p0_way_data_upd11_wayD   and p0_wren_q;
p0_way_data_upd11_wayE    <=  p0_congr_cl11_act_q  and binv_wayE_upd3_q;
p1_way_data_upd11_wayE    <=  p1_congr_cl11_act_q  and reload_wayE_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu11_wayE_upd(0) <=  p1_way_data_upd11_wayE   and p1_wren_q;
rel_bixu11_wayE_upd(1) <=  p0_way_data_upd11_wayE   and p0_wren_q;
p0_way_data_upd11_wayF    <=  p0_congr_cl11_act_q  and binv_wayF_upd3_q;
p1_way_data_upd11_wayF    <=  p1_congr_cl11_act_q  and reload_wayF_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu11_wayF_upd(0) <=  p1_way_data_upd11_wayF   and p1_wren_q;
rel_bixu11_wayF_upd(1) <=  p0_way_data_upd11_wayF   and p0_wren_q;
p0_way_data_upd11_wayG    <=  p0_congr_cl11_act_q  and binv_wayG_upd3_q;
p1_way_data_upd11_wayG    <=  p1_congr_cl11_act_q  and reload_wayG_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu11_wayG_upd(0) <=  p1_way_data_upd11_wayG   and p1_wren_q;
rel_bixu11_wayG_upd(1) <=  p0_way_data_upd11_wayG   and p0_wren_q;
p0_way_data_upd11_wayH    <=  p0_congr_cl11_act_q  and binv_wayH_upd3_q;
p1_way_data_upd11_wayH    <=  p1_congr_cl11_act_q  and reload_wayH_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu11_wayH_upd(0) <=  p1_way_data_upd11_wayH   and p1_wren_q;
rel_bixu11_wayH_upd(1) <=  p0_way_data_upd11_wayH   and p0_wren_q;
-- Congruence Class Match
p0_congr_cl12_m       <=  (ex5_congr_cl_q    = tconv(12,6));
p1_congr_cl12_m       <=  (relu_s_congr_cl_q = tconv(12,6));
-- Act Pin to Directory Latches for specific congruence class
p0_congr_cl12_act_d   <=  p0_congr_cl12_m  and (back_inval_stg5_q or ex5_xuop_val_q or ex5_dir_err_val_q);
p1_congr_cl12_act_d   <=  p1_congr_cl12_m  and rel_port_wren_q;
congr_cl12_act        <=  p0_congr_cl12_act_q  or p1_congr_cl12_act_q  or congr_cl_all_act_q;
p0_way_data_upd12_wayA    <=  p0_congr_cl12_act_q  and binv_wayA_upd3_q;
p1_way_data_upd12_wayA    <=  p1_congr_cl12_act_q  and reload_wayA_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu12_wayA_upd(0) <=  p1_way_data_upd12_wayA   and p1_wren_q;
rel_bixu12_wayA_upd(1) <=  p0_way_data_upd12_wayA   and p0_wren_q;
p0_way_data_upd12_wayB    <=  p0_congr_cl12_act_q  and binv_wayB_upd3_q;
p1_way_data_upd12_wayB    <=  p1_congr_cl12_act_q  and reload_wayB_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu12_wayB_upd(0) <=  p1_way_data_upd12_wayB   and p1_wren_q;
rel_bixu12_wayB_upd(1) <=  p0_way_data_upd12_wayB   and p0_wren_q;
p0_way_data_upd12_wayC    <=  p0_congr_cl12_act_q  and binv_wayC_upd3_q;
p1_way_data_upd12_wayC    <=  p1_congr_cl12_act_q  and reload_wayC_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu12_wayC_upd(0) <=  p1_way_data_upd12_wayC   and p1_wren_q;
rel_bixu12_wayC_upd(1) <=  p0_way_data_upd12_wayC   and p0_wren_q;
p0_way_data_upd12_wayD    <=  p0_congr_cl12_act_q  and binv_wayD_upd3_q;
p1_way_data_upd12_wayD    <=  p1_congr_cl12_act_q  and reload_wayD_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu12_wayD_upd(0) <=  p1_way_data_upd12_wayD   and p1_wren_q;
rel_bixu12_wayD_upd(1) <=  p0_way_data_upd12_wayD   and p0_wren_q;
p0_way_data_upd12_wayE    <=  p0_congr_cl12_act_q  and binv_wayE_upd3_q;
p1_way_data_upd12_wayE    <=  p1_congr_cl12_act_q  and reload_wayE_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu12_wayE_upd(0) <=  p1_way_data_upd12_wayE   and p1_wren_q;
rel_bixu12_wayE_upd(1) <=  p0_way_data_upd12_wayE   and p0_wren_q;
p0_way_data_upd12_wayF    <=  p0_congr_cl12_act_q  and binv_wayF_upd3_q;
p1_way_data_upd12_wayF    <=  p1_congr_cl12_act_q  and reload_wayF_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu12_wayF_upd(0) <=  p1_way_data_upd12_wayF   and p1_wren_q;
rel_bixu12_wayF_upd(1) <=  p0_way_data_upd12_wayF   and p0_wren_q;
p0_way_data_upd12_wayG    <=  p0_congr_cl12_act_q  and binv_wayG_upd3_q;
p1_way_data_upd12_wayG    <=  p1_congr_cl12_act_q  and reload_wayG_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu12_wayG_upd(0) <=  p1_way_data_upd12_wayG   and p1_wren_q;
rel_bixu12_wayG_upd(1) <=  p0_way_data_upd12_wayG   and p0_wren_q;
p0_way_data_upd12_wayH    <=  p0_congr_cl12_act_q  and binv_wayH_upd3_q;
p1_way_data_upd12_wayH    <=  p1_congr_cl12_act_q  and reload_wayH_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu12_wayH_upd(0) <=  p1_way_data_upd12_wayH   and p1_wren_q;
rel_bixu12_wayH_upd(1) <=  p0_way_data_upd12_wayH   and p0_wren_q;
-- Congruence Class Match
p0_congr_cl13_m       <=  (ex5_congr_cl_q    = tconv(13,6));
p1_congr_cl13_m       <=  (relu_s_congr_cl_q = tconv(13,6));
-- Act Pin to Directory Latches for specific congruence class
p0_congr_cl13_act_d   <=  p0_congr_cl13_m  and (back_inval_stg5_q or ex5_xuop_val_q or ex5_dir_err_val_q);
p1_congr_cl13_act_d   <=  p1_congr_cl13_m  and rel_port_wren_q;
congr_cl13_act        <=  p0_congr_cl13_act_q  or p1_congr_cl13_act_q  or congr_cl_all_act_q;
p0_way_data_upd13_wayA    <=  p0_congr_cl13_act_q  and binv_wayA_upd3_q;
p1_way_data_upd13_wayA    <=  p1_congr_cl13_act_q  and reload_wayA_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu13_wayA_upd(0) <=  p1_way_data_upd13_wayA   and p1_wren_q;
rel_bixu13_wayA_upd(1) <=  p0_way_data_upd13_wayA   and p0_wren_q;
p0_way_data_upd13_wayB    <=  p0_congr_cl13_act_q  and binv_wayB_upd3_q;
p1_way_data_upd13_wayB    <=  p1_congr_cl13_act_q  and reload_wayB_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu13_wayB_upd(0) <=  p1_way_data_upd13_wayB   and p1_wren_q;
rel_bixu13_wayB_upd(1) <=  p0_way_data_upd13_wayB   and p0_wren_q;
p0_way_data_upd13_wayC    <=  p0_congr_cl13_act_q  and binv_wayC_upd3_q;
p1_way_data_upd13_wayC    <=  p1_congr_cl13_act_q  and reload_wayC_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu13_wayC_upd(0) <=  p1_way_data_upd13_wayC   and p1_wren_q;
rel_bixu13_wayC_upd(1) <=  p0_way_data_upd13_wayC   and p0_wren_q;
p0_way_data_upd13_wayD    <=  p0_congr_cl13_act_q  and binv_wayD_upd3_q;
p1_way_data_upd13_wayD    <=  p1_congr_cl13_act_q  and reload_wayD_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu13_wayD_upd(0) <=  p1_way_data_upd13_wayD   and p1_wren_q;
rel_bixu13_wayD_upd(1) <=  p0_way_data_upd13_wayD   and p0_wren_q;
p0_way_data_upd13_wayE    <=  p0_congr_cl13_act_q  and binv_wayE_upd3_q;
p1_way_data_upd13_wayE    <=  p1_congr_cl13_act_q  and reload_wayE_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu13_wayE_upd(0) <=  p1_way_data_upd13_wayE   and p1_wren_q;
rel_bixu13_wayE_upd(1) <=  p0_way_data_upd13_wayE   and p0_wren_q;
p0_way_data_upd13_wayF    <=  p0_congr_cl13_act_q  and binv_wayF_upd3_q;
p1_way_data_upd13_wayF    <=  p1_congr_cl13_act_q  and reload_wayF_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu13_wayF_upd(0) <=  p1_way_data_upd13_wayF   and p1_wren_q;
rel_bixu13_wayF_upd(1) <=  p0_way_data_upd13_wayF   and p0_wren_q;
p0_way_data_upd13_wayG    <=  p0_congr_cl13_act_q  and binv_wayG_upd3_q;
p1_way_data_upd13_wayG    <=  p1_congr_cl13_act_q  and reload_wayG_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu13_wayG_upd(0) <=  p1_way_data_upd13_wayG   and p1_wren_q;
rel_bixu13_wayG_upd(1) <=  p0_way_data_upd13_wayG   and p0_wren_q;
p0_way_data_upd13_wayH    <=  p0_congr_cl13_act_q  and binv_wayH_upd3_q;
p1_way_data_upd13_wayH    <=  p1_congr_cl13_act_q  and reload_wayH_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu13_wayH_upd(0) <=  p1_way_data_upd13_wayH   and p1_wren_q;
rel_bixu13_wayH_upd(1) <=  p0_way_data_upd13_wayH   and p0_wren_q;
-- Congruence Class Match
p0_congr_cl14_m       <=  (ex5_congr_cl_q    = tconv(14,6));
p1_congr_cl14_m       <=  (relu_s_congr_cl_q = tconv(14,6));
-- Act Pin to Directory Latches for specific congruence class
p0_congr_cl14_act_d   <=  p0_congr_cl14_m  and (back_inval_stg5_q or ex5_xuop_val_q or ex5_dir_err_val_q);
p1_congr_cl14_act_d   <=  p1_congr_cl14_m  and rel_port_wren_q;
congr_cl14_act        <=  p0_congr_cl14_act_q  or p1_congr_cl14_act_q  or congr_cl_all_act_q;
p0_way_data_upd14_wayA    <=  p0_congr_cl14_act_q  and binv_wayA_upd3_q;
p1_way_data_upd14_wayA    <=  p1_congr_cl14_act_q  and reload_wayA_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu14_wayA_upd(0) <=  p1_way_data_upd14_wayA   and p1_wren_q;
rel_bixu14_wayA_upd(1) <=  p0_way_data_upd14_wayA   and p0_wren_q;
p0_way_data_upd14_wayB    <=  p0_congr_cl14_act_q  and binv_wayB_upd3_q;
p1_way_data_upd14_wayB    <=  p1_congr_cl14_act_q  and reload_wayB_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu14_wayB_upd(0) <=  p1_way_data_upd14_wayB   and p1_wren_q;
rel_bixu14_wayB_upd(1) <=  p0_way_data_upd14_wayB   and p0_wren_q;
p0_way_data_upd14_wayC    <=  p0_congr_cl14_act_q  and binv_wayC_upd3_q;
p1_way_data_upd14_wayC    <=  p1_congr_cl14_act_q  and reload_wayC_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu14_wayC_upd(0) <=  p1_way_data_upd14_wayC   and p1_wren_q;
rel_bixu14_wayC_upd(1) <=  p0_way_data_upd14_wayC   and p0_wren_q;
p0_way_data_upd14_wayD    <=  p0_congr_cl14_act_q  and binv_wayD_upd3_q;
p1_way_data_upd14_wayD    <=  p1_congr_cl14_act_q  and reload_wayD_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu14_wayD_upd(0) <=  p1_way_data_upd14_wayD   and p1_wren_q;
rel_bixu14_wayD_upd(1) <=  p0_way_data_upd14_wayD   and p0_wren_q;
p0_way_data_upd14_wayE    <=  p0_congr_cl14_act_q  and binv_wayE_upd3_q;
p1_way_data_upd14_wayE    <=  p1_congr_cl14_act_q  and reload_wayE_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu14_wayE_upd(0) <=  p1_way_data_upd14_wayE   and p1_wren_q;
rel_bixu14_wayE_upd(1) <=  p0_way_data_upd14_wayE   and p0_wren_q;
p0_way_data_upd14_wayF    <=  p0_congr_cl14_act_q  and binv_wayF_upd3_q;
p1_way_data_upd14_wayF    <=  p1_congr_cl14_act_q  and reload_wayF_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu14_wayF_upd(0) <=  p1_way_data_upd14_wayF   and p1_wren_q;
rel_bixu14_wayF_upd(1) <=  p0_way_data_upd14_wayF   and p0_wren_q;
p0_way_data_upd14_wayG    <=  p0_congr_cl14_act_q  and binv_wayG_upd3_q;
p1_way_data_upd14_wayG    <=  p1_congr_cl14_act_q  and reload_wayG_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu14_wayG_upd(0) <=  p1_way_data_upd14_wayG   and p1_wren_q;
rel_bixu14_wayG_upd(1) <=  p0_way_data_upd14_wayG   and p0_wren_q;
p0_way_data_upd14_wayH    <=  p0_congr_cl14_act_q  and binv_wayH_upd3_q;
p1_way_data_upd14_wayH    <=  p1_congr_cl14_act_q  and reload_wayH_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu14_wayH_upd(0) <=  p1_way_data_upd14_wayH   and p1_wren_q;
rel_bixu14_wayH_upd(1) <=  p0_way_data_upd14_wayH   and p0_wren_q;
-- Congruence Class Match
p0_congr_cl15_m       <=  (ex5_congr_cl_q    = tconv(15,6));
p1_congr_cl15_m       <=  (relu_s_congr_cl_q = tconv(15,6));
-- Act Pin to Directory Latches for specific congruence class
p0_congr_cl15_act_d   <=  p0_congr_cl15_m  and (back_inval_stg5_q or ex5_xuop_val_q or ex5_dir_err_val_q);
p1_congr_cl15_act_d   <=  p1_congr_cl15_m  and rel_port_wren_q;
congr_cl15_act        <=  p0_congr_cl15_act_q  or p1_congr_cl15_act_q  or congr_cl_all_act_q;
p0_way_data_upd15_wayA    <=  p0_congr_cl15_act_q  and binv_wayA_upd3_q;
p1_way_data_upd15_wayA    <=  p1_congr_cl15_act_q  and reload_wayA_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu15_wayA_upd(0) <=  p1_way_data_upd15_wayA   and p1_wren_q;
rel_bixu15_wayA_upd(1) <=  p0_way_data_upd15_wayA   and p0_wren_q;
p0_way_data_upd15_wayB    <=  p0_congr_cl15_act_q  and binv_wayB_upd3_q;
p1_way_data_upd15_wayB    <=  p1_congr_cl15_act_q  and reload_wayB_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu15_wayB_upd(0) <=  p1_way_data_upd15_wayB   and p1_wren_q;
rel_bixu15_wayB_upd(1) <=  p0_way_data_upd15_wayB   and p0_wren_q;
p0_way_data_upd15_wayC    <=  p0_congr_cl15_act_q  and binv_wayC_upd3_q;
p1_way_data_upd15_wayC    <=  p1_congr_cl15_act_q  and reload_wayC_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu15_wayC_upd(0) <=  p1_way_data_upd15_wayC   and p1_wren_q;
rel_bixu15_wayC_upd(1) <=  p0_way_data_upd15_wayC   and p0_wren_q;
p0_way_data_upd15_wayD    <=  p0_congr_cl15_act_q  and binv_wayD_upd3_q;
p1_way_data_upd15_wayD    <=  p1_congr_cl15_act_q  and reload_wayD_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu15_wayD_upd(0) <=  p1_way_data_upd15_wayD   and p1_wren_q;
rel_bixu15_wayD_upd(1) <=  p0_way_data_upd15_wayD   and p0_wren_q;
p0_way_data_upd15_wayE    <=  p0_congr_cl15_act_q  and binv_wayE_upd3_q;
p1_way_data_upd15_wayE    <=  p1_congr_cl15_act_q  and reload_wayE_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu15_wayE_upd(0) <=  p1_way_data_upd15_wayE   and p1_wren_q;
rel_bixu15_wayE_upd(1) <=  p0_way_data_upd15_wayE   and p0_wren_q;
p0_way_data_upd15_wayF    <=  p0_congr_cl15_act_q  and binv_wayF_upd3_q;
p1_way_data_upd15_wayF    <=  p1_congr_cl15_act_q  and reload_wayF_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu15_wayF_upd(0) <=  p1_way_data_upd15_wayF   and p1_wren_q;
rel_bixu15_wayF_upd(1) <=  p0_way_data_upd15_wayF   and p0_wren_q;
p0_way_data_upd15_wayG    <=  p0_congr_cl15_act_q  and binv_wayG_upd3_q;
p1_way_data_upd15_wayG    <=  p1_congr_cl15_act_q  and reload_wayG_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu15_wayG_upd(0) <=  p1_way_data_upd15_wayG   and p1_wren_q;
rel_bixu15_wayG_upd(1) <=  p0_way_data_upd15_wayG   and p0_wren_q;
p0_way_data_upd15_wayH    <=  p0_congr_cl15_act_q  and binv_wayH_upd3_q;
p1_way_data_upd15_wayH    <=  p1_congr_cl15_act_q  and reload_wayH_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu15_wayH_upd(0) <=  p1_way_data_upd15_wayH   and p1_wren_q;
rel_bixu15_wayH_upd(1) <=  p0_way_data_upd15_wayH   and p0_wren_q;
-- Congruence Class Match
p0_congr_cl16_m       <=  (ex5_congr_cl_q    = tconv(16,6));
p1_congr_cl16_m       <=  (relu_s_congr_cl_q = tconv(16,6));
-- Act Pin to Directory Latches for specific congruence class
p0_congr_cl16_act_d   <=  p0_congr_cl16_m  and (back_inval_stg5_q or ex5_xuop_val_q or ex5_dir_err_val_q);
p1_congr_cl16_act_d   <=  p1_congr_cl16_m  and rel_port_wren_q;
congr_cl16_act        <=  p0_congr_cl16_act_q  or p1_congr_cl16_act_q  or congr_cl_all_act_q;
p0_way_data_upd16_wayA    <=  p0_congr_cl16_act_q  and binv_wayA_upd3_q;
p1_way_data_upd16_wayA    <=  p1_congr_cl16_act_q  and reload_wayA_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu16_wayA_upd(0) <=  p1_way_data_upd16_wayA   and p1_wren_q;
rel_bixu16_wayA_upd(1) <=  p0_way_data_upd16_wayA   and p0_wren_q;
p0_way_data_upd16_wayB    <=  p0_congr_cl16_act_q  and binv_wayB_upd3_q;
p1_way_data_upd16_wayB    <=  p1_congr_cl16_act_q  and reload_wayB_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu16_wayB_upd(0) <=  p1_way_data_upd16_wayB   and p1_wren_q;
rel_bixu16_wayB_upd(1) <=  p0_way_data_upd16_wayB   and p0_wren_q;
p0_way_data_upd16_wayC    <=  p0_congr_cl16_act_q  and binv_wayC_upd3_q;
p1_way_data_upd16_wayC    <=  p1_congr_cl16_act_q  and reload_wayC_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu16_wayC_upd(0) <=  p1_way_data_upd16_wayC   and p1_wren_q;
rel_bixu16_wayC_upd(1) <=  p0_way_data_upd16_wayC   and p0_wren_q;
p0_way_data_upd16_wayD    <=  p0_congr_cl16_act_q  and binv_wayD_upd3_q;
p1_way_data_upd16_wayD    <=  p1_congr_cl16_act_q  and reload_wayD_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu16_wayD_upd(0) <=  p1_way_data_upd16_wayD   and p1_wren_q;
rel_bixu16_wayD_upd(1) <=  p0_way_data_upd16_wayD   and p0_wren_q;
p0_way_data_upd16_wayE    <=  p0_congr_cl16_act_q  and binv_wayE_upd3_q;
p1_way_data_upd16_wayE    <=  p1_congr_cl16_act_q  and reload_wayE_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu16_wayE_upd(0) <=  p1_way_data_upd16_wayE   and p1_wren_q;
rel_bixu16_wayE_upd(1) <=  p0_way_data_upd16_wayE   and p0_wren_q;
p0_way_data_upd16_wayF    <=  p0_congr_cl16_act_q  and binv_wayF_upd3_q;
p1_way_data_upd16_wayF    <=  p1_congr_cl16_act_q  and reload_wayF_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu16_wayF_upd(0) <=  p1_way_data_upd16_wayF   and p1_wren_q;
rel_bixu16_wayF_upd(1) <=  p0_way_data_upd16_wayF   and p0_wren_q;
p0_way_data_upd16_wayG    <=  p0_congr_cl16_act_q  and binv_wayG_upd3_q;
p1_way_data_upd16_wayG    <=  p1_congr_cl16_act_q  and reload_wayG_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu16_wayG_upd(0) <=  p1_way_data_upd16_wayG   and p1_wren_q;
rel_bixu16_wayG_upd(1) <=  p0_way_data_upd16_wayG   and p0_wren_q;
p0_way_data_upd16_wayH    <=  p0_congr_cl16_act_q  and binv_wayH_upd3_q;
p1_way_data_upd16_wayH    <=  p1_congr_cl16_act_q  and reload_wayH_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu16_wayH_upd(0) <=  p1_way_data_upd16_wayH   and p1_wren_q;
rel_bixu16_wayH_upd(1) <=  p0_way_data_upd16_wayH   and p0_wren_q;
-- Congruence Class Match
p0_congr_cl17_m       <=  (ex5_congr_cl_q    = tconv(17,6));
p1_congr_cl17_m       <=  (relu_s_congr_cl_q = tconv(17,6));
-- Act Pin to Directory Latches for specific congruence class
p0_congr_cl17_act_d   <=  p0_congr_cl17_m  and (back_inval_stg5_q or ex5_xuop_val_q or ex5_dir_err_val_q);
p1_congr_cl17_act_d   <=  p1_congr_cl17_m  and rel_port_wren_q;
congr_cl17_act        <=  p0_congr_cl17_act_q  or p1_congr_cl17_act_q  or congr_cl_all_act_q;
p0_way_data_upd17_wayA    <=  p0_congr_cl17_act_q  and binv_wayA_upd3_q;
p1_way_data_upd17_wayA    <=  p1_congr_cl17_act_q  and reload_wayA_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu17_wayA_upd(0) <=  p1_way_data_upd17_wayA   and p1_wren_q;
rel_bixu17_wayA_upd(1) <=  p0_way_data_upd17_wayA   and p0_wren_q;
p0_way_data_upd17_wayB    <=  p0_congr_cl17_act_q  and binv_wayB_upd3_q;
p1_way_data_upd17_wayB    <=  p1_congr_cl17_act_q  and reload_wayB_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu17_wayB_upd(0) <=  p1_way_data_upd17_wayB   and p1_wren_q;
rel_bixu17_wayB_upd(1) <=  p0_way_data_upd17_wayB   and p0_wren_q;
p0_way_data_upd17_wayC    <=  p0_congr_cl17_act_q  and binv_wayC_upd3_q;
p1_way_data_upd17_wayC    <=  p1_congr_cl17_act_q  and reload_wayC_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu17_wayC_upd(0) <=  p1_way_data_upd17_wayC   and p1_wren_q;
rel_bixu17_wayC_upd(1) <=  p0_way_data_upd17_wayC   and p0_wren_q;
p0_way_data_upd17_wayD    <=  p0_congr_cl17_act_q  and binv_wayD_upd3_q;
p1_way_data_upd17_wayD    <=  p1_congr_cl17_act_q  and reload_wayD_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu17_wayD_upd(0) <=  p1_way_data_upd17_wayD   and p1_wren_q;
rel_bixu17_wayD_upd(1) <=  p0_way_data_upd17_wayD   and p0_wren_q;
p0_way_data_upd17_wayE    <=  p0_congr_cl17_act_q  and binv_wayE_upd3_q;
p1_way_data_upd17_wayE    <=  p1_congr_cl17_act_q  and reload_wayE_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu17_wayE_upd(0) <=  p1_way_data_upd17_wayE   and p1_wren_q;
rel_bixu17_wayE_upd(1) <=  p0_way_data_upd17_wayE   and p0_wren_q;
p0_way_data_upd17_wayF    <=  p0_congr_cl17_act_q  and binv_wayF_upd3_q;
p1_way_data_upd17_wayF    <=  p1_congr_cl17_act_q  and reload_wayF_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu17_wayF_upd(0) <=  p1_way_data_upd17_wayF   and p1_wren_q;
rel_bixu17_wayF_upd(1) <=  p0_way_data_upd17_wayF   and p0_wren_q;
p0_way_data_upd17_wayG    <=  p0_congr_cl17_act_q  and binv_wayG_upd3_q;
p1_way_data_upd17_wayG    <=  p1_congr_cl17_act_q  and reload_wayG_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu17_wayG_upd(0) <=  p1_way_data_upd17_wayG   and p1_wren_q;
rel_bixu17_wayG_upd(1) <=  p0_way_data_upd17_wayG   and p0_wren_q;
p0_way_data_upd17_wayH    <=  p0_congr_cl17_act_q  and binv_wayH_upd3_q;
p1_way_data_upd17_wayH    <=  p1_congr_cl17_act_q  and reload_wayH_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu17_wayH_upd(0) <=  p1_way_data_upd17_wayH   and p1_wren_q;
rel_bixu17_wayH_upd(1) <=  p0_way_data_upd17_wayH   and p0_wren_q;
-- Congruence Class Match
p0_congr_cl18_m       <=  (ex5_congr_cl_q    = tconv(18,6));
p1_congr_cl18_m       <=  (relu_s_congr_cl_q = tconv(18,6));
-- Act Pin to Directory Latches for specific congruence class
p0_congr_cl18_act_d   <=  p0_congr_cl18_m  and (back_inval_stg5_q or ex5_xuop_val_q or ex5_dir_err_val_q);
p1_congr_cl18_act_d   <=  p1_congr_cl18_m  and rel_port_wren_q;
congr_cl18_act        <=  p0_congr_cl18_act_q  or p1_congr_cl18_act_q  or congr_cl_all_act_q;
p0_way_data_upd18_wayA    <=  p0_congr_cl18_act_q  and binv_wayA_upd3_q;
p1_way_data_upd18_wayA    <=  p1_congr_cl18_act_q  and reload_wayA_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu18_wayA_upd(0) <=  p1_way_data_upd18_wayA   and p1_wren_q;
rel_bixu18_wayA_upd(1) <=  p0_way_data_upd18_wayA   and p0_wren_q;
p0_way_data_upd18_wayB    <=  p0_congr_cl18_act_q  and binv_wayB_upd3_q;
p1_way_data_upd18_wayB    <=  p1_congr_cl18_act_q  and reload_wayB_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu18_wayB_upd(0) <=  p1_way_data_upd18_wayB   and p1_wren_q;
rel_bixu18_wayB_upd(1) <=  p0_way_data_upd18_wayB   and p0_wren_q;
p0_way_data_upd18_wayC    <=  p0_congr_cl18_act_q  and binv_wayC_upd3_q;
p1_way_data_upd18_wayC    <=  p1_congr_cl18_act_q  and reload_wayC_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu18_wayC_upd(0) <=  p1_way_data_upd18_wayC   and p1_wren_q;
rel_bixu18_wayC_upd(1) <=  p0_way_data_upd18_wayC   and p0_wren_q;
p0_way_data_upd18_wayD    <=  p0_congr_cl18_act_q  and binv_wayD_upd3_q;
p1_way_data_upd18_wayD    <=  p1_congr_cl18_act_q  and reload_wayD_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu18_wayD_upd(0) <=  p1_way_data_upd18_wayD   and p1_wren_q;
rel_bixu18_wayD_upd(1) <=  p0_way_data_upd18_wayD   and p0_wren_q;
p0_way_data_upd18_wayE    <=  p0_congr_cl18_act_q  and binv_wayE_upd3_q;
p1_way_data_upd18_wayE    <=  p1_congr_cl18_act_q  and reload_wayE_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu18_wayE_upd(0) <=  p1_way_data_upd18_wayE   and p1_wren_q;
rel_bixu18_wayE_upd(1) <=  p0_way_data_upd18_wayE   and p0_wren_q;
p0_way_data_upd18_wayF    <=  p0_congr_cl18_act_q  and binv_wayF_upd3_q;
p1_way_data_upd18_wayF    <=  p1_congr_cl18_act_q  and reload_wayF_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu18_wayF_upd(0) <=  p1_way_data_upd18_wayF   and p1_wren_q;
rel_bixu18_wayF_upd(1) <=  p0_way_data_upd18_wayF   and p0_wren_q;
p0_way_data_upd18_wayG    <=  p0_congr_cl18_act_q  and binv_wayG_upd3_q;
p1_way_data_upd18_wayG    <=  p1_congr_cl18_act_q  and reload_wayG_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu18_wayG_upd(0) <=  p1_way_data_upd18_wayG   and p1_wren_q;
rel_bixu18_wayG_upd(1) <=  p0_way_data_upd18_wayG   and p0_wren_q;
p0_way_data_upd18_wayH    <=  p0_congr_cl18_act_q  and binv_wayH_upd3_q;
p1_way_data_upd18_wayH    <=  p1_congr_cl18_act_q  and reload_wayH_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu18_wayH_upd(0) <=  p1_way_data_upd18_wayH   and p1_wren_q;
rel_bixu18_wayH_upd(1) <=  p0_way_data_upd18_wayH   and p0_wren_q;
-- Congruence Class Match
p0_congr_cl19_m       <=  (ex5_congr_cl_q    = tconv(19,6));
p1_congr_cl19_m       <=  (relu_s_congr_cl_q = tconv(19,6));
-- Act Pin to Directory Latches for specific congruence class
p0_congr_cl19_act_d   <=  p0_congr_cl19_m  and (back_inval_stg5_q or ex5_xuop_val_q or ex5_dir_err_val_q);
p1_congr_cl19_act_d   <=  p1_congr_cl19_m  and rel_port_wren_q;
congr_cl19_act        <=  p0_congr_cl19_act_q  or p1_congr_cl19_act_q  or congr_cl_all_act_q;
p0_way_data_upd19_wayA    <=  p0_congr_cl19_act_q  and binv_wayA_upd3_q;
p1_way_data_upd19_wayA    <=  p1_congr_cl19_act_q  and reload_wayA_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu19_wayA_upd(0) <=  p1_way_data_upd19_wayA   and p1_wren_q;
rel_bixu19_wayA_upd(1) <=  p0_way_data_upd19_wayA   and p0_wren_q;
p0_way_data_upd19_wayB    <=  p0_congr_cl19_act_q  and binv_wayB_upd3_q;
p1_way_data_upd19_wayB    <=  p1_congr_cl19_act_q  and reload_wayB_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu19_wayB_upd(0) <=  p1_way_data_upd19_wayB   and p1_wren_q;
rel_bixu19_wayB_upd(1) <=  p0_way_data_upd19_wayB   and p0_wren_q;
p0_way_data_upd19_wayC    <=  p0_congr_cl19_act_q  and binv_wayC_upd3_q;
p1_way_data_upd19_wayC    <=  p1_congr_cl19_act_q  and reload_wayC_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu19_wayC_upd(0) <=  p1_way_data_upd19_wayC   and p1_wren_q;
rel_bixu19_wayC_upd(1) <=  p0_way_data_upd19_wayC   and p0_wren_q;
p0_way_data_upd19_wayD    <=  p0_congr_cl19_act_q  and binv_wayD_upd3_q;
p1_way_data_upd19_wayD    <=  p1_congr_cl19_act_q  and reload_wayD_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu19_wayD_upd(0) <=  p1_way_data_upd19_wayD   and p1_wren_q;
rel_bixu19_wayD_upd(1) <=  p0_way_data_upd19_wayD   and p0_wren_q;
p0_way_data_upd19_wayE    <=  p0_congr_cl19_act_q  and binv_wayE_upd3_q;
p1_way_data_upd19_wayE    <=  p1_congr_cl19_act_q  and reload_wayE_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu19_wayE_upd(0) <=  p1_way_data_upd19_wayE   and p1_wren_q;
rel_bixu19_wayE_upd(1) <=  p0_way_data_upd19_wayE   and p0_wren_q;
p0_way_data_upd19_wayF    <=  p0_congr_cl19_act_q  and binv_wayF_upd3_q;
p1_way_data_upd19_wayF    <=  p1_congr_cl19_act_q  and reload_wayF_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu19_wayF_upd(0) <=  p1_way_data_upd19_wayF   and p1_wren_q;
rel_bixu19_wayF_upd(1) <=  p0_way_data_upd19_wayF   and p0_wren_q;
p0_way_data_upd19_wayG    <=  p0_congr_cl19_act_q  and binv_wayG_upd3_q;
p1_way_data_upd19_wayG    <=  p1_congr_cl19_act_q  and reload_wayG_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu19_wayG_upd(0) <=  p1_way_data_upd19_wayG   and p1_wren_q;
rel_bixu19_wayG_upd(1) <=  p0_way_data_upd19_wayG   and p0_wren_q;
p0_way_data_upd19_wayH    <=  p0_congr_cl19_act_q  and binv_wayH_upd3_q;
p1_way_data_upd19_wayH    <=  p1_congr_cl19_act_q  and reload_wayH_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu19_wayH_upd(0) <=  p1_way_data_upd19_wayH   and p1_wren_q;
rel_bixu19_wayH_upd(1) <=  p0_way_data_upd19_wayH   and p0_wren_q;
-- Congruence Class Match
p0_congr_cl20_m       <=  (ex5_congr_cl_q    = tconv(20,6));
p1_congr_cl20_m       <=  (relu_s_congr_cl_q = tconv(20,6));
-- Act Pin to Directory Latches for specific congruence class
p0_congr_cl20_act_d   <=  p0_congr_cl20_m  and (back_inval_stg5_q or ex5_xuop_val_q or ex5_dir_err_val_q);
p1_congr_cl20_act_d   <=  p1_congr_cl20_m  and rel_port_wren_q;
congr_cl20_act        <=  p0_congr_cl20_act_q  or p1_congr_cl20_act_q  or congr_cl_all_act_q;
p0_way_data_upd20_wayA    <=  p0_congr_cl20_act_q  and binv_wayA_upd3_q;
p1_way_data_upd20_wayA    <=  p1_congr_cl20_act_q  and reload_wayA_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu20_wayA_upd(0) <=  p1_way_data_upd20_wayA   and p1_wren_q;
rel_bixu20_wayA_upd(1) <=  p0_way_data_upd20_wayA   and p0_wren_q;
p0_way_data_upd20_wayB    <=  p0_congr_cl20_act_q  and binv_wayB_upd3_q;
p1_way_data_upd20_wayB    <=  p1_congr_cl20_act_q  and reload_wayB_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu20_wayB_upd(0) <=  p1_way_data_upd20_wayB   and p1_wren_q;
rel_bixu20_wayB_upd(1) <=  p0_way_data_upd20_wayB   and p0_wren_q;
p0_way_data_upd20_wayC    <=  p0_congr_cl20_act_q  and binv_wayC_upd3_q;
p1_way_data_upd20_wayC    <=  p1_congr_cl20_act_q  and reload_wayC_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu20_wayC_upd(0) <=  p1_way_data_upd20_wayC   and p1_wren_q;
rel_bixu20_wayC_upd(1) <=  p0_way_data_upd20_wayC   and p0_wren_q;
p0_way_data_upd20_wayD    <=  p0_congr_cl20_act_q  and binv_wayD_upd3_q;
p1_way_data_upd20_wayD    <=  p1_congr_cl20_act_q  and reload_wayD_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu20_wayD_upd(0) <=  p1_way_data_upd20_wayD   and p1_wren_q;
rel_bixu20_wayD_upd(1) <=  p0_way_data_upd20_wayD   and p0_wren_q;
p0_way_data_upd20_wayE    <=  p0_congr_cl20_act_q  and binv_wayE_upd3_q;
p1_way_data_upd20_wayE    <=  p1_congr_cl20_act_q  and reload_wayE_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu20_wayE_upd(0) <=  p1_way_data_upd20_wayE   and p1_wren_q;
rel_bixu20_wayE_upd(1) <=  p0_way_data_upd20_wayE   and p0_wren_q;
p0_way_data_upd20_wayF    <=  p0_congr_cl20_act_q  and binv_wayF_upd3_q;
p1_way_data_upd20_wayF    <=  p1_congr_cl20_act_q  and reload_wayF_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu20_wayF_upd(0) <=  p1_way_data_upd20_wayF   and p1_wren_q;
rel_bixu20_wayF_upd(1) <=  p0_way_data_upd20_wayF   and p0_wren_q;
p0_way_data_upd20_wayG    <=  p0_congr_cl20_act_q  and binv_wayG_upd3_q;
p1_way_data_upd20_wayG    <=  p1_congr_cl20_act_q  and reload_wayG_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu20_wayG_upd(0) <=  p1_way_data_upd20_wayG   and p1_wren_q;
rel_bixu20_wayG_upd(1) <=  p0_way_data_upd20_wayG   and p0_wren_q;
p0_way_data_upd20_wayH    <=  p0_congr_cl20_act_q  and binv_wayH_upd3_q;
p1_way_data_upd20_wayH    <=  p1_congr_cl20_act_q  and reload_wayH_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu20_wayH_upd(0) <=  p1_way_data_upd20_wayH   and p1_wren_q;
rel_bixu20_wayH_upd(1) <=  p0_way_data_upd20_wayH   and p0_wren_q;
-- Congruence Class Match
p0_congr_cl21_m       <=  (ex5_congr_cl_q    = tconv(21,6));
p1_congr_cl21_m       <=  (relu_s_congr_cl_q = tconv(21,6));
-- Act Pin to Directory Latches for specific congruence class
p0_congr_cl21_act_d   <=  p0_congr_cl21_m  and (back_inval_stg5_q or ex5_xuop_val_q or ex5_dir_err_val_q);
p1_congr_cl21_act_d   <=  p1_congr_cl21_m  and rel_port_wren_q;
congr_cl21_act        <=  p0_congr_cl21_act_q  or p1_congr_cl21_act_q  or congr_cl_all_act_q;
p0_way_data_upd21_wayA    <=  p0_congr_cl21_act_q  and binv_wayA_upd3_q;
p1_way_data_upd21_wayA    <=  p1_congr_cl21_act_q  and reload_wayA_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu21_wayA_upd(0) <=  p1_way_data_upd21_wayA   and p1_wren_q;
rel_bixu21_wayA_upd(1) <=  p0_way_data_upd21_wayA   and p0_wren_q;
p0_way_data_upd21_wayB    <=  p0_congr_cl21_act_q  and binv_wayB_upd3_q;
p1_way_data_upd21_wayB    <=  p1_congr_cl21_act_q  and reload_wayB_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu21_wayB_upd(0) <=  p1_way_data_upd21_wayB   and p1_wren_q;
rel_bixu21_wayB_upd(1) <=  p0_way_data_upd21_wayB   and p0_wren_q;
p0_way_data_upd21_wayC    <=  p0_congr_cl21_act_q  and binv_wayC_upd3_q;
p1_way_data_upd21_wayC    <=  p1_congr_cl21_act_q  and reload_wayC_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu21_wayC_upd(0) <=  p1_way_data_upd21_wayC   and p1_wren_q;
rel_bixu21_wayC_upd(1) <=  p0_way_data_upd21_wayC   and p0_wren_q;
p0_way_data_upd21_wayD    <=  p0_congr_cl21_act_q  and binv_wayD_upd3_q;
p1_way_data_upd21_wayD    <=  p1_congr_cl21_act_q  and reload_wayD_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu21_wayD_upd(0) <=  p1_way_data_upd21_wayD   and p1_wren_q;
rel_bixu21_wayD_upd(1) <=  p0_way_data_upd21_wayD   and p0_wren_q;
p0_way_data_upd21_wayE    <=  p0_congr_cl21_act_q  and binv_wayE_upd3_q;
p1_way_data_upd21_wayE    <=  p1_congr_cl21_act_q  and reload_wayE_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu21_wayE_upd(0) <=  p1_way_data_upd21_wayE   and p1_wren_q;
rel_bixu21_wayE_upd(1) <=  p0_way_data_upd21_wayE   and p0_wren_q;
p0_way_data_upd21_wayF    <=  p0_congr_cl21_act_q  and binv_wayF_upd3_q;
p1_way_data_upd21_wayF    <=  p1_congr_cl21_act_q  and reload_wayF_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu21_wayF_upd(0) <=  p1_way_data_upd21_wayF   and p1_wren_q;
rel_bixu21_wayF_upd(1) <=  p0_way_data_upd21_wayF   and p0_wren_q;
p0_way_data_upd21_wayG    <=  p0_congr_cl21_act_q  and binv_wayG_upd3_q;
p1_way_data_upd21_wayG    <=  p1_congr_cl21_act_q  and reload_wayG_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu21_wayG_upd(0) <=  p1_way_data_upd21_wayG   and p1_wren_q;
rel_bixu21_wayG_upd(1) <=  p0_way_data_upd21_wayG   and p0_wren_q;
p0_way_data_upd21_wayH    <=  p0_congr_cl21_act_q  and binv_wayH_upd3_q;
p1_way_data_upd21_wayH    <=  p1_congr_cl21_act_q  and reload_wayH_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu21_wayH_upd(0) <=  p1_way_data_upd21_wayH   and p1_wren_q;
rel_bixu21_wayH_upd(1) <=  p0_way_data_upd21_wayH   and p0_wren_q;
-- Congruence Class Match
p0_congr_cl22_m       <=  (ex5_congr_cl_q    = tconv(22,6));
p1_congr_cl22_m       <=  (relu_s_congr_cl_q = tconv(22,6));
-- Act Pin to Directory Latches for specific congruence class
p0_congr_cl22_act_d   <=  p0_congr_cl22_m  and (back_inval_stg5_q or ex5_xuop_val_q or ex5_dir_err_val_q);
p1_congr_cl22_act_d   <=  p1_congr_cl22_m  and rel_port_wren_q;
congr_cl22_act        <=  p0_congr_cl22_act_q  or p1_congr_cl22_act_q  or congr_cl_all_act_q;
p0_way_data_upd22_wayA    <=  p0_congr_cl22_act_q  and binv_wayA_upd3_q;
p1_way_data_upd22_wayA    <=  p1_congr_cl22_act_q  and reload_wayA_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu22_wayA_upd(0) <=  p1_way_data_upd22_wayA   and p1_wren_q;
rel_bixu22_wayA_upd(1) <=  p0_way_data_upd22_wayA   and p0_wren_q;
p0_way_data_upd22_wayB    <=  p0_congr_cl22_act_q  and binv_wayB_upd3_q;
p1_way_data_upd22_wayB    <=  p1_congr_cl22_act_q  and reload_wayB_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu22_wayB_upd(0) <=  p1_way_data_upd22_wayB   and p1_wren_q;
rel_bixu22_wayB_upd(1) <=  p0_way_data_upd22_wayB   and p0_wren_q;
p0_way_data_upd22_wayC    <=  p0_congr_cl22_act_q  and binv_wayC_upd3_q;
p1_way_data_upd22_wayC    <=  p1_congr_cl22_act_q  and reload_wayC_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu22_wayC_upd(0) <=  p1_way_data_upd22_wayC   and p1_wren_q;
rel_bixu22_wayC_upd(1) <=  p0_way_data_upd22_wayC   and p0_wren_q;
p0_way_data_upd22_wayD    <=  p0_congr_cl22_act_q  and binv_wayD_upd3_q;
p1_way_data_upd22_wayD    <=  p1_congr_cl22_act_q  and reload_wayD_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu22_wayD_upd(0) <=  p1_way_data_upd22_wayD   and p1_wren_q;
rel_bixu22_wayD_upd(1) <=  p0_way_data_upd22_wayD   and p0_wren_q;
p0_way_data_upd22_wayE    <=  p0_congr_cl22_act_q  and binv_wayE_upd3_q;
p1_way_data_upd22_wayE    <=  p1_congr_cl22_act_q  and reload_wayE_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu22_wayE_upd(0) <=  p1_way_data_upd22_wayE   and p1_wren_q;
rel_bixu22_wayE_upd(1) <=  p0_way_data_upd22_wayE   and p0_wren_q;
p0_way_data_upd22_wayF    <=  p0_congr_cl22_act_q  and binv_wayF_upd3_q;
p1_way_data_upd22_wayF    <=  p1_congr_cl22_act_q  and reload_wayF_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu22_wayF_upd(0) <=  p1_way_data_upd22_wayF   and p1_wren_q;
rel_bixu22_wayF_upd(1) <=  p0_way_data_upd22_wayF   and p0_wren_q;
p0_way_data_upd22_wayG    <=  p0_congr_cl22_act_q  and binv_wayG_upd3_q;
p1_way_data_upd22_wayG    <=  p1_congr_cl22_act_q  and reload_wayG_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu22_wayG_upd(0) <=  p1_way_data_upd22_wayG   and p1_wren_q;
rel_bixu22_wayG_upd(1) <=  p0_way_data_upd22_wayG   and p0_wren_q;
p0_way_data_upd22_wayH    <=  p0_congr_cl22_act_q  and binv_wayH_upd3_q;
p1_way_data_upd22_wayH    <=  p1_congr_cl22_act_q  and reload_wayH_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu22_wayH_upd(0) <=  p1_way_data_upd22_wayH   and p1_wren_q;
rel_bixu22_wayH_upd(1) <=  p0_way_data_upd22_wayH   and p0_wren_q;
-- Congruence Class Match
p0_congr_cl23_m       <=  (ex5_congr_cl_q    = tconv(23,6));
p1_congr_cl23_m       <=  (relu_s_congr_cl_q = tconv(23,6));
-- Act Pin to Directory Latches for specific congruence class
p0_congr_cl23_act_d   <=  p0_congr_cl23_m  and (back_inval_stg5_q or ex5_xuop_val_q or ex5_dir_err_val_q);
p1_congr_cl23_act_d   <=  p1_congr_cl23_m  and rel_port_wren_q;
congr_cl23_act        <=  p0_congr_cl23_act_q  or p1_congr_cl23_act_q  or congr_cl_all_act_q;
p0_way_data_upd23_wayA    <=  p0_congr_cl23_act_q  and binv_wayA_upd3_q;
p1_way_data_upd23_wayA    <=  p1_congr_cl23_act_q  and reload_wayA_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu23_wayA_upd(0) <=  p1_way_data_upd23_wayA   and p1_wren_q;
rel_bixu23_wayA_upd(1) <=  p0_way_data_upd23_wayA   and p0_wren_q;
p0_way_data_upd23_wayB    <=  p0_congr_cl23_act_q  and binv_wayB_upd3_q;
p1_way_data_upd23_wayB    <=  p1_congr_cl23_act_q  and reload_wayB_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu23_wayB_upd(0) <=  p1_way_data_upd23_wayB   and p1_wren_q;
rel_bixu23_wayB_upd(1) <=  p0_way_data_upd23_wayB   and p0_wren_q;
p0_way_data_upd23_wayC    <=  p0_congr_cl23_act_q  and binv_wayC_upd3_q;
p1_way_data_upd23_wayC    <=  p1_congr_cl23_act_q  and reload_wayC_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu23_wayC_upd(0) <=  p1_way_data_upd23_wayC   and p1_wren_q;
rel_bixu23_wayC_upd(1) <=  p0_way_data_upd23_wayC   and p0_wren_q;
p0_way_data_upd23_wayD    <=  p0_congr_cl23_act_q  and binv_wayD_upd3_q;
p1_way_data_upd23_wayD    <=  p1_congr_cl23_act_q  and reload_wayD_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu23_wayD_upd(0) <=  p1_way_data_upd23_wayD   and p1_wren_q;
rel_bixu23_wayD_upd(1) <=  p0_way_data_upd23_wayD   and p0_wren_q;
p0_way_data_upd23_wayE    <=  p0_congr_cl23_act_q  and binv_wayE_upd3_q;
p1_way_data_upd23_wayE    <=  p1_congr_cl23_act_q  and reload_wayE_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu23_wayE_upd(0) <=  p1_way_data_upd23_wayE   and p1_wren_q;
rel_bixu23_wayE_upd(1) <=  p0_way_data_upd23_wayE   and p0_wren_q;
p0_way_data_upd23_wayF    <=  p0_congr_cl23_act_q  and binv_wayF_upd3_q;
p1_way_data_upd23_wayF    <=  p1_congr_cl23_act_q  and reload_wayF_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu23_wayF_upd(0) <=  p1_way_data_upd23_wayF   and p1_wren_q;
rel_bixu23_wayF_upd(1) <=  p0_way_data_upd23_wayF   and p0_wren_q;
p0_way_data_upd23_wayG    <=  p0_congr_cl23_act_q  and binv_wayG_upd3_q;
p1_way_data_upd23_wayG    <=  p1_congr_cl23_act_q  and reload_wayG_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu23_wayG_upd(0) <=  p1_way_data_upd23_wayG   and p1_wren_q;
rel_bixu23_wayG_upd(1) <=  p0_way_data_upd23_wayG   and p0_wren_q;
p0_way_data_upd23_wayH    <=  p0_congr_cl23_act_q  and binv_wayH_upd3_q;
p1_way_data_upd23_wayH    <=  p1_congr_cl23_act_q  and reload_wayH_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu23_wayH_upd(0) <=  p1_way_data_upd23_wayH   and p1_wren_q;
rel_bixu23_wayH_upd(1) <=  p0_way_data_upd23_wayH   and p0_wren_q;
-- Congruence Class Match
p0_congr_cl24_m       <=  (ex5_congr_cl_q    = tconv(24,6));
p1_congr_cl24_m       <=  (relu_s_congr_cl_q = tconv(24,6));
-- Act Pin to Directory Latches for specific congruence class
p0_congr_cl24_act_d   <=  p0_congr_cl24_m  and (back_inval_stg5_q or ex5_xuop_val_q or ex5_dir_err_val_q);
p1_congr_cl24_act_d   <=  p1_congr_cl24_m  and rel_port_wren_q;
congr_cl24_act        <=  p0_congr_cl24_act_q  or p1_congr_cl24_act_q  or congr_cl_all_act_q;
p0_way_data_upd24_wayA    <=  p0_congr_cl24_act_q  and binv_wayA_upd3_q;
p1_way_data_upd24_wayA    <=  p1_congr_cl24_act_q  and reload_wayA_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu24_wayA_upd(0) <=  p1_way_data_upd24_wayA   and p1_wren_q;
rel_bixu24_wayA_upd(1) <=  p0_way_data_upd24_wayA   and p0_wren_q;
p0_way_data_upd24_wayB    <=  p0_congr_cl24_act_q  and binv_wayB_upd3_q;
p1_way_data_upd24_wayB    <=  p1_congr_cl24_act_q  and reload_wayB_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu24_wayB_upd(0) <=  p1_way_data_upd24_wayB   and p1_wren_q;
rel_bixu24_wayB_upd(1) <=  p0_way_data_upd24_wayB   and p0_wren_q;
p0_way_data_upd24_wayC    <=  p0_congr_cl24_act_q  and binv_wayC_upd3_q;
p1_way_data_upd24_wayC    <=  p1_congr_cl24_act_q  and reload_wayC_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu24_wayC_upd(0) <=  p1_way_data_upd24_wayC   and p1_wren_q;
rel_bixu24_wayC_upd(1) <=  p0_way_data_upd24_wayC   and p0_wren_q;
p0_way_data_upd24_wayD    <=  p0_congr_cl24_act_q  and binv_wayD_upd3_q;
p1_way_data_upd24_wayD    <=  p1_congr_cl24_act_q  and reload_wayD_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu24_wayD_upd(0) <=  p1_way_data_upd24_wayD   and p1_wren_q;
rel_bixu24_wayD_upd(1) <=  p0_way_data_upd24_wayD   and p0_wren_q;
p0_way_data_upd24_wayE    <=  p0_congr_cl24_act_q  and binv_wayE_upd3_q;
p1_way_data_upd24_wayE    <=  p1_congr_cl24_act_q  and reload_wayE_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu24_wayE_upd(0) <=  p1_way_data_upd24_wayE   and p1_wren_q;
rel_bixu24_wayE_upd(1) <=  p0_way_data_upd24_wayE   and p0_wren_q;
p0_way_data_upd24_wayF    <=  p0_congr_cl24_act_q  and binv_wayF_upd3_q;
p1_way_data_upd24_wayF    <=  p1_congr_cl24_act_q  and reload_wayF_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu24_wayF_upd(0) <=  p1_way_data_upd24_wayF   and p1_wren_q;
rel_bixu24_wayF_upd(1) <=  p0_way_data_upd24_wayF   and p0_wren_q;
p0_way_data_upd24_wayG    <=  p0_congr_cl24_act_q  and binv_wayG_upd3_q;
p1_way_data_upd24_wayG    <=  p1_congr_cl24_act_q  and reload_wayG_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu24_wayG_upd(0) <=  p1_way_data_upd24_wayG   and p1_wren_q;
rel_bixu24_wayG_upd(1) <=  p0_way_data_upd24_wayG   and p0_wren_q;
p0_way_data_upd24_wayH    <=  p0_congr_cl24_act_q  and binv_wayH_upd3_q;
p1_way_data_upd24_wayH    <=  p1_congr_cl24_act_q  and reload_wayH_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu24_wayH_upd(0) <=  p1_way_data_upd24_wayH   and p1_wren_q;
rel_bixu24_wayH_upd(1) <=  p0_way_data_upd24_wayH   and p0_wren_q;
-- Congruence Class Match
p0_congr_cl25_m       <=  (ex5_congr_cl_q    = tconv(25,6));
p1_congr_cl25_m       <=  (relu_s_congr_cl_q = tconv(25,6));
-- Act Pin to Directory Latches for specific congruence class
p0_congr_cl25_act_d   <=  p0_congr_cl25_m  and (back_inval_stg5_q or ex5_xuop_val_q or ex5_dir_err_val_q);
p1_congr_cl25_act_d   <=  p1_congr_cl25_m  and rel_port_wren_q;
congr_cl25_act        <=  p0_congr_cl25_act_q  or p1_congr_cl25_act_q  or congr_cl_all_act_q;
p0_way_data_upd25_wayA    <=  p0_congr_cl25_act_q  and binv_wayA_upd3_q;
p1_way_data_upd25_wayA    <=  p1_congr_cl25_act_q  and reload_wayA_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu25_wayA_upd(0) <=  p1_way_data_upd25_wayA   and p1_wren_q;
rel_bixu25_wayA_upd(1) <=  p0_way_data_upd25_wayA   and p0_wren_q;
p0_way_data_upd25_wayB    <=  p0_congr_cl25_act_q  and binv_wayB_upd3_q;
p1_way_data_upd25_wayB    <=  p1_congr_cl25_act_q  and reload_wayB_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu25_wayB_upd(0) <=  p1_way_data_upd25_wayB   and p1_wren_q;
rel_bixu25_wayB_upd(1) <=  p0_way_data_upd25_wayB   and p0_wren_q;
p0_way_data_upd25_wayC    <=  p0_congr_cl25_act_q  and binv_wayC_upd3_q;
p1_way_data_upd25_wayC    <=  p1_congr_cl25_act_q  and reload_wayC_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu25_wayC_upd(0) <=  p1_way_data_upd25_wayC   and p1_wren_q;
rel_bixu25_wayC_upd(1) <=  p0_way_data_upd25_wayC   and p0_wren_q;
p0_way_data_upd25_wayD    <=  p0_congr_cl25_act_q  and binv_wayD_upd3_q;
p1_way_data_upd25_wayD    <=  p1_congr_cl25_act_q  and reload_wayD_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu25_wayD_upd(0) <=  p1_way_data_upd25_wayD   and p1_wren_q;
rel_bixu25_wayD_upd(1) <=  p0_way_data_upd25_wayD   and p0_wren_q;
p0_way_data_upd25_wayE    <=  p0_congr_cl25_act_q  and binv_wayE_upd3_q;
p1_way_data_upd25_wayE    <=  p1_congr_cl25_act_q  and reload_wayE_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu25_wayE_upd(0) <=  p1_way_data_upd25_wayE   and p1_wren_q;
rel_bixu25_wayE_upd(1) <=  p0_way_data_upd25_wayE   and p0_wren_q;
p0_way_data_upd25_wayF    <=  p0_congr_cl25_act_q  and binv_wayF_upd3_q;
p1_way_data_upd25_wayF    <=  p1_congr_cl25_act_q  and reload_wayF_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu25_wayF_upd(0) <=  p1_way_data_upd25_wayF   and p1_wren_q;
rel_bixu25_wayF_upd(1) <=  p0_way_data_upd25_wayF   and p0_wren_q;
p0_way_data_upd25_wayG    <=  p0_congr_cl25_act_q  and binv_wayG_upd3_q;
p1_way_data_upd25_wayG    <=  p1_congr_cl25_act_q  and reload_wayG_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu25_wayG_upd(0) <=  p1_way_data_upd25_wayG   and p1_wren_q;
rel_bixu25_wayG_upd(1) <=  p0_way_data_upd25_wayG   and p0_wren_q;
p0_way_data_upd25_wayH    <=  p0_congr_cl25_act_q  and binv_wayH_upd3_q;
p1_way_data_upd25_wayH    <=  p1_congr_cl25_act_q  and reload_wayH_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu25_wayH_upd(0) <=  p1_way_data_upd25_wayH   and p1_wren_q;
rel_bixu25_wayH_upd(1) <=  p0_way_data_upd25_wayH   and p0_wren_q;
-- Congruence Class Match
p0_congr_cl26_m       <=  (ex5_congr_cl_q    = tconv(26,6));
p1_congr_cl26_m       <=  (relu_s_congr_cl_q = tconv(26,6));
-- Act Pin to Directory Latches for specific congruence class
p0_congr_cl26_act_d   <=  p0_congr_cl26_m  and (back_inval_stg5_q or ex5_xuop_val_q or ex5_dir_err_val_q);
p1_congr_cl26_act_d   <=  p1_congr_cl26_m  and rel_port_wren_q;
congr_cl26_act        <=  p0_congr_cl26_act_q  or p1_congr_cl26_act_q  or congr_cl_all_act_q;
p0_way_data_upd26_wayA    <=  p0_congr_cl26_act_q  and binv_wayA_upd3_q;
p1_way_data_upd26_wayA    <=  p1_congr_cl26_act_q  and reload_wayA_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu26_wayA_upd(0) <=  p1_way_data_upd26_wayA   and p1_wren_q;
rel_bixu26_wayA_upd(1) <=  p0_way_data_upd26_wayA   and p0_wren_q;
p0_way_data_upd26_wayB    <=  p0_congr_cl26_act_q  and binv_wayB_upd3_q;
p1_way_data_upd26_wayB    <=  p1_congr_cl26_act_q  and reload_wayB_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu26_wayB_upd(0) <=  p1_way_data_upd26_wayB   and p1_wren_q;
rel_bixu26_wayB_upd(1) <=  p0_way_data_upd26_wayB   and p0_wren_q;
p0_way_data_upd26_wayC    <=  p0_congr_cl26_act_q  and binv_wayC_upd3_q;
p1_way_data_upd26_wayC    <=  p1_congr_cl26_act_q  and reload_wayC_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu26_wayC_upd(0) <=  p1_way_data_upd26_wayC   and p1_wren_q;
rel_bixu26_wayC_upd(1) <=  p0_way_data_upd26_wayC   and p0_wren_q;
p0_way_data_upd26_wayD    <=  p0_congr_cl26_act_q  and binv_wayD_upd3_q;
p1_way_data_upd26_wayD    <=  p1_congr_cl26_act_q  and reload_wayD_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu26_wayD_upd(0) <=  p1_way_data_upd26_wayD   and p1_wren_q;
rel_bixu26_wayD_upd(1) <=  p0_way_data_upd26_wayD   and p0_wren_q;
p0_way_data_upd26_wayE    <=  p0_congr_cl26_act_q  and binv_wayE_upd3_q;
p1_way_data_upd26_wayE    <=  p1_congr_cl26_act_q  and reload_wayE_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu26_wayE_upd(0) <=  p1_way_data_upd26_wayE   and p1_wren_q;
rel_bixu26_wayE_upd(1) <=  p0_way_data_upd26_wayE   and p0_wren_q;
p0_way_data_upd26_wayF    <=  p0_congr_cl26_act_q  and binv_wayF_upd3_q;
p1_way_data_upd26_wayF    <=  p1_congr_cl26_act_q  and reload_wayF_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu26_wayF_upd(0) <=  p1_way_data_upd26_wayF   and p1_wren_q;
rel_bixu26_wayF_upd(1) <=  p0_way_data_upd26_wayF   and p0_wren_q;
p0_way_data_upd26_wayG    <=  p0_congr_cl26_act_q  and binv_wayG_upd3_q;
p1_way_data_upd26_wayG    <=  p1_congr_cl26_act_q  and reload_wayG_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu26_wayG_upd(0) <=  p1_way_data_upd26_wayG   and p1_wren_q;
rel_bixu26_wayG_upd(1) <=  p0_way_data_upd26_wayG   and p0_wren_q;
p0_way_data_upd26_wayH    <=  p0_congr_cl26_act_q  and binv_wayH_upd3_q;
p1_way_data_upd26_wayH    <=  p1_congr_cl26_act_q  and reload_wayH_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu26_wayH_upd(0) <=  p1_way_data_upd26_wayH   and p1_wren_q;
rel_bixu26_wayH_upd(1) <=  p0_way_data_upd26_wayH   and p0_wren_q;
-- Congruence Class Match
p0_congr_cl27_m       <=  (ex5_congr_cl_q    = tconv(27,6));
p1_congr_cl27_m       <=  (relu_s_congr_cl_q = tconv(27,6));
-- Act Pin to Directory Latches for specific congruence class
p0_congr_cl27_act_d   <=  p0_congr_cl27_m  and (back_inval_stg5_q or ex5_xuop_val_q or ex5_dir_err_val_q);
p1_congr_cl27_act_d   <=  p1_congr_cl27_m  and rel_port_wren_q;
congr_cl27_act        <=  p0_congr_cl27_act_q  or p1_congr_cl27_act_q  or congr_cl_all_act_q;
p0_way_data_upd27_wayA    <=  p0_congr_cl27_act_q  and binv_wayA_upd3_q;
p1_way_data_upd27_wayA    <=  p1_congr_cl27_act_q  and reload_wayA_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu27_wayA_upd(0) <=  p1_way_data_upd27_wayA   and p1_wren_q;
rel_bixu27_wayA_upd(1) <=  p0_way_data_upd27_wayA   and p0_wren_q;
p0_way_data_upd27_wayB    <=  p0_congr_cl27_act_q  and binv_wayB_upd3_q;
p1_way_data_upd27_wayB    <=  p1_congr_cl27_act_q  and reload_wayB_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu27_wayB_upd(0) <=  p1_way_data_upd27_wayB   and p1_wren_q;
rel_bixu27_wayB_upd(1) <=  p0_way_data_upd27_wayB   and p0_wren_q;
p0_way_data_upd27_wayC    <=  p0_congr_cl27_act_q  and binv_wayC_upd3_q;
p1_way_data_upd27_wayC    <=  p1_congr_cl27_act_q  and reload_wayC_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu27_wayC_upd(0) <=  p1_way_data_upd27_wayC   and p1_wren_q;
rel_bixu27_wayC_upd(1) <=  p0_way_data_upd27_wayC   and p0_wren_q;
p0_way_data_upd27_wayD    <=  p0_congr_cl27_act_q  and binv_wayD_upd3_q;
p1_way_data_upd27_wayD    <=  p1_congr_cl27_act_q  and reload_wayD_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu27_wayD_upd(0) <=  p1_way_data_upd27_wayD   and p1_wren_q;
rel_bixu27_wayD_upd(1) <=  p0_way_data_upd27_wayD   and p0_wren_q;
p0_way_data_upd27_wayE    <=  p0_congr_cl27_act_q  and binv_wayE_upd3_q;
p1_way_data_upd27_wayE    <=  p1_congr_cl27_act_q  and reload_wayE_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu27_wayE_upd(0) <=  p1_way_data_upd27_wayE   and p1_wren_q;
rel_bixu27_wayE_upd(1) <=  p0_way_data_upd27_wayE   and p0_wren_q;
p0_way_data_upd27_wayF    <=  p0_congr_cl27_act_q  and binv_wayF_upd3_q;
p1_way_data_upd27_wayF    <=  p1_congr_cl27_act_q  and reload_wayF_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu27_wayF_upd(0) <=  p1_way_data_upd27_wayF   and p1_wren_q;
rel_bixu27_wayF_upd(1) <=  p0_way_data_upd27_wayF   and p0_wren_q;
p0_way_data_upd27_wayG    <=  p0_congr_cl27_act_q  and binv_wayG_upd3_q;
p1_way_data_upd27_wayG    <=  p1_congr_cl27_act_q  and reload_wayG_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu27_wayG_upd(0) <=  p1_way_data_upd27_wayG   and p1_wren_q;
rel_bixu27_wayG_upd(1) <=  p0_way_data_upd27_wayG   and p0_wren_q;
p0_way_data_upd27_wayH    <=  p0_congr_cl27_act_q  and binv_wayH_upd3_q;
p1_way_data_upd27_wayH    <=  p1_congr_cl27_act_q  and reload_wayH_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu27_wayH_upd(0) <=  p1_way_data_upd27_wayH   and p1_wren_q;
rel_bixu27_wayH_upd(1) <=  p0_way_data_upd27_wayH   and p0_wren_q;
-- Congruence Class Match
p0_congr_cl28_m       <=  (ex5_congr_cl_q    = tconv(28,6));
p1_congr_cl28_m       <=  (relu_s_congr_cl_q = tconv(28,6));
-- Act Pin to Directory Latches for specific congruence class
p0_congr_cl28_act_d   <=  p0_congr_cl28_m  and (back_inval_stg5_q or ex5_xuop_val_q or ex5_dir_err_val_q);
p1_congr_cl28_act_d   <=  p1_congr_cl28_m  and rel_port_wren_q;
congr_cl28_act        <=  p0_congr_cl28_act_q  or p1_congr_cl28_act_q  or congr_cl_all_act_q;
p0_way_data_upd28_wayA    <=  p0_congr_cl28_act_q  and binv_wayA_upd3_q;
p1_way_data_upd28_wayA    <=  p1_congr_cl28_act_q  and reload_wayA_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu28_wayA_upd(0) <=  p1_way_data_upd28_wayA   and p1_wren_q;
rel_bixu28_wayA_upd(1) <=  p0_way_data_upd28_wayA   and p0_wren_q;
p0_way_data_upd28_wayB    <=  p0_congr_cl28_act_q  and binv_wayB_upd3_q;
p1_way_data_upd28_wayB    <=  p1_congr_cl28_act_q  and reload_wayB_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu28_wayB_upd(0) <=  p1_way_data_upd28_wayB   and p1_wren_q;
rel_bixu28_wayB_upd(1) <=  p0_way_data_upd28_wayB   and p0_wren_q;
p0_way_data_upd28_wayC    <=  p0_congr_cl28_act_q  and binv_wayC_upd3_q;
p1_way_data_upd28_wayC    <=  p1_congr_cl28_act_q  and reload_wayC_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu28_wayC_upd(0) <=  p1_way_data_upd28_wayC   and p1_wren_q;
rel_bixu28_wayC_upd(1) <=  p0_way_data_upd28_wayC   and p0_wren_q;
p0_way_data_upd28_wayD    <=  p0_congr_cl28_act_q  and binv_wayD_upd3_q;
p1_way_data_upd28_wayD    <=  p1_congr_cl28_act_q  and reload_wayD_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu28_wayD_upd(0) <=  p1_way_data_upd28_wayD   and p1_wren_q;
rel_bixu28_wayD_upd(1) <=  p0_way_data_upd28_wayD   and p0_wren_q;
p0_way_data_upd28_wayE    <=  p0_congr_cl28_act_q  and binv_wayE_upd3_q;
p1_way_data_upd28_wayE    <=  p1_congr_cl28_act_q  and reload_wayE_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu28_wayE_upd(0) <=  p1_way_data_upd28_wayE   and p1_wren_q;
rel_bixu28_wayE_upd(1) <=  p0_way_data_upd28_wayE   and p0_wren_q;
p0_way_data_upd28_wayF    <=  p0_congr_cl28_act_q  and binv_wayF_upd3_q;
p1_way_data_upd28_wayF    <=  p1_congr_cl28_act_q  and reload_wayF_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu28_wayF_upd(0) <=  p1_way_data_upd28_wayF   and p1_wren_q;
rel_bixu28_wayF_upd(1) <=  p0_way_data_upd28_wayF   and p0_wren_q;
p0_way_data_upd28_wayG    <=  p0_congr_cl28_act_q  and binv_wayG_upd3_q;
p1_way_data_upd28_wayG    <=  p1_congr_cl28_act_q  and reload_wayG_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu28_wayG_upd(0) <=  p1_way_data_upd28_wayG   and p1_wren_q;
rel_bixu28_wayG_upd(1) <=  p0_way_data_upd28_wayG   and p0_wren_q;
p0_way_data_upd28_wayH    <=  p0_congr_cl28_act_q  and binv_wayH_upd3_q;
p1_way_data_upd28_wayH    <=  p1_congr_cl28_act_q  and reload_wayH_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu28_wayH_upd(0) <=  p1_way_data_upd28_wayH   and p1_wren_q;
rel_bixu28_wayH_upd(1) <=  p0_way_data_upd28_wayH   and p0_wren_q;
-- Congruence Class Match
p0_congr_cl29_m       <=  (ex5_congr_cl_q    = tconv(29,6));
p1_congr_cl29_m       <=  (relu_s_congr_cl_q = tconv(29,6));
-- Act Pin to Directory Latches for specific congruence class
p0_congr_cl29_act_d   <=  p0_congr_cl29_m  and (back_inval_stg5_q or ex5_xuop_val_q or ex5_dir_err_val_q);
p1_congr_cl29_act_d   <=  p1_congr_cl29_m  and rel_port_wren_q;
congr_cl29_act        <=  p0_congr_cl29_act_q  or p1_congr_cl29_act_q  or congr_cl_all_act_q;
p0_way_data_upd29_wayA    <=  p0_congr_cl29_act_q  and binv_wayA_upd3_q;
p1_way_data_upd29_wayA    <=  p1_congr_cl29_act_q  and reload_wayA_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu29_wayA_upd(0) <=  p1_way_data_upd29_wayA   and p1_wren_q;
rel_bixu29_wayA_upd(1) <=  p0_way_data_upd29_wayA   and p0_wren_q;
p0_way_data_upd29_wayB    <=  p0_congr_cl29_act_q  and binv_wayB_upd3_q;
p1_way_data_upd29_wayB    <=  p1_congr_cl29_act_q  and reload_wayB_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu29_wayB_upd(0) <=  p1_way_data_upd29_wayB   and p1_wren_q;
rel_bixu29_wayB_upd(1) <=  p0_way_data_upd29_wayB   and p0_wren_q;
p0_way_data_upd29_wayC    <=  p0_congr_cl29_act_q  and binv_wayC_upd3_q;
p1_way_data_upd29_wayC    <=  p1_congr_cl29_act_q  and reload_wayC_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu29_wayC_upd(0) <=  p1_way_data_upd29_wayC   and p1_wren_q;
rel_bixu29_wayC_upd(1) <=  p0_way_data_upd29_wayC   and p0_wren_q;
p0_way_data_upd29_wayD    <=  p0_congr_cl29_act_q  and binv_wayD_upd3_q;
p1_way_data_upd29_wayD    <=  p1_congr_cl29_act_q  and reload_wayD_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu29_wayD_upd(0) <=  p1_way_data_upd29_wayD   and p1_wren_q;
rel_bixu29_wayD_upd(1) <=  p0_way_data_upd29_wayD   and p0_wren_q;
p0_way_data_upd29_wayE    <=  p0_congr_cl29_act_q  and binv_wayE_upd3_q;
p1_way_data_upd29_wayE    <=  p1_congr_cl29_act_q  and reload_wayE_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu29_wayE_upd(0) <=  p1_way_data_upd29_wayE   and p1_wren_q;
rel_bixu29_wayE_upd(1) <=  p0_way_data_upd29_wayE   and p0_wren_q;
p0_way_data_upd29_wayF    <=  p0_congr_cl29_act_q  and binv_wayF_upd3_q;
p1_way_data_upd29_wayF    <=  p1_congr_cl29_act_q  and reload_wayF_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu29_wayF_upd(0) <=  p1_way_data_upd29_wayF   and p1_wren_q;
rel_bixu29_wayF_upd(1) <=  p0_way_data_upd29_wayF   and p0_wren_q;
p0_way_data_upd29_wayG    <=  p0_congr_cl29_act_q  and binv_wayG_upd3_q;
p1_way_data_upd29_wayG    <=  p1_congr_cl29_act_q  and reload_wayG_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu29_wayG_upd(0) <=  p1_way_data_upd29_wayG   and p1_wren_q;
rel_bixu29_wayG_upd(1) <=  p0_way_data_upd29_wayG   and p0_wren_q;
p0_way_data_upd29_wayH    <=  p0_congr_cl29_act_q  and binv_wayH_upd3_q;
p1_way_data_upd29_wayH    <=  p1_congr_cl29_act_q  and reload_wayH_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu29_wayH_upd(0) <=  p1_way_data_upd29_wayH   and p1_wren_q;
rel_bixu29_wayH_upd(1) <=  p0_way_data_upd29_wayH   and p0_wren_q;
-- Congruence Class Match
p0_congr_cl30_m       <=  (ex5_congr_cl_q    = tconv(30,6));
p1_congr_cl30_m       <=  (relu_s_congr_cl_q = tconv(30,6));
-- Act Pin to Directory Latches for specific congruence class
p0_congr_cl30_act_d   <=  p0_congr_cl30_m  and (back_inval_stg5_q or ex5_xuop_val_q or ex5_dir_err_val_q);
p1_congr_cl30_act_d   <=  p1_congr_cl30_m  and rel_port_wren_q;
congr_cl30_act        <=  p0_congr_cl30_act_q  or p1_congr_cl30_act_q  or congr_cl_all_act_q;
p0_way_data_upd30_wayA    <=  p0_congr_cl30_act_q  and binv_wayA_upd3_q;
p1_way_data_upd30_wayA    <=  p1_congr_cl30_act_q  and reload_wayA_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu30_wayA_upd(0) <=  p1_way_data_upd30_wayA   and p1_wren_q;
rel_bixu30_wayA_upd(1) <=  p0_way_data_upd30_wayA   and p0_wren_q;
p0_way_data_upd30_wayB    <=  p0_congr_cl30_act_q  and binv_wayB_upd3_q;
p1_way_data_upd30_wayB    <=  p1_congr_cl30_act_q  and reload_wayB_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu30_wayB_upd(0) <=  p1_way_data_upd30_wayB   and p1_wren_q;
rel_bixu30_wayB_upd(1) <=  p0_way_data_upd30_wayB   and p0_wren_q;
p0_way_data_upd30_wayC    <=  p0_congr_cl30_act_q  and binv_wayC_upd3_q;
p1_way_data_upd30_wayC    <=  p1_congr_cl30_act_q  and reload_wayC_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu30_wayC_upd(0) <=  p1_way_data_upd30_wayC   and p1_wren_q;
rel_bixu30_wayC_upd(1) <=  p0_way_data_upd30_wayC   and p0_wren_q;
p0_way_data_upd30_wayD    <=  p0_congr_cl30_act_q  and binv_wayD_upd3_q;
p1_way_data_upd30_wayD    <=  p1_congr_cl30_act_q  and reload_wayD_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu30_wayD_upd(0) <=  p1_way_data_upd30_wayD   and p1_wren_q;
rel_bixu30_wayD_upd(1) <=  p0_way_data_upd30_wayD   and p0_wren_q;
p0_way_data_upd30_wayE    <=  p0_congr_cl30_act_q  and binv_wayE_upd3_q;
p1_way_data_upd30_wayE    <=  p1_congr_cl30_act_q  and reload_wayE_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu30_wayE_upd(0) <=  p1_way_data_upd30_wayE   and p1_wren_q;
rel_bixu30_wayE_upd(1) <=  p0_way_data_upd30_wayE   and p0_wren_q;
p0_way_data_upd30_wayF    <=  p0_congr_cl30_act_q  and binv_wayF_upd3_q;
p1_way_data_upd30_wayF    <=  p1_congr_cl30_act_q  and reload_wayF_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu30_wayF_upd(0) <=  p1_way_data_upd30_wayF   and p1_wren_q;
rel_bixu30_wayF_upd(1) <=  p0_way_data_upd30_wayF   and p0_wren_q;
p0_way_data_upd30_wayG    <=  p0_congr_cl30_act_q  and binv_wayG_upd3_q;
p1_way_data_upd30_wayG    <=  p1_congr_cl30_act_q  and reload_wayG_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu30_wayG_upd(0) <=  p1_way_data_upd30_wayG   and p1_wren_q;
rel_bixu30_wayG_upd(1) <=  p0_way_data_upd30_wayG   and p0_wren_q;
p0_way_data_upd30_wayH    <=  p0_congr_cl30_act_q  and binv_wayH_upd3_q;
p1_way_data_upd30_wayH    <=  p1_congr_cl30_act_q  and reload_wayH_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu30_wayH_upd(0) <=  p1_way_data_upd30_wayH   and p1_wren_q;
rel_bixu30_wayH_upd(1) <=  p0_way_data_upd30_wayH   and p0_wren_q;
-- Congruence Class Match
p0_congr_cl31_m       <=  (ex5_congr_cl_q    = tconv(31,6));
p1_congr_cl31_m       <=  (relu_s_congr_cl_q = tconv(31,6));
-- Act Pin to Directory Latches for specific congruence class
p0_congr_cl31_act_d   <=  p0_congr_cl31_m  and (back_inval_stg5_q or ex5_xuop_val_q or ex5_dir_err_val_q);
p1_congr_cl31_act_d   <=  p1_congr_cl31_m  and rel_port_wren_q;
congr_cl31_act        <=  p0_congr_cl31_act_q  or p1_congr_cl31_act_q  or congr_cl_all_act_q;
p0_way_data_upd31_wayA    <=  p0_congr_cl31_act_q  and binv_wayA_upd3_q;
p1_way_data_upd31_wayA    <=  p1_congr_cl31_act_q  and reload_wayA_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu31_wayA_upd(0) <=  p1_way_data_upd31_wayA   and p1_wren_q;
rel_bixu31_wayA_upd(1) <=  p0_way_data_upd31_wayA   and p0_wren_q;
p0_way_data_upd31_wayB    <=  p0_congr_cl31_act_q  and binv_wayB_upd3_q;
p1_way_data_upd31_wayB    <=  p1_congr_cl31_act_q  and reload_wayB_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu31_wayB_upd(0) <=  p1_way_data_upd31_wayB   and p1_wren_q;
rel_bixu31_wayB_upd(1) <=  p0_way_data_upd31_wayB   and p0_wren_q;
p0_way_data_upd31_wayC    <=  p0_congr_cl31_act_q  and binv_wayC_upd3_q;
p1_way_data_upd31_wayC    <=  p1_congr_cl31_act_q  and reload_wayC_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu31_wayC_upd(0) <=  p1_way_data_upd31_wayC   and p1_wren_q;
rel_bixu31_wayC_upd(1) <=  p0_way_data_upd31_wayC   and p0_wren_q;
p0_way_data_upd31_wayD    <=  p0_congr_cl31_act_q  and binv_wayD_upd3_q;
p1_way_data_upd31_wayD    <=  p1_congr_cl31_act_q  and reload_wayD_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu31_wayD_upd(0) <=  p1_way_data_upd31_wayD   and p1_wren_q;
rel_bixu31_wayD_upd(1) <=  p0_way_data_upd31_wayD   and p0_wren_q;
p0_way_data_upd31_wayE    <=  p0_congr_cl31_act_q  and binv_wayE_upd3_q;
p1_way_data_upd31_wayE    <=  p1_congr_cl31_act_q  and reload_wayE_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu31_wayE_upd(0) <=  p1_way_data_upd31_wayE   and p1_wren_q;
rel_bixu31_wayE_upd(1) <=  p0_way_data_upd31_wayE   and p0_wren_q;
p0_way_data_upd31_wayF    <=  p0_congr_cl31_act_q  and binv_wayF_upd3_q;
p1_way_data_upd31_wayF    <=  p1_congr_cl31_act_q  and reload_wayF_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu31_wayF_upd(0) <=  p1_way_data_upd31_wayF   and p1_wren_q;
rel_bixu31_wayF_upd(1) <=  p0_way_data_upd31_wayF   and p0_wren_q;
p0_way_data_upd31_wayG    <=  p0_congr_cl31_act_q  and binv_wayG_upd3_q;
p1_way_data_upd31_wayG    <=  p1_congr_cl31_act_q  and reload_wayG_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu31_wayG_upd(0) <=  p1_way_data_upd31_wayG   and p1_wren_q;
rel_bixu31_wayG_upd(1) <=  p0_way_data_upd31_wayG   and p0_wren_q;
p0_way_data_upd31_wayH    <=  p0_congr_cl31_act_q  and binv_wayH_upd3_q;
p1_way_data_upd31_wayH    <=  p1_congr_cl31_act_q  and reload_wayH_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu31_wayH_upd(0) <=  p1_way_data_upd31_wayH   and p1_wren_q;
rel_bixu31_wayH_upd(1) <=  p0_way_data_upd31_wayH   and p0_wren_q;
-- Congruence Class Match
p0_congr_cl32_m       <=  (ex5_congr_cl_q    = tconv(32,6));
p1_congr_cl32_m       <=  (relu_s_congr_cl_q = tconv(32,6));
-- Act Pin to Directory Latches for specific congruence class
p0_congr_cl32_act_d   <=  p0_congr_cl32_m  and (back_inval_stg5_q or ex5_xuop_val_q or ex5_dir_err_val_q);
p1_congr_cl32_act_d   <=  p1_congr_cl32_m  and rel_port_wren_q;
congr_cl32_act        <=  p0_congr_cl32_act_q  or p1_congr_cl32_act_q  or congr_cl_all_act_q;
p0_way_data_upd32_wayA    <=  p0_congr_cl32_act_q  and binv_wayA_upd3_q;
p1_way_data_upd32_wayA    <=  p1_congr_cl32_act_q  and reload_wayA_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu32_wayA_upd(0) <=  p1_way_data_upd32_wayA   and p1_wren_q;
rel_bixu32_wayA_upd(1) <=  p0_way_data_upd32_wayA   and p0_wren_q;
p0_way_data_upd32_wayB    <=  p0_congr_cl32_act_q  and binv_wayB_upd3_q;
p1_way_data_upd32_wayB    <=  p1_congr_cl32_act_q  and reload_wayB_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu32_wayB_upd(0) <=  p1_way_data_upd32_wayB   and p1_wren_q;
rel_bixu32_wayB_upd(1) <=  p0_way_data_upd32_wayB   and p0_wren_q;
p0_way_data_upd32_wayC    <=  p0_congr_cl32_act_q  and binv_wayC_upd3_q;
p1_way_data_upd32_wayC    <=  p1_congr_cl32_act_q  and reload_wayC_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu32_wayC_upd(0) <=  p1_way_data_upd32_wayC   and p1_wren_q;
rel_bixu32_wayC_upd(1) <=  p0_way_data_upd32_wayC   and p0_wren_q;
p0_way_data_upd32_wayD    <=  p0_congr_cl32_act_q  and binv_wayD_upd3_q;
p1_way_data_upd32_wayD    <=  p1_congr_cl32_act_q  and reload_wayD_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu32_wayD_upd(0) <=  p1_way_data_upd32_wayD   and p1_wren_q;
rel_bixu32_wayD_upd(1) <=  p0_way_data_upd32_wayD   and p0_wren_q;
p0_way_data_upd32_wayE    <=  p0_congr_cl32_act_q  and binv_wayE_upd3_q;
p1_way_data_upd32_wayE    <=  p1_congr_cl32_act_q  and reload_wayE_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu32_wayE_upd(0) <=  p1_way_data_upd32_wayE   and p1_wren_q;
rel_bixu32_wayE_upd(1) <=  p0_way_data_upd32_wayE   and p0_wren_q;
p0_way_data_upd32_wayF    <=  p0_congr_cl32_act_q  and binv_wayF_upd3_q;
p1_way_data_upd32_wayF    <=  p1_congr_cl32_act_q  and reload_wayF_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu32_wayF_upd(0) <=  p1_way_data_upd32_wayF   and p1_wren_q;
rel_bixu32_wayF_upd(1) <=  p0_way_data_upd32_wayF   and p0_wren_q;
p0_way_data_upd32_wayG    <=  p0_congr_cl32_act_q  and binv_wayG_upd3_q;
p1_way_data_upd32_wayG    <=  p1_congr_cl32_act_q  and reload_wayG_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu32_wayG_upd(0) <=  p1_way_data_upd32_wayG   and p1_wren_q;
rel_bixu32_wayG_upd(1) <=  p0_way_data_upd32_wayG   and p0_wren_q;
p0_way_data_upd32_wayH    <=  p0_congr_cl32_act_q  and binv_wayH_upd3_q;
p1_way_data_upd32_wayH    <=  p1_congr_cl32_act_q  and reload_wayH_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu32_wayH_upd(0) <=  p1_way_data_upd32_wayH   and p1_wren_q;
rel_bixu32_wayH_upd(1) <=  p0_way_data_upd32_wayH   and p0_wren_q;
-- Congruence Class Match
p0_congr_cl33_m       <=  (ex5_congr_cl_q    = tconv(33,6));
p1_congr_cl33_m       <=  (relu_s_congr_cl_q = tconv(33,6));
-- Act Pin to Directory Latches for specific congruence class
p0_congr_cl33_act_d   <=  p0_congr_cl33_m  and (back_inval_stg5_q or ex5_xuop_val_q or ex5_dir_err_val_q);
p1_congr_cl33_act_d   <=  p1_congr_cl33_m  and rel_port_wren_q;
congr_cl33_act        <=  p0_congr_cl33_act_q  or p1_congr_cl33_act_q  or congr_cl_all_act_q;
p0_way_data_upd33_wayA    <=  p0_congr_cl33_act_q  and binv_wayA_upd3_q;
p1_way_data_upd33_wayA    <=  p1_congr_cl33_act_q  and reload_wayA_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu33_wayA_upd(0) <=  p1_way_data_upd33_wayA   and p1_wren_q;
rel_bixu33_wayA_upd(1) <=  p0_way_data_upd33_wayA   and p0_wren_q;
p0_way_data_upd33_wayB    <=  p0_congr_cl33_act_q  and binv_wayB_upd3_q;
p1_way_data_upd33_wayB    <=  p1_congr_cl33_act_q  and reload_wayB_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu33_wayB_upd(0) <=  p1_way_data_upd33_wayB   and p1_wren_q;
rel_bixu33_wayB_upd(1) <=  p0_way_data_upd33_wayB   and p0_wren_q;
p0_way_data_upd33_wayC    <=  p0_congr_cl33_act_q  and binv_wayC_upd3_q;
p1_way_data_upd33_wayC    <=  p1_congr_cl33_act_q  and reload_wayC_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu33_wayC_upd(0) <=  p1_way_data_upd33_wayC   and p1_wren_q;
rel_bixu33_wayC_upd(1) <=  p0_way_data_upd33_wayC   and p0_wren_q;
p0_way_data_upd33_wayD    <=  p0_congr_cl33_act_q  and binv_wayD_upd3_q;
p1_way_data_upd33_wayD    <=  p1_congr_cl33_act_q  and reload_wayD_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu33_wayD_upd(0) <=  p1_way_data_upd33_wayD   and p1_wren_q;
rel_bixu33_wayD_upd(1) <=  p0_way_data_upd33_wayD   and p0_wren_q;
p0_way_data_upd33_wayE    <=  p0_congr_cl33_act_q  and binv_wayE_upd3_q;
p1_way_data_upd33_wayE    <=  p1_congr_cl33_act_q  and reload_wayE_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu33_wayE_upd(0) <=  p1_way_data_upd33_wayE   and p1_wren_q;
rel_bixu33_wayE_upd(1) <=  p0_way_data_upd33_wayE   and p0_wren_q;
p0_way_data_upd33_wayF    <=  p0_congr_cl33_act_q  and binv_wayF_upd3_q;
p1_way_data_upd33_wayF    <=  p1_congr_cl33_act_q  and reload_wayF_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu33_wayF_upd(0) <=  p1_way_data_upd33_wayF   and p1_wren_q;
rel_bixu33_wayF_upd(1) <=  p0_way_data_upd33_wayF   and p0_wren_q;
p0_way_data_upd33_wayG    <=  p0_congr_cl33_act_q  and binv_wayG_upd3_q;
p1_way_data_upd33_wayG    <=  p1_congr_cl33_act_q  and reload_wayG_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu33_wayG_upd(0) <=  p1_way_data_upd33_wayG   and p1_wren_q;
rel_bixu33_wayG_upd(1) <=  p0_way_data_upd33_wayG   and p0_wren_q;
p0_way_data_upd33_wayH    <=  p0_congr_cl33_act_q  and binv_wayH_upd3_q;
p1_way_data_upd33_wayH    <=  p1_congr_cl33_act_q  and reload_wayH_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu33_wayH_upd(0) <=  p1_way_data_upd33_wayH   and p1_wren_q;
rel_bixu33_wayH_upd(1) <=  p0_way_data_upd33_wayH   and p0_wren_q;
-- Congruence Class Match
p0_congr_cl34_m       <=  (ex5_congr_cl_q    = tconv(34,6));
p1_congr_cl34_m       <=  (relu_s_congr_cl_q = tconv(34,6));
-- Act Pin to Directory Latches for specific congruence class
p0_congr_cl34_act_d   <=  p0_congr_cl34_m  and (back_inval_stg5_q or ex5_xuop_val_q or ex5_dir_err_val_q);
p1_congr_cl34_act_d   <=  p1_congr_cl34_m  and rel_port_wren_q;
congr_cl34_act        <=  p0_congr_cl34_act_q  or p1_congr_cl34_act_q  or congr_cl_all_act_q;
p0_way_data_upd34_wayA    <=  p0_congr_cl34_act_q  and binv_wayA_upd3_q;
p1_way_data_upd34_wayA    <=  p1_congr_cl34_act_q  and reload_wayA_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu34_wayA_upd(0) <=  p1_way_data_upd34_wayA   and p1_wren_q;
rel_bixu34_wayA_upd(1) <=  p0_way_data_upd34_wayA   and p0_wren_q;
p0_way_data_upd34_wayB    <=  p0_congr_cl34_act_q  and binv_wayB_upd3_q;
p1_way_data_upd34_wayB    <=  p1_congr_cl34_act_q  and reload_wayB_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu34_wayB_upd(0) <=  p1_way_data_upd34_wayB   and p1_wren_q;
rel_bixu34_wayB_upd(1) <=  p0_way_data_upd34_wayB   and p0_wren_q;
p0_way_data_upd34_wayC    <=  p0_congr_cl34_act_q  and binv_wayC_upd3_q;
p1_way_data_upd34_wayC    <=  p1_congr_cl34_act_q  and reload_wayC_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu34_wayC_upd(0) <=  p1_way_data_upd34_wayC   and p1_wren_q;
rel_bixu34_wayC_upd(1) <=  p0_way_data_upd34_wayC   and p0_wren_q;
p0_way_data_upd34_wayD    <=  p0_congr_cl34_act_q  and binv_wayD_upd3_q;
p1_way_data_upd34_wayD    <=  p1_congr_cl34_act_q  and reload_wayD_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu34_wayD_upd(0) <=  p1_way_data_upd34_wayD   and p1_wren_q;
rel_bixu34_wayD_upd(1) <=  p0_way_data_upd34_wayD   and p0_wren_q;
p0_way_data_upd34_wayE    <=  p0_congr_cl34_act_q  and binv_wayE_upd3_q;
p1_way_data_upd34_wayE    <=  p1_congr_cl34_act_q  and reload_wayE_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu34_wayE_upd(0) <=  p1_way_data_upd34_wayE   and p1_wren_q;
rel_bixu34_wayE_upd(1) <=  p0_way_data_upd34_wayE   and p0_wren_q;
p0_way_data_upd34_wayF    <=  p0_congr_cl34_act_q  and binv_wayF_upd3_q;
p1_way_data_upd34_wayF    <=  p1_congr_cl34_act_q  and reload_wayF_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu34_wayF_upd(0) <=  p1_way_data_upd34_wayF   and p1_wren_q;
rel_bixu34_wayF_upd(1) <=  p0_way_data_upd34_wayF   and p0_wren_q;
p0_way_data_upd34_wayG    <=  p0_congr_cl34_act_q  and binv_wayG_upd3_q;
p1_way_data_upd34_wayG    <=  p1_congr_cl34_act_q  and reload_wayG_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu34_wayG_upd(0) <=  p1_way_data_upd34_wayG   and p1_wren_q;
rel_bixu34_wayG_upd(1) <=  p0_way_data_upd34_wayG   and p0_wren_q;
p0_way_data_upd34_wayH    <=  p0_congr_cl34_act_q  and binv_wayH_upd3_q;
p1_way_data_upd34_wayH    <=  p1_congr_cl34_act_q  and reload_wayH_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu34_wayH_upd(0) <=  p1_way_data_upd34_wayH   and p1_wren_q;
rel_bixu34_wayH_upd(1) <=  p0_way_data_upd34_wayH   and p0_wren_q;
-- Congruence Class Match
p0_congr_cl35_m       <=  (ex5_congr_cl_q    = tconv(35,6));
p1_congr_cl35_m       <=  (relu_s_congr_cl_q = tconv(35,6));
-- Act Pin to Directory Latches for specific congruence class
p0_congr_cl35_act_d   <=  p0_congr_cl35_m  and (back_inval_stg5_q or ex5_xuop_val_q or ex5_dir_err_val_q);
p1_congr_cl35_act_d   <=  p1_congr_cl35_m  and rel_port_wren_q;
congr_cl35_act        <=  p0_congr_cl35_act_q  or p1_congr_cl35_act_q  or congr_cl_all_act_q;
p0_way_data_upd35_wayA    <=  p0_congr_cl35_act_q  and binv_wayA_upd3_q;
p1_way_data_upd35_wayA    <=  p1_congr_cl35_act_q  and reload_wayA_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu35_wayA_upd(0) <=  p1_way_data_upd35_wayA   and p1_wren_q;
rel_bixu35_wayA_upd(1) <=  p0_way_data_upd35_wayA   and p0_wren_q;
p0_way_data_upd35_wayB    <=  p0_congr_cl35_act_q  and binv_wayB_upd3_q;
p1_way_data_upd35_wayB    <=  p1_congr_cl35_act_q  and reload_wayB_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu35_wayB_upd(0) <=  p1_way_data_upd35_wayB   and p1_wren_q;
rel_bixu35_wayB_upd(1) <=  p0_way_data_upd35_wayB   and p0_wren_q;
p0_way_data_upd35_wayC    <=  p0_congr_cl35_act_q  and binv_wayC_upd3_q;
p1_way_data_upd35_wayC    <=  p1_congr_cl35_act_q  and reload_wayC_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu35_wayC_upd(0) <=  p1_way_data_upd35_wayC   and p1_wren_q;
rel_bixu35_wayC_upd(1) <=  p0_way_data_upd35_wayC   and p0_wren_q;
p0_way_data_upd35_wayD    <=  p0_congr_cl35_act_q  and binv_wayD_upd3_q;
p1_way_data_upd35_wayD    <=  p1_congr_cl35_act_q  and reload_wayD_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu35_wayD_upd(0) <=  p1_way_data_upd35_wayD   and p1_wren_q;
rel_bixu35_wayD_upd(1) <=  p0_way_data_upd35_wayD   and p0_wren_q;
p0_way_data_upd35_wayE    <=  p0_congr_cl35_act_q  and binv_wayE_upd3_q;
p1_way_data_upd35_wayE    <=  p1_congr_cl35_act_q  and reload_wayE_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu35_wayE_upd(0) <=  p1_way_data_upd35_wayE   and p1_wren_q;
rel_bixu35_wayE_upd(1) <=  p0_way_data_upd35_wayE   and p0_wren_q;
p0_way_data_upd35_wayF    <=  p0_congr_cl35_act_q  and binv_wayF_upd3_q;
p1_way_data_upd35_wayF    <=  p1_congr_cl35_act_q  and reload_wayF_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu35_wayF_upd(0) <=  p1_way_data_upd35_wayF   and p1_wren_q;
rel_bixu35_wayF_upd(1) <=  p0_way_data_upd35_wayF   and p0_wren_q;
p0_way_data_upd35_wayG    <=  p0_congr_cl35_act_q  and binv_wayG_upd3_q;
p1_way_data_upd35_wayG    <=  p1_congr_cl35_act_q  and reload_wayG_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu35_wayG_upd(0) <=  p1_way_data_upd35_wayG   and p1_wren_q;
rel_bixu35_wayG_upd(1) <=  p0_way_data_upd35_wayG   and p0_wren_q;
p0_way_data_upd35_wayH    <=  p0_congr_cl35_act_q  and binv_wayH_upd3_q;
p1_way_data_upd35_wayH    <=  p1_congr_cl35_act_q  and reload_wayH_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu35_wayH_upd(0) <=  p1_way_data_upd35_wayH   and p1_wren_q;
rel_bixu35_wayH_upd(1) <=  p0_way_data_upd35_wayH   and p0_wren_q;
-- Congruence Class Match
p0_congr_cl36_m       <=  (ex5_congr_cl_q    = tconv(36,6));
p1_congr_cl36_m       <=  (relu_s_congr_cl_q = tconv(36,6));
-- Act Pin to Directory Latches for specific congruence class
p0_congr_cl36_act_d   <=  p0_congr_cl36_m  and (back_inval_stg5_q or ex5_xuop_val_q or ex5_dir_err_val_q);
p1_congr_cl36_act_d   <=  p1_congr_cl36_m  and rel_port_wren_q;
congr_cl36_act        <=  p0_congr_cl36_act_q  or p1_congr_cl36_act_q  or congr_cl_all_act_q;
p0_way_data_upd36_wayA    <=  p0_congr_cl36_act_q  and binv_wayA_upd3_q;
p1_way_data_upd36_wayA    <=  p1_congr_cl36_act_q  and reload_wayA_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu36_wayA_upd(0) <=  p1_way_data_upd36_wayA   and p1_wren_q;
rel_bixu36_wayA_upd(1) <=  p0_way_data_upd36_wayA   and p0_wren_q;
p0_way_data_upd36_wayB    <=  p0_congr_cl36_act_q  and binv_wayB_upd3_q;
p1_way_data_upd36_wayB    <=  p1_congr_cl36_act_q  and reload_wayB_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu36_wayB_upd(0) <=  p1_way_data_upd36_wayB   and p1_wren_q;
rel_bixu36_wayB_upd(1) <=  p0_way_data_upd36_wayB   and p0_wren_q;
p0_way_data_upd36_wayC    <=  p0_congr_cl36_act_q  and binv_wayC_upd3_q;
p1_way_data_upd36_wayC    <=  p1_congr_cl36_act_q  and reload_wayC_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu36_wayC_upd(0) <=  p1_way_data_upd36_wayC   and p1_wren_q;
rel_bixu36_wayC_upd(1) <=  p0_way_data_upd36_wayC   and p0_wren_q;
p0_way_data_upd36_wayD    <=  p0_congr_cl36_act_q  and binv_wayD_upd3_q;
p1_way_data_upd36_wayD    <=  p1_congr_cl36_act_q  and reload_wayD_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu36_wayD_upd(0) <=  p1_way_data_upd36_wayD   and p1_wren_q;
rel_bixu36_wayD_upd(1) <=  p0_way_data_upd36_wayD   and p0_wren_q;
p0_way_data_upd36_wayE    <=  p0_congr_cl36_act_q  and binv_wayE_upd3_q;
p1_way_data_upd36_wayE    <=  p1_congr_cl36_act_q  and reload_wayE_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu36_wayE_upd(0) <=  p1_way_data_upd36_wayE   and p1_wren_q;
rel_bixu36_wayE_upd(1) <=  p0_way_data_upd36_wayE   and p0_wren_q;
p0_way_data_upd36_wayF    <=  p0_congr_cl36_act_q  and binv_wayF_upd3_q;
p1_way_data_upd36_wayF    <=  p1_congr_cl36_act_q  and reload_wayF_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu36_wayF_upd(0) <=  p1_way_data_upd36_wayF   and p1_wren_q;
rel_bixu36_wayF_upd(1) <=  p0_way_data_upd36_wayF   and p0_wren_q;
p0_way_data_upd36_wayG    <=  p0_congr_cl36_act_q  and binv_wayG_upd3_q;
p1_way_data_upd36_wayG    <=  p1_congr_cl36_act_q  and reload_wayG_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu36_wayG_upd(0) <=  p1_way_data_upd36_wayG   and p1_wren_q;
rel_bixu36_wayG_upd(1) <=  p0_way_data_upd36_wayG   and p0_wren_q;
p0_way_data_upd36_wayH    <=  p0_congr_cl36_act_q  and binv_wayH_upd3_q;
p1_way_data_upd36_wayH    <=  p1_congr_cl36_act_q  and reload_wayH_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu36_wayH_upd(0) <=  p1_way_data_upd36_wayH   and p1_wren_q;
rel_bixu36_wayH_upd(1) <=  p0_way_data_upd36_wayH   and p0_wren_q;
-- Congruence Class Match
p0_congr_cl37_m       <=  (ex5_congr_cl_q    = tconv(37,6));
p1_congr_cl37_m       <=  (relu_s_congr_cl_q = tconv(37,6));
-- Act Pin to Directory Latches for specific congruence class
p0_congr_cl37_act_d   <=  p0_congr_cl37_m  and (back_inval_stg5_q or ex5_xuop_val_q or ex5_dir_err_val_q);
p1_congr_cl37_act_d   <=  p1_congr_cl37_m  and rel_port_wren_q;
congr_cl37_act        <=  p0_congr_cl37_act_q  or p1_congr_cl37_act_q  or congr_cl_all_act_q;
p0_way_data_upd37_wayA    <=  p0_congr_cl37_act_q  and binv_wayA_upd3_q;
p1_way_data_upd37_wayA    <=  p1_congr_cl37_act_q  and reload_wayA_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu37_wayA_upd(0) <=  p1_way_data_upd37_wayA   and p1_wren_q;
rel_bixu37_wayA_upd(1) <=  p0_way_data_upd37_wayA   and p0_wren_q;
p0_way_data_upd37_wayB    <=  p0_congr_cl37_act_q  and binv_wayB_upd3_q;
p1_way_data_upd37_wayB    <=  p1_congr_cl37_act_q  and reload_wayB_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu37_wayB_upd(0) <=  p1_way_data_upd37_wayB   and p1_wren_q;
rel_bixu37_wayB_upd(1) <=  p0_way_data_upd37_wayB   and p0_wren_q;
p0_way_data_upd37_wayC    <=  p0_congr_cl37_act_q  and binv_wayC_upd3_q;
p1_way_data_upd37_wayC    <=  p1_congr_cl37_act_q  and reload_wayC_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu37_wayC_upd(0) <=  p1_way_data_upd37_wayC   and p1_wren_q;
rel_bixu37_wayC_upd(1) <=  p0_way_data_upd37_wayC   and p0_wren_q;
p0_way_data_upd37_wayD    <=  p0_congr_cl37_act_q  and binv_wayD_upd3_q;
p1_way_data_upd37_wayD    <=  p1_congr_cl37_act_q  and reload_wayD_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu37_wayD_upd(0) <=  p1_way_data_upd37_wayD   and p1_wren_q;
rel_bixu37_wayD_upd(1) <=  p0_way_data_upd37_wayD   and p0_wren_q;
p0_way_data_upd37_wayE    <=  p0_congr_cl37_act_q  and binv_wayE_upd3_q;
p1_way_data_upd37_wayE    <=  p1_congr_cl37_act_q  and reload_wayE_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu37_wayE_upd(0) <=  p1_way_data_upd37_wayE   and p1_wren_q;
rel_bixu37_wayE_upd(1) <=  p0_way_data_upd37_wayE   and p0_wren_q;
p0_way_data_upd37_wayF    <=  p0_congr_cl37_act_q  and binv_wayF_upd3_q;
p1_way_data_upd37_wayF    <=  p1_congr_cl37_act_q  and reload_wayF_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu37_wayF_upd(0) <=  p1_way_data_upd37_wayF   and p1_wren_q;
rel_bixu37_wayF_upd(1) <=  p0_way_data_upd37_wayF   and p0_wren_q;
p0_way_data_upd37_wayG    <=  p0_congr_cl37_act_q  and binv_wayG_upd3_q;
p1_way_data_upd37_wayG    <=  p1_congr_cl37_act_q  and reload_wayG_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu37_wayG_upd(0) <=  p1_way_data_upd37_wayG   and p1_wren_q;
rel_bixu37_wayG_upd(1) <=  p0_way_data_upd37_wayG   and p0_wren_q;
p0_way_data_upd37_wayH    <=  p0_congr_cl37_act_q  and binv_wayH_upd3_q;
p1_way_data_upd37_wayH    <=  p1_congr_cl37_act_q  and reload_wayH_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu37_wayH_upd(0) <=  p1_way_data_upd37_wayH   and p1_wren_q;
rel_bixu37_wayH_upd(1) <=  p0_way_data_upd37_wayH   and p0_wren_q;
-- Congruence Class Match
p0_congr_cl38_m       <=  (ex5_congr_cl_q    = tconv(38,6));
p1_congr_cl38_m       <=  (relu_s_congr_cl_q = tconv(38,6));
-- Act Pin to Directory Latches for specific congruence class
p0_congr_cl38_act_d   <=  p0_congr_cl38_m  and (back_inval_stg5_q or ex5_xuop_val_q or ex5_dir_err_val_q);
p1_congr_cl38_act_d   <=  p1_congr_cl38_m  and rel_port_wren_q;
congr_cl38_act        <=  p0_congr_cl38_act_q  or p1_congr_cl38_act_q  or congr_cl_all_act_q;
p0_way_data_upd38_wayA    <=  p0_congr_cl38_act_q  and binv_wayA_upd3_q;
p1_way_data_upd38_wayA    <=  p1_congr_cl38_act_q  and reload_wayA_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu38_wayA_upd(0) <=  p1_way_data_upd38_wayA   and p1_wren_q;
rel_bixu38_wayA_upd(1) <=  p0_way_data_upd38_wayA   and p0_wren_q;
p0_way_data_upd38_wayB    <=  p0_congr_cl38_act_q  and binv_wayB_upd3_q;
p1_way_data_upd38_wayB    <=  p1_congr_cl38_act_q  and reload_wayB_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu38_wayB_upd(0) <=  p1_way_data_upd38_wayB   and p1_wren_q;
rel_bixu38_wayB_upd(1) <=  p0_way_data_upd38_wayB   and p0_wren_q;
p0_way_data_upd38_wayC    <=  p0_congr_cl38_act_q  and binv_wayC_upd3_q;
p1_way_data_upd38_wayC    <=  p1_congr_cl38_act_q  and reload_wayC_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu38_wayC_upd(0) <=  p1_way_data_upd38_wayC   and p1_wren_q;
rel_bixu38_wayC_upd(1) <=  p0_way_data_upd38_wayC   and p0_wren_q;
p0_way_data_upd38_wayD    <=  p0_congr_cl38_act_q  and binv_wayD_upd3_q;
p1_way_data_upd38_wayD    <=  p1_congr_cl38_act_q  and reload_wayD_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu38_wayD_upd(0) <=  p1_way_data_upd38_wayD   and p1_wren_q;
rel_bixu38_wayD_upd(1) <=  p0_way_data_upd38_wayD   and p0_wren_q;
p0_way_data_upd38_wayE    <=  p0_congr_cl38_act_q  and binv_wayE_upd3_q;
p1_way_data_upd38_wayE    <=  p1_congr_cl38_act_q  and reload_wayE_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu38_wayE_upd(0) <=  p1_way_data_upd38_wayE   and p1_wren_q;
rel_bixu38_wayE_upd(1) <=  p0_way_data_upd38_wayE   and p0_wren_q;
p0_way_data_upd38_wayF    <=  p0_congr_cl38_act_q  and binv_wayF_upd3_q;
p1_way_data_upd38_wayF    <=  p1_congr_cl38_act_q  and reload_wayF_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu38_wayF_upd(0) <=  p1_way_data_upd38_wayF   and p1_wren_q;
rel_bixu38_wayF_upd(1) <=  p0_way_data_upd38_wayF   and p0_wren_q;
p0_way_data_upd38_wayG    <=  p0_congr_cl38_act_q  and binv_wayG_upd3_q;
p1_way_data_upd38_wayG    <=  p1_congr_cl38_act_q  and reload_wayG_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu38_wayG_upd(0) <=  p1_way_data_upd38_wayG   and p1_wren_q;
rel_bixu38_wayG_upd(1) <=  p0_way_data_upd38_wayG   and p0_wren_q;
p0_way_data_upd38_wayH    <=  p0_congr_cl38_act_q  and binv_wayH_upd3_q;
p1_way_data_upd38_wayH    <=  p1_congr_cl38_act_q  and reload_wayH_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu38_wayH_upd(0) <=  p1_way_data_upd38_wayH   and p1_wren_q;
rel_bixu38_wayH_upd(1) <=  p0_way_data_upd38_wayH   and p0_wren_q;
-- Congruence Class Match
p0_congr_cl39_m       <=  (ex5_congr_cl_q    = tconv(39,6));
p1_congr_cl39_m       <=  (relu_s_congr_cl_q = tconv(39,6));
-- Act Pin to Directory Latches for specific congruence class
p0_congr_cl39_act_d   <=  p0_congr_cl39_m  and (back_inval_stg5_q or ex5_xuop_val_q or ex5_dir_err_val_q);
p1_congr_cl39_act_d   <=  p1_congr_cl39_m  and rel_port_wren_q;
congr_cl39_act        <=  p0_congr_cl39_act_q  or p1_congr_cl39_act_q  or congr_cl_all_act_q;
p0_way_data_upd39_wayA    <=  p0_congr_cl39_act_q  and binv_wayA_upd3_q;
p1_way_data_upd39_wayA    <=  p1_congr_cl39_act_q  and reload_wayA_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu39_wayA_upd(0) <=  p1_way_data_upd39_wayA   and p1_wren_q;
rel_bixu39_wayA_upd(1) <=  p0_way_data_upd39_wayA   and p0_wren_q;
p0_way_data_upd39_wayB    <=  p0_congr_cl39_act_q  and binv_wayB_upd3_q;
p1_way_data_upd39_wayB    <=  p1_congr_cl39_act_q  and reload_wayB_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu39_wayB_upd(0) <=  p1_way_data_upd39_wayB   and p1_wren_q;
rel_bixu39_wayB_upd(1) <=  p0_way_data_upd39_wayB   and p0_wren_q;
p0_way_data_upd39_wayC    <=  p0_congr_cl39_act_q  and binv_wayC_upd3_q;
p1_way_data_upd39_wayC    <=  p1_congr_cl39_act_q  and reload_wayC_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu39_wayC_upd(0) <=  p1_way_data_upd39_wayC   and p1_wren_q;
rel_bixu39_wayC_upd(1) <=  p0_way_data_upd39_wayC   and p0_wren_q;
p0_way_data_upd39_wayD    <=  p0_congr_cl39_act_q  and binv_wayD_upd3_q;
p1_way_data_upd39_wayD    <=  p1_congr_cl39_act_q  and reload_wayD_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu39_wayD_upd(0) <=  p1_way_data_upd39_wayD   and p1_wren_q;
rel_bixu39_wayD_upd(1) <=  p0_way_data_upd39_wayD   and p0_wren_q;
p0_way_data_upd39_wayE    <=  p0_congr_cl39_act_q  and binv_wayE_upd3_q;
p1_way_data_upd39_wayE    <=  p1_congr_cl39_act_q  and reload_wayE_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu39_wayE_upd(0) <=  p1_way_data_upd39_wayE   and p1_wren_q;
rel_bixu39_wayE_upd(1) <=  p0_way_data_upd39_wayE   and p0_wren_q;
p0_way_data_upd39_wayF    <=  p0_congr_cl39_act_q  and binv_wayF_upd3_q;
p1_way_data_upd39_wayF    <=  p1_congr_cl39_act_q  and reload_wayF_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu39_wayF_upd(0) <=  p1_way_data_upd39_wayF   and p1_wren_q;
rel_bixu39_wayF_upd(1) <=  p0_way_data_upd39_wayF   and p0_wren_q;
p0_way_data_upd39_wayG    <=  p0_congr_cl39_act_q  and binv_wayG_upd3_q;
p1_way_data_upd39_wayG    <=  p1_congr_cl39_act_q  and reload_wayG_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu39_wayG_upd(0) <=  p1_way_data_upd39_wayG   and p1_wren_q;
rel_bixu39_wayG_upd(1) <=  p0_way_data_upd39_wayG   and p0_wren_q;
p0_way_data_upd39_wayH    <=  p0_congr_cl39_act_q  and binv_wayH_upd3_q;
p1_way_data_upd39_wayH    <=  p1_congr_cl39_act_q  and reload_wayH_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu39_wayH_upd(0) <=  p1_way_data_upd39_wayH   and p1_wren_q;
rel_bixu39_wayH_upd(1) <=  p0_way_data_upd39_wayH   and p0_wren_q;
-- Congruence Class Match
p0_congr_cl40_m       <=  (ex5_congr_cl_q    = tconv(40,6));
p1_congr_cl40_m       <=  (relu_s_congr_cl_q = tconv(40,6));
-- Act Pin to Directory Latches for specific congruence class
p0_congr_cl40_act_d   <=  p0_congr_cl40_m  and (back_inval_stg5_q or ex5_xuop_val_q or ex5_dir_err_val_q);
p1_congr_cl40_act_d   <=  p1_congr_cl40_m  and rel_port_wren_q;
congr_cl40_act        <=  p0_congr_cl40_act_q  or p1_congr_cl40_act_q  or congr_cl_all_act_q;
p0_way_data_upd40_wayA    <=  p0_congr_cl40_act_q  and binv_wayA_upd3_q;
p1_way_data_upd40_wayA    <=  p1_congr_cl40_act_q  and reload_wayA_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu40_wayA_upd(0) <=  p1_way_data_upd40_wayA   and p1_wren_q;
rel_bixu40_wayA_upd(1) <=  p0_way_data_upd40_wayA   and p0_wren_q;
p0_way_data_upd40_wayB    <=  p0_congr_cl40_act_q  and binv_wayB_upd3_q;
p1_way_data_upd40_wayB    <=  p1_congr_cl40_act_q  and reload_wayB_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu40_wayB_upd(0) <=  p1_way_data_upd40_wayB   and p1_wren_q;
rel_bixu40_wayB_upd(1) <=  p0_way_data_upd40_wayB   and p0_wren_q;
p0_way_data_upd40_wayC    <=  p0_congr_cl40_act_q  and binv_wayC_upd3_q;
p1_way_data_upd40_wayC    <=  p1_congr_cl40_act_q  and reload_wayC_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu40_wayC_upd(0) <=  p1_way_data_upd40_wayC   and p1_wren_q;
rel_bixu40_wayC_upd(1) <=  p0_way_data_upd40_wayC   and p0_wren_q;
p0_way_data_upd40_wayD    <=  p0_congr_cl40_act_q  and binv_wayD_upd3_q;
p1_way_data_upd40_wayD    <=  p1_congr_cl40_act_q  and reload_wayD_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu40_wayD_upd(0) <=  p1_way_data_upd40_wayD   and p1_wren_q;
rel_bixu40_wayD_upd(1) <=  p0_way_data_upd40_wayD   and p0_wren_q;
p0_way_data_upd40_wayE    <=  p0_congr_cl40_act_q  and binv_wayE_upd3_q;
p1_way_data_upd40_wayE    <=  p1_congr_cl40_act_q  and reload_wayE_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu40_wayE_upd(0) <=  p1_way_data_upd40_wayE   and p1_wren_q;
rel_bixu40_wayE_upd(1) <=  p0_way_data_upd40_wayE   and p0_wren_q;
p0_way_data_upd40_wayF    <=  p0_congr_cl40_act_q  and binv_wayF_upd3_q;
p1_way_data_upd40_wayF    <=  p1_congr_cl40_act_q  and reload_wayF_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu40_wayF_upd(0) <=  p1_way_data_upd40_wayF   and p1_wren_q;
rel_bixu40_wayF_upd(1) <=  p0_way_data_upd40_wayF   and p0_wren_q;
p0_way_data_upd40_wayG    <=  p0_congr_cl40_act_q  and binv_wayG_upd3_q;
p1_way_data_upd40_wayG    <=  p1_congr_cl40_act_q  and reload_wayG_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu40_wayG_upd(0) <=  p1_way_data_upd40_wayG   and p1_wren_q;
rel_bixu40_wayG_upd(1) <=  p0_way_data_upd40_wayG   and p0_wren_q;
p0_way_data_upd40_wayH    <=  p0_congr_cl40_act_q  and binv_wayH_upd3_q;
p1_way_data_upd40_wayH    <=  p1_congr_cl40_act_q  and reload_wayH_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu40_wayH_upd(0) <=  p1_way_data_upd40_wayH   and p1_wren_q;
rel_bixu40_wayH_upd(1) <=  p0_way_data_upd40_wayH   and p0_wren_q;
-- Congruence Class Match
p0_congr_cl41_m       <=  (ex5_congr_cl_q    = tconv(41,6));
p1_congr_cl41_m       <=  (relu_s_congr_cl_q = tconv(41,6));
-- Act Pin to Directory Latches for specific congruence class
p0_congr_cl41_act_d   <=  p0_congr_cl41_m  and (back_inval_stg5_q or ex5_xuop_val_q or ex5_dir_err_val_q);
p1_congr_cl41_act_d   <=  p1_congr_cl41_m  and rel_port_wren_q;
congr_cl41_act        <=  p0_congr_cl41_act_q  or p1_congr_cl41_act_q  or congr_cl_all_act_q;
p0_way_data_upd41_wayA    <=  p0_congr_cl41_act_q  and binv_wayA_upd3_q;
p1_way_data_upd41_wayA    <=  p1_congr_cl41_act_q  and reload_wayA_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu41_wayA_upd(0) <=  p1_way_data_upd41_wayA   and p1_wren_q;
rel_bixu41_wayA_upd(1) <=  p0_way_data_upd41_wayA   and p0_wren_q;
p0_way_data_upd41_wayB    <=  p0_congr_cl41_act_q  and binv_wayB_upd3_q;
p1_way_data_upd41_wayB    <=  p1_congr_cl41_act_q  and reload_wayB_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu41_wayB_upd(0) <=  p1_way_data_upd41_wayB   and p1_wren_q;
rel_bixu41_wayB_upd(1) <=  p0_way_data_upd41_wayB   and p0_wren_q;
p0_way_data_upd41_wayC    <=  p0_congr_cl41_act_q  and binv_wayC_upd3_q;
p1_way_data_upd41_wayC    <=  p1_congr_cl41_act_q  and reload_wayC_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu41_wayC_upd(0) <=  p1_way_data_upd41_wayC   and p1_wren_q;
rel_bixu41_wayC_upd(1) <=  p0_way_data_upd41_wayC   and p0_wren_q;
p0_way_data_upd41_wayD    <=  p0_congr_cl41_act_q  and binv_wayD_upd3_q;
p1_way_data_upd41_wayD    <=  p1_congr_cl41_act_q  and reload_wayD_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu41_wayD_upd(0) <=  p1_way_data_upd41_wayD   and p1_wren_q;
rel_bixu41_wayD_upd(1) <=  p0_way_data_upd41_wayD   and p0_wren_q;
p0_way_data_upd41_wayE    <=  p0_congr_cl41_act_q  and binv_wayE_upd3_q;
p1_way_data_upd41_wayE    <=  p1_congr_cl41_act_q  and reload_wayE_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu41_wayE_upd(0) <=  p1_way_data_upd41_wayE   and p1_wren_q;
rel_bixu41_wayE_upd(1) <=  p0_way_data_upd41_wayE   and p0_wren_q;
p0_way_data_upd41_wayF    <=  p0_congr_cl41_act_q  and binv_wayF_upd3_q;
p1_way_data_upd41_wayF    <=  p1_congr_cl41_act_q  and reload_wayF_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu41_wayF_upd(0) <=  p1_way_data_upd41_wayF   and p1_wren_q;
rel_bixu41_wayF_upd(1) <=  p0_way_data_upd41_wayF   and p0_wren_q;
p0_way_data_upd41_wayG    <=  p0_congr_cl41_act_q  and binv_wayG_upd3_q;
p1_way_data_upd41_wayG    <=  p1_congr_cl41_act_q  and reload_wayG_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu41_wayG_upd(0) <=  p1_way_data_upd41_wayG   and p1_wren_q;
rel_bixu41_wayG_upd(1) <=  p0_way_data_upd41_wayG   and p0_wren_q;
p0_way_data_upd41_wayH    <=  p0_congr_cl41_act_q  and binv_wayH_upd3_q;
p1_way_data_upd41_wayH    <=  p1_congr_cl41_act_q  and reload_wayH_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu41_wayH_upd(0) <=  p1_way_data_upd41_wayH   and p1_wren_q;
rel_bixu41_wayH_upd(1) <=  p0_way_data_upd41_wayH   and p0_wren_q;
-- Congruence Class Match
p0_congr_cl42_m       <=  (ex5_congr_cl_q    = tconv(42,6));
p1_congr_cl42_m       <=  (relu_s_congr_cl_q = tconv(42,6));
-- Act Pin to Directory Latches for specific congruence class
p0_congr_cl42_act_d   <=  p0_congr_cl42_m  and (back_inval_stg5_q or ex5_xuop_val_q or ex5_dir_err_val_q);
p1_congr_cl42_act_d   <=  p1_congr_cl42_m  and rel_port_wren_q;
congr_cl42_act        <=  p0_congr_cl42_act_q  or p1_congr_cl42_act_q  or congr_cl_all_act_q;
p0_way_data_upd42_wayA    <=  p0_congr_cl42_act_q  and binv_wayA_upd3_q;
p1_way_data_upd42_wayA    <=  p1_congr_cl42_act_q  and reload_wayA_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu42_wayA_upd(0) <=  p1_way_data_upd42_wayA   and p1_wren_q;
rel_bixu42_wayA_upd(1) <=  p0_way_data_upd42_wayA   and p0_wren_q;
p0_way_data_upd42_wayB    <=  p0_congr_cl42_act_q  and binv_wayB_upd3_q;
p1_way_data_upd42_wayB    <=  p1_congr_cl42_act_q  and reload_wayB_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu42_wayB_upd(0) <=  p1_way_data_upd42_wayB   and p1_wren_q;
rel_bixu42_wayB_upd(1) <=  p0_way_data_upd42_wayB   and p0_wren_q;
p0_way_data_upd42_wayC    <=  p0_congr_cl42_act_q  and binv_wayC_upd3_q;
p1_way_data_upd42_wayC    <=  p1_congr_cl42_act_q  and reload_wayC_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu42_wayC_upd(0) <=  p1_way_data_upd42_wayC   and p1_wren_q;
rel_bixu42_wayC_upd(1) <=  p0_way_data_upd42_wayC   and p0_wren_q;
p0_way_data_upd42_wayD    <=  p0_congr_cl42_act_q  and binv_wayD_upd3_q;
p1_way_data_upd42_wayD    <=  p1_congr_cl42_act_q  and reload_wayD_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu42_wayD_upd(0) <=  p1_way_data_upd42_wayD   and p1_wren_q;
rel_bixu42_wayD_upd(1) <=  p0_way_data_upd42_wayD   and p0_wren_q;
p0_way_data_upd42_wayE    <=  p0_congr_cl42_act_q  and binv_wayE_upd3_q;
p1_way_data_upd42_wayE    <=  p1_congr_cl42_act_q  and reload_wayE_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu42_wayE_upd(0) <=  p1_way_data_upd42_wayE   and p1_wren_q;
rel_bixu42_wayE_upd(1) <=  p0_way_data_upd42_wayE   and p0_wren_q;
p0_way_data_upd42_wayF    <=  p0_congr_cl42_act_q  and binv_wayF_upd3_q;
p1_way_data_upd42_wayF    <=  p1_congr_cl42_act_q  and reload_wayF_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu42_wayF_upd(0) <=  p1_way_data_upd42_wayF   and p1_wren_q;
rel_bixu42_wayF_upd(1) <=  p0_way_data_upd42_wayF   and p0_wren_q;
p0_way_data_upd42_wayG    <=  p0_congr_cl42_act_q  and binv_wayG_upd3_q;
p1_way_data_upd42_wayG    <=  p1_congr_cl42_act_q  and reload_wayG_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu42_wayG_upd(0) <=  p1_way_data_upd42_wayG   and p1_wren_q;
rel_bixu42_wayG_upd(1) <=  p0_way_data_upd42_wayG   and p0_wren_q;
p0_way_data_upd42_wayH    <=  p0_congr_cl42_act_q  and binv_wayH_upd3_q;
p1_way_data_upd42_wayH    <=  p1_congr_cl42_act_q  and reload_wayH_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu42_wayH_upd(0) <=  p1_way_data_upd42_wayH   and p1_wren_q;
rel_bixu42_wayH_upd(1) <=  p0_way_data_upd42_wayH   and p0_wren_q;
-- Congruence Class Match
p0_congr_cl43_m       <=  (ex5_congr_cl_q    = tconv(43,6));
p1_congr_cl43_m       <=  (relu_s_congr_cl_q = tconv(43,6));
-- Act Pin to Directory Latches for specific congruence class
p0_congr_cl43_act_d   <=  p0_congr_cl43_m  and (back_inval_stg5_q or ex5_xuop_val_q or ex5_dir_err_val_q);
p1_congr_cl43_act_d   <=  p1_congr_cl43_m  and rel_port_wren_q;
congr_cl43_act        <=  p0_congr_cl43_act_q  or p1_congr_cl43_act_q  or congr_cl_all_act_q;
p0_way_data_upd43_wayA    <=  p0_congr_cl43_act_q  and binv_wayA_upd3_q;
p1_way_data_upd43_wayA    <=  p1_congr_cl43_act_q  and reload_wayA_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu43_wayA_upd(0) <=  p1_way_data_upd43_wayA   and p1_wren_q;
rel_bixu43_wayA_upd(1) <=  p0_way_data_upd43_wayA   and p0_wren_q;
p0_way_data_upd43_wayB    <=  p0_congr_cl43_act_q  and binv_wayB_upd3_q;
p1_way_data_upd43_wayB    <=  p1_congr_cl43_act_q  and reload_wayB_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu43_wayB_upd(0) <=  p1_way_data_upd43_wayB   and p1_wren_q;
rel_bixu43_wayB_upd(1) <=  p0_way_data_upd43_wayB   and p0_wren_q;
p0_way_data_upd43_wayC    <=  p0_congr_cl43_act_q  and binv_wayC_upd3_q;
p1_way_data_upd43_wayC    <=  p1_congr_cl43_act_q  and reload_wayC_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu43_wayC_upd(0) <=  p1_way_data_upd43_wayC   and p1_wren_q;
rel_bixu43_wayC_upd(1) <=  p0_way_data_upd43_wayC   and p0_wren_q;
p0_way_data_upd43_wayD    <=  p0_congr_cl43_act_q  and binv_wayD_upd3_q;
p1_way_data_upd43_wayD    <=  p1_congr_cl43_act_q  and reload_wayD_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu43_wayD_upd(0) <=  p1_way_data_upd43_wayD   and p1_wren_q;
rel_bixu43_wayD_upd(1) <=  p0_way_data_upd43_wayD   and p0_wren_q;
p0_way_data_upd43_wayE    <=  p0_congr_cl43_act_q  and binv_wayE_upd3_q;
p1_way_data_upd43_wayE    <=  p1_congr_cl43_act_q  and reload_wayE_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu43_wayE_upd(0) <=  p1_way_data_upd43_wayE   and p1_wren_q;
rel_bixu43_wayE_upd(1) <=  p0_way_data_upd43_wayE   and p0_wren_q;
p0_way_data_upd43_wayF    <=  p0_congr_cl43_act_q  and binv_wayF_upd3_q;
p1_way_data_upd43_wayF    <=  p1_congr_cl43_act_q  and reload_wayF_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu43_wayF_upd(0) <=  p1_way_data_upd43_wayF   and p1_wren_q;
rel_bixu43_wayF_upd(1) <=  p0_way_data_upd43_wayF   and p0_wren_q;
p0_way_data_upd43_wayG    <=  p0_congr_cl43_act_q  and binv_wayG_upd3_q;
p1_way_data_upd43_wayG    <=  p1_congr_cl43_act_q  and reload_wayG_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu43_wayG_upd(0) <=  p1_way_data_upd43_wayG   and p1_wren_q;
rel_bixu43_wayG_upd(1) <=  p0_way_data_upd43_wayG   and p0_wren_q;
p0_way_data_upd43_wayH    <=  p0_congr_cl43_act_q  and binv_wayH_upd3_q;
p1_way_data_upd43_wayH    <=  p1_congr_cl43_act_q  and reload_wayH_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu43_wayH_upd(0) <=  p1_way_data_upd43_wayH   and p1_wren_q;
rel_bixu43_wayH_upd(1) <=  p0_way_data_upd43_wayH   and p0_wren_q;
-- Congruence Class Match
p0_congr_cl44_m       <=  (ex5_congr_cl_q    = tconv(44,6));
p1_congr_cl44_m       <=  (relu_s_congr_cl_q = tconv(44,6));
-- Act Pin to Directory Latches for specific congruence class
p0_congr_cl44_act_d   <=  p0_congr_cl44_m  and (back_inval_stg5_q or ex5_xuop_val_q or ex5_dir_err_val_q);
p1_congr_cl44_act_d   <=  p1_congr_cl44_m  and rel_port_wren_q;
congr_cl44_act        <=  p0_congr_cl44_act_q  or p1_congr_cl44_act_q  or congr_cl_all_act_q;
p0_way_data_upd44_wayA    <=  p0_congr_cl44_act_q  and binv_wayA_upd3_q;
p1_way_data_upd44_wayA    <=  p1_congr_cl44_act_q  and reload_wayA_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu44_wayA_upd(0) <=  p1_way_data_upd44_wayA   and p1_wren_q;
rel_bixu44_wayA_upd(1) <=  p0_way_data_upd44_wayA   and p0_wren_q;
p0_way_data_upd44_wayB    <=  p0_congr_cl44_act_q  and binv_wayB_upd3_q;
p1_way_data_upd44_wayB    <=  p1_congr_cl44_act_q  and reload_wayB_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu44_wayB_upd(0) <=  p1_way_data_upd44_wayB   and p1_wren_q;
rel_bixu44_wayB_upd(1) <=  p0_way_data_upd44_wayB   and p0_wren_q;
p0_way_data_upd44_wayC    <=  p0_congr_cl44_act_q  and binv_wayC_upd3_q;
p1_way_data_upd44_wayC    <=  p1_congr_cl44_act_q  and reload_wayC_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu44_wayC_upd(0) <=  p1_way_data_upd44_wayC   and p1_wren_q;
rel_bixu44_wayC_upd(1) <=  p0_way_data_upd44_wayC   and p0_wren_q;
p0_way_data_upd44_wayD    <=  p0_congr_cl44_act_q  and binv_wayD_upd3_q;
p1_way_data_upd44_wayD    <=  p1_congr_cl44_act_q  and reload_wayD_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu44_wayD_upd(0) <=  p1_way_data_upd44_wayD   and p1_wren_q;
rel_bixu44_wayD_upd(1) <=  p0_way_data_upd44_wayD   and p0_wren_q;
p0_way_data_upd44_wayE    <=  p0_congr_cl44_act_q  and binv_wayE_upd3_q;
p1_way_data_upd44_wayE    <=  p1_congr_cl44_act_q  and reload_wayE_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu44_wayE_upd(0) <=  p1_way_data_upd44_wayE   and p1_wren_q;
rel_bixu44_wayE_upd(1) <=  p0_way_data_upd44_wayE   and p0_wren_q;
p0_way_data_upd44_wayF    <=  p0_congr_cl44_act_q  and binv_wayF_upd3_q;
p1_way_data_upd44_wayF    <=  p1_congr_cl44_act_q  and reload_wayF_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu44_wayF_upd(0) <=  p1_way_data_upd44_wayF   and p1_wren_q;
rel_bixu44_wayF_upd(1) <=  p0_way_data_upd44_wayF   and p0_wren_q;
p0_way_data_upd44_wayG    <=  p0_congr_cl44_act_q  and binv_wayG_upd3_q;
p1_way_data_upd44_wayG    <=  p1_congr_cl44_act_q  and reload_wayG_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu44_wayG_upd(0) <=  p1_way_data_upd44_wayG   and p1_wren_q;
rel_bixu44_wayG_upd(1) <=  p0_way_data_upd44_wayG   and p0_wren_q;
p0_way_data_upd44_wayH    <=  p0_congr_cl44_act_q  and binv_wayH_upd3_q;
p1_way_data_upd44_wayH    <=  p1_congr_cl44_act_q  and reload_wayH_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu44_wayH_upd(0) <=  p1_way_data_upd44_wayH   and p1_wren_q;
rel_bixu44_wayH_upd(1) <=  p0_way_data_upd44_wayH   and p0_wren_q;
-- Congruence Class Match
p0_congr_cl45_m       <=  (ex5_congr_cl_q    = tconv(45,6));
p1_congr_cl45_m       <=  (relu_s_congr_cl_q = tconv(45,6));
-- Act Pin to Directory Latches for specific congruence class
p0_congr_cl45_act_d   <=  p0_congr_cl45_m  and (back_inval_stg5_q or ex5_xuop_val_q or ex5_dir_err_val_q);
p1_congr_cl45_act_d   <=  p1_congr_cl45_m  and rel_port_wren_q;
congr_cl45_act        <=  p0_congr_cl45_act_q  or p1_congr_cl45_act_q  or congr_cl_all_act_q;
p0_way_data_upd45_wayA    <=  p0_congr_cl45_act_q  and binv_wayA_upd3_q;
p1_way_data_upd45_wayA    <=  p1_congr_cl45_act_q  and reload_wayA_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu45_wayA_upd(0) <=  p1_way_data_upd45_wayA   and p1_wren_q;
rel_bixu45_wayA_upd(1) <=  p0_way_data_upd45_wayA   and p0_wren_q;
p0_way_data_upd45_wayB    <=  p0_congr_cl45_act_q  and binv_wayB_upd3_q;
p1_way_data_upd45_wayB    <=  p1_congr_cl45_act_q  and reload_wayB_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu45_wayB_upd(0) <=  p1_way_data_upd45_wayB   and p1_wren_q;
rel_bixu45_wayB_upd(1) <=  p0_way_data_upd45_wayB   and p0_wren_q;
p0_way_data_upd45_wayC    <=  p0_congr_cl45_act_q  and binv_wayC_upd3_q;
p1_way_data_upd45_wayC    <=  p1_congr_cl45_act_q  and reload_wayC_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu45_wayC_upd(0) <=  p1_way_data_upd45_wayC   and p1_wren_q;
rel_bixu45_wayC_upd(1) <=  p0_way_data_upd45_wayC   and p0_wren_q;
p0_way_data_upd45_wayD    <=  p0_congr_cl45_act_q  and binv_wayD_upd3_q;
p1_way_data_upd45_wayD    <=  p1_congr_cl45_act_q  and reload_wayD_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu45_wayD_upd(0) <=  p1_way_data_upd45_wayD   and p1_wren_q;
rel_bixu45_wayD_upd(1) <=  p0_way_data_upd45_wayD   and p0_wren_q;
p0_way_data_upd45_wayE    <=  p0_congr_cl45_act_q  and binv_wayE_upd3_q;
p1_way_data_upd45_wayE    <=  p1_congr_cl45_act_q  and reload_wayE_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu45_wayE_upd(0) <=  p1_way_data_upd45_wayE   and p1_wren_q;
rel_bixu45_wayE_upd(1) <=  p0_way_data_upd45_wayE   and p0_wren_q;
p0_way_data_upd45_wayF    <=  p0_congr_cl45_act_q  and binv_wayF_upd3_q;
p1_way_data_upd45_wayF    <=  p1_congr_cl45_act_q  and reload_wayF_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu45_wayF_upd(0) <=  p1_way_data_upd45_wayF   and p1_wren_q;
rel_bixu45_wayF_upd(1) <=  p0_way_data_upd45_wayF   and p0_wren_q;
p0_way_data_upd45_wayG    <=  p0_congr_cl45_act_q  and binv_wayG_upd3_q;
p1_way_data_upd45_wayG    <=  p1_congr_cl45_act_q  and reload_wayG_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu45_wayG_upd(0) <=  p1_way_data_upd45_wayG   and p1_wren_q;
rel_bixu45_wayG_upd(1) <=  p0_way_data_upd45_wayG   and p0_wren_q;
p0_way_data_upd45_wayH    <=  p0_congr_cl45_act_q  and binv_wayH_upd3_q;
p1_way_data_upd45_wayH    <=  p1_congr_cl45_act_q  and reload_wayH_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu45_wayH_upd(0) <=  p1_way_data_upd45_wayH   and p1_wren_q;
rel_bixu45_wayH_upd(1) <=  p0_way_data_upd45_wayH   and p0_wren_q;
-- Congruence Class Match
p0_congr_cl46_m       <=  (ex5_congr_cl_q    = tconv(46,6));
p1_congr_cl46_m       <=  (relu_s_congr_cl_q = tconv(46,6));
-- Act Pin to Directory Latches for specific congruence class
p0_congr_cl46_act_d   <=  p0_congr_cl46_m  and (back_inval_stg5_q or ex5_xuop_val_q or ex5_dir_err_val_q);
p1_congr_cl46_act_d   <=  p1_congr_cl46_m  and rel_port_wren_q;
congr_cl46_act        <=  p0_congr_cl46_act_q  or p1_congr_cl46_act_q  or congr_cl_all_act_q;
p0_way_data_upd46_wayA    <=  p0_congr_cl46_act_q  and binv_wayA_upd3_q;
p1_way_data_upd46_wayA    <=  p1_congr_cl46_act_q  and reload_wayA_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu46_wayA_upd(0) <=  p1_way_data_upd46_wayA   and p1_wren_q;
rel_bixu46_wayA_upd(1) <=  p0_way_data_upd46_wayA   and p0_wren_q;
p0_way_data_upd46_wayB    <=  p0_congr_cl46_act_q  and binv_wayB_upd3_q;
p1_way_data_upd46_wayB    <=  p1_congr_cl46_act_q  and reload_wayB_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu46_wayB_upd(0) <=  p1_way_data_upd46_wayB   and p1_wren_q;
rel_bixu46_wayB_upd(1) <=  p0_way_data_upd46_wayB   and p0_wren_q;
p0_way_data_upd46_wayC    <=  p0_congr_cl46_act_q  and binv_wayC_upd3_q;
p1_way_data_upd46_wayC    <=  p1_congr_cl46_act_q  and reload_wayC_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu46_wayC_upd(0) <=  p1_way_data_upd46_wayC   and p1_wren_q;
rel_bixu46_wayC_upd(1) <=  p0_way_data_upd46_wayC   and p0_wren_q;
p0_way_data_upd46_wayD    <=  p0_congr_cl46_act_q  and binv_wayD_upd3_q;
p1_way_data_upd46_wayD    <=  p1_congr_cl46_act_q  and reload_wayD_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu46_wayD_upd(0) <=  p1_way_data_upd46_wayD   and p1_wren_q;
rel_bixu46_wayD_upd(1) <=  p0_way_data_upd46_wayD   and p0_wren_q;
p0_way_data_upd46_wayE    <=  p0_congr_cl46_act_q  and binv_wayE_upd3_q;
p1_way_data_upd46_wayE    <=  p1_congr_cl46_act_q  and reload_wayE_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu46_wayE_upd(0) <=  p1_way_data_upd46_wayE   and p1_wren_q;
rel_bixu46_wayE_upd(1) <=  p0_way_data_upd46_wayE   and p0_wren_q;
p0_way_data_upd46_wayF    <=  p0_congr_cl46_act_q  and binv_wayF_upd3_q;
p1_way_data_upd46_wayF    <=  p1_congr_cl46_act_q  and reload_wayF_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu46_wayF_upd(0) <=  p1_way_data_upd46_wayF   and p1_wren_q;
rel_bixu46_wayF_upd(1) <=  p0_way_data_upd46_wayF   and p0_wren_q;
p0_way_data_upd46_wayG    <=  p0_congr_cl46_act_q  and binv_wayG_upd3_q;
p1_way_data_upd46_wayG    <=  p1_congr_cl46_act_q  and reload_wayG_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu46_wayG_upd(0) <=  p1_way_data_upd46_wayG   and p1_wren_q;
rel_bixu46_wayG_upd(1) <=  p0_way_data_upd46_wayG   and p0_wren_q;
p0_way_data_upd46_wayH    <=  p0_congr_cl46_act_q  and binv_wayH_upd3_q;
p1_way_data_upd46_wayH    <=  p1_congr_cl46_act_q  and reload_wayH_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu46_wayH_upd(0) <=  p1_way_data_upd46_wayH   and p1_wren_q;
rel_bixu46_wayH_upd(1) <=  p0_way_data_upd46_wayH   and p0_wren_q;
-- Congruence Class Match
p0_congr_cl47_m       <=  (ex5_congr_cl_q    = tconv(47,6));
p1_congr_cl47_m       <=  (relu_s_congr_cl_q = tconv(47,6));
-- Act Pin to Directory Latches for specific congruence class
p0_congr_cl47_act_d   <=  p0_congr_cl47_m  and (back_inval_stg5_q or ex5_xuop_val_q or ex5_dir_err_val_q);
p1_congr_cl47_act_d   <=  p1_congr_cl47_m  and rel_port_wren_q;
congr_cl47_act        <=  p0_congr_cl47_act_q  or p1_congr_cl47_act_q  or congr_cl_all_act_q;
p0_way_data_upd47_wayA    <=  p0_congr_cl47_act_q  and binv_wayA_upd3_q;
p1_way_data_upd47_wayA    <=  p1_congr_cl47_act_q  and reload_wayA_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu47_wayA_upd(0) <=  p1_way_data_upd47_wayA   and p1_wren_q;
rel_bixu47_wayA_upd(1) <=  p0_way_data_upd47_wayA   and p0_wren_q;
p0_way_data_upd47_wayB    <=  p0_congr_cl47_act_q  and binv_wayB_upd3_q;
p1_way_data_upd47_wayB    <=  p1_congr_cl47_act_q  and reload_wayB_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu47_wayB_upd(0) <=  p1_way_data_upd47_wayB   and p1_wren_q;
rel_bixu47_wayB_upd(1) <=  p0_way_data_upd47_wayB   and p0_wren_q;
p0_way_data_upd47_wayC    <=  p0_congr_cl47_act_q  and binv_wayC_upd3_q;
p1_way_data_upd47_wayC    <=  p1_congr_cl47_act_q  and reload_wayC_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu47_wayC_upd(0) <=  p1_way_data_upd47_wayC   and p1_wren_q;
rel_bixu47_wayC_upd(1) <=  p0_way_data_upd47_wayC   and p0_wren_q;
p0_way_data_upd47_wayD    <=  p0_congr_cl47_act_q  and binv_wayD_upd3_q;
p1_way_data_upd47_wayD    <=  p1_congr_cl47_act_q  and reload_wayD_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu47_wayD_upd(0) <=  p1_way_data_upd47_wayD   and p1_wren_q;
rel_bixu47_wayD_upd(1) <=  p0_way_data_upd47_wayD   and p0_wren_q;
p0_way_data_upd47_wayE    <=  p0_congr_cl47_act_q  and binv_wayE_upd3_q;
p1_way_data_upd47_wayE    <=  p1_congr_cl47_act_q  and reload_wayE_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu47_wayE_upd(0) <=  p1_way_data_upd47_wayE   and p1_wren_q;
rel_bixu47_wayE_upd(1) <=  p0_way_data_upd47_wayE   and p0_wren_q;
p0_way_data_upd47_wayF    <=  p0_congr_cl47_act_q  and binv_wayF_upd3_q;
p1_way_data_upd47_wayF    <=  p1_congr_cl47_act_q  and reload_wayF_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu47_wayF_upd(0) <=  p1_way_data_upd47_wayF   and p1_wren_q;
rel_bixu47_wayF_upd(1) <=  p0_way_data_upd47_wayF   and p0_wren_q;
p0_way_data_upd47_wayG    <=  p0_congr_cl47_act_q  and binv_wayG_upd3_q;
p1_way_data_upd47_wayG    <=  p1_congr_cl47_act_q  and reload_wayG_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu47_wayG_upd(0) <=  p1_way_data_upd47_wayG   and p1_wren_q;
rel_bixu47_wayG_upd(1) <=  p0_way_data_upd47_wayG   and p0_wren_q;
p0_way_data_upd47_wayH    <=  p0_congr_cl47_act_q  and binv_wayH_upd3_q;
p1_way_data_upd47_wayH    <=  p1_congr_cl47_act_q  and reload_wayH_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu47_wayH_upd(0) <=  p1_way_data_upd47_wayH   and p1_wren_q;
rel_bixu47_wayH_upd(1) <=  p0_way_data_upd47_wayH   and p0_wren_q;
-- Congruence Class Match
p0_congr_cl48_m       <=  (ex5_congr_cl_q    = tconv(48,6));
p1_congr_cl48_m       <=  (relu_s_congr_cl_q = tconv(48,6));
-- Act Pin to Directory Latches for specific congruence class
p0_congr_cl48_act_d   <=  p0_congr_cl48_m  and (back_inval_stg5_q or ex5_xuop_val_q or ex5_dir_err_val_q);
p1_congr_cl48_act_d   <=  p1_congr_cl48_m  and rel_port_wren_q;
congr_cl48_act        <=  p0_congr_cl48_act_q  or p1_congr_cl48_act_q  or congr_cl_all_act_q;
p0_way_data_upd48_wayA    <=  p0_congr_cl48_act_q  and binv_wayA_upd3_q;
p1_way_data_upd48_wayA    <=  p1_congr_cl48_act_q  and reload_wayA_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu48_wayA_upd(0) <=  p1_way_data_upd48_wayA   and p1_wren_q;
rel_bixu48_wayA_upd(1) <=  p0_way_data_upd48_wayA   and p0_wren_q;
p0_way_data_upd48_wayB    <=  p0_congr_cl48_act_q  and binv_wayB_upd3_q;
p1_way_data_upd48_wayB    <=  p1_congr_cl48_act_q  and reload_wayB_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu48_wayB_upd(0) <=  p1_way_data_upd48_wayB   and p1_wren_q;
rel_bixu48_wayB_upd(1) <=  p0_way_data_upd48_wayB   and p0_wren_q;
p0_way_data_upd48_wayC    <=  p0_congr_cl48_act_q  and binv_wayC_upd3_q;
p1_way_data_upd48_wayC    <=  p1_congr_cl48_act_q  and reload_wayC_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu48_wayC_upd(0) <=  p1_way_data_upd48_wayC   and p1_wren_q;
rel_bixu48_wayC_upd(1) <=  p0_way_data_upd48_wayC   and p0_wren_q;
p0_way_data_upd48_wayD    <=  p0_congr_cl48_act_q  and binv_wayD_upd3_q;
p1_way_data_upd48_wayD    <=  p1_congr_cl48_act_q  and reload_wayD_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu48_wayD_upd(0) <=  p1_way_data_upd48_wayD   and p1_wren_q;
rel_bixu48_wayD_upd(1) <=  p0_way_data_upd48_wayD   and p0_wren_q;
p0_way_data_upd48_wayE    <=  p0_congr_cl48_act_q  and binv_wayE_upd3_q;
p1_way_data_upd48_wayE    <=  p1_congr_cl48_act_q  and reload_wayE_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu48_wayE_upd(0) <=  p1_way_data_upd48_wayE   and p1_wren_q;
rel_bixu48_wayE_upd(1) <=  p0_way_data_upd48_wayE   and p0_wren_q;
p0_way_data_upd48_wayF    <=  p0_congr_cl48_act_q  and binv_wayF_upd3_q;
p1_way_data_upd48_wayF    <=  p1_congr_cl48_act_q  and reload_wayF_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu48_wayF_upd(0) <=  p1_way_data_upd48_wayF   and p1_wren_q;
rel_bixu48_wayF_upd(1) <=  p0_way_data_upd48_wayF   and p0_wren_q;
p0_way_data_upd48_wayG    <=  p0_congr_cl48_act_q  and binv_wayG_upd3_q;
p1_way_data_upd48_wayG    <=  p1_congr_cl48_act_q  and reload_wayG_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu48_wayG_upd(0) <=  p1_way_data_upd48_wayG   and p1_wren_q;
rel_bixu48_wayG_upd(1) <=  p0_way_data_upd48_wayG   and p0_wren_q;
p0_way_data_upd48_wayH    <=  p0_congr_cl48_act_q  and binv_wayH_upd3_q;
p1_way_data_upd48_wayH    <=  p1_congr_cl48_act_q  and reload_wayH_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu48_wayH_upd(0) <=  p1_way_data_upd48_wayH   and p1_wren_q;
rel_bixu48_wayH_upd(1) <=  p0_way_data_upd48_wayH   and p0_wren_q;
-- Congruence Class Match
p0_congr_cl49_m       <=  (ex5_congr_cl_q    = tconv(49,6));
p1_congr_cl49_m       <=  (relu_s_congr_cl_q = tconv(49,6));
-- Act Pin to Directory Latches for specific congruence class
p0_congr_cl49_act_d   <=  p0_congr_cl49_m  and (back_inval_stg5_q or ex5_xuop_val_q or ex5_dir_err_val_q);
p1_congr_cl49_act_d   <=  p1_congr_cl49_m  and rel_port_wren_q;
congr_cl49_act        <=  p0_congr_cl49_act_q  or p1_congr_cl49_act_q  or congr_cl_all_act_q;
p0_way_data_upd49_wayA    <=  p0_congr_cl49_act_q  and binv_wayA_upd3_q;
p1_way_data_upd49_wayA    <=  p1_congr_cl49_act_q  and reload_wayA_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu49_wayA_upd(0) <=  p1_way_data_upd49_wayA   and p1_wren_q;
rel_bixu49_wayA_upd(1) <=  p0_way_data_upd49_wayA   and p0_wren_q;
p0_way_data_upd49_wayB    <=  p0_congr_cl49_act_q  and binv_wayB_upd3_q;
p1_way_data_upd49_wayB    <=  p1_congr_cl49_act_q  and reload_wayB_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu49_wayB_upd(0) <=  p1_way_data_upd49_wayB   and p1_wren_q;
rel_bixu49_wayB_upd(1) <=  p0_way_data_upd49_wayB   and p0_wren_q;
p0_way_data_upd49_wayC    <=  p0_congr_cl49_act_q  and binv_wayC_upd3_q;
p1_way_data_upd49_wayC    <=  p1_congr_cl49_act_q  and reload_wayC_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu49_wayC_upd(0) <=  p1_way_data_upd49_wayC   and p1_wren_q;
rel_bixu49_wayC_upd(1) <=  p0_way_data_upd49_wayC   and p0_wren_q;
p0_way_data_upd49_wayD    <=  p0_congr_cl49_act_q  and binv_wayD_upd3_q;
p1_way_data_upd49_wayD    <=  p1_congr_cl49_act_q  and reload_wayD_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu49_wayD_upd(0) <=  p1_way_data_upd49_wayD   and p1_wren_q;
rel_bixu49_wayD_upd(1) <=  p0_way_data_upd49_wayD   and p0_wren_q;
p0_way_data_upd49_wayE    <=  p0_congr_cl49_act_q  and binv_wayE_upd3_q;
p1_way_data_upd49_wayE    <=  p1_congr_cl49_act_q  and reload_wayE_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu49_wayE_upd(0) <=  p1_way_data_upd49_wayE   and p1_wren_q;
rel_bixu49_wayE_upd(1) <=  p0_way_data_upd49_wayE   and p0_wren_q;
p0_way_data_upd49_wayF    <=  p0_congr_cl49_act_q  and binv_wayF_upd3_q;
p1_way_data_upd49_wayF    <=  p1_congr_cl49_act_q  and reload_wayF_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu49_wayF_upd(0) <=  p1_way_data_upd49_wayF   and p1_wren_q;
rel_bixu49_wayF_upd(1) <=  p0_way_data_upd49_wayF   and p0_wren_q;
p0_way_data_upd49_wayG    <=  p0_congr_cl49_act_q  and binv_wayG_upd3_q;
p1_way_data_upd49_wayG    <=  p1_congr_cl49_act_q  and reload_wayG_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu49_wayG_upd(0) <=  p1_way_data_upd49_wayG   and p1_wren_q;
rel_bixu49_wayG_upd(1) <=  p0_way_data_upd49_wayG   and p0_wren_q;
p0_way_data_upd49_wayH    <=  p0_congr_cl49_act_q  and binv_wayH_upd3_q;
p1_way_data_upd49_wayH    <=  p1_congr_cl49_act_q  and reload_wayH_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu49_wayH_upd(0) <=  p1_way_data_upd49_wayH   and p1_wren_q;
rel_bixu49_wayH_upd(1) <=  p0_way_data_upd49_wayH   and p0_wren_q;
-- Congruence Class Match
p0_congr_cl50_m       <=  (ex5_congr_cl_q    = tconv(50,6));
p1_congr_cl50_m       <=  (relu_s_congr_cl_q = tconv(50,6));
-- Act Pin to Directory Latches for specific congruence class
p0_congr_cl50_act_d   <=  p0_congr_cl50_m  and (back_inval_stg5_q or ex5_xuop_val_q or ex5_dir_err_val_q);
p1_congr_cl50_act_d   <=  p1_congr_cl50_m  and rel_port_wren_q;
congr_cl50_act        <=  p0_congr_cl50_act_q  or p1_congr_cl50_act_q  or congr_cl_all_act_q;
p0_way_data_upd50_wayA    <=  p0_congr_cl50_act_q  and binv_wayA_upd3_q;
p1_way_data_upd50_wayA    <=  p1_congr_cl50_act_q  and reload_wayA_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu50_wayA_upd(0) <=  p1_way_data_upd50_wayA   and p1_wren_q;
rel_bixu50_wayA_upd(1) <=  p0_way_data_upd50_wayA   and p0_wren_q;
p0_way_data_upd50_wayB    <=  p0_congr_cl50_act_q  and binv_wayB_upd3_q;
p1_way_data_upd50_wayB    <=  p1_congr_cl50_act_q  and reload_wayB_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu50_wayB_upd(0) <=  p1_way_data_upd50_wayB   and p1_wren_q;
rel_bixu50_wayB_upd(1) <=  p0_way_data_upd50_wayB   and p0_wren_q;
p0_way_data_upd50_wayC    <=  p0_congr_cl50_act_q  and binv_wayC_upd3_q;
p1_way_data_upd50_wayC    <=  p1_congr_cl50_act_q  and reload_wayC_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu50_wayC_upd(0) <=  p1_way_data_upd50_wayC   and p1_wren_q;
rel_bixu50_wayC_upd(1) <=  p0_way_data_upd50_wayC   and p0_wren_q;
p0_way_data_upd50_wayD    <=  p0_congr_cl50_act_q  and binv_wayD_upd3_q;
p1_way_data_upd50_wayD    <=  p1_congr_cl50_act_q  and reload_wayD_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu50_wayD_upd(0) <=  p1_way_data_upd50_wayD   and p1_wren_q;
rel_bixu50_wayD_upd(1) <=  p0_way_data_upd50_wayD   and p0_wren_q;
p0_way_data_upd50_wayE    <=  p0_congr_cl50_act_q  and binv_wayE_upd3_q;
p1_way_data_upd50_wayE    <=  p1_congr_cl50_act_q  and reload_wayE_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu50_wayE_upd(0) <=  p1_way_data_upd50_wayE   and p1_wren_q;
rel_bixu50_wayE_upd(1) <=  p0_way_data_upd50_wayE   and p0_wren_q;
p0_way_data_upd50_wayF    <=  p0_congr_cl50_act_q  and binv_wayF_upd3_q;
p1_way_data_upd50_wayF    <=  p1_congr_cl50_act_q  and reload_wayF_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu50_wayF_upd(0) <=  p1_way_data_upd50_wayF   and p1_wren_q;
rel_bixu50_wayF_upd(1) <=  p0_way_data_upd50_wayF   and p0_wren_q;
p0_way_data_upd50_wayG    <=  p0_congr_cl50_act_q  and binv_wayG_upd3_q;
p1_way_data_upd50_wayG    <=  p1_congr_cl50_act_q  and reload_wayG_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu50_wayG_upd(0) <=  p1_way_data_upd50_wayG   and p1_wren_q;
rel_bixu50_wayG_upd(1) <=  p0_way_data_upd50_wayG   and p0_wren_q;
p0_way_data_upd50_wayH    <=  p0_congr_cl50_act_q  and binv_wayH_upd3_q;
p1_way_data_upd50_wayH    <=  p1_congr_cl50_act_q  and reload_wayH_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu50_wayH_upd(0) <=  p1_way_data_upd50_wayH   and p1_wren_q;
rel_bixu50_wayH_upd(1) <=  p0_way_data_upd50_wayH   and p0_wren_q;
-- Congruence Class Match
p0_congr_cl51_m       <=  (ex5_congr_cl_q    = tconv(51,6));
p1_congr_cl51_m       <=  (relu_s_congr_cl_q = tconv(51,6));
-- Act Pin to Directory Latches for specific congruence class
p0_congr_cl51_act_d   <=  p0_congr_cl51_m  and (back_inval_stg5_q or ex5_xuop_val_q or ex5_dir_err_val_q);
p1_congr_cl51_act_d   <=  p1_congr_cl51_m  and rel_port_wren_q;
congr_cl51_act        <=  p0_congr_cl51_act_q  or p1_congr_cl51_act_q  or congr_cl_all_act_q;
p0_way_data_upd51_wayA    <=  p0_congr_cl51_act_q  and binv_wayA_upd3_q;
p1_way_data_upd51_wayA    <=  p1_congr_cl51_act_q  and reload_wayA_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu51_wayA_upd(0) <=  p1_way_data_upd51_wayA   and p1_wren_q;
rel_bixu51_wayA_upd(1) <=  p0_way_data_upd51_wayA   and p0_wren_q;
p0_way_data_upd51_wayB    <=  p0_congr_cl51_act_q  and binv_wayB_upd3_q;
p1_way_data_upd51_wayB    <=  p1_congr_cl51_act_q  and reload_wayB_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu51_wayB_upd(0) <=  p1_way_data_upd51_wayB   and p1_wren_q;
rel_bixu51_wayB_upd(1) <=  p0_way_data_upd51_wayB   and p0_wren_q;
p0_way_data_upd51_wayC    <=  p0_congr_cl51_act_q  and binv_wayC_upd3_q;
p1_way_data_upd51_wayC    <=  p1_congr_cl51_act_q  and reload_wayC_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu51_wayC_upd(0) <=  p1_way_data_upd51_wayC   and p1_wren_q;
rel_bixu51_wayC_upd(1) <=  p0_way_data_upd51_wayC   and p0_wren_q;
p0_way_data_upd51_wayD    <=  p0_congr_cl51_act_q  and binv_wayD_upd3_q;
p1_way_data_upd51_wayD    <=  p1_congr_cl51_act_q  and reload_wayD_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu51_wayD_upd(0) <=  p1_way_data_upd51_wayD   and p1_wren_q;
rel_bixu51_wayD_upd(1) <=  p0_way_data_upd51_wayD   and p0_wren_q;
p0_way_data_upd51_wayE    <=  p0_congr_cl51_act_q  and binv_wayE_upd3_q;
p1_way_data_upd51_wayE    <=  p1_congr_cl51_act_q  and reload_wayE_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu51_wayE_upd(0) <=  p1_way_data_upd51_wayE   and p1_wren_q;
rel_bixu51_wayE_upd(1) <=  p0_way_data_upd51_wayE   and p0_wren_q;
p0_way_data_upd51_wayF    <=  p0_congr_cl51_act_q  and binv_wayF_upd3_q;
p1_way_data_upd51_wayF    <=  p1_congr_cl51_act_q  and reload_wayF_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu51_wayF_upd(0) <=  p1_way_data_upd51_wayF   and p1_wren_q;
rel_bixu51_wayF_upd(1) <=  p0_way_data_upd51_wayF   and p0_wren_q;
p0_way_data_upd51_wayG    <=  p0_congr_cl51_act_q  and binv_wayG_upd3_q;
p1_way_data_upd51_wayG    <=  p1_congr_cl51_act_q  and reload_wayG_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu51_wayG_upd(0) <=  p1_way_data_upd51_wayG   and p1_wren_q;
rel_bixu51_wayG_upd(1) <=  p0_way_data_upd51_wayG   and p0_wren_q;
p0_way_data_upd51_wayH    <=  p0_congr_cl51_act_q  and binv_wayH_upd3_q;
p1_way_data_upd51_wayH    <=  p1_congr_cl51_act_q  and reload_wayH_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu51_wayH_upd(0) <=  p1_way_data_upd51_wayH   and p1_wren_q;
rel_bixu51_wayH_upd(1) <=  p0_way_data_upd51_wayH   and p0_wren_q;
-- Congruence Class Match
p0_congr_cl52_m       <=  (ex5_congr_cl_q    = tconv(52,6));
p1_congr_cl52_m       <=  (relu_s_congr_cl_q = tconv(52,6));
-- Act Pin to Directory Latches for specific congruence class
p0_congr_cl52_act_d   <=  p0_congr_cl52_m  and (back_inval_stg5_q or ex5_xuop_val_q or ex5_dir_err_val_q);
p1_congr_cl52_act_d   <=  p1_congr_cl52_m  and rel_port_wren_q;
congr_cl52_act        <=  p0_congr_cl52_act_q  or p1_congr_cl52_act_q  or congr_cl_all_act_q;
p0_way_data_upd52_wayA    <=  p0_congr_cl52_act_q  and binv_wayA_upd3_q;
p1_way_data_upd52_wayA    <=  p1_congr_cl52_act_q  and reload_wayA_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu52_wayA_upd(0) <=  p1_way_data_upd52_wayA   and p1_wren_q;
rel_bixu52_wayA_upd(1) <=  p0_way_data_upd52_wayA   and p0_wren_q;
p0_way_data_upd52_wayB    <=  p0_congr_cl52_act_q  and binv_wayB_upd3_q;
p1_way_data_upd52_wayB    <=  p1_congr_cl52_act_q  and reload_wayB_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu52_wayB_upd(0) <=  p1_way_data_upd52_wayB   and p1_wren_q;
rel_bixu52_wayB_upd(1) <=  p0_way_data_upd52_wayB   and p0_wren_q;
p0_way_data_upd52_wayC    <=  p0_congr_cl52_act_q  and binv_wayC_upd3_q;
p1_way_data_upd52_wayC    <=  p1_congr_cl52_act_q  and reload_wayC_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu52_wayC_upd(0) <=  p1_way_data_upd52_wayC   and p1_wren_q;
rel_bixu52_wayC_upd(1) <=  p0_way_data_upd52_wayC   and p0_wren_q;
p0_way_data_upd52_wayD    <=  p0_congr_cl52_act_q  and binv_wayD_upd3_q;
p1_way_data_upd52_wayD    <=  p1_congr_cl52_act_q  and reload_wayD_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu52_wayD_upd(0) <=  p1_way_data_upd52_wayD   and p1_wren_q;
rel_bixu52_wayD_upd(1) <=  p0_way_data_upd52_wayD   and p0_wren_q;
p0_way_data_upd52_wayE    <=  p0_congr_cl52_act_q  and binv_wayE_upd3_q;
p1_way_data_upd52_wayE    <=  p1_congr_cl52_act_q  and reload_wayE_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu52_wayE_upd(0) <=  p1_way_data_upd52_wayE   and p1_wren_q;
rel_bixu52_wayE_upd(1) <=  p0_way_data_upd52_wayE   and p0_wren_q;
p0_way_data_upd52_wayF    <=  p0_congr_cl52_act_q  and binv_wayF_upd3_q;
p1_way_data_upd52_wayF    <=  p1_congr_cl52_act_q  and reload_wayF_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu52_wayF_upd(0) <=  p1_way_data_upd52_wayF   and p1_wren_q;
rel_bixu52_wayF_upd(1) <=  p0_way_data_upd52_wayF   and p0_wren_q;
p0_way_data_upd52_wayG    <=  p0_congr_cl52_act_q  and binv_wayG_upd3_q;
p1_way_data_upd52_wayG    <=  p1_congr_cl52_act_q  and reload_wayG_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu52_wayG_upd(0) <=  p1_way_data_upd52_wayG   and p1_wren_q;
rel_bixu52_wayG_upd(1) <=  p0_way_data_upd52_wayG   and p0_wren_q;
p0_way_data_upd52_wayH    <=  p0_congr_cl52_act_q  and binv_wayH_upd3_q;
p1_way_data_upd52_wayH    <=  p1_congr_cl52_act_q  and reload_wayH_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu52_wayH_upd(0) <=  p1_way_data_upd52_wayH   and p1_wren_q;
rel_bixu52_wayH_upd(1) <=  p0_way_data_upd52_wayH   and p0_wren_q;
-- Congruence Class Match
p0_congr_cl53_m       <=  (ex5_congr_cl_q    = tconv(53,6));
p1_congr_cl53_m       <=  (relu_s_congr_cl_q = tconv(53,6));
-- Act Pin to Directory Latches for specific congruence class
p0_congr_cl53_act_d   <=  p0_congr_cl53_m  and (back_inval_stg5_q or ex5_xuop_val_q or ex5_dir_err_val_q);
p1_congr_cl53_act_d   <=  p1_congr_cl53_m  and rel_port_wren_q;
congr_cl53_act        <=  p0_congr_cl53_act_q  or p1_congr_cl53_act_q  or congr_cl_all_act_q;
p0_way_data_upd53_wayA    <=  p0_congr_cl53_act_q  and binv_wayA_upd3_q;
p1_way_data_upd53_wayA    <=  p1_congr_cl53_act_q  and reload_wayA_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu53_wayA_upd(0) <=  p1_way_data_upd53_wayA   and p1_wren_q;
rel_bixu53_wayA_upd(1) <=  p0_way_data_upd53_wayA   and p0_wren_q;
p0_way_data_upd53_wayB    <=  p0_congr_cl53_act_q  and binv_wayB_upd3_q;
p1_way_data_upd53_wayB    <=  p1_congr_cl53_act_q  and reload_wayB_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu53_wayB_upd(0) <=  p1_way_data_upd53_wayB   and p1_wren_q;
rel_bixu53_wayB_upd(1) <=  p0_way_data_upd53_wayB   and p0_wren_q;
p0_way_data_upd53_wayC    <=  p0_congr_cl53_act_q  and binv_wayC_upd3_q;
p1_way_data_upd53_wayC    <=  p1_congr_cl53_act_q  and reload_wayC_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu53_wayC_upd(0) <=  p1_way_data_upd53_wayC   and p1_wren_q;
rel_bixu53_wayC_upd(1) <=  p0_way_data_upd53_wayC   and p0_wren_q;
p0_way_data_upd53_wayD    <=  p0_congr_cl53_act_q  and binv_wayD_upd3_q;
p1_way_data_upd53_wayD    <=  p1_congr_cl53_act_q  and reload_wayD_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu53_wayD_upd(0) <=  p1_way_data_upd53_wayD   and p1_wren_q;
rel_bixu53_wayD_upd(1) <=  p0_way_data_upd53_wayD   and p0_wren_q;
p0_way_data_upd53_wayE    <=  p0_congr_cl53_act_q  and binv_wayE_upd3_q;
p1_way_data_upd53_wayE    <=  p1_congr_cl53_act_q  and reload_wayE_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu53_wayE_upd(0) <=  p1_way_data_upd53_wayE   and p1_wren_q;
rel_bixu53_wayE_upd(1) <=  p0_way_data_upd53_wayE   and p0_wren_q;
p0_way_data_upd53_wayF    <=  p0_congr_cl53_act_q  and binv_wayF_upd3_q;
p1_way_data_upd53_wayF    <=  p1_congr_cl53_act_q  and reload_wayF_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu53_wayF_upd(0) <=  p1_way_data_upd53_wayF   and p1_wren_q;
rel_bixu53_wayF_upd(1) <=  p0_way_data_upd53_wayF   and p0_wren_q;
p0_way_data_upd53_wayG    <=  p0_congr_cl53_act_q  and binv_wayG_upd3_q;
p1_way_data_upd53_wayG    <=  p1_congr_cl53_act_q  and reload_wayG_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu53_wayG_upd(0) <=  p1_way_data_upd53_wayG   and p1_wren_q;
rel_bixu53_wayG_upd(1) <=  p0_way_data_upd53_wayG   and p0_wren_q;
p0_way_data_upd53_wayH    <=  p0_congr_cl53_act_q  and binv_wayH_upd3_q;
p1_way_data_upd53_wayH    <=  p1_congr_cl53_act_q  and reload_wayH_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu53_wayH_upd(0) <=  p1_way_data_upd53_wayH   and p1_wren_q;
rel_bixu53_wayH_upd(1) <=  p0_way_data_upd53_wayH   and p0_wren_q;
-- Congruence Class Match
p0_congr_cl54_m       <=  (ex5_congr_cl_q    = tconv(54,6));
p1_congr_cl54_m       <=  (relu_s_congr_cl_q = tconv(54,6));
-- Act Pin to Directory Latches for specific congruence class
p0_congr_cl54_act_d   <=  p0_congr_cl54_m  and (back_inval_stg5_q or ex5_xuop_val_q or ex5_dir_err_val_q);
p1_congr_cl54_act_d   <=  p1_congr_cl54_m  and rel_port_wren_q;
congr_cl54_act        <=  p0_congr_cl54_act_q  or p1_congr_cl54_act_q  or congr_cl_all_act_q;
p0_way_data_upd54_wayA    <=  p0_congr_cl54_act_q  and binv_wayA_upd3_q;
p1_way_data_upd54_wayA    <=  p1_congr_cl54_act_q  and reload_wayA_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu54_wayA_upd(0) <=  p1_way_data_upd54_wayA   and p1_wren_q;
rel_bixu54_wayA_upd(1) <=  p0_way_data_upd54_wayA   and p0_wren_q;
p0_way_data_upd54_wayB    <=  p0_congr_cl54_act_q  and binv_wayB_upd3_q;
p1_way_data_upd54_wayB    <=  p1_congr_cl54_act_q  and reload_wayB_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu54_wayB_upd(0) <=  p1_way_data_upd54_wayB   and p1_wren_q;
rel_bixu54_wayB_upd(1) <=  p0_way_data_upd54_wayB   and p0_wren_q;
p0_way_data_upd54_wayC    <=  p0_congr_cl54_act_q  and binv_wayC_upd3_q;
p1_way_data_upd54_wayC    <=  p1_congr_cl54_act_q  and reload_wayC_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu54_wayC_upd(0) <=  p1_way_data_upd54_wayC   and p1_wren_q;
rel_bixu54_wayC_upd(1) <=  p0_way_data_upd54_wayC   and p0_wren_q;
p0_way_data_upd54_wayD    <=  p0_congr_cl54_act_q  and binv_wayD_upd3_q;
p1_way_data_upd54_wayD    <=  p1_congr_cl54_act_q  and reload_wayD_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu54_wayD_upd(0) <=  p1_way_data_upd54_wayD   and p1_wren_q;
rel_bixu54_wayD_upd(1) <=  p0_way_data_upd54_wayD   and p0_wren_q;
p0_way_data_upd54_wayE    <=  p0_congr_cl54_act_q  and binv_wayE_upd3_q;
p1_way_data_upd54_wayE    <=  p1_congr_cl54_act_q  and reload_wayE_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu54_wayE_upd(0) <=  p1_way_data_upd54_wayE   and p1_wren_q;
rel_bixu54_wayE_upd(1) <=  p0_way_data_upd54_wayE   and p0_wren_q;
p0_way_data_upd54_wayF    <=  p0_congr_cl54_act_q  and binv_wayF_upd3_q;
p1_way_data_upd54_wayF    <=  p1_congr_cl54_act_q  and reload_wayF_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu54_wayF_upd(0) <=  p1_way_data_upd54_wayF   and p1_wren_q;
rel_bixu54_wayF_upd(1) <=  p0_way_data_upd54_wayF   and p0_wren_q;
p0_way_data_upd54_wayG    <=  p0_congr_cl54_act_q  and binv_wayG_upd3_q;
p1_way_data_upd54_wayG    <=  p1_congr_cl54_act_q  and reload_wayG_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu54_wayG_upd(0) <=  p1_way_data_upd54_wayG   and p1_wren_q;
rel_bixu54_wayG_upd(1) <=  p0_way_data_upd54_wayG   and p0_wren_q;
p0_way_data_upd54_wayH    <=  p0_congr_cl54_act_q  and binv_wayH_upd3_q;
p1_way_data_upd54_wayH    <=  p1_congr_cl54_act_q  and reload_wayH_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu54_wayH_upd(0) <=  p1_way_data_upd54_wayH   and p1_wren_q;
rel_bixu54_wayH_upd(1) <=  p0_way_data_upd54_wayH   and p0_wren_q;
-- Congruence Class Match
p0_congr_cl55_m       <=  (ex5_congr_cl_q    = tconv(55,6));
p1_congr_cl55_m       <=  (relu_s_congr_cl_q = tconv(55,6));
-- Act Pin to Directory Latches for specific congruence class
p0_congr_cl55_act_d   <=  p0_congr_cl55_m  and (back_inval_stg5_q or ex5_xuop_val_q or ex5_dir_err_val_q);
p1_congr_cl55_act_d   <=  p1_congr_cl55_m  and rel_port_wren_q;
congr_cl55_act        <=  p0_congr_cl55_act_q  or p1_congr_cl55_act_q  or congr_cl_all_act_q;
p0_way_data_upd55_wayA    <=  p0_congr_cl55_act_q  and binv_wayA_upd3_q;
p1_way_data_upd55_wayA    <=  p1_congr_cl55_act_q  and reload_wayA_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu55_wayA_upd(0) <=  p1_way_data_upd55_wayA   and p1_wren_q;
rel_bixu55_wayA_upd(1) <=  p0_way_data_upd55_wayA   and p0_wren_q;
p0_way_data_upd55_wayB    <=  p0_congr_cl55_act_q  and binv_wayB_upd3_q;
p1_way_data_upd55_wayB    <=  p1_congr_cl55_act_q  and reload_wayB_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu55_wayB_upd(0) <=  p1_way_data_upd55_wayB   and p1_wren_q;
rel_bixu55_wayB_upd(1) <=  p0_way_data_upd55_wayB   and p0_wren_q;
p0_way_data_upd55_wayC    <=  p0_congr_cl55_act_q  and binv_wayC_upd3_q;
p1_way_data_upd55_wayC    <=  p1_congr_cl55_act_q  and reload_wayC_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu55_wayC_upd(0) <=  p1_way_data_upd55_wayC   and p1_wren_q;
rel_bixu55_wayC_upd(1) <=  p0_way_data_upd55_wayC   and p0_wren_q;
p0_way_data_upd55_wayD    <=  p0_congr_cl55_act_q  and binv_wayD_upd3_q;
p1_way_data_upd55_wayD    <=  p1_congr_cl55_act_q  and reload_wayD_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu55_wayD_upd(0) <=  p1_way_data_upd55_wayD   and p1_wren_q;
rel_bixu55_wayD_upd(1) <=  p0_way_data_upd55_wayD   and p0_wren_q;
p0_way_data_upd55_wayE    <=  p0_congr_cl55_act_q  and binv_wayE_upd3_q;
p1_way_data_upd55_wayE    <=  p1_congr_cl55_act_q  and reload_wayE_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu55_wayE_upd(0) <=  p1_way_data_upd55_wayE   and p1_wren_q;
rel_bixu55_wayE_upd(1) <=  p0_way_data_upd55_wayE   and p0_wren_q;
p0_way_data_upd55_wayF    <=  p0_congr_cl55_act_q  and binv_wayF_upd3_q;
p1_way_data_upd55_wayF    <=  p1_congr_cl55_act_q  and reload_wayF_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu55_wayF_upd(0) <=  p1_way_data_upd55_wayF   and p1_wren_q;
rel_bixu55_wayF_upd(1) <=  p0_way_data_upd55_wayF   and p0_wren_q;
p0_way_data_upd55_wayG    <=  p0_congr_cl55_act_q  and binv_wayG_upd3_q;
p1_way_data_upd55_wayG    <=  p1_congr_cl55_act_q  and reload_wayG_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu55_wayG_upd(0) <=  p1_way_data_upd55_wayG   and p1_wren_q;
rel_bixu55_wayG_upd(1) <=  p0_way_data_upd55_wayG   and p0_wren_q;
p0_way_data_upd55_wayH    <=  p0_congr_cl55_act_q  and binv_wayH_upd3_q;
p1_way_data_upd55_wayH    <=  p1_congr_cl55_act_q  and reload_wayH_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu55_wayH_upd(0) <=  p1_way_data_upd55_wayH   and p1_wren_q;
rel_bixu55_wayH_upd(1) <=  p0_way_data_upd55_wayH   and p0_wren_q;
-- Congruence Class Match
p0_congr_cl56_m       <=  (ex5_congr_cl_q    = tconv(56,6));
p1_congr_cl56_m       <=  (relu_s_congr_cl_q = tconv(56,6));
-- Act Pin to Directory Latches for specific congruence class
p0_congr_cl56_act_d   <=  p0_congr_cl56_m  and (back_inval_stg5_q or ex5_xuop_val_q or ex5_dir_err_val_q);
p1_congr_cl56_act_d   <=  p1_congr_cl56_m  and rel_port_wren_q;
congr_cl56_act        <=  p0_congr_cl56_act_q  or p1_congr_cl56_act_q  or congr_cl_all_act_q;
p0_way_data_upd56_wayA    <=  p0_congr_cl56_act_q  and binv_wayA_upd3_q;
p1_way_data_upd56_wayA    <=  p1_congr_cl56_act_q  and reload_wayA_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu56_wayA_upd(0) <=  p1_way_data_upd56_wayA   and p1_wren_q;
rel_bixu56_wayA_upd(1) <=  p0_way_data_upd56_wayA   and p0_wren_q;
p0_way_data_upd56_wayB    <=  p0_congr_cl56_act_q  and binv_wayB_upd3_q;
p1_way_data_upd56_wayB    <=  p1_congr_cl56_act_q  and reload_wayB_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu56_wayB_upd(0) <=  p1_way_data_upd56_wayB   and p1_wren_q;
rel_bixu56_wayB_upd(1) <=  p0_way_data_upd56_wayB   and p0_wren_q;
p0_way_data_upd56_wayC    <=  p0_congr_cl56_act_q  and binv_wayC_upd3_q;
p1_way_data_upd56_wayC    <=  p1_congr_cl56_act_q  and reload_wayC_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu56_wayC_upd(0) <=  p1_way_data_upd56_wayC   and p1_wren_q;
rel_bixu56_wayC_upd(1) <=  p0_way_data_upd56_wayC   and p0_wren_q;
p0_way_data_upd56_wayD    <=  p0_congr_cl56_act_q  and binv_wayD_upd3_q;
p1_way_data_upd56_wayD    <=  p1_congr_cl56_act_q  and reload_wayD_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu56_wayD_upd(0) <=  p1_way_data_upd56_wayD   and p1_wren_q;
rel_bixu56_wayD_upd(1) <=  p0_way_data_upd56_wayD   and p0_wren_q;
p0_way_data_upd56_wayE    <=  p0_congr_cl56_act_q  and binv_wayE_upd3_q;
p1_way_data_upd56_wayE    <=  p1_congr_cl56_act_q  and reload_wayE_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu56_wayE_upd(0) <=  p1_way_data_upd56_wayE   and p1_wren_q;
rel_bixu56_wayE_upd(1) <=  p0_way_data_upd56_wayE   and p0_wren_q;
p0_way_data_upd56_wayF    <=  p0_congr_cl56_act_q  and binv_wayF_upd3_q;
p1_way_data_upd56_wayF    <=  p1_congr_cl56_act_q  and reload_wayF_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu56_wayF_upd(0) <=  p1_way_data_upd56_wayF   and p1_wren_q;
rel_bixu56_wayF_upd(1) <=  p0_way_data_upd56_wayF   and p0_wren_q;
p0_way_data_upd56_wayG    <=  p0_congr_cl56_act_q  and binv_wayG_upd3_q;
p1_way_data_upd56_wayG    <=  p1_congr_cl56_act_q  and reload_wayG_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu56_wayG_upd(0) <=  p1_way_data_upd56_wayG   and p1_wren_q;
rel_bixu56_wayG_upd(1) <=  p0_way_data_upd56_wayG   and p0_wren_q;
p0_way_data_upd56_wayH    <=  p0_congr_cl56_act_q  and binv_wayH_upd3_q;
p1_way_data_upd56_wayH    <=  p1_congr_cl56_act_q  and reload_wayH_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu56_wayH_upd(0) <=  p1_way_data_upd56_wayH   and p1_wren_q;
rel_bixu56_wayH_upd(1) <=  p0_way_data_upd56_wayH   and p0_wren_q;
-- Congruence Class Match
p0_congr_cl57_m       <=  (ex5_congr_cl_q    = tconv(57,6));
p1_congr_cl57_m       <=  (relu_s_congr_cl_q = tconv(57,6));
-- Act Pin to Directory Latches for specific congruence class
p0_congr_cl57_act_d   <=  p0_congr_cl57_m  and (back_inval_stg5_q or ex5_xuop_val_q or ex5_dir_err_val_q);
p1_congr_cl57_act_d   <=  p1_congr_cl57_m  and rel_port_wren_q;
congr_cl57_act        <=  p0_congr_cl57_act_q  or p1_congr_cl57_act_q  or congr_cl_all_act_q;
p0_way_data_upd57_wayA    <=  p0_congr_cl57_act_q  and binv_wayA_upd3_q;
p1_way_data_upd57_wayA    <=  p1_congr_cl57_act_q  and reload_wayA_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu57_wayA_upd(0) <=  p1_way_data_upd57_wayA   and p1_wren_q;
rel_bixu57_wayA_upd(1) <=  p0_way_data_upd57_wayA   and p0_wren_q;
p0_way_data_upd57_wayB    <=  p0_congr_cl57_act_q  and binv_wayB_upd3_q;
p1_way_data_upd57_wayB    <=  p1_congr_cl57_act_q  and reload_wayB_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu57_wayB_upd(0) <=  p1_way_data_upd57_wayB   and p1_wren_q;
rel_bixu57_wayB_upd(1) <=  p0_way_data_upd57_wayB   and p0_wren_q;
p0_way_data_upd57_wayC    <=  p0_congr_cl57_act_q  and binv_wayC_upd3_q;
p1_way_data_upd57_wayC    <=  p1_congr_cl57_act_q  and reload_wayC_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu57_wayC_upd(0) <=  p1_way_data_upd57_wayC   and p1_wren_q;
rel_bixu57_wayC_upd(1) <=  p0_way_data_upd57_wayC   and p0_wren_q;
p0_way_data_upd57_wayD    <=  p0_congr_cl57_act_q  and binv_wayD_upd3_q;
p1_way_data_upd57_wayD    <=  p1_congr_cl57_act_q  and reload_wayD_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu57_wayD_upd(0) <=  p1_way_data_upd57_wayD   and p1_wren_q;
rel_bixu57_wayD_upd(1) <=  p0_way_data_upd57_wayD   and p0_wren_q;
p0_way_data_upd57_wayE    <=  p0_congr_cl57_act_q  and binv_wayE_upd3_q;
p1_way_data_upd57_wayE    <=  p1_congr_cl57_act_q  and reload_wayE_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu57_wayE_upd(0) <=  p1_way_data_upd57_wayE   and p1_wren_q;
rel_bixu57_wayE_upd(1) <=  p0_way_data_upd57_wayE   and p0_wren_q;
p0_way_data_upd57_wayF    <=  p0_congr_cl57_act_q  and binv_wayF_upd3_q;
p1_way_data_upd57_wayF    <=  p1_congr_cl57_act_q  and reload_wayF_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu57_wayF_upd(0) <=  p1_way_data_upd57_wayF   and p1_wren_q;
rel_bixu57_wayF_upd(1) <=  p0_way_data_upd57_wayF   and p0_wren_q;
p0_way_data_upd57_wayG    <=  p0_congr_cl57_act_q  and binv_wayG_upd3_q;
p1_way_data_upd57_wayG    <=  p1_congr_cl57_act_q  and reload_wayG_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu57_wayG_upd(0) <=  p1_way_data_upd57_wayG   and p1_wren_q;
rel_bixu57_wayG_upd(1) <=  p0_way_data_upd57_wayG   and p0_wren_q;
p0_way_data_upd57_wayH    <=  p0_congr_cl57_act_q  and binv_wayH_upd3_q;
p1_way_data_upd57_wayH    <=  p1_congr_cl57_act_q  and reload_wayH_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu57_wayH_upd(0) <=  p1_way_data_upd57_wayH   and p1_wren_q;
rel_bixu57_wayH_upd(1) <=  p0_way_data_upd57_wayH   and p0_wren_q;
-- Congruence Class Match
p0_congr_cl58_m       <=  (ex5_congr_cl_q    = tconv(58,6));
p1_congr_cl58_m       <=  (relu_s_congr_cl_q = tconv(58,6));
-- Act Pin to Directory Latches for specific congruence class
p0_congr_cl58_act_d   <=  p0_congr_cl58_m  and (back_inval_stg5_q or ex5_xuop_val_q or ex5_dir_err_val_q);
p1_congr_cl58_act_d   <=  p1_congr_cl58_m  and rel_port_wren_q;
congr_cl58_act        <=  p0_congr_cl58_act_q  or p1_congr_cl58_act_q  or congr_cl_all_act_q;
p0_way_data_upd58_wayA    <=  p0_congr_cl58_act_q  and binv_wayA_upd3_q;
p1_way_data_upd58_wayA    <=  p1_congr_cl58_act_q  and reload_wayA_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu58_wayA_upd(0) <=  p1_way_data_upd58_wayA   and p1_wren_q;
rel_bixu58_wayA_upd(1) <=  p0_way_data_upd58_wayA   and p0_wren_q;
p0_way_data_upd58_wayB    <=  p0_congr_cl58_act_q  and binv_wayB_upd3_q;
p1_way_data_upd58_wayB    <=  p1_congr_cl58_act_q  and reload_wayB_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu58_wayB_upd(0) <=  p1_way_data_upd58_wayB   and p1_wren_q;
rel_bixu58_wayB_upd(1) <=  p0_way_data_upd58_wayB   and p0_wren_q;
p0_way_data_upd58_wayC    <=  p0_congr_cl58_act_q  and binv_wayC_upd3_q;
p1_way_data_upd58_wayC    <=  p1_congr_cl58_act_q  and reload_wayC_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu58_wayC_upd(0) <=  p1_way_data_upd58_wayC   and p1_wren_q;
rel_bixu58_wayC_upd(1) <=  p0_way_data_upd58_wayC   and p0_wren_q;
p0_way_data_upd58_wayD    <=  p0_congr_cl58_act_q  and binv_wayD_upd3_q;
p1_way_data_upd58_wayD    <=  p1_congr_cl58_act_q  and reload_wayD_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu58_wayD_upd(0) <=  p1_way_data_upd58_wayD   and p1_wren_q;
rel_bixu58_wayD_upd(1) <=  p0_way_data_upd58_wayD   and p0_wren_q;
p0_way_data_upd58_wayE    <=  p0_congr_cl58_act_q  and binv_wayE_upd3_q;
p1_way_data_upd58_wayE    <=  p1_congr_cl58_act_q  and reload_wayE_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu58_wayE_upd(0) <=  p1_way_data_upd58_wayE   and p1_wren_q;
rel_bixu58_wayE_upd(1) <=  p0_way_data_upd58_wayE   and p0_wren_q;
p0_way_data_upd58_wayF    <=  p0_congr_cl58_act_q  and binv_wayF_upd3_q;
p1_way_data_upd58_wayF    <=  p1_congr_cl58_act_q  and reload_wayF_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu58_wayF_upd(0) <=  p1_way_data_upd58_wayF   and p1_wren_q;
rel_bixu58_wayF_upd(1) <=  p0_way_data_upd58_wayF   and p0_wren_q;
p0_way_data_upd58_wayG    <=  p0_congr_cl58_act_q  and binv_wayG_upd3_q;
p1_way_data_upd58_wayG    <=  p1_congr_cl58_act_q  and reload_wayG_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu58_wayG_upd(0) <=  p1_way_data_upd58_wayG   and p1_wren_q;
rel_bixu58_wayG_upd(1) <=  p0_way_data_upd58_wayG   and p0_wren_q;
p0_way_data_upd58_wayH    <=  p0_congr_cl58_act_q  and binv_wayH_upd3_q;
p1_way_data_upd58_wayH    <=  p1_congr_cl58_act_q  and reload_wayH_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu58_wayH_upd(0) <=  p1_way_data_upd58_wayH   and p1_wren_q;
rel_bixu58_wayH_upd(1) <=  p0_way_data_upd58_wayH   and p0_wren_q;
-- Congruence Class Match
p0_congr_cl59_m       <=  (ex5_congr_cl_q    = tconv(59,6));
p1_congr_cl59_m       <=  (relu_s_congr_cl_q = tconv(59,6));
-- Act Pin to Directory Latches for specific congruence class
p0_congr_cl59_act_d   <=  p0_congr_cl59_m  and (back_inval_stg5_q or ex5_xuop_val_q or ex5_dir_err_val_q);
p1_congr_cl59_act_d   <=  p1_congr_cl59_m  and rel_port_wren_q;
congr_cl59_act        <=  p0_congr_cl59_act_q  or p1_congr_cl59_act_q  or congr_cl_all_act_q;
p0_way_data_upd59_wayA    <=  p0_congr_cl59_act_q  and binv_wayA_upd3_q;
p1_way_data_upd59_wayA    <=  p1_congr_cl59_act_q  and reload_wayA_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu59_wayA_upd(0) <=  p1_way_data_upd59_wayA   and p1_wren_q;
rel_bixu59_wayA_upd(1) <=  p0_way_data_upd59_wayA   and p0_wren_q;
p0_way_data_upd59_wayB    <=  p0_congr_cl59_act_q  and binv_wayB_upd3_q;
p1_way_data_upd59_wayB    <=  p1_congr_cl59_act_q  and reload_wayB_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu59_wayB_upd(0) <=  p1_way_data_upd59_wayB   and p1_wren_q;
rel_bixu59_wayB_upd(1) <=  p0_way_data_upd59_wayB   and p0_wren_q;
p0_way_data_upd59_wayC    <=  p0_congr_cl59_act_q  and binv_wayC_upd3_q;
p1_way_data_upd59_wayC    <=  p1_congr_cl59_act_q  and reload_wayC_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu59_wayC_upd(0) <=  p1_way_data_upd59_wayC   and p1_wren_q;
rel_bixu59_wayC_upd(1) <=  p0_way_data_upd59_wayC   and p0_wren_q;
p0_way_data_upd59_wayD    <=  p0_congr_cl59_act_q  and binv_wayD_upd3_q;
p1_way_data_upd59_wayD    <=  p1_congr_cl59_act_q  and reload_wayD_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu59_wayD_upd(0) <=  p1_way_data_upd59_wayD   and p1_wren_q;
rel_bixu59_wayD_upd(1) <=  p0_way_data_upd59_wayD   and p0_wren_q;
p0_way_data_upd59_wayE    <=  p0_congr_cl59_act_q  and binv_wayE_upd3_q;
p1_way_data_upd59_wayE    <=  p1_congr_cl59_act_q  and reload_wayE_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu59_wayE_upd(0) <=  p1_way_data_upd59_wayE   and p1_wren_q;
rel_bixu59_wayE_upd(1) <=  p0_way_data_upd59_wayE   and p0_wren_q;
p0_way_data_upd59_wayF    <=  p0_congr_cl59_act_q  and binv_wayF_upd3_q;
p1_way_data_upd59_wayF    <=  p1_congr_cl59_act_q  and reload_wayF_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu59_wayF_upd(0) <=  p1_way_data_upd59_wayF   and p1_wren_q;
rel_bixu59_wayF_upd(1) <=  p0_way_data_upd59_wayF   and p0_wren_q;
p0_way_data_upd59_wayG    <=  p0_congr_cl59_act_q  and binv_wayG_upd3_q;
p1_way_data_upd59_wayG    <=  p1_congr_cl59_act_q  and reload_wayG_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu59_wayG_upd(0) <=  p1_way_data_upd59_wayG   and p1_wren_q;
rel_bixu59_wayG_upd(1) <=  p0_way_data_upd59_wayG   and p0_wren_q;
p0_way_data_upd59_wayH    <=  p0_congr_cl59_act_q  and binv_wayH_upd3_q;
p1_way_data_upd59_wayH    <=  p1_congr_cl59_act_q  and reload_wayH_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu59_wayH_upd(0) <=  p1_way_data_upd59_wayH   and p1_wren_q;
rel_bixu59_wayH_upd(1) <=  p0_way_data_upd59_wayH   and p0_wren_q;
-- Congruence Class Match
p0_congr_cl60_m       <=  (ex5_congr_cl_q    = tconv(60,6));
p1_congr_cl60_m       <=  (relu_s_congr_cl_q = tconv(60,6));
-- Act Pin to Directory Latches for specific congruence class
p0_congr_cl60_act_d   <=  p0_congr_cl60_m  and (back_inval_stg5_q or ex5_xuop_val_q or ex5_dir_err_val_q);
p1_congr_cl60_act_d   <=  p1_congr_cl60_m  and rel_port_wren_q;
congr_cl60_act        <=  p0_congr_cl60_act_q  or p1_congr_cl60_act_q  or congr_cl_all_act_q;
p0_way_data_upd60_wayA    <=  p0_congr_cl60_act_q  and binv_wayA_upd3_q;
p1_way_data_upd60_wayA    <=  p1_congr_cl60_act_q  and reload_wayA_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu60_wayA_upd(0) <=  p1_way_data_upd60_wayA   and p1_wren_q;
rel_bixu60_wayA_upd(1) <=  p0_way_data_upd60_wayA   and p0_wren_q;
p0_way_data_upd60_wayB    <=  p0_congr_cl60_act_q  and binv_wayB_upd3_q;
p1_way_data_upd60_wayB    <=  p1_congr_cl60_act_q  and reload_wayB_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu60_wayB_upd(0) <=  p1_way_data_upd60_wayB   and p1_wren_q;
rel_bixu60_wayB_upd(1) <=  p0_way_data_upd60_wayB   and p0_wren_q;
p0_way_data_upd60_wayC    <=  p0_congr_cl60_act_q  and binv_wayC_upd3_q;
p1_way_data_upd60_wayC    <=  p1_congr_cl60_act_q  and reload_wayC_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu60_wayC_upd(0) <=  p1_way_data_upd60_wayC   and p1_wren_q;
rel_bixu60_wayC_upd(1) <=  p0_way_data_upd60_wayC   and p0_wren_q;
p0_way_data_upd60_wayD    <=  p0_congr_cl60_act_q  and binv_wayD_upd3_q;
p1_way_data_upd60_wayD    <=  p1_congr_cl60_act_q  and reload_wayD_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu60_wayD_upd(0) <=  p1_way_data_upd60_wayD   and p1_wren_q;
rel_bixu60_wayD_upd(1) <=  p0_way_data_upd60_wayD   and p0_wren_q;
p0_way_data_upd60_wayE    <=  p0_congr_cl60_act_q  and binv_wayE_upd3_q;
p1_way_data_upd60_wayE    <=  p1_congr_cl60_act_q  and reload_wayE_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu60_wayE_upd(0) <=  p1_way_data_upd60_wayE   and p1_wren_q;
rel_bixu60_wayE_upd(1) <=  p0_way_data_upd60_wayE   and p0_wren_q;
p0_way_data_upd60_wayF    <=  p0_congr_cl60_act_q  and binv_wayF_upd3_q;
p1_way_data_upd60_wayF    <=  p1_congr_cl60_act_q  and reload_wayF_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu60_wayF_upd(0) <=  p1_way_data_upd60_wayF   and p1_wren_q;
rel_bixu60_wayF_upd(1) <=  p0_way_data_upd60_wayF   and p0_wren_q;
p0_way_data_upd60_wayG    <=  p0_congr_cl60_act_q  and binv_wayG_upd3_q;
p1_way_data_upd60_wayG    <=  p1_congr_cl60_act_q  and reload_wayG_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu60_wayG_upd(0) <=  p1_way_data_upd60_wayG   and p1_wren_q;
rel_bixu60_wayG_upd(1) <=  p0_way_data_upd60_wayG   and p0_wren_q;
p0_way_data_upd60_wayH    <=  p0_congr_cl60_act_q  and binv_wayH_upd3_q;
p1_way_data_upd60_wayH    <=  p1_congr_cl60_act_q  and reload_wayH_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu60_wayH_upd(0) <=  p1_way_data_upd60_wayH   and p1_wren_q;
rel_bixu60_wayH_upd(1) <=  p0_way_data_upd60_wayH   and p0_wren_q;
-- Congruence Class Match
p0_congr_cl61_m       <=  (ex5_congr_cl_q    = tconv(61,6));
p1_congr_cl61_m       <=  (relu_s_congr_cl_q = tconv(61,6));
-- Act Pin to Directory Latches for specific congruence class
p0_congr_cl61_act_d   <=  p0_congr_cl61_m  and (back_inval_stg5_q or ex5_xuop_val_q or ex5_dir_err_val_q);
p1_congr_cl61_act_d   <=  p1_congr_cl61_m  and rel_port_wren_q;
congr_cl61_act        <=  p0_congr_cl61_act_q  or p1_congr_cl61_act_q  or congr_cl_all_act_q;
p0_way_data_upd61_wayA    <=  p0_congr_cl61_act_q  and binv_wayA_upd3_q;
p1_way_data_upd61_wayA    <=  p1_congr_cl61_act_q  and reload_wayA_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu61_wayA_upd(0) <=  p1_way_data_upd61_wayA   and p1_wren_q;
rel_bixu61_wayA_upd(1) <=  p0_way_data_upd61_wayA   and p0_wren_q;
p0_way_data_upd61_wayB    <=  p0_congr_cl61_act_q  and binv_wayB_upd3_q;
p1_way_data_upd61_wayB    <=  p1_congr_cl61_act_q  and reload_wayB_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu61_wayB_upd(0) <=  p1_way_data_upd61_wayB   and p1_wren_q;
rel_bixu61_wayB_upd(1) <=  p0_way_data_upd61_wayB   and p0_wren_q;
p0_way_data_upd61_wayC    <=  p0_congr_cl61_act_q  and binv_wayC_upd3_q;
p1_way_data_upd61_wayC    <=  p1_congr_cl61_act_q  and reload_wayC_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu61_wayC_upd(0) <=  p1_way_data_upd61_wayC   and p1_wren_q;
rel_bixu61_wayC_upd(1) <=  p0_way_data_upd61_wayC   and p0_wren_q;
p0_way_data_upd61_wayD    <=  p0_congr_cl61_act_q  and binv_wayD_upd3_q;
p1_way_data_upd61_wayD    <=  p1_congr_cl61_act_q  and reload_wayD_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu61_wayD_upd(0) <=  p1_way_data_upd61_wayD   and p1_wren_q;
rel_bixu61_wayD_upd(1) <=  p0_way_data_upd61_wayD   and p0_wren_q;
p0_way_data_upd61_wayE    <=  p0_congr_cl61_act_q  and binv_wayE_upd3_q;
p1_way_data_upd61_wayE    <=  p1_congr_cl61_act_q  and reload_wayE_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu61_wayE_upd(0) <=  p1_way_data_upd61_wayE   and p1_wren_q;
rel_bixu61_wayE_upd(1) <=  p0_way_data_upd61_wayE   and p0_wren_q;
p0_way_data_upd61_wayF    <=  p0_congr_cl61_act_q  and binv_wayF_upd3_q;
p1_way_data_upd61_wayF    <=  p1_congr_cl61_act_q  and reload_wayF_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu61_wayF_upd(0) <=  p1_way_data_upd61_wayF   and p1_wren_q;
rel_bixu61_wayF_upd(1) <=  p0_way_data_upd61_wayF   and p0_wren_q;
p0_way_data_upd61_wayG    <=  p0_congr_cl61_act_q  and binv_wayG_upd3_q;
p1_way_data_upd61_wayG    <=  p1_congr_cl61_act_q  and reload_wayG_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu61_wayG_upd(0) <=  p1_way_data_upd61_wayG   and p1_wren_q;
rel_bixu61_wayG_upd(1) <=  p0_way_data_upd61_wayG   and p0_wren_q;
p0_way_data_upd61_wayH    <=  p0_congr_cl61_act_q  and binv_wayH_upd3_q;
p1_way_data_upd61_wayH    <=  p1_congr_cl61_act_q  and reload_wayH_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu61_wayH_upd(0) <=  p1_way_data_upd61_wayH   and p1_wren_q;
rel_bixu61_wayH_upd(1) <=  p0_way_data_upd61_wayH   and p0_wren_q;
-- Congruence Class Match
p0_congr_cl62_m       <=  (ex5_congr_cl_q    = tconv(62,6));
p1_congr_cl62_m       <=  (relu_s_congr_cl_q = tconv(62,6));
-- Act Pin to Directory Latches for specific congruence class
p0_congr_cl62_act_d   <=  p0_congr_cl62_m  and (back_inval_stg5_q or ex5_xuop_val_q or ex5_dir_err_val_q);
p1_congr_cl62_act_d   <=  p1_congr_cl62_m  and rel_port_wren_q;
congr_cl62_act        <=  p0_congr_cl62_act_q  or p1_congr_cl62_act_q  or congr_cl_all_act_q;
p0_way_data_upd62_wayA    <=  p0_congr_cl62_act_q  and binv_wayA_upd3_q;
p1_way_data_upd62_wayA    <=  p1_congr_cl62_act_q  and reload_wayA_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu62_wayA_upd(0) <=  p1_way_data_upd62_wayA   and p1_wren_q;
rel_bixu62_wayA_upd(1) <=  p0_way_data_upd62_wayA   and p0_wren_q;
p0_way_data_upd62_wayB    <=  p0_congr_cl62_act_q  and binv_wayB_upd3_q;
p1_way_data_upd62_wayB    <=  p1_congr_cl62_act_q  and reload_wayB_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu62_wayB_upd(0) <=  p1_way_data_upd62_wayB   and p1_wren_q;
rel_bixu62_wayB_upd(1) <=  p0_way_data_upd62_wayB   and p0_wren_q;
p0_way_data_upd62_wayC    <=  p0_congr_cl62_act_q  and binv_wayC_upd3_q;
p1_way_data_upd62_wayC    <=  p1_congr_cl62_act_q  and reload_wayC_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu62_wayC_upd(0) <=  p1_way_data_upd62_wayC   and p1_wren_q;
rel_bixu62_wayC_upd(1) <=  p0_way_data_upd62_wayC   and p0_wren_q;
p0_way_data_upd62_wayD    <=  p0_congr_cl62_act_q  and binv_wayD_upd3_q;
p1_way_data_upd62_wayD    <=  p1_congr_cl62_act_q  and reload_wayD_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu62_wayD_upd(0) <=  p1_way_data_upd62_wayD   and p1_wren_q;
rel_bixu62_wayD_upd(1) <=  p0_way_data_upd62_wayD   and p0_wren_q;
p0_way_data_upd62_wayE    <=  p0_congr_cl62_act_q  and binv_wayE_upd3_q;
p1_way_data_upd62_wayE    <=  p1_congr_cl62_act_q  and reload_wayE_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu62_wayE_upd(0) <=  p1_way_data_upd62_wayE   and p1_wren_q;
rel_bixu62_wayE_upd(1) <=  p0_way_data_upd62_wayE   and p0_wren_q;
p0_way_data_upd62_wayF    <=  p0_congr_cl62_act_q  and binv_wayF_upd3_q;
p1_way_data_upd62_wayF    <=  p1_congr_cl62_act_q  and reload_wayF_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu62_wayF_upd(0) <=  p1_way_data_upd62_wayF   and p1_wren_q;
rel_bixu62_wayF_upd(1) <=  p0_way_data_upd62_wayF   and p0_wren_q;
p0_way_data_upd62_wayG    <=  p0_congr_cl62_act_q  and binv_wayG_upd3_q;
p1_way_data_upd62_wayG    <=  p1_congr_cl62_act_q  and reload_wayG_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu62_wayG_upd(0) <=  p1_way_data_upd62_wayG   and p1_wren_q;
rel_bixu62_wayG_upd(1) <=  p0_way_data_upd62_wayG   and p0_wren_q;
p0_way_data_upd62_wayH    <=  p0_congr_cl62_act_q  and binv_wayH_upd3_q;
p1_way_data_upd62_wayH    <=  p1_congr_cl62_act_q  and reload_wayH_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu62_wayH_upd(0) <=  p1_way_data_upd62_wayH   and p1_wren_q;
rel_bixu62_wayH_upd(1) <=  p0_way_data_upd62_wayH   and p0_wren_q;
-- Congruence Class Match
p0_congr_cl63_m       <=  (ex5_congr_cl_q    = tconv(63,6));
p1_congr_cl63_m       <=  (relu_s_congr_cl_q = tconv(63,6));
-- Act Pin to Directory Latches for specific congruence class
p0_congr_cl63_act_d   <=  p0_congr_cl63_m  and (back_inval_stg5_q or ex5_xuop_val_q or ex5_dir_err_val_q);
p1_congr_cl63_act_d   <=  p1_congr_cl63_m  and rel_port_wren_q;
congr_cl63_act        <=  p0_congr_cl63_act_q  or p1_congr_cl63_act_q  or congr_cl_all_act_q;
p0_way_data_upd63_wayA    <=  p0_congr_cl63_act_q  and binv_wayA_upd3_q;
p1_way_data_upd63_wayA    <=  p1_congr_cl63_act_q  and reload_wayA_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu63_wayA_upd(0) <=  p1_way_data_upd63_wayA   and p1_wren_q;
rel_bixu63_wayA_upd(1) <=  p0_way_data_upd63_wayA   and p0_wren_q;
p0_way_data_upd63_wayB    <=  p0_congr_cl63_act_q  and binv_wayB_upd3_q;
p1_way_data_upd63_wayB    <=  p1_congr_cl63_act_q  and reload_wayB_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu63_wayB_upd(0) <=  p1_way_data_upd63_wayB   and p1_wren_q;
rel_bixu63_wayB_upd(1) <=  p0_way_data_upd63_wayB   and p0_wren_q;
p0_way_data_upd63_wayC    <=  p0_congr_cl63_act_q  and binv_wayC_upd3_q;
p1_way_data_upd63_wayC    <=  p1_congr_cl63_act_q  and reload_wayC_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu63_wayC_upd(0) <=  p1_way_data_upd63_wayC   and p1_wren_q;
rel_bixu63_wayC_upd(1) <=  p0_way_data_upd63_wayC   and p0_wren_q;
p0_way_data_upd63_wayD    <=  p0_congr_cl63_act_q  and binv_wayD_upd3_q;
p1_way_data_upd63_wayD    <=  p1_congr_cl63_act_q  and reload_wayD_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu63_wayD_upd(0) <=  p1_way_data_upd63_wayD   and p1_wren_q;
rel_bixu63_wayD_upd(1) <=  p0_way_data_upd63_wayD   and p0_wren_q;
p0_way_data_upd63_wayE    <=  p0_congr_cl63_act_q  and binv_wayE_upd3_q;
p1_way_data_upd63_wayE    <=  p1_congr_cl63_act_q  and reload_wayE_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu63_wayE_upd(0) <=  p1_way_data_upd63_wayE   and p1_wren_q;
rel_bixu63_wayE_upd(1) <=  p0_way_data_upd63_wayE   and p0_wren_q;
p0_way_data_upd63_wayF    <=  p0_congr_cl63_act_q  and binv_wayF_upd3_q;
p1_way_data_upd63_wayF    <=  p1_congr_cl63_act_q  and reload_wayF_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu63_wayF_upd(0) <=  p1_way_data_upd63_wayF   and p1_wren_q;
rel_bixu63_wayF_upd(1) <=  p0_way_data_upd63_wayF   and p0_wren_q;
p0_way_data_upd63_wayG    <=  p0_congr_cl63_act_q  and binv_wayG_upd3_q;
p1_way_data_upd63_wayG    <=  p1_congr_cl63_act_q  and reload_wayG_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu63_wayG_upd(0) <=  p1_way_data_upd63_wayG   and p1_wren_q;
rel_bixu63_wayG_upd(1) <=  p0_way_data_upd63_wayG   and p0_wren_q;
p0_way_data_upd63_wayH    <=  p0_congr_cl63_act_q  and binv_wayH_upd3_q;
p1_way_data_upd63_wayH    <=  p1_congr_cl63_act_q  and reload_wayH_upd3_q;
-- Mux Selects for Input to Latches
rel_bixu63_wayH_upd(0) <=  p1_way_data_upd63_wayH   and p1_wren_q;
rel_bixu63_wayH_upd(1) <=  p0_way_data_upd63_wayH   and p0_wren_q;
-- XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
-- Write Select for WayA
-- WayA   Valid Bit Update for Congruence Class 0
with rel_bixu0_wayA_upd     select
    congr_cl0_wA_d(0)      <=   (congr_cl0_wA_q(0)     and not dci_inval_all_q) when "00",
                           (flush_wayA_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayA_data2_q(0)   and not dci_inval_all_q) when others;
-- WayA   Lock Bit Update for Congruence Class 0
with rel_bixu0_wayA_upd     select
    congr_cl0_wA_d(1)      <=   (congr_cl0_wA_q(1)     and not lock_finval) when "00",
                           (flush_wayA_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayA_data2_q(1)   and not lock_finval) when others;
-- WayA   Thread 0   Watch Bit Update for Congruence Class 0
with rel_bixu0_wayA_upd     select
    congr_cl0_wA_d(2)      <=   (congr_cl0_wA_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayA   Thread 1   Watch Bit Update for Congruence Class 0
with rel_bixu0_wayA_upd     select
    congr_cl0_wA_d(3)      <=   (congr_cl0_wA_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayA   Thread 2   Watch Bit Update for Congruence Class 0
with rel_bixu0_wayA_upd     select
    congr_cl0_wA_d(4)      <=   (congr_cl0_wA_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayA   Thread 3   Watch Bit Update for Congruence Class 0
with rel_bixu0_wayA_upd     select
    congr_cl0_wA_d(5)      <=   (congr_cl0_wA_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayA   Valid Bit Update for Congruence Class 1
with rel_bixu1_wayA_upd     select
    congr_cl1_wA_d(0)      <=   (congr_cl1_wA_q(0)     and not dci_inval_all_q) when "00",
                           (flush_wayA_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayA_data2_q(0)   and not dci_inval_all_q) when others;
-- WayA   Lock Bit Update for Congruence Class 1
with rel_bixu1_wayA_upd     select
    congr_cl1_wA_d(1)      <=   (congr_cl1_wA_q(1)     and not lock_finval) when "00",
                           (flush_wayA_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayA_data2_q(1)   and not lock_finval) when others;
-- WayA   Thread 0   Watch Bit Update for Congruence Class 1
with rel_bixu1_wayA_upd     select
    congr_cl1_wA_d(2)      <=   (congr_cl1_wA_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayA   Thread 1   Watch Bit Update for Congruence Class 1
with rel_bixu1_wayA_upd     select
    congr_cl1_wA_d(3)      <=   (congr_cl1_wA_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayA   Thread 2   Watch Bit Update for Congruence Class 1
with rel_bixu1_wayA_upd     select
    congr_cl1_wA_d(4)      <=   (congr_cl1_wA_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayA   Thread 3   Watch Bit Update for Congruence Class 1
with rel_bixu1_wayA_upd     select
    congr_cl1_wA_d(5)      <=   (congr_cl1_wA_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayA   Valid Bit Update for Congruence Class 2
with rel_bixu2_wayA_upd     select
    congr_cl2_wA_d(0)      <=   (congr_cl2_wA_q(0)     and not dci_inval_all_q) when "00",
                           (flush_wayA_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayA_data2_q(0)   and not dci_inval_all_q) when others;
-- WayA   Lock Bit Update for Congruence Class 2
with rel_bixu2_wayA_upd     select
    congr_cl2_wA_d(1)      <=   (congr_cl2_wA_q(1)     and not lock_finval) when "00",
                           (flush_wayA_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayA_data2_q(1)   and not lock_finval) when others;
-- WayA   Thread 0   Watch Bit Update for Congruence Class 2
with rel_bixu2_wayA_upd     select
    congr_cl2_wA_d(2)      <=   (congr_cl2_wA_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayA   Thread 1   Watch Bit Update for Congruence Class 2
with rel_bixu2_wayA_upd     select
    congr_cl2_wA_d(3)      <=   (congr_cl2_wA_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayA   Thread 2   Watch Bit Update for Congruence Class 2
with rel_bixu2_wayA_upd     select
    congr_cl2_wA_d(4)      <=   (congr_cl2_wA_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayA   Thread 3   Watch Bit Update for Congruence Class 2
with rel_bixu2_wayA_upd     select
    congr_cl2_wA_d(5)      <=   (congr_cl2_wA_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayA   Valid Bit Update for Congruence Class 3
with rel_bixu3_wayA_upd     select
    congr_cl3_wA_d(0)      <=   (congr_cl3_wA_q(0)     and not dci_inval_all_q) when "00",
                           (flush_wayA_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayA_data2_q(0)   and not dci_inval_all_q) when others;
-- WayA   Lock Bit Update for Congruence Class 3
with rel_bixu3_wayA_upd     select
    congr_cl3_wA_d(1)      <=   (congr_cl3_wA_q(1)     and not lock_finval) when "00",
                           (flush_wayA_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayA_data2_q(1)   and not lock_finval) when others;
-- WayA   Thread 0   Watch Bit Update for Congruence Class 3
with rel_bixu3_wayA_upd     select
    congr_cl3_wA_d(2)      <=   (congr_cl3_wA_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayA   Thread 1   Watch Bit Update for Congruence Class 3
with rel_bixu3_wayA_upd     select
    congr_cl3_wA_d(3)      <=   (congr_cl3_wA_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayA   Thread 2   Watch Bit Update for Congruence Class 3
with rel_bixu3_wayA_upd     select
    congr_cl3_wA_d(4)      <=   (congr_cl3_wA_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayA   Thread 3   Watch Bit Update for Congruence Class 3
with rel_bixu3_wayA_upd     select
    congr_cl3_wA_d(5)      <=   (congr_cl3_wA_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayA   Valid Bit Update for Congruence Class 4
with rel_bixu4_wayA_upd     select
    congr_cl4_wA_d(0)      <=   (congr_cl4_wA_q(0)     and not dci_inval_all_q) when "00",
                           (flush_wayA_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayA_data2_q(0)   and not dci_inval_all_q) when others;
-- WayA   Lock Bit Update for Congruence Class 4
with rel_bixu4_wayA_upd     select
    congr_cl4_wA_d(1)      <=   (congr_cl4_wA_q(1)     and not lock_finval) when "00",
                           (flush_wayA_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayA_data2_q(1)   and not lock_finval) when others;
-- WayA   Thread 0   Watch Bit Update for Congruence Class 4
with rel_bixu4_wayA_upd     select
    congr_cl4_wA_d(2)      <=   (congr_cl4_wA_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayA   Thread 1   Watch Bit Update for Congruence Class 4
with rel_bixu4_wayA_upd     select
    congr_cl4_wA_d(3)      <=   (congr_cl4_wA_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayA   Thread 2   Watch Bit Update for Congruence Class 4
with rel_bixu4_wayA_upd     select
    congr_cl4_wA_d(4)      <=   (congr_cl4_wA_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayA   Thread 3   Watch Bit Update for Congruence Class 4
with rel_bixu4_wayA_upd     select
    congr_cl4_wA_d(5)      <=   (congr_cl4_wA_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayA   Valid Bit Update for Congruence Class 5
with rel_bixu5_wayA_upd     select
    congr_cl5_wA_d(0)      <=   (congr_cl5_wA_q(0)     and not dci_inval_all_q) when "00",
                           (flush_wayA_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayA_data2_q(0)   and not dci_inval_all_q) when others;
-- WayA   Lock Bit Update for Congruence Class 5
with rel_bixu5_wayA_upd     select
    congr_cl5_wA_d(1)      <=   (congr_cl5_wA_q(1)     and not lock_finval) when "00",
                           (flush_wayA_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayA_data2_q(1)   and not lock_finval) when others;
-- WayA   Thread 0   Watch Bit Update for Congruence Class 5
with rel_bixu5_wayA_upd     select
    congr_cl5_wA_d(2)      <=   (congr_cl5_wA_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayA   Thread 1   Watch Bit Update for Congruence Class 5
with rel_bixu5_wayA_upd     select
    congr_cl5_wA_d(3)      <=   (congr_cl5_wA_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayA   Thread 2   Watch Bit Update for Congruence Class 5
with rel_bixu5_wayA_upd     select
    congr_cl5_wA_d(4)      <=   (congr_cl5_wA_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayA   Thread 3   Watch Bit Update for Congruence Class 5
with rel_bixu5_wayA_upd     select
    congr_cl5_wA_d(5)      <=   (congr_cl5_wA_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayA   Valid Bit Update for Congruence Class 6
with rel_bixu6_wayA_upd     select
    congr_cl6_wA_d(0)      <=   (congr_cl6_wA_q(0)     and not dci_inval_all_q) when "00",
                           (flush_wayA_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayA_data2_q(0)   and not dci_inval_all_q) when others;
-- WayA   Lock Bit Update for Congruence Class 6
with rel_bixu6_wayA_upd     select
    congr_cl6_wA_d(1)      <=   (congr_cl6_wA_q(1)     and not lock_finval) when "00",
                           (flush_wayA_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayA_data2_q(1)   and not lock_finval) when others;
-- WayA   Thread 0   Watch Bit Update for Congruence Class 6
with rel_bixu6_wayA_upd     select
    congr_cl6_wA_d(2)      <=   (congr_cl6_wA_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayA   Thread 1   Watch Bit Update for Congruence Class 6
with rel_bixu6_wayA_upd     select
    congr_cl6_wA_d(3)      <=   (congr_cl6_wA_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayA   Thread 2   Watch Bit Update for Congruence Class 6
with rel_bixu6_wayA_upd     select
    congr_cl6_wA_d(4)      <=   (congr_cl6_wA_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayA   Thread 3   Watch Bit Update for Congruence Class 6
with rel_bixu6_wayA_upd     select
    congr_cl6_wA_d(5)      <=   (congr_cl6_wA_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayA   Valid Bit Update for Congruence Class 7
with rel_bixu7_wayA_upd     select
    congr_cl7_wA_d(0)      <=   (congr_cl7_wA_q(0)     and not dci_inval_all_q) when "00",
                           (flush_wayA_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayA_data2_q(0)   and not dci_inval_all_q) when others;
-- WayA   Lock Bit Update for Congruence Class 7
with rel_bixu7_wayA_upd     select
    congr_cl7_wA_d(1)      <=   (congr_cl7_wA_q(1)     and not lock_finval) when "00",
                           (flush_wayA_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayA_data2_q(1)   and not lock_finval) when others;
-- WayA   Thread 0   Watch Bit Update for Congruence Class 7
with rel_bixu7_wayA_upd     select
    congr_cl7_wA_d(2)      <=   (congr_cl7_wA_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayA   Thread 1   Watch Bit Update for Congruence Class 7
with rel_bixu7_wayA_upd     select
    congr_cl7_wA_d(3)      <=   (congr_cl7_wA_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayA   Thread 2   Watch Bit Update for Congruence Class 7
with rel_bixu7_wayA_upd     select
    congr_cl7_wA_d(4)      <=   (congr_cl7_wA_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayA   Thread 3   Watch Bit Update for Congruence Class 7
with rel_bixu7_wayA_upd     select
    congr_cl7_wA_d(5)      <=   (congr_cl7_wA_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayA   Valid Bit Update for Congruence Class 8
with rel_bixu8_wayA_upd     select
    congr_cl8_wA_d(0)      <=   (congr_cl8_wA_q(0)     and not dci_inval_all_q) when "00",
                           (flush_wayA_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayA_data2_q(0)   and not dci_inval_all_q) when others;
-- WayA   Lock Bit Update for Congruence Class 8
with rel_bixu8_wayA_upd     select
    congr_cl8_wA_d(1)      <=   (congr_cl8_wA_q(1)     and not lock_finval) when "00",
                           (flush_wayA_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayA_data2_q(1)   and not lock_finval) when others;
-- WayA   Thread 0   Watch Bit Update for Congruence Class 8
with rel_bixu8_wayA_upd     select
    congr_cl8_wA_d(2)      <=   (congr_cl8_wA_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayA   Thread 1   Watch Bit Update for Congruence Class 8
with rel_bixu8_wayA_upd     select
    congr_cl8_wA_d(3)      <=   (congr_cl8_wA_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayA   Thread 2   Watch Bit Update for Congruence Class 8
with rel_bixu8_wayA_upd     select
    congr_cl8_wA_d(4)      <=   (congr_cl8_wA_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayA   Thread 3   Watch Bit Update for Congruence Class 8
with rel_bixu8_wayA_upd     select
    congr_cl8_wA_d(5)      <=   (congr_cl8_wA_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayA   Valid Bit Update for Congruence Class 9
with rel_bixu9_wayA_upd     select
    congr_cl9_wA_d(0)      <=   (congr_cl9_wA_q(0)     and not dci_inval_all_q) when "00",
                           (flush_wayA_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayA_data2_q(0)   and not dci_inval_all_q) when others;
-- WayA   Lock Bit Update for Congruence Class 9
with rel_bixu9_wayA_upd     select
    congr_cl9_wA_d(1)      <=   (congr_cl9_wA_q(1)     and not lock_finval) when "00",
                           (flush_wayA_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayA_data2_q(1)   and not lock_finval) when others;
-- WayA   Thread 0   Watch Bit Update for Congruence Class 9
with rel_bixu9_wayA_upd     select
    congr_cl9_wA_d(2)      <=   (congr_cl9_wA_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayA   Thread 1   Watch Bit Update for Congruence Class 9
with rel_bixu9_wayA_upd     select
    congr_cl9_wA_d(3)      <=   (congr_cl9_wA_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayA   Thread 2   Watch Bit Update for Congruence Class 9
with rel_bixu9_wayA_upd     select
    congr_cl9_wA_d(4)      <=   (congr_cl9_wA_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayA   Thread 3   Watch Bit Update for Congruence Class 9
with rel_bixu9_wayA_upd     select
    congr_cl9_wA_d(5)      <=   (congr_cl9_wA_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayA   Valid Bit Update for Congruence Class 10
with rel_bixu10_wayA_upd    select
    congr_cl10_wA_d(0)     <=   (congr_cl10_wA_q(0)    and not dci_inval_all_q) when "00",
                           (flush_wayA_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayA_data2_q(0)   and not dci_inval_all_q) when others;
-- WayA   Lock Bit Update for Congruence Class 10
with rel_bixu10_wayA_upd    select
    congr_cl10_wA_d(1)     <=   (congr_cl10_wA_q(1)    and not lock_finval) when "00",
                           (flush_wayA_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayA_data2_q(1)   and not lock_finval) when others;
-- WayA   Thread 0   Watch Bit Update for Congruence Class 10
with rel_bixu10_wayA_upd    select
    congr_cl10_wA_d(2)      <=   (congr_cl10_wA_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayA   Thread 1   Watch Bit Update for Congruence Class 10
with rel_bixu10_wayA_upd    select
    congr_cl10_wA_d(3)      <=   (congr_cl10_wA_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayA   Thread 2   Watch Bit Update for Congruence Class 10
with rel_bixu10_wayA_upd    select
    congr_cl10_wA_d(4)      <=   (congr_cl10_wA_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayA   Thread 3   Watch Bit Update for Congruence Class 10
with rel_bixu10_wayA_upd    select
    congr_cl10_wA_d(5)      <=   (congr_cl10_wA_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayA   Valid Bit Update for Congruence Class 11
with rel_bixu11_wayA_upd    select
    congr_cl11_wA_d(0)     <=   (congr_cl11_wA_q(0)    and not dci_inval_all_q) when "00",
                           (flush_wayA_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayA_data2_q(0)   and not dci_inval_all_q) when others;
-- WayA   Lock Bit Update for Congruence Class 11
with rel_bixu11_wayA_upd    select
    congr_cl11_wA_d(1)     <=   (congr_cl11_wA_q(1)    and not lock_finval) when "00",
                           (flush_wayA_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayA_data2_q(1)   and not lock_finval) when others;
-- WayA   Thread 0   Watch Bit Update for Congruence Class 11
with rel_bixu11_wayA_upd    select
    congr_cl11_wA_d(2)      <=   (congr_cl11_wA_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayA   Thread 1   Watch Bit Update for Congruence Class 11
with rel_bixu11_wayA_upd    select
    congr_cl11_wA_d(3)      <=   (congr_cl11_wA_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayA   Thread 2   Watch Bit Update for Congruence Class 11
with rel_bixu11_wayA_upd    select
    congr_cl11_wA_d(4)      <=   (congr_cl11_wA_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayA   Thread 3   Watch Bit Update for Congruence Class 11
with rel_bixu11_wayA_upd    select
    congr_cl11_wA_d(5)      <=   (congr_cl11_wA_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayA   Valid Bit Update for Congruence Class 12
with rel_bixu12_wayA_upd    select
    congr_cl12_wA_d(0)     <=   (congr_cl12_wA_q(0)    and not dci_inval_all_q) when "00",
                           (flush_wayA_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayA_data2_q(0)   and not dci_inval_all_q) when others;
-- WayA   Lock Bit Update for Congruence Class 12
with rel_bixu12_wayA_upd    select
    congr_cl12_wA_d(1)     <=   (congr_cl12_wA_q(1)    and not lock_finval) when "00",
                           (flush_wayA_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayA_data2_q(1)   and not lock_finval) when others;
-- WayA   Thread 0   Watch Bit Update for Congruence Class 12
with rel_bixu12_wayA_upd    select
    congr_cl12_wA_d(2)      <=   (congr_cl12_wA_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayA   Thread 1   Watch Bit Update for Congruence Class 12
with rel_bixu12_wayA_upd    select
    congr_cl12_wA_d(3)      <=   (congr_cl12_wA_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayA   Thread 2   Watch Bit Update for Congruence Class 12
with rel_bixu12_wayA_upd    select
    congr_cl12_wA_d(4)      <=   (congr_cl12_wA_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayA   Thread 3   Watch Bit Update for Congruence Class 12
with rel_bixu12_wayA_upd    select
    congr_cl12_wA_d(5)      <=   (congr_cl12_wA_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayA   Valid Bit Update for Congruence Class 13
with rel_bixu13_wayA_upd    select
    congr_cl13_wA_d(0)     <=   (congr_cl13_wA_q(0)    and not dci_inval_all_q) when "00",
                           (flush_wayA_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayA_data2_q(0)   and not dci_inval_all_q) when others;
-- WayA   Lock Bit Update for Congruence Class 13
with rel_bixu13_wayA_upd    select
    congr_cl13_wA_d(1)     <=   (congr_cl13_wA_q(1)    and not lock_finval) when "00",
                           (flush_wayA_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayA_data2_q(1)   and not lock_finval) when others;
-- WayA   Thread 0   Watch Bit Update for Congruence Class 13
with rel_bixu13_wayA_upd    select
    congr_cl13_wA_d(2)      <=   (congr_cl13_wA_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayA   Thread 1   Watch Bit Update for Congruence Class 13
with rel_bixu13_wayA_upd    select
    congr_cl13_wA_d(3)      <=   (congr_cl13_wA_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayA   Thread 2   Watch Bit Update for Congruence Class 13
with rel_bixu13_wayA_upd    select
    congr_cl13_wA_d(4)      <=   (congr_cl13_wA_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayA   Thread 3   Watch Bit Update for Congruence Class 13
with rel_bixu13_wayA_upd    select
    congr_cl13_wA_d(5)      <=   (congr_cl13_wA_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayA   Valid Bit Update for Congruence Class 14
with rel_bixu14_wayA_upd    select
    congr_cl14_wA_d(0)     <=   (congr_cl14_wA_q(0)    and not dci_inval_all_q) when "00",
                           (flush_wayA_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayA_data2_q(0)   and not dci_inval_all_q) when others;
-- WayA   Lock Bit Update for Congruence Class 14
with rel_bixu14_wayA_upd    select
    congr_cl14_wA_d(1)     <=   (congr_cl14_wA_q(1)    and not lock_finval) when "00",
                           (flush_wayA_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayA_data2_q(1)   and not lock_finval) when others;
-- WayA   Thread 0   Watch Bit Update for Congruence Class 14
with rel_bixu14_wayA_upd    select
    congr_cl14_wA_d(2)      <=   (congr_cl14_wA_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayA   Thread 1   Watch Bit Update for Congruence Class 14
with rel_bixu14_wayA_upd    select
    congr_cl14_wA_d(3)      <=   (congr_cl14_wA_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayA   Thread 2   Watch Bit Update for Congruence Class 14
with rel_bixu14_wayA_upd    select
    congr_cl14_wA_d(4)      <=   (congr_cl14_wA_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayA   Thread 3   Watch Bit Update for Congruence Class 14
with rel_bixu14_wayA_upd    select
    congr_cl14_wA_d(5)      <=   (congr_cl14_wA_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayA   Valid Bit Update for Congruence Class 15
with rel_bixu15_wayA_upd    select
    congr_cl15_wA_d(0)     <=   (congr_cl15_wA_q(0)    and not dci_inval_all_q) when "00",
                           (flush_wayA_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayA_data2_q(0)   and not dci_inval_all_q) when others;
-- WayA   Lock Bit Update for Congruence Class 15
with rel_bixu15_wayA_upd    select
    congr_cl15_wA_d(1)     <=   (congr_cl15_wA_q(1)    and not lock_finval) when "00",
                           (flush_wayA_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayA_data2_q(1)   and not lock_finval) when others;
-- WayA   Thread 0   Watch Bit Update for Congruence Class 15
with rel_bixu15_wayA_upd    select
    congr_cl15_wA_d(2)      <=   (congr_cl15_wA_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayA   Thread 1   Watch Bit Update for Congruence Class 15
with rel_bixu15_wayA_upd    select
    congr_cl15_wA_d(3)      <=   (congr_cl15_wA_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayA   Thread 2   Watch Bit Update for Congruence Class 15
with rel_bixu15_wayA_upd    select
    congr_cl15_wA_d(4)      <=   (congr_cl15_wA_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayA   Thread 3   Watch Bit Update for Congruence Class 15
with rel_bixu15_wayA_upd    select
    congr_cl15_wA_d(5)      <=   (congr_cl15_wA_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayA   Valid Bit Update for Congruence Class 16
with rel_bixu16_wayA_upd    select
    congr_cl16_wA_d(0)     <=   (congr_cl16_wA_q(0)    and not dci_inval_all_q) when "00",
                           (flush_wayA_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayA_data2_q(0)   and not dci_inval_all_q) when others;
-- WayA   Lock Bit Update for Congruence Class 16
with rel_bixu16_wayA_upd    select
    congr_cl16_wA_d(1)     <=   (congr_cl16_wA_q(1)    and not lock_finval) when "00",
                           (flush_wayA_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayA_data2_q(1)   and not lock_finval) when others;
-- WayA   Thread 0   Watch Bit Update for Congruence Class 16
with rel_bixu16_wayA_upd    select
    congr_cl16_wA_d(2)      <=   (congr_cl16_wA_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayA   Thread 1   Watch Bit Update for Congruence Class 16
with rel_bixu16_wayA_upd    select
    congr_cl16_wA_d(3)      <=   (congr_cl16_wA_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayA   Thread 2   Watch Bit Update for Congruence Class 16
with rel_bixu16_wayA_upd    select
    congr_cl16_wA_d(4)      <=   (congr_cl16_wA_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayA   Thread 3   Watch Bit Update for Congruence Class 16
with rel_bixu16_wayA_upd    select
    congr_cl16_wA_d(5)      <=   (congr_cl16_wA_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayA   Valid Bit Update for Congruence Class 17
with rel_bixu17_wayA_upd    select
    congr_cl17_wA_d(0)     <=   (congr_cl17_wA_q(0)    and not dci_inval_all_q) when "00",
                           (flush_wayA_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayA_data2_q(0)   and not dci_inval_all_q) when others;
-- WayA   Lock Bit Update for Congruence Class 17
with rel_bixu17_wayA_upd    select
    congr_cl17_wA_d(1)     <=   (congr_cl17_wA_q(1)    and not lock_finval) when "00",
                           (flush_wayA_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayA_data2_q(1)   and not lock_finval) when others;
-- WayA   Thread 0   Watch Bit Update for Congruence Class 17
with rel_bixu17_wayA_upd    select
    congr_cl17_wA_d(2)      <=   (congr_cl17_wA_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayA   Thread 1   Watch Bit Update for Congruence Class 17
with rel_bixu17_wayA_upd    select
    congr_cl17_wA_d(3)      <=   (congr_cl17_wA_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayA   Thread 2   Watch Bit Update for Congruence Class 17
with rel_bixu17_wayA_upd    select
    congr_cl17_wA_d(4)      <=   (congr_cl17_wA_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayA   Thread 3   Watch Bit Update for Congruence Class 17
with rel_bixu17_wayA_upd    select
    congr_cl17_wA_d(5)      <=   (congr_cl17_wA_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayA   Valid Bit Update for Congruence Class 18
with rel_bixu18_wayA_upd    select
    congr_cl18_wA_d(0)     <=   (congr_cl18_wA_q(0)    and not dci_inval_all_q) when "00",
                           (flush_wayA_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayA_data2_q(0)   and not dci_inval_all_q) when others;
-- WayA   Lock Bit Update for Congruence Class 18
with rel_bixu18_wayA_upd    select
    congr_cl18_wA_d(1)     <=   (congr_cl18_wA_q(1)    and not lock_finval) when "00",
                           (flush_wayA_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayA_data2_q(1)   and not lock_finval) when others;
-- WayA   Thread 0   Watch Bit Update for Congruence Class 18
with rel_bixu18_wayA_upd    select
    congr_cl18_wA_d(2)      <=   (congr_cl18_wA_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayA   Thread 1   Watch Bit Update for Congruence Class 18
with rel_bixu18_wayA_upd    select
    congr_cl18_wA_d(3)      <=   (congr_cl18_wA_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayA   Thread 2   Watch Bit Update for Congruence Class 18
with rel_bixu18_wayA_upd    select
    congr_cl18_wA_d(4)      <=   (congr_cl18_wA_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayA   Thread 3   Watch Bit Update for Congruence Class 18
with rel_bixu18_wayA_upd    select
    congr_cl18_wA_d(5)      <=   (congr_cl18_wA_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayA   Valid Bit Update for Congruence Class 19
with rel_bixu19_wayA_upd    select
    congr_cl19_wA_d(0)     <=   (congr_cl19_wA_q(0)    and not dci_inval_all_q) when "00",
                           (flush_wayA_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayA_data2_q(0)   and not dci_inval_all_q) when others;
-- WayA   Lock Bit Update for Congruence Class 19
with rel_bixu19_wayA_upd    select
    congr_cl19_wA_d(1)     <=   (congr_cl19_wA_q(1)    and not lock_finval) when "00",
                           (flush_wayA_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayA_data2_q(1)   and not lock_finval) when others;
-- WayA   Thread 0   Watch Bit Update for Congruence Class 19
with rel_bixu19_wayA_upd    select
    congr_cl19_wA_d(2)      <=   (congr_cl19_wA_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayA   Thread 1   Watch Bit Update for Congruence Class 19
with rel_bixu19_wayA_upd    select
    congr_cl19_wA_d(3)      <=   (congr_cl19_wA_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayA   Thread 2   Watch Bit Update for Congruence Class 19
with rel_bixu19_wayA_upd    select
    congr_cl19_wA_d(4)      <=   (congr_cl19_wA_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayA   Thread 3   Watch Bit Update for Congruence Class 19
with rel_bixu19_wayA_upd    select
    congr_cl19_wA_d(5)      <=   (congr_cl19_wA_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayA   Valid Bit Update for Congruence Class 20
with rel_bixu20_wayA_upd    select
    congr_cl20_wA_d(0)     <=   (congr_cl20_wA_q(0)    and not dci_inval_all_q) when "00",
                           (flush_wayA_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayA_data2_q(0)   and not dci_inval_all_q) when others;
-- WayA   Lock Bit Update for Congruence Class 20
with rel_bixu20_wayA_upd    select
    congr_cl20_wA_d(1)     <=   (congr_cl20_wA_q(1)    and not lock_finval) when "00",
                           (flush_wayA_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayA_data2_q(1)   and not lock_finval) when others;
-- WayA   Thread 0   Watch Bit Update for Congruence Class 20
with rel_bixu20_wayA_upd    select
    congr_cl20_wA_d(2)      <=   (congr_cl20_wA_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayA   Thread 1   Watch Bit Update for Congruence Class 20
with rel_bixu20_wayA_upd    select
    congr_cl20_wA_d(3)      <=   (congr_cl20_wA_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayA   Thread 2   Watch Bit Update for Congruence Class 20
with rel_bixu20_wayA_upd    select
    congr_cl20_wA_d(4)      <=   (congr_cl20_wA_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayA   Thread 3   Watch Bit Update for Congruence Class 20
with rel_bixu20_wayA_upd    select
    congr_cl20_wA_d(5)      <=   (congr_cl20_wA_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayA   Valid Bit Update for Congruence Class 21
with rel_bixu21_wayA_upd    select
    congr_cl21_wA_d(0)     <=   (congr_cl21_wA_q(0)    and not dci_inval_all_q) when "00",
                           (flush_wayA_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayA_data2_q(0)   and not dci_inval_all_q) when others;
-- WayA   Lock Bit Update for Congruence Class 21
with rel_bixu21_wayA_upd    select
    congr_cl21_wA_d(1)     <=   (congr_cl21_wA_q(1)    and not lock_finval) when "00",
                           (flush_wayA_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayA_data2_q(1)   and not lock_finval) when others;
-- WayA   Thread 0   Watch Bit Update for Congruence Class 21
with rel_bixu21_wayA_upd    select
    congr_cl21_wA_d(2)      <=   (congr_cl21_wA_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayA   Thread 1   Watch Bit Update for Congruence Class 21
with rel_bixu21_wayA_upd    select
    congr_cl21_wA_d(3)      <=   (congr_cl21_wA_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayA   Thread 2   Watch Bit Update for Congruence Class 21
with rel_bixu21_wayA_upd    select
    congr_cl21_wA_d(4)      <=   (congr_cl21_wA_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayA   Thread 3   Watch Bit Update for Congruence Class 21
with rel_bixu21_wayA_upd    select
    congr_cl21_wA_d(5)      <=   (congr_cl21_wA_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayA   Valid Bit Update for Congruence Class 22
with rel_bixu22_wayA_upd    select
    congr_cl22_wA_d(0)     <=   (congr_cl22_wA_q(0)    and not dci_inval_all_q) when "00",
                           (flush_wayA_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayA_data2_q(0)   and not dci_inval_all_q) when others;
-- WayA   Lock Bit Update for Congruence Class 22
with rel_bixu22_wayA_upd    select
    congr_cl22_wA_d(1)     <=   (congr_cl22_wA_q(1)    and not lock_finval) when "00",
                           (flush_wayA_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayA_data2_q(1)   and not lock_finval) when others;
-- WayA   Thread 0   Watch Bit Update for Congruence Class 22
with rel_bixu22_wayA_upd    select
    congr_cl22_wA_d(2)      <=   (congr_cl22_wA_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayA   Thread 1   Watch Bit Update for Congruence Class 22
with rel_bixu22_wayA_upd    select
    congr_cl22_wA_d(3)      <=   (congr_cl22_wA_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayA   Thread 2   Watch Bit Update for Congruence Class 22
with rel_bixu22_wayA_upd    select
    congr_cl22_wA_d(4)      <=   (congr_cl22_wA_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayA   Thread 3   Watch Bit Update for Congruence Class 22
with rel_bixu22_wayA_upd    select
    congr_cl22_wA_d(5)      <=   (congr_cl22_wA_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayA   Valid Bit Update for Congruence Class 23
with rel_bixu23_wayA_upd    select
    congr_cl23_wA_d(0)     <=   (congr_cl23_wA_q(0)    and not dci_inval_all_q) when "00",
                           (flush_wayA_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayA_data2_q(0)   and not dci_inval_all_q) when others;
-- WayA   Lock Bit Update for Congruence Class 23
with rel_bixu23_wayA_upd    select
    congr_cl23_wA_d(1)     <=   (congr_cl23_wA_q(1)    and not lock_finval) when "00",
                           (flush_wayA_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayA_data2_q(1)   and not lock_finval) when others;
-- WayA   Thread 0   Watch Bit Update for Congruence Class 23
with rel_bixu23_wayA_upd    select
    congr_cl23_wA_d(2)      <=   (congr_cl23_wA_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayA   Thread 1   Watch Bit Update for Congruence Class 23
with rel_bixu23_wayA_upd    select
    congr_cl23_wA_d(3)      <=   (congr_cl23_wA_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayA   Thread 2   Watch Bit Update for Congruence Class 23
with rel_bixu23_wayA_upd    select
    congr_cl23_wA_d(4)      <=   (congr_cl23_wA_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayA   Thread 3   Watch Bit Update for Congruence Class 23
with rel_bixu23_wayA_upd    select
    congr_cl23_wA_d(5)      <=   (congr_cl23_wA_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayA   Valid Bit Update for Congruence Class 24
with rel_bixu24_wayA_upd    select
    congr_cl24_wA_d(0)     <=   (congr_cl24_wA_q(0)    and not dci_inval_all_q) when "00",
                           (flush_wayA_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayA_data2_q(0)   and not dci_inval_all_q) when others;
-- WayA   Lock Bit Update for Congruence Class 24
with rel_bixu24_wayA_upd    select
    congr_cl24_wA_d(1)     <=   (congr_cl24_wA_q(1)    and not lock_finval) when "00",
                           (flush_wayA_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayA_data2_q(1)   and not lock_finval) when others;
-- WayA   Thread 0   Watch Bit Update for Congruence Class 24
with rel_bixu24_wayA_upd    select
    congr_cl24_wA_d(2)      <=   (congr_cl24_wA_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayA   Thread 1   Watch Bit Update for Congruence Class 24
with rel_bixu24_wayA_upd    select
    congr_cl24_wA_d(3)      <=   (congr_cl24_wA_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayA   Thread 2   Watch Bit Update for Congruence Class 24
with rel_bixu24_wayA_upd    select
    congr_cl24_wA_d(4)      <=   (congr_cl24_wA_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayA   Thread 3   Watch Bit Update for Congruence Class 24
with rel_bixu24_wayA_upd    select
    congr_cl24_wA_d(5)      <=   (congr_cl24_wA_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayA   Valid Bit Update for Congruence Class 25
with rel_bixu25_wayA_upd    select
    congr_cl25_wA_d(0)     <=   (congr_cl25_wA_q(0)    and not dci_inval_all_q) when "00",
                           (flush_wayA_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayA_data2_q(0)   and not dci_inval_all_q) when others;
-- WayA   Lock Bit Update for Congruence Class 25
with rel_bixu25_wayA_upd    select
    congr_cl25_wA_d(1)     <=   (congr_cl25_wA_q(1)    and not lock_finval) when "00",
                           (flush_wayA_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayA_data2_q(1)   and not lock_finval) when others;
-- WayA   Thread 0   Watch Bit Update for Congruence Class 25
with rel_bixu25_wayA_upd    select
    congr_cl25_wA_d(2)      <=   (congr_cl25_wA_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayA   Thread 1   Watch Bit Update for Congruence Class 25
with rel_bixu25_wayA_upd    select
    congr_cl25_wA_d(3)      <=   (congr_cl25_wA_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayA   Thread 2   Watch Bit Update for Congruence Class 25
with rel_bixu25_wayA_upd    select
    congr_cl25_wA_d(4)      <=   (congr_cl25_wA_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayA   Thread 3   Watch Bit Update for Congruence Class 25
with rel_bixu25_wayA_upd    select
    congr_cl25_wA_d(5)      <=   (congr_cl25_wA_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayA   Valid Bit Update for Congruence Class 26
with rel_bixu26_wayA_upd    select
    congr_cl26_wA_d(0)     <=   (congr_cl26_wA_q(0)    and not dci_inval_all_q) when "00",
                           (flush_wayA_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayA_data2_q(0)   and not dci_inval_all_q) when others;
-- WayA   Lock Bit Update for Congruence Class 26
with rel_bixu26_wayA_upd    select
    congr_cl26_wA_d(1)     <=   (congr_cl26_wA_q(1)    and not lock_finval) when "00",
                           (flush_wayA_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayA_data2_q(1)   and not lock_finval) when others;
-- WayA   Thread 0   Watch Bit Update for Congruence Class 26
with rel_bixu26_wayA_upd    select
    congr_cl26_wA_d(2)      <=   (congr_cl26_wA_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayA   Thread 1   Watch Bit Update for Congruence Class 26
with rel_bixu26_wayA_upd    select
    congr_cl26_wA_d(3)      <=   (congr_cl26_wA_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayA   Thread 2   Watch Bit Update for Congruence Class 26
with rel_bixu26_wayA_upd    select
    congr_cl26_wA_d(4)      <=   (congr_cl26_wA_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayA   Thread 3   Watch Bit Update for Congruence Class 26
with rel_bixu26_wayA_upd    select
    congr_cl26_wA_d(5)      <=   (congr_cl26_wA_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayA   Valid Bit Update for Congruence Class 27
with rel_bixu27_wayA_upd    select
    congr_cl27_wA_d(0)     <=   (congr_cl27_wA_q(0)    and not dci_inval_all_q) when "00",
                           (flush_wayA_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayA_data2_q(0)   and not dci_inval_all_q) when others;
-- WayA   Lock Bit Update for Congruence Class 27
with rel_bixu27_wayA_upd    select
    congr_cl27_wA_d(1)     <=   (congr_cl27_wA_q(1)    and not lock_finval) when "00",
                           (flush_wayA_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayA_data2_q(1)   and not lock_finval) when others;
-- WayA   Thread 0   Watch Bit Update for Congruence Class 27
with rel_bixu27_wayA_upd    select
    congr_cl27_wA_d(2)      <=   (congr_cl27_wA_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayA   Thread 1   Watch Bit Update for Congruence Class 27
with rel_bixu27_wayA_upd    select
    congr_cl27_wA_d(3)      <=   (congr_cl27_wA_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayA   Thread 2   Watch Bit Update for Congruence Class 27
with rel_bixu27_wayA_upd    select
    congr_cl27_wA_d(4)      <=   (congr_cl27_wA_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayA   Thread 3   Watch Bit Update for Congruence Class 27
with rel_bixu27_wayA_upd    select
    congr_cl27_wA_d(5)      <=   (congr_cl27_wA_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayA   Valid Bit Update for Congruence Class 28
with rel_bixu28_wayA_upd    select
    congr_cl28_wA_d(0)     <=   (congr_cl28_wA_q(0)    and not dci_inval_all_q) when "00",
                           (flush_wayA_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayA_data2_q(0)   and not dci_inval_all_q) when others;
-- WayA   Lock Bit Update for Congruence Class 28
with rel_bixu28_wayA_upd    select
    congr_cl28_wA_d(1)     <=   (congr_cl28_wA_q(1)    and not lock_finval) when "00",
                           (flush_wayA_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayA_data2_q(1)   and not lock_finval) when others;
-- WayA   Thread 0   Watch Bit Update for Congruence Class 28
with rel_bixu28_wayA_upd    select
    congr_cl28_wA_d(2)      <=   (congr_cl28_wA_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayA   Thread 1   Watch Bit Update for Congruence Class 28
with rel_bixu28_wayA_upd    select
    congr_cl28_wA_d(3)      <=   (congr_cl28_wA_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayA   Thread 2   Watch Bit Update for Congruence Class 28
with rel_bixu28_wayA_upd    select
    congr_cl28_wA_d(4)      <=   (congr_cl28_wA_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayA   Thread 3   Watch Bit Update for Congruence Class 28
with rel_bixu28_wayA_upd    select
    congr_cl28_wA_d(5)      <=   (congr_cl28_wA_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayA   Valid Bit Update for Congruence Class 29
with rel_bixu29_wayA_upd    select
    congr_cl29_wA_d(0)     <=   (congr_cl29_wA_q(0)    and not dci_inval_all_q) when "00",
                           (flush_wayA_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayA_data2_q(0)   and not dci_inval_all_q) when others;
-- WayA   Lock Bit Update for Congruence Class 29
with rel_bixu29_wayA_upd    select
    congr_cl29_wA_d(1)     <=   (congr_cl29_wA_q(1)    and not lock_finval) when "00",
                           (flush_wayA_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayA_data2_q(1)   and not lock_finval) when others;
-- WayA   Thread 0   Watch Bit Update for Congruence Class 29
with rel_bixu29_wayA_upd    select
    congr_cl29_wA_d(2)      <=   (congr_cl29_wA_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayA   Thread 1   Watch Bit Update for Congruence Class 29
with rel_bixu29_wayA_upd    select
    congr_cl29_wA_d(3)      <=   (congr_cl29_wA_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayA   Thread 2   Watch Bit Update for Congruence Class 29
with rel_bixu29_wayA_upd    select
    congr_cl29_wA_d(4)      <=   (congr_cl29_wA_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayA   Thread 3   Watch Bit Update for Congruence Class 29
with rel_bixu29_wayA_upd    select
    congr_cl29_wA_d(5)      <=   (congr_cl29_wA_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayA   Valid Bit Update for Congruence Class 30
with rel_bixu30_wayA_upd    select
    congr_cl30_wA_d(0)     <=   (congr_cl30_wA_q(0)    and not dci_inval_all_q) when "00",
                           (flush_wayA_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayA_data2_q(0)   and not dci_inval_all_q) when others;
-- WayA   Lock Bit Update for Congruence Class 30
with rel_bixu30_wayA_upd    select
    congr_cl30_wA_d(1)     <=   (congr_cl30_wA_q(1)    and not lock_finval) when "00",
                           (flush_wayA_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayA_data2_q(1)   and not lock_finval) when others;
-- WayA   Thread 0   Watch Bit Update for Congruence Class 30
with rel_bixu30_wayA_upd    select
    congr_cl30_wA_d(2)      <=   (congr_cl30_wA_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayA   Thread 1   Watch Bit Update for Congruence Class 30
with rel_bixu30_wayA_upd    select
    congr_cl30_wA_d(3)      <=   (congr_cl30_wA_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayA   Thread 2   Watch Bit Update for Congruence Class 30
with rel_bixu30_wayA_upd    select
    congr_cl30_wA_d(4)      <=   (congr_cl30_wA_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayA   Thread 3   Watch Bit Update for Congruence Class 30
with rel_bixu30_wayA_upd    select
    congr_cl30_wA_d(5)      <=   (congr_cl30_wA_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayA   Valid Bit Update for Congruence Class 31
with rel_bixu31_wayA_upd    select
    congr_cl31_wA_d(0)     <=   (congr_cl31_wA_q(0)    and not dci_inval_all_q) when "00",
                           (flush_wayA_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayA_data2_q(0)   and not dci_inval_all_q) when others;
-- WayA   Lock Bit Update for Congruence Class 31
with rel_bixu31_wayA_upd    select
    congr_cl31_wA_d(1)     <=   (congr_cl31_wA_q(1)    and not lock_finval) when "00",
                           (flush_wayA_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayA_data2_q(1)   and not lock_finval) when others;
-- WayA   Thread 0   Watch Bit Update for Congruence Class 31
with rel_bixu31_wayA_upd    select
    congr_cl31_wA_d(2)      <=   (congr_cl31_wA_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayA   Thread 1   Watch Bit Update for Congruence Class 31
with rel_bixu31_wayA_upd    select
    congr_cl31_wA_d(3)      <=   (congr_cl31_wA_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayA   Thread 2   Watch Bit Update for Congruence Class 31
with rel_bixu31_wayA_upd    select
    congr_cl31_wA_d(4)      <=   (congr_cl31_wA_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayA   Thread 3   Watch Bit Update for Congruence Class 31
with rel_bixu31_wayA_upd    select
    congr_cl31_wA_d(5)      <=   (congr_cl31_wA_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayA   Valid Bit Update for Congruence Class 32
with rel_bixu32_wayA_upd    select
    congr_cl32_wA_d(0)     <=   (congr_cl32_wA_q(0)    and not dci_inval_all_q) when "00",
                           (flush_wayA_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayA_data2_q(0)   and not dci_inval_all_q) when others;
-- WayA   Lock Bit Update for Congruence Class 32
with rel_bixu32_wayA_upd    select
    congr_cl32_wA_d(1)     <=   (congr_cl32_wA_q(1)    and not lock_finval) when "00",
                           (flush_wayA_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayA_data2_q(1)   and not lock_finval) when others;
-- WayA   Thread 0   Watch Bit Update for Congruence Class 32
with rel_bixu32_wayA_upd    select
    congr_cl32_wA_d(2)      <=   (congr_cl32_wA_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayA   Thread 1   Watch Bit Update for Congruence Class 32
with rel_bixu32_wayA_upd    select
    congr_cl32_wA_d(3)      <=   (congr_cl32_wA_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayA   Thread 2   Watch Bit Update for Congruence Class 32
with rel_bixu32_wayA_upd    select
    congr_cl32_wA_d(4)      <=   (congr_cl32_wA_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayA   Thread 3   Watch Bit Update for Congruence Class 32
with rel_bixu32_wayA_upd    select
    congr_cl32_wA_d(5)      <=   (congr_cl32_wA_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayA   Valid Bit Update for Congruence Class 33
with rel_bixu33_wayA_upd    select
    congr_cl33_wA_d(0)     <=   (congr_cl33_wA_q(0)    and not dci_inval_all_q) when "00",
                           (flush_wayA_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayA_data2_q(0)   and not dci_inval_all_q) when others;
-- WayA   Lock Bit Update for Congruence Class 33
with rel_bixu33_wayA_upd    select
    congr_cl33_wA_d(1)     <=   (congr_cl33_wA_q(1)    and not lock_finval) when "00",
                           (flush_wayA_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayA_data2_q(1)   and not lock_finval) when others;
-- WayA   Thread 0   Watch Bit Update for Congruence Class 33
with rel_bixu33_wayA_upd    select
    congr_cl33_wA_d(2)      <=   (congr_cl33_wA_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayA   Thread 1   Watch Bit Update for Congruence Class 33
with rel_bixu33_wayA_upd    select
    congr_cl33_wA_d(3)      <=   (congr_cl33_wA_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayA   Thread 2   Watch Bit Update for Congruence Class 33
with rel_bixu33_wayA_upd    select
    congr_cl33_wA_d(4)      <=   (congr_cl33_wA_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayA   Thread 3   Watch Bit Update for Congruence Class 33
with rel_bixu33_wayA_upd    select
    congr_cl33_wA_d(5)      <=   (congr_cl33_wA_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayA   Valid Bit Update for Congruence Class 34
with rel_bixu34_wayA_upd    select
    congr_cl34_wA_d(0)     <=   (congr_cl34_wA_q(0)    and not dci_inval_all_q) when "00",
                           (flush_wayA_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayA_data2_q(0)   and not dci_inval_all_q) when others;
-- WayA   Lock Bit Update for Congruence Class 34
with rel_bixu34_wayA_upd    select
    congr_cl34_wA_d(1)     <=   (congr_cl34_wA_q(1)    and not lock_finval) when "00",
                           (flush_wayA_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayA_data2_q(1)   and not lock_finval) when others;
-- WayA   Thread 0   Watch Bit Update for Congruence Class 34
with rel_bixu34_wayA_upd    select
    congr_cl34_wA_d(2)      <=   (congr_cl34_wA_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayA   Thread 1   Watch Bit Update for Congruence Class 34
with rel_bixu34_wayA_upd    select
    congr_cl34_wA_d(3)      <=   (congr_cl34_wA_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayA   Thread 2   Watch Bit Update for Congruence Class 34
with rel_bixu34_wayA_upd    select
    congr_cl34_wA_d(4)      <=   (congr_cl34_wA_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayA   Thread 3   Watch Bit Update for Congruence Class 34
with rel_bixu34_wayA_upd    select
    congr_cl34_wA_d(5)      <=   (congr_cl34_wA_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayA   Valid Bit Update for Congruence Class 35
with rel_bixu35_wayA_upd    select
    congr_cl35_wA_d(0)     <=   (congr_cl35_wA_q(0)    and not dci_inval_all_q) when "00",
                           (flush_wayA_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayA_data2_q(0)   and not dci_inval_all_q) when others;
-- WayA   Lock Bit Update for Congruence Class 35
with rel_bixu35_wayA_upd    select
    congr_cl35_wA_d(1)     <=   (congr_cl35_wA_q(1)    and not lock_finval) when "00",
                           (flush_wayA_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayA_data2_q(1)   and not lock_finval) when others;
-- WayA   Thread 0   Watch Bit Update for Congruence Class 35
with rel_bixu35_wayA_upd    select
    congr_cl35_wA_d(2)      <=   (congr_cl35_wA_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayA   Thread 1   Watch Bit Update for Congruence Class 35
with rel_bixu35_wayA_upd    select
    congr_cl35_wA_d(3)      <=   (congr_cl35_wA_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayA   Thread 2   Watch Bit Update for Congruence Class 35
with rel_bixu35_wayA_upd    select
    congr_cl35_wA_d(4)      <=   (congr_cl35_wA_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayA   Thread 3   Watch Bit Update for Congruence Class 35
with rel_bixu35_wayA_upd    select
    congr_cl35_wA_d(5)      <=   (congr_cl35_wA_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayA   Valid Bit Update for Congruence Class 36
with rel_bixu36_wayA_upd    select
    congr_cl36_wA_d(0)     <=   (congr_cl36_wA_q(0)    and not dci_inval_all_q) when "00",
                           (flush_wayA_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayA_data2_q(0)   and not dci_inval_all_q) when others;
-- WayA   Lock Bit Update for Congruence Class 36
with rel_bixu36_wayA_upd    select
    congr_cl36_wA_d(1)     <=   (congr_cl36_wA_q(1)    and not lock_finval) when "00",
                           (flush_wayA_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayA_data2_q(1)   and not lock_finval) when others;
-- WayA   Thread 0   Watch Bit Update for Congruence Class 36
with rel_bixu36_wayA_upd    select
    congr_cl36_wA_d(2)      <=   (congr_cl36_wA_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayA   Thread 1   Watch Bit Update for Congruence Class 36
with rel_bixu36_wayA_upd    select
    congr_cl36_wA_d(3)      <=   (congr_cl36_wA_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayA   Thread 2   Watch Bit Update for Congruence Class 36
with rel_bixu36_wayA_upd    select
    congr_cl36_wA_d(4)      <=   (congr_cl36_wA_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayA   Thread 3   Watch Bit Update for Congruence Class 36
with rel_bixu36_wayA_upd    select
    congr_cl36_wA_d(5)      <=   (congr_cl36_wA_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayA   Valid Bit Update for Congruence Class 37
with rel_bixu37_wayA_upd    select
    congr_cl37_wA_d(0)     <=   (congr_cl37_wA_q(0)    and not dci_inval_all_q) when "00",
                           (flush_wayA_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayA_data2_q(0)   and not dci_inval_all_q) when others;
-- WayA   Lock Bit Update for Congruence Class 37
with rel_bixu37_wayA_upd    select
    congr_cl37_wA_d(1)     <=   (congr_cl37_wA_q(1)    and not lock_finval) when "00",
                           (flush_wayA_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayA_data2_q(1)   and not lock_finval) when others;
-- WayA   Thread 0   Watch Bit Update for Congruence Class 37
with rel_bixu37_wayA_upd    select
    congr_cl37_wA_d(2)      <=   (congr_cl37_wA_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayA   Thread 1   Watch Bit Update for Congruence Class 37
with rel_bixu37_wayA_upd    select
    congr_cl37_wA_d(3)      <=   (congr_cl37_wA_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayA   Thread 2   Watch Bit Update for Congruence Class 37
with rel_bixu37_wayA_upd    select
    congr_cl37_wA_d(4)      <=   (congr_cl37_wA_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayA   Thread 3   Watch Bit Update for Congruence Class 37
with rel_bixu37_wayA_upd    select
    congr_cl37_wA_d(5)      <=   (congr_cl37_wA_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayA   Valid Bit Update for Congruence Class 38
with rel_bixu38_wayA_upd    select
    congr_cl38_wA_d(0)     <=   (congr_cl38_wA_q(0)    and not dci_inval_all_q) when "00",
                           (flush_wayA_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayA_data2_q(0)   and not dci_inval_all_q) when others;
-- WayA   Lock Bit Update for Congruence Class 38
with rel_bixu38_wayA_upd    select
    congr_cl38_wA_d(1)     <=   (congr_cl38_wA_q(1)    and not lock_finval) when "00",
                           (flush_wayA_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayA_data2_q(1)   and not lock_finval) when others;
-- WayA   Thread 0   Watch Bit Update for Congruence Class 38
with rel_bixu38_wayA_upd    select
    congr_cl38_wA_d(2)      <=   (congr_cl38_wA_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayA   Thread 1   Watch Bit Update for Congruence Class 38
with rel_bixu38_wayA_upd    select
    congr_cl38_wA_d(3)      <=   (congr_cl38_wA_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayA   Thread 2   Watch Bit Update for Congruence Class 38
with rel_bixu38_wayA_upd    select
    congr_cl38_wA_d(4)      <=   (congr_cl38_wA_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayA   Thread 3   Watch Bit Update for Congruence Class 38
with rel_bixu38_wayA_upd    select
    congr_cl38_wA_d(5)      <=   (congr_cl38_wA_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayA   Valid Bit Update for Congruence Class 39
with rel_bixu39_wayA_upd    select
    congr_cl39_wA_d(0)     <=   (congr_cl39_wA_q(0)    and not dci_inval_all_q) when "00",
                           (flush_wayA_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayA_data2_q(0)   and not dci_inval_all_q) when others;
-- WayA   Lock Bit Update for Congruence Class 39
with rel_bixu39_wayA_upd    select
    congr_cl39_wA_d(1)     <=   (congr_cl39_wA_q(1)    and not lock_finval) when "00",
                           (flush_wayA_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayA_data2_q(1)   and not lock_finval) when others;
-- WayA   Thread 0   Watch Bit Update for Congruence Class 39
with rel_bixu39_wayA_upd    select
    congr_cl39_wA_d(2)      <=   (congr_cl39_wA_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayA   Thread 1   Watch Bit Update for Congruence Class 39
with rel_bixu39_wayA_upd    select
    congr_cl39_wA_d(3)      <=   (congr_cl39_wA_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayA   Thread 2   Watch Bit Update for Congruence Class 39
with rel_bixu39_wayA_upd    select
    congr_cl39_wA_d(4)      <=   (congr_cl39_wA_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayA   Thread 3   Watch Bit Update for Congruence Class 39
with rel_bixu39_wayA_upd    select
    congr_cl39_wA_d(5)      <=   (congr_cl39_wA_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayA   Valid Bit Update for Congruence Class 40
with rel_bixu40_wayA_upd    select
    congr_cl40_wA_d(0)     <=   (congr_cl40_wA_q(0)    and not dci_inval_all_q) when "00",
                           (flush_wayA_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayA_data2_q(0)   and not dci_inval_all_q) when others;
-- WayA   Lock Bit Update for Congruence Class 40
with rel_bixu40_wayA_upd    select
    congr_cl40_wA_d(1)     <=   (congr_cl40_wA_q(1)    and not lock_finval) when "00",
                           (flush_wayA_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayA_data2_q(1)   and not lock_finval) when others;
-- WayA   Thread 0   Watch Bit Update for Congruence Class 40
with rel_bixu40_wayA_upd    select
    congr_cl40_wA_d(2)      <=   (congr_cl40_wA_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayA   Thread 1   Watch Bit Update for Congruence Class 40
with rel_bixu40_wayA_upd    select
    congr_cl40_wA_d(3)      <=   (congr_cl40_wA_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayA   Thread 2   Watch Bit Update for Congruence Class 40
with rel_bixu40_wayA_upd    select
    congr_cl40_wA_d(4)      <=   (congr_cl40_wA_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayA   Thread 3   Watch Bit Update for Congruence Class 40
with rel_bixu40_wayA_upd    select
    congr_cl40_wA_d(5)      <=   (congr_cl40_wA_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayA   Valid Bit Update for Congruence Class 41
with rel_bixu41_wayA_upd    select
    congr_cl41_wA_d(0)     <=   (congr_cl41_wA_q(0)    and not dci_inval_all_q) when "00",
                           (flush_wayA_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayA_data2_q(0)   and not dci_inval_all_q) when others;
-- WayA   Lock Bit Update for Congruence Class 41
with rel_bixu41_wayA_upd    select
    congr_cl41_wA_d(1)     <=   (congr_cl41_wA_q(1)    and not lock_finval) when "00",
                           (flush_wayA_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayA_data2_q(1)   and not lock_finval) when others;
-- WayA   Thread 0   Watch Bit Update for Congruence Class 41
with rel_bixu41_wayA_upd    select
    congr_cl41_wA_d(2)      <=   (congr_cl41_wA_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayA   Thread 1   Watch Bit Update for Congruence Class 41
with rel_bixu41_wayA_upd    select
    congr_cl41_wA_d(3)      <=   (congr_cl41_wA_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayA   Thread 2   Watch Bit Update for Congruence Class 41
with rel_bixu41_wayA_upd    select
    congr_cl41_wA_d(4)      <=   (congr_cl41_wA_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayA   Thread 3   Watch Bit Update for Congruence Class 41
with rel_bixu41_wayA_upd    select
    congr_cl41_wA_d(5)      <=   (congr_cl41_wA_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayA   Valid Bit Update for Congruence Class 42
with rel_bixu42_wayA_upd    select
    congr_cl42_wA_d(0)     <=   (congr_cl42_wA_q(0)    and not dci_inval_all_q) when "00",
                           (flush_wayA_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayA_data2_q(0)   and not dci_inval_all_q) when others;
-- WayA   Lock Bit Update for Congruence Class 42
with rel_bixu42_wayA_upd    select
    congr_cl42_wA_d(1)     <=   (congr_cl42_wA_q(1)    and not lock_finval) when "00",
                           (flush_wayA_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayA_data2_q(1)   and not lock_finval) when others;
-- WayA   Thread 0   Watch Bit Update for Congruence Class 42
with rel_bixu42_wayA_upd    select
    congr_cl42_wA_d(2)      <=   (congr_cl42_wA_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayA   Thread 1   Watch Bit Update for Congruence Class 42
with rel_bixu42_wayA_upd    select
    congr_cl42_wA_d(3)      <=   (congr_cl42_wA_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayA   Thread 2   Watch Bit Update for Congruence Class 42
with rel_bixu42_wayA_upd    select
    congr_cl42_wA_d(4)      <=   (congr_cl42_wA_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayA   Thread 3   Watch Bit Update for Congruence Class 42
with rel_bixu42_wayA_upd    select
    congr_cl42_wA_d(5)      <=   (congr_cl42_wA_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayA   Valid Bit Update for Congruence Class 43
with rel_bixu43_wayA_upd    select
    congr_cl43_wA_d(0)     <=   (congr_cl43_wA_q(0)    and not dci_inval_all_q) when "00",
                           (flush_wayA_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayA_data2_q(0)   and not dci_inval_all_q) when others;
-- WayA   Lock Bit Update for Congruence Class 43
with rel_bixu43_wayA_upd    select
    congr_cl43_wA_d(1)     <=   (congr_cl43_wA_q(1)    and not lock_finval) when "00",
                           (flush_wayA_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayA_data2_q(1)   and not lock_finval) when others;
-- WayA   Thread 0   Watch Bit Update for Congruence Class 43
with rel_bixu43_wayA_upd    select
    congr_cl43_wA_d(2)      <=   (congr_cl43_wA_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayA   Thread 1   Watch Bit Update for Congruence Class 43
with rel_bixu43_wayA_upd    select
    congr_cl43_wA_d(3)      <=   (congr_cl43_wA_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayA   Thread 2   Watch Bit Update for Congruence Class 43
with rel_bixu43_wayA_upd    select
    congr_cl43_wA_d(4)      <=   (congr_cl43_wA_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayA   Thread 3   Watch Bit Update for Congruence Class 43
with rel_bixu43_wayA_upd    select
    congr_cl43_wA_d(5)      <=   (congr_cl43_wA_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayA   Valid Bit Update for Congruence Class 44
with rel_bixu44_wayA_upd    select
    congr_cl44_wA_d(0)     <=   (congr_cl44_wA_q(0)    and not dci_inval_all_q) when "00",
                           (flush_wayA_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayA_data2_q(0)   and not dci_inval_all_q) when others;
-- WayA   Lock Bit Update for Congruence Class 44
with rel_bixu44_wayA_upd    select
    congr_cl44_wA_d(1)     <=   (congr_cl44_wA_q(1)    and not lock_finval) when "00",
                           (flush_wayA_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayA_data2_q(1)   and not lock_finval) when others;
-- WayA   Thread 0   Watch Bit Update for Congruence Class 44
with rel_bixu44_wayA_upd    select
    congr_cl44_wA_d(2)      <=   (congr_cl44_wA_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayA   Thread 1   Watch Bit Update for Congruence Class 44
with rel_bixu44_wayA_upd    select
    congr_cl44_wA_d(3)      <=   (congr_cl44_wA_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayA   Thread 2   Watch Bit Update for Congruence Class 44
with rel_bixu44_wayA_upd    select
    congr_cl44_wA_d(4)      <=   (congr_cl44_wA_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayA   Thread 3   Watch Bit Update for Congruence Class 44
with rel_bixu44_wayA_upd    select
    congr_cl44_wA_d(5)      <=   (congr_cl44_wA_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayA   Valid Bit Update for Congruence Class 45
with rel_bixu45_wayA_upd    select
    congr_cl45_wA_d(0)     <=   (congr_cl45_wA_q(0)    and not dci_inval_all_q) when "00",
                           (flush_wayA_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayA_data2_q(0)   and not dci_inval_all_q) when others;
-- WayA   Lock Bit Update for Congruence Class 45
with rel_bixu45_wayA_upd    select
    congr_cl45_wA_d(1)     <=   (congr_cl45_wA_q(1)    and not lock_finval) when "00",
                           (flush_wayA_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayA_data2_q(1)   and not lock_finval) when others;
-- WayA   Thread 0   Watch Bit Update for Congruence Class 45
with rel_bixu45_wayA_upd    select
    congr_cl45_wA_d(2)      <=   (congr_cl45_wA_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayA   Thread 1   Watch Bit Update for Congruence Class 45
with rel_bixu45_wayA_upd    select
    congr_cl45_wA_d(3)      <=   (congr_cl45_wA_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayA   Thread 2   Watch Bit Update for Congruence Class 45
with rel_bixu45_wayA_upd    select
    congr_cl45_wA_d(4)      <=   (congr_cl45_wA_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayA   Thread 3   Watch Bit Update for Congruence Class 45
with rel_bixu45_wayA_upd    select
    congr_cl45_wA_d(5)      <=   (congr_cl45_wA_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayA   Valid Bit Update for Congruence Class 46
with rel_bixu46_wayA_upd    select
    congr_cl46_wA_d(0)     <=   (congr_cl46_wA_q(0)    and not dci_inval_all_q) when "00",
                           (flush_wayA_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayA_data2_q(0)   and not dci_inval_all_q) when others;
-- WayA   Lock Bit Update for Congruence Class 46
with rel_bixu46_wayA_upd    select
    congr_cl46_wA_d(1)     <=   (congr_cl46_wA_q(1)    and not lock_finval) when "00",
                           (flush_wayA_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayA_data2_q(1)   and not lock_finval) when others;
-- WayA   Thread 0   Watch Bit Update for Congruence Class 46
with rel_bixu46_wayA_upd    select
    congr_cl46_wA_d(2)      <=   (congr_cl46_wA_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayA   Thread 1   Watch Bit Update for Congruence Class 46
with rel_bixu46_wayA_upd    select
    congr_cl46_wA_d(3)      <=   (congr_cl46_wA_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayA   Thread 2   Watch Bit Update for Congruence Class 46
with rel_bixu46_wayA_upd    select
    congr_cl46_wA_d(4)      <=   (congr_cl46_wA_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayA   Thread 3   Watch Bit Update for Congruence Class 46
with rel_bixu46_wayA_upd    select
    congr_cl46_wA_d(5)      <=   (congr_cl46_wA_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayA   Valid Bit Update for Congruence Class 47
with rel_bixu47_wayA_upd    select
    congr_cl47_wA_d(0)     <=   (congr_cl47_wA_q(0)    and not dci_inval_all_q) when "00",
                           (flush_wayA_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayA_data2_q(0)   and not dci_inval_all_q) when others;
-- WayA   Lock Bit Update for Congruence Class 47
with rel_bixu47_wayA_upd    select
    congr_cl47_wA_d(1)     <=   (congr_cl47_wA_q(1)    and not lock_finval) when "00",
                           (flush_wayA_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayA_data2_q(1)   and not lock_finval) when others;
-- WayA   Thread 0   Watch Bit Update for Congruence Class 47
with rel_bixu47_wayA_upd    select
    congr_cl47_wA_d(2)      <=   (congr_cl47_wA_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayA   Thread 1   Watch Bit Update for Congruence Class 47
with rel_bixu47_wayA_upd    select
    congr_cl47_wA_d(3)      <=   (congr_cl47_wA_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayA   Thread 2   Watch Bit Update for Congruence Class 47
with rel_bixu47_wayA_upd    select
    congr_cl47_wA_d(4)      <=   (congr_cl47_wA_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayA   Thread 3   Watch Bit Update for Congruence Class 47
with rel_bixu47_wayA_upd    select
    congr_cl47_wA_d(5)      <=   (congr_cl47_wA_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayA   Valid Bit Update for Congruence Class 48
with rel_bixu48_wayA_upd    select
    congr_cl48_wA_d(0)     <=   (congr_cl48_wA_q(0)    and not dci_inval_all_q) when "00",
                           (flush_wayA_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayA_data2_q(0)   and not dci_inval_all_q) when others;
-- WayA   Lock Bit Update for Congruence Class 48
with rel_bixu48_wayA_upd    select
    congr_cl48_wA_d(1)     <=   (congr_cl48_wA_q(1)    and not lock_finval) when "00",
                           (flush_wayA_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayA_data2_q(1)   and not lock_finval) when others;
-- WayA   Thread 0   Watch Bit Update for Congruence Class 48
with rel_bixu48_wayA_upd    select
    congr_cl48_wA_d(2)      <=   (congr_cl48_wA_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayA   Thread 1   Watch Bit Update for Congruence Class 48
with rel_bixu48_wayA_upd    select
    congr_cl48_wA_d(3)      <=   (congr_cl48_wA_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayA   Thread 2   Watch Bit Update for Congruence Class 48
with rel_bixu48_wayA_upd    select
    congr_cl48_wA_d(4)      <=   (congr_cl48_wA_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayA   Thread 3   Watch Bit Update for Congruence Class 48
with rel_bixu48_wayA_upd    select
    congr_cl48_wA_d(5)      <=   (congr_cl48_wA_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayA   Valid Bit Update for Congruence Class 49
with rel_bixu49_wayA_upd    select
    congr_cl49_wA_d(0)     <=   (congr_cl49_wA_q(0)    and not dci_inval_all_q) when "00",
                           (flush_wayA_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayA_data2_q(0)   and not dci_inval_all_q) when others;
-- WayA   Lock Bit Update for Congruence Class 49
with rel_bixu49_wayA_upd    select
    congr_cl49_wA_d(1)     <=   (congr_cl49_wA_q(1)    and not lock_finval) when "00",
                           (flush_wayA_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayA_data2_q(1)   and not lock_finval) when others;
-- WayA   Thread 0   Watch Bit Update for Congruence Class 49
with rel_bixu49_wayA_upd    select
    congr_cl49_wA_d(2)      <=   (congr_cl49_wA_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayA   Thread 1   Watch Bit Update for Congruence Class 49
with rel_bixu49_wayA_upd    select
    congr_cl49_wA_d(3)      <=   (congr_cl49_wA_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayA   Thread 2   Watch Bit Update for Congruence Class 49
with rel_bixu49_wayA_upd    select
    congr_cl49_wA_d(4)      <=   (congr_cl49_wA_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayA   Thread 3   Watch Bit Update for Congruence Class 49
with rel_bixu49_wayA_upd    select
    congr_cl49_wA_d(5)      <=   (congr_cl49_wA_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayA   Valid Bit Update for Congruence Class 50
with rel_bixu50_wayA_upd    select
    congr_cl50_wA_d(0)     <=   (congr_cl50_wA_q(0)    and not dci_inval_all_q) when "00",
                           (flush_wayA_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayA_data2_q(0)   and not dci_inval_all_q) when others;
-- WayA   Lock Bit Update for Congruence Class 50
with rel_bixu50_wayA_upd    select
    congr_cl50_wA_d(1)     <=   (congr_cl50_wA_q(1)    and not lock_finval) when "00",
                           (flush_wayA_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayA_data2_q(1)   and not lock_finval) when others;
-- WayA   Thread 0   Watch Bit Update for Congruence Class 50
with rel_bixu50_wayA_upd    select
    congr_cl50_wA_d(2)      <=   (congr_cl50_wA_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayA   Thread 1   Watch Bit Update for Congruence Class 50
with rel_bixu50_wayA_upd    select
    congr_cl50_wA_d(3)      <=   (congr_cl50_wA_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayA   Thread 2   Watch Bit Update for Congruence Class 50
with rel_bixu50_wayA_upd    select
    congr_cl50_wA_d(4)      <=   (congr_cl50_wA_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayA   Thread 3   Watch Bit Update for Congruence Class 50
with rel_bixu50_wayA_upd    select
    congr_cl50_wA_d(5)      <=   (congr_cl50_wA_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayA   Valid Bit Update for Congruence Class 51
with rel_bixu51_wayA_upd    select
    congr_cl51_wA_d(0)     <=   (congr_cl51_wA_q(0)    and not dci_inval_all_q) when "00",
                           (flush_wayA_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayA_data2_q(0)   and not dci_inval_all_q) when others;
-- WayA   Lock Bit Update for Congruence Class 51
with rel_bixu51_wayA_upd    select
    congr_cl51_wA_d(1)     <=   (congr_cl51_wA_q(1)    and not lock_finval) when "00",
                           (flush_wayA_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayA_data2_q(1)   and not lock_finval) when others;
-- WayA   Thread 0   Watch Bit Update for Congruence Class 51
with rel_bixu51_wayA_upd    select
    congr_cl51_wA_d(2)      <=   (congr_cl51_wA_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayA   Thread 1   Watch Bit Update for Congruence Class 51
with rel_bixu51_wayA_upd    select
    congr_cl51_wA_d(3)      <=   (congr_cl51_wA_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayA   Thread 2   Watch Bit Update for Congruence Class 51
with rel_bixu51_wayA_upd    select
    congr_cl51_wA_d(4)      <=   (congr_cl51_wA_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayA   Thread 3   Watch Bit Update for Congruence Class 51
with rel_bixu51_wayA_upd    select
    congr_cl51_wA_d(5)      <=   (congr_cl51_wA_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayA   Valid Bit Update for Congruence Class 52
with rel_bixu52_wayA_upd    select
    congr_cl52_wA_d(0)     <=   (congr_cl52_wA_q(0)    and not dci_inval_all_q) when "00",
                           (flush_wayA_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayA_data2_q(0)   and not dci_inval_all_q) when others;
-- WayA   Lock Bit Update for Congruence Class 52
with rel_bixu52_wayA_upd    select
    congr_cl52_wA_d(1)     <=   (congr_cl52_wA_q(1)    and not lock_finval) when "00",
                           (flush_wayA_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayA_data2_q(1)   and not lock_finval) when others;
-- WayA   Thread 0   Watch Bit Update for Congruence Class 52
with rel_bixu52_wayA_upd    select
    congr_cl52_wA_d(2)      <=   (congr_cl52_wA_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayA   Thread 1   Watch Bit Update for Congruence Class 52
with rel_bixu52_wayA_upd    select
    congr_cl52_wA_d(3)      <=   (congr_cl52_wA_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayA   Thread 2   Watch Bit Update for Congruence Class 52
with rel_bixu52_wayA_upd    select
    congr_cl52_wA_d(4)      <=   (congr_cl52_wA_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayA   Thread 3   Watch Bit Update for Congruence Class 52
with rel_bixu52_wayA_upd    select
    congr_cl52_wA_d(5)      <=   (congr_cl52_wA_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayA   Valid Bit Update for Congruence Class 53
with rel_bixu53_wayA_upd    select
    congr_cl53_wA_d(0)     <=   (congr_cl53_wA_q(0)    and not dci_inval_all_q) when "00",
                           (flush_wayA_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayA_data2_q(0)   and not dci_inval_all_q) when others;
-- WayA   Lock Bit Update for Congruence Class 53
with rel_bixu53_wayA_upd    select
    congr_cl53_wA_d(1)     <=   (congr_cl53_wA_q(1)    and not lock_finval) when "00",
                           (flush_wayA_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayA_data2_q(1)   and not lock_finval) when others;
-- WayA   Thread 0   Watch Bit Update for Congruence Class 53
with rel_bixu53_wayA_upd    select
    congr_cl53_wA_d(2)      <=   (congr_cl53_wA_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayA   Thread 1   Watch Bit Update for Congruence Class 53
with rel_bixu53_wayA_upd    select
    congr_cl53_wA_d(3)      <=   (congr_cl53_wA_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayA   Thread 2   Watch Bit Update for Congruence Class 53
with rel_bixu53_wayA_upd    select
    congr_cl53_wA_d(4)      <=   (congr_cl53_wA_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayA   Thread 3   Watch Bit Update for Congruence Class 53
with rel_bixu53_wayA_upd    select
    congr_cl53_wA_d(5)      <=   (congr_cl53_wA_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayA   Valid Bit Update for Congruence Class 54
with rel_bixu54_wayA_upd    select
    congr_cl54_wA_d(0)     <=   (congr_cl54_wA_q(0)    and not dci_inval_all_q) when "00",
                           (flush_wayA_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayA_data2_q(0)   and not dci_inval_all_q) when others;
-- WayA   Lock Bit Update for Congruence Class 54
with rel_bixu54_wayA_upd    select
    congr_cl54_wA_d(1)     <=   (congr_cl54_wA_q(1)    and not lock_finval) when "00",
                           (flush_wayA_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayA_data2_q(1)   and not lock_finval) when others;
-- WayA   Thread 0   Watch Bit Update for Congruence Class 54
with rel_bixu54_wayA_upd    select
    congr_cl54_wA_d(2)      <=   (congr_cl54_wA_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayA   Thread 1   Watch Bit Update for Congruence Class 54
with rel_bixu54_wayA_upd    select
    congr_cl54_wA_d(3)      <=   (congr_cl54_wA_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayA   Thread 2   Watch Bit Update for Congruence Class 54
with rel_bixu54_wayA_upd    select
    congr_cl54_wA_d(4)      <=   (congr_cl54_wA_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayA   Thread 3   Watch Bit Update for Congruence Class 54
with rel_bixu54_wayA_upd    select
    congr_cl54_wA_d(5)      <=   (congr_cl54_wA_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayA   Valid Bit Update for Congruence Class 55
with rel_bixu55_wayA_upd    select
    congr_cl55_wA_d(0)     <=   (congr_cl55_wA_q(0)    and not dci_inval_all_q) when "00",
                           (flush_wayA_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayA_data2_q(0)   and not dci_inval_all_q) when others;
-- WayA   Lock Bit Update for Congruence Class 55
with rel_bixu55_wayA_upd    select
    congr_cl55_wA_d(1)     <=   (congr_cl55_wA_q(1)    and not lock_finval) when "00",
                           (flush_wayA_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayA_data2_q(1)   and not lock_finval) when others;
-- WayA   Thread 0   Watch Bit Update for Congruence Class 55
with rel_bixu55_wayA_upd    select
    congr_cl55_wA_d(2)      <=   (congr_cl55_wA_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayA   Thread 1   Watch Bit Update for Congruence Class 55
with rel_bixu55_wayA_upd    select
    congr_cl55_wA_d(3)      <=   (congr_cl55_wA_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayA   Thread 2   Watch Bit Update for Congruence Class 55
with rel_bixu55_wayA_upd    select
    congr_cl55_wA_d(4)      <=   (congr_cl55_wA_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayA   Thread 3   Watch Bit Update for Congruence Class 55
with rel_bixu55_wayA_upd    select
    congr_cl55_wA_d(5)      <=   (congr_cl55_wA_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayA   Valid Bit Update for Congruence Class 56
with rel_bixu56_wayA_upd    select
    congr_cl56_wA_d(0)     <=   (congr_cl56_wA_q(0)    and not dci_inval_all_q) when "00",
                           (flush_wayA_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayA_data2_q(0)   and not dci_inval_all_q) when others;
-- WayA   Lock Bit Update for Congruence Class 56
with rel_bixu56_wayA_upd    select
    congr_cl56_wA_d(1)     <=   (congr_cl56_wA_q(1)    and not lock_finval) when "00",
                           (flush_wayA_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayA_data2_q(1)   and not lock_finval) when others;
-- WayA   Thread 0   Watch Bit Update for Congruence Class 56
with rel_bixu56_wayA_upd    select
    congr_cl56_wA_d(2)      <=   (congr_cl56_wA_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayA   Thread 1   Watch Bit Update for Congruence Class 56
with rel_bixu56_wayA_upd    select
    congr_cl56_wA_d(3)      <=   (congr_cl56_wA_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayA   Thread 2   Watch Bit Update for Congruence Class 56
with rel_bixu56_wayA_upd    select
    congr_cl56_wA_d(4)      <=   (congr_cl56_wA_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayA   Thread 3   Watch Bit Update for Congruence Class 56
with rel_bixu56_wayA_upd    select
    congr_cl56_wA_d(5)      <=   (congr_cl56_wA_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayA   Valid Bit Update for Congruence Class 57
with rel_bixu57_wayA_upd    select
    congr_cl57_wA_d(0)     <=   (congr_cl57_wA_q(0)    and not dci_inval_all_q) when "00",
                           (flush_wayA_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayA_data2_q(0)   and not dci_inval_all_q) when others;
-- WayA   Lock Bit Update for Congruence Class 57
with rel_bixu57_wayA_upd    select
    congr_cl57_wA_d(1)     <=   (congr_cl57_wA_q(1)    and not lock_finval) when "00",
                           (flush_wayA_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayA_data2_q(1)   and not lock_finval) when others;
-- WayA   Thread 0   Watch Bit Update for Congruence Class 57
with rel_bixu57_wayA_upd    select
    congr_cl57_wA_d(2)      <=   (congr_cl57_wA_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayA   Thread 1   Watch Bit Update for Congruence Class 57
with rel_bixu57_wayA_upd    select
    congr_cl57_wA_d(3)      <=   (congr_cl57_wA_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayA   Thread 2   Watch Bit Update for Congruence Class 57
with rel_bixu57_wayA_upd    select
    congr_cl57_wA_d(4)      <=   (congr_cl57_wA_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayA   Thread 3   Watch Bit Update for Congruence Class 57
with rel_bixu57_wayA_upd    select
    congr_cl57_wA_d(5)      <=   (congr_cl57_wA_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayA   Valid Bit Update for Congruence Class 58
with rel_bixu58_wayA_upd    select
    congr_cl58_wA_d(0)     <=   (congr_cl58_wA_q(0)    and not dci_inval_all_q) when "00",
                           (flush_wayA_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayA_data2_q(0)   and not dci_inval_all_q) when others;
-- WayA   Lock Bit Update for Congruence Class 58
with rel_bixu58_wayA_upd    select
    congr_cl58_wA_d(1)     <=   (congr_cl58_wA_q(1)    and not lock_finval) when "00",
                           (flush_wayA_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayA_data2_q(1)   and not lock_finval) when others;
-- WayA   Thread 0   Watch Bit Update for Congruence Class 58
with rel_bixu58_wayA_upd    select
    congr_cl58_wA_d(2)      <=   (congr_cl58_wA_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayA   Thread 1   Watch Bit Update for Congruence Class 58
with rel_bixu58_wayA_upd    select
    congr_cl58_wA_d(3)      <=   (congr_cl58_wA_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayA   Thread 2   Watch Bit Update for Congruence Class 58
with rel_bixu58_wayA_upd    select
    congr_cl58_wA_d(4)      <=   (congr_cl58_wA_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayA   Thread 3   Watch Bit Update for Congruence Class 58
with rel_bixu58_wayA_upd    select
    congr_cl58_wA_d(5)      <=   (congr_cl58_wA_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayA   Valid Bit Update for Congruence Class 59
with rel_bixu59_wayA_upd    select
    congr_cl59_wA_d(0)     <=   (congr_cl59_wA_q(0)    and not dci_inval_all_q) when "00",
                           (flush_wayA_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayA_data2_q(0)   and not dci_inval_all_q) when others;
-- WayA   Lock Bit Update for Congruence Class 59
with rel_bixu59_wayA_upd    select
    congr_cl59_wA_d(1)     <=   (congr_cl59_wA_q(1)    and not lock_finval) when "00",
                           (flush_wayA_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayA_data2_q(1)   and not lock_finval) when others;
-- WayA   Thread 0   Watch Bit Update for Congruence Class 59
with rel_bixu59_wayA_upd    select
    congr_cl59_wA_d(2)      <=   (congr_cl59_wA_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayA   Thread 1   Watch Bit Update for Congruence Class 59
with rel_bixu59_wayA_upd    select
    congr_cl59_wA_d(3)      <=   (congr_cl59_wA_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayA   Thread 2   Watch Bit Update for Congruence Class 59
with rel_bixu59_wayA_upd    select
    congr_cl59_wA_d(4)      <=   (congr_cl59_wA_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayA   Thread 3   Watch Bit Update for Congruence Class 59
with rel_bixu59_wayA_upd    select
    congr_cl59_wA_d(5)      <=   (congr_cl59_wA_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayA   Valid Bit Update for Congruence Class 60
with rel_bixu60_wayA_upd    select
    congr_cl60_wA_d(0)     <=   (congr_cl60_wA_q(0)    and not dci_inval_all_q) when "00",
                           (flush_wayA_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayA_data2_q(0)   and not dci_inval_all_q) when others;
-- WayA   Lock Bit Update for Congruence Class 60
with rel_bixu60_wayA_upd    select
    congr_cl60_wA_d(1)     <=   (congr_cl60_wA_q(1)    and not lock_finval) when "00",
                           (flush_wayA_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayA_data2_q(1)   and not lock_finval) when others;
-- WayA   Thread 0   Watch Bit Update for Congruence Class 60
with rel_bixu60_wayA_upd    select
    congr_cl60_wA_d(2)      <=   (congr_cl60_wA_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayA   Thread 1   Watch Bit Update for Congruence Class 60
with rel_bixu60_wayA_upd    select
    congr_cl60_wA_d(3)      <=   (congr_cl60_wA_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayA   Thread 2   Watch Bit Update for Congruence Class 60
with rel_bixu60_wayA_upd    select
    congr_cl60_wA_d(4)      <=   (congr_cl60_wA_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayA   Thread 3   Watch Bit Update for Congruence Class 60
with rel_bixu60_wayA_upd    select
    congr_cl60_wA_d(5)      <=   (congr_cl60_wA_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayA   Valid Bit Update for Congruence Class 61
with rel_bixu61_wayA_upd    select
    congr_cl61_wA_d(0)     <=   (congr_cl61_wA_q(0)    and not dci_inval_all_q) when "00",
                           (flush_wayA_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayA_data2_q(0)   and not dci_inval_all_q) when others;
-- WayA   Lock Bit Update for Congruence Class 61
with rel_bixu61_wayA_upd    select
    congr_cl61_wA_d(1)     <=   (congr_cl61_wA_q(1)    and not lock_finval) when "00",
                           (flush_wayA_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayA_data2_q(1)   and not lock_finval) when others;
-- WayA   Thread 0   Watch Bit Update for Congruence Class 61
with rel_bixu61_wayA_upd    select
    congr_cl61_wA_d(2)      <=   (congr_cl61_wA_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayA   Thread 1   Watch Bit Update for Congruence Class 61
with rel_bixu61_wayA_upd    select
    congr_cl61_wA_d(3)      <=   (congr_cl61_wA_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayA   Thread 2   Watch Bit Update for Congruence Class 61
with rel_bixu61_wayA_upd    select
    congr_cl61_wA_d(4)      <=   (congr_cl61_wA_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayA   Thread 3   Watch Bit Update for Congruence Class 61
with rel_bixu61_wayA_upd    select
    congr_cl61_wA_d(5)      <=   (congr_cl61_wA_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayA   Valid Bit Update for Congruence Class 62
with rel_bixu62_wayA_upd    select
    congr_cl62_wA_d(0)     <=   (congr_cl62_wA_q(0)    and not dci_inval_all_q) when "00",
                           (flush_wayA_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayA_data2_q(0)   and not dci_inval_all_q) when others;
-- WayA   Lock Bit Update for Congruence Class 62
with rel_bixu62_wayA_upd    select
    congr_cl62_wA_d(1)     <=   (congr_cl62_wA_q(1)    and not lock_finval) when "00",
                           (flush_wayA_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayA_data2_q(1)   and not lock_finval) when others;
-- WayA   Thread 0   Watch Bit Update for Congruence Class 62
with rel_bixu62_wayA_upd    select
    congr_cl62_wA_d(2)      <=   (congr_cl62_wA_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayA   Thread 1   Watch Bit Update for Congruence Class 62
with rel_bixu62_wayA_upd    select
    congr_cl62_wA_d(3)      <=   (congr_cl62_wA_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayA   Thread 2   Watch Bit Update for Congruence Class 62
with rel_bixu62_wayA_upd    select
    congr_cl62_wA_d(4)      <=   (congr_cl62_wA_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayA   Thread 3   Watch Bit Update for Congruence Class 62
with rel_bixu62_wayA_upd    select
    congr_cl62_wA_d(5)      <=   (congr_cl62_wA_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayA   Valid Bit Update for Congruence Class 63
with rel_bixu63_wayA_upd    select
    congr_cl63_wA_d(0)     <=   (congr_cl63_wA_q(0)    and not dci_inval_all_q) when "00",
                           (flush_wayA_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayA_data2_q(0)   and not dci_inval_all_q) when others;
-- WayA   Lock Bit Update for Congruence Class 63
with rel_bixu63_wayA_upd    select
    congr_cl63_wA_d(1)     <=   (congr_cl63_wA_q(1)    and not lock_finval) when "00",
                           (flush_wayA_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayA_data2_q(1)   and not lock_finval) when others;
-- WayA   Thread 0   Watch Bit Update for Congruence Class 63
with rel_bixu63_wayA_upd    select
    congr_cl63_wA_d(2)      <=   (congr_cl63_wA_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayA_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayA   Thread 1   Watch Bit Update for Congruence Class 63
with rel_bixu63_wayA_upd    select
    congr_cl63_wA_d(3)      <=   (congr_cl63_wA_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayA_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayA   Thread 2   Watch Bit Update for Congruence Class 63
with rel_bixu63_wayA_upd    select
    congr_cl63_wA_d(4)      <=   (congr_cl63_wA_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayA_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayA   Thread 3   Watch Bit Update for Congruence Class 63
with rel_bixu63_wayA_upd    select
    congr_cl63_wA_d(5)      <=   (congr_cl63_wA_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayA_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
-- XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
-- Write Select for WayB
-- WayB   Valid Bit Update for Congruence Class 0
with rel_bixu0_wayB_upd     select
    congr_cl0_wB_d(0)      <=   (congr_cl0_wB_q(0)     and not dci_inval_all_q) when "00",
                           (flush_wayB_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayB_data2_q(0)   and not dci_inval_all_q) when others;
-- WayB   Lock Bit Update for Congruence Class 0
with rel_bixu0_wayB_upd     select
    congr_cl0_wB_d(1)      <=   (congr_cl0_wB_q(1)     and not lock_finval) when "00",
                           (flush_wayB_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayB_data2_q(1)   and not lock_finval) when others;
-- WayB   Thread 0   Watch Bit Update for Congruence Class 0
with rel_bixu0_wayB_upd     select
    congr_cl0_wB_d(2)      <=   (congr_cl0_wB_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayB   Thread 1   Watch Bit Update for Congruence Class 0
with rel_bixu0_wayB_upd     select
    congr_cl0_wB_d(3)      <=   (congr_cl0_wB_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayB   Thread 2   Watch Bit Update for Congruence Class 0
with rel_bixu0_wayB_upd     select
    congr_cl0_wB_d(4)      <=   (congr_cl0_wB_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayB   Thread 3   Watch Bit Update for Congruence Class 0
with rel_bixu0_wayB_upd     select
    congr_cl0_wB_d(5)      <=   (congr_cl0_wB_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayB   Valid Bit Update for Congruence Class 1
with rel_bixu1_wayB_upd     select
    congr_cl1_wB_d(0)      <=   (congr_cl1_wB_q(0)     and not dci_inval_all_q) when "00",
                           (flush_wayB_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayB_data2_q(0)   and not dci_inval_all_q) when others;
-- WayB   Lock Bit Update for Congruence Class 1
with rel_bixu1_wayB_upd     select
    congr_cl1_wB_d(1)      <=   (congr_cl1_wB_q(1)     and not lock_finval) when "00",
                           (flush_wayB_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayB_data2_q(1)   and not lock_finval) when others;
-- WayB   Thread 0   Watch Bit Update for Congruence Class 1
with rel_bixu1_wayB_upd     select
    congr_cl1_wB_d(2)      <=   (congr_cl1_wB_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayB   Thread 1   Watch Bit Update for Congruence Class 1
with rel_bixu1_wayB_upd     select
    congr_cl1_wB_d(3)      <=   (congr_cl1_wB_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayB   Thread 2   Watch Bit Update for Congruence Class 1
with rel_bixu1_wayB_upd     select
    congr_cl1_wB_d(4)      <=   (congr_cl1_wB_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayB   Thread 3   Watch Bit Update for Congruence Class 1
with rel_bixu1_wayB_upd     select
    congr_cl1_wB_d(5)      <=   (congr_cl1_wB_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayB   Valid Bit Update for Congruence Class 2
with rel_bixu2_wayB_upd     select
    congr_cl2_wB_d(0)      <=   (congr_cl2_wB_q(0)     and not dci_inval_all_q) when "00",
                           (flush_wayB_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayB_data2_q(0)   and not dci_inval_all_q) when others;
-- WayB   Lock Bit Update for Congruence Class 2
with rel_bixu2_wayB_upd     select
    congr_cl2_wB_d(1)      <=   (congr_cl2_wB_q(1)     and not lock_finval) when "00",
                           (flush_wayB_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayB_data2_q(1)   and not lock_finval) when others;
-- WayB   Thread 0   Watch Bit Update for Congruence Class 2
with rel_bixu2_wayB_upd     select
    congr_cl2_wB_d(2)      <=   (congr_cl2_wB_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayB   Thread 1   Watch Bit Update for Congruence Class 2
with rel_bixu2_wayB_upd     select
    congr_cl2_wB_d(3)      <=   (congr_cl2_wB_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayB   Thread 2   Watch Bit Update for Congruence Class 2
with rel_bixu2_wayB_upd     select
    congr_cl2_wB_d(4)      <=   (congr_cl2_wB_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayB   Thread 3   Watch Bit Update for Congruence Class 2
with rel_bixu2_wayB_upd     select
    congr_cl2_wB_d(5)      <=   (congr_cl2_wB_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayB   Valid Bit Update for Congruence Class 3
with rel_bixu3_wayB_upd     select
    congr_cl3_wB_d(0)      <=   (congr_cl3_wB_q(0)     and not dci_inval_all_q) when "00",
                           (flush_wayB_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayB_data2_q(0)   and not dci_inval_all_q) when others;
-- WayB   Lock Bit Update for Congruence Class 3
with rel_bixu3_wayB_upd     select
    congr_cl3_wB_d(1)      <=   (congr_cl3_wB_q(1)     and not lock_finval) when "00",
                           (flush_wayB_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayB_data2_q(1)   and not lock_finval) when others;
-- WayB   Thread 0   Watch Bit Update for Congruence Class 3
with rel_bixu3_wayB_upd     select
    congr_cl3_wB_d(2)      <=   (congr_cl3_wB_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayB   Thread 1   Watch Bit Update for Congruence Class 3
with rel_bixu3_wayB_upd     select
    congr_cl3_wB_d(3)      <=   (congr_cl3_wB_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayB   Thread 2   Watch Bit Update for Congruence Class 3
with rel_bixu3_wayB_upd     select
    congr_cl3_wB_d(4)      <=   (congr_cl3_wB_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayB   Thread 3   Watch Bit Update for Congruence Class 3
with rel_bixu3_wayB_upd     select
    congr_cl3_wB_d(5)      <=   (congr_cl3_wB_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayB   Valid Bit Update for Congruence Class 4
with rel_bixu4_wayB_upd     select
    congr_cl4_wB_d(0)      <=   (congr_cl4_wB_q(0)     and not dci_inval_all_q) when "00",
                           (flush_wayB_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayB_data2_q(0)   and not dci_inval_all_q) when others;
-- WayB   Lock Bit Update for Congruence Class 4
with rel_bixu4_wayB_upd     select
    congr_cl4_wB_d(1)      <=   (congr_cl4_wB_q(1)     and not lock_finval) when "00",
                           (flush_wayB_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayB_data2_q(1)   and not lock_finval) when others;
-- WayB   Thread 0   Watch Bit Update for Congruence Class 4
with rel_bixu4_wayB_upd     select
    congr_cl4_wB_d(2)      <=   (congr_cl4_wB_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayB   Thread 1   Watch Bit Update for Congruence Class 4
with rel_bixu4_wayB_upd     select
    congr_cl4_wB_d(3)      <=   (congr_cl4_wB_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayB   Thread 2   Watch Bit Update for Congruence Class 4
with rel_bixu4_wayB_upd     select
    congr_cl4_wB_d(4)      <=   (congr_cl4_wB_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayB   Thread 3   Watch Bit Update for Congruence Class 4
with rel_bixu4_wayB_upd     select
    congr_cl4_wB_d(5)      <=   (congr_cl4_wB_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayB   Valid Bit Update for Congruence Class 5
with rel_bixu5_wayB_upd     select
    congr_cl5_wB_d(0)      <=   (congr_cl5_wB_q(0)     and not dci_inval_all_q) when "00",
                           (flush_wayB_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayB_data2_q(0)   and not dci_inval_all_q) when others;
-- WayB   Lock Bit Update for Congruence Class 5
with rel_bixu5_wayB_upd     select
    congr_cl5_wB_d(1)      <=   (congr_cl5_wB_q(1)     and not lock_finval) when "00",
                           (flush_wayB_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayB_data2_q(1)   and not lock_finval) when others;
-- WayB   Thread 0   Watch Bit Update for Congruence Class 5
with rel_bixu5_wayB_upd     select
    congr_cl5_wB_d(2)      <=   (congr_cl5_wB_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayB   Thread 1   Watch Bit Update for Congruence Class 5
with rel_bixu5_wayB_upd     select
    congr_cl5_wB_d(3)      <=   (congr_cl5_wB_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayB   Thread 2   Watch Bit Update for Congruence Class 5
with rel_bixu5_wayB_upd     select
    congr_cl5_wB_d(4)      <=   (congr_cl5_wB_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayB   Thread 3   Watch Bit Update for Congruence Class 5
with rel_bixu5_wayB_upd     select
    congr_cl5_wB_d(5)      <=   (congr_cl5_wB_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayB   Valid Bit Update for Congruence Class 6
with rel_bixu6_wayB_upd     select
    congr_cl6_wB_d(0)      <=   (congr_cl6_wB_q(0)     and not dci_inval_all_q) when "00",
                           (flush_wayB_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayB_data2_q(0)   and not dci_inval_all_q) when others;
-- WayB   Lock Bit Update for Congruence Class 6
with rel_bixu6_wayB_upd     select
    congr_cl6_wB_d(1)      <=   (congr_cl6_wB_q(1)     and not lock_finval) when "00",
                           (flush_wayB_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayB_data2_q(1)   and not lock_finval) when others;
-- WayB   Thread 0   Watch Bit Update for Congruence Class 6
with rel_bixu6_wayB_upd     select
    congr_cl6_wB_d(2)      <=   (congr_cl6_wB_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayB   Thread 1   Watch Bit Update for Congruence Class 6
with rel_bixu6_wayB_upd     select
    congr_cl6_wB_d(3)      <=   (congr_cl6_wB_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayB   Thread 2   Watch Bit Update for Congruence Class 6
with rel_bixu6_wayB_upd     select
    congr_cl6_wB_d(4)      <=   (congr_cl6_wB_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayB   Thread 3   Watch Bit Update for Congruence Class 6
with rel_bixu6_wayB_upd     select
    congr_cl6_wB_d(5)      <=   (congr_cl6_wB_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayB   Valid Bit Update for Congruence Class 7
with rel_bixu7_wayB_upd     select
    congr_cl7_wB_d(0)      <=   (congr_cl7_wB_q(0)     and not dci_inval_all_q) when "00",
                           (flush_wayB_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayB_data2_q(0)   and not dci_inval_all_q) when others;
-- WayB   Lock Bit Update for Congruence Class 7
with rel_bixu7_wayB_upd     select
    congr_cl7_wB_d(1)      <=   (congr_cl7_wB_q(1)     and not lock_finval) when "00",
                           (flush_wayB_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayB_data2_q(1)   and not lock_finval) when others;
-- WayB   Thread 0   Watch Bit Update for Congruence Class 7
with rel_bixu7_wayB_upd     select
    congr_cl7_wB_d(2)      <=   (congr_cl7_wB_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayB   Thread 1   Watch Bit Update for Congruence Class 7
with rel_bixu7_wayB_upd     select
    congr_cl7_wB_d(3)      <=   (congr_cl7_wB_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayB   Thread 2   Watch Bit Update for Congruence Class 7
with rel_bixu7_wayB_upd     select
    congr_cl7_wB_d(4)      <=   (congr_cl7_wB_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayB   Thread 3   Watch Bit Update for Congruence Class 7
with rel_bixu7_wayB_upd     select
    congr_cl7_wB_d(5)      <=   (congr_cl7_wB_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayB   Valid Bit Update for Congruence Class 8
with rel_bixu8_wayB_upd     select
    congr_cl8_wB_d(0)      <=   (congr_cl8_wB_q(0)     and not dci_inval_all_q) when "00",
                           (flush_wayB_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayB_data2_q(0)   and not dci_inval_all_q) when others;
-- WayB   Lock Bit Update for Congruence Class 8
with rel_bixu8_wayB_upd     select
    congr_cl8_wB_d(1)      <=   (congr_cl8_wB_q(1)     and not lock_finval) when "00",
                           (flush_wayB_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayB_data2_q(1)   and not lock_finval) when others;
-- WayB   Thread 0   Watch Bit Update for Congruence Class 8
with rel_bixu8_wayB_upd     select
    congr_cl8_wB_d(2)      <=   (congr_cl8_wB_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayB   Thread 1   Watch Bit Update for Congruence Class 8
with rel_bixu8_wayB_upd     select
    congr_cl8_wB_d(3)      <=   (congr_cl8_wB_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayB   Thread 2   Watch Bit Update for Congruence Class 8
with rel_bixu8_wayB_upd     select
    congr_cl8_wB_d(4)      <=   (congr_cl8_wB_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayB   Thread 3   Watch Bit Update for Congruence Class 8
with rel_bixu8_wayB_upd     select
    congr_cl8_wB_d(5)      <=   (congr_cl8_wB_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayB   Valid Bit Update for Congruence Class 9
with rel_bixu9_wayB_upd     select
    congr_cl9_wB_d(0)      <=   (congr_cl9_wB_q(0)     and not dci_inval_all_q) when "00",
                           (flush_wayB_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayB_data2_q(0)   and not dci_inval_all_q) when others;
-- WayB   Lock Bit Update for Congruence Class 9
with rel_bixu9_wayB_upd     select
    congr_cl9_wB_d(1)      <=   (congr_cl9_wB_q(1)     and not lock_finval) when "00",
                           (flush_wayB_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayB_data2_q(1)   and not lock_finval) when others;
-- WayB   Thread 0   Watch Bit Update for Congruence Class 9
with rel_bixu9_wayB_upd     select
    congr_cl9_wB_d(2)      <=   (congr_cl9_wB_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayB   Thread 1   Watch Bit Update for Congruence Class 9
with rel_bixu9_wayB_upd     select
    congr_cl9_wB_d(3)      <=   (congr_cl9_wB_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayB   Thread 2   Watch Bit Update for Congruence Class 9
with rel_bixu9_wayB_upd     select
    congr_cl9_wB_d(4)      <=   (congr_cl9_wB_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayB   Thread 3   Watch Bit Update for Congruence Class 9
with rel_bixu9_wayB_upd     select
    congr_cl9_wB_d(5)      <=   (congr_cl9_wB_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayB   Valid Bit Update for Congruence Class 10
with rel_bixu10_wayB_upd    select
    congr_cl10_wB_d(0)     <=   (congr_cl10_wB_q(0)    and not dci_inval_all_q) when "00",
                           (flush_wayB_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayB_data2_q(0)   and not dci_inval_all_q) when others;
-- WayB   Lock Bit Update for Congruence Class 10
with rel_bixu10_wayB_upd    select
    congr_cl10_wB_d(1)     <=   (congr_cl10_wB_q(1)    and not lock_finval) when "00",
                           (flush_wayB_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayB_data2_q(1)   and not lock_finval) when others;
-- WayB   Thread 0   Watch Bit Update for Congruence Class 10
with rel_bixu10_wayB_upd    select
    congr_cl10_wB_d(2)      <=   (congr_cl10_wB_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayB   Thread 1   Watch Bit Update for Congruence Class 10
with rel_bixu10_wayB_upd    select
    congr_cl10_wB_d(3)      <=   (congr_cl10_wB_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayB   Thread 2   Watch Bit Update for Congruence Class 10
with rel_bixu10_wayB_upd    select
    congr_cl10_wB_d(4)      <=   (congr_cl10_wB_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayB   Thread 3   Watch Bit Update for Congruence Class 10
with rel_bixu10_wayB_upd    select
    congr_cl10_wB_d(5)      <=   (congr_cl10_wB_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayB   Valid Bit Update for Congruence Class 11
with rel_bixu11_wayB_upd    select
    congr_cl11_wB_d(0)     <=   (congr_cl11_wB_q(0)    and not dci_inval_all_q) when "00",
                           (flush_wayB_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayB_data2_q(0)   and not dci_inval_all_q) when others;
-- WayB   Lock Bit Update for Congruence Class 11
with rel_bixu11_wayB_upd    select
    congr_cl11_wB_d(1)     <=   (congr_cl11_wB_q(1)    and not lock_finval) when "00",
                           (flush_wayB_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayB_data2_q(1)   and not lock_finval) when others;
-- WayB   Thread 0   Watch Bit Update for Congruence Class 11
with rel_bixu11_wayB_upd    select
    congr_cl11_wB_d(2)      <=   (congr_cl11_wB_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayB   Thread 1   Watch Bit Update for Congruence Class 11
with rel_bixu11_wayB_upd    select
    congr_cl11_wB_d(3)      <=   (congr_cl11_wB_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayB   Thread 2   Watch Bit Update for Congruence Class 11
with rel_bixu11_wayB_upd    select
    congr_cl11_wB_d(4)      <=   (congr_cl11_wB_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayB   Thread 3   Watch Bit Update for Congruence Class 11
with rel_bixu11_wayB_upd    select
    congr_cl11_wB_d(5)      <=   (congr_cl11_wB_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayB   Valid Bit Update for Congruence Class 12
with rel_bixu12_wayB_upd    select
    congr_cl12_wB_d(0)     <=   (congr_cl12_wB_q(0)    and not dci_inval_all_q) when "00",
                           (flush_wayB_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayB_data2_q(0)   and not dci_inval_all_q) when others;
-- WayB   Lock Bit Update for Congruence Class 12
with rel_bixu12_wayB_upd    select
    congr_cl12_wB_d(1)     <=   (congr_cl12_wB_q(1)    and not lock_finval) when "00",
                           (flush_wayB_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayB_data2_q(1)   and not lock_finval) when others;
-- WayB   Thread 0   Watch Bit Update for Congruence Class 12
with rel_bixu12_wayB_upd    select
    congr_cl12_wB_d(2)      <=   (congr_cl12_wB_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayB   Thread 1   Watch Bit Update for Congruence Class 12
with rel_bixu12_wayB_upd    select
    congr_cl12_wB_d(3)      <=   (congr_cl12_wB_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayB   Thread 2   Watch Bit Update for Congruence Class 12
with rel_bixu12_wayB_upd    select
    congr_cl12_wB_d(4)      <=   (congr_cl12_wB_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayB   Thread 3   Watch Bit Update for Congruence Class 12
with rel_bixu12_wayB_upd    select
    congr_cl12_wB_d(5)      <=   (congr_cl12_wB_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayB   Valid Bit Update for Congruence Class 13
with rel_bixu13_wayB_upd    select
    congr_cl13_wB_d(0)     <=   (congr_cl13_wB_q(0)    and not dci_inval_all_q) when "00",
                           (flush_wayB_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayB_data2_q(0)   and not dci_inval_all_q) when others;
-- WayB   Lock Bit Update for Congruence Class 13
with rel_bixu13_wayB_upd    select
    congr_cl13_wB_d(1)     <=   (congr_cl13_wB_q(1)    and not lock_finval) when "00",
                           (flush_wayB_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayB_data2_q(1)   and not lock_finval) when others;
-- WayB   Thread 0   Watch Bit Update for Congruence Class 13
with rel_bixu13_wayB_upd    select
    congr_cl13_wB_d(2)      <=   (congr_cl13_wB_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayB   Thread 1   Watch Bit Update for Congruence Class 13
with rel_bixu13_wayB_upd    select
    congr_cl13_wB_d(3)      <=   (congr_cl13_wB_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayB   Thread 2   Watch Bit Update for Congruence Class 13
with rel_bixu13_wayB_upd    select
    congr_cl13_wB_d(4)      <=   (congr_cl13_wB_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayB   Thread 3   Watch Bit Update for Congruence Class 13
with rel_bixu13_wayB_upd    select
    congr_cl13_wB_d(5)      <=   (congr_cl13_wB_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayB   Valid Bit Update for Congruence Class 14
with rel_bixu14_wayB_upd    select
    congr_cl14_wB_d(0)     <=   (congr_cl14_wB_q(0)    and not dci_inval_all_q) when "00",
                           (flush_wayB_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayB_data2_q(0)   and not dci_inval_all_q) when others;
-- WayB   Lock Bit Update for Congruence Class 14
with rel_bixu14_wayB_upd    select
    congr_cl14_wB_d(1)     <=   (congr_cl14_wB_q(1)    and not lock_finval) when "00",
                           (flush_wayB_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayB_data2_q(1)   and not lock_finval) when others;
-- WayB   Thread 0   Watch Bit Update for Congruence Class 14
with rel_bixu14_wayB_upd    select
    congr_cl14_wB_d(2)      <=   (congr_cl14_wB_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayB   Thread 1   Watch Bit Update for Congruence Class 14
with rel_bixu14_wayB_upd    select
    congr_cl14_wB_d(3)      <=   (congr_cl14_wB_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayB   Thread 2   Watch Bit Update for Congruence Class 14
with rel_bixu14_wayB_upd    select
    congr_cl14_wB_d(4)      <=   (congr_cl14_wB_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayB   Thread 3   Watch Bit Update for Congruence Class 14
with rel_bixu14_wayB_upd    select
    congr_cl14_wB_d(5)      <=   (congr_cl14_wB_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayB   Valid Bit Update for Congruence Class 15
with rel_bixu15_wayB_upd    select
    congr_cl15_wB_d(0)     <=   (congr_cl15_wB_q(0)    and not dci_inval_all_q) when "00",
                           (flush_wayB_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayB_data2_q(0)   and not dci_inval_all_q) when others;
-- WayB   Lock Bit Update for Congruence Class 15
with rel_bixu15_wayB_upd    select
    congr_cl15_wB_d(1)     <=   (congr_cl15_wB_q(1)    and not lock_finval) when "00",
                           (flush_wayB_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayB_data2_q(1)   and not lock_finval) when others;
-- WayB   Thread 0   Watch Bit Update for Congruence Class 15
with rel_bixu15_wayB_upd    select
    congr_cl15_wB_d(2)      <=   (congr_cl15_wB_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayB   Thread 1   Watch Bit Update for Congruence Class 15
with rel_bixu15_wayB_upd    select
    congr_cl15_wB_d(3)      <=   (congr_cl15_wB_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayB   Thread 2   Watch Bit Update for Congruence Class 15
with rel_bixu15_wayB_upd    select
    congr_cl15_wB_d(4)      <=   (congr_cl15_wB_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayB   Thread 3   Watch Bit Update for Congruence Class 15
with rel_bixu15_wayB_upd    select
    congr_cl15_wB_d(5)      <=   (congr_cl15_wB_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayB   Valid Bit Update for Congruence Class 16
with rel_bixu16_wayB_upd    select
    congr_cl16_wB_d(0)     <=   (congr_cl16_wB_q(0)    and not dci_inval_all_q) when "00",
                           (flush_wayB_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayB_data2_q(0)   and not dci_inval_all_q) when others;
-- WayB   Lock Bit Update for Congruence Class 16
with rel_bixu16_wayB_upd    select
    congr_cl16_wB_d(1)     <=   (congr_cl16_wB_q(1)    and not lock_finval) when "00",
                           (flush_wayB_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayB_data2_q(1)   and not lock_finval) when others;
-- WayB   Thread 0   Watch Bit Update for Congruence Class 16
with rel_bixu16_wayB_upd    select
    congr_cl16_wB_d(2)      <=   (congr_cl16_wB_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayB   Thread 1   Watch Bit Update for Congruence Class 16
with rel_bixu16_wayB_upd    select
    congr_cl16_wB_d(3)      <=   (congr_cl16_wB_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayB   Thread 2   Watch Bit Update for Congruence Class 16
with rel_bixu16_wayB_upd    select
    congr_cl16_wB_d(4)      <=   (congr_cl16_wB_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayB   Thread 3   Watch Bit Update for Congruence Class 16
with rel_bixu16_wayB_upd    select
    congr_cl16_wB_d(5)      <=   (congr_cl16_wB_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayB   Valid Bit Update for Congruence Class 17
with rel_bixu17_wayB_upd    select
    congr_cl17_wB_d(0)     <=   (congr_cl17_wB_q(0)    and not dci_inval_all_q) when "00",
                           (flush_wayB_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayB_data2_q(0)   and not dci_inval_all_q) when others;
-- WayB   Lock Bit Update for Congruence Class 17
with rel_bixu17_wayB_upd    select
    congr_cl17_wB_d(1)     <=   (congr_cl17_wB_q(1)    and not lock_finval) when "00",
                           (flush_wayB_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayB_data2_q(1)   and not lock_finval) when others;
-- WayB   Thread 0   Watch Bit Update for Congruence Class 17
with rel_bixu17_wayB_upd    select
    congr_cl17_wB_d(2)      <=   (congr_cl17_wB_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayB   Thread 1   Watch Bit Update for Congruence Class 17
with rel_bixu17_wayB_upd    select
    congr_cl17_wB_d(3)      <=   (congr_cl17_wB_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayB   Thread 2   Watch Bit Update for Congruence Class 17
with rel_bixu17_wayB_upd    select
    congr_cl17_wB_d(4)      <=   (congr_cl17_wB_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayB   Thread 3   Watch Bit Update for Congruence Class 17
with rel_bixu17_wayB_upd    select
    congr_cl17_wB_d(5)      <=   (congr_cl17_wB_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayB   Valid Bit Update for Congruence Class 18
with rel_bixu18_wayB_upd    select
    congr_cl18_wB_d(0)     <=   (congr_cl18_wB_q(0)    and not dci_inval_all_q) when "00",
                           (flush_wayB_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayB_data2_q(0)   and not dci_inval_all_q) when others;
-- WayB   Lock Bit Update for Congruence Class 18
with rel_bixu18_wayB_upd    select
    congr_cl18_wB_d(1)     <=   (congr_cl18_wB_q(1)    and not lock_finval) when "00",
                           (flush_wayB_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayB_data2_q(1)   and not lock_finval) when others;
-- WayB   Thread 0   Watch Bit Update for Congruence Class 18
with rel_bixu18_wayB_upd    select
    congr_cl18_wB_d(2)      <=   (congr_cl18_wB_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayB   Thread 1   Watch Bit Update for Congruence Class 18
with rel_bixu18_wayB_upd    select
    congr_cl18_wB_d(3)      <=   (congr_cl18_wB_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayB   Thread 2   Watch Bit Update for Congruence Class 18
with rel_bixu18_wayB_upd    select
    congr_cl18_wB_d(4)      <=   (congr_cl18_wB_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayB   Thread 3   Watch Bit Update for Congruence Class 18
with rel_bixu18_wayB_upd    select
    congr_cl18_wB_d(5)      <=   (congr_cl18_wB_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayB   Valid Bit Update for Congruence Class 19
with rel_bixu19_wayB_upd    select
    congr_cl19_wB_d(0)     <=   (congr_cl19_wB_q(0)    and not dci_inval_all_q) when "00",
                           (flush_wayB_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayB_data2_q(0)   and not dci_inval_all_q) when others;
-- WayB   Lock Bit Update for Congruence Class 19
with rel_bixu19_wayB_upd    select
    congr_cl19_wB_d(1)     <=   (congr_cl19_wB_q(1)    and not lock_finval) when "00",
                           (flush_wayB_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayB_data2_q(1)   and not lock_finval) when others;
-- WayB   Thread 0   Watch Bit Update for Congruence Class 19
with rel_bixu19_wayB_upd    select
    congr_cl19_wB_d(2)      <=   (congr_cl19_wB_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayB   Thread 1   Watch Bit Update for Congruence Class 19
with rel_bixu19_wayB_upd    select
    congr_cl19_wB_d(3)      <=   (congr_cl19_wB_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayB   Thread 2   Watch Bit Update for Congruence Class 19
with rel_bixu19_wayB_upd    select
    congr_cl19_wB_d(4)      <=   (congr_cl19_wB_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayB   Thread 3   Watch Bit Update for Congruence Class 19
with rel_bixu19_wayB_upd    select
    congr_cl19_wB_d(5)      <=   (congr_cl19_wB_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayB   Valid Bit Update for Congruence Class 20
with rel_bixu20_wayB_upd    select
    congr_cl20_wB_d(0)     <=   (congr_cl20_wB_q(0)    and not dci_inval_all_q) when "00",
                           (flush_wayB_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayB_data2_q(0)   and not dci_inval_all_q) when others;
-- WayB   Lock Bit Update for Congruence Class 20
with rel_bixu20_wayB_upd    select
    congr_cl20_wB_d(1)     <=   (congr_cl20_wB_q(1)    and not lock_finval) when "00",
                           (flush_wayB_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayB_data2_q(1)   and not lock_finval) when others;
-- WayB   Thread 0   Watch Bit Update for Congruence Class 20
with rel_bixu20_wayB_upd    select
    congr_cl20_wB_d(2)      <=   (congr_cl20_wB_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayB   Thread 1   Watch Bit Update for Congruence Class 20
with rel_bixu20_wayB_upd    select
    congr_cl20_wB_d(3)      <=   (congr_cl20_wB_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayB   Thread 2   Watch Bit Update for Congruence Class 20
with rel_bixu20_wayB_upd    select
    congr_cl20_wB_d(4)      <=   (congr_cl20_wB_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayB   Thread 3   Watch Bit Update for Congruence Class 20
with rel_bixu20_wayB_upd    select
    congr_cl20_wB_d(5)      <=   (congr_cl20_wB_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayB   Valid Bit Update for Congruence Class 21
with rel_bixu21_wayB_upd    select
    congr_cl21_wB_d(0)     <=   (congr_cl21_wB_q(0)    and not dci_inval_all_q) when "00",
                           (flush_wayB_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayB_data2_q(0)   and not dci_inval_all_q) when others;
-- WayB   Lock Bit Update for Congruence Class 21
with rel_bixu21_wayB_upd    select
    congr_cl21_wB_d(1)     <=   (congr_cl21_wB_q(1)    and not lock_finval) when "00",
                           (flush_wayB_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayB_data2_q(1)   and not lock_finval) when others;
-- WayB   Thread 0   Watch Bit Update for Congruence Class 21
with rel_bixu21_wayB_upd    select
    congr_cl21_wB_d(2)      <=   (congr_cl21_wB_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayB   Thread 1   Watch Bit Update for Congruence Class 21
with rel_bixu21_wayB_upd    select
    congr_cl21_wB_d(3)      <=   (congr_cl21_wB_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayB   Thread 2   Watch Bit Update for Congruence Class 21
with rel_bixu21_wayB_upd    select
    congr_cl21_wB_d(4)      <=   (congr_cl21_wB_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayB   Thread 3   Watch Bit Update for Congruence Class 21
with rel_bixu21_wayB_upd    select
    congr_cl21_wB_d(5)      <=   (congr_cl21_wB_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayB   Valid Bit Update for Congruence Class 22
with rel_bixu22_wayB_upd    select
    congr_cl22_wB_d(0)     <=   (congr_cl22_wB_q(0)    and not dci_inval_all_q) when "00",
                           (flush_wayB_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayB_data2_q(0)   and not dci_inval_all_q) when others;
-- WayB   Lock Bit Update for Congruence Class 22
with rel_bixu22_wayB_upd    select
    congr_cl22_wB_d(1)     <=   (congr_cl22_wB_q(1)    and not lock_finval) when "00",
                           (flush_wayB_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayB_data2_q(1)   and not lock_finval) when others;
-- WayB   Thread 0   Watch Bit Update for Congruence Class 22
with rel_bixu22_wayB_upd    select
    congr_cl22_wB_d(2)      <=   (congr_cl22_wB_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayB   Thread 1   Watch Bit Update for Congruence Class 22
with rel_bixu22_wayB_upd    select
    congr_cl22_wB_d(3)      <=   (congr_cl22_wB_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayB   Thread 2   Watch Bit Update for Congruence Class 22
with rel_bixu22_wayB_upd    select
    congr_cl22_wB_d(4)      <=   (congr_cl22_wB_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayB   Thread 3   Watch Bit Update for Congruence Class 22
with rel_bixu22_wayB_upd    select
    congr_cl22_wB_d(5)      <=   (congr_cl22_wB_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayB   Valid Bit Update for Congruence Class 23
with rel_bixu23_wayB_upd    select
    congr_cl23_wB_d(0)     <=   (congr_cl23_wB_q(0)    and not dci_inval_all_q) when "00",
                           (flush_wayB_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayB_data2_q(0)   and not dci_inval_all_q) when others;
-- WayB   Lock Bit Update for Congruence Class 23
with rel_bixu23_wayB_upd    select
    congr_cl23_wB_d(1)     <=   (congr_cl23_wB_q(1)    and not lock_finval) when "00",
                           (flush_wayB_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayB_data2_q(1)   and not lock_finval) when others;
-- WayB   Thread 0   Watch Bit Update for Congruence Class 23
with rel_bixu23_wayB_upd    select
    congr_cl23_wB_d(2)      <=   (congr_cl23_wB_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayB   Thread 1   Watch Bit Update for Congruence Class 23
with rel_bixu23_wayB_upd    select
    congr_cl23_wB_d(3)      <=   (congr_cl23_wB_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayB   Thread 2   Watch Bit Update for Congruence Class 23
with rel_bixu23_wayB_upd    select
    congr_cl23_wB_d(4)      <=   (congr_cl23_wB_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayB   Thread 3   Watch Bit Update for Congruence Class 23
with rel_bixu23_wayB_upd    select
    congr_cl23_wB_d(5)      <=   (congr_cl23_wB_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayB   Valid Bit Update for Congruence Class 24
with rel_bixu24_wayB_upd    select
    congr_cl24_wB_d(0)     <=   (congr_cl24_wB_q(0)    and not dci_inval_all_q) when "00",
                           (flush_wayB_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayB_data2_q(0)   and not dci_inval_all_q) when others;
-- WayB   Lock Bit Update for Congruence Class 24
with rel_bixu24_wayB_upd    select
    congr_cl24_wB_d(1)     <=   (congr_cl24_wB_q(1)    and not lock_finval) when "00",
                           (flush_wayB_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayB_data2_q(1)   and not lock_finval) when others;
-- WayB   Thread 0   Watch Bit Update for Congruence Class 24
with rel_bixu24_wayB_upd    select
    congr_cl24_wB_d(2)      <=   (congr_cl24_wB_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayB   Thread 1   Watch Bit Update for Congruence Class 24
with rel_bixu24_wayB_upd    select
    congr_cl24_wB_d(3)      <=   (congr_cl24_wB_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayB   Thread 2   Watch Bit Update for Congruence Class 24
with rel_bixu24_wayB_upd    select
    congr_cl24_wB_d(4)      <=   (congr_cl24_wB_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayB   Thread 3   Watch Bit Update for Congruence Class 24
with rel_bixu24_wayB_upd    select
    congr_cl24_wB_d(5)      <=   (congr_cl24_wB_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayB   Valid Bit Update for Congruence Class 25
with rel_bixu25_wayB_upd    select
    congr_cl25_wB_d(0)     <=   (congr_cl25_wB_q(0)    and not dci_inval_all_q) when "00",
                           (flush_wayB_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayB_data2_q(0)   and not dci_inval_all_q) when others;
-- WayB   Lock Bit Update for Congruence Class 25
with rel_bixu25_wayB_upd    select
    congr_cl25_wB_d(1)     <=   (congr_cl25_wB_q(1)    and not lock_finval) when "00",
                           (flush_wayB_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayB_data2_q(1)   and not lock_finval) when others;
-- WayB   Thread 0   Watch Bit Update for Congruence Class 25
with rel_bixu25_wayB_upd    select
    congr_cl25_wB_d(2)      <=   (congr_cl25_wB_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayB   Thread 1   Watch Bit Update for Congruence Class 25
with rel_bixu25_wayB_upd    select
    congr_cl25_wB_d(3)      <=   (congr_cl25_wB_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayB   Thread 2   Watch Bit Update for Congruence Class 25
with rel_bixu25_wayB_upd    select
    congr_cl25_wB_d(4)      <=   (congr_cl25_wB_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayB   Thread 3   Watch Bit Update for Congruence Class 25
with rel_bixu25_wayB_upd    select
    congr_cl25_wB_d(5)      <=   (congr_cl25_wB_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayB   Valid Bit Update for Congruence Class 26
with rel_bixu26_wayB_upd    select
    congr_cl26_wB_d(0)     <=   (congr_cl26_wB_q(0)    and not dci_inval_all_q) when "00",
                           (flush_wayB_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayB_data2_q(0)   and not dci_inval_all_q) when others;
-- WayB   Lock Bit Update for Congruence Class 26
with rel_bixu26_wayB_upd    select
    congr_cl26_wB_d(1)     <=   (congr_cl26_wB_q(1)    and not lock_finval) when "00",
                           (flush_wayB_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayB_data2_q(1)   and not lock_finval) when others;
-- WayB   Thread 0   Watch Bit Update for Congruence Class 26
with rel_bixu26_wayB_upd    select
    congr_cl26_wB_d(2)      <=   (congr_cl26_wB_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayB   Thread 1   Watch Bit Update for Congruence Class 26
with rel_bixu26_wayB_upd    select
    congr_cl26_wB_d(3)      <=   (congr_cl26_wB_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayB   Thread 2   Watch Bit Update for Congruence Class 26
with rel_bixu26_wayB_upd    select
    congr_cl26_wB_d(4)      <=   (congr_cl26_wB_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayB   Thread 3   Watch Bit Update for Congruence Class 26
with rel_bixu26_wayB_upd    select
    congr_cl26_wB_d(5)      <=   (congr_cl26_wB_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayB   Valid Bit Update for Congruence Class 27
with rel_bixu27_wayB_upd    select
    congr_cl27_wB_d(0)     <=   (congr_cl27_wB_q(0)    and not dci_inval_all_q) when "00",
                           (flush_wayB_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayB_data2_q(0)   and not dci_inval_all_q) when others;
-- WayB   Lock Bit Update for Congruence Class 27
with rel_bixu27_wayB_upd    select
    congr_cl27_wB_d(1)     <=   (congr_cl27_wB_q(1)    and not lock_finval) when "00",
                           (flush_wayB_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayB_data2_q(1)   and not lock_finval) when others;
-- WayB   Thread 0   Watch Bit Update for Congruence Class 27
with rel_bixu27_wayB_upd    select
    congr_cl27_wB_d(2)      <=   (congr_cl27_wB_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayB   Thread 1   Watch Bit Update for Congruence Class 27
with rel_bixu27_wayB_upd    select
    congr_cl27_wB_d(3)      <=   (congr_cl27_wB_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayB   Thread 2   Watch Bit Update for Congruence Class 27
with rel_bixu27_wayB_upd    select
    congr_cl27_wB_d(4)      <=   (congr_cl27_wB_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayB   Thread 3   Watch Bit Update for Congruence Class 27
with rel_bixu27_wayB_upd    select
    congr_cl27_wB_d(5)      <=   (congr_cl27_wB_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayB   Valid Bit Update for Congruence Class 28
with rel_bixu28_wayB_upd    select
    congr_cl28_wB_d(0)     <=   (congr_cl28_wB_q(0)    and not dci_inval_all_q) when "00",
                           (flush_wayB_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayB_data2_q(0)   and not dci_inval_all_q) when others;
-- WayB   Lock Bit Update for Congruence Class 28
with rel_bixu28_wayB_upd    select
    congr_cl28_wB_d(1)     <=   (congr_cl28_wB_q(1)    and not lock_finval) when "00",
                           (flush_wayB_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayB_data2_q(1)   and not lock_finval) when others;
-- WayB   Thread 0   Watch Bit Update for Congruence Class 28
with rel_bixu28_wayB_upd    select
    congr_cl28_wB_d(2)      <=   (congr_cl28_wB_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayB   Thread 1   Watch Bit Update for Congruence Class 28
with rel_bixu28_wayB_upd    select
    congr_cl28_wB_d(3)      <=   (congr_cl28_wB_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayB   Thread 2   Watch Bit Update for Congruence Class 28
with rel_bixu28_wayB_upd    select
    congr_cl28_wB_d(4)      <=   (congr_cl28_wB_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayB   Thread 3   Watch Bit Update for Congruence Class 28
with rel_bixu28_wayB_upd    select
    congr_cl28_wB_d(5)      <=   (congr_cl28_wB_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayB   Valid Bit Update for Congruence Class 29
with rel_bixu29_wayB_upd    select
    congr_cl29_wB_d(0)     <=   (congr_cl29_wB_q(0)    and not dci_inval_all_q) when "00",
                           (flush_wayB_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayB_data2_q(0)   and not dci_inval_all_q) when others;
-- WayB   Lock Bit Update for Congruence Class 29
with rel_bixu29_wayB_upd    select
    congr_cl29_wB_d(1)     <=   (congr_cl29_wB_q(1)    and not lock_finval) when "00",
                           (flush_wayB_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayB_data2_q(1)   and not lock_finval) when others;
-- WayB   Thread 0   Watch Bit Update for Congruence Class 29
with rel_bixu29_wayB_upd    select
    congr_cl29_wB_d(2)      <=   (congr_cl29_wB_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayB   Thread 1   Watch Bit Update for Congruence Class 29
with rel_bixu29_wayB_upd    select
    congr_cl29_wB_d(3)      <=   (congr_cl29_wB_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayB   Thread 2   Watch Bit Update for Congruence Class 29
with rel_bixu29_wayB_upd    select
    congr_cl29_wB_d(4)      <=   (congr_cl29_wB_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayB   Thread 3   Watch Bit Update for Congruence Class 29
with rel_bixu29_wayB_upd    select
    congr_cl29_wB_d(5)      <=   (congr_cl29_wB_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayB   Valid Bit Update for Congruence Class 30
with rel_bixu30_wayB_upd    select
    congr_cl30_wB_d(0)     <=   (congr_cl30_wB_q(0)    and not dci_inval_all_q) when "00",
                           (flush_wayB_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayB_data2_q(0)   and not dci_inval_all_q) when others;
-- WayB   Lock Bit Update for Congruence Class 30
with rel_bixu30_wayB_upd    select
    congr_cl30_wB_d(1)     <=   (congr_cl30_wB_q(1)    and not lock_finval) when "00",
                           (flush_wayB_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayB_data2_q(1)   and not lock_finval) when others;
-- WayB   Thread 0   Watch Bit Update for Congruence Class 30
with rel_bixu30_wayB_upd    select
    congr_cl30_wB_d(2)      <=   (congr_cl30_wB_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayB   Thread 1   Watch Bit Update for Congruence Class 30
with rel_bixu30_wayB_upd    select
    congr_cl30_wB_d(3)      <=   (congr_cl30_wB_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayB   Thread 2   Watch Bit Update for Congruence Class 30
with rel_bixu30_wayB_upd    select
    congr_cl30_wB_d(4)      <=   (congr_cl30_wB_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayB   Thread 3   Watch Bit Update for Congruence Class 30
with rel_bixu30_wayB_upd    select
    congr_cl30_wB_d(5)      <=   (congr_cl30_wB_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayB   Valid Bit Update for Congruence Class 31
with rel_bixu31_wayB_upd    select
    congr_cl31_wB_d(0)     <=   (congr_cl31_wB_q(0)    and not dci_inval_all_q) when "00",
                           (flush_wayB_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayB_data2_q(0)   and not dci_inval_all_q) when others;
-- WayB   Lock Bit Update for Congruence Class 31
with rel_bixu31_wayB_upd    select
    congr_cl31_wB_d(1)     <=   (congr_cl31_wB_q(1)    and not lock_finval) when "00",
                           (flush_wayB_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayB_data2_q(1)   and not lock_finval) when others;
-- WayB   Thread 0   Watch Bit Update for Congruence Class 31
with rel_bixu31_wayB_upd    select
    congr_cl31_wB_d(2)      <=   (congr_cl31_wB_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayB   Thread 1   Watch Bit Update for Congruence Class 31
with rel_bixu31_wayB_upd    select
    congr_cl31_wB_d(3)      <=   (congr_cl31_wB_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayB   Thread 2   Watch Bit Update for Congruence Class 31
with rel_bixu31_wayB_upd    select
    congr_cl31_wB_d(4)      <=   (congr_cl31_wB_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayB   Thread 3   Watch Bit Update for Congruence Class 31
with rel_bixu31_wayB_upd    select
    congr_cl31_wB_d(5)      <=   (congr_cl31_wB_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayB   Valid Bit Update for Congruence Class 32
with rel_bixu32_wayB_upd    select
    congr_cl32_wB_d(0)     <=   (congr_cl32_wB_q(0)    and not dci_inval_all_q) when "00",
                           (flush_wayB_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayB_data2_q(0)   and not dci_inval_all_q) when others;
-- WayB   Lock Bit Update for Congruence Class 32
with rel_bixu32_wayB_upd    select
    congr_cl32_wB_d(1)     <=   (congr_cl32_wB_q(1)    and not lock_finval) when "00",
                           (flush_wayB_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayB_data2_q(1)   and not lock_finval) when others;
-- WayB   Thread 0   Watch Bit Update for Congruence Class 32
with rel_bixu32_wayB_upd    select
    congr_cl32_wB_d(2)      <=   (congr_cl32_wB_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayB   Thread 1   Watch Bit Update for Congruence Class 32
with rel_bixu32_wayB_upd    select
    congr_cl32_wB_d(3)      <=   (congr_cl32_wB_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayB   Thread 2   Watch Bit Update for Congruence Class 32
with rel_bixu32_wayB_upd    select
    congr_cl32_wB_d(4)      <=   (congr_cl32_wB_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayB   Thread 3   Watch Bit Update for Congruence Class 32
with rel_bixu32_wayB_upd    select
    congr_cl32_wB_d(5)      <=   (congr_cl32_wB_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayB   Valid Bit Update for Congruence Class 33
with rel_bixu33_wayB_upd    select
    congr_cl33_wB_d(0)     <=   (congr_cl33_wB_q(0)    and not dci_inval_all_q) when "00",
                           (flush_wayB_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayB_data2_q(0)   and not dci_inval_all_q) when others;
-- WayB   Lock Bit Update for Congruence Class 33
with rel_bixu33_wayB_upd    select
    congr_cl33_wB_d(1)     <=   (congr_cl33_wB_q(1)    and not lock_finval) when "00",
                           (flush_wayB_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayB_data2_q(1)   and not lock_finval) when others;
-- WayB   Thread 0   Watch Bit Update for Congruence Class 33
with rel_bixu33_wayB_upd    select
    congr_cl33_wB_d(2)      <=   (congr_cl33_wB_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayB   Thread 1   Watch Bit Update for Congruence Class 33
with rel_bixu33_wayB_upd    select
    congr_cl33_wB_d(3)      <=   (congr_cl33_wB_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayB   Thread 2   Watch Bit Update for Congruence Class 33
with rel_bixu33_wayB_upd    select
    congr_cl33_wB_d(4)      <=   (congr_cl33_wB_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayB   Thread 3   Watch Bit Update for Congruence Class 33
with rel_bixu33_wayB_upd    select
    congr_cl33_wB_d(5)      <=   (congr_cl33_wB_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayB   Valid Bit Update for Congruence Class 34
with rel_bixu34_wayB_upd    select
    congr_cl34_wB_d(0)     <=   (congr_cl34_wB_q(0)    and not dci_inval_all_q) when "00",
                           (flush_wayB_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayB_data2_q(0)   and not dci_inval_all_q) when others;
-- WayB   Lock Bit Update for Congruence Class 34
with rel_bixu34_wayB_upd    select
    congr_cl34_wB_d(1)     <=   (congr_cl34_wB_q(1)    and not lock_finval) when "00",
                           (flush_wayB_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayB_data2_q(1)   and not lock_finval) when others;
-- WayB   Thread 0   Watch Bit Update for Congruence Class 34
with rel_bixu34_wayB_upd    select
    congr_cl34_wB_d(2)      <=   (congr_cl34_wB_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayB   Thread 1   Watch Bit Update for Congruence Class 34
with rel_bixu34_wayB_upd    select
    congr_cl34_wB_d(3)      <=   (congr_cl34_wB_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayB   Thread 2   Watch Bit Update for Congruence Class 34
with rel_bixu34_wayB_upd    select
    congr_cl34_wB_d(4)      <=   (congr_cl34_wB_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayB   Thread 3   Watch Bit Update for Congruence Class 34
with rel_bixu34_wayB_upd    select
    congr_cl34_wB_d(5)      <=   (congr_cl34_wB_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayB   Valid Bit Update for Congruence Class 35
with rel_bixu35_wayB_upd    select
    congr_cl35_wB_d(0)     <=   (congr_cl35_wB_q(0)    and not dci_inval_all_q) when "00",
                           (flush_wayB_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayB_data2_q(0)   and not dci_inval_all_q) when others;
-- WayB   Lock Bit Update for Congruence Class 35
with rel_bixu35_wayB_upd    select
    congr_cl35_wB_d(1)     <=   (congr_cl35_wB_q(1)    and not lock_finval) when "00",
                           (flush_wayB_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayB_data2_q(1)   and not lock_finval) when others;
-- WayB   Thread 0   Watch Bit Update for Congruence Class 35
with rel_bixu35_wayB_upd    select
    congr_cl35_wB_d(2)      <=   (congr_cl35_wB_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayB   Thread 1   Watch Bit Update for Congruence Class 35
with rel_bixu35_wayB_upd    select
    congr_cl35_wB_d(3)      <=   (congr_cl35_wB_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayB   Thread 2   Watch Bit Update for Congruence Class 35
with rel_bixu35_wayB_upd    select
    congr_cl35_wB_d(4)      <=   (congr_cl35_wB_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayB   Thread 3   Watch Bit Update for Congruence Class 35
with rel_bixu35_wayB_upd    select
    congr_cl35_wB_d(5)      <=   (congr_cl35_wB_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayB   Valid Bit Update for Congruence Class 36
with rel_bixu36_wayB_upd    select
    congr_cl36_wB_d(0)     <=   (congr_cl36_wB_q(0)    and not dci_inval_all_q) when "00",
                           (flush_wayB_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayB_data2_q(0)   and not dci_inval_all_q) when others;
-- WayB   Lock Bit Update for Congruence Class 36
with rel_bixu36_wayB_upd    select
    congr_cl36_wB_d(1)     <=   (congr_cl36_wB_q(1)    and not lock_finval) when "00",
                           (flush_wayB_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayB_data2_q(1)   and not lock_finval) when others;
-- WayB   Thread 0   Watch Bit Update for Congruence Class 36
with rel_bixu36_wayB_upd    select
    congr_cl36_wB_d(2)      <=   (congr_cl36_wB_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayB   Thread 1   Watch Bit Update for Congruence Class 36
with rel_bixu36_wayB_upd    select
    congr_cl36_wB_d(3)      <=   (congr_cl36_wB_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayB   Thread 2   Watch Bit Update for Congruence Class 36
with rel_bixu36_wayB_upd    select
    congr_cl36_wB_d(4)      <=   (congr_cl36_wB_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayB   Thread 3   Watch Bit Update for Congruence Class 36
with rel_bixu36_wayB_upd    select
    congr_cl36_wB_d(5)      <=   (congr_cl36_wB_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayB   Valid Bit Update for Congruence Class 37
with rel_bixu37_wayB_upd    select
    congr_cl37_wB_d(0)     <=   (congr_cl37_wB_q(0)    and not dci_inval_all_q) when "00",
                           (flush_wayB_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayB_data2_q(0)   and not dci_inval_all_q) when others;
-- WayB   Lock Bit Update for Congruence Class 37
with rel_bixu37_wayB_upd    select
    congr_cl37_wB_d(1)     <=   (congr_cl37_wB_q(1)    and not lock_finval) when "00",
                           (flush_wayB_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayB_data2_q(1)   and not lock_finval) when others;
-- WayB   Thread 0   Watch Bit Update for Congruence Class 37
with rel_bixu37_wayB_upd    select
    congr_cl37_wB_d(2)      <=   (congr_cl37_wB_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayB   Thread 1   Watch Bit Update for Congruence Class 37
with rel_bixu37_wayB_upd    select
    congr_cl37_wB_d(3)      <=   (congr_cl37_wB_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayB   Thread 2   Watch Bit Update for Congruence Class 37
with rel_bixu37_wayB_upd    select
    congr_cl37_wB_d(4)      <=   (congr_cl37_wB_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayB   Thread 3   Watch Bit Update for Congruence Class 37
with rel_bixu37_wayB_upd    select
    congr_cl37_wB_d(5)      <=   (congr_cl37_wB_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayB   Valid Bit Update for Congruence Class 38
with rel_bixu38_wayB_upd    select
    congr_cl38_wB_d(0)     <=   (congr_cl38_wB_q(0)    and not dci_inval_all_q) when "00",
                           (flush_wayB_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayB_data2_q(0)   and not dci_inval_all_q) when others;
-- WayB   Lock Bit Update for Congruence Class 38
with rel_bixu38_wayB_upd    select
    congr_cl38_wB_d(1)     <=   (congr_cl38_wB_q(1)    and not lock_finval) when "00",
                           (flush_wayB_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayB_data2_q(1)   and not lock_finval) when others;
-- WayB   Thread 0   Watch Bit Update for Congruence Class 38
with rel_bixu38_wayB_upd    select
    congr_cl38_wB_d(2)      <=   (congr_cl38_wB_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayB   Thread 1   Watch Bit Update for Congruence Class 38
with rel_bixu38_wayB_upd    select
    congr_cl38_wB_d(3)      <=   (congr_cl38_wB_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayB   Thread 2   Watch Bit Update for Congruence Class 38
with rel_bixu38_wayB_upd    select
    congr_cl38_wB_d(4)      <=   (congr_cl38_wB_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayB   Thread 3   Watch Bit Update for Congruence Class 38
with rel_bixu38_wayB_upd    select
    congr_cl38_wB_d(5)      <=   (congr_cl38_wB_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayB   Valid Bit Update for Congruence Class 39
with rel_bixu39_wayB_upd    select
    congr_cl39_wB_d(0)     <=   (congr_cl39_wB_q(0)    and not dci_inval_all_q) when "00",
                           (flush_wayB_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayB_data2_q(0)   and not dci_inval_all_q) when others;
-- WayB   Lock Bit Update for Congruence Class 39
with rel_bixu39_wayB_upd    select
    congr_cl39_wB_d(1)     <=   (congr_cl39_wB_q(1)    and not lock_finval) when "00",
                           (flush_wayB_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayB_data2_q(1)   and not lock_finval) when others;
-- WayB   Thread 0   Watch Bit Update for Congruence Class 39
with rel_bixu39_wayB_upd    select
    congr_cl39_wB_d(2)      <=   (congr_cl39_wB_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayB   Thread 1   Watch Bit Update for Congruence Class 39
with rel_bixu39_wayB_upd    select
    congr_cl39_wB_d(3)      <=   (congr_cl39_wB_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayB   Thread 2   Watch Bit Update for Congruence Class 39
with rel_bixu39_wayB_upd    select
    congr_cl39_wB_d(4)      <=   (congr_cl39_wB_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayB   Thread 3   Watch Bit Update for Congruence Class 39
with rel_bixu39_wayB_upd    select
    congr_cl39_wB_d(5)      <=   (congr_cl39_wB_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayB   Valid Bit Update for Congruence Class 40
with rel_bixu40_wayB_upd    select
    congr_cl40_wB_d(0)     <=   (congr_cl40_wB_q(0)    and not dci_inval_all_q) when "00",
                           (flush_wayB_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayB_data2_q(0)   and not dci_inval_all_q) when others;
-- WayB   Lock Bit Update for Congruence Class 40
with rel_bixu40_wayB_upd    select
    congr_cl40_wB_d(1)     <=   (congr_cl40_wB_q(1)    and not lock_finval) when "00",
                           (flush_wayB_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayB_data2_q(1)   and not lock_finval) when others;
-- WayB   Thread 0   Watch Bit Update for Congruence Class 40
with rel_bixu40_wayB_upd    select
    congr_cl40_wB_d(2)      <=   (congr_cl40_wB_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayB   Thread 1   Watch Bit Update for Congruence Class 40
with rel_bixu40_wayB_upd    select
    congr_cl40_wB_d(3)      <=   (congr_cl40_wB_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayB   Thread 2   Watch Bit Update for Congruence Class 40
with rel_bixu40_wayB_upd    select
    congr_cl40_wB_d(4)      <=   (congr_cl40_wB_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayB   Thread 3   Watch Bit Update for Congruence Class 40
with rel_bixu40_wayB_upd    select
    congr_cl40_wB_d(5)      <=   (congr_cl40_wB_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayB   Valid Bit Update for Congruence Class 41
with rel_bixu41_wayB_upd    select
    congr_cl41_wB_d(0)     <=   (congr_cl41_wB_q(0)    and not dci_inval_all_q) when "00",
                           (flush_wayB_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayB_data2_q(0)   and not dci_inval_all_q) when others;
-- WayB   Lock Bit Update for Congruence Class 41
with rel_bixu41_wayB_upd    select
    congr_cl41_wB_d(1)     <=   (congr_cl41_wB_q(1)    and not lock_finval) when "00",
                           (flush_wayB_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayB_data2_q(1)   and not lock_finval) when others;
-- WayB   Thread 0   Watch Bit Update for Congruence Class 41
with rel_bixu41_wayB_upd    select
    congr_cl41_wB_d(2)      <=   (congr_cl41_wB_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayB   Thread 1   Watch Bit Update for Congruence Class 41
with rel_bixu41_wayB_upd    select
    congr_cl41_wB_d(3)      <=   (congr_cl41_wB_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayB   Thread 2   Watch Bit Update for Congruence Class 41
with rel_bixu41_wayB_upd    select
    congr_cl41_wB_d(4)      <=   (congr_cl41_wB_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayB   Thread 3   Watch Bit Update for Congruence Class 41
with rel_bixu41_wayB_upd    select
    congr_cl41_wB_d(5)      <=   (congr_cl41_wB_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayB   Valid Bit Update for Congruence Class 42
with rel_bixu42_wayB_upd    select
    congr_cl42_wB_d(0)     <=   (congr_cl42_wB_q(0)    and not dci_inval_all_q) when "00",
                           (flush_wayB_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayB_data2_q(0)   and not dci_inval_all_q) when others;
-- WayB   Lock Bit Update for Congruence Class 42
with rel_bixu42_wayB_upd    select
    congr_cl42_wB_d(1)     <=   (congr_cl42_wB_q(1)    and not lock_finval) when "00",
                           (flush_wayB_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayB_data2_q(1)   and not lock_finval) when others;
-- WayB   Thread 0   Watch Bit Update for Congruence Class 42
with rel_bixu42_wayB_upd    select
    congr_cl42_wB_d(2)      <=   (congr_cl42_wB_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayB   Thread 1   Watch Bit Update for Congruence Class 42
with rel_bixu42_wayB_upd    select
    congr_cl42_wB_d(3)      <=   (congr_cl42_wB_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayB   Thread 2   Watch Bit Update for Congruence Class 42
with rel_bixu42_wayB_upd    select
    congr_cl42_wB_d(4)      <=   (congr_cl42_wB_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayB   Thread 3   Watch Bit Update for Congruence Class 42
with rel_bixu42_wayB_upd    select
    congr_cl42_wB_d(5)      <=   (congr_cl42_wB_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayB   Valid Bit Update for Congruence Class 43
with rel_bixu43_wayB_upd    select
    congr_cl43_wB_d(0)     <=   (congr_cl43_wB_q(0)    and not dci_inval_all_q) when "00",
                           (flush_wayB_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayB_data2_q(0)   and not dci_inval_all_q) when others;
-- WayB   Lock Bit Update for Congruence Class 43
with rel_bixu43_wayB_upd    select
    congr_cl43_wB_d(1)     <=   (congr_cl43_wB_q(1)    and not lock_finval) when "00",
                           (flush_wayB_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayB_data2_q(1)   and not lock_finval) when others;
-- WayB   Thread 0   Watch Bit Update for Congruence Class 43
with rel_bixu43_wayB_upd    select
    congr_cl43_wB_d(2)      <=   (congr_cl43_wB_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayB   Thread 1   Watch Bit Update for Congruence Class 43
with rel_bixu43_wayB_upd    select
    congr_cl43_wB_d(3)      <=   (congr_cl43_wB_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayB   Thread 2   Watch Bit Update for Congruence Class 43
with rel_bixu43_wayB_upd    select
    congr_cl43_wB_d(4)      <=   (congr_cl43_wB_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayB   Thread 3   Watch Bit Update for Congruence Class 43
with rel_bixu43_wayB_upd    select
    congr_cl43_wB_d(5)      <=   (congr_cl43_wB_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayB   Valid Bit Update for Congruence Class 44
with rel_bixu44_wayB_upd    select
    congr_cl44_wB_d(0)     <=   (congr_cl44_wB_q(0)    and not dci_inval_all_q) when "00",
                           (flush_wayB_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayB_data2_q(0)   and not dci_inval_all_q) when others;
-- WayB   Lock Bit Update for Congruence Class 44
with rel_bixu44_wayB_upd    select
    congr_cl44_wB_d(1)     <=   (congr_cl44_wB_q(1)    and not lock_finval) when "00",
                           (flush_wayB_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayB_data2_q(1)   and not lock_finval) when others;
-- WayB   Thread 0   Watch Bit Update for Congruence Class 44
with rel_bixu44_wayB_upd    select
    congr_cl44_wB_d(2)      <=   (congr_cl44_wB_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayB   Thread 1   Watch Bit Update for Congruence Class 44
with rel_bixu44_wayB_upd    select
    congr_cl44_wB_d(3)      <=   (congr_cl44_wB_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayB   Thread 2   Watch Bit Update for Congruence Class 44
with rel_bixu44_wayB_upd    select
    congr_cl44_wB_d(4)      <=   (congr_cl44_wB_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayB   Thread 3   Watch Bit Update for Congruence Class 44
with rel_bixu44_wayB_upd    select
    congr_cl44_wB_d(5)      <=   (congr_cl44_wB_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayB   Valid Bit Update for Congruence Class 45
with rel_bixu45_wayB_upd    select
    congr_cl45_wB_d(0)     <=   (congr_cl45_wB_q(0)    and not dci_inval_all_q) when "00",
                           (flush_wayB_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayB_data2_q(0)   and not dci_inval_all_q) when others;
-- WayB   Lock Bit Update for Congruence Class 45
with rel_bixu45_wayB_upd    select
    congr_cl45_wB_d(1)     <=   (congr_cl45_wB_q(1)    and not lock_finval) when "00",
                           (flush_wayB_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayB_data2_q(1)   and not lock_finval) when others;
-- WayB   Thread 0   Watch Bit Update for Congruence Class 45
with rel_bixu45_wayB_upd    select
    congr_cl45_wB_d(2)      <=   (congr_cl45_wB_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayB   Thread 1   Watch Bit Update for Congruence Class 45
with rel_bixu45_wayB_upd    select
    congr_cl45_wB_d(3)      <=   (congr_cl45_wB_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayB   Thread 2   Watch Bit Update for Congruence Class 45
with rel_bixu45_wayB_upd    select
    congr_cl45_wB_d(4)      <=   (congr_cl45_wB_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayB   Thread 3   Watch Bit Update for Congruence Class 45
with rel_bixu45_wayB_upd    select
    congr_cl45_wB_d(5)      <=   (congr_cl45_wB_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayB   Valid Bit Update for Congruence Class 46
with rel_bixu46_wayB_upd    select
    congr_cl46_wB_d(0)     <=   (congr_cl46_wB_q(0)    and not dci_inval_all_q) when "00",
                           (flush_wayB_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayB_data2_q(0)   and not dci_inval_all_q) when others;
-- WayB   Lock Bit Update for Congruence Class 46
with rel_bixu46_wayB_upd    select
    congr_cl46_wB_d(1)     <=   (congr_cl46_wB_q(1)    and not lock_finval) when "00",
                           (flush_wayB_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayB_data2_q(1)   and not lock_finval) when others;
-- WayB   Thread 0   Watch Bit Update for Congruence Class 46
with rel_bixu46_wayB_upd    select
    congr_cl46_wB_d(2)      <=   (congr_cl46_wB_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayB   Thread 1   Watch Bit Update for Congruence Class 46
with rel_bixu46_wayB_upd    select
    congr_cl46_wB_d(3)      <=   (congr_cl46_wB_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayB   Thread 2   Watch Bit Update for Congruence Class 46
with rel_bixu46_wayB_upd    select
    congr_cl46_wB_d(4)      <=   (congr_cl46_wB_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayB   Thread 3   Watch Bit Update for Congruence Class 46
with rel_bixu46_wayB_upd    select
    congr_cl46_wB_d(5)      <=   (congr_cl46_wB_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayB   Valid Bit Update for Congruence Class 47
with rel_bixu47_wayB_upd    select
    congr_cl47_wB_d(0)     <=   (congr_cl47_wB_q(0)    and not dci_inval_all_q) when "00",
                           (flush_wayB_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayB_data2_q(0)   and not dci_inval_all_q) when others;
-- WayB   Lock Bit Update for Congruence Class 47
with rel_bixu47_wayB_upd    select
    congr_cl47_wB_d(1)     <=   (congr_cl47_wB_q(1)    and not lock_finval) when "00",
                           (flush_wayB_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayB_data2_q(1)   and not lock_finval) when others;
-- WayB   Thread 0   Watch Bit Update for Congruence Class 47
with rel_bixu47_wayB_upd    select
    congr_cl47_wB_d(2)      <=   (congr_cl47_wB_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayB   Thread 1   Watch Bit Update for Congruence Class 47
with rel_bixu47_wayB_upd    select
    congr_cl47_wB_d(3)      <=   (congr_cl47_wB_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayB   Thread 2   Watch Bit Update for Congruence Class 47
with rel_bixu47_wayB_upd    select
    congr_cl47_wB_d(4)      <=   (congr_cl47_wB_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayB   Thread 3   Watch Bit Update for Congruence Class 47
with rel_bixu47_wayB_upd    select
    congr_cl47_wB_d(5)      <=   (congr_cl47_wB_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayB   Valid Bit Update for Congruence Class 48
with rel_bixu48_wayB_upd    select
    congr_cl48_wB_d(0)     <=   (congr_cl48_wB_q(0)    and not dci_inval_all_q) when "00",
                           (flush_wayB_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayB_data2_q(0)   and not dci_inval_all_q) when others;
-- WayB   Lock Bit Update for Congruence Class 48
with rel_bixu48_wayB_upd    select
    congr_cl48_wB_d(1)     <=   (congr_cl48_wB_q(1)    and not lock_finval) when "00",
                           (flush_wayB_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayB_data2_q(1)   and not lock_finval) when others;
-- WayB   Thread 0   Watch Bit Update for Congruence Class 48
with rel_bixu48_wayB_upd    select
    congr_cl48_wB_d(2)      <=   (congr_cl48_wB_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayB   Thread 1   Watch Bit Update for Congruence Class 48
with rel_bixu48_wayB_upd    select
    congr_cl48_wB_d(3)      <=   (congr_cl48_wB_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayB   Thread 2   Watch Bit Update for Congruence Class 48
with rel_bixu48_wayB_upd    select
    congr_cl48_wB_d(4)      <=   (congr_cl48_wB_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayB   Thread 3   Watch Bit Update for Congruence Class 48
with rel_bixu48_wayB_upd    select
    congr_cl48_wB_d(5)      <=   (congr_cl48_wB_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayB   Valid Bit Update for Congruence Class 49
with rel_bixu49_wayB_upd    select
    congr_cl49_wB_d(0)     <=   (congr_cl49_wB_q(0)    and not dci_inval_all_q) when "00",
                           (flush_wayB_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayB_data2_q(0)   and not dci_inval_all_q) when others;
-- WayB   Lock Bit Update for Congruence Class 49
with rel_bixu49_wayB_upd    select
    congr_cl49_wB_d(1)     <=   (congr_cl49_wB_q(1)    and not lock_finval) when "00",
                           (flush_wayB_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayB_data2_q(1)   and not lock_finval) when others;
-- WayB   Thread 0   Watch Bit Update for Congruence Class 49
with rel_bixu49_wayB_upd    select
    congr_cl49_wB_d(2)      <=   (congr_cl49_wB_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayB   Thread 1   Watch Bit Update for Congruence Class 49
with rel_bixu49_wayB_upd    select
    congr_cl49_wB_d(3)      <=   (congr_cl49_wB_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayB   Thread 2   Watch Bit Update for Congruence Class 49
with rel_bixu49_wayB_upd    select
    congr_cl49_wB_d(4)      <=   (congr_cl49_wB_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayB   Thread 3   Watch Bit Update for Congruence Class 49
with rel_bixu49_wayB_upd    select
    congr_cl49_wB_d(5)      <=   (congr_cl49_wB_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayB   Valid Bit Update for Congruence Class 50
with rel_bixu50_wayB_upd    select
    congr_cl50_wB_d(0)     <=   (congr_cl50_wB_q(0)    and not dci_inval_all_q) when "00",
                           (flush_wayB_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayB_data2_q(0)   and not dci_inval_all_q) when others;
-- WayB   Lock Bit Update for Congruence Class 50
with rel_bixu50_wayB_upd    select
    congr_cl50_wB_d(1)     <=   (congr_cl50_wB_q(1)    and not lock_finval) when "00",
                           (flush_wayB_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayB_data2_q(1)   and not lock_finval) when others;
-- WayB   Thread 0   Watch Bit Update for Congruence Class 50
with rel_bixu50_wayB_upd    select
    congr_cl50_wB_d(2)      <=   (congr_cl50_wB_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayB   Thread 1   Watch Bit Update for Congruence Class 50
with rel_bixu50_wayB_upd    select
    congr_cl50_wB_d(3)      <=   (congr_cl50_wB_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayB   Thread 2   Watch Bit Update for Congruence Class 50
with rel_bixu50_wayB_upd    select
    congr_cl50_wB_d(4)      <=   (congr_cl50_wB_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayB   Thread 3   Watch Bit Update for Congruence Class 50
with rel_bixu50_wayB_upd    select
    congr_cl50_wB_d(5)      <=   (congr_cl50_wB_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayB   Valid Bit Update for Congruence Class 51
with rel_bixu51_wayB_upd    select
    congr_cl51_wB_d(0)     <=   (congr_cl51_wB_q(0)    and not dci_inval_all_q) when "00",
                           (flush_wayB_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayB_data2_q(0)   and not dci_inval_all_q) when others;
-- WayB   Lock Bit Update for Congruence Class 51
with rel_bixu51_wayB_upd    select
    congr_cl51_wB_d(1)     <=   (congr_cl51_wB_q(1)    and not lock_finval) when "00",
                           (flush_wayB_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayB_data2_q(1)   and not lock_finval) when others;
-- WayB   Thread 0   Watch Bit Update for Congruence Class 51
with rel_bixu51_wayB_upd    select
    congr_cl51_wB_d(2)      <=   (congr_cl51_wB_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "00",
                               (flush_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when "01",
                              (reload_wayB_data2_q(2)     and not (dci_inval_all_q or ex6_watch_clr_all_q(0)))   when others;
-- WayB   Thread 1   Watch Bit Update for Congruence Class 51
with rel_bixu51_wayB_upd    select
    congr_cl51_wB_d(3)      <=   (congr_cl51_wB_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "00",
                               (flush_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when "01",
                              (reload_wayB_data2_q(3)     and not (dci_inval_all_q or ex6_watch_clr_all_q(1)))   when others;
-- WayB   Thread 2   Watch Bit Update for Congruence Class 51
with rel_bixu51_wayB_upd    select
    congr_cl51_wB_d(4)      <=   (congr_cl51_wB_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "00",
                               (flush_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when "01",
                              (reload_wayB_data2_q(4)     and not (dci_inval_all_q or ex6_watch_clr_all_q(2)))   when others;
-- WayB   Thread 3   Watch Bit Update for Congruence Class 51
with rel_bixu51_wayB_upd    select
    congr_cl51_wB_d(5)      <=   (congr_cl51_wB_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "00",
                               (flush_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when "01",
                              (reload_wayB_data2_q(5)     and not (dci_inval_all_q or ex6_watch_clr_all_q(3)))   when others;
-- WayB   Valid Bit Update for Congruence Class 52
with rel_bixu52_wayB_upd    select
    congr_cl52_wB_d(0)     <=   (congr_cl52_wB_q(0)    and not dci_inval_all_q) when "00",
                           (flush_wayB_data2_q(0)   and not dci_inval_all_q) when "01",
                          (reload_wayB_data2_q(0)   and not dci_inval_all_q) when others;
-- WayB   Lock Bit Update for Congruence Class 52
with rel_bixu52_wayB_upd    select
    congr_cl52_wB_d(1)     <=   (congr_cl52_wB_q(1)    and not lock_finval) when "00",
                           (flush_wayB_data2_q(1)   and not lock_finval) when "01",
                          (reload_wayB_data2_q(1)   and not lock_finval) when others;
