/* Mingw headers don't have latest language and sublanguage codes.  */
# ifndef LANG_AFRIKAANS
# define LANG_AFRIKAANS 0x36
# endif
# ifndef LANG_ALBANIAN
# define LANG_ALBANIAN 0x1c
# endif
# ifndef LANG_ARABIC
# define LANG_ARABIC 0x01
# endif
# ifndef LANG_ARMENIAN
# define LANG_ARMENIAN 0x2b
# endif
# ifndef LANG_ASSAMESE
# define LANG_ASSAMESE 0x4d
# endif
# ifndef LANG_AZERI
# define LANG_AZERI 0x2c
# endif
# ifndef LANG_BASQUE
# define LANG_BASQUE 0x2d
# endif
# ifndef LANG_BELARUSIAN
# define LANG_BELARUSIAN 0x23
# endif
# ifndef LANG_BENGALI
# define LANG_BENGALI 0x45
# endif
# ifndef LANG_CATALAN
# define LANG_CATALAN 0x03
# endif
# ifndef LANG_DIVEHI
# define LANG_DIVEHI 0x65
# endif
# ifndef LANG_ESTONIAN
# define LANG_ESTONIAN 0x25
# endif
# ifndef LANG_FAEROESE
# define LANG_FAEROESE 0x38
# endif
# ifndef LANG_FARSI
# define LANG_FARSI 0x29
# endif
# ifndef LANG_GALICIAN
# define LANG_GALICIAN 0x56
# endif
# ifndef LANG_GEORGIAN
# define LANG_GEORGIAN 0x37
# endif
# ifndef LANG_GUJARATI
# define LANG_GUJARATI 0x47
# endif
# ifndef LANG_HEBREW
# define LANG_HEBREW 0x0d
# endif
# ifndef LANG_HINDI
# define LANG_HINDI 0x39
# endif
# ifndef LANG_INDONESIAN
# define LANG_INDONESIAN 0x21
# endif
# ifndef LANG_KANNADA
# define LANG_KANNADA 0x4b
# endif
# ifndef LANG_KASHMIRI
# define LANG_KASHMIRI 0x60
# endif
# ifndef LANG_KAZAK
# define LANG_KAZAK 0x3f
# endif
# ifndef LANG_KONKANI
# define LANG_KONKANI 0x57
# endif
# ifndef LANG_KYRGYZ
# define LANG_KYRGYZ 0x40
# endif
# ifndef LANG_LATVIAN
# define LANG_LATVIAN 0x26
# endif
# ifndef LANG_LITHUANIAN
# define LANG_LITHUANIAN 0x27
# endif
# ifndef LANG_MACEDONIAN
# define LANG_MACEDONIAN 0x2f
# endif
# ifndef LANG_MALAY
# define LANG_MALAY 0x3e
# endif
# ifndef LANG_MALAYALAM
# define LANG_MALAYALAM 0x4c
# endif
# ifndef LANG_MANIPURI
# define LANG_MANIPURI 0x58
# endif
# ifndef LANG_MARATHI
# define LANG_MARATHI 0x4e
# endif
# ifndef LANG_MONGOLIAN
# define LANG_MONGOLIAN 0x50
# endif
# ifndef LANG_NEPALI
# define LANG_NEPALI 0x61
# endif
# ifndef LANG_ORIYA
# define LANG_ORIYA 0x48
# endif
# ifndef LANG_PUNJABI
# define LANG_PUNJABI 0x46
# endif
# ifndef LANG_SANSKRIT
# define LANG_SANSKRIT 0x4f
# endif
# ifndef LANG_SERBIAN
# define LANG_SERBIAN 0x1a
# endif
# ifndef LANG_SINDHI
# define LANG_SINDHI 0x59
# endif
# ifndef LANG_SLOVAK
# define LANG_SLOVAK 0x1b
# endif
# ifndef LANG_SORBIAN
# define LANG_SORBIAN 0x2e
# endif
# ifndef LANG_SWAHILI
# define LANG_SWAHILI 0x41
# endif
# ifndef LANG_SYRIAC
# define LANG_SYRIAC 0x5a
# endif
# ifndef LANG_TAMIL
# define LANG_TAMIL 0x49
# endif
# ifndef LANG_TATAR
# define LANG_TATAR 0x44
# endif
# ifndef LANG_TELUGU
# define LANG_TELUGU 0x4a
# endif
# ifndef LANG_THAI
# define LANG_THAI 0x1e
# endif
# ifndef LANG_UKRAINIAN
# define LANG_UKRAINIAN 0x22
# endif
# ifndef LANG_URDU
# define LANG_URDU 0x20
# endif
# ifndef LANG_UZBEK
# define LANG_UZBEK 0x43
# endif
# ifndef LANG_VIETNAMESE
# define LANG_VIETNAMESE 0x2a
# endif
# ifndef SUBLANG_ARABIC_SAUDI_ARABIA
# define SUBLANG_ARABIC_SAUDI_ARABIA 0x01
# endif
# ifndef SUBLANG_ARABIC_IRAQ
# define SUBLANG_ARABIC_IRAQ 0x02
# endif
# ifndef SUBLANG_ARABIC_EGYPT
# define SUBLANG_ARABIC_EGYPT 0x03
# endif
# ifndef SUBLANG_ARABIC_LIBYA
# define SUBLANG_ARABIC_LIBYA 0x04
# endif
# ifndef SUBLANG_ARABIC_ALGERIA
# define SUBLANG_ARABIC_ALGERIA 0x05
# endif
# ifndef SUBLANG_ARABIC_MOROCCO
# define SUBLANG_ARABIC_MOROCCO 0x06
# endif
# ifndef SUBLANG_ARABIC_TUNISIA
# define SUBLANG_ARABIC_TUNISIA 0x07
# endif
# ifndef SUBLANG_ARABIC_OMAN
# define SUBLANG_ARABIC_OMAN 0x08
# endif
# ifndef SUBLANG_ARABIC_YEMEN
# define SUBLANG_ARABIC_YEMEN 0x09
# endif
# ifndef SUBLANG_ARABIC_SYRIA
# define SUBLANG_ARABIC_SYRIA 0x0a
# endif
# ifndef SUBLANG_ARABIC_JORDAN
# define SUBLANG_ARABIC_JORDAN 0x0b
# endif
# ifndef SUBLANG_ARABIC_LEBANON
# define SUBLANG_ARABIC_LEBANON 0x0c
# endif
# ifndef SUBLANG_ARABIC_KUWAIT
# define SUBLANG_ARABIC_KUWAIT 0x0d
# endif
# ifndef SUBLANG_ARABIC_UAE
# define SUBLANG_ARABIC_UAE 0x0e
# endif
# ifndef SUBLANG_ARABIC_BAHRAIN
# define SUBLANG_ARABIC_BAHRAIN 0x0f
# endif
# ifndef SUBLANG_ARABIC_QATAR
# define SUBLANG_ARABIC_QATAR 0x10
# endif
# ifndef SUBLANG_AZERI_LATIN
# define SUBLANG_AZERI_LATIN 0x01
# endif
# ifndef SUBLANG_AZERI_CYRILLIC
# define SUBLANG_AZERI_CYRILLIC 0x02
# endif
# ifndef SUBLANG_CHINESE_MACAU
# define SUBLANG_CHINESE_MACAU 0x05
# endif
# ifndef SUBLANG_ENGLISH_SOUTH_AFRICA
# define SUBLANG_ENGLISH_SOUTH_AFRICA 0x07
# endif
# ifndef SUBLANG_ENGLISH_JAMAICA
# define SUBLANG_ENGLISH_JAMAICA 0x08
# endif
# ifndef SUBLANG_ENGLISH_CARIBBEAN
# define SUBLANG_ENGLISH_CARIBBEAN 0x09
# endif
# ifndef SUBLANG_ENGLISH_BELIZE
# define SUBLANG_ENGLISH_BELIZE 0x0a
# endif
# ifndef SUBLANG_ENGLISH_TRINIDAD
# define SUBLANG_ENGLISH_TRINIDAD 0x0b
# endif
# ifndef SUBLANG_ENGLISH_ZIMBABWE
# define SUBLANG_ENGLISH_ZIMBABWE 0x0c
# endif
# ifndef SUBLANG_ENGLISH_PHILIPPINES
# define SUBLANG_ENGLISH_PHILIPPINES 0x0d
# endif
# ifndef SUBLANG_FRENCH_LUXEMBOURG
# define SUBLANG_FRENCH_LUXEMBOURG 0x05
# endif
# ifndef SUBLANG_FRENCH_MONACO
# define SUBLANG_FRENCH_MONACO 0x06
# endif
# ifndef SUBLANG_GERMAN_LUXEMBOURG
# define SUBLANG_GERMAN_LUXEMBOURG 0x04
# endif
# ifndef SUBLANG_GERMAN_LIECHTENSTEIN
# define SUBLANG_GERMAN_LIECHTENSTEIN 0x05
# endif
# ifndef SUBLANG_KASHMIRI_INDIA
# define SUBLANG_KASHMIRI_INDIA 0x02
# endif
# ifndef SUBLANG_MALAY_MALAYSIA
# define SUBLANG_MALAY_MALAYSIA 0x01
# endif
# ifndef SUBLANG_MALAY_BRUNEI_DARUSSALAM
# define SUBLANG_MALAY_BRUNEI_DARUSSALAM 0x02
# endif
# ifndef SUBLANG_NEPALI_INDIA
# define SUBLANG_NEPALI_INDIA 0x02
# endif
# ifndef SUBLANG_SERBIAN_LATIN
# define SUBLANG_SERBIAN_LATIN 0x02
# endif
# ifndef SUBLANG_SERBIAN_CYRILLIC
# define SUBLANG_SERBIAN_CYRILLIC 0x03
# endif
# ifndef SUBLANG_SPANISH_GUATEMALA
# define SUBLANG_SPANISH_GUATEMALA 0x04
# endif
# ifndef SUBLANG_SPANISH_COSTA_RICA
# define SUBLANG_SPANISH_COSTA_RICA 0x05
# endif
# ifndef SUBLANG_SPANISH_PANAMA
# define SUBLANG_SPANISH_PANAMA 0x06
# endif
# ifndef SUBLANG_SPANISH_DOMINICAN_REPUBLIC
# define SUBLANG_SPANISH_DOMINICAN_REPUBLIC 0x07
# endif
# ifndef SUBLANG_SPANISH_VENEZUELA
# define SUBLANG_SPANISH_VENEZUELA 0x08
# endif
# ifndef SUBLANG_SPANISH_COLOMBIA
# define SUBLANG_SPANISH_COLOMBIA 0x09
# endif
# ifndef SUBLANG_SPANISH_PERU
# define SUBLANG_SPANISH_PERU 0x0a
# endif
# ifndef SUBLANG_SPANISH_ARGENTINA
# define SUBLANG_SPANISH_ARGENTINA 0x0b
# endif
# ifndef SUBLANG_SPANISH_ECUADOR
# define SUBLANG_SPANISH_ECUADOR 0x0c
# endif
# ifndef SUBLANG_SPANISH_CHILE
# define SUBLANG_SPANISH_CHILE 0x0d
# endif
# ifndef SUBLANG_SPANISH_URUGUAY
# define SUBLANG_SPANISH_URUGUAY 0x0e
# endif
# ifndef SUBLANG_SPANISH_PARAGUAY
# define SUBLANG_SPANISH_PARAGUAY 0x0f
# endif
# ifndef SUBLANG_SPANISH_BOLIVIA
# define SUBLANG_SPANISH_BOLIVIA 0x10
# endif
# ifndef SUBLANG_SPANISH_EL_SALVADOR
# define SUBLANG_SPANISH_EL_SALVADOR 0x11
# endif
# ifndef SUBLANG_SPANISH_HONDURAS
# define SUBLANG_SPANISH_HONDURAS 0x12
# endif
# ifndef SUBLANG_SPANISH_NICARAGUA
# define SUBLANG_SPANISH_NICARAGUA 0x13
# endif
# ifndef SUBLANG_SPANISH_PUERTO_RICO
# define SUBLANG_SPANISH_PUERTO_RICO 0x14
# endif
# ifndef SUBLANG_SWEDISH_FINLAND
# define SUBLANG_SWEDISH_FINLAND 0x02
# endif
# ifndef SUBLANG_URDU_PAKISTAN
# define SUBLANG_URDU_PAKISTAN 0x01
# endif
# ifndef SUBLANG_URDU_INDIA
# define SUBLANG_URDU_INDIA 0x02
# endif
# ifndef SUBLANG_UZBEK_LATIN
# define SUBLANG_UZBEK_LATIN 0x01
# endif
# ifndef SUBLANG_UZBEK_CYRILLIC
# define SUBLANG_UZBEK_CYRILLIC 0x02
# endif

static char *
getLanguageName ()
{
	LCID lcid;
	LANGID langid;
	int primary, sub;

	/* Use native Win32 API locale ID.  */
	lcid = GetThreadLocale ();

	/* Strip off the sorting rules, keep only the language part.  */
	langid = LANGIDFROMLCID (lcid);

	/* Split into language and territory part.  */
	primary = PRIMARYLANGID (langid);
	sub = SUBLANGID (langid);

	/* Dispatch on language.
	   See also http://www.unicode.org/unicode/onlinedat/languages.html .
	   For details about languages, see http://www.ethnologue.com/ .  */
	switch (primary) {
	case LANG_AFRIKAANS: return (char *)"af_ZA";
	case LANG_ALBANIAN: return (char *)"sq_AL";
	case 0x5e: /* AMHARIC */ return (char *)"am_ET";
	case LANG_ARABIC:
		switch (sub) {
		case SUBLANG_ARABIC_SAUDI_ARABIA: return (char *)"ar_SA";
		case SUBLANG_ARABIC_IRAQ: return (char *)"ar_IQ";
		case SUBLANG_ARABIC_EGYPT: return (char *)"ar_EG";
		case SUBLANG_ARABIC_LIBYA: return (char *)"ar_LY";
		case SUBLANG_ARABIC_ALGERIA: return (char *)"ar_DZ";
		case SUBLANG_ARABIC_MOROCCO: return (char *)"ar_MA";
		case SUBLANG_ARABIC_TUNISIA: return (char *)"ar_TN";
		case SUBLANG_ARABIC_OMAN: return (char *)"ar_OM";
		case SUBLANG_ARABIC_YEMEN: return (char *)"ar_YE";
		case SUBLANG_ARABIC_SYRIA: return (char *)"ar_SY";
		case SUBLANG_ARABIC_JORDAN: return (char *)"ar_JO";
		case SUBLANG_ARABIC_LEBANON: return (char *)"ar_LB";
		case SUBLANG_ARABIC_KUWAIT: return (char *)"ar_KW";
		case SUBLANG_ARABIC_UAE: return (char *)"ar_AE";
		case SUBLANG_ARABIC_BAHRAIN: return (char *)"ar_BH";
		case SUBLANG_ARABIC_QATAR: return (char *)"ar_QA";
		default: return (char *)"ar";
		}
	case LANG_ARMENIAN: return (char *)"hy_AM";
	case LANG_ASSAMESE: return (char *)"as_IN";
	case LANG_AZERI:
		switch (sub) {
		/* FIXME: Adjust this when Azerbaijani locales appear on Unix.  */
		case SUBLANG_AZERI_LATIN: return (char *)"az_AZ@latin";
		case SUBLANG_AZERI_CYRILLIC: return (char *)"az_AZ@cyrillic";
		default: return (char *)"az";
		}
	case LANG_BASQUE: return (char *)"eu"; /* Ambiguous: could be "eu_ES" or "eu_FR".  */
	case LANG_BELARUSIAN: return (char *)"be_BY";
	case LANG_BENGALI: return (char *)"bn_IN";
	case LANG_BULGARIAN: return (char *)"bg_BG";
	case 0x55: /* BURMESE */ return (char *)"my_MM";
	case 0x53: /* CAMBODIAN */ return (char *)"km_KH";
	case LANG_CATALAN: return (char *)"ca_ES";
	case 0x5c: /* CHEROKEE */ return (char *)"chr_US";
	case LANG_CHINESE:
		switch (sub) {
		case SUBLANG_CHINESE_TRADITIONAL: return (char *)"zh_TW";
		case SUBLANG_CHINESE_SIMPLIFIED: return (char *)"zh_CN";
		case SUBLANG_CHINESE_HONGKONG: return (char *)"zh_HK";
		case SUBLANG_CHINESE_SINGAPORE: return (char *)"zh_SG";
		case SUBLANG_CHINESE_MACAU: return (char *)"zh_MO";
		default: return (char *)"zh";
		}
	case LANG_CROATIAN:	/* LANG_CROATIAN == LANG_SERBIAN
				 * What used to be called Serbo-Croatian
				 * should really now be two separate
				 * languages because of political reasons.
				 * (Says tml, who knows nothing about Serbian
				 * or Croatian.)
				 * (I can feel those flames coming already.)
				 */
		switch (sub) {
		case SUBLANG_DEFAULT: return (char *)"hr_HR";
		case SUBLANG_SERBIAN_LATIN: return (char *)"sr_YU";
		case SUBLANG_SERBIAN_CYRILLIC: return (char *)"sr_YU@cyrillic";
		default: return (char *)"hr";
		}
	case LANG_CZECH: return (char *)"cs_CZ";
	case LANG_DANISH: return (char *)"da_DK";
	case LANG_DIVEHI: return (char *)"div_MV";
	case LANG_DUTCH:
		switch (sub) {
		case SUBLANG_DUTCH: return (char *)"nl_NL";
		case SUBLANG_DUTCH_BELGIAN: /* FLEMISH, VLAAMS */ return (char *)"nl_BE";
		default: return (char *)"nl";
		}
	case 0x66: /* EDO */ return (char *)"bin_NG";
	case LANG_ENGLISH:
		switch (sub) {
		/* SUBLANG_ENGLISH_US == SUBLANG_DEFAULT. Heh. I thought
		 * English was the language spoken in England.
		 * Oh well.
		 */
		case SUBLANG_ENGLISH_US: return (char *)"en_US";
		case SUBLANG_ENGLISH_UK: return (char *)"en_GB";
		case SUBLANG_ENGLISH_AUS: return (char *)"en_AU";
		case SUBLANG_ENGLISH_CAN: return (char *)"en_CA";
		case SUBLANG_ENGLISH_NZ: return (char *)"en_NZ";
		case SUBLANG_ENGLISH_EIRE: return (char *)"en_IE";
		case SUBLANG_ENGLISH_SOUTH_AFRICA: return (char *)"en_ZA";
		case SUBLANG_ENGLISH_JAMAICA: return (char *)"en_JM";
		case SUBLANG_ENGLISH_CARIBBEAN: return (char *)"en_GD"; /* Grenada? */
		case SUBLANG_ENGLISH_BELIZE: return (char *)"en_BZ";
		case SUBLANG_ENGLISH_TRINIDAD: return (char *)"en_TT";
		case SUBLANG_ENGLISH_ZIMBABWE: return (char *)"en_ZW";
		case SUBLANG_ENGLISH_PHILIPPINES: return (char *)"en_PH";
		default: return (char *)"en";
		}
	case LANG_ESTONIAN: return (char *)"et_EE";
	case LANG_FAEROESE: return (char *)"fo_FO";
	case LANG_FARSI: return (char *)"fa_IR";
	case LANG_FINNISH: return (char *)"fi_FI";
	case LANG_FRENCH:
	    switch (sub) {
		case SUBLANG_FRENCH: return (char *)"fr_FR";
		case SUBLANG_FRENCH_BELGIAN: /* WALLOON */ return (char *)"fr_BE";
		case SUBLANG_FRENCH_CANADIAN: return (char *)"fr_CA";
		case SUBLANG_FRENCH_SWISS: return (char *)"fr_CH";
		case SUBLANG_FRENCH_LUXEMBOURG: return (char *)"fr_LU";
		case SUBLANG_FRENCH_MONACO: return (char *)"fr_MC";
		default: return (char *)"fr";
		}
	case 0x62: /* FRISIAN */ return (char *)"fy_NL";
	case 0x67: /* FULFULDE */ return (char *)"ful_NG";
	case 0x3c: /* GAELIC */
		switch (sub) {
		case 0x01: /* SCOTTISH */ return (char *)"gd_GB";
		case 0x02: /* IRISH */ return (char *)"ga_IE";
		default: return (char *)"C";
		}
	case LANG_GALICIAN: return (char *)"gl_ES";
	case LANG_GEORGIAN: return (char *)"ka_GE";
	case LANG_GERMAN:
		switch (sub) {
		case SUBLANG_GERMAN: return (char *)"de_DE";
		case SUBLANG_GERMAN_SWISS: return (char *)"de_CH";
		case SUBLANG_GERMAN_AUSTRIAN: return (char *)"de_AT";
		case SUBLANG_GERMAN_LUXEMBOURG: return (char *)"de_LU";
		case SUBLANG_GERMAN_LIECHTENSTEIN: return (char *)"de_LI";
		default: return (char *)"de";
		}
	case LANG_GREEK: return (char *)"el_GR";
	case 0x74: /* GUARANI */ return (char *)"gn_PY";
	case LANG_GUJARATI: return (char *)"gu_IN";
	case 0x68: /* HAUSA */ return (char *)"ha_NG";
	case 0x75: /* HAWAIIAN */
		/* FIXME: Do they mean Hawaiian ("haw_US", 1000 speakers)
		   or Hawaii Creole English ("cpe_US", 600000 speakers)?  */
		return (char *)"cpe_US";
	case LANG_HEBREW: return (char *)"he_IL";
	case LANG_HINDI: return (char *)"hi_IN";
	case LANG_HUNGARIAN: return (char *)"hu_HU";
	case 0x69: /* IBIBIO */ return (char *)"nic_NG";
	case LANG_ICELANDIC: return (char *)"is_IS";
	case 0x70: /* IGBO */ return (char *)"ibo_NG";
	case LANG_INDONESIAN: return (char *)"id_ID";
	case 0x5d: /* INUKTITUT */ return (char *)"iu_CA";
	case LANG_ITALIAN:
		switch (sub) {
		case SUBLANG_ITALIAN: return (char *)"it_IT";
		case SUBLANG_ITALIAN_SWISS: return (char *)"it_CH";
		default: return (char *)"it";
		}
	case LANG_JAPANESE: return (char *)"ja_JP";
	case LANG_KANNADA: return (char *)"kn_IN";
	case 0x71: /* KANURI */ return (char *)"kau_NG";
	case LANG_KASHMIRI:
		switch (sub) {
		case SUBLANG_DEFAULT: return (char *)"ks_PK";
		case SUBLANG_KASHMIRI_INDIA: return (char *)"ks_IN";
		default: return (char *)"ks";
		}
	case LANG_KAZAK: return (char *)"kk_KZ";
	case LANG_KONKANI:
		/* FIXME: Adjust this when such locales appear on Unix.  */
		return (char *)"kok_IN";
	case LANG_KOREAN: return (char *)"ko_KR";
	case LANG_KYRGYZ: return (char *)"ky_KG";
	case 0x54: /* LAO */ return (char *)"lo_LA";
	case 0x76: /* LATIN */ return (char *)"la_VA";
	case LANG_LATVIAN: return (char *)"lv_LV";
	case LANG_LITHUANIAN: return (char *)"lt_LT";
	case LANG_MACEDONIAN: return (char *)"mk_MK";
	case LANG_MALAY:
		switch (sub) {
		case SUBLANG_MALAY_MALAYSIA: return (char *)"ms_MY";
		case SUBLANG_MALAY_BRUNEI_DARUSSALAM: return (char *)"ms_BN";
		default: return (char *)"ms";
		}
	case LANG_MALAYALAM: return (char *)"ml_IN";
	case 0x3a: /* MALTESE */ return (char *)"mt_MT";
	case LANG_MANIPURI:
		/* FIXME: Adjust this when such locales appear on Unix.  */
		return (char *)"mni_IN";
	case LANG_MARATHI: return (char *)"mr_IN";
	case LANG_MONGOLIAN:
		return (char *)"mn"; /* Ambiguous: could be "mn_CN" or "mn_MN".  */
	case LANG_NEPALI:
		switch (sub) {
		case SUBLANG_DEFAULT: return (char *)"ne_NP";
		case SUBLANG_NEPALI_INDIA: return (char *)"ne_IN";
		default: return (char *)"ne";
		}
	case LANG_NORWEGIAN:
		switch (sub) {
		case SUBLANG_NORWEGIAN_BOKMAL: return (char *)"no_NO";
		case SUBLANG_NORWEGIAN_NYNORSK: return (char *)"nn_NO";
		default: return (char *)"no";
		}
	case LANG_ORIYA: return (char *)"or_IN";
	case 0x72: /* OROMO */ return (char *)"om_ET";
	case 0x79: /* PAPIAMENTU */ return (char *)"pap_AN";
	case 0x63: /* PASHTO */
		return (char *)"ps"; /* Ambiguous: could be "ps_PK" or "ps_AF".  */
	case LANG_POLISH: return (char *)"pl_PL";
	case LANG_PORTUGUESE:
		switch (sub) {
		case SUBLANG_PORTUGUESE: return (char *)"(char *)pt_PT";
		/* Hmm. SUBLANG_PORTUGUESE_BRAZILIAN == SUBLANG_DEFAULT.
		   Same phenomenon as SUBLANG_ENGLISH_US == SUBLANG_DEFAULT. */
		case SUBLANG_PORTUGUESE_BRAZILIAN: return (char *)"pt_BR";
		default: return (char *)"pt";
		}
	case LANG_PUNJABI: return (char *)"pa_IN";
	case 0x17: /* RHAETO-ROMANCE */ return (char *)"rm_CH";
	case LANG_ROMANIAN: return (char *)"ro_RO";
	case LANG_RUSSIAN:
		return (char *)"ru"; /* Ambiguous: could be "ru_RU" or "ru_UA".  */
	case 0x3b: /* SAMI */ return (char *)"se_NO";
	case LANG_SANSKRIT: return (char *)"sa_IN";
	case LANG_SINDHI: return (char *)"sd";
	case 0x5b: /* SINHALESE */ return (char *)"si_LK";
	case LANG_SLOVAK: return (char *)"sk_SK";
	case LANG_SLOVENIAN: return (char *)"sl_SI";
	case 0x77: /* SOMALI */ return (char *)"so_SO";
	case LANG_SORBIAN:
		/* FIXME: Adjust this when such locales appear on Unix.  */
		return (char *)"wen_DE";
	case LANG_SPANISH:
		switch (sub) {
		case SUBLANG_SPANISH: return (char *)"es_ES";
		case SUBLANG_SPANISH_MEXICAN: return (char *)"es_MX";
		case SUBLANG_SPANISH_MODERN:
			return (char *)"es_ES@modern";	/* not seen on Unix */
		case SUBLANG_SPANISH_GUATEMALA: return (char *)"es_GT";
		case SUBLANG_SPANISH_COSTA_RICA: return (char *)"es_CR";
		case SUBLANG_SPANISH_PANAMA: return (char *)"es_PA";
		case SUBLANG_SPANISH_DOMINICAN_REPUBLIC: return (char *)"es_DO";
		case SUBLANG_SPANISH_VENEZUELA: return (char *)"es_VE";
		case SUBLANG_SPANISH_COLOMBIA: return (char *)"es_CO";
		case SUBLANG_SPANISH_PERU: return (char *)"es_PE";
		case SUBLANG_SPANISH_ARGENTINA: return (char *)"es_AR";
		case SUBLANG_SPANISH_ECUADOR: return (char *)"es_EC";
		case SUBLANG_SPANISH_CHILE: return (char *)"es_CL";
		case SUBLANG_SPANISH_URUGUAY: return (char *)"es_UY";
		case SUBLANG_SPANISH_PARAGUAY: return (char *)"es_PY";
		case SUBLANG_SPANISH_BOLIVIA: return (char *)"es_BO";
		case SUBLANG_SPANISH_EL_SALVADOR: return (char *)"es_SV";
		case SUBLANG_SPANISH_HONDURAS: return (char *)"es_HN";
		case SUBLANG_SPANISH_NICARAGUA: return (char *)"es_NI";
		case SUBLANG_SPANISH_PUERTO_RICO: return (char *)"es_PR";
		default: return (char *)"es";
		}
	case 0x30: /* SUTU */ return (char *)"bnt_TZ";
	case LANG_SWAHILI: return (char *)"sw_KE";
	case LANG_SWEDISH:
		switch (sub) {
		case SUBLANG_DEFAULT: return (char *)"sv_SE";
		case SUBLANG_SWEDISH_FINLAND: return (char *)"sv_FI";
		default: return (char *)"sv";
		}
	case LANG_SYRIAC: return (char *)"syr_TR"; /* An extinct language.  */
	case 0x64: /* TAGALOG */ return (char *)"tl_PH";
	case 0x28: /* TAJIK */ return (char *)"tg_TJ";
	case 0x5f: /* TAMAZIGHT */ return (char *)"ber_MA";
	case LANG_TAMIL:
		return (char *)"ta"; /* Ambiguous: could be "ta_IN" or "ta_LK" or "ta_SG".  */
	case LANG_TATAR: return (char *)"tt_RU";
	case LANG_TELUGU: return (char *)"te_IN";
	case LANG_THAI: return (char *)"th_TH";
	case 0x51: /* TIBETAN */ return (char *)"bo_CN";
	case 0x73: /* TIGRINYA */ return (char *)"ti_ET";
	case 0x31: /* TSONGA */ return (char *)"ts_ZA";
	case LANG_TURKISH: return (char *)"tr_TR";
	case 0x42: /* TURKMEN */ return (char *)"tk_TM";
	case LANG_UKRAINIAN: return (char *)"uk_UA";
	case LANG_URDU:
		switch (sub) {
		case SUBLANG_URDU_PAKISTAN: return (char *)"ur_PK";
		case SUBLANG_URDU_INDIA: return (char *)"ur_IN";
		default: return (char *)"ur";
		}
	case LANG_UZBEK:
		switch (sub) {
		/* FIXME: Adjust this when Uzbek locales appear on Unix.  */
		case SUBLANG_UZBEK_LATIN: return (char *)"uz_UZ@latin";
		case SUBLANG_UZBEK_CYRILLIC: return (char *)"uz_UZ@cyrillic";
		default: return (char *)"uz";
		}
	case 0x33: /* VENDA */ return (char *)"ven_ZA";
	case LANG_VIETNAMESE: return (char *)"vi_VN";
	case 0x52: /* WELSH */ return (char *)"cy_GB";
	case 0x34: /* XHOSA */ return (char *)"xh_ZA";
	case 0x78: /* YI */ return (char *)"sit_CN";
	case 0x3d: /* YIDDISH */ return (char *)"yi_IL";
	case 0x6a: /* YORUBA */ return (char *)"yo_NG";
	case 0x35: /* ZULU */ return (char *)"zu_ZA";
	default: return (char *)"C";
	}
}
