#########################################################################
#  OpenKore - Packet sending
#  This module contains functions for sending packets to the server.
#
#  This software is open source, licensed under the GNU General Public
#  License, version 2.
#  Basically, this means that you're allowed to modify and distribute
#  this software. However, if you distribute modified versions, you MUST
#  also distribute the source code.
#  See http://www.gnu.org/licenses/gpl.html for the full license.
#
#  $Revision: 6687 $
#  $Id: kRO.pm 6687 2009-04-19 19:04:25Z technologyguild $
########################################################################
# Korea (kRO)
# The majority of private servers use eAthena, this is a clone of kRO

package Network::Send::kRO::Sakexe_2004_10_05a;

use strict;
use base qw(Network::Send::kRO::Sakexe_2004_09_20a);

sub version {
	return 12;
}

sub new {
	my ($class) = @_;
	my $self = $class->SUPER::new(@_);
	
	my %packets = (
		'0072' => ['item_use', 'x4 a2 x5 a4', [qw(ID targetID)]],#17
		'007E' => ['storage_item_add', 'x3 a2 x5 V', [qw(ID amount)]],
		'0089' => ['character_move', 'x1 a3', [qw(coords)]],
		'008C' => ['skill_use_location_text', 'v2 x2 v x9 v x2 v Z80', [qw(lvl ID x y info)]],
		'0094' => ['item_drop', 'x3 a2 x5 v', [qw(ID amount)]],
		'009B' => ['actor_info_request', 'x9 a4', [qw(ID)]],
		'00A2' => ['actor_name_request', 'x6 a4', [qw(ID)]],
		'00A7' => ['skill_use_location', 'x v x v x9 v x2 v', [qw(lv skillID x y)]],
		'00F3' => ['actor_look_at', 'x3 C x6 C', [qw(head body)]],
		'00F5' => ['map_login', 'x10 a4 x2 a4 x2 a4 V C', [qw(accountID charID sessionID tick sex)]],
		'0113' => ['item_take', 'x4 a4', [qw(ID)]],
		'0116' => ['sync', 'x4 V', [qw(time)]],
		'0190' => ['skill_use', 'x5 V x v x2 a4', [qw(lv skillID targetID)]],#20
		'0193' => ['storage_item_remove', 'x8 a2 x10 V', [qw(ID amount)]],
	);
	
	$self->{packet_list}{$_} = $packets{$_} for keys %packets;
	
	my %handlers = qw(
		skill_use_location_text 008C
	);
	
	$self->{packet_lut}{$_} = $handlers{$_} for keys %handlers;
	
	return $self;
}

1;

=pod
//2004-10-05aSakexe
packet_ver: 12
0x0072,17,useitem,6:13
0x007e,16,movetokafra,5:12
0x0089,6,walktoxy,3
0x008c,103,useskilltoposinfo,2:6:17:21:23
0x0094,14,dropitem,5:12
0x009b,15,getcharnamerequest,11
0x00a2,12,solvecharname,8
0x00a7,23,useskilltopos,3:6:17:21
0x00f3,13,changedir,5:12
0x00f5,33,wanttoconnection,12:18:24:28:32
0x0113,10,takeitem,6
0x0116,10,ticksend,6
0x0190,20,useskilltoid,7:12:16
0x0193,26,movefromkafra,10:22
=cut