package AI::Slave::Homunculus;

use strict;
use Time::HiRes qw(time);
use base qw/AI::Slave/;
use Globals;
use Log qw/message warning error debug/;
use Utils;
use Misc;
use Translation;

sub checkSkillOwnership { $_[1]->getOwnerType == Skill::OWNER_HOMUN }

sub iterate {
	my $slave = shift;

	# homunculus is in rest
	if ($slave->{vaporized}) {
		#message TF("Slave %s vaporized\n", $slave), 'slave';

	# homunculus is dead / not present
	} elsif ($slave->{dead}) {
		#message TF("Slave %s dead\n", $slave), 'slave';

	# homunculus is alive
	} elsif ($slave->{appear_time} && $field->baseName eq $slave->{map}) {
		# auto-feed homunculus
		# We don't need random and feeding limit. They don't prevent from banning or being suspicious.
		$config{homunculus_hunger} = 15 if (!$config{homunculus_hunger} || $config{homunculus_return} > $config{homunculus_hunger}); #Fix value instead of random
		$config{homunculus_return} = 11 if (!$config{homunculus_return} || $config{homunculus_hunger} < $config{homunculus_return}); #Fix value instead of random
		$timeout{ai_homunFeed}{timeout} = 60 if (!$timeout{ai_homunFeed}{timeout}); #Timeout value : Default 60sec

		if (timeOut($timeout{ai_homunFeed})
			&& $slave->{hunger} <= $config{homunculus_hunger}
			&& $config{homunculus_autoFeed}
			&& (existsInList($config{homunculus_autoFeedAllowedMaps}, $field->baseName) || !$config{homunculus_autoFeedAllowedMaps})) {
			$timeout{ai_homunFeed}{time} = time;
			message TF("Auto-feeding %s (%d hunger).\n", $slave, $slave->{hunger}), 'slave';
			$messageSender->sendHomunculusCommand(1);

		} elsif (timeOut($timeout{ai_homunFeed}) && $slave->{hunger} <= $config{homunculus_return}) {
			message TF("Homunculus hunger reaches the return value.\n", 'slave');
			my $skill = new Skill(handle => 'AM_REST');
			AI::ai_skillUse2($skill, $char->{skills}{AM_REST}{lv}, 1, 0, $char, "AM_REST");
			$timeout{ai_homunFeed}{time} = time; #timeout trick

		} else {
			$slave->SUPER::iterate;
		}
	}
}

1;
