// Package docs Code generated by swaggo/swag. DO NOT EDIT
package docs

import "github.com/swaggo/swag"

const docTemplate = `{
    "schemes": {{ marshal .Schemes }},
    "swagger": "2.0",
    "info": {
        "description": "{{escape .Description}}",
        "title": "{{.Title}}",
        "contact": {},
        "version": "{{.Version}}"
    },
    "host": "{{.Host}}",
    "basePath": "{{.BasePath}}",
    "paths": {
        "/accounting/metering/{id}/statements": {
            "get": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "List meterings by user uuid and start time and end time",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Accounting"
                ],
                "summary": "List meterings by user uuid and start time and end time",
                "parameters": [
                    {
                        "type": "string",
                        "description": "user uuid",
                        "name": "id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "enum": [
                            10,
                            11,
                            12,
                            20
                        ],
                        "type": "integer",
                        "default": 10,
                        "description": "scene",
                        "name": "scene",
                        "in": "query"
                    },
                    {
                        "type": "string",
                        "description": "instance name",
                        "name": "instance_name",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "start_time, format: '2024-06-12 08:27:22'",
                        "name": "start_time",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "end_time, format: '2024-06-12 17:17:22'",
                        "name": "end_time",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "current_user",
                        "name": "current_user",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "default": 20,
                        "description": "per",
                        "name": "per",
                        "in": "query"
                    },
                    {
                        "type": "integer",
                        "default": 1,
                        "description": "per page",
                        "name": "page",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.Response"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/cluster": {
            "get": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "Get cluster list",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Cluster"
                ],
                "summary": "Get cluster list",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.Response"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/cluster/{id}": {
            "get": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "Get cluster by id",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Cluster"
                ],
                "summary": "Get cluster by id",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.Response"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/codes": {
            "get": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "get visiable codes for current user",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Code"
                ],
                "summary": "Get Visiable codes for current user",
                "parameters": [
                    {
                        "type": "string",
                        "description": "current user",
                        "name": "current_user",
                        "in": "query"
                    },
                    {
                        "type": "string",
                        "description": "search text",
                        "name": "search",
                        "in": "query"
                    },
                    {
                        "type": "string",
                        "description": "filter by task tag",
                        "name": "task_tag",
                        "in": "query"
                    },
                    {
                        "type": "string",
                        "description": "filter by framework tag",
                        "name": "framework_tag",
                        "in": "query"
                    },
                    {
                        "type": "string",
                        "description": "filter by license tag",
                        "name": "license_tag",
                        "in": "query"
                    },
                    {
                        "type": "string",
                        "description": "filter by language tag",
                        "name": "language_tag",
                        "in": "query"
                    },
                    {
                        "type": "string",
                        "description": "sort by",
                        "name": "sort",
                        "in": "query"
                    },
                    {
                        "enum": [
                            "opencsg",
                            "huggingface",
                            "local"
                        ],
                        "type": "string",
                        "description": "source",
                        "name": "source",
                        "in": "query"
                    },
                    {
                        "type": "integer",
                        "default": 20,
                        "description": "per",
                        "name": "per",
                        "in": "query"
                    },
                    {
                        "type": "integer",
                        "default": 1,
                        "description": "per page",
                        "name": "page",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.ResponseWithTotal"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "type": "array",
                                            "items": {
                                                "$ref": "#/definitions/types.Code"
                                            }
                                        },
                                        "total": {
                                            "type": "integer"
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            },
            "post": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "create a new code",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Code"
                ],
                "summary": "Create a new code",
                "parameters": [
                    {
                        "type": "string",
                        "description": "current user, the owner",
                        "name": "current_user",
                        "in": "query"
                    },
                    {
                        "description": "body",
                        "name": "body",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/types.CreateCodeReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.Response"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/types.Code"
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/codes/{namespace}/{name}": {
            "get": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "get code detail",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Code"
                ],
                "summary": "Get code detail",
                "parameters": [
                    {
                        "type": "string",
                        "description": "namespace",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "name",
                        "name": "name",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "current_user",
                        "name": "current_user",
                        "in": "query",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.Response"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/types.Code"
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            },
            "put": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "update a exists code",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Code"
                ],
                "summary": "Update a exists code",
                "parameters": [
                    {
                        "type": "string",
                        "description": "namespace",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "name",
                        "name": "name",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "current user, the owner",
                        "name": "current_user",
                        "in": "query"
                    },
                    {
                        "description": "body",
                        "name": "body",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/types.UpdateCodeReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.Response"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/database.Code"
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            },
            "delete": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "delete a exists code",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Code"
                ],
                "summary": "Delete a exists code",
                "parameters": [
                    {
                        "type": "string",
                        "description": "namespace",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "name",
                        "name": "name",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "current user, the owner",
                        "name": "current_user",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.Response"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/codes/{namespace}/{name}/relations": {
            "get": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Code"
                ],
                "summary": "Get code related assets",
                "parameters": [
                    {
                        "type": "string",
                        "description": "namespace",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "name",
                        "name": "name",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "current_user",
                        "name": "current_user",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.Response"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/types.Relations"
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/collections": {
            "get": {
                "description": "get all collections",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Collection"
                ],
                "summary": "get all collections",
                "parameters": [
                    {
                        "type": "string",
                        "description": "search text",
                        "name": "search",
                        "in": "query"
                    },
                    {
                        "type": "string",
                        "default": "\"trending\"",
                        "description": "sort by",
                        "name": "sort",
                        "in": "query"
                    },
                    {
                        "type": "integer",
                        "default": 50,
                        "description": "per",
                        "name": "per",
                        "in": "query"
                    },
                    {
                        "type": "integer",
                        "default": 1,
                        "description": "per page",
                        "name": "page",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.ResponseWithTotal"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "type": "array",
                                            "items": {
                                                "$ref": "#/definitions/types.Collection"
                                            }
                                        },
                                        "total": {
                                            "type": "integer"
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            },
            "post": {
                "security": [
                    {
                        "JWT token": []
                    }
                ],
                "description": "create a collection",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Collection"
                ],
                "summary": "create a collection",
                "parameters": [
                    {
                        "description": "body",
                        "name": "body",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/types.CreateCollectionReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.Response"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/types.Collection"
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/collections/{id}": {
            "get": {
                "description": "get a collection detail",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Collection"
                ],
                "summary": "get a collection detail",
                "parameters": [
                    {
                        "type": "string",
                        "description": "id",
                        "name": "id",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.Response"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/types.Collection"
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            },
            "put": {
                "security": [
                    {
                        "JWT token": []
                    }
                ],
                "description": "update a collection",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Collection"
                ],
                "summary": "update a collection",
                "parameters": [
                    {
                        "description": "body",
                        "name": "body",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/types.CreateCollectionReq"
                        }
                    },
                    {
                        "type": "string",
                        "description": "id",
                        "name": "id",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.Response"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/types.Collection"
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            },
            "delete": {
                "security": [
                    {
                        "JWT token": []
                    }
                ],
                "description": "delete a exists collection",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Collection"
                ],
                "summary": "Delete a exists collection",
                "parameters": [
                    {
                        "type": "string",
                        "description": "id",
                        "name": "id",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.Response"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/collections/{id}/repos": {
            "post": {
                "security": [
                    {
                        "JWT token": []
                    }
                ],
                "description": "Add repos to a collection",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Collection"
                ],
                "summary": "Add repos to a collection",
                "parameters": [
                    {
                        "description": "body",
                        "name": "body",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/types.UpdateCollectionReposReq"
                        }
                    },
                    {
                        "type": "string",
                        "description": "id",
                        "name": "id",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.Response"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/database.Collection"
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            },
            "delete": {
                "security": [
                    {
                        "JWT token": []
                    }
                ],
                "description": "remove repos from a collection",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Collection"
                ],
                "summary": "remove repos from a collection",
                "parameters": [
                    {
                        "description": "body",
                        "name": "body",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/types.UpdateCollectionReposReq"
                        }
                    },
                    {
                        "type": "string",
                        "description": "id",
                        "name": "id",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.Response"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/types.Collection"
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/comments/{id}": {
            "put": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "update a comment content by id",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Discussion"
                ],
                "summary": "Update a comment content by id",
                "parameters": [
                    {
                        "type": "string",
                        "description": "the comment id",
                        "name": "id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "current user, the owner of the comment",
                        "name": "current_user",
                        "in": "query",
                        "required": true
                    },
                    {
                        "description": "body",
                        "name": "body",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/component.UpdateCommentRequest"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.Response"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            },
            "delete": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "delete a comment by id",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Discussion"
                ],
                "summary": "Delete a comment by id",
                "parameters": [
                    {
                        "type": "string",
                        "description": "the comment id",
                        "name": "id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "current user, the owner of the comment",
                        "name": "current_user",
                        "in": "query",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.Response"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/datasets": {
            "get": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "get visiable datasets for current user",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Dataset"
                ],
                "summary": "Get Visiable datasets for current user",
                "parameters": [
                    {
                        "type": "string",
                        "description": "current user",
                        "name": "current_user",
                        "in": "query"
                    },
                    {
                        "type": "string",
                        "description": "search text",
                        "name": "search",
                        "in": "query"
                    },
                    {
                        "type": "string",
                        "description": "filter by task tag",
                        "name": "task_tag",
                        "in": "query"
                    },
                    {
                        "type": "string",
                        "description": "filter by framework tag",
                        "name": "framework_tag",
                        "in": "query"
                    },
                    {
                        "type": "string",
                        "description": "filter by license tag",
                        "name": "license_tag",
                        "in": "query"
                    },
                    {
                        "type": "string",
                        "description": "filter by language tag",
                        "name": "language_tag",
                        "in": "query"
                    },
                    {
                        "type": "string",
                        "description": "sort by",
                        "name": "sort",
                        "in": "query"
                    },
                    {
                        "enum": [
                            "opencsg",
                            "huggingface",
                            "local"
                        ],
                        "type": "string",
                        "description": "source",
                        "name": "source",
                        "in": "query"
                    },
                    {
                        "type": "integer",
                        "default": 20,
                        "description": "per",
                        "name": "per",
                        "in": "query"
                    },
                    {
                        "type": "integer",
                        "default": 1,
                        "description": "per page",
                        "name": "page",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.ResponseWithTotal"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "type": "array",
                                            "items": {
                                                "$ref": "#/definitions/types.Dataset"
                                            }
                                        },
                                        "total": {
                                            "type": "integer"
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            },
            "post": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "create a new dataset",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Dataset"
                ],
                "summary": "Create a new dataset",
                "parameters": [
                    {
                        "type": "string",
                        "description": "current user, the owner",
                        "name": "current_user",
                        "in": "query"
                    },
                    {
                        "description": "body",
                        "name": "body",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/types.CreateDatasetReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.Response"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/types.Dataset"
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/datasets/{namespace}/{name}": {
            "get": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "get dataset detail",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Dataset"
                ],
                "summary": "Get dataset detail",
                "parameters": [
                    {
                        "type": "string",
                        "description": "namespace",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "name",
                        "name": "name",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "current_user",
                        "name": "current_user",
                        "in": "query",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.Response"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/types.Dataset"
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            },
            "put": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "update a exists dataset",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Dataset"
                ],
                "summary": "Update a exists dataset",
                "parameters": [
                    {
                        "type": "string",
                        "description": "namespace",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "name",
                        "name": "name",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "current user, the owner",
                        "name": "current_user",
                        "in": "query"
                    },
                    {
                        "description": "body",
                        "name": "body",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/types.UpdateDatasetReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.Response"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/database.Dataset"
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            },
            "delete": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "delete a exists dataset",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Dataset"
                ],
                "summary": "Delete a exists dataset",
                "parameters": [
                    {
                        "type": "string",
                        "description": "namespace",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "name",
                        "name": "name",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "current user, the owner",
                        "name": "current_user",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.Response"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/datasets/{namespace}/{name}/all_files": {
            "get": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Dataset"
                ],
                "summary": "Get all files of a dataset",
                "parameters": [
                    {
                        "type": "string",
                        "description": "namespace",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "name",
                        "name": "name",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "current user",
                        "name": "current_user",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.Response"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/types.File"
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/datasets/{namespace}/{name}/relations": {
            "get": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Dataset"
                ],
                "summary": "Get dataset related assets",
                "parameters": [
                    {
                        "type": "string",
                        "description": "namespace",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "name",
                        "name": "name",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "current_user",
                        "name": "current_user",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.Response"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/types.Relations"
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/datasets/{namespace}/{name}/viewer/{file_path}": {
            "get": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "get the demo data of the dataset",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Dataset"
                ],
                "summary": "Get the demo data of the dataset",
                "parameters": [
                    {
                        "type": "string",
                        "description": "namespace",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "file_path",
                        "name": "file_path",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "count",
                        "name": "count",
                        "in": "query",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.Response"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/discussions/{id}": {
            "get": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "show a discussion",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Discussion"
                ],
                "summary": "Show a discussion and its comments",
                "parameters": [
                    {
                        "type": "string",
                        "description": "the discussion id",
                        "name": "id",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.Response"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/component.ShowDiscussionResponse"
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            },
            "put": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "update a discussion",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Discussion"
                ],
                "summary": "Update a discussion",
                "parameters": [
                    {
                        "type": "string",
                        "description": "the discussion id",
                        "name": "id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "current user, the owner",
                        "name": "current_user",
                        "in": "query",
                        "required": true
                    },
                    {
                        "description": "body",
                        "name": "body",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/component.UpdateDiscussionRequest"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.Response"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            },
            "delete": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "delete a discussion",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Discussion"
                ],
                "summary": "Delete a discussion",
                "parameters": [
                    {
                        "type": "string",
                        "description": "the discussion id",
                        "name": "id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "current user, the owner of the discussion",
                        "name": "current_user",
                        "in": "query",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.Response"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/discussions/{id}/comments": {
            "get": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "list discussion comments",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Discussion"
                ],
                "summary": "List discussion comments",
                "parameters": [
                    {
                        "type": "string",
                        "description": "the discussion id",
                        "name": "id",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.Response"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "type": "array",
                                            "items": {
                                                "$ref": "#/definitions/component.DiscussionResponse_Comment"
                                            }
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            },
            "post": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "create a new discussion comment",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Discussion"
                ],
                "summary": "Create a new discussion comment",
                "parameters": [
                    {
                        "type": "string",
                        "description": "the discussion id",
                        "name": "id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "description": "body",
                        "name": "body",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/component.CreateCommentRequest"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.Response"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/component.CreateCommentResponse"
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/events": {
            "post": {
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Events"
                ],
                "summary": "Report client events",
                "parameters": [
                    {
                        "description": "Events",
                        "name": "events",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/types.Event"
                            }
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "object"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/jwt/token": {
            "post": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "JWT"
                ],
                "summary": "generate jwt token for user",
                "parameters": [
                    {
                        "description": "body",
                        "name": "body",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/types.CreateJWTReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.CreateJWTResp"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/jwt/{token}": {
            "get": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "JWT"
                ],
                "summary": "verify jwt token and return user info",
                "parameters": [
                    {
                        "type": "string",
                        "description": "token",
                        "name": "token",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.User"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/list/datasets_by_path": {
            "post": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "list datasets by paths",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "List"
                ],
                "summary": "List datasets by paths",
                "parameters": [
                    {
                        "description": "body",
                        "name": "body",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/types.ListByPathReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.Response"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "type": "array",
                                            "items": {
                                                "$ref": "#/definitions/types.DatasetResp"
                                            }
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/list/models_by_path": {
            "post": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "list models by paths",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "List"
                ],
                "summary": "List models by paths",
                "parameters": [
                    {
                        "description": "body",
                        "name": "body",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/types.ListByPathReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.Response"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "type": "array",
                                            "items": {
                                                "$ref": "#/definitions/types.ModelResp"
                                            }
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/list/spaces_by_path": {
            "post": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "List"
                ],
                "summary": "List spaces by paths",
                "parameters": [
                    {
                        "description": "body",
                        "name": "body",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/types.ListByPathReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.Response"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "type": "array",
                                            "items": {
                                                "$ref": "#/definitions/types.Space"
                                            }
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/mirror/repo": {
            "post": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Mirror"
                ],
                "summary": "Create mirror repo",
                "parameters": [
                    {
                        "description": "body",
                        "name": "body",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/types.CreateMirrorRepoReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.Response"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/mirror/repos": {
            "get": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Mirror"
                ],
                "summary": "Get mirror repos",
                "parameters": [
                    {
                        "type": "integer",
                        "default": 20,
                        "description": "per",
                        "name": "per",
                        "in": "query"
                    },
                    {
                        "type": "integer",
                        "default": 1,
                        "description": "page",
                        "name": "page",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.Response"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "type": "array",
                                            "items": {
                                                "$ref": "#/definitions/types.MirrorRepo"
                                            }
                                        },
                                        "total": {
                                            "type": "integer"
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/mirror/sources": {
            "get": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Mirror"
                ],
                "summary": "Get mirror sources",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.Response"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "type": "array",
                                            "items": {
                                                "$ref": "#/definitions/database.MirrorSource"
                                            }
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            },
            "post": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Mirror"
                ],
                "summary": "Create mirror source",
                "parameters": [
                    {
                        "description": "body",
                        "name": "body",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/types.CreateMirrorSourceReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.Response"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/database.MirrorSource"
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/mirror/sources/{id}": {
            "get": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Mirror"
                ],
                "summary": "Get mirror source",
                "parameters": [
                    {
                        "type": "string",
                        "description": "id",
                        "name": "id",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.Response"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/database.MirrorSource"
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            },
            "put": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Mirror"
                ],
                "summary": "Update mirror source",
                "parameters": [
                    {
                        "type": "string",
                        "description": "id",
                        "name": "id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "description": "body",
                        "name": "body",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/types.UpdateMirrorSourceReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.Response"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/database.MirrorSource"
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            },
            "delete": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Mirror"
                ],
                "summary": "Delete mirror source",
                "parameters": [
                    {
                        "type": "string",
                        "description": "id",
                        "name": "id",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.Response"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/mirrors": {
            "get": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Mirror"
                ],
                "summary": "Get mirrors",
                "parameters": [
                    {
                        "type": "integer",
                        "default": 20,
                        "description": "per",
                        "name": "per",
                        "in": "query"
                    },
                    {
                        "type": "integer",
                        "default": 1,
                        "description": "page",
                        "name": "page",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.Response"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "type": "array",
                                            "items": {
                                                "$ref": "#/definitions/types.Mirror"
                                            }
                                        },
                                        "total": {
                                            "type": "integer"
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/models": {
            "get": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "get visiable models for current user",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Model"
                ],
                "summary": "Get Visiable models for current user",
                "parameters": [
                    {
                        "type": "string",
                        "description": "current user",
                        "name": "current_user",
                        "in": "query"
                    },
                    {
                        "type": "string",
                        "description": "search text",
                        "name": "search",
                        "in": "query"
                    },
                    {
                        "type": "string",
                        "description": "filter by task tag, deprecated",
                        "name": "task_tag",
                        "in": "query"
                    },
                    {
                        "type": "string",
                        "description": "filter by framework tag, deprecated",
                        "name": "framework_tag",
                        "in": "query"
                    },
                    {
                        "type": "string",
                        "description": "filter by license tag, deprecated",
                        "name": "license_tag",
                        "in": "query"
                    },
                    {
                        "type": "string",
                        "description": "filter by language tag, deprecated",
                        "name": "language_tag",
                        "in": "query"
                    },
                    {
                        "type": "string",
                        "description": "filter by tag category",
                        "name": "tag_category",
                        "in": "query"
                    },
                    {
                        "type": "string",
                        "description": "filter by tag name",
                        "name": "tag_name",
                        "in": "query"
                    },
                    {
                        "type": "string",
                        "description": "sort by",
                        "name": "sort",
                        "in": "query"
                    },
                    {
                        "enum": [
                            "opencsg",
                            "huggingface",
                            "local"
                        ],
                        "type": "string",
                        "description": "source",
                        "name": "source",
                        "in": "query"
                    },
                    {
                        "type": "integer",
                        "default": 20,
                        "description": "per",
                        "name": "per",
                        "in": "query"
                    },
                    {
                        "type": "integer",
                        "default": 1,
                        "description": "per page",
                        "name": "page",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.ResponseWithTotal"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "type": "array",
                                            "items": {
                                                "$ref": "#/definitions/types.Model"
                                            }
                                        },
                                        "total": {
                                            "type": "integer"
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            },
            "post": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "create a new model",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Model"
                ],
                "summary": "Create a new model",
                "parameters": [
                    {
                        "type": "string",
                        "description": "current user",
                        "name": "current_user",
                        "in": "query"
                    },
                    {
                        "description": "body",
                        "name": "body",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/types.CreateModelReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.Response"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/database.Model"
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/models/runtime_framework": {
            "get": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "List repo runtime framework",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Repository"
                ],
                "summary": "List repo runtime framework",
                "parameters": [
                    {
                        "enum": [
                            "models"
                        ],
                        "type": "string",
                        "description": "models",
                        "name": "repo_type",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "namespace",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "name",
                        "name": "name",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "current user",
                        "name": "current_user",
                        "in": "query"
                    },
                    {
                        "enum": [
                            0,
                            1,
                            2
                        ],
                        "type": "integer",
                        "default": 1,
                        "description": "deploy_type",
                        "name": "deploy_type",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "string"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/models/{namespace}/{name}": {
            "get": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "get model detail",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Model"
                ],
                "summary": "Get model detail",
                "parameters": [
                    {
                        "type": "string",
                        "description": "namespace",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "name",
                        "name": "name",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "current_user",
                        "name": "current_user",
                        "in": "query",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.Response"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/types.Model"
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            },
            "put": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "update a exists model",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Model"
                ],
                "summary": "Update a exists model",
                "parameters": [
                    {
                        "type": "string",
                        "description": "namespace",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "name",
                        "name": "name",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "current user, the model owner",
                        "name": "current_user",
                        "in": "query"
                    },
                    {
                        "description": "body",
                        "name": "body",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/types.UpdateModelReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.Response"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/database.Model"
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            },
            "delete": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "delete a exists model",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Model"
                ],
                "summary": "Delete a exists model",
                "parameters": [
                    {
                        "type": "string",
                        "description": "namespace",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "name",
                        "name": "name",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "current user, the model owner",
                        "name": "current_user",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.Response"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/models/{namespace}/{name}/all_files": {
            "get": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Model"
                ],
                "summary": "Get all files of a model",
                "parameters": [
                    {
                        "type": "string",
                        "description": "namespace",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "name",
                        "name": "name",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "current user",
                        "name": "current_user",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.Response"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/types.File"
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/models/{namespace}/{name}/finetune": {
            "post": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Model"
                ],
                "summary": "create a finetune instance",
                "parameters": [
                    {
                        "type": "string",
                        "description": "namespace",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "name",
                        "name": "name",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "current_user",
                        "name": "current_user",
                        "in": "query",
                        "required": true
                    },
                    {
                        "description": "deploy setting of instance",
                        "name": "body",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/types.InstanceRunReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "string"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/models/{namespace}/{name}/finetune/{id}": {
            "delete": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "delete a finetune instance",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Model"
                ],
                "summary": "Delete a finetune instance",
                "parameters": [
                    {
                        "type": "string",
                        "description": "namespace",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "name",
                        "name": "name",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "id",
                        "name": "id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "current user",
                        "name": "current_user",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.Response"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/models/{namespace}/{name}/finetune/{id}/start": {
            "put": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "Start a finetune instance",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Model"
                ],
                "summary": "Start a finetune instance",
                "parameters": [
                    {
                        "type": "string",
                        "description": "namespace",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "name",
                        "name": "name",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "deploy id",
                        "name": "id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "current user",
                        "name": "current_user",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.Response"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/models/{namespace}/{name}/finetune/{id}/stop": {
            "put": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "Stop a finetune instance",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Model"
                ],
                "summary": "Stop a finetune instance",
                "parameters": [
                    {
                        "type": "string",
                        "description": "namespace",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "name",
                        "name": "name",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "id",
                        "name": "id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "current user",
                        "name": "current_user",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.Response"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/models/{namespace}/{name}/predict": {
            "post": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "invoke model prediction",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Model"
                ],
                "summary": "Invoke model prediction",
                "parameters": [
                    {
                        "type": "string",
                        "description": "namespace",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "name",
                        "name": "name",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "current user",
                        "name": "current_user",
                        "in": "query"
                    },
                    {
                        "description": "input for model prediction",
                        "name": "body",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/types.ModelPredictReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "string"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/models/{namespace}/{name}/relations": {
            "get": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Model"
                ],
                "summary": "Get model related assets",
                "parameters": [
                    {
                        "type": "string",
                        "description": "namespace",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "name",
                        "name": "name",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "current user",
                        "name": "current_user",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.Response"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/types.Relations"
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            },
            "put": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Model"
                ],
                "summary": "Set dataset relation for model",
                "parameters": [
                    {
                        "type": "string",
                        "description": "namespace",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "name",
                        "name": "name",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "current user",
                        "name": "current_user",
                        "in": "query"
                    },
                    {
                        "description": "set dataset relation",
                        "name": "req",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/types.RelationDatasets"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.Response"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/types.Relations"
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/models/{namespace}/{name}/relations/dataset": {
            "post": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Model"
                ],
                "summary": "add dataset relation for model",
                "parameters": [
                    {
                        "type": "string",
                        "description": "namespace",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "name",
                        "name": "name",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "current user",
                        "name": "current_user",
                        "in": "query"
                    },
                    {
                        "description": "add dataset relation",
                        "name": "req",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/types.RelationDataset"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.Response"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            },
            "delete": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Model"
                ],
                "summary": "delete dataset relation for model",
                "parameters": [
                    {
                        "type": "string",
                        "description": "namespace",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "name",
                        "name": "name",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "current user",
                        "name": "current_user",
                        "in": "query"
                    },
                    {
                        "description": "delelet dataset relation",
                        "name": "req",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/types.RelationDataset"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.Response"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/models/{namespace}/{name}/run": {
            "post": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Model"
                ],
                "summary": "run model as inference",
                "parameters": [
                    {
                        "type": "string",
                        "description": "namespace",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "name",
                        "name": "name",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "current_user",
                        "name": "current_user",
                        "in": "query",
                        "required": true
                    },
                    {
                        "description": "deploy setting of inference",
                        "name": "body",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/types.ModelRunReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "string"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/models/{namespace}/{name}/run/{id}": {
            "delete": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "delete a model inference",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Model"
                ],
                "summary": "Delete a model inference",
                "parameters": [
                    {
                        "type": "string",
                        "description": "namespace",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "name",
                        "name": "name",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "id",
                        "name": "id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "current user",
                        "name": "current_user",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.Response"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/models/{namespace}/{name}/run/{id}/start": {
            "put": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "Start a model inference",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Model"
                ],
                "summary": "Start a model inference",
                "parameters": [
                    {
                        "type": "string",
                        "description": "namespace",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "name",
                        "name": "name",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "deploy id",
                        "name": "id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "current user",
                        "name": "current_user",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.Response"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/models/{namespace}/{name}/run/{id}/stop": {
            "put": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "Stop a model inference",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Model"
                ],
                "summary": "Stop a model inference",
                "parameters": [
                    {
                        "type": "string",
                        "description": "namespace",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "name",
                        "name": "name",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "id",
                        "name": "id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "current user",
                        "name": "current_user",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.Response"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/models/{namespace}/{name}/serverless": {
            "get": {
                "security": [
                    {
                        "JWT token": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Model"
                ],
                "summary": "get model serverless",
                "parameters": [
                    {
                        "type": "string",
                        "description": "namespace",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "name",
                        "name": "name",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "string"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            },
            "post": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Model"
                ],
                "summary": "run model as serverless service",
                "parameters": [
                    {
                        "type": "string",
                        "description": "namespace",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "name",
                        "name": "name",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "current_user",
                        "name": "current_user",
                        "in": "query",
                        "required": true
                    },
                    {
                        "description": "deploy setting of serverless",
                        "name": "body",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/types.ModelRunReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "string"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/models/{namespace}/{name}/serverless/{id}": {
            "get": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "Get repo serverless detail",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Model"
                ],
                "summary": "Get repo serverless detail",
                "parameters": [
                    {
                        "type": "string",
                        "description": "namespace",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "name",
                        "name": "name",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "id",
                        "name": "id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "current user",
                        "name": "current_user",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "string"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            },
            "put": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Model"
                ],
                "summary": "Update serverless parameters",
                "parameters": [
                    {
                        "type": "string",
                        "description": "namespace",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "name",
                        "name": "name",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "deploy id",
                        "name": "id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "current_user",
                        "name": "current_user",
                        "in": "query",
                        "required": true
                    },
                    {
                        "description": "deploy setting of Serverless",
                        "name": "body",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/types.DeployUpdateReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.Response"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/models/{namespace}/{name}/serverless/{id}/logs/{instance}": {
            "get": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Model"
                ],
                "summary": "get serverless logs",
                "parameters": [
                    {
                        "enum": [
                            "models"
                        ],
                        "type": "string",
                        "description": "models",
                        "name": "repo_type",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "namespace",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "name",
                        "name": "name",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "id",
                        "name": "id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "instance",
                        "name": "instance",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "current_user",
                        "name": "current_user",
                        "in": "query",
                        "required": true
                    }
                ],
                "responses": {
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/models/{namespace}/{name}/serverless/{id}/start": {
            "put": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "Start a model serverless",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Model"
                ],
                "summary": "Start a model serverless",
                "parameters": [
                    {
                        "type": "string",
                        "description": "namespace",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "name",
                        "name": "name",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "deploy id",
                        "name": "id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "current user",
                        "name": "current_user",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.Response"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/models/{namespace}/{name}/serverless/{id}/status": {
            "get": {
                "security": [
                    {
                        "JWT token": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Model"
                ],
                "summary": "get serverless status",
                "parameters": [
                    {
                        "type": "string",
                        "description": "namespace",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "name",
                        "name": "name",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "deploy id",
                        "name": "id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "current_user",
                        "name": "current_user",
                        "in": "query",
                        "required": true
                    }
                ],
                "responses": {
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/models/{namespace}/{name}/serverless/{id}/stop": {
            "put": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "Stop a model serverless",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Model"
                ],
                "summary": "Stop a model serverless",
                "parameters": [
                    {
                        "type": "string",
                        "description": "namespace",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "name",
                        "name": "name",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "id",
                        "name": "id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "current user",
                        "name": "current_user",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.Response"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/namespace/{path}": {
            "get": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "get namespace info",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Namespace",
                    "InternalOnly"
                ],
                "summary": "Get namespace info [Internal Only].",
                "parameters": [
                    {
                        "type": "string",
                        "description": "namespace",
                        "name": "path",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.Response"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/types.Namespace"
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/organization/{namespace}": {
            "get": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Organization"
                ],
                "summary": "Get organization info",
                "parameters": [
                    {
                        "type": "string",
                        "description": "the op user",
                        "name": "current_user",
                        "in": "query"
                    },
                    {
                        "type": "string",
                        "description": "namespace",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.Response"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/types.Organization"
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            },
            "put": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "update organization",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Organization"
                ],
                "summary": "Update organization",
                "parameters": [
                    {
                        "type": "string",
                        "description": "namespace",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "the op user",
                        "name": "current_user",
                        "in": "query"
                    },
                    {
                        "description": "body",
                        "name": "body",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/types.EditOrgReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.Response"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/database.Organization"
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            },
            "delete": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "delete organization",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Organization"
                ],
                "summary": "Delete organization",
                "parameters": [
                    {
                        "type": "string",
                        "description": "namespace",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "the op user",
                        "name": "current_user",
                        "in": "query"
                    },
                    {
                        "description": "body",
                        "name": "body",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/types.DeleteOrgReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.Response"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/organization/{namespace}/codes": {
            "get": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Organization"
                ],
                "summary": "Get organization codes",
                "parameters": [
                    {
                        "type": "string",
                        "description": "org name",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "current user name",
                        "name": "current_user",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "page size",
                        "name": "per",
                        "in": "query"
                    },
                    {
                        "type": "integer",
                        "description": "current page number",
                        "name": "page",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.ResponseWithTotal"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "type": "array",
                                            "items": {
                                                "$ref": "#/definitions/types.Code"
                                            }
                                        },
                                        "total": {
                                            "type": "integer"
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/organization/{namespace}/collections": {
            "get": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Organization"
                ],
                "summary": "Get organization Collections",
                "parameters": [
                    {
                        "type": "string",
                        "description": "org name",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "current user name",
                        "name": "current_user",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "page size",
                        "name": "per",
                        "in": "query"
                    },
                    {
                        "type": "integer",
                        "description": "current page number",
                        "name": "page",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.ResponseWithTotal"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "type": "array",
                                            "items": {
                                                "$ref": "#/definitions/types.Collection"
                                            }
                                        },
                                        "total": {
                                            "type": "integer"
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/organization/{namespace}/datasets": {
            "get": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "get organization datasets",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Organization"
                ],
                "summary": "Get organization datasets",
                "parameters": [
                    {
                        "type": "string",
                        "description": "org name",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "current user name",
                        "name": "current_user",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "page size",
                        "name": "per",
                        "in": "query"
                    },
                    {
                        "type": "integer",
                        "description": "current page number",
                        "name": "page",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.ResponseWithTotal"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "type": "array",
                                            "items": {
                                                "$ref": "#/definitions/types.Dataset"
                                            }
                                        },
                                        "total": {
                                            "type": "integer"
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/organization/{namespace}/members": {
            "get": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Member"
                ],
                "summary": "Get organization members. Org member can get more details.",
                "parameters": [
                    {
                        "type": "string",
                        "description": "the op user",
                        "name": "current_user",
                        "in": "query"
                    },
                    {
                        "type": "string",
                        "description": "namespace",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "default": 50,
                        "description": "per",
                        "name": "per",
                        "in": "query"
                    },
                    {
                        "type": "integer",
                        "default": 1,
                        "description": "per page",
                        "name": "page",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.ResponseWithTotal"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        " total": {
                                            "type": "integer"
                                        },
                                        "data": {
                                            "$ref": "#/definitions/types.Member"
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            },
            "post": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "user will be added to org with a role",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Member"
                ],
                "summary": "Create new membership between org and user",
                "parameters": [
                    {
                        "type": "string",
                        "description": "org name",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "the op user",
                        "name": "current_user",
                        "in": "query"
                    },
                    {
                        "description": "body",
                        "name": "body",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/handler.Create.addMemberRequest"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.Response"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/organization/{namespace}/members/{username}": {
            "get": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Member"
                ],
                "summary": "Get user's role in an org",
                "parameters": [
                    {
                        "type": "string",
                        "description": "org name",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "user name",
                        "name": "username",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "the op user",
                        "name": "current_user",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "string"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            },
            "put": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Member"
                ],
                "summary": "update user membership",
                "parameters": [
                    {
                        "type": "string",
                        "description": "org name",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "user name",
                        "name": "username",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "the op user",
                        "name": "current_user",
                        "in": "query"
                    },
                    {
                        "description": "body",
                        "name": "body",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/handler.Update.updateMemberRequest"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.Response"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            },
            "delete": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "user's role will be remove from org",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Member"
                ],
                "summary": "Remove membership between org and user",
                "parameters": [
                    {
                        "type": "string",
                        "description": "org name",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "user name",
                        "name": "username",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "the op user",
                        "name": "current_user",
                        "in": "query"
                    },
                    {
                        "description": "body",
                        "name": "body",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/handler.Delete.removeMemberRequest"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.Response"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/organization/{namespace}/models": {
            "get": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "get organization models",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Organization"
                ],
                "summary": "Get organization models",
                "parameters": [
                    {
                        "type": "string",
                        "description": "org name",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "current user name",
                        "name": "current_user",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "page size",
                        "name": "per",
                        "in": "query"
                    },
                    {
                        "type": "integer",
                        "description": "current page number",
                        "name": "page",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.ResponseWithTotal"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "type": "array",
                                            "items": {
                                                "$ref": "#/definitions/types.Model"
                                            }
                                        },
                                        "total": {
                                            "type": "integer"
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/organization/{namespace}/prompts": {
            "get": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "get organization prompts",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Organization"
                ],
                "summary": "Get organization prompts",
                "parameters": [
                    {
                        "type": "string",
                        "description": "org name",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "current user name",
                        "name": "current_user",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "page size",
                        "name": "per",
                        "in": "query"
                    },
                    {
                        "type": "integer",
                        "description": "current page number",
                        "name": "page",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.ResponseWithTotal"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "type": "array",
                                            "items": {
                                                "$ref": "#/definitions/types.PromptRes"
                                            }
                                        },
                                        "total": {
                                            "type": "integer"
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/organization/{namespace}/spaces": {
            "get": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Organization"
                ],
                "summary": "Get organization Spaces",
                "parameters": [
                    {
                        "type": "string",
                        "description": "org name",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "current user name",
                        "name": "current_user",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "page size",
                        "name": "per",
                        "in": "query"
                    },
                    {
                        "type": "integer",
                        "description": "current page number",
                        "name": "page",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.ResponseWithTotal"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "type": "array",
                                            "items": {
                                                "$ref": "#/definitions/types.Space"
                                            }
                                        },
                                        "total": {
                                            "type": "integer"
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/organizations": {
            "get": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "get organizations",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Organization"
                ],
                "summary": "Get organizations",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.Response"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "type": "array",
                                            "items": {
                                                "$ref": "#/definitions/types.Organization"
                                            }
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            },
            "post": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "create a new organization",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Organization"
                ],
                "summary": "Create a new organization",
                "parameters": [
                    {
                        "type": "string",
                        "description": "the op user",
                        "name": "current_user",
                        "in": "query"
                    },
                    {
                        "description": "body",
                        "name": "body",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/types.CreateOrgReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.Response"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/types.Organization"
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/prompts": {
            "get": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "get visiable Prompt repos for current user",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Prompt"
                ],
                "summary": "Get Visiable Prompt repos for current user",
                "parameters": [
                    {
                        "type": "string",
                        "description": "current user",
                        "name": "current_user",
                        "in": "query"
                    },
                    {
                        "type": "string",
                        "description": "search text",
                        "name": "search",
                        "in": "query"
                    },
                    {
                        "type": "string",
                        "description": "filter by task tag",
                        "name": "task_tag",
                        "in": "query"
                    },
                    {
                        "type": "string",
                        "description": "filter by framework tag",
                        "name": "framework_tag",
                        "in": "query"
                    },
                    {
                        "type": "string",
                        "description": "filter by license tag",
                        "name": "license_tag",
                        "in": "query"
                    },
                    {
                        "type": "string",
                        "description": "filter by language tag",
                        "name": "language_tag",
                        "in": "query"
                    },
                    {
                        "type": "string",
                        "description": "sort by",
                        "name": "sort",
                        "in": "query"
                    },
                    {
                        "enum": [
                            "opencsg",
                            "huggingface",
                            "local"
                        ],
                        "type": "string",
                        "description": "source",
                        "name": "source",
                        "in": "query"
                    },
                    {
                        "type": "integer",
                        "default": 20,
                        "description": "per",
                        "name": "per",
                        "in": "query"
                    },
                    {
                        "type": "integer",
                        "default": 1,
                        "description": "per page",
                        "name": "page",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.ResponseWithTotal"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "type": "array",
                                            "items": {
                                                "$ref": "#/definitions/types.PromptRes"
                                            }
                                        },
                                        "total": {
                                            "type": "integer"
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            },
            "post": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "create a new prompt repo",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Prompt"
                ],
                "summary": "Create a new prompt repo",
                "parameters": [
                    {
                        "type": "string",
                        "description": "current user, the owner",
                        "name": "current_user",
                        "in": "query"
                    },
                    {
                        "description": "body",
                        "name": "body",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/types.CreatePromptRepoReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.Response"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/prompts/conversations": {
            "get": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "List conversations of user",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Prompt"
                ],
                "summary": "List conversations of user",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.Response"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            },
            "post": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "Create new conversation",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Prompt"
                ],
                "summary": "Create new conversation",
                "parameters": [
                    {
                        "description": "body",
                        "name": "body",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/types.Conversation"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.Response"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/prompts/conversations/{id}": {
            "get": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "Get a conversation by uuid",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Prompt"
                ],
                "summary": "Get a conversation by uuid",
                "parameters": [
                    {
                        "type": "string",
                        "description": "conversation uuid",
                        "name": "id",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.Response"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            },
            "put": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "Update a conversation title",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Prompt"
                ],
                "summary": "Update a conversation title",
                "parameters": [
                    {
                        "type": "string",
                        "description": "conversation uuid",
                        "name": "id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "description": "body",
                        "name": "body",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/types.ConversationTitle"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.Response"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            },
            "post": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "Submit a conversation message",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Prompt"
                ],
                "summary": "Submit a conversation message",
                "parameters": [
                    {
                        "type": "string",
                        "description": "conversation uuid",
                        "name": "id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "description": "body",
                        "name": "body",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/types.Conversation"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.Response"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            },
            "delete": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "Delete a conversation",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Prompt"
                ],
                "summary": "Delete a conversation",
                "parameters": [
                    {
                        "type": "string",
                        "description": "conversation uuid",
                        "name": "id",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.Response"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/prompts/conversations/{id}/message/{msgid}/hate": {
            "put": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "Hate a conversation message",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Prompt"
                ],
                "summary": "Hate a conversation message",
                "parameters": [
                    {
                        "type": "string",
                        "description": "conversation uuid",
                        "name": "uuid",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "message id",
                        "name": "id",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.Response"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/prompts/conversations/{id}/message/{msgid}/like": {
            "put": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "Like a conversation message",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Prompt"
                ],
                "summary": "Like a conversation message",
                "parameters": [
                    {
                        "type": "string",
                        "description": "conversation uuid",
                        "name": "uuid",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "message id",
                        "name": "id",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.Response"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/prompts/{namespace}/{name}": {
            "get": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "List prompts",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Prompt"
                ],
                "summary": "List prompts",
                "parameters": [
                    {
                        "type": "string",
                        "description": "namespace",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "name",
                        "name": "name",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.Response"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            },
            "put": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "update a exists prompt repo",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Prompt"
                ],
                "summary": "Update a exists prompt repo",
                "parameters": [
                    {
                        "type": "string",
                        "description": "namespace",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "name",
                        "name": "name",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "current user, the owner",
                        "name": "current_user",
                        "in": "query"
                    },
                    {
                        "description": "body",
                        "name": "body",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/types.UpdatePromptRepoReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.Response"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            },
            "delete": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "delete a exists prompt repo",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Prompt"
                ],
                "summary": "Delete a exists prompt repo",
                "parameters": [
                    {
                        "type": "string",
                        "description": "namespace",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "name",
                        "name": "name",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "current user, the owner",
                        "name": "current_user",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.Response"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/prompts/{namespace}/{name}/branches": {
            "get": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Prompt"
                ],
                "summary": "Get the branches of prompt repository",
                "parameters": [
                    {
                        "type": "string",
                        "description": "repo owner name",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "repo name",
                        "name": "name",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "branch or tag",
                        "name": "ref",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "current user name",
                        "name": "current_user",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.ResponseWithTotal"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "type": "array",
                                            "items": {
                                                "$ref": "#/definitions/types.Branch"
                                            }
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/prompts/{namespace}/{name}/prompt/file": {
            "post": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "Create prompt in repo",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Prompt"
                ],
                "summary": "Create prompt in repo",
                "parameters": [
                    {
                        "type": "string",
                        "description": "namespace",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "name",
                        "name": "name",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "current user name",
                        "name": "current_user",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.Response"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/prompts/{namespace}/{name}/prompt/file/{file_path}": {
            "put": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "Update prompt in repo",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Prompt"
                ],
                "summary": "Update prompt in repo",
                "parameters": [
                    {
                        "type": "string",
                        "description": "namespace",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "name",
                        "name": "name",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "the file relative path",
                        "name": "file_path",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "current user name",
                        "name": "current_user",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.Response"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            },
            "delete": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "Delete prompt in repo",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Prompt"
                ],
                "summary": "Delete prompt in repo",
                "parameters": [
                    {
                        "type": "string",
                        "description": "namespace",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "name",
                        "name": "name",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "the file relative path",
                        "name": "file_path",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "current user name",
                        "name": "current_user",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.Response"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/prompts/{namespace}/{name}/prompt/view/{file_path}": {
            "get": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "Get prompts by file",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Prompt"
                ],
                "summary": "Get prompts by file",
                "parameters": [
                    {
                        "type": "string",
                        "description": "namespace",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "name",
                        "name": "name",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "the file relative path",
                        "name": "file_path",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "current user name",
                        "name": "current_user",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.Response"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/prompts/{namespace}/{name}/relations": {
            "get": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Prompt"
                ],
                "summary": "Get prompt related assets",
                "parameters": [
                    {
                        "type": "string",
                        "description": "namespace",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "name",
                        "name": "name",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "current user",
                        "name": "current_user",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.Response"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/types.Relations"
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            },
            "put": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Prompt"
                ],
                "summary": "Set model relation for prompt",
                "parameters": [
                    {
                        "type": "string",
                        "description": "namespace",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "name",
                        "name": "name",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "current user",
                        "name": "current_user",
                        "in": "query"
                    },
                    {
                        "description": "set model relation",
                        "name": "req",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/types.RelationModels"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.Response"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/prompts/{namespace}/{name}/relations/model": {
            "post": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Prompt"
                ],
                "summary": "add model relation for prompt",
                "parameters": [
                    {
                        "type": "string",
                        "description": "namespace",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "name",
                        "name": "name",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "current user",
                        "name": "current_user",
                        "in": "query"
                    },
                    {
                        "description": "add model relation",
                        "name": "req",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/types.RelationModel"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.Response"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            },
            "delete": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Prompt"
                ],
                "summary": "delete model relation for prompt",
                "parameters": [
                    {
                        "type": "string",
                        "description": "namespace",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "name",
                        "name": "name",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "current user",
                        "name": "current_user",
                        "in": "query"
                    },
                    {
                        "description": "delelet model relation",
                        "name": "req",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/types.RelationModel"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.Response"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/prompts/{namespace}/{name}/tags": {
            "get": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Prompt"
                ],
                "summary": "Get the tags of prompt repository",
                "parameters": [
                    {
                        "type": "string",
                        "description": "repo owner name",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "repo name",
                        "name": "name",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "current user name",
                        "name": "current_user",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.ResponseWithTotal"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "type": "array",
                                            "items": {
                                                "$ref": "#/definitions/database.Tag"
                                            }
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/prompts/{namespace}/{name}/tags/{category}": {
            "post": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Prompt"
                ],
                "summary": "update the tags of a certain category",
                "parameters": [
                    {
                        "type": "string",
                        "description": "repo owner name",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "repo name",
                        "name": "name",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "current user name",
                        "name": "current_user",
                        "in": "query",
                        "required": true
                    },
                    {
                        "enum": [
                            "task",
                            "license",
                            "framework",
                            "language",
                            "industry"
                        ],
                        "type": "string",
                        "description": "tag category",
                        "name": "category",
                        "in": "path",
                        "required": true
                    },
                    {
                        "description": "tag names in array",
                        "name": "tags",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "type": "array",
                            "items": {
                                "type": "string"
                            }
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.Response"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/recom/opweight": {
            "post": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Recommendation"
                ],
                "summary": "set op weight for repo recommendation",
                "parameters": [
                    {
                        "description": "json request body",
                        "name": "body",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/handler.SetOpWeight.SetOpWeightReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.Response"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/runtime_framework": {
            "get": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "get all runtime frameworks for current user",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "RuntimeFramework"
                ],
                "summary": "Get all runtime frameworks for current user",
                "parameters": [
                    {
                        "type": "string",
                        "description": "current user",
                        "name": "current_user",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.Response"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/runtime_framework/models": {
            "get": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "get visible models for all runtime frameworks for current user",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "RuntimeFramework"
                ],
                "summary": "Get Visible models for all runtime frameworks for current user",
                "parameters": [
                    {
                        "type": "string",
                        "description": "search text",
                        "name": "search",
                        "in": "query"
                    },
                    {
                        "type": "string",
                        "description": "sort by",
                        "name": "sort",
                        "in": "query"
                    },
                    {
                        "type": "string",
                        "description": "current user",
                        "name": "current_user",
                        "in": "query"
                    },
                    {
                        "type": "integer",
                        "default": 20,
                        "description": "per",
                        "name": "per",
                        "in": "query"
                    },
                    {
                        "type": "integer",
                        "default": 1,
                        "description": "per page",
                        "name": "page",
                        "in": "query"
                    },
                    {
                        "enum": [
                            1,
                            2
                        ],
                        "type": "integer",
                        "default": 1,
                        "description": "deploy_type",
                        "name": "deploy_type",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.Response"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/runtime_framework/{id}": {
            "post": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "set model runtime frameworks",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "RuntimeFramework"
                ],
                "summary": "Set model runtime frameworks",
                "parameters": [
                    {
                        "type": "integer",
                        "description": "runtime framework id",
                        "name": "id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "enum": [
                            0,
                            1,
                            2
                        ],
                        "type": "integer",
                        "default": 1,
                        "description": "deploy_type",
                        "name": "deploy_type",
                        "in": "query"
                    },
                    {
                        "type": "string",
                        "description": "current user",
                        "name": "current_user",
                        "in": "query"
                    },
                    {
                        "description": "body",
                        "name": "body",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/types.RuntimeFrameworkModels"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.Response"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            },
            "delete": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "set model runtime frameworks",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "RuntimeFramework"
                ],
                "summary": "Set model runtime frameworks",
                "parameters": [
                    {
                        "type": "integer",
                        "description": "runtime framework id",
                        "name": "id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "enum": [
                            0,
                            1,
                            2
                        ],
                        "type": "integer",
                        "default": 1,
                        "description": "deploy_type",
                        "name": "deploy_type",
                        "in": "query"
                    },
                    {
                        "description": "body",
                        "name": "body",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/types.RuntimeFrameworkModels"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.Response"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/runtime_framework/{id}/architecture": {
            "get": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "get runtime framework architectures",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "RuntimeFramework"
                ],
                "summary": "Get runtime framework architectures",
                "parameters": [
                    {
                        "type": "integer",
                        "description": "runtime framework id",
                        "name": "id",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.Response"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            },
            "put": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "set runtime framework architectures",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "RuntimeFramework"
                ],
                "summary": "Set runtime framework architectures",
                "parameters": [
                    {
                        "type": "integer",
                        "description": "runtime framework id",
                        "name": "id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "description": "body",
                        "name": "body",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/types.RuntimeArchitecture"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.Response"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            },
            "delete": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "Delete runtime framework architectures",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "RuntimeFramework"
                ],
                "summary": "Delete runtime framework architectures",
                "parameters": [
                    {
                        "type": "integer",
                        "description": "runtime framework id",
                        "name": "id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "description": "body",
                        "name": "body",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/types.RuntimeArchitecture"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.Response"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/runtime_framework/{id}/models": {
            "get": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "get visible models by runtime framework for current user",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "RuntimeFramework"
                ],
                "summary": "Get Visible models by runtime framework for current user",
                "parameters": [
                    {
                        "type": "integer",
                        "description": "runtime framework id",
                        "name": "id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "current user",
                        "name": "current_user",
                        "in": "query"
                    },
                    {
                        "type": "integer",
                        "default": 20,
                        "description": "per",
                        "name": "per",
                        "in": "query"
                    },
                    {
                        "type": "integer",
                        "default": 1,
                        "description": "per page",
                        "name": "page",
                        "in": "query"
                    },
                    {
                        "enum": [
                            0,
                            1,
                            2
                        ],
                        "type": "integer",
                        "default": 1,
                        "description": "deploy_type",
                        "name": "deploy_type",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.Response"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/runtime_framework/{id}/scan": {
            "post": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "Scan runtime architecture",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "RuntimeFramework"
                ],
                "summary": "Scan runtime architecture",
                "parameters": [
                    {
                        "type": "integer",
                        "description": "runtime framework id",
                        "name": "id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "enum": [
                            0,
                            1,
                            2
                        ],
                        "type": "integer",
                        "description": "scan_type(0:all models, 1:new models, 2:old models)",
                        "name": "scan_type",
                        "in": "query"
                    },
                    {
                        "description": "body",
                        "name": "body",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/types.RuntimeFrameworkModels"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.Response"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/space_resources": {
            "get": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "get space resources",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "SpaceReource"
                ],
                "summary": "Get space resources",
                "parameters": [
                    {
                        "type": "string",
                        "description": "cluster_id",
                        "name": "cluster_id",
                        "in": "query"
                    },
                    {
                        "enum": [
                            0,
                            1,
                            2
                        ],
                        "type": "integer",
                        "default": 1,
                        "description": "deploy type(0-space,1-inference,2-finetune)",
                        "name": "deploy_type",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.ResponseWithTotal"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "type": "array",
                                            "items": {
                                                "$ref": "#/definitions/types.SpaceResource"
                                            }
                                        },
                                        "total": {
                                            "type": "integer"
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            },
            "post": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "create space resource",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "SpaceReource"
                ],
                "summary": "Create space resource",
                "parameters": [
                    {
                        "description": "body",
                        "name": "body",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/types.CreateSpaceResourceReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.ResponseWithTotal"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/types.SpaceResource"
                                        },
                                        "total": {
                                            "type": "integer"
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/space_resources/{id}": {
            "put": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "update a exist space resource",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "SpaceReource"
                ],
                "summary": "Update a exist space resource",
                "parameters": [
                    {
                        "type": "integer",
                        "description": "id",
                        "name": "id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "description": "body",
                        "name": "body",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/types.UpdateSpaceResourceReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.ResponseWithTotal"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/types.SpaceResource"
                                        },
                                        "total": {
                                            "type": "integer"
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            },
            "delete": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "delete a exist space resource",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "SpaceReource"
                ],
                "summary": "Delete a exist space resource",
                "parameters": [
                    {
                        "type": "integer",
                        "description": "id",
                        "name": "id",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.Response"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/space_sdks": {
            "get": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "get space sdks",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "SpaceSdk"
                ],
                "summary": "Get space sdks",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.ResponseWithTotal"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "type": "array",
                                            "items": {
                                                "$ref": "#/definitions/types.SpaceSdk"
                                            }
                                        },
                                        "total": {
                                            "type": "integer"
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            },
            "post": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "create space sdk",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "SpaceSdk"
                ],
                "summary": "Create space sdk",
                "parameters": [
                    {
                        "description": "body",
                        "name": "body",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/types.CreateSpaceSdkReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.ResponseWithTotal"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/types.SpaceSdk"
                                        },
                                        "total": {
                                            "type": "integer"
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/space_sdks/{id}": {
            "put": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "update a exist space sdk",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "SpaceSdk"
                ],
                "summary": "Update a exist space sdk",
                "parameters": [
                    {
                        "type": "integer",
                        "description": "id",
                        "name": "id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "description": "body",
                        "name": "body",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/types.UpdateSpaceSdkReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.ResponseWithTotal"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/types.SpaceSdk"
                                        },
                                        "total": {
                                            "type": "integer"
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            },
            "delete": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "delete a exist space sdk",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "SpaceSdk"
                ],
                "summary": "Delete a exist space sdk",
                "parameters": [
                    {
                        "type": "integer",
                        "description": "id",
                        "name": "写id",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.Response"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/spaces": {
            "get": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "get spaces visible to current user",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Space"
                ],
                "summary": "Get spaces visible to current user",
                "parameters": [
                    {
                        "type": "string",
                        "description": "current user",
                        "name": "current_user",
                        "in": "query"
                    },
                    {
                        "type": "string",
                        "description": "search text",
                        "name": "search",
                        "in": "query"
                    },
                    {
                        "type": "string",
                        "description": "filter by task tag",
                        "name": "task_tag",
                        "in": "query"
                    },
                    {
                        "type": "string",
                        "description": "filter by framework tag",
                        "name": "framework_tag",
                        "in": "query"
                    },
                    {
                        "type": "string",
                        "description": "filter by license tag",
                        "name": "license_tag",
                        "in": "query"
                    },
                    {
                        "type": "string",
                        "description": "filter by language tag",
                        "name": "language_tag",
                        "in": "query"
                    },
                    {
                        "type": "string",
                        "description": "sort by",
                        "name": "sort",
                        "in": "query"
                    },
                    {
                        "enum": [
                            "opencsg",
                            "huggingface",
                            "local"
                        ],
                        "type": "string",
                        "description": "source",
                        "name": "source",
                        "in": "query"
                    },
                    {
                        "type": "integer",
                        "default": 20,
                        "description": "per",
                        "name": "per",
                        "in": "query"
                    },
                    {
                        "type": "integer",
                        "default": 1,
                        "description": "per page",
                        "name": "page",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.ResponseWithTotal"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "type": "array",
                                            "items": {
                                                "$ref": "#/definitions/types.Space"
                                            }
                                        },
                                        "total": {
                                            "type": "integer"
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            },
            "post": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "create a new space",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Space"
                ],
                "summary": "Create a new space",
                "parameters": [
                    {
                        "type": "string",
                        "description": "current_user",
                        "name": "current_user",
                        "in": "query",
                        "required": true
                    },
                    {
                        "description": "body",
                        "name": "body",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/types.CreateSpaceReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.Response"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/types.Space"
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/spaces/{namespace}/{name}": {
            "get": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Space"
                ],
                "summary": "show space detail",
                "parameters": [
                    {
                        "type": "string",
                        "description": "namespace",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "name",
                        "name": "name",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "current_user",
                        "name": "current_user",
                        "in": "query",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.Response"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/types.Space"
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            },
            "put": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "update a exists space",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Space"
                ],
                "summary": "Update a exists space",
                "parameters": [
                    {
                        "type": "string",
                        "description": "namespace",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "name",
                        "name": "name",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "current_user",
                        "name": "current_user",
                        "in": "query",
                        "required": true
                    },
                    {
                        "description": "body",
                        "name": "body",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/types.UpdateSpaceReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.Response"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/types.Space"
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            },
            "delete": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "delete a exists space",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Space"
                ],
                "summary": "Delete a exists space",
                "parameters": [
                    {
                        "type": "string",
                        "description": "namespace",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "name",
                        "name": "name",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "current_user",
                        "name": "current_user",
                        "in": "query",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.Response"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/spaces/{namespace}/{name}/logs": {
            "get": {
                "security": [
                    {
                        "JWT token": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Space"
                ],
                "summary": "get space logs",
                "parameters": [
                    {
                        "type": "string",
                        "description": "namespace",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "name",
                        "name": "name",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "current_user",
                        "name": "current_user",
                        "in": "query",
                        "required": true
                    }
                ],
                "responses": {
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/spaces/{namespace}/{name}/run": {
            "post": {
                "security": [
                    {
                        "JWT token": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Space"
                ],
                "summary": "run space app",
                "parameters": [
                    {
                        "type": "string",
                        "description": "namespace",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "name",
                        "name": "name",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "current_user",
                        "name": "current_user",
                        "in": "query",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "string"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/spaces/{namespace}/{name}/status": {
            "get": {
                "security": [
                    {
                        "JWT token": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Space"
                ],
                "summary": "get space status",
                "parameters": [
                    {
                        "type": "string",
                        "description": "namespace",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "name",
                        "name": "name",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "current_user",
                        "name": "current_user",
                        "in": "query",
                        "required": true
                    }
                ],
                "responses": {
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/spaces/{namespace}/{name}/stop": {
            "post": {
                "security": [
                    {
                        "JWT token": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Space"
                ],
                "summary": "stop space app",
                "parameters": [
                    {
                        "type": "string",
                        "description": "namespace",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "name",
                        "name": "name",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "current_user",
                        "name": "current_user",
                        "in": "query",
                        "required": true
                    }
                ],
                "responses": {
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/spaces/{namespace}/{name}/wakeup": {
            "post": {
                "security": [
                    {
                        "JWT token": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Space"
                ],
                "summary": "wake up space app",
                "parameters": [
                    {
                        "type": "string",
                        "description": "namespace",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "name",
                        "name": "name",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/sync/client_setting": {
            "get": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "Get sync client setting",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Sync"
                ],
                "summary": "Get sync client setting",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.Response"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/database.SyncClientSetting"
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            },
            "post": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "Create sync client setting or update an existing sync client setting",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Sync"
                ],
                "summary": "Create sync client setting or update an existing sync client setting",
                "parameters": [
                    {
                        "description": "body",
                        "name": "body",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/types.CreateSyncClientSettingReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.Response"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/database.SyncClientSetting"
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/sync/version/latest": {
            "get": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Sync"
                ],
                "summary": "Get latest version",
                "parameters": [
                    {
                        "type": "string",
                        "description": "current version",
                        "name": "cur",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "current_user",
                        "name": "current_user",
                        "in": "query",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.Response"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/types.SyncVersionResponse"
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/tags": {
            "get": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "get all tags",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Tag"
                ],
                "summary": "Get all tags",
                "responses": {
                    "200": {
                        "description": "tags",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.ResponseWithTotal"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "type": "array",
                                            "items": {
                                                "$ref": "#/definitions/database.Tag"
                                            }
                                        },
                                        "total": {
                                            "type": "integer"
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/telemetry/usage": {
            "post": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Telemetry"
                ],
                "summary": "Submit telemetry data for a client",
                "parameters": [
                    {
                        "description": "body",
                        "name": "body",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/telemetry.Usage"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.Response"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/token/{app}/{token_name}": {
            "put": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Access token"
                ],
                "summary": "Refresh a access token for a user",
                "parameters": [
                    {
                        "enum": [
                            "git",
                            "starship"
                        ],
                        "type": "string",
                        "description": "application",
                        "name": "app",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "token_name",
                        "name": "token_name",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "current user, the owner",
                        "name": "current_user",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "new expire time, in format RFC3339, like 2006-01-02T15:04:05Z07:00",
                        "name": "expired_at",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.Response"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            },
            "post": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Access token"
                ],
                "summary": "Create access token for an special application",
                "parameters": [
                    {
                        "type": "string",
                        "description": "token name",
                        "name": "token_name",
                        "in": "path",
                        "required": true
                    },
                    {
                        "enum": [
                            "git",
                            "starship"
                        ],
                        "type": "string",
                        "description": "application",
                        "name": "app",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "current user, the owner",
                        "name": "current_user",
                        "in": "query",
                        "required": true
                    },
                    {
                        "description": "body",
                        "name": "body",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/types.CreateUserTokenRequest"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.Response"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/database.AccessToken"
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            },
            "delete": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Access token"
                ],
                "summary": "Delete access token of a app",
                "parameters": [
                    {
                        "enum": [
                            "git",
                            "starship"
                        ],
                        "type": "string",
                        "description": "application",
                        "name": "app",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "token_name",
                        "name": "token_name",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "current user, the owner",
                        "name": "current_user",
                        "in": "query",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.Response"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/token/{token_value}": {
            "get": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Access token"
                ],
                "summary": "Get token and owner's detail by the token value",
                "parameters": [
                    {
                        "type": "string",
                        "description": "token_value",
                        "name": "token_value",
                        "in": "path",
                        "required": true
                    },
                    {
                        "enum": [
                            "git",
                            "starship"
                        ],
                        "type": "string",
                        "description": "application",
                        "name": "app",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.Response"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/user/{username}": {
            "get": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "User"
                ],
                "summary": "Get user info. Admin and the user self can see full info, other users can only see basic info.",
                "parameters": [
                    {
                        "type": "string",
                        "description": "username or uuid, defined by the query string 'type'",
                        "name": "username",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "current user",
                        "name": "current_user",
                        "in": "query"
                    },
                    {
                        "enum": [
                            "username",
                            "uuid"
                        ],
                        "type": "string",
                        "description": "path param is usernam or uuid, default to username",
                        "name": "type",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.Response"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/types.User"
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            },
            "put": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "update user",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "User"
                ],
                "summary": "Update user. If change user name, should only send 'new_username' in the request body.",
                "parameters": [
                    {
                        "type": "string",
                        "description": "username",
                        "name": "username",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "current user",
                        "name": "current_user",
                        "in": "query",
                        "required": true
                    },
                    {
                        "description": "body",
                        "name": "body",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/types.UpdateUserRequest"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.Response"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            },
            "delete": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "User"
                ],
                "summary": "Delete user",
                "parameters": [
                    {
                        "type": "string",
                        "description": "username",
                        "name": "username",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "current user",
                        "name": "current_user",
                        "in": "query",
                        "required": true
                    },
                    {
                        "description": "body",
                        "name": "body",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/types.UpdateUserRequest"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.Response"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/user/{username}/codes": {
            "get": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "get user codes",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "User"
                ],
                "summary": "Get user codes",
                "parameters": [
                    {
                        "type": "string",
                        "description": "username",
                        "name": "username",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.ResponseWithTotal"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "type": "array",
                                            "items": {
                                                "$ref": "#/definitions/types.Code"
                                            }
                                        },
                                        "total": {
                                            "type": "integer"
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/user/{username}/collections": {
            "get": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "User"
                ],
                "summary": "Get user's collections",
                "parameters": [
                    {
                        "type": "string",
                        "description": "username",
                        "name": "username",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.ResponseWithTotal"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "type": "array",
                                            "items": {
                                                "$ref": "#/definitions/types.Collection"
                                            }
                                        },
                                        "total": {
                                            "type": "integer"
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/user/{username}/datasets": {
            "get": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "get user datasets",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "User"
                ],
                "summary": "Get user datasets",
                "parameters": [
                    {
                        "type": "string",
                        "description": "username",
                        "name": "username",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.ResponseWithTotal"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "type": "array",
                                            "items": {
                                                "$ref": "#/definitions/types.Dataset"
                                            }
                                        },
                                        "total": {
                                            "type": "integer"
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/user/{username}/finetune/instances": {
            "get": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "Get user running notebook instances",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "User"
                ],
                "summary": "Get user running notebook instances",
                "parameters": [
                    {
                        "type": "string",
                        "description": "username",
                        "name": "username",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "default": 50,
                        "description": "per",
                        "name": "per",
                        "in": "query"
                    },
                    {
                        "type": "integer",
                        "default": 1,
                        "description": "page index",
                        "name": "page",
                        "in": "query"
                    },
                    {
                        "type": "string",
                        "description": "current user",
                        "name": "current_user",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.Response"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/user/{username}/likes/codes": {
            "get": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "get user likes codes",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "User"
                ],
                "summary": "Get user likes codes",
                "parameters": [
                    {
                        "type": "string",
                        "description": "username",
                        "name": "username",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.ResponseWithTotal"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "type": "array",
                                            "items": {
                                                "$ref": "#/definitions/types.Code"
                                            }
                                        },
                                        "total": {
                                            "type": "integer"
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/user/{username}/likes/collections": {
            "get": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "User"
                ],
                "summary": "Get user likes collections",
                "parameters": [
                    {
                        "type": "string",
                        "description": "username",
                        "name": "username",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.ResponseWithTotal"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "type": "array",
                                            "items": {
                                                "$ref": "#/definitions/types.Collection"
                                            }
                                        },
                                        "total": {
                                            "type": "integer"
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/user/{username}/likes/collections/{id}": {
            "put": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "User"
                ],
                "summary": "Add collection likes",
                "parameters": [
                    {
                        "type": "string",
                        "description": "username",
                        "name": "username",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "collection id",
                        "name": "id",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.Response"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            },
            "delete": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "User"
                ],
                "summary": "delete collection likes",
                "parameters": [
                    {
                        "type": "string",
                        "description": "username",
                        "name": "username",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "collection id",
                        "name": "id",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.Response"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/user/{username}/likes/datasets": {
            "get": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "get user likes datasets",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "User"
                ],
                "summary": "Get user likes datasets",
                "parameters": [
                    {
                        "type": "string",
                        "description": "username",
                        "name": "username",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.ResponseWithTotal"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "type": "array",
                                            "items": {
                                                "$ref": "#/definitions/types.Dataset"
                                            }
                                        },
                                        "total": {
                                            "type": "integer"
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/user/{username}/likes/models": {
            "get": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "get user likes models",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "User"
                ],
                "summary": "Get user likes models",
                "parameters": [
                    {
                        "type": "string",
                        "description": "username",
                        "name": "username",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.ResponseWithTotal"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "type": "array",
                                            "items": {
                                                "$ref": "#/definitions/types.Model"
                                            }
                                        },
                                        "total": {
                                            "type": "integer"
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/user/{username}/likes/spaces": {
            "get": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "User"
                ],
                "summary": "Get user likes spaces",
                "parameters": [
                    {
                        "type": "string",
                        "description": "username",
                        "name": "username",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.ResponseWithTotal"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "type": "array",
                                            "items": {
                                                "$ref": "#/definitions/types.Space"
                                            }
                                        },
                                        "total": {
                                            "type": "integer"
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/user/{username}/likes/{repoid}": {
            "put": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "User"
                ],
                "summary": "Add user likes",
                "parameters": [
                    {
                        "type": "string",
                        "description": "username",
                        "name": "username",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "repo id",
                        "name": "repo_id",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.Response"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            },
            "delete": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "Delete user likes",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "User"
                ],
                "summary": "Delete user likes",
                "parameters": [
                    {
                        "type": "string",
                        "description": "username",
                        "name": "username",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "repo id",
                        "name": "repo_id",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.Response"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/user/{username}/models": {
            "get": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "get user models",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "User"
                ],
                "summary": "Get user models",
                "parameters": [
                    {
                        "type": "string",
                        "description": "username",
                        "name": "username",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.ResponseWithTotal"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "type": "array",
                                            "items": {
                                                "$ref": "#/definitions/types.Model"
                                            }
                                        },
                                        "total": {
                                            "type": "integer"
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/user/{username}/prompts": {
            "get": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "get user prompts",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "User"
                ],
                "summary": "Get user prompts",
                "parameters": [
                    {
                        "type": "string",
                        "description": "username",
                        "name": "username",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "default": 20,
                        "description": "per",
                        "name": "per",
                        "in": "query"
                    },
                    {
                        "type": "integer",
                        "default": 1,
                        "description": "per page",
                        "name": "page",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.Response"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/user/{username}/run/serverless": {
            "get": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "Get serverless deploys",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "User"
                ],
                "summary": "Get serverless deploys",
                "parameters": [
                    {
                        "type": "string",
                        "description": "username",
                        "name": "username",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "default": 50,
                        "description": "per",
                        "name": "per",
                        "in": "query"
                    },
                    {
                        "type": "integer",
                        "default": 1,
                        "description": "page index",
                        "name": "page",
                        "in": "query"
                    },
                    {
                        "type": "string",
                        "description": "current user",
                        "name": "current_user",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.Response"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/user/{username}/run/{repo_type}": {
            "get": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "Get user running deploys",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "User"
                ],
                "summary": "Get user running deploys",
                "parameters": [
                    {
                        "type": "string",
                        "description": "username",
                        "name": "username",
                        "in": "path",
                        "required": true
                    },
                    {
                        "enum": [
                            "model",
                            "space"
                        ],
                        "type": "string",
                        "description": "model,space",
                        "name": "repo_type",
                        "in": "path",
                        "required": true
                    },
                    {
                        "enum": [
                            0,
                            1,
                            2
                        ],
                        "type": "integer",
                        "default": 1,
                        "description": "deploy type(0-space,1-inference,2-finetune)",
                        "name": "deploy_type",
                        "in": "query"
                    },
                    {
                        "type": "integer",
                        "default": 50,
                        "description": "per",
                        "name": "per",
                        "in": "query"
                    },
                    {
                        "type": "integer",
                        "default": 1,
                        "description": "page index",
                        "name": "page",
                        "in": "query"
                    },
                    {
                        "type": "string",
                        "description": "current user",
                        "name": "current_user",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.Response"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/user/{username}/spaces": {
            "get": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "User"
                ],
                "summary": "Get user spaces",
                "parameters": [
                    {
                        "type": "string",
                        "description": "username",
                        "name": "username",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.ResponseWithTotal"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "type": "array",
                                            "items": {
                                                "$ref": "#/definitions/types.Space"
                                            }
                                        },
                                        "total": {
                                            "type": "integer"
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/user/{username}/ssh_key/{name}": {
            "delete": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "delete specific SSH key for the given user",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "SSH Key"
                ],
                "summary": "Delete specific SSH key for the given user",
                "parameters": [
                    {
                        "type": "string",
                        "description": "username",
                        "name": "username",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "key name",
                        "name": "name",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.Response"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/user/{username}/ssh_keys": {
            "get": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "get all SSH keys for the given user",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "SSH Key"
                ],
                "summary": "Get all SSH keys for the given user",
                "parameters": [
                    {
                        "type": "string",
                        "description": "username",
                        "name": "username",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.ResponseWithTotal"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "type": "array",
                                            "items": {
                                                "$ref": "#/definitions/database.SSHKey"
                                            }
                                        },
                                        "total": {
                                            "type": "integer"
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            },
            "post": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "create a new SSH key for the given user",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "SSH Key"
                ],
                "summary": "Create a new SSH key for the given user",
                "parameters": [
                    {
                        "type": "string",
                        "description": "username",
                        "name": "username",
                        "in": "path",
                        "required": true
                    },
                    {
                        "description": "body",
                        "name": "body",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/types.CreateSSHKeyRequest"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.Response"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/database.SSHKey"
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/user/{username}/tokens": {
            "get": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Access token"
                ],
                "summary": "Get all access tokens for a user",
                "parameters": [
                    {
                        "type": "string",
                        "description": "username",
                        "name": "username",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "current user name",
                        "name": "current_user",
                        "in": "query"
                    },
                    {
                        "enum": [
                            "git",
                            "starship"
                        ],
                        "type": "string",
                        "description": "application",
                        "name": "app",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.Response"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            },
            "post": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "create access token for a user",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Access token"
                ],
                "summary": "[Deprecated: use POST:/token/{app}/{username} instead]",
                "parameters": [
                    {
                        "type": "string",
                        "description": "username",
                        "name": "username",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "current user, the owner",
                        "name": "current_user",
                        "in": "query",
                        "required": true
                    },
                    {
                        "description": "body",
                        "name": "body",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/types.CreateUserTokenRequest"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.Response"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/database.AccessToken"
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/user/{username}/tokens/{token_name}": {
            "delete": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Access token"
                ],
                "summary": "[Deprecated: use DELETE:/token/{app}/{token_name} instead]",
                "parameters": [
                    {
                        "type": "string",
                        "description": "username",
                        "name": "username",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "token_name",
                        "name": "token_name",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "current user, the owner",
                        "name": "current_user",
                        "in": "query",
                        "required": true
                    },
                    {
                        "description": "body",
                        "name": "body",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/types.DeleteUserTokenRequest"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.Response"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/users": {
            "get": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "User"
                ],
                "summary": "Get users info. Only Admin",
                "parameters": [
                    {
                        "type": "string",
                        "description": "search",
                        "name": "search",
                        "in": "query",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.Response"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "type": "array",
                                            "items": {
                                                "$ref": "#/definitions/types.User"
                                            }
                                        },
                                        "total": {
                                            "type": "integer"
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/{repo_type}/{namespace}/{name}/blob/{file_path}": {
            "get": {
                "security": [
                    {
                        "ApiKey or JWT": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Repository"
                ],
                "summary": "Get the repo file information like size, content, sha etc",
                "parameters": [
                    {
                        "enum": [
                            "models",
                            "datasets",
                            "codes",
                            "spaces"
                        ],
                        "type": "string",
                        "description": "models,dataset,codes or spaces",
                        "name": "repo_type",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "repo owner name",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "repo name",
                        "name": "name",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "file path",
                        "name": "file_path",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "branch or tag",
                        "name": "ref",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "current user name",
                        "name": "current_user",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.ResponseWithTotal"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/types.File"
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/{repo_type}/{namespace}/{name}/branches": {
            "get": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Repository"
                ],
                "summary": "Get the branches of repository",
                "parameters": [
                    {
                        "enum": [
                            "models",
                            "datasets",
                            "codes",
                            "spaces"
                        ],
                        "type": "string",
                        "description": "models,dataset,codes or spaces",
                        "name": "repo_type",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "repo owner name",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "repo name",
                        "name": "name",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "branch or tag",
                        "name": "ref",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "current user name",
                        "name": "current_user",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.ResponseWithTotal"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "type": "array",
                                            "items": {
                                                "$ref": "#/definitions/types.Branch"
                                            }
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/{repo_type}/{namespace}/{name}/commit/{commit_id}": {
            "get": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Repository"
                ],
                "summary": "Get commit diff of repository and data field of response need to be decode with base64",
                "parameters": [
                    {
                        "enum": [
                            "models",
                            "datasets",
                            "codes",
                            "spaces"
                        ],
                        "type": "string",
                        "description": "models,datasets,codes or spaces",
                        "name": "repo_type",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "repo owner name",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "repo name",
                        "name": "name",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "commit id",
                        "name": "commit_id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "current user name",
                        "name": "current_user",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.Response"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/types.CommitResponse"
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/{repo_type}/{namespace}/{name}/commits": {
            "get": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Repository"
                ],
                "summary": "Get all commits of repository",
                "parameters": [
                    {
                        "enum": [
                            "models",
                            "datasets",
                            "codes",
                            "spaces"
                        ],
                        "type": "string",
                        "description": "models,dataset,codes or spaces",
                        "name": "repo_type",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "repo owner name",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "repo name",
                        "name": "name",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "branch or tag",
                        "name": "ref",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "current user name",
                        "name": "current_user",
                        "in": "query"
                    },
                    {
                        "type": "integer",
                        "default": 20,
                        "description": "per",
                        "name": "per",
                        "in": "query"
                    },
                    {
                        "type": "integer",
                        "default": 1,
                        "description": "per page",
                        "name": "page",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.ResponseWithTotal"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "type": "array",
                                            "items": {
                                                "$ref": "#/definitions/types.Commit"
                                            }
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/{repo_type}/{namespace}/{name}/discussions": {
            "get": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "list repo discussions",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Discussion"
                ],
                "summary": "List repo discussions",
                "parameters": [
                    {
                        "type": "string",
                        "description": "current user",
                        "name": "current_user",
                        "in": "query"
                    },
                    {
                        "enum": [
                            "models",
                            "datasets",
                            "codes",
                            "spaces"
                        ],
                        "type": "string",
                        "description": "repository type",
                        "name": "repo_type",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "namespace",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "name",
                        "name": "name",
                        "in": "query",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.Response"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/component.ListRepoDiscussionResponse"
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            },
            "post": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "create a new repo discussion",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Discussion"
                ],
                "summary": "Create a new repo discussion",
                "parameters": [
                    {
                        "type": "string",
                        "description": "current user, the owner",
                        "name": "current_user",
                        "in": "query",
                        "required": true
                    },
                    {
                        "enum": [
                            "models",
                            "datasets",
                            "codes",
                            "spaces"
                        ],
                        "type": "string",
                        "description": "repository type",
                        "name": "repo_type",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "namespace",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "name",
                        "name": "name",
                        "in": "path",
                        "required": true
                    },
                    {
                        "description": "body",
                        "name": "body",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/component.CreateRepoDiscussionRequest"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.Response"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/component.CreateDiscussionResponse"
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/{repo_type}/{namespace}/{name}/download/{file_path}": {
            "get": {
                "security": [
                    {
                        "ApiKey or JWT": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Repository"
                ],
                "summary": "Download a repo file [Depricated: use 'resolve' api instead]",
                "parameters": [
                    {
                        "enum": [
                            "models",
                            "datasets",
                            "codes",
                            "spaces"
                        ],
                        "type": "string",
                        "description": "models,dataset,codes or spaces",
                        "name": "repo_type",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "repo owner name",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "repo name",
                        "name": "name",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "file path",
                        "name": "file_path",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "branch or tag",
                        "name": "ref",
                        "in": "query"
                    },
                    {
                        "type": "string",
                        "description": "file name to save as",
                        "name": "save_as",
                        "in": "query"
                    },
                    {
                        "type": "string",
                        "description": "current user name",
                        "name": "current_user",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.ResponseWithTotal"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "type": "object"
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/{repo_type}/{namespace}/{name}/incr_downloads": {
            "put": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Repository"
                ],
                "summary": "Increase repo download count by 1",
                "parameters": [
                    {
                        "enum": [
                            "models",
                            "datasets",
                            "codes",
                            "spaces"
                        ],
                        "type": "string",
                        "description": "models,dataset,codes or spaces",
                        "name": "repo_type",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "repo owner name",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "repo name",
                        "name": "name",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.Response"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/{repo_type}/{namespace}/{name}/last_commit": {
            "get": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Repository"
                ],
                "summary": "Get the last commit of repository",
                "parameters": [
                    {
                        "enum": [
                            "models",
                            "datasets",
                            "codes",
                            "spaces"
                        ],
                        "type": "string",
                        "description": "models,dataset,codes or spaces",
                        "name": "repo_type",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "repo owner name",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "repo name",
                        "name": "name",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "branch or tag",
                        "name": "ref",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "current user name",
                        "name": "current_user",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.ResponseWithTotal"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/types.Commit"
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/{repo_type}/{namespace}/{name}/mirror": {
            "get": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Repository"
                ],
                "summary": "Get a mirror",
                "parameters": [
                    {
                        "enum": [
                            "models",
                            "datasets",
                            "codes",
                            "spaces"
                        ],
                        "type": "string",
                        "description": "models,datasets,codes or spaces",
                        "name": "repo_type",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "repo owner name",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "repo name",
                        "name": "name",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "current_user",
                        "name": "current_user",
                        "in": "query",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.Response"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/database.Mirror"
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            },
            "put": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Repository"
                ],
                "summary": "Update a mirror for a existing repository",
                "parameters": [
                    {
                        "enum": [
                            "models",
                            "datasets",
                            "codes",
                            "spaces"
                        ],
                        "type": "string",
                        "description": "models,datasets,codes or spaces",
                        "name": "repo_type",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "repo owner name",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "repo name",
                        "name": "name",
                        "in": "path",
                        "required": true
                    },
                    {
                        "description": "body",
                        "name": "body",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/types.UpdateMirrorParams"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.Response"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/database.Mirror"
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            },
            "post": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Repository"
                ],
                "summary": "Create mirror for a existing repository",
                "parameters": [
                    {
                        "enum": [
                            "models",
                            "datasets",
                            "codes",
                            "spaces"
                        ],
                        "type": "string",
                        "description": "models,datasets,codes or spaces",
                        "name": "repo_type",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "repo owner name",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "repo name",
                        "name": "name",
                        "in": "path",
                        "required": true
                    },
                    {
                        "description": "body",
                        "name": "body",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/types.CreateMirrorParams"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.Response"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/database.Mirror"
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            },
            "delete": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Repository"
                ],
                "summary": "Delete a mirror",
                "parameters": [
                    {
                        "enum": [
                            "models",
                            "datasets",
                            "codes",
                            "spaces"
                        ],
                        "type": "string",
                        "description": "models,datasets,codes or spaces",
                        "name": "repo_type",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "repo owner name",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "repo name",
                        "name": "name",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.Response"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/{repo_type}/{namespace}/{name}/mirror/sync": {
            "post": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Repository"
                ],
                "summary": "Triggers the mirror synchronization",
                "parameters": [
                    {
                        "enum": [
                            "models",
                            "datasets",
                            "codes",
                            "spaces"
                        ],
                        "type": "string",
                        "description": "models,datasets,codes or spaces",
                        "name": "repo_type",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "repo owner name",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "repo name",
                        "name": "name",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.Response"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/{repo_type}/{namespace}/{name}/mirror_from_saas": {
            "post": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Repository"
                ],
                "summary": "Mirror repo from OpenCSG Saas(only on-premises)",
                "parameters": [
                    {
                        "enum": [
                            "models",
                            "datasets",
                            "codes",
                            "spaces"
                        ],
                        "type": "string",
                        "description": "models,datasets,codes or spaces",
                        "name": "repo_type",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "repo owner name",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "repo name",
                        "name": "name",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.Response"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/database.Mirror"
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/{repo_type}/{namespace}/{name}/raw/{file_path}": {
            "get": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Repository"
                ],
                "summary": "Get the last commit of repository",
                "parameters": [
                    {
                        "enum": [
                            "models",
                            "datasets",
                            "codes",
                            "spaces"
                        ],
                        "type": "string",
                        "description": "models,dataset,codes or spaces",
                        "name": "repo_type",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "repo owner name",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "repo name",
                        "name": "name",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "file path",
                        "name": "file_path",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "branch or tag",
                        "name": "ref",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "current user name",
                        "name": "current_user",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.ResponseWithTotal"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "type": "string"
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            },
            "put": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Repository"
                ],
                "summary": "Update existing file in repository",
                "parameters": [
                    {
                        "enum": [
                            "models",
                            "datasets",
                            "codes",
                            "spaces"
                        ],
                        "type": "string",
                        "description": "models,dataset,codes or spaces",
                        "name": "repo_type",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "repo owner name",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "repo name",
                        "name": "name",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "the new file relative path",
                        "name": "file_path",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "current user name",
                        "name": "current_user",
                        "in": "query"
                    },
                    {
                        "description": "create file request",
                        "name": "req",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/types.UpdateFileReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.ResponseWithTotal"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/types.UpdateFileResp"
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            },
            "post": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Repository"
                ],
                "summary": "Create a new file in repository",
                "parameters": [
                    {
                        "enum": [
                            "models",
                            "datasets",
                            "codes",
                            "spaces"
                        ],
                        "type": "string",
                        "description": "models,dataset,codes or spaces",
                        "name": "repo_type",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "repo owner name",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "repo name",
                        "name": "name",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "the new file relative path",
                        "name": "file_path",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "current user name",
                        "name": "current_user",
                        "in": "query"
                    },
                    {
                        "description": "create file request",
                        "name": "req",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/types.CreateFileReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.ResponseWithTotal"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/types.CreateFileResp"
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/{repo_type}/{namespace}/{name}/resolve/{file_path}": {
            "get": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Repository"
                ],
                "summary": "Download a rep file",
                "parameters": [
                    {
                        "enum": [
                            "models",
                            "datasets",
                            "codes",
                            "spaces"
                        ],
                        "type": "string",
                        "description": "models,dataset,codes or spaces",
                        "name": "repo_type",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "repo owner name",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "repo name",
                        "name": "name",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "file path",
                        "name": "file_path",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "branch or tag",
                        "name": "ref",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "current user name",
                        "name": "current_user",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.ResponseWithTotal"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "type": "string"
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/{repo_type}/{namespace}/{name}/run": {
            "get": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "List repo deploys",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Repository"
                ],
                "summary": "List repo deploys",
                "parameters": [
                    {
                        "enum": [
                            "models",
                            "spaces"
                        ],
                        "type": "string",
                        "description": "models,spaces",
                        "name": "repo_type",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "namespace",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "name",
                        "name": "name",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "current user",
                        "name": "current_user",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "string"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/{repo_type}/{namespace}/{name}/run/{id}": {
            "get": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "Get repo deploy detail",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Repository"
                ],
                "summary": "Get repo deploy detail",
                "parameters": [
                    {
                        "enum": [
                            "models",
                            "spaces"
                        ],
                        "type": "string",
                        "description": "models,spaces",
                        "name": "repo_type",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "namespace",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "name",
                        "name": "name",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "id",
                        "name": "id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "current user",
                        "name": "current_user",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "string"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "401": {
                        "description": "Permission denied",
                        "schema": {
                            "$ref": "#/definitions/types.APIUnauthorized"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            },
            "put": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Repository"
                ],
                "summary": "Update deploy parameters",
                "parameters": [
                    {
                        "enum": [
                            "models"
                        ],
                        "type": "string",
                        "description": "models",
                        "name": "repo_type",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "namespace",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "name",
                        "name": "name",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "deploy id",
                        "name": "id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "current_user",
                        "name": "current_user",
                        "in": "query",
                        "required": true
                    },
                    {
                        "description": "deploy setting of inference",
                        "name": "body",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/types.DeployUpdateReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.Response"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/{repo_type}/{namespace}/{name}/run/{id}/logs/{instance}": {
            "get": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Repository"
                ],
                "summary": "get deploy instance logs",
                "parameters": [
                    {
                        "enum": [
                            "models",
                            "spaces"
                        ],
                        "type": "string",
                        "description": "models,spaces",
                        "name": "repo_type",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "namespace",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "name",
                        "name": "name",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "id",
                        "name": "id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "instance",
                        "name": "instance",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "current_user",
                        "name": "current_user",
                        "in": "query",
                        "required": true
                    }
                ],
                "responses": {
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "401": {
                        "description": "Permission denied",
                        "schema": {
                            "$ref": "#/definitions/types.APIUnauthorized"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/{repo_type}/{namespace}/{name}/run/{id}/status": {
            "get": {
                "security": [
                    {
                        "JWT token": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Repository"
                ],
                "summary": "get deploy status",
                "parameters": [
                    {
                        "enum": [
                            "models",
                            "spaces"
                        ],
                        "type": "string",
                        "description": "models,spaces",
                        "name": "repo_type",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "namespace",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "name",
                        "name": "name",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "deploy id",
                        "name": "id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "current_user",
                        "name": "current_user",
                        "in": "query",
                        "required": true
                    }
                ],
                "responses": {
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "401": {
                        "description": "Permission denied",
                        "schema": {
                            "$ref": "#/definitions/types.APIUnauthorized"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/{repo_type}/{namespace}/{name}/runtime_framework": {
            "get": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "List repo runtime framework",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Repository"
                ],
                "summary": "List repo runtime framework",
                "parameters": [
                    {
                        "enum": [
                            "models",
                            "spaces"
                        ],
                        "type": "string",
                        "description": "models,spaces",
                        "name": "repo_type",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "namespace",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "name",
                        "name": "name",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "current user",
                        "name": "current_user",
                        "in": "query"
                    },
                    {
                        "enum": [
                            0,
                            1,
                            2
                        ],
                        "type": "integer",
                        "default": 1,
                        "description": "deploy_type",
                        "name": "deploy_type",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "string"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            },
            "post": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "create runtime framework",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Repository"
                ],
                "summary": "Create runtime framework",
                "parameters": [
                    {
                        "enum": [
                            "models",
                            "spaces"
                        ],
                        "type": "string",
                        "description": "models,spaces",
                        "name": "repo_type",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "namespace",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "name",
                        "name": "name",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "current user",
                        "name": "current_user",
                        "in": "query"
                    },
                    {
                        "description": "body",
                        "name": "body",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/types.RuntimeFrameworkReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.RuntimeFramework"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/{repo_type}/{namespace}/{name}/runtime_framework/{id}": {
            "put": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "Update runtime framework",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Repository"
                ],
                "summary": "Update runtime framework",
                "parameters": [
                    {
                        "enum": [
                            "models",
                            "spaces"
                        ],
                        "type": "string",
                        "description": "models,spaces",
                        "name": "repo_type",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "namespace",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "name",
                        "name": "name",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "id",
                        "name": "id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "current user",
                        "name": "current_user",
                        "in": "query"
                    },
                    {
                        "description": "body",
                        "name": "body",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/types.RuntimeFrameworkReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.RuntimeFramework"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            },
            "delete": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "description": "delete a exist RuntimeFramework",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Repository"
                ],
                "summary": "Delete a exist RuntimeFramework",
                "parameters": [
                    {
                        "enum": [
                            "models",
                            "spaces"
                        ],
                        "type": "string",
                        "description": "models,spaces",
                        "name": "repo_type",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "namespace",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "name",
                        "name": "name",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "id",
                        "name": "id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "current user",
                        "name": "current_user",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.Response"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/{repo_type}/{namespace}/{name}/tags": {
            "get": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Repository"
                ],
                "summary": "Get the tags of repository",
                "parameters": [
                    {
                        "enum": [
                            "models",
                            "datasets",
                            "codes",
                            "spaces"
                        ],
                        "type": "string",
                        "description": "models,dataset,codes or spaces",
                        "name": "repo_type",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "repo owner name",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "repo name",
                        "name": "name",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "current user name",
                        "name": "current_user",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.ResponseWithTotal"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "type": "array",
                                            "items": {
                                                "$ref": "#/definitions/database.Tag"
                                            }
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/{repo_type}/{namespace}/{name}/tags/{category}": {
            "post": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Repository"
                ],
                "summary": "update the tags of a certain category",
                "parameters": [
                    {
                        "enum": [
                            "models",
                            "datasets",
                            "codes",
                            "spaces"
                        ],
                        "type": "string",
                        "description": "models,dataset,codes or spaces",
                        "name": "repo_type",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "repo owner name",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "repo name",
                        "name": "name",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "current user name",
                        "name": "current_user",
                        "in": "query",
                        "required": true
                    },
                    {
                        "enum": [
                            "task",
                            "license",
                            "framework",
                            "language",
                            "industry"
                        ],
                        "type": "string",
                        "description": "tag category",
                        "name": "category",
                        "in": "path",
                        "required": true
                    },
                    {
                        "description": "tag names in array",
                        "name": "tags",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "type": "array",
                            "items": {
                                "type": "string"
                            }
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.Response"
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        },
        "/{repo_type}/{namespace}/{name}/tree": {
            "get": {
                "security": [
                    {
                        "ApiKey": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Repository"
                ],
                "summary": "Get repository file tree",
                "parameters": [
                    {
                        "enum": [
                            "models",
                            "datasets",
                            "codes",
                            "spaces"
                        ],
                        "type": "string",
                        "description": "models,dataset,codes or spaces",
                        "name": "repo_type",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "repo owner name",
                        "name": "namespace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "repo name",
                        "name": "name",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "root dir",
                        "name": "path",
                        "in": "query"
                    },
                    {
                        "type": "string",
                        "description": "branch or tag",
                        "name": "ref",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/types.ResponseWithTotal"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "type": "array",
                                            "items": {
                                                "$ref": "#/definitions/types.File"
                                            }
                                        }
                                    }
                                }
                            ]
                        }
                    },
                    "400": {
                        "description": "Bad request",
                        "schema": {
                            "$ref": "#/definitions/types.APIBadRequest"
                        }
                    },
                    "500": {
                        "description": "Internal server error",
                        "schema": {
                            "$ref": "#/definitions/types.APIInternalServerError"
                        }
                    }
                }
            }
        }
    },
    "definitions": {
        "component.CreateCommentRequest": {
            "type": "object",
            "required": [
                "content"
            ],
            "properties": {
                "commentable_id": {
                    "type": "integer"
                },
                "commentable_type": {
                    "type": "string"
                },
                "content": {
                    "type": "string"
                }
            }
        },
        "component.CreateCommentResponse": {
            "type": "object",
            "properties": {
                "commentable_id": {
                    "type": "integer"
                },
                "commentable_type": {
                    "type": "string"
                },
                "created_at": {
                    "type": "string"
                },
                "id": {
                    "type": "integer"
                },
                "user": {
                    "$ref": "#/definitions/component.DiscussionResponse_User"
                }
            }
        },
        "component.CreateDiscussionResponse": {
            "type": "object",
            "properties": {
                "comment_count": {
                    "description": "DiscussionableID   int64     ` + "`" + `json:\"discussionable_id\"` + "`" + `\nDiscussionableType string    ` + "`" + `json:\"discussionable_type\"` + "`" + `",
                    "type": "integer"
                },
                "created_at": {
                    "type": "string"
                },
                "id": {
                    "type": "integer"
                },
                "title": {
                    "type": "string"
                },
                "user": {
                    "$ref": "#/definitions/component.DiscussionResponse_User"
                }
            }
        },
        "component.CreateRepoDiscussionRequest": {
            "type": "object",
            "required": [
                "title"
            ],
            "properties": {
                "title": {
                    "type": "string"
                }
            }
        },
        "component.DiscussionResponse_Comment": {
            "type": "object",
            "properties": {
                "content": {
                    "type": "string"
                },
                "created_at": {
                    "type": "string"
                },
                "id": {
                    "type": "integer"
                },
                "user": {
                    "$ref": "#/definitions/component.DiscussionResponse_User"
                }
            }
        },
        "component.DiscussionResponse_User": {
            "type": "object",
            "properties": {
                "avatar": {
                    "type": "string"
                },
                "id": {
                    "type": "integer"
                },
                "name": {
                    "type": "string"
                }
            }
        },
        "component.ListRepoDiscussionResponse": {
            "type": "object",
            "properties": {
                "discussions": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/component.CreateDiscussionResponse"
                    }
                }
            }
        },
        "component.ShowDiscussionResponse": {
            "type": "object",
            "properties": {
                "comment_count": {
                    "type": "integer"
                },
                "comments": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/component.DiscussionResponse_Comment"
                    }
                },
                "id": {
                    "type": "integer"
                },
                "title": {
                    "type": "string"
                },
                "user": {
                    "$ref": "#/definitions/component.DiscussionResponse_User"
                }
            }
        },
        "component.UpdateCommentRequest": {
            "type": "object",
            "required": [
                "content"
            ],
            "properties": {
                "content": {
                    "type": "string"
                }
            }
        },
        "component.UpdateDiscussionRequest": {
            "type": "object",
            "required": [
                "title"
            ],
            "properties": {
                "title": {
                    "type": "string"
                }
            }
        },
        "database.AccessToken": {
            "type": "object",
            "properties": {
                "application": {
                    "description": "example: csghub, starship",
                    "allOf": [
                        {
                            "$ref": "#/definitions/types.AccessTokenApp"
                        }
                    ]
                },
                "created_at": {
                    "type": "string"
                },
                "expired_at": {
                    "type": "string"
                },
                "git_id": {
                    "type": "integer"
                },
                "id": {
                    "type": "integer"
                },
                "is_active": {
                    "type": "boolean"
                },
                "name": {
                    "type": "string"
                },
                "permission": {
                    "type": "string"
                },
                "token": {
                    "type": "string"
                },
                "updated_at": {
                    "type": "string"
                },
                "user": {
                    "$ref": "#/definitions/database.User"
                },
                "user_id": {
                    "type": "integer"
                }
            }
        },
        "database.Code": {
            "type": "object",
            "properties": {
                "created_at": {
                    "type": "string"
                },
                "id": {
                    "type": "integer"
                },
                "last_updated_at": {
                    "type": "string"
                },
                "repository": {
                    "$ref": "#/definitions/database.Repository"
                },
                "repository_id": {
                    "type": "integer"
                },
                "updated_at": {
                    "type": "string"
                }
            }
        },
        "database.Collection": {
            "type": "object",
            "properties": {
                "created_at": {
                    "type": "string"
                },
                "description": {
                    "type": "string"
                },
                "id": {
                    "type": "integer"
                },
                "likes": {
                    "type": "integer"
                },
                "name": {
                    "type": "string"
                },
                "namespace": {
                    "type": "string"
                },
                "nickname": {
                    "type": "string"
                },
                "private": {
                    "type": "boolean"
                },
                "repositories": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/database.Repository"
                    }
                },
                "theme": {
                    "type": "string"
                },
                "updated_at": {
                    "type": "string"
                },
                "user_id": {
                    "type": "integer"
                },
                "username": {
                    "type": "string"
                }
            }
        },
        "database.Dataset": {
            "type": "object",
            "properties": {
                "created_at": {
                    "type": "string"
                },
                "id": {
                    "type": "integer"
                },
                "repository": {
                    "$ref": "#/definitions/database.Repository"
                },
                "repository_id": {
                    "type": "integer"
                },
                "updated_at": {
                    "type": "string"
                }
            }
        },
        "database.Mirror": {
            "type": "object",
            "properties": {
                "created_at": {
                    "type": "string"
                },
                "id": {
                    "type": "integer"
                },
                "interval": {
                    "type": "string"
                },
                "last_message": {
                    "type": "string"
                },
                "last_updated_at": {
                    "type": "string"
                },
                "local_repo_path": {
                    "type": "string"
                },
                "mirror_source": {
                    "$ref": "#/definitions/database.MirrorSource"
                },
                "mirror_source_id": {
                    "type": "integer"
                },
                "mirror_task_id": {
                    "type": "integer"
                },
                "next_execution_timestamp": {
                    "type": "string"
                },
                "priority": {
                    "$ref": "#/definitions/types.MirrorPriority"
                },
                "progress": {
                    "type": "integer"
                },
                "push_mirror_created": {
                    "type": "boolean"
                },
                "repository": {
                    "$ref": "#/definitions/database.Repository"
                },
                "repository_id": {
                    "type": "integer"
                },
                "source_repo_path": {
                    "type": "string"
                },
                "source_url": {
                    "type": "string"
                },
                "status": {
                    "$ref": "#/definitions/types.MirrorTaskStatus"
                },
                "updated_at": {
                    "type": "string"
                }
            }
        },
        "database.MirrorSource": {
            "type": "object",
            "properties": {
                "created_at": {
                    "type": "string"
                },
                "id": {
                    "type": "integer"
                },
                "info_api_url": {
                    "type": "string"
                },
                "source_name": {
                    "type": "string"
                },
                "updated_at": {
                    "type": "string"
                }
            }
        },
        "database.Model": {
            "type": "object",
            "properties": {
                "base_model": {
                    "type": "string"
                },
                "created_at": {
                    "type": "string"
                },
                "id": {
                    "type": "integer"
                },
                "last_updated_at": {
                    "type": "string"
                },
                "repository": {
                    "$ref": "#/definitions/database.Repository"
                },
                "repository_id": {
                    "type": "integer"
                },
                "updated_at": {
                    "type": "string"
                }
            }
        },
        "database.Namespace": {
            "type": "object",
            "properties": {
                "created_at": {
                    "type": "string"
                },
                "id": {
                    "type": "integer"
                },
                "mirrored": {
                    "type": "boolean"
                },
                "namespace_type": {
                    "$ref": "#/definitions/database.NamespaceType"
                },
                "path": {
                    "type": "string"
                },
                "updated_at": {
                    "type": "string"
                },
                "user": {
                    "$ref": "#/definitions/database.User"
                },
                "user_id": {
                    "type": "integer"
                }
            }
        },
        "database.NamespaceType": {
            "type": "string",
            "enum": [
                "user",
                "organization"
            ],
            "x-enum-varnames": [
                "UserNamespace",
                "OrgNamespace"
            ]
        },
        "database.Organization": {
            "type": "object",
            "properties": {
                "created_at": {
                    "type": "string"
                },
                "description": {
                    "type": "string"
                },
                "git_path": {
                    "type": "string"
                },
                "homepage": {
                    "type": "string"
                },
                "id": {
                    "type": "integer"
                },
                "logo": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                },
                "namespace": {
                    "$ref": "#/definitions/database.Namespace"
                },
                "namespace_id": {
                    "type": "integer"
                },
                "org_type": {
                    "type": "string"
                },
                "path": {
                    "description": "unique name of the organization",
                    "type": "string"
                },
                "updated_at": {
                    "type": "string"
                },
                "user": {
                    "$ref": "#/definitions/database.User"
                },
                "user_id": {
                    "type": "integer"
                },
                "verified": {
                    "type": "boolean"
                }
            }
        },
        "database.Repository": {
            "type": "object",
            "properties": {
                "created_at": {
                    "type": "string"
                },
                "default_branch": {
                    "type": "string"
                },
                "description": {
                    "type": "string"
                },
                "download_count": {
                    "type": "integer"
                },
                "downloads": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/database.RepositoryDownload"
                    }
                },
                "git_path": {
                    "type": "string"
                },
                "http_clone_url": {
                    "type": "string"
                },
                "id": {
                    "type": "integer"
                },
                "labels": {
                    "description": "Depreated",
                    "type": "string"
                },
                "license": {
                    "type": "string"
                },
                "likes": {
                    "type": "integer"
                },
                "mirror": {
                    "$ref": "#/definitions/database.Mirror"
                },
                "name": {
                    "type": "string"
                },
                "nickname": {
                    "type": "string"
                },
                "path": {
                    "type": "string"
                },
                "private": {
                    "type": "boolean"
                },
                "readme": {
                    "description": "Depreated",
                    "type": "string"
                },
                "repository_type": {
                    "$ref": "#/definitions/types.RepositoryType"
                },
                "sensitive_check_status": {
                    "$ref": "#/definitions/types.SensitiveCheckStatus"
                },
                "source": {
                    "$ref": "#/definitions/types.RepositorySource"
                },
                "ssh_clone_url": {
                    "type": "string"
                },
                "sync_status": {
                    "$ref": "#/definitions/types.RepositorySyncStatus"
                },
                "tags": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/database.Tag"
                    }
                },
                "updated_at": {
                    "type": "string"
                },
                "user": {
                    "$ref": "#/definitions/database.User"
                },
                "user_id": {
                    "type": "integer"
                }
            }
        },
        "database.RepositoryDownload": {
            "type": "object",
            "properties": {
                "click_download_count": {
                    "type": "integer"
                },
                "created_at": {
                    "type": "string"
                },
                "date": {
                    "type": "string"
                },
                "id": {
                    "type": "integer"
                },
                "repository": {
                    "$ref": "#/definitions/database.Repository"
                },
                "repository_id": {
                    "type": "integer"
                },
                "updated_at": {
                    "type": "string"
                },
                "user_id": {
                    "type": "integer"
                }
            }
        },
        "database.SSHKey": {
            "type": "object",
            "properties": {
                "content": {
                    "type": "string"
                },
                "created_at": {
                    "type": "string"
                },
                "fingerprint_sha256": {
                    "type": "string"
                },
                "git_id": {
                    "type": "integer"
                },
                "id": {
                    "type": "integer"
                },
                "name": {
                    "type": "string"
                },
                "updated_at": {
                    "type": "string"
                },
                "user": {
                    "$ref": "#/definitions/database.User"
                },
                "user_id": {
                    "type": "integer"
                }
            }
        },
        "database.SyncClientSetting": {
            "type": "object",
            "properties": {
                "concurrent_count": {
                    "type": "integer"
                },
                "created_at": {
                    "type": "string"
                },
                "default": {
                    "type": "boolean"
                },
                "id": {
                    "type": "integer"
                },
                "max_bandwidth": {
                    "type": "integer"
                },
                "token": {
                    "type": "string"
                },
                "updated_at": {
                    "type": "string"
                }
            }
        },
        "database.Tag": {
            "type": "object",
            "properties": {
                "built_in": {
                    "type": "boolean"
                },
                "category": {
                    "type": "string"
                },
                "created_at": {
                    "type": "string"
                },
                "group": {
                    "type": "string"
                },
                "id": {
                    "type": "integer"
                },
                "name": {
                    "type": "string"
                },
                "scope": {
                    "$ref": "#/definitions/database.TagScope"
                },
                "show_name": {
                    "type": "string"
                },
                "updated_at": {
                    "type": "string"
                }
            }
        },
        "database.TagScope": {
            "type": "string",
            "enum": [
                "model",
                "dataset",
                "code",
                "space",
                "prompt"
            ],
            "x-enum-varnames": [
                "ModelTagScope",
                "DatasetTagScope",
                "CodeTagScope",
                "SpaceTagScope",
                "PromptTagScope"
            ]
        },
        "database.User": {
            "type": "object",
            "properties": {
                "accessTokens": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/database.AccessToken"
                    }
                },
                "avatar": {
                    "type": "string"
                },
                "bio": {
                    "type": "string"
                },
                "can_change_username": {
                    "description": "allow user to change username once",
                    "type": "boolean"
                },
                "company_verified": {
                    "type": "boolean"
                },
                "created_at": {
                    "type": "string"
                },
                "email": {
                    "type": "string"
                },
                "email_verified": {
                    "type": "boolean"
                },
                "gender": {
                    "type": "string"
                },
                "git_id": {
                    "type": "integer"
                },
                "homepage": {
                    "type": "string"
                },
                "id": {
                    "type": "integer"
                },
                "last_login_at": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                },
                "namespace": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/database.Namespace"
                    }
                },
                "password_hash": {
                    "description": "password for user registered without casdoor",
                    "type": "string"
                },
                "phone": {
                    "type": "string"
                },
                "phone_verified": {
                    "type": "boolean"
                },
                "reg_provider": {
                    "description": "user registered from default login page, from casdoor, etc. Possible values:\n\n- \"default\"\n- \"casdoor\"",
                    "type": "string"
                },
                "role_mask": {
                    "type": "string"
                },
                "updated_at": {
                    "type": "string"
                },
                "username": {
                    "type": "string"
                },
                "uuid": {
                    "description": "TODO:add unique index after migration",
                    "type": "string"
                }
            }
        },
        "handler.Create.addMemberRequest": {
            "type": "object",
            "required": [
                "role",
                "users"
            ],
            "properties": {
                "role": {
                    "type": "string"
                },
                "users": {
                    "description": "name of user will be added to the org as a member",
                    "type": "string",
                    "example": "user1,user2"
                }
            }
        },
        "handler.Delete.removeMemberRequest": {
            "type": "object",
            "required": [
                "role"
            ],
            "properties": {
                "role": {
                    "type": "string"
                }
            }
        },
        "handler.SetOpWeight.SetOpWeightReq": {
            "type": "object",
            "required": [
                "repo_id",
                "weight"
            ],
            "properties": {
                "repo_id": {
                    "type": "integer"
                },
                "weight": {
                    "type": "integer"
                }
            }
        },
        "handler.Update.updateMemberRequest": {
            "type": "object",
            "required": [
                "new_role",
                "old_role"
            ],
            "properties": {
                "new_role": {
                    "type": "string"
                },
                "old_role": {
                    "type": "string"
                }
            }
        },
        "telemetry.Counts": {
            "type": "object",
            "properties": {
                "codes": {
                    "type": "integer"
                },
                "datasets": {
                    "type": "integer"
                },
                "models": {
                    "type": "integer"
                },
                "spaces": {
                    "type": "integer"
                },
                "total_repos": {
                    "type": "integer"
                }
            }
        },
        "telemetry.Licensee": {
            "type": "object",
            "properties": {
                "Company": {
                    "type": "string"
                },
                "Email": {
                    "type": "string"
                },
                "Name": {
                    "type": "string"
                }
            }
        },
        "telemetry.Settings": {
            "type": "object",
            "properties": {
                "collected_data_categories": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "gitaly_apdex": {
                    "type": "number"
                },
                "ldap_encrypted_secrets_enabled": {
                    "type": "boolean"
                },
                "operating_system": {
                    "type": "string"
                },
                "service_ping_features_enabled": {
                    "type": "boolean"
                },
                "smtp_encrypted_secrets_enabled": {
                    "type": "boolean"
                },
                "snowplow_configured_to_gitlab_collector": {
                    "type": "boolean"
                },
                "snowplow_enabled": {
                    "type": "boolean"
                }
            }
        },
        "telemetry.Usage": {
            "type": "object",
            "properties": {
                "active_user_count": {
                    "type": "integer"
                },
                "counts": {
                    "$ref": "#/definitions/telemetry.Counts"
                },
                "edition": {
                    "type": "string"
                },
                "historical_max_users": {
                    "type": "integer"
                },
                "hostname": {
                    "type": "string"
                },
                "installation_type": {
                    "type": "string"
                },
                "license_add_ons": {
                    "type": "object",
                    "additionalProperties": true
                },
                "license_billable_users": {
                    "type": "integer"
                },
                "license_expires_at": {
                    "type": "string"
                },
                "license_id": {
                    "type": "integer"
                },
                "license_md5": {
                    "type": "string"
                },
                "license_plan": {
                    "type": "string"
                },
                "license_starts_at": {
                    "type": "string"
                },
                "license_user_count": {
                    "type": "integer"
                },
                "licensee": {
                    "$ref": "#/definitions/telemetry.Licensee"
                },
                "recorded_at": {
                    "type": "string"
                },
                "settings": {
                    "$ref": "#/definitions/telemetry.Settings"
                },
                "uuid": {
                    "type": "string"
                },
                "version": {
                    "type": "string"
                }
            }
        },
        "types.APIBadRequest": {
            "type": "object"
        },
        "types.APIInternalServerError": {
            "type": "object"
        },
        "types.APIUnauthorized": {
            "type": "object"
        },
        "types.AccessTokenApp": {
            "type": "string",
            "enum": [
                "git",
                "git",
                "mirror",
                "starship"
            ],
            "x-enum-varnames": [
                "AccessTokenAppGit",
                "AccessTokenAppCSGHub",
                "AccessTokenAppMirror",
                "AccessTokenAppStarship"
            ]
        },
        "types.Branch": {
            "type": "object",
            "properties": {
                "commit": {
                    "$ref": "#/definitions/types.RepoBranchCommit"
                },
                "message": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                }
            }
        },
        "types.Code": {
            "type": "object",
            "properties": {
                "can_manage": {
                    "type": "boolean"
                },
                "can_write": {
                    "type": "boolean"
                },
                "created_at": {
                    "type": "string"
                },
                "default_branch": {
                    "type": "string"
                },
                "description": {
                    "type": "string"
                },
                "downloads": {
                    "type": "integer"
                },
                "id": {
                    "type": "integer"
                },
                "license": {
                    "type": "string"
                },
                "likes": {
                    "type": "integer"
                },
                "name": {
                    "type": "string"
                },
                "namespace": {
                    "$ref": "#/definitions/types.Namespace"
                },
                "nickname": {
                    "type": "string"
                },
                "path": {
                    "type": "string"
                },
                "private": {
                    "type": "boolean"
                },
                "repository": {
                    "$ref": "#/definitions/types.Repository"
                },
                "repository_id": {
                    "type": "integer"
                },
                "source": {
                    "$ref": "#/definitions/types.RepositorySource"
                },
                "sync_status": {
                    "$ref": "#/definitions/types.RepositorySyncStatus"
                },
                "tags": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/types.RepoTag"
                    }
                },
                "updated_at": {
                    "type": "string"
                },
                "user": {
                    "$ref": "#/definitions/types.User"
                },
                "user_likes": {
                    "type": "boolean"
                }
            }
        },
        "types.Collection": {
            "type": "object",
            "properties": {
                "avatar": {
                    "type": "string"
                },
                "can_manage": {
                    "type": "boolean"
                },
                "can_write": {
                    "type": "boolean"
                },
                "created_at": {
                    "type": "string"
                },
                "description": {
                    "type": "string"
                },
                "id": {
                    "type": "integer"
                },
                "likes": {
                    "type": "integer"
                },
                "name": {
                    "type": "string"
                },
                "namespace": {
                    "type": "string"
                },
                "nickname": {
                    "type": "string"
                },
                "private": {
                    "type": "boolean"
                },
                "repositories": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/types.CollectionRepository"
                    }
                },
                "theme": {
                    "type": "string"
                },
                "updated_at": {
                    "type": "string"
                },
                "user_likes": {
                    "type": "boolean"
                },
                "username": {
                    "type": "string"
                }
            }
        },
        "types.CollectionRepository": {
            "type": "object",
            "properties": {
                "created_at": {
                    "type": "string"
                },
                "description": {
                    "type": "string"
                },
                "download_count": {
                    "type": "integer"
                },
                "id": {
                    "type": "integer"
                },
                "likes": {
                    "type": "integer"
                },
                "name": {
                    "type": "string"
                },
                "nickname": {
                    "type": "string"
                },
                "path": {
                    "type": "string"
                },
                "private": {
                    "type": "boolean"
                },
                "repository_type": {
                    "$ref": "#/definitions/types.RepositoryType"
                },
                "status": {
                    "type": "string"
                },
                "tags": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/types.RepoTag"
                    }
                },
                "updated_at": {
                    "type": "string"
                },
                "user_id": {
                    "type": "integer"
                }
            }
        },
        "types.Commit": {
            "type": "object",
            "properties": {
                "author_email": {
                    "type": "string"
                },
                "author_name": {
                    "type": "string"
                },
                "authored_date": {
                    "type": "string"
                },
                "committer_date": {
                    "type": "string"
                },
                "committer_email": {
                    "type": "string"
                },
                "committer_name": {
                    "type": "string"
                },
                "created_at": {
                    "type": "string"
                },
                "id": {
                    "type": "string"
                },
                "message": {
                    "type": "string"
                }
            }
        },
        "types.CommitMeta": {
            "type": "object",
            "properties": {
                "sha": {
                    "type": "string"
                }
            }
        },
        "types.CommitResponse": {
            "type": "object",
            "properties": {
                "author_email": {
                    "type": "string"
                },
                "author_name": {
                    "type": "string"
                },
                "authored_date": {
                    "type": "string"
                },
                "committer_date": {
                    "type": "string"
                },
                "committer_email": {
                    "type": "string"
                },
                "committer_name": {
                    "type": "string"
                },
                "created_at": {
                    "type": "string"
                },
                "diff": {
                    "type": "array",
                    "items": {
                        "type": "integer"
                    }
                },
                "files": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "id": {
                    "type": "string"
                },
                "message": {
                    "type": "string"
                },
                "parents": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/types.CommitMeta"
                    }
                },
                "stats": {
                    "$ref": "#/definitions/types.CommitStats"
                }
            }
        },
        "types.CommitStats": {
            "type": "object",
            "properties": {
                "additions": {
                    "type": "integer"
                },
                "deletions": {
                    "type": "integer"
                },
                "total": {
                    "type": "integer"
                }
            }
        },
        "types.Conversation": {
            "type": "object",
            "required": [
                "message",
                "uuid"
            ],
            "properties": {
                "message": {
                    "type": "string"
                },
                "temperature": {
                    "type": "number"
                },
                "uuid": {
                    "type": "string"
                }
            }
        },
        "types.ConversationTitle": {
            "type": "object",
            "required": [
                "title",
                "uuid"
            ],
            "properties": {
                "title": {
                    "type": "string"
                },
                "uuid": {
                    "type": "string"
                }
            }
        },
        "types.CreateCodeReq": {
            "type": "object",
            "properties": {
                "default_branch": {
                    "type": "string",
                    "example": "main"
                },
                "description": {
                    "type": "string"
                },
                "labels": {
                    "type": "string",
                    "example": ""
                },
                "license": {
                    "type": "string",
                    "example": "MIT"
                },
                "name": {
                    "type": "string",
                    "example": "model_name_1"
                },
                "namespace": {
                    "type": "string",
                    "example": "user_or_org_name"
                },
                "nickname": {
                    "type": "string",
                    "example": "model display name"
                },
                "private": {
                    "type": "boolean"
                },
                "readme": {
                    "type": "string"
                }
            }
        },
        "types.CreateCollectionReq": {
            "type": "object",
            "properties": {
                "description": {
                    "type": "string"
                },
                "name": {
                    "type": "string",
                    "example": "collection1"
                },
                "namespace": {
                    "type": "string",
                    "example": "user_or_org_name"
                },
                "nickname": {
                    "type": "string",
                    "example": "collection nick name"
                },
                "private": {
                    "type": "boolean"
                },
                "theme": {
                    "type": "string",
                    "example": "#fff000"
                }
            }
        },
        "types.CreateDatasetReq": {
            "type": "object",
            "properties": {
                "default_branch": {
                    "type": "string",
                    "example": "main"
                },
                "description": {
                    "type": "string"
                },
                "labels": {
                    "type": "string",
                    "example": ""
                },
                "license": {
                    "type": "string",
                    "example": "MIT"
                },
                "name": {
                    "type": "string",
                    "example": "model_name_1"
                },
                "namespace": {
                    "type": "string",
                    "example": "user_or_org_name"
                },
                "nickname": {
                    "type": "string",
                    "example": "model display name"
                },
                "private": {
                    "type": "boolean"
                },
                "readme": {
                    "type": "string"
                },
                "type": {
                    "type": "integer"
                }
            }
        },
        "types.CreateFileReq": {
            "type": "object",
            "properties": {
                "branch": {
                    "type": "string"
                },
                "content": {
                    "type": "string"
                },
                "current_user": {
                    "type": "string"
                },
                "message": {
                    "type": "string"
                },
                "new_branch": {
                    "type": "string"
                },
                "original_content": {
                    "description": "Use for lfs file",
                    "type": "array",
                    "items": {
                        "type": "integer"
                    }
                },
                "pointer": {
                    "$ref": "#/definitions/types.Pointer"
                }
            }
        },
        "types.CreateFileResp": {
            "type": "object"
        },
        "types.CreateJWTReq": {
            "type": "object",
            "required": [
                "uuid"
            ],
            "properties": {
                "uuid": {
                    "type": "string"
                }
            }
        },
        "types.CreateJWTResp": {
            "type": "object",
            "properties": {
                "expire_at": {
                    "type": "string"
                },
                "token": {
                    "type": "string"
                }
            }
        },
        "types.CreateMirrorParams": {
            "type": "object",
            "properties": {
                "mirror_source_id": {
                    "type": "integer"
                },
                "password": {
                    "type": "string"
                },
                "source_url": {
                    "type": "string"
                },
                "username": {
                    "type": "string"
                }
            }
        },
        "types.CreateMirrorRepoReq": {
            "type": "object",
            "required": [
                "mirror_source_id",
                "repo_type",
                "source_name",
                "source_namespace",
                "source_url"
            ],
            "properties": {
                "branch": {
                    "type": "string"
                },
                "current_user": {
                    "type": "string"
                },
                "description": {
                    "type": "string"
                },
                "license": {
                    "type": "string"
                },
                "mirror_source_id": {
                    "description": "source id for HF,github etc",
                    "type": "integer"
                },
                "repo_type": {
                    "description": "repo basic info",
                    "allOf": [
                        {
                            "$ref": "#/definitions/types.RepositoryType"
                        }
                    ]
                },
                "source_name": {
                    "type": "string"
                },
                "source_namespace": {
                    "type": "string"
                },
                "source_url": {
                    "description": "mirror source info",
                    "type": "string"
                },
                "sync_lfs": {
                    "type": "boolean"
                }
            }
        },
        "types.CreateMirrorSourceReq": {
            "type": "object",
            "required": [
                "source_name"
            ],
            "properties": {
                "current_user": {
                    "type": "string"
                },
                "info_api_url": {
                    "type": "string"
                },
                "source_name": {
                    "type": "string"
                }
            }
        },
        "types.CreateModelReq": {
            "type": "object",
            "properties": {
                "base_model": {
                    "type": "string"
                },
                "default_branch": {
                    "type": "string",
                    "example": "main"
                },
                "description": {
                    "type": "string"
                },
                "labels": {
                    "type": "string",
                    "example": ""
                },
                "license": {
                    "type": "string",
                    "example": "MIT"
                },
                "name": {
                    "type": "string",
                    "example": "model_name_1"
                },
                "namespace": {
                    "type": "string",
                    "example": "user_or_org_name"
                },
                "nickname": {
                    "type": "string",
                    "example": "model display name"
                },
                "private": {
                    "type": "boolean"
                },
                "readme": {
                    "type": "string"
                }
            }
        },
        "types.CreateOrgReq": {
            "type": "object",
            "properties": {
                "description": {
                    "type": "string",
                    "example": "org description"
                },
                "homepage": {
                    "type": "string",
                    "example": "https://www.example.com"
                },
                "logo": {
                    "type": "string",
                    "example": "https://www.example.com/logo.png"
                },
                "name": {
                    "description": "Org unique identifier",
                    "type": "string",
                    "example": "org_name_1"
                },
                "nickname": {
                    "description": "Display name",
                    "type": "string",
                    "example": "org_display_name"
                },
                "org_type": {
                    "type": "string",
                    "example": "company or school etc"
                },
                "verified": {
                    "type": "boolean",
                    "example": false
                }
            }
        },
        "types.CreatePromptRepoReq": {
            "type": "object",
            "properties": {
                "default_branch": {
                    "type": "string",
                    "example": "main"
                },
                "description": {
                    "type": "string"
                },
                "labels": {
                    "type": "string",
                    "example": ""
                },
                "license": {
                    "type": "string",
                    "example": "MIT"
                },
                "name": {
                    "type": "string",
                    "example": "model_name_1"
                },
                "namespace": {
                    "type": "string",
                    "example": "user_or_org_name"
                },
                "nickname": {
                    "type": "string",
                    "example": "model display name"
                },
                "private": {
                    "type": "boolean"
                },
                "readme": {
                    "type": "string"
                }
            }
        },
        "types.CreateSSHKeyRequest": {
            "type": "object",
            "properties": {
                "content": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                },
                "username": {
                    "type": "string"
                }
            }
        },
        "types.CreateSpaceReq": {
            "type": "object",
            "properties": {
                "cluster_id": {
                    "type": "string"
                },
                "cover_image_url": {
                    "type": "string"
                },
                "default_branch": {
                    "type": "string",
                    "example": "main"
                },
                "description": {
                    "type": "string"
                },
                "env": {
                    "type": "string"
                },
                "labels": {
                    "type": "string",
                    "example": ""
                },
                "license": {
                    "type": "string",
                    "example": "MIT"
                },
                "name": {
                    "type": "string",
                    "example": "model_name_1"
                },
                "namespace": {
                    "type": "string",
                    "example": "user_or_org_name"
                },
                "nickname": {
                    "type": "string",
                    "example": "model display name"
                },
                "private": {
                    "type": "boolean"
                },
                "readme": {
                    "type": "string"
                },
                "resource_id": {
                    "type": "integer"
                },
                "sdk": {
                    "type": "string",
                    "example": "1"
                },
                "sdk_version": {
                    "type": "string",
                    "example": "v0.1"
                },
                "secrets": {
                    "type": "string"
                },
                "template": {
                    "type": "string"
                }
            }
        },
        "types.CreateSpaceResourceReq": {
            "type": "object",
            "required": [
                "cluster_id",
                "name",
                "resources"
            ],
            "properties": {
                "cluster_id": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                },
                "resources": {
                    "type": "string"
                }
            }
        },
        "types.CreateSpaceSdkReq": {
            "type": "object",
            "required": [
                "name",
                "version"
            ],
            "properties": {
                "name": {
                    "type": "string"
                },
                "version": {
                    "type": "string"
                }
            }
        },
        "types.CreateSyncClientSettingReq": {
            "type": "object",
            "required": [
                "token"
            ],
            "properties": {
                "concurrent_count": {
                    "type": "integer"
                },
                "max_bandwidth": {
                    "type": "integer"
                },
                "token": {
                    "type": "string"
                }
            }
        },
        "types.CreateUserTokenRequest": {
            "type": "object",
            "properties": {
                "application": {
                    "description": "default to csghub",
                    "allOf": [
                        {
                            "$ref": "#/definitions/types.AccessTokenApp"
                        }
                    ]
                },
                "expired_at": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                },
                "permission": {
                    "description": "default to empty, means full permission",
                    "type": "string"
                }
            }
        },
        "types.Dataset": {
            "type": "object",
            "properties": {
                "can_manage": {
                    "type": "boolean"
                },
                "can_write": {
                    "type": "boolean"
                },
                "created_at": {
                    "type": "string"
                },
                "default_branch": {
                    "type": "string"
                },
                "description": {
                    "type": "string"
                },
                "downloads": {
                    "type": "integer"
                },
                "id": {
                    "type": "integer"
                },
                "license": {
                    "type": "string"
                },
                "likes": {
                    "type": "integer"
                },
                "mirror_last_updated_at": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                },
                "namespace": {
                    "$ref": "#/definitions/types.Namespace"
                },
                "nickname": {
                    "type": "string"
                },
                "path": {
                    "type": "string"
                },
                "private": {
                    "type": "boolean"
                },
                "readme": {
                    "type": "string"
                },
                "repository": {
                    "$ref": "#/definitions/types.Repository"
                },
                "repository_id": {
                    "type": "integer"
                },
                "source": {
                    "$ref": "#/definitions/types.RepositorySource"
                },
                "sync_status": {
                    "$ref": "#/definitions/types.RepositorySyncStatus"
                },
                "tags": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/types.RepoTag"
                    }
                },
                "updated_at": {
                    "type": "string"
                },
                "user": {
                    "$ref": "#/definitions/types.User"
                },
                "user_likes": {
                    "type": "boolean"
                }
            }
        },
        "types.DatasetResp": {
            "type": "object",
            "properties": {
                "description": {
                    "type": "string"
                },
                "downloads": {
                    "type": "integer"
                },
                "name": {
                    "type": "string"
                },
                "nickname": {
                    "type": "string"
                },
                "path": {
                    "type": "string"
                },
                "private": {
                    "type": "boolean"
                },
                "tags": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/types.RepoTag"
                    }
                },
                "updated_at": {
                    "type": "string"
                }
            }
        },
        "types.DeleteOrgReq": {
            "type": "object"
        },
        "types.DeleteUserTokenRequest": {
            "type": "object",
            "properties": {
                "application": {
                    "description": "default to csghub",
                    "allOf": [
                        {
                            "$ref": "#/definitions/types.AccessTokenApp"
                        }
                    ]
                },
                "expired_at": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                },
                "permission": {
                    "description": "default to empty, means full permission",
                    "type": "string"
                }
            }
        },
        "types.DeployUpdateReq": {
            "type": "object",
            "properties": {
                "cluster_id": {
                    "type": "string"
                },
                "deploy_name": {
                    "type": "string"
                },
                "env": {
                    "type": "string"
                },
                "max_replica": {
                    "type": "integer",
                    "minimum": 1
                },
                "min_replica": {
                    "type": "integer",
                    "minimum": 1
                },
                "resource_id": {
                    "type": "integer"
                },
                "revision": {
                    "type": "string"
                },
                "runtime_framework_id": {
                    "type": "integer"
                },
                "secure_level": {
                    "type": "integer"
                }
            }
        },
        "types.EditOrgReq": {
            "type": "object",
            "properties": {
                "description": {
                    "type": "string",
                    "example": "org description"
                },
                "homepage": {
                    "type": "string",
                    "example": "https://www.example.com"
                },
                "logo": {
                    "type": "string",
                    "example": "https://www.example.com/logo.png"
                },
                "nickname": {
                    "description": "Display name",
                    "type": "string",
                    "example": "org display name"
                },
                "org_type": {
                    "type": "string",
                    "example": "company or school etc"
                },
                "verified": {
                    "type": "boolean",
                    "example": false
                }
            }
        },
        "types.Event": {
            "type": "object",
            "properties": {
                "c_id": {
                    "type": "string",
                    "example": ""
                },
                "c_ip": {
                    "type": "string",
                    "example": ""
                },
                "ext": {
                    "description": "reserved for future use",
                    "type": "string",
                    "example": ""
                },
                "id": {
                    "type": "string",
                    "example": "space_card"
                },
                "m": {
                    "type": "string",
                    "example": "space"
                },
                "v": {
                    "type": "string",
                    "example": "1"
                }
            }
        },
        "types.File": {
            "type": "object",
            "properties": {
                "commit": {
                    "$ref": "#/definitions/types.Commit"
                },
                "content": {
                    "type": "string"
                },
                "last_commit_sha": {
                    "type": "string"
                },
                "lfs": {
                    "type": "boolean"
                },
                "lfs_pointer_size": {
                    "type": "integer"
                },
                "lfs_relative_path": {
                    "description": "relative path in lfs storage",
                    "type": "string"
                },
                "mode": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                },
                "path": {
                    "type": "string"
                },
                "sha": {
                    "type": "string"
                },
                "size": {
                    "type": "integer"
                },
                "type": {
                    "type": "string"
                },
                "url": {
                    "description": "URL to browse the file",
                    "type": "string"
                }
            }
        },
        "types.InstanceRunReq": {
            "type": "object",
            "properties": {
                "cluster_id": {
                    "type": "string"
                },
                "deploy_name": {
                    "type": "string"
                },
                "resource_id": {
                    "type": "integer"
                },
                "revision": {
                    "type": "string"
                },
                "runtime_framework_id": {
                    "type": "integer"
                }
            }
        },
        "types.ListByPathReq": {
            "type": "object",
            "properties": {
                "paths": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                }
            }
        },
        "types.Member": {
            "type": "object",
            "properties": {
                "avatar": {
                    "type": "string"
                },
                "last_login_at": {
                    "type": "string"
                },
                "nickname": {
                    "type": "string"
                },
                "role": {
                    "type": "string"
                },
                "username": {
                    "type": "string"
                },
                "uuid": {
                    "type": "string"
                }
            }
        },
        "types.Mirror": {
            "type": "object",
            "properties": {
                "access_token": {
                    "description": "source access token",
                    "type": "string"
                },
                "last_message": {
                    "type": "string"
                },
                "last_updated_at": {
                    "type": "string"
                },
                "local_repo_path": {
                    "type": "string"
                },
                "mirror_source": {
                    "$ref": "#/definitions/types.MirrorSource"
                },
                "progress": {
                    "type": "integer"
                },
                "push_access_token": {
                    "type": "string"
                },
                "push_url": {
                    "type": "string"
                },
                "push_username": {
                    "type": "string"
                },
                "repository": {
                    "$ref": "#/definitions/types.Repository"
                },
                "source_repo_path": {
                    "type": "string"
                },
                "source_url": {
                    "type": "string"
                },
                "status": {
                    "$ref": "#/definitions/types.MirrorTaskStatus"
                },
                "username": {
                    "description": "source user name",
                    "type": "string"
                }
            }
        },
        "types.MirrorPriority": {
            "type": "integer",
            "enum": [
                3,
                2,
                1
            ],
            "x-enum-varnames": [
                "HighMirrorPriority",
                "MediumMirrorPriority",
                "LowMirrorPriority"
            ]
        },
        "types.MirrorRepo": {
            "type": "object",
            "properties": {
                "path": {
                    "type": "string"
                },
                "progress": {
                    "type": "integer"
                },
                "repo_type": {
                    "$ref": "#/definitions/types.RepositoryType"
                },
                "sync_status": {
                    "$ref": "#/definitions/types.RepositorySyncStatus"
                }
            }
        },
        "types.MirrorSource": {
            "type": "object",
            "properties": {
                "source_name": {
                    "type": "string"
                }
            }
        },
        "types.MirrorTaskStatus": {
            "type": "string",
            "enum": [
                "waiting",
                "running",
                "repo_synced",
                "finished",
                "failed",
                "incomplete"
            ],
            "x-enum-varnames": [
                "MirrorWaiting",
                "MirrorRunning",
                "MirrorRepoSynced",
                "MirrorFinished",
                "MirrorFailed",
                "MirrorIncomplete"
            ]
        },
        "types.Model": {
            "type": "object",
            "properties": {
                "base_model": {
                    "type": "string"
                },
                "can_manage": {
                    "type": "boolean"
                },
                "can_write": {
                    "type": "boolean"
                },
                "created_at": {
                    "type": "string"
                },
                "default_branch": {
                    "type": "string"
                },
                "description": {
                    "type": "string"
                },
                "downloads": {
                    "type": "integer"
                },
                "enable_finetune": {
                    "type": "boolean"
                },
                "enable_inference": {
                    "type": "boolean"
                },
                "id": {
                    "type": "integer"
                },
                "license": {
                    "type": "string"
                },
                "likes": {
                    "type": "integer"
                },
                "mirror_last_updated_at": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                },
                "namespace": {
                    "$ref": "#/definitions/types.Namespace"
                },
                "nickname": {
                    "type": "string"
                },
                "path": {
                    "type": "string"
                },
                "private": {
                    "type": "boolean"
                },
                "readme": {
                    "type": "string"
                },
                "repository": {
                    "$ref": "#/definitions/types.Repository"
                },
                "repository_id": {
                    "type": "integer"
                },
                "source": {
                    "$ref": "#/definitions/types.RepositorySource"
                },
                "status": {
                    "description": "url to interact with the model",
                    "type": "string",
                    "example": "RUNNING"
                },
                "sync_status": {
                    "$ref": "#/definitions/types.RepositorySyncStatus"
                },
                "tags": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/types.RepoTag"
                    }
                },
                "updated_at": {
                    "type": "string"
                },
                "user": {
                    "$ref": "#/definitions/types.User"
                },
                "user_likes": {
                    "type": "boolean"
                },
                "widget_type": {
                    "description": "widget UI style: generation,chat",
                    "allOf": [
                        {
                            "$ref": "#/definitions/types.ModelWidgetType"
                        }
                    ],
                    "example": "generation"
                }
            }
        },
        "types.ModelPredictReq": {
            "type": "object",
            "properties": {
                "current_user": {
                    "type": "string"
                },
                "input": {
                    "type": "string"
                },
                "version": {
                    "type": "string"
                }
            }
        },
        "types.ModelResp": {
            "type": "object",
            "properties": {
                "description": {
                    "type": "string"
                },
                "downloads": {
                    "type": "integer"
                },
                "name": {
                    "type": "string"
                },
                "nickname": {
                    "type": "string"
                },
                "path": {
                    "type": "string"
                },
                "private": {
                    "type": "boolean"
                },
                "tags": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/types.RepoTag"
                    }
                },
                "updated_at": {
                    "type": "string"
                }
            }
        },
        "types.ModelRunReq": {
            "type": "object",
            "properties": {
                "cluster_id": {
                    "type": "string"
                },
                "deploy_name": {
                    "type": "string"
                },
                "env": {
                    "type": "string"
                },
                "max_replica": {
                    "type": "integer"
                },
                "min_replica": {
                    "type": "integer"
                },
                "resource_id": {
                    "type": "integer"
                },
                "revision": {
                    "type": "string"
                },
                "runtime_framework_id": {
                    "type": "integer"
                },
                "secure_level": {
                    "type": "integer"
                }
            }
        },
        "types.ModelWidgetType": {
            "type": "string",
            "enum": [
                "generation",
                "chat"
            ],
            "x-enum-varnames": [
                "ModelWidgetTypeGeneration",
                "ModelWidgetTypeChat"
            ]
        },
        "types.Namespace": {
            "type": "object",
            "properties": {
                "avatar": {
                    "type": "string"
                },
                "path": {
                    "type": "string"
                },
                "type": {
                    "description": "namespace types like 'user' for normal user, and 'school', 'company' for orgs etc.",
                    "type": "string"
                }
            }
        },
        "types.Organization": {
            "type": "object",
            "properties": {
                "homepage": {
                    "type": "string"
                },
                "logo": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                },
                "org_type": {
                    "type": "string"
                },
                "path": {
                    "description": "unique name of the organization",
                    "type": "string"
                },
                "user_id": {
                    "type": "integer"
                },
                "verified": {
                    "type": "boolean"
                }
            }
        },
        "types.Pointer": {
            "type": "object",
            "properties": {
                "download_url": {
                    "type": "string"
                },
                "oid": {
                    "type": "string"
                },
                "size": {
                    "type": "integer"
                }
            }
        },
        "types.PromptRes": {
            "type": "object",
            "properties": {
                "can_manage": {
                    "type": "boolean"
                },
                "can_write": {
                    "type": "boolean"
                },
                "created_at": {
                    "type": "string"
                },
                "default_branch": {
                    "type": "string"
                },
                "description": {
                    "type": "string"
                },
                "downloads": {
                    "type": "integer"
                },
                "id": {
                    "type": "integer"
                },
                "license": {
                    "type": "string"
                },
                "likes": {
                    "type": "integer"
                },
                "name": {
                    "type": "string"
                },
                "namespace": {
                    "$ref": "#/definitions/types.Namespace"
                },
                "nickname": {
                    "type": "string"
                },
                "path": {
                    "type": "string"
                },
                "private": {
                    "type": "boolean"
                },
                "readme": {
                    "type": "string"
                },
                "repository": {
                    "$ref": "#/definitions/types.Repository"
                },
                "repository_id": {
                    "type": "integer"
                },
                "source": {
                    "$ref": "#/definitions/types.RepositorySource"
                },
                "sync_status": {
                    "$ref": "#/definitions/types.RepositorySyncStatus"
                },
                "tags": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/types.RepoTag"
                    }
                },
                "updated_at": {
                    "type": "string"
                },
                "user": {
                    "$ref": "#/definitions/types.User"
                },
                "user_likes": {
                    "type": "boolean"
                }
            }
        },
        "types.RelationDataset": {
            "type": "object",
            "properties": {
                "dataset": {
                    "type": "string"
                }
            }
        },
        "types.RelationDatasets": {
            "type": "object",
            "properties": {
                "datasets": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                }
            }
        },
        "types.RelationModel": {
            "type": "object",
            "properties": {
                "model": {
                    "type": "string"
                }
            }
        },
        "types.RelationModels": {
            "type": "object",
            "properties": {
                "models": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                }
            }
        },
        "types.Relations": {
            "type": "object",
            "properties": {
                "codes": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/types.Code"
                    }
                },
                "datasets": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/types.Dataset"
                    }
                },
                "models": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/types.Model"
                    }
                },
                "prompts": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/types.PromptRes"
                    }
                },
                "spaces": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/types.Space"
                    }
                }
            }
        },
        "types.RepoBranchCommit": {
            "type": "object",
            "properties": {
                "id": {
                    "type": "string"
                }
            }
        },
        "types.RepoTag": {
            "type": "object",
            "properties": {
                "built_in": {
                    "type": "boolean"
                },
                "category": {
                    "type": "string"
                },
                "created_at": {
                    "type": "string"
                },
                "group": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                },
                "show_name": {
                    "type": "string"
                },
                "updated_at": {
                    "type": "string"
                }
            }
        },
        "types.Repository": {
            "type": "object",
            "properties": {
                "http_clone_url": {
                    "type": "string"
                },
                "ssh_clone_url": {
                    "type": "string"
                }
            }
        },
        "types.RepositorySource": {
            "type": "string",
            "enum": [
                "opencsg",
                "local",
                "huggingface"
            ],
            "x-enum-varnames": [
                "OpenCSGSource",
                "LocalSource",
                "HuggingfaceSource"
            ]
        },
        "types.RepositorySyncStatus": {
            "type": "string",
            "enum": [
                "pending",
                "inprogress",
                "failed",
                "completed"
            ],
            "x-enum-varnames": [
                "SyncStatusPending",
                "SyncStatusInProgress",
                "SyncStatusFailed",
                "SyncStatusCompleted"
            ]
        },
        "types.RepositoryType": {
            "type": "string",
            "enum": [
                "model",
                "dataset",
                "space",
                "code",
                "prompt",
                ""
            ],
            "x-enum-varnames": [
                "ModelRepo",
                "DatasetRepo",
                "SpaceRepo",
                "CodeRepo",
                "PromptRepo",
                "UnknownRepo"
            ]
        },
        "types.ResourceType": {
            "type": "string",
            "enum": [
                "cpu",
                "gpu"
            ],
            "x-enum-varnames": [
                "ResourceTypeCPU",
                "ResourceTypeGPU"
            ]
        },
        "types.Response": {
            "type": "object",
            "properties": {
                "data": {},
                "msg": {
                    "type": "string"
                }
            }
        },
        "types.ResponseWithTotal": {
            "type": "object",
            "properties": {
                "data": {},
                "msg": {
                    "type": "string"
                },
                "total": {
                    "type": "integer"
                }
            }
        },
        "types.RuntimeArchitecture": {
            "type": "object",
            "properties": {
                "architectures": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                }
            }
        },
        "types.RuntimeFramework": {
            "type": "object",
            "properties": {
                "container_port": {
                    "type": "integer"
                },
                "enabled": {
                    "type": "integer"
                },
                "frame_cpu_image": {
                    "type": "string"
                },
                "frame_image": {
                    "type": "string"
                },
                "frame_name": {
                    "type": "string"
                },
                "frame_version": {
                    "type": "string"
                },
                "id": {
                    "type": "integer"
                },
                "type": {
                    "type": "integer"
                }
            }
        },
        "types.RuntimeFrameworkModels": {
            "type": "object",
            "properties": {
                "models": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                }
            }
        },
        "types.RuntimeFrameworkReq": {
            "type": "object",
            "properties": {
                "container_port": {
                    "type": "integer"
                },
                "enabled": {
                    "type": "integer"
                },
                "frame_cpu_image": {
                    "type": "string"
                },
                "frame_image": {
                    "type": "string"
                },
                "frame_name": {
                    "type": "string"
                },
                "frame_version": {
                    "type": "string"
                },
                "type": {
                    "type": "integer"
                }
            }
        },
        "types.SensitiveCheckStatus": {
            "type": "integer",
            "enum": [
                -1,
                0,
                1,
                2,
                3
            ],
            "x-enum-comments": {
                "SensitiveCheckException": "error happen",
                "SensitiveCheckFail": "sensitive content detected",
                "SensitiveCheckPass": "pass",
                "SensitiveCheckPending": "default",
                "SensitiveCheckSkip": "skip"
            },
            "x-enum-varnames": [
                "SensitiveCheckFail",
                "SensitiveCheckPending",
                "SensitiveCheckPass",
                "SensitiveCheckSkip",
                "SensitiveCheckException"
            ]
        },
        "types.Space": {
            "type": "object",
            "properties": {
                "can_manage": {
                    "type": "boolean"
                },
                "can_write": {
                    "type": "boolean"
                },
                "cover_image_url": {
                    "type": "string"
                },
                "created_at": {
                    "type": "string"
                },
                "default_branch": {
                    "type": "string"
                },
                "description": {
                    "type": "string",
                    "example": ""
                },
                "endpoint": {
                    "description": "the serving endpoint url",
                    "type": "string",
                    "example": "https://localhost/spaces/myname/myspace"
                },
                "env": {
                    "type": "string"
                },
                "hardware": {
                    "type": "string"
                },
                "id": {
                    "type": "integer"
                },
                "license": {
                    "type": "string",
                    "example": "MIT"
                },
                "like_count": {
                    "type": "integer"
                },
                "name": {
                    "type": "string",
                    "example": "space_name_1"
                },
                "namespace": {
                    "$ref": "#/definitions/types.Namespace"
                },
                "nickname": {
                    "type": "string",
                    "example": ""
                },
                "path": {
                    "type": "string",
                    "example": "user_or_org_name/space_name_1"
                },
                "private": {
                    "type": "boolean"
                },
                "repository": {
                    "$ref": "#/definitions/types.Repository"
                },
                "repository_id": {
                    "type": "integer"
                },
                "sdk": {
                    "description": "like gradio,steamlit etc",
                    "type": "string",
                    "example": "1"
                },
                "sdk_version": {
                    "type": "string",
                    "example": "v0.1"
                },
                "secrets": {
                    "type": "string"
                },
                "sku": {
                    "type": "string"
                },
                "source": {
                    "$ref": "#/definitions/types.RepositorySource"
                },
                "status": {
                    "description": "deploying, running, failed",
                    "type": "string"
                },
                "svc_name": {
                    "type": "string"
                },
                "sync_status": {
                    "$ref": "#/definitions/types.RepositorySyncStatus"
                },
                "tags": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/types.RepoTag"
                    }
                },
                "template": {
                    "type": "string"
                },
                "updated_at": {
                    "type": "string"
                },
                "user": {
                    "$ref": "#/definitions/types.User"
                },
                "user_likes": {
                    "type": "boolean"
                },
                "username": {
                    "type": "string",
                    "example": "creator_user_name"
                }
            }
        },
        "types.SpaceResource": {
            "type": "object",
            "properties": {
                "id": {
                    "type": "integer"
                },
                "is_available": {
                    "type": "boolean"
                },
                "name": {
                    "type": "string"
                },
                "resources": {
                    "type": "string"
                },
                "type": {
                    "$ref": "#/definitions/types.ResourceType"
                }
            }
        },
        "types.SpaceSdk": {
            "type": "object",
            "properties": {
                "id": {
                    "type": "integer"
                },
                "name": {
                    "type": "string"
                },
                "version": {
                    "type": "string"
                }
            }
        },
        "types.SyncVersion": {
            "type": "object",
            "properties": {
                "change_log": {
                    "type": "string"
                },
                "last_modify_time": {
                    "type": "string"
                },
                "repo_path": {
                    "type": "string"
                },
                "repo_type": {
                    "$ref": "#/definitions/types.RepositoryType"
                },
                "source_id": {
                    "description": "0: opencsg, 1: HF",
                    "type": "integer"
                },
                "version": {
                    "type": "integer"
                }
            }
        },
        "types.SyncVersionResponse": {
            "type": "object",
            "properties": {
                "data": {
                    "type": "object",
                    "properties": {
                        "has_more": {
                            "type": "boolean"
                        },
                        "versions": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/types.SyncVersion"
                            }
                        }
                    }
                },
                "msg": {
                    "type": "string"
                }
            }
        },
        "types.UpdateCodeReq": {
            "type": "object",
            "properties": {
                "description": {
                    "type": "string"
                },
                "nickname": {
                    "type": "string",
                    "example": "model display name"
                },
                "private": {
                    "type": "boolean",
                    "example": false
                }
            }
        },
        "types.UpdateCollectionReposReq": {
            "type": "object",
            "properties": {
                "repo_ids": {
                    "type": "array",
                    "items": {
                        "type": "integer"
                    }
                }
            }
        },
        "types.UpdateDatasetReq": {
            "type": "object",
            "properties": {
                "description": {
                    "type": "string"
                },
                "nickname": {
                    "type": "string",
                    "example": "model display name"
                },
                "private": {
                    "type": "boolean",
                    "example": false
                }
            }
        },
        "types.UpdateFileReq": {
            "type": "object",
            "properties": {
                "branch": {
                    "type": "string"
                },
                "content": {
                    "type": "string"
                },
                "message": {
                    "type": "string"
                },
                "new_branch": {
                    "type": "string"
                },
                "origin_path": {
                    "type": "string"
                },
                "original_content": {
                    "description": "Use for lfs file",
                    "type": "array",
                    "items": {
                        "type": "integer"
                    }
                },
                "pointer": {
                    "$ref": "#/definitions/types.Pointer"
                },
                "repoType": {
                    "$ref": "#/definitions/types.RepositoryType"
                },
                "sha": {
                    "type": "string"
                }
            }
        },
        "types.UpdateFileResp": {
            "type": "object"
        },
        "types.UpdateMirrorParams": {
            "type": "object",
            "properties": {
                "mirror_source_id": {
                    "type": "integer"
                },
                "password": {
                    "type": "string"
                },
                "source_url": {
                    "type": "string"
                },
                "username": {
                    "type": "string"
                }
            }
        },
        "types.UpdateMirrorSourceReq": {
            "type": "object",
            "required": [
                "source_name"
            ],
            "properties": {
                "current_user": {
                    "type": "string"
                },
                "id": {
                    "type": "integer"
                },
                "info_api_url": {
                    "type": "string"
                },
                "source_name": {
                    "type": "string"
                }
            }
        },
        "types.UpdateModelReq": {
            "type": "object",
            "properties": {
                "base_model": {
                    "type": "string"
                },
                "description": {
                    "type": "string"
                },
                "nickname": {
                    "type": "string",
                    "example": "model display name"
                },
                "private": {
                    "type": "boolean",
                    "example": false
                }
            }
        },
        "types.UpdatePromptRepoReq": {
            "type": "object",
            "properties": {
                "description": {
                    "type": "string"
                },
                "nickname": {
                    "type": "string",
                    "example": "model display name"
                },
                "private": {
                    "type": "boolean",
                    "example": false
                }
            }
        },
        "types.UpdateSpaceReq": {
            "type": "object",
            "properties": {
                "cover_image_url": {
                    "type": "string"
                },
                "description": {
                    "type": "string"
                },
                "env": {
                    "type": "string"
                },
                "nickname": {
                    "type": "string",
                    "example": "model display name"
                },
                "private": {
                    "type": "boolean",
                    "example": false
                },
                "resource_id": {
                    "type": "integer"
                },
                "sdk": {
                    "type": "string",
                    "example": "1"
                },
                "sdk_version": {
                    "type": "string",
                    "example": "v0.1"
                },
                "secrets": {
                    "type": "string"
                },
                "template": {
                    "type": "string"
                }
            }
        },
        "types.UpdateSpaceResourceReq": {
            "type": "object",
            "properties": {
                "name": {
                    "type": "string"
                },
                "resources": {
                    "type": "string"
                }
            }
        },
        "types.UpdateSpaceSdkReq": {
            "type": "object",
            "properties": {
                "id": {
                    "type": "integer"
                },
                "name": {
                    "type": "string"
                },
                "version": {
                    "type": "string"
                }
            }
        },
        "types.UpdateUserRequest": {
            "type": "object",
            "properties": {
                "avatar": {
                    "type": "string"
                },
                "bio": {
                    "type": "string"
                },
                "email": {
                    "type": "string"
                },
                "homepage": {
                    "type": "string"
                },
                "name": {
                    "description": "Display name of the user",
                    "type": "string"
                },
                "new_username": {
                    "description": "if use want to change username, this should be the only field to send in request body",
                    "type": "string"
                },
                "phone": {
                    "type": "string"
                },
                "roles": {
                    "description": "should be updated by admin",
                    "type": "array",
                    "items": {
                        "type": "string"
                    },
                    "example": [
                        "[super_user",
                        " admin",
                        " personal_user]"
                    ]
                },
                "uuid": {
                    "type": "string"
                }
            }
        },
        "types.User": {
            "type": "object",
            "properties": {
                "avatar": {
                    "type": "string"
                },
                "bio": {
                    "type": "string"
                },
                "can_change_username": {
                    "type": "boolean"
                },
                "email": {
                    "type": "string"
                },
                "homepage": {
                    "type": "string"
                },
                "id": {
                    "type": "integer"
                },
                "last_login_at": {
                    "type": "string"
                },
                "nickname": {
                    "type": "string"
                },
                "orgs": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/types.Organization"
                    }
                },
                "phone": {
                    "type": "string"
                },
                "roles": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "username": {
                    "type": "string"
                },
                "uuid": {
                    "type": "string"
                }
            }
        }
    },
    "securityDefinitions": {
        "ApiKey": {
            "description": "Bearer token",
            "type": "apiKey",
            "name": "Authorization",
            "in": "header"
        }
    }
}`

// SwaggerInfo holds exported Swagger Info so clients can modify it
var SwaggerInfo = &swag.Spec{
	Version:          "",
	Host:             "",
	BasePath:         "",
	Schemes:          []string{},
	Title:            "",
	Description:      "",
	InfoInstanceName: "swagger",
	SwaggerTemplate:  docTemplate,
	LeftDelim:        "{{",
	RightDelim:       "}}",
}

func init() {
	swag.Register(SwaggerInfo.InstanceName(), SwaggerInfo)
}
