// Code generated by mockery v2.48.0. DO NOT EDIT.

package database

import (
	context "context"

	bun "github.com/uptrace/bun"

	database "opencsg.com/csghub-server/builder/store/database"

	mock "github.com/stretchr/testify/mock"

	time "time"

	types "opencsg.com/csghub-server/common/types"
)

// MockRepoStore is an autogenerated mock type for the RepoStore type
type MockRepoStore struct {
	mock.Mock
}

type MockRepoStore_Expecter struct {
	mock *mock.Mock
}

func (_m *MockRepoStore) EXPECT() *MockRepoStore_Expecter {
	return &MockRepoStore_Expecter{mock: &_m.Mock}
}

// All provides a mock function with given fields: ctx
func (_m *MockRepoStore) All(ctx context.Context) ([]*database.Repository, error) {
	ret := _m.Called(ctx)

	if len(ret) == 0 {
		panic("no return value specified for All")
	}

	var r0 []*database.Repository
	var r1 error
	if rf, ok := ret.Get(0).(func(context.Context) ([]*database.Repository, error)); ok {
		return rf(ctx)
	}
	if rf, ok := ret.Get(0).(func(context.Context) []*database.Repository); ok {
		r0 = rf(ctx)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*database.Repository)
		}
	}

	if rf, ok := ret.Get(1).(func(context.Context) error); ok {
		r1 = rf(ctx)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// MockRepoStore_All_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'All'
type MockRepoStore_All_Call struct {
	*mock.Call
}

// All is a helper method to define mock.On call
//   - ctx context.Context
func (_e *MockRepoStore_Expecter) All(ctx interface{}) *MockRepoStore_All_Call {
	return &MockRepoStore_All_Call{Call: _e.mock.On("All", ctx)}
}

func (_c *MockRepoStore_All_Call) Run(run func(ctx context.Context)) *MockRepoStore_All_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(context.Context))
	})
	return _c
}

func (_c *MockRepoStore_All_Call) Return(_a0 []*database.Repository, _a1 error) *MockRepoStore_All_Call {
	_c.Call.Return(_a0, _a1)
	return _c
}

func (_c *MockRepoStore_All_Call) RunAndReturn(run func(context.Context) ([]*database.Repository, error)) *MockRepoStore_All_Call {
	_c.Call.Return(run)
	return _c
}

// BatchCreateRepoTags provides a mock function with given fields: ctx, repoTags
func (_m *MockRepoStore) BatchCreateRepoTags(ctx context.Context, repoTags []database.RepositoryTag) error {
	ret := _m.Called(ctx, repoTags)

	if len(ret) == 0 {
		panic("no return value specified for BatchCreateRepoTags")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, []database.RepositoryTag) error); ok {
		r0 = rf(ctx, repoTags)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// MockRepoStore_BatchCreateRepoTags_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'BatchCreateRepoTags'
type MockRepoStore_BatchCreateRepoTags_Call struct {
	*mock.Call
}

// BatchCreateRepoTags is a helper method to define mock.On call
//   - ctx context.Context
//   - repoTags []database.RepositoryTag
func (_e *MockRepoStore_Expecter) BatchCreateRepoTags(ctx interface{}, repoTags interface{}) *MockRepoStore_BatchCreateRepoTags_Call {
	return &MockRepoStore_BatchCreateRepoTags_Call{Call: _e.mock.On("BatchCreateRepoTags", ctx, repoTags)}
}

func (_c *MockRepoStore_BatchCreateRepoTags_Call) Run(run func(ctx context.Context, repoTags []database.RepositoryTag)) *MockRepoStore_BatchCreateRepoTags_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(context.Context), args[1].([]database.RepositoryTag))
	})
	return _c
}

func (_c *MockRepoStore_BatchCreateRepoTags_Call) Return(_a0 error) *MockRepoStore_BatchCreateRepoTags_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockRepoStore_BatchCreateRepoTags_Call) RunAndReturn(run func(context.Context, []database.RepositoryTag) error) *MockRepoStore_BatchCreateRepoTags_Call {
	_c.Call.Return(run)
	return _c
}

// BatchGet provides a mock function with given fields: ctx, repoType, lastRepoID, batch
func (_m *MockRepoStore) BatchGet(ctx context.Context, repoType types.RepositoryType, lastRepoID int64, batch int) ([]database.Repository, error) {
	ret := _m.Called(ctx, repoType, lastRepoID, batch)

	if len(ret) == 0 {
		panic("no return value specified for BatchGet")
	}

	var r0 []database.Repository
	var r1 error
	if rf, ok := ret.Get(0).(func(context.Context, types.RepositoryType, int64, int) ([]database.Repository, error)); ok {
		return rf(ctx, repoType, lastRepoID, batch)
	}
	if rf, ok := ret.Get(0).(func(context.Context, types.RepositoryType, int64, int) []database.Repository); ok {
		r0 = rf(ctx, repoType, lastRepoID, batch)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]database.Repository)
		}
	}

	if rf, ok := ret.Get(1).(func(context.Context, types.RepositoryType, int64, int) error); ok {
		r1 = rf(ctx, repoType, lastRepoID, batch)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// MockRepoStore_BatchGet_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'BatchGet'
type MockRepoStore_BatchGet_Call struct {
	*mock.Call
}

// BatchGet is a helper method to define mock.On call
//   - ctx context.Context
//   - repoType types.RepositoryType
//   - lastRepoID int64
//   - batch int
func (_e *MockRepoStore_Expecter) BatchGet(ctx interface{}, repoType interface{}, lastRepoID interface{}, batch interface{}) *MockRepoStore_BatchGet_Call {
	return &MockRepoStore_BatchGet_Call{Call: _e.mock.On("BatchGet", ctx, repoType, lastRepoID, batch)}
}

func (_c *MockRepoStore_BatchGet_Call) Run(run func(ctx context.Context, repoType types.RepositoryType, lastRepoID int64, batch int)) *MockRepoStore_BatchGet_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(context.Context), args[1].(types.RepositoryType), args[2].(int64), args[3].(int))
	})
	return _c
}

func (_c *MockRepoStore_BatchGet_Call) Return(_a0 []database.Repository, _a1 error) *MockRepoStore_BatchGet_Call {
	_c.Call.Return(_a0, _a1)
	return _c
}

func (_c *MockRepoStore_BatchGet_Call) RunAndReturn(run func(context.Context, types.RepositoryType, int64, int) ([]database.Repository, error)) *MockRepoStore_BatchGet_Call {
	_c.Call.Return(run)
	return _c
}

// ByUser provides a mock function with given fields: ctx, userID
func (_m *MockRepoStore) ByUser(ctx context.Context, userID int64) ([]database.Repository, error) {
	ret := _m.Called(ctx, userID)

	if len(ret) == 0 {
		panic("no return value specified for ByUser")
	}

	var r0 []database.Repository
	var r1 error
	if rf, ok := ret.Get(0).(func(context.Context, int64) ([]database.Repository, error)); ok {
		return rf(ctx, userID)
	}
	if rf, ok := ret.Get(0).(func(context.Context, int64) []database.Repository); ok {
		r0 = rf(ctx, userID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]database.Repository)
		}
	}

	if rf, ok := ret.Get(1).(func(context.Context, int64) error); ok {
		r1 = rf(ctx, userID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// MockRepoStore_ByUser_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'ByUser'
type MockRepoStore_ByUser_Call struct {
	*mock.Call
}

// ByUser is a helper method to define mock.On call
//   - ctx context.Context
//   - userID int64
func (_e *MockRepoStore_Expecter) ByUser(ctx interface{}, userID interface{}) *MockRepoStore_ByUser_Call {
	return &MockRepoStore_ByUser_Call{Call: _e.mock.On("ByUser", ctx, userID)}
}

func (_c *MockRepoStore_ByUser_Call) Run(run func(ctx context.Context, userID int64)) *MockRepoStore_ByUser_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(context.Context), args[1].(int64))
	})
	return _c
}

func (_c *MockRepoStore_ByUser_Call) Return(_a0 []database.Repository, _a1 error) *MockRepoStore_ByUser_Call {
	_c.Call.Return(_a0, _a1)
	return _c
}

func (_c *MockRepoStore_ByUser_Call) RunAndReturn(run func(context.Context, int64) ([]database.Repository, error)) *MockRepoStore_ByUser_Call {
	_c.Call.Return(run)
	return _c
}

// CleanRelationsByRepoID provides a mock function with given fields: ctx, repoId
func (_m *MockRepoStore) CleanRelationsByRepoID(ctx context.Context, repoId int64) error {
	ret := _m.Called(ctx, repoId)

	if len(ret) == 0 {
		panic("no return value specified for CleanRelationsByRepoID")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, int64) error); ok {
		r0 = rf(ctx, repoId)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// MockRepoStore_CleanRelationsByRepoID_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'CleanRelationsByRepoID'
type MockRepoStore_CleanRelationsByRepoID_Call struct {
	*mock.Call
}

// CleanRelationsByRepoID is a helper method to define mock.On call
//   - ctx context.Context
//   - repoId int64
func (_e *MockRepoStore_Expecter) CleanRelationsByRepoID(ctx interface{}, repoId interface{}) *MockRepoStore_CleanRelationsByRepoID_Call {
	return &MockRepoStore_CleanRelationsByRepoID_Call{Call: _e.mock.On("CleanRelationsByRepoID", ctx, repoId)}
}

func (_c *MockRepoStore_CleanRelationsByRepoID_Call) Run(run func(ctx context.Context, repoId int64)) *MockRepoStore_CleanRelationsByRepoID_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(context.Context), args[1].(int64))
	})
	return _c
}

func (_c *MockRepoStore_CleanRelationsByRepoID_Call) Return(_a0 error) *MockRepoStore_CleanRelationsByRepoID_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockRepoStore_CleanRelationsByRepoID_Call) RunAndReturn(run func(context.Context, int64) error) *MockRepoStore_CleanRelationsByRepoID_Call {
	_c.Call.Return(run)
	return _c
}

// CountByRepoType provides a mock function with given fields: ctx, repoType
func (_m *MockRepoStore) CountByRepoType(ctx context.Context, repoType types.RepositoryType) (int, error) {
	ret := _m.Called(ctx, repoType)

	if len(ret) == 0 {
		panic("no return value specified for CountByRepoType")
	}

	var r0 int
	var r1 error
	if rf, ok := ret.Get(0).(func(context.Context, types.RepositoryType) (int, error)); ok {
		return rf(ctx, repoType)
	}
	if rf, ok := ret.Get(0).(func(context.Context, types.RepositoryType) int); ok {
		r0 = rf(ctx, repoType)
	} else {
		r0 = ret.Get(0).(int)
	}

	if rf, ok := ret.Get(1).(func(context.Context, types.RepositoryType) error); ok {
		r1 = rf(ctx, repoType)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// MockRepoStore_CountByRepoType_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'CountByRepoType'
type MockRepoStore_CountByRepoType_Call struct {
	*mock.Call
}

// CountByRepoType is a helper method to define mock.On call
//   - ctx context.Context
//   - repoType types.RepositoryType
func (_e *MockRepoStore_Expecter) CountByRepoType(ctx interface{}, repoType interface{}) *MockRepoStore_CountByRepoType_Call {
	return &MockRepoStore_CountByRepoType_Call{Call: _e.mock.On("CountByRepoType", ctx, repoType)}
}

func (_c *MockRepoStore_CountByRepoType_Call) Run(run func(ctx context.Context, repoType types.RepositoryType)) *MockRepoStore_CountByRepoType_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(context.Context), args[1].(types.RepositoryType))
	})
	return _c
}

func (_c *MockRepoStore_CountByRepoType_Call) Return(_a0 int, _a1 error) *MockRepoStore_CountByRepoType_Call {
	_c.Call.Return(_a0, _a1)
	return _c
}

func (_c *MockRepoStore_CountByRepoType_Call) RunAndReturn(run func(context.Context, types.RepositoryType) (int, error)) *MockRepoStore_CountByRepoType_Call {
	_c.Call.Return(run)
	return _c
}

// CreateRepo provides a mock function with given fields: ctx, input
func (_m *MockRepoStore) CreateRepo(ctx context.Context, input database.Repository) (*database.Repository, error) {
	ret := _m.Called(ctx, input)

	if len(ret) == 0 {
		panic("no return value specified for CreateRepo")
	}

	var r0 *database.Repository
	var r1 error
	if rf, ok := ret.Get(0).(func(context.Context, database.Repository) (*database.Repository, error)); ok {
		return rf(ctx, input)
	}
	if rf, ok := ret.Get(0).(func(context.Context, database.Repository) *database.Repository); ok {
		r0 = rf(ctx, input)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*database.Repository)
		}
	}

	if rf, ok := ret.Get(1).(func(context.Context, database.Repository) error); ok {
		r1 = rf(ctx, input)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// MockRepoStore_CreateRepo_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'CreateRepo'
type MockRepoStore_CreateRepo_Call struct {
	*mock.Call
}

// CreateRepo is a helper method to define mock.On call
//   - ctx context.Context
//   - input database.Repository
func (_e *MockRepoStore_Expecter) CreateRepo(ctx interface{}, input interface{}) *MockRepoStore_CreateRepo_Call {
	return &MockRepoStore_CreateRepo_Call{Call: _e.mock.On("CreateRepo", ctx, input)}
}

func (_c *MockRepoStore_CreateRepo_Call) Run(run func(ctx context.Context, input database.Repository)) *MockRepoStore_CreateRepo_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(context.Context), args[1].(database.Repository))
	})
	return _c
}

func (_c *MockRepoStore_CreateRepo_Call) Return(_a0 *database.Repository, _a1 error) *MockRepoStore_CreateRepo_Call {
	_c.Call.Return(_a0, _a1)
	return _c
}

func (_c *MockRepoStore_CreateRepo_Call) RunAndReturn(run func(context.Context, database.Repository) (*database.Repository, error)) *MockRepoStore_CreateRepo_Call {
	_c.Call.Return(run)
	return _c
}

// CreateRepoTx provides a mock function with given fields: ctx, tx, input
func (_m *MockRepoStore) CreateRepoTx(ctx context.Context, tx bun.Tx, input database.Repository) (*database.Repository, error) {
	ret := _m.Called(ctx, tx, input)

	if len(ret) == 0 {
		panic("no return value specified for CreateRepoTx")
	}

	var r0 *database.Repository
	var r1 error
	if rf, ok := ret.Get(0).(func(context.Context, bun.Tx, database.Repository) (*database.Repository, error)); ok {
		return rf(ctx, tx, input)
	}
	if rf, ok := ret.Get(0).(func(context.Context, bun.Tx, database.Repository) *database.Repository); ok {
		r0 = rf(ctx, tx, input)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*database.Repository)
		}
	}

	if rf, ok := ret.Get(1).(func(context.Context, bun.Tx, database.Repository) error); ok {
		r1 = rf(ctx, tx, input)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// MockRepoStore_CreateRepoTx_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'CreateRepoTx'
type MockRepoStore_CreateRepoTx_Call struct {
	*mock.Call
}

// CreateRepoTx is a helper method to define mock.On call
//   - ctx context.Context
//   - tx bun.Tx
//   - input database.Repository
func (_e *MockRepoStore_Expecter) CreateRepoTx(ctx interface{}, tx interface{}, input interface{}) *MockRepoStore_CreateRepoTx_Call {
	return &MockRepoStore_CreateRepoTx_Call{Call: _e.mock.On("CreateRepoTx", ctx, tx, input)}
}

func (_c *MockRepoStore_CreateRepoTx_Call) Run(run func(ctx context.Context, tx bun.Tx, input database.Repository)) *MockRepoStore_CreateRepoTx_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(context.Context), args[1].(bun.Tx), args[2].(database.Repository))
	})
	return _c
}

func (_c *MockRepoStore_CreateRepoTx_Call) Return(_a0 *database.Repository, _a1 error) *MockRepoStore_CreateRepoTx_Call {
	_c.Call.Return(_a0, _a1)
	return _c
}

func (_c *MockRepoStore_CreateRepoTx_Call) RunAndReturn(run func(context.Context, bun.Tx, database.Repository) (*database.Repository, error)) *MockRepoStore_CreateRepoTx_Call {
	_c.Call.Return(run)
	return _c
}

// DeleteAllFiles provides a mock function with given fields: ctx, repoID
func (_m *MockRepoStore) DeleteAllFiles(ctx context.Context, repoID int64) error {
	ret := _m.Called(ctx, repoID)

	if len(ret) == 0 {
		panic("no return value specified for DeleteAllFiles")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, int64) error); ok {
		r0 = rf(ctx, repoID)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// MockRepoStore_DeleteAllFiles_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'DeleteAllFiles'
type MockRepoStore_DeleteAllFiles_Call struct {
	*mock.Call
}

// DeleteAllFiles is a helper method to define mock.On call
//   - ctx context.Context
//   - repoID int64
func (_e *MockRepoStore_Expecter) DeleteAllFiles(ctx interface{}, repoID interface{}) *MockRepoStore_DeleteAllFiles_Call {
	return &MockRepoStore_DeleteAllFiles_Call{Call: _e.mock.On("DeleteAllFiles", ctx, repoID)}
}

func (_c *MockRepoStore_DeleteAllFiles_Call) Run(run func(ctx context.Context, repoID int64)) *MockRepoStore_DeleteAllFiles_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(context.Context), args[1].(int64))
	})
	return _c
}

func (_c *MockRepoStore_DeleteAllFiles_Call) Return(_a0 error) *MockRepoStore_DeleteAllFiles_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockRepoStore_DeleteAllFiles_Call) RunAndReturn(run func(context.Context, int64) error) *MockRepoStore_DeleteAllFiles_Call {
	_c.Call.Return(run)
	return _c
}

// DeleteAllTags provides a mock function with given fields: ctx, repoID
func (_m *MockRepoStore) DeleteAllTags(ctx context.Context, repoID int64) error {
	ret := _m.Called(ctx, repoID)

	if len(ret) == 0 {
		panic("no return value specified for DeleteAllTags")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, int64) error); ok {
		r0 = rf(ctx, repoID)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// MockRepoStore_DeleteAllTags_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'DeleteAllTags'
type MockRepoStore_DeleteAllTags_Call struct {
	*mock.Call
}

// DeleteAllTags is a helper method to define mock.On call
//   - ctx context.Context
//   - repoID int64
func (_e *MockRepoStore_Expecter) DeleteAllTags(ctx interface{}, repoID interface{}) *MockRepoStore_DeleteAllTags_Call {
	return &MockRepoStore_DeleteAllTags_Call{Call: _e.mock.On("DeleteAllTags", ctx, repoID)}
}

func (_c *MockRepoStore_DeleteAllTags_Call) Run(run func(ctx context.Context, repoID int64)) *MockRepoStore_DeleteAllTags_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(context.Context), args[1].(int64))
	})
	return _c
}

func (_c *MockRepoStore_DeleteAllTags_Call) Return(_a0 error) *MockRepoStore_DeleteAllTags_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockRepoStore_DeleteAllTags_Call) RunAndReturn(run func(context.Context, int64) error) *MockRepoStore_DeleteAllTags_Call {
	_c.Call.Return(run)
	return _c
}

// DeleteRepo provides a mock function with given fields: ctx, input
func (_m *MockRepoStore) DeleteRepo(ctx context.Context, input database.Repository) error {
	ret := _m.Called(ctx, input)

	if len(ret) == 0 {
		panic("no return value specified for DeleteRepo")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, database.Repository) error); ok {
		r0 = rf(ctx, input)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// MockRepoStore_DeleteRepo_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'DeleteRepo'
type MockRepoStore_DeleteRepo_Call struct {
	*mock.Call
}

// DeleteRepo is a helper method to define mock.On call
//   - ctx context.Context
//   - input database.Repository
func (_e *MockRepoStore_Expecter) DeleteRepo(ctx interface{}, input interface{}) *MockRepoStore_DeleteRepo_Call {
	return &MockRepoStore_DeleteRepo_Call{Call: _e.mock.On("DeleteRepo", ctx, input)}
}

func (_c *MockRepoStore_DeleteRepo_Call) Run(run func(ctx context.Context, input database.Repository)) *MockRepoStore_DeleteRepo_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(context.Context), args[1].(database.Repository))
	})
	return _c
}

func (_c *MockRepoStore_DeleteRepo_Call) Return(_a0 error) *MockRepoStore_DeleteRepo_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockRepoStore_DeleteRepo_Call) RunAndReturn(run func(context.Context, database.Repository) error) *MockRepoStore_DeleteRepo_Call {
	_c.Call.Return(run)
	return _c
}

// Exists provides a mock function with given fields: ctx, repoType, namespace, name
func (_m *MockRepoStore) Exists(ctx context.Context, repoType types.RepositoryType, namespace string, name string) (bool, error) {
	ret := _m.Called(ctx, repoType, namespace, name)

	if len(ret) == 0 {
		panic("no return value specified for Exists")
	}

	var r0 bool
	var r1 error
	if rf, ok := ret.Get(0).(func(context.Context, types.RepositoryType, string, string) (bool, error)); ok {
		return rf(ctx, repoType, namespace, name)
	}
	if rf, ok := ret.Get(0).(func(context.Context, types.RepositoryType, string, string) bool); ok {
		r0 = rf(ctx, repoType, namespace, name)
	} else {
		r0 = ret.Get(0).(bool)
	}

	if rf, ok := ret.Get(1).(func(context.Context, types.RepositoryType, string, string) error); ok {
		r1 = rf(ctx, repoType, namespace, name)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// MockRepoStore_Exists_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'Exists'
type MockRepoStore_Exists_Call struct {
	*mock.Call
}

// Exists is a helper method to define mock.On call
//   - ctx context.Context
//   - repoType types.RepositoryType
//   - namespace string
//   - name string
func (_e *MockRepoStore_Expecter) Exists(ctx interface{}, repoType interface{}, namespace interface{}, name interface{}) *MockRepoStore_Exists_Call {
	return &MockRepoStore_Exists_Call{Call: _e.mock.On("Exists", ctx, repoType, namespace, name)}
}

func (_c *MockRepoStore_Exists_Call) Run(run func(ctx context.Context, repoType types.RepositoryType, namespace string, name string)) *MockRepoStore_Exists_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(context.Context), args[1].(types.RepositoryType), args[2].(string), args[3].(string))
	})
	return _c
}

func (_c *MockRepoStore_Exists_Call) Return(_a0 bool, _a1 error) *MockRepoStore_Exists_Call {
	_c.Call.Return(_a0, _a1)
	return _c
}

func (_c *MockRepoStore_Exists_Call) RunAndReturn(run func(context.Context, types.RepositoryType, string, string) (bool, error)) *MockRepoStore_Exists_Call {
	_c.Call.Return(run)
	return _c
}

// Find provides a mock function with given fields: ctx, owner, repoType, repoName
func (_m *MockRepoStore) Find(ctx context.Context, owner string, repoType string, repoName string) (*database.Repository, error) {
	ret := _m.Called(ctx, owner, repoType, repoName)

	if len(ret) == 0 {
		panic("no return value specified for Find")
	}

	var r0 *database.Repository
	var r1 error
	if rf, ok := ret.Get(0).(func(context.Context, string, string, string) (*database.Repository, error)); ok {
		return rf(ctx, owner, repoType, repoName)
	}
	if rf, ok := ret.Get(0).(func(context.Context, string, string, string) *database.Repository); ok {
		r0 = rf(ctx, owner, repoType, repoName)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*database.Repository)
		}
	}

	if rf, ok := ret.Get(1).(func(context.Context, string, string, string) error); ok {
		r1 = rf(ctx, owner, repoType, repoName)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// MockRepoStore_Find_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'Find'
type MockRepoStore_Find_Call struct {
	*mock.Call
}

// Find is a helper method to define mock.On call
//   - ctx context.Context
//   - owner string
//   - repoType string
//   - repoName string
func (_e *MockRepoStore_Expecter) Find(ctx interface{}, owner interface{}, repoType interface{}, repoName interface{}) *MockRepoStore_Find_Call {
	return &MockRepoStore_Find_Call{Call: _e.mock.On("Find", ctx, owner, repoType, repoName)}
}

func (_c *MockRepoStore_Find_Call) Run(run func(ctx context.Context, owner string, repoType string, repoName string)) *MockRepoStore_Find_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(context.Context), args[1].(string), args[2].(string), args[3].(string))
	})
	return _c
}

func (_c *MockRepoStore_Find_Call) Return(_a0 *database.Repository, _a1 error) *MockRepoStore_Find_Call {
	_c.Call.Return(_a0, _a1)
	return _c
}

func (_c *MockRepoStore_Find_Call) RunAndReturn(run func(context.Context, string, string, string) (*database.Repository, error)) *MockRepoStore_Find_Call {
	_c.Call.Return(run)
	return _c
}

// FindByGitPath provides a mock function with given fields: ctx, path
func (_m *MockRepoStore) FindByGitPath(ctx context.Context, path string) (*database.Repository, error) {
	ret := _m.Called(ctx, path)

	if len(ret) == 0 {
		panic("no return value specified for FindByGitPath")
	}

	var r0 *database.Repository
	var r1 error
	if rf, ok := ret.Get(0).(func(context.Context, string) (*database.Repository, error)); ok {
		return rf(ctx, path)
	}
	if rf, ok := ret.Get(0).(func(context.Context, string) *database.Repository); ok {
		r0 = rf(ctx, path)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*database.Repository)
		}
	}

	if rf, ok := ret.Get(1).(func(context.Context, string) error); ok {
		r1 = rf(ctx, path)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// MockRepoStore_FindByGitPath_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'FindByGitPath'
type MockRepoStore_FindByGitPath_Call struct {
	*mock.Call
}

// FindByGitPath is a helper method to define mock.On call
//   - ctx context.Context
//   - path string
func (_e *MockRepoStore_Expecter) FindByGitPath(ctx interface{}, path interface{}) *MockRepoStore_FindByGitPath_Call {
	return &MockRepoStore_FindByGitPath_Call{Call: _e.mock.On("FindByGitPath", ctx, path)}
}

func (_c *MockRepoStore_FindByGitPath_Call) Run(run func(ctx context.Context, path string)) *MockRepoStore_FindByGitPath_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(context.Context), args[1].(string))
	})
	return _c
}

func (_c *MockRepoStore_FindByGitPath_Call) Return(_a0 *database.Repository, _a1 error) *MockRepoStore_FindByGitPath_Call {
	_c.Call.Return(_a0, _a1)
	return _c
}

func (_c *MockRepoStore_FindByGitPath_Call) RunAndReturn(run func(context.Context, string) (*database.Repository, error)) *MockRepoStore_FindByGitPath_Call {
	_c.Call.Return(run)
	return _c
}

// FindByGitPaths provides a mock function with given fields: ctx, paths, opts
func (_m *MockRepoStore) FindByGitPaths(ctx context.Context, paths []string, opts ...database.SelectOption) ([]*database.Repository, error) {
	_va := make([]interface{}, len(opts))
	for _i := range opts {
		_va[_i] = opts[_i]
	}
	var _ca []interface{}
	_ca = append(_ca, ctx, paths)
	_ca = append(_ca, _va...)
	ret := _m.Called(_ca...)

	if len(ret) == 0 {
		panic("no return value specified for FindByGitPaths")
	}

	var r0 []*database.Repository
	var r1 error
	if rf, ok := ret.Get(0).(func(context.Context, []string, ...database.SelectOption) ([]*database.Repository, error)); ok {
		return rf(ctx, paths, opts...)
	}
	if rf, ok := ret.Get(0).(func(context.Context, []string, ...database.SelectOption) []*database.Repository); ok {
		r0 = rf(ctx, paths, opts...)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*database.Repository)
		}
	}

	if rf, ok := ret.Get(1).(func(context.Context, []string, ...database.SelectOption) error); ok {
		r1 = rf(ctx, paths, opts...)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// MockRepoStore_FindByGitPaths_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'FindByGitPaths'
type MockRepoStore_FindByGitPaths_Call struct {
	*mock.Call
}

// FindByGitPaths is a helper method to define mock.On call
//   - ctx context.Context
//   - paths []string
//   - opts ...database.SelectOption
func (_e *MockRepoStore_Expecter) FindByGitPaths(ctx interface{}, paths interface{}, opts ...interface{}) *MockRepoStore_FindByGitPaths_Call {
	return &MockRepoStore_FindByGitPaths_Call{Call: _e.mock.On("FindByGitPaths",
		append([]interface{}{ctx, paths}, opts...)...)}
}

func (_c *MockRepoStore_FindByGitPaths_Call) Run(run func(ctx context.Context, paths []string, opts ...database.SelectOption)) *MockRepoStore_FindByGitPaths_Call {
	_c.Call.Run(func(args mock.Arguments) {
		variadicArgs := make([]database.SelectOption, len(args)-2)
		for i, a := range args[2:] {
			if a != nil {
				variadicArgs[i] = a.(database.SelectOption)
			}
		}
		run(args[0].(context.Context), args[1].([]string), variadicArgs...)
	})
	return _c
}

func (_c *MockRepoStore_FindByGitPaths_Call) Return(_a0 []*database.Repository, _a1 error) *MockRepoStore_FindByGitPaths_Call {
	_c.Call.Return(_a0, _a1)
	return _c
}

func (_c *MockRepoStore_FindByGitPaths_Call) RunAndReturn(run func(context.Context, []string, ...database.SelectOption) ([]*database.Repository, error)) *MockRepoStore_FindByGitPaths_Call {
	_c.Call.Return(run)
	return _c
}

// FindById provides a mock function with given fields: ctx, id
func (_m *MockRepoStore) FindById(ctx context.Context, id int64) (*database.Repository, error) {
	ret := _m.Called(ctx, id)

	if len(ret) == 0 {
		panic("no return value specified for FindById")
	}

	var r0 *database.Repository
	var r1 error
	if rf, ok := ret.Get(0).(func(context.Context, int64) (*database.Repository, error)); ok {
		return rf(ctx, id)
	}
	if rf, ok := ret.Get(0).(func(context.Context, int64) *database.Repository); ok {
		r0 = rf(ctx, id)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*database.Repository)
		}
	}

	if rf, ok := ret.Get(1).(func(context.Context, int64) error); ok {
		r1 = rf(ctx, id)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// MockRepoStore_FindById_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'FindById'
type MockRepoStore_FindById_Call struct {
	*mock.Call
}

// FindById is a helper method to define mock.On call
//   - ctx context.Context
//   - id int64
func (_e *MockRepoStore_Expecter) FindById(ctx interface{}, id interface{}) *MockRepoStore_FindById_Call {
	return &MockRepoStore_FindById_Call{Call: _e.mock.On("FindById", ctx, id)}
}

func (_c *MockRepoStore_FindById_Call) Run(run func(ctx context.Context, id int64)) *MockRepoStore_FindById_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(context.Context), args[1].(int64))
	})
	return _c
}

func (_c *MockRepoStore_FindById_Call) Return(_a0 *database.Repository, _a1 error) *MockRepoStore_FindById_Call {
	_c.Call.Return(_a0, _a1)
	return _c
}

func (_c *MockRepoStore_FindById_Call) RunAndReturn(run func(context.Context, int64) (*database.Repository, error)) *MockRepoStore_FindById_Call {
	_c.Call.Return(run)
	return _c
}

// FindByIds provides a mock function with given fields: ctx, ids, opts
func (_m *MockRepoStore) FindByIds(ctx context.Context, ids []int64, opts ...database.SelectOption) ([]*database.Repository, error) {
	_va := make([]interface{}, len(opts))
	for _i := range opts {
		_va[_i] = opts[_i]
	}
	var _ca []interface{}
	_ca = append(_ca, ctx, ids)
	_ca = append(_ca, _va...)
	ret := _m.Called(_ca...)

	if len(ret) == 0 {
		panic("no return value specified for FindByIds")
	}

	var r0 []*database.Repository
	var r1 error
	if rf, ok := ret.Get(0).(func(context.Context, []int64, ...database.SelectOption) ([]*database.Repository, error)); ok {
		return rf(ctx, ids, opts...)
	}
	if rf, ok := ret.Get(0).(func(context.Context, []int64, ...database.SelectOption) []*database.Repository); ok {
		r0 = rf(ctx, ids, opts...)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*database.Repository)
		}
	}

	if rf, ok := ret.Get(1).(func(context.Context, []int64, ...database.SelectOption) error); ok {
		r1 = rf(ctx, ids, opts...)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// MockRepoStore_FindByIds_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'FindByIds'
type MockRepoStore_FindByIds_Call struct {
	*mock.Call
}

// FindByIds is a helper method to define mock.On call
//   - ctx context.Context
//   - ids []int64
//   - opts ...database.SelectOption
func (_e *MockRepoStore_Expecter) FindByIds(ctx interface{}, ids interface{}, opts ...interface{}) *MockRepoStore_FindByIds_Call {
	return &MockRepoStore_FindByIds_Call{Call: _e.mock.On("FindByIds",
		append([]interface{}{ctx, ids}, opts...)...)}
}

func (_c *MockRepoStore_FindByIds_Call) Run(run func(ctx context.Context, ids []int64, opts ...database.SelectOption)) *MockRepoStore_FindByIds_Call {
	_c.Call.Run(func(args mock.Arguments) {
		variadicArgs := make([]database.SelectOption, len(args)-2)
		for i, a := range args[2:] {
			if a != nil {
				variadicArgs[i] = a.(database.SelectOption)
			}
		}
		run(args[0].(context.Context), args[1].([]int64), variadicArgs...)
	})
	return _c
}

func (_c *MockRepoStore_FindByIds_Call) Return(_a0 []*database.Repository, _a1 error) *MockRepoStore_FindByIds_Call {
	_c.Call.Return(_a0, _a1)
	return _c
}

func (_c *MockRepoStore_FindByIds_Call) RunAndReturn(run func(context.Context, []int64, ...database.SelectOption) ([]*database.Repository, error)) *MockRepoStore_FindByIds_Call {
	_c.Call.Return(run)
	return _c
}

// FindByPath provides a mock function with given fields: ctx, repoType, namespace, name
func (_m *MockRepoStore) FindByPath(ctx context.Context, repoType types.RepositoryType, namespace string, name string) (*database.Repository, error) {
	ret := _m.Called(ctx, repoType, namespace, name)

	if len(ret) == 0 {
		panic("no return value specified for FindByPath")
	}

	var r0 *database.Repository
	var r1 error
	if rf, ok := ret.Get(0).(func(context.Context, types.RepositoryType, string, string) (*database.Repository, error)); ok {
		return rf(ctx, repoType, namespace, name)
	}
	if rf, ok := ret.Get(0).(func(context.Context, types.RepositoryType, string, string) *database.Repository); ok {
		r0 = rf(ctx, repoType, namespace, name)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*database.Repository)
		}
	}

	if rf, ok := ret.Get(1).(func(context.Context, types.RepositoryType, string, string) error); ok {
		r1 = rf(ctx, repoType, namespace, name)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// MockRepoStore_FindByPath_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'FindByPath'
type MockRepoStore_FindByPath_Call struct {
	*mock.Call
}

// FindByPath is a helper method to define mock.On call
//   - ctx context.Context
//   - repoType types.RepositoryType
//   - namespace string
//   - name string
func (_e *MockRepoStore_Expecter) FindByPath(ctx interface{}, repoType interface{}, namespace interface{}, name interface{}) *MockRepoStore_FindByPath_Call {
	return &MockRepoStore_FindByPath_Call{Call: _e.mock.On("FindByPath", ctx, repoType, namespace, name)}
}

func (_c *MockRepoStore_FindByPath_Call) Run(run func(ctx context.Context, repoType types.RepositoryType, namespace string, name string)) *MockRepoStore_FindByPath_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(context.Context), args[1].(types.RepositoryType), args[2].(string), args[3].(string))
	})
	return _c
}

func (_c *MockRepoStore_FindByPath_Call) Return(_a0 *database.Repository, _a1 error) *MockRepoStore_FindByPath_Call {
	_c.Call.Return(_a0, _a1)
	return _c
}

func (_c *MockRepoStore_FindByPath_Call) RunAndReturn(run func(context.Context, types.RepositoryType, string, string) (*database.Repository, error)) *MockRepoStore_FindByPath_Call {
	_c.Call.Return(run)
	return _c
}

// FindByRepoSourceWithBatch provides a mock function with given fields: ctx, repoSource, batchSize, batch
func (_m *MockRepoStore) FindByRepoSourceWithBatch(ctx context.Context, repoSource types.RepositorySource, batchSize int, batch int) ([]database.Repository, error) {
	ret := _m.Called(ctx, repoSource, batchSize, batch)

	if len(ret) == 0 {
		panic("no return value specified for FindByRepoSourceWithBatch")
	}

	var r0 []database.Repository
	var r1 error
	if rf, ok := ret.Get(0).(func(context.Context, types.RepositorySource, int, int) ([]database.Repository, error)); ok {
		return rf(ctx, repoSource, batchSize, batch)
	}
	if rf, ok := ret.Get(0).(func(context.Context, types.RepositorySource, int, int) []database.Repository); ok {
		r0 = rf(ctx, repoSource, batchSize, batch)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]database.Repository)
		}
	}

	if rf, ok := ret.Get(1).(func(context.Context, types.RepositorySource, int, int) error); ok {
		r1 = rf(ctx, repoSource, batchSize, batch)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// MockRepoStore_FindByRepoSourceWithBatch_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'FindByRepoSourceWithBatch'
type MockRepoStore_FindByRepoSourceWithBatch_Call struct {
	*mock.Call
}

// FindByRepoSourceWithBatch is a helper method to define mock.On call
//   - ctx context.Context
//   - repoSource types.RepositorySource
//   - batchSize int
//   - batch int
func (_e *MockRepoStore_Expecter) FindByRepoSourceWithBatch(ctx interface{}, repoSource interface{}, batchSize interface{}, batch interface{}) *MockRepoStore_FindByRepoSourceWithBatch_Call {
	return &MockRepoStore_FindByRepoSourceWithBatch_Call{Call: _e.mock.On("FindByRepoSourceWithBatch", ctx, repoSource, batchSize, batch)}
}

func (_c *MockRepoStore_FindByRepoSourceWithBatch_Call) Run(run func(ctx context.Context, repoSource types.RepositorySource, batchSize int, batch int)) *MockRepoStore_FindByRepoSourceWithBatch_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(context.Context), args[1].(types.RepositorySource), args[2].(int), args[3].(int))
	})
	return _c
}

func (_c *MockRepoStore_FindByRepoSourceWithBatch_Call) Return(_a0 []database.Repository, _a1 error) *MockRepoStore_FindByRepoSourceWithBatch_Call {
	_c.Call.Return(_a0, _a1)
	return _c
}

func (_c *MockRepoStore_FindByRepoSourceWithBatch_Call) RunAndReturn(run func(context.Context, types.RepositorySource, int, int) ([]database.Repository, error)) *MockRepoStore_FindByRepoSourceWithBatch_Call {
	_c.Call.Return(run)
	return _c
}

// FindWithBatch provides a mock function with given fields: ctx, batchSize, batch
func (_m *MockRepoStore) FindWithBatch(ctx context.Context, batchSize int, batch int) ([]database.Repository, error) {
	ret := _m.Called(ctx, batchSize, batch)

	if len(ret) == 0 {
		panic("no return value specified for FindWithBatch")
	}

	var r0 []database.Repository
	var r1 error
	if rf, ok := ret.Get(0).(func(context.Context, int, int) ([]database.Repository, error)); ok {
		return rf(ctx, batchSize, batch)
	}
	if rf, ok := ret.Get(0).(func(context.Context, int, int) []database.Repository); ok {
		r0 = rf(ctx, batchSize, batch)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]database.Repository)
		}
	}

	if rf, ok := ret.Get(1).(func(context.Context, int, int) error); ok {
		r1 = rf(ctx, batchSize, batch)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// MockRepoStore_FindWithBatch_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'FindWithBatch'
type MockRepoStore_FindWithBatch_Call struct {
	*mock.Call
}

// FindWithBatch is a helper method to define mock.On call
//   - ctx context.Context
//   - batchSize int
//   - batch int
func (_e *MockRepoStore_Expecter) FindWithBatch(ctx interface{}, batchSize interface{}, batch interface{}) *MockRepoStore_FindWithBatch_Call {
	return &MockRepoStore_FindWithBatch_Call{Call: _e.mock.On("FindWithBatch", ctx, batchSize, batch)}
}

func (_c *MockRepoStore_FindWithBatch_Call) Run(run func(ctx context.Context, batchSize int, batch int)) *MockRepoStore_FindWithBatch_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(context.Context), args[1].(int), args[2].(int))
	})
	return _c
}

func (_c *MockRepoStore_FindWithBatch_Call) Return(_a0 []database.Repository, _a1 error) *MockRepoStore_FindWithBatch_Call {
	_c.Call.Return(_a0, _a1)
	return _c
}

func (_c *MockRepoStore_FindWithBatch_Call) RunAndReturn(run func(context.Context, int, int) ([]database.Repository, error)) *MockRepoStore_FindWithBatch_Call {
	_c.Call.Return(run)
	return _c
}

// GetRepoWithRuntimeByID provides a mock function with given fields: ctx, rfID, paths
func (_m *MockRepoStore) GetRepoWithRuntimeByID(ctx context.Context, rfID int64, paths []string) ([]database.Repository, error) {
	ret := _m.Called(ctx, rfID, paths)

	if len(ret) == 0 {
		panic("no return value specified for GetRepoWithRuntimeByID")
	}

	var r0 []database.Repository
	var r1 error
	if rf, ok := ret.Get(0).(func(context.Context, int64, []string) ([]database.Repository, error)); ok {
		return rf(ctx, rfID, paths)
	}
	if rf, ok := ret.Get(0).(func(context.Context, int64, []string) []database.Repository); ok {
		r0 = rf(ctx, rfID, paths)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]database.Repository)
		}
	}

	if rf, ok := ret.Get(1).(func(context.Context, int64, []string) error); ok {
		r1 = rf(ctx, rfID, paths)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// MockRepoStore_GetRepoWithRuntimeByID_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetRepoWithRuntimeByID'
type MockRepoStore_GetRepoWithRuntimeByID_Call struct {
	*mock.Call
}

// GetRepoWithRuntimeByID is a helper method to define mock.On call
//   - ctx context.Context
//   - rfID int64
//   - paths []string
func (_e *MockRepoStore_Expecter) GetRepoWithRuntimeByID(ctx interface{}, rfID interface{}, paths interface{}) *MockRepoStore_GetRepoWithRuntimeByID_Call {
	return &MockRepoStore_GetRepoWithRuntimeByID_Call{Call: _e.mock.On("GetRepoWithRuntimeByID", ctx, rfID, paths)}
}

func (_c *MockRepoStore_GetRepoWithRuntimeByID_Call) Run(run func(ctx context.Context, rfID int64, paths []string)) *MockRepoStore_GetRepoWithRuntimeByID_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(context.Context), args[1].(int64), args[2].([]string))
	})
	return _c
}

func (_c *MockRepoStore_GetRepoWithRuntimeByID_Call) Return(_a0 []database.Repository, _a1 error) *MockRepoStore_GetRepoWithRuntimeByID_Call {
	_c.Call.Return(_a0, _a1)
	return _c
}

func (_c *MockRepoStore_GetRepoWithRuntimeByID_Call) RunAndReturn(run func(context.Context, int64, []string) ([]database.Repository, error)) *MockRepoStore_GetRepoWithRuntimeByID_Call {
	_c.Call.Return(run)
	return _c
}

// GetRepoWithoutRuntimeByID provides a mock function with given fields: ctx, rfID, paths
func (_m *MockRepoStore) GetRepoWithoutRuntimeByID(ctx context.Context, rfID int64, paths []string) ([]database.Repository, error) {
	ret := _m.Called(ctx, rfID, paths)

	if len(ret) == 0 {
		panic("no return value specified for GetRepoWithoutRuntimeByID")
	}

	var r0 []database.Repository
	var r1 error
	if rf, ok := ret.Get(0).(func(context.Context, int64, []string) ([]database.Repository, error)); ok {
		return rf(ctx, rfID, paths)
	}
	if rf, ok := ret.Get(0).(func(context.Context, int64, []string) []database.Repository); ok {
		r0 = rf(ctx, rfID, paths)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]database.Repository)
		}
	}

	if rf, ok := ret.Get(1).(func(context.Context, int64, []string) error); ok {
		r1 = rf(ctx, rfID, paths)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// MockRepoStore_GetRepoWithoutRuntimeByID_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetRepoWithoutRuntimeByID'
type MockRepoStore_GetRepoWithoutRuntimeByID_Call struct {
	*mock.Call
}

// GetRepoWithoutRuntimeByID is a helper method to define mock.On call
//   - ctx context.Context
//   - rfID int64
//   - paths []string
func (_e *MockRepoStore_Expecter) GetRepoWithoutRuntimeByID(ctx interface{}, rfID interface{}, paths interface{}) *MockRepoStore_GetRepoWithoutRuntimeByID_Call {
	return &MockRepoStore_GetRepoWithoutRuntimeByID_Call{Call: _e.mock.On("GetRepoWithoutRuntimeByID", ctx, rfID, paths)}
}

func (_c *MockRepoStore_GetRepoWithoutRuntimeByID_Call) Run(run func(ctx context.Context, rfID int64, paths []string)) *MockRepoStore_GetRepoWithoutRuntimeByID_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(context.Context), args[1].(int64), args[2].([]string))
	})
	return _c
}

func (_c *MockRepoStore_GetRepoWithoutRuntimeByID_Call) Return(_a0 []database.Repository, _a1 error) *MockRepoStore_GetRepoWithoutRuntimeByID_Call {
	_c.Call.Return(_a0, _a1)
	return _c
}

func (_c *MockRepoStore_GetRepoWithoutRuntimeByID_Call) RunAndReturn(run func(context.Context, int64, []string) ([]database.Repository, error)) *MockRepoStore_GetRepoWithoutRuntimeByID_Call {
	_c.Call.Return(run)
	return _c
}

// IsMirrorRepo provides a mock function with given fields: ctx, repoType, namespace, name
func (_m *MockRepoStore) IsMirrorRepo(ctx context.Context, repoType types.RepositoryType, namespace string, name string) (bool, error) {
	ret := _m.Called(ctx, repoType, namespace, name)

	if len(ret) == 0 {
		panic("no return value specified for IsMirrorRepo")
	}

	var r0 bool
	var r1 error
	if rf, ok := ret.Get(0).(func(context.Context, types.RepositoryType, string, string) (bool, error)); ok {
		return rf(ctx, repoType, namespace, name)
	}
	if rf, ok := ret.Get(0).(func(context.Context, types.RepositoryType, string, string) bool); ok {
		r0 = rf(ctx, repoType, namespace, name)
	} else {
		r0 = ret.Get(0).(bool)
	}

	if rf, ok := ret.Get(1).(func(context.Context, types.RepositoryType, string, string) error); ok {
		r1 = rf(ctx, repoType, namespace, name)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// MockRepoStore_IsMirrorRepo_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'IsMirrorRepo'
type MockRepoStore_IsMirrorRepo_Call struct {
	*mock.Call
}

// IsMirrorRepo is a helper method to define mock.On call
//   - ctx context.Context
//   - repoType types.RepositoryType
//   - namespace string
//   - name string
func (_e *MockRepoStore_Expecter) IsMirrorRepo(ctx interface{}, repoType interface{}, namespace interface{}, name interface{}) *MockRepoStore_IsMirrorRepo_Call {
	return &MockRepoStore_IsMirrorRepo_Call{Call: _e.mock.On("IsMirrorRepo", ctx, repoType, namespace, name)}
}

func (_c *MockRepoStore_IsMirrorRepo_Call) Run(run func(ctx context.Context, repoType types.RepositoryType, namespace string, name string)) *MockRepoStore_IsMirrorRepo_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(context.Context), args[1].(types.RepositoryType), args[2].(string), args[3].(string))
	})
	return _c
}

func (_c *MockRepoStore_IsMirrorRepo_Call) Return(_a0 bool, _a1 error) *MockRepoStore_IsMirrorRepo_Call {
	_c.Call.Return(_a0, _a1)
	return _c
}

func (_c *MockRepoStore_IsMirrorRepo_Call) RunAndReturn(run func(context.Context, types.RepositoryType, string, string) (bool, error)) *MockRepoStore_IsMirrorRepo_Call {
	_c.Call.Return(run)
	return _c
}

// ListRepoPublicToUserByRepoIDs provides a mock function with given fields: ctx, repoType, userID, search, sort, per, page, repoIDs
func (_m *MockRepoStore) ListRepoPublicToUserByRepoIDs(ctx context.Context, repoType types.RepositoryType, userID int64, search string, sort string, per int, page int, repoIDs []int64) ([]*database.Repository, int, error) {
	ret := _m.Called(ctx, repoType, userID, search, sort, per, page, repoIDs)

	if len(ret) == 0 {
		panic("no return value specified for ListRepoPublicToUserByRepoIDs")
	}

	var r0 []*database.Repository
	var r1 int
	var r2 error
	if rf, ok := ret.Get(0).(func(context.Context, types.RepositoryType, int64, string, string, int, int, []int64) ([]*database.Repository, int, error)); ok {
		return rf(ctx, repoType, userID, search, sort, per, page, repoIDs)
	}
	if rf, ok := ret.Get(0).(func(context.Context, types.RepositoryType, int64, string, string, int, int, []int64) []*database.Repository); ok {
		r0 = rf(ctx, repoType, userID, search, sort, per, page, repoIDs)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*database.Repository)
		}
	}

	if rf, ok := ret.Get(1).(func(context.Context, types.RepositoryType, int64, string, string, int, int, []int64) int); ok {
		r1 = rf(ctx, repoType, userID, search, sort, per, page, repoIDs)
	} else {
		r1 = ret.Get(1).(int)
	}

	if rf, ok := ret.Get(2).(func(context.Context, types.RepositoryType, int64, string, string, int, int, []int64) error); ok {
		r2 = rf(ctx, repoType, userID, search, sort, per, page, repoIDs)
	} else {
		r2 = ret.Error(2)
	}

	return r0, r1, r2
}

// MockRepoStore_ListRepoPublicToUserByRepoIDs_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'ListRepoPublicToUserByRepoIDs'
type MockRepoStore_ListRepoPublicToUserByRepoIDs_Call struct {
	*mock.Call
}

// ListRepoPublicToUserByRepoIDs is a helper method to define mock.On call
//   - ctx context.Context
//   - repoType types.RepositoryType
//   - userID int64
//   - search string
//   - sort string
//   - per int
//   - page int
//   - repoIDs []int64
func (_e *MockRepoStore_Expecter) ListRepoPublicToUserByRepoIDs(ctx interface{}, repoType interface{}, userID interface{}, search interface{}, sort interface{}, per interface{}, page interface{}, repoIDs interface{}) *MockRepoStore_ListRepoPublicToUserByRepoIDs_Call {
	return &MockRepoStore_ListRepoPublicToUserByRepoIDs_Call{Call: _e.mock.On("ListRepoPublicToUserByRepoIDs", ctx, repoType, userID, search, sort, per, page, repoIDs)}
}

func (_c *MockRepoStore_ListRepoPublicToUserByRepoIDs_Call) Run(run func(ctx context.Context, repoType types.RepositoryType, userID int64, search string, sort string, per int, page int, repoIDs []int64)) *MockRepoStore_ListRepoPublicToUserByRepoIDs_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(context.Context), args[1].(types.RepositoryType), args[2].(int64), args[3].(string), args[4].(string), args[5].(int), args[6].(int), args[7].([]int64))
	})
	return _c
}

func (_c *MockRepoStore_ListRepoPublicToUserByRepoIDs_Call) Return(repos []*database.Repository, count int, err error) *MockRepoStore_ListRepoPublicToUserByRepoIDs_Call {
	_c.Call.Return(repos, count, err)
	return _c
}

func (_c *MockRepoStore_ListRepoPublicToUserByRepoIDs_Call) RunAndReturn(run func(context.Context, types.RepositoryType, int64, string, string, int, int, []int64) ([]*database.Repository, int, error)) *MockRepoStore_ListRepoPublicToUserByRepoIDs_Call {
	_c.Call.Return(run)
	return _c
}

// PublicToUser provides a mock function with given fields: ctx, repoType, userIDs, filter, per, page
func (_m *MockRepoStore) PublicToUser(ctx context.Context, repoType types.RepositoryType, userIDs []int64, filter *types.RepoFilter, per int, page int) ([]*database.Repository, int, error) {
	ret := _m.Called(ctx, repoType, userIDs, filter, per, page)

	if len(ret) == 0 {
		panic("no return value specified for PublicToUser")
	}

	var r0 []*database.Repository
	var r1 int
	var r2 error
	if rf, ok := ret.Get(0).(func(context.Context, types.RepositoryType, []int64, *types.RepoFilter, int, int) ([]*database.Repository, int, error)); ok {
		return rf(ctx, repoType, userIDs, filter, per, page)
	}
	if rf, ok := ret.Get(0).(func(context.Context, types.RepositoryType, []int64, *types.RepoFilter, int, int) []*database.Repository); ok {
		r0 = rf(ctx, repoType, userIDs, filter, per, page)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*database.Repository)
		}
	}

	if rf, ok := ret.Get(1).(func(context.Context, types.RepositoryType, []int64, *types.RepoFilter, int, int) int); ok {
		r1 = rf(ctx, repoType, userIDs, filter, per, page)
	} else {
		r1 = ret.Get(1).(int)
	}

	if rf, ok := ret.Get(2).(func(context.Context, types.RepositoryType, []int64, *types.RepoFilter, int, int) error); ok {
		r2 = rf(ctx, repoType, userIDs, filter, per, page)
	} else {
		r2 = ret.Error(2)
	}

	return r0, r1, r2
}

// MockRepoStore_PublicToUser_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'PublicToUser'
type MockRepoStore_PublicToUser_Call struct {
	*mock.Call
}

// PublicToUser is a helper method to define mock.On call
//   - ctx context.Context
//   - repoType types.RepositoryType
//   - userIDs []int64
//   - filter *types.RepoFilter
//   - per int
//   - page int
func (_e *MockRepoStore_Expecter) PublicToUser(ctx interface{}, repoType interface{}, userIDs interface{}, filter interface{}, per interface{}, page interface{}) *MockRepoStore_PublicToUser_Call {
	return &MockRepoStore_PublicToUser_Call{Call: _e.mock.On("PublicToUser", ctx, repoType, userIDs, filter, per, page)}
}

func (_c *MockRepoStore_PublicToUser_Call) Run(run func(ctx context.Context, repoType types.RepositoryType, userIDs []int64, filter *types.RepoFilter, per int, page int)) *MockRepoStore_PublicToUser_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(context.Context), args[1].(types.RepositoryType), args[2].([]int64), args[3].(*types.RepoFilter), args[4].(int), args[5].(int))
	})
	return _c
}

func (_c *MockRepoStore_PublicToUser_Call) Return(repos []*database.Repository, count int, err error) *MockRepoStore_PublicToUser_Call {
	_c.Call.Return(repos, count, err)
	return _c
}

func (_c *MockRepoStore_PublicToUser_Call) RunAndReturn(run func(context.Context, types.RepositoryType, []int64, *types.RepoFilter, int, int) ([]*database.Repository, int, error)) *MockRepoStore_PublicToUser_Call {
	_c.Call.Return(run)
	return _c
}

// SetUpdateTimeByPath provides a mock function with given fields: ctx, repoType, namespace, name, update
func (_m *MockRepoStore) SetUpdateTimeByPath(ctx context.Context, repoType types.RepositoryType, namespace string, name string, update time.Time) error {
	ret := _m.Called(ctx, repoType, namespace, name, update)

	if len(ret) == 0 {
		panic("no return value specified for SetUpdateTimeByPath")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, types.RepositoryType, string, string, time.Time) error); ok {
		r0 = rf(ctx, repoType, namespace, name, update)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// MockRepoStore_SetUpdateTimeByPath_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'SetUpdateTimeByPath'
type MockRepoStore_SetUpdateTimeByPath_Call struct {
	*mock.Call
}

// SetUpdateTimeByPath is a helper method to define mock.On call
//   - ctx context.Context
//   - repoType types.RepositoryType
//   - namespace string
//   - name string
//   - update time.Time
func (_e *MockRepoStore_Expecter) SetUpdateTimeByPath(ctx interface{}, repoType interface{}, namespace interface{}, name interface{}, update interface{}) *MockRepoStore_SetUpdateTimeByPath_Call {
	return &MockRepoStore_SetUpdateTimeByPath_Call{Call: _e.mock.On("SetUpdateTimeByPath", ctx, repoType, namespace, name, update)}
}

func (_c *MockRepoStore_SetUpdateTimeByPath_Call) Run(run func(ctx context.Context, repoType types.RepositoryType, namespace string, name string, update time.Time)) *MockRepoStore_SetUpdateTimeByPath_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(context.Context), args[1].(types.RepositoryType), args[2].(string), args[3].(string), args[4].(time.Time))
	})
	return _c
}

func (_c *MockRepoStore_SetUpdateTimeByPath_Call) Return(_a0 error) *MockRepoStore_SetUpdateTimeByPath_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockRepoStore_SetUpdateTimeByPath_Call) RunAndReturn(run func(context.Context, types.RepositoryType, string, string, time.Time) error) *MockRepoStore_SetUpdateTimeByPath_Call {
	_c.Call.Return(run)
	return _c
}

// TagIDs provides a mock function with given fields: ctx, repoID, category
func (_m *MockRepoStore) TagIDs(ctx context.Context, repoID int64, category string) ([]int64, error) {
	ret := _m.Called(ctx, repoID, category)

	if len(ret) == 0 {
		panic("no return value specified for TagIDs")
	}

	var r0 []int64
	var r1 error
	if rf, ok := ret.Get(0).(func(context.Context, int64, string) ([]int64, error)); ok {
		return rf(ctx, repoID, category)
	}
	if rf, ok := ret.Get(0).(func(context.Context, int64, string) []int64); ok {
		r0 = rf(ctx, repoID, category)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]int64)
		}
	}

	if rf, ok := ret.Get(1).(func(context.Context, int64, string) error); ok {
		r1 = rf(ctx, repoID, category)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// MockRepoStore_TagIDs_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'TagIDs'
type MockRepoStore_TagIDs_Call struct {
	*mock.Call
}

// TagIDs is a helper method to define mock.On call
//   - ctx context.Context
//   - repoID int64
//   - category string
func (_e *MockRepoStore_Expecter) TagIDs(ctx interface{}, repoID interface{}, category interface{}) *MockRepoStore_TagIDs_Call {
	return &MockRepoStore_TagIDs_Call{Call: _e.mock.On("TagIDs", ctx, repoID, category)}
}

func (_c *MockRepoStore_TagIDs_Call) Run(run func(ctx context.Context, repoID int64, category string)) *MockRepoStore_TagIDs_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(context.Context), args[1].(int64), args[2].(string))
	})
	return _c
}

func (_c *MockRepoStore_TagIDs_Call) Return(tagIDs []int64, err error) *MockRepoStore_TagIDs_Call {
	_c.Call.Return(tagIDs, err)
	return _c
}

func (_c *MockRepoStore_TagIDs_Call) RunAndReturn(run func(context.Context, int64, string) ([]int64, error)) *MockRepoStore_TagIDs_Call {
	_c.Call.Return(run)
	return _c
}

// Tags provides a mock function with given fields: ctx, repoID
func (_m *MockRepoStore) Tags(ctx context.Context, repoID int64) ([]database.Tag, error) {
	ret := _m.Called(ctx, repoID)

	if len(ret) == 0 {
		panic("no return value specified for Tags")
	}

	var r0 []database.Tag
	var r1 error
	if rf, ok := ret.Get(0).(func(context.Context, int64) ([]database.Tag, error)); ok {
		return rf(ctx, repoID)
	}
	if rf, ok := ret.Get(0).(func(context.Context, int64) []database.Tag); ok {
		r0 = rf(ctx, repoID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]database.Tag)
		}
	}

	if rf, ok := ret.Get(1).(func(context.Context, int64) error); ok {
		r1 = rf(ctx, repoID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// MockRepoStore_Tags_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'Tags'
type MockRepoStore_Tags_Call struct {
	*mock.Call
}

// Tags is a helper method to define mock.On call
//   - ctx context.Context
//   - repoID int64
func (_e *MockRepoStore_Expecter) Tags(ctx interface{}, repoID interface{}) *MockRepoStore_Tags_Call {
	return &MockRepoStore_Tags_Call{Call: _e.mock.On("Tags", ctx, repoID)}
}

func (_c *MockRepoStore_Tags_Call) Run(run func(ctx context.Context, repoID int64)) *MockRepoStore_Tags_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(context.Context), args[1].(int64))
	})
	return _c
}

func (_c *MockRepoStore_Tags_Call) Return(tags []database.Tag, err error) *MockRepoStore_Tags_Call {
	_c.Call.Return(tags, err)
	return _c
}

func (_c *MockRepoStore_Tags_Call) RunAndReturn(run func(context.Context, int64) ([]database.Tag, error)) *MockRepoStore_Tags_Call {
	_c.Call.Return(run)
	return _c
}

// TagsWithCategory provides a mock function with given fields: ctx, repoID, category
func (_m *MockRepoStore) TagsWithCategory(ctx context.Context, repoID int64, category string) ([]database.Tag, error) {
	ret := _m.Called(ctx, repoID, category)

	if len(ret) == 0 {
		panic("no return value specified for TagsWithCategory")
	}

	var r0 []database.Tag
	var r1 error
	if rf, ok := ret.Get(0).(func(context.Context, int64, string) ([]database.Tag, error)); ok {
		return rf(ctx, repoID, category)
	}
	if rf, ok := ret.Get(0).(func(context.Context, int64, string) []database.Tag); ok {
		r0 = rf(ctx, repoID, category)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]database.Tag)
		}
	}

	if rf, ok := ret.Get(1).(func(context.Context, int64, string) error); ok {
		r1 = rf(ctx, repoID, category)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// MockRepoStore_TagsWithCategory_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'TagsWithCategory'
type MockRepoStore_TagsWithCategory_Call struct {
	*mock.Call
}

// TagsWithCategory is a helper method to define mock.On call
//   - ctx context.Context
//   - repoID int64
//   - category string
func (_e *MockRepoStore_Expecter) TagsWithCategory(ctx interface{}, repoID interface{}, category interface{}) *MockRepoStore_TagsWithCategory_Call {
	return &MockRepoStore_TagsWithCategory_Call{Call: _e.mock.On("TagsWithCategory", ctx, repoID, category)}
}

func (_c *MockRepoStore_TagsWithCategory_Call) Run(run func(ctx context.Context, repoID int64, category string)) *MockRepoStore_TagsWithCategory_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(context.Context), args[1].(int64), args[2].(string))
	})
	return _c
}

func (_c *MockRepoStore_TagsWithCategory_Call) Return(tags []database.Tag, err error) *MockRepoStore_TagsWithCategory_Call {
	_c.Call.Return(tags, err)
	return _c
}

func (_c *MockRepoStore_TagsWithCategory_Call) RunAndReturn(run func(context.Context, int64, string) ([]database.Tag, error)) *MockRepoStore_TagsWithCategory_Call {
	_c.Call.Return(run)
	return _c
}

// UpdateDownloads provides a mock function with given fields: ctx, repo
func (_m *MockRepoStore) UpdateDownloads(ctx context.Context, repo *database.Repository) error {
	ret := _m.Called(ctx, repo)

	if len(ret) == 0 {
		panic("no return value specified for UpdateDownloads")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, *database.Repository) error); ok {
		r0 = rf(ctx, repo)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// MockRepoStore_UpdateDownloads_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'UpdateDownloads'
type MockRepoStore_UpdateDownloads_Call struct {
	*mock.Call
}

// UpdateDownloads is a helper method to define mock.On call
//   - ctx context.Context
//   - repo *database.Repository
func (_e *MockRepoStore_Expecter) UpdateDownloads(ctx interface{}, repo interface{}) *MockRepoStore_UpdateDownloads_Call {
	return &MockRepoStore_UpdateDownloads_Call{Call: _e.mock.On("UpdateDownloads", ctx, repo)}
}

func (_c *MockRepoStore_UpdateDownloads_Call) Run(run func(ctx context.Context, repo *database.Repository)) *MockRepoStore_UpdateDownloads_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(context.Context), args[1].(*database.Repository))
	})
	return _c
}

func (_c *MockRepoStore_UpdateDownloads_Call) Return(_a0 error) *MockRepoStore_UpdateDownloads_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockRepoStore_UpdateDownloads_Call) RunAndReturn(run func(context.Context, *database.Repository) error) *MockRepoStore_UpdateDownloads_Call {
	_c.Call.Return(run)
	return _c
}

// UpdateLicenseByTag provides a mock function with given fields: ctx, repoID
func (_m *MockRepoStore) UpdateLicenseByTag(ctx context.Context, repoID int64) error {
	ret := _m.Called(ctx, repoID)

	if len(ret) == 0 {
		panic("no return value specified for UpdateLicenseByTag")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, int64) error); ok {
		r0 = rf(ctx, repoID)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// MockRepoStore_UpdateLicenseByTag_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'UpdateLicenseByTag'
type MockRepoStore_UpdateLicenseByTag_Call struct {
	*mock.Call
}

// UpdateLicenseByTag is a helper method to define mock.On call
//   - ctx context.Context
//   - repoID int64
func (_e *MockRepoStore_Expecter) UpdateLicenseByTag(ctx interface{}, repoID interface{}) *MockRepoStore_UpdateLicenseByTag_Call {
	return &MockRepoStore_UpdateLicenseByTag_Call{Call: _e.mock.On("UpdateLicenseByTag", ctx, repoID)}
}

func (_c *MockRepoStore_UpdateLicenseByTag_Call) Run(run func(ctx context.Context, repoID int64)) *MockRepoStore_UpdateLicenseByTag_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(context.Context), args[1].(int64))
	})
	return _c
}

func (_c *MockRepoStore_UpdateLicenseByTag_Call) Return(_a0 error) *MockRepoStore_UpdateLicenseByTag_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockRepoStore_UpdateLicenseByTag_Call) RunAndReturn(run func(context.Context, int64) error) *MockRepoStore_UpdateLicenseByTag_Call {
	_c.Call.Return(run)
	return _c
}

// UpdateOrCreateRepo provides a mock function with given fields: ctx, input
func (_m *MockRepoStore) UpdateOrCreateRepo(ctx context.Context, input database.Repository) (*database.Repository, error) {
	ret := _m.Called(ctx, input)

	if len(ret) == 0 {
		panic("no return value specified for UpdateOrCreateRepo")
	}

	var r0 *database.Repository
	var r1 error
	if rf, ok := ret.Get(0).(func(context.Context, database.Repository) (*database.Repository, error)); ok {
		return rf(ctx, input)
	}
	if rf, ok := ret.Get(0).(func(context.Context, database.Repository) *database.Repository); ok {
		r0 = rf(ctx, input)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*database.Repository)
		}
	}

	if rf, ok := ret.Get(1).(func(context.Context, database.Repository) error); ok {
		r1 = rf(ctx, input)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// MockRepoStore_UpdateOrCreateRepo_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'UpdateOrCreateRepo'
type MockRepoStore_UpdateOrCreateRepo_Call struct {
	*mock.Call
}

// UpdateOrCreateRepo is a helper method to define mock.On call
//   - ctx context.Context
//   - input database.Repository
func (_e *MockRepoStore_Expecter) UpdateOrCreateRepo(ctx interface{}, input interface{}) *MockRepoStore_UpdateOrCreateRepo_Call {
	return &MockRepoStore_UpdateOrCreateRepo_Call{Call: _e.mock.On("UpdateOrCreateRepo", ctx, input)}
}

func (_c *MockRepoStore_UpdateOrCreateRepo_Call) Run(run func(ctx context.Context, input database.Repository)) *MockRepoStore_UpdateOrCreateRepo_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(context.Context), args[1].(database.Repository))
	})
	return _c
}

func (_c *MockRepoStore_UpdateOrCreateRepo_Call) Return(_a0 *database.Repository, _a1 error) *MockRepoStore_UpdateOrCreateRepo_Call {
	_c.Call.Return(_a0, _a1)
	return _c
}

func (_c *MockRepoStore_UpdateOrCreateRepo_Call) RunAndReturn(run func(context.Context, database.Repository) (*database.Repository, error)) *MockRepoStore_UpdateOrCreateRepo_Call {
	_c.Call.Return(run)
	return _c
}

// UpdateRepo provides a mock function with given fields: ctx, input
func (_m *MockRepoStore) UpdateRepo(ctx context.Context, input database.Repository) (*database.Repository, error) {
	ret := _m.Called(ctx, input)

	if len(ret) == 0 {
		panic("no return value specified for UpdateRepo")
	}

	var r0 *database.Repository
	var r1 error
	if rf, ok := ret.Get(0).(func(context.Context, database.Repository) (*database.Repository, error)); ok {
		return rf(ctx, input)
	}
	if rf, ok := ret.Get(0).(func(context.Context, database.Repository) *database.Repository); ok {
		r0 = rf(ctx, input)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*database.Repository)
		}
	}

	if rf, ok := ret.Get(1).(func(context.Context, database.Repository) error); ok {
		r1 = rf(ctx, input)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// MockRepoStore_UpdateRepo_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'UpdateRepo'
type MockRepoStore_UpdateRepo_Call struct {
	*mock.Call
}

// UpdateRepo is a helper method to define mock.On call
//   - ctx context.Context
//   - input database.Repository
func (_e *MockRepoStore_Expecter) UpdateRepo(ctx interface{}, input interface{}) *MockRepoStore_UpdateRepo_Call {
	return &MockRepoStore_UpdateRepo_Call{Call: _e.mock.On("UpdateRepo", ctx, input)}
}

func (_c *MockRepoStore_UpdateRepo_Call) Run(run func(ctx context.Context, input database.Repository)) *MockRepoStore_UpdateRepo_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(context.Context), args[1].(database.Repository))
	})
	return _c
}

func (_c *MockRepoStore_UpdateRepo_Call) Return(_a0 *database.Repository, _a1 error) *MockRepoStore_UpdateRepo_Call {
	_c.Call.Return(_a0, _a1)
	return _c
}

func (_c *MockRepoStore_UpdateRepo_Call) RunAndReturn(run func(context.Context, database.Repository) (*database.Repository, error)) *MockRepoStore_UpdateRepo_Call {
	_c.Call.Return(run)
	return _c
}

// UpdateRepoCloneDownloads provides a mock function with given fields: ctx, repo, date, cloneCount
func (_m *MockRepoStore) UpdateRepoCloneDownloads(ctx context.Context, repo *database.Repository, date time.Time, cloneCount int64) error {
	ret := _m.Called(ctx, repo, date, cloneCount)

	if len(ret) == 0 {
		panic("no return value specified for UpdateRepoCloneDownloads")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, *database.Repository, time.Time, int64) error); ok {
		r0 = rf(ctx, repo, date, cloneCount)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// MockRepoStore_UpdateRepoCloneDownloads_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'UpdateRepoCloneDownloads'
type MockRepoStore_UpdateRepoCloneDownloads_Call struct {
	*mock.Call
}

// UpdateRepoCloneDownloads is a helper method to define mock.On call
//   - ctx context.Context
//   - repo *database.Repository
//   - date time.Time
//   - cloneCount int64
func (_e *MockRepoStore_Expecter) UpdateRepoCloneDownloads(ctx interface{}, repo interface{}, date interface{}, cloneCount interface{}) *MockRepoStore_UpdateRepoCloneDownloads_Call {
	return &MockRepoStore_UpdateRepoCloneDownloads_Call{Call: _e.mock.On("UpdateRepoCloneDownloads", ctx, repo, date, cloneCount)}
}

func (_c *MockRepoStore_UpdateRepoCloneDownloads_Call) Run(run func(ctx context.Context, repo *database.Repository, date time.Time, cloneCount int64)) *MockRepoStore_UpdateRepoCloneDownloads_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(context.Context), args[1].(*database.Repository), args[2].(time.Time), args[3].(int64))
	})
	return _c
}

func (_c *MockRepoStore_UpdateRepoCloneDownloads_Call) Return(err error) *MockRepoStore_UpdateRepoCloneDownloads_Call {
	_c.Call.Return(err)
	return _c
}

func (_c *MockRepoStore_UpdateRepoCloneDownloads_Call) RunAndReturn(run func(context.Context, *database.Repository, time.Time, int64) error) *MockRepoStore_UpdateRepoCloneDownloads_Call {
	_c.Call.Return(run)
	return _c
}

// UpdateRepoFileDownloads provides a mock function with given fields: ctx, repo, date, clickDownloadCount
func (_m *MockRepoStore) UpdateRepoFileDownloads(ctx context.Context, repo *database.Repository, date time.Time, clickDownloadCount int64) error {
	ret := _m.Called(ctx, repo, date, clickDownloadCount)

	if len(ret) == 0 {
		panic("no return value specified for UpdateRepoFileDownloads")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, *database.Repository, time.Time, int64) error); ok {
		r0 = rf(ctx, repo, date, clickDownloadCount)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// MockRepoStore_UpdateRepoFileDownloads_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'UpdateRepoFileDownloads'
type MockRepoStore_UpdateRepoFileDownloads_Call struct {
	*mock.Call
}

// UpdateRepoFileDownloads is a helper method to define mock.On call
//   - ctx context.Context
//   - repo *database.Repository
//   - date time.Time
//   - clickDownloadCount int64
func (_e *MockRepoStore_Expecter) UpdateRepoFileDownloads(ctx interface{}, repo interface{}, date interface{}, clickDownloadCount interface{}) *MockRepoStore_UpdateRepoFileDownloads_Call {
	return &MockRepoStore_UpdateRepoFileDownloads_Call{Call: _e.mock.On("UpdateRepoFileDownloads", ctx, repo, date, clickDownloadCount)}
}

func (_c *MockRepoStore_UpdateRepoFileDownloads_Call) Run(run func(ctx context.Context, repo *database.Repository, date time.Time, clickDownloadCount int64)) *MockRepoStore_UpdateRepoFileDownloads_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(context.Context), args[1].(*database.Repository), args[2].(time.Time), args[3].(int64))
	})
	return _c
}

func (_c *MockRepoStore_UpdateRepoFileDownloads_Call) Return(err error) *MockRepoStore_UpdateRepoFileDownloads_Call {
	_c.Call.Return(err)
	return _c
}

func (_c *MockRepoStore_UpdateRepoFileDownloads_Call) RunAndReturn(run func(context.Context, *database.Repository, time.Time, int64) error) *MockRepoStore_UpdateRepoFileDownloads_Call {
	_c.Call.Return(run)
	return _c
}

// WithMirror provides a mock function with given fields: ctx, per, page
func (_m *MockRepoStore) WithMirror(ctx context.Context, per int, page int) ([]database.Repository, int, error) {
	ret := _m.Called(ctx, per, page)

	if len(ret) == 0 {
		panic("no return value specified for WithMirror")
	}

	var r0 []database.Repository
	var r1 int
	var r2 error
	if rf, ok := ret.Get(0).(func(context.Context, int, int) ([]database.Repository, int, error)); ok {
		return rf(ctx, per, page)
	}
	if rf, ok := ret.Get(0).(func(context.Context, int, int) []database.Repository); ok {
		r0 = rf(ctx, per, page)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]database.Repository)
		}
	}

	if rf, ok := ret.Get(1).(func(context.Context, int, int) int); ok {
		r1 = rf(ctx, per, page)
	} else {
		r1 = ret.Get(1).(int)
	}

	if rf, ok := ret.Get(2).(func(context.Context, int, int) error); ok {
		r2 = rf(ctx, per, page)
	} else {
		r2 = ret.Error(2)
	}

	return r0, r1, r2
}

// MockRepoStore_WithMirror_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'WithMirror'
type MockRepoStore_WithMirror_Call struct {
	*mock.Call
}

// WithMirror is a helper method to define mock.On call
//   - ctx context.Context
//   - per int
//   - page int
func (_e *MockRepoStore_Expecter) WithMirror(ctx interface{}, per interface{}, page interface{}) *MockRepoStore_WithMirror_Call {
	return &MockRepoStore_WithMirror_Call{Call: _e.mock.On("WithMirror", ctx, per, page)}
}

func (_c *MockRepoStore_WithMirror_Call) Run(run func(ctx context.Context, per int, page int)) *MockRepoStore_WithMirror_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(context.Context), args[1].(int), args[2].(int))
	})
	return _c
}

func (_c *MockRepoStore_WithMirror_Call) Return(repos []database.Repository, count int, err error) *MockRepoStore_WithMirror_Call {
	_c.Call.Return(repos, count, err)
	return _c
}

func (_c *MockRepoStore_WithMirror_Call) RunAndReturn(run func(context.Context, int, int) ([]database.Repository, int, error)) *MockRepoStore_WithMirror_Call {
	_c.Call.Return(run)
	return _c
}

// NewMockRepoStore creates a new instance of MockRepoStore. It also registers a testing interface on the mock and a cleanup function to assert the mocks expectations.
// The first argument is typically a *testing.T value.
func NewMockRepoStore(t interface {
	mock.TestingT
	Cleanup(func())
}) *MockRepoStore {
	mock := &MockRepoStore{}
	mock.Mock.Test(t)

	t.Cleanup(func() { mock.AssertExpectations(t) })

	return mock
}
