# Contributing to SimpleBLE

This document outlines the process for contributing to the project and provides some guidelines to ensure a smooth collaboration.

## Contributor License Agreement

Before we can accept your contribution, you must sign our Contributor License Agreement (CLA). This agreement ensures that the project has the necessary rights to use and distribute your contributions.

- If you are contributing as an individual, please sign the Individual CLA.
- If you are contributing on behalf of your employer, please have your employer sign the Corporate CLA.

<!-- You can find the appropriate CLA forms on our website or by contacting our legal team at [email@email.com](mailto:email@email.com). -->

**Please note:** We cannot accept any contributions without a signed CLA.

## Coding Guidelines

- Follow the existing code style and conventions used in the project.
- Write clear, readable, and well-documented code.
- Include unit tests for new features or bug fixes where applicable.
- Ensure your code works on all supported platforms (Linux, Windows, macOS, iOS, and Android).

## Submitting a Pull Request

1. Ensure you have signed the CLA before submitting your pull request.
2. Provide a clear and detailed description of your changes in the pull request.
3. Reference any related issues in your pull request description.
4. Be prepared to make changes if requested by the maintainers.

## Reporting Issues

- Use the GitHub issue tracker to report bugs or suggest features.
- Before creating a new issue, please check if a similar issue already exists.
- Provide as much detail as possible, including steps to reproduce for bugs.

## Community Guidelines

- Be respectful and considerate in all interactions.
- Help others if you can.

## Questions?

If you have any questions about contributing, feel free to open an issue or contact the team directly.

Thank you for contributing to SimpleBLE! Your efforts help make this project better for everyone.