Overview
========

The packet parse plug-in mainly solves the problem of formatting data pieces from each IO, cutting these data pieces,  
and encapsulating them into messages that can be used normally by the logic plug-in.  
Here, you can judge and verify the legality of the data from different IOs,  
and you can also format the sent data into the data stream to be transmitted on the IO through a similar method.  
At the same time, it is convenient for business plug-ins,  
so that they don't need to care about which IO the data comes from, business plug-ins only need to concentrate on processing messages themselves.  
Data cutting and grouping will be carried out here.  

You can refer to PacketParse_Inferface or PacketParse_Http I wrote.  

Table of Contents(function info)
================================
 - [parse_packet_from_recv_buffer](#parse_packet_from_recv_buffer)
 - [parse_packet_format_send_buffer](#parse_packet_format_send_buffer)
 - [is_need_send_format](#is_need_send_format)
 - [connect](#connect)
 - [disConnect](#disConnect)
 - [set_output](#set_output)
 - [packet_load](#packet_load)
 - [packet_close](#packet_close)

parse_packet_from_recv_buffer
=============================
Function description: This function processes the data received from the IO. Here, the complete data packet is judged and cut, and as required, it is assembled into a message that can be processed by the logic module, and then pushed to the worker thread for the logic plug-in to consume.  
| name | type | Description |  
| ------ | ------ | ------ |  
| connect_id | int | IO connect id(Generated by the framework, globally unique) |  
| buffer | byte array | The content of the received IO data |  
| message_list | message array | The formatted logic plug-in message content list |  
| emIOType | int | Current IO type, tcp, udp, serial port or ssl |  

parse_packet_format_send_buffer
===============================
Function description: This function provides the formatting operation of sending the specified IO data packet, you can add your encryption algorithm here and send it.  
| name | type | Description |  
| ------ | ------ | ------ |  
| connect_id | int | IO connect id(Generated by the framework, globally unique) |  
| message | byte array | The content of the message that needs to be formatted and sent by the logic plug-in |  
| send_message | message array | The content of the data packet generated after the internal formatting of the function |  
| emIOType | int | Current IO type, tcp, udp, serial port or ssl |  

is_need_send_format
===================
Function description: Tell the framework if sending data needs to call parse_packet_format_send_buffer to format the sent data.  

connect
=======
Function description: The specified IO connection establishment message.  

| name | type | Description |  
| ------ | ------ | ------ |  
| connect_id | int | IO connect id(Generated by the framework, globally unique) |  
| remote_ip | string | IO remote ip |  
| local_ip | string | IO local listen ip |  
| emIOType | int |  Current IO type, tcp, udp, serial port or ssl |  

disConnect
==========
Function description: The specified IO disconnection establishment message. 

| name | type | Description |  
| ------ | ------ | ------ |  
| connect_id | int | IO connect id(Generated by the framework, globally unique) |  
| emIOType | int |  Current IO type, tcp, udp, serial port or ssl |  

set_output
==========
Function description: Set the interface for synchronous output with the framework (no need to modify the code).  

| name | type | Description |  
| ------ | ------ | ------ |  
| logger | object | Frame's logger object |  

packet_load
===========
Function description: The packet parse plugin is loaded by the framework event.  

packet_close
============
Function description: The packet parse plugin was uninstalled by the framework.  
