# Supported Providers & Frameworks

Omni-Authify supports a variety of OAuth2 providers and frameworks to make integrating social logins straightforward.

## 🌍 Supported Providers

Omni-Authify currently supports the following OAuth2 providers:

| 🔒 Auth Type | 🌐 Provider        | 📖 Documentation                 |
|--------------|--------------------|----------------------------------|
| OAuth 2.0    | Apple              | [Setup Guide](Setup/apple.md)    |
| OAuth 2.0    | Google             | [Setup Guide](Setup/google.md)   |
| OAuth 2.0    | Facebook/Instagram | [Setup Guide](Setup/facebook.md) |
| OAuth 2.0    | Twitter/X          | [Setup Guide](Setup/twitter.md)  |
| OAuth 2.0    | LinkedIn           | [Setup Guide](Setup/linkedin.md) |
| OAuth 2.0    | GitHub             | [Setup Guide](Setup/github.md)   |
| Bot Token    | Telegram           | [Setup Guide](Setup/telegram.md) |

---

## 🧰 Supported Frameworks

Omni-Authify integrates with several popular frameworks to facilitate OAuth2 authentication. Below are the frameworks supported:

| 🛠️ Framework version | 🖥️ Framework | 📖 Documentation                   |
|-----------------------|---------------|------------------------------------|
| Version: 3+           | Django        | [Setup Guide](usage/django.md)     |
| Version: 3.3+         | Django-DRF    | [Setup Guide](usage/django-drf.md) |
| Version: ...          | FastAPI       | [Setup Guide](usage/fastapi.md)    |
| Flask: ...            | Flask         | [Setup Guide](usage/flask.md)      |

---

Omni-Authify is committed to expanding support to additional providers and frameworks. Stay tuned for more updates and integrations!

For more information on contributing or accessing the source code, refer to our [Contributing Guide](../CONTRIBUTING.md).

Omni-Authify makes it easy to implement secure social login for your projects, whether you're working with Django, DRF, FastAPI, or Flask. 🚀

