# Awesome-jamstack-resources [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome) ![](https://img.shields.io/badge/olanetsoft-approved-brightgreen.svg) [![All Contributors](https://img.shields.io/badge/all_contributors-1-orange.svg?style=flat-square)](#contributors-)

![JAMSTACK IMG](https://res.cloudinary.com/cloudinary-marketing/image/upload/v1/Web_Assets/blog/JAMstack-Delivers-v1.png)

  <p>
    <b>
      This is Curated list of tools using the <a href="https://jamstack.org">JAMStack:</a> A modern web development architecture for creating fast, secure and dynamic websites.
    </b>
  </p>
  <p>
    <i>
      Want to contribute with some tools / resource ? Awesome! Please, read the <a href="contributing.md">contribution guidelines</a> before contributing.
    </i>
  </p>

## Table of Content

- [Official Resource Site](#official)
- [Jamstack Sites Showcase](#jamstack-sites-showcase)
- [Platforms](#platforms)
- [Static Site Generators](#static-site-generators)
- [CMS](#cms)
- [API](#api)
  - [Authentication](#authentication)
  - [Comments](#comments)
  - [Forms](#forms)
  - [E-commerce](#e-commerce)
  - [Search](#search)
  - [Database](#database)
- [Serverless](#serverless)
- [Videos](#videos)
- [Tutorials / Articles](#tutorials--articles)
- [Books](#books)

---

## official

- [Jamstack](https://jamstack.org/)
- [Jamstack resources](https://jamstack.org/resources/) - Videos and articles about Jamstack.
- [JAMstack Radio](https://www.netlify.com/tags/podcast/)
- [JAMstack Boilerplates](https://templates.netlify.com/)
- [Netlify Blog](https://www.netlify.com/blog/)
- [What is the JAMstack?](https://jamstack.org/#what)
- [Why the JAMstack?](https://jamstack.org/#why)
- [How do I get started?](https://jamstack.org/#how)

## Jamstack Sites Showcase

- [My Portfolio](https://idrisolubisi.com) - Built on Gatsby and hosted on Netlify.
- [React](https://reactjs.org/) - Built on Gatsby.
- [Squoosh.app](https://squoosh.app/) - Hosted on Netlify, demonstrates advanced features from a modern Web Application.
- [Hopper](https://travel.hopper.com/) - Built on Gatsby and hosted on Netlify.
- [VSCode Power User Course](https://vscode.pro/) - PWA built on Gatsby and hosted on Netlify.
- [CloudyCam](https://CloudyCam.dev/) - PWA built on Next.js and hosted on Zeit Now v2 Serverless platform.
- [Creative Designs Guru](https://creativedesignsguru.com) - Built on Eleventy.js hosted on Netlify and styled with Tailwind CSS

## Platforms

- [Netlify](https://netlify.com) - All-in-one platform for automating modern web projects.
- [Vercel](https://vercel.com) - All-in-one serverless platform for modern web apps with config-free tools and workflows.

## Static Site Generators

- [Gatsby](https://gatsbyjs.org) - Blazing-fast static site generator for React.
- [Next.js](https://nextjs.org/) - Lightweight framework for static and server-rendered applications.
- [Hugo](https://gohugo.io) - Hugo is a static site generator written in Go.
- [Jekyll](https://jekyllrb.com) - Jekyll is a simple, blog-aware, static site generator perfect for personal, project, or organization sites.
- [Hexo](https://hexo.io) - A fast, simple & powerful blog framework, powered by Node.js.
- [Gridsome](https://gridsome.org/) - Vue-powered static site generator for building CDN-ready websites for any Headless CMS, APIs or Markdown-files.
- [Nuxt.js](https://nuxtjs.org/) - Versatile vue-based framework for server-side-rendered, static and traditional single page applications.
- [eleventy](https://www.11ty.io/) - A simpler static site generator transforming various template files into HTML.
- [Nift](https://nift.cc) - A cross-platform open source website generator developed in C++ that is lightning fast and extremely powerful.

## CMS

- [Cosmic](https://cosmicjs.com) - Headless CMS with REST and GraphQL API options.
- [Kentico Kontent](https://kontent.ai) - A cloud-native headless CMS that scales.
- [Contentful](https://contentful.com) - Content infrastructure for digital teams.
- [NetlifyCMS](https://netlifycms.org/) - open source Git-based CMS.
- [ButterCMS](https://buttercms.com/) - Headless CMS and Content API.
- [GraphCMS](https://graphcms.com) - The GraphQL Headless CMS.
- [Prismic](https://prismic.io) - Headless API CMS for both developers and marketers.
- [Siteleaf](https://siteleaf.com) - A friendly CMS for your static site.
- [DatoCMS](https://datocms.com) - The API-based CMS your editors will love.
- [Prose](https://prose.io) - Prose is a content editor for GitHub designed for managing websites.
- [Tipe](https://tipe.io) - Next Generation API-first CMS.
- [Forestry](https://forestry.io) - Headless CMS for sites built with static site generators.
- [HeadlessCMS](https://headlesscms.org/) - A List of Content Management Systems for Jamstack Sites.
- [Ghost](https://ghost.org/) - A headless CMS for online publications
- [Strapi](https://strapi.io) - The open source Headless CMS Front-End Developers love.

## API

### Authentication

- [Auth0](https://auth0.com/) - Single sign on and token based authentication.
- [Netlify Identity](https://www.netlify.com/docs/identity/) - Brings a full suite of authentication functionality, backed by the [GoTrue API](https://www.gotrueapi.org).
- [Jexia UMS](https://jexia.com) - REST API User management system for your webside with identy provider with JWT + extra functionality.

### Comments

- [Disqus](https://disqus.com) - Global comment system that improves discussion on websites and connects conversations across the web.
- [Facebook Comments](https://developers.facebook.com/docs/plugins/comments) - The comments plugin lets people comment on content on your site using their Facebook account.
- [Utterances](https://utteranc.es/) - A lightweight comments widget built on GitHub issues. Use GitHub issues for blog comments, wiki pages and more.

### Forms

- [Formcake](https://formcake.com) - A form backend built for developers: Zapier integrations, zero dependencies, a simple API, and unlimited forms.
- [Getform](https://getform.io) - Form backend platform for designers and developers. Setup your form endpoints for your static site within minutes and expand your data with Zapier integration and Webhooks support.
- [Netlify Forms](https://www.netlify.com/docs/form-handling/) - Built-in form handling on building time by parsing HTML files directly at deploy time.
- [Arengu](https://www.arengu.com) - Build signup and login forms with Arengu, enable social login, add 2FA or use passwordless flows to authenticate users with your API or identity provider.

### E-commerce

- [Snipcart](https://snipcart.com/) - A powerful shopping cart platform for developers.
- [Moltin](https://moltin.com/) - eCommerce API for developers.
- [Trolley](https://trolley.link) - A shopping cart designed for the Jamstack.
- [Shopify](https://www.shopify.co.uk/plus/solutions/headless-commerce) - Shopify headless e-commerce solution.
- [Commerce.js](https://commercejs.com/) - API-first eCommerce platform for developers.

### Search

- [Algolia](https://www.algolia.com/) - The most reliable platform for building search into your business.
- [Lunr](https://lunrjs.com/) - Search made simple (on frontend).

### Database

- [GraphQL](https://graphql.org) - Query language for APIs and a runtime for fulfilling those queries with your existing data.
- [Graphcool](https://graph.cool) - Open-source and self-hosted backend-as-a-service to develop serverless GraphQL backends.
- [FaunaDB](https://fauna.com) - Relational NoSQL database with joins, indexes, and multi-region ACID transactions in the cloud or on-premise.

### File management

- [Jexia FileSet](https://jexia.com) - REST API File manager for your application with indexing and extra functions.

## Serverless

- [Netlify Functions](https://www.netlify.com/docs/functions/) - Netlify lets you deploy Lambda functions without an AWS account, and with function management handled directly within Netlify.
- [Amazon Lambda](https://aws.amazon.com/lambda/) - Lets you run code without provisioning or managing servers.
- Microsoft Azure
  - [Azure Functions](https://docs.microsoft.com/en-us/azure/azure-functions/) - Serverless compute service that enables you to run code on-demand without having to explicitly provision or manage infrastructure.
  - [Azure Logic Apps](https://docs.microsoft.com/en-us/azure/logic-apps/) - Simplifies building automated scalable workflows that integrate apps and data across cloud services and on-premises systems.
- Google Cloud
  - [App Engine](https://cloud.google.com/appengine/) - Serverless application that completely abstracts away infrastructure so you focus only on code.
  - [Cloud Functions](https://cloud.google.com/functions/) - Serverless environment to build and connect cloud services.
  - [Cloud Datastore](https://cloud.google.com/datastore/) - Highly-scalable NoSQL database with automatic sharding and replication.
  - [Cloud Storage](https://cloud.google.com/storage/) - Geo-redundant object storage for high QPS needs.
  - [Cloud Pub/Sub](https://cloud.google.com/pubsub/) - Geo-redundant real-time messaging for all message sizes and velocities.
  - [Apigee](https://apigee.com/) - Enterprise API management for multi-cloud environments.
  - [Endpoints](https://cloud.google.com/endpoints/) - API management apps built on Google Cloud.
  - [Cloud Dataflow](https://cloud.google.com/dataflow/) - Serverless stream and batch data processing service.
  - [BigQuery](https://cloud.google.com/bigquery/) - Serverless data warehousing services that help you to deploy advanced cloud data warehousing solutions for your enterprise.
  - [Cloud ML Engine](https://cloud.google.com/ml-engine/) - Serverless machine learning services that automatically scales built on custom Google hardware (Tensor Processing Units).
- [Serverless](https://serverless.com/) - Toolkit for deploying and operating serverless architectures.
- [Cloudinary](https://cloudinary.com/) - Serverless media (images/videos) management platform. Provides SDKs in every popular language and media widgets for Jamstack to make it easy to manage media, CDN, storage, transformations, and more.
- [imgix](https://www.imgix.com/) - Serverless image delivery and management service. imgix connects to where your images are stored (e.g. S3, GCS, web folder) and transforms, optimizes, and intelligently delivers your images using simple and robust URL parameters.
- [Elastictable](https://www.elastictable.com) - Backend as a Service solution built on AWS that's on a missing to increase the success rate of online businesses.


_For a more complete list see [Awesome Serverless](https://github.com/pmuens/awesome-serverless)._

## Videos

- [The New Front-end Stack. JavaScript, APIs and Markup](https://vimeo.com/163522126) - Matt Biilmann.
- [Rise of the Jamstack](https://www.youtube.com/watch?v=uWTMEDEPw8c) - Mathias Biillman.
- [Jamstack: Silly name, serious stuff](https://www.youtube.com/watch?v=XOYtS91QWQI) - Phil Hawksworth.
- [Git-based or API-driven CMS](https://www.youtube.com/watch?v=KX4G49ZrvY0) - Chris Macrae.
- [Jamstack Tutorial - Full site using Netlify & Hugo](https://www.youtube.com/watch?v=NSts93C9UeE) - freeCodeCamp.org.
- [Gatsby JS Crash Course](https://www.youtube.com/watch?v=6YhqQ2ZW1sc) - Traversy Media.
- [How We Got Here and The Future of the Web](https://www.gatsbyjs.com/gatsby-days-keynote-kyle/) - Kyle Mathews.
- [Talks from all the Jamstack Conferences](https://www.youtube.com/channel/UC8bRyfU7ycLXnEBfvdorpUg/videos) - Jamstack Conf.
- [How I Used React, Vue, & Node to Build a Single Jamstack App](https://www.youtube.com/watch?v=dwpn1pd9kT8) - Ahmad Awais.
- [React vs Vue, Gatsby vs Gridsome - building the same site](https://www.youtube.com/watch?v=H19fF7ITtaI) - Ondrej Polesny.
- [WTF is Jamstack?](https://youtu.be/ReSvk5MQek4) - Ondrej Polesny.

## Tutorials / Articles

- [Build a JAMstack Personal Blog with Headless Ghost 2.0 CMS & Gatsby](https://josebrowne.com/tutorial-static-blog-using-headless-ghost-2-0-gatsby-netlify/)
- [How to Build a JAMstack Website using Vue.js, Nuxt.js and Cosmic JS](https://cosmicjs.com/articles/how-to-build-a-jamstack-website-using-vuejs-nuxtjs-and-cosmic-js-jws3mpy1)
- [Ghost on the Jamstack](https://blog.ghost.org/jamstack/)
- [Building a contact form in Gatsby using Getform](https://blog.getform.io/building-a-gatsby-contact-form-using-getform)
- [Getting Started with Gatsby and Cockpit — Part 1 of 2](https://blog.ginetta.net/getting-started-with-gatsby-and-cockpit-part-1-of-2-d86871932d44)
- [Creating Static E-commerce site with GatsbyJs](https://medium.com/@pinku1/creating-static-e-commerce-site-with-gatsbyjs-a349d7e022a)
- [For Static Sites, There’s No Excuse Not to Use a CDN](https://forestry.io/blog/for-static-sites-theres-no-excuse-not-to-use-a-cdn/)
- [E-commerce front-end for Vue.js, Nuxt.js and Snipcart](https://www.sanity.io/blog/e-commerce-vue-nuxt-snipcart)
- [Building Paul The Octopus](https://www.tomango.co.uk/thinks/paul-the-octopus-2018/)
- [Jamstack and Netlify: Do We really need another buzzword?](https://noti.st/philhawksworth/qp7jZC/jamstack-and-netlify-do-we-really-need-another-buzzword)
- [The Jamstack Startup Landscape](https://medium.com/@CRVVC/the-jamstack-startup-landscape-c06cc3cdb917)
- [How I built my blog using Gatsby and Netlify](https://blog.pavsidhu.com/how-i-built-my-blog-using-gatsby-and-netlify/)
- [Developer's Guide to Headless E-Commerce](https://snipcart.com/blog/headless-ecommerce-guide)
- [Handling Static Forms, Auth & Serverless Functions with Gatsby on Netlify](https://snipcart.com/blog/static-forms-serverless-gatsby-netlify)
- [Jamstack for Clients: Benefits, Static Site CMS, & Limitations](https://snipcart.com/blog/jamstack-clients-static-site-cms)
- [Exploring Netlify CMS, a React & Git-Based Content Management System](https://snipcart.com/blog/netlify-cms-react-git-workflow)
- [Jamstack PWA — Let’s Build a Polling App. with Gatsby.js, Firebase, and Styled-components Pt. 1](https://medium.com/@UnicornAgency/jamstack-pwa-lets-build-a-polling-app-with-gatsby-js-firebase-and-styled-components-pt-1-78a03a633092)
- [Dynamic Static Sites with Netlify and iOS Shortcuts; Use Netlify Functions, a Gulp build process and iOS Shortcuts to publish dynamic content to your static site](https://bryanlrobinson.com/blog/2018/11/12/ios-shortcuts-pushing-data-to-netlify-static-site/)
- [Gatsby for Apps](https://www.gatsbyjs.org/blog/2018-11-07-gatsby-for-apps/)
- [Turning the Static Dynamic](https://www.gatsbyjs.org/blog/2018-12-17-turning-the-static-dynamic/)
- [Going Jamstack with Netlify and Nuxt](https://blog.lichter.io/posts/going-jamstack-with-netlify-and-nuxt/)
- [Getting Started With Gridsome](https://scotch.io/tutorials/getting-started-with-gridsome)
- [The Complete Beginner's Guide to Deploying Your First Static Website to IPFS](https://interplanetarygatsby.com/ipfs-deploy/)
- [A Broad Discussion on Jamstack & E-Commerce (Podcast & Transcript)](https://snipcart.com/jamstack-ecommerce-podcast)
- [The Beginner's Guide to Static Site Generators](https://bejamas.io/blog/static-site-generators/)
- [9 Headless CMS Options for Your Jamstack Site](https://bejamas.io/blog/headless-cms/)
- [State of Jamstack 2020 report](https://kontent.ai/resources/state-of-jamstack-2020-report)
- [Jamify Tutorials — Publish flaring fast blogs with Gatsby and Ghost](https://www.jamify.org)
- [State of the Headless CMS Market 2020 report](https://tracker.kontent.ai/592920/state-of-the-headless-cms-market-2020)
- [Why is Next.js my ultimate choice over Gatsby, Gridsome, and Nuxt?](https://kontent.ai/blog/gatsby-vs-next-gridsome-nuxt)
- [Adopting the JAMStack: Building CMS-backed static websites with Vue or React](https://www.codegram.com/blog/a-jamstack-journey-headless-content-management-with-vue-react/)
- [A Ghost Demo: How to Go Headless with Ghost CMS [Tutorial]](https://hashnode.com/post/a-ghost-demo-how-to-go-headless-with-ghost-cms-tutorial-cjy4fxmmr0001rts1pyp2ch2s)
- [Next.js E-Commerce Tutorial: Quick Shopping Cart Integration](https://hashnode.com/post/nextjs-e-commerce-tutorial-quick-shopping-cart-integration-cjy074x9l0017zxs17tn6yp4d)
- [How to Build a Blog using React Static and Cosmic JS](https://sumitkharche.hashnode.dev/how-to-build-a-blog-using-react-static-and-cosmic-js-cjxewj3xa000kjms1c9s0qaae)
- [How to build a Static Serverless Blog for Free😇](https://sujaykundu.hashnode.dev/how-to-build-a-static-serverless-blog-for-free-cjwgqd96u001ezws1v8linwdk)
- [JAMStack vs serverless web apps](https://fettblog.eu/jamstack-vs-serverless-web-apps/) -[JAMstack? More like SHAMstack.](https://css-tricks.com/jamstack-more-like-shamstack/)
- [Static File Hosting Doesn’t Have To Be So… Static](https://css-tricks.com/static-file-hosting-doesnt-have-to-be-so-static/)
- [Static First: Pre-Generated JAMstack Sites with Serverless Rendering as a Fallback](https://css-tricks.com/static-first-pre-generated-jamstack-sites-with-serverless-rendering-as-a-fallback/)

## Books

- [Modern Web Development on the Jamstack](https://www.netlify.com/pdf/oreilly-modern-web-development-on-the-jamstack.pdf) - By Mathias Biilmann & Phil Hawksworth (published by O'Reilly).
- [Hugo in Action](https://www.manning.com/books/hugo-in-action)
- [Jumpstart Jamstack Development](https://www.packtpub.com/web-development/jumpstart-jamstack-development) - By Christopher Pecoraro and Vincenzo Gambino
- [Modern Web Development on the JAMstack](https://www.netlify.com/oreilly-jamstack/) - New Techniques for Ultra Fast Sites and Web Applications by Mathias Biilmann & Phil Hawksworth

## License

[MIT](https://github.com/Olanetsoft/awesome-jamstack-tools/blob/main/LICENSE)
