/* ========================================================================
 * Copyright (c) 2005-2021 The OPC Foundation, Inc. All rights reserved.
 *
 * OPC Foundation MIT License 1.00
 * 
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following
 * conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 *
 * The complete license agreement can be found here:
 * http://opcfoundation.org/License/MIT/1.00/
 * ======================================================================*/

using System;

namespace Opc.Ua.PubSub.PublishedData
{
    /// <summary>
    /// Base class for a DataSet field
    /// </summary>
    public class Field : ICloneable
    {
        /// <summary>
        /// Get/Set Value 
        /// </summary>
        public DataValue Value { get; set; }

        /// <summary>
        /// Get/Set Target NodeId 
        /// </summary>
        public NodeId TargetNodeId { get; set; }

        /// <summary>
        /// Get/Set target attribute 
        /// </summary>
        public uint TargetAttribute { get; set; }

        /// <summary>
        /// Get configured <see cref="FieldMetaData"/> object for this <see cref="Field"/> instance.
        /// </summary>
        public FieldMetaData FieldMetaData { get; internal set; }

        #region ICloneable method
        /// <inheritdoc/>
        public virtual object Clone()
        {
            return this.MemberwiseClone();
        }

        /// <summary>
        /// Create a deep copy of current DataSet
        /// </summary>
        public new object MemberwiseClone()
        {
            Field copy = base.MemberwiseClone() as Field;
            if (Value != null)
            {
                if (copy != null)
                {
                    copy.Value = Value.Clone() as DataValue;
                }
            }

            if (FieldMetaData != null)
            {
                if (copy != null)
                {
                    copy.FieldMetaData = FieldMetaData.Clone() as FieldMetaData;
                }
            }
            return copy;
        }
        #endregion
    }
}
