/* ========================================================================
 * Copyright (c) 2005-2019 The OPC Foundation, Inc. All rights reserved.
 *
 * OPC Foundation MIT License 1.00
 * 
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following
 * conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 *
 * The complete license agreement can be found here:
 * http://opcfoundation.org/License/MIT/1.00/
 * ======================================================================*/

using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using Opc.Ua;

namespace Boiler
{
    public partial class BoilerStateMachineState
    {
        #region Initialization
        /// <summary>
        /// Initializes the object as a collection of counters which change value on read.
        /// </summary>
        protected override void OnAfterCreate(ISystemContext context, NodeState node)
        {
            base.OnAfterCreate(context, node);

            Start.OnCallMethod = OnStart;
            Start.OnReadExecutable = IsStartExecutable;
            Start.OnReadUserExecutable = IsStartUserExecutable;

            Suspend.OnCallMethod = OnSuspend;
            Suspend.OnReadExecutable = IsSuspendExecutable;
            Suspend.OnReadUserExecutable = IsSuspendUserExecutable;

            Resume.OnCallMethod = OnResume;
            Resume.OnReadExecutable = IsResumeExecutable;
            Resume.OnReadUserExecutable = IsResumeUserExecutable;

            Halt.OnCallMethod = OnHalt;
            Halt.OnReadExecutable = IsHaltExecutable;
            Halt.OnReadUserExecutable = IsHaltUserExecutable;

            Reset.OnCallMethod = OnReset;
            Reset.OnReadExecutable = IsResetExecutable;
            Reset.OnReadUserExecutable = IsResetUserExecutable;
        }
        #endregion
    }
}
