/* Copyright 2018 The TensorFlow Authors. All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
==============================================================================*/
// automatically generated by the FlatBuffers compiler, do not modify

#ifndef FLATBUFFERS_GENERATED_SCHEMA_TFLITE_H_
#define FLATBUFFERS_GENERATED_SCHEMA_TFLITE_H_

#include "flatbuffers/flatbuffers.h"

namespace tflite {

struct CustomQuantization;
struct CustomQuantizationT;

struct QuantizationParameters;
struct QuantizationParametersT;

struct Tensor;
struct TensorT;

struct Conv2DOptions;
struct Conv2DOptionsT;

struct Pool2DOptions;
struct Pool2DOptionsT;

struct DepthwiseConv2DOptions;
struct DepthwiseConv2DOptionsT;

struct ConcatEmbeddingsOptions;
struct ConcatEmbeddingsOptionsT;

struct LSHProjectionOptions;
struct LSHProjectionOptionsT;

struct SVDFOptions;
struct SVDFOptionsT;

struct RNNOptions;
struct RNNOptionsT;

struct SequenceRNNOptions;
struct SequenceRNNOptionsT;

struct BidirectionalSequenceRNNOptions;
struct BidirectionalSequenceRNNOptionsT;

struct FullyConnectedOptions;
struct FullyConnectedOptionsT;

struct SoftmaxOptions;
struct SoftmaxOptionsT;

struct ConcatenationOptions;
struct ConcatenationOptionsT;

struct AddOptions;
struct AddOptionsT;

struct MulOptions;
struct MulOptionsT;

struct L2NormOptions;
struct L2NormOptionsT;

struct LocalResponseNormalizationOptions;
struct LocalResponseNormalizationOptionsT;

struct LSTMOptions;
struct LSTMOptionsT;

struct UnidirectionalSequenceLSTMOptions;
struct UnidirectionalSequenceLSTMOptionsT;

struct BidirectionalSequenceLSTMOptions;
struct BidirectionalSequenceLSTMOptionsT;

struct ResizeBilinearOptions;
struct ResizeBilinearOptionsT;

struct ResizeNearestNeighborOptions;
struct ResizeNearestNeighborOptionsT;

struct CallOptions;
struct CallOptionsT;

struct PadOptions;
struct PadOptionsT;

struct PadV2Options;
struct PadV2OptionsT;

struct ReshapeOptions;
struct ReshapeOptionsT;

struct SpaceToBatchNDOptions;
struct SpaceToBatchNDOptionsT;

struct BatchToSpaceNDOptions;
struct BatchToSpaceNDOptionsT;

struct SkipGramOptions;
struct SkipGramOptionsT;

struct SpaceToDepthOptions;
struct SpaceToDepthOptionsT;

struct SubOptions;
struct SubOptionsT;

struct DivOptions;
struct DivOptionsT;

struct TopKV2Options;
struct TopKV2OptionsT;

struct EmbeddingLookupSparseOptions;
struct EmbeddingLookupSparseOptionsT;

struct GatherOptions;
struct GatherOptionsT;

struct TransposeOptions;
struct TransposeOptionsT;

struct ExpOptions;
struct ExpOptionsT;

struct CosOptions;
struct CosOptionsT;

struct ReducerOptions;
struct ReducerOptionsT;

struct SqueezeOptions;
struct SqueezeOptionsT;

struct SplitOptions;
struct SplitOptionsT;

struct SplitVOptions;
struct SplitVOptionsT;

struct StridedSliceOptions;
struct StridedSliceOptionsT;

struct LogSoftmaxOptions;
struct LogSoftmaxOptionsT;

struct CastOptions;
struct CastOptionsT;

struct DequantizeOptions;
struct DequantizeOptionsT;

struct MaximumMinimumOptions;
struct MaximumMinimumOptionsT;

struct TileOptions;
struct TileOptionsT;

struct ArgMaxOptions;
struct ArgMaxOptionsT;

struct ArgMinOptions;
struct ArgMinOptionsT;

struct GreaterOptions;
struct GreaterOptionsT;

struct GreaterEqualOptions;
struct GreaterEqualOptionsT;

struct LessOptions;
struct LessOptionsT;

struct LessEqualOptions;
struct LessEqualOptionsT;

struct NegOptions;
struct NegOptionsT;

struct SelectOptions;
struct SelectOptionsT;

struct SliceOptions;
struct SliceOptionsT;

struct TransposeConvOptions;
struct TransposeConvOptionsT;

struct ExpandDimsOptions;
struct ExpandDimsOptionsT;

struct SparseToDenseOptions;
struct SparseToDenseOptionsT;

struct EqualOptions;
struct EqualOptionsT;

struct NotEqualOptions;
struct NotEqualOptionsT;

struct ShapeOptions;
struct ShapeOptionsT;

struct RankOptions;
struct RankOptionsT;

struct PowOptions;
struct PowOptionsT;

struct FakeQuantOptions;
struct FakeQuantOptionsT;

struct PackOptions;
struct PackOptionsT;

struct LogicalOrOptions;
struct LogicalOrOptionsT;

struct OneHotOptions;
struct OneHotOptionsT;

struct AbsOptions;
struct AbsOptionsT;

struct HardSwishOptions;
struct HardSwishOptionsT;

struct LogicalAndOptions;
struct LogicalAndOptionsT;

struct LogicalNotOptions;
struct LogicalNotOptionsT;

struct UnpackOptions;
struct UnpackOptionsT;

struct FloorDivOptions;
struct FloorDivOptionsT;

struct SquareOptions;
struct SquareOptionsT;

struct ZerosLikeOptions;
struct ZerosLikeOptionsT;

struct FillOptions;
struct FillOptionsT;

struct FloorModOptions;
struct FloorModOptionsT;

struct RangeOptions;
struct RangeOptionsT;

struct LeakyReluOptions;
struct LeakyReluOptionsT;

struct SquaredDifferenceOptions;
struct SquaredDifferenceOptionsT;

struct MirrorPadOptions;
struct MirrorPadOptionsT;

struct UniqueOptions;
struct UniqueOptionsT;

struct ReverseV2Options;
struct ReverseV2OptionsT;

struct AddNOptions;
struct AddNOptionsT;

struct GatherNdOptions;
struct GatherNdOptionsT;

struct WhereOptions;
struct WhereOptionsT;

struct ReverseSequenceOptions;
struct ReverseSequenceOptionsT;

struct MatrixDiagOptions;
struct MatrixDiagOptionsT;

struct QuantizeOptions;
struct QuantizeOptionsT;

struct MatrixSetDiagOptions;
struct MatrixSetDiagOptionsT;

struct IfOptions;
struct IfOptionsT;

struct WhileOptions;
struct WhileOptionsT;

struct OperatorCode;
struct OperatorCodeT;

struct Operator;
struct OperatorT;

struct SubGraph;
struct SubGraphT;

struct Buffer;
struct BufferT;

struct Metadata;
struct MetadataT;

struct Model;
struct ModelT;

enum TensorType
{
    TensorType_FLOAT32 = 0,
    TensorType_FLOAT16 = 1,
    TensorType_INT32 = 2,
    TensorType_UINT8 = 3,
    TensorType_INT64 = 4,
    TensorType_STRING = 5,
    TensorType_BOOL = 6,
    TensorType_INT16 = 7,
    TensorType_COMPLEX64 = 8,
    TensorType_INT8 = 9,
    TensorType_MIN = TensorType_FLOAT32,
    TensorType_MAX = TensorType_INT8
};

inline const TensorType (&EnumValuesTensorType())[10]
{
    static const TensorType values[] = {
        TensorType_FLOAT32,
        TensorType_FLOAT16,
        TensorType_INT32,
        TensorType_UINT8,
        TensorType_INT64,
        TensorType_STRING,
        TensorType_BOOL,
        TensorType_INT16,
        TensorType_COMPLEX64,
        TensorType_INT8};
    return values;
}

inline const char* const* EnumNamesTensorType()
{
    static const char* const names[] = {
        "FLOAT32",
        "FLOAT16",
        "INT32",
        "UINT8",
        "INT64",
        "STRING",
        "BOOL",
        "INT16",
        "COMPLEX64",
        "INT8",
        nullptr};
    return names;
}

inline const char* EnumNameTensorType(TensorType e)
{
    if (e < TensorType_FLOAT32 || e > TensorType_INT8) return "";
    const size_t index = static_cast<size_t>(e);
    return EnumNamesTensorType()[index];
}

enum QuantizationDetails
{
    QuantizationDetails_NONE = 0,
    QuantizationDetails_CustomQuantization = 1,
    QuantizationDetails_MIN = QuantizationDetails_NONE,
    QuantizationDetails_MAX = QuantizationDetails_CustomQuantization
};

inline const QuantizationDetails (&EnumValuesQuantizationDetails())[2]
{
    static const QuantizationDetails values[] = {
        QuantizationDetails_NONE,
        QuantizationDetails_CustomQuantization};
    return values;
}

inline const char* const* EnumNamesQuantizationDetails()
{
    static const char* const names[] = {
        "NONE",
        "CustomQuantization",
        nullptr};
    return names;
}

inline const char* EnumNameQuantizationDetails(QuantizationDetails e)
{
    if (e < QuantizationDetails_NONE || e > QuantizationDetails_CustomQuantization) return "";
    const size_t index = static_cast<size_t>(e);
    return EnumNamesQuantizationDetails()[index];
}

template<typename T>
struct QuantizationDetailsTraits
{
    static const QuantizationDetails enum_value = QuantizationDetails_NONE;
};

template<>
struct QuantizationDetailsTraits<CustomQuantization>
{
    static const QuantizationDetails enum_value = QuantizationDetails_CustomQuantization;
};

struct QuantizationDetailsUnion
{
    QuantizationDetails type;
    void* value;

    QuantizationDetailsUnion()
        : type(QuantizationDetails_NONE), value(nullptr)
    {
    }
    QuantizationDetailsUnion(QuantizationDetailsUnion&& u) FLATBUFFERS_NOEXCEPT : type(QuantizationDetails_NONE), value(nullptr)
    {
        std::swap(type, u.type);
        std::swap(value, u.value);
    }
    QuantizationDetailsUnion(const QuantizationDetailsUnion&) FLATBUFFERS_NOEXCEPT;
    QuantizationDetailsUnion& operator=(const QuantizationDetailsUnion& u) FLATBUFFERS_NOEXCEPT
    {
        QuantizationDetailsUnion t(u);
        std::swap(type, t.type);
        std::swap(value, t.value);
        return *this;
    }
    QuantizationDetailsUnion& operator=(QuantizationDetailsUnion&& u) FLATBUFFERS_NOEXCEPT
    {
        std::swap(type, u.type);
        std::swap(value, u.value);
        return *this;
    }
    ~QuantizationDetailsUnion()
    {
        Reset();
    }

    void Reset();

#ifndef FLATBUFFERS_CPP98_STL
    template<typename T>
    void Set(T&& val)
    {
        using RT = typename std::remove_reference<T>::type;
        Reset();
        type = QuantizationDetailsTraits<typename RT::TableType>::enum_value;
        if (type != QuantizationDetails_NONE)
        {
            value = new RT(std::forward<T>(val));
        }
    }
#endif // FLATBUFFERS_CPP98_STL

    static void* UnPack(const void* obj, QuantizationDetails type, const flatbuffers::resolver_function_t* resolver);
    flatbuffers::Offset<void> Pack(flatbuffers::FlatBufferBuilder& _fbb, const flatbuffers::rehasher_function_t* _rehasher = nullptr) const;

    CustomQuantizationT* AsCustomQuantization()
    {
        return type == QuantizationDetails_CustomQuantization ? reinterpret_cast<CustomQuantizationT*>(value) : nullptr;
    }
    const CustomQuantizationT* AsCustomQuantization() const
    {
        return type == QuantizationDetails_CustomQuantization ? reinterpret_cast<const CustomQuantizationT*>(value) : nullptr;
    }
};

bool VerifyQuantizationDetails(flatbuffers::Verifier& verifier, const void* obj, QuantizationDetails type);
bool VerifyQuantizationDetailsVector(flatbuffers::Verifier& verifier, const flatbuffers::Vector<flatbuffers::Offset<void> >* values, const flatbuffers::Vector<uint8_t>* types);

enum BuiltinOperator
{
    BuiltinOperator_ADD = 0,
    BuiltinOperator_AVERAGE_POOL_2D = 1,
    BuiltinOperator_CONCATENATION = 2,
    BuiltinOperator_CONV_2D = 3,
    BuiltinOperator_DEPTHWISE_CONV_2D = 4,
    BuiltinOperator_DEQUANTIZE = 6,
    BuiltinOperator_EMBEDDING_LOOKUP = 7,
    BuiltinOperator_FLOOR = 8,
    BuiltinOperator_FULLY_CONNECTED = 9,
    BuiltinOperator_HASHTABLE_LOOKUP = 10,
    BuiltinOperator_L2_NORMALIZATION = 11,
    BuiltinOperator_L2_POOL_2D = 12,
    BuiltinOperator_LOCAL_RESPONSE_NORMALIZATION = 13,
    BuiltinOperator_LOGISTIC = 14,
    BuiltinOperator_LSH_PROJECTION = 15,
    BuiltinOperator_LSTM = 16,
    BuiltinOperator_MAX_POOL_2D = 17,
    BuiltinOperator_MUL = 18,
    BuiltinOperator_RELU = 19,
    BuiltinOperator_RELU_N1_TO_1 = 20,
    BuiltinOperator_RELU6 = 21,
    BuiltinOperator_RESHAPE = 22,
    BuiltinOperator_RESIZE_BILINEAR = 23,
    BuiltinOperator_RNN = 24,
    BuiltinOperator_SOFTMAX = 25,
    BuiltinOperator_SPACE_TO_DEPTH = 26,
    BuiltinOperator_SVDF = 27,
    BuiltinOperator_TANH = 28,
    BuiltinOperator_CONCAT_EMBEDDINGS = 29,
    BuiltinOperator_SKIP_GRAM = 30,
    BuiltinOperator_CALL = 31,
    BuiltinOperator_CUSTOM = 32,
    BuiltinOperator_EMBEDDING_LOOKUP_SPARSE = 33,
    BuiltinOperator_PAD = 34,
    BuiltinOperator_UNIDIRECTIONAL_SEQUENCE_RNN = 35,
    BuiltinOperator_GATHER = 36,
    BuiltinOperator_BATCH_TO_SPACE_ND = 37,
    BuiltinOperator_SPACE_TO_BATCH_ND = 38,
    BuiltinOperator_TRANSPOSE = 39,
    BuiltinOperator_MEAN = 40,
    BuiltinOperator_SUB = 41,
    BuiltinOperator_DIV = 42,
    BuiltinOperator_SQUEEZE = 43,
    BuiltinOperator_UNIDIRECTIONAL_SEQUENCE_LSTM = 44,
    BuiltinOperator_STRIDED_SLICE = 45,
    BuiltinOperator_BIDIRECTIONAL_SEQUENCE_RNN = 46,
    BuiltinOperator_EXP = 47,
    BuiltinOperator_TOPK_V2 = 48,
    BuiltinOperator_SPLIT = 49,
    BuiltinOperator_LOG_SOFTMAX = 50,
    BuiltinOperator_DELEGATE = 51,
    BuiltinOperator_BIDIRECTIONAL_SEQUENCE_LSTM = 52,
    BuiltinOperator_CAST = 53,
    BuiltinOperator_PRELU = 54,
    BuiltinOperator_MAXIMUM = 55,
    BuiltinOperator_ARG_MAX = 56,
    BuiltinOperator_MINIMUM = 57,
    BuiltinOperator_LESS = 58,
    BuiltinOperator_NEG = 59,
    BuiltinOperator_PADV2 = 60,
    BuiltinOperator_GREATER = 61,
    BuiltinOperator_GREATER_EQUAL = 62,
    BuiltinOperator_LESS_EQUAL = 63,
    BuiltinOperator_SELECT = 64,
    BuiltinOperator_SLICE = 65,
    BuiltinOperator_SIN = 66,
    BuiltinOperator_TRANSPOSE_CONV = 67,
    BuiltinOperator_SPARSE_TO_DENSE = 68,
    BuiltinOperator_TILE = 69,
    BuiltinOperator_EXPAND_DIMS = 70,
    BuiltinOperator_EQUAL = 71,
    BuiltinOperator_NOT_EQUAL = 72,
    BuiltinOperator_LOG = 73,
    BuiltinOperator_SUM = 74,
    BuiltinOperator_SQRT = 75,
    BuiltinOperator_RSQRT = 76,
    BuiltinOperator_SHAPE = 77,
    BuiltinOperator_POW = 78,
    BuiltinOperator_ARG_MIN = 79,
    BuiltinOperator_FAKE_QUANT = 80,
    BuiltinOperator_REDUCE_PROD = 81,
    BuiltinOperator_REDUCE_MAX = 82,
    BuiltinOperator_PACK = 83,
    BuiltinOperator_LOGICAL_OR = 84,
    BuiltinOperator_ONE_HOT = 85,
    BuiltinOperator_LOGICAL_AND = 86,
    BuiltinOperator_LOGICAL_NOT = 87,
    BuiltinOperator_UNPACK = 88,
    BuiltinOperator_REDUCE_MIN = 89,
    BuiltinOperator_FLOOR_DIV = 90,
    BuiltinOperator_REDUCE_ANY = 91,
    BuiltinOperator_SQUARE = 92,
    BuiltinOperator_ZEROS_LIKE = 93,
    BuiltinOperator_FILL = 94,
    BuiltinOperator_FLOOR_MOD = 95,
    BuiltinOperator_RANGE = 96,
    BuiltinOperator_RESIZE_NEAREST_NEIGHBOR = 97,
    BuiltinOperator_LEAKY_RELU = 98,
    BuiltinOperator_SQUARED_DIFFERENCE = 99,
    BuiltinOperator_MIRROR_PAD = 100,
    BuiltinOperator_ABS = 101,
    BuiltinOperator_SPLIT_V = 102,
    BuiltinOperator_UNIQUE = 103,
    BuiltinOperator_CEIL = 104,
    BuiltinOperator_REVERSE_V2 = 105,
    BuiltinOperator_ADD_N = 106,
    BuiltinOperator_GATHER_ND = 107,
    BuiltinOperator_COS = 108,
    BuiltinOperator_WHERE = 109,
    BuiltinOperator_RANK = 110,
    BuiltinOperator_ELU = 111,
    BuiltinOperator_REVERSE_SEQUENCE = 112,
    BuiltinOperator_MATRIX_DIAG = 113,
    BuiltinOperator_QUANTIZE = 114,
    BuiltinOperator_MATRIX_SET_DIAG = 115,
    BuiltinOperator_ROUND = 116,
    BuiltinOperator_HARD_SWISH = 117,
    BuiltinOperator_IF = 118,
    BuiltinOperator_WHILE = 119,
    BuiltinOperator_MIN = BuiltinOperator_ADD,
    BuiltinOperator_MAX = BuiltinOperator_WHILE
};

inline const BuiltinOperator (&EnumValuesBuiltinOperator())[119]
{
    static const BuiltinOperator values[] = {
        BuiltinOperator_ADD,
        BuiltinOperator_AVERAGE_POOL_2D,
        BuiltinOperator_CONCATENATION,
        BuiltinOperator_CONV_2D,
        BuiltinOperator_DEPTHWISE_CONV_2D,
        BuiltinOperator_DEQUANTIZE,
        BuiltinOperator_EMBEDDING_LOOKUP,
        BuiltinOperator_FLOOR,
        BuiltinOperator_FULLY_CONNECTED,
        BuiltinOperator_HASHTABLE_LOOKUP,
        BuiltinOperator_L2_NORMALIZATION,
        BuiltinOperator_L2_POOL_2D,
        BuiltinOperator_LOCAL_RESPONSE_NORMALIZATION,
        BuiltinOperator_LOGISTIC,
        BuiltinOperator_LSH_PROJECTION,
        BuiltinOperator_LSTM,
        BuiltinOperator_MAX_POOL_2D,
        BuiltinOperator_MUL,
        BuiltinOperator_RELU,
        BuiltinOperator_RELU_N1_TO_1,
        BuiltinOperator_RELU6,
        BuiltinOperator_RESHAPE,
        BuiltinOperator_RESIZE_BILINEAR,
        BuiltinOperator_RNN,
        BuiltinOperator_SOFTMAX,
        BuiltinOperator_SPACE_TO_DEPTH,
        BuiltinOperator_SVDF,
        BuiltinOperator_TANH,
        BuiltinOperator_CONCAT_EMBEDDINGS,
        BuiltinOperator_SKIP_GRAM,
        BuiltinOperator_CALL,
        BuiltinOperator_CUSTOM,
        BuiltinOperator_EMBEDDING_LOOKUP_SPARSE,
        BuiltinOperator_PAD,
        BuiltinOperator_UNIDIRECTIONAL_SEQUENCE_RNN,
        BuiltinOperator_GATHER,
        BuiltinOperator_BATCH_TO_SPACE_ND,
        BuiltinOperator_SPACE_TO_BATCH_ND,
        BuiltinOperator_TRANSPOSE,
        BuiltinOperator_MEAN,
        BuiltinOperator_SUB,
        BuiltinOperator_DIV,
        BuiltinOperator_SQUEEZE,
        BuiltinOperator_UNIDIRECTIONAL_SEQUENCE_LSTM,
        BuiltinOperator_STRIDED_SLICE,
        BuiltinOperator_BIDIRECTIONAL_SEQUENCE_RNN,
        BuiltinOperator_EXP,
        BuiltinOperator_TOPK_V2,
        BuiltinOperator_SPLIT,
        BuiltinOperator_LOG_SOFTMAX,
        BuiltinOperator_DELEGATE,
        BuiltinOperator_BIDIRECTIONAL_SEQUENCE_LSTM,
        BuiltinOperator_CAST,
        BuiltinOperator_PRELU,
        BuiltinOperator_MAXIMUM,
        BuiltinOperator_ARG_MAX,
        BuiltinOperator_MINIMUM,
        BuiltinOperator_LESS,
        BuiltinOperator_NEG,
        BuiltinOperator_PADV2,
        BuiltinOperator_GREATER,
        BuiltinOperator_GREATER_EQUAL,
        BuiltinOperator_LESS_EQUAL,
        BuiltinOperator_SELECT,
        BuiltinOperator_SLICE,
        BuiltinOperator_SIN,
        BuiltinOperator_TRANSPOSE_CONV,
        BuiltinOperator_SPARSE_TO_DENSE,
        BuiltinOperator_TILE,
        BuiltinOperator_EXPAND_DIMS,
        BuiltinOperator_EQUAL,
        BuiltinOperator_NOT_EQUAL,
        BuiltinOperator_LOG,
        BuiltinOperator_SUM,
        BuiltinOperator_SQRT,
        BuiltinOperator_RSQRT,
        BuiltinOperator_SHAPE,
        BuiltinOperator_POW,
        BuiltinOperator_ARG_MIN,
        BuiltinOperator_FAKE_QUANT,
        BuiltinOperator_REDUCE_PROD,
        BuiltinOperator_REDUCE_MAX,
        BuiltinOperator_PACK,
        BuiltinOperator_LOGICAL_OR,
        BuiltinOperator_ONE_HOT,
        BuiltinOperator_LOGICAL_AND,
        BuiltinOperator_LOGICAL_NOT,
        BuiltinOperator_UNPACK,
        BuiltinOperator_REDUCE_MIN,
        BuiltinOperator_FLOOR_DIV,
        BuiltinOperator_REDUCE_ANY,
        BuiltinOperator_SQUARE,
        BuiltinOperator_ZEROS_LIKE,
        BuiltinOperator_FILL,
        BuiltinOperator_FLOOR_MOD,
        BuiltinOperator_RANGE,
        BuiltinOperator_RESIZE_NEAREST_NEIGHBOR,
        BuiltinOperator_LEAKY_RELU,
        BuiltinOperator_SQUARED_DIFFERENCE,
        BuiltinOperator_MIRROR_PAD,
        BuiltinOperator_ABS,
        BuiltinOperator_SPLIT_V,
        BuiltinOperator_UNIQUE,
        BuiltinOperator_CEIL,
        BuiltinOperator_REVERSE_V2,
        BuiltinOperator_ADD_N,
        BuiltinOperator_GATHER_ND,
        BuiltinOperator_COS,
        BuiltinOperator_WHERE,
        BuiltinOperator_RANK,
        BuiltinOperator_ELU,
        BuiltinOperator_REVERSE_SEQUENCE,
        BuiltinOperator_MATRIX_DIAG,
        BuiltinOperator_QUANTIZE,
        BuiltinOperator_MATRIX_SET_DIAG,
        BuiltinOperator_ROUND,
        BuiltinOperator_HARD_SWISH,
        BuiltinOperator_IF,
        BuiltinOperator_WHILE};
    return values;
}

inline const char* const* EnumNamesBuiltinOperator()
{
    static const char* const names[] = {
        "ADD",
        "AVERAGE_POOL_2D",
        "CONCATENATION",
        "CONV_2D",
        "DEPTHWISE_CONV_2D",
        "",
        "DEQUANTIZE",
        "EMBEDDING_LOOKUP",
        "FLOOR",
        "FULLY_CONNECTED",
        "HASHTABLE_LOOKUP",
        "L2_NORMALIZATION",
        "L2_POOL_2D",
        "LOCAL_RESPONSE_NORMALIZATION",
        "LOGISTIC",
        "LSH_PROJECTION",
        "LSTM",
        "MAX_POOL_2D",
        "MUL",
        "RELU",
        "RELU_N1_TO_1",
        "RELU6",
        "RESHAPE",
        "RESIZE_BILINEAR",
        "RNN",
        "SOFTMAX",
        "SPACE_TO_DEPTH",
        "SVDF",
        "TANH",
        "CONCAT_EMBEDDINGS",
        "SKIP_GRAM",
        "CALL",
        "CUSTOM",
        "EMBEDDING_LOOKUP_SPARSE",
        "PAD",
        "UNIDIRECTIONAL_SEQUENCE_RNN",
        "GATHER",
        "BATCH_TO_SPACE_ND",
        "SPACE_TO_BATCH_ND",
        "TRANSPOSE",
        "MEAN",
        "SUB",
        "DIV",
        "SQUEEZE",
        "UNIDIRECTIONAL_SEQUENCE_LSTM",
        "STRIDED_SLICE",
        "BIDIRECTIONAL_SEQUENCE_RNN",
        "EXP",
        "TOPK_V2",
        "SPLIT",
        "LOG_SOFTMAX",
        "DELEGATE",
        "BIDIRECTIONAL_SEQUENCE_LSTM",
        "CAST",
        "PRELU",
        "MAXIMUM",
        "ARG_MAX",
        "MINIMUM",
        "LESS",
        "NEG",
        "PADV2",
        "GREATER",
        "GREATER_EQUAL",
        "LESS_EQUAL",
        "SELECT",
        "SLICE",
        "SIN",
        "TRANSPOSE_CONV",
        "SPARSE_TO_DENSE",
        "TILE",
        "EXPAND_DIMS",
        "EQUAL",
        "NOT_EQUAL",
        "LOG",
        "SUM",
        "SQRT",
        "RSQRT",
        "SHAPE",
        "POW",
        "ARG_MIN",
        "FAKE_QUANT",
        "REDUCE_PROD",
        "REDUCE_MAX",
        "PACK",
        "LOGICAL_OR",
        "ONE_HOT",
        "LOGICAL_AND",
        "LOGICAL_NOT",
        "UNPACK",
        "REDUCE_MIN",
        "FLOOR_DIV",
        "REDUCE_ANY",
        "SQUARE",
        "ZEROS_LIKE",
        "FILL",
        "FLOOR_MOD",
        "RANGE",
        "RESIZE_NEAREST_NEIGHBOR",
        "LEAKY_RELU",
        "SQUARED_DIFFERENCE",
        "MIRROR_PAD",
        "ABS",
        "SPLIT_V",
        "UNIQUE",
        "CEIL",
        "REVERSE_V2",
        "ADD_N",
        "GATHER_ND",
        "COS",
        "WHERE",
        "RANK",
        "ELU",
        "REVERSE_SEQUENCE",
        "MATRIX_DIAG",
        "QUANTIZE",
        "MATRIX_SET_DIAG",
        "ROUND",
        "HARD_SWISH",
        "IF",
        "WHILE",
        nullptr};
    return names;
}

inline const char* EnumNameBuiltinOperator(BuiltinOperator e)
{
    if (e < BuiltinOperator_ADD || e > BuiltinOperator_WHILE) return "";
    const size_t index = static_cast<size_t>(e);
    return EnumNamesBuiltinOperator()[index];
}

enum BuiltinOptions
{
    BuiltinOptions_NONE = 0,
    BuiltinOptions_Conv2DOptions = 1,
    BuiltinOptions_DepthwiseConv2DOptions = 2,
    BuiltinOptions_ConcatEmbeddingsOptions = 3,
    BuiltinOptions_LSHProjectionOptions = 4,
    BuiltinOptions_Pool2DOptions = 5,
    BuiltinOptions_SVDFOptions = 6,
    BuiltinOptions_RNNOptions = 7,
    BuiltinOptions_FullyConnectedOptions = 8,
    BuiltinOptions_SoftmaxOptions = 9,
    BuiltinOptions_ConcatenationOptions = 10,
    BuiltinOptions_AddOptions = 11,
    BuiltinOptions_L2NormOptions = 12,
    BuiltinOptions_LocalResponseNormalizationOptions = 13,
    BuiltinOptions_LSTMOptions = 14,
    BuiltinOptions_ResizeBilinearOptions = 15,
    BuiltinOptions_CallOptions = 16,
    BuiltinOptions_ReshapeOptions = 17,
    BuiltinOptions_SkipGramOptions = 18,
    BuiltinOptions_SpaceToDepthOptions = 19,
    BuiltinOptions_EmbeddingLookupSparseOptions = 20,
    BuiltinOptions_MulOptions = 21,
    BuiltinOptions_PadOptions = 22,
    BuiltinOptions_GatherOptions = 23,
    BuiltinOptions_BatchToSpaceNDOptions = 24,
    BuiltinOptions_SpaceToBatchNDOptions = 25,
    BuiltinOptions_TransposeOptions = 26,
    BuiltinOptions_ReducerOptions = 27,
    BuiltinOptions_SubOptions = 28,
    BuiltinOptions_DivOptions = 29,
    BuiltinOptions_SqueezeOptions = 30,
    BuiltinOptions_SequenceRNNOptions = 31,
    BuiltinOptions_StridedSliceOptions = 32,
    BuiltinOptions_ExpOptions = 33,
    BuiltinOptions_TopKV2Options = 34,
    BuiltinOptions_SplitOptions = 35,
    BuiltinOptions_LogSoftmaxOptions = 36,
    BuiltinOptions_CastOptions = 37,
    BuiltinOptions_DequantizeOptions = 38,
    BuiltinOptions_MaximumMinimumOptions = 39,
    BuiltinOptions_ArgMaxOptions = 40,
    BuiltinOptions_LessOptions = 41,
    BuiltinOptions_NegOptions = 42,
    BuiltinOptions_PadV2Options = 43,
    BuiltinOptions_GreaterOptions = 44,
    BuiltinOptions_GreaterEqualOptions = 45,
    BuiltinOptions_LessEqualOptions = 46,
    BuiltinOptions_SelectOptions = 47,
    BuiltinOptions_SliceOptions = 48,
    BuiltinOptions_TransposeConvOptions = 49,
    BuiltinOptions_SparseToDenseOptions = 50,
    BuiltinOptions_TileOptions = 51,
    BuiltinOptions_ExpandDimsOptions = 52,
    BuiltinOptions_EqualOptions = 53,
    BuiltinOptions_NotEqualOptions = 54,
    BuiltinOptions_ShapeOptions = 55,
    BuiltinOptions_PowOptions = 56,
    BuiltinOptions_ArgMinOptions = 57,
    BuiltinOptions_FakeQuantOptions = 58,
    BuiltinOptions_PackOptions = 59,
    BuiltinOptions_LogicalOrOptions = 60,
    BuiltinOptions_OneHotOptions = 61,
    BuiltinOptions_LogicalAndOptions = 62,
    BuiltinOptions_LogicalNotOptions = 63,
    BuiltinOptions_UnpackOptions = 64,
    BuiltinOptions_FloorDivOptions = 65,
    BuiltinOptions_SquareOptions = 66,
    BuiltinOptions_ZerosLikeOptions = 67,
    BuiltinOptions_FillOptions = 68,
    BuiltinOptions_BidirectionalSequenceLSTMOptions = 69,
    BuiltinOptions_BidirectionalSequenceRNNOptions = 70,
    BuiltinOptions_UnidirectionalSequenceLSTMOptions = 71,
    BuiltinOptions_FloorModOptions = 72,
    BuiltinOptions_RangeOptions = 73,
    BuiltinOptions_ResizeNearestNeighborOptions = 74,
    BuiltinOptions_LeakyReluOptions = 75,
    BuiltinOptions_SquaredDifferenceOptions = 76,
    BuiltinOptions_MirrorPadOptions = 77,
    BuiltinOptions_AbsOptions = 78,
    BuiltinOptions_SplitVOptions = 79,
    BuiltinOptions_UniqueOptions = 80,
    BuiltinOptions_ReverseV2Options = 81,
    BuiltinOptions_AddNOptions = 82,
    BuiltinOptions_GatherNdOptions = 83,
    BuiltinOptions_CosOptions = 84,
    BuiltinOptions_WhereOptions = 85,
    BuiltinOptions_RankOptions = 86,
    BuiltinOptions_ReverseSequenceOptions = 87,
    BuiltinOptions_MatrixDiagOptions = 88,
    BuiltinOptions_QuantizeOptions = 89,
    BuiltinOptions_MatrixSetDiagOptions = 90,
    BuiltinOptions_HardSwishOptions = 91,
    BuiltinOptions_IfOptions = 92,
    BuiltinOptions_WhileOptions = 93,
    BuiltinOptions_MIN = BuiltinOptions_NONE,
    BuiltinOptions_MAX = BuiltinOptions_WhileOptions
};

inline const BuiltinOptions (&EnumValuesBuiltinOptions())[94]
{
    static const BuiltinOptions values[] = {
        BuiltinOptions_NONE,
        BuiltinOptions_Conv2DOptions,
        BuiltinOptions_DepthwiseConv2DOptions,
        BuiltinOptions_ConcatEmbeddingsOptions,
        BuiltinOptions_LSHProjectionOptions,
        BuiltinOptions_Pool2DOptions,
        BuiltinOptions_SVDFOptions,
        BuiltinOptions_RNNOptions,
        BuiltinOptions_FullyConnectedOptions,
        BuiltinOptions_SoftmaxOptions,
        BuiltinOptions_ConcatenationOptions,
        BuiltinOptions_AddOptions,
        BuiltinOptions_L2NormOptions,
        BuiltinOptions_LocalResponseNormalizationOptions,
        BuiltinOptions_LSTMOptions,
        BuiltinOptions_ResizeBilinearOptions,
        BuiltinOptions_CallOptions,
        BuiltinOptions_ReshapeOptions,
        BuiltinOptions_SkipGramOptions,
        BuiltinOptions_SpaceToDepthOptions,
        BuiltinOptions_EmbeddingLookupSparseOptions,
        BuiltinOptions_MulOptions,
        BuiltinOptions_PadOptions,
        BuiltinOptions_GatherOptions,
        BuiltinOptions_BatchToSpaceNDOptions,
        BuiltinOptions_SpaceToBatchNDOptions,
        BuiltinOptions_TransposeOptions,
        BuiltinOptions_ReducerOptions,
        BuiltinOptions_SubOptions,
        BuiltinOptions_DivOptions,
        BuiltinOptions_SqueezeOptions,
        BuiltinOptions_SequenceRNNOptions,
        BuiltinOptions_StridedSliceOptions,
        BuiltinOptions_ExpOptions,
        BuiltinOptions_TopKV2Options,
        BuiltinOptions_SplitOptions,
        BuiltinOptions_LogSoftmaxOptions,
        BuiltinOptions_CastOptions,
        BuiltinOptions_DequantizeOptions,
        BuiltinOptions_MaximumMinimumOptions,
        BuiltinOptions_ArgMaxOptions,
        BuiltinOptions_LessOptions,
        BuiltinOptions_NegOptions,
        BuiltinOptions_PadV2Options,
        BuiltinOptions_GreaterOptions,
        BuiltinOptions_GreaterEqualOptions,
        BuiltinOptions_LessEqualOptions,
        BuiltinOptions_SelectOptions,
        BuiltinOptions_SliceOptions,
        BuiltinOptions_TransposeConvOptions,
        BuiltinOptions_SparseToDenseOptions,
        BuiltinOptions_TileOptions,
        BuiltinOptions_ExpandDimsOptions,
        BuiltinOptions_EqualOptions,
        BuiltinOptions_NotEqualOptions,
        BuiltinOptions_ShapeOptions,
        BuiltinOptions_PowOptions,
        BuiltinOptions_ArgMinOptions,
        BuiltinOptions_FakeQuantOptions,
        BuiltinOptions_PackOptions,
        BuiltinOptions_LogicalOrOptions,
        BuiltinOptions_OneHotOptions,
        BuiltinOptions_LogicalAndOptions,
        BuiltinOptions_LogicalNotOptions,
        BuiltinOptions_UnpackOptions,
        BuiltinOptions_FloorDivOptions,
        BuiltinOptions_SquareOptions,
        BuiltinOptions_ZerosLikeOptions,
        BuiltinOptions_FillOptions,
        BuiltinOptions_BidirectionalSequenceLSTMOptions,
        BuiltinOptions_BidirectionalSequenceRNNOptions,
        BuiltinOptions_UnidirectionalSequenceLSTMOptions,
        BuiltinOptions_FloorModOptions,
        BuiltinOptions_RangeOptions,
        BuiltinOptions_ResizeNearestNeighborOptions,
        BuiltinOptions_LeakyReluOptions,
        BuiltinOptions_SquaredDifferenceOptions,
        BuiltinOptions_MirrorPadOptions,
        BuiltinOptions_AbsOptions,
        BuiltinOptions_SplitVOptions,
        BuiltinOptions_UniqueOptions,
        BuiltinOptions_ReverseV2Options,
        BuiltinOptions_AddNOptions,
        BuiltinOptions_GatherNdOptions,
        BuiltinOptions_CosOptions,
        BuiltinOptions_WhereOptions,
        BuiltinOptions_RankOptions,
        BuiltinOptions_ReverseSequenceOptions,
        BuiltinOptions_MatrixDiagOptions,
        BuiltinOptions_QuantizeOptions,
        BuiltinOptions_MatrixSetDiagOptions,
        BuiltinOptions_HardSwishOptions,
        BuiltinOptions_IfOptions,
        BuiltinOptions_WhileOptions};
    return values;
}

inline const char* const* EnumNamesBuiltinOptions()
{
    static const char* const names[] = {
        "NONE",
        "Conv2DOptions",
        "DepthwiseConv2DOptions",
        "ConcatEmbeddingsOptions",
        "LSHProjectionOptions",
        "Pool2DOptions",
        "SVDFOptions",
        "RNNOptions",
        "FullyConnectedOptions",
        "SoftmaxOptions",
        "ConcatenationOptions",
        "AddOptions",
        "L2NormOptions",
        "LocalResponseNormalizationOptions",
        "LSTMOptions",
        "ResizeBilinearOptions",
        "CallOptions",
        "ReshapeOptions",
        "SkipGramOptions",
        "SpaceToDepthOptions",
        "EmbeddingLookupSparseOptions",
        "MulOptions",
        "PadOptions",
        "GatherOptions",
        "BatchToSpaceNDOptions",
        "SpaceToBatchNDOptions",
        "TransposeOptions",
        "ReducerOptions",
        "SubOptions",
        "DivOptions",
        "SqueezeOptions",
        "SequenceRNNOptions",
        "StridedSliceOptions",
        "ExpOptions",
        "TopKV2Options",
        "SplitOptions",
        "LogSoftmaxOptions",
        "CastOptions",
        "DequantizeOptions",
        "MaximumMinimumOptions",
        "ArgMaxOptions",
        "LessOptions",
        "NegOptions",
        "PadV2Options",
        "GreaterOptions",
        "GreaterEqualOptions",
        "LessEqualOptions",
        "SelectOptions",
        "SliceOptions",
        "TransposeConvOptions",
        "SparseToDenseOptions",
        "TileOptions",
        "ExpandDimsOptions",
        "EqualOptions",
        "NotEqualOptions",
        "ShapeOptions",
        "PowOptions",
        "ArgMinOptions",
        "FakeQuantOptions",
        "PackOptions",
        "LogicalOrOptions",
        "OneHotOptions",
        "LogicalAndOptions",
        "LogicalNotOptions",
        "UnpackOptions",
        "FloorDivOptions",
        "SquareOptions",
        "ZerosLikeOptions",
        "FillOptions",
        "BidirectionalSequenceLSTMOptions",
        "BidirectionalSequenceRNNOptions",
        "UnidirectionalSequenceLSTMOptions",
        "FloorModOptions",
        "RangeOptions",
        "ResizeNearestNeighborOptions",
        "LeakyReluOptions",
        "SquaredDifferenceOptions",
        "MirrorPadOptions",
        "AbsOptions",
        "SplitVOptions",
        "UniqueOptions",
        "ReverseV2Options",
        "AddNOptions",
        "GatherNdOptions",
        "CosOptions",
        "WhereOptions",
        "RankOptions",
        "ReverseSequenceOptions",
        "MatrixDiagOptions",
        "QuantizeOptions",
        "MatrixSetDiagOptions",
        "HardSwishOptions",
        "IfOptions",
        "WhileOptions",
        nullptr};
    return names;
}

inline const char* EnumNameBuiltinOptions(BuiltinOptions e)
{
    if (e < BuiltinOptions_NONE || e > BuiltinOptions_WhileOptions) return "";
    const size_t index = static_cast<size_t>(e);
    return EnumNamesBuiltinOptions()[index];
}

template<typename T>
struct BuiltinOptionsTraits
{
    static const BuiltinOptions enum_value = BuiltinOptions_NONE;
};

template<>
struct BuiltinOptionsTraits<Conv2DOptions>
{
    static const BuiltinOptions enum_value = BuiltinOptions_Conv2DOptions;
};

template<>
struct BuiltinOptionsTraits<DepthwiseConv2DOptions>
{
    static const BuiltinOptions enum_value = BuiltinOptions_DepthwiseConv2DOptions;
};

template<>
struct BuiltinOptionsTraits<ConcatEmbeddingsOptions>
{
    static const BuiltinOptions enum_value = BuiltinOptions_ConcatEmbeddingsOptions;
};

template<>
struct BuiltinOptionsTraits<LSHProjectionOptions>
{
    static const BuiltinOptions enum_value = BuiltinOptions_LSHProjectionOptions;
};

template<>
struct BuiltinOptionsTraits<Pool2DOptions>
{
    static const BuiltinOptions enum_value = BuiltinOptions_Pool2DOptions;
};

template<>
struct BuiltinOptionsTraits<SVDFOptions>
{
    static const BuiltinOptions enum_value = BuiltinOptions_SVDFOptions;
};

template<>
struct BuiltinOptionsTraits<RNNOptions>
{
    static const BuiltinOptions enum_value = BuiltinOptions_RNNOptions;
};

template<>
struct BuiltinOptionsTraits<FullyConnectedOptions>
{
    static const BuiltinOptions enum_value = BuiltinOptions_FullyConnectedOptions;
};

template<>
struct BuiltinOptionsTraits<SoftmaxOptions>
{
    static const BuiltinOptions enum_value = BuiltinOptions_SoftmaxOptions;
};

template<>
struct BuiltinOptionsTraits<ConcatenationOptions>
{
    static const BuiltinOptions enum_value = BuiltinOptions_ConcatenationOptions;
};

template<>
struct BuiltinOptionsTraits<AddOptions>
{
    static const BuiltinOptions enum_value = BuiltinOptions_AddOptions;
};

template<>
struct BuiltinOptionsTraits<L2NormOptions>
{
    static const BuiltinOptions enum_value = BuiltinOptions_L2NormOptions;
};

template<>
struct BuiltinOptionsTraits<LocalResponseNormalizationOptions>
{
    static const BuiltinOptions enum_value = BuiltinOptions_LocalResponseNormalizationOptions;
};

template<>
struct BuiltinOptionsTraits<LSTMOptions>
{
    static const BuiltinOptions enum_value = BuiltinOptions_LSTMOptions;
};

template<>
struct BuiltinOptionsTraits<ResizeBilinearOptions>
{
    static const BuiltinOptions enum_value = BuiltinOptions_ResizeBilinearOptions;
};

template<>
struct BuiltinOptionsTraits<CallOptions>
{
    static const BuiltinOptions enum_value = BuiltinOptions_CallOptions;
};

template<>
struct BuiltinOptionsTraits<ReshapeOptions>
{
    static const BuiltinOptions enum_value = BuiltinOptions_ReshapeOptions;
};

template<>
struct BuiltinOptionsTraits<SkipGramOptions>
{
    static const BuiltinOptions enum_value = BuiltinOptions_SkipGramOptions;
};

template<>
struct BuiltinOptionsTraits<SpaceToDepthOptions>
{
    static const BuiltinOptions enum_value = BuiltinOptions_SpaceToDepthOptions;
};

template<>
struct BuiltinOptionsTraits<EmbeddingLookupSparseOptions>
{
    static const BuiltinOptions enum_value = BuiltinOptions_EmbeddingLookupSparseOptions;
};

template<>
struct BuiltinOptionsTraits<MulOptions>
{
    static const BuiltinOptions enum_value = BuiltinOptions_MulOptions;
};

template<>
struct BuiltinOptionsTraits<PadOptions>
{
    static const BuiltinOptions enum_value = BuiltinOptions_PadOptions;
};

template<>
struct BuiltinOptionsTraits<GatherOptions>
{
    static const BuiltinOptions enum_value = BuiltinOptions_GatherOptions;
};

template<>
struct BuiltinOptionsTraits<BatchToSpaceNDOptions>
{
    static const BuiltinOptions enum_value = BuiltinOptions_BatchToSpaceNDOptions;
};

template<>
struct BuiltinOptionsTraits<SpaceToBatchNDOptions>
{
    static const BuiltinOptions enum_value = BuiltinOptions_SpaceToBatchNDOptions;
};

template<>
struct BuiltinOptionsTraits<TransposeOptions>
{
    static const BuiltinOptions enum_value = BuiltinOptions_TransposeOptions;
};

template<>
struct BuiltinOptionsTraits<ReducerOptions>
{
    static const BuiltinOptions enum_value = BuiltinOptions_ReducerOptions;
};

template<>
struct BuiltinOptionsTraits<SubOptions>
{
    static const BuiltinOptions enum_value = BuiltinOptions_SubOptions;
};

template<>
struct BuiltinOptionsTraits<DivOptions>
{
    static const BuiltinOptions enum_value = BuiltinOptions_DivOptions;
};

template<>
struct BuiltinOptionsTraits<SqueezeOptions>
{
    static const BuiltinOptions enum_value = BuiltinOptions_SqueezeOptions;
};

template<>
struct BuiltinOptionsTraits<SequenceRNNOptions>
{
    static const BuiltinOptions enum_value = BuiltinOptions_SequenceRNNOptions;
};

template<>
struct BuiltinOptionsTraits<StridedSliceOptions>
{
    static const BuiltinOptions enum_value = BuiltinOptions_StridedSliceOptions;
};

template<>
struct BuiltinOptionsTraits<ExpOptions>
{
    static const BuiltinOptions enum_value = BuiltinOptions_ExpOptions;
};

template<>
struct BuiltinOptionsTraits<TopKV2Options>
{
    static const BuiltinOptions enum_value = BuiltinOptions_TopKV2Options;
};

template<>
struct BuiltinOptionsTraits<SplitOptions>
{
    static const BuiltinOptions enum_value = BuiltinOptions_SplitOptions;
};

template<>
struct BuiltinOptionsTraits<LogSoftmaxOptions>
{
    static const BuiltinOptions enum_value = BuiltinOptions_LogSoftmaxOptions;
};

template<>
struct BuiltinOptionsTraits<CastOptions>
{
    static const BuiltinOptions enum_value = BuiltinOptions_CastOptions;
};

template<>
struct BuiltinOptionsTraits<DequantizeOptions>
{
    static const BuiltinOptions enum_value = BuiltinOptions_DequantizeOptions;
};

template<>
struct BuiltinOptionsTraits<MaximumMinimumOptions>
{
    static const BuiltinOptions enum_value = BuiltinOptions_MaximumMinimumOptions;
};

template<>
struct BuiltinOptionsTraits<ArgMaxOptions>
{
    static const BuiltinOptions enum_value = BuiltinOptions_ArgMaxOptions;
};

template<>
struct BuiltinOptionsTraits<LessOptions>
{
    static const BuiltinOptions enum_value = BuiltinOptions_LessOptions;
};

template<>
struct BuiltinOptionsTraits<NegOptions>
{
    static const BuiltinOptions enum_value = BuiltinOptions_NegOptions;
};

template<>
struct BuiltinOptionsTraits<PadV2Options>
{
    static const BuiltinOptions enum_value = BuiltinOptions_PadV2Options;
};

template<>
struct BuiltinOptionsTraits<GreaterOptions>
{
    static const BuiltinOptions enum_value = BuiltinOptions_GreaterOptions;
};

template<>
struct BuiltinOptionsTraits<GreaterEqualOptions>
{
    static const BuiltinOptions enum_value = BuiltinOptions_GreaterEqualOptions;
};

template<>
struct BuiltinOptionsTraits<LessEqualOptions>
{
    static const BuiltinOptions enum_value = BuiltinOptions_LessEqualOptions;
};

template<>
struct BuiltinOptionsTraits<SelectOptions>
{
    static const BuiltinOptions enum_value = BuiltinOptions_SelectOptions;
};

template<>
struct BuiltinOptionsTraits<SliceOptions>
{
    static const BuiltinOptions enum_value = BuiltinOptions_SliceOptions;
};

template<>
struct BuiltinOptionsTraits<TransposeConvOptions>
{
    static const BuiltinOptions enum_value = BuiltinOptions_TransposeConvOptions;
};

template<>
struct BuiltinOptionsTraits<SparseToDenseOptions>
{
    static const BuiltinOptions enum_value = BuiltinOptions_SparseToDenseOptions;
};

template<>
struct BuiltinOptionsTraits<TileOptions>
{
    static const BuiltinOptions enum_value = BuiltinOptions_TileOptions;
};

template<>
struct BuiltinOptionsTraits<ExpandDimsOptions>
{
    static const BuiltinOptions enum_value = BuiltinOptions_ExpandDimsOptions;
};

template<>
struct BuiltinOptionsTraits<EqualOptions>
{
    static const BuiltinOptions enum_value = BuiltinOptions_EqualOptions;
};

template<>
struct BuiltinOptionsTraits<NotEqualOptions>
{
    static const BuiltinOptions enum_value = BuiltinOptions_NotEqualOptions;
};

template<>
struct BuiltinOptionsTraits<ShapeOptions>
{
    static const BuiltinOptions enum_value = BuiltinOptions_ShapeOptions;
};

template<>
struct BuiltinOptionsTraits<PowOptions>
{
    static const BuiltinOptions enum_value = BuiltinOptions_PowOptions;
};

template<>
struct BuiltinOptionsTraits<ArgMinOptions>
{
    static const BuiltinOptions enum_value = BuiltinOptions_ArgMinOptions;
};

template<>
struct BuiltinOptionsTraits<FakeQuantOptions>
{
    static const BuiltinOptions enum_value = BuiltinOptions_FakeQuantOptions;
};

template<>
struct BuiltinOptionsTraits<PackOptions>
{
    static const BuiltinOptions enum_value = BuiltinOptions_PackOptions;
};

template<>
struct BuiltinOptionsTraits<LogicalOrOptions>
{
    static const BuiltinOptions enum_value = BuiltinOptions_LogicalOrOptions;
};

template<>
struct BuiltinOptionsTraits<OneHotOptions>
{
    static const BuiltinOptions enum_value = BuiltinOptions_OneHotOptions;
};

template<>
struct BuiltinOptionsTraits<LogicalAndOptions>
{
    static const BuiltinOptions enum_value = BuiltinOptions_LogicalAndOptions;
};

template<>
struct BuiltinOptionsTraits<LogicalNotOptions>
{
    static const BuiltinOptions enum_value = BuiltinOptions_LogicalNotOptions;
};

template<>
struct BuiltinOptionsTraits<UnpackOptions>
{
    static const BuiltinOptions enum_value = BuiltinOptions_UnpackOptions;
};

template<>
struct BuiltinOptionsTraits<FloorDivOptions>
{
    static const BuiltinOptions enum_value = BuiltinOptions_FloorDivOptions;
};

template<>
struct BuiltinOptionsTraits<SquareOptions>
{
    static const BuiltinOptions enum_value = BuiltinOptions_SquareOptions;
};

template<>
struct BuiltinOptionsTraits<ZerosLikeOptions>
{
    static const BuiltinOptions enum_value = BuiltinOptions_ZerosLikeOptions;
};

template<>
struct BuiltinOptionsTraits<FillOptions>
{
    static const BuiltinOptions enum_value = BuiltinOptions_FillOptions;
};

template<>
struct BuiltinOptionsTraits<BidirectionalSequenceLSTMOptions>
{
    static const BuiltinOptions enum_value = BuiltinOptions_BidirectionalSequenceLSTMOptions;
};

template<>
struct BuiltinOptionsTraits<BidirectionalSequenceRNNOptions>
{
    static const BuiltinOptions enum_value = BuiltinOptions_BidirectionalSequenceRNNOptions;
};

template<>
struct BuiltinOptionsTraits<UnidirectionalSequenceLSTMOptions>
{
    static const BuiltinOptions enum_value = BuiltinOptions_UnidirectionalSequenceLSTMOptions;
};

template<>
struct BuiltinOptionsTraits<FloorModOptions>
{
    static const BuiltinOptions enum_value = BuiltinOptions_FloorModOptions;
};

template<>
struct BuiltinOptionsTraits<RangeOptions>
{
    static const BuiltinOptions enum_value = BuiltinOptions_RangeOptions;
};

template<>
struct BuiltinOptionsTraits<ResizeNearestNeighborOptions>
{
    static const BuiltinOptions enum_value = BuiltinOptions_ResizeNearestNeighborOptions;
};

template<>
struct BuiltinOptionsTraits<LeakyReluOptions>
{
    static const BuiltinOptions enum_value = BuiltinOptions_LeakyReluOptions;
};

template<>
struct BuiltinOptionsTraits<SquaredDifferenceOptions>
{
    static const BuiltinOptions enum_value = BuiltinOptions_SquaredDifferenceOptions;
};

template<>
struct BuiltinOptionsTraits<MirrorPadOptions>
{
    static const BuiltinOptions enum_value = BuiltinOptions_MirrorPadOptions;
};

template<>
struct BuiltinOptionsTraits<AbsOptions>
{
    static const BuiltinOptions enum_value = BuiltinOptions_AbsOptions;
};

template<>
struct BuiltinOptionsTraits<SplitVOptions>
{
    static const BuiltinOptions enum_value = BuiltinOptions_SplitVOptions;
};

template<>
struct BuiltinOptionsTraits<UniqueOptions>
{
    static const BuiltinOptions enum_value = BuiltinOptions_UniqueOptions;
};

template<>
struct BuiltinOptionsTraits<ReverseV2Options>
{
    static const BuiltinOptions enum_value = BuiltinOptions_ReverseV2Options;
};

template<>
struct BuiltinOptionsTraits<AddNOptions>
{
    static const BuiltinOptions enum_value = BuiltinOptions_AddNOptions;
};

template<>
struct BuiltinOptionsTraits<GatherNdOptions>
{
    static const BuiltinOptions enum_value = BuiltinOptions_GatherNdOptions;
};

template<>
struct BuiltinOptionsTraits<CosOptions>
{
    static const BuiltinOptions enum_value = BuiltinOptions_CosOptions;
};

template<>
struct BuiltinOptionsTraits<WhereOptions>
{
    static const BuiltinOptions enum_value = BuiltinOptions_WhereOptions;
};

template<>
struct BuiltinOptionsTraits<RankOptions>
{
    static const BuiltinOptions enum_value = BuiltinOptions_RankOptions;
};

template<>
struct BuiltinOptionsTraits<ReverseSequenceOptions>
{
    static const BuiltinOptions enum_value = BuiltinOptions_ReverseSequenceOptions;
};

template<>
struct BuiltinOptionsTraits<MatrixDiagOptions>
{
    static const BuiltinOptions enum_value = BuiltinOptions_MatrixDiagOptions;
};

template<>
struct BuiltinOptionsTraits<QuantizeOptions>
{
    static const BuiltinOptions enum_value = BuiltinOptions_QuantizeOptions;
};

template<>
struct BuiltinOptionsTraits<MatrixSetDiagOptions>
{
    static const BuiltinOptions enum_value = BuiltinOptions_MatrixSetDiagOptions;
};

template<>
struct BuiltinOptionsTraits<HardSwishOptions>
{
    static const BuiltinOptions enum_value = BuiltinOptions_HardSwishOptions;
};

template<>
struct BuiltinOptionsTraits<IfOptions>
{
    static const BuiltinOptions enum_value = BuiltinOptions_IfOptions;
};

template<>
struct BuiltinOptionsTraits<WhileOptions>
{
    static const BuiltinOptions enum_value = BuiltinOptions_WhileOptions;
};

struct BuiltinOptionsUnion
{
    BuiltinOptions type;
    void* value;

    BuiltinOptionsUnion()
        : type(BuiltinOptions_NONE), value(nullptr)
    {
    }
    BuiltinOptionsUnion(BuiltinOptionsUnion&& u) FLATBUFFERS_NOEXCEPT : type(BuiltinOptions_NONE), value(nullptr)
    {
        std::swap(type, u.type);
        std::swap(value, u.value);
    }
    BuiltinOptionsUnion(const BuiltinOptionsUnion&) FLATBUFFERS_NOEXCEPT;
    BuiltinOptionsUnion& operator=(const BuiltinOptionsUnion& u) FLATBUFFERS_NOEXCEPT
    {
        BuiltinOptionsUnion t(u);
        std::swap(type, t.type);
        std::swap(value, t.value);
        return *this;
    }
    BuiltinOptionsUnion& operator=(BuiltinOptionsUnion&& u) FLATBUFFERS_NOEXCEPT
    {
        std::swap(type, u.type);
        std::swap(value, u.value);
        return *this;
    }
    ~BuiltinOptionsUnion()
    {
        Reset();
    }

    void Reset();

#ifndef FLATBUFFERS_CPP98_STL
    template<typename T>
    void Set(T&& val)
    {
        using RT = typename std::remove_reference<T>::type;
        Reset();
        type = BuiltinOptionsTraits<typename RT::TableType>::enum_value;
        if (type != BuiltinOptions_NONE)
        {
            value = new RT(std::forward<T>(val));
        }
    }
#endif // FLATBUFFERS_CPP98_STL

    static void* UnPack(const void* obj, BuiltinOptions type, const flatbuffers::resolver_function_t* resolver);
    flatbuffers::Offset<void> Pack(flatbuffers::FlatBufferBuilder& _fbb, const flatbuffers::rehasher_function_t* _rehasher = nullptr) const;

    Conv2DOptionsT* AsConv2DOptions()
    {
        return type == BuiltinOptions_Conv2DOptions ? reinterpret_cast<Conv2DOptionsT*>(value) : nullptr;
    }
    const Conv2DOptionsT* AsConv2DOptions() const
    {
        return type == BuiltinOptions_Conv2DOptions ? reinterpret_cast<const Conv2DOptionsT*>(value) : nullptr;
    }
    DepthwiseConv2DOptionsT* AsDepthwiseConv2DOptions()
    {
        return type == BuiltinOptions_DepthwiseConv2DOptions ? reinterpret_cast<DepthwiseConv2DOptionsT*>(value) : nullptr;
    }
    const DepthwiseConv2DOptionsT* AsDepthwiseConv2DOptions() const
    {
        return type == BuiltinOptions_DepthwiseConv2DOptions ? reinterpret_cast<const DepthwiseConv2DOptionsT*>(value) : nullptr;
    }
    ConcatEmbeddingsOptionsT* AsConcatEmbeddingsOptions()
    {
        return type == BuiltinOptions_ConcatEmbeddingsOptions ? reinterpret_cast<ConcatEmbeddingsOptionsT*>(value) : nullptr;
    }
    const ConcatEmbeddingsOptionsT* AsConcatEmbeddingsOptions() const
    {
        return type == BuiltinOptions_ConcatEmbeddingsOptions ? reinterpret_cast<const ConcatEmbeddingsOptionsT*>(value) : nullptr;
    }
    LSHProjectionOptionsT* AsLSHProjectionOptions()
    {
        return type == BuiltinOptions_LSHProjectionOptions ? reinterpret_cast<LSHProjectionOptionsT*>(value) : nullptr;
    }
    const LSHProjectionOptionsT* AsLSHProjectionOptions() const
    {
        return type == BuiltinOptions_LSHProjectionOptions ? reinterpret_cast<const LSHProjectionOptionsT*>(value) : nullptr;
    }
    Pool2DOptionsT* AsPool2DOptions()
    {
        return type == BuiltinOptions_Pool2DOptions ? reinterpret_cast<Pool2DOptionsT*>(value) : nullptr;
    }
    const Pool2DOptionsT* AsPool2DOptions() const
    {
        return type == BuiltinOptions_Pool2DOptions ? reinterpret_cast<const Pool2DOptionsT*>(value) : nullptr;
    }
    SVDFOptionsT* AsSVDFOptions()
    {
        return type == BuiltinOptions_SVDFOptions ? reinterpret_cast<SVDFOptionsT*>(value) : nullptr;
    }
    const SVDFOptionsT* AsSVDFOptions() const
    {
        return type == BuiltinOptions_SVDFOptions ? reinterpret_cast<const SVDFOptionsT*>(value) : nullptr;
    }
    RNNOptionsT* AsRNNOptions()
    {
        return type == BuiltinOptions_RNNOptions ? reinterpret_cast<RNNOptionsT*>(value) : nullptr;
    }
    const RNNOptionsT* AsRNNOptions() const
    {
        return type == BuiltinOptions_RNNOptions ? reinterpret_cast<const RNNOptionsT*>(value) : nullptr;
    }
    FullyConnectedOptionsT* AsFullyConnectedOptions()
    {
        return type == BuiltinOptions_FullyConnectedOptions ? reinterpret_cast<FullyConnectedOptionsT*>(value) : nullptr;
    }
    const FullyConnectedOptionsT* AsFullyConnectedOptions() const
    {
        return type == BuiltinOptions_FullyConnectedOptions ? reinterpret_cast<const FullyConnectedOptionsT*>(value) : nullptr;
    }
    SoftmaxOptionsT* AsSoftmaxOptions()
    {
        return type == BuiltinOptions_SoftmaxOptions ? reinterpret_cast<SoftmaxOptionsT*>(value) : nullptr;
    }
    const SoftmaxOptionsT* AsSoftmaxOptions() const
    {
        return type == BuiltinOptions_SoftmaxOptions ? reinterpret_cast<const SoftmaxOptionsT*>(value) : nullptr;
    }
    ConcatenationOptionsT* AsConcatenationOptions()
    {
        return type == BuiltinOptions_ConcatenationOptions ? reinterpret_cast<ConcatenationOptionsT*>(value) : nullptr;
    }
    const ConcatenationOptionsT* AsConcatenationOptions() const
    {
        return type == BuiltinOptions_ConcatenationOptions ? reinterpret_cast<const ConcatenationOptionsT*>(value) : nullptr;
    }
    AddOptionsT* AsAddOptions()
    {
        return type == BuiltinOptions_AddOptions ? reinterpret_cast<AddOptionsT*>(value) : nullptr;
    }
    const AddOptionsT* AsAddOptions() const
    {
        return type == BuiltinOptions_AddOptions ? reinterpret_cast<const AddOptionsT*>(value) : nullptr;
    }
    L2NormOptionsT* AsL2NormOptions()
    {
        return type == BuiltinOptions_L2NormOptions ? reinterpret_cast<L2NormOptionsT*>(value) : nullptr;
    }
    const L2NormOptionsT* AsL2NormOptions() const
    {
        return type == BuiltinOptions_L2NormOptions ? reinterpret_cast<const L2NormOptionsT*>(value) : nullptr;
    }
    LocalResponseNormalizationOptionsT* AsLocalResponseNormalizationOptions()
    {
        return type == BuiltinOptions_LocalResponseNormalizationOptions ? reinterpret_cast<LocalResponseNormalizationOptionsT*>(value) : nullptr;
    }
    const LocalResponseNormalizationOptionsT* AsLocalResponseNormalizationOptions() const
    {
        return type == BuiltinOptions_LocalResponseNormalizationOptions ? reinterpret_cast<const LocalResponseNormalizationOptionsT*>(value) : nullptr;
    }
    LSTMOptionsT* AsLSTMOptions()
    {
        return type == BuiltinOptions_LSTMOptions ? reinterpret_cast<LSTMOptionsT*>(value) : nullptr;
    }
    const LSTMOptionsT* AsLSTMOptions() const
    {
        return type == BuiltinOptions_LSTMOptions ? reinterpret_cast<const LSTMOptionsT*>(value) : nullptr;
    }
    ResizeBilinearOptionsT* AsResizeBilinearOptions()
    {
        return type == BuiltinOptions_ResizeBilinearOptions ? reinterpret_cast<ResizeBilinearOptionsT*>(value) : nullptr;
    }
    const ResizeBilinearOptionsT* AsResizeBilinearOptions() const
    {
        return type == BuiltinOptions_ResizeBilinearOptions ? reinterpret_cast<const ResizeBilinearOptionsT*>(value) : nullptr;
    }
    CallOptionsT* AsCallOptions()
    {
        return type == BuiltinOptions_CallOptions ? reinterpret_cast<CallOptionsT*>(value) : nullptr;
    }
    const CallOptionsT* AsCallOptions() const
    {
        return type == BuiltinOptions_CallOptions ? reinterpret_cast<const CallOptionsT*>(value) : nullptr;
    }
    ReshapeOptionsT* AsReshapeOptions()
    {
        return type == BuiltinOptions_ReshapeOptions ? reinterpret_cast<ReshapeOptionsT*>(value) : nullptr;
    }
    const ReshapeOptionsT* AsReshapeOptions() const
    {
        return type == BuiltinOptions_ReshapeOptions ? reinterpret_cast<const ReshapeOptionsT*>(value) : nullptr;
    }
    SkipGramOptionsT* AsSkipGramOptions()
    {
        return type == BuiltinOptions_SkipGramOptions ? reinterpret_cast<SkipGramOptionsT*>(value) : nullptr;
    }
    const SkipGramOptionsT* AsSkipGramOptions() const
    {
        return type == BuiltinOptions_SkipGramOptions ? reinterpret_cast<const SkipGramOptionsT*>(value) : nullptr;
    }
    SpaceToDepthOptionsT* AsSpaceToDepthOptions()
    {
        return type == BuiltinOptions_SpaceToDepthOptions ? reinterpret_cast<SpaceToDepthOptionsT*>(value) : nullptr;
    }
    const SpaceToDepthOptionsT* AsSpaceToDepthOptions() const
    {
        return type == BuiltinOptions_SpaceToDepthOptions ? reinterpret_cast<const SpaceToDepthOptionsT*>(value) : nullptr;
    }
    EmbeddingLookupSparseOptionsT* AsEmbeddingLookupSparseOptions()
    {
        return type == BuiltinOptions_EmbeddingLookupSparseOptions ? reinterpret_cast<EmbeddingLookupSparseOptionsT*>(value) : nullptr;
    }
    const EmbeddingLookupSparseOptionsT* AsEmbeddingLookupSparseOptions() const
    {
        return type == BuiltinOptions_EmbeddingLookupSparseOptions ? reinterpret_cast<const EmbeddingLookupSparseOptionsT*>(value) : nullptr;
    }
    MulOptionsT* AsMulOptions()
    {
        return type == BuiltinOptions_MulOptions ? reinterpret_cast<MulOptionsT*>(value) : nullptr;
    }
    const MulOptionsT* AsMulOptions() const
    {
        return type == BuiltinOptions_MulOptions ? reinterpret_cast<const MulOptionsT*>(value) : nullptr;
    }
    PadOptionsT* AsPadOptions()
    {
        return type == BuiltinOptions_PadOptions ? reinterpret_cast<PadOptionsT*>(value) : nullptr;
    }
    const PadOptionsT* AsPadOptions() const
    {
        return type == BuiltinOptions_PadOptions ? reinterpret_cast<const PadOptionsT*>(value) : nullptr;
    }
    GatherOptionsT* AsGatherOptions()
    {
        return type == BuiltinOptions_GatherOptions ? reinterpret_cast<GatherOptionsT*>(value) : nullptr;
    }
    const GatherOptionsT* AsGatherOptions() const
    {
        return type == BuiltinOptions_GatherOptions ? reinterpret_cast<const GatherOptionsT*>(value) : nullptr;
    }
    BatchToSpaceNDOptionsT* AsBatchToSpaceNDOptions()
    {
        return type == BuiltinOptions_BatchToSpaceNDOptions ? reinterpret_cast<BatchToSpaceNDOptionsT*>(value) : nullptr;
    }
    const BatchToSpaceNDOptionsT* AsBatchToSpaceNDOptions() const
    {
        return type == BuiltinOptions_BatchToSpaceNDOptions ? reinterpret_cast<const BatchToSpaceNDOptionsT*>(value) : nullptr;
    }
    SpaceToBatchNDOptionsT* AsSpaceToBatchNDOptions()
    {
        return type == BuiltinOptions_SpaceToBatchNDOptions ? reinterpret_cast<SpaceToBatchNDOptionsT*>(value) : nullptr;
    }
    const SpaceToBatchNDOptionsT* AsSpaceToBatchNDOptions() const
    {
        return type == BuiltinOptions_SpaceToBatchNDOptions ? reinterpret_cast<const SpaceToBatchNDOptionsT*>(value) : nullptr;
    }
    TransposeOptionsT* AsTransposeOptions()
    {
        return type == BuiltinOptions_TransposeOptions ? reinterpret_cast<TransposeOptionsT*>(value) : nullptr;
    }
    const TransposeOptionsT* AsTransposeOptions() const
    {
        return type == BuiltinOptions_TransposeOptions ? reinterpret_cast<const TransposeOptionsT*>(value) : nullptr;
    }
    ReducerOptionsT* AsReducerOptions()
    {
        return type == BuiltinOptions_ReducerOptions ? reinterpret_cast<ReducerOptionsT*>(value) : nullptr;
    }
    const ReducerOptionsT* AsReducerOptions() const
    {
        return type == BuiltinOptions_ReducerOptions ? reinterpret_cast<const ReducerOptionsT*>(value) : nullptr;
    }
    SubOptionsT* AsSubOptions()
    {
        return type == BuiltinOptions_SubOptions ? reinterpret_cast<SubOptionsT*>(value) : nullptr;
    }
    const SubOptionsT* AsSubOptions() const
    {
        return type == BuiltinOptions_SubOptions ? reinterpret_cast<const SubOptionsT*>(value) : nullptr;
    }
    DivOptionsT* AsDivOptions()
    {
        return type == BuiltinOptions_DivOptions ? reinterpret_cast<DivOptionsT*>(value) : nullptr;
    }
    const DivOptionsT* AsDivOptions() const
    {
        return type == BuiltinOptions_DivOptions ? reinterpret_cast<const DivOptionsT*>(value) : nullptr;
    }
    SqueezeOptionsT* AsSqueezeOptions()
    {
        return type == BuiltinOptions_SqueezeOptions ? reinterpret_cast<SqueezeOptionsT*>(value) : nullptr;
    }
    const SqueezeOptionsT* AsSqueezeOptions() const
    {
        return type == BuiltinOptions_SqueezeOptions ? reinterpret_cast<const SqueezeOptionsT*>(value) : nullptr;
    }
    SequenceRNNOptionsT* AsSequenceRNNOptions()
    {
        return type == BuiltinOptions_SequenceRNNOptions ? reinterpret_cast<SequenceRNNOptionsT*>(value) : nullptr;
    }
    const SequenceRNNOptionsT* AsSequenceRNNOptions() const
    {
        return type == BuiltinOptions_SequenceRNNOptions ? reinterpret_cast<const SequenceRNNOptionsT*>(value) : nullptr;
    }
    StridedSliceOptionsT* AsStridedSliceOptions()
    {
        return type == BuiltinOptions_StridedSliceOptions ? reinterpret_cast<StridedSliceOptionsT*>(value) : nullptr;
    }
    const StridedSliceOptionsT* AsStridedSliceOptions() const
    {
        return type == BuiltinOptions_StridedSliceOptions ? reinterpret_cast<const StridedSliceOptionsT*>(value) : nullptr;
    }
    ExpOptionsT* AsExpOptions()
    {
        return type == BuiltinOptions_ExpOptions ? reinterpret_cast<ExpOptionsT*>(value) : nullptr;
    }
    const ExpOptionsT* AsExpOptions() const
    {
        return type == BuiltinOptions_ExpOptions ? reinterpret_cast<const ExpOptionsT*>(value) : nullptr;
    }
    TopKV2OptionsT* AsTopKV2Options()
    {
        return type == BuiltinOptions_TopKV2Options ? reinterpret_cast<TopKV2OptionsT*>(value) : nullptr;
    }
    const TopKV2OptionsT* AsTopKV2Options() const
    {
        return type == BuiltinOptions_TopKV2Options ? reinterpret_cast<const TopKV2OptionsT*>(value) : nullptr;
    }
    SplitOptionsT* AsSplitOptions()
    {
        return type == BuiltinOptions_SplitOptions ? reinterpret_cast<SplitOptionsT*>(value) : nullptr;
    }
    const SplitOptionsT* AsSplitOptions() const
    {
        return type == BuiltinOptions_SplitOptions ? reinterpret_cast<const SplitOptionsT*>(value) : nullptr;
    }
    LogSoftmaxOptionsT* AsLogSoftmaxOptions()
    {
        return type == BuiltinOptions_LogSoftmaxOptions ? reinterpret_cast<LogSoftmaxOptionsT*>(value) : nullptr;
    }
    const LogSoftmaxOptionsT* AsLogSoftmaxOptions() const
    {
        return type == BuiltinOptions_LogSoftmaxOptions ? reinterpret_cast<const LogSoftmaxOptionsT*>(value) : nullptr;
    }
    CastOptionsT* AsCastOptions()
    {
        return type == BuiltinOptions_CastOptions ? reinterpret_cast<CastOptionsT*>(value) : nullptr;
    }
    const CastOptionsT* AsCastOptions() const
    {
        return type == BuiltinOptions_CastOptions ? reinterpret_cast<const CastOptionsT*>(value) : nullptr;
    }
    DequantizeOptionsT* AsDequantizeOptions()
    {
        return type == BuiltinOptions_DequantizeOptions ? reinterpret_cast<DequantizeOptionsT*>(value) : nullptr;
    }
    const DequantizeOptionsT* AsDequantizeOptions() const
    {
        return type == BuiltinOptions_DequantizeOptions ? reinterpret_cast<const DequantizeOptionsT*>(value) : nullptr;
    }
    MaximumMinimumOptionsT* AsMaximumMinimumOptions()
    {
        return type == BuiltinOptions_MaximumMinimumOptions ? reinterpret_cast<MaximumMinimumOptionsT*>(value) : nullptr;
    }
    const MaximumMinimumOptionsT* AsMaximumMinimumOptions() const
    {
        return type == BuiltinOptions_MaximumMinimumOptions ? reinterpret_cast<const MaximumMinimumOptionsT*>(value) : nullptr;
    }
    ArgMaxOptionsT* AsArgMaxOptions()
    {
        return type == BuiltinOptions_ArgMaxOptions ? reinterpret_cast<ArgMaxOptionsT*>(value) : nullptr;
    }
    const ArgMaxOptionsT* AsArgMaxOptions() const
    {
        return type == BuiltinOptions_ArgMaxOptions ? reinterpret_cast<const ArgMaxOptionsT*>(value) : nullptr;
    }
    LessOptionsT* AsLessOptions()
    {
        return type == BuiltinOptions_LessOptions ? reinterpret_cast<LessOptionsT*>(value) : nullptr;
    }
    const LessOptionsT* AsLessOptions() const
    {
        return type == BuiltinOptions_LessOptions ? reinterpret_cast<const LessOptionsT*>(value) : nullptr;
    }
    NegOptionsT* AsNegOptions()
    {
        return type == BuiltinOptions_NegOptions ? reinterpret_cast<NegOptionsT*>(value) : nullptr;
    }
    const NegOptionsT* AsNegOptions() const
    {
        return type == BuiltinOptions_NegOptions ? reinterpret_cast<const NegOptionsT*>(value) : nullptr;
    }
    PadV2OptionsT* AsPadV2Options()
    {
        return type == BuiltinOptions_PadV2Options ? reinterpret_cast<PadV2OptionsT*>(value) : nullptr;
    }
    const PadV2OptionsT* AsPadV2Options() const
    {
        return type == BuiltinOptions_PadV2Options ? reinterpret_cast<const PadV2OptionsT*>(value) : nullptr;
    }
    GreaterOptionsT* AsGreaterOptions()
    {
        return type == BuiltinOptions_GreaterOptions ? reinterpret_cast<GreaterOptionsT*>(value) : nullptr;
    }
    const GreaterOptionsT* AsGreaterOptions() const
    {
        return type == BuiltinOptions_GreaterOptions ? reinterpret_cast<const GreaterOptionsT*>(value) : nullptr;
    }
    GreaterEqualOptionsT* AsGreaterEqualOptions()
    {
        return type == BuiltinOptions_GreaterEqualOptions ? reinterpret_cast<GreaterEqualOptionsT*>(value) : nullptr;
    }
    const GreaterEqualOptionsT* AsGreaterEqualOptions() const
    {
        return type == BuiltinOptions_GreaterEqualOptions ? reinterpret_cast<const GreaterEqualOptionsT*>(value) : nullptr;
    }
    LessEqualOptionsT* AsLessEqualOptions()
    {
        return type == BuiltinOptions_LessEqualOptions ? reinterpret_cast<LessEqualOptionsT*>(value) : nullptr;
    }
    const LessEqualOptionsT* AsLessEqualOptions() const
    {
        return type == BuiltinOptions_LessEqualOptions ? reinterpret_cast<const LessEqualOptionsT*>(value) : nullptr;
    }
    SelectOptionsT* AsSelectOptions()
    {
        return type == BuiltinOptions_SelectOptions ? reinterpret_cast<SelectOptionsT*>(value) : nullptr;
    }
    const SelectOptionsT* AsSelectOptions() const
    {
        return type == BuiltinOptions_SelectOptions ? reinterpret_cast<const SelectOptionsT*>(value) : nullptr;
    }
    SliceOptionsT* AsSliceOptions()
    {
        return type == BuiltinOptions_SliceOptions ? reinterpret_cast<SliceOptionsT*>(value) : nullptr;
    }
    const SliceOptionsT* AsSliceOptions() const
    {
        return type == BuiltinOptions_SliceOptions ? reinterpret_cast<const SliceOptionsT*>(value) : nullptr;
    }
    TransposeConvOptionsT* AsTransposeConvOptions()
    {
        return type == BuiltinOptions_TransposeConvOptions ? reinterpret_cast<TransposeConvOptionsT*>(value) : nullptr;
    }
    const TransposeConvOptionsT* AsTransposeConvOptions() const
    {
        return type == BuiltinOptions_TransposeConvOptions ? reinterpret_cast<const TransposeConvOptionsT*>(value) : nullptr;
    }
    SparseToDenseOptionsT* AsSparseToDenseOptions()
    {
        return type == BuiltinOptions_SparseToDenseOptions ? reinterpret_cast<SparseToDenseOptionsT*>(value) : nullptr;
    }
    const SparseToDenseOptionsT* AsSparseToDenseOptions() const
    {
        return type == BuiltinOptions_SparseToDenseOptions ? reinterpret_cast<const SparseToDenseOptionsT*>(value) : nullptr;
    }
    TileOptionsT* AsTileOptions()
    {
        return type == BuiltinOptions_TileOptions ? reinterpret_cast<TileOptionsT*>(value) : nullptr;
    }
    const TileOptionsT* AsTileOptions() const
    {
        return type == BuiltinOptions_TileOptions ? reinterpret_cast<const TileOptionsT*>(value) : nullptr;
    }
    ExpandDimsOptionsT* AsExpandDimsOptions()
    {
        return type == BuiltinOptions_ExpandDimsOptions ? reinterpret_cast<ExpandDimsOptionsT*>(value) : nullptr;
    }
    const ExpandDimsOptionsT* AsExpandDimsOptions() const
    {
        return type == BuiltinOptions_ExpandDimsOptions ? reinterpret_cast<const ExpandDimsOptionsT*>(value) : nullptr;
    }
    EqualOptionsT* AsEqualOptions()
    {
        return type == BuiltinOptions_EqualOptions ? reinterpret_cast<EqualOptionsT*>(value) : nullptr;
    }
    const EqualOptionsT* AsEqualOptions() const
    {
        return type == BuiltinOptions_EqualOptions ? reinterpret_cast<const EqualOptionsT*>(value) : nullptr;
    }
    NotEqualOptionsT* AsNotEqualOptions()
    {
        return type == BuiltinOptions_NotEqualOptions ? reinterpret_cast<NotEqualOptionsT*>(value) : nullptr;
    }
    const NotEqualOptionsT* AsNotEqualOptions() const
    {
        return type == BuiltinOptions_NotEqualOptions ? reinterpret_cast<const NotEqualOptionsT*>(value) : nullptr;
    }
    ShapeOptionsT* AsShapeOptions()
    {
        return type == BuiltinOptions_ShapeOptions ? reinterpret_cast<ShapeOptionsT*>(value) : nullptr;
    }
    const ShapeOptionsT* AsShapeOptions() const
    {
        return type == BuiltinOptions_ShapeOptions ? reinterpret_cast<const ShapeOptionsT*>(value) : nullptr;
    }
    PowOptionsT* AsPowOptions()
    {
        return type == BuiltinOptions_PowOptions ? reinterpret_cast<PowOptionsT*>(value) : nullptr;
    }
    const PowOptionsT* AsPowOptions() const
    {
        return type == BuiltinOptions_PowOptions ? reinterpret_cast<const PowOptionsT*>(value) : nullptr;
    }
    ArgMinOptionsT* AsArgMinOptions()
    {
        return type == BuiltinOptions_ArgMinOptions ? reinterpret_cast<ArgMinOptionsT*>(value) : nullptr;
    }
    const ArgMinOptionsT* AsArgMinOptions() const
    {
        return type == BuiltinOptions_ArgMinOptions ? reinterpret_cast<const ArgMinOptionsT*>(value) : nullptr;
    }
    FakeQuantOptionsT* AsFakeQuantOptions()
    {
        return type == BuiltinOptions_FakeQuantOptions ? reinterpret_cast<FakeQuantOptionsT*>(value) : nullptr;
    }
    const FakeQuantOptionsT* AsFakeQuantOptions() const
    {
        return type == BuiltinOptions_FakeQuantOptions ? reinterpret_cast<const FakeQuantOptionsT*>(value) : nullptr;
    }
    PackOptionsT* AsPackOptions()
    {
        return type == BuiltinOptions_PackOptions ? reinterpret_cast<PackOptionsT*>(value) : nullptr;
    }
    const PackOptionsT* AsPackOptions() const
    {
        return type == BuiltinOptions_PackOptions ? reinterpret_cast<const PackOptionsT*>(value) : nullptr;
    }
    LogicalOrOptionsT* AsLogicalOrOptions()
    {
        return type == BuiltinOptions_LogicalOrOptions ? reinterpret_cast<LogicalOrOptionsT*>(value) : nullptr;
    }
    const LogicalOrOptionsT* AsLogicalOrOptions() const
    {
        return type == BuiltinOptions_LogicalOrOptions ? reinterpret_cast<const LogicalOrOptionsT*>(value) : nullptr;
    }
    OneHotOptionsT* AsOneHotOptions()
    {
        return type == BuiltinOptions_OneHotOptions ? reinterpret_cast<OneHotOptionsT*>(value) : nullptr;
    }
    const OneHotOptionsT* AsOneHotOptions() const
    {
        return type == BuiltinOptions_OneHotOptions ? reinterpret_cast<const OneHotOptionsT*>(value) : nullptr;
    }
    LogicalAndOptionsT* AsLogicalAndOptions()
    {
        return type == BuiltinOptions_LogicalAndOptions ? reinterpret_cast<LogicalAndOptionsT*>(value) : nullptr;
    }
    const LogicalAndOptionsT* AsLogicalAndOptions() const
    {
        return type == BuiltinOptions_LogicalAndOptions ? reinterpret_cast<const LogicalAndOptionsT*>(value) : nullptr;
    }
    LogicalNotOptionsT* AsLogicalNotOptions()
    {
        return type == BuiltinOptions_LogicalNotOptions ? reinterpret_cast<LogicalNotOptionsT*>(value) : nullptr;
    }
    const LogicalNotOptionsT* AsLogicalNotOptions() const
    {
        return type == BuiltinOptions_LogicalNotOptions ? reinterpret_cast<const LogicalNotOptionsT*>(value) : nullptr;
    }
    UnpackOptionsT* AsUnpackOptions()
    {
        return type == BuiltinOptions_UnpackOptions ? reinterpret_cast<UnpackOptionsT*>(value) : nullptr;
    }
    const UnpackOptionsT* AsUnpackOptions() const
    {
        return type == BuiltinOptions_UnpackOptions ? reinterpret_cast<const UnpackOptionsT*>(value) : nullptr;
    }
    FloorDivOptionsT* AsFloorDivOptions()
    {
        return type == BuiltinOptions_FloorDivOptions ? reinterpret_cast<FloorDivOptionsT*>(value) : nullptr;
    }
    const FloorDivOptionsT* AsFloorDivOptions() const
    {
        return type == BuiltinOptions_FloorDivOptions ? reinterpret_cast<const FloorDivOptionsT*>(value) : nullptr;
    }
    SquareOptionsT* AsSquareOptions()
    {
        return type == BuiltinOptions_SquareOptions ? reinterpret_cast<SquareOptionsT*>(value) : nullptr;
    }
    const SquareOptionsT* AsSquareOptions() const
    {
        return type == BuiltinOptions_SquareOptions ? reinterpret_cast<const SquareOptionsT*>(value) : nullptr;
    }
    ZerosLikeOptionsT* AsZerosLikeOptions()
    {
        return type == BuiltinOptions_ZerosLikeOptions ? reinterpret_cast<ZerosLikeOptionsT*>(value) : nullptr;
    }
    const ZerosLikeOptionsT* AsZerosLikeOptions() const
    {
        return type == BuiltinOptions_ZerosLikeOptions ? reinterpret_cast<const ZerosLikeOptionsT*>(value) : nullptr;
    }
    FillOptionsT* AsFillOptions()
    {
        return type == BuiltinOptions_FillOptions ? reinterpret_cast<FillOptionsT*>(value) : nullptr;
    }
    const FillOptionsT* AsFillOptions() const
    {
        return type == BuiltinOptions_FillOptions ? reinterpret_cast<const FillOptionsT*>(value) : nullptr;
    }
    BidirectionalSequenceLSTMOptionsT* AsBidirectionalSequenceLSTMOptions()
    {
        return type == BuiltinOptions_BidirectionalSequenceLSTMOptions ? reinterpret_cast<BidirectionalSequenceLSTMOptionsT*>(value) : nullptr;
    }
    const BidirectionalSequenceLSTMOptionsT* AsBidirectionalSequenceLSTMOptions() const
    {
        return type == BuiltinOptions_BidirectionalSequenceLSTMOptions ? reinterpret_cast<const BidirectionalSequenceLSTMOptionsT*>(value) : nullptr;
    }
    BidirectionalSequenceRNNOptionsT* AsBidirectionalSequenceRNNOptions()
    {
        return type == BuiltinOptions_BidirectionalSequenceRNNOptions ? reinterpret_cast<BidirectionalSequenceRNNOptionsT*>(value) : nullptr;
    }
    const BidirectionalSequenceRNNOptionsT* AsBidirectionalSequenceRNNOptions() const
    {
        return type == BuiltinOptions_BidirectionalSequenceRNNOptions ? reinterpret_cast<const BidirectionalSequenceRNNOptionsT*>(value) : nullptr;
    }
    UnidirectionalSequenceLSTMOptionsT* AsUnidirectionalSequenceLSTMOptions()
    {
        return type == BuiltinOptions_UnidirectionalSequenceLSTMOptions ? reinterpret_cast<UnidirectionalSequenceLSTMOptionsT*>(value) : nullptr;
    }
    const UnidirectionalSequenceLSTMOptionsT* AsUnidirectionalSequenceLSTMOptions() const
    {
        return type == BuiltinOptions_UnidirectionalSequenceLSTMOptions ? reinterpret_cast<const UnidirectionalSequenceLSTMOptionsT*>(value) : nullptr;
    }
    FloorModOptionsT* AsFloorModOptions()
    {
        return type == BuiltinOptions_FloorModOptions ? reinterpret_cast<FloorModOptionsT*>(value) : nullptr;
    }
    const FloorModOptionsT* AsFloorModOptions() const
    {
        return type == BuiltinOptions_FloorModOptions ? reinterpret_cast<const FloorModOptionsT*>(value) : nullptr;
    }
    RangeOptionsT* AsRangeOptions()
    {
        return type == BuiltinOptions_RangeOptions ? reinterpret_cast<RangeOptionsT*>(value) : nullptr;
    }
    const RangeOptionsT* AsRangeOptions() const
    {
        return type == BuiltinOptions_RangeOptions ? reinterpret_cast<const RangeOptionsT*>(value) : nullptr;
    }
    ResizeNearestNeighborOptionsT* AsResizeNearestNeighborOptions()
    {
        return type == BuiltinOptions_ResizeNearestNeighborOptions ? reinterpret_cast<ResizeNearestNeighborOptionsT*>(value) : nullptr;
    }
    const ResizeNearestNeighborOptionsT* AsResizeNearestNeighborOptions() const
    {
        return type == BuiltinOptions_ResizeNearestNeighborOptions ? reinterpret_cast<const ResizeNearestNeighborOptionsT*>(value) : nullptr;
    }
    LeakyReluOptionsT* AsLeakyReluOptions()
    {
        return type == BuiltinOptions_LeakyReluOptions ? reinterpret_cast<LeakyReluOptionsT*>(value) : nullptr;
    }
    const LeakyReluOptionsT* AsLeakyReluOptions() const
    {
        return type == BuiltinOptions_LeakyReluOptions ? reinterpret_cast<const LeakyReluOptionsT*>(value) : nullptr;
    }
    SquaredDifferenceOptionsT* AsSquaredDifferenceOptions()
    {
        return type == BuiltinOptions_SquaredDifferenceOptions ? reinterpret_cast<SquaredDifferenceOptionsT*>(value) : nullptr;
    }
    const SquaredDifferenceOptionsT* AsSquaredDifferenceOptions() const
    {
        return type == BuiltinOptions_SquaredDifferenceOptions ? reinterpret_cast<const SquaredDifferenceOptionsT*>(value) : nullptr;
    }
    MirrorPadOptionsT* AsMirrorPadOptions()
    {
        return type == BuiltinOptions_MirrorPadOptions ? reinterpret_cast<MirrorPadOptionsT*>(value) : nullptr;
    }
    const MirrorPadOptionsT* AsMirrorPadOptions() const
    {
        return type == BuiltinOptions_MirrorPadOptions ? reinterpret_cast<const MirrorPadOptionsT*>(value) : nullptr;
    }
    AbsOptionsT* AsAbsOptions()
    {
        return type == BuiltinOptions_AbsOptions ? reinterpret_cast<AbsOptionsT*>(value) : nullptr;
    }
    const AbsOptionsT* AsAbsOptions() const
    {
        return type == BuiltinOptions_AbsOptions ? reinterpret_cast<const AbsOptionsT*>(value) : nullptr;
    }
    SplitVOptionsT* AsSplitVOptions()
    {
        return type == BuiltinOptions_SplitVOptions ? reinterpret_cast<SplitVOptionsT*>(value) : nullptr;
    }
    const SplitVOptionsT* AsSplitVOptions() const
    {
        return type == BuiltinOptions_SplitVOptions ? reinterpret_cast<const SplitVOptionsT*>(value) : nullptr;
    }
    UniqueOptionsT* AsUniqueOptions()
    {
        return type == BuiltinOptions_UniqueOptions ? reinterpret_cast<UniqueOptionsT*>(value) : nullptr;
    }
    const UniqueOptionsT* AsUniqueOptions() const
    {
        return type == BuiltinOptions_UniqueOptions ? reinterpret_cast<const UniqueOptionsT*>(value) : nullptr;
    }
    ReverseV2OptionsT* AsReverseV2Options()
    {
        return type == BuiltinOptions_ReverseV2Options ? reinterpret_cast<ReverseV2OptionsT*>(value) : nullptr;
    }
    const ReverseV2OptionsT* AsReverseV2Options() const
    {
        return type == BuiltinOptions_ReverseV2Options ? reinterpret_cast<const ReverseV2OptionsT*>(value) : nullptr;
    }
    AddNOptionsT* AsAddNOptions()
    {
        return type == BuiltinOptions_AddNOptions ? reinterpret_cast<AddNOptionsT*>(value) : nullptr;
    }
    const AddNOptionsT* AsAddNOptions() const
    {
        return type == BuiltinOptions_AddNOptions ? reinterpret_cast<const AddNOptionsT*>(value) : nullptr;
    }
    GatherNdOptionsT* AsGatherNdOptions()
    {
        return type == BuiltinOptions_GatherNdOptions ? reinterpret_cast<GatherNdOptionsT*>(value) : nullptr;
    }
    const GatherNdOptionsT* AsGatherNdOptions() const
    {
        return type == BuiltinOptions_GatherNdOptions ? reinterpret_cast<const GatherNdOptionsT*>(value) : nullptr;
    }
    CosOptionsT* AsCosOptions()
    {
        return type == BuiltinOptions_CosOptions ? reinterpret_cast<CosOptionsT*>(value) : nullptr;
    }
    const CosOptionsT* AsCosOptions() const
    {
        return type == BuiltinOptions_CosOptions ? reinterpret_cast<const CosOptionsT*>(value) : nullptr;
    }
    WhereOptionsT* AsWhereOptions()
    {
        return type == BuiltinOptions_WhereOptions ? reinterpret_cast<WhereOptionsT*>(value) : nullptr;
    }
    const WhereOptionsT* AsWhereOptions() const
    {
        return type == BuiltinOptions_WhereOptions ? reinterpret_cast<const WhereOptionsT*>(value) : nullptr;
    }
    RankOptionsT* AsRankOptions()
    {
        return type == BuiltinOptions_RankOptions ? reinterpret_cast<RankOptionsT*>(value) : nullptr;
    }
    const RankOptionsT* AsRankOptions() const
    {
        return type == BuiltinOptions_RankOptions ? reinterpret_cast<const RankOptionsT*>(value) : nullptr;
    }
    ReverseSequenceOptionsT* AsReverseSequenceOptions()
    {
        return type == BuiltinOptions_ReverseSequenceOptions ? reinterpret_cast<ReverseSequenceOptionsT*>(value) : nullptr;
    }
    const ReverseSequenceOptionsT* AsReverseSequenceOptions() const
    {
        return type == BuiltinOptions_ReverseSequenceOptions ? reinterpret_cast<const ReverseSequenceOptionsT*>(value) : nullptr;
    }
    MatrixDiagOptionsT* AsMatrixDiagOptions()
    {
        return type == BuiltinOptions_MatrixDiagOptions ? reinterpret_cast<MatrixDiagOptionsT*>(value) : nullptr;
    }
    const MatrixDiagOptionsT* AsMatrixDiagOptions() const
    {
        return type == BuiltinOptions_MatrixDiagOptions ? reinterpret_cast<const MatrixDiagOptionsT*>(value) : nullptr;
    }
    QuantizeOptionsT* AsQuantizeOptions()
    {
        return type == BuiltinOptions_QuantizeOptions ? reinterpret_cast<QuantizeOptionsT*>(value) : nullptr;
    }
    const QuantizeOptionsT* AsQuantizeOptions() const
    {
        return type == BuiltinOptions_QuantizeOptions ? reinterpret_cast<const QuantizeOptionsT*>(value) : nullptr;
    }
    MatrixSetDiagOptionsT* AsMatrixSetDiagOptions()
    {
        return type == BuiltinOptions_MatrixSetDiagOptions ? reinterpret_cast<MatrixSetDiagOptionsT*>(value) : nullptr;
    }
    const MatrixSetDiagOptionsT* AsMatrixSetDiagOptions() const
    {
        return type == BuiltinOptions_MatrixSetDiagOptions ? reinterpret_cast<const MatrixSetDiagOptionsT*>(value) : nullptr;
    }
    HardSwishOptionsT* AsHardSwishOptions()
    {
        return type == BuiltinOptions_HardSwishOptions ? reinterpret_cast<HardSwishOptionsT*>(value) : nullptr;
    }
    const HardSwishOptionsT* AsHardSwishOptions() const
    {
        return type == BuiltinOptions_HardSwishOptions ? reinterpret_cast<const HardSwishOptionsT*>(value) : nullptr;
    }
    IfOptionsT* AsIfOptions()
    {
        return type == BuiltinOptions_IfOptions ? reinterpret_cast<IfOptionsT*>(value) : nullptr;
    }
    const IfOptionsT* AsIfOptions() const
    {
        return type == BuiltinOptions_IfOptions ? reinterpret_cast<const IfOptionsT*>(value) : nullptr;
    }
    WhileOptionsT* AsWhileOptions()
    {
        return type == BuiltinOptions_WhileOptions ? reinterpret_cast<WhileOptionsT*>(value) : nullptr;
    }
    const WhileOptionsT* AsWhileOptions() const
    {
        return type == BuiltinOptions_WhileOptions ? reinterpret_cast<const WhileOptionsT*>(value) : nullptr;
    }
};

bool VerifyBuiltinOptions(flatbuffers::Verifier& verifier, const void* obj, BuiltinOptions type);
bool VerifyBuiltinOptionsVector(flatbuffers::Verifier& verifier, const flatbuffers::Vector<flatbuffers::Offset<void> >* values, const flatbuffers::Vector<uint8_t>* types);

enum Padding
{
    Padding_SAME = 0,
    Padding_VALID = 1,
    Padding_MIN = Padding_SAME,
    Padding_MAX = Padding_VALID
};

inline const Padding (&EnumValuesPadding())[2]
{
    static const Padding values[] = {
        Padding_SAME,
        Padding_VALID};
    return values;
}

inline const char* const* EnumNamesPadding()
{
    static const char* const names[] = {
        "SAME",
        "VALID",
        nullptr};
    return names;
}

inline const char* EnumNamePadding(Padding e)
{
    if (e < Padding_SAME || e > Padding_VALID) return "";
    const size_t index = static_cast<size_t>(e);
    return EnumNamesPadding()[index];
}

enum ActivationFunctionType
{
    ActivationFunctionType_NONE = 0,
    ActivationFunctionType_RELU = 1,
    ActivationFunctionType_RELU_N1_TO_1 = 2,
    ActivationFunctionType_RELU6 = 3,
    ActivationFunctionType_TANH = 4,
    ActivationFunctionType_SIGN_BIT = 5,
    ActivationFunctionType_MIN = ActivationFunctionType_NONE,
    ActivationFunctionType_MAX = ActivationFunctionType_SIGN_BIT
};

inline const ActivationFunctionType (&EnumValuesActivationFunctionType())[6]
{
    static const ActivationFunctionType values[] = {
        ActivationFunctionType_NONE,
        ActivationFunctionType_RELU,
        ActivationFunctionType_RELU_N1_TO_1,
        ActivationFunctionType_RELU6,
        ActivationFunctionType_TANH,
        ActivationFunctionType_SIGN_BIT};
    return values;
}

inline const char* const* EnumNamesActivationFunctionType()
{
    static const char* const names[] = {
        "NONE",
        "RELU",
        "RELU_N1_TO_1",
        "RELU6",
        "TANH",
        "SIGN_BIT",
        nullptr};
    return names;
}

inline const char* EnumNameActivationFunctionType(ActivationFunctionType e)
{
    if (e < ActivationFunctionType_NONE || e > ActivationFunctionType_SIGN_BIT) return "";
    const size_t index = static_cast<size_t>(e);
    return EnumNamesActivationFunctionType()[index];
}

enum LSHProjectionType
{
    LSHProjectionType_UNKNOWN = 0,
    LSHProjectionType_SPARSE = 1,
    LSHProjectionType_DENSE = 2,
    LSHProjectionType_MIN = LSHProjectionType_UNKNOWN,
    LSHProjectionType_MAX = LSHProjectionType_DENSE
};

inline const LSHProjectionType (&EnumValuesLSHProjectionType())[3]
{
    static const LSHProjectionType values[] = {
        LSHProjectionType_UNKNOWN,
        LSHProjectionType_SPARSE,
        LSHProjectionType_DENSE};
    return values;
}

inline const char* const* EnumNamesLSHProjectionType()
{
    static const char* const names[] = {
        "UNKNOWN",
        "SPARSE",
        "DENSE",
        nullptr};
    return names;
}

inline const char* EnumNameLSHProjectionType(LSHProjectionType e)
{
    if (e < LSHProjectionType_UNKNOWN || e > LSHProjectionType_DENSE) return "";
    const size_t index = static_cast<size_t>(e);
    return EnumNamesLSHProjectionType()[index];
}

enum FullyConnectedOptionsWeightsFormat
{
    FullyConnectedOptionsWeightsFormat_DEFAULT = 0,
    FullyConnectedOptionsWeightsFormat_SHUFFLED4x16INT8 = 1,
    FullyConnectedOptionsWeightsFormat_MIN = FullyConnectedOptionsWeightsFormat_DEFAULT,
    FullyConnectedOptionsWeightsFormat_MAX = FullyConnectedOptionsWeightsFormat_SHUFFLED4x16INT8
};

inline const FullyConnectedOptionsWeightsFormat (&EnumValuesFullyConnectedOptionsWeightsFormat())[2]
{
    static const FullyConnectedOptionsWeightsFormat values[] = {
        FullyConnectedOptionsWeightsFormat_DEFAULT,
        FullyConnectedOptionsWeightsFormat_SHUFFLED4x16INT8};
    return values;
}

inline const char* const* EnumNamesFullyConnectedOptionsWeightsFormat()
{
    static const char* const names[] = {
        "DEFAULT",
        "SHUFFLED4x16INT8",
        nullptr};
    return names;
}

inline const char* EnumNameFullyConnectedOptionsWeightsFormat(FullyConnectedOptionsWeightsFormat e)
{
    if (e < FullyConnectedOptionsWeightsFormat_DEFAULT || e > FullyConnectedOptionsWeightsFormat_SHUFFLED4x16INT8) return "";
    const size_t index = static_cast<size_t>(e);
    return EnumNamesFullyConnectedOptionsWeightsFormat()[index];
}

enum LSTMKernelType
{
    LSTMKernelType_FULL = 0,
    LSTMKernelType_BASIC = 1,
    LSTMKernelType_MIN = LSTMKernelType_FULL,
    LSTMKernelType_MAX = LSTMKernelType_BASIC
};

inline const LSTMKernelType (&EnumValuesLSTMKernelType())[2]
{
    static const LSTMKernelType values[] = {
        LSTMKernelType_FULL,
        LSTMKernelType_BASIC};
    return values;
}

inline const char* const* EnumNamesLSTMKernelType()
{
    static const char* const names[] = {
        "FULL",
        "BASIC",
        nullptr};
    return names;
}

inline const char* EnumNameLSTMKernelType(LSTMKernelType e)
{
    if (e < LSTMKernelType_FULL || e > LSTMKernelType_BASIC) return "";
    const size_t index = static_cast<size_t>(e);
    return EnumNamesLSTMKernelType()[index];
}

enum CombinerType
{
    CombinerType_SUM = 0,
    CombinerType_MEAN = 1,
    CombinerType_SQRTN = 2,
    CombinerType_MIN = CombinerType_SUM,
    CombinerType_MAX = CombinerType_SQRTN
};

inline const CombinerType (&EnumValuesCombinerType())[3]
{
    static const CombinerType values[] = {
        CombinerType_SUM,
        CombinerType_MEAN,
        CombinerType_SQRTN};
    return values;
}

inline const char* const* EnumNamesCombinerType()
{
    static const char* const names[] = {
        "SUM",
        "MEAN",
        "SQRTN",
        nullptr};
    return names;
}

inline const char* EnumNameCombinerType(CombinerType e)
{
    if (e < CombinerType_SUM || e > CombinerType_SQRTN) return "";
    const size_t index = static_cast<size_t>(e);
    return EnumNamesCombinerType()[index];
}

enum MirrorPadMode
{
    MirrorPadMode_REFLECT = 0,
    MirrorPadMode_SYMMETRIC = 1,
    MirrorPadMode_MIN = MirrorPadMode_REFLECT,
    MirrorPadMode_MAX = MirrorPadMode_SYMMETRIC
};

inline const MirrorPadMode (&EnumValuesMirrorPadMode())[2]
{
    static const MirrorPadMode values[] = {
        MirrorPadMode_REFLECT,
        MirrorPadMode_SYMMETRIC};
    return values;
}

inline const char* const* EnumNamesMirrorPadMode()
{
    static const char* const names[] = {
        "REFLECT",
        "SYMMETRIC",
        nullptr};
    return names;
}

inline const char* EnumNameMirrorPadMode(MirrorPadMode e)
{
    if (e < MirrorPadMode_REFLECT || e > MirrorPadMode_SYMMETRIC) return "";
    const size_t index = static_cast<size_t>(e);
    return EnumNamesMirrorPadMode()[index];
}

enum CustomOptionsFormat
{
    CustomOptionsFormat_FLEXBUFFERS = 0,
    CustomOptionsFormat_MIN = CustomOptionsFormat_FLEXBUFFERS,
    CustomOptionsFormat_MAX = CustomOptionsFormat_FLEXBUFFERS
};

inline const CustomOptionsFormat (&EnumValuesCustomOptionsFormat())[1]
{
    static const CustomOptionsFormat values[] = {
        CustomOptionsFormat_FLEXBUFFERS};
    return values;
}

inline const char* const* EnumNamesCustomOptionsFormat()
{
    static const char* const names[] = {
        "FLEXBUFFERS",
        nullptr};
    return names;
}

inline const char* EnumNameCustomOptionsFormat(CustomOptionsFormat e)
{
    if (e < CustomOptionsFormat_FLEXBUFFERS || e > CustomOptionsFormat_FLEXBUFFERS) return "";
    const size_t index = static_cast<size_t>(e);
    return EnumNamesCustomOptionsFormat()[index];
}

struct CustomQuantizationT : public flatbuffers::NativeTable
{
    typedef CustomQuantization TableType;
    std::vector<uint8_t> custom;
    CustomQuantizationT()
    {
    }
};

struct CustomQuantization FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef CustomQuantizationT NativeTableType;
    enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE
    {
        VT_CUSTOM = 4
    };
    const flatbuffers::Vector<uint8_t>* custom() const
    {
        return GetPointer<const flatbuffers::Vector<uint8_t>*>(VT_CUSTOM);
    }
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && VerifyOffset(verifier, VT_CUSTOM) && verifier.VerifyVector(custom()) && verifier.EndTable();
    }
    CustomQuantizationT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(CustomQuantizationT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<CustomQuantization> Pack(flatbuffers::FlatBufferBuilder& _fbb, const CustomQuantizationT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct CustomQuantizationBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    void add_custom(flatbuffers::Offset<flatbuffers::Vector<uint8_t> > custom)
    {
        fbb_.AddOffset(CustomQuantization::VT_CUSTOM, custom);
    }
    explicit CustomQuantizationBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    CustomQuantizationBuilder& operator=(const CustomQuantizationBuilder&);
    flatbuffers::Offset<CustomQuantization> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<CustomQuantization>(end);
        return o;
    }
};

inline flatbuffers::Offset<CustomQuantization> CreateCustomQuantization(
    flatbuffers::FlatBufferBuilder& _fbb,
    flatbuffers::Offset<flatbuffers::Vector<uint8_t> > custom = 0)
{
    CustomQuantizationBuilder builder_(_fbb);
    builder_.add_custom(custom);
    return builder_.Finish();
}

inline flatbuffers::Offset<CustomQuantization> CreateCustomQuantizationDirect(
    flatbuffers::FlatBufferBuilder& _fbb,
    const std::vector<uint8_t>* custom = nullptr)
{
    auto custom__ = custom ? _fbb.CreateVector<uint8_t>(*custom) : 0;
    return tflite::CreateCustomQuantization(
        _fbb,
        custom__);
}

flatbuffers::Offset<CustomQuantization> CreateCustomQuantization(flatbuffers::FlatBufferBuilder& _fbb, const CustomQuantizationT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct QuantizationParametersT : public flatbuffers::NativeTable
{
    typedef QuantizationParameters TableType;
    std::vector<float> min;
    std::vector<float> max;
    std::vector<float> scale;
    std::vector<int64_t> zero_point;
    QuantizationDetailsUnion details;
    int32_t quantized_dimension;
    QuantizationParametersT()
        : quantized_dimension(0)
    {
    }
};

struct QuantizationParameters FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef QuantizationParametersT NativeTableType;
    enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE
    {
        VT_MIN = 4,
        VT_MAX = 6,
        VT_SCALE = 8,
        VT_ZERO_POINT = 10,
        VT_DETAILS_TYPE = 12,
        VT_DETAILS = 14,
        VT_QUANTIZED_DIMENSION = 16
    };
    const flatbuffers::Vector<float>* min() const
    {
        return GetPointer<const flatbuffers::Vector<float>*>(VT_MIN);
    }
    const flatbuffers::Vector<float>* max() const
    {
        return GetPointer<const flatbuffers::Vector<float>*>(VT_MAX);
    }
    const flatbuffers::Vector<float>* scale() const
    {
        return GetPointer<const flatbuffers::Vector<float>*>(VT_SCALE);
    }
    const flatbuffers::Vector<int64_t>* zero_point() const
    {
        return GetPointer<const flatbuffers::Vector<int64_t>*>(VT_ZERO_POINT);
    }
    QuantizationDetails details_type() const
    {
        return static_cast<QuantizationDetails>(GetField<uint8_t>(VT_DETAILS_TYPE, 0));
    }
    const void* details() const
    {
        return GetPointer<const void*>(VT_DETAILS);
    }
    template<typename T>
    const T* details_as() const;
    const CustomQuantization* details_as_CustomQuantization() const
    {
        return details_type() == QuantizationDetails_CustomQuantization ? static_cast<const CustomQuantization*>(details()) : nullptr;
    }
    int32_t quantized_dimension() const
    {
        return GetField<int32_t>(VT_QUANTIZED_DIMENSION, 0);
    }
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && VerifyOffset(verifier, VT_MIN) && verifier.VerifyVector(min()) && VerifyOffset(verifier, VT_MAX) && verifier.VerifyVector(max()) && VerifyOffset(verifier, VT_SCALE) && verifier.VerifyVector(scale()) && VerifyOffset(verifier, VT_ZERO_POINT) && verifier.VerifyVector(zero_point()) && VerifyField<uint8_t>(verifier, VT_DETAILS_TYPE) && VerifyOffset(verifier, VT_DETAILS) && VerifyQuantizationDetails(verifier, details(), details_type()) && VerifyField<int32_t>(verifier, VT_QUANTIZED_DIMENSION) && verifier.EndTable();
    }
    QuantizationParametersT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(QuantizationParametersT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<QuantizationParameters> Pack(flatbuffers::FlatBufferBuilder& _fbb, const QuantizationParametersT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

template<>
inline const CustomQuantization* QuantizationParameters::details_as<CustomQuantization>() const
{
    return details_as_CustomQuantization();
}

struct QuantizationParametersBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    void add_min(flatbuffers::Offset<flatbuffers::Vector<float> > min)
    {
        fbb_.AddOffset(QuantizationParameters::VT_MIN, min);
    }
    void add_max(flatbuffers::Offset<flatbuffers::Vector<float> > max)
    {
        fbb_.AddOffset(QuantizationParameters::VT_MAX, max);
    }
    void add_scale(flatbuffers::Offset<flatbuffers::Vector<float> > scale)
    {
        fbb_.AddOffset(QuantizationParameters::VT_SCALE, scale);
    }
    void add_zero_point(flatbuffers::Offset<flatbuffers::Vector<int64_t> > zero_point)
    {
        fbb_.AddOffset(QuantizationParameters::VT_ZERO_POINT, zero_point);
    }
    void add_details_type(QuantizationDetails details_type)
    {
        fbb_.AddElement<uint8_t>(QuantizationParameters::VT_DETAILS_TYPE, static_cast<uint8_t>(details_type), 0);
    }
    void add_details(flatbuffers::Offset<void> details)
    {
        fbb_.AddOffset(QuantizationParameters::VT_DETAILS, details);
    }
    void add_quantized_dimension(int32_t quantized_dimension)
    {
        fbb_.AddElement<int32_t>(QuantizationParameters::VT_QUANTIZED_DIMENSION, quantized_dimension, 0);
    }
    explicit QuantizationParametersBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    QuantizationParametersBuilder& operator=(const QuantizationParametersBuilder&);
    flatbuffers::Offset<QuantizationParameters> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<QuantizationParameters>(end);
        return o;
    }
};

inline flatbuffers::Offset<QuantizationParameters> CreateQuantizationParameters(
    flatbuffers::FlatBufferBuilder& _fbb,
    flatbuffers::Offset<flatbuffers::Vector<float> > min = 0,
    flatbuffers::Offset<flatbuffers::Vector<float> > max = 0,
    flatbuffers::Offset<flatbuffers::Vector<float> > scale = 0,
    flatbuffers::Offset<flatbuffers::Vector<int64_t> > zero_point = 0,
    QuantizationDetails details_type = QuantizationDetails_NONE,
    flatbuffers::Offset<void> details = 0,
    int32_t quantized_dimension = 0)
{
    QuantizationParametersBuilder builder_(_fbb);
    builder_.add_quantized_dimension(quantized_dimension);
    builder_.add_details(details);
    builder_.add_zero_point(zero_point);
    builder_.add_scale(scale);
    builder_.add_max(max);
    builder_.add_min(min);
    builder_.add_details_type(details_type);
    return builder_.Finish();
}

inline flatbuffers::Offset<QuantizationParameters> CreateQuantizationParametersDirect(
    flatbuffers::FlatBufferBuilder& _fbb,
    const std::vector<float>* min = nullptr,
    const std::vector<float>* max = nullptr,
    const std::vector<float>* scale = nullptr,
    const std::vector<int64_t>* zero_point = nullptr,
    QuantizationDetails details_type = QuantizationDetails_NONE,
    flatbuffers::Offset<void> details = 0,
    int32_t quantized_dimension = 0)
{
    auto min__ = min ? _fbb.CreateVector<float>(*min) : 0;
    auto max__ = max ? _fbb.CreateVector<float>(*max) : 0;
    auto scale__ = scale ? _fbb.CreateVector<float>(*scale) : 0;
    auto zero_point__ = zero_point ? _fbb.CreateVector<int64_t>(*zero_point) : 0;
    return tflite::CreateQuantizationParameters(
        _fbb,
        min__,
        max__,
        scale__,
        zero_point__,
        details_type,
        details,
        quantized_dimension);
}

flatbuffers::Offset<QuantizationParameters> CreateQuantizationParameters(flatbuffers::FlatBufferBuilder& _fbb, const QuantizationParametersT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct TensorT : public flatbuffers::NativeTable
{
    typedef Tensor TableType;
    std::vector<int32_t> shape;
    TensorType type;
    uint32_t buffer;
    std::string name;
    std::unique_ptr<QuantizationParametersT> quantization;
    bool is_variable;
    TensorT()
        : type(TensorType_FLOAT32),
          buffer(0),
          is_variable(false)
    {
    }
};

struct Tensor FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef TensorT NativeTableType;
    enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE
    {
        VT_SHAPE = 4,
        VT_TYPE = 6,
        VT_BUFFER = 8,
        VT_NAME = 10,
        VT_QUANTIZATION = 12,
        VT_IS_VARIABLE = 14
    };
    const flatbuffers::Vector<int32_t>* shape() const
    {
        return GetPointer<const flatbuffers::Vector<int32_t>*>(VT_SHAPE);
    }
    TensorType type() const
    {
        return static_cast<TensorType>(GetField<int8_t>(VT_TYPE, 0));
    }
    uint32_t buffer() const
    {
        return GetField<uint32_t>(VT_BUFFER, 0);
    }
    const flatbuffers::String* name() const
    {
        return GetPointer<const flatbuffers::String*>(VT_NAME);
    }
    const QuantizationParameters* quantization() const
    {
        return GetPointer<const QuantizationParameters*>(VT_QUANTIZATION);
    }
    bool is_variable() const
    {
        return GetField<uint8_t>(VT_IS_VARIABLE, 0) != 0;
    }
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && VerifyOffset(verifier, VT_SHAPE) && verifier.VerifyVector(shape()) && VerifyField<int8_t>(verifier, VT_TYPE) && VerifyField<uint32_t>(verifier, VT_BUFFER) && VerifyOffset(verifier, VT_NAME) && verifier.VerifyString(name()) && VerifyOffset(verifier, VT_QUANTIZATION) && verifier.VerifyTable(quantization()) && VerifyField<uint8_t>(verifier, VT_IS_VARIABLE) && verifier.EndTable();
    }
    TensorT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(TensorT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<Tensor> Pack(flatbuffers::FlatBufferBuilder& _fbb, const TensorT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct TensorBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    void add_shape(flatbuffers::Offset<flatbuffers::Vector<int32_t> > shape)
    {
        fbb_.AddOffset(Tensor::VT_SHAPE, shape);
    }
    void add_type(TensorType type)
    {
        fbb_.AddElement<int8_t>(Tensor::VT_TYPE, static_cast<int8_t>(type), 0);
    }
    void add_buffer(uint32_t buffer)
    {
        fbb_.AddElement<uint32_t>(Tensor::VT_BUFFER, buffer, 0);
    }
    void add_name(flatbuffers::Offset<flatbuffers::String> name)
    {
        fbb_.AddOffset(Tensor::VT_NAME, name);
    }
    void add_quantization(flatbuffers::Offset<QuantizationParameters> quantization)
    {
        fbb_.AddOffset(Tensor::VT_QUANTIZATION, quantization);
    }
    void add_is_variable(bool is_variable)
    {
        fbb_.AddElement<uint8_t>(Tensor::VT_IS_VARIABLE, static_cast<uint8_t>(is_variable), 0);
    }
    explicit TensorBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    TensorBuilder& operator=(const TensorBuilder&);
    flatbuffers::Offset<Tensor> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<Tensor>(end);
        return o;
    }
};

inline flatbuffers::Offset<Tensor> CreateTensor(
    flatbuffers::FlatBufferBuilder& _fbb,
    flatbuffers::Offset<flatbuffers::Vector<int32_t> > shape = 0,
    TensorType type = TensorType_FLOAT32,
    uint32_t buffer = 0,
    flatbuffers::Offset<flatbuffers::String> name = 0,
    flatbuffers::Offset<QuantizationParameters> quantization = 0,
    bool is_variable = false)
{
    TensorBuilder builder_(_fbb);
    builder_.add_quantization(quantization);
    builder_.add_name(name);
    builder_.add_buffer(buffer);
    builder_.add_shape(shape);
    builder_.add_is_variable(is_variable);
    builder_.add_type(type);
    return builder_.Finish();
}

inline flatbuffers::Offset<Tensor> CreateTensorDirect(
    flatbuffers::FlatBufferBuilder& _fbb,
    const std::vector<int32_t>* shape = nullptr,
    TensorType type = TensorType_FLOAT32,
    uint32_t buffer = 0,
    const char* name = nullptr,
    flatbuffers::Offset<QuantizationParameters> quantization = 0,
    bool is_variable = false)
{
    auto shape__ = shape ? _fbb.CreateVector<int32_t>(*shape) : 0;
    auto name__ = name ? _fbb.CreateString(name) : 0;
    return tflite::CreateTensor(
        _fbb,
        shape__,
        type,
        buffer,
        name__,
        quantization,
        is_variable);
}

flatbuffers::Offset<Tensor> CreateTensor(flatbuffers::FlatBufferBuilder& _fbb, const TensorT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct Conv2DOptionsT : public flatbuffers::NativeTable
{
    typedef Conv2DOptions TableType;
    Padding padding;
    int32_t stride_w;
    int32_t stride_h;
    ActivationFunctionType fused_activation_function;
    int32_t dilation_w_factor;
    int32_t dilation_h_factor;
    Conv2DOptionsT()
        : padding(Padding_SAME),
          stride_w(0),
          stride_h(0),
          fused_activation_function(ActivationFunctionType_NONE),
          dilation_w_factor(1),
          dilation_h_factor(1)
    {
    }
};

struct Conv2DOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef Conv2DOptionsT NativeTableType;
    enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE
    {
        VT_PADDING = 4,
        VT_STRIDE_W = 6,
        VT_STRIDE_H = 8,
        VT_FUSED_ACTIVATION_FUNCTION = 10,
        VT_DILATION_W_FACTOR = 12,
        VT_DILATION_H_FACTOR = 14
    };
    Padding padding() const
    {
        return static_cast<Padding>(GetField<int8_t>(VT_PADDING, 0));
    }
    int32_t stride_w() const
    {
        return GetField<int32_t>(VT_STRIDE_W, 0);
    }
    int32_t stride_h() const
    {
        return GetField<int32_t>(VT_STRIDE_H, 0);
    }
    ActivationFunctionType fused_activation_function() const
    {
        return static_cast<ActivationFunctionType>(GetField<int8_t>(VT_FUSED_ACTIVATION_FUNCTION, 0));
    }
    int32_t dilation_w_factor() const
    {
        return GetField<int32_t>(VT_DILATION_W_FACTOR, 1);
    }
    int32_t dilation_h_factor() const
    {
        return GetField<int32_t>(VT_DILATION_H_FACTOR, 1);
    }
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && VerifyField<int8_t>(verifier, VT_PADDING) && VerifyField<int32_t>(verifier, VT_STRIDE_W) && VerifyField<int32_t>(verifier, VT_STRIDE_H) && VerifyField<int8_t>(verifier, VT_FUSED_ACTIVATION_FUNCTION) && VerifyField<int32_t>(verifier, VT_DILATION_W_FACTOR) && VerifyField<int32_t>(verifier, VT_DILATION_H_FACTOR) && verifier.EndTable();
    }
    Conv2DOptionsT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(Conv2DOptionsT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<Conv2DOptions> Pack(flatbuffers::FlatBufferBuilder& _fbb, const Conv2DOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct Conv2DOptionsBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    void add_padding(Padding padding)
    {
        fbb_.AddElement<int8_t>(Conv2DOptions::VT_PADDING, static_cast<int8_t>(padding), 0);
    }
    void add_stride_w(int32_t stride_w)
    {
        fbb_.AddElement<int32_t>(Conv2DOptions::VT_STRIDE_W, stride_w, 0);
    }
    void add_stride_h(int32_t stride_h)
    {
        fbb_.AddElement<int32_t>(Conv2DOptions::VT_STRIDE_H, stride_h, 0);
    }
    void add_fused_activation_function(ActivationFunctionType fused_activation_function)
    {
        fbb_.AddElement<int8_t>(Conv2DOptions::VT_FUSED_ACTIVATION_FUNCTION, static_cast<int8_t>(fused_activation_function), 0);
    }
    void add_dilation_w_factor(int32_t dilation_w_factor)
    {
        fbb_.AddElement<int32_t>(Conv2DOptions::VT_DILATION_W_FACTOR, dilation_w_factor, 1);
    }
    void add_dilation_h_factor(int32_t dilation_h_factor)
    {
        fbb_.AddElement<int32_t>(Conv2DOptions::VT_DILATION_H_FACTOR, dilation_h_factor, 1);
    }
    explicit Conv2DOptionsBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    Conv2DOptionsBuilder& operator=(const Conv2DOptionsBuilder&);
    flatbuffers::Offset<Conv2DOptions> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<Conv2DOptions>(end);
        return o;
    }
};

inline flatbuffers::Offset<Conv2DOptions> CreateConv2DOptions(
    flatbuffers::FlatBufferBuilder& _fbb,
    Padding padding = Padding_SAME,
    int32_t stride_w = 0,
    int32_t stride_h = 0,
    ActivationFunctionType fused_activation_function = ActivationFunctionType_NONE,
    int32_t dilation_w_factor = 1,
    int32_t dilation_h_factor = 1)
{
    Conv2DOptionsBuilder builder_(_fbb);
    builder_.add_dilation_h_factor(dilation_h_factor);
    builder_.add_dilation_w_factor(dilation_w_factor);
    builder_.add_stride_h(stride_h);
    builder_.add_stride_w(stride_w);
    builder_.add_fused_activation_function(fused_activation_function);
    builder_.add_padding(padding);
    return builder_.Finish();
}

flatbuffers::Offset<Conv2DOptions> CreateConv2DOptions(flatbuffers::FlatBufferBuilder& _fbb, const Conv2DOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct Pool2DOptionsT : public flatbuffers::NativeTable
{
    typedef Pool2DOptions TableType;
    Padding padding;
    int32_t stride_w;
    int32_t stride_h;
    int32_t filter_width;
    int32_t filter_height;
    ActivationFunctionType fused_activation_function;
    Pool2DOptionsT()
        : padding(Padding_SAME),
          stride_w(0),
          stride_h(0),
          filter_width(0),
          filter_height(0),
          fused_activation_function(ActivationFunctionType_NONE)
    {
    }
};

struct Pool2DOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef Pool2DOptionsT NativeTableType;
    enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE
    {
        VT_PADDING = 4,
        VT_STRIDE_W = 6,
        VT_STRIDE_H = 8,
        VT_FILTER_WIDTH = 10,
        VT_FILTER_HEIGHT = 12,
        VT_FUSED_ACTIVATION_FUNCTION = 14
    };
    Padding padding() const
    {
        return static_cast<Padding>(GetField<int8_t>(VT_PADDING, 0));
    }
    int32_t stride_w() const
    {
        return GetField<int32_t>(VT_STRIDE_W, 0);
    }
    int32_t stride_h() const
    {
        return GetField<int32_t>(VT_STRIDE_H, 0);
    }
    int32_t filter_width() const
    {
        return GetField<int32_t>(VT_FILTER_WIDTH, 0);
    }
    int32_t filter_height() const
    {
        return GetField<int32_t>(VT_FILTER_HEIGHT, 0);
    }
    ActivationFunctionType fused_activation_function() const
    {
        return static_cast<ActivationFunctionType>(GetField<int8_t>(VT_FUSED_ACTIVATION_FUNCTION, 0));
    }
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && VerifyField<int8_t>(verifier, VT_PADDING) && VerifyField<int32_t>(verifier, VT_STRIDE_W) && VerifyField<int32_t>(verifier, VT_STRIDE_H) && VerifyField<int32_t>(verifier, VT_FILTER_WIDTH) && VerifyField<int32_t>(verifier, VT_FILTER_HEIGHT) && VerifyField<int8_t>(verifier, VT_FUSED_ACTIVATION_FUNCTION) && verifier.EndTable();
    }
    Pool2DOptionsT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(Pool2DOptionsT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<Pool2DOptions> Pack(flatbuffers::FlatBufferBuilder& _fbb, const Pool2DOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct Pool2DOptionsBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    void add_padding(Padding padding)
    {
        fbb_.AddElement<int8_t>(Pool2DOptions::VT_PADDING, static_cast<int8_t>(padding), 0);
    }
    void add_stride_w(int32_t stride_w)
    {
        fbb_.AddElement<int32_t>(Pool2DOptions::VT_STRIDE_W, stride_w, 0);
    }
    void add_stride_h(int32_t stride_h)
    {
        fbb_.AddElement<int32_t>(Pool2DOptions::VT_STRIDE_H, stride_h, 0);
    }
    void add_filter_width(int32_t filter_width)
    {
        fbb_.AddElement<int32_t>(Pool2DOptions::VT_FILTER_WIDTH, filter_width, 0);
    }
    void add_filter_height(int32_t filter_height)
    {
        fbb_.AddElement<int32_t>(Pool2DOptions::VT_FILTER_HEIGHT, filter_height, 0);
    }
    void add_fused_activation_function(ActivationFunctionType fused_activation_function)
    {
        fbb_.AddElement<int8_t>(Pool2DOptions::VT_FUSED_ACTIVATION_FUNCTION, static_cast<int8_t>(fused_activation_function), 0);
    }
    explicit Pool2DOptionsBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    Pool2DOptionsBuilder& operator=(const Pool2DOptionsBuilder&);
    flatbuffers::Offset<Pool2DOptions> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<Pool2DOptions>(end);
        return o;
    }
};

inline flatbuffers::Offset<Pool2DOptions> CreatePool2DOptions(
    flatbuffers::FlatBufferBuilder& _fbb,
    Padding padding = Padding_SAME,
    int32_t stride_w = 0,
    int32_t stride_h = 0,
    int32_t filter_width = 0,
    int32_t filter_height = 0,
    ActivationFunctionType fused_activation_function = ActivationFunctionType_NONE)
{
    Pool2DOptionsBuilder builder_(_fbb);
    builder_.add_filter_height(filter_height);
    builder_.add_filter_width(filter_width);
    builder_.add_stride_h(stride_h);
    builder_.add_stride_w(stride_w);
    builder_.add_fused_activation_function(fused_activation_function);
    builder_.add_padding(padding);
    return builder_.Finish();
}

flatbuffers::Offset<Pool2DOptions> CreatePool2DOptions(flatbuffers::FlatBufferBuilder& _fbb, const Pool2DOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct DepthwiseConv2DOptionsT : public flatbuffers::NativeTable
{
    typedef DepthwiseConv2DOptions TableType;
    Padding padding;
    int32_t stride_w;
    int32_t stride_h;
    int32_t depth_multiplier;
    ActivationFunctionType fused_activation_function;
    int32_t dilation_w_factor;
    int32_t dilation_h_factor;
    DepthwiseConv2DOptionsT()
        : padding(Padding_SAME),
          stride_w(0),
          stride_h(0),
          depth_multiplier(0),
          fused_activation_function(ActivationFunctionType_NONE),
          dilation_w_factor(1),
          dilation_h_factor(1)
    {
    }
};

struct DepthwiseConv2DOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef DepthwiseConv2DOptionsT NativeTableType;
    enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE
    {
        VT_PADDING = 4,
        VT_STRIDE_W = 6,
        VT_STRIDE_H = 8,
        VT_DEPTH_MULTIPLIER = 10,
        VT_FUSED_ACTIVATION_FUNCTION = 12,
        VT_DILATION_W_FACTOR = 14,
        VT_DILATION_H_FACTOR = 16
    };
    Padding padding() const
    {
        return static_cast<Padding>(GetField<int8_t>(VT_PADDING, 0));
    }
    int32_t stride_w() const
    {
        return GetField<int32_t>(VT_STRIDE_W, 0);
    }
    int32_t stride_h() const
    {
        return GetField<int32_t>(VT_STRIDE_H, 0);
    }
    int32_t depth_multiplier() const
    {
        return GetField<int32_t>(VT_DEPTH_MULTIPLIER, 0);
    }
    ActivationFunctionType fused_activation_function() const
    {
        return static_cast<ActivationFunctionType>(GetField<int8_t>(VT_FUSED_ACTIVATION_FUNCTION, 0));
    }
    int32_t dilation_w_factor() const
    {
        return GetField<int32_t>(VT_DILATION_W_FACTOR, 1);
    }
    int32_t dilation_h_factor() const
    {
        return GetField<int32_t>(VT_DILATION_H_FACTOR, 1);
    }
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && VerifyField<int8_t>(verifier, VT_PADDING) && VerifyField<int32_t>(verifier, VT_STRIDE_W) && VerifyField<int32_t>(verifier, VT_STRIDE_H) && VerifyField<int32_t>(verifier, VT_DEPTH_MULTIPLIER) && VerifyField<int8_t>(verifier, VT_FUSED_ACTIVATION_FUNCTION) && VerifyField<int32_t>(verifier, VT_DILATION_W_FACTOR) && VerifyField<int32_t>(verifier, VT_DILATION_H_FACTOR) && verifier.EndTable();
    }
    DepthwiseConv2DOptionsT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(DepthwiseConv2DOptionsT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<DepthwiseConv2DOptions> Pack(flatbuffers::FlatBufferBuilder& _fbb, const DepthwiseConv2DOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct DepthwiseConv2DOptionsBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    void add_padding(Padding padding)
    {
        fbb_.AddElement<int8_t>(DepthwiseConv2DOptions::VT_PADDING, static_cast<int8_t>(padding), 0);
    }
    void add_stride_w(int32_t stride_w)
    {
        fbb_.AddElement<int32_t>(DepthwiseConv2DOptions::VT_STRIDE_W, stride_w, 0);
    }
    void add_stride_h(int32_t stride_h)
    {
        fbb_.AddElement<int32_t>(DepthwiseConv2DOptions::VT_STRIDE_H, stride_h, 0);
    }
    void add_depth_multiplier(int32_t depth_multiplier)
    {
        fbb_.AddElement<int32_t>(DepthwiseConv2DOptions::VT_DEPTH_MULTIPLIER, depth_multiplier, 0);
    }
    void add_fused_activation_function(ActivationFunctionType fused_activation_function)
    {
        fbb_.AddElement<int8_t>(DepthwiseConv2DOptions::VT_FUSED_ACTIVATION_FUNCTION, static_cast<int8_t>(fused_activation_function), 0);
    }
    void add_dilation_w_factor(int32_t dilation_w_factor)
    {
        fbb_.AddElement<int32_t>(DepthwiseConv2DOptions::VT_DILATION_W_FACTOR, dilation_w_factor, 1);
    }
    void add_dilation_h_factor(int32_t dilation_h_factor)
    {
        fbb_.AddElement<int32_t>(DepthwiseConv2DOptions::VT_DILATION_H_FACTOR, dilation_h_factor, 1);
    }
    explicit DepthwiseConv2DOptionsBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    DepthwiseConv2DOptionsBuilder& operator=(const DepthwiseConv2DOptionsBuilder&);
    flatbuffers::Offset<DepthwiseConv2DOptions> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<DepthwiseConv2DOptions>(end);
        return o;
    }
};

inline flatbuffers::Offset<DepthwiseConv2DOptions> CreateDepthwiseConv2DOptions(
    flatbuffers::FlatBufferBuilder& _fbb,
    Padding padding = Padding_SAME,
    int32_t stride_w = 0,
    int32_t stride_h = 0,
    int32_t depth_multiplier = 0,
    ActivationFunctionType fused_activation_function = ActivationFunctionType_NONE,
    int32_t dilation_w_factor = 1,
    int32_t dilation_h_factor = 1)
{
    DepthwiseConv2DOptionsBuilder builder_(_fbb);
    builder_.add_dilation_h_factor(dilation_h_factor);
    builder_.add_dilation_w_factor(dilation_w_factor);
    builder_.add_depth_multiplier(depth_multiplier);
    builder_.add_stride_h(stride_h);
    builder_.add_stride_w(stride_w);
    builder_.add_fused_activation_function(fused_activation_function);
    builder_.add_padding(padding);
    return builder_.Finish();
}

flatbuffers::Offset<DepthwiseConv2DOptions> CreateDepthwiseConv2DOptions(flatbuffers::FlatBufferBuilder& _fbb, const DepthwiseConv2DOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct ConcatEmbeddingsOptionsT : public flatbuffers::NativeTable
{
    typedef ConcatEmbeddingsOptions TableType;
    int32_t num_channels;
    std::vector<int32_t> num_columns_per_channel;
    std::vector<int32_t> embedding_dim_per_channel;
    ConcatEmbeddingsOptionsT()
        : num_channels(0)
    {
    }
};

struct ConcatEmbeddingsOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef ConcatEmbeddingsOptionsT NativeTableType;
    enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE
    {
        VT_NUM_CHANNELS = 4,
        VT_NUM_COLUMNS_PER_CHANNEL = 6,
        VT_EMBEDDING_DIM_PER_CHANNEL = 8
    };
    int32_t num_channels() const
    {
        return GetField<int32_t>(VT_NUM_CHANNELS, 0);
    }
    const flatbuffers::Vector<int32_t>* num_columns_per_channel() const
    {
        return GetPointer<const flatbuffers::Vector<int32_t>*>(VT_NUM_COLUMNS_PER_CHANNEL);
    }
    const flatbuffers::Vector<int32_t>* embedding_dim_per_channel() const
    {
        return GetPointer<const flatbuffers::Vector<int32_t>*>(VT_EMBEDDING_DIM_PER_CHANNEL);
    }
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && VerifyField<int32_t>(verifier, VT_NUM_CHANNELS) && VerifyOffset(verifier, VT_NUM_COLUMNS_PER_CHANNEL) && verifier.VerifyVector(num_columns_per_channel()) && VerifyOffset(verifier, VT_EMBEDDING_DIM_PER_CHANNEL) && verifier.VerifyVector(embedding_dim_per_channel()) && verifier.EndTable();
    }
    ConcatEmbeddingsOptionsT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(ConcatEmbeddingsOptionsT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<ConcatEmbeddingsOptions> Pack(flatbuffers::FlatBufferBuilder& _fbb, const ConcatEmbeddingsOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct ConcatEmbeddingsOptionsBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    void add_num_channels(int32_t num_channels)
    {
        fbb_.AddElement<int32_t>(ConcatEmbeddingsOptions::VT_NUM_CHANNELS, num_channels, 0);
    }
    void add_num_columns_per_channel(flatbuffers::Offset<flatbuffers::Vector<int32_t> > num_columns_per_channel)
    {
        fbb_.AddOffset(ConcatEmbeddingsOptions::VT_NUM_COLUMNS_PER_CHANNEL, num_columns_per_channel);
    }
    void add_embedding_dim_per_channel(flatbuffers::Offset<flatbuffers::Vector<int32_t> > embedding_dim_per_channel)
    {
        fbb_.AddOffset(ConcatEmbeddingsOptions::VT_EMBEDDING_DIM_PER_CHANNEL, embedding_dim_per_channel);
    }
    explicit ConcatEmbeddingsOptionsBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    ConcatEmbeddingsOptionsBuilder& operator=(const ConcatEmbeddingsOptionsBuilder&);
    flatbuffers::Offset<ConcatEmbeddingsOptions> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<ConcatEmbeddingsOptions>(end);
        return o;
    }
};

inline flatbuffers::Offset<ConcatEmbeddingsOptions> CreateConcatEmbeddingsOptions(
    flatbuffers::FlatBufferBuilder& _fbb,
    int32_t num_channels = 0,
    flatbuffers::Offset<flatbuffers::Vector<int32_t> > num_columns_per_channel = 0,
    flatbuffers::Offset<flatbuffers::Vector<int32_t> > embedding_dim_per_channel = 0)
{
    ConcatEmbeddingsOptionsBuilder builder_(_fbb);
    builder_.add_embedding_dim_per_channel(embedding_dim_per_channel);
    builder_.add_num_columns_per_channel(num_columns_per_channel);
    builder_.add_num_channels(num_channels);
    return builder_.Finish();
}

inline flatbuffers::Offset<ConcatEmbeddingsOptions> CreateConcatEmbeddingsOptionsDirect(
    flatbuffers::FlatBufferBuilder& _fbb,
    int32_t num_channels = 0,
    const std::vector<int32_t>* num_columns_per_channel = nullptr,
    const std::vector<int32_t>* embedding_dim_per_channel = nullptr)
{
    auto num_columns_per_channel__ = num_columns_per_channel ? _fbb.CreateVector<int32_t>(*num_columns_per_channel) : 0;
    auto embedding_dim_per_channel__ = embedding_dim_per_channel ? _fbb.CreateVector<int32_t>(*embedding_dim_per_channel) : 0;
    return tflite::CreateConcatEmbeddingsOptions(
        _fbb,
        num_channels,
        num_columns_per_channel__,
        embedding_dim_per_channel__);
}

flatbuffers::Offset<ConcatEmbeddingsOptions> CreateConcatEmbeddingsOptions(flatbuffers::FlatBufferBuilder& _fbb, const ConcatEmbeddingsOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct LSHProjectionOptionsT : public flatbuffers::NativeTable
{
    typedef LSHProjectionOptions TableType;
    LSHProjectionType type;
    LSHProjectionOptionsT()
        : type(LSHProjectionType_UNKNOWN)
    {
    }
};

struct LSHProjectionOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef LSHProjectionOptionsT NativeTableType;
    enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE
    {
        VT_TYPE = 4
    };
    LSHProjectionType type() const
    {
        return static_cast<LSHProjectionType>(GetField<int8_t>(VT_TYPE, 0));
    }
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && VerifyField<int8_t>(verifier, VT_TYPE) && verifier.EndTable();
    }
    LSHProjectionOptionsT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(LSHProjectionOptionsT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<LSHProjectionOptions> Pack(flatbuffers::FlatBufferBuilder& _fbb, const LSHProjectionOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct LSHProjectionOptionsBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    void add_type(LSHProjectionType type)
    {
        fbb_.AddElement<int8_t>(LSHProjectionOptions::VT_TYPE, static_cast<int8_t>(type), 0);
    }
    explicit LSHProjectionOptionsBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    LSHProjectionOptionsBuilder& operator=(const LSHProjectionOptionsBuilder&);
    flatbuffers::Offset<LSHProjectionOptions> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<LSHProjectionOptions>(end);
        return o;
    }
};

inline flatbuffers::Offset<LSHProjectionOptions> CreateLSHProjectionOptions(
    flatbuffers::FlatBufferBuilder& _fbb,
    LSHProjectionType type = LSHProjectionType_UNKNOWN)
{
    LSHProjectionOptionsBuilder builder_(_fbb);
    builder_.add_type(type);
    return builder_.Finish();
}

flatbuffers::Offset<LSHProjectionOptions> CreateLSHProjectionOptions(flatbuffers::FlatBufferBuilder& _fbb, const LSHProjectionOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct SVDFOptionsT : public flatbuffers::NativeTable
{
    typedef SVDFOptions TableType;
    int32_t rank;
    ActivationFunctionType fused_activation_function;
    SVDFOptionsT()
        : rank(0),
          fused_activation_function(ActivationFunctionType_NONE)
    {
    }
};

struct SVDFOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef SVDFOptionsT NativeTableType;
    enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE
    {
        VT_RANK = 4,
        VT_FUSED_ACTIVATION_FUNCTION = 6
    };
    int32_t rank() const
    {
        return GetField<int32_t>(VT_RANK, 0);
    }
    ActivationFunctionType fused_activation_function() const
    {
        return static_cast<ActivationFunctionType>(GetField<int8_t>(VT_FUSED_ACTIVATION_FUNCTION, 0));
    }
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && VerifyField<int32_t>(verifier, VT_RANK) && VerifyField<int8_t>(verifier, VT_FUSED_ACTIVATION_FUNCTION) && verifier.EndTable();
    }
    SVDFOptionsT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(SVDFOptionsT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<SVDFOptions> Pack(flatbuffers::FlatBufferBuilder& _fbb, const SVDFOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct SVDFOptionsBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    void add_rank(int32_t rank)
    {
        fbb_.AddElement<int32_t>(SVDFOptions::VT_RANK, rank, 0);
    }
    void add_fused_activation_function(ActivationFunctionType fused_activation_function)
    {
        fbb_.AddElement<int8_t>(SVDFOptions::VT_FUSED_ACTIVATION_FUNCTION, static_cast<int8_t>(fused_activation_function), 0);
    }
    explicit SVDFOptionsBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    SVDFOptionsBuilder& operator=(const SVDFOptionsBuilder&);
    flatbuffers::Offset<SVDFOptions> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<SVDFOptions>(end);
        return o;
    }
};

inline flatbuffers::Offset<SVDFOptions> CreateSVDFOptions(
    flatbuffers::FlatBufferBuilder& _fbb,
    int32_t rank = 0,
    ActivationFunctionType fused_activation_function = ActivationFunctionType_NONE)
{
    SVDFOptionsBuilder builder_(_fbb);
    builder_.add_rank(rank);
    builder_.add_fused_activation_function(fused_activation_function);
    return builder_.Finish();
}

flatbuffers::Offset<SVDFOptions> CreateSVDFOptions(flatbuffers::FlatBufferBuilder& _fbb, const SVDFOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct RNNOptionsT : public flatbuffers::NativeTable
{
    typedef RNNOptions TableType;
    ActivationFunctionType fused_activation_function;
    RNNOptionsT()
        : fused_activation_function(ActivationFunctionType_NONE)
    {
    }
};

struct RNNOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef RNNOptionsT NativeTableType;
    enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE
    {
        VT_FUSED_ACTIVATION_FUNCTION = 4
    };
    ActivationFunctionType fused_activation_function() const
    {
        return static_cast<ActivationFunctionType>(GetField<int8_t>(VT_FUSED_ACTIVATION_FUNCTION, 0));
    }
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && VerifyField<int8_t>(verifier, VT_FUSED_ACTIVATION_FUNCTION) && verifier.EndTable();
    }
    RNNOptionsT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(RNNOptionsT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<RNNOptions> Pack(flatbuffers::FlatBufferBuilder& _fbb, const RNNOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct RNNOptionsBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    void add_fused_activation_function(ActivationFunctionType fused_activation_function)
    {
        fbb_.AddElement<int8_t>(RNNOptions::VT_FUSED_ACTIVATION_FUNCTION, static_cast<int8_t>(fused_activation_function), 0);
    }
    explicit RNNOptionsBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    RNNOptionsBuilder& operator=(const RNNOptionsBuilder&);
    flatbuffers::Offset<RNNOptions> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<RNNOptions>(end);
        return o;
    }
};

inline flatbuffers::Offset<RNNOptions> CreateRNNOptions(
    flatbuffers::FlatBufferBuilder& _fbb,
    ActivationFunctionType fused_activation_function = ActivationFunctionType_NONE)
{
    RNNOptionsBuilder builder_(_fbb);
    builder_.add_fused_activation_function(fused_activation_function);
    return builder_.Finish();
}

flatbuffers::Offset<RNNOptions> CreateRNNOptions(flatbuffers::FlatBufferBuilder& _fbb, const RNNOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct SequenceRNNOptionsT : public flatbuffers::NativeTable
{
    typedef SequenceRNNOptions TableType;
    bool time_major;
    ActivationFunctionType fused_activation_function;
    SequenceRNNOptionsT()
        : time_major(false),
          fused_activation_function(ActivationFunctionType_NONE)
    {
    }
};

struct SequenceRNNOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef SequenceRNNOptionsT NativeTableType;
    enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE
    {
        VT_TIME_MAJOR = 4,
        VT_FUSED_ACTIVATION_FUNCTION = 6
    };
    bool time_major() const
    {
        return GetField<uint8_t>(VT_TIME_MAJOR, 0) != 0;
    }
    ActivationFunctionType fused_activation_function() const
    {
        return static_cast<ActivationFunctionType>(GetField<int8_t>(VT_FUSED_ACTIVATION_FUNCTION, 0));
    }
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && VerifyField<uint8_t>(verifier, VT_TIME_MAJOR) && VerifyField<int8_t>(verifier, VT_FUSED_ACTIVATION_FUNCTION) && verifier.EndTable();
    }
    SequenceRNNOptionsT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(SequenceRNNOptionsT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<SequenceRNNOptions> Pack(flatbuffers::FlatBufferBuilder& _fbb, const SequenceRNNOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct SequenceRNNOptionsBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    void add_time_major(bool time_major)
    {
        fbb_.AddElement<uint8_t>(SequenceRNNOptions::VT_TIME_MAJOR, static_cast<uint8_t>(time_major), 0);
    }
    void add_fused_activation_function(ActivationFunctionType fused_activation_function)
    {
        fbb_.AddElement<int8_t>(SequenceRNNOptions::VT_FUSED_ACTIVATION_FUNCTION, static_cast<int8_t>(fused_activation_function), 0);
    }
    explicit SequenceRNNOptionsBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    SequenceRNNOptionsBuilder& operator=(const SequenceRNNOptionsBuilder&);
    flatbuffers::Offset<SequenceRNNOptions> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<SequenceRNNOptions>(end);
        return o;
    }
};

inline flatbuffers::Offset<SequenceRNNOptions> CreateSequenceRNNOptions(
    flatbuffers::FlatBufferBuilder& _fbb,
    bool time_major = false,
    ActivationFunctionType fused_activation_function = ActivationFunctionType_NONE)
{
    SequenceRNNOptionsBuilder builder_(_fbb);
    builder_.add_fused_activation_function(fused_activation_function);
    builder_.add_time_major(time_major);
    return builder_.Finish();
}

flatbuffers::Offset<SequenceRNNOptions> CreateSequenceRNNOptions(flatbuffers::FlatBufferBuilder& _fbb, const SequenceRNNOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct BidirectionalSequenceRNNOptionsT : public flatbuffers::NativeTable
{
    typedef BidirectionalSequenceRNNOptions TableType;
    bool time_major;
    ActivationFunctionType fused_activation_function;
    bool merge_outputs;
    BidirectionalSequenceRNNOptionsT()
        : time_major(false),
          fused_activation_function(ActivationFunctionType_NONE),
          merge_outputs(false)
    {
    }
};

struct BidirectionalSequenceRNNOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef BidirectionalSequenceRNNOptionsT NativeTableType;
    enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE
    {
        VT_TIME_MAJOR = 4,
        VT_FUSED_ACTIVATION_FUNCTION = 6,
        VT_MERGE_OUTPUTS = 8
    };
    bool time_major() const
    {
        return GetField<uint8_t>(VT_TIME_MAJOR, 0) != 0;
    }
    ActivationFunctionType fused_activation_function() const
    {
        return static_cast<ActivationFunctionType>(GetField<int8_t>(VT_FUSED_ACTIVATION_FUNCTION, 0));
    }
    bool merge_outputs() const
    {
        return GetField<uint8_t>(VT_MERGE_OUTPUTS, 0) != 0;
    }
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && VerifyField<uint8_t>(verifier, VT_TIME_MAJOR) && VerifyField<int8_t>(verifier, VT_FUSED_ACTIVATION_FUNCTION) && VerifyField<uint8_t>(verifier, VT_MERGE_OUTPUTS) && verifier.EndTable();
    }
    BidirectionalSequenceRNNOptionsT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(BidirectionalSequenceRNNOptionsT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<BidirectionalSequenceRNNOptions> Pack(flatbuffers::FlatBufferBuilder& _fbb, const BidirectionalSequenceRNNOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct BidirectionalSequenceRNNOptionsBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    void add_time_major(bool time_major)
    {
        fbb_.AddElement<uint8_t>(BidirectionalSequenceRNNOptions::VT_TIME_MAJOR, static_cast<uint8_t>(time_major), 0);
    }
    void add_fused_activation_function(ActivationFunctionType fused_activation_function)
    {
        fbb_.AddElement<int8_t>(BidirectionalSequenceRNNOptions::VT_FUSED_ACTIVATION_FUNCTION, static_cast<int8_t>(fused_activation_function), 0);
    }
    void add_merge_outputs(bool merge_outputs)
    {
        fbb_.AddElement<uint8_t>(BidirectionalSequenceRNNOptions::VT_MERGE_OUTPUTS, static_cast<uint8_t>(merge_outputs), 0);
    }
    explicit BidirectionalSequenceRNNOptionsBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    BidirectionalSequenceRNNOptionsBuilder& operator=(const BidirectionalSequenceRNNOptionsBuilder&);
    flatbuffers::Offset<BidirectionalSequenceRNNOptions> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<BidirectionalSequenceRNNOptions>(end);
        return o;
    }
};

inline flatbuffers::Offset<BidirectionalSequenceRNNOptions> CreateBidirectionalSequenceRNNOptions(
    flatbuffers::FlatBufferBuilder& _fbb,
    bool time_major = false,
    ActivationFunctionType fused_activation_function = ActivationFunctionType_NONE,
    bool merge_outputs = false)
{
    BidirectionalSequenceRNNOptionsBuilder builder_(_fbb);
    builder_.add_merge_outputs(merge_outputs);
    builder_.add_fused_activation_function(fused_activation_function);
    builder_.add_time_major(time_major);
    return builder_.Finish();
}

flatbuffers::Offset<BidirectionalSequenceRNNOptions> CreateBidirectionalSequenceRNNOptions(flatbuffers::FlatBufferBuilder& _fbb, const BidirectionalSequenceRNNOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct FullyConnectedOptionsT : public flatbuffers::NativeTable
{
    typedef FullyConnectedOptions TableType;
    ActivationFunctionType fused_activation_function;
    FullyConnectedOptionsWeightsFormat weights_format;
    bool keep_num_dims;
    FullyConnectedOptionsT()
        : fused_activation_function(ActivationFunctionType_NONE),
          weights_format(FullyConnectedOptionsWeightsFormat_DEFAULT),
          keep_num_dims(false)
    {
    }
};

struct FullyConnectedOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef FullyConnectedOptionsT NativeTableType;
    enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE
    {
        VT_FUSED_ACTIVATION_FUNCTION = 4,
        VT_WEIGHTS_FORMAT = 6,
        VT_KEEP_NUM_DIMS = 8
    };
    ActivationFunctionType fused_activation_function() const
    {
        return static_cast<ActivationFunctionType>(GetField<int8_t>(VT_FUSED_ACTIVATION_FUNCTION, 0));
    }
    FullyConnectedOptionsWeightsFormat weights_format() const
    {
        return static_cast<FullyConnectedOptionsWeightsFormat>(GetField<int8_t>(VT_WEIGHTS_FORMAT, 0));
    }
    bool keep_num_dims() const
    {
        return GetField<uint8_t>(VT_KEEP_NUM_DIMS, 0) != 0;
    }
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && VerifyField<int8_t>(verifier, VT_FUSED_ACTIVATION_FUNCTION) && VerifyField<int8_t>(verifier, VT_WEIGHTS_FORMAT) && VerifyField<uint8_t>(verifier, VT_KEEP_NUM_DIMS) && verifier.EndTable();
    }
    FullyConnectedOptionsT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(FullyConnectedOptionsT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<FullyConnectedOptions> Pack(flatbuffers::FlatBufferBuilder& _fbb, const FullyConnectedOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct FullyConnectedOptionsBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    void add_fused_activation_function(ActivationFunctionType fused_activation_function)
    {
        fbb_.AddElement<int8_t>(FullyConnectedOptions::VT_FUSED_ACTIVATION_FUNCTION, static_cast<int8_t>(fused_activation_function), 0);
    }
    void add_weights_format(FullyConnectedOptionsWeightsFormat weights_format)
    {
        fbb_.AddElement<int8_t>(FullyConnectedOptions::VT_WEIGHTS_FORMAT, static_cast<int8_t>(weights_format), 0);
    }
    void add_keep_num_dims(bool keep_num_dims)
    {
        fbb_.AddElement<uint8_t>(FullyConnectedOptions::VT_KEEP_NUM_DIMS, static_cast<uint8_t>(keep_num_dims), 0);
    }
    explicit FullyConnectedOptionsBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    FullyConnectedOptionsBuilder& operator=(const FullyConnectedOptionsBuilder&);
    flatbuffers::Offset<FullyConnectedOptions> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<FullyConnectedOptions>(end);
        return o;
    }
};

inline flatbuffers::Offset<FullyConnectedOptions> CreateFullyConnectedOptions(
    flatbuffers::FlatBufferBuilder& _fbb,
    ActivationFunctionType fused_activation_function = ActivationFunctionType_NONE,
    FullyConnectedOptionsWeightsFormat weights_format = FullyConnectedOptionsWeightsFormat_DEFAULT,
    bool keep_num_dims = false)
{
    FullyConnectedOptionsBuilder builder_(_fbb);
    builder_.add_keep_num_dims(keep_num_dims);
    builder_.add_weights_format(weights_format);
    builder_.add_fused_activation_function(fused_activation_function);
    return builder_.Finish();
}

flatbuffers::Offset<FullyConnectedOptions> CreateFullyConnectedOptions(flatbuffers::FlatBufferBuilder& _fbb, const FullyConnectedOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct SoftmaxOptionsT : public flatbuffers::NativeTable
{
    typedef SoftmaxOptions TableType;
    float beta;
    SoftmaxOptionsT()
        : beta(0.0f)
    {
    }
};

struct SoftmaxOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef SoftmaxOptionsT NativeTableType;
    enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE
    {
        VT_BETA = 4
    };
    float beta() const
    {
        return GetField<float>(VT_BETA, 0.0f);
    }
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && VerifyField<float>(verifier, VT_BETA) && verifier.EndTable();
    }
    SoftmaxOptionsT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(SoftmaxOptionsT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<SoftmaxOptions> Pack(flatbuffers::FlatBufferBuilder& _fbb, const SoftmaxOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct SoftmaxOptionsBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    void add_beta(float beta)
    {
        fbb_.AddElement<float>(SoftmaxOptions::VT_BETA, beta, 0.0f);
    }
    explicit SoftmaxOptionsBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    SoftmaxOptionsBuilder& operator=(const SoftmaxOptionsBuilder&);
    flatbuffers::Offset<SoftmaxOptions> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<SoftmaxOptions>(end);
        return o;
    }
};

inline flatbuffers::Offset<SoftmaxOptions> CreateSoftmaxOptions(
    flatbuffers::FlatBufferBuilder& _fbb,
    float beta = 0.0f)
{
    SoftmaxOptionsBuilder builder_(_fbb);
    builder_.add_beta(beta);
    return builder_.Finish();
}

flatbuffers::Offset<SoftmaxOptions> CreateSoftmaxOptions(flatbuffers::FlatBufferBuilder& _fbb, const SoftmaxOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct ConcatenationOptionsT : public flatbuffers::NativeTable
{
    typedef ConcatenationOptions TableType;
    int32_t axis;
    ActivationFunctionType fused_activation_function;
    ConcatenationOptionsT()
        : axis(0),
          fused_activation_function(ActivationFunctionType_NONE)
    {
    }
};

struct ConcatenationOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef ConcatenationOptionsT NativeTableType;
    enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE
    {
        VT_AXIS = 4,
        VT_FUSED_ACTIVATION_FUNCTION = 6
    };
    int32_t axis() const
    {
        return GetField<int32_t>(VT_AXIS, 0);
    }
    ActivationFunctionType fused_activation_function() const
    {
        return static_cast<ActivationFunctionType>(GetField<int8_t>(VT_FUSED_ACTIVATION_FUNCTION, 0));
    }
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && VerifyField<int32_t>(verifier, VT_AXIS) && VerifyField<int8_t>(verifier, VT_FUSED_ACTIVATION_FUNCTION) && verifier.EndTable();
    }
    ConcatenationOptionsT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(ConcatenationOptionsT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<ConcatenationOptions> Pack(flatbuffers::FlatBufferBuilder& _fbb, const ConcatenationOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct ConcatenationOptionsBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    void add_axis(int32_t axis)
    {
        fbb_.AddElement<int32_t>(ConcatenationOptions::VT_AXIS, axis, 0);
    }
    void add_fused_activation_function(ActivationFunctionType fused_activation_function)
    {
        fbb_.AddElement<int8_t>(ConcatenationOptions::VT_FUSED_ACTIVATION_FUNCTION, static_cast<int8_t>(fused_activation_function), 0);
    }
    explicit ConcatenationOptionsBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    ConcatenationOptionsBuilder& operator=(const ConcatenationOptionsBuilder&);
    flatbuffers::Offset<ConcatenationOptions> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<ConcatenationOptions>(end);
        return o;
    }
};

inline flatbuffers::Offset<ConcatenationOptions> CreateConcatenationOptions(
    flatbuffers::FlatBufferBuilder& _fbb,
    int32_t axis = 0,
    ActivationFunctionType fused_activation_function = ActivationFunctionType_NONE)
{
    ConcatenationOptionsBuilder builder_(_fbb);
    builder_.add_axis(axis);
    builder_.add_fused_activation_function(fused_activation_function);
    return builder_.Finish();
}

flatbuffers::Offset<ConcatenationOptions> CreateConcatenationOptions(flatbuffers::FlatBufferBuilder& _fbb, const ConcatenationOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct AddOptionsT : public flatbuffers::NativeTable
{
    typedef AddOptions TableType;
    ActivationFunctionType fused_activation_function;
    AddOptionsT()
        : fused_activation_function(ActivationFunctionType_NONE)
    {
    }
};

struct AddOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef AddOptionsT NativeTableType;
    enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE
    {
        VT_FUSED_ACTIVATION_FUNCTION = 4
    };
    ActivationFunctionType fused_activation_function() const
    {
        return static_cast<ActivationFunctionType>(GetField<int8_t>(VT_FUSED_ACTIVATION_FUNCTION, 0));
    }
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && VerifyField<int8_t>(verifier, VT_FUSED_ACTIVATION_FUNCTION) && verifier.EndTable();
    }
    AddOptionsT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(AddOptionsT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<AddOptions> Pack(flatbuffers::FlatBufferBuilder& _fbb, const AddOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct AddOptionsBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    void add_fused_activation_function(ActivationFunctionType fused_activation_function)
    {
        fbb_.AddElement<int8_t>(AddOptions::VT_FUSED_ACTIVATION_FUNCTION, static_cast<int8_t>(fused_activation_function), 0);
    }
    explicit AddOptionsBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    AddOptionsBuilder& operator=(const AddOptionsBuilder&);
    flatbuffers::Offset<AddOptions> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<AddOptions>(end);
        return o;
    }
};

inline flatbuffers::Offset<AddOptions> CreateAddOptions(
    flatbuffers::FlatBufferBuilder& _fbb,
    ActivationFunctionType fused_activation_function = ActivationFunctionType_NONE)
{
    AddOptionsBuilder builder_(_fbb);
    builder_.add_fused_activation_function(fused_activation_function);
    return builder_.Finish();
}

flatbuffers::Offset<AddOptions> CreateAddOptions(flatbuffers::FlatBufferBuilder& _fbb, const AddOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct MulOptionsT : public flatbuffers::NativeTable
{
    typedef MulOptions TableType;
    ActivationFunctionType fused_activation_function;
    MulOptionsT()
        : fused_activation_function(ActivationFunctionType_NONE)
    {
    }
};

struct MulOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef MulOptionsT NativeTableType;
    enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE
    {
        VT_FUSED_ACTIVATION_FUNCTION = 4
    };
    ActivationFunctionType fused_activation_function() const
    {
        return static_cast<ActivationFunctionType>(GetField<int8_t>(VT_FUSED_ACTIVATION_FUNCTION, 0));
    }
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && VerifyField<int8_t>(verifier, VT_FUSED_ACTIVATION_FUNCTION) && verifier.EndTable();
    }
    MulOptionsT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(MulOptionsT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<MulOptions> Pack(flatbuffers::FlatBufferBuilder& _fbb, const MulOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct MulOptionsBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    void add_fused_activation_function(ActivationFunctionType fused_activation_function)
    {
        fbb_.AddElement<int8_t>(MulOptions::VT_FUSED_ACTIVATION_FUNCTION, static_cast<int8_t>(fused_activation_function), 0);
    }
    explicit MulOptionsBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    MulOptionsBuilder& operator=(const MulOptionsBuilder&);
    flatbuffers::Offset<MulOptions> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<MulOptions>(end);
        return o;
    }
};

inline flatbuffers::Offset<MulOptions> CreateMulOptions(
    flatbuffers::FlatBufferBuilder& _fbb,
    ActivationFunctionType fused_activation_function = ActivationFunctionType_NONE)
{
    MulOptionsBuilder builder_(_fbb);
    builder_.add_fused_activation_function(fused_activation_function);
    return builder_.Finish();
}

flatbuffers::Offset<MulOptions> CreateMulOptions(flatbuffers::FlatBufferBuilder& _fbb, const MulOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct L2NormOptionsT : public flatbuffers::NativeTable
{
    typedef L2NormOptions TableType;
    ActivationFunctionType fused_activation_function;
    L2NormOptionsT()
        : fused_activation_function(ActivationFunctionType_NONE)
    {
    }
};

struct L2NormOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef L2NormOptionsT NativeTableType;
    enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE
    {
        VT_FUSED_ACTIVATION_FUNCTION = 4
    };
    ActivationFunctionType fused_activation_function() const
    {
        return static_cast<ActivationFunctionType>(GetField<int8_t>(VT_FUSED_ACTIVATION_FUNCTION, 0));
    }
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && VerifyField<int8_t>(verifier, VT_FUSED_ACTIVATION_FUNCTION) && verifier.EndTable();
    }
    L2NormOptionsT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(L2NormOptionsT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<L2NormOptions> Pack(flatbuffers::FlatBufferBuilder& _fbb, const L2NormOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct L2NormOptionsBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    void add_fused_activation_function(ActivationFunctionType fused_activation_function)
    {
        fbb_.AddElement<int8_t>(L2NormOptions::VT_FUSED_ACTIVATION_FUNCTION, static_cast<int8_t>(fused_activation_function), 0);
    }
    explicit L2NormOptionsBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    L2NormOptionsBuilder& operator=(const L2NormOptionsBuilder&);
    flatbuffers::Offset<L2NormOptions> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<L2NormOptions>(end);
        return o;
    }
};

inline flatbuffers::Offset<L2NormOptions> CreateL2NormOptions(
    flatbuffers::FlatBufferBuilder& _fbb,
    ActivationFunctionType fused_activation_function = ActivationFunctionType_NONE)
{
    L2NormOptionsBuilder builder_(_fbb);
    builder_.add_fused_activation_function(fused_activation_function);
    return builder_.Finish();
}

flatbuffers::Offset<L2NormOptions> CreateL2NormOptions(flatbuffers::FlatBufferBuilder& _fbb, const L2NormOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct LocalResponseNormalizationOptionsT : public flatbuffers::NativeTable
{
    typedef LocalResponseNormalizationOptions TableType;
    int32_t radius;
    float bias;
    float alpha;
    float beta;
    LocalResponseNormalizationOptionsT()
        : radius(0),
          bias(0.0f),
          alpha(0.0f),
          beta(0.0f)
    {
    }
};

struct LocalResponseNormalizationOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef LocalResponseNormalizationOptionsT NativeTableType;
    enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE
    {
        VT_RADIUS = 4,
        VT_BIAS = 6,
        VT_ALPHA = 8,
        VT_BETA = 10
    };
    int32_t radius() const
    {
        return GetField<int32_t>(VT_RADIUS, 0);
    }
    float bias() const
    {
        return GetField<float>(VT_BIAS, 0.0f);
    }
    float alpha() const
    {
        return GetField<float>(VT_ALPHA, 0.0f);
    }
    float beta() const
    {
        return GetField<float>(VT_BETA, 0.0f);
    }
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && VerifyField<int32_t>(verifier, VT_RADIUS) && VerifyField<float>(verifier, VT_BIAS) && VerifyField<float>(verifier, VT_ALPHA) && VerifyField<float>(verifier, VT_BETA) && verifier.EndTable();
    }
    LocalResponseNormalizationOptionsT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(LocalResponseNormalizationOptionsT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<LocalResponseNormalizationOptions> Pack(flatbuffers::FlatBufferBuilder& _fbb, const LocalResponseNormalizationOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct LocalResponseNormalizationOptionsBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    void add_radius(int32_t radius)
    {
        fbb_.AddElement<int32_t>(LocalResponseNormalizationOptions::VT_RADIUS, radius, 0);
    }
    void add_bias(float bias)
    {
        fbb_.AddElement<float>(LocalResponseNormalizationOptions::VT_BIAS, bias, 0.0f);
    }
    void add_alpha(float alpha)
    {
        fbb_.AddElement<float>(LocalResponseNormalizationOptions::VT_ALPHA, alpha, 0.0f);
    }
    void add_beta(float beta)
    {
        fbb_.AddElement<float>(LocalResponseNormalizationOptions::VT_BETA, beta, 0.0f);
    }
    explicit LocalResponseNormalizationOptionsBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    LocalResponseNormalizationOptionsBuilder& operator=(const LocalResponseNormalizationOptionsBuilder&);
    flatbuffers::Offset<LocalResponseNormalizationOptions> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<LocalResponseNormalizationOptions>(end);
        return o;
    }
};

inline flatbuffers::Offset<LocalResponseNormalizationOptions> CreateLocalResponseNormalizationOptions(
    flatbuffers::FlatBufferBuilder& _fbb,
    int32_t radius = 0,
    float bias = 0.0f,
    float alpha = 0.0f,
    float beta = 0.0f)
{
    LocalResponseNormalizationOptionsBuilder builder_(_fbb);
    builder_.add_beta(beta);
    builder_.add_alpha(alpha);
    builder_.add_bias(bias);
    builder_.add_radius(radius);
    return builder_.Finish();
}

flatbuffers::Offset<LocalResponseNormalizationOptions> CreateLocalResponseNormalizationOptions(flatbuffers::FlatBufferBuilder& _fbb, const LocalResponseNormalizationOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct LSTMOptionsT : public flatbuffers::NativeTable
{
    typedef LSTMOptions TableType;
    ActivationFunctionType fused_activation_function;
    float cell_clip;
    float proj_clip;
    LSTMKernelType kernel_type;
    LSTMOptionsT()
        : fused_activation_function(ActivationFunctionType_NONE),
          cell_clip(0.0f),
          proj_clip(0.0f),
          kernel_type(LSTMKernelType_FULL)
    {
    }
};

struct LSTMOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef LSTMOptionsT NativeTableType;
    enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE
    {
        VT_FUSED_ACTIVATION_FUNCTION = 4,
        VT_CELL_CLIP = 6,
        VT_PROJ_CLIP = 8,
        VT_KERNEL_TYPE = 10
    };
    ActivationFunctionType fused_activation_function() const
    {
        return static_cast<ActivationFunctionType>(GetField<int8_t>(VT_FUSED_ACTIVATION_FUNCTION, 0));
    }
    float cell_clip() const
    {
        return GetField<float>(VT_CELL_CLIP, 0.0f);
    }
    float proj_clip() const
    {
        return GetField<float>(VT_PROJ_CLIP, 0.0f);
    }
    LSTMKernelType kernel_type() const
    {
        return static_cast<LSTMKernelType>(GetField<int8_t>(VT_KERNEL_TYPE, 0));
    }
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && VerifyField<int8_t>(verifier, VT_FUSED_ACTIVATION_FUNCTION) && VerifyField<float>(verifier, VT_CELL_CLIP) && VerifyField<float>(verifier, VT_PROJ_CLIP) && VerifyField<int8_t>(verifier, VT_KERNEL_TYPE) && verifier.EndTable();
    }
    LSTMOptionsT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(LSTMOptionsT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<LSTMOptions> Pack(flatbuffers::FlatBufferBuilder& _fbb, const LSTMOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct LSTMOptionsBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    void add_fused_activation_function(ActivationFunctionType fused_activation_function)
    {
        fbb_.AddElement<int8_t>(LSTMOptions::VT_FUSED_ACTIVATION_FUNCTION, static_cast<int8_t>(fused_activation_function), 0);
    }
    void add_cell_clip(float cell_clip)
    {
        fbb_.AddElement<float>(LSTMOptions::VT_CELL_CLIP, cell_clip, 0.0f);
    }
    void add_proj_clip(float proj_clip)
    {
        fbb_.AddElement<float>(LSTMOptions::VT_PROJ_CLIP, proj_clip, 0.0f);
    }
    void add_kernel_type(LSTMKernelType kernel_type)
    {
        fbb_.AddElement<int8_t>(LSTMOptions::VT_KERNEL_TYPE, static_cast<int8_t>(kernel_type), 0);
    }
    explicit LSTMOptionsBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    LSTMOptionsBuilder& operator=(const LSTMOptionsBuilder&);
    flatbuffers::Offset<LSTMOptions> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<LSTMOptions>(end);
        return o;
    }
};

inline flatbuffers::Offset<LSTMOptions> CreateLSTMOptions(
    flatbuffers::FlatBufferBuilder& _fbb,
    ActivationFunctionType fused_activation_function = ActivationFunctionType_NONE,
    float cell_clip = 0.0f,
    float proj_clip = 0.0f,
    LSTMKernelType kernel_type = LSTMKernelType_FULL)
{
    LSTMOptionsBuilder builder_(_fbb);
    builder_.add_proj_clip(proj_clip);
    builder_.add_cell_clip(cell_clip);
    builder_.add_kernel_type(kernel_type);
    builder_.add_fused_activation_function(fused_activation_function);
    return builder_.Finish();
}

flatbuffers::Offset<LSTMOptions> CreateLSTMOptions(flatbuffers::FlatBufferBuilder& _fbb, const LSTMOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct UnidirectionalSequenceLSTMOptionsT : public flatbuffers::NativeTable
{
    typedef UnidirectionalSequenceLSTMOptions TableType;
    ActivationFunctionType fused_activation_function;
    float cell_clip;
    float proj_clip;
    bool time_major;
    UnidirectionalSequenceLSTMOptionsT()
        : fused_activation_function(ActivationFunctionType_NONE),
          cell_clip(0.0f),
          proj_clip(0.0f),
          time_major(false)
    {
    }
};

struct UnidirectionalSequenceLSTMOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef UnidirectionalSequenceLSTMOptionsT NativeTableType;
    enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE
    {
        VT_FUSED_ACTIVATION_FUNCTION = 4,
        VT_CELL_CLIP = 6,
        VT_PROJ_CLIP = 8,
        VT_TIME_MAJOR = 10
    };
    ActivationFunctionType fused_activation_function() const
    {
        return static_cast<ActivationFunctionType>(GetField<int8_t>(VT_FUSED_ACTIVATION_FUNCTION, 0));
    }
    float cell_clip() const
    {
        return GetField<float>(VT_CELL_CLIP, 0.0f);
    }
    float proj_clip() const
    {
        return GetField<float>(VT_PROJ_CLIP, 0.0f);
    }
    bool time_major() const
    {
        return GetField<uint8_t>(VT_TIME_MAJOR, 0) != 0;
    }
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && VerifyField<int8_t>(verifier, VT_FUSED_ACTIVATION_FUNCTION) && VerifyField<float>(verifier, VT_CELL_CLIP) && VerifyField<float>(verifier, VT_PROJ_CLIP) && VerifyField<uint8_t>(verifier, VT_TIME_MAJOR) && verifier.EndTable();
    }
    UnidirectionalSequenceLSTMOptionsT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(UnidirectionalSequenceLSTMOptionsT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<UnidirectionalSequenceLSTMOptions> Pack(flatbuffers::FlatBufferBuilder& _fbb, const UnidirectionalSequenceLSTMOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct UnidirectionalSequenceLSTMOptionsBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    void add_fused_activation_function(ActivationFunctionType fused_activation_function)
    {
        fbb_.AddElement<int8_t>(UnidirectionalSequenceLSTMOptions::VT_FUSED_ACTIVATION_FUNCTION, static_cast<int8_t>(fused_activation_function), 0);
    }
    void add_cell_clip(float cell_clip)
    {
        fbb_.AddElement<float>(UnidirectionalSequenceLSTMOptions::VT_CELL_CLIP, cell_clip, 0.0f);
    }
    void add_proj_clip(float proj_clip)
    {
        fbb_.AddElement<float>(UnidirectionalSequenceLSTMOptions::VT_PROJ_CLIP, proj_clip, 0.0f);
    }
    void add_time_major(bool time_major)
    {
        fbb_.AddElement<uint8_t>(UnidirectionalSequenceLSTMOptions::VT_TIME_MAJOR, static_cast<uint8_t>(time_major), 0);
    }
    explicit UnidirectionalSequenceLSTMOptionsBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    UnidirectionalSequenceLSTMOptionsBuilder& operator=(const UnidirectionalSequenceLSTMOptionsBuilder&);
    flatbuffers::Offset<UnidirectionalSequenceLSTMOptions> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<UnidirectionalSequenceLSTMOptions>(end);
        return o;
    }
};

inline flatbuffers::Offset<UnidirectionalSequenceLSTMOptions> CreateUnidirectionalSequenceLSTMOptions(
    flatbuffers::FlatBufferBuilder& _fbb,
    ActivationFunctionType fused_activation_function = ActivationFunctionType_NONE,
    float cell_clip = 0.0f,
    float proj_clip = 0.0f,
    bool time_major = false)
{
    UnidirectionalSequenceLSTMOptionsBuilder builder_(_fbb);
    builder_.add_proj_clip(proj_clip);
    builder_.add_cell_clip(cell_clip);
    builder_.add_time_major(time_major);
    builder_.add_fused_activation_function(fused_activation_function);
    return builder_.Finish();
}

flatbuffers::Offset<UnidirectionalSequenceLSTMOptions> CreateUnidirectionalSequenceLSTMOptions(flatbuffers::FlatBufferBuilder& _fbb, const UnidirectionalSequenceLSTMOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct BidirectionalSequenceLSTMOptionsT : public flatbuffers::NativeTable
{
    typedef BidirectionalSequenceLSTMOptions TableType;
    ActivationFunctionType fused_activation_function;
    float cell_clip;
    float proj_clip;
    bool merge_outputs;
    bool time_major;
    BidirectionalSequenceLSTMOptionsT()
        : fused_activation_function(ActivationFunctionType_NONE),
          cell_clip(0.0f),
          proj_clip(0.0f),
          merge_outputs(false),
          time_major(true)
    {
    }
};

struct BidirectionalSequenceLSTMOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef BidirectionalSequenceLSTMOptionsT NativeTableType;
    enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE
    {
        VT_FUSED_ACTIVATION_FUNCTION = 4,
        VT_CELL_CLIP = 6,
        VT_PROJ_CLIP = 8,
        VT_MERGE_OUTPUTS = 10,
        VT_TIME_MAJOR = 12
    };
    ActivationFunctionType fused_activation_function() const
    {
        return static_cast<ActivationFunctionType>(GetField<int8_t>(VT_FUSED_ACTIVATION_FUNCTION, 0));
    }
    float cell_clip() const
    {
        return GetField<float>(VT_CELL_CLIP, 0.0f);
    }
    float proj_clip() const
    {
        return GetField<float>(VT_PROJ_CLIP, 0.0f);
    }
    bool merge_outputs() const
    {
        return GetField<uint8_t>(VT_MERGE_OUTPUTS, 0) != 0;
    }
    bool time_major() const
    {
        return GetField<uint8_t>(VT_TIME_MAJOR, 1) != 0;
    }
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && VerifyField<int8_t>(verifier, VT_FUSED_ACTIVATION_FUNCTION) && VerifyField<float>(verifier, VT_CELL_CLIP) && VerifyField<float>(verifier, VT_PROJ_CLIP) && VerifyField<uint8_t>(verifier, VT_MERGE_OUTPUTS) && VerifyField<uint8_t>(verifier, VT_TIME_MAJOR) && verifier.EndTable();
    }
    BidirectionalSequenceLSTMOptionsT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(BidirectionalSequenceLSTMOptionsT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<BidirectionalSequenceLSTMOptions> Pack(flatbuffers::FlatBufferBuilder& _fbb, const BidirectionalSequenceLSTMOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct BidirectionalSequenceLSTMOptionsBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    void add_fused_activation_function(ActivationFunctionType fused_activation_function)
    {
        fbb_.AddElement<int8_t>(BidirectionalSequenceLSTMOptions::VT_FUSED_ACTIVATION_FUNCTION, static_cast<int8_t>(fused_activation_function), 0);
    }
    void add_cell_clip(float cell_clip)
    {
        fbb_.AddElement<float>(BidirectionalSequenceLSTMOptions::VT_CELL_CLIP, cell_clip, 0.0f);
    }
    void add_proj_clip(float proj_clip)
    {
        fbb_.AddElement<float>(BidirectionalSequenceLSTMOptions::VT_PROJ_CLIP, proj_clip, 0.0f);
    }
    void add_merge_outputs(bool merge_outputs)
    {
        fbb_.AddElement<uint8_t>(BidirectionalSequenceLSTMOptions::VT_MERGE_OUTPUTS, static_cast<uint8_t>(merge_outputs), 0);
    }
    void add_time_major(bool time_major)
    {
        fbb_.AddElement<uint8_t>(BidirectionalSequenceLSTMOptions::VT_TIME_MAJOR, static_cast<uint8_t>(time_major), 1);
    }
    explicit BidirectionalSequenceLSTMOptionsBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    BidirectionalSequenceLSTMOptionsBuilder& operator=(const BidirectionalSequenceLSTMOptionsBuilder&);
    flatbuffers::Offset<BidirectionalSequenceLSTMOptions> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<BidirectionalSequenceLSTMOptions>(end);
        return o;
    }
};

inline flatbuffers::Offset<BidirectionalSequenceLSTMOptions> CreateBidirectionalSequenceLSTMOptions(
    flatbuffers::FlatBufferBuilder& _fbb,
    ActivationFunctionType fused_activation_function = ActivationFunctionType_NONE,
    float cell_clip = 0.0f,
    float proj_clip = 0.0f,
    bool merge_outputs = false,
    bool time_major = true)
{
    BidirectionalSequenceLSTMOptionsBuilder builder_(_fbb);
    builder_.add_proj_clip(proj_clip);
    builder_.add_cell_clip(cell_clip);
    builder_.add_time_major(time_major);
    builder_.add_merge_outputs(merge_outputs);
    builder_.add_fused_activation_function(fused_activation_function);
    return builder_.Finish();
}

flatbuffers::Offset<BidirectionalSequenceLSTMOptions> CreateBidirectionalSequenceLSTMOptions(flatbuffers::FlatBufferBuilder& _fbb, const BidirectionalSequenceLSTMOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct ResizeBilinearOptionsT : public flatbuffers::NativeTable
{
    typedef ResizeBilinearOptions TableType;
    bool align_corners;
    ResizeBilinearOptionsT()
        : align_corners(false)
    {
    }
};

struct ResizeBilinearOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef ResizeBilinearOptionsT NativeTableType;
    enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE
    {
        VT_ALIGN_CORNERS = 8
    };
    bool align_corners() const
    {
        return GetField<uint8_t>(VT_ALIGN_CORNERS, 0) != 0;
    }
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && VerifyField<uint8_t>(verifier, VT_ALIGN_CORNERS) && verifier.EndTable();
    }
    ResizeBilinearOptionsT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(ResizeBilinearOptionsT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<ResizeBilinearOptions> Pack(flatbuffers::FlatBufferBuilder& _fbb, const ResizeBilinearOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct ResizeBilinearOptionsBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    void add_align_corners(bool align_corners)
    {
        fbb_.AddElement<uint8_t>(ResizeBilinearOptions::VT_ALIGN_CORNERS, static_cast<uint8_t>(align_corners), 0);
    }
    explicit ResizeBilinearOptionsBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    ResizeBilinearOptionsBuilder& operator=(const ResizeBilinearOptionsBuilder&);
    flatbuffers::Offset<ResizeBilinearOptions> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<ResizeBilinearOptions>(end);
        return o;
    }
};

inline flatbuffers::Offset<ResizeBilinearOptions> CreateResizeBilinearOptions(
    flatbuffers::FlatBufferBuilder& _fbb,
    bool align_corners = false)
{
    ResizeBilinearOptionsBuilder builder_(_fbb);
    builder_.add_align_corners(align_corners);
    return builder_.Finish();
}

flatbuffers::Offset<ResizeBilinearOptions> CreateResizeBilinearOptions(flatbuffers::FlatBufferBuilder& _fbb, const ResizeBilinearOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct ResizeNearestNeighborOptionsT : public flatbuffers::NativeTable
{
    typedef ResizeNearestNeighborOptions TableType;
    bool align_corners;
    ResizeNearestNeighborOptionsT()
        : align_corners(false)
    {
    }
};

struct ResizeNearestNeighborOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef ResizeNearestNeighborOptionsT NativeTableType;
    enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE
    {
        VT_ALIGN_CORNERS = 4
    };
    bool align_corners() const
    {
        return GetField<uint8_t>(VT_ALIGN_CORNERS, 0) != 0;
    }
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && VerifyField<uint8_t>(verifier, VT_ALIGN_CORNERS) && verifier.EndTable();
    }
    ResizeNearestNeighborOptionsT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(ResizeNearestNeighborOptionsT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<ResizeNearestNeighborOptions> Pack(flatbuffers::FlatBufferBuilder& _fbb, const ResizeNearestNeighborOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct ResizeNearestNeighborOptionsBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    void add_align_corners(bool align_corners)
    {
        fbb_.AddElement<uint8_t>(ResizeNearestNeighborOptions::VT_ALIGN_CORNERS, static_cast<uint8_t>(align_corners), 0);
    }
    explicit ResizeNearestNeighborOptionsBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    ResizeNearestNeighborOptionsBuilder& operator=(const ResizeNearestNeighborOptionsBuilder&);
    flatbuffers::Offset<ResizeNearestNeighborOptions> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<ResizeNearestNeighborOptions>(end);
        return o;
    }
};

inline flatbuffers::Offset<ResizeNearestNeighborOptions> CreateResizeNearestNeighborOptions(
    flatbuffers::FlatBufferBuilder& _fbb,
    bool align_corners = false)
{
    ResizeNearestNeighborOptionsBuilder builder_(_fbb);
    builder_.add_align_corners(align_corners);
    return builder_.Finish();
}

flatbuffers::Offset<ResizeNearestNeighborOptions> CreateResizeNearestNeighborOptions(flatbuffers::FlatBufferBuilder& _fbb, const ResizeNearestNeighborOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct CallOptionsT : public flatbuffers::NativeTable
{
    typedef CallOptions TableType;
    uint32_t subgraph;
    CallOptionsT()
        : subgraph(0)
    {
    }
};

struct CallOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef CallOptionsT NativeTableType;
    enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE
    {
        VT_SUBGRAPH = 4
    };
    uint32_t subgraph() const
    {
        return GetField<uint32_t>(VT_SUBGRAPH, 0);
    }
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && VerifyField<uint32_t>(verifier, VT_SUBGRAPH) && verifier.EndTable();
    }
    CallOptionsT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(CallOptionsT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<CallOptions> Pack(flatbuffers::FlatBufferBuilder& _fbb, const CallOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct CallOptionsBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    void add_subgraph(uint32_t subgraph)
    {
        fbb_.AddElement<uint32_t>(CallOptions::VT_SUBGRAPH, subgraph, 0);
    }
    explicit CallOptionsBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    CallOptionsBuilder& operator=(const CallOptionsBuilder&);
    flatbuffers::Offset<CallOptions> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<CallOptions>(end);
        return o;
    }
};

inline flatbuffers::Offset<CallOptions> CreateCallOptions(
    flatbuffers::FlatBufferBuilder& _fbb,
    uint32_t subgraph = 0)
{
    CallOptionsBuilder builder_(_fbb);
    builder_.add_subgraph(subgraph);
    return builder_.Finish();
}

flatbuffers::Offset<CallOptions> CreateCallOptions(flatbuffers::FlatBufferBuilder& _fbb, const CallOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct PadOptionsT : public flatbuffers::NativeTable
{
    typedef PadOptions TableType;
    PadOptionsT()
    {
    }
};

struct PadOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef PadOptionsT NativeTableType;
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && verifier.EndTable();
    }
    PadOptionsT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(PadOptionsT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<PadOptions> Pack(flatbuffers::FlatBufferBuilder& _fbb, const PadOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct PadOptionsBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    explicit PadOptionsBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    PadOptionsBuilder& operator=(const PadOptionsBuilder&);
    flatbuffers::Offset<PadOptions> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<PadOptions>(end);
        return o;
    }
};

inline flatbuffers::Offset<PadOptions> CreatePadOptions(
    flatbuffers::FlatBufferBuilder& _fbb)
{
    PadOptionsBuilder builder_(_fbb);
    return builder_.Finish();
}

flatbuffers::Offset<PadOptions> CreatePadOptions(flatbuffers::FlatBufferBuilder& _fbb, const PadOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct PadV2OptionsT : public flatbuffers::NativeTable
{
    typedef PadV2Options TableType;
    PadV2OptionsT()
    {
    }
};

struct PadV2Options FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef PadV2OptionsT NativeTableType;
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && verifier.EndTable();
    }
    PadV2OptionsT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(PadV2OptionsT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<PadV2Options> Pack(flatbuffers::FlatBufferBuilder& _fbb, const PadV2OptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct PadV2OptionsBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    explicit PadV2OptionsBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    PadV2OptionsBuilder& operator=(const PadV2OptionsBuilder&);
    flatbuffers::Offset<PadV2Options> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<PadV2Options>(end);
        return o;
    }
};

inline flatbuffers::Offset<PadV2Options> CreatePadV2Options(
    flatbuffers::FlatBufferBuilder& _fbb)
{
    PadV2OptionsBuilder builder_(_fbb);
    return builder_.Finish();
}

flatbuffers::Offset<PadV2Options> CreatePadV2Options(flatbuffers::FlatBufferBuilder& _fbb, const PadV2OptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct ReshapeOptionsT : public flatbuffers::NativeTable
{
    typedef ReshapeOptions TableType;
    std::vector<int32_t> new_shape;
    ReshapeOptionsT()
    {
    }
};

struct ReshapeOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef ReshapeOptionsT NativeTableType;
    enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE
    {
        VT_NEW_SHAPE = 4
    };
    const flatbuffers::Vector<int32_t>* new_shape() const
    {
        return GetPointer<const flatbuffers::Vector<int32_t>*>(VT_NEW_SHAPE);
    }
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && VerifyOffset(verifier, VT_NEW_SHAPE) && verifier.VerifyVector(new_shape()) && verifier.EndTable();
    }
    ReshapeOptionsT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(ReshapeOptionsT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<ReshapeOptions> Pack(flatbuffers::FlatBufferBuilder& _fbb, const ReshapeOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct ReshapeOptionsBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    void add_new_shape(flatbuffers::Offset<flatbuffers::Vector<int32_t> > new_shape)
    {
        fbb_.AddOffset(ReshapeOptions::VT_NEW_SHAPE, new_shape);
    }
    explicit ReshapeOptionsBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    ReshapeOptionsBuilder& operator=(const ReshapeOptionsBuilder&);
    flatbuffers::Offset<ReshapeOptions> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<ReshapeOptions>(end);
        return o;
    }
};

inline flatbuffers::Offset<ReshapeOptions> CreateReshapeOptions(
    flatbuffers::FlatBufferBuilder& _fbb,
    flatbuffers::Offset<flatbuffers::Vector<int32_t> > new_shape = 0)
{
    ReshapeOptionsBuilder builder_(_fbb);
    builder_.add_new_shape(new_shape);
    return builder_.Finish();
}

inline flatbuffers::Offset<ReshapeOptions> CreateReshapeOptionsDirect(
    flatbuffers::FlatBufferBuilder& _fbb,
    const std::vector<int32_t>* new_shape = nullptr)
{
    auto new_shape__ = new_shape ? _fbb.CreateVector<int32_t>(*new_shape) : 0;
    return tflite::CreateReshapeOptions(
        _fbb,
        new_shape__);
}

flatbuffers::Offset<ReshapeOptions> CreateReshapeOptions(flatbuffers::FlatBufferBuilder& _fbb, const ReshapeOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct SpaceToBatchNDOptionsT : public flatbuffers::NativeTable
{
    typedef SpaceToBatchNDOptions TableType;
    SpaceToBatchNDOptionsT()
    {
    }
};

struct SpaceToBatchNDOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef SpaceToBatchNDOptionsT NativeTableType;
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && verifier.EndTable();
    }
    SpaceToBatchNDOptionsT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(SpaceToBatchNDOptionsT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<SpaceToBatchNDOptions> Pack(flatbuffers::FlatBufferBuilder& _fbb, const SpaceToBatchNDOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct SpaceToBatchNDOptionsBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    explicit SpaceToBatchNDOptionsBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    SpaceToBatchNDOptionsBuilder& operator=(const SpaceToBatchNDOptionsBuilder&);
    flatbuffers::Offset<SpaceToBatchNDOptions> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<SpaceToBatchNDOptions>(end);
        return o;
    }
};

inline flatbuffers::Offset<SpaceToBatchNDOptions> CreateSpaceToBatchNDOptions(
    flatbuffers::FlatBufferBuilder& _fbb)
{
    SpaceToBatchNDOptionsBuilder builder_(_fbb);
    return builder_.Finish();
}

flatbuffers::Offset<SpaceToBatchNDOptions> CreateSpaceToBatchNDOptions(flatbuffers::FlatBufferBuilder& _fbb, const SpaceToBatchNDOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct BatchToSpaceNDOptionsT : public flatbuffers::NativeTable
{
    typedef BatchToSpaceNDOptions TableType;
    BatchToSpaceNDOptionsT()
    {
    }
};

struct BatchToSpaceNDOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef BatchToSpaceNDOptionsT NativeTableType;
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && verifier.EndTable();
    }
    BatchToSpaceNDOptionsT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(BatchToSpaceNDOptionsT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<BatchToSpaceNDOptions> Pack(flatbuffers::FlatBufferBuilder& _fbb, const BatchToSpaceNDOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct BatchToSpaceNDOptionsBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    explicit BatchToSpaceNDOptionsBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    BatchToSpaceNDOptionsBuilder& operator=(const BatchToSpaceNDOptionsBuilder&);
    flatbuffers::Offset<BatchToSpaceNDOptions> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<BatchToSpaceNDOptions>(end);
        return o;
    }
};

inline flatbuffers::Offset<BatchToSpaceNDOptions> CreateBatchToSpaceNDOptions(
    flatbuffers::FlatBufferBuilder& _fbb)
{
    BatchToSpaceNDOptionsBuilder builder_(_fbb);
    return builder_.Finish();
}

flatbuffers::Offset<BatchToSpaceNDOptions> CreateBatchToSpaceNDOptions(flatbuffers::FlatBufferBuilder& _fbb, const BatchToSpaceNDOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct SkipGramOptionsT : public flatbuffers::NativeTable
{
    typedef SkipGramOptions TableType;
    int32_t ngram_size;
    int32_t max_skip_size;
    bool include_all_ngrams;
    SkipGramOptionsT()
        : ngram_size(0),
          max_skip_size(0),
          include_all_ngrams(false)
    {
    }
};

struct SkipGramOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef SkipGramOptionsT NativeTableType;
    enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE
    {
        VT_NGRAM_SIZE = 4,
        VT_MAX_SKIP_SIZE = 6,
        VT_INCLUDE_ALL_NGRAMS = 8
    };
    int32_t ngram_size() const
    {
        return GetField<int32_t>(VT_NGRAM_SIZE, 0);
    }
    int32_t max_skip_size() const
    {
        return GetField<int32_t>(VT_MAX_SKIP_SIZE, 0);
    }
    bool include_all_ngrams() const
    {
        return GetField<uint8_t>(VT_INCLUDE_ALL_NGRAMS, 0) != 0;
    }
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && VerifyField<int32_t>(verifier, VT_NGRAM_SIZE) && VerifyField<int32_t>(verifier, VT_MAX_SKIP_SIZE) && VerifyField<uint8_t>(verifier, VT_INCLUDE_ALL_NGRAMS) && verifier.EndTable();
    }
    SkipGramOptionsT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(SkipGramOptionsT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<SkipGramOptions> Pack(flatbuffers::FlatBufferBuilder& _fbb, const SkipGramOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct SkipGramOptionsBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    void add_ngram_size(int32_t ngram_size)
    {
        fbb_.AddElement<int32_t>(SkipGramOptions::VT_NGRAM_SIZE, ngram_size, 0);
    }
    void add_max_skip_size(int32_t max_skip_size)
    {
        fbb_.AddElement<int32_t>(SkipGramOptions::VT_MAX_SKIP_SIZE, max_skip_size, 0);
    }
    void add_include_all_ngrams(bool include_all_ngrams)
    {
        fbb_.AddElement<uint8_t>(SkipGramOptions::VT_INCLUDE_ALL_NGRAMS, static_cast<uint8_t>(include_all_ngrams), 0);
    }
    explicit SkipGramOptionsBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    SkipGramOptionsBuilder& operator=(const SkipGramOptionsBuilder&);
    flatbuffers::Offset<SkipGramOptions> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<SkipGramOptions>(end);
        return o;
    }
};

inline flatbuffers::Offset<SkipGramOptions> CreateSkipGramOptions(
    flatbuffers::FlatBufferBuilder& _fbb,
    int32_t ngram_size = 0,
    int32_t max_skip_size = 0,
    bool include_all_ngrams = false)
{
    SkipGramOptionsBuilder builder_(_fbb);
    builder_.add_max_skip_size(max_skip_size);
    builder_.add_ngram_size(ngram_size);
    builder_.add_include_all_ngrams(include_all_ngrams);
    return builder_.Finish();
}

flatbuffers::Offset<SkipGramOptions> CreateSkipGramOptions(flatbuffers::FlatBufferBuilder& _fbb, const SkipGramOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct SpaceToDepthOptionsT : public flatbuffers::NativeTable
{
    typedef SpaceToDepthOptions TableType;
    int32_t block_size;
    SpaceToDepthOptionsT()
        : block_size(0)
    {
    }
};

struct SpaceToDepthOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef SpaceToDepthOptionsT NativeTableType;
    enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE
    {
        VT_BLOCK_SIZE = 4
    };
    int32_t block_size() const
    {
        return GetField<int32_t>(VT_BLOCK_SIZE, 0);
    }
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && VerifyField<int32_t>(verifier, VT_BLOCK_SIZE) && verifier.EndTable();
    }
    SpaceToDepthOptionsT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(SpaceToDepthOptionsT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<SpaceToDepthOptions> Pack(flatbuffers::FlatBufferBuilder& _fbb, const SpaceToDepthOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct SpaceToDepthOptionsBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    void add_block_size(int32_t block_size)
    {
        fbb_.AddElement<int32_t>(SpaceToDepthOptions::VT_BLOCK_SIZE, block_size, 0);
    }
    explicit SpaceToDepthOptionsBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    SpaceToDepthOptionsBuilder& operator=(const SpaceToDepthOptionsBuilder&);
    flatbuffers::Offset<SpaceToDepthOptions> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<SpaceToDepthOptions>(end);
        return o;
    }
};

inline flatbuffers::Offset<SpaceToDepthOptions> CreateSpaceToDepthOptions(
    flatbuffers::FlatBufferBuilder& _fbb,
    int32_t block_size = 0)
{
    SpaceToDepthOptionsBuilder builder_(_fbb);
    builder_.add_block_size(block_size);
    return builder_.Finish();
}

flatbuffers::Offset<SpaceToDepthOptions> CreateSpaceToDepthOptions(flatbuffers::FlatBufferBuilder& _fbb, const SpaceToDepthOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct SubOptionsT : public flatbuffers::NativeTable
{
    typedef SubOptions TableType;
    ActivationFunctionType fused_activation_function;
    SubOptionsT()
        : fused_activation_function(ActivationFunctionType_NONE)
    {
    }
};

struct SubOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef SubOptionsT NativeTableType;
    enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE
    {
        VT_FUSED_ACTIVATION_FUNCTION = 4
    };
    ActivationFunctionType fused_activation_function() const
    {
        return static_cast<ActivationFunctionType>(GetField<int8_t>(VT_FUSED_ACTIVATION_FUNCTION, 0));
    }
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && VerifyField<int8_t>(verifier, VT_FUSED_ACTIVATION_FUNCTION) && verifier.EndTable();
    }
    SubOptionsT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(SubOptionsT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<SubOptions> Pack(flatbuffers::FlatBufferBuilder& _fbb, const SubOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct SubOptionsBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    void add_fused_activation_function(ActivationFunctionType fused_activation_function)
    {
        fbb_.AddElement<int8_t>(SubOptions::VT_FUSED_ACTIVATION_FUNCTION, static_cast<int8_t>(fused_activation_function), 0);
    }
    explicit SubOptionsBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    SubOptionsBuilder& operator=(const SubOptionsBuilder&);
    flatbuffers::Offset<SubOptions> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<SubOptions>(end);
        return o;
    }
};

inline flatbuffers::Offset<SubOptions> CreateSubOptions(
    flatbuffers::FlatBufferBuilder& _fbb,
    ActivationFunctionType fused_activation_function = ActivationFunctionType_NONE)
{
    SubOptionsBuilder builder_(_fbb);
    builder_.add_fused_activation_function(fused_activation_function);
    return builder_.Finish();
}

flatbuffers::Offset<SubOptions> CreateSubOptions(flatbuffers::FlatBufferBuilder& _fbb, const SubOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct DivOptionsT : public flatbuffers::NativeTable
{
    typedef DivOptions TableType;
    ActivationFunctionType fused_activation_function;
    DivOptionsT()
        : fused_activation_function(ActivationFunctionType_NONE)
    {
    }
};

struct DivOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef DivOptionsT NativeTableType;
    enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE
    {
        VT_FUSED_ACTIVATION_FUNCTION = 4
    };
    ActivationFunctionType fused_activation_function() const
    {
        return static_cast<ActivationFunctionType>(GetField<int8_t>(VT_FUSED_ACTIVATION_FUNCTION, 0));
    }
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && VerifyField<int8_t>(verifier, VT_FUSED_ACTIVATION_FUNCTION) && verifier.EndTable();
    }
    DivOptionsT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(DivOptionsT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<DivOptions> Pack(flatbuffers::FlatBufferBuilder& _fbb, const DivOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct DivOptionsBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    void add_fused_activation_function(ActivationFunctionType fused_activation_function)
    {
        fbb_.AddElement<int8_t>(DivOptions::VT_FUSED_ACTIVATION_FUNCTION, static_cast<int8_t>(fused_activation_function), 0);
    }
    explicit DivOptionsBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    DivOptionsBuilder& operator=(const DivOptionsBuilder&);
    flatbuffers::Offset<DivOptions> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<DivOptions>(end);
        return o;
    }
};

inline flatbuffers::Offset<DivOptions> CreateDivOptions(
    flatbuffers::FlatBufferBuilder& _fbb,
    ActivationFunctionType fused_activation_function = ActivationFunctionType_NONE)
{
    DivOptionsBuilder builder_(_fbb);
    builder_.add_fused_activation_function(fused_activation_function);
    return builder_.Finish();
}

flatbuffers::Offset<DivOptions> CreateDivOptions(flatbuffers::FlatBufferBuilder& _fbb, const DivOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct TopKV2OptionsT : public flatbuffers::NativeTable
{
    typedef TopKV2Options TableType;
    TopKV2OptionsT()
    {
    }
};

struct TopKV2Options FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef TopKV2OptionsT NativeTableType;
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && verifier.EndTable();
    }
    TopKV2OptionsT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(TopKV2OptionsT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<TopKV2Options> Pack(flatbuffers::FlatBufferBuilder& _fbb, const TopKV2OptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct TopKV2OptionsBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    explicit TopKV2OptionsBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    TopKV2OptionsBuilder& operator=(const TopKV2OptionsBuilder&);
    flatbuffers::Offset<TopKV2Options> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<TopKV2Options>(end);
        return o;
    }
};

inline flatbuffers::Offset<TopKV2Options> CreateTopKV2Options(
    flatbuffers::FlatBufferBuilder& _fbb)
{
    TopKV2OptionsBuilder builder_(_fbb);
    return builder_.Finish();
}

flatbuffers::Offset<TopKV2Options> CreateTopKV2Options(flatbuffers::FlatBufferBuilder& _fbb, const TopKV2OptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct EmbeddingLookupSparseOptionsT : public flatbuffers::NativeTable
{
    typedef EmbeddingLookupSparseOptions TableType;
    CombinerType combiner;
    EmbeddingLookupSparseOptionsT()
        : combiner(CombinerType_SUM)
    {
    }
};

struct EmbeddingLookupSparseOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef EmbeddingLookupSparseOptionsT NativeTableType;
    enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE
    {
        VT_COMBINER = 4
    };
    CombinerType combiner() const
    {
        return static_cast<CombinerType>(GetField<int8_t>(VT_COMBINER, 0));
    }
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && VerifyField<int8_t>(verifier, VT_COMBINER) && verifier.EndTable();
    }
    EmbeddingLookupSparseOptionsT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(EmbeddingLookupSparseOptionsT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<EmbeddingLookupSparseOptions> Pack(flatbuffers::FlatBufferBuilder& _fbb, const EmbeddingLookupSparseOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct EmbeddingLookupSparseOptionsBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    void add_combiner(CombinerType combiner)
    {
        fbb_.AddElement<int8_t>(EmbeddingLookupSparseOptions::VT_COMBINER, static_cast<int8_t>(combiner), 0);
    }
    explicit EmbeddingLookupSparseOptionsBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    EmbeddingLookupSparseOptionsBuilder& operator=(const EmbeddingLookupSparseOptionsBuilder&);
    flatbuffers::Offset<EmbeddingLookupSparseOptions> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<EmbeddingLookupSparseOptions>(end);
        return o;
    }
};

inline flatbuffers::Offset<EmbeddingLookupSparseOptions> CreateEmbeddingLookupSparseOptions(
    flatbuffers::FlatBufferBuilder& _fbb,
    CombinerType combiner = CombinerType_SUM)
{
    EmbeddingLookupSparseOptionsBuilder builder_(_fbb);
    builder_.add_combiner(combiner);
    return builder_.Finish();
}

flatbuffers::Offset<EmbeddingLookupSparseOptions> CreateEmbeddingLookupSparseOptions(flatbuffers::FlatBufferBuilder& _fbb, const EmbeddingLookupSparseOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct GatherOptionsT : public flatbuffers::NativeTable
{
    typedef GatherOptions TableType;
    int32_t axis;
    GatherOptionsT()
        : axis(0)
    {
    }
};

struct GatherOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef GatherOptionsT NativeTableType;
    enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE
    {
        VT_AXIS = 4
    };
    int32_t axis() const
    {
        return GetField<int32_t>(VT_AXIS, 0);
    }
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && VerifyField<int32_t>(verifier, VT_AXIS) && verifier.EndTable();
    }
    GatherOptionsT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(GatherOptionsT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<GatherOptions> Pack(flatbuffers::FlatBufferBuilder& _fbb, const GatherOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct GatherOptionsBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    void add_axis(int32_t axis)
    {
        fbb_.AddElement<int32_t>(GatherOptions::VT_AXIS, axis, 0);
    }
    explicit GatherOptionsBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    GatherOptionsBuilder& operator=(const GatherOptionsBuilder&);
    flatbuffers::Offset<GatherOptions> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<GatherOptions>(end);
        return o;
    }
};

inline flatbuffers::Offset<GatherOptions> CreateGatherOptions(
    flatbuffers::FlatBufferBuilder& _fbb,
    int32_t axis = 0)
{
    GatherOptionsBuilder builder_(_fbb);
    builder_.add_axis(axis);
    return builder_.Finish();
}

flatbuffers::Offset<GatherOptions> CreateGatherOptions(flatbuffers::FlatBufferBuilder& _fbb, const GatherOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct TransposeOptionsT : public flatbuffers::NativeTable
{
    typedef TransposeOptions TableType;
    TransposeOptionsT()
    {
    }
};

struct TransposeOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef TransposeOptionsT NativeTableType;
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && verifier.EndTable();
    }
    TransposeOptionsT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(TransposeOptionsT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<TransposeOptions> Pack(flatbuffers::FlatBufferBuilder& _fbb, const TransposeOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct TransposeOptionsBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    explicit TransposeOptionsBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    TransposeOptionsBuilder& operator=(const TransposeOptionsBuilder&);
    flatbuffers::Offset<TransposeOptions> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<TransposeOptions>(end);
        return o;
    }
};

inline flatbuffers::Offset<TransposeOptions> CreateTransposeOptions(
    flatbuffers::FlatBufferBuilder& _fbb)
{
    TransposeOptionsBuilder builder_(_fbb);
    return builder_.Finish();
}

flatbuffers::Offset<TransposeOptions> CreateTransposeOptions(flatbuffers::FlatBufferBuilder& _fbb, const TransposeOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct ExpOptionsT : public flatbuffers::NativeTable
{
    typedef ExpOptions TableType;
    ExpOptionsT()
    {
    }
};

struct ExpOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef ExpOptionsT NativeTableType;
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && verifier.EndTable();
    }
    ExpOptionsT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(ExpOptionsT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<ExpOptions> Pack(flatbuffers::FlatBufferBuilder& _fbb, const ExpOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct ExpOptionsBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    explicit ExpOptionsBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    ExpOptionsBuilder& operator=(const ExpOptionsBuilder&);
    flatbuffers::Offset<ExpOptions> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<ExpOptions>(end);
        return o;
    }
};

inline flatbuffers::Offset<ExpOptions> CreateExpOptions(
    flatbuffers::FlatBufferBuilder& _fbb)
{
    ExpOptionsBuilder builder_(_fbb);
    return builder_.Finish();
}

flatbuffers::Offset<ExpOptions> CreateExpOptions(flatbuffers::FlatBufferBuilder& _fbb, const ExpOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct CosOptionsT : public flatbuffers::NativeTable
{
    typedef CosOptions TableType;
    CosOptionsT()
    {
    }
};

struct CosOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef CosOptionsT NativeTableType;
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && verifier.EndTable();
    }
    CosOptionsT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(CosOptionsT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<CosOptions> Pack(flatbuffers::FlatBufferBuilder& _fbb, const CosOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct CosOptionsBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    explicit CosOptionsBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    CosOptionsBuilder& operator=(const CosOptionsBuilder&);
    flatbuffers::Offset<CosOptions> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<CosOptions>(end);
        return o;
    }
};

inline flatbuffers::Offset<CosOptions> CreateCosOptions(
    flatbuffers::FlatBufferBuilder& _fbb)
{
    CosOptionsBuilder builder_(_fbb);
    return builder_.Finish();
}

flatbuffers::Offset<CosOptions> CreateCosOptions(flatbuffers::FlatBufferBuilder& _fbb, const CosOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct ReducerOptionsT : public flatbuffers::NativeTable
{
    typedef ReducerOptions TableType;
    bool keep_dims;
    ReducerOptionsT()
        : keep_dims(false)
    {
    }
};

struct ReducerOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef ReducerOptionsT NativeTableType;
    enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE
    {
        VT_KEEP_DIMS = 4
    };
    bool keep_dims() const
    {
        return GetField<uint8_t>(VT_KEEP_DIMS, 0) != 0;
    }
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && VerifyField<uint8_t>(verifier, VT_KEEP_DIMS) && verifier.EndTable();
    }
    ReducerOptionsT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(ReducerOptionsT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<ReducerOptions> Pack(flatbuffers::FlatBufferBuilder& _fbb, const ReducerOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct ReducerOptionsBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    void add_keep_dims(bool keep_dims)
    {
        fbb_.AddElement<uint8_t>(ReducerOptions::VT_KEEP_DIMS, static_cast<uint8_t>(keep_dims), 0);
    }
    explicit ReducerOptionsBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    ReducerOptionsBuilder& operator=(const ReducerOptionsBuilder&);
    flatbuffers::Offset<ReducerOptions> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<ReducerOptions>(end);
        return o;
    }
};

inline flatbuffers::Offset<ReducerOptions> CreateReducerOptions(
    flatbuffers::FlatBufferBuilder& _fbb,
    bool keep_dims = false)
{
    ReducerOptionsBuilder builder_(_fbb);
    builder_.add_keep_dims(keep_dims);
    return builder_.Finish();
}

flatbuffers::Offset<ReducerOptions> CreateReducerOptions(flatbuffers::FlatBufferBuilder& _fbb, const ReducerOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct SqueezeOptionsT : public flatbuffers::NativeTable
{
    typedef SqueezeOptions TableType;
    std::vector<int32_t> squeeze_dims;
    SqueezeOptionsT()
    {
    }
};

struct SqueezeOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef SqueezeOptionsT NativeTableType;
    enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE
    {
        VT_SQUEEZE_DIMS = 4
    };
    const flatbuffers::Vector<int32_t>* squeeze_dims() const
    {
        return GetPointer<const flatbuffers::Vector<int32_t>*>(VT_SQUEEZE_DIMS);
    }
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && VerifyOffset(verifier, VT_SQUEEZE_DIMS) && verifier.VerifyVector(squeeze_dims()) && verifier.EndTable();
    }
    SqueezeOptionsT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(SqueezeOptionsT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<SqueezeOptions> Pack(flatbuffers::FlatBufferBuilder& _fbb, const SqueezeOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct SqueezeOptionsBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    void add_squeeze_dims(flatbuffers::Offset<flatbuffers::Vector<int32_t> > squeeze_dims)
    {
        fbb_.AddOffset(SqueezeOptions::VT_SQUEEZE_DIMS, squeeze_dims);
    }
    explicit SqueezeOptionsBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    SqueezeOptionsBuilder& operator=(const SqueezeOptionsBuilder&);
    flatbuffers::Offset<SqueezeOptions> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<SqueezeOptions>(end);
        return o;
    }
};

inline flatbuffers::Offset<SqueezeOptions> CreateSqueezeOptions(
    flatbuffers::FlatBufferBuilder& _fbb,
    flatbuffers::Offset<flatbuffers::Vector<int32_t> > squeeze_dims = 0)
{
    SqueezeOptionsBuilder builder_(_fbb);
    builder_.add_squeeze_dims(squeeze_dims);
    return builder_.Finish();
}

inline flatbuffers::Offset<SqueezeOptions> CreateSqueezeOptionsDirect(
    flatbuffers::FlatBufferBuilder& _fbb,
    const std::vector<int32_t>* squeeze_dims = nullptr)
{
    auto squeeze_dims__ = squeeze_dims ? _fbb.CreateVector<int32_t>(*squeeze_dims) : 0;
    return tflite::CreateSqueezeOptions(
        _fbb,
        squeeze_dims__);
}

flatbuffers::Offset<SqueezeOptions> CreateSqueezeOptions(flatbuffers::FlatBufferBuilder& _fbb, const SqueezeOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct SplitOptionsT : public flatbuffers::NativeTable
{
    typedef SplitOptions TableType;
    int32_t num_splits;
    SplitOptionsT()
        : num_splits(0)
    {
    }
};

struct SplitOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef SplitOptionsT NativeTableType;
    enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE
    {
        VT_NUM_SPLITS = 4
    };
    int32_t num_splits() const
    {
        return GetField<int32_t>(VT_NUM_SPLITS, 0);
    }
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && VerifyField<int32_t>(verifier, VT_NUM_SPLITS) && verifier.EndTable();
    }
    SplitOptionsT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(SplitOptionsT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<SplitOptions> Pack(flatbuffers::FlatBufferBuilder& _fbb, const SplitOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct SplitOptionsBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    void add_num_splits(int32_t num_splits)
    {
        fbb_.AddElement<int32_t>(SplitOptions::VT_NUM_SPLITS, num_splits, 0);
    }
    explicit SplitOptionsBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    SplitOptionsBuilder& operator=(const SplitOptionsBuilder&);
    flatbuffers::Offset<SplitOptions> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<SplitOptions>(end);
        return o;
    }
};

inline flatbuffers::Offset<SplitOptions> CreateSplitOptions(
    flatbuffers::FlatBufferBuilder& _fbb,
    int32_t num_splits = 0)
{
    SplitOptionsBuilder builder_(_fbb);
    builder_.add_num_splits(num_splits);
    return builder_.Finish();
}

flatbuffers::Offset<SplitOptions> CreateSplitOptions(flatbuffers::FlatBufferBuilder& _fbb, const SplitOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct SplitVOptionsT : public flatbuffers::NativeTable
{
    typedef SplitVOptions TableType;
    int32_t num_splits;
    SplitVOptionsT()
        : num_splits(0)
    {
    }
};

struct SplitVOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef SplitVOptionsT NativeTableType;
    enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE
    {
        VT_NUM_SPLITS = 4
    };
    int32_t num_splits() const
    {
        return GetField<int32_t>(VT_NUM_SPLITS, 0);
    }
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && VerifyField<int32_t>(verifier, VT_NUM_SPLITS) && verifier.EndTable();
    }
    SplitVOptionsT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(SplitVOptionsT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<SplitVOptions> Pack(flatbuffers::FlatBufferBuilder& _fbb, const SplitVOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct SplitVOptionsBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    void add_num_splits(int32_t num_splits)
    {
        fbb_.AddElement<int32_t>(SplitVOptions::VT_NUM_SPLITS, num_splits, 0);
    }
    explicit SplitVOptionsBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    SplitVOptionsBuilder& operator=(const SplitVOptionsBuilder&);
    flatbuffers::Offset<SplitVOptions> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<SplitVOptions>(end);
        return o;
    }
};

inline flatbuffers::Offset<SplitVOptions> CreateSplitVOptions(
    flatbuffers::FlatBufferBuilder& _fbb,
    int32_t num_splits = 0)
{
    SplitVOptionsBuilder builder_(_fbb);
    builder_.add_num_splits(num_splits);
    return builder_.Finish();
}

flatbuffers::Offset<SplitVOptions> CreateSplitVOptions(flatbuffers::FlatBufferBuilder& _fbb, const SplitVOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct StridedSliceOptionsT : public flatbuffers::NativeTable
{
    typedef StridedSliceOptions TableType;
    int32_t begin_mask;
    int32_t end_mask;
    int32_t ellipsis_mask;
    int32_t new_axis_mask;
    int32_t shrink_axis_mask;
    StridedSliceOptionsT()
        : begin_mask(0),
          end_mask(0),
          ellipsis_mask(0),
          new_axis_mask(0),
          shrink_axis_mask(0)
    {
    }
};

struct StridedSliceOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef StridedSliceOptionsT NativeTableType;
    enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE
    {
        VT_BEGIN_MASK = 4,
        VT_END_MASK = 6,
        VT_ELLIPSIS_MASK = 8,
        VT_NEW_AXIS_MASK = 10,
        VT_SHRINK_AXIS_MASK = 12
    };
    int32_t begin_mask() const
    {
        return GetField<int32_t>(VT_BEGIN_MASK, 0);
    }
    int32_t end_mask() const
    {
        return GetField<int32_t>(VT_END_MASK, 0);
    }
    int32_t ellipsis_mask() const
    {
        return GetField<int32_t>(VT_ELLIPSIS_MASK, 0);
    }
    int32_t new_axis_mask() const
    {
        return GetField<int32_t>(VT_NEW_AXIS_MASK, 0);
    }
    int32_t shrink_axis_mask() const
    {
        return GetField<int32_t>(VT_SHRINK_AXIS_MASK, 0);
    }
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && VerifyField<int32_t>(verifier, VT_BEGIN_MASK) && VerifyField<int32_t>(verifier, VT_END_MASK) && VerifyField<int32_t>(verifier, VT_ELLIPSIS_MASK) && VerifyField<int32_t>(verifier, VT_NEW_AXIS_MASK) && VerifyField<int32_t>(verifier, VT_SHRINK_AXIS_MASK) && verifier.EndTable();
    }
    StridedSliceOptionsT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(StridedSliceOptionsT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<StridedSliceOptions> Pack(flatbuffers::FlatBufferBuilder& _fbb, const StridedSliceOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct StridedSliceOptionsBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    void add_begin_mask(int32_t begin_mask)
    {
        fbb_.AddElement<int32_t>(StridedSliceOptions::VT_BEGIN_MASK, begin_mask, 0);
    }
    void add_end_mask(int32_t end_mask)
    {
        fbb_.AddElement<int32_t>(StridedSliceOptions::VT_END_MASK, end_mask, 0);
    }
    void add_ellipsis_mask(int32_t ellipsis_mask)
    {
        fbb_.AddElement<int32_t>(StridedSliceOptions::VT_ELLIPSIS_MASK, ellipsis_mask, 0);
    }
    void add_new_axis_mask(int32_t new_axis_mask)
    {
        fbb_.AddElement<int32_t>(StridedSliceOptions::VT_NEW_AXIS_MASK, new_axis_mask, 0);
    }
    void add_shrink_axis_mask(int32_t shrink_axis_mask)
    {
        fbb_.AddElement<int32_t>(StridedSliceOptions::VT_SHRINK_AXIS_MASK, shrink_axis_mask, 0);
    }
    explicit StridedSliceOptionsBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    StridedSliceOptionsBuilder& operator=(const StridedSliceOptionsBuilder&);
    flatbuffers::Offset<StridedSliceOptions> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<StridedSliceOptions>(end);
        return o;
    }
};

inline flatbuffers::Offset<StridedSliceOptions> CreateStridedSliceOptions(
    flatbuffers::FlatBufferBuilder& _fbb,
    int32_t begin_mask = 0,
    int32_t end_mask = 0,
    int32_t ellipsis_mask = 0,
    int32_t new_axis_mask = 0,
    int32_t shrink_axis_mask = 0)
{
    StridedSliceOptionsBuilder builder_(_fbb);
    builder_.add_shrink_axis_mask(shrink_axis_mask);
    builder_.add_new_axis_mask(new_axis_mask);
    builder_.add_ellipsis_mask(ellipsis_mask);
    builder_.add_end_mask(end_mask);
    builder_.add_begin_mask(begin_mask);
    return builder_.Finish();
}

flatbuffers::Offset<StridedSliceOptions> CreateStridedSliceOptions(flatbuffers::FlatBufferBuilder& _fbb, const StridedSliceOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct LogSoftmaxOptionsT : public flatbuffers::NativeTable
{
    typedef LogSoftmaxOptions TableType;
    LogSoftmaxOptionsT()
    {
    }
};

struct LogSoftmaxOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef LogSoftmaxOptionsT NativeTableType;
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && verifier.EndTable();
    }
    LogSoftmaxOptionsT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(LogSoftmaxOptionsT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<LogSoftmaxOptions> Pack(flatbuffers::FlatBufferBuilder& _fbb, const LogSoftmaxOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct LogSoftmaxOptionsBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    explicit LogSoftmaxOptionsBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    LogSoftmaxOptionsBuilder& operator=(const LogSoftmaxOptionsBuilder&);
    flatbuffers::Offset<LogSoftmaxOptions> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<LogSoftmaxOptions>(end);
        return o;
    }
};

inline flatbuffers::Offset<LogSoftmaxOptions> CreateLogSoftmaxOptions(
    flatbuffers::FlatBufferBuilder& _fbb)
{
    LogSoftmaxOptionsBuilder builder_(_fbb);
    return builder_.Finish();
}

flatbuffers::Offset<LogSoftmaxOptions> CreateLogSoftmaxOptions(flatbuffers::FlatBufferBuilder& _fbb, const LogSoftmaxOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct CastOptionsT : public flatbuffers::NativeTable
{
    typedef CastOptions TableType;
    TensorType in_data_type;
    TensorType out_data_type;
    CastOptionsT()
        : in_data_type(TensorType_FLOAT32),
          out_data_type(TensorType_FLOAT32)
    {
    }
};

struct CastOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef CastOptionsT NativeTableType;
    enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE
    {
        VT_IN_DATA_TYPE = 4,
        VT_OUT_DATA_TYPE = 6
    };
    TensorType in_data_type() const
    {
        return static_cast<TensorType>(GetField<int8_t>(VT_IN_DATA_TYPE, 0));
    }
    TensorType out_data_type() const
    {
        return static_cast<TensorType>(GetField<int8_t>(VT_OUT_DATA_TYPE, 0));
    }
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && VerifyField<int8_t>(verifier, VT_IN_DATA_TYPE) && VerifyField<int8_t>(verifier, VT_OUT_DATA_TYPE) && verifier.EndTable();
    }
    CastOptionsT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(CastOptionsT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<CastOptions> Pack(flatbuffers::FlatBufferBuilder& _fbb, const CastOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct CastOptionsBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    void add_in_data_type(TensorType in_data_type)
    {
        fbb_.AddElement<int8_t>(CastOptions::VT_IN_DATA_TYPE, static_cast<int8_t>(in_data_type), 0);
    }
    void add_out_data_type(TensorType out_data_type)
    {
        fbb_.AddElement<int8_t>(CastOptions::VT_OUT_DATA_TYPE, static_cast<int8_t>(out_data_type), 0);
    }
    explicit CastOptionsBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    CastOptionsBuilder& operator=(const CastOptionsBuilder&);
    flatbuffers::Offset<CastOptions> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<CastOptions>(end);
        return o;
    }
};

inline flatbuffers::Offset<CastOptions> CreateCastOptions(
    flatbuffers::FlatBufferBuilder& _fbb,
    TensorType in_data_type = TensorType_FLOAT32,
    TensorType out_data_type = TensorType_FLOAT32)
{
    CastOptionsBuilder builder_(_fbb);
    builder_.add_out_data_type(out_data_type);
    builder_.add_in_data_type(in_data_type);
    return builder_.Finish();
}

flatbuffers::Offset<CastOptions> CreateCastOptions(flatbuffers::FlatBufferBuilder& _fbb, const CastOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct DequantizeOptionsT : public flatbuffers::NativeTable
{
    typedef DequantizeOptions TableType;
    DequantizeOptionsT()
    {
    }
};

struct DequantizeOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef DequantizeOptionsT NativeTableType;
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && verifier.EndTable();
    }
    DequantizeOptionsT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(DequantizeOptionsT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<DequantizeOptions> Pack(flatbuffers::FlatBufferBuilder& _fbb, const DequantizeOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct DequantizeOptionsBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    explicit DequantizeOptionsBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    DequantizeOptionsBuilder& operator=(const DequantizeOptionsBuilder&);
    flatbuffers::Offset<DequantizeOptions> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<DequantizeOptions>(end);
        return o;
    }
};

inline flatbuffers::Offset<DequantizeOptions> CreateDequantizeOptions(
    flatbuffers::FlatBufferBuilder& _fbb)
{
    DequantizeOptionsBuilder builder_(_fbb);
    return builder_.Finish();
}

flatbuffers::Offset<DequantizeOptions> CreateDequantizeOptions(flatbuffers::FlatBufferBuilder& _fbb, const DequantizeOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct MaximumMinimumOptionsT : public flatbuffers::NativeTable
{
    typedef MaximumMinimumOptions TableType;
    MaximumMinimumOptionsT()
    {
    }
};

struct MaximumMinimumOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef MaximumMinimumOptionsT NativeTableType;
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && verifier.EndTable();
    }
    MaximumMinimumOptionsT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(MaximumMinimumOptionsT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<MaximumMinimumOptions> Pack(flatbuffers::FlatBufferBuilder& _fbb, const MaximumMinimumOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct MaximumMinimumOptionsBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    explicit MaximumMinimumOptionsBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    MaximumMinimumOptionsBuilder& operator=(const MaximumMinimumOptionsBuilder&);
    flatbuffers::Offset<MaximumMinimumOptions> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<MaximumMinimumOptions>(end);
        return o;
    }
};

inline flatbuffers::Offset<MaximumMinimumOptions> CreateMaximumMinimumOptions(
    flatbuffers::FlatBufferBuilder& _fbb)
{
    MaximumMinimumOptionsBuilder builder_(_fbb);
    return builder_.Finish();
}

flatbuffers::Offset<MaximumMinimumOptions> CreateMaximumMinimumOptions(flatbuffers::FlatBufferBuilder& _fbb, const MaximumMinimumOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct TileOptionsT : public flatbuffers::NativeTable
{
    typedef TileOptions TableType;
    TileOptionsT()
    {
    }
};

struct TileOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef TileOptionsT NativeTableType;
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && verifier.EndTable();
    }
    TileOptionsT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(TileOptionsT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<TileOptions> Pack(flatbuffers::FlatBufferBuilder& _fbb, const TileOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct TileOptionsBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    explicit TileOptionsBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    TileOptionsBuilder& operator=(const TileOptionsBuilder&);
    flatbuffers::Offset<TileOptions> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<TileOptions>(end);
        return o;
    }
};

inline flatbuffers::Offset<TileOptions> CreateTileOptions(
    flatbuffers::FlatBufferBuilder& _fbb)
{
    TileOptionsBuilder builder_(_fbb);
    return builder_.Finish();
}

flatbuffers::Offset<TileOptions> CreateTileOptions(flatbuffers::FlatBufferBuilder& _fbb, const TileOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct ArgMaxOptionsT : public flatbuffers::NativeTable
{
    typedef ArgMaxOptions TableType;
    TensorType output_type;
    ArgMaxOptionsT()
        : output_type(TensorType_FLOAT32)
    {
    }
};

struct ArgMaxOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef ArgMaxOptionsT NativeTableType;
    enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE
    {
        VT_OUTPUT_TYPE = 4
    };
    TensorType output_type() const
    {
        return static_cast<TensorType>(GetField<int8_t>(VT_OUTPUT_TYPE, 0));
    }
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && VerifyField<int8_t>(verifier, VT_OUTPUT_TYPE) && verifier.EndTable();
    }
    ArgMaxOptionsT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(ArgMaxOptionsT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<ArgMaxOptions> Pack(flatbuffers::FlatBufferBuilder& _fbb, const ArgMaxOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct ArgMaxOptionsBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    void add_output_type(TensorType output_type)
    {
        fbb_.AddElement<int8_t>(ArgMaxOptions::VT_OUTPUT_TYPE, static_cast<int8_t>(output_type), 0);
    }
    explicit ArgMaxOptionsBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    ArgMaxOptionsBuilder& operator=(const ArgMaxOptionsBuilder&);
    flatbuffers::Offset<ArgMaxOptions> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<ArgMaxOptions>(end);
        return o;
    }
};

inline flatbuffers::Offset<ArgMaxOptions> CreateArgMaxOptions(
    flatbuffers::FlatBufferBuilder& _fbb,
    TensorType output_type = TensorType_FLOAT32)
{
    ArgMaxOptionsBuilder builder_(_fbb);
    builder_.add_output_type(output_type);
    return builder_.Finish();
}

flatbuffers::Offset<ArgMaxOptions> CreateArgMaxOptions(flatbuffers::FlatBufferBuilder& _fbb, const ArgMaxOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct ArgMinOptionsT : public flatbuffers::NativeTable
{
    typedef ArgMinOptions TableType;
    TensorType output_type;
    ArgMinOptionsT()
        : output_type(TensorType_FLOAT32)
    {
    }
};

struct ArgMinOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef ArgMinOptionsT NativeTableType;
    enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE
    {
        VT_OUTPUT_TYPE = 4
    };
    TensorType output_type() const
    {
        return static_cast<TensorType>(GetField<int8_t>(VT_OUTPUT_TYPE, 0));
    }
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && VerifyField<int8_t>(verifier, VT_OUTPUT_TYPE) && verifier.EndTable();
    }
    ArgMinOptionsT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(ArgMinOptionsT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<ArgMinOptions> Pack(flatbuffers::FlatBufferBuilder& _fbb, const ArgMinOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct ArgMinOptionsBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    void add_output_type(TensorType output_type)
    {
        fbb_.AddElement<int8_t>(ArgMinOptions::VT_OUTPUT_TYPE, static_cast<int8_t>(output_type), 0);
    }
    explicit ArgMinOptionsBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    ArgMinOptionsBuilder& operator=(const ArgMinOptionsBuilder&);
    flatbuffers::Offset<ArgMinOptions> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<ArgMinOptions>(end);
        return o;
    }
};

inline flatbuffers::Offset<ArgMinOptions> CreateArgMinOptions(
    flatbuffers::FlatBufferBuilder& _fbb,
    TensorType output_type = TensorType_FLOAT32)
{
    ArgMinOptionsBuilder builder_(_fbb);
    builder_.add_output_type(output_type);
    return builder_.Finish();
}

flatbuffers::Offset<ArgMinOptions> CreateArgMinOptions(flatbuffers::FlatBufferBuilder& _fbb, const ArgMinOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct GreaterOptionsT : public flatbuffers::NativeTable
{
    typedef GreaterOptions TableType;
    GreaterOptionsT()
    {
    }
};

struct GreaterOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef GreaterOptionsT NativeTableType;
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && verifier.EndTable();
    }
    GreaterOptionsT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(GreaterOptionsT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<GreaterOptions> Pack(flatbuffers::FlatBufferBuilder& _fbb, const GreaterOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct GreaterOptionsBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    explicit GreaterOptionsBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    GreaterOptionsBuilder& operator=(const GreaterOptionsBuilder&);
    flatbuffers::Offset<GreaterOptions> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<GreaterOptions>(end);
        return o;
    }
};

inline flatbuffers::Offset<GreaterOptions> CreateGreaterOptions(
    flatbuffers::FlatBufferBuilder& _fbb)
{
    GreaterOptionsBuilder builder_(_fbb);
    return builder_.Finish();
}

flatbuffers::Offset<GreaterOptions> CreateGreaterOptions(flatbuffers::FlatBufferBuilder& _fbb, const GreaterOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct GreaterEqualOptionsT : public flatbuffers::NativeTable
{
    typedef GreaterEqualOptions TableType;
    GreaterEqualOptionsT()
    {
    }
};

struct GreaterEqualOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef GreaterEqualOptionsT NativeTableType;
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && verifier.EndTable();
    }
    GreaterEqualOptionsT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(GreaterEqualOptionsT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<GreaterEqualOptions> Pack(flatbuffers::FlatBufferBuilder& _fbb, const GreaterEqualOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct GreaterEqualOptionsBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    explicit GreaterEqualOptionsBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    GreaterEqualOptionsBuilder& operator=(const GreaterEqualOptionsBuilder&);
    flatbuffers::Offset<GreaterEqualOptions> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<GreaterEqualOptions>(end);
        return o;
    }
};

inline flatbuffers::Offset<GreaterEqualOptions> CreateGreaterEqualOptions(
    flatbuffers::FlatBufferBuilder& _fbb)
{
    GreaterEqualOptionsBuilder builder_(_fbb);
    return builder_.Finish();
}

flatbuffers::Offset<GreaterEqualOptions> CreateGreaterEqualOptions(flatbuffers::FlatBufferBuilder& _fbb, const GreaterEqualOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct LessOptionsT : public flatbuffers::NativeTable
{
    typedef LessOptions TableType;
    LessOptionsT()
    {
    }
};

struct LessOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef LessOptionsT NativeTableType;
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && verifier.EndTable();
    }
    LessOptionsT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(LessOptionsT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<LessOptions> Pack(flatbuffers::FlatBufferBuilder& _fbb, const LessOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct LessOptionsBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    explicit LessOptionsBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    LessOptionsBuilder& operator=(const LessOptionsBuilder&);
    flatbuffers::Offset<LessOptions> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<LessOptions>(end);
        return o;
    }
};

inline flatbuffers::Offset<LessOptions> CreateLessOptions(
    flatbuffers::FlatBufferBuilder& _fbb)
{
    LessOptionsBuilder builder_(_fbb);
    return builder_.Finish();
}

flatbuffers::Offset<LessOptions> CreateLessOptions(flatbuffers::FlatBufferBuilder& _fbb, const LessOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct LessEqualOptionsT : public flatbuffers::NativeTable
{
    typedef LessEqualOptions TableType;
    LessEqualOptionsT()
    {
    }
};

struct LessEqualOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef LessEqualOptionsT NativeTableType;
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && verifier.EndTable();
    }
    LessEqualOptionsT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(LessEqualOptionsT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<LessEqualOptions> Pack(flatbuffers::FlatBufferBuilder& _fbb, const LessEqualOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct LessEqualOptionsBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    explicit LessEqualOptionsBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    LessEqualOptionsBuilder& operator=(const LessEqualOptionsBuilder&);
    flatbuffers::Offset<LessEqualOptions> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<LessEqualOptions>(end);
        return o;
    }
};

inline flatbuffers::Offset<LessEqualOptions> CreateLessEqualOptions(
    flatbuffers::FlatBufferBuilder& _fbb)
{
    LessEqualOptionsBuilder builder_(_fbb);
    return builder_.Finish();
}

flatbuffers::Offset<LessEqualOptions> CreateLessEqualOptions(flatbuffers::FlatBufferBuilder& _fbb, const LessEqualOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct NegOptionsT : public flatbuffers::NativeTable
{
    typedef NegOptions TableType;
    NegOptionsT()
    {
    }
};

struct NegOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef NegOptionsT NativeTableType;
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && verifier.EndTable();
    }
    NegOptionsT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(NegOptionsT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<NegOptions> Pack(flatbuffers::FlatBufferBuilder& _fbb, const NegOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct NegOptionsBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    explicit NegOptionsBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    NegOptionsBuilder& operator=(const NegOptionsBuilder&);
    flatbuffers::Offset<NegOptions> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<NegOptions>(end);
        return o;
    }
};

inline flatbuffers::Offset<NegOptions> CreateNegOptions(
    flatbuffers::FlatBufferBuilder& _fbb)
{
    NegOptionsBuilder builder_(_fbb);
    return builder_.Finish();
}

flatbuffers::Offset<NegOptions> CreateNegOptions(flatbuffers::FlatBufferBuilder& _fbb, const NegOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct SelectOptionsT : public flatbuffers::NativeTable
{
    typedef SelectOptions TableType;
    SelectOptionsT()
    {
    }
};

struct SelectOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef SelectOptionsT NativeTableType;
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && verifier.EndTable();
    }
    SelectOptionsT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(SelectOptionsT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<SelectOptions> Pack(flatbuffers::FlatBufferBuilder& _fbb, const SelectOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct SelectOptionsBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    explicit SelectOptionsBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    SelectOptionsBuilder& operator=(const SelectOptionsBuilder&);
    flatbuffers::Offset<SelectOptions> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<SelectOptions>(end);
        return o;
    }
};

inline flatbuffers::Offset<SelectOptions> CreateSelectOptions(
    flatbuffers::FlatBufferBuilder& _fbb)
{
    SelectOptionsBuilder builder_(_fbb);
    return builder_.Finish();
}

flatbuffers::Offset<SelectOptions> CreateSelectOptions(flatbuffers::FlatBufferBuilder& _fbb, const SelectOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct SliceOptionsT : public flatbuffers::NativeTable
{
    typedef SliceOptions TableType;
    SliceOptionsT()
    {
    }
};

struct SliceOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef SliceOptionsT NativeTableType;
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && verifier.EndTable();
    }
    SliceOptionsT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(SliceOptionsT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<SliceOptions> Pack(flatbuffers::FlatBufferBuilder& _fbb, const SliceOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct SliceOptionsBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    explicit SliceOptionsBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    SliceOptionsBuilder& operator=(const SliceOptionsBuilder&);
    flatbuffers::Offset<SliceOptions> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<SliceOptions>(end);
        return o;
    }
};

inline flatbuffers::Offset<SliceOptions> CreateSliceOptions(
    flatbuffers::FlatBufferBuilder& _fbb)
{
    SliceOptionsBuilder builder_(_fbb);
    return builder_.Finish();
}

flatbuffers::Offset<SliceOptions> CreateSliceOptions(flatbuffers::FlatBufferBuilder& _fbb, const SliceOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct TransposeConvOptionsT : public flatbuffers::NativeTable
{
    typedef TransposeConvOptions TableType;
    Padding padding;
    int32_t stride_w;
    int32_t stride_h;
    TransposeConvOptionsT()
        : padding(Padding_SAME),
          stride_w(0),
          stride_h(0)
    {
    }
};

struct TransposeConvOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef TransposeConvOptionsT NativeTableType;
    enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE
    {
        VT_PADDING = 4,
        VT_STRIDE_W = 6,
        VT_STRIDE_H = 8
    };
    Padding padding() const
    {
        return static_cast<Padding>(GetField<int8_t>(VT_PADDING, 0));
    }
    int32_t stride_w() const
    {
        return GetField<int32_t>(VT_STRIDE_W, 0);
    }
    int32_t stride_h() const
    {
        return GetField<int32_t>(VT_STRIDE_H, 0);
    }
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && VerifyField<int8_t>(verifier, VT_PADDING) && VerifyField<int32_t>(verifier, VT_STRIDE_W) && VerifyField<int32_t>(verifier, VT_STRIDE_H) && verifier.EndTable();
    }
    TransposeConvOptionsT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(TransposeConvOptionsT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<TransposeConvOptions> Pack(flatbuffers::FlatBufferBuilder& _fbb, const TransposeConvOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct TransposeConvOptionsBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    void add_padding(Padding padding)
    {
        fbb_.AddElement<int8_t>(TransposeConvOptions::VT_PADDING, static_cast<int8_t>(padding), 0);
    }
    void add_stride_w(int32_t stride_w)
    {
        fbb_.AddElement<int32_t>(TransposeConvOptions::VT_STRIDE_W, stride_w, 0);
    }
    void add_stride_h(int32_t stride_h)
    {
        fbb_.AddElement<int32_t>(TransposeConvOptions::VT_STRIDE_H, stride_h, 0);
    }
    explicit TransposeConvOptionsBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    TransposeConvOptionsBuilder& operator=(const TransposeConvOptionsBuilder&);
    flatbuffers::Offset<TransposeConvOptions> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<TransposeConvOptions>(end);
        return o;
    }
};

inline flatbuffers::Offset<TransposeConvOptions> CreateTransposeConvOptions(
    flatbuffers::FlatBufferBuilder& _fbb,
    Padding padding = Padding_SAME,
    int32_t stride_w = 0,
    int32_t stride_h = 0)
{
    TransposeConvOptionsBuilder builder_(_fbb);
    builder_.add_stride_h(stride_h);
    builder_.add_stride_w(stride_w);
    builder_.add_padding(padding);
    return builder_.Finish();
}

flatbuffers::Offset<TransposeConvOptions> CreateTransposeConvOptions(flatbuffers::FlatBufferBuilder& _fbb, const TransposeConvOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct ExpandDimsOptionsT : public flatbuffers::NativeTable
{
    typedef ExpandDimsOptions TableType;
    ExpandDimsOptionsT()
    {
    }
};

struct ExpandDimsOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef ExpandDimsOptionsT NativeTableType;
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && verifier.EndTable();
    }
    ExpandDimsOptionsT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(ExpandDimsOptionsT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<ExpandDimsOptions> Pack(flatbuffers::FlatBufferBuilder& _fbb, const ExpandDimsOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct ExpandDimsOptionsBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    explicit ExpandDimsOptionsBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    ExpandDimsOptionsBuilder& operator=(const ExpandDimsOptionsBuilder&);
    flatbuffers::Offset<ExpandDimsOptions> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<ExpandDimsOptions>(end);
        return o;
    }
};

inline flatbuffers::Offset<ExpandDimsOptions> CreateExpandDimsOptions(
    flatbuffers::FlatBufferBuilder& _fbb)
{
    ExpandDimsOptionsBuilder builder_(_fbb);
    return builder_.Finish();
}

flatbuffers::Offset<ExpandDimsOptions> CreateExpandDimsOptions(flatbuffers::FlatBufferBuilder& _fbb, const ExpandDimsOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct SparseToDenseOptionsT : public flatbuffers::NativeTable
{
    typedef SparseToDenseOptions TableType;
    bool validate_indices;
    SparseToDenseOptionsT()
        : validate_indices(false)
    {
    }
};

struct SparseToDenseOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef SparseToDenseOptionsT NativeTableType;
    enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE
    {
        VT_VALIDATE_INDICES = 4
    };
    bool validate_indices() const
    {
        return GetField<uint8_t>(VT_VALIDATE_INDICES, 0) != 0;
    }
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && VerifyField<uint8_t>(verifier, VT_VALIDATE_INDICES) && verifier.EndTable();
    }
    SparseToDenseOptionsT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(SparseToDenseOptionsT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<SparseToDenseOptions> Pack(flatbuffers::FlatBufferBuilder& _fbb, const SparseToDenseOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct SparseToDenseOptionsBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    void add_validate_indices(bool validate_indices)
    {
        fbb_.AddElement<uint8_t>(SparseToDenseOptions::VT_VALIDATE_INDICES, static_cast<uint8_t>(validate_indices), 0);
    }
    explicit SparseToDenseOptionsBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    SparseToDenseOptionsBuilder& operator=(const SparseToDenseOptionsBuilder&);
    flatbuffers::Offset<SparseToDenseOptions> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<SparseToDenseOptions>(end);
        return o;
    }
};

inline flatbuffers::Offset<SparseToDenseOptions> CreateSparseToDenseOptions(
    flatbuffers::FlatBufferBuilder& _fbb,
    bool validate_indices = false)
{
    SparseToDenseOptionsBuilder builder_(_fbb);
    builder_.add_validate_indices(validate_indices);
    return builder_.Finish();
}

flatbuffers::Offset<SparseToDenseOptions> CreateSparseToDenseOptions(flatbuffers::FlatBufferBuilder& _fbb, const SparseToDenseOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct EqualOptionsT : public flatbuffers::NativeTable
{
    typedef EqualOptions TableType;
    EqualOptionsT()
    {
    }
};

struct EqualOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef EqualOptionsT NativeTableType;
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && verifier.EndTable();
    }
    EqualOptionsT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(EqualOptionsT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<EqualOptions> Pack(flatbuffers::FlatBufferBuilder& _fbb, const EqualOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct EqualOptionsBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    explicit EqualOptionsBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    EqualOptionsBuilder& operator=(const EqualOptionsBuilder&);
    flatbuffers::Offset<EqualOptions> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<EqualOptions>(end);
        return o;
    }
};

inline flatbuffers::Offset<EqualOptions> CreateEqualOptions(
    flatbuffers::FlatBufferBuilder& _fbb)
{
    EqualOptionsBuilder builder_(_fbb);
    return builder_.Finish();
}

flatbuffers::Offset<EqualOptions> CreateEqualOptions(flatbuffers::FlatBufferBuilder& _fbb, const EqualOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct NotEqualOptionsT : public flatbuffers::NativeTable
{
    typedef NotEqualOptions TableType;
    NotEqualOptionsT()
    {
    }
};

struct NotEqualOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef NotEqualOptionsT NativeTableType;
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && verifier.EndTable();
    }
    NotEqualOptionsT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(NotEqualOptionsT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<NotEqualOptions> Pack(flatbuffers::FlatBufferBuilder& _fbb, const NotEqualOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct NotEqualOptionsBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    explicit NotEqualOptionsBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    NotEqualOptionsBuilder& operator=(const NotEqualOptionsBuilder&);
    flatbuffers::Offset<NotEqualOptions> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<NotEqualOptions>(end);
        return o;
    }
};

inline flatbuffers::Offset<NotEqualOptions> CreateNotEqualOptions(
    flatbuffers::FlatBufferBuilder& _fbb)
{
    NotEqualOptionsBuilder builder_(_fbb);
    return builder_.Finish();
}

flatbuffers::Offset<NotEqualOptions> CreateNotEqualOptions(flatbuffers::FlatBufferBuilder& _fbb, const NotEqualOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct ShapeOptionsT : public flatbuffers::NativeTable
{
    typedef ShapeOptions TableType;
    TensorType out_type;
    ShapeOptionsT()
        : out_type(TensorType_FLOAT32)
    {
    }
};

struct ShapeOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef ShapeOptionsT NativeTableType;
    enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE
    {
        VT_OUT_TYPE = 4
    };
    TensorType out_type() const
    {
        return static_cast<TensorType>(GetField<int8_t>(VT_OUT_TYPE, 0));
    }
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && VerifyField<int8_t>(verifier, VT_OUT_TYPE) && verifier.EndTable();
    }
    ShapeOptionsT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(ShapeOptionsT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<ShapeOptions> Pack(flatbuffers::FlatBufferBuilder& _fbb, const ShapeOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct ShapeOptionsBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    void add_out_type(TensorType out_type)
    {
        fbb_.AddElement<int8_t>(ShapeOptions::VT_OUT_TYPE, static_cast<int8_t>(out_type), 0);
    }
    explicit ShapeOptionsBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    ShapeOptionsBuilder& operator=(const ShapeOptionsBuilder&);
    flatbuffers::Offset<ShapeOptions> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<ShapeOptions>(end);
        return o;
    }
};

inline flatbuffers::Offset<ShapeOptions> CreateShapeOptions(
    flatbuffers::FlatBufferBuilder& _fbb,
    TensorType out_type = TensorType_FLOAT32)
{
    ShapeOptionsBuilder builder_(_fbb);
    builder_.add_out_type(out_type);
    return builder_.Finish();
}

flatbuffers::Offset<ShapeOptions> CreateShapeOptions(flatbuffers::FlatBufferBuilder& _fbb, const ShapeOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct RankOptionsT : public flatbuffers::NativeTable
{
    typedef RankOptions TableType;
    RankOptionsT()
    {
    }
};

struct RankOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef RankOptionsT NativeTableType;
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && verifier.EndTable();
    }
    RankOptionsT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(RankOptionsT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<RankOptions> Pack(flatbuffers::FlatBufferBuilder& _fbb, const RankOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct RankOptionsBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    explicit RankOptionsBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    RankOptionsBuilder& operator=(const RankOptionsBuilder&);
    flatbuffers::Offset<RankOptions> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<RankOptions>(end);
        return o;
    }
};

inline flatbuffers::Offset<RankOptions> CreateRankOptions(
    flatbuffers::FlatBufferBuilder& _fbb)
{
    RankOptionsBuilder builder_(_fbb);
    return builder_.Finish();
}

flatbuffers::Offset<RankOptions> CreateRankOptions(flatbuffers::FlatBufferBuilder& _fbb, const RankOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct PowOptionsT : public flatbuffers::NativeTable
{
    typedef PowOptions TableType;
    PowOptionsT()
    {
    }
};

struct PowOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef PowOptionsT NativeTableType;
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && verifier.EndTable();
    }
    PowOptionsT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(PowOptionsT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<PowOptions> Pack(flatbuffers::FlatBufferBuilder& _fbb, const PowOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct PowOptionsBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    explicit PowOptionsBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    PowOptionsBuilder& operator=(const PowOptionsBuilder&);
    flatbuffers::Offset<PowOptions> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<PowOptions>(end);
        return o;
    }
};

inline flatbuffers::Offset<PowOptions> CreatePowOptions(
    flatbuffers::FlatBufferBuilder& _fbb)
{
    PowOptionsBuilder builder_(_fbb);
    return builder_.Finish();
}

flatbuffers::Offset<PowOptions> CreatePowOptions(flatbuffers::FlatBufferBuilder& _fbb, const PowOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct FakeQuantOptionsT : public flatbuffers::NativeTable
{
    typedef FakeQuantOptions TableType;
    float min;
    float max;
    int32_t num_bits;
    bool narrow_range;
    FakeQuantOptionsT()
        : min(0.0f),
          max(0.0f),
          num_bits(0),
          narrow_range(false)
    {
    }
};

struct FakeQuantOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef FakeQuantOptionsT NativeTableType;
    enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE
    {
        VT_MIN = 4,
        VT_MAX = 6,
        VT_NUM_BITS = 8,
        VT_NARROW_RANGE = 10
    };
    float min() const
    {
        return GetField<float>(VT_MIN, 0.0f);
    }
    float max() const
    {
        return GetField<float>(VT_MAX, 0.0f);
    }
    int32_t num_bits() const
    {
        return GetField<int32_t>(VT_NUM_BITS, 0);
    }
    bool narrow_range() const
    {
        return GetField<uint8_t>(VT_NARROW_RANGE, 0) != 0;
    }
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && VerifyField<float>(verifier, VT_MIN) && VerifyField<float>(verifier, VT_MAX) && VerifyField<int32_t>(verifier, VT_NUM_BITS) && VerifyField<uint8_t>(verifier, VT_NARROW_RANGE) && verifier.EndTable();
    }
    FakeQuantOptionsT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(FakeQuantOptionsT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<FakeQuantOptions> Pack(flatbuffers::FlatBufferBuilder& _fbb, const FakeQuantOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct FakeQuantOptionsBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    void add_min(float min)
    {
        fbb_.AddElement<float>(FakeQuantOptions::VT_MIN, min, 0.0f);
    }
    void add_max(float max)
    {
        fbb_.AddElement<float>(FakeQuantOptions::VT_MAX, max, 0.0f);
    }
    void add_num_bits(int32_t num_bits)
    {
        fbb_.AddElement<int32_t>(FakeQuantOptions::VT_NUM_BITS, num_bits, 0);
    }
    void add_narrow_range(bool narrow_range)
    {
        fbb_.AddElement<uint8_t>(FakeQuantOptions::VT_NARROW_RANGE, static_cast<uint8_t>(narrow_range), 0);
    }
    explicit FakeQuantOptionsBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    FakeQuantOptionsBuilder& operator=(const FakeQuantOptionsBuilder&);
    flatbuffers::Offset<FakeQuantOptions> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<FakeQuantOptions>(end);
        return o;
    }
};

inline flatbuffers::Offset<FakeQuantOptions> CreateFakeQuantOptions(
    flatbuffers::FlatBufferBuilder& _fbb,
    float min = 0.0f,
    float max = 0.0f,
    int32_t num_bits = 0,
    bool narrow_range = false)
{
    FakeQuantOptionsBuilder builder_(_fbb);
    builder_.add_num_bits(num_bits);
    builder_.add_max(max);
    builder_.add_min(min);
    builder_.add_narrow_range(narrow_range);
    return builder_.Finish();
}

flatbuffers::Offset<FakeQuantOptions> CreateFakeQuantOptions(flatbuffers::FlatBufferBuilder& _fbb, const FakeQuantOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct PackOptionsT : public flatbuffers::NativeTable
{
    typedef PackOptions TableType;
    int32_t values_count;
    int32_t axis;
    PackOptionsT()
        : values_count(0),
          axis(0)
    {
    }
};

struct PackOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef PackOptionsT NativeTableType;
    enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE
    {
        VT_VALUES_COUNT = 4,
        VT_AXIS = 6
    };
    int32_t values_count() const
    {
        return GetField<int32_t>(VT_VALUES_COUNT, 0);
    }
    int32_t axis() const
    {
        return GetField<int32_t>(VT_AXIS, 0);
    }
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && VerifyField<int32_t>(verifier, VT_VALUES_COUNT) && VerifyField<int32_t>(verifier, VT_AXIS) && verifier.EndTable();
    }
    PackOptionsT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(PackOptionsT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<PackOptions> Pack(flatbuffers::FlatBufferBuilder& _fbb, const PackOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct PackOptionsBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    void add_values_count(int32_t values_count)
    {
        fbb_.AddElement<int32_t>(PackOptions::VT_VALUES_COUNT, values_count, 0);
    }
    void add_axis(int32_t axis)
    {
        fbb_.AddElement<int32_t>(PackOptions::VT_AXIS, axis, 0);
    }
    explicit PackOptionsBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    PackOptionsBuilder& operator=(const PackOptionsBuilder&);
    flatbuffers::Offset<PackOptions> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<PackOptions>(end);
        return o;
    }
};

inline flatbuffers::Offset<PackOptions> CreatePackOptions(
    flatbuffers::FlatBufferBuilder& _fbb,
    int32_t values_count = 0,
    int32_t axis = 0)
{
    PackOptionsBuilder builder_(_fbb);
    builder_.add_axis(axis);
    builder_.add_values_count(values_count);
    return builder_.Finish();
}

flatbuffers::Offset<PackOptions> CreatePackOptions(flatbuffers::FlatBufferBuilder& _fbb, const PackOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct LogicalOrOptionsT : public flatbuffers::NativeTable
{
    typedef LogicalOrOptions TableType;
    LogicalOrOptionsT()
    {
    }
};

struct LogicalOrOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef LogicalOrOptionsT NativeTableType;
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && verifier.EndTable();
    }
    LogicalOrOptionsT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(LogicalOrOptionsT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<LogicalOrOptions> Pack(flatbuffers::FlatBufferBuilder& _fbb, const LogicalOrOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct LogicalOrOptionsBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    explicit LogicalOrOptionsBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    LogicalOrOptionsBuilder& operator=(const LogicalOrOptionsBuilder&);
    flatbuffers::Offset<LogicalOrOptions> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<LogicalOrOptions>(end);
        return o;
    }
};

inline flatbuffers::Offset<LogicalOrOptions> CreateLogicalOrOptions(
    flatbuffers::FlatBufferBuilder& _fbb)
{
    LogicalOrOptionsBuilder builder_(_fbb);
    return builder_.Finish();
}

flatbuffers::Offset<LogicalOrOptions> CreateLogicalOrOptions(flatbuffers::FlatBufferBuilder& _fbb, const LogicalOrOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct OneHotOptionsT : public flatbuffers::NativeTable
{
    typedef OneHotOptions TableType;
    int32_t axis;
    OneHotOptionsT()
        : axis(0)
    {
    }
};

struct OneHotOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef OneHotOptionsT NativeTableType;
    enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE
    {
        VT_AXIS = 4
    };
    int32_t axis() const
    {
        return GetField<int32_t>(VT_AXIS, 0);
    }
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && VerifyField<int32_t>(verifier, VT_AXIS) && verifier.EndTable();
    }
    OneHotOptionsT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(OneHotOptionsT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<OneHotOptions> Pack(flatbuffers::FlatBufferBuilder& _fbb, const OneHotOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct OneHotOptionsBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    void add_axis(int32_t axis)
    {
        fbb_.AddElement<int32_t>(OneHotOptions::VT_AXIS, axis, 0);
    }
    explicit OneHotOptionsBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    OneHotOptionsBuilder& operator=(const OneHotOptionsBuilder&);
    flatbuffers::Offset<OneHotOptions> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<OneHotOptions>(end);
        return o;
    }
};

inline flatbuffers::Offset<OneHotOptions> CreateOneHotOptions(
    flatbuffers::FlatBufferBuilder& _fbb,
    int32_t axis = 0)
{
    OneHotOptionsBuilder builder_(_fbb);
    builder_.add_axis(axis);
    return builder_.Finish();
}

flatbuffers::Offset<OneHotOptions> CreateOneHotOptions(flatbuffers::FlatBufferBuilder& _fbb, const OneHotOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct AbsOptionsT : public flatbuffers::NativeTable
{
    typedef AbsOptions TableType;
    AbsOptionsT()
    {
    }
};

struct AbsOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef AbsOptionsT NativeTableType;
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && verifier.EndTable();
    }
    AbsOptionsT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(AbsOptionsT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<AbsOptions> Pack(flatbuffers::FlatBufferBuilder& _fbb, const AbsOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct AbsOptionsBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    explicit AbsOptionsBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    AbsOptionsBuilder& operator=(const AbsOptionsBuilder&);
    flatbuffers::Offset<AbsOptions> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<AbsOptions>(end);
        return o;
    }
};

inline flatbuffers::Offset<AbsOptions> CreateAbsOptions(
    flatbuffers::FlatBufferBuilder& _fbb)
{
    AbsOptionsBuilder builder_(_fbb);
    return builder_.Finish();
}

flatbuffers::Offset<AbsOptions> CreateAbsOptions(flatbuffers::FlatBufferBuilder& _fbb, const AbsOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct HardSwishOptionsT : public flatbuffers::NativeTable
{
    typedef HardSwishOptions TableType;
    HardSwishOptionsT()
    {
    }
};

struct HardSwishOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef HardSwishOptionsT NativeTableType;
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && verifier.EndTable();
    }
    HardSwishOptionsT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(HardSwishOptionsT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<HardSwishOptions> Pack(flatbuffers::FlatBufferBuilder& _fbb, const HardSwishOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct HardSwishOptionsBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    explicit HardSwishOptionsBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    HardSwishOptionsBuilder& operator=(const HardSwishOptionsBuilder&);
    flatbuffers::Offset<HardSwishOptions> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<HardSwishOptions>(end);
        return o;
    }
};

inline flatbuffers::Offset<HardSwishOptions> CreateHardSwishOptions(
    flatbuffers::FlatBufferBuilder& _fbb)
{
    HardSwishOptionsBuilder builder_(_fbb);
    return builder_.Finish();
}

flatbuffers::Offset<HardSwishOptions> CreateHardSwishOptions(flatbuffers::FlatBufferBuilder& _fbb, const HardSwishOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct LogicalAndOptionsT : public flatbuffers::NativeTable
{
    typedef LogicalAndOptions TableType;
    LogicalAndOptionsT()
    {
    }
};

struct LogicalAndOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef LogicalAndOptionsT NativeTableType;
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && verifier.EndTable();
    }
    LogicalAndOptionsT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(LogicalAndOptionsT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<LogicalAndOptions> Pack(flatbuffers::FlatBufferBuilder& _fbb, const LogicalAndOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct LogicalAndOptionsBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    explicit LogicalAndOptionsBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    LogicalAndOptionsBuilder& operator=(const LogicalAndOptionsBuilder&);
    flatbuffers::Offset<LogicalAndOptions> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<LogicalAndOptions>(end);
        return o;
    }
};

inline flatbuffers::Offset<LogicalAndOptions> CreateLogicalAndOptions(
    flatbuffers::FlatBufferBuilder& _fbb)
{
    LogicalAndOptionsBuilder builder_(_fbb);
    return builder_.Finish();
}

flatbuffers::Offset<LogicalAndOptions> CreateLogicalAndOptions(flatbuffers::FlatBufferBuilder& _fbb, const LogicalAndOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct LogicalNotOptionsT : public flatbuffers::NativeTable
{
    typedef LogicalNotOptions TableType;
    LogicalNotOptionsT()
    {
    }
};

struct LogicalNotOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef LogicalNotOptionsT NativeTableType;
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && verifier.EndTable();
    }
    LogicalNotOptionsT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(LogicalNotOptionsT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<LogicalNotOptions> Pack(flatbuffers::FlatBufferBuilder& _fbb, const LogicalNotOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct LogicalNotOptionsBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    explicit LogicalNotOptionsBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    LogicalNotOptionsBuilder& operator=(const LogicalNotOptionsBuilder&);
    flatbuffers::Offset<LogicalNotOptions> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<LogicalNotOptions>(end);
        return o;
    }
};

inline flatbuffers::Offset<LogicalNotOptions> CreateLogicalNotOptions(
    flatbuffers::FlatBufferBuilder& _fbb)
{
    LogicalNotOptionsBuilder builder_(_fbb);
    return builder_.Finish();
}

flatbuffers::Offset<LogicalNotOptions> CreateLogicalNotOptions(flatbuffers::FlatBufferBuilder& _fbb, const LogicalNotOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct UnpackOptionsT : public flatbuffers::NativeTable
{
    typedef UnpackOptions TableType;
    int32_t num;
    int32_t axis;
    UnpackOptionsT()
        : num(0),
          axis(0)
    {
    }
};

struct UnpackOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef UnpackOptionsT NativeTableType;
    enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE
    {
        VT_NUM = 4,
        VT_AXIS = 6
    };
    int32_t num() const
    {
        return GetField<int32_t>(VT_NUM, 0);
    }
    int32_t axis() const
    {
        return GetField<int32_t>(VT_AXIS, 0);
    }
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && VerifyField<int32_t>(verifier, VT_NUM) && VerifyField<int32_t>(verifier, VT_AXIS) && verifier.EndTable();
    }
    UnpackOptionsT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(UnpackOptionsT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<UnpackOptions> Pack(flatbuffers::FlatBufferBuilder& _fbb, const UnpackOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct UnpackOptionsBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    void add_num(int32_t num)
    {
        fbb_.AddElement<int32_t>(UnpackOptions::VT_NUM, num, 0);
    }
    void add_axis(int32_t axis)
    {
        fbb_.AddElement<int32_t>(UnpackOptions::VT_AXIS, axis, 0);
    }
    explicit UnpackOptionsBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    UnpackOptionsBuilder& operator=(const UnpackOptionsBuilder&);
    flatbuffers::Offset<UnpackOptions> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<UnpackOptions>(end);
        return o;
    }
};

inline flatbuffers::Offset<UnpackOptions> CreateUnpackOptions(
    flatbuffers::FlatBufferBuilder& _fbb,
    int32_t num = 0,
    int32_t axis = 0)
{
    UnpackOptionsBuilder builder_(_fbb);
    builder_.add_axis(axis);
    builder_.add_num(num);
    return builder_.Finish();
}

flatbuffers::Offset<UnpackOptions> CreateUnpackOptions(flatbuffers::FlatBufferBuilder& _fbb, const UnpackOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct FloorDivOptionsT : public flatbuffers::NativeTable
{
    typedef FloorDivOptions TableType;
    FloorDivOptionsT()
    {
    }
};

struct FloorDivOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef FloorDivOptionsT NativeTableType;
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && verifier.EndTable();
    }
    FloorDivOptionsT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(FloorDivOptionsT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<FloorDivOptions> Pack(flatbuffers::FlatBufferBuilder& _fbb, const FloorDivOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct FloorDivOptionsBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    explicit FloorDivOptionsBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    FloorDivOptionsBuilder& operator=(const FloorDivOptionsBuilder&);
    flatbuffers::Offset<FloorDivOptions> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<FloorDivOptions>(end);
        return o;
    }
};

inline flatbuffers::Offset<FloorDivOptions> CreateFloorDivOptions(
    flatbuffers::FlatBufferBuilder& _fbb)
{
    FloorDivOptionsBuilder builder_(_fbb);
    return builder_.Finish();
}

flatbuffers::Offset<FloorDivOptions> CreateFloorDivOptions(flatbuffers::FlatBufferBuilder& _fbb, const FloorDivOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct SquareOptionsT : public flatbuffers::NativeTable
{
    typedef SquareOptions TableType;
    SquareOptionsT()
    {
    }
};

struct SquareOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef SquareOptionsT NativeTableType;
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && verifier.EndTable();
    }
    SquareOptionsT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(SquareOptionsT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<SquareOptions> Pack(flatbuffers::FlatBufferBuilder& _fbb, const SquareOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct SquareOptionsBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    explicit SquareOptionsBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    SquareOptionsBuilder& operator=(const SquareOptionsBuilder&);
    flatbuffers::Offset<SquareOptions> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<SquareOptions>(end);
        return o;
    }
};

inline flatbuffers::Offset<SquareOptions> CreateSquareOptions(
    flatbuffers::FlatBufferBuilder& _fbb)
{
    SquareOptionsBuilder builder_(_fbb);
    return builder_.Finish();
}

flatbuffers::Offset<SquareOptions> CreateSquareOptions(flatbuffers::FlatBufferBuilder& _fbb, const SquareOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct ZerosLikeOptionsT : public flatbuffers::NativeTable
{
    typedef ZerosLikeOptions TableType;
    ZerosLikeOptionsT()
    {
    }
};

struct ZerosLikeOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef ZerosLikeOptionsT NativeTableType;
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && verifier.EndTable();
    }
    ZerosLikeOptionsT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(ZerosLikeOptionsT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<ZerosLikeOptions> Pack(flatbuffers::FlatBufferBuilder& _fbb, const ZerosLikeOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct ZerosLikeOptionsBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    explicit ZerosLikeOptionsBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    ZerosLikeOptionsBuilder& operator=(const ZerosLikeOptionsBuilder&);
    flatbuffers::Offset<ZerosLikeOptions> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<ZerosLikeOptions>(end);
        return o;
    }
};

inline flatbuffers::Offset<ZerosLikeOptions> CreateZerosLikeOptions(
    flatbuffers::FlatBufferBuilder& _fbb)
{
    ZerosLikeOptionsBuilder builder_(_fbb);
    return builder_.Finish();
}

flatbuffers::Offset<ZerosLikeOptions> CreateZerosLikeOptions(flatbuffers::FlatBufferBuilder& _fbb, const ZerosLikeOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct FillOptionsT : public flatbuffers::NativeTable
{
    typedef FillOptions TableType;
    FillOptionsT()
    {
    }
};

struct FillOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef FillOptionsT NativeTableType;
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && verifier.EndTable();
    }
    FillOptionsT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(FillOptionsT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<FillOptions> Pack(flatbuffers::FlatBufferBuilder& _fbb, const FillOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct FillOptionsBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    explicit FillOptionsBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    FillOptionsBuilder& operator=(const FillOptionsBuilder&);
    flatbuffers::Offset<FillOptions> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<FillOptions>(end);
        return o;
    }
};

inline flatbuffers::Offset<FillOptions> CreateFillOptions(
    flatbuffers::FlatBufferBuilder& _fbb)
{
    FillOptionsBuilder builder_(_fbb);
    return builder_.Finish();
}

flatbuffers::Offset<FillOptions> CreateFillOptions(flatbuffers::FlatBufferBuilder& _fbb, const FillOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct FloorModOptionsT : public flatbuffers::NativeTable
{
    typedef FloorModOptions TableType;
    FloorModOptionsT()
    {
    }
};

struct FloorModOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef FloorModOptionsT NativeTableType;
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && verifier.EndTable();
    }
    FloorModOptionsT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(FloorModOptionsT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<FloorModOptions> Pack(flatbuffers::FlatBufferBuilder& _fbb, const FloorModOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct FloorModOptionsBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    explicit FloorModOptionsBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    FloorModOptionsBuilder& operator=(const FloorModOptionsBuilder&);
    flatbuffers::Offset<FloorModOptions> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<FloorModOptions>(end);
        return o;
    }
};

inline flatbuffers::Offset<FloorModOptions> CreateFloorModOptions(
    flatbuffers::FlatBufferBuilder& _fbb)
{
    FloorModOptionsBuilder builder_(_fbb);
    return builder_.Finish();
}

flatbuffers::Offset<FloorModOptions> CreateFloorModOptions(flatbuffers::FlatBufferBuilder& _fbb, const FloorModOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct RangeOptionsT : public flatbuffers::NativeTable
{
    typedef RangeOptions TableType;
    RangeOptionsT()
    {
    }
};

struct RangeOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef RangeOptionsT NativeTableType;
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && verifier.EndTable();
    }
    RangeOptionsT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(RangeOptionsT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<RangeOptions> Pack(flatbuffers::FlatBufferBuilder& _fbb, const RangeOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct RangeOptionsBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    explicit RangeOptionsBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    RangeOptionsBuilder& operator=(const RangeOptionsBuilder&);
    flatbuffers::Offset<RangeOptions> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<RangeOptions>(end);
        return o;
    }
};

inline flatbuffers::Offset<RangeOptions> CreateRangeOptions(
    flatbuffers::FlatBufferBuilder& _fbb)
{
    RangeOptionsBuilder builder_(_fbb);
    return builder_.Finish();
}

flatbuffers::Offset<RangeOptions> CreateRangeOptions(flatbuffers::FlatBufferBuilder& _fbb, const RangeOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct LeakyReluOptionsT : public flatbuffers::NativeTable
{
    typedef LeakyReluOptions TableType;
    float alpha;
    LeakyReluOptionsT()
        : alpha(0.0f)
    {
    }
};

struct LeakyReluOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef LeakyReluOptionsT NativeTableType;
    enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE
    {
        VT_ALPHA = 4
    };
    float alpha() const
    {
        return GetField<float>(VT_ALPHA, 0.0f);
    }
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && VerifyField<float>(verifier, VT_ALPHA) && verifier.EndTable();
    }
    LeakyReluOptionsT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(LeakyReluOptionsT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<LeakyReluOptions> Pack(flatbuffers::FlatBufferBuilder& _fbb, const LeakyReluOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct LeakyReluOptionsBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    void add_alpha(float alpha)
    {
        fbb_.AddElement<float>(LeakyReluOptions::VT_ALPHA, alpha, 0.0f);
    }
    explicit LeakyReluOptionsBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    LeakyReluOptionsBuilder& operator=(const LeakyReluOptionsBuilder&);
    flatbuffers::Offset<LeakyReluOptions> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<LeakyReluOptions>(end);
        return o;
    }
};

inline flatbuffers::Offset<LeakyReluOptions> CreateLeakyReluOptions(
    flatbuffers::FlatBufferBuilder& _fbb,
    float alpha = 0.0f)
{
    LeakyReluOptionsBuilder builder_(_fbb);
    builder_.add_alpha(alpha);
    return builder_.Finish();
}

flatbuffers::Offset<LeakyReluOptions> CreateLeakyReluOptions(flatbuffers::FlatBufferBuilder& _fbb, const LeakyReluOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct SquaredDifferenceOptionsT : public flatbuffers::NativeTable
{
    typedef SquaredDifferenceOptions TableType;
    SquaredDifferenceOptionsT()
    {
    }
};

struct SquaredDifferenceOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef SquaredDifferenceOptionsT NativeTableType;
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && verifier.EndTable();
    }
    SquaredDifferenceOptionsT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(SquaredDifferenceOptionsT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<SquaredDifferenceOptions> Pack(flatbuffers::FlatBufferBuilder& _fbb, const SquaredDifferenceOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct SquaredDifferenceOptionsBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    explicit SquaredDifferenceOptionsBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    SquaredDifferenceOptionsBuilder& operator=(const SquaredDifferenceOptionsBuilder&);
    flatbuffers::Offset<SquaredDifferenceOptions> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<SquaredDifferenceOptions>(end);
        return o;
    }
};

inline flatbuffers::Offset<SquaredDifferenceOptions> CreateSquaredDifferenceOptions(
    flatbuffers::FlatBufferBuilder& _fbb)
{
    SquaredDifferenceOptionsBuilder builder_(_fbb);
    return builder_.Finish();
}

flatbuffers::Offset<SquaredDifferenceOptions> CreateSquaredDifferenceOptions(flatbuffers::FlatBufferBuilder& _fbb, const SquaredDifferenceOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct MirrorPadOptionsT : public flatbuffers::NativeTable
{
    typedef MirrorPadOptions TableType;
    MirrorPadMode mode;
    MirrorPadOptionsT()
        : mode(MirrorPadMode_REFLECT)
    {
    }
};

struct MirrorPadOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef MirrorPadOptionsT NativeTableType;
    enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE
    {
        VT_MODE = 4
    };
    MirrorPadMode mode() const
    {
        return static_cast<MirrorPadMode>(GetField<int8_t>(VT_MODE, 0));
    }
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && VerifyField<int8_t>(verifier, VT_MODE) && verifier.EndTable();
    }
    MirrorPadOptionsT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(MirrorPadOptionsT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<MirrorPadOptions> Pack(flatbuffers::FlatBufferBuilder& _fbb, const MirrorPadOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct MirrorPadOptionsBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    void add_mode(MirrorPadMode mode)
    {
        fbb_.AddElement<int8_t>(MirrorPadOptions::VT_MODE, static_cast<int8_t>(mode), 0);
    }
    explicit MirrorPadOptionsBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    MirrorPadOptionsBuilder& operator=(const MirrorPadOptionsBuilder&);
    flatbuffers::Offset<MirrorPadOptions> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<MirrorPadOptions>(end);
        return o;
    }
};

inline flatbuffers::Offset<MirrorPadOptions> CreateMirrorPadOptions(
    flatbuffers::FlatBufferBuilder& _fbb,
    MirrorPadMode mode = MirrorPadMode_REFLECT)
{
    MirrorPadOptionsBuilder builder_(_fbb);
    builder_.add_mode(mode);
    return builder_.Finish();
}

flatbuffers::Offset<MirrorPadOptions> CreateMirrorPadOptions(flatbuffers::FlatBufferBuilder& _fbb, const MirrorPadOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct UniqueOptionsT : public flatbuffers::NativeTable
{
    typedef UniqueOptions TableType;
    TensorType idx_out_type;
    UniqueOptionsT()
        : idx_out_type(TensorType_INT32)
    {
    }
};

struct UniqueOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef UniqueOptionsT NativeTableType;
    enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE
    {
        VT_IDX_OUT_TYPE = 4
    };
    TensorType idx_out_type() const
    {
        return static_cast<TensorType>(GetField<int8_t>(VT_IDX_OUT_TYPE, 2));
    }
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && VerifyField<int8_t>(verifier, VT_IDX_OUT_TYPE) && verifier.EndTable();
    }
    UniqueOptionsT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(UniqueOptionsT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<UniqueOptions> Pack(flatbuffers::FlatBufferBuilder& _fbb, const UniqueOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct UniqueOptionsBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    void add_idx_out_type(TensorType idx_out_type)
    {
        fbb_.AddElement<int8_t>(UniqueOptions::VT_IDX_OUT_TYPE, static_cast<int8_t>(idx_out_type), 2);
    }
    explicit UniqueOptionsBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    UniqueOptionsBuilder& operator=(const UniqueOptionsBuilder&);
    flatbuffers::Offset<UniqueOptions> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<UniqueOptions>(end);
        return o;
    }
};

inline flatbuffers::Offset<UniqueOptions> CreateUniqueOptions(
    flatbuffers::FlatBufferBuilder& _fbb,
    TensorType idx_out_type = TensorType_INT32)
{
    UniqueOptionsBuilder builder_(_fbb);
    builder_.add_idx_out_type(idx_out_type);
    return builder_.Finish();
}

flatbuffers::Offset<UniqueOptions> CreateUniqueOptions(flatbuffers::FlatBufferBuilder& _fbb, const UniqueOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct ReverseV2OptionsT : public flatbuffers::NativeTable
{
    typedef ReverseV2Options TableType;
    ReverseV2OptionsT()
    {
    }
};

struct ReverseV2Options FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef ReverseV2OptionsT NativeTableType;
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && verifier.EndTable();
    }
    ReverseV2OptionsT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(ReverseV2OptionsT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<ReverseV2Options> Pack(flatbuffers::FlatBufferBuilder& _fbb, const ReverseV2OptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct ReverseV2OptionsBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    explicit ReverseV2OptionsBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    ReverseV2OptionsBuilder& operator=(const ReverseV2OptionsBuilder&);
    flatbuffers::Offset<ReverseV2Options> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<ReverseV2Options>(end);
        return o;
    }
};

inline flatbuffers::Offset<ReverseV2Options> CreateReverseV2Options(
    flatbuffers::FlatBufferBuilder& _fbb)
{
    ReverseV2OptionsBuilder builder_(_fbb);
    return builder_.Finish();
}

flatbuffers::Offset<ReverseV2Options> CreateReverseV2Options(flatbuffers::FlatBufferBuilder& _fbb, const ReverseV2OptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct AddNOptionsT : public flatbuffers::NativeTable
{
    typedef AddNOptions TableType;
    AddNOptionsT()
    {
    }
};

struct AddNOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef AddNOptionsT NativeTableType;
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && verifier.EndTable();
    }
    AddNOptionsT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(AddNOptionsT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<AddNOptions> Pack(flatbuffers::FlatBufferBuilder& _fbb, const AddNOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct AddNOptionsBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    explicit AddNOptionsBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    AddNOptionsBuilder& operator=(const AddNOptionsBuilder&);
    flatbuffers::Offset<AddNOptions> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<AddNOptions>(end);
        return o;
    }
};

inline flatbuffers::Offset<AddNOptions> CreateAddNOptions(
    flatbuffers::FlatBufferBuilder& _fbb)
{
    AddNOptionsBuilder builder_(_fbb);
    return builder_.Finish();
}

flatbuffers::Offset<AddNOptions> CreateAddNOptions(flatbuffers::FlatBufferBuilder& _fbb, const AddNOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct GatherNdOptionsT : public flatbuffers::NativeTable
{
    typedef GatherNdOptions TableType;
    GatherNdOptionsT()
    {
    }
};

struct GatherNdOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef GatherNdOptionsT NativeTableType;
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && verifier.EndTable();
    }
    GatherNdOptionsT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(GatherNdOptionsT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<GatherNdOptions> Pack(flatbuffers::FlatBufferBuilder& _fbb, const GatherNdOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct GatherNdOptionsBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    explicit GatherNdOptionsBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    GatherNdOptionsBuilder& operator=(const GatherNdOptionsBuilder&);
    flatbuffers::Offset<GatherNdOptions> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<GatherNdOptions>(end);
        return o;
    }
};

inline flatbuffers::Offset<GatherNdOptions> CreateGatherNdOptions(
    flatbuffers::FlatBufferBuilder& _fbb)
{
    GatherNdOptionsBuilder builder_(_fbb);
    return builder_.Finish();
}

flatbuffers::Offset<GatherNdOptions> CreateGatherNdOptions(flatbuffers::FlatBufferBuilder& _fbb, const GatherNdOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct WhereOptionsT : public flatbuffers::NativeTable
{
    typedef WhereOptions TableType;
    WhereOptionsT()
    {
    }
};

struct WhereOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef WhereOptionsT NativeTableType;
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && verifier.EndTable();
    }
    WhereOptionsT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(WhereOptionsT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<WhereOptions> Pack(flatbuffers::FlatBufferBuilder& _fbb, const WhereOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct WhereOptionsBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    explicit WhereOptionsBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    WhereOptionsBuilder& operator=(const WhereOptionsBuilder&);
    flatbuffers::Offset<WhereOptions> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<WhereOptions>(end);
        return o;
    }
};

inline flatbuffers::Offset<WhereOptions> CreateWhereOptions(
    flatbuffers::FlatBufferBuilder& _fbb)
{
    WhereOptionsBuilder builder_(_fbb);
    return builder_.Finish();
}

flatbuffers::Offset<WhereOptions> CreateWhereOptions(flatbuffers::FlatBufferBuilder& _fbb, const WhereOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct ReverseSequenceOptionsT : public flatbuffers::NativeTable
{
    typedef ReverseSequenceOptions TableType;
    int32_t seq_dim;
    int32_t batch_dim;
    ReverseSequenceOptionsT()
        : seq_dim(0),
          batch_dim(0)
    {
    }
};

struct ReverseSequenceOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef ReverseSequenceOptionsT NativeTableType;
    enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE
    {
        VT_SEQ_DIM = 4,
        VT_BATCH_DIM = 6
    };
    int32_t seq_dim() const
    {
        return GetField<int32_t>(VT_SEQ_DIM, 0);
    }
    int32_t batch_dim() const
    {
        return GetField<int32_t>(VT_BATCH_DIM, 0);
    }
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && VerifyField<int32_t>(verifier, VT_SEQ_DIM) && VerifyField<int32_t>(verifier, VT_BATCH_DIM) && verifier.EndTable();
    }
    ReverseSequenceOptionsT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(ReverseSequenceOptionsT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<ReverseSequenceOptions> Pack(flatbuffers::FlatBufferBuilder& _fbb, const ReverseSequenceOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct ReverseSequenceOptionsBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    void add_seq_dim(int32_t seq_dim)
    {
        fbb_.AddElement<int32_t>(ReverseSequenceOptions::VT_SEQ_DIM, seq_dim, 0);
    }
    void add_batch_dim(int32_t batch_dim)
    {
        fbb_.AddElement<int32_t>(ReverseSequenceOptions::VT_BATCH_DIM, batch_dim, 0);
    }
    explicit ReverseSequenceOptionsBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    ReverseSequenceOptionsBuilder& operator=(const ReverseSequenceOptionsBuilder&);
    flatbuffers::Offset<ReverseSequenceOptions> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<ReverseSequenceOptions>(end);
        return o;
    }
};

inline flatbuffers::Offset<ReverseSequenceOptions> CreateReverseSequenceOptions(
    flatbuffers::FlatBufferBuilder& _fbb,
    int32_t seq_dim = 0,
    int32_t batch_dim = 0)
{
    ReverseSequenceOptionsBuilder builder_(_fbb);
    builder_.add_batch_dim(batch_dim);
    builder_.add_seq_dim(seq_dim);
    return builder_.Finish();
}

flatbuffers::Offset<ReverseSequenceOptions> CreateReverseSequenceOptions(flatbuffers::FlatBufferBuilder& _fbb, const ReverseSequenceOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct MatrixDiagOptionsT : public flatbuffers::NativeTable
{
    typedef MatrixDiagOptions TableType;
    MatrixDiagOptionsT()
    {
    }
};

struct MatrixDiagOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef MatrixDiagOptionsT NativeTableType;
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && verifier.EndTable();
    }
    MatrixDiagOptionsT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(MatrixDiagOptionsT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<MatrixDiagOptions> Pack(flatbuffers::FlatBufferBuilder& _fbb, const MatrixDiagOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct MatrixDiagOptionsBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    explicit MatrixDiagOptionsBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    MatrixDiagOptionsBuilder& operator=(const MatrixDiagOptionsBuilder&);
    flatbuffers::Offset<MatrixDiagOptions> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<MatrixDiagOptions>(end);
        return o;
    }
};

inline flatbuffers::Offset<MatrixDiagOptions> CreateMatrixDiagOptions(
    flatbuffers::FlatBufferBuilder& _fbb)
{
    MatrixDiagOptionsBuilder builder_(_fbb);
    return builder_.Finish();
}

flatbuffers::Offset<MatrixDiagOptions> CreateMatrixDiagOptions(flatbuffers::FlatBufferBuilder& _fbb, const MatrixDiagOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct QuantizeOptionsT : public flatbuffers::NativeTable
{
    typedef QuantizeOptions TableType;
    QuantizeOptionsT()
    {
    }
};

struct QuantizeOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef QuantizeOptionsT NativeTableType;
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && verifier.EndTable();
    }
    QuantizeOptionsT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(QuantizeOptionsT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<QuantizeOptions> Pack(flatbuffers::FlatBufferBuilder& _fbb, const QuantizeOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct QuantizeOptionsBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    explicit QuantizeOptionsBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    QuantizeOptionsBuilder& operator=(const QuantizeOptionsBuilder&);
    flatbuffers::Offset<QuantizeOptions> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<QuantizeOptions>(end);
        return o;
    }
};

inline flatbuffers::Offset<QuantizeOptions> CreateQuantizeOptions(
    flatbuffers::FlatBufferBuilder& _fbb)
{
    QuantizeOptionsBuilder builder_(_fbb);
    return builder_.Finish();
}

flatbuffers::Offset<QuantizeOptions> CreateQuantizeOptions(flatbuffers::FlatBufferBuilder& _fbb, const QuantizeOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct MatrixSetDiagOptionsT : public flatbuffers::NativeTable
{
    typedef MatrixSetDiagOptions TableType;
    MatrixSetDiagOptionsT()
    {
    }
};

struct MatrixSetDiagOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef MatrixSetDiagOptionsT NativeTableType;
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && verifier.EndTable();
    }
    MatrixSetDiagOptionsT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(MatrixSetDiagOptionsT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<MatrixSetDiagOptions> Pack(flatbuffers::FlatBufferBuilder& _fbb, const MatrixSetDiagOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct MatrixSetDiagOptionsBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    explicit MatrixSetDiagOptionsBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    MatrixSetDiagOptionsBuilder& operator=(const MatrixSetDiagOptionsBuilder&);
    flatbuffers::Offset<MatrixSetDiagOptions> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<MatrixSetDiagOptions>(end);
        return o;
    }
};

inline flatbuffers::Offset<MatrixSetDiagOptions> CreateMatrixSetDiagOptions(
    flatbuffers::FlatBufferBuilder& _fbb)
{
    MatrixSetDiagOptionsBuilder builder_(_fbb);
    return builder_.Finish();
}

flatbuffers::Offset<MatrixSetDiagOptions> CreateMatrixSetDiagOptions(flatbuffers::FlatBufferBuilder& _fbb, const MatrixSetDiagOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct IfOptionsT : public flatbuffers::NativeTable
{
    typedef IfOptions TableType;
    int32_t then_subgraph_index;
    int32_t else_subgraph_index;
    IfOptionsT()
        : then_subgraph_index(0),
          else_subgraph_index(0)
    {
    }
};

struct IfOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef IfOptionsT NativeTableType;
    enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE
    {
        VT_THEN_SUBGRAPH_INDEX = 4,
        VT_ELSE_SUBGRAPH_INDEX = 6
    };
    int32_t then_subgraph_index() const
    {
        return GetField<int32_t>(VT_THEN_SUBGRAPH_INDEX, 0);
    }
    int32_t else_subgraph_index() const
    {
        return GetField<int32_t>(VT_ELSE_SUBGRAPH_INDEX, 0);
    }
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && VerifyField<int32_t>(verifier, VT_THEN_SUBGRAPH_INDEX) && VerifyField<int32_t>(verifier, VT_ELSE_SUBGRAPH_INDEX) && verifier.EndTable();
    }
    IfOptionsT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(IfOptionsT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<IfOptions> Pack(flatbuffers::FlatBufferBuilder& _fbb, const IfOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct IfOptionsBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    void add_then_subgraph_index(int32_t then_subgraph_index)
    {
        fbb_.AddElement<int32_t>(IfOptions::VT_THEN_SUBGRAPH_INDEX, then_subgraph_index, 0);
    }
    void add_else_subgraph_index(int32_t else_subgraph_index)
    {
        fbb_.AddElement<int32_t>(IfOptions::VT_ELSE_SUBGRAPH_INDEX, else_subgraph_index, 0);
    }
    explicit IfOptionsBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    IfOptionsBuilder& operator=(const IfOptionsBuilder&);
    flatbuffers::Offset<IfOptions> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<IfOptions>(end);
        return o;
    }
};

inline flatbuffers::Offset<IfOptions> CreateIfOptions(
    flatbuffers::FlatBufferBuilder& _fbb,
    int32_t then_subgraph_index = 0,
    int32_t else_subgraph_index = 0)
{
    IfOptionsBuilder builder_(_fbb);
    builder_.add_else_subgraph_index(else_subgraph_index);
    builder_.add_then_subgraph_index(then_subgraph_index);
    return builder_.Finish();
}

flatbuffers::Offset<IfOptions> CreateIfOptions(flatbuffers::FlatBufferBuilder& _fbb, const IfOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct WhileOptionsT : public flatbuffers::NativeTable
{
    typedef WhileOptions TableType;
    int32_t cond_subgraph_index;
    int32_t body_subgraph_index;
    WhileOptionsT()
        : cond_subgraph_index(0),
          body_subgraph_index(0)
    {
    }
};

struct WhileOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef WhileOptionsT NativeTableType;
    enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE
    {
        VT_COND_SUBGRAPH_INDEX = 4,
        VT_BODY_SUBGRAPH_INDEX = 6
    };
    int32_t cond_subgraph_index() const
    {
        return GetField<int32_t>(VT_COND_SUBGRAPH_INDEX, 0);
    }
    int32_t body_subgraph_index() const
    {
        return GetField<int32_t>(VT_BODY_SUBGRAPH_INDEX, 0);
    }
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && VerifyField<int32_t>(verifier, VT_COND_SUBGRAPH_INDEX) && VerifyField<int32_t>(verifier, VT_BODY_SUBGRAPH_INDEX) && verifier.EndTable();
    }
    WhileOptionsT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(WhileOptionsT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<WhileOptions> Pack(flatbuffers::FlatBufferBuilder& _fbb, const WhileOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct WhileOptionsBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    void add_cond_subgraph_index(int32_t cond_subgraph_index)
    {
        fbb_.AddElement<int32_t>(WhileOptions::VT_COND_SUBGRAPH_INDEX, cond_subgraph_index, 0);
    }
    void add_body_subgraph_index(int32_t body_subgraph_index)
    {
        fbb_.AddElement<int32_t>(WhileOptions::VT_BODY_SUBGRAPH_INDEX, body_subgraph_index, 0);
    }
    explicit WhileOptionsBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    WhileOptionsBuilder& operator=(const WhileOptionsBuilder&);
    flatbuffers::Offset<WhileOptions> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<WhileOptions>(end);
        return o;
    }
};

inline flatbuffers::Offset<WhileOptions> CreateWhileOptions(
    flatbuffers::FlatBufferBuilder& _fbb,
    int32_t cond_subgraph_index = 0,
    int32_t body_subgraph_index = 0)
{
    WhileOptionsBuilder builder_(_fbb);
    builder_.add_body_subgraph_index(body_subgraph_index);
    builder_.add_cond_subgraph_index(cond_subgraph_index);
    return builder_.Finish();
}

flatbuffers::Offset<WhileOptions> CreateWhileOptions(flatbuffers::FlatBufferBuilder& _fbb, const WhileOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct OperatorCodeT : public flatbuffers::NativeTable
{
    typedef OperatorCode TableType;
    BuiltinOperator builtin_code;
    std::string custom_code;
    int32_t version;
    OperatorCodeT()
        : builtin_code(BuiltinOperator_ADD),
          version(1)
    {
    }
};

struct OperatorCode FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef OperatorCodeT NativeTableType;
    enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE
    {
        VT_BUILTIN_CODE = 4,
        VT_CUSTOM_CODE = 6,
        VT_VERSION = 8
    };
    BuiltinOperator builtin_code() const
    {
        return static_cast<BuiltinOperator>(GetField<int8_t>(VT_BUILTIN_CODE, 0));
    }
    const flatbuffers::String* custom_code() const
    {
        return GetPointer<const flatbuffers::String*>(VT_CUSTOM_CODE);
    }
    int32_t version() const
    {
        return GetField<int32_t>(VT_VERSION, 1);
    }
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && VerifyField<int8_t>(verifier, VT_BUILTIN_CODE) && VerifyOffset(verifier, VT_CUSTOM_CODE) && verifier.VerifyString(custom_code()) && VerifyField<int32_t>(verifier, VT_VERSION) && verifier.EndTable();
    }
    OperatorCodeT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(OperatorCodeT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<OperatorCode> Pack(flatbuffers::FlatBufferBuilder& _fbb, const OperatorCodeT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct OperatorCodeBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    void add_builtin_code(BuiltinOperator builtin_code)
    {
        fbb_.AddElement<int8_t>(OperatorCode::VT_BUILTIN_CODE, static_cast<int8_t>(builtin_code), 0);
    }
    void add_custom_code(flatbuffers::Offset<flatbuffers::String> custom_code)
    {
        fbb_.AddOffset(OperatorCode::VT_CUSTOM_CODE, custom_code);
    }
    void add_version(int32_t version)
    {
        fbb_.AddElement<int32_t>(OperatorCode::VT_VERSION, version, 1);
    }
    explicit OperatorCodeBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    OperatorCodeBuilder& operator=(const OperatorCodeBuilder&);
    flatbuffers::Offset<OperatorCode> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<OperatorCode>(end);
        return o;
    }
};

inline flatbuffers::Offset<OperatorCode> CreateOperatorCode(
    flatbuffers::FlatBufferBuilder& _fbb,
    BuiltinOperator builtin_code = BuiltinOperator_ADD,
    flatbuffers::Offset<flatbuffers::String> custom_code = 0,
    int32_t version = 1)
{
    OperatorCodeBuilder builder_(_fbb);
    builder_.add_version(version);
    builder_.add_custom_code(custom_code);
    builder_.add_builtin_code(builtin_code);
    return builder_.Finish();
}

inline flatbuffers::Offset<OperatorCode> CreateOperatorCodeDirect(
    flatbuffers::FlatBufferBuilder& _fbb,
    BuiltinOperator builtin_code = BuiltinOperator_ADD,
    const char* custom_code = nullptr,
    int32_t version = 1)
{
    auto custom_code__ = custom_code ? _fbb.CreateString(custom_code) : 0;
    return tflite::CreateOperatorCode(
        _fbb,
        builtin_code,
        custom_code__,
        version);
}

flatbuffers::Offset<OperatorCode> CreateOperatorCode(flatbuffers::FlatBufferBuilder& _fbb, const OperatorCodeT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct OperatorT : public flatbuffers::NativeTable
{
    typedef Operator TableType;
    uint32_t opcode_index;
    std::vector<int32_t> inputs;
    std::vector<int32_t> outputs;
    BuiltinOptionsUnion builtin_options;
    std::vector<uint8_t> custom_options;
    CustomOptionsFormat custom_options_format;
    std::vector<bool> mutating_variable_inputs;
    std::vector<int32_t> intermediates;
    OperatorT()
        : opcode_index(0),
          custom_options_format(CustomOptionsFormat_FLEXBUFFERS)
    {
    }
};

struct Operator FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef OperatorT NativeTableType;
    enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE
    {
        VT_OPCODE_INDEX = 4,
        VT_INPUTS = 6,
        VT_OUTPUTS = 8,
        VT_BUILTIN_OPTIONS_TYPE = 10,
        VT_BUILTIN_OPTIONS = 12,
        VT_CUSTOM_OPTIONS = 14,
        VT_CUSTOM_OPTIONS_FORMAT = 16,
        VT_MUTATING_VARIABLE_INPUTS = 18,
        VT_INTERMEDIATES = 20
    };
    uint32_t opcode_index() const
    {
        return GetField<uint32_t>(VT_OPCODE_INDEX, 0);
    }
    const flatbuffers::Vector<int32_t>* inputs() const
    {
        return GetPointer<const flatbuffers::Vector<int32_t>*>(VT_INPUTS);
    }
    const flatbuffers::Vector<int32_t>* outputs() const
    {
        return GetPointer<const flatbuffers::Vector<int32_t>*>(VT_OUTPUTS);
    }
    BuiltinOptions builtin_options_type() const
    {
        return static_cast<BuiltinOptions>(GetField<uint8_t>(VT_BUILTIN_OPTIONS_TYPE, 0));
    }
    const void* builtin_options() const
    {
        return GetPointer<const void*>(VT_BUILTIN_OPTIONS);
    }
    template<typename T>
    const T* builtin_options_as() const;
    const Conv2DOptions* builtin_options_as_Conv2DOptions() const
    {
        return builtin_options_type() == BuiltinOptions_Conv2DOptions ? static_cast<const Conv2DOptions*>(builtin_options()) : nullptr;
    }
    const DepthwiseConv2DOptions* builtin_options_as_DepthwiseConv2DOptions() const
    {
        return builtin_options_type() == BuiltinOptions_DepthwiseConv2DOptions ? static_cast<const DepthwiseConv2DOptions*>(builtin_options()) : nullptr;
    }
    const ConcatEmbeddingsOptions* builtin_options_as_ConcatEmbeddingsOptions() const
    {
        return builtin_options_type() == BuiltinOptions_ConcatEmbeddingsOptions ? static_cast<const ConcatEmbeddingsOptions*>(builtin_options()) : nullptr;
    }
    const LSHProjectionOptions* builtin_options_as_LSHProjectionOptions() const
    {
        return builtin_options_type() == BuiltinOptions_LSHProjectionOptions ? static_cast<const LSHProjectionOptions*>(builtin_options()) : nullptr;
    }
    const Pool2DOptions* builtin_options_as_Pool2DOptions() const
    {
        return builtin_options_type() == BuiltinOptions_Pool2DOptions ? static_cast<const Pool2DOptions*>(builtin_options()) : nullptr;
    }
    const SVDFOptions* builtin_options_as_SVDFOptions() const
    {
        return builtin_options_type() == BuiltinOptions_SVDFOptions ? static_cast<const SVDFOptions*>(builtin_options()) : nullptr;
    }
    const RNNOptions* builtin_options_as_RNNOptions() const
    {
        return builtin_options_type() == BuiltinOptions_RNNOptions ? static_cast<const RNNOptions*>(builtin_options()) : nullptr;
    }
    const FullyConnectedOptions* builtin_options_as_FullyConnectedOptions() const
    {
        return builtin_options_type() == BuiltinOptions_FullyConnectedOptions ? static_cast<const FullyConnectedOptions*>(builtin_options()) : nullptr;
    }
    const SoftmaxOptions* builtin_options_as_SoftmaxOptions() const
    {
        return builtin_options_type() == BuiltinOptions_SoftmaxOptions ? static_cast<const SoftmaxOptions*>(builtin_options()) : nullptr;
    }
    const ConcatenationOptions* builtin_options_as_ConcatenationOptions() const
    {
        return builtin_options_type() == BuiltinOptions_ConcatenationOptions ? static_cast<const ConcatenationOptions*>(builtin_options()) : nullptr;
    }
    const AddOptions* builtin_options_as_AddOptions() const
    {
        return builtin_options_type() == BuiltinOptions_AddOptions ? static_cast<const AddOptions*>(builtin_options()) : nullptr;
    }
    const L2NormOptions* builtin_options_as_L2NormOptions() const
    {
        return builtin_options_type() == BuiltinOptions_L2NormOptions ? static_cast<const L2NormOptions*>(builtin_options()) : nullptr;
    }
    const LocalResponseNormalizationOptions* builtin_options_as_LocalResponseNormalizationOptions() const
    {
        return builtin_options_type() == BuiltinOptions_LocalResponseNormalizationOptions ? static_cast<const LocalResponseNormalizationOptions*>(builtin_options()) : nullptr;
    }
    const LSTMOptions* builtin_options_as_LSTMOptions() const
    {
        return builtin_options_type() == BuiltinOptions_LSTMOptions ? static_cast<const LSTMOptions*>(builtin_options()) : nullptr;
    }
    const ResizeBilinearOptions* builtin_options_as_ResizeBilinearOptions() const
    {
        return builtin_options_type() == BuiltinOptions_ResizeBilinearOptions ? static_cast<const ResizeBilinearOptions*>(builtin_options()) : nullptr;
    }
    const CallOptions* builtin_options_as_CallOptions() const
    {
        return builtin_options_type() == BuiltinOptions_CallOptions ? static_cast<const CallOptions*>(builtin_options()) : nullptr;
    }
    const ReshapeOptions* builtin_options_as_ReshapeOptions() const
    {
        return builtin_options_type() == BuiltinOptions_ReshapeOptions ? static_cast<const ReshapeOptions*>(builtin_options()) : nullptr;
    }
    const SkipGramOptions* builtin_options_as_SkipGramOptions() const
    {
        return builtin_options_type() == BuiltinOptions_SkipGramOptions ? static_cast<const SkipGramOptions*>(builtin_options()) : nullptr;
    }
    const SpaceToDepthOptions* builtin_options_as_SpaceToDepthOptions() const
    {
        return builtin_options_type() == BuiltinOptions_SpaceToDepthOptions ? static_cast<const SpaceToDepthOptions*>(builtin_options()) : nullptr;
    }
    const EmbeddingLookupSparseOptions* builtin_options_as_EmbeddingLookupSparseOptions() const
    {
        return builtin_options_type() == BuiltinOptions_EmbeddingLookupSparseOptions ? static_cast<const EmbeddingLookupSparseOptions*>(builtin_options()) : nullptr;
    }
    const MulOptions* builtin_options_as_MulOptions() const
    {
        return builtin_options_type() == BuiltinOptions_MulOptions ? static_cast<const MulOptions*>(builtin_options()) : nullptr;
    }
    const PadOptions* builtin_options_as_PadOptions() const
    {
        return builtin_options_type() == BuiltinOptions_PadOptions ? static_cast<const PadOptions*>(builtin_options()) : nullptr;
    }
    const GatherOptions* builtin_options_as_GatherOptions() const
    {
        return builtin_options_type() == BuiltinOptions_GatherOptions ? static_cast<const GatherOptions*>(builtin_options()) : nullptr;
    }
    const BatchToSpaceNDOptions* builtin_options_as_BatchToSpaceNDOptions() const
    {
        return builtin_options_type() == BuiltinOptions_BatchToSpaceNDOptions ? static_cast<const BatchToSpaceNDOptions*>(builtin_options()) : nullptr;
    }
    const SpaceToBatchNDOptions* builtin_options_as_SpaceToBatchNDOptions() const
    {
        return builtin_options_type() == BuiltinOptions_SpaceToBatchNDOptions ? static_cast<const SpaceToBatchNDOptions*>(builtin_options()) : nullptr;
    }
    const TransposeOptions* builtin_options_as_TransposeOptions() const
    {
        return builtin_options_type() == BuiltinOptions_TransposeOptions ? static_cast<const TransposeOptions*>(builtin_options()) : nullptr;
    }
    const ReducerOptions* builtin_options_as_ReducerOptions() const
    {
        return builtin_options_type() == BuiltinOptions_ReducerOptions ? static_cast<const ReducerOptions*>(builtin_options()) : nullptr;
    }
    const SubOptions* builtin_options_as_SubOptions() const
    {
        return builtin_options_type() == BuiltinOptions_SubOptions ? static_cast<const SubOptions*>(builtin_options()) : nullptr;
    }
    const DivOptions* builtin_options_as_DivOptions() const
    {
        return builtin_options_type() == BuiltinOptions_DivOptions ? static_cast<const DivOptions*>(builtin_options()) : nullptr;
    }
    const SqueezeOptions* builtin_options_as_SqueezeOptions() const
    {
        return builtin_options_type() == BuiltinOptions_SqueezeOptions ? static_cast<const SqueezeOptions*>(builtin_options()) : nullptr;
    }
    const SequenceRNNOptions* builtin_options_as_SequenceRNNOptions() const
    {
        return builtin_options_type() == BuiltinOptions_SequenceRNNOptions ? static_cast<const SequenceRNNOptions*>(builtin_options()) : nullptr;
    }
    const StridedSliceOptions* builtin_options_as_StridedSliceOptions() const
    {
        return builtin_options_type() == BuiltinOptions_StridedSliceOptions ? static_cast<const StridedSliceOptions*>(builtin_options()) : nullptr;
    }
    const ExpOptions* builtin_options_as_ExpOptions() const
    {
        return builtin_options_type() == BuiltinOptions_ExpOptions ? static_cast<const ExpOptions*>(builtin_options()) : nullptr;
    }
    const TopKV2Options* builtin_options_as_TopKV2Options() const
    {
        return builtin_options_type() == BuiltinOptions_TopKV2Options ? static_cast<const TopKV2Options*>(builtin_options()) : nullptr;
    }
    const SplitOptions* builtin_options_as_SplitOptions() const
    {
        return builtin_options_type() == BuiltinOptions_SplitOptions ? static_cast<const SplitOptions*>(builtin_options()) : nullptr;
    }
    const LogSoftmaxOptions* builtin_options_as_LogSoftmaxOptions() const
    {
        return builtin_options_type() == BuiltinOptions_LogSoftmaxOptions ? static_cast<const LogSoftmaxOptions*>(builtin_options()) : nullptr;
    }
    const CastOptions* builtin_options_as_CastOptions() const
    {
        return builtin_options_type() == BuiltinOptions_CastOptions ? static_cast<const CastOptions*>(builtin_options()) : nullptr;
    }
    const DequantizeOptions* builtin_options_as_DequantizeOptions() const
    {
        return builtin_options_type() == BuiltinOptions_DequantizeOptions ? static_cast<const DequantizeOptions*>(builtin_options()) : nullptr;
    }
    const MaximumMinimumOptions* builtin_options_as_MaximumMinimumOptions() const
    {
        return builtin_options_type() == BuiltinOptions_MaximumMinimumOptions ? static_cast<const MaximumMinimumOptions*>(builtin_options()) : nullptr;
    }
    const ArgMaxOptions* builtin_options_as_ArgMaxOptions() const
    {
        return builtin_options_type() == BuiltinOptions_ArgMaxOptions ? static_cast<const ArgMaxOptions*>(builtin_options()) : nullptr;
    }
    const LessOptions* builtin_options_as_LessOptions() const
    {
        return builtin_options_type() == BuiltinOptions_LessOptions ? static_cast<const LessOptions*>(builtin_options()) : nullptr;
    }
    const NegOptions* builtin_options_as_NegOptions() const
    {
        return builtin_options_type() == BuiltinOptions_NegOptions ? static_cast<const NegOptions*>(builtin_options()) : nullptr;
    }
    const PadV2Options* builtin_options_as_PadV2Options() const
    {
        return builtin_options_type() == BuiltinOptions_PadV2Options ? static_cast<const PadV2Options*>(builtin_options()) : nullptr;
    }
    const GreaterOptions* builtin_options_as_GreaterOptions() const
    {
        return builtin_options_type() == BuiltinOptions_GreaterOptions ? static_cast<const GreaterOptions*>(builtin_options()) : nullptr;
    }
    const GreaterEqualOptions* builtin_options_as_GreaterEqualOptions() const
    {
        return builtin_options_type() == BuiltinOptions_GreaterEqualOptions ? static_cast<const GreaterEqualOptions*>(builtin_options()) : nullptr;
    }
    const LessEqualOptions* builtin_options_as_LessEqualOptions() const
    {
        return builtin_options_type() == BuiltinOptions_LessEqualOptions ? static_cast<const LessEqualOptions*>(builtin_options()) : nullptr;
    }
    const SelectOptions* builtin_options_as_SelectOptions() const
    {
        return builtin_options_type() == BuiltinOptions_SelectOptions ? static_cast<const SelectOptions*>(builtin_options()) : nullptr;
    }
    const SliceOptions* builtin_options_as_SliceOptions() const
    {
        return builtin_options_type() == BuiltinOptions_SliceOptions ? static_cast<const SliceOptions*>(builtin_options()) : nullptr;
    }
    const TransposeConvOptions* builtin_options_as_TransposeConvOptions() const
    {
        return builtin_options_type() == BuiltinOptions_TransposeConvOptions ? static_cast<const TransposeConvOptions*>(builtin_options()) : nullptr;
    }
    const SparseToDenseOptions* builtin_options_as_SparseToDenseOptions() const
    {
        return builtin_options_type() == BuiltinOptions_SparseToDenseOptions ? static_cast<const SparseToDenseOptions*>(builtin_options()) : nullptr;
    }
    const TileOptions* builtin_options_as_TileOptions() const
    {
        return builtin_options_type() == BuiltinOptions_TileOptions ? static_cast<const TileOptions*>(builtin_options()) : nullptr;
    }
    const ExpandDimsOptions* builtin_options_as_ExpandDimsOptions() const
    {
        return builtin_options_type() == BuiltinOptions_ExpandDimsOptions ? static_cast<const ExpandDimsOptions*>(builtin_options()) : nullptr;
    }
    const EqualOptions* builtin_options_as_EqualOptions() const
    {
        return builtin_options_type() == BuiltinOptions_EqualOptions ? static_cast<const EqualOptions*>(builtin_options()) : nullptr;
    }
    const NotEqualOptions* builtin_options_as_NotEqualOptions() const
    {
        return builtin_options_type() == BuiltinOptions_NotEqualOptions ? static_cast<const NotEqualOptions*>(builtin_options()) : nullptr;
    }
    const ShapeOptions* builtin_options_as_ShapeOptions() const
    {
        return builtin_options_type() == BuiltinOptions_ShapeOptions ? static_cast<const ShapeOptions*>(builtin_options()) : nullptr;
    }
    const PowOptions* builtin_options_as_PowOptions() const
    {
        return builtin_options_type() == BuiltinOptions_PowOptions ? static_cast<const PowOptions*>(builtin_options()) : nullptr;
    }
    const ArgMinOptions* builtin_options_as_ArgMinOptions() const
    {
        return builtin_options_type() == BuiltinOptions_ArgMinOptions ? static_cast<const ArgMinOptions*>(builtin_options()) : nullptr;
    }
    const FakeQuantOptions* builtin_options_as_FakeQuantOptions() const
    {
        return builtin_options_type() == BuiltinOptions_FakeQuantOptions ? static_cast<const FakeQuantOptions*>(builtin_options()) : nullptr;
    }
    const PackOptions* builtin_options_as_PackOptions() const
    {
        return builtin_options_type() == BuiltinOptions_PackOptions ? static_cast<const PackOptions*>(builtin_options()) : nullptr;
    }
    const LogicalOrOptions* builtin_options_as_LogicalOrOptions() const
    {
        return builtin_options_type() == BuiltinOptions_LogicalOrOptions ? static_cast<const LogicalOrOptions*>(builtin_options()) : nullptr;
    }
    const OneHotOptions* builtin_options_as_OneHotOptions() const
    {
        return builtin_options_type() == BuiltinOptions_OneHotOptions ? static_cast<const OneHotOptions*>(builtin_options()) : nullptr;
    }
    const LogicalAndOptions* builtin_options_as_LogicalAndOptions() const
    {
        return builtin_options_type() == BuiltinOptions_LogicalAndOptions ? static_cast<const LogicalAndOptions*>(builtin_options()) : nullptr;
    }
    const LogicalNotOptions* builtin_options_as_LogicalNotOptions() const
    {
        return builtin_options_type() == BuiltinOptions_LogicalNotOptions ? static_cast<const LogicalNotOptions*>(builtin_options()) : nullptr;
    }
    const UnpackOptions* builtin_options_as_UnpackOptions() const
    {
        return builtin_options_type() == BuiltinOptions_UnpackOptions ? static_cast<const UnpackOptions*>(builtin_options()) : nullptr;
    }
    const FloorDivOptions* builtin_options_as_FloorDivOptions() const
    {
        return builtin_options_type() == BuiltinOptions_FloorDivOptions ? static_cast<const FloorDivOptions*>(builtin_options()) : nullptr;
    }
    const SquareOptions* builtin_options_as_SquareOptions() const
    {
        return builtin_options_type() == BuiltinOptions_SquareOptions ? static_cast<const SquareOptions*>(builtin_options()) : nullptr;
    }
    const ZerosLikeOptions* builtin_options_as_ZerosLikeOptions() const
    {
        return builtin_options_type() == BuiltinOptions_ZerosLikeOptions ? static_cast<const ZerosLikeOptions*>(builtin_options()) : nullptr;
    }
    const FillOptions* builtin_options_as_FillOptions() const
    {
        return builtin_options_type() == BuiltinOptions_FillOptions ? static_cast<const FillOptions*>(builtin_options()) : nullptr;
    }
    const BidirectionalSequenceLSTMOptions* builtin_options_as_BidirectionalSequenceLSTMOptions() const
    {
        return builtin_options_type() == BuiltinOptions_BidirectionalSequenceLSTMOptions ? static_cast<const BidirectionalSequenceLSTMOptions*>(builtin_options()) : nullptr;
    }
    const BidirectionalSequenceRNNOptions* builtin_options_as_BidirectionalSequenceRNNOptions() const
    {
        return builtin_options_type() == BuiltinOptions_BidirectionalSequenceRNNOptions ? static_cast<const BidirectionalSequenceRNNOptions*>(builtin_options()) : nullptr;
    }
    const UnidirectionalSequenceLSTMOptions* builtin_options_as_UnidirectionalSequenceLSTMOptions() const
    {
        return builtin_options_type() == BuiltinOptions_UnidirectionalSequenceLSTMOptions ? static_cast<const UnidirectionalSequenceLSTMOptions*>(builtin_options()) : nullptr;
    }
    const FloorModOptions* builtin_options_as_FloorModOptions() const
    {
        return builtin_options_type() == BuiltinOptions_FloorModOptions ? static_cast<const FloorModOptions*>(builtin_options()) : nullptr;
    }
    const RangeOptions* builtin_options_as_RangeOptions() const
    {
        return builtin_options_type() == BuiltinOptions_RangeOptions ? static_cast<const RangeOptions*>(builtin_options()) : nullptr;
    }
    const ResizeNearestNeighborOptions* builtin_options_as_ResizeNearestNeighborOptions() const
    {
        return builtin_options_type() == BuiltinOptions_ResizeNearestNeighborOptions ? static_cast<const ResizeNearestNeighborOptions*>(builtin_options()) : nullptr;
    }
    const LeakyReluOptions* builtin_options_as_LeakyReluOptions() const
    {
        return builtin_options_type() == BuiltinOptions_LeakyReluOptions ? static_cast<const LeakyReluOptions*>(builtin_options()) : nullptr;
    }
    const SquaredDifferenceOptions* builtin_options_as_SquaredDifferenceOptions() const
    {
        return builtin_options_type() == BuiltinOptions_SquaredDifferenceOptions ? static_cast<const SquaredDifferenceOptions*>(builtin_options()) : nullptr;
    }
    const MirrorPadOptions* builtin_options_as_MirrorPadOptions() const
    {
        return builtin_options_type() == BuiltinOptions_MirrorPadOptions ? static_cast<const MirrorPadOptions*>(builtin_options()) : nullptr;
    }
    const AbsOptions* builtin_options_as_AbsOptions() const
    {
        return builtin_options_type() == BuiltinOptions_AbsOptions ? static_cast<const AbsOptions*>(builtin_options()) : nullptr;
    }
    const SplitVOptions* builtin_options_as_SplitVOptions() const
    {
        return builtin_options_type() == BuiltinOptions_SplitVOptions ? static_cast<const SplitVOptions*>(builtin_options()) : nullptr;
    }
    const UniqueOptions* builtin_options_as_UniqueOptions() const
    {
        return builtin_options_type() == BuiltinOptions_UniqueOptions ? static_cast<const UniqueOptions*>(builtin_options()) : nullptr;
    }
    const ReverseV2Options* builtin_options_as_ReverseV2Options() const
    {
        return builtin_options_type() == BuiltinOptions_ReverseV2Options ? static_cast<const ReverseV2Options*>(builtin_options()) : nullptr;
    }
    const AddNOptions* builtin_options_as_AddNOptions() const
    {
        return builtin_options_type() == BuiltinOptions_AddNOptions ? static_cast<const AddNOptions*>(builtin_options()) : nullptr;
    }
    const GatherNdOptions* builtin_options_as_GatherNdOptions() const
    {
        return builtin_options_type() == BuiltinOptions_GatherNdOptions ? static_cast<const GatherNdOptions*>(builtin_options()) : nullptr;
    }
    const CosOptions* builtin_options_as_CosOptions() const
    {
        return builtin_options_type() == BuiltinOptions_CosOptions ? static_cast<const CosOptions*>(builtin_options()) : nullptr;
    }
    const WhereOptions* builtin_options_as_WhereOptions() const
    {
        return builtin_options_type() == BuiltinOptions_WhereOptions ? static_cast<const WhereOptions*>(builtin_options()) : nullptr;
    }
    const RankOptions* builtin_options_as_RankOptions() const
    {
        return builtin_options_type() == BuiltinOptions_RankOptions ? static_cast<const RankOptions*>(builtin_options()) : nullptr;
    }
    const ReverseSequenceOptions* builtin_options_as_ReverseSequenceOptions() const
    {
        return builtin_options_type() == BuiltinOptions_ReverseSequenceOptions ? static_cast<const ReverseSequenceOptions*>(builtin_options()) : nullptr;
    }
    const MatrixDiagOptions* builtin_options_as_MatrixDiagOptions() const
    {
        return builtin_options_type() == BuiltinOptions_MatrixDiagOptions ? static_cast<const MatrixDiagOptions*>(builtin_options()) : nullptr;
    }
    const QuantizeOptions* builtin_options_as_QuantizeOptions() const
    {
        return builtin_options_type() == BuiltinOptions_QuantizeOptions ? static_cast<const QuantizeOptions*>(builtin_options()) : nullptr;
    }
    const MatrixSetDiagOptions* builtin_options_as_MatrixSetDiagOptions() const
    {
        return builtin_options_type() == BuiltinOptions_MatrixSetDiagOptions ? static_cast<const MatrixSetDiagOptions*>(builtin_options()) : nullptr;
    }
    const HardSwishOptions* builtin_options_as_HardSwishOptions() const
    {
        return builtin_options_type() == BuiltinOptions_HardSwishOptions ? static_cast<const HardSwishOptions*>(builtin_options()) : nullptr;
    }
    const IfOptions* builtin_options_as_IfOptions() const
    {
        return builtin_options_type() == BuiltinOptions_IfOptions ? static_cast<const IfOptions*>(builtin_options()) : nullptr;
    }
    const WhileOptions* builtin_options_as_WhileOptions() const
    {
        return builtin_options_type() == BuiltinOptions_WhileOptions ? static_cast<const WhileOptions*>(builtin_options()) : nullptr;
    }
    const flatbuffers::Vector<uint8_t>* custom_options() const
    {
        return GetPointer<const flatbuffers::Vector<uint8_t>*>(VT_CUSTOM_OPTIONS);
    }
    CustomOptionsFormat custom_options_format() const
    {
        return static_cast<CustomOptionsFormat>(GetField<int8_t>(VT_CUSTOM_OPTIONS_FORMAT, 0));
    }
    const flatbuffers::Vector<uint8_t>* mutating_variable_inputs() const
    {
        return GetPointer<const flatbuffers::Vector<uint8_t>*>(VT_MUTATING_VARIABLE_INPUTS);
    }
    const flatbuffers::Vector<int32_t>* intermediates() const
    {
        return GetPointer<const flatbuffers::Vector<int32_t>*>(VT_INTERMEDIATES);
    }
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && VerifyField<uint32_t>(verifier, VT_OPCODE_INDEX) && VerifyOffset(verifier, VT_INPUTS) && verifier.VerifyVector(inputs()) && VerifyOffset(verifier, VT_OUTPUTS) && verifier.VerifyVector(outputs()) && VerifyField<uint8_t>(verifier, VT_BUILTIN_OPTIONS_TYPE) && VerifyOffset(verifier, VT_BUILTIN_OPTIONS) && VerifyBuiltinOptions(verifier, builtin_options(), builtin_options_type()) && VerifyOffset(verifier, VT_CUSTOM_OPTIONS) && verifier.VerifyVector(custom_options()) && VerifyField<int8_t>(verifier, VT_CUSTOM_OPTIONS_FORMAT) && VerifyOffset(verifier, VT_MUTATING_VARIABLE_INPUTS) && verifier.VerifyVector(mutating_variable_inputs()) && VerifyOffset(verifier, VT_INTERMEDIATES) && verifier.VerifyVector(intermediates()) && verifier.EndTable();
    }
    OperatorT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(OperatorT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<Operator> Pack(flatbuffers::FlatBufferBuilder& _fbb, const OperatorT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

template<>
inline const Conv2DOptions* Operator::builtin_options_as<Conv2DOptions>() const
{
    return builtin_options_as_Conv2DOptions();
}

template<>
inline const DepthwiseConv2DOptions* Operator::builtin_options_as<DepthwiseConv2DOptions>() const
{
    return builtin_options_as_DepthwiseConv2DOptions();
}

template<>
inline const ConcatEmbeddingsOptions* Operator::builtin_options_as<ConcatEmbeddingsOptions>() const
{
    return builtin_options_as_ConcatEmbeddingsOptions();
}

template<>
inline const LSHProjectionOptions* Operator::builtin_options_as<LSHProjectionOptions>() const
{
    return builtin_options_as_LSHProjectionOptions();
}

template<>
inline const Pool2DOptions* Operator::builtin_options_as<Pool2DOptions>() const
{
    return builtin_options_as_Pool2DOptions();
}

template<>
inline const SVDFOptions* Operator::builtin_options_as<SVDFOptions>() const
{
    return builtin_options_as_SVDFOptions();
}

template<>
inline const RNNOptions* Operator::builtin_options_as<RNNOptions>() const
{
    return builtin_options_as_RNNOptions();
}

template<>
inline const FullyConnectedOptions* Operator::builtin_options_as<FullyConnectedOptions>() const
{
    return builtin_options_as_FullyConnectedOptions();
}

template<>
inline const SoftmaxOptions* Operator::builtin_options_as<SoftmaxOptions>() const
{
    return builtin_options_as_SoftmaxOptions();
}

template<>
inline const ConcatenationOptions* Operator::builtin_options_as<ConcatenationOptions>() const
{
    return builtin_options_as_ConcatenationOptions();
}

template<>
inline const AddOptions* Operator::builtin_options_as<AddOptions>() const
{
    return builtin_options_as_AddOptions();
}

template<>
inline const L2NormOptions* Operator::builtin_options_as<L2NormOptions>() const
{
    return builtin_options_as_L2NormOptions();
}

template<>
inline const LocalResponseNormalizationOptions* Operator::builtin_options_as<LocalResponseNormalizationOptions>() const
{
    return builtin_options_as_LocalResponseNormalizationOptions();
}

template<>
inline const LSTMOptions* Operator::builtin_options_as<LSTMOptions>() const
{
    return builtin_options_as_LSTMOptions();
}

template<>
inline const ResizeBilinearOptions* Operator::builtin_options_as<ResizeBilinearOptions>() const
{
    return builtin_options_as_ResizeBilinearOptions();
}

template<>
inline const CallOptions* Operator::builtin_options_as<CallOptions>() const
{
    return builtin_options_as_CallOptions();
}

template<>
inline const ReshapeOptions* Operator::builtin_options_as<ReshapeOptions>() const
{
    return builtin_options_as_ReshapeOptions();
}

template<>
inline const SkipGramOptions* Operator::builtin_options_as<SkipGramOptions>() const
{
    return builtin_options_as_SkipGramOptions();
}

template<>
inline const SpaceToDepthOptions* Operator::builtin_options_as<SpaceToDepthOptions>() const
{
    return builtin_options_as_SpaceToDepthOptions();
}

template<>
inline const EmbeddingLookupSparseOptions* Operator::builtin_options_as<EmbeddingLookupSparseOptions>() const
{
    return builtin_options_as_EmbeddingLookupSparseOptions();
}

template<>
inline const MulOptions* Operator::builtin_options_as<MulOptions>() const
{
    return builtin_options_as_MulOptions();
}

template<>
inline const PadOptions* Operator::builtin_options_as<PadOptions>() const
{
    return builtin_options_as_PadOptions();
}

template<>
inline const GatherOptions* Operator::builtin_options_as<GatherOptions>() const
{
    return builtin_options_as_GatherOptions();
}

template<>
inline const BatchToSpaceNDOptions* Operator::builtin_options_as<BatchToSpaceNDOptions>() const
{
    return builtin_options_as_BatchToSpaceNDOptions();
}

template<>
inline const SpaceToBatchNDOptions* Operator::builtin_options_as<SpaceToBatchNDOptions>() const
{
    return builtin_options_as_SpaceToBatchNDOptions();
}

template<>
inline const TransposeOptions* Operator::builtin_options_as<TransposeOptions>() const
{
    return builtin_options_as_TransposeOptions();
}

template<>
inline const ReducerOptions* Operator::builtin_options_as<ReducerOptions>() const
{
    return builtin_options_as_ReducerOptions();
}

template<>
inline const SubOptions* Operator::builtin_options_as<SubOptions>() const
{
    return builtin_options_as_SubOptions();
}

template<>
inline const DivOptions* Operator::builtin_options_as<DivOptions>() const
{
    return builtin_options_as_DivOptions();
}

template<>
inline const SqueezeOptions* Operator::builtin_options_as<SqueezeOptions>() const
{
    return builtin_options_as_SqueezeOptions();
}

template<>
inline const SequenceRNNOptions* Operator::builtin_options_as<SequenceRNNOptions>() const
{
    return builtin_options_as_SequenceRNNOptions();
}

template<>
inline const StridedSliceOptions* Operator::builtin_options_as<StridedSliceOptions>() const
{
    return builtin_options_as_StridedSliceOptions();
}

template<>
inline const ExpOptions* Operator::builtin_options_as<ExpOptions>() const
{
    return builtin_options_as_ExpOptions();
}

template<>
inline const TopKV2Options* Operator::builtin_options_as<TopKV2Options>() const
{
    return builtin_options_as_TopKV2Options();
}

template<>
inline const SplitOptions* Operator::builtin_options_as<SplitOptions>() const
{
    return builtin_options_as_SplitOptions();
}

template<>
inline const LogSoftmaxOptions* Operator::builtin_options_as<LogSoftmaxOptions>() const
{
    return builtin_options_as_LogSoftmaxOptions();
}

template<>
inline const CastOptions* Operator::builtin_options_as<CastOptions>() const
{
    return builtin_options_as_CastOptions();
}

template<>
inline const DequantizeOptions* Operator::builtin_options_as<DequantizeOptions>() const
{
    return builtin_options_as_DequantizeOptions();
}

template<>
inline const MaximumMinimumOptions* Operator::builtin_options_as<MaximumMinimumOptions>() const
{
    return builtin_options_as_MaximumMinimumOptions();
}

template<>
inline const ArgMaxOptions* Operator::builtin_options_as<ArgMaxOptions>() const
{
    return builtin_options_as_ArgMaxOptions();
}

template<>
inline const LessOptions* Operator::builtin_options_as<LessOptions>() const
{
    return builtin_options_as_LessOptions();
}

template<>
inline const NegOptions* Operator::builtin_options_as<NegOptions>() const
{
    return builtin_options_as_NegOptions();
}

template<>
inline const PadV2Options* Operator::builtin_options_as<PadV2Options>() const
{
    return builtin_options_as_PadV2Options();
}

template<>
inline const GreaterOptions* Operator::builtin_options_as<GreaterOptions>() const
{
    return builtin_options_as_GreaterOptions();
}

template<>
inline const GreaterEqualOptions* Operator::builtin_options_as<GreaterEqualOptions>() const
{
    return builtin_options_as_GreaterEqualOptions();
}

template<>
inline const LessEqualOptions* Operator::builtin_options_as<LessEqualOptions>() const
{
    return builtin_options_as_LessEqualOptions();
}

template<>
inline const SelectOptions* Operator::builtin_options_as<SelectOptions>() const
{
    return builtin_options_as_SelectOptions();
}

template<>
inline const SliceOptions* Operator::builtin_options_as<SliceOptions>() const
{
    return builtin_options_as_SliceOptions();
}

template<>
inline const TransposeConvOptions* Operator::builtin_options_as<TransposeConvOptions>() const
{
    return builtin_options_as_TransposeConvOptions();
}

template<>
inline const SparseToDenseOptions* Operator::builtin_options_as<SparseToDenseOptions>() const
{
    return builtin_options_as_SparseToDenseOptions();
}

template<>
inline const TileOptions* Operator::builtin_options_as<TileOptions>() const
{
    return builtin_options_as_TileOptions();
}

template<>
inline const ExpandDimsOptions* Operator::builtin_options_as<ExpandDimsOptions>() const
{
    return builtin_options_as_ExpandDimsOptions();
}

template<>
inline const EqualOptions* Operator::builtin_options_as<EqualOptions>() const
{
    return builtin_options_as_EqualOptions();
}

template<>
inline const NotEqualOptions* Operator::builtin_options_as<NotEqualOptions>() const
{
    return builtin_options_as_NotEqualOptions();
}

template<>
inline const ShapeOptions* Operator::builtin_options_as<ShapeOptions>() const
{
    return builtin_options_as_ShapeOptions();
}

template<>
inline const PowOptions* Operator::builtin_options_as<PowOptions>() const
{
    return builtin_options_as_PowOptions();
}

template<>
inline const ArgMinOptions* Operator::builtin_options_as<ArgMinOptions>() const
{
    return builtin_options_as_ArgMinOptions();
}

template<>
inline const FakeQuantOptions* Operator::builtin_options_as<FakeQuantOptions>() const
{
    return builtin_options_as_FakeQuantOptions();
}

template<>
inline const PackOptions* Operator::builtin_options_as<PackOptions>() const
{
    return builtin_options_as_PackOptions();
}

template<>
inline const LogicalOrOptions* Operator::builtin_options_as<LogicalOrOptions>() const
{
    return builtin_options_as_LogicalOrOptions();
}

template<>
inline const OneHotOptions* Operator::builtin_options_as<OneHotOptions>() const
{
    return builtin_options_as_OneHotOptions();
}

template<>
inline const LogicalAndOptions* Operator::builtin_options_as<LogicalAndOptions>() const
{
    return builtin_options_as_LogicalAndOptions();
}

template<>
inline const LogicalNotOptions* Operator::builtin_options_as<LogicalNotOptions>() const
{
    return builtin_options_as_LogicalNotOptions();
}

template<>
inline const UnpackOptions* Operator::builtin_options_as<UnpackOptions>() const
{
    return builtin_options_as_UnpackOptions();
}

template<>
inline const FloorDivOptions* Operator::builtin_options_as<FloorDivOptions>() const
{
    return builtin_options_as_FloorDivOptions();
}

template<>
inline const SquareOptions* Operator::builtin_options_as<SquareOptions>() const
{
    return builtin_options_as_SquareOptions();
}

template<>
inline const ZerosLikeOptions* Operator::builtin_options_as<ZerosLikeOptions>() const
{
    return builtin_options_as_ZerosLikeOptions();
}

template<>
inline const FillOptions* Operator::builtin_options_as<FillOptions>() const
{
    return builtin_options_as_FillOptions();
}

template<>
inline const BidirectionalSequenceLSTMOptions* Operator::builtin_options_as<BidirectionalSequenceLSTMOptions>() const
{
    return builtin_options_as_BidirectionalSequenceLSTMOptions();
}

template<>
inline const BidirectionalSequenceRNNOptions* Operator::builtin_options_as<BidirectionalSequenceRNNOptions>() const
{
    return builtin_options_as_BidirectionalSequenceRNNOptions();
}

template<>
inline const UnidirectionalSequenceLSTMOptions* Operator::builtin_options_as<UnidirectionalSequenceLSTMOptions>() const
{
    return builtin_options_as_UnidirectionalSequenceLSTMOptions();
}

template<>
inline const FloorModOptions* Operator::builtin_options_as<FloorModOptions>() const
{
    return builtin_options_as_FloorModOptions();
}

template<>
inline const RangeOptions* Operator::builtin_options_as<RangeOptions>() const
{
    return builtin_options_as_RangeOptions();
}

template<>
inline const ResizeNearestNeighborOptions* Operator::builtin_options_as<ResizeNearestNeighborOptions>() const
{
    return builtin_options_as_ResizeNearestNeighborOptions();
}

template<>
inline const LeakyReluOptions* Operator::builtin_options_as<LeakyReluOptions>() const
{
    return builtin_options_as_LeakyReluOptions();
}

template<>
inline const SquaredDifferenceOptions* Operator::builtin_options_as<SquaredDifferenceOptions>() const
{
    return builtin_options_as_SquaredDifferenceOptions();
}

template<>
inline const MirrorPadOptions* Operator::builtin_options_as<MirrorPadOptions>() const
{
    return builtin_options_as_MirrorPadOptions();
}

template<>
inline const AbsOptions* Operator::builtin_options_as<AbsOptions>() const
{
    return builtin_options_as_AbsOptions();
}

template<>
inline const SplitVOptions* Operator::builtin_options_as<SplitVOptions>() const
{
    return builtin_options_as_SplitVOptions();
}

template<>
inline const UniqueOptions* Operator::builtin_options_as<UniqueOptions>() const
{
    return builtin_options_as_UniqueOptions();
}

template<>
inline const ReverseV2Options* Operator::builtin_options_as<ReverseV2Options>() const
{
    return builtin_options_as_ReverseV2Options();
}

template<>
inline const AddNOptions* Operator::builtin_options_as<AddNOptions>() const
{
    return builtin_options_as_AddNOptions();
}

template<>
inline const GatherNdOptions* Operator::builtin_options_as<GatherNdOptions>() const
{
    return builtin_options_as_GatherNdOptions();
}

template<>
inline const CosOptions* Operator::builtin_options_as<CosOptions>() const
{
    return builtin_options_as_CosOptions();
}

template<>
inline const WhereOptions* Operator::builtin_options_as<WhereOptions>() const
{
    return builtin_options_as_WhereOptions();
}

template<>
inline const RankOptions* Operator::builtin_options_as<RankOptions>() const
{
    return builtin_options_as_RankOptions();
}

template<>
inline const ReverseSequenceOptions* Operator::builtin_options_as<ReverseSequenceOptions>() const
{
    return builtin_options_as_ReverseSequenceOptions();
}

template<>
inline const MatrixDiagOptions* Operator::builtin_options_as<MatrixDiagOptions>() const
{
    return builtin_options_as_MatrixDiagOptions();
}

template<>
inline const QuantizeOptions* Operator::builtin_options_as<QuantizeOptions>() const
{
    return builtin_options_as_QuantizeOptions();
}

template<>
inline const MatrixSetDiagOptions* Operator::builtin_options_as<MatrixSetDiagOptions>() const
{
    return builtin_options_as_MatrixSetDiagOptions();
}

template<>
inline const HardSwishOptions* Operator::builtin_options_as<HardSwishOptions>() const
{
    return builtin_options_as_HardSwishOptions();
}

template<>
inline const IfOptions* Operator::builtin_options_as<IfOptions>() const
{
    return builtin_options_as_IfOptions();
}

template<>
inline const WhileOptions* Operator::builtin_options_as<WhileOptions>() const
{
    return builtin_options_as_WhileOptions();
}

struct OperatorBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    void add_opcode_index(uint32_t opcode_index)
    {
        fbb_.AddElement<uint32_t>(Operator::VT_OPCODE_INDEX, opcode_index, 0);
    }
    void add_inputs(flatbuffers::Offset<flatbuffers::Vector<int32_t> > inputs)
    {
        fbb_.AddOffset(Operator::VT_INPUTS, inputs);
    }
    void add_outputs(flatbuffers::Offset<flatbuffers::Vector<int32_t> > outputs)
    {
        fbb_.AddOffset(Operator::VT_OUTPUTS, outputs);
    }
    void add_builtin_options_type(BuiltinOptions builtin_options_type)
    {
        fbb_.AddElement<uint8_t>(Operator::VT_BUILTIN_OPTIONS_TYPE, static_cast<uint8_t>(builtin_options_type), 0);
    }
    void add_builtin_options(flatbuffers::Offset<void> builtin_options)
    {
        fbb_.AddOffset(Operator::VT_BUILTIN_OPTIONS, builtin_options);
    }
    void add_custom_options(flatbuffers::Offset<flatbuffers::Vector<uint8_t> > custom_options)
    {
        fbb_.AddOffset(Operator::VT_CUSTOM_OPTIONS, custom_options);
    }
    void add_custom_options_format(CustomOptionsFormat custom_options_format)
    {
        fbb_.AddElement<int8_t>(Operator::VT_CUSTOM_OPTIONS_FORMAT, static_cast<int8_t>(custom_options_format), 0);
    }
    void add_mutating_variable_inputs(flatbuffers::Offset<flatbuffers::Vector<uint8_t> > mutating_variable_inputs)
    {
        fbb_.AddOffset(Operator::VT_MUTATING_VARIABLE_INPUTS, mutating_variable_inputs);
    }
    void add_intermediates(flatbuffers::Offset<flatbuffers::Vector<int32_t> > intermediates)
    {
        fbb_.AddOffset(Operator::VT_INTERMEDIATES, intermediates);
    }
    explicit OperatorBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    OperatorBuilder& operator=(const OperatorBuilder&);
    flatbuffers::Offset<Operator> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<Operator>(end);
        return o;
    }
};

inline flatbuffers::Offset<Operator> CreateOperator(
    flatbuffers::FlatBufferBuilder& _fbb,
    uint32_t opcode_index = 0,
    flatbuffers::Offset<flatbuffers::Vector<int32_t> > inputs = 0,
    flatbuffers::Offset<flatbuffers::Vector<int32_t> > outputs = 0,
    BuiltinOptions builtin_options_type = BuiltinOptions_NONE,
    flatbuffers::Offset<void> builtin_options = 0,
    flatbuffers::Offset<flatbuffers::Vector<uint8_t> > custom_options = 0,
    CustomOptionsFormat custom_options_format = CustomOptionsFormat_FLEXBUFFERS,
    flatbuffers::Offset<flatbuffers::Vector<uint8_t> > mutating_variable_inputs = 0,
    flatbuffers::Offset<flatbuffers::Vector<int32_t> > intermediates = 0)
{
    OperatorBuilder builder_(_fbb);
    builder_.add_intermediates(intermediates);
    builder_.add_mutating_variable_inputs(mutating_variable_inputs);
    builder_.add_custom_options(custom_options);
    builder_.add_builtin_options(builtin_options);
    builder_.add_outputs(outputs);
    builder_.add_inputs(inputs);
    builder_.add_opcode_index(opcode_index);
    builder_.add_custom_options_format(custom_options_format);
    builder_.add_builtin_options_type(builtin_options_type);
    return builder_.Finish();
}

inline flatbuffers::Offset<Operator> CreateOperatorDirect(
    flatbuffers::FlatBufferBuilder& _fbb,
    uint32_t opcode_index = 0,
    const std::vector<int32_t>* inputs = nullptr,
    const std::vector<int32_t>* outputs = nullptr,
    BuiltinOptions builtin_options_type = BuiltinOptions_NONE,
    flatbuffers::Offset<void> builtin_options = 0,
    const std::vector<uint8_t>* custom_options = nullptr,
    CustomOptionsFormat custom_options_format = CustomOptionsFormat_FLEXBUFFERS,
    const std::vector<uint8_t>* mutating_variable_inputs = nullptr,
    const std::vector<int32_t>* intermediates = nullptr)
{
    auto inputs__ = inputs ? _fbb.CreateVector<int32_t>(*inputs) : 0;
    auto outputs__ = outputs ? _fbb.CreateVector<int32_t>(*outputs) : 0;
    auto custom_options__ = custom_options ? _fbb.CreateVector<uint8_t>(*custom_options) : 0;
    auto mutating_variable_inputs__ = mutating_variable_inputs ? _fbb.CreateVector<uint8_t>(*mutating_variable_inputs) : 0;
    auto intermediates__ = intermediates ? _fbb.CreateVector<int32_t>(*intermediates) : 0;
    return tflite::CreateOperator(
        _fbb,
        opcode_index,
        inputs__,
        outputs__,
        builtin_options_type,
        builtin_options,
        custom_options__,
        custom_options_format,
        mutating_variable_inputs__,
        intermediates__);
}

flatbuffers::Offset<Operator> CreateOperator(flatbuffers::FlatBufferBuilder& _fbb, const OperatorT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct SubGraphT : public flatbuffers::NativeTable
{
    typedef SubGraph TableType;
    std::vector<std::unique_ptr<TensorT> > tensors;
    std::vector<int32_t> inputs;
    std::vector<int32_t> outputs;
    std::vector<std::unique_ptr<OperatorT> > operators;
    std::string name;
    SubGraphT()
    {
    }
};

struct SubGraph FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef SubGraphT NativeTableType;
    enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE
    {
        VT_TENSORS = 4,
        VT_INPUTS = 6,
        VT_OUTPUTS = 8,
        VT_OPERATORS = 10,
        VT_NAME = 12
    };
    const flatbuffers::Vector<flatbuffers::Offset<Tensor> >* tensors() const
    {
        return GetPointer<const flatbuffers::Vector<flatbuffers::Offset<Tensor> >*>(VT_TENSORS);
    }
    const flatbuffers::Vector<int32_t>* inputs() const
    {
        return GetPointer<const flatbuffers::Vector<int32_t>*>(VT_INPUTS);
    }
    const flatbuffers::Vector<int32_t>* outputs() const
    {
        return GetPointer<const flatbuffers::Vector<int32_t>*>(VT_OUTPUTS);
    }
    const flatbuffers::Vector<flatbuffers::Offset<Operator> >* operators() const
    {
        return GetPointer<const flatbuffers::Vector<flatbuffers::Offset<Operator> >*>(VT_OPERATORS);
    }
    const flatbuffers::String* name() const
    {
        return GetPointer<const flatbuffers::String*>(VT_NAME);
    }
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && VerifyOffset(verifier, VT_TENSORS) && verifier.VerifyVector(tensors()) && verifier.VerifyVectorOfTables(tensors()) && VerifyOffset(verifier, VT_INPUTS) && verifier.VerifyVector(inputs()) && VerifyOffset(verifier, VT_OUTPUTS) && verifier.VerifyVector(outputs()) && VerifyOffset(verifier, VT_OPERATORS) && verifier.VerifyVector(operators()) && verifier.VerifyVectorOfTables(operators()) && VerifyOffset(verifier, VT_NAME) && verifier.VerifyString(name()) && verifier.EndTable();
    }
    SubGraphT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(SubGraphT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<SubGraph> Pack(flatbuffers::FlatBufferBuilder& _fbb, const SubGraphT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct SubGraphBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    void add_tensors(flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<Tensor> > > tensors)
    {
        fbb_.AddOffset(SubGraph::VT_TENSORS, tensors);
    }
    void add_inputs(flatbuffers::Offset<flatbuffers::Vector<int32_t> > inputs)
    {
        fbb_.AddOffset(SubGraph::VT_INPUTS, inputs);
    }
    void add_outputs(flatbuffers::Offset<flatbuffers::Vector<int32_t> > outputs)
    {
        fbb_.AddOffset(SubGraph::VT_OUTPUTS, outputs);
    }
    void add_operators(flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<Operator> > > operators)
    {
        fbb_.AddOffset(SubGraph::VT_OPERATORS, operators);
    }
    void add_name(flatbuffers::Offset<flatbuffers::String> name)
    {
        fbb_.AddOffset(SubGraph::VT_NAME, name);
    }
    explicit SubGraphBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    SubGraphBuilder& operator=(const SubGraphBuilder&);
    flatbuffers::Offset<SubGraph> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<SubGraph>(end);
        return o;
    }
};

inline flatbuffers::Offset<SubGraph> CreateSubGraph(
    flatbuffers::FlatBufferBuilder& _fbb,
    flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<Tensor> > > tensors = 0,
    flatbuffers::Offset<flatbuffers::Vector<int32_t> > inputs = 0,
    flatbuffers::Offset<flatbuffers::Vector<int32_t> > outputs = 0,
    flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<Operator> > > operators = 0,
    flatbuffers::Offset<flatbuffers::String> name = 0)
{
    SubGraphBuilder builder_(_fbb);
    builder_.add_name(name);
    builder_.add_operators(operators);
    builder_.add_outputs(outputs);
    builder_.add_inputs(inputs);
    builder_.add_tensors(tensors);
    return builder_.Finish();
}

inline flatbuffers::Offset<SubGraph> CreateSubGraphDirect(
    flatbuffers::FlatBufferBuilder& _fbb,
    const std::vector<flatbuffers::Offset<Tensor> >* tensors = nullptr,
    const std::vector<int32_t>* inputs = nullptr,
    const std::vector<int32_t>* outputs = nullptr,
    const std::vector<flatbuffers::Offset<Operator> >* operators = nullptr,
    const char* name = nullptr)
{
    auto tensors__ = tensors ? _fbb.CreateVector<flatbuffers::Offset<Tensor> >(*tensors) : 0;
    auto inputs__ = inputs ? _fbb.CreateVector<int32_t>(*inputs) : 0;
    auto outputs__ = outputs ? _fbb.CreateVector<int32_t>(*outputs) : 0;
    auto operators__ = operators ? _fbb.CreateVector<flatbuffers::Offset<Operator> >(*operators) : 0;
    auto name__ = name ? _fbb.CreateString(name) : 0;
    return tflite::CreateSubGraph(
        _fbb,
        tensors__,
        inputs__,
        outputs__,
        operators__,
        name__);
}

flatbuffers::Offset<SubGraph> CreateSubGraph(flatbuffers::FlatBufferBuilder& _fbb, const SubGraphT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct BufferT : public flatbuffers::NativeTable
{
    typedef Buffer TableType;
    std::vector<uint8_t> data;
    BufferT()
    {
    }
};

struct Buffer FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef BufferT NativeTableType;
    enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE
    {
        VT_DATA = 4
    };
    const flatbuffers::Vector<uint8_t>* data() const
    {
        return GetPointer<const flatbuffers::Vector<uint8_t>*>(VT_DATA);
    }
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && VerifyOffset(verifier, VT_DATA) && verifier.VerifyVector(data()) && verifier.EndTable();
    }
    BufferT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(BufferT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<Buffer> Pack(flatbuffers::FlatBufferBuilder& _fbb, const BufferT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct BufferBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    void add_data(flatbuffers::Offset<flatbuffers::Vector<uint8_t> > data)
    {
        fbb_.AddOffset(Buffer::VT_DATA, data);
    }
    explicit BufferBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    BufferBuilder& operator=(const BufferBuilder&);
    flatbuffers::Offset<Buffer> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<Buffer>(end);
        return o;
    }
};

inline flatbuffers::Offset<Buffer> CreateBuffer(
    flatbuffers::FlatBufferBuilder& _fbb,
    flatbuffers::Offset<flatbuffers::Vector<uint8_t> > data = 0)
{
    BufferBuilder builder_(_fbb);
    builder_.add_data(data);
    return builder_.Finish();
}

inline flatbuffers::Offset<Buffer> CreateBufferDirect(
    flatbuffers::FlatBufferBuilder& _fbb,
    const std::vector<uint8_t>* data = nullptr)
{
    auto data__ = data ? _fbb.CreateVector<uint8_t>(*data) : 0;
    return tflite::CreateBuffer(
        _fbb,
        data__);
}

flatbuffers::Offset<Buffer> CreateBuffer(flatbuffers::FlatBufferBuilder& _fbb, const BufferT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct MetadataT : public flatbuffers::NativeTable
{
    typedef Metadata TableType;
    std::string name;
    uint32_t buffer;
    MetadataT()
        : buffer(0)
    {
    }
};

struct Metadata FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef MetadataT NativeTableType;
    enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE
    {
        VT_NAME = 4,
        VT_BUFFER = 6
    };
    const flatbuffers::String* name() const
    {
        return GetPointer<const flatbuffers::String*>(VT_NAME);
    }
    uint32_t buffer() const
    {
        return GetField<uint32_t>(VT_BUFFER, 0);
    }
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && VerifyOffset(verifier, VT_NAME) && verifier.VerifyString(name()) && VerifyField<uint32_t>(verifier, VT_BUFFER) && verifier.EndTable();
    }
    MetadataT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(MetadataT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<Metadata> Pack(flatbuffers::FlatBufferBuilder& _fbb, const MetadataT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct MetadataBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    void add_name(flatbuffers::Offset<flatbuffers::String> name)
    {
        fbb_.AddOffset(Metadata::VT_NAME, name);
    }
    void add_buffer(uint32_t buffer)
    {
        fbb_.AddElement<uint32_t>(Metadata::VT_BUFFER, buffer, 0);
    }
    explicit MetadataBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    MetadataBuilder& operator=(const MetadataBuilder&);
    flatbuffers::Offset<Metadata> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<Metadata>(end);
        return o;
    }
};

inline flatbuffers::Offset<Metadata> CreateMetadata(
    flatbuffers::FlatBufferBuilder& _fbb,
    flatbuffers::Offset<flatbuffers::String> name = 0,
    uint32_t buffer = 0)
{
    MetadataBuilder builder_(_fbb);
    builder_.add_buffer(buffer);
    builder_.add_name(name);
    return builder_.Finish();
}

inline flatbuffers::Offset<Metadata> CreateMetadataDirect(
    flatbuffers::FlatBufferBuilder& _fbb,
    const char* name = nullptr,
    uint32_t buffer = 0)
{
    auto name__ = name ? _fbb.CreateString(name) : 0;
    return tflite::CreateMetadata(
        _fbb,
        name__,
        buffer);
}

flatbuffers::Offset<Metadata> CreateMetadata(flatbuffers::FlatBufferBuilder& _fbb, const MetadataT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

struct ModelT : public flatbuffers::NativeTable
{
    typedef Model TableType;
    uint32_t version;
    std::vector<std::unique_ptr<OperatorCodeT> > operator_codes;
    std::vector<std::unique_ptr<SubGraphT> > subgraphs;
    std::string description;
    std::vector<std::unique_ptr<BufferT> > buffers;
    std::vector<int32_t> metadata_buffer;
    std::vector<std::unique_ptr<MetadataT> > metadata;
    ModelT()
        : version(0)
    {
    }
};

struct Model FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table
{
    typedef ModelT NativeTableType;
    enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE
    {
        VT_VERSION = 4,
        VT_OPERATOR_CODES = 6,
        VT_SUBGRAPHS = 8,
        VT_DESCRIPTION = 10,
        VT_BUFFERS = 12,
        VT_METADATA_BUFFER = 14,
        VT_METADATA = 16
    };
    uint32_t version() const
    {
        return GetField<uint32_t>(VT_VERSION, 0);
    }
    const flatbuffers::Vector<flatbuffers::Offset<OperatorCode> >* operator_codes() const
    {
        return GetPointer<const flatbuffers::Vector<flatbuffers::Offset<OperatorCode> >*>(VT_OPERATOR_CODES);
    }
    const flatbuffers::Vector<flatbuffers::Offset<SubGraph> >* subgraphs() const
    {
        return GetPointer<const flatbuffers::Vector<flatbuffers::Offset<SubGraph> >*>(VT_SUBGRAPHS);
    }
    const flatbuffers::String* description() const
    {
        return GetPointer<const flatbuffers::String*>(VT_DESCRIPTION);
    }
    const flatbuffers::Vector<flatbuffers::Offset<Buffer> >* buffers() const
    {
        return GetPointer<const flatbuffers::Vector<flatbuffers::Offset<Buffer> >*>(VT_BUFFERS);
    }
    const flatbuffers::Vector<int32_t>* metadata_buffer() const
    {
        return GetPointer<const flatbuffers::Vector<int32_t>*>(VT_METADATA_BUFFER);
    }
    const flatbuffers::Vector<flatbuffers::Offset<Metadata> >* metadata() const
    {
        return GetPointer<const flatbuffers::Vector<flatbuffers::Offset<Metadata> >*>(VT_METADATA);
    }
    bool Verify(flatbuffers::Verifier& verifier) const
    {
        return VerifyTableStart(verifier) && VerifyField<uint32_t>(verifier, VT_VERSION) && VerifyOffset(verifier, VT_OPERATOR_CODES) && verifier.VerifyVector(operator_codes()) && verifier.VerifyVectorOfTables(operator_codes()) && VerifyOffset(verifier, VT_SUBGRAPHS) && verifier.VerifyVector(subgraphs()) && verifier.VerifyVectorOfTables(subgraphs()) && VerifyOffset(verifier, VT_DESCRIPTION) && verifier.VerifyString(description()) && VerifyOffset(verifier, VT_BUFFERS) && verifier.VerifyVector(buffers()) && verifier.VerifyVectorOfTables(buffers()) && VerifyOffset(verifier, VT_METADATA_BUFFER) && verifier.VerifyVector(metadata_buffer()) && VerifyOffset(verifier, VT_METADATA) && verifier.VerifyVector(metadata()) && verifier.VerifyVectorOfTables(metadata()) && verifier.EndTable();
    }
    ModelT* UnPack(const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    void UnPackTo(ModelT* _o, const flatbuffers::resolver_function_t* _resolver = nullptr) const;
    static flatbuffers::Offset<Model> Pack(flatbuffers::FlatBufferBuilder& _fbb, const ModelT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);
};

struct ModelBuilder
{
    flatbuffers::FlatBufferBuilder& fbb_;
    flatbuffers::uoffset_t start_;
    void add_version(uint32_t version)
    {
        fbb_.AddElement<uint32_t>(Model::VT_VERSION, version, 0);
    }
    void add_operator_codes(flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<OperatorCode> > > operator_codes)
    {
        fbb_.AddOffset(Model::VT_OPERATOR_CODES, operator_codes);
    }
    void add_subgraphs(flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<SubGraph> > > subgraphs)
    {
        fbb_.AddOffset(Model::VT_SUBGRAPHS, subgraphs);
    }
    void add_description(flatbuffers::Offset<flatbuffers::String> description)
    {
        fbb_.AddOffset(Model::VT_DESCRIPTION, description);
    }
    void add_buffers(flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<Buffer> > > buffers)
    {
        fbb_.AddOffset(Model::VT_BUFFERS, buffers);
    }
    void add_metadata_buffer(flatbuffers::Offset<flatbuffers::Vector<int32_t> > metadata_buffer)
    {
        fbb_.AddOffset(Model::VT_METADATA_BUFFER, metadata_buffer);
    }
    void add_metadata(flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<Metadata> > > metadata)
    {
        fbb_.AddOffset(Model::VT_METADATA, metadata);
    }
    explicit ModelBuilder(flatbuffers::FlatBufferBuilder& _fbb)
        : fbb_(_fbb)
    {
        start_ = fbb_.StartTable();
    }
    ModelBuilder& operator=(const ModelBuilder&);
    flatbuffers::Offset<Model> Finish()
    {
        const auto end = fbb_.EndTable(start_);
        auto o = flatbuffers::Offset<Model>(end);
        return o;
    }
};

inline flatbuffers::Offset<Model> CreateModel(
    flatbuffers::FlatBufferBuilder& _fbb,
    uint32_t version = 0,
    flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<OperatorCode> > > operator_codes = 0,
    flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<SubGraph> > > subgraphs = 0,
    flatbuffers::Offset<flatbuffers::String> description = 0,
    flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<Buffer> > > buffers = 0,
    flatbuffers::Offset<flatbuffers::Vector<int32_t> > metadata_buffer = 0,
    flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<Metadata> > > metadata = 0)
{
    ModelBuilder builder_(_fbb);
    builder_.add_metadata(metadata);
    builder_.add_metadata_buffer(metadata_buffer);
    builder_.add_buffers(buffers);
    builder_.add_description(description);
    builder_.add_subgraphs(subgraphs);
    builder_.add_operator_codes(operator_codes);
    builder_.add_version(version);
    return builder_.Finish();
}

inline flatbuffers::Offset<Model> CreateModelDirect(
    flatbuffers::FlatBufferBuilder& _fbb,
    uint32_t version = 0,
    const std::vector<flatbuffers::Offset<OperatorCode> >* operator_codes = nullptr,
    const std::vector<flatbuffers::Offset<SubGraph> >* subgraphs = nullptr,
    const char* description = nullptr,
    const std::vector<flatbuffers::Offset<Buffer> >* buffers = nullptr,
    const std::vector<int32_t>* metadata_buffer = nullptr,
    const std::vector<flatbuffers::Offset<Metadata> >* metadata = nullptr)
{
    auto operator_codes__ = operator_codes ? _fbb.CreateVector<flatbuffers::Offset<OperatorCode> >(*operator_codes) : 0;
    auto subgraphs__ = subgraphs ? _fbb.CreateVector<flatbuffers::Offset<SubGraph> >(*subgraphs) : 0;
    auto description__ = description ? _fbb.CreateString(description) : 0;
    auto buffers__ = buffers ? _fbb.CreateVector<flatbuffers::Offset<Buffer> >(*buffers) : 0;
    auto metadata_buffer__ = metadata_buffer ? _fbb.CreateVector<int32_t>(*metadata_buffer) : 0;
    auto metadata__ = metadata ? _fbb.CreateVector<flatbuffers::Offset<Metadata> >(*metadata) : 0;
    return tflite::CreateModel(
        _fbb,
        version,
        operator_codes__,
        subgraphs__,
        description__,
        buffers__,
        metadata_buffer__,
        metadata__);
}

flatbuffers::Offset<Model> CreateModel(flatbuffers::FlatBufferBuilder& _fbb, const ModelT* _o, const flatbuffers::rehasher_function_t* _rehasher = nullptr);

inline CustomQuantizationT* CustomQuantization::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new CustomQuantizationT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void CustomQuantization::UnPackTo(CustomQuantizationT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
    {
        auto _e = custom();
        if (_e)
        {
            _o->custom.resize(_e->size());
            for (flatbuffers::uoffset_t _i = 0; _i < _e->size(); _i++) { _o->custom[_i] = _e->Get(_i); }
        }
    };
}

inline flatbuffers::Offset<CustomQuantization> CustomQuantization::Pack(flatbuffers::FlatBufferBuilder& _fbb, const CustomQuantizationT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreateCustomQuantization(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<CustomQuantization> CreateCustomQuantization(flatbuffers::FlatBufferBuilder& _fbb, const CustomQuantizationT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const CustomQuantizationT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    auto _custom = _o->custom.size() ? _fbb.CreateVector(_o->custom) : 0;
    return tflite::CreateCustomQuantization(
        _fbb,
        _custom);
}

inline QuantizationParametersT* QuantizationParameters::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new QuantizationParametersT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void QuantizationParameters::UnPackTo(QuantizationParametersT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
    {
        auto _e = min();
        if (_e)
        {
            _o->min.resize(_e->size());
            for (flatbuffers::uoffset_t _i = 0; _i < _e->size(); _i++) { _o->min[_i] = _e->Get(_i); }
        }
    };
    {
        auto _e = max();
        if (_e)
        {
            _o->max.resize(_e->size());
            for (flatbuffers::uoffset_t _i = 0; _i < _e->size(); _i++) { _o->max[_i] = _e->Get(_i); }
        }
    };
    {
        auto _e = scale();
        if (_e)
        {
            _o->scale.resize(_e->size());
            for (flatbuffers::uoffset_t _i = 0; _i < _e->size(); _i++) { _o->scale[_i] = _e->Get(_i); }
        }
    };
    {
        auto _e = zero_point();
        if (_e)
        {
            _o->zero_point.resize(_e->size());
            for (flatbuffers::uoffset_t _i = 0; _i < _e->size(); _i++) { _o->zero_point[_i] = _e->Get(_i); }
        }
    };
    {
        auto _e = details_type();
        _o->details.type = _e;
    };
    {
        auto _e = details();
        if (_e) _o->details.value = QuantizationDetailsUnion::UnPack(_e, details_type(), _resolver);
    };
    {
        auto _e = quantized_dimension();
        _o->quantized_dimension = _e;
    };
}

inline flatbuffers::Offset<QuantizationParameters> QuantizationParameters::Pack(flatbuffers::FlatBufferBuilder& _fbb, const QuantizationParametersT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreateQuantizationParameters(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<QuantizationParameters> CreateQuantizationParameters(flatbuffers::FlatBufferBuilder& _fbb, const QuantizationParametersT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const QuantizationParametersT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    auto _min = _o->min.size() ? _fbb.CreateVector(_o->min) : 0;
    auto _max = _o->max.size() ? _fbb.CreateVector(_o->max) : 0;
    auto _scale = _o->scale.size() ? _fbb.CreateVector(_o->scale) : 0;
    auto _zero_point = _o->zero_point.size() ? _fbb.CreateVector(_o->zero_point) : 0;
    auto _details_type = _o->details.type;
    auto _details = _o->details.Pack(_fbb);
    auto _quantized_dimension = _o->quantized_dimension;
    return tflite::CreateQuantizationParameters(
        _fbb,
        _min,
        _max,
        _scale,
        _zero_point,
        _details_type,
        _details,
        _quantized_dimension);
}

inline TensorT* Tensor::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new TensorT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void Tensor::UnPackTo(TensorT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
    {
        auto _e = shape();
        if (_e)
        {
            _o->shape.resize(_e->size());
            for (flatbuffers::uoffset_t _i = 0; _i < _e->size(); _i++) { _o->shape[_i] = _e->Get(_i); }
        }
    };
    {
        auto _e = type();
        _o->type = _e;
    };
    {
        auto _e = buffer();
        _o->buffer = _e;
    };
    {
        auto _e = name();
        if (_e) _o->name = _e->str();
    };
    {
        auto _e = quantization();
        if (_e) _o->quantization = std::unique_ptr<QuantizationParametersT>(_e->UnPack(_resolver));
    };
    {
        auto _e = is_variable();
        _o->is_variable = _e;
    };
}

inline flatbuffers::Offset<Tensor> Tensor::Pack(flatbuffers::FlatBufferBuilder& _fbb, const TensorT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreateTensor(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<Tensor> CreateTensor(flatbuffers::FlatBufferBuilder& _fbb, const TensorT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const TensorT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    auto _shape = _o->shape.size() ? _fbb.CreateVector(_o->shape) : 0;
    auto _type = _o->type;
    auto _buffer = _o->buffer;
    auto _name = _o->name.empty() ? 0 : _fbb.CreateString(_o->name);
    auto _quantization = _o->quantization ? CreateQuantizationParameters(_fbb, _o->quantization.get(), _rehasher) : 0;
    auto _is_variable = _o->is_variable;
    return tflite::CreateTensor(
        _fbb,
        _shape,
        _type,
        _buffer,
        _name,
        _quantization,
        _is_variable);
}

inline Conv2DOptionsT* Conv2DOptions::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new Conv2DOptionsT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void Conv2DOptions::UnPackTo(Conv2DOptionsT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
    {
        auto _e = padding();
        _o->padding = _e;
    };
    {
        auto _e = stride_w();
        _o->stride_w = _e;
    };
    {
        auto _e = stride_h();
        _o->stride_h = _e;
    };
    {
        auto _e = fused_activation_function();
        _o->fused_activation_function = _e;
    };
    {
        auto _e = dilation_w_factor();
        _o->dilation_w_factor = _e;
    };
    {
        auto _e = dilation_h_factor();
        _o->dilation_h_factor = _e;
    };
}

inline flatbuffers::Offset<Conv2DOptions> Conv2DOptions::Pack(flatbuffers::FlatBufferBuilder& _fbb, const Conv2DOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreateConv2DOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<Conv2DOptions> CreateConv2DOptions(flatbuffers::FlatBufferBuilder& _fbb, const Conv2DOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const Conv2DOptionsT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    auto _padding = _o->padding;
    auto _stride_w = _o->stride_w;
    auto _stride_h = _o->stride_h;
    auto _fused_activation_function = _o->fused_activation_function;
    auto _dilation_w_factor = _o->dilation_w_factor;
    auto _dilation_h_factor = _o->dilation_h_factor;
    return tflite::CreateConv2DOptions(
        _fbb,
        _padding,
        _stride_w,
        _stride_h,
        _fused_activation_function,
        _dilation_w_factor,
        _dilation_h_factor);
}

inline Pool2DOptionsT* Pool2DOptions::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new Pool2DOptionsT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void Pool2DOptions::UnPackTo(Pool2DOptionsT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
    {
        auto _e = padding();
        _o->padding = _e;
    };
    {
        auto _e = stride_w();
        _o->stride_w = _e;
    };
    {
        auto _e = stride_h();
        _o->stride_h = _e;
    };
    {
        auto _e = filter_width();
        _o->filter_width = _e;
    };
    {
        auto _e = filter_height();
        _o->filter_height = _e;
    };
    {
        auto _e = fused_activation_function();
        _o->fused_activation_function = _e;
    };
}

inline flatbuffers::Offset<Pool2DOptions> Pool2DOptions::Pack(flatbuffers::FlatBufferBuilder& _fbb, const Pool2DOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreatePool2DOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<Pool2DOptions> CreatePool2DOptions(flatbuffers::FlatBufferBuilder& _fbb, const Pool2DOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const Pool2DOptionsT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    auto _padding = _o->padding;
    auto _stride_w = _o->stride_w;
    auto _stride_h = _o->stride_h;
    auto _filter_width = _o->filter_width;
    auto _filter_height = _o->filter_height;
    auto _fused_activation_function = _o->fused_activation_function;
    return tflite::CreatePool2DOptions(
        _fbb,
        _padding,
        _stride_w,
        _stride_h,
        _filter_width,
        _filter_height,
        _fused_activation_function);
}

inline DepthwiseConv2DOptionsT* DepthwiseConv2DOptions::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new DepthwiseConv2DOptionsT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void DepthwiseConv2DOptions::UnPackTo(DepthwiseConv2DOptionsT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
    {
        auto _e = padding();
        _o->padding = _e;
    };
    {
        auto _e = stride_w();
        _o->stride_w = _e;
    };
    {
        auto _e = stride_h();
        _o->stride_h = _e;
    };
    {
        auto _e = depth_multiplier();
        _o->depth_multiplier = _e;
    };
    {
        auto _e = fused_activation_function();
        _o->fused_activation_function = _e;
    };
    {
        auto _e = dilation_w_factor();
        _o->dilation_w_factor = _e;
    };
    {
        auto _e = dilation_h_factor();
        _o->dilation_h_factor = _e;
    };
}

inline flatbuffers::Offset<DepthwiseConv2DOptions> DepthwiseConv2DOptions::Pack(flatbuffers::FlatBufferBuilder& _fbb, const DepthwiseConv2DOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreateDepthwiseConv2DOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<DepthwiseConv2DOptions> CreateDepthwiseConv2DOptions(flatbuffers::FlatBufferBuilder& _fbb, const DepthwiseConv2DOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const DepthwiseConv2DOptionsT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    auto _padding = _o->padding;
    auto _stride_w = _o->stride_w;
    auto _stride_h = _o->stride_h;
    auto _depth_multiplier = _o->depth_multiplier;
    auto _fused_activation_function = _o->fused_activation_function;
    auto _dilation_w_factor = _o->dilation_w_factor;
    auto _dilation_h_factor = _o->dilation_h_factor;
    return tflite::CreateDepthwiseConv2DOptions(
        _fbb,
        _padding,
        _stride_w,
        _stride_h,
        _depth_multiplier,
        _fused_activation_function,
        _dilation_w_factor,
        _dilation_h_factor);
}

inline ConcatEmbeddingsOptionsT* ConcatEmbeddingsOptions::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new ConcatEmbeddingsOptionsT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void ConcatEmbeddingsOptions::UnPackTo(ConcatEmbeddingsOptionsT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
    {
        auto _e = num_channels();
        _o->num_channels = _e;
    };
    {
        auto _e = num_columns_per_channel();
        if (_e)
        {
            _o->num_columns_per_channel.resize(_e->size());
            for (flatbuffers::uoffset_t _i = 0; _i < _e->size(); _i++) { _o->num_columns_per_channel[_i] = _e->Get(_i); }
        }
    };
    {
        auto _e = embedding_dim_per_channel();
        if (_e)
        {
            _o->embedding_dim_per_channel.resize(_e->size());
            for (flatbuffers::uoffset_t _i = 0; _i < _e->size(); _i++) { _o->embedding_dim_per_channel[_i] = _e->Get(_i); }
        }
    };
}

inline flatbuffers::Offset<ConcatEmbeddingsOptions> ConcatEmbeddingsOptions::Pack(flatbuffers::FlatBufferBuilder& _fbb, const ConcatEmbeddingsOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreateConcatEmbeddingsOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<ConcatEmbeddingsOptions> CreateConcatEmbeddingsOptions(flatbuffers::FlatBufferBuilder& _fbb, const ConcatEmbeddingsOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const ConcatEmbeddingsOptionsT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    auto _num_channels = _o->num_channels;
    auto _num_columns_per_channel = _o->num_columns_per_channel.size() ? _fbb.CreateVector(_o->num_columns_per_channel) : 0;
    auto _embedding_dim_per_channel = _o->embedding_dim_per_channel.size() ? _fbb.CreateVector(_o->embedding_dim_per_channel) : 0;
    return tflite::CreateConcatEmbeddingsOptions(
        _fbb,
        _num_channels,
        _num_columns_per_channel,
        _embedding_dim_per_channel);
}

inline LSHProjectionOptionsT* LSHProjectionOptions::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new LSHProjectionOptionsT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void LSHProjectionOptions::UnPackTo(LSHProjectionOptionsT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
    {
        auto _e = type();
        _o->type = _e;
    };
}

inline flatbuffers::Offset<LSHProjectionOptions> LSHProjectionOptions::Pack(flatbuffers::FlatBufferBuilder& _fbb, const LSHProjectionOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreateLSHProjectionOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<LSHProjectionOptions> CreateLSHProjectionOptions(flatbuffers::FlatBufferBuilder& _fbb, const LSHProjectionOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const LSHProjectionOptionsT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    auto _type = _o->type;
    return tflite::CreateLSHProjectionOptions(
        _fbb,
        _type);
}

inline SVDFOptionsT* SVDFOptions::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new SVDFOptionsT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void SVDFOptions::UnPackTo(SVDFOptionsT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
    {
        auto _e = rank();
        _o->rank = _e;
    };
    {
        auto _e = fused_activation_function();
        _o->fused_activation_function = _e;
    };
}

inline flatbuffers::Offset<SVDFOptions> SVDFOptions::Pack(flatbuffers::FlatBufferBuilder& _fbb, const SVDFOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreateSVDFOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<SVDFOptions> CreateSVDFOptions(flatbuffers::FlatBufferBuilder& _fbb, const SVDFOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const SVDFOptionsT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    auto _rank = _o->rank;
    auto _fused_activation_function = _o->fused_activation_function;
    return tflite::CreateSVDFOptions(
        _fbb,
        _rank,
        _fused_activation_function);
}

inline RNNOptionsT* RNNOptions::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new RNNOptionsT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void RNNOptions::UnPackTo(RNNOptionsT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
    {
        auto _e = fused_activation_function();
        _o->fused_activation_function = _e;
    };
}

inline flatbuffers::Offset<RNNOptions> RNNOptions::Pack(flatbuffers::FlatBufferBuilder& _fbb, const RNNOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreateRNNOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<RNNOptions> CreateRNNOptions(flatbuffers::FlatBufferBuilder& _fbb, const RNNOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const RNNOptionsT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    auto _fused_activation_function = _o->fused_activation_function;
    return tflite::CreateRNNOptions(
        _fbb,
        _fused_activation_function);
}

inline SequenceRNNOptionsT* SequenceRNNOptions::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new SequenceRNNOptionsT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void SequenceRNNOptions::UnPackTo(SequenceRNNOptionsT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
    {
        auto _e = time_major();
        _o->time_major = _e;
    };
    {
        auto _e = fused_activation_function();
        _o->fused_activation_function = _e;
    };
}

inline flatbuffers::Offset<SequenceRNNOptions> SequenceRNNOptions::Pack(flatbuffers::FlatBufferBuilder& _fbb, const SequenceRNNOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreateSequenceRNNOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<SequenceRNNOptions> CreateSequenceRNNOptions(flatbuffers::FlatBufferBuilder& _fbb, const SequenceRNNOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const SequenceRNNOptionsT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    auto _time_major = _o->time_major;
    auto _fused_activation_function = _o->fused_activation_function;
    return tflite::CreateSequenceRNNOptions(
        _fbb,
        _time_major,
        _fused_activation_function);
}

inline BidirectionalSequenceRNNOptionsT* BidirectionalSequenceRNNOptions::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new BidirectionalSequenceRNNOptionsT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void BidirectionalSequenceRNNOptions::UnPackTo(BidirectionalSequenceRNNOptionsT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
    {
        auto _e = time_major();
        _o->time_major = _e;
    };
    {
        auto _e = fused_activation_function();
        _o->fused_activation_function = _e;
    };
    {
        auto _e = merge_outputs();
        _o->merge_outputs = _e;
    };
}

inline flatbuffers::Offset<BidirectionalSequenceRNNOptions> BidirectionalSequenceRNNOptions::Pack(flatbuffers::FlatBufferBuilder& _fbb, const BidirectionalSequenceRNNOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreateBidirectionalSequenceRNNOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<BidirectionalSequenceRNNOptions> CreateBidirectionalSequenceRNNOptions(flatbuffers::FlatBufferBuilder& _fbb, const BidirectionalSequenceRNNOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const BidirectionalSequenceRNNOptionsT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    auto _time_major = _o->time_major;
    auto _fused_activation_function = _o->fused_activation_function;
    auto _merge_outputs = _o->merge_outputs;
    return tflite::CreateBidirectionalSequenceRNNOptions(
        _fbb,
        _time_major,
        _fused_activation_function,
        _merge_outputs);
}

inline FullyConnectedOptionsT* FullyConnectedOptions::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new FullyConnectedOptionsT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void FullyConnectedOptions::UnPackTo(FullyConnectedOptionsT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
    {
        auto _e = fused_activation_function();
        _o->fused_activation_function = _e;
    };
    {
        auto _e = weights_format();
        _o->weights_format = _e;
    };
    {
        auto _e = keep_num_dims();
        _o->keep_num_dims = _e;
    };
}

inline flatbuffers::Offset<FullyConnectedOptions> FullyConnectedOptions::Pack(flatbuffers::FlatBufferBuilder& _fbb, const FullyConnectedOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreateFullyConnectedOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<FullyConnectedOptions> CreateFullyConnectedOptions(flatbuffers::FlatBufferBuilder& _fbb, const FullyConnectedOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const FullyConnectedOptionsT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    auto _fused_activation_function = _o->fused_activation_function;
    auto _weights_format = _o->weights_format;
    auto _keep_num_dims = _o->keep_num_dims;
    return tflite::CreateFullyConnectedOptions(
        _fbb,
        _fused_activation_function,
        _weights_format,
        _keep_num_dims);
}

inline SoftmaxOptionsT* SoftmaxOptions::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new SoftmaxOptionsT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void SoftmaxOptions::UnPackTo(SoftmaxOptionsT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
    {
        auto _e = beta();
        _o->beta = _e;
    };
}

inline flatbuffers::Offset<SoftmaxOptions> SoftmaxOptions::Pack(flatbuffers::FlatBufferBuilder& _fbb, const SoftmaxOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreateSoftmaxOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<SoftmaxOptions> CreateSoftmaxOptions(flatbuffers::FlatBufferBuilder& _fbb, const SoftmaxOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const SoftmaxOptionsT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    auto _beta = _o->beta;
    return tflite::CreateSoftmaxOptions(
        _fbb,
        _beta);
}

inline ConcatenationOptionsT* ConcatenationOptions::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new ConcatenationOptionsT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void ConcatenationOptions::UnPackTo(ConcatenationOptionsT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
    {
        auto _e = axis();
        _o->axis = _e;
    };
    {
        auto _e = fused_activation_function();
        _o->fused_activation_function = _e;
    };
}

inline flatbuffers::Offset<ConcatenationOptions> ConcatenationOptions::Pack(flatbuffers::FlatBufferBuilder& _fbb, const ConcatenationOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreateConcatenationOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<ConcatenationOptions> CreateConcatenationOptions(flatbuffers::FlatBufferBuilder& _fbb, const ConcatenationOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const ConcatenationOptionsT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    auto _axis = _o->axis;
    auto _fused_activation_function = _o->fused_activation_function;
    return tflite::CreateConcatenationOptions(
        _fbb,
        _axis,
        _fused_activation_function);
}

inline AddOptionsT* AddOptions::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new AddOptionsT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void AddOptions::UnPackTo(AddOptionsT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
    {
        auto _e = fused_activation_function();
        _o->fused_activation_function = _e;
    };
}

inline flatbuffers::Offset<AddOptions> AddOptions::Pack(flatbuffers::FlatBufferBuilder& _fbb, const AddOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreateAddOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<AddOptions> CreateAddOptions(flatbuffers::FlatBufferBuilder& _fbb, const AddOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const AddOptionsT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    auto _fused_activation_function = _o->fused_activation_function;
    return tflite::CreateAddOptions(
        _fbb,
        _fused_activation_function);
}

inline MulOptionsT* MulOptions::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new MulOptionsT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void MulOptions::UnPackTo(MulOptionsT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
    {
        auto _e = fused_activation_function();
        _o->fused_activation_function = _e;
    };
}

inline flatbuffers::Offset<MulOptions> MulOptions::Pack(flatbuffers::FlatBufferBuilder& _fbb, const MulOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreateMulOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<MulOptions> CreateMulOptions(flatbuffers::FlatBufferBuilder& _fbb, const MulOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const MulOptionsT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    auto _fused_activation_function = _o->fused_activation_function;
    return tflite::CreateMulOptions(
        _fbb,
        _fused_activation_function);
}

inline L2NormOptionsT* L2NormOptions::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new L2NormOptionsT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void L2NormOptions::UnPackTo(L2NormOptionsT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
    {
        auto _e = fused_activation_function();
        _o->fused_activation_function = _e;
    };
}

inline flatbuffers::Offset<L2NormOptions> L2NormOptions::Pack(flatbuffers::FlatBufferBuilder& _fbb, const L2NormOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreateL2NormOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<L2NormOptions> CreateL2NormOptions(flatbuffers::FlatBufferBuilder& _fbb, const L2NormOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const L2NormOptionsT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    auto _fused_activation_function = _o->fused_activation_function;
    return tflite::CreateL2NormOptions(
        _fbb,
        _fused_activation_function);
}

inline LocalResponseNormalizationOptionsT* LocalResponseNormalizationOptions::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new LocalResponseNormalizationOptionsT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void LocalResponseNormalizationOptions::UnPackTo(LocalResponseNormalizationOptionsT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
    {
        auto _e = radius();
        _o->radius = _e;
    };
    {
        auto _e = bias();
        _o->bias = _e;
    };
    {
        auto _e = alpha();
        _o->alpha = _e;
    };
    {
        auto _e = beta();
        _o->beta = _e;
    };
}

inline flatbuffers::Offset<LocalResponseNormalizationOptions> LocalResponseNormalizationOptions::Pack(flatbuffers::FlatBufferBuilder& _fbb, const LocalResponseNormalizationOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreateLocalResponseNormalizationOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<LocalResponseNormalizationOptions> CreateLocalResponseNormalizationOptions(flatbuffers::FlatBufferBuilder& _fbb, const LocalResponseNormalizationOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const LocalResponseNormalizationOptionsT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    auto _radius = _o->radius;
    auto _bias = _o->bias;
    auto _alpha = _o->alpha;
    auto _beta = _o->beta;
    return tflite::CreateLocalResponseNormalizationOptions(
        _fbb,
        _radius,
        _bias,
        _alpha,
        _beta);
}

inline LSTMOptionsT* LSTMOptions::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new LSTMOptionsT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void LSTMOptions::UnPackTo(LSTMOptionsT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
    {
        auto _e = fused_activation_function();
        _o->fused_activation_function = _e;
    };
    {
        auto _e = cell_clip();
        _o->cell_clip = _e;
    };
    {
        auto _e = proj_clip();
        _o->proj_clip = _e;
    };
    {
        auto _e = kernel_type();
        _o->kernel_type = _e;
    };
}

inline flatbuffers::Offset<LSTMOptions> LSTMOptions::Pack(flatbuffers::FlatBufferBuilder& _fbb, const LSTMOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreateLSTMOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<LSTMOptions> CreateLSTMOptions(flatbuffers::FlatBufferBuilder& _fbb, const LSTMOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const LSTMOptionsT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    auto _fused_activation_function = _o->fused_activation_function;
    auto _cell_clip = _o->cell_clip;
    auto _proj_clip = _o->proj_clip;
    auto _kernel_type = _o->kernel_type;
    return tflite::CreateLSTMOptions(
        _fbb,
        _fused_activation_function,
        _cell_clip,
        _proj_clip,
        _kernel_type);
}

inline UnidirectionalSequenceLSTMOptionsT* UnidirectionalSequenceLSTMOptions::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new UnidirectionalSequenceLSTMOptionsT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void UnidirectionalSequenceLSTMOptions::UnPackTo(UnidirectionalSequenceLSTMOptionsT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
    {
        auto _e = fused_activation_function();
        _o->fused_activation_function = _e;
    };
    {
        auto _e = cell_clip();
        _o->cell_clip = _e;
    };
    {
        auto _e = proj_clip();
        _o->proj_clip = _e;
    };
    {
        auto _e = time_major();
        _o->time_major = _e;
    };
}

inline flatbuffers::Offset<UnidirectionalSequenceLSTMOptions> UnidirectionalSequenceLSTMOptions::Pack(flatbuffers::FlatBufferBuilder& _fbb, const UnidirectionalSequenceLSTMOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreateUnidirectionalSequenceLSTMOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<UnidirectionalSequenceLSTMOptions> CreateUnidirectionalSequenceLSTMOptions(flatbuffers::FlatBufferBuilder& _fbb, const UnidirectionalSequenceLSTMOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const UnidirectionalSequenceLSTMOptionsT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    auto _fused_activation_function = _o->fused_activation_function;
    auto _cell_clip = _o->cell_clip;
    auto _proj_clip = _o->proj_clip;
    auto _time_major = _o->time_major;
    return tflite::CreateUnidirectionalSequenceLSTMOptions(
        _fbb,
        _fused_activation_function,
        _cell_clip,
        _proj_clip,
        _time_major);
}

inline BidirectionalSequenceLSTMOptionsT* BidirectionalSequenceLSTMOptions::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new BidirectionalSequenceLSTMOptionsT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void BidirectionalSequenceLSTMOptions::UnPackTo(BidirectionalSequenceLSTMOptionsT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
    {
        auto _e = fused_activation_function();
        _o->fused_activation_function = _e;
    };
    {
        auto _e = cell_clip();
        _o->cell_clip = _e;
    };
    {
        auto _e = proj_clip();
        _o->proj_clip = _e;
    };
    {
        auto _e = merge_outputs();
        _o->merge_outputs = _e;
    };
    {
        auto _e = time_major();
        _o->time_major = _e;
    };
}

inline flatbuffers::Offset<BidirectionalSequenceLSTMOptions> BidirectionalSequenceLSTMOptions::Pack(flatbuffers::FlatBufferBuilder& _fbb, const BidirectionalSequenceLSTMOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreateBidirectionalSequenceLSTMOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<BidirectionalSequenceLSTMOptions> CreateBidirectionalSequenceLSTMOptions(flatbuffers::FlatBufferBuilder& _fbb, const BidirectionalSequenceLSTMOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const BidirectionalSequenceLSTMOptionsT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    auto _fused_activation_function = _o->fused_activation_function;
    auto _cell_clip = _o->cell_clip;
    auto _proj_clip = _o->proj_clip;
    auto _merge_outputs = _o->merge_outputs;
    auto _time_major = _o->time_major;
    return tflite::CreateBidirectionalSequenceLSTMOptions(
        _fbb,
        _fused_activation_function,
        _cell_clip,
        _proj_clip,
        _merge_outputs,
        _time_major);
}

inline ResizeBilinearOptionsT* ResizeBilinearOptions::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new ResizeBilinearOptionsT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void ResizeBilinearOptions::UnPackTo(ResizeBilinearOptionsT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
    {
        auto _e = align_corners();
        _o->align_corners = _e;
    };
}

inline flatbuffers::Offset<ResizeBilinearOptions> ResizeBilinearOptions::Pack(flatbuffers::FlatBufferBuilder& _fbb, const ResizeBilinearOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreateResizeBilinearOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<ResizeBilinearOptions> CreateResizeBilinearOptions(flatbuffers::FlatBufferBuilder& _fbb, const ResizeBilinearOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const ResizeBilinearOptionsT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    auto _align_corners = _o->align_corners;
    return tflite::CreateResizeBilinearOptions(
        _fbb,
        _align_corners);
}

inline ResizeNearestNeighborOptionsT* ResizeNearestNeighborOptions::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new ResizeNearestNeighborOptionsT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void ResizeNearestNeighborOptions::UnPackTo(ResizeNearestNeighborOptionsT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
    {
        auto _e = align_corners();
        _o->align_corners = _e;
    };
}

inline flatbuffers::Offset<ResizeNearestNeighborOptions> ResizeNearestNeighborOptions::Pack(flatbuffers::FlatBufferBuilder& _fbb, const ResizeNearestNeighborOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreateResizeNearestNeighborOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<ResizeNearestNeighborOptions> CreateResizeNearestNeighborOptions(flatbuffers::FlatBufferBuilder& _fbb, const ResizeNearestNeighborOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const ResizeNearestNeighborOptionsT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    auto _align_corners = _o->align_corners;
    return tflite::CreateResizeNearestNeighborOptions(
        _fbb,
        _align_corners);
}

inline CallOptionsT* CallOptions::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new CallOptionsT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void CallOptions::UnPackTo(CallOptionsT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
    {
        auto _e = subgraph();
        _o->subgraph = _e;
    };
}

inline flatbuffers::Offset<CallOptions> CallOptions::Pack(flatbuffers::FlatBufferBuilder& _fbb, const CallOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreateCallOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<CallOptions> CreateCallOptions(flatbuffers::FlatBufferBuilder& _fbb, const CallOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const CallOptionsT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    auto _subgraph = _o->subgraph;
    return tflite::CreateCallOptions(
        _fbb,
        _subgraph);
}

inline PadOptionsT* PadOptions::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new PadOptionsT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void PadOptions::UnPackTo(PadOptionsT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
}

inline flatbuffers::Offset<PadOptions> PadOptions::Pack(flatbuffers::FlatBufferBuilder& _fbb, const PadOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreatePadOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<PadOptions> CreatePadOptions(flatbuffers::FlatBufferBuilder& _fbb, const PadOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const PadOptionsT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    return tflite::CreatePadOptions(
        _fbb);
}

inline PadV2OptionsT* PadV2Options::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new PadV2OptionsT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void PadV2Options::UnPackTo(PadV2OptionsT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
}

inline flatbuffers::Offset<PadV2Options> PadV2Options::Pack(flatbuffers::FlatBufferBuilder& _fbb, const PadV2OptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreatePadV2Options(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<PadV2Options> CreatePadV2Options(flatbuffers::FlatBufferBuilder& _fbb, const PadV2OptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const PadV2OptionsT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    return tflite::CreatePadV2Options(
        _fbb);
}

inline ReshapeOptionsT* ReshapeOptions::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new ReshapeOptionsT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void ReshapeOptions::UnPackTo(ReshapeOptionsT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
    {
        auto _e = new_shape();
        if (_e)
        {
            _o->new_shape.resize(_e->size());
            for (flatbuffers::uoffset_t _i = 0; _i < _e->size(); _i++) { _o->new_shape[_i] = _e->Get(_i); }
        }
    };
}

inline flatbuffers::Offset<ReshapeOptions> ReshapeOptions::Pack(flatbuffers::FlatBufferBuilder& _fbb, const ReshapeOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreateReshapeOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<ReshapeOptions> CreateReshapeOptions(flatbuffers::FlatBufferBuilder& _fbb, const ReshapeOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const ReshapeOptionsT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    auto _new_shape = _o->new_shape.size() ? _fbb.CreateVector(_o->new_shape) : 0;
    return tflite::CreateReshapeOptions(
        _fbb,
        _new_shape);
}

inline SpaceToBatchNDOptionsT* SpaceToBatchNDOptions::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new SpaceToBatchNDOptionsT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void SpaceToBatchNDOptions::UnPackTo(SpaceToBatchNDOptionsT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
}

inline flatbuffers::Offset<SpaceToBatchNDOptions> SpaceToBatchNDOptions::Pack(flatbuffers::FlatBufferBuilder& _fbb, const SpaceToBatchNDOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreateSpaceToBatchNDOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<SpaceToBatchNDOptions> CreateSpaceToBatchNDOptions(flatbuffers::FlatBufferBuilder& _fbb, const SpaceToBatchNDOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const SpaceToBatchNDOptionsT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    return tflite::CreateSpaceToBatchNDOptions(
        _fbb);
}

inline BatchToSpaceNDOptionsT* BatchToSpaceNDOptions::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new BatchToSpaceNDOptionsT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void BatchToSpaceNDOptions::UnPackTo(BatchToSpaceNDOptionsT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
}

inline flatbuffers::Offset<BatchToSpaceNDOptions> BatchToSpaceNDOptions::Pack(flatbuffers::FlatBufferBuilder& _fbb, const BatchToSpaceNDOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreateBatchToSpaceNDOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<BatchToSpaceNDOptions> CreateBatchToSpaceNDOptions(flatbuffers::FlatBufferBuilder& _fbb, const BatchToSpaceNDOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const BatchToSpaceNDOptionsT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    return tflite::CreateBatchToSpaceNDOptions(
        _fbb);
}

inline SkipGramOptionsT* SkipGramOptions::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new SkipGramOptionsT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void SkipGramOptions::UnPackTo(SkipGramOptionsT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
    {
        auto _e = ngram_size();
        _o->ngram_size = _e;
    };
    {
        auto _e = max_skip_size();
        _o->max_skip_size = _e;
    };
    {
        auto _e = include_all_ngrams();
        _o->include_all_ngrams = _e;
    };
}

inline flatbuffers::Offset<SkipGramOptions> SkipGramOptions::Pack(flatbuffers::FlatBufferBuilder& _fbb, const SkipGramOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreateSkipGramOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<SkipGramOptions> CreateSkipGramOptions(flatbuffers::FlatBufferBuilder& _fbb, const SkipGramOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const SkipGramOptionsT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    auto _ngram_size = _o->ngram_size;
    auto _max_skip_size = _o->max_skip_size;
    auto _include_all_ngrams = _o->include_all_ngrams;
    return tflite::CreateSkipGramOptions(
        _fbb,
        _ngram_size,
        _max_skip_size,
        _include_all_ngrams);
}

inline SpaceToDepthOptionsT* SpaceToDepthOptions::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new SpaceToDepthOptionsT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void SpaceToDepthOptions::UnPackTo(SpaceToDepthOptionsT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
    {
        auto _e = block_size();
        _o->block_size = _e;
    };
}

inline flatbuffers::Offset<SpaceToDepthOptions> SpaceToDepthOptions::Pack(flatbuffers::FlatBufferBuilder& _fbb, const SpaceToDepthOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreateSpaceToDepthOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<SpaceToDepthOptions> CreateSpaceToDepthOptions(flatbuffers::FlatBufferBuilder& _fbb, const SpaceToDepthOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const SpaceToDepthOptionsT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    auto _block_size = _o->block_size;
    return tflite::CreateSpaceToDepthOptions(
        _fbb,
        _block_size);
}

inline SubOptionsT* SubOptions::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new SubOptionsT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void SubOptions::UnPackTo(SubOptionsT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
    {
        auto _e = fused_activation_function();
        _o->fused_activation_function = _e;
    };
}

inline flatbuffers::Offset<SubOptions> SubOptions::Pack(flatbuffers::FlatBufferBuilder& _fbb, const SubOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreateSubOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<SubOptions> CreateSubOptions(flatbuffers::FlatBufferBuilder& _fbb, const SubOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const SubOptionsT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    auto _fused_activation_function = _o->fused_activation_function;
    return tflite::CreateSubOptions(
        _fbb,
        _fused_activation_function);
}

inline DivOptionsT* DivOptions::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new DivOptionsT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void DivOptions::UnPackTo(DivOptionsT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
    {
        auto _e = fused_activation_function();
        _o->fused_activation_function = _e;
    };
}

inline flatbuffers::Offset<DivOptions> DivOptions::Pack(flatbuffers::FlatBufferBuilder& _fbb, const DivOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreateDivOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<DivOptions> CreateDivOptions(flatbuffers::FlatBufferBuilder& _fbb, const DivOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const DivOptionsT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    auto _fused_activation_function = _o->fused_activation_function;
    return tflite::CreateDivOptions(
        _fbb,
        _fused_activation_function);
}

inline TopKV2OptionsT* TopKV2Options::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new TopKV2OptionsT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void TopKV2Options::UnPackTo(TopKV2OptionsT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
}

inline flatbuffers::Offset<TopKV2Options> TopKV2Options::Pack(flatbuffers::FlatBufferBuilder& _fbb, const TopKV2OptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreateTopKV2Options(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<TopKV2Options> CreateTopKV2Options(flatbuffers::FlatBufferBuilder& _fbb, const TopKV2OptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const TopKV2OptionsT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    return tflite::CreateTopKV2Options(
        _fbb);
}

inline EmbeddingLookupSparseOptionsT* EmbeddingLookupSparseOptions::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new EmbeddingLookupSparseOptionsT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void EmbeddingLookupSparseOptions::UnPackTo(EmbeddingLookupSparseOptionsT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
    {
        auto _e = combiner();
        _o->combiner = _e;
    };
}

inline flatbuffers::Offset<EmbeddingLookupSparseOptions> EmbeddingLookupSparseOptions::Pack(flatbuffers::FlatBufferBuilder& _fbb, const EmbeddingLookupSparseOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreateEmbeddingLookupSparseOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<EmbeddingLookupSparseOptions> CreateEmbeddingLookupSparseOptions(flatbuffers::FlatBufferBuilder& _fbb, const EmbeddingLookupSparseOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const EmbeddingLookupSparseOptionsT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    auto _combiner = _o->combiner;
    return tflite::CreateEmbeddingLookupSparseOptions(
        _fbb,
        _combiner);
}

inline GatherOptionsT* GatherOptions::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new GatherOptionsT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void GatherOptions::UnPackTo(GatherOptionsT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
    {
        auto _e = axis();
        _o->axis = _e;
    };
}

inline flatbuffers::Offset<GatherOptions> GatherOptions::Pack(flatbuffers::FlatBufferBuilder& _fbb, const GatherOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreateGatherOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<GatherOptions> CreateGatherOptions(flatbuffers::FlatBufferBuilder& _fbb, const GatherOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const GatherOptionsT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    auto _axis = _o->axis;
    return tflite::CreateGatherOptions(
        _fbb,
        _axis);
}

inline TransposeOptionsT* TransposeOptions::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new TransposeOptionsT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void TransposeOptions::UnPackTo(TransposeOptionsT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
}

inline flatbuffers::Offset<TransposeOptions> TransposeOptions::Pack(flatbuffers::FlatBufferBuilder& _fbb, const TransposeOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreateTransposeOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<TransposeOptions> CreateTransposeOptions(flatbuffers::FlatBufferBuilder& _fbb, const TransposeOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const TransposeOptionsT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    return tflite::CreateTransposeOptions(
        _fbb);
}

inline ExpOptionsT* ExpOptions::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new ExpOptionsT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void ExpOptions::UnPackTo(ExpOptionsT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
}

inline flatbuffers::Offset<ExpOptions> ExpOptions::Pack(flatbuffers::FlatBufferBuilder& _fbb, const ExpOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreateExpOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<ExpOptions> CreateExpOptions(flatbuffers::FlatBufferBuilder& _fbb, const ExpOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const ExpOptionsT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    return tflite::CreateExpOptions(
        _fbb);
}

inline CosOptionsT* CosOptions::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new CosOptionsT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void CosOptions::UnPackTo(CosOptionsT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
}

inline flatbuffers::Offset<CosOptions> CosOptions::Pack(flatbuffers::FlatBufferBuilder& _fbb, const CosOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreateCosOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<CosOptions> CreateCosOptions(flatbuffers::FlatBufferBuilder& _fbb, const CosOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const CosOptionsT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    return tflite::CreateCosOptions(
        _fbb);
}

inline ReducerOptionsT* ReducerOptions::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new ReducerOptionsT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void ReducerOptions::UnPackTo(ReducerOptionsT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
    {
        auto _e = keep_dims();
        _o->keep_dims = _e;
    };
}

inline flatbuffers::Offset<ReducerOptions> ReducerOptions::Pack(flatbuffers::FlatBufferBuilder& _fbb, const ReducerOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreateReducerOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<ReducerOptions> CreateReducerOptions(flatbuffers::FlatBufferBuilder& _fbb, const ReducerOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const ReducerOptionsT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    auto _keep_dims = _o->keep_dims;
    return tflite::CreateReducerOptions(
        _fbb,
        _keep_dims);
}

inline SqueezeOptionsT* SqueezeOptions::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new SqueezeOptionsT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void SqueezeOptions::UnPackTo(SqueezeOptionsT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
    {
        auto _e = squeeze_dims();
        if (_e)
        {
            _o->squeeze_dims.resize(_e->size());
            for (flatbuffers::uoffset_t _i = 0; _i < _e->size(); _i++) { _o->squeeze_dims[_i] = _e->Get(_i); }
        }
    };
}

inline flatbuffers::Offset<SqueezeOptions> SqueezeOptions::Pack(flatbuffers::FlatBufferBuilder& _fbb, const SqueezeOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreateSqueezeOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<SqueezeOptions> CreateSqueezeOptions(flatbuffers::FlatBufferBuilder& _fbb, const SqueezeOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const SqueezeOptionsT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    auto _squeeze_dims = _o->squeeze_dims.size() ? _fbb.CreateVector(_o->squeeze_dims) : 0;
    return tflite::CreateSqueezeOptions(
        _fbb,
        _squeeze_dims);
}

inline SplitOptionsT* SplitOptions::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new SplitOptionsT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void SplitOptions::UnPackTo(SplitOptionsT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
    {
        auto _e = num_splits();
        _o->num_splits = _e;
    };
}

inline flatbuffers::Offset<SplitOptions> SplitOptions::Pack(flatbuffers::FlatBufferBuilder& _fbb, const SplitOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreateSplitOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<SplitOptions> CreateSplitOptions(flatbuffers::FlatBufferBuilder& _fbb, const SplitOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const SplitOptionsT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    auto _num_splits = _o->num_splits;
    return tflite::CreateSplitOptions(
        _fbb,
        _num_splits);
}

inline SplitVOptionsT* SplitVOptions::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new SplitVOptionsT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void SplitVOptions::UnPackTo(SplitVOptionsT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
    {
        auto _e = num_splits();
        _o->num_splits = _e;
    };
}

inline flatbuffers::Offset<SplitVOptions> SplitVOptions::Pack(flatbuffers::FlatBufferBuilder& _fbb, const SplitVOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreateSplitVOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<SplitVOptions> CreateSplitVOptions(flatbuffers::FlatBufferBuilder& _fbb, const SplitVOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const SplitVOptionsT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    auto _num_splits = _o->num_splits;
    return tflite::CreateSplitVOptions(
        _fbb,
        _num_splits);
}

inline StridedSliceOptionsT* StridedSliceOptions::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new StridedSliceOptionsT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void StridedSliceOptions::UnPackTo(StridedSliceOptionsT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
    {
        auto _e = begin_mask();
        _o->begin_mask = _e;
    };
    {
        auto _e = end_mask();
        _o->end_mask = _e;
    };
    {
        auto _e = ellipsis_mask();
        _o->ellipsis_mask = _e;
    };
    {
        auto _e = new_axis_mask();
        _o->new_axis_mask = _e;
    };
    {
        auto _e = shrink_axis_mask();
        _o->shrink_axis_mask = _e;
    };
}

inline flatbuffers::Offset<StridedSliceOptions> StridedSliceOptions::Pack(flatbuffers::FlatBufferBuilder& _fbb, const StridedSliceOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreateStridedSliceOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<StridedSliceOptions> CreateStridedSliceOptions(flatbuffers::FlatBufferBuilder& _fbb, const StridedSliceOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const StridedSliceOptionsT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    auto _begin_mask = _o->begin_mask;
    auto _end_mask = _o->end_mask;
    auto _ellipsis_mask = _o->ellipsis_mask;
    auto _new_axis_mask = _o->new_axis_mask;
    auto _shrink_axis_mask = _o->shrink_axis_mask;
    return tflite::CreateStridedSliceOptions(
        _fbb,
        _begin_mask,
        _end_mask,
        _ellipsis_mask,
        _new_axis_mask,
        _shrink_axis_mask);
}

inline LogSoftmaxOptionsT* LogSoftmaxOptions::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new LogSoftmaxOptionsT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void LogSoftmaxOptions::UnPackTo(LogSoftmaxOptionsT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
}

inline flatbuffers::Offset<LogSoftmaxOptions> LogSoftmaxOptions::Pack(flatbuffers::FlatBufferBuilder& _fbb, const LogSoftmaxOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreateLogSoftmaxOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<LogSoftmaxOptions> CreateLogSoftmaxOptions(flatbuffers::FlatBufferBuilder& _fbb, const LogSoftmaxOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const LogSoftmaxOptionsT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    return tflite::CreateLogSoftmaxOptions(
        _fbb);
}

inline CastOptionsT* CastOptions::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new CastOptionsT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void CastOptions::UnPackTo(CastOptionsT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
    {
        auto _e = in_data_type();
        _o->in_data_type = _e;
    };
    {
        auto _e = out_data_type();
        _o->out_data_type = _e;
    };
}

inline flatbuffers::Offset<CastOptions> CastOptions::Pack(flatbuffers::FlatBufferBuilder& _fbb, const CastOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreateCastOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<CastOptions> CreateCastOptions(flatbuffers::FlatBufferBuilder& _fbb, const CastOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const CastOptionsT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    auto _in_data_type = _o->in_data_type;
    auto _out_data_type = _o->out_data_type;
    return tflite::CreateCastOptions(
        _fbb,
        _in_data_type,
        _out_data_type);
}

inline DequantizeOptionsT* DequantizeOptions::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new DequantizeOptionsT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void DequantizeOptions::UnPackTo(DequantizeOptionsT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
}

inline flatbuffers::Offset<DequantizeOptions> DequantizeOptions::Pack(flatbuffers::FlatBufferBuilder& _fbb, const DequantizeOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreateDequantizeOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<DequantizeOptions> CreateDequantizeOptions(flatbuffers::FlatBufferBuilder& _fbb, const DequantizeOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const DequantizeOptionsT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    return tflite::CreateDequantizeOptions(
        _fbb);
}

inline MaximumMinimumOptionsT* MaximumMinimumOptions::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new MaximumMinimumOptionsT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void MaximumMinimumOptions::UnPackTo(MaximumMinimumOptionsT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
}

inline flatbuffers::Offset<MaximumMinimumOptions> MaximumMinimumOptions::Pack(flatbuffers::FlatBufferBuilder& _fbb, const MaximumMinimumOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreateMaximumMinimumOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<MaximumMinimumOptions> CreateMaximumMinimumOptions(flatbuffers::FlatBufferBuilder& _fbb, const MaximumMinimumOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const MaximumMinimumOptionsT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    return tflite::CreateMaximumMinimumOptions(
        _fbb);
}

inline TileOptionsT* TileOptions::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new TileOptionsT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void TileOptions::UnPackTo(TileOptionsT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
}

inline flatbuffers::Offset<TileOptions> TileOptions::Pack(flatbuffers::FlatBufferBuilder& _fbb, const TileOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreateTileOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<TileOptions> CreateTileOptions(flatbuffers::FlatBufferBuilder& _fbb, const TileOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const TileOptionsT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    return tflite::CreateTileOptions(
        _fbb);
}

inline ArgMaxOptionsT* ArgMaxOptions::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new ArgMaxOptionsT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void ArgMaxOptions::UnPackTo(ArgMaxOptionsT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
    {
        auto _e = output_type();
        _o->output_type = _e;
    };
}

inline flatbuffers::Offset<ArgMaxOptions> ArgMaxOptions::Pack(flatbuffers::FlatBufferBuilder& _fbb, const ArgMaxOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreateArgMaxOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<ArgMaxOptions> CreateArgMaxOptions(flatbuffers::FlatBufferBuilder& _fbb, const ArgMaxOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const ArgMaxOptionsT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    auto _output_type = _o->output_type;
    return tflite::CreateArgMaxOptions(
        _fbb,
        _output_type);
}

inline ArgMinOptionsT* ArgMinOptions::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new ArgMinOptionsT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void ArgMinOptions::UnPackTo(ArgMinOptionsT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
    {
        auto _e = output_type();
        _o->output_type = _e;
    };
}

inline flatbuffers::Offset<ArgMinOptions> ArgMinOptions::Pack(flatbuffers::FlatBufferBuilder& _fbb, const ArgMinOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreateArgMinOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<ArgMinOptions> CreateArgMinOptions(flatbuffers::FlatBufferBuilder& _fbb, const ArgMinOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const ArgMinOptionsT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    auto _output_type = _o->output_type;
    return tflite::CreateArgMinOptions(
        _fbb,
        _output_type);
}

inline GreaterOptionsT* GreaterOptions::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new GreaterOptionsT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void GreaterOptions::UnPackTo(GreaterOptionsT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
}

inline flatbuffers::Offset<GreaterOptions> GreaterOptions::Pack(flatbuffers::FlatBufferBuilder& _fbb, const GreaterOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreateGreaterOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<GreaterOptions> CreateGreaterOptions(flatbuffers::FlatBufferBuilder& _fbb, const GreaterOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const GreaterOptionsT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    return tflite::CreateGreaterOptions(
        _fbb);
}

inline GreaterEqualOptionsT* GreaterEqualOptions::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new GreaterEqualOptionsT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void GreaterEqualOptions::UnPackTo(GreaterEqualOptionsT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
}

inline flatbuffers::Offset<GreaterEqualOptions> GreaterEqualOptions::Pack(flatbuffers::FlatBufferBuilder& _fbb, const GreaterEqualOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreateGreaterEqualOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<GreaterEqualOptions> CreateGreaterEqualOptions(flatbuffers::FlatBufferBuilder& _fbb, const GreaterEqualOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const GreaterEqualOptionsT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    return tflite::CreateGreaterEqualOptions(
        _fbb);
}

inline LessOptionsT* LessOptions::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new LessOptionsT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void LessOptions::UnPackTo(LessOptionsT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
}

inline flatbuffers::Offset<LessOptions> LessOptions::Pack(flatbuffers::FlatBufferBuilder& _fbb, const LessOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreateLessOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<LessOptions> CreateLessOptions(flatbuffers::FlatBufferBuilder& _fbb, const LessOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const LessOptionsT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    return tflite::CreateLessOptions(
        _fbb);
}

inline LessEqualOptionsT* LessEqualOptions::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new LessEqualOptionsT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void LessEqualOptions::UnPackTo(LessEqualOptionsT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
}

inline flatbuffers::Offset<LessEqualOptions> LessEqualOptions::Pack(flatbuffers::FlatBufferBuilder& _fbb, const LessEqualOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreateLessEqualOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<LessEqualOptions> CreateLessEqualOptions(flatbuffers::FlatBufferBuilder& _fbb, const LessEqualOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const LessEqualOptionsT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    return tflite::CreateLessEqualOptions(
        _fbb);
}

inline NegOptionsT* NegOptions::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new NegOptionsT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void NegOptions::UnPackTo(NegOptionsT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
}

inline flatbuffers::Offset<NegOptions> NegOptions::Pack(flatbuffers::FlatBufferBuilder& _fbb, const NegOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreateNegOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<NegOptions> CreateNegOptions(flatbuffers::FlatBufferBuilder& _fbb, const NegOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const NegOptionsT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    return tflite::CreateNegOptions(
        _fbb);
}

inline SelectOptionsT* SelectOptions::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new SelectOptionsT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void SelectOptions::UnPackTo(SelectOptionsT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
}

inline flatbuffers::Offset<SelectOptions> SelectOptions::Pack(flatbuffers::FlatBufferBuilder& _fbb, const SelectOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreateSelectOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<SelectOptions> CreateSelectOptions(flatbuffers::FlatBufferBuilder& _fbb, const SelectOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const SelectOptionsT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    return tflite::CreateSelectOptions(
        _fbb);
}

inline SliceOptionsT* SliceOptions::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new SliceOptionsT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void SliceOptions::UnPackTo(SliceOptionsT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
}

inline flatbuffers::Offset<SliceOptions> SliceOptions::Pack(flatbuffers::FlatBufferBuilder& _fbb, const SliceOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreateSliceOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<SliceOptions> CreateSliceOptions(flatbuffers::FlatBufferBuilder& _fbb, const SliceOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const SliceOptionsT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    return tflite::CreateSliceOptions(
        _fbb);
}

inline TransposeConvOptionsT* TransposeConvOptions::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new TransposeConvOptionsT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void TransposeConvOptions::UnPackTo(TransposeConvOptionsT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
    {
        auto _e = padding();
        _o->padding = _e;
    };
    {
        auto _e = stride_w();
        _o->stride_w = _e;
    };
    {
        auto _e = stride_h();
        _o->stride_h = _e;
    };
}

inline flatbuffers::Offset<TransposeConvOptions> TransposeConvOptions::Pack(flatbuffers::FlatBufferBuilder& _fbb, const TransposeConvOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreateTransposeConvOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<TransposeConvOptions> CreateTransposeConvOptions(flatbuffers::FlatBufferBuilder& _fbb, const TransposeConvOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const TransposeConvOptionsT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    auto _padding = _o->padding;
    auto _stride_w = _o->stride_w;
    auto _stride_h = _o->stride_h;
    return tflite::CreateTransposeConvOptions(
        _fbb,
        _padding,
        _stride_w,
        _stride_h);
}

inline ExpandDimsOptionsT* ExpandDimsOptions::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new ExpandDimsOptionsT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void ExpandDimsOptions::UnPackTo(ExpandDimsOptionsT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
}

inline flatbuffers::Offset<ExpandDimsOptions> ExpandDimsOptions::Pack(flatbuffers::FlatBufferBuilder& _fbb, const ExpandDimsOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreateExpandDimsOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<ExpandDimsOptions> CreateExpandDimsOptions(flatbuffers::FlatBufferBuilder& _fbb, const ExpandDimsOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const ExpandDimsOptionsT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    return tflite::CreateExpandDimsOptions(
        _fbb);
}

inline SparseToDenseOptionsT* SparseToDenseOptions::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new SparseToDenseOptionsT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void SparseToDenseOptions::UnPackTo(SparseToDenseOptionsT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
    {
        auto _e = validate_indices();
        _o->validate_indices = _e;
    };
}

inline flatbuffers::Offset<SparseToDenseOptions> SparseToDenseOptions::Pack(flatbuffers::FlatBufferBuilder& _fbb, const SparseToDenseOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreateSparseToDenseOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<SparseToDenseOptions> CreateSparseToDenseOptions(flatbuffers::FlatBufferBuilder& _fbb, const SparseToDenseOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const SparseToDenseOptionsT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    auto _validate_indices = _o->validate_indices;
    return tflite::CreateSparseToDenseOptions(
        _fbb,
        _validate_indices);
}

inline EqualOptionsT* EqualOptions::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new EqualOptionsT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void EqualOptions::UnPackTo(EqualOptionsT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
}

inline flatbuffers::Offset<EqualOptions> EqualOptions::Pack(flatbuffers::FlatBufferBuilder& _fbb, const EqualOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreateEqualOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<EqualOptions> CreateEqualOptions(flatbuffers::FlatBufferBuilder& _fbb, const EqualOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const EqualOptionsT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    return tflite::CreateEqualOptions(
        _fbb);
}

inline NotEqualOptionsT* NotEqualOptions::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new NotEqualOptionsT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void NotEqualOptions::UnPackTo(NotEqualOptionsT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
}

inline flatbuffers::Offset<NotEqualOptions> NotEqualOptions::Pack(flatbuffers::FlatBufferBuilder& _fbb, const NotEqualOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreateNotEqualOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<NotEqualOptions> CreateNotEqualOptions(flatbuffers::FlatBufferBuilder& _fbb, const NotEqualOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const NotEqualOptionsT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    return tflite::CreateNotEqualOptions(
        _fbb);
}

inline ShapeOptionsT* ShapeOptions::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new ShapeOptionsT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void ShapeOptions::UnPackTo(ShapeOptionsT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
    {
        auto _e = out_type();
        _o->out_type = _e;
    };
}

inline flatbuffers::Offset<ShapeOptions> ShapeOptions::Pack(flatbuffers::FlatBufferBuilder& _fbb, const ShapeOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreateShapeOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<ShapeOptions> CreateShapeOptions(flatbuffers::FlatBufferBuilder& _fbb, const ShapeOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const ShapeOptionsT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    auto _out_type = _o->out_type;
    return tflite::CreateShapeOptions(
        _fbb,
        _out_type);
}

inline RankOptionsT* RankOptions::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new RankOptionsT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void RankOptions::UnPackTo(RankOptionsT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
}

inline flatbuffers::Offset<RankOptions> RankOptions::Pack(flatbuffers::FlatBufferBuilder& _fbb, const RankOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreateRankOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<RankOptions> CreateRankOptions(flatbuffers::FlatBufferBuilder& _fbb, const RankOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const RankOptionsT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    return tflite::CreateRankOptions(
        _fbb);
}

inline PowOptionsT* PowOptions::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new PowOptionsT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void PowOptions::UnPackTo(PowOptionsT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
}

inline flatbuffers::Offset<PowOptions> PowOptions::Pack(flatbuffers::FlatBufferBuilder& _fbb, const PowOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreatePowOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<PowOptions> CreatePowOptions(flatbuffers::FlatBufferBuilder& _fbb, const PowOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const PowOptionsT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    return tflite::CreatePowOptions(
        _fbb);
}

inline FakeQuantOptionsT* FakeQuantOptions::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new FakeQuantOptionsT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void FakeQuantOptions::UnPackTo(FakeQuantOptionsT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
    {
        auto _e = min();
        _o->min = _e;
    };
    {
        auto _e = max();
        _o->max = _e;
    };
    {
        auto _e = num_bits();
        _o->num_bits = _e;
    };
    {
        auto _e = narrow_range();
        _o->narrow_range = _e;
    };
}

inline flatbuffers::Offset<FakeQuantOptions> FakeQuantOptions::Pack(flatbuffers::FlatBufferBuilder& _fbb, const FakeQuantOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreateFakeQuantOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<FakeQuantOptions> CreateFakeQuantOptions(flatbuffers::FlatBufferBuilder& _fbb, const FakeQuantOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const FakeQuantOptionsT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    auto _min = _o->min;
    auto _max = _o->max;
    auto _num_bits = _o->num_bits;
    auto _narrow_range = _o->narrow_range;
    return tflite::CreateFakeQuantOptions(
        _fbb,
        _min,
        _max,
        _num_bits,
        _narrow_range);
}

inline PackOptionsT* PackOptions::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new PackOptionsT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void PackOptions::UnPackTo(PackOptionsT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
    {
        auto _e = values_count();
        _o->values_count = _e;
    };
    {
        auto _e = axis();
        _o->axis = _e;
    };
}

inline flatbuffers::Offset<PackOptions> PackOptions::Pack(flatbuffers::FlatBufferBuilder& _fbb, const PackOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreatePackOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<PackOptions> CreatePackOptions(flatbuffers::FlatBufferBuilder& _fbb, const PackOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const PackOptionsT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    auto _values_count = _o->values_count;
    auto _axis = _o->axis;
    return tflite::CreatePackOptions(
        _fbb,
        _values_count,
        _axis);
}

inline LogicalOrOptionsT* LogicalOrOptions::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new LogicalOrOptionsT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void LogicalOrOptions::UnPackTo(LogicalOrOptionsT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
}

inline flatbuffers::Offset<LogicalOrOptions> LogicalOrOptions::Pack(flatbuffers::FlatBufferBuilder& _fbb, const LogicalOrOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreateLogicalOrOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<LogicalOrOptions> CreateLogicalOrOptions(flatbuffers::FlatBufferBuilder& _fbb, const LogicalOrOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const LogicalOrOptionsT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    return tflite::CreateLogicalOrOptions(
        _fbb);
}

inline OneHotOptionsT* OneHotOptions::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new OneHotOptionsT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void OneHotOptions::UnPackTo(OneHotOptionsT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
    {
        auto _e = axis();
        _o->axis = _e;
    };
}

inline flatbuffers::Offset<OneHotOptions> OneHotOptions::Pack(flatbuffers::FlatBufferBuilder& _fbb, const OneHotOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreateOneHotOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<OneHotOptions> CreateOneHotOptions(flatbuffers::FlatBufferBuilder& _fbb, const OneHotOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const OneHotOptionsT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    auto _axis = _o->axis;
    return tflite::CreateOneHotOptions(
        _fbb,
        _axis);
}

inline AbsOptionsT* AbsOptions::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new AbsOptionsT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void AbsOptions::UnPackTo(AbsOptionsT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
}

inline flatbuffers::Offset<AbsOptions> AbsOptions::Pack(flatbuffers::FlatBufferBuilder& _fbb, const AbsOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreateAbsOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<AbsOptions> CreateAbsOptions(flatbuffers::FlatBufferBuilder& _fbb, const AbsOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const AbsOptionsT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    return tflite::CreateAbsOptions(
        _fbb);
}

inline HardSwishOptionsT* HardSwishOptions::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new HardSwishOptionsT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void HardSwishOptions::UnPackTo(HardSwishOptionsT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
}

inline flatbuffers::Offset<HardSwishOptions> HardSwishOptions::Pack(flatbuffers::FlatBufferBuilder& _fbb, const HardSwishOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreateHardSwishOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<HardSwishOptions> CreateHardSwishOptions(flatbuffers::FlatBufferBuilder& _fbb, const HardSwishOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const HardSwishOptionsT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    return tflite::CreateHardSwishOptions(
        _fbb);
}

inline LogicalAndOptionsT* LogicalAndOptions::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new LogicalAndOptionsT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void LogicalAndOptions::UnPackTo(LogicalAndOptionsT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
}

inline flatbuffers::Offset<LogicalAndOptions> LogicalAndOptions::Pack(flatbuffers::FlatBufferBuilder& _fbb, const LogicalAndOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreateLogicalAndOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<LogicalAndOptions> CreateLogicalAndOptions(flatbuffers::FlatBufferBuilder& _fbb, const LogicalAndOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const LogicalAndOptionsT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    return tflite::CreateLogicalAndOptions(
        _fbb);
}

inline LogicalNotOptionsT* LogicalNotOptions::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new LogicalNotOptionsT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void LogicalNotOptions::UnPackTo(LogicalNotOptionsT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
}

inline flatbuffers::Offset<LogicalNotOptions> LogicalNotOptions::Pack(flatbuffers::FlatBufferBuilder& _fbb, const LogicalNotOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreateLogicalNotOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<LogicalNotOptions> CreateLogicalNotOptions(flatbuffers::FlatBufferBuilder& _fbb, const LogicalNotOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const LogicalNotOptionsT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    return tflite::CreateLogicalNotOptions(
        _fbb);
}

inline UnpackOptionsT* UnpackOptions::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new UnpackOptionsT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void UnpackOptions::UnPackTo(UnpackOptionsT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
    {
        auto _e = num();
        _o->num = _e;
    };
    {
        auto _e = axis();
        _o->axis = _e;
    };
}

inline flatbuffers::Offset<UnpackOptions> UnpackOptions::Pack(flatbuffers::FlatBufferBuilder& _fbb, const UnpackOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreateUnpackOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<UnpackOptions> CreateUnpackOptions(flatbuffers::FlatBufferBuilder& _fbb, const UnpackOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const UnpackOptionsT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    auto _num = _o->num;
    auto _axis = _o->axis;
    return tflite::CreateUnpackOptions(
        _fbb,
        _num,
        _axis);
}

inline FloorDivOptionsT* FloorDivOptions::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new FloorDivOptionsT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void FloorDivOptions::UnPackTo(FloorDivOptionsT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
}

inline flatbuffers::Offset<FloorDivOptions> FloorDivOptions::Pack(flatbuffers::FlatBufferBuilder& _fbb, const FloorDivOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreateFloorDivOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<FloorDivOptions> CreateFloorDivOptions(flatbuffers::FlatBufferBuilder& _fbb, const FloorDivOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const FloorDivOptionsT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    return tflite::CreateFloorDivOptions(
        _fbb);
}

inline SquareOptionsT* SquareOptions::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new SquareOptionsT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void SquareOptions::UnPackTo(SquareOptionsT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
}

inline flatbuffers::Offset<SquareOptions> SquareOptions::Pack(flatbuffers::FlatBufferBuilder& _fbb, const SquareOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreateSquareOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<SquareOptions> CreateSquareOptions(flatbuffers::FlatBufferBuilder& _fbb, const SquareOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const SquareOptionsT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    return tflite::CreateSquareOptions(
        _fbb);
}

inline ZerosLikeOptionsT* ZerosLikeOptions::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new ZerosLikeOptionsT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void ZerosLikeOptions::UnPackTo(ZerosLikeOptionsT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
}

inline flatbuffers::Offset<ZerosLikeOptions> ZerosLikeOptions::Pack(flatbuffers::FlatBufferBuilder& _fbb, const ZerosLikeOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreateZerosLikeOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<ZerosLikeOptions> CreateZerosLikeOptions(flatbuffers::FlatBufferBuilder& _fbb, const ZerosLikeOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const ZerosLikeOptionsT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    return tflite::CreateZerosLikeOptions(
        _fbb);
}

inline FillOptionsT* FillOptions::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new FillOptionsT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void FillOptions::UnPackTo(FillOptionsT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
}

inline flatbuffers::Offset<FillOptions> FillOptions::Pack(flatbuffers::FlatBufferBuilder& _fbb, const FillOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreateFillOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<FillOptions> CreateFillOptions(flatbuffers::FlatBufferBuilder& _fbb, const FillOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const FillOptionsT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    return tflite::CreateFillOptions(
        _fbb);
}

inline FloorModOptionsT* FloorModOptions::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new FloorModOptionsT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void FloorModOptions::UnPackTo(FloorModOptionsT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
}

inline flatbuffers::Offset<FloorModOptions> FloorModOptions::Pack(flatbuffers::FlatBufferBuilder& _fbb, const FloorModOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreateFloorModOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<FloorModOptions> CreateFloorModOptions(flatbuffers::FlatBufferBuilder& _fbb, const FloorModOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const FloorModOptionsT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    return tflite::CreateFloorModOptions(
        _fbb);
}

inline RangeOptionsT* RangeOptions::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new RangeOptionsT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void RangeOptions::UnPackTo(RangeOptionsT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
}

inline flatbuffers::Offset<RangeOptions> RangeOptions::Pack(flatbuffers::FlatBufferBuilder& _fbb, const RangeOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreateRangeOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<RangeOptions> CreateRangeOptions(flatbuffers::FlatBufferBuilder& _fbb, const RangeOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const RangeOptionsT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    return tflite::CreateRangeOptions(
        _fbb);
}

inline LeakyReluOptionsT* LeakyReluOptions::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new LeakyReluOptionsT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void LeakyReluOptions::UnPackTo(LeakyReluOptionsT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
    {
        auto _e = alpha();
        _o->alpha = _e;
    };
}

inline flatbuffers::Offset<LeakyReluOptions> LeakyReluOptions::Pack(flatbuffers::FlatBufferBuilder& _fbb, const LeakyReluOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreateLeakyReluOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<LeakyReluOptions> CreateLeakyReluOptions(flatbuffers::FlatBufferBuilder& _fbb, const LeakyReluOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const LeakyReluOptionsT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    auto _alpha = _o->alpha;
    return tflite::CreateLeakyReluOptions(
        _fbb,
        _alpha);
}

inline SquaredDifferenceOptionsT* SquaredDifferenceOptions::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new SquaredDifferenceOptionsT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void SquaredDifferenceOptions::UnPackTo(SquaredDifferenceOptionsT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
}

inline flatbuffers::Offset<SquaredDifferenceOptions> SquaredDifferenceOptions::Pack(flatbuffers::FlatBufferBuilder& _fbb, const SquaredDifferenceOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreateSquaredDifferenceOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<SquaredDifferenceOptions> CreateSquaredDifferenceOptions(flatbuffers::FlatBufferBuilder& _fbb, const SquaredDifferenceOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const SquaredDifferenceOptionsT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    return tflite::CreateSquaredDifferenceOptions(
        _fbb);
}

inline MirrorPadOptionsT* MirrorPadOptions::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new MirrorPadOptionsT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void MirrorPadOptions::UnPackTo(MirrorPadOptionsT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
    {
        auto _e = mode();
        _o->mode = _e;
    };
}

inline flatbuffers::Offset<MirrorPadOptions> MirrorPadOptions::Pack(flatbuffers::FlatBufferBuilder& _fbb, const MirrorPadOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreateMirrorPadOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<MirrorPadOptions> CreateMirrorPadOptions(flatbuffers::FlatBufferBuilder& _fbb, const MirrorPadOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const MirrorPadOptionsT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    auto _mode = _o->mode;
    return tflite::CreateMirrorPadOptions(
        _fbb,
        _mode);
}

inline UniqueOptionsT* UniqueOptions::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new UniqueOptionsT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void UniqueOptions::UnPackTo(UniqueOptionsT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
    {
        auto _e = idx_out_type();
        _o->idx_out_type = _e;
    };
}

inline flatbuffers::Offset<UniqueOptions> UniqueOptions::Pack(flatbuffers::FlatBufferBuilder& _fbb, const UniqueOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreateUniqueOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<UniqueOptions> CreateUniqueOptions(flatbuffers::FlatBufferBuilder& _fbb, const UniqueOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const UniqueOptionsT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    auto _idx_out_type = _o->idx_out_type;
    return tflite::CreateUniqueOptions(
        _fbb,
        _idx_out_type);
}

inline ReverseV2OptionsT* ReverseV2Options::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new ReverseV2OptionsT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void ReverseV2Options::UnPackTo(ReverseV2OptionsT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
}

inline flatbuffers::Offset<ReverseV2Options> ReverseV2Options::Pack(flatbuffers::FlatBufferBuilder& _fbb, const ReverseV2OptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreateReverseV2Options(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<ReverseV2Options> CreateReverseV2Options(flatbuffers::FlatBufferBuilder& _fbb, const ReverseV2OptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const ReverseV2OptionsT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    return tflite::CreateReverseV2Options(
        _fbb);
}

inline AddNOptionsT* AddNOptions::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new AddNOptionsT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void AddNOptions::UnPackTo(AddNOptionsT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
}

inline flatbuffers::Offset<AddNOptions> AddNOptions::Pack(flatbuffers::FlatBufferBuilder& _fbb, const AddNOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreateAddNOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<AddNOptions> CreateAddNOptions(flatbuffers::FlatBufferBuilder& _fbb, const AddNOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const AddNOptionsT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    return tflite::CreateAddNOptions(
        _fbb);
}

inline GatherNdOptionsT* GatherNdOptions::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new GatherNdOptionsT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void GatherNdOptions::UnPackTo(GatherNdOptionsT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
}

inline flatbuffers::Offset<GatherNdOptions> GatherNdOptions::Pack(flatbuffers::FlatBufferBuilder& _fbb, const GatherNdOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreateGatherNdOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<GatherNdOptions> CreateGatherNdOptions(flatbuffers::FlatBufferBuilder& _fbb, const GatherNdOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const GatherNdOptionsT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    return tflite::CreateGatherNdOptions(
        _fbb);
}

inline WhereOptionsT* WhereOptions::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new WhereOptionsT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void WhereOptions::UnPackTo(WhereOptionsT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
}

inline flatbuffers::Offset<WhereOptions> WhereOptions::Pack(flatbuffers::FlatBufferBuilder& _fbb, const WhereOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreateWhereOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<WhereOptions> CreateWhereOptions(flatbuffers::FlatBufferBuilder& _fbb, const WhereOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const WhereOptionsT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    return tflite::CreateWhereOptions(
        _fbb);
}

inline ReverseSequenceOptionsT* ReverseSequenceOptions::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new ReverseSequenceOptionsT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void ReverseSequenceOptions::UnPackTo(ReverseSequenceOptionsT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
    {
        auto _e = seq_dim();
        _o->seq_dim = _e;
    };
    {
        auto _e = batch_dim();
        _o->batch_dim = _e;
    };
}

inline flatbuffers::Offset<ReverseSequenceOptions> ReverseSequenceOptions::Pack(flatbuffers::FlatBufferBuilder& _fbb, const ReverseSequenceOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreateReverseSequenceOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<ReverseSequenceOptions> CreateReverseSequenceOptions(flatbuffers::FlatBufferBuilder& _fbb, const ReverseSequenceOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const ReverseSequenceOptionsT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    auto _seq_dim = _o->seq_dim;
    auto _batch_dim = _o->batch_dim;
    return tflite::CreateReverseSequenceOptions(
        _fbb,
        _seq_dim,
        _batch_dim);
}

inline MatrixDiagOptionsT* MatrixDiagOptions::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new MatrixDiagOptionsT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void MatrixDiagOptions::UnPackTo(MatrixDiagOptionsT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
}

inline flatbuffers::Offset<MatrixDiagOptions> MatrixDiagOptions::Pack(flatbuffers::FlatBufferBuilder& _fbb, const MatrixDiagOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreateMatrixDiagOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<MatrixDiagOptions> CreateMatrixDiagOptions(flatbuffers::FlatBufferBuilder& _fbb, const MatrixDiagOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const MatrixDiagOptionsT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    return tflite::CreateMatrixDiagOptions(
        _fbb);
}

inline QuantizeOptionsT* QuantizeOptions::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new QuantizeOptionsT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void QuantizeOptions::UnPackTo(QuantizeOptionsT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
}

inline flatbuffers::Offset<QuantizeOptions> QuantizeOptions::Pack(flatbuffers::FlatBufferBuilder& _fbb, const QuantizeOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreateQuantizeOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<QuantizeOptions> CreateQuantizeOptions(flatbuffers::FlatBufferBuilder& _fbb, const QuantizeOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const QuantizeOptionsT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    return tflite::CreateQuantizeOptions(
        _fbb);
}

inline MatrixSetDiagOptionsT* MatrixSetDiagOptions::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new MatrixSetDiagOptionsT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void MatrixSetDiagOptions::UnPackTo(MatrixSetDiagOptionsT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
}

inline flatbuffers::Offset<MatrixSetDiagOptions> MatrixSetDiagOptions::Pack(flatbuffers::FlatBufferBuilder& _fbb, const MatrixSetDiagOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreateMatrixSetDiagOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<MatrixSetDiagOptions> CreateMatrixSetDiagOptions(flatbuffers::FlatBufferBuilder& _fbb, const MatrixSetDiagOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const MatrixSetDiagOptionsT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    return tflite::CreateMatrixSetDiagOptions(
        _fbb);
}

inline IfOptionsT* IfOptions::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new IfOptionsT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void IfOptions::UnPackTo(IfOptionsT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
    {
        auto _e = then_subgraph_index();
        _o->then_subgraph_index = _e;
    };
    {
        auto _e = else_subgraph_index();
        _o->else_subgraph_index = _e;
    };
}

inline flatbuffers::Offset<IfOptions> IfOptions::Pack(flatbuffers::FlatBufferBuilder& _fbb, const IfOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreateIfOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<IfOptions> CreateIfOptions(flatbuffers::FlatBufferBuilder& _fbb, const IfOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const IfOptionsT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    auto _then_subgraph_index = _o->then_subgraph_index;
    auto _else_subgraph_index = _o->else_subgraph_index;
    return tflite::CreateIfOptions(
        _fbb,
        _then_subgraph_index,
        _else_subgraph_index);
}

inline WhileOptionsT* WhileOptions::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new WhileOptionsT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void WhileOptions::UnPackTo(WhileOptionsT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
    {
        auto _e = cond_subgraph_index();
        _o->cond_subgraph_index = _e;
    };
    {
        auto _e = body_subgraph_index();
        _o->body_subgraph_index = _e;
    };
}

inline flatbuffers::Offset<WhileOptions> WhileOptions::Pack(flatbuffers::FlatBufferBuilder& _fbb, const WhileOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreateWhileOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<WhileOptions> CreateWhileOptions(flatbuffers::FlatBufferBuilder& _fbb, const WhileOptionsT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const WhileOptionsT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    auto _cond_subgraph_index = _o->cond_subgraph_index;
    auto _body_subgraph_index = _o->body_subgraph_index;
    return tflite::CreateWhileOptions(
        _fbb,
        _cond_subgraph_index,
        _body_subgraph_index);
}

inline OperatorCodeT* OperatorCode::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new OperatorCodeT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void OperatorCode::UnPackTo(OperatorCodeT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
    {
        auto _e = builtin_code();
        _o->builtin_code = _e;
    };
    {
        auto _e = custom_code();
        if (_e) _o->custom_code = _e->str();
    };
    {
        auto _e = version();
        _o->version = _e;
    };
}

inline flatbuffers::Offset<OperatorCode> OperatorCode::Pack(flatbuffers::FlatBufferBuilder& _fbb, const OperatorCodeT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreateOperatorCode(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<OperatorCode> CreateOperatorCode(flatbuffers::FlatBufferBuilder& _fbb, const OperatorCodeT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const OperatorCodeT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    auto _builtin_code = _o->builtin_code;
    auto _custom_code = _o->custom_code.empty() ? 0 : _fbb.CreateString(_o->custom_code);
    auto _version = _o->version;
    return tflite::CreateOperatorCode(
        _fbb,
        _builtin_code,
        _custom_code,
        _version);
}

inline OperatorT* Operator::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new OperatorT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void Operator::UnPackTo(OperatorT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
    {
        auto _e = opcode_index();
        _o->opcode_index = _e;
    };
    {
        auto _e = inputs();
        if (_e)
        {
            _o->inputs.resize(_e->size());
            for (flatbuffers::uoffset_t _i = 0; _i < _e->size(); _i++) { _o->inputs[_i] = _e->Get(_i); }
        }
    };
    {
        auto _e = outputs();
        if (_e)
        {
            _o->outputs.resize(_e->size());
            for (flatbuffers::uoffset_t _i = 0; _i < _e->size(); _i++) { _o->outputs[_i] = _e->Get(_i); }
        }
    };
    {
        auto _e = builtin_options_type();
        _o->builtin_options.type = _e;
    };
    {
        auto _e = builtin_options();
        if (_e) _o->builtin_options.value = BuiltinOptionsUnion::UnPack(_e, builtin_options_type(), _resolver);
    };
    {
        auto _e = custom_options();
        if (_e)
        {
            _o->custom_options.resize(_e->size());
            for (flatbuffers::uoffset_t _i = 0; _i < _e->size(); _i++) { _o->custom_options[_i] = _e->Get(_i); }
        }
    };
    {
        auto _e = custom_options_format();
        _o->custom_options_format = _e;
    };
    {
        auto _e = mutating_variable_inputs();
        if (_e)
        {
            _o->mutating_variable_inputs.resize(_e->size());
            for (flatbuffers::uoffset_t _i = 0; _i < _e->size(); _i++) { _o->mutating_variable_inputs[_i] = _e->Get(_i) != 0; }
        }
    };
    {
        auto _e = intermediates();
        if (_e)
        {
            _o->intermediates.resize(_e->size());
            for (flatbuffers::uoffset_t _i = 0; _i < _e->size(); _i++) { _o->intermediates[_i] = _e->Get(_i); }
        }
    };
}

inline flatbuffers::Offset<Operator> Operator::Pack(flatbuffers::FlatBufferBuilder& _fbb, const OperatorT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreateOperator(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<Operator> CreateOperator(flatbuffers::FlatBufferBuilder& _fbb, const OperatorT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const OperatorT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    auto _opcode_index = _o->opcode_index;
    auto _inputs = _o->inputs.size() ? _fbb.CreateVector(_o->inputs) : 0;
    auto _outputs = _o->outputs.size() ? _fbb.CreateVector(_o->outputs) : 0;
    auto _builtin_options_type = _o->builtin_options.type;
    auto _builtin_options = _o->builtin_options.Pack(_fbb);
    auto _custom_options = _o->custom_options.size() ? _fbb.CreateVector(_o->custom_options) : 0;
    auto _custom_options_format = _o->custom_options_format;
    auto _mutating_variable_inputs = _o->mutating_variable_inputs.size() ? _fbb.CreateVector(_o->mutating_variable_inputs) : 0;
    auto _intermediates = _o->intermediates.size() ? _fbb.CreateVector(_o->intermediates) : 0;
    return tflite::CreateOperator(
        _fbb,
        _opcode_index,
        _inputs,
        _outputs,
        _builtin_options_type,
        _builtin_options,
        _custom_options,
        _custom_options_format,
        _mutating_variable_inputs,
        _intermediates);
}

inline SubGraphT* SubGraph::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new SubGraphT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void SubGraph::UnPackTo(SubGraphT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
    {
        auto _e = tensors();
        if (_e)
        {
            _o->tensors.resize(_e->size());
            for (flatbuffers::uoffset_t _i = 0; _i < _e->size(); _i++) { _o->tensors[_i] = std::unique_ptr<TensorT>(_e->Get(_i)->UnPack(_resolver)); }
        }
    };
    {
        auto _e = inputs();
        if (_e)
        {
            _o->inputs.resize(_e->size());
            for (flatbuffers::uoffset_t _i = 0; _i < _e->size(); _i++) { _o->inputs[_i] = _e->Get(_i); }
        }
    };
    {
        auto _e = outputs();
        if (_e)
        {
            _o->outputs.resize(_e->size());
            for (flatbuffers::uoffset_t _i = 0; _i < _e->size(); _i++) { _o->outputs[_i] = _e->Get(_i); }
        }
    };
    {
        auto _e = operators();
        if (_e)
        {
            _o->operators.resize(_e->size());
            for (flatbuffers::uoffset_t _i = 0; _i < _e->size(); _i++) { _o->operators[_i] = std::unique_ptr<OperatorT>(_e->Get(_i)->UnPack(_resolver)); }
        }
    };
    {
        auto _e = name();
        if (_e) _o->name = _e->str();
    };
}

inline flatbuffers::Offset<SubGraph> SubGraph::Pack(flatbuffers::FlatBufferBuilder& _fbb, const SubGraphT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreateSubGraph(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<SubGraph> CreateSubGraph(flatbuffers::FlatBufferBuilder& _fbb, const SubGraphT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const SubGraphT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    auto _tensors = _o->tensors.size() ? _fbb.CreateVector<flatbuffers::Offset<Tensor> >(
                        _o->tensors.size(), [](size_t i, _VectorArgs* __va) { return CreateTensor(*__va->__fbb, __va->__o->tensors[i].get(), __va->__rehasher); }, &_va)
                                       : 0;
    auto _inputs = _o->inputs.size() ? _fbb.CreateVector(_o->inputs) : 0;
    auto _outputs = _o->outputs.size() ? _fbb.CreateVector(_o->outputs) : 0;
    auto _operators = _o->operators.size() ? _fbb.CreateVector<flatbuffers::Offset<Operator> >(
                          _o->operators.size(), [](size_t i, _VectorArgs* __va) { return CreateOperator(*__va->__fbb, __va->__o->operators[i].get(), __va->__rehasher); }, &_va)
                                           : 0;
    auto _name = _o->name.empty() ? 0 : _fbb.CreateString(_o->name);
    return tflite::CreateSubGraph(
        _fbb,
        _tensors,
        _inputs,
        _outputs,
        _operators,
        _name);
}

inline BufferT* Buffer::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new BufferT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void Buffer::UnPackTo(BufferT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
    {
        auto _e = data();
        if (_e)
        {
            _o->data.resize(_e->size());
            for (flatbuffers::uoffset_t _i = 0; _i < _e->size(); _i++) { _o->data[_i] = _e->Get(_i); }
        }
    };
}

inline flatbuffers::Offset<Buffer> Buffer::Pack(flatbuffers::FlatBufferBuilder& _fbb, const BufferT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreateBuffer(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<Buffer> CreateBuffer(flatbuffers::FlatBufferBuilder& _fbb, const BufferT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const BufferT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    auto _data = _o->data.size() ? _fbb.CreateVector(_o->data) : 0;
    return tflite::CreateBuffer(
        _fbb,
        _data);
}

inline MetadataT* Metadata::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new MetadataT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void Metadata::UnPackTo(MetadataT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
    {
        auto _e = name();
        if (_e) _o->name = _e->str();
    };
    {
        auto _e = buffer();
        _o->buffer = _e;
    };
}

inline flatbuffers::Offset<Metadata> Metadata::Pack(flatbuffers::FlatBufferBuilder& _fbb, const MetadataT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreateMetadata(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<Metadata> CreateMetadata(flatbuffers::FlatBufferBuilder& _fbb, const MetadataT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const MetadataT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    auto _name = _o->name.empty() ? 0 : _fbb.CreateString(_o->name);
    auto _buffer = _o->buffer;
    return tflite::CreateMetadata(
        _fbb,
        _name,
        _buffer);
}

inline ModelT* Model::UnPack(const flatbuffers::resolver_function_t* _resolver) const
{
    auto _o = new ModelT();
    UnPackTo(_o, _resolver);
    return _o;
}

inline void Model::UnPackTo(ModelT* _o, const flatbuffers::resolver_function_t* _resolver) const
{
    (void)_o;
    (void)_resolver;
    {
        auto _e = version();
        _o->version = _e;
    };
    {
        auto _e = operator_codes();
        if (_e)
        {
            _o->operator_codes.resize(_e->size());
            for (flatbuffers::uoffset_t _i = 0; _i < _e->size(); _i++) { _o->operator_codes[_i] = std::unique_ptr<OperatorCodeT>(_e->Get(_i)->UnPack(_resolver)); }
        }
    };
    {
        auto _e = subgraphs();
        if (_e)
        {
            _o->subgraphs.resize(_e->size());
            for (flatbuffers::uoffset_t _i = 0; _i < _e->size(); _i++) { _o->subgraphs[_i] = std::unique_ptr<SubGraphT>(_e->Get(_i)->UnPack(_resolver)); }
        }
    };
    {
        auto _e = description();
        if (_e) _o->description = _e->str();
    };
    {
        auto _e = buffers();
        if (_e)
        {
            _o->buffers.resize(_e->size());
            for (flatbuffers::uoffset_t _i = 0; _i < _e->size(); _i++) { _o->buffers[_i] = std::unique_ptr<BufferT>(_e->Get(_i)->UnPack(_resolver)); }
        }
    };
    {
        auto _e = metadata_buffer();
        if (_e)
        {
            _o->metadata_buffer.resize(_e->size());
            for (flatbuffers::uoffset_t _i = 0; _i < _e->size(); _i++) { _o->metadata_buffer[_i] = _e->Get(_i); }
        }
    };
    {
        auto _e = metadata();
        if (_e)
        {
            _o->metadata.resize(_e->size());
            for (flatbuffers::uoffset_t _i = 0; _i < _e->size(); _i++) { _o->metadata[_i] = std::unique_ptr<MetadataT>(_e->Get(_i)->UnPack(_resolver)); }
        }
    };
}

inline flatbuffers::Offset<Model> Model::Pack(flatbuffers::FlatBufferBuilder& _fbb, const ModelT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    return CreateModel(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<Model> CreateModel(flatbuffers::FlatBufferBuilder& _fbb, const ModelT* _o, const flatbuffers::rehasher_function_t* _rehasher)
{
    (void)_rehasher;
    (void)_o;
    struct _VectorArgs
    {
        flatbuffers::FlatBufferBuilder* __fbb;
        const ModelT* __o;
        const flatbuffers::rehasher_function_t* __rehasher;
    } _va = {&_fbb, _o, _rehasher};
    (void)_va;
    auto _version = _o->version;
    auto _operator_codes = _o->operator_codes.size() ? _fbb.CreateVector<flatbuffers::Offset<OperatorCode> >(
                               _o->operator_codes.size(), [](size_t i, _VectorArgs* __va) { return CreateOperatorCode(*__va->__fbb, __va->__o->operator_codes[i].get(), __va->__rehasher); }, &_va)
                                                     : 0;
    auto _subgraphs = _o->subgraphs.size() ? _fbb.CreateVector<flatbuffers::Offset<SubGraph> >(
                          _o->subgraphs.size(), [](size_t i, _VectorArgs* __va) { return CreateSubGraph(*__va->__fbb, __va->__o->subgraphs[i].get(), __va->__rehasher); }, &_va)
                                           : 0;
    auto _description = _o->description.empty() ? 0 : _fbb.CreateString(_o->description);
    auto _buffers = _o->buffers.size() ? _fbb.CreateVector<flatbuffers::Offset<Buffer> >(
                        _o->buffers.size(), [](size_t i, _VectorArgs* __va) { return CreateBuffer(*__va->__fbb, __va->__o->buffers[i].get(), __va->__rehasher); }, &_va)
                                       : 0;
    auto _metadata_buffer = _o->metadata_buffer.size() ? _fbb.CreateVector(_o->metadata_buffer) : 0;
    auto _metadata = _o->metadata.size() ? _fbb.CreateVector<flatbuffers::Offset<Metadata> >(
                         _o->metadata.size(), [](size_t i, _VectorArgs* __va) { return CreateMetadata(*__va->__fbb, __va->__o->metadata[i].get(), __va->__rehasher); }, &_va)
                                         : 0;
    return tflite::CreateModel(
        _fbb,
        _version,
        _operator_codes,
        _subgraphs,
        _description,
        _buffers,
        _metadata_buffer,
        _metadata);
}

inline bool VerifyQuantizationDetails(flatbuffers::Verifier& verifier, const void* obj, QuantizationDetails type)
{
    switch (type)
    {
    case QuantizationDetails_NONE:
    {
        return true;
    }
    case QuantizationDetails_CustomQuantization:
    {
        auto ptr = reinterpret_cast<const CustomQuantization*>(obj);
        return verifier.VerifyTable(ptr);
    }
    default: return false;
    }
}

inline bool VerifyQuantizationDetailsVector(flatbuffers::Verifier& verifier, const flatbuffers::Vector<flatbuffers::Offset<void> >* values, const flatbuffers::Vector<uint8_t>* types)
{
    if (!values || !types) return !values && !types;
    if (values->size() != types->size()) return false;
    for (flatbuffers::uoffset_t i = 0; i < values->size(); ++i)
    {
        if (!VerifyQuantizationDetails(
                verifier, values->Get(i), types->GetEnum<QuantizationDetails>(i)))
        {
            return false;
        }
    }
    return true;
}

inline void* QuantizationDetailsUnion::UnPack(const void* obj, QuantizationDetails type, const flatbuffers::resolver_function_t* resolver)
{
    switch (type)
    {
    case QuantizationDetails_CustomQuantization:
    {
        auto ptr = reinterpret_cast<const CustomQuantization*>(obj);
        return ptr->UnPack(resolver);
    }
    default: return nullptr;
    }
}

inline flatbuffers::Offset<void> QuantizationDetailsUnion::Pack(flatbuffers::FlatBufferBuilder& _fbb, const flatbuffers::rehasher_function_t* _rehasher) const
{
    switch (type)
    {
    case QuantizationDetails_CustomQuantization:
    {
        auto ptr = reinterpret_cast<const CustomQuantizationT*>(value);
        return CreateCustomQuantization(_fbb, ptr, _rehasher).Union();
    }
    default: return 0;
    }
}

inline QuantizationDetailsUnion::QuantizationDetailsUnion(const QuantizationDetailsUnion& u) FLATBUFFERS_NOEXCEPT : type(u.type), value(nullptr)
{
    switch (type)
    {
    case QuantizationDetails_CustomQuantization:
    {
        value = new CustomQuantizationT(*reinterpret_cast<CustomQuantizationT*>(u.value));
        break;
    }
    default:
        break;
    }
}

inline void QuantizationDetailsUnion::Reset()
{
    switch (type)
    {
    case QuantizationDetails_CustomQuantization:
    {
        auto ptr = reinterpret_cast<CustomQuantizationT*>(value);
        delete ptr;
        break;
    }
    default: break;
    }
    value = nullptr;
    type = QuantizationDetails_NONE;
}

inline bool VerifyBuiltinOptions(flatbuffers::Verifier& verifier, const void* obj, BuiltinOptions type)
{
    switch (type)
    {
    case BuiltinOptions_NONE:
    {
        return true;
    }
    case BuiltinOptions_Conv2DOptions:
    {
        auto ptr = reinterpret_cast<const Conv2DOptions*>(obj);
        return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_DepthwiseConv2DOptions:
    {
        auto ptr = reinterpret_cast<const DepthwiseConv2DOptions*>(obj);
        return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_ConcatEmbeddingsOptions:
    {
        auto ptr = reinterpret_cast<const ConcatEmbeddingsOptions*>(obj);
        return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_LSHProjectionOptions:
    {
        auto ptr = reinterpret_cast<const LSHProjectionOptions*>(obj);
        return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_Pool2DOptions:
    {
        auto ptr = reinterpret_cast<const Pool2DOptions*>(obj);
        return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_SVDFOptions:
    {
        auto ptr = reinterpret_cast<const SVDFOptions*>(obj);
        return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_RNNOptions:
    {
        auto ptr = reinterpret_cast<const RNNOptions*>(obj);
        return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_FullyConnectedOptions:
    {
        auto ptr = reinterpret_cast<const FullyConnectedOptions*>(obj);
        return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_SoftmaxOptions:
    {
        auto ptr = reinterpret_cast<const SoftmaxOptions*>(obj);
        return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_ConcatenationOptions:
    {
        auto ptr = reinterpret_cast<const ConcatenationOptions*>(obj);
        return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_AddOptions:
    {
        auto ptr = reinterpret_cast<const AddOptions*>(obj);
        return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_L2NormOptions:
    {
        auto ptr = reinterpret_cast<const L2NormOptions*>(obj);
        return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_LocalResponseNormalizationOptions:
    {
        auto ptr = reinterpret_cast<const LocalResponseNormalizationOptions*>(obj);
        return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_LSTMOptions:
    {
        auto ptr = reinterpret_cast<const LSTMOptions*>(obj);
        return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_ResizeBilinearOptions:
    {
        auto ptr = reinterpret_cast<const ResizeBilinearOptions*>(obj);
        return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_CallOptions:
    {
        auto ptr = reinterpret_cast<const CallOptions*>(obj);
        return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_ReshapeOptions:
    {
        auto ptr = reinterpret_cast<const ReshapeOptions*>(obj);
        return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_SkipGramOptions:
    {
        auto ptr = reinterpret_cast<const SkipGramOptions*>(obj);
        return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_SpaceToDepthOptions:
    {
        auto ptr = reinterpret_cast<const SpaceToDepthOptions*>(obj);
        return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_EmbeddingLookupSparseOptions:
    {
        auto ptr = reinterpret_cast<const EmbeddingLookupSparseOptions*>(obj);
        return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_MulOptions:
    {
        auto ptr = reinterpret_cast<const MulOptions*>(obj);
        return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_PadOptions:
    {
        auto ptr = reinterpret_cast<const PadOptions*>(obj);
        return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_GatherOptions:
    {
        auto ptr = reinterpret_cast<const GatherOptions*>(obj);
        return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_BatchToSpaceNDOptions:
    {
        auto ptr = reinterpret_cast<const BatchToSpaceNDOptions*>(obj);
        return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_SpaceToBatchNDOptions:
    {
        auto ptr = reinterpret_cast<const SpaceToBatchNDOptions*>(obj);
        return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_TransposeOptions:
    {
        auto ptr = reinterpret_cast<const TransposeOptions*>(obj);
        return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_ReducerOptions:
    {
        auto ptr = reinterpret_cast<const ReducerOptions*>(obj);
        return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_SubOptions:
    {
        auto ptr = reinterpret_cast<const SubOptions*>(obj);
        return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_DivOptions:
    {
        auto ptr = reinterpret_cast<const DivOptions*>(obj);
        return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_SqueezeOptions:
    {
        auto ptr = reinterpret_cast<const SqueezeOptions*>(obj);
        return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_SequenceRNNOptions:
    {
        auto ptr = reinterpret_cast<const SequenceRNNOptions*>(obj);
        return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_StridedSliceOptions:
    {
        auto ptr = reinterpret_cast<const StridedSliceOptions*>(obj);
        return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_ExpOptions:
    {
        auto ptr = reinterpret_cast<const ExpOptions*>(obj);
        return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_TopKV2Options:
    {
        auto ptr = reinterpret_cast<const TopKV2Options*>(obj);
        return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_SplitOptions:
    {
        auto ptr = reinterpret_cast<const SplitOptions*>(obj);
        return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_LogSoftmaxOptions:
    {
        auto ptr = reinterpret_cast<const LogSoftmaxOptions*>(obj);
        return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_CastOptions:
    {
        auto ptr = reinterpret_cast<const CastOptions*>(obj);
        return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_DequantizeOptions:
    {
        auto ptr = reinterpret_cast<const DequantizeOptions*>(obj);
        return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_MaximumMinimumOptions:
    {
        auto ptr = reinterpret_cast<const MaximumMinimumOptions*>(obj);
        return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_ArgMaxOptions:
    {
        auto ptr = reinterpret_cast<const ArgMaxOptions*>(obj);
        return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_LessOptions:
    {
        auto ptr = reinterpret_cast<const LessOptions*>(obj);
        return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_NegOptions:
    {
        auto ptr = reinterpret_cast<const NegOptions*>(obj);
        return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_PadV2Options:
    {
        auto ptr = reinterpret_cast<const PadV2Options*>(obj);
        return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_GreaterOptions:
    {
        auto ptr = reinterpret_cast<const GreaterOptions*>(obj);
        return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_GreaterEqualOptions:
    {
        auto ptr = reinterpret_cast<const GreaterEqualOptions*>(obj);
        return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_LessEqualOptions:
    {
        auto ptr = reinterpret_cast<const LessEqualOptions*>(obj);
        return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_SelectOptions:
    {
        auto ptr = reinterpret_cast<const SelectOptions*>(obj);
        return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_SliceOptions:
    {
        auto ptr = reinterpret_cast<const SliceOptions*>(obj);
        return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_TransposeConvOptions:
    {
        auto ptr = reinterpret_cast<const TransposeConvOptions*>(obj);
        return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_SparseToDenseOptions:
    {
        auto ptr = reinterpret_cast<const SparseToDenseOptions*>(obj);
        return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_TileOptions:
    {
        auto ptr = reinterpret_cast<const TileOptions*>(obj);
        return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_ExpandDimsOptions:
    {
        auto ptr = reinterpret_cast<const ExpandDimsOptions*>(obj);
        return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_EqualOptions:
    {
        auto ptr = reinterpret_cast<const EqualOptions*>(obj);
        return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_NotEqualOptions:
    {
        auto ptr = reinterpret_cast<const NotEqualOptions*>(obj);
        return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_ShapeOptions:
    {
        auto ptr = reinterpret_cast<const ShapeOptions*>(obj);
        return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_PowOptions:
    {
        auto ptr = reinterpret_cast<const PowOptions*>(obj);
        return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_ArgMinOptions:
    {
        auto ptr = reinterpret_cast<const ArgMinOptions*>(obj);
        return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_FakeQuantOptions:
    {
        auto ptr = reinterpret_cast<const FakeQuantOptions*>(obj);
        return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_PackOptions:
    {
        auto ptr = reinterpret_cast<const PackOptions*>(obj);
        return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_LogicalOrOptions:
    {
        auto ptr = reinterpret_cast<const LogicalOrOptions*>(obj);
        return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_OneHotOptions:
    {
        auto ptr = reinterpret_cast<const OneHotOptions*>(obj);
        return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_LogicalAndOptions:
    {
        auto ptr = reinterpret_cast<const LogicalAndOptions*>(obj);
        return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_LogicalNotOptions:
    {
        auto ptr = reinterpret_cast<const LogicalNotOptions*>(obj);
        return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_UnpackOptions:
    {
        auto ptr = reinterpret_cast<const UnpackOptions*>(obj);
        return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_FloorDivOptions:
    {
        auto ptr = reinterpret_cast<const FloorDivOptions*>(obj);
        return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_SquareOptions:
    {
        auto ptr = reinterpret_cast<const SquareOptions*>(obj);
        return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_ZerosLikeOptions:
    {
        auto ptr = reinterpret_cast<const ZerosLikeOptions*>(obj);
        return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_FillOptions:
    {
        auto ptr = reinterpret_cast<const FillOptions*>(obj);
        return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_BidirectionalSequenceLSTMOptions:
    {
        auto ptr = reinterpret_cast<const BidirectionalSequenceLSTMOptions*>(obj);
        return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_BidirectionalSequenceRNNOptions:
    {
        auto ptr = reinterpret_cast<const BidirectionalSequenceRNNOptions*>(obj);
        return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_UnidirectionalSequenceLSTMOptions:
    {
        auto ptr = reinterpret_cast<const UnidirectionalSequenceLSTMOptions*>(obj);
        return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_FloorModOptions:
    {
        auto ptr = reinterpret_cast<const FloorModOptions*>(obj);
        return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_RangeOptions:
    {
        auto ptr = reinterpret_cast<const RangeOptions*>(obj);
        return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_ResizeNearestNeighborOptions:
    {
        auto ptr = reinterpret_cast<const ResizeNearestNeighborOptions*>(obj);
        return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_LeakyReluOptions:
    {
        auto ptr = reinterpret_cast<const LeakyReluOptions*>(obj);
        return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_SquaredDifferenceOptions:
    {
        auto ptr = reinterpret_cast<const SquaredDifferenceOptions*>(obj);
        return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_MirrorPadOptions:
    {
        auto ptr = reinterpret_cast<const MirrorPadOptions*>(obj);
        return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_AbsOptions:
    {
        auto ptr = reinterpret_cast<const AbsOptions*>(obj);
        return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_SplitVOptions:
    {
        auto ptr = reinterpret_cast<const SplitVOptions*>(obj);
        return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_UniqueOptions:
    {
        auto ptr = reinterpret_cast<const UniqueOptions*>(obj);
        return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_ReverseV2Options:
    {
        auto ptr = reinterpret_cast<const ReverseV2Options*>(obj);
        return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_AddNOptions:
    {
        auto ptr = reinterpret_cast<const AddNOptions*>(obj);
        return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_GatherNdOptions:
    {
        auto ptr = reinterpret_cast<const GatherNdOptions*>(obj);
        return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_CosOptions:
    {
        auto ptr = reinterpret_cast<const CosOptions*>(obj);
        return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_WhereOptions:
    {
        auto ptr = reinterpret_cast<const WhereOptions*>(obj);
        return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_RankOptions:
    {
        auto ptr = reinterpret_cast<const RankOptions*>(obj);
        return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_ReverseSequenceOptions:
    {
        auto ptr = reinterpret_cast<const ReverseSequenceOptions*>(obj);
        return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_MatrixDiagOptions:
    {
        auto ptr = reinterpret_cast<const MatrixDiagOptions*>(obj);
        return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_QuantizeOptions:
    {
        auto ptr = reinterpret_cast<const QuantizeOptions*>(obj);
        return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_MatrixSetDiagOptions:
    {
        auto ptr = reinterpret_cast<const MatrixSetDiagOptions*>(obj);
        return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_HardSwishOptions:
    {
        auto ptr = reinterpret_cast<const HardSwishOptions*>(obj);
        return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_IfOptions:
    {
        auto ptr = reinterpret_cast<const IfOptions*>(obj);
        return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_WhileOptions:
    {
        auto ptr = reinterpret_cast<const WhileOptions*>(obj);
        return verifier.VerifyTable(ptr);
    }
    default: return false;
    }
}

inline bool VerifyBuiltinOptionsVector(flatbuffers::Verifier& verifier, const flatbuffers::Vector<flatbuffers::Offset<void> >* values, const flatbuffers::Vector<uint8_t>* types)
{
    if (!values || !types) return !values && !types;
    if (values->size() != types->size()) return false;
    for (flatbuffers::uoffset_t i = 0; i < values->size(); ++i)
    {
        if (!VerifyBuiltinOptions(
                verifier, values->Get(i), types->GetEnum<BuiltinOptions>(i)))
        {
            return false;
        }
    }
    return true;
}

inline void* BuiltinOptionsUnion::UnPack(const void* obj, BuiltinOptions type, const flatbuffers::resolver_function_t* resolver)
{
    switch (type)
    {
    case BuiltinOptions_Conv2DOptions:
    {
        auto ptr = reinterpret_cast<const Conv2DOptions*>(obj);
        return ptr->UnPack(resolver);
    }
    case BuiltinOptions_DepthwiseConv2DOptions:
    {
        auto ptr = reinterpret_cast<const DepthwiseConv2DOptions*>(obj);
        return ptr->UnPack(resolver);
    }
    case BuiltinOptions_ConcatEmbeddingsOptions:
    {
        auto ptr = reinterpret_cast<const ConcatEmbeddingsOptions*>(obj);
        return ptr->UnPack(resolver);
    }
    case BuiltinOptions_LSHProjectionOptions:
    {
        auto ptr = reinterpret_cast<const LSHProjectionOptions*>(obj);
        return ptr->UnPack(resolver);
    }
    case BuiltinOptions_Pool2DOptions:
    {
        auto ptr = reinterpret_cast<const Pool2DOptions*>(obj);
        return ptr->UnPack(resolver);
    }
    case BuiltinOptions_SVDFOptions:
    {
        auto ptr = reinterpret_cast<const SVDFOptions*>(obj);
        return ptr->UnPack(resolver);
    }
    case BuiltinOptions_RNNOptions:
    {
        auto ptr = reinterpret_cast<const RNNOptions*>(obj);
        return ptr->UnPack(resolver);
    }
    case BuiltinOptions_FullyConnectedOptions:
    {
        auto ptr = reinterpret_cast<const FullyConnectedOptions*>(obj);
        return ptr->UnPack(resolver);
    }
    case BuiltinOptions_SoftmaxOptions:
    {
        auto ptr = reinterpret_cast<const SoftmaxOptions*>(obj);
        return ptr->UnPack(resolver);
    }
    case BuiltinOptions_ConcatenationOptions:
    {
        auto ptr = reinterpret_cast<const ConcatenationOptions*>(obj);
        return ptr->UnPack(resolver);
    }
    case BuiltinOptions_AddOptions:
    {
        auto ptr = reinterpret_cast<const AddOptions*>(obj);
        return ptr->UnPack(resolver);
    }
    case BuiltinOptions_L2NormOptions:
    {
        auto ptr = reinterpret_cast<const L2NormOptions*>(obj);
        return ptr->UnPack(resolver);
    }
    case BuiltinOptions_LocalResponseNormalizationOptions:
    {
        auto ptr = reinterpret_cast<const LocalResponseNormalizationOptions*>(obj);
        return ptr->UnPack(resolver);
    }
    case BuiltinOptions_LSTMOptions:
    {
        auto ptr = reinterpret_cast<const LSTMOptions*>(obj);
        return ptr->UnPack(resolver);
    }
    case BuiltinOptions_ResizeBilinearOptions:
    {
        auto ptr = reinterpret_cast<const ResizeBilinearOptions*>(obj);
        return ptr->UnPack(resolver);
    }
    case BuiltinOptions_CallOptions:
    {
        auto ptr = reinterpret_cast<const CallOptions*>(obj);
        return ptr->UnPack(resolver);
    }
    case BuiltinOptions_ReshapeOptions:
    {
        auto ptr = reinterpret_cast<const ReshapeOptions*>(obj);
        return ptr->UnPack(resolver);
    }
    case BuiltinOptions_SkipGramOptions:
    {
        auto ptr = reinterpret_cast<const SkipGramOptions*>(obj);
        return ptr->UnPack(resolver);
    }
    case BuiltinOptions_SpaceToDepthOptions:
    {
        auto ptr = reinterpret_cast<const SpaceToDepthOptions*>(obj);
        return ptr->UnPack(resolver);
    }
    case BuiltinOptions_EmbeddingLookupSparseOptions:
    {
        auto ptr = reinterpret_cast<const EmbeddingLookupSparseOptions*>(obj);
        return ptr->UnPack(resolver);
    }
    case BuiltinOptions_MulOptions:
    {
        auto ptr = reinterpret_cast<const MulOptions*>(obj);
        return ptr->UnPack(resolver);
    }
    case BuiltinOptions_PadOptions:
    {
        auto ptr = reinterpret_cast<const PadOptions*>(obj);
        return ptr->UnPack(resolver);
    }
    case BuiltinOptions_GatherOptions:
    {
        auto ptr = reinterpret_cast<const GatherOptions*>(obj);
        return ptr->UnPack(resolver);
    }
    case BuiltinOptions_BatchToSpaceNDOptions:
    {
        auto ptr = reinterpret_cast<const BatchToSpaceNDOptions*>(obj);
        return ptr->UnPack(resolver);
    }
    case BuiltinOptions_SpaceToBatchNDOptions:
    {
        auto ptr = reinterpret_cast<const SpaceToBatchNDOptions*>(obj);
        return ptr->UnPack(resolver);
    }
    case BuiltinOptions_TransposeOptions:
    {
        auto ptr = reinterpret_cast<const TransposeOptions*>(obj);
        return ptr->UnPack(resolver);
    }
    case BuiltinOptions_ReducerOptions:
    {
        auto ptr = reinterpret_cast<const ReducerOptions*>(obj);
        return ptr->UnPack(resolver);
    }
    case BuiltinOptions_SubOptions:
    {
        auto ptr = reinterpret_cast<const SubOptions*>(obj);
        return ptr->UnPack(resolver);
    }
    case BuiltinOptions_DivOptions:
    {
        auto ptr = reinterpret_cast<const DivOptions*>(obj);
        return ptr->UnPack(resolver);
    }
    case BuiltinOptions_SqueezeOptions:
    {
        auto ptr = reinterpret_cast<const SqueezeOptions*>(obj);
        return ptr->UnPack(resolver);
    }
    case BuiltinOptions_SequenceRNNOptions:
    {
        auto ptr = reinterpret_cast<const SequenceRNNOptions*>(obj);
        return ptr->UnPack(resolver);
    }
    case BuiltinOptions_StridedSliceOptions:
    {
        auto ptr = reinterpret_cast<const StridedSliceOptions*>(obj);
        return ptr->UnPack(resolver);
    }
    case BuiltinOptions_ExpOptions:
    {
        auto ptr = reinterpret_cast<const ExpOptions*>(obj);
        return ptr->UnPack(resolver);
    }
    case BuiltinOptions_TopKV2Options:
    {
        auto ptr = reinterpret_cast<const TopKV2Options*>(obj);
        return ptr->UnPack(resolver);
    }
    case BuiltinOptions_SplitOptions:
    {
        auto ptr = reinterpret_cast<const SplitOptions*>(obj);
        return ptr->UnPack(resolver);
    }
    case BuiltinOptions_LogSoftmaxOptions:
    {
        auto ptr = reinterpret_cast<const LogSoftmaxOptions*>(obj);
        return ptr->UnPack(resolver);
    }
    case BuiltinOptions_CastOptions:
    {
        auto ptr = reinterpret_cast<const CastOptions*>(obj);
        return ptr->UnPack(resolver);
    }
    case BuiltinOptions_DequantizeOptions:
    {
        auto ptr = reinterpret_cast<const DequantizeOptions*>(obj);
        return ptr->UnPack(resolver);
    }
    case BuiltinOptions_MaximumMinimumOptions:
    {
        auto ptr = reinterpret_cast<const MaximumMinimumOptions*>(obj);
        return ptr->UnPack(resolver);
    }
    case BuiltinOptions_ArgMaxOptions:
    {
        auto ptr = reinterpret_cast<const ArgMaxOptions*>(obj);
        return ptr->UnPack(resolver);
    }
    case BuiltinOptions_LessOptions:
    {
        auto ptr = reinterpret_cast<const LessOptions*>(obj);
        return ptr->UnPack(resolver);
    }
    case BuiltinOptions_NegOptions:
    {
        auto ptr = reinterpret_cast<const NegOptions*>(obj);
        return ptr->UnPack(resolver);
    }
    case BuiltinOptions_PadV2Options:
    {
        auto ptr = reinterpret_cast<const PadV2Options*>(obj);
        return ptr->UnPack(resolver);
    }
    case BuiltinOptions_GreaterOptions:
    {
        auto ptr = reinterpret_cast<const GreaterOptions*>(obj);
        return ptr->UnPack(resolver);
    }
    case BuiltinOptions_GreaterEqualOptions:
    {
        auto ptr = reinterpret_cast<const GreaterEqualOptions*>(obj);
        return ptr->UnPack(resolver);
    }
    case BuiltinOptions_LessEqualOptions:
    {
        auto ptr = reinterpret_cast<const LessEqualOptions*>(obj);
        return ptr->UnPack(resolver);
    }
    case BuiltinOptions_SelectOptions:
    {
        auto ptr = reinterpret_cast<const SelectOptions*>(obj);
        return ptr->UnPack(resolver);
    }
    case BuiltinOptions_SliceOptions:
    {
        auto ptr = reinterpret_cast<const SliceOptions*>(obj);
        return ptr->UnPack(resolver);
    }
    case BuiltinOptions_TransposeConvOptions:
    {
        auto ptr = reinterpret_cast<const TransposeConvOptions*>(obj);
        return ptr->UnPack(resolver);
    }
    case BuiltinOptions_SparseToDenseOptions:
    {
        auto ptr = reinterpret_cast<const SparseToDenseOptions*>(obj);
        return ptr->UnPack(resolver);
    }
    case BuiltinOptions_TileOptions:
    {
        auto ptr = reinterpret_cast<const TileOptions*>(obj);
        return ptr->UnPack(resolver);
    }
    case BuiltinOptions_ExpandDimsOptions:
    {
        auto ptr = reinterpret_cast<const ExpandDimsOptions*>(obj);
        return ptr->UnPack(resolver);
    }
    case BuiltinOptions_EqualOptions:
    {
        auto ptr = reinterpret_cast<const EqualOptions*>(obj);
        return ptr->UnPack(resolver);
    }
    case BuiltinOptions_NotEqualOptions:
    {
        auto ptr = reinterpret_cast<const NotEqualOptions*>(obj);
        return ptr->UnPack(resolver);
    }
    case BuiltinOptions_ShapeOptions:
    {
        auto ptr = reinterpret_cast<const ShapeOptions*>(obj);
        return ptr->UnPack(resolver);
    }
    case BuiltinOptions_PowOptions:
    {
        auto ptr = reinterpret_cast<const PowOptions*>(obj);
        return ptr->UnPack(resolver);
    }
    case BuiltinOptions_ArgMinOptions:
    {
        auto ptr = reinterpret_cast<const ArgMinOptions*>(obj);
        return ptr->UnPack(resolver);
    }
    case BuiltinOptions_FakeQuantOptions:
    {
        auto ptr = reinterpret_cast<const FakeQuantOptions*>(obj);
        return ptr->UnPack(resolver);
    }
    case BuiltinOptions_PackOptions:
    {
        auto ptr = reinterpret_cast<const PackOptions*>(obj);
        return ptr->UnPack(resolver);
    }
    case BuiltinOptions_LogicalOrOptions:
    {
        auto ptr = reinterpret_cast<const LogicalOrOptions*>(obj);
        return ptr->UnPack(resolver);
    }
    case BuiltinOptions_OneHotOptions:
    {
        auto ptr = reinterpret_cast<const OneHotOptions*>(obj);
        return ptr->UnPack(resolver);
    }
    case BuiltinOptions_LogicalAndOptions:
    {
        auto ptr = reinterpret_cast<const LogicalAndOptions*>(obj);
        return ptr->UnPack(resolver);
    }
    case BuiltinOptions_LogicalNotOptions:
    {
        auto ptr = reinterpret_cast<const LogicalNotOptions*>(obj);
        return ptr->UnPack(resolver);
    }
    case BuiltinOptions_UnpackOptions:
    {
        auto ptr = reinterpret_cast<const UnpackOptions*>(obj);
        return ptr->UnPack(resolver);
    }
    case BuiltinOptions_FloorDivOptions:
    {
        auto ptr = reinterpret_cast<const FloorDivOptions*>(obj);
        return ptr->UnPack(resolver);
    }
    case BuiltinOptions_SquareOptions:
    {
        auto ptr = reinterpret_cast<const SquareOptions*>(obj);
        return ptr->UnPack(resolver);
    }
    case BuiltinOptions_ZerosLikeOptions:
    {
        auto ptr = reinterpret_cast<const ZerosLikeOptions*>(obj);
        return ptr->UnPack(resolver);
    }
    case BuiltinOptions_FillOptions:
    {
        auto ptr = reinterpret_cast<const FillOptions*>(obj);
        return ptr->UnPack(resolver);
    }
    case BuiltinOptions_BidirectionalSequenceLSTMOptions:
    {
        auto ptr = reinterpret_cast<const BidirectionalSequenceLSTMOptions*>(obj);
        return ptr->UnPack(resolver);
    }
    case BuiltinOptions_BidirectionalSequenceRNNOptions:
    {
        auto ptr = reinterpret_cast<const BidirectionalSequenceRNNOptions*>(obj);
        return ptr->UnPack(resolver);
    }
    case BuiltinOptions_UnidirectionalSequenceLSTMOptions:
    {
        auto ptr = reinterpret_cast<const UnidirectionalSequenceLSTMOptions*>(obj);
        return ptr->UnPack(resolver);
    }
    case BuiltinOptions_FloorModOptions:
    {
        auto ptr = reinterpret_cast<const FloorModOptions*>(obj);
        return ptr->UnPack(resolver);
    }
    case BuiltinOptions_RangeOptions:
    {
        auto ptr = reinterpret_cast<const RangeOptions*>(obj);
        return ptr->UnPack(resolver);
    }
    case BuiltinOptions_ResizeNearestNeighborOptions:
    {
        auto ptr = reinterpret_cast<const ResizeNearestNeighborOptions*>(obj);
        return ptr->UnPack(resolver);
    }
    case BuiltinOptions_LeakyReluOptions:
    {
        auto ptr = reinterpret_cast<const LeakyReluOptions*>(obj);
        return ptr->UnPack(resolver);
    }
    case BuiltinOptions_SquaredDifferenceOptions:
    {
        auto ptr = reinterpret_cast<const SquaredDifferenceOptions*>(obj);
        return ptr->UnPack(resolver);
    }
    case BuiltinOptions_MirrorPadOptions:
    {
        auto ptr = reinterpret_cast<const MirrorPadOptions*>(obj);
        return ptr->UnPack(resolver);
    }
    case BuiltinOptions_AbsOptions:
    {
        auto ptr = reinterpret_cast<const AbsOptions*>(obj);
        return ptr->UnPack(resolver);
    }
    case BuiltinOptions_SplitVOptions:
    {
        auto ptr = reinterpret_cast<const SplitVOptions*>(obj);
        return ptr->UnPack(resolver);
    }
    case BuiltinOptions_UniqueOptions:
    {
        auto ptr = reinterpret_cast<const UniqueOptions*>(obj);
        return ptr->UnPack(resolver);
    }
    case BuiltinOptions_ReverseV2Options:
    {
        auto ptr = reinterpret_cast<const ReverseV2Options*>(obj);
        return ptr->UnPack(resolver);
    }
    case BuiltinOptions_AddNOptions:
    {
        auto ptr = reinterpret_cast<const AddNOptions*>(obj);
        return ptr->UnPack(resolver);
    }
    case BuiltinOptions_GatherNdOptions:
    {
        auto ptr = reinterpret_cast<const GatherNdOptions*>(obj);
        return ptr->UnPack(resolver);
    }
    case BuiltinOptions_CosOptions:
    {
        auto ptr = reinterpret_cast<const CosOptions*>(obj);
        return ptr->UnPack(resolver);
    }
    case BuiltinOptions_WhereOptions:
    {
        auto ptr = reinterpret_cast<const WhereOptions*>(obj);
        return ptr->UnPack(resolver);
    }
    case BuiltinOptions_RankOptions:
    {
        auto ptr = reinterpret_cast<const RankOptions*>(obj);
        return ptr->UnPack(resolver);
    }
    case BuiltinOptions_ReverseSequenceOptions:
    {
        auto ptr = reinterpret_cast<const ReverseSequenceOptions*>(obj);
        return ptr->UnPack(resolver);
    }
    case BuiltinOptions_MatrixDiagOptions:
    {
        auto ptr = reinterpret_cast<const MatrixDiagOptions*>(obj);
        return ptr->UnPack(resolver);
    }
    case BuiltinOptions_QuantizeOptions:
    {
        auto ptr = reinterpret_cast<const QuantizeOptions*>(obj);
        return ptr->UnPack(resolver);
    }
    case BuiltinOptions_MatrixSetDiagOptions:
    {
        auto ptr = reinterpret_cast<const MatrixSetDiagOptions*>(obj);
        return ptr->UnPack(resolver);
    }
    case BuiltinOptions_HardSwishOptions:
    {
        auto ptr = reinterpret_cast<const HardSwishOptions*>(obj);
        return ptr->UnPack(resolver);
    }
    case BuiltinOptions_IfOptions:
    {
        auto ptr = reinterpret_cast<const IfOptions*>(obj);
        return ptr->UnPack(resolver);
    }
    case BuiltinOptions_WhileOptions:
    {
        auto ptr = reinterpret_cast<const WhileOptions*>(obj);
        return ptr->UnPack(resolver);
    }
    default: return nullptr;
    }
}

inline flatbuffers::Offset<void> BuiltinOptionsUnion::Pack(flatbuffers::FlatBufferBuilder& _fbb, const flatbuffers::rehasher_function_t* _rehasher) const
{
    switch (type)
    {
    case BuiltinOptions_Conv2DOptions:
    {
        auto ptr = reinterpret_cast<const Conv2DOptionsT*>(value);
        return CreateConv2DOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_DepthwiseConv2DOptions:
    {
        auto ptr = reinterpret_cast<const DepthwiseConv2DOptionsT*>(value);
        return CreateDepthwiseConv2DOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_ConcatEmbeddingsOptions:
    {
        auto ptr = reinterpret_cast<const ConcatEmbeddingsOptionsT*>(value);
        return CreateConcatEmbeddingsOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_LSHProjectionOptions:
    {
        auto ptr = reinterpret_cast<const LSHProjectionOptionsT*>(value);
        return CreateLSHProjectionOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_Pool2DOptions:
    {
        auto ptr = reinterpret_cast<const Pool2DOptionsT*>(value);
        return CreatePool2DOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_SVDFOptions:
    {
        auto ptr = reinterpret_cast<const SVDFOptionsT*>(value);
        return CreateSVDFOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_RNNOptions:
    {
        auto ptr = reinterpret_cast<const RNNOptionsT*>(value);
        return CreateRNNOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_FullyConnectedOptions:
    {
        auto ptr = reinterpret_cast<const FullyConnectedOptionsT*>(value);
        return CreateFullyConnectedOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_SoftmaxOptions:
    {
        auto ptr = reinterpret_cast<const SoftmaxOptionsT*>(value);
        return CreateSoftmaxOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_ConcatenationOptions:
    {
        auto ptr = reinterpret_cast<const ConcatenationOptionsT*>(value);
        return CreateConcatenationOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_AddOptions:
    {
        auto ptr = reinterpret_cast<const AddOptionsT*>(value);
        return CreateAddOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_L2NormOptions:
    {
        auto ptr = reinterpret_cast<const L2NormOptionsT*>(value);
        return CreateL2NormOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_LocalResponseNormalizationOptions:
    {
        auto ptr = reinterpret_cast<const LocalResponseNormalizationOptionsT*>(value);
        return CreateLocalResponseNormalizationOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_LSTMOptions:
    {
        auto ptr = reinterpret_cast<const LSTMOptionsT*>(value);
        return CreateLSTMOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_ResizeBilinearOptions:
    {
        auto ptr = reinterpret_cast<const ResizeBilinearOptionsT*>(value);
        return CreateResizeBilinearOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_CallOptions:
    {
        auto ptr = reinterpret_cast<const CallOptionsT*>(value);
        return CreateCallOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_ReshapeOptions:
    {
        auto ptr = reinterpret_cast<const ReshapeOptionsT*>(value);
        return CreateReshapeOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_SkipGramOptions:
    {
        auto ptr = reinterpret_cast<const SkipGramOptionsT*>(value);
        return CreateSkipGramOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_SpaceToDepthOptions:
    {
        auto ptr = reinterpret_cast<const SpaceToDepthOptionsT*>(value);
        return CreateSpaceToDepthOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_EmbeddingLookupSparseOptions:
    {
        auto ptr = reinterpret_cast<const EmbeddingLookupSparseOptionsT*>(value);
        return CreateEmbeddingLookupSparseOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_MulOptions:
    {
        auto ptr = reinterpret_cast<const MulOptionsT*>(value);
        return CreateMulOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_PadOptions:
    {
        auto ptr = reinterpret_cast<const PadOptionsT*>(value);
        return CreatePadOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_GatherOptions:
    {
        auto ptr = reinterpret_cast<const GatherOptionsT*>(value);
        return CreateGatherOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_BatchToSpaceNDOptions:
    {
        auto ptr = reinterpret_cast<const BatchToSpaceNDOptionsT*>(value);
        return CreateBatchToSpaceNDOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_SpaceToBatchNDOptions:
    {
        auto ptr = reinterpret_cast<const SpaceToBatchNDOptionsT*>(value);
        return CreateSpaceToBatchNDOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_TransposeOptions:
    {
        auto ptr = reinterpret_cast<const TransposeOptionsT*>(value);
        return CreateTransposeOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_ReducerOptions:
    {
        auto ptr = reinterpret_cast<const ReducerOptionsT*>(value);
        return CreateReducerOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_SubOptions:
    {
        auto ptr = reinterpret_cast<const SubOptionsT*>(value);
        return CreateSubOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_DivOptions:
    {
        auto ptr = reinterpret_cast<const DivOptionsT*>(value);
        return CreateDivOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_SqueezeOptions:
    {
        auto ptr = reinterpret_cast<const SqueezeOptionsT*>(value);
        return CreateSqueezeOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_SequenceRNNOptions:
    {
        auto ptr = reinterpret_cast<const SequenceRNNOptionsT*>(value);
        return CreateSequenceRNNOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_StridedSliceOptions:
    {
        auto ptr = reinterpret_cast<const StridedSliceOptionsT*>(value);
        return CreateStridedSliceOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_ExpOptions:
    {
        auto ptr = reinterpret_cast<const ExpOptionsT*>(value);
        return CreateExpOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_TopKV2Options:
    {
        auto ptr = reinterpret_cast<const TopKV2OptionsT*>(value);
        return CreateTopKV2Options(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_SplitOptions:
    {
        auto ptr = reinterpret_cast<const SplitOptionsT*>(value);
        return CreateSplitOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_LogSoftmaxOptions:
    {
        auto ptr = reinterpret_cast<const LogSoftmaxOptionsT*>(value);
        return CreateLogSoftmaxOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_CastOptions:
    {
        auto ptr = reinterpret_cast<const CastOptionsT*>(value);
        return CreateCastOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_DequantizeOptions:
    {
        auto ptr = reinterpret_cast<const DequantizeOptionsT*>(value);
        return CreateDequantizeOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_MaximumMinimumOptions:
    {
        auto ptr = reinterpret_cast<const MaximumMinimumOptionsT*>(value);
        return CreateMaximumMinimumOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_ArgMaxOptions:
    {
        auto ptr = reinterpret_cast<const ArgMaxOptionsT*>(value);
        return CreateArgMaxOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_LessOptions:
    {
        auto ptr = reinterpret_cast<const LessOptionsT*>(value);
        return CreateLessOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_NegOptions:
    {
        auto ptr = reinterpret_cast<const NegOptionsT*>(value);
        return CreateNegOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_PadV2Options:
    {
        auto ptr = reinterpret_cast<const PadV2OptionsT*>(value);
        return CreatePadV2Options(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_GreaterOptions:
    {
        auto ptr = reinterpret_cast<const GreaterOptionsT*>(value);
        return CreateGreaterOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_GreaterEqualOptions:
    {
        auto ptr = reinterpret_cast<const GreaterEqualOptionsT*>(value);
        return CreateGreaterEqualOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_LessEqualOptions:
    {
        auto ptr = reinterpret_cast<const LessEqualOptionsT*>(value);
        return CreateLessEqualOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_SelectOptions:
    {
        auto ptr = reinterpret_cast<const SelectOptionsT*>(value);
        return CreateSelectOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_SliceOptions:
    {
        auto ptr = reinterpret_cast<const SliceOptionsT*>(value);
        return CreateSliceOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_TransposeConvOptions:
    {
        auto ptr = reinterpret_cast<const TransposeConvOptionsT*>(value);
        return CreateTransposeConvOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_SparseToDenseOptions:
    {
        auto ptr = reinterpret_cast<const SparseToDenseOptionsT*>(value);
        return CreateSparseToDenseOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_TileOptions:
    {
        auto ptr = reinterpret_cast<const TileOptionsT*>(value);
        return CreateTileOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_ExpandDimsOptions:
    {
        auto ptr = reinterpret_cast<const ExpandDimsOptionsT*>(value);
        return CreateExpandDimsOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_EqualOptions:
    {
        auto ptr = reinterpret_cast<const EqualOptionsT*>(value);
        return CreateEqualOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_NotEqualOptions:
    {
        auto ptr = reinterpret_cast<const NotEqualOptionsT*>(value);
        return CreateNotEqualOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_ShapeOptions:
    {
        auto ptr = reinterpret_cast<const ShapeOptionsT*>(value);
        return CreateShapeOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_PowOptions:
    {
        auto ptr = reinterpret_cast<const PowOptionsT*>(value);
        return CreatePowOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_ArgMinOptions:
    {
        auto ptr = reinterpret_cast<const ArgMinOptionsT*>(value);
        return CreateArgMinOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_FakeQuantOptions:
    {
        auto ptr = reinterpret_cast<const FakeQuantOptionsT*>(value);
        return CreateFakeQuantOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_PackOptions:
    {
        auto ptr = reinterpret_cast<const PackOptionsT*>(value);
        return CreatePackOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_LogicalOrOptions:
    {
        auto ptr = reinterpret_cast<const LogicalOrOptionsT*>(value);
        return CreateLogicalOrOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_OneHotOptions:
    {
        auto ptr = reinterpret_cast<const OneHotOptionsT*>(value);
        return CreateOneHotOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_LogicalAndOptions:
    {
        auto ptr = reinterpret_cast<const LogicalAndOptionsT*>(value);
        return CreateLogicalAndOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_LogicalNotOptions:
    {
        auto ptr = reinterpret_cast<const LogicalNotOptionsT*>(value);
        return CreateLogicalNotOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_UnpackOptions:
    {
        auto ptr = reinterpret_cast<const UnpackOptionsT*>(value);
        return CreateUnpackOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_FloorDivOptions:
    {
        auto ptr = reinterpret_cast<const FloorDivOptionsT*>(value);
        return CreateFloorDivOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_SquareOptions:
    {
        auto ptr = reinterpret_cast<const SquareOptionsT*>(value);
        return CreateSquareOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_ZerosLikeOptions:
    {
        auto ptr = reinterpret_cast<const ZerosLikeOptionsT*>(value);
        return CreateZerosLikeOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_FillOptions:
    {
        auto ptr = reinterpret_cast<const FillOptionsT*>(value);
        return CreateFillOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_BidirectionalSequenceLSTMOptions:
    {
        auto ptr = reinterpret_cast<const BidirectionalSequenceLSTMOptionsT*>(value);
        return CreateBidirectionalSequenceLSTMOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_BidirectionalSequenceRNNOptions:
    {
        auto ptr = reinterpret_cast<const BidirectionalSequenceRNNOptionsT*>(value);
        return CreateBidirectionalSequenceRNNOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_UnidirectionalSequenceLSTMOptions:
    {
        auto ptr = reinterpret_cast<const UnidirectionalSequenceLSTMOptionsT*>(value);
        return CreateUnidirectionalSequenceLSTMOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_FloorModOptions:
    {
        auto ptr = reinterpret_cast<const FloorModOptionsT*>(value);
        return CreateFloorModOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_RangeOptions:
    {
        auto ptr = reinterpret_cast<const RangeOptionsT*>(value);
        return CreateRangeOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_ResizeNearestNeighborOptions:
    {
        auto ptr = reinterpret_cast<const ResizeNearestNeighborOptionsT*>(value);
        return CreateResizeNearestNeighborOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_LeakyReluOptions:
    {
        auto ptr = reinterpret_cast<const LeakyReluOptionsT*>(value);
        return CreateLeakyReluOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_SquaredDifferenceOptions:
    {
        auto ptr = reinterpret_cast<const SquaredDifferenceOptionsT*>(value);
        return CreateSquaredDifferenceOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_MirrorPadOptions:
    {
        auto ptr = reinterpret_cast<const MirrorPadOptionsT*>(value);
        return CreateMirrorPadOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_AbsOptions:
    {
        auto ptr = reinterpret_cast<const AbsOptionsT*>(value);
        return CreateAbsOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_SplitVOptions:
    {
        auto ptr = reinterpret_cast<const SplitVOptionsT*>(value);
        return CreateSplitVOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_UniqueOptions:
    {
        auto ptr = reinterpret_cast<const UniqueOptionsT*>(value);
        return CreateUniqueOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_ReverseV2Options:
    {
        auto ptr = reinterpret_cast<const ReverseV2OptionsT*>(value);
        return CreateReverseV2Options(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_AddNOptions:
    {
        auto ptr = reinterpret_cast<const AddNOptionsT*>(value);
        return CreateAddNOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_GatherNdOptions:
    {
        auto ptr = reinterpret_cast<const GatherNdOptionsT*>(value);
        return CreateGatherNdOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_CosOptions:
    {
        auto ptr = reinterpret_cast<const CosOptionsT*>(value);
        return CreateCosOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_WhereOptions:
    {
        auto ptr = reinterpret_cast<const WhereOptionsT*>(value);
        return CreateWhereOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_RankOptions:
    {
        auto ptr = reinterpret_cast<const RankOptionsT*>(value);
        return CreateRankOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_ReverseSequenceOptions:
    {
        auto ptr = reinterpret_cast<const ReverseSequenceOptionsT*>(value);
        return CreateReverseSequenceOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_MatrixDiagOptions:
    {
        auto ptr = reinterpret_cast<const MatrixDiagOptionsT*>(value);
        return CreateMatrixDiagOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_QuantizeOptions:
    {
        auto ptr = reinterpret_cast<const QuantizeOptionsT*>(value);
        return CreateQuantizeOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_MatrixSetDiagOptions:
    {
        auto ptr = reinterpret_cast<const MatrixSetDiagOptionsT*>(value);
        return CreateMatrixSetDiagOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_HardSwishOptions:
    {
        auto ptr = reinterpret_cast<const HardSwishOptionsT*>(value);
        return CreateHardSwishOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_IfOptions:
    {
        auto ptr = reinterpret_cast<const IfOptionsT*>(value);
        return CreateIfOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_WhileOptions:
    {
        auto ptr = reinterpret_cast<const WhileOptionsT*>(value);
        return CreateWhileOptions(_fbb, ptr, _rehasher).Union();
    }
    default: return 0;
    }
}

inline BuiltinOptionsUnion::BuiltinOptionsUnion(const BuiltinOptionsUnion& u) FLATBUFFERS_NOEXCEPT : type(u.type), value(nullptr)
{
    switch (type)
    {
    case BuiltinOptions_Conv2DOptions:
    {
        value = new Conv2DOptionsT(*reinterpret_cast<Conv2DOptionsT*>(u.value));
        break;
    }
    case BuiltinOptions_DepthwiseConv2DOptions:
    {
        value = new DepthwiseConv2DOptionsT(*reinterpret_cast<DepthwiseConv2DOptionsT*>(u.value));
        break;
    }
    case BuiltinOptions_ConcatEmbeddingsOptions:
    {
        value = new ConcatEmbeddingsOptionsT(*reinterpret_cast<ConcatEmbeddingsOptionsT*>(u.value));
        break;
    }
    case BuiltinOptions_LSHProjectionOptions:
    {
        value = new LSHProjectionOptionsT(*reinterpret_cast<LSHProjectionOptionsT*>(u.value));
        break;
    }
    case BuiltinOptions_Pool2DOptions:
    {
        value = new Pool2DOptionsT(*reinterpret_cast<Pool2DOptionsT*>(u.value));
        break;
    }
    case BuiltinOptions_SVDFOptions:
    {
        value = new SVDFOptionsT(*reinterpret_cast<SVDFOptionsT*>(u.value));
        break;
    }
    case BuiltinOptions_RNNOptions:
    {
        value = new RNNOptionsT(*reinterpret_cast<RNNOptionsT*>(u.value));
        break;
    }
    case BuiltinOptions_FullyConnectedOptions:
    {
        value = new FullyConnectedOptionsT(*reinterpret_cast<FullyConnectedOptionsT*>(u.value));
        break;
    }
    case BuiltinOptions_SoftmaxOptions:
    {
        value = new SoftmaxOptionsT(*reinterpret_cast<SoftmaxOptionsT*>(u.value));
        break;
    }
    case BuiltinOptions_ConcatenationOptions:
    {
        value = new ConcatenationOptionsT(*reinterpret_cast<ConcatenationOptionsT*>(u.value));
        break;
    }
    case BuiltinOptions_AddOptions:
    {
        value = new AddOptionsT(*reinterpret_cast<AddOptionsT*>(u.value));
        break;
    }
    case BuiltinOptions_L2NormOptions:
    {
        value = new L2NormOptionsT(*reinterpret_cast<L2NormOptionsT*>(u.value));
        break;
    }
    case BuiltinOptions_LocalResponseNormalizationOptions:
    {
        value = new LocalResponseNormalizationOptionsT(*reinterpret_cast<LocalResponseNormalizationOptionsT*>(u.value));
        break;
    }
    case BuiltinOptions_LSTMOptions:
    {
        value = new LSTMOptionsT(*reinterpret_cast<LSTMOptionsT*>(u.value));
        break;
    }
    case BuiltinOptions_ResizeBilinearOptions:
    {
        value = new ResizeBilinearOptionsT(*reinterpret_cast<ResizeBilinearOptionsT*>(u.value));
        break;
    }
    case BuiltinOptions_CallOptions:
    {
        value = new CallOptionsT(*reinterpret_cast<CallOptionsT*>(u.value));
        break;
    }
    case BuiltinOptions_ReshapeOptions:
    {
        value = new ReshapeOptionsT(*reinterpret_cast<ReshapeOptionsT*>(u.value));
        break;
    }
    case BuiltinOptions_SkipGramOptions:
    {
        value = new SkipGramOptionsT(*reinterpret_cast<SkipGramOptionsT*>(u.value));
        break;
    }
    case BuiltinOptions_SpaceToDepthOptions:
    {
        value = new SpaceToDepthOptionsT(*reinterpret_cast<SpaceToDepthOptionsT*>(u.value));
        break;
    }
    case BuiltinOptions_EmbeddingLookupSparseOptions:
    {
        value = new EmbeddingLookupSparseOptionsT(*reinterpret_cast<EmbeddingLookupSparseOptionsT*>(u.value));
        break;
    }
    case BuiltinOptions_MulOptions:
    {
        value = new MulOptionsT(*reinterpret_cast<MulOptionsT*>(u.value));
        break;
    }
    case BuiltinOptions_PadOptions:
    {
        value = new PadOptionsT(*reinterpret_cast<PadOptionsT*>(u.value));
        break;
    }
    case BuiltinOptions_GatherOptions:
    {
        value = new GatherOptionsT(*reinterpret_cast<GatherOptionsT*>(u.value));
        break;
    }
    case BuiltinOptions_BatchToSpaceNDOptions:
    {
        value = new BatchToSpaceNDOptionsT(*reinterpret_cast<BatchToSpaceNDOptionsT*>(u.value));
        break;
    }
    case BuiltinOptions_SpaceToBatchNDOptions:
    {
        value = new SpaceToBatchNDOptionsT(*reinterpret_cast<SpaceToBatchNDOptionsT*>(u.value));
        break;
    }
    case BuiltinOptions_TransposeOptions:
    {
        value = new TransposeOptionsT(*reinterpret_cast<TransposeOptionsT*>(u.value));
        break;
    }
    case BuiltinOptions_ReducerOptions:
    {
        value = new ReducerOptionsT(*reinterpret_cast<ReducerOptionsT*>(u.value));
        break;
    }
    case BuiltinOptions_SubOptions:
    {
        value = new SubOptionsT(*reinterpret_cast<SubOptionsT*>(u.value));
        break;
    }
    case BuiltinOptions_DivOptions:
    {
        value = new DivOptionsT(*reinterpret_cast<DivOptionsT*>(u.value));
        break;
    }
    case BuiltinOptions_SqueezeOptions:
    {
        value = new SqueezeOptionsT(*reinterpret_cast<SqueezeOptionsT*>(u.value));
        break;
    }
    case BuiltinOptions_SequenceRNNOptions:
    {
        value = new SequenceRNNOptionsT(*reinterpret_cast<SequenceRNNOptionsT*>(u.value));
        break;
    }
    case BuiltinOptions_StridedSliceOptions:
    {
        value = new StridedSliceOptionsT(*reinterpret_cast<StridedSliceOptionsT*>(u.value));
        break;
    }
    case BuiltinOptions_ExpOptions:
    {
        value = new ExpOptionsT(*reinterpret_cast<ExpOptionsT*>(u.value));
        break;
    }
    case BuiltinOptions_TopKV2Options:
    {
        value = new TopKV2OptionsT(*reinterpret_cast<TopKV2OptionsT*>(u.value));
        break;
    }
    case BuiltinOptions_SplitOptions:
    {
        value = new SplitOptionsT(*reinterpret_cast<SplitOptionsT*>(u.value));
        break;
    }
    case BuiltinOptions_LogSoftmaxOptions:
    {
        value = new LogSoftmaxOptionsT(*reinterpret_cast<LogSoftmaxOptionsT*>(u.value));
        break;
    }
    case BuiltinOptions_CastOptions:
    {
        value = new CastOptionsT(*reinterpret_cast<CastOptionsT*>(u.value));
        break;
    }
    case BuiltinOptions_DequantizeOptions:
    {
        value = new DequantizeOptionsT(*reinterpret_cast<DequantizeOptionsT*>(u.value));
        break;
    }
    case BuiltinOptions_MaximumMinimumOptions:
    {
        value = new MaximumMinimumOptionsT(*reinterpret_cast<MaximumMinimumOptionsT*>(u.value));
        break;
    }
    case BuiltinOptions_ArgMaxOptions:
    {
        value = new ArgMaxOptionsT(*reinterpret_cast<ArgMaxOptionsT*>(u.value));
        break;
    }
    case BuiltinOptions_LessOptions:
    {
        value = new LessOptionsT(*reinterpret_cast<LessOptionsT*>(u.value));
        break;
    }
    case BuiltinOptions_NegOptions:
    {
        value = new NegOptionsT(*reinterpret_cast<NegOptionsT*>(u.value));
        break;
    }
    case BuiltinOptions_PadV2Options:
    {
        value = new PadV2OptionsT(*reinterpret_cast<PadV2OptionsT*>(u.value));
        break;
    }
    case BuiltinOptions_GreaterOptions:
    {
        value = new GreaterOptionsT(*reinterpret_cast<GreaterOptionsT*>(u.value));
        break;
    }
    case BuiltinOptions_GreaterEqualOptions:
    {
        value = new GreaterEqualOptionsT(*reinterpret_cast<GreaterEqualOptionsT*>(u.value));
        break;
    }
    case BuiltinOptions_LessEqualOptions:
    {
        value = new LessEqualOptionsT(*reinterpret_cast<LessEqualOptionsT*>(u.value));
        break;
    }
    case BuiltinOptions_SelectOptions:
    {
        value = new SelectOptionsT(*reinterpret_cast<SelectOptionsT*>(u.value));
        break;
    }
    case BuiltinOptions_SliceOptions:
    {
        value = new SliceOptionsT(*reinterpret_cast<SliceOptionsT*>(u.value));
        break;
    }
    case BuiltinOptions_TransposeConvOptions:
    {
        value = new TransposeConvOptionsT(*reinterpret_cast<TransposeConvOptionsT*>(u.value));
        break;
    }
    case BuiltinOptions_SparseToDenseOptions:
    {
        value = new SparseToDenseOptionsT(*reinterpret_cast<SparseToDenseOptionsT*>(u.value));
        break;
    }
    case BuiltinOptions_TileOptions:
    {
        value = new TileOptionsT(*reinterpret_cast<TileOptionsT*>(u.value));
        break;
    }
    case BuiltinOptions_ExpandDimsOptions:
    {
        value = new ExpandDimsOptionsT(*reinterpret_cast<ExpandDimsOptionsT*>(u.value));
        break;
    }
    case BuiltinOptions_EqualOptions:
    {
        value = new EqualOptionsT(*reinterpret_cast<EqualOptionsT*>(u.value));
        break;
    }
    case BuiltinOptions_NotEqualOptions:
    {
        value = new NotEqualOptionsT(*reinterpret_cast<NotEqualOptionsT*>(u.value));
        break;
    }
    case BuiltinOptions_ShapeOptions:
    {
        value = new ShapeOptionsT(*reinterpret_cast<ShapeOptionsT*>(u.value));
        break;
    }
    case BuiltinOptions_PowOptions:
    {
        value = new PowOptionsT(*reinterpret_cast<PowOptionsT*>(u.value));
        break;
    }
    case BuiltinOptions_ArgMinOptions:
    {
        value = new ArgMinOptionsT(*reinterpret_cast<ArgMinOptionsT*>(u.value));
        break;
    }
    case BuiltinOptions_FakeQuantOptions:
    {
        value = new FakeQuantOptionsT(*reinterpret_cast<FakeQuantOptionsT*>(u.value));
        break;
    }
    case BuiltinOptions_PackOptions:
    {
        value = new PackOptionsT(*reinterpret_cast<PackOptionsT*>(u.value));
        break;
    }
    case BuiltinOptions_LogicalOrOptions:
    {
        value = new LogicalOrOptionsT(*reinterpret_cast<LogicalOrOptionsT*>(u.value));
        break;
    }
    case BuiltinOptions_OneHotOptions:
    {
        value = new OneHotOptionsT(*reinterpret_cast<OneHotOptionsT*>(u.value));
        break;
    }
    case BuiltinOptions_LogicalAndOptions:
    {
        value = new LogicalAndOptionsT(*reinterpret_cast<LogicalAndOptionsT*>(u.value));
        break;
    }
    case BuiltinOptions_LogicalNotOptions:
    {
        value = new LogicalNotOptionsT(*reinterpret_cast<LogicalNotOptionsT*>(u.value));
        break;
    }
    case BuiltinOptions_UnpackOptions:
    {
        value = new UnpackOptionsT(*reinterpret_cast<UnpackOptionsT*>(u.value));
        break;
    }
    case BuiltinOptions_FloorDivOptions:
    {
        value = new FloorDivOptionsT(*reinterpret_cast<FloorDivOptionsT*>(u.value));
        break;
    }
    case BuiltinOptions_SquareOptions:
    {
        value = new SquareOptionsT(*reinterpret_cast<SquareOptionsT*>(u.value));
        break;
    }
    case BuiltinOptions_ZerosLikeOptions:
    {
        value = new ZerosLikeOptionsT(*reinterpret_cast<ZerosLikeOptionsT*>(u.value));
        break;
    }
    case BuiltinOptions_FillOptions:
    {
        value = new FillOptionsT(*reinterpret_cast<FillOptionsT*>(u.value));
        break;
    }
    case BuiltinOptions_BidirectionalSequenceLSTMOptions:
    {
        value = new BidirectionalSequenceLSTMOptionsT(*reinterpret_cast<BidirectionalSequenceLSTMOptionsT*>(u.value));
        break;
    }
    case BuiltinOptions_BidirectionalSequenceRNNOptions:
    {
        value = new BidirectionalSequenceRNNOptionsT(*reinterpret_cast<BidirectionalSequenceRNNOptionsT*>(u.value));
        break;
    }
    case BuiltinOptions_UnidirectionalSequenceLSTMOptions:
    {
        value = new UnidirectionalSequenceLSTMOptionsT(*reinterpret_cast<UnidirectionalSequenceLSTMOptionsT*>(u.value));
        break;
    }
    case BuiltinOptions_FloorModOptions:
    {
        value = new FloorModOptionsT(*reinterpret_cast<FloorModOptionsT*>(u.value));
        break;
    }
    case BuiltinOptions_RangeOptions:
    {
        value = new RangeOptionsT(*reinterpret_cast<RangeOptionsT*>(u.value));
        break;
    }
    case BuiltinOptions_ResizeNearestNeighborOptions:
    {
        value = new ResizeNearestNeighborOptionsT(*reinterpret_cast<ResizeNearestNeighborOptionsT*>(u.value));
        break;
    }
    case BuiltinOptions_LeakyReluOptions:
    {
        value = new LeakyReluOptionsT(*reinterpret_cast<LeakyReluOptionsT*>(u.value));
        break;
    }
    case BuiltinOptions_SquaredDifferenceOptions:
    {
        value = new SquaredDifferenceOptionsT(*reinterpret_cast<SquaredDifferenceOptionsT*>(u.value));
        break;
    }
    case BuiltinOptions_MirrorPadOptions:
    {
        value = new MirrorPadOptionsT(*reinterpret_cast<MirrorPadOptionsT*>(u.value));
        break;
    }
    case BuiltinOptions_AbsOptions:
    {
        value = new AbsOptionsT(*reinterpret_cast<AbsOptionsT*>(u.value));
        break;
    }
    case BuiltinOptions_SplitVOptions:
    {
        value = new SplitVOptionsT(*reinterpret_cast<SplitVOptionsT*>(u.value));
        break;
    }
    case BuiltinOptions_UniqueOptions:
    {
        value = new UniqueOptionsT(*reinterpret_cast<UniqueOptionsT*>(u.value));
        break;
    }
    case BuiltinOptions_ReverseV2Options:
    {
        value = new ReverseV2OptionsT(*reinterpret_cast<ReverseV2OptionsT*>(u.value));
        break;
    }
    case BuiltinOptions_AddNOptions:
    {
        value = new AddNOptionsT(*reinterpret_cast<AddNOptionsT*>(u.value));
        break;
    }
    case BuiltinOptions_GatherNdOptions:
    {
        value = new GatherNdOptionsT(*reinterpret_cast<GatherNdOptionsT*>(u.value));
        break;
    }
    case BuiltinOptions_CosOptions:
    {
        value = new CosOptionsT(*reinterpret_cast<CosOptionsT*>(u.value));
        break;
    }
    case BuiltinOptions_WhereOptions:
    {
        value = new WhereOptionsT(*reinterpret_cast<WhereOptionsT*>(u.value));
        break;
    }
    case BuiltinOptions_RankOptions:
    {
        value = new RankOptionsT(*reinterpret_cast<RankOptionsT*>(u.value));
        break;
    }
    case BuiltinOptions_ReverseSequenceOptions:
    {
        value = new ReverseSequenceOptionsT(*reinterpret_cast<ReverseSequenceOptionsT*>(u.value));
        break;
    }
    case BuiltinOptions_MatrixDiagOptions:
    {
        value = new MatrixDiagOptionsT(*reinterpret_cast<MatrixDiagOptionsT*>(u.value));
        break;
    }
    case BuiltinOptions_QuantizeOptions:
    {
        value = new QuantizeOptionsT(*reinterpret_cast<QuantizeOptionsT*>(u.value));
        break;
    }
    case BuiltinOptions_MatrixSetDiagOptions:
    {
        value = new MatrixSetDiagOptionsT(*reinterpret_cast<MatrixSetDiagOptionsT*>(u.value));
        break;
    }
    case BuiltinOptions_HardSwishOptions:
    {
        value = new HardSwishOptionsT(*reinterpret_cast<HardSwishOptionsT*>(u.value));
        break;
    }
    case BuiltinOptions_IfOptions:
    {
        value = new IfOptionsT(*reinterpret_cast<IfOptionsT*>(u.value));
        break;
    }
    case BuiltinOptions_WhileOptions:
    {
        value = new WhileOptionsT(*reinterpret_cast<WhileOptionsT*>(u.value));
        break;
    }
    default:
        break;
    }
}

inline void BuiltinOptionsUnion::Reset()
{
    switch (type)
    {
    case BuiltinOptions_Conv2DOptions:
    {
        auto ptr = reinterpret_cast<Conv2DOptionsT*>(value);
        delete ptr;
        break;
    }
    case BuiltinOptions_DepthwiseConv2DOptions:
    {
        auto ptr = reinterpret_cast<DepthwiseConv2DOptionsT*>(value);
        delete ptr;
        break;
    }
    case BuiltinOptions_ConcatEmbeddingsOptions:
    {
        auto ptr = reinterpret_cast<ConcatEmbeddingsOptionsT*>(value);
        delete ptr;
        break;
    }
    case BuiltinOptions_LSHProjectionOptions:
    {
        auto ptr = reinterpret_cast<LSHProjectionOptionsT*>(value);
        delete ptr;
        break;
    }
    case BuiltinOptions_Pool2DOptions:
    {
        auto ptr = reinterpret_cast<Pool2DOptionsT*>(value);
        delete ptr;
        break;
    }
    case BuiltinOptions_SVDFOptions:
    {
        auto ptr = reinterpret_cast<SVDFOptionsT*>(value);
        delete ptr;
        break;
    }
    case BuiltinOptions_RNNOptions:
    {
        auto ptr = reinterpret_cast<RNNOptionsT*>(value);
        delete ptr;
        break;
    }
    case BuiltinOptions_FullyConnectedOptions:
    {
        auto ptr = reinterpret_cast<FullyConnectedOptionsT*>(value);
        delete ptr;
        break;
    }
    case BuiltinOptions_SoftmaxOptions:
    {
        auto ptr = reinterpret_cast<SoftmaxOptionsT*>(value);
        delete ptr;
        break;
    }
    case BuiltinOptions_ConcatenationOptions:
    {
        auto ptr = reinterpret_cast<ConcatenationOptionsT*>(value);
        delete ptr;
        break;
    }
    case BuiltinOptions_AddOptions:
    {
        auto ptr = reinterpret_cast<AddOptionsT*>(value);
        delete ptr;
        break;
    }
    case BuiltinOptions_L2NormOptions:
    {
        auto ptr = reinterpret_cast<L2NormOptionsT*>(value);
        delete ptr;
        break;
    }
    case BuiltinOptions_LocalResponseNormalizationOptions:
    {
        auto ptr = reinterpret_cast<LocalResponseNormalizationOptionsT*>(value);
        delete ptr;
        break;
    }
    case BuiltinOptions_LSTMOptions:
    {
        auto ptr = reinterpret_cast<LSTMOptionsT*>(value);
        delete ptr;
        break;
    }
    case BuiltinOptions_ResizeBilinearOptions:
    {
        auto ptr = reinterpret_cast<ResizeBilinearOptionsT*>(value);
        delete ptr;
        break;
    }
    case BuiltinOptions_CallOptions:
    {
        auto ptr = reinterpret_cast<CallOptionsT*>(value);
        delete ptr;
        break;
    }
    case BuiltinOptions_ReshapeOptions:
    {
        auto ptr = reinterpret_cast<ReshapeOptionsT*>(value);
        delete ptr;
        break;
    }
    case BuiltinOptions_SkipGramOptions:
    {
        auto ptr = reinterpret_cast<SkipGramOptionsT*>(value);
        delete ptr;
        break;
    }
    case BuiltinOptions_SpaceToDepthOptions:
    {
        auto ptr = reinterpret_cast<SpaceToDepthOptionsT*>(value);
        delete ptr;
        break;
    }
    case BuiltinOptions_EmbeddingLookupSparseOptions:
    {
        auto ptr = reinterpret_cast<EmbeddingLookupSparseOptionsT*>(value);
        delete ptr;
        break;
    }
    case BuiltinOptions_MulOptions:
    {
        auto ptr = reinterpret_cast<MulOptionsT*>(value);
        delete ptr;
        break;
    }
    case BuiltinOptions_PadOptions:
    {
        auto ptr = reinterpret_cast<PadOptionsT*>(value);
        delete ptr;
        break;
    }
    case BuiltinOptions_GatherOptions:
    {
        auto ptr = reinterpret_cast<GatherOptionsT*>(value);
        delete ptr;
        break;
    }
    case BuiltinOptions_BatchToSpaceNDOptions:
    {
        auto ptr = reinterpret_cast<BatchToSpaceNDOptionsT*>(value);
        delete ptr;
        break;
    }
    case BuiltinOptions_SpaceToBatchNDOptions:
    {
        auto ptr = reinterpret_cast<SpaceToBatchNDOptionsT*>(value);
        delete ptr;
        break;
    }
    case BuiltinOptions_TransposeOptions:
    {
        auto ptr = reinterpret_cast<TransposeOptionsT*>(value);
        delete ptr;
        break;
    }
    case BuiltinOptions_ReducerOptions:
    {
        auto ptr = reinterpret_cast<ReducerOptionsT*>(value);
        delete ptr;
        break;
    }
    case BuiltinOptions_SubOptions:
    {
        auto ptr = reinterpret_cast<SubOptionsT*>(value);
        delete ptr;
        break;
    }
    case BuiltinOptions_DivOptions:
    {
        auto ptr = reinterpret_cast<DivOptionsT*>(value);
        delete ptr;
        break;
    }
    case BuiltinOptions_SqueezeOptions:
    {
        auto ptr = reinterpret_cast<SqueezeOptionsT*>(value);
        delete ptr;
        break;
    }
    case BuiltinOptions_SequenceRNNOptions:
    {
        auto ptr = reinterpret_cast<SequenceRNNOptionsT*>(value);
        delete ptr;
        break;
    }
    case BuiltinOptions_StridedSliceOptions:
    {
        auto ptr = reinterpret_cast<StridedSliceOptionsT*>(value);
        delete ptr;
        break;
    }
    case BuiltinOptions_ExpOptions:
    {
        auto ptr = reinterpret_cast<ExpOptionsT*>(value);
        delete ptr;
        break;
    }
    case BuiltinOptions_TopKV2Options:
    {
        auto ptr = reinterpret_cast<TopKV2OptionsT*>(value);
        delete ptr;
        break;
    }
    case BuiltinOptions_SplitOptions:
    {
        auto ptr = reinterpret_cast<SplitOptionsT*>(value);
        delete ptr;
        break;
    }
    case BuiltinOptions_LogSoftmaxOptions:
    {
        auto ptr = reinterpret_cast<LogSoftmaxOptionsT*>(value);
        delete ptr;
        break;
    }
    case BuiltinOptions_CastOptions:
    {
        auto ptr = reinterpret_cast<CastOptionsT*>(value);
        delete ptr;
        break;
    }
    case BuiltinOptions_DequantizeOptions:
    {
        auto ptr = reinterpret_cast<DequantizeOptionsT*>(value);
        delete ptr;
        break;
    }
    case BuiltinOptions_MaximumMinimumOptions:
    {
        auto ptr = reinterpret_cast<MaximumMinimumOptionsT*>(value);
        delete ptr;
        break;
    }
    case BuiltinOptions_ArgMaxOptions:
    {
        auto ptr = reinterpret_cast<ArgMaxOptionsT*>(value);
        delete ptr;
        break;
    }
    case BuiltinOptions_LessOptions:
    {
        auto ptr = reinterpret_cast<LessOptionsT*>(value);
        delete ptr;
        break;
    }
    case BuiltinOptions_NegOptions:
    {
        auto ptr = reinterpret_cast<NegOptionsT*>(value);
        delete ptr;
        break;
    }
    case BuiltinOptions_PadV2Options:
    {
        auto ptr = reinterpret_cast<PadV2OptionsT*>(value);
        delete ptr;
        break;
    }
    case BuiltinOptions_GreaterOptions:
    {
        auto ptr = reinterpret_cast<GreaterOptionsT*>(value);
        delete ptr;
        break;
    }
    case BuiltinOptions_GreaterEqualOptions:
    {
        auto ptr = reinterpret_cast<GreaterEqualOptionsT*>(value);
        delete ptr;
        break;
    }
    case BuiltinOptions_LessEqualOptions:
    {
        auto ptr = reinterpret_cast<LessEqualOptionsT*>(value);
        delete ptr;
        break;
    }
    case BuiltinOptions_SelectOptions:
    {
        auto ptr = reinterpret_cast<SelectOptionsT*>(value);
        delete ptr;
        break;
    }
    case BuiltinOptions_SliceOptions:
    {
        auto ptr = reinterpret_cast<SliceOptionsT*>(value);
        delete ptr;
        break;
    }
    case BuiltinOptions_TransposeConvOptions:
    {
        auto ptr = reinterpret_cast<TransposeConvOptionsT*>(value);
        delete ptr;
        break;
    }
    case BuiltinOptions_SparseToDenseOptions:
    {
        auto ptr = reinterpret_cast<SparseToDenseOptionsT*>(value);
        delete ptr;
        break;
    }
    case BuiltinOptions_TileOptions:
    {
        auto ptr = reinterpret_cast<TileOptionsT*>(value);
        delete ptr;
        break;
    }
    case BuiltinOptions_ExpandDimsOptions:
    {
        auto ptr = reinterpret_cast<ExpandDimsOptionsT*>(value);
        delete ptr;
        break;
    }
    case BuiltinOptions_EqualOptions:
    {
        auto ptr = reinterpret_cast<EqualOptionsT*>(value);
        delete ptr;
        break;
    }
    case BuiltinOptions_NotEqualOptions:
    {
        auto ptr = reinterpret_cast<NotEqualOptionsT*>(value);
        delete ptr;
        break;
    }
    case BuiltinOptions_ShapeOptions:
    {
        auto ptr = reinterpret_cast<ShapeOptionsT*>(value);
        delete ptr;
        break;
    }
    case BuiltinOptions_PowOptions:
    {
        auto ptr = reinterpret_cast<PowOptionsT*>(value);
        delete ptr;
        break;
    }
    case BuiltinOptions_ArgMinOptions:
    {
        auto ptr = reinterpret_cast<ArgMinOptionsT*>(value);
        delete ptr;
        break;
    }
    case BuiltinOptions_FakeQuantOptions:
    {
        auto ptr = reinterpret_cast<FakeQuantOptionsT*>(value);
        delete ptr;
        break;
    }
    case BuiltinOptions_PackOptions:
    {
        auto ptr = reinterpret_cast<PackOptionsT*>(value);
        delete ptr;
        break;
    }
    case BuiltinOptions_LogicalOrOptions:
    {
        auto ptr = reinterpret_cast<LogicalOrOptionsT*>(value);
        delete ptr;
        break;
    }
    case BuiltinOptions_OneHotOptions:
    {
        auto ptr = reinterpret_cast<OneHotOptionsT*>(value);
        delete ptr;
        break;
    }
    case BuiltinOptions_LogicalAndOptions:
    {
        auto ptr = reinterpret_cast<LogicalAndOptionsT*>(value);
        delete ptr;
        break;
    }
    case BuiltinOptions_LogicalNotOptions:
    {
        auto ptr = reinterpret_cast<LogicalNotOptionsT*>(value);
        delete ptr;
        break;
    }
    case BuiltinOptions_UnpackOptions:
    {
        auto ptr = reinterpret_cast<UnpackOptionsT*>(value);
        delete ptr;
        break;
    }
    case BuiltinOptions_FloorDivOptions:
    {
        auto ptr = reinterpret_cast<FloorDivOptionsT*>(value);
        delete ptr;
        break;
    }
    case BuiltinOptions_SquareOptions:
    {
        auto ptr = reinterpret_cast<SquareOptionsT*>(value);
        delete ptr;
        break;
    }
    case BuiltinOptions_ZerosLikeOptions:
    {
        auto ptr = reinterpret_cast<ZerosLikeOptionsT*>(value);
        delete ptr;
        break;
    }
    case BuiltinOptions_FillOptions:
    {
        auto ptr = reinterpret_cast<FillOptionsT*>(value);
        delete ptr;
        break;
    }
    case BuiltinOptions_BidirectionalSequenceLSTMOptions:
    {
        auto ptr = reinterpret_cast<BidirectionalSequenceLSTMOptionsT*>(value);
        delete ptr;
        break;
    }
    case BuiltinOptions_BidirectionalSequenceRNNOptions:
    {
        auto ptr = reinterpret_cast<BidirectionalSequenceRNNOptionsT*>(value);
        delete ptr;
        break;
    }
    case BuiltinOptions_UnidirectionalSequenceLSTMOptions:
    {
        auto ptr = reinterpret_cast<UnidirectionalSequenceLSTMOptionsT*>(value);
        delete ptr;
        break;
    }
    case BuiltinOptions_FloorModOptions:
    {
        auto ptr = reinterpret_cast<FloorModOptionsT*>(value);
        delete ptr;
        break;
    }
    case BuiltinOptions_RangeOptions:
    {
        auto ptr = reinterpret_cast<RangeOptionsT*>(value);
        delete ptr;
        break;
    }
    case BuiltinOptions_ResizeNearestNeighborOptions:
    {
        auto ptr = reinterpret_cast<ResizeNearestNeighborOptionsT*>(value);
        delete ptr;
        break;
    }
    case BuiltinOptions_LeakyReluOptions:
    {
        auto ptr = reinterpret_cast<LeakyReluOptionsT*>(value);
        delete ptr;
        break;
    }
    case BuiltinOptions_SquaredDifferenceOptions:
    {
        auto ptr = reinterpret_cast<SquaredDifferenceOptionsT*>(value);
        delete ptr;
        break;
    }
    case BuiltinOptions_MirrorPadOptions:
    {
        auto ptr = reinterpret_cast<MirrorPadOptionsT*>(value);
        delete ptr;
        break;
    }
    case BuiltinOptions_AbsOptions:
    {
        auto ptr = reinterpret_cast<AbsOptionsT*>(value);
        delete ptr;
        break;
    }
    case BuiltinOptions_SplitVOptions:
    {
        auto ptr = reinterpret_cast<SplitVOptionsT*>(value);
        delete ptr;
        break;
    }
    case BuiltinOptions_UniqueOptions:
    {
        auto ptr = reinterpret_cast<UniqueOptionsT*>(value);
        delete ptr;
        break;
    }
    case BuiltinOptions_ReverseV2Options:
    {
        auto ptr = reinterpret_cast<ReverseV2OptionsT*>(value);
        delete ptr;
        break;
    }
    case BuiltinOptions_AddNOptions:
    {
        auto ptr = reinterpret_cast<AddNOptionsT*>(value);
        delete ptr;
        break;
    }
    case BuiltinOptions_GatherNdOptions:
    {
        auto ptr = reinterpret_cast<GatherNdOptionsT*>(value);
        delete ptr;
        break;
    }
    case BuiltinOptions_CosOptions:
    {
        auto ptr = reinterpret_cast<CosOptionsT*>(value);
        delete ptr;
        break;
    }
    case BuiltinOptions_WhereOptions:
    {
        auto ptr = reinterpret_cast<WhereOptionsT*>(value);
        delete ptr;
        break;
    }
    case BuiltinOptions_RankOptions:
    {
        auto ptr = reinterpret_cast<RankOptionsT*>(value);
        delete ptr;
        break;
    }
    case BuiltinOptions_ReverseSequenceOptions:
    {
        auto ptr = reinterpret_cast<ReverseSequenceOptionsT*>(value);
        delete ptr;
        break;
    }
    case BuiltinOptions_MatrixDiagOptions:
    {
        auto ptr = reinterpret_cast<MatrixDiagOptionsT*>(value);
        delete ptr;
        break;
    }
    case BuiltinOptions_QuantizeOptions:
    {
        auto ptr = reinterpret_cast<QuantizeOptionsT*>(value);
        delete ptr;
        break;
    }
    case BuiltinOptions_MatrixSetDiagOptions:
    {
        auto ptr = reinterpret_cast<MatrixSetDiagOptionsT*>(value);
        delete ptr;
        break;
    }
    case BuiltinOptions_HardSwishOptions:
    {
        auto ptr = reinterpret_cast<HardSwishOptionsT*>(value);
        delete ptr;
        break;
    }
    case BuiltinOptions_IfOptions:
    {
        auto ptr = reinterpret_cast<IfOptionsT*>(value);
        delete ptr;
        break;
    }
    case BuiltinOptions_WhileOptions:
    {
        auto ptr = reinterpret_cast<WhileOptionsT*>(value);
        delete ptr;
        break;
    }
    default: break;
    }
    value = nullptr;
    type = BuiltinOptions_NONE;
}

inline const tflite::Model* GetModel(const void* buf)
{
    return flatbuffers::GetRoot<tflite::Model>(buf);
}

inline const tflite::Model* GetSizePrefixedModel(const void* buf)
{
    return flatbuffers::GetSizePrefixedRoot<tflite::Model>(buf);
}

inline const char* ModelIdentifier()
{
    return "TFL3";
}

inline bool ModelBufferHasIdentifier(const void* buf)
{
    return flatbuffers::BufferHasIdentifier(
        buf, ModelIdentifier());
}

inline bool VerifyModelBuffer(
    flatbuffers::Verifier& verifier)
{
    return verifier.VerifyBuffer<tflite::Model>(ModelIdentifier());
}

inline bool VerifySizePrefixedModelBuffer(
    flatbuffers::Verifier& verifier)
{
    return verifier.VerifySizePrefixedBuffer<tflite::Model>(ModelIdentifier());
}

inline const char* ModelExtension()
{
    return "tflite";
}

inline void FinishModelBuffer(
    flatbuffers::FlatBufferBuilder& fbb,
    flatbuffers::Offset<tflite::Model> root)
{
    fbb.Finish(root, ModelIdentifier());
}

inline void FinishSizePrefixedModelBuffer(
    flatbuffers::FlatBufferBuilder& fbb,
    flatbuffers::Offset<tflite::Model> root)
{
    fbb.FinishSizePrefixed(root, ModelIdentifier());
}

inline std::unique_ptr<ModelT> UnPackModel(
    const void* buf,
    const flatbuffers::resolver_function_t* res = nullptr)
{
    return std::unique_ptr<ModelT>(GetModel(buf)->UnPack(res));
}

} // namespace tflite

#endif // FLATBUFFERS_GENERATED_SCHEMA_TFLITE_H_
