/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * License); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * AS IS BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/*
 * Copyright (c) 2021, OPEN AI LAB
 * Author: hhchen@openailab.com
 */

#pragma once

// #include <CL/cl.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <iostream>
#include <string>
#include <fstream>

extern "C" {
#include "api/c_api.h"
#include "graph/tensor.h"
#include "graph/node.h"
#include "graph/graph.h"
#include "graph/subgraph.h"
#include "device/device.h"
#include "utility/sys_port.h"
#include "utility/log.h"
}

// bool CHECK_SET_KERNEL_STATUS(cl_int status);
// bool CHECK_ENQUEUE_KERNEL_STATUS(cl_int status);
// bool CHECK_ENQUEUE_BUFFER_STATUS(cl_int status);

/** convert the kernel file into a string */
int convertToString(const char* filename, std::string& s);

/**Getting platforms and choose an available one.*/
// int getPlatform(cl_platform_id &platform);

/**Step 2:Query the platform and choose the first GPU device if has one.*/
// cl_device_id *getCl_device_id(cl_platform_id &platform);

void get_device_message();

void dump_sub_graph(struct subgraph* sub_graph);
