# 技术亮点

**Tengine** 由 **[OPEN AI LAB](http://www.openailab.com)** 主导开发，该项目实现了深度学习神经网络模型在嵌入式设备上的**快速**、**高效**部署需求。为实现在众多 **AIoT** 应用中的跨平台部署，本项目基于原有 Tengine 项目使用 **C 语言**进行重构，针对嵌入式设备资源有限的特点进行了深度框架裁剪。同时采用了完全分离的前后端设计，有利于 CPU、GPU、NPU 等异构计算单元的快速移植和部署，同时降低评估和迁移成本。

## 多硬件支持

Tengine 支持多种硬件后端对神经网络模型进行加速推理，包含 CPU（ARM、X86、MIPS、RISC-V）、GPU（Mail、NV、AMD、Adreno、PowerVR）、NPU（VSI、NNIE、DLA）。

## 高性能

通过提供计算图优化（算子合并、算子移除），实现对原生网络模型结构进行优化，降低计算量。

同时针对不同 CPU 架构，采用精细的手工汇编，实现对计算量要求较高的 Kernel 进行极致优化，充分发挥硬件峰值算力。

## 异构切图

为了支持不同 SoC 上多种计算单元，Tengine 在加载模型后，获取当前指定硬件加速特性，灵活切分原有计算图，实现算力充分利用，同时提高模型支持的泛化性。

## 量化支持

支持主流的两种量化策略（对称分通道量化、非对称分层量化）实现模型低比特压缩、性能加速的目的，同时做到无缝对接主流 NPU 加速引擎。

提供低比特量化精度补偿方案。

## 混合精度

为了充分发挥硬件计算资源，同时保证模型推理精度，支持混合精度计算模式。

## 轻量级部署

最新的 Tengine 核心模块代码采用 C 语言开发，无第三方库依赖，最小可执行静态库大小 < 100KB，甚至可在主流 MCU 上进行模型部署。
