# Face Similarity Matching Using PineCone #

## Project Overview ##
**`Face Similarity Matching Using PineCone`** is a sophisticated image verification system designed to recognize repeat customers efficiently. It leverages advanced machine learning techniques for accurate facial recognition, enhancing both security and customer experience.

## Purpose ##
The project aims to automate the identification of repeat customers using facial recognition, thus offering a more personalized and secure interaction.

## Key Features ##
1. **`Facial Recognition`**: Uses MTCNN for accurate face detection in customer images.
2. **`Vector Embedding`**: Converts facial images into numerical vectors using the DeepFace-FaceNet model.
3. **`Efficient Database Management`**: Employs Pinecone, a vector database, for storing and querying facial embeddings.
4. **`API Functionality`**: Provides a set of APIs for matching images, upserting, deleting, and updating vectors with API key authentication for secure access.


## Technologies ##
1. **MTCNN (Multi-Task Cascaded Convolutional Neural Networks)**
2. **DeepFace-FaceNet Model**
3. **Pinecone Vector Database**
4. **RESTful API services**


## Workflow ##
1. `Initial Setup`:
   * Face detection using MTCNN.
   * Transformation of faces into embeddings with DeepFace-FaceNet.
   * Pinecone database setup and embedding upsertion.

2. `API Usage`:
   * **`ValidateImage API`**: Queries the Pinecone database to find the closest match for a given facial vector.
   * **`AddImageToIndex API`**: Add new facial vectors in the database.
   * **`DeleteImageFromIndex API`**: To remove existing facial vectors from the database.
   * **`ReplaceImage API`**: Updating existing facial vectors in the database.


## Prerequisites ##
1. Python 3.9+
2. Access to customer image data
3. Pinecone API key


## Installation ##
`Install the necessary Python packages:`
```
pip install mtcnn deepface pinecone-client
```

## Configuration ##
Configure the Pinecone API key and database settings.
Set the top_k parameter based on the desired matching precision.

## API Authentication ##
1. Implement API key authentication to validate and secure API usage.
2. Ensure proper management of API keys to prevent unauthorized access.

## Testing API ##
`Run command to test API using Postman`:
```
uvicorn app_fastapi:app --host 127.0.0.1 --port 5000 --reload
```

## Data Privacy ##
Adhere to data privacy laws and ensure secure handling of sensitive customer data, especially facial images.


## Contact ##
For queries or contributions, contact: nitishkundu1993@gmail.com.

Happy Coding! 🚀
