﻿package com {
	
	import flash.display.MovieClip;
	import fl.video.FLVPlayback;
	import fl.video.VideoEvent;
	
	public class TempsEcoule extends MovieClip {
		
		private var util		:VideoUtils 	= new VideoUtils();
		private var ecran		:FLVPlayback;
		
		private var positionTete:Number;
		private var heures		:*;
		private var minutes		:*;
		private var secondes	:*;
		
		private var meta		:Boolean;
		private var duree		:Number;
		
		public function TempsEcoule() {
			ecran = util.chargeVideo("_flv/BLIS.flv",384,216,8,8);
			addChild(ecran);
			
			jaugeLecture.visible = false;
			
			ecran.addEventListener(VideoEvent.PLAYHEAD_UPDATE,lectureEnCours);
			// Nombre représentant l'intervalle (en millisecondes) entre chaque événement playheadUpdate.
			ecran.playheadUpdateInterval = 10;
		}
		
		private function lectureEnCours(evt:VideoEvent) {
			positionTete = ecran.playheadTime;
			
			// test les meta données
			if (ecran.metadata != null && !meta) {
				meta = true;
				duree = ecran.metadata.duration;
				// affichage de la pompe de la pompe
				this.jaugeLecture.scaleX = positionTete/duree;
				this.jaugeLecture.visible = true;
			}
			
			if (meta){
				this.jaugeLecture.scaleX = positionTete/duree;
			}
		
			heures = Math.floor(positionTete/3600);
			minutes = Math.floor(positionTete/60)-(heures*60);
			secondes = Math.floor(positionTete%60);
		
			heures= heures<=9 ? "0"+heures : heures;
			minutes= minutes<=9 ? "0"+minutes : minutes;
			secondes= secondes<=9 ? "0"+secondes : secondes;
			messageInfo.text = heures+":"+minutes+":"+secondes;
		
		}
	}
	
}