﻿package com
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.DisplayObject;
	import flash.display.Loader;
	import flash.display.Shape;
	import flash.display.Sprite;
	import flash.display.StageAlign;
	import flash.display.StageDisplayState;
	import flash.display.StageScaleMode;
	import flash.events.Event;
	import flash.events.FullScreenEvent;
	import flash.events.KeyboardEvent;
	import flash.events.MouseEvent;
	import flash.events.NetStatusEvent;
	import flash.events.StageVideoAvailabilityEvent;
	import flash.events.StageVideoEvent;
	import flash.events.TimerEvent;
	import flash.events.VideoEvent;
	import flash.geom.Rectangle;
	import flash.media.SoundTransform;
	import flash.media.StageVideo;
	import flash.media.StageVideoAvailability;
	import flash.media.Video;
	import flash.net.NetConnection;
	import flash.net.NetStream;
	import flash.system.LoaderContext;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	import flash.text.TextFormat;
	import flash.ui.Keyboard;
	import flash.utils.Timer;
	
	// parametrage du swf recevant la Classe du Document
	[SWF(width="1280", height="720", frameRate="24", backgroundColor="#FF0000")]
	
	public class SimpleStageVideo extends Sprite
	{
		private static const FILE_NAME	:String = "backcountry_bombshells_4min_HD_H264.mp4";
		private static const INTERVAL	:Number = 500;
		private static const BORDER		:Number = 20;
		
		private var legend				:TextField = new TextField();
		private var sv					:StageVideo;
		private var nc					:NetConnection;
		private var ns					:NetStream;
		private var rc					:Rectangle;
		private var video				:Video;
		private var thumb				:Shape;
		private var interactiveThumb	:Sprite;
		private var animatedSprite		:Sprite;
		private var temporisation		:Timer;
		private var totalTime			:Number;
		
		private var videoWidth			:int;
		private var videoHeight			:int;
		private var outputBuffer		:String = new String();
		private var rect				:Rectangle = new Rectangle(0, 0, 0, BORDER);
		private var videoRect			:Rectangle = new Rectangle(0, 0, 0, 0);
		private var gotStage			:Boolean;
		private var stageVideoInUse		:Boolean;
		private var classicVideoInUse	:Boolean;
		private var accelerationType	:String;
		private var infos				:String = new String("");
		private var available			:Boolean;
		private var inited				:Boolean;
		private var played				:Boolean;
		private var container			:Sprite;
		
		
		public function SimpleStageVideo()
		{
			// s'assurer que l'apaplication est visible et le stage disponible
			addEventListener(Event.ADDED_TO_STAGE, onAddedToStage);
		}
		
		/**
		 * 
		 * @param event //// Init de programme
		 * 
		 */		
		private function onAddedToStage(event:Event):void
		{
			// réglage du scale
			stage.scaleMode 		= StageScaleMode.NO_SCALE;
			stage.align 			= StageAlign.TOP_LEFT;
			legend.autoSize 		= TextFieldAutoSize.LEFT;
			
			// Debug infos
			legend.multiline 		= true;
			legend.background 		= true;
			legend.backgroundColor 	= 0xFFFFFF;
			addChild(legend);
			
			// Barre de progression
			thumb 					= new Shape();
			// Conteneur de la barre de progression
			interactiveThumb 		= new Sprite();
			interactiveThumb.addChild(thumb);
			addChildAt(interactiveThumb,0);
			
			// surcouche animée et timer d'envoie
			animatedSprite 			= new Sprite();
			addChild(animatedSprite);
			
			temporisation = new Timer(2000);
			temporisation.addEventListener(TimerEvent.TIMER,onTime);
			temporisation.start();
			
			// Connections
			nc 						= new NetConnection();
			nc.connect(null);
			ns 						= new NetStream(nc);
			ns.addEventListener(NetStatusEvent.NET_STATUS, onNetStatus);
			ns.client 				= this;
			
			// Ecran
			video 					= new Video();
			video.smoothing = true;
			
			// Evenement video
			// StageVideoEvent.STAGE_VIDEO_STATE nous informe si StageVideo est disponible ou pas
			stage.addEventListener(StageVideoAvailabilityEvent.STAGE_VIDEO_AVAILABILITY, onStageVideoState);
			// écoute de l'événement VideoEvent.RENDER_STATE pour un redimensionement correct et connaître le mode d'accélération en cours
			video.addEventListener(VideoEvent.RENDER_STATE, videoStateChange);
			
			// Input Events
			stage.addEventListener(KeyboardEvent.KEY_DOWN, onKD);
			stage.addEventListener(Event.RESIZE,  onRedim);
			stage.addEventListener(MouseEvent.CLICK, onClick);
		}

		/**
		 * 
		 * @param event //// status de la video en cours
		 * 
		 */		
		private function onNetStatus(_e:NetStatusEvent):void
		{
			
			if ( _e.info == "NetStream.Play.StreamNotFound" )
				{
					legend.text = "Video file passed, not available!";
				}
		}
		
		/**
		 * 
		 * @param event //// le timer createur de bulle
		 * 
		 */	
		private function onTime(_e:TimerEvent = null):void
		{
			var ball	:Ball 		= new Ball();
			ball.x 					= Math.random()*(stage.stageWidth - ball.width) + ball.width/2;
			ball.y 					= - ball.height;
			ball.alpha 				= ((Math.random()*5) / 10) + .5;
			animatedSprite.addChild(ball);
		}
		
		/**
		 * 
		 * @param event //// enter frame pour pompe et bulle
		 * 
		 */		
		private function onFrame(_e:Event):void 
		{
			// pompe d'avancement
			var ratio	:Number 	= (ns.time / totalTime) * (stage.stageWidth - (BORDER << 1));
			rect.width 				= ratio;
			thumb.graphics.clear();
			thumb.graphics.beginFill(0xFFFFFF);
			thumb.graphics.drawRect(rect.x, rect.y, rect.width, rect.height);	
			
			// ball descende
			var nc		:uint 		= animatedSprite.numChildren;
			while (nc--){
				var b:Ball 			= animatedSprite.getChildAt(nc) as Ball;
				b.y 		+= 5;
				if (b.y > stage.stageHeight ) 
				{
					animatedSprite.removeChild(b);
					onTime();
				}
			}
		}
		
		/**
		 * 
		 * @param event //// clic pour avance rapide
		 * 
		 */		
		private function onClick(_e:MouseEvent):void
		{
			// avance rapide
			if ( _e.stageY >= interactiveThumb.y - BORDER && _e.stageX <= stage.stageWidth - BORDER )
			{
				var seekTime:Number = (stage.mouseX - BORDER) * ( totalTime / (stage.stageWidth - (BORDER << 1) ) );
				ns.seek( seekTime );	
			}
		}
		
		/**
		 * 
		 * @param event //// changement de décodage // fullscreen // pause
		 * 
		 */		
		private function onKD(_e:KeyboardEvent):void
		{	
		/*
		touches clavier :
		- O , bascule StageVideo On/Off
		- F , bascule Fullscreen On/Off
		- Space , Pause/Play
		*/
		
			if ( _e.keyCode == Keyboard.O )
			{
				if ( available ){
					// Bascule du StageVideo en on ou off (fallback to Video and back to StageVideo);
					toggleStageVideo(inited =! inited);
				}
			} else if ( _e.keyCode == Keyboard.F )
			{
				stage.displayState = StageDisplayState.FULL_SCREEN;
			} else if ( _e.keyCode == Keyboard.SPACE )
			{
				ns.togglePause();
			}
		}
		
		/**
		 * 
		 * @param width
		 * @param height
		 * @return      /// calcul du rectangle dans lequel s'inscrira la video
		 * 
		 */		
		private function getVideoRect(_width:uint, _height:uint):Rectangle
		{	
			var videoWidth	:uint 	= _width;
			var videoHeight	:uint 	= _height;
			var scaling		:Number = Math.min ( stage.stageWidth / videoWidth, stage.stageHeight / videoHeight );
			
			videoWidth *= scaling, videoHeight *= scaling;
			
			var posX:uint 			= stage.stageWidth - videoWidth >> 1;
			var posY:uint 			= stage.stageHeight - videoHeight >> 1;
			
			videoRect.x 			= posX;
			videoRect.y 			= posY;
			videoRect.width 		= videoWidth;
			videoRect.height 		= videoHeight;
			
			return videoRect;
		}
		
		/**
		 * ////  mise à l'echelle dans les différents cas
		 * 
		 */		
		private function onRedim (_e:Event = null):void
		{	
			if ( stageVideoInUse )
			{
				// si direct to stage
				// recupere l'espace de visualisation
				rc = getVideoRect(sv.videoWidth, sv.videoHeight);
				// espace de visualisation est associé à la propriété viewPort
				sv.viewPort = rc;
			} else 
			{
				// si lecture classique
				// recupere l'espace de visualisation
				rc = getVideoRect(video.videoWidth, video.videoHeight);
				// changement de taille de l'objet vidéo
				video.width = rc.width;
				video.height = rc.height;
				video.x = rc.x, video.y = rc.y;
			}
			
			interactiveThumb.x = BORDER, interactiveThumb.y = stage.stageHeight - (BORDER << 1);
			legend.text = infos;
		}
		
		/**
		 * 
		 * @param evt //// la video est prete à etre lu (reception des meta données)
		 * 
		 */		
		public function onMetaData ( _e:Object ):void
		{
			totalTime = _e.duration;
			stage.addEventListener(Event.ENTER_FRAME, onFrame);
		}
		
		/**
		 * 
		 * @param event  /// disponibilité du StageVideo
		 * 
		 */		
		private function onStageVideoState(_e:StageVideoAvailabilityEvent):void
		{	
			// si StageVideo est disponible ou pas, basculement du rendu video par la fct toggleStageVideo
			toggleStageVideo(available = inited = (_e.availability == StageVideoAvailability.AVAILABLE));
		}
		
		/**
		 * 
		 * @param on  /// si acces direct ou non
		 * 
		 */		
		private function toggleStageVideo(_on:Boolean):void
		{	
			infos += "StageVideo Running (Direct path) : " + _on + "\n";
			
			// Si nous choisissons le rendu StageVideo nous attachons NetStream à StageVideo
			if (_on) 
			{
				stageVideoInUse = true;
				if ( sv == null )
				{
					sv = stage.stageVideos[0];
					sv.addEventListener(StageVideoEvent.RENDER_STATE, stageVideoStateChange);
				}
				sv.attachNetStream(ns);
				if (classicVideoInUse)
				{
					// si StageVideo est utilisé, nous devons retirer de la liste d'affichage l'object Video pour eviter de recouvrir l'object StageVideo object (tjrs en arriere plan)
					stage.removeChild ( video );
					classicVideoInUse = false;
				}
			} else 
			{
				// sinon nous l'attachons à l'object Video
				if (stageVideoInUse)
				{
					stageVideoInUse 	= false;
					classicVideoInUse 	= true;
					video.attachNetStream(ns);
					stage.addChildAt(video, 0);
				}
			}
			
			if ( !played ) 
			{
				played = true;
				ns.play(FILE_NAME);
			}
		} 
		
		/**
		 * 
		 * @param event  /// quand basculement d'état de la StageVideo
		 * 
		 */		
		private function stageVideoStateChange(_e:StageVideoEvent):void
		{	
			infos += "StageVideoEvent received\n";
			infos += "Render State : " + _e.status + "\n";
			onRedim();
		}
		
		/**
		 * 
		 * @param event ///  quand basculement d'état de la Video
		 * 
		 */		
		private function videoStateChange(_e:VideoEvent):void
		{	
			infos += "VideoEvent received\n";
			infos += "Render State : " + _e.status + "\n";
			onRedim();
		}
	}
}