﻿package  com {
	
	import flash.display.MovieClip;
	import flash.display.Sprite;
	import flash.display.Shape;

	import flash.media.Sound;
	import flash.media.SoundChannel;
	import flash.media.SoundTransform;
	
	import flash.net.URLRequest;
	
	import flash.events.MouseEvent;
	import flash.events.Event;
	
	public class GestionSon extends MovieClip {
		
		private var ecoute			:Sound;
		private var piste			:SoundChannel;
		private var niveauSon		:SoundTransform = new SoundTransform(1);
		private var positionTete	:Number 		= 0;
		
		private var pompe			:Sprite;
		private var jauge			:Shape;
		private var largeurEcran	:uint			= stage.stageWidth;
		
		public function GestionSon() {
			
			ecoute 					= new Sound();
			ecoute.load(new URLRequest("medias/bubbles.mp3"));
			piste 					= ecoute.play(positionTete);
			piste.soundTransform 	= niveauSon;

			sonBt.addEventListener(MouseEvent.CLICK,lecturePauseSon);
			
			initPompe();
		}
		
		private function lecturePauseSon(e:MouseEvent):void {

			if (sonBt.currentFrame == 1) {
				this.removeEventListener(Event.ENTER_FRAME, pompeSon);
				positionTete	    = piste.position;
				piste.stop();
				sonBt.gotoAndStop(2);
			} else {
				this.addEventListener(Event.ENTER_FRAME, pompeSon);
				piste 				= ecoute.play(positionTete);
				sonBt.gotoAndStop(1);
			}
			
		}
		
		private function initPompe():void
		{
			pompe					= new Sprite();
			pompe.graphics.beginFill(0x000000,.2);
			pompe.graphics.drawRect(0,0,largeurEcran,10);
			pompe.graphics.endFill();
			pompe.y					= stage.stageHeight - 10;
			this.addChild(pompe);
			pompe.addEventListener(MouseEvent.CLICK, onClicPompe);
			this.addEventListener(Event.ENTER_FRAME, pompeSon);
		}
		private function onClicPompe(e:MouseEvent):void
		{
			positionTete = ecoute.length * (pompe.mouseX/largeurEcran);
			if (sonBt.currentFrame == 1) {
				piste.stop();
				piste = ecoute.play(positionTete);
			}else{
				pompe.removeChild(jauge);
				jauge	= null;
				majJauge(positionTete);
				/*jauge		= new Shape();
				jauge.graphics.lineStyle(10,0xFF0000,1,false,"normal","square");
				jauge.graphics.moveTo(0,0);
				jauge.graphics.lineTo(largeurEcran*(positionTete/ecoute.length),0);
				jauge.graphics.endFill();
				jauge.y		= 5;
				pompe.addChild(jauge);*/
			}
		}
		private function pompeSon(e:Event):void
		{
			if (jauge ){ pompe.removeChild(jauge); jauge	= null; }
			majJauge();
			/*jauge		= new Shape();
			jauge.graphics.lineStyle(10,0xFF0000,1,false,"normal","square");
			jauge.graphics.moveTo(0,0);
			jauge.graphics.lineTo(largeurEcran*(piste.position/ecoute.length),0);
			jauge.graphics.endFill();
			jauge.y		= 5;
			pompe.addChild(jauge);*/
			// boucle du son
			if (piste.position == ecoute.length ){
				positionTete = 0;
				piste.stop();
				piste = ecoute.play(positionTete);
			}
		}
		private function majJauge(_pt:Number = NaN):void
		{
			var _largeur:Number = _pt ? largeurEcran*(_pt/ecoute.length) :
										largeurEcran*(piste.position/ecoute.length);
			jauge		= new Shape();
			jauge.graphics.lineStyle(10,0xFF0000,1,false,"normal","square");
			jauge.graphics.moveTo(0,0);
			jauge.graphics.lineTo(_largeur,0);
			jauge.graphics.endFill();
			jauge.y		= 5;
			pompe.addChild(jauge);
		}
	}
}